---
marp: true
title: 02 March 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** This Keyword, Static Methods and Fields, Inheritance 

---

# Today's Learning Objectives
- This Keyword 
- Static Methods and Fields 
- Inheritance 

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# This Keyword

- Special Java keyword that refers to the current instance that is executing the method
- In the example below, `this` is used to distinguish name (the instance variable), and name( the method parameter)
- In this class, we will ask you to avoid using the same parameter names and instance variable names (checkstyle is your friend)
- You will mostly see this used to call constructors in constuctor overloading 

```java
public class Dog {
  private String name;
  Dog(String name) {
    this.name = name; // checkstyle WILL give you an error if you try this 
  }
}
```

---

# Practice with This Keyword (10 minutes)

1. Create a class called `Country`. Set up three instance variables inside of `Country`: `name`, `nationalBird`, and `populationSize`. Create a constructor for `Country` that uses the `this` keyword to set up all three instance variables. 

2. Create a second constructor for `Country` that takes in a `nationalBird` and `name`, but not `populationSize`. Use the `this` keyword to call the first constructor and set the value of `populationSize` to 100.  

---

# Static Methods and Static Fields 

### Static Methods 
- Use the `static` keyword to attach the method to the class, rather than the instance
- `static` class methods cannot access instance variables

### Static Fields 
- Typically used to establish constants and make code more readable 
- Commonly Used with the `final` keyword to create symbolic constants 
- `final` creates a variable that cannot be changed after it has been set 

--- 

# Static Method - Example

```java
public class Building {
  private String name;
  private int height;
  public Building(String name, int height) {
    this.name = name;
    this.height = height;
  }
  public static String getName() {
    return name;
  }
}
Building siebel = new Building("Siebel", 4);
// Will this work? why/why not?
System.out.println(siebel.getName());
```
---

# Practice with Static Methods and Fields (10 minutes)

1. Create a class named `Dog`. `Dog` should have `name` and `age` instance variables. Your `Dog` class should come with a constructor that sets the `name` and `age`. Use the `this` keyword when appropriate. 

2. Create a method called `methodA` that returns a String that says "This is the Dog class."

3. Create a method called `methodB` that returns a String that says "This dog's name is { }". The dog's name should appear where the curling braces are. 

4. Between `methodA` and `methodB`, which one can be made into a static method? Why or why not? Use the `static` keyword to make it a static method. 

---

# Inheritance 

Inheritance allows us to create relationships between classes. We can ***inherit*** the behavior of one class by ***extending*** another class. Inheritance can be useful when we have objects that share functionality. 

**extends** - keyword used to create a one way relationship between two classes; the child class **extends** the parent class 
**super** - keyword used by the child constructor to call the parent constructor; MUST be called at the start of the constructor

Private variables in the parent class can't be accessed by the child classes, but child classes can access protected variables in the parent class. 

--- 
# Inheritance 

What gets printed here? 

```java
class Base {
  public void show() {
    System.out.println("Base::show() called");
  }
}
  
class Derived extends Base { // here the child class is extending the parent class 
  public void show() {
    System.out.println("Derived::show() called");
  }
}

Base b = new Derived();
b.show();
```
---

# Inheritance 

```java
public class Animal {
  protected String name;
  protected String sound;
  public Animal(String n, String s) {
    name = n; 
    sound = s; 
  }
}

public class Cat extends Animal {
  public double cutenessLevel; 
  protected boolean hasClaws;
  public Cat(String n, String s, double c, boolean h) {
    super(n, s); // this is how we use the super keyword to call the parent class's constructor 
    cutenessLevel = c;
    hasClaws = h;
  }  
}

```
---

# Practice with Inheritance (Fish) (5 minutes)

1. Create a class called `Animal`. `Animal` has one method called `sleep()` that returns `"I am sleeping."` 

2. Create a class called `Fish`. `Fish` is a child class of `Animal`. `Fish` has one method called swim. `Fish` should print `"I am swimming."` inside of `swim()`. Use extends correctly so that a `Fish` object can sleep and swim. 

---

# Practice with Inhertiance (Computer) (10 minutes)

1. Create a class called `Computer`. The `Computer` class has two instance variables: `name` and `batteryLife`. Create a constructor for `Computer` that initilizes these two variables. 

2. Create a class called `DellComputer`. `DellComputer` should inherit the same instance variables as the `Computer` class, but it also has an instance variable called `screenSize` of integer type. Create a constructor for `DellComputer` that uses the `super` keyword and initilizes `screenSize`.

3. Create a class called AppleComputer. `AppleComputer` should inherit the same instance variables as the `Computer` class, but it also has an instance variable called `ios` of `String` type. Create a constructor for AppleComputer that uses the `super` keyword and initilizes `ios`.

4. Identify the parent class and the child class(es) in this scenario. 

---

# That's All, Folks! 

Thanks for stopping by. Leave us some feedback pls.
See y'all on Friday! 

Acknowledgements: Special thanks to course staff from Fall 2020 for providing some of the coding examples seen in this slide deck. 

---

# Solution Section

---

# Practice with This Keyword  - Solution 

```java
public class Country {
  String name; 
  String nationalBird; 
  int populationSize; 
  
  public Country(String setName, String setNationalBird, int setPopulationSize) {
    this.name = setName;
    this.nationalBird = setNationalBird; 
    this.populationSize = setPopulationSize; 
  }
  
  public Country(String setNationalBird, String setName) {
    this(setName, setNationalBird, 100);
  }
}
```
---

# Practice with Static Methods and Static Fields - Solution 

```java
public class Dog {
  private String name; 
  private int age; 
  public Dog(String setName, int setAge) {
    this.name = setName; 
    this.age = setAge; 
  }
  
  // we can make this method static because it is not dependent on the instance 
  public static String methodA() {
    return "This is the Dog class.";
  }
  public String methodB() {
    return "This dog's name is " + name; 
  }
}

Dog happy = new Dog("Happy", 10);
System.out.println(happy.methodB()); 
System.out.println(happy.methodA()); 
```

---

# Practice with Inheritance (Fish)

```java
public class Animal {
  public String sleep() {
    return "I am sleeping";
  }
}

public class Fish extends Animal {
  public String swim() {
    return "I am swimming";
  }
}
Fish nemo = new Fish(); 
System.out.println(nemo.swim());
System.out.println(nemo.sleep());
```

---

# Practice with Inheritance (Computer)

```java
// Computer is the parent class 
public class Computer {
  String name; 
  int batteryLife; 
  public Computer(String setName, int setBatteryLife) {
    this.name = setName; 
    this.batteryLife = setBatteryLife; 
  }
}

// DellComputer is a child class of Computer 
public class DellComputer extends Computer {
  int screenSize; 
  public DellComputer(int setScreenSize) {
    super("Dell Computer", 12);
    this.screenSize = setScreenSize; 
  }
}

// AppleComputer is a child class of Computer 
public class AppleComputer extends Computer {
  String ios; 
  public AppleComputer(String setIos) {
    super("Apple Computer", 12);
    this.ios = setIos;
  }
}
```