---
marp: true
title: 23 Feb 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** Objects, Constructors, Encapsulation, Java Compilation/Execution

---

# Today's Learning Objectives
- Objects
- Constructors
- Encapsulation
- Java Compilation/Execution (actually high- and low-level programming languages)

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# Object Terminology Summarized

- **Object:** A bundle of variables and functions/methods that specify the behavior of a new structure, e.g. `String name` and `int age` for a `Person` object.
- **Class:** The blueprint to define the *state and behaviors* of an object, e.g. a `Car` class.
- **Instance**: An occurance (was about to use instance) of a class.

**Altogether:** I'm going to define a `Vehicle` *object* using a *class* so that I can produce *instances* of `Vehicles` like a 2013 Toyota Camry.

Objects, and *object-oriented programming*, is a defining feature to most programming languages. It won't go away. Understanding it will help you program in other languages and represent the real world computationally.

---

# Defining an Object Practice (10 minutes)

Let's define an object, using a class, called `Enemy` for a video game. The enemy should have a `name`, `healthPoints`, `loot`, `weapon`, and other variables (be creative). Enemies should also be able to `attack`, `die` and `heal`. Feel free to add other methods.

---

# Enemy Starter Code

```java
class Enemy {
    // your variables and methods here.
}

Enemy goblin = new Enemy();

goblin.name = "Wruk";
goblin.healthPoints = 10;
goblin.weapon = "Club";
goblin.loot = "Gold Pouch";

goblin.attack();
String loot = goblin.die();

System.out.println("You killed the goblin, this is your loot: " + loot);
```

---

# Constructor, Another New Term

*Constructors* are functions that are ran when you initialize an object, i.e. when you type `new Person("Jackie")`.

Turns long initializations like our goblin from before to something shorter.

```java
// No constructor.
Enemy goblin = new Enemy();

goblin.name = "Wruk";
goblin.healthPoints = 10;
goblin.weapon = "Club";
goblin.loot = "Gold Pouch";

// With constructor. Look how elegant it is!
Enemy goblin = new Enemy("Wruk", 10, "Club", "Gold Pouch");
```

---

# Constructor for Enemies (5 minutes)

Add a *constructor* to the `Enemy` object so that it forces the user to initialize the `name`, `healthPoints`, `weapon`, and `loot`.

Overload the constructor (add a new one) so that you can just initialize the `name` of the enemy.

---

# Encapsulation, What a Fancy Word

**Laymen Explanation:** Only let the user interact with what is *necessary*.

How do you limit visibility to users? Using *access/visibility modifiers* (e.g. `private`, `public`) and getter and setter methods. For example, take an account object already defined.

```java
class Account {
  String username;
  String password; // should be "private String password;"
}

Account jackiec3 = new Account("jackiec3", "computerscienceisawesome2!");

// Without visibility modifiers, I can do. Not good.
System.out.println(jackiec3.password);
```

---

# Encapsulation Practice (10 minutes)

Take the `Playlist` object defined below. Add the visibility modifiers and define these getter and setter methods

```java
class Playlist {
  String[] playlist;
  String name;
  int numSongs;

  Playlist(String setName) {
    name = setName;
    playlist = new String[100]; // only 100 songs
  }

  // addSong(String song)
  // getPlaylist()
  // getSongByIndex(int index) gets the song at a particular index in the playlist
  // setName(String name) sets the name of the playlist

}
```

---

# That Was A Lot About Objects!

There's plenty of more things to learn about them too! But let's pause, do you have any questions? About anything.

---

# Because You Asked: Java Compilation/Execution

Geoff talked about Java's *compilation and execution* transition as well as the differences between *development and production*.

Here, I'll talk about the idea of *high-level and low-level* programming languages.

---

# High- and Low-Level Programming Languages

In computer science, there's a hierarchy for programming languages to classify how similar it is to natural language. 

*High-level languages* are similar to natural language, e.g. Wikipedia includes Java, Python (love it), JavaScript.

*Low-level languages* are closer to what the computer can actually understand, i.e. basic instructions/machine code, binary, and bytes. Low-level languages include C (argubly), machine code, assembly.

This definition changes throughout time, it's just a way for us to classify languages. Before, people would say that Fortran or COBOL were high-level languages. I don't think anyone says that now.

---

# High-Level and Low-Level Programming Language Spectrum

![Language Spectrum](../../pics/language_spectrum.png)

---

# High- and Low-Level Programming Languages Cont.

No matter the language, the code needs to be translated to machine-understandable code, i.e. machine code. High-level languages have compilers and interpreters to make that transition, where lower level languages have less work to transition to machine-understandable code.

This is just a sneak peak, you'll learn more about this in later courses if you take them.

But hopefully with this, you'll understand a little bit more when people talk about high- and low-level programming languages.

Questions? Not needed for the course, but still interesting stuff.

---


# Extra Object Practice (remaining minutes)

Let's go back to Twitter and define a `Tweet` object. Define a `Tweet` object that has private variables for `String body`, `String username`, `String date`, `int numRetweets`, `int numMentions`, `int numReplies`, and `Tweet[] replies`.

When you initialize a `Tweet`, you must pass in the `username`, `body`, and `date` and those cannot be changed once created (*use a constructor*). Define getters and setters listed: `addRetweet/Mentions()`, `addReply(Tweet reply)`, and `getBody/Username/Date/NumRetweets/NumMentions/Replies()`.

---

# Tweet Starter Code

```java
class Tweet {
  
  // variables
  private Tweet[] replies;

  // constructor
  Tweet(String setBody, String setUsername, String setDate) {
    // your code
    replies = new Tweet[100]; // only 100 replies allowed
  }

  // getters and setters
}

Tweet myTweet = new Tweet("Had a good EMP session today!", "jackiec3", "02/26/2021");

// add a bunch of retweets cause I'm popular
for (int i = 0; i < 100; i++) {
  myTweet.addRetweet();
}

myTweet.addReply(new Tweet("That's good to hear!", "ashokan2", "02/26/2021"));
```

---


# Solution Section

---

# Defining an Object Practice Solution
```java
class Enemy {
  String name;
  int healthPoints;
  String weapon;
  String loot;

  void attack() {
    System.out.println(name + " attacked with a " + weapon);
    return;
  }

  String die() {
    System.out.println(name + " died.");
    return loot;
  }

  void heal() {
    healthPoints += 10;
    return;
  }
}
```

---

# Constructor for Enemies Solution

```java
class Enemy {
  String name;
  int healthPoints;
  String weapon;
  String loot;

  Enemy(String setName, int setHealth, String setWeapon, int setLoot) {
    name = setName;
    healthPoints = setHealth;
    weapon = setWeapon;
    loot = setLoot;
  }

  Enemy(String setName) {
    name = setName;
  }
}
```

---

# Encapsulation Practice Solution

```java
class Playlist {
  private String[] playlist;
  private String name;
  private int numSongs;

  Playlist(String setName) {
    name = setName;
    playlist = new String[100]; // only 100 songs
  }

  void addSong(String song) {
    playlist[numSongs] = song;
    numSongs++;
  
    return;
  }

  String[] getPlaylist() {
    return playlist;
  }

  String getSongByIndex(int index) {
    if (index < numSongs) {
      return playlist[index];
    } else {
      return "No song at index.";
    }
  }

  void setName(String setName) {
    name = setName;
    return;
  }
}
```

---

# Tweet Object Solution

```java
class Tweet {
  
  // variables
  private Tweet[] replies;
  private String body;
  private String username;
  private String date;
  private int numRetweets;
  private int numMentions;
  private int numReplies;

  // constructor
  Tweet(String setBody, String setUsername, String setDate) {
    body = setBody;
    username = setUsername;
    date = setDate;

    replies = new Tweet[100]; // only 100 replies allowed
    numRetweets = 0;
    numMentions = 0;
    numReplies = 0;
  }

  void addReply(Tweet reply) {
    replies[numReplies] = reply;
    numReplies++;
    return;
  }

  // repeat for addMentions
  void addRetweet() {
    numRetweets++;
    return;
  }

  // repeat for username, date, numRetweets, numMentions, replies
  String getBody() {
    return body;
  }
}