---
marp: true
title: 16 Feb 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** MORE Multidimensional Arrays, MORE Strings and String Functions, and null

---

# Today's Learning Objectives

Review and practice:
- MORE Multidimensional Arrays
- MORE Strings and String Methods 
- null

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# Quick review on multidimensional arrays

Declaring and creating a multidimensional array 
``` java 
<datatype> [][] arr; // declares a two-dimensional array 
arr = new <datatype>[5][4] // creates a two dimensional of 5 x 4 int values and assigns it to arr 
```

Length of a multidimensional array 
```java
System.out.println(arr.length) //prints 5 
System.out.println(arr[0].length) //prints 4
System.out.println(arr[1].length) //prints 4
System.out.println(arr[2].length) //prints 4
System.out.println(arr[3].length) //prints 4
```

**Nested for loops are your friend.** Multidimensional arrays can get pretty messy. You will almost always need to use nest for loops to solve problems. If you get stuck, try walking through the loops by drawing out what's happening using pen and paper.

---

# Grade Test (10 minutes)

Write a function that grades a MCQ test. Suppose there are eight students and ten questions. The answers are stored in a 2d array shown below. Each row records a student's answers to the questions. We have a key to the test given below. Your function should print out each students score after grading their test. Each question is worth 1 point. 

```java
char[][] answers = {
    {'A', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'D', 'B', 'A', 'B', 'C', 'A', 'E', 'E', 'A', 'D'},
    {'E', 'D', 'D', 'A', 'C', 'B', 'E', 'E', 'A', 'D'},
    {'C', 'B', 'A', 'E', 'D', 'C', 'E', 'E', 'A', 'D'},
    {'A', 'B', 'D', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'E', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'}};

char[] keys = {'D', 'B', 'D', 'C', 'C', 'D', 'A', 'E', 'A', 'D'};
```
---

# Grade Test Starter Code (10 minutes)

```java
void gradeTest(char[][] answers, char[] keys) {
    // Your code here.
}

char[][] answers = {
    {'A', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'D', 'B', 'A', 'B', 'C', 'A', 'E', 'E', 'A', 'D'},
    {'E', 'D', 'D', 'A', 'C', 'B', 'E', 'E', 'A', 'D'},
    {'C', 'B', 'A', 'E', 'D', 'C', 'E', 'E', 'A', 'D'},
    {'A', 'B', 'D', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'E', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'}};

char[] keys = {'D', 'B', 'D', 'C', 'C', 'D', 'A', 'E', 'A', 'D'};
gradeTest(answers, keys);
```
---

# Quick review on strings and string functions  
- `String substring(int begin)` or `String substring(int begin, int end)` - begin is inclusive, end is exclusive - we use this to get a portion of a string out

- `String split(String delim)` - splits a String based on what is given, commonly we split based on `,`, `:`,`\n` (newline, note the `\`)

- `String trim()` - removes starting and ending whitespace (so if a cat types it in we can deal with it)

- `String equals(String other)` - use this to compare strings and not `==` (which sometimes fails)

- `String charAt(int index)` - use this to get the character at the specified index in a string 

- `String toCharArray()` - converts a String to a sequences of characters in an array of chars 

---

#  conCat (5 minutes)

Write a function that given two strings, appends them together (known as "concatenation") and returns the result. However, if the concatenation creates a double-char, then omit one of the chars, so "abc" and "cat" yields "abcat". Remember to handle the special case when one of the two strings are empty (`""`).

```java
String conCat(String a, String b) {
    // write your code here 
}

System.out.println(conCat("abc", "cat")) // "abcat"
System.out.println(conCat("dog", "cat")) // "dogcat"
System.out.println(conCat("abc", "")) // "abc"
```
---

# doubleChar (5 minutes)

Write a function that given a string, returns a string where for every char in the original, there are two chars. 

```java
String doubleChar(String str) {
    // write your code here 
}

System.out.println(doubleChar("The")) // "TThhee"
System.out.println(doubleChar("AAbb")) // "AAAAbbbb"
System.out.println(doubleChar("Hi-There")) // "HHii--TThheerree"
```
---

# What is `null`?

Just Java's special value for nothing. `null` is a reserved keyword in Java so we can't use it for variables. It's not an object or a type. It just exists 😊

- We sometimes use it as a placeholder for other things until it's initialized 
- `null` is case sensitive 
- ALWAYS check if a variable is `null` before we try to do something with it

---

# highestAgeIndex (10 mins)

Write a function that will take in an int array as an input and return the index of the highest value in the array. Assume all the items in the array are unique. Use the test case below to determine how to handle the null case. 

```java
int highestAgeIndex(int[] arr) {
    // write your code here
}

int[] ex1 = {23, 22, 21};
int[] ex2 = {69, 78, 56};
System.out.println(highestAgeIndex(ex1)); // returns 0
System.out.println(highestAgeIndex(ex2)); // returns 1
System.out.println(highestAgeIndex(null)); //returns -1

```

---

# That's it! We're done for today. 

Reminders: 
- [Attendence Form](https://forms.gle/EXnYCrB8zAt69GTj6)
- [Feedback](https://forms.gle/54tRoxwNM79J7nAu5)

What more practice? Check out these helpful sites: 
- [CS 125 Quiz Material](https://github.com/ranchncarrots/CS125QuizPrepSpring21)
- [Coding Bat](https://codingbat.com/java)
- [HackerRank](https://www.hackerrank.com/)
- [LeetCode](https://leetcode.com/)

See you on Friday and have a great week! 

---

# Solutions Section

---

# Grade Test Solution 
```java
void gradeTest(char[][] answers, char[] keys) {
  //loop through each student's answers 
  for (int i = 0; i < answers.length; i++) {
    int correctCount = 0; // keep track of number correct 
    for (int j = 0; j < answers[i].length; j++) {
      // if the answer matches the key, increment the number of correct answers 
      if (answers[i][j] == keys[j]) {
        correctCount++;
      }
    }
    System.out.println("Student " + i + "'s correct count is " + correctCount);
  }
}

char[][] answers = {
    {'A', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'D', 'B', 'A', 'B', 'C', 'A', 'E', 'E', 'A', 'D'},
    {'E', 'D', 'D', 'A', 'C', 'B', 'E', 'E', 'A', 'D'},
    {'C', 'B', 'A', 'E', 'D', 'C', 'E', 'E', 'A', 'D'},
    {'A', 'B', 'D', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'B', 'B', 'A', 'C', 'C', 'D', 'E', 'E', 'A', 'D'},
    {'E', 'B', 'E', 'C', 'C', 'D', 'E', 'E', 'A', 'D'}};

char[] keys = {'D', 'B', 'D', 'C', 'C', 'D', 'A', 'E', 'A', 'D'};
gradeTest(answers, keys); 
```

---

# conCat Solution
```java
String conCat(String a, String b) {
  if (a.length() == 0) {
    return b;
  }
  if (b.length() == 0) {
    return a;
  }
  if (a.charAt(a.length() - 1) == (b.charAt(0))) { 
    return a.substring(0, a.length() - 1) + b;
  } else {
    return a + b;
  }
}
```

---

# doubleChar Solution
```java
String doubleChar(String str) {
  String result = "";
  for (int i = 0; i < str.length(); i++) {
    result = result + str.charAt(i) + str.charAt(i);
  }
  return result;
}
```

---

# highestAgeIndex Solution 
```java
int highestAgeIndex(int[] arr) {
  if (arr == null) { // always check for the null case first 
    return -1;
  }
  int highestAge = -1; 
  int highestAgeIndex = -1;
  //loop through array 
  for (int i = 0; i < arr.length; i++) {
    if (arr[i] >= highestAge) { // check if highest Age yet 
      highestAge = arr[i];
      highestAgeIndex = i;
    } 
  }
  return highestAgeIndex; 
}

int[] ex1 = {23, 22, 21};
int[] ex2 = {69, 78, 56};
System.out.println(highestAgeIndex(ex1)); // returns 0
System.out.println(highestAgeIndex(ex2)); // returns 1
System.out.println(highestAgeIndex(null)); //returns -1
```