---
marp: true
title: 12 Feb 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** Multidimensional Arrays, Strings and Algorithms, and More Functions

---

# Today's Learning Objectives

Review and practice:
- Multidimensional Arrays
- Strings and Algorithms
- More Functions (covered throughout)

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# "Why multidimensional arrays? They're annoying..."

**Answer:** Because not all data can be represented, intuitively, by a one-dimensional array! Consider images `int[64][64][3]` (64-by-64 image with three color channels), chessboards `char[8][8]` (eight-by-eight board where a `char` represents a piece), or Rubrik's Cubes `char[6][3][3]` (six three-by-three faces where a `char` is associated with a color).

**Multidimensional data is everywhere.** And if you're interested in machine learning/artificial intelligence, you'll see it there too!

---

# "How do they work?"

Each bracket `[]` you add onto the datatype will add another dimension to the array. For example, `int[][] matrix` as two dimensions.

**Reminders!**
- Multidimensional arrays don't have to be squares, cubes, or hypercubes.
- `array.length`, **not** `array.length()`, is your best friend to avoid index errors.
- Arrays indices start at zero! I mean zero, not zero factorial which is one.

---

# Practice with Multidimensional Arrays (10 minutes)
Write a function that takes in a two-dimensional `int` array that represents multiple sequences of integers and a target value. You should  traverse the array to return whether the sum of those sequences is ever equal to the target value. If the sum of the sequence is equal to the target value, return `true`, otherwise return `false`.

```java
boolean calculateSums(int[][] sums, int targetValue) {
    // Your code here.
}
```

**Tips:** `arr.length` will be your friend. You need to loop through each summation (the first dimension) and calculate the total by looping through the components of the summation.

---

# Test Case for Practice with Multidimensional Arrays

```java
boolean calculateSums(int[][] sums, int targetValue) {
    // Your code here.
}

int[][] arr = {{34, 23, 53}, {52, 42, 16, -1}};

System.out.println(calculateSums(arr, 109)); // Should print false.
System.out.println(calculateSums(arr, 110)); // Should print true.
System.out.println(calculateSums(arr, 101)); // Should print false.
```

---

# MD Arrays Cont.: Phone Numbers (10 minutes)

Write a function called `phoneLookUp` that takes `int[][] phoneNumbers` (where the first-dimension is a certain phone number and the second-dimension are the numbers in that phone number) and `int[] targetNumber` is a phone number you want to find within the two-dimensional array. Return `true` if `targetNumber` is in `phoneNumbers`, return `false` otherwise.

Note that the second-dimension of phoneNumbers will always have `10` indices as well as `targetNumber`. Standard American phone number looks like `(432) 234 - 1434` without symbols. Not my phone number by the way.

---

# Test Case for Phone Numbers Practice
```java
boolean phoneLookUp(int[][] phoneNumbers, int[] targetNumber) {
    // Your code here.
}

int[][] phoneNumbers = new int[2][10];
phoneNumbers[0] = new int[]{4, 5, 3, 5, 4, 3, 4, 6, 7, 8};
phoneNumbers[1] = new int[]{7, 5, 6, 3, 4, 6, 2, 6, 8, 3};

int[] firstTarget = {4, 5, 3, 5, 4, 3, 4, 6, 7, 8};
int[] secondTarget = {5, 3, 5, 3, 2, 8, 6, 3, 6, 7};

System.out.println(phoneLookUp(phoneNumbers, firstTarget)); // Prints true.
System.out.println(phoneLookUp(phoneNumbers, secondTarget)); // Prints false.
```

---

# Strings and Algorithms Preface

Strings are objects, and strings are *immutable*. That means, once a string is created, it can never be changed. It may look like it changes, but Java just destroys it and makes a new one.

```java
String test = "Jackie";
test += " Chan";
// Java creates "Jackie Chan", but the string "Jackie" is gone forever :(
```

Because strings are *objects*, they come with certain methods, e.g. `.toCharArray()`, `.charAt()`, and `.split()`. Knowing these will make your life easier when working with strings.

---

# Practice with Strings and Algorithms (10 minutes)

Write a function called `foundName` that takes a two strings, `String sentence` and `String name`, and returns `true` if `name` is contained in the sentence, otherwise `false`. We're going to pretend puncuation doesn't exist. **Hint:** You'll need `.split()`  to split the sentence into words and `.equals()` for checking equality.

```java
boolean foundName(String sentence, String name) {
    // Your code here.
}

// Should print true.
System.out.println(foundName("Jackie likes sleeping in", "Jackie"));

// Should print false.
System.out.println(foundName("Hey Harsh nice to see you", "Lou"));
```

---

# Strings and Algorithms Cont. (10 minutes)
Write a function called `secretCode` that takes `String[] codeWords` and returns a `String` of all the first letters in `codeWords`. You'll need `.charAt()` for this problem.

```java
String secretCode(String[] codeWords) {
    // Your code here.
}

String[] codeWords = {"Got", "edible", "otters", "from", "friends"};

// Prints "Geoff".
System.out.println(secretCode(codeWords));
```

---

# WOW THAT WAS A LOT, but we reached the end.

Just attending these sessions (or watching the videos) gets you ahead of the game. I'm glad you're here and working through these.

Have an awesome weekend, you're doing great. Be proud of yourself. Do something fun this weekend.

---

# Solutions Section

---

# Practice with Multidimensional Arrays Solution
```java
boolean calculateSums(int[][] sums, int targetValue) {
    
    // Have a variable to store the calculated summation.
    int total = 0;
    
    for (int i = 0; i < sums.length; i++) { // loop through summations

        for (int j = 0; j < sums[i].length; j++) { // loop through components
            total += sums[i][j];
        }

        // Check if the calculated total is equal to the target.
        if (total == targetValue) {
            return true;
        }
    }

    // We didn't find any matches to target value.
    return false;
}
```

---

# MD Arrays Cont.: Phone Numbers Solution
```java
boolean phoneLookUp(int[][] phoneNumbers, int[] targetNumber) {

    boolean samePhoneNumber = true;

    for (int i = 0; i < phoneNumbers.length; i++) { // loop through each phone numbers
        for (int j = 0; j < phoneNumbers[i].length; j++) { // loop through numbers
            if (phoneNumbers[i][j] != targetNumber[j]) {
                samePhoneNumber = false;
            }
        }

        if (samePhoneNumber) {
            return true;
        }
    }

    return false;
}
```

---

# Practice with Strings and Algorithms Solution
```java
boolean foundName(String sentence, String name) {

    // Split the sentence into individual words by spaces.
    String[] words = sentence.split(" ");

    for (String word : words) {
        if (word.equals(name)) { // Check equality.
            return true;
        }
    }

    return false;
}
```

---

# Strings and Algorithms Cont. Solution
```java
String secretCode(String[] codeWords) {
    String finalCode = "";

    for (String codeWord : codeWords) { // loop through the code words
        codeWord += codeWord.charAt(0); // get the first character
    }

    return finalCode;
}
```