---
marp: true
title: 09 Feb 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** Function Overloading, Void Return, Strings

---

# Today's Learning Objectives

Review and practice:
- Function Overloading
- Void Returns 
- Strings

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# How to follow along 

- Small breakout rooms of working together

- Work for 10-15 minutes together, feel free to use paper, whiteboards, online share tools.

- Use the Jeed playground on the 125 homepage for the interactive running

---

# Function Overloading

Function overloading is when you make *different functions* with the *same name*.

- This is to deal with different types of and number of inputs

- Different data types may be processed differently

```java
int area(int l, int h) {
  return l * h;
}

float add(float l, float h) {
  return l * h
}
```
---

# Function Overloading

We distinguish functions via their signatures for overloading.

- Signature = name + inputs(names, type, order)

- `area(int, int)`, `area(float, float)`

- Note that having the return type different doesn't change the signatures. `float area(int l, int h)` and `int area(int l, int h)` are the same function as far as overloading is concerned.

- Having the same type, order, and number but different name does not work either. `area(int a, int b)` and `area(int l, int h)` are the same function as far as overloading is concerned.

---

# Function Overloading - Practice 

Write two overloaded functions `area` to calculate the area of a circle and triangle

- `double area(double radius)` - $\pi r^2$. Feel free to use $\pi = 3.14159$

- `double area(double base, double height)` - $\frac{1}{2}bh$

---

# Function Overloading - Starter code (5 mins)

```java
double area(double radius) {
  return 0.0; // implement
}

double area(double base, double height) {
  return 0.0; // implement
}
```

---

# Void Returns 

Void returns happen only when a fucntions **DOESN'T** return a value. This changes the declaration of the function to a void return type. 
```java
void <functionName>(<data type> <argumentName>) {
    <code>;
}

void sayMyName(String myName) {
  System.out.println("Hi there, " + myName);
}

sayMyName("Jarvis"); // this works
System.out.println(sayMyName("Jarvis")); // will this work? why or why not?
String myName = sayMyName("Jarvis"); // why does this fail? 
```
Can you think of a function where you would use the void return type? 

---

# Void Returns - Practice (5 mins)

Create a function that will print out statements based on two parameters passed into the function: `likeEMP` and `likeCoding`. If you like both, it should print out `"Yay, we're so glad you like this class."` If you liked one or the other, print out `"Aww, which one didn't you like?"` If you liked neither, print out `"Dang, what can we do better?"` (Hint: you should be using a `void` return type)

---

# Void Returns - Practice (5 mins)

Can you have a return statement in a function that has a return type of `void`? In other words, does the function below work?
```java
void isNumTwo(int num) {
  if (num == 2) {
    System.out.println("Yes, this number is two.");
  }
  return;

  // What happens if I write a print statement here?
}
```
---

# Strings

- Strings are the Java data type for working with text/a sequence of characters.

- This is our first example of an *object* data type in Java. Java objects combine together **state** and **behavior**.

- Strings are different from `char`s because they are enclosed in double quotes ("")

```java
String welcome = "Welcome to the world of Strings! "; 
String soMuch = "There is so much we can do with Strings. ";
String emojiis = "We can even use emojiis now! 🙌";
System.out.println(welcome + soMuch + emojiis);
```
---

# More fun with Strings

- Concatenation
```java
String question = "Can you call, ";
String name = "Ms.Potts?";
System.out.println(question + name);
```

- Dot notation 
```java
String full = "Can you call, Ms.Potts?";
System.out.println(full.length()); 
// how this this different from the way we find the length of an array?
```

- The `new` operator - where have we seen this before? 
```java
String opinion = "My favorite Marvel super hero is Iron Man.";
String opinionTwo = new String("My favorite Marvel super hero is Captain America.");
```
---

# Even more fun with Strings 

- The split method 
```java
String opinion = "My favorite Marvel super hero is Iron Man.";
String[] arr = opinion.split(" ");
System.out.println(arr[2]); // What does this print out?
```

- The substring method 
```java
String opinionTwo = new String("My favorite Marvel super hero is Captain America.");
String sub = opinionTwo.substring(33);
// Substring can also take two arguments: beginIndex and endIndex.
// A real example of function overloading!
System.out.println(sub);
```

---

# Strings - Practice (5 mins)

Create a function called combineStrings that will output a new String in the form short+long+short where short is the shorter of the two strings and long is the longer of the two strings. The two strings will not be of the same length. 

```java
String combineStrings(String a, String b) {
  // write your code here 
}
```

For example `String a = "Dog"` and `String b = "Fish"` should *return* `"DogFishDog"`.

---

# Strings - Practice (5 mins)

Given a string, return a string length 1 from its front, unless front is false, in which case return a string length 1 from its back. The string will be non-empty.

theEnd("Hello", true) → "H"
theEnd("Hello", false) → "o"
theEnd("oh", true) → "o"

```java
String theEnd(String str, boolean front) {
    // write your code here 
}

```
---

# Final Questions? You're Doing Awesome.

```java
boolean empStudent = true;

if (empStudent) {
    System.out.println("You're awesome, and you'll do awesome in the course!");
}
```

**Give us feedback!**
What did you guys think? Are the questions too hard? Too easy? Let us know in the feedback form available on the course site. 
https://cs199emp.netlify.app/

---

# Solutions Section (Spoiler Alert!)

---

# Function Overloading - Practice 

```java
double area(double radius) {
  return 3.14159 * radius * radius;
}

double area(double base, double height) {
  return base * height / 2.0;
}
```

---

# Void Returns - Practice 

```java
void likeEmpAndCoding(boolean likeEMP, boolean likeCoding) {
  if (likeEMP && likeCoding) {
    System.out.println("Yay, we're so glad you like this class");
  } else if (likeEMP || likeCoding) {
    System.out.println("Aww, which one didn't you like?");
  } else { 
    System.out.println("Dang, what can we do better?");
  }
}

likeEmpAndCoding(true, true); // try calling this method with different inputs 
```

---

# Void Returns - Practice 

Can you have a return statement in a function that returns `void`? Yes, void functions can still return so this code will run fine. The return will just exit the function, but it will not actually return anything.
```java
void isNumTwo(int num) {
  if (num == 2) {
    System.out.println("Yes, this number is two.");
  }
  return;
}
```
---

# Strings - Practice 

```java
public String comboString(String a, String b) {
  if (a.length() > b.length()) {
    return b + a + b;
  } else {
    return a + b + a;
  }
}
```
---

# Strings - Practice 

```java
public String theEnd(String str, boolean front) {
  if (front) {
    // Get the first letter.
    return str.substring(0, 1);
  } else {
    // Get the last letter.
    return str.substring(str.length() - 1, str.length());
  }
}

```