---
marp: true
title: 05 Feb 2021
theme: default
paginate: true
---
# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** Algorithms, Functions, Loops, and Error Messages

---

# Today's Learning Objectives

Review *briefly* and practice (might not get to it all):
- Algorithms
- Functions
- While Loop
- Error Messages

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---

# "What the heck are algorithms anyways?"

Algorithms sound somewhat spooky, mysterious, and complicated, but honestly they are just *recipes to solve a problem*, e.g. sort a list, find the shortest path through a maze, reverse my name.

**Algorithms are NOT code!**

Algorithms are *language agnostic* descriptions of problem solving steps, i.e. English description to solve a problem.

**Why are they important?** Well, programmers are lazy and they don't need to solve the same problem over and over again when it's already solved. Instead, programmers use already specified algorithms and convert them into code.

---

# Practice With Algorithms (5 minutes)

**Task:** You are given a list of prices associated with items, calculate the sum price of all the items on the list and apply a sales tax on it of 4%.

Describe an *algorithm* that tells me the total price.

Remember NO code. Write some steps you would give a little kid with a calculator to solve this problem. The more specific, the better, remember you're giving these to a kid.

---

# Practice With Algorithms Cont. (5 minutes)

**Task:** Given two same length arrays of numbers, `array1` and `array2`, print `"Found one!"` if the two numbers at the same index are the same.

For example, `arrayOne = {1, 2, 3}` and `arrayTwo = {3, 2, 1}`, the algorithm should only print `"Found one!"` when it hits index `2`.

Describe the algorithm (which means NO CODE) that solves this problem.

---

# "Conjunction Junction, What's Your Function?": What are functions?

Functions are pretty awesome. They let us *reuse code* when we have to do something over and over again. In general, functions take in input (called parameters or arguments) and *return* some output.

Functions have three parts: the name, the return type (i.e. the output type), and the arguments/parameters (i.e. the inputs). **Identify those three below.**

```java
boolean foo(int[] a) {
    for (int i = 0; i < a.length; i++) {
        if (a[i] < 0) {
            return true;
        }
    }
    return false;
} // Bonus: What does this function do? What's a better name for it?
```
---

# Practice With Functions (10 minutes)

1. Remember describing an algorithm to calculate a grocery store total? Fill out the blanks below to make that algorithm a reality.
```java
<blank> calculateTotal(double[] prices) {

    <your code>;

    return <blank>;
}
```

2. Implement a function that finds matches in two equal sized arrays of `int` and return the number of matches.


---

# For and While Loops: "What's the difference?"

The difference between for and while loops. For loops look like this:
```java
for (<initialization>; <condition>; <update>) {
    <code>;
}
```

While loops on the other hand look like this:
```java
while (<condition>) {
    <code>;
}
```

When do you think you should use for loops vs. while loops? Not everyone agrees.

---

# Practice With While Loops (5 minutes)

Convert this into a while loop that does the same thing.

```java
for (int i = 4096; i > 0; i = i / 2) {
    System.out.println(i);
}
```

Do you think the while loop is better here? Or a for loop?

---

# "Computers are so frustrating!": Dealing With Errors

*Agreed*, but that's somewhat the curse of being a computer scientist. High highs, low lows.

There are three types of errors: `checkstyle` errors, compiler/syntax errors, and testing errors.

- `checkstyle` errors: You wrote some code that was not up to our beauty standards.
- Compiler/syntax errors: You wrote something that Java does not understand.
- Testing errors: Your code didn't accomplish its task.

---

# Practice With Errors (5 minutes)

Identify the errors below.
```java
double price = 10.75;
boolean hasCoupon = true;

if (hasCoupon) {
    double price = price * 0.95;
}
```
```java
for(int i=0; i<10; i++) {
    System.out.println(i);
}
```

---

# Final Questions? You're Doing Awesome.

```java
boolean empStudent = true;

if (empStudent) {
    System.out.println("You're awesome, and you'll do awesome in the course!");
}
```

Attendance and feedback links are found on the course site.
https://cs199emp.netlify.app/

**Give us feedback!** Tell us where we can improve and help *you*.

Have a good weekend!

---

# Solutions Section

---

# Practice With Algorithms (Solution)

```java
(1) have a variable called total set to zero

(2) go through the list of prices one at a time:
    (2.1) add price p to total

(3) multiply 1.04 to the total and make that the new total

(4) read the total out
```

---

# Practice With Algorithms Cont. (Solution)

```java
(1) loop through 0 to the length of the list - 1 (because index by 0)
    (1.1) set a to the value stored in list1 at our index
    (1.2) set b to the value stored in list2 at our index
    (1.3) check if a and b are the same thing:
        (1.3.1) if true, then print "Found one!"
```

---

# Practice With Functions (Solution)

```java
double calculateTotal(double[] prices) {

    double total = 0;

    for (int i = 0; i < prices.length; i++) {
        total += prices[i];
    }

    return total * 1.04;
}
```

---

# Practice With Functions (Solution Cont.)
```java
int countMatches(int[] firstArr, int[] secondArr) {

    int matches = 0;

    // Remember the arrays are the same length.
    for (int i = 0; i < firstArr.length; i++) {
        if (firstArr[i] == secondArr[i]) {
            matches++;
        }
    }

    return matches;
}
```

---

# Practice With While Loops (Solution)

```java
int i = 4096;

while (i > 0) {
    System.out.println(i);

    i = i / 2; // or i /= 2;
}
```

---

# Practice With Errors (Solution)

```java
double price = 10.75;
boolean hasCoupon = true;

if (hasCoupon) {
    // double price = price * 0.95; // Syntax error.
    price = price * 0.95;
}
```
```java
for(int i = 0; i < 10; i++) { // checkstyle error, should have spaces.
    System.out.println(i);
}
```