---
marp: true
title: 02 Feb 2021
theme: default
paginate: true
---

# <!-- fit --> CS 199 EMP

### Hosted by Jackie Chan and Akhila Ashokan

**Topics:** Compound Conditional Statements, Arrays, and For Loops

---

# Course Details

Every Tuesday and Friday, there are two sessions that cover the same topic.

- Session 1 @ 6AM on Tuesdays and Fridays w/ Akhila.
- Session 2 @ 2PM on Tuesdays and 4PM on Fridays w/ Jackie.

---

# Goals of the Course

- Provide extra help and assistance to be successful in the course through practice problems.
- Provide a safe environment to work on problems with others. Coding can be a very solitary activity, but not here.

---
# Today's Learning Objectives

Review briefly and practice:
- Compound Conditional Statements
- Arrays
- For Loops

Write code on the homepage or any playground on the site!
https://cs125.cs.illinois.edu/

Slides are on the course site!
https://cs199emp.netlify.app/

---
# Compound Conditional Statements 
Compound conditional statements allow us to take conditional expressions using conditional operators (>, <, ==, etc.) a step further to combine them and create complex decision-making logic. 

In this example, what is the conditional expression and what is the conditional statement? What will this code output?  
```java
int myHeight = 149;
int yourHeight = 182;
if (myHeight < yourHeight) {
    System.out.println("I am shorter than you!");
} else if (myHeight > yourHeight) {
    System.out.println("I am taller than you!");
} else {
    System.out.println("I am the same height as you!");
}
```
Questions before practice?

---

# Practice with compound conditional statements (10 minutes)

1. Write a conditional statement that compares two integer variables (x and y) and prints out whether they are equal to each other, greater than each other, or less than each other. Now, test our your code by initializing the integers to be equal to 1 and 3. 
2. Assume you have only three letter grades (A, B, and C) and one test score. You get an A if your test score is 90 or above. You get a B if your test score is greater than or equal to 80 but less than 90. You get a C if your test score is anything below an 80. Write a code that will print your letter grade based on your test score. Test out your code and see what happens if your test score is 75.
---

# So... what are arrays?

Arrays are one way to store sequential data in Java. Let's review the syntax of arrays. 
```java
<datatype>[] <varName> = new <datatype>[<length>]; 
int[] values = new int[8];

char[] varName = {'x', 'y', 'z', 'f'}; // what's different about this example? 
```

Now, let's take a look at indexing arrays.
```java
int[] heights = new int[20];
heights[0] = 149; // why did we start with 0? 
heights[20] = 160; // what's wrong with this piece of code? 
System.out.println(heights[0]); //what do you think this will print? 
```

Questions before practice?

---

# Practice with arrays! (10 minutes)

1. Initialize a boolean array with 7 values. 
2. Set the last value in the array to true. 
3. Print out the first value in the array. 
4. Initialize a char array with 4 elements.
5. Set the 4 elements to be the the first 4 letters of the alphabet. 
6. See if you can do 4 and 5 in one line if you haven't already. 

Bonus Question: Will this print the values in the heights array?
```java
int[] heights = new int[20];
System.out.println(heights);
```
---



# What are for loops?

We learn about two different types of loops this week: for loops and while loops. For loops are one of the most common loops because they allow you to run blocks of code based on some conditional expression.

```java
for (<initialization>; <condition>; <update>) {
   <body>
}
// when will this for loop stop? what is the counter for this loop?
for (int age = 0; age < 15; age++) {
  System.out.println("I am " + age + " years old.");
}
```
---

# Practice with for loops! (10 minutes)

1. Create a for loop that prints out your age from when you were 1 to your current age at every iteration. 
2. Create a for loop that prints the consecutive integers from 50 to 0 backwards. So the first iteration should print 50 and the last should print 0.
3. Write a for loop that begins at your current age and decrements by 2 at every iteration until 0. Within the loop, write a conditional statement to check if the counter for the loop is equal to 2. When the counter for your age is your 2, print out "Hurray!" 

---

# Final, final questions about today's content? Anything!

```java
if (!questions) {
    System.out.println("Have an awesome day!");
    System.out.println("Be sure to mark attendance if that matters, " +
        "leave some feedback!");
}
```

Attendance and feedback links are found on the course site.
https://cs199emp.netlify.app/

---

# Solutions Section

---
# Practice with compount conditional statements! (Solution)
```java
int x = 1; // Question 1
int y = 3;
if (x == y) {
  System.out.println("Equal to each other");
} else if (x > y) {
  System.out.println("X is greater than Y.");
} else if (x < y) {
  System.out.println("X is less than Y.");
}
```
```java
int testScore = 75; //Question 2
if (testScore >= 90) {
  System.out.println("A");
} else if (testScore >= 80) {
  System.out.println("B");
} else {
  System.out.println("C");
}
```
---

# Practice with arrays! (Solution)

```java
boolean[] example = new boolean[7];
example[6] = true; 
System.out.println(example[0]);
char[] array = new char[4];
array[0] = 'a';
array[1] = 'b';
array[2] = 'c';
array[3] = 'd';
char[] array = {'a', 'b', 'c', 'd'};
```
---

# Practice with for loops! (Solution)

```java
for (int myAge = 1; myAge <= 23; myAge++) {
  System.out.println(myAge);
}
for (int z = 50; z >= 0; z--) {
  System.out.println(z);
}
for (int myAge = 24; myAge > 0; myAge -= 2) {
  if (myAge == 2) {
    System.out.println("Hurray!");
  } 
}

```
