/* Generated by restful-react */

import React from 'react'
import { Get, GetProps, useGet, UseGetProps, Mutate, MutateProps, useMutate, UseMutateProps } from 'restful-react'

import { getConfig } from '../config'
export const SPEC_VERSION = '0.0.0'
export type EnumGitspaceAccessType = 'jwt_token' | 'user_credentials' | 'ssh_key'

export type EnumGitspaceActionType = 'start' | 'stop'

export type EnumGitspaceCodeRepoType = 'github' | 'gitlab' | 'harness_code' | 'bitbucket' | 'unknown' | 'gitness'

export type EnumGitspaceEntityType = 'gitspace_config' | 'gitspace_instance'

export type EnumGitspaceEventType =
  | 'gitspace_action_start'
  | 'gitspace_action_start_completed'
  | 'gitspace_action_start_failed'
  | 'gitspace_action_stop'
  | 'gitspace_action_stop_completed'
  | 'gitspace_action_stop_failed'
  | 'fetch_devcontainer_start'
  | 'fetch_devcontainer_completed'
  | 'fetch_devcontainer_failed'
  | 'infra_provisioning_start'
  | 'infra_provisioning_completed'
  | 'infra_provisioning_failed'
  | 'infra_stop_start'
  | 'infra_stop_completed'
  | 'infra_stop_failed'
  | 'infra_deprovisioning_start'
  | 'infra_deprovisioning_completed'
  | 'infra_deprovisioning_failed'
  | 'agent_connect_start'
  | 'agent_connect_completed'
  | 'agent_connect_failed'
  | 'agent_gitspace_creation_start'
  | 'agent_gitspace_creation_completed'
  | 'agent_gitspace_creation_failed'
  | 'agent_gitspace_stop_start'
  | 'agent_gitspace_stop_completed'
  | 'agent_gitspace_stop_failed'
  | 'agent_gitspace_deletion_start'
  | 'agent_gitspace_deletion_completed'
  | 'agent_gitspace_deletion_failed'
  | 'agent_gitspace_state_report_running'
  | 'agent_gitspace_state_report_error'
  | 'agent_gitspace_state_report_stopped'
  | 'agent_gitspace_state_report_unknown'
  | 'gitspace_action_auto_stop'

export type EnumGitspaceFilterState = 'error' | 'running' | 'stopped'

export type EnumGitspaceInstanceStateType =
  | 'running'
  | 'uninitialized'
  | 'unknown'
  | 'error'
  | 'deleted'
  | 'starting'
  | 'stopping'

export type EnumGitspaceOwner = 'all' | 'self'

export type EnumGitspaceSort = 'created' | 'last_activated' | 'last_used'

export type EnumGitspaceStateType = 'running' | 'stopped' | 'error' | 'uninitialized' | 'starting' | 'stopping'

export type EnumIDEType = 'vs_code' | 'vs_code_web' | 'intellij'

export type EnumInfraProviderType = 'docker' | 'harness_gcp' | 'harness_cloud' | 'hybrid_vm_gcp'

export interface InfraproviderResourceInput {
  cpu?: string | null
  disk?: string | null
  gateway_host?: string | null
  gateway_port?: string | null
  identifier?: string
  infra_provider_type?: EnumInfraProviderType
  memory?: string | null
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  network?: string | null
  region?: string[] | null
}

export interface OpenapiCreateGitspaceRequest {
  branch?: string
  code_repo_ref?: string | null
  code_repo_type?: EnumGitspaceCodeRepoType
  code_repo_url?: string
  devcontainer_path?: string | null
  ide?: EnumIDEType
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resource_identifier?: string
  resource_space_ref?: string
  space_ref?: string
  ssh_token_identifier?: string
}

export interface OpenapiCreateInfraProviderConfigRequest {
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resources?: InfraproviderResourceInput[] | null
  space_ref?: string
  type?: EnumInfraProviderType
}

export interface OpenapiCreateInfraProviderTemplateRequest {
  data?: string
  description?: string
  identifier?: string
}

export type OpenapiGetGitspaceLogsResponse = string | null

export interface OpenapiGetTokenResponse {
  gitspace_token?: string
}

export interface OpenapiGitspaceActionRequest {
  action?: EnumGitspaceActionType
}

export interface OpenapiLookupRepoGitspaceRequest {
  repo_type?: EnumGitspaceCodeRepoType
  space_ref?: string
  url?: string
}

export interface OpenapiUpdateGitspaceRequest {
  branch?: string
  devcontainer_path?: string
  id?: string
  ide?: EnumIDEType
  infra_provider_resource_id?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
}

export interface ScmCodeRepositoryResponse {
  branch?: string
  is_private?: boolean
  url?: string
}

export interface TypesBranchResponse {
  name?: string
}

export interface TypesGitspaceConfig {
  branch?: string
  branch_url?: string
  code_repo_is_private?: boolean
  code_repo_ref?: string | null
  code_repo_type?: EnumGitspaceCodeRepoType
  code_repo_url?: string
  created?: number
  devcontainer_path?: string | null
  ide?: EnumIDEType
  identifier?: string
  instance?: TypesGitspaceInstance
  name?: string
  resource?: TypesInfraProviderResource
  space_path?: string
  ssh_token_identifier?: string
  state?: EnumGitspaceStateType
  updated?: number
  user_display_name?: string
  user_email?: string
  user_id?: string
}

export interface TypesGitspaceEventResponse {
  created?: number
  entity_type?: EnumGitspaceEntityType
  entity_uid?: string
  event?: EnumGitspaceEventType
  event_time?: string
  message?: string
  timestamp?: number
}

export type TypesGitspaceInstance = {
  access_key?: string | null
  access_key_ref?: string | null
  access_type?: EnumGitspaceAccessType
  active_time_ended?: number | null
  active_time_started?: number | null
  created?: number
  error_message?: string | null
  has_git_changes?: boolean | null
  identifier?: string
  last_heartbeat?: number | null
  last_used?: number | null
  machine_user?: string | null
  resource_usage?: string | null
  space_path?: string
  state?: EnumGitspaceInstanceStateType
  total_time_used?: number
  updated?: number
  url?: string | null
} | null

export interface TypesInfraProviderConfig {
  created?: number
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resources?: TypesInfraProviderResource[] | null
  space_path?: string
  type?: EnumInfraProviderType
  updated?: number
}

export interface TypesInfraProviderResource {
  config_identifier?: string
  cpu?: string | null
  created?: number
  disk?: string | null
  identifier?: string
  infra_provider_type?: EnumInfraProviderType
  memory?: string | null
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  network?: string | null
  region?: string
  space_path?: string
  updated?: number
}

export interface TypesInfraProviderTemplate {
  config_identifier?: string
  created?: number
  data?: string
  description?: string
  identifier?: string
  space_id?: number
  space_path?: string
  updated?: number
}

export interface TypesListBranchesResponse {
  branches?: TypesBranchResponse[] | null
}

export interface TypesListRepoResponse {
  repositories?: TypesRepoResponse[] | null
}

export interface TypesRepoResponse {
  clone_url?: string
  default_branch?: string
  name?: string
}

export interface TypesUsage {
  total_mins?: number
  used_mins?: number
}

export interface UsererrorError {
  message?: string
  values?: { [key: string]: any }
}

export interface ListGitspacesForAccountPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
}

export type ListGitspacesForAccountProps = Omit<
  GetProps<TypesGitspaceConfig[], unknown, void, ListGitspacesForAccountPathParams>,
  'path'
> &
  ListGitspacesForAccountPathParams

/**
 * List gitspaces for account
 */
export const ListGitspacesForAccount = ({ accountIdentifier, ...props }: ListGitspacesForAccountProps) => (
  <Get<TypesGitspaceConfig[], unknown, void, ListGitspacesForAccountPathParams>
    path={`/accounts/${accountIdentifier}/gitspaces`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseListGitspacesForAccountProps = Omit<
  UseGetProps<TypesGitspaceConfig[], unknown, void, ListGitspacesForAccountPathParams>,
  'path'
> &
  ListGitspacesForAccountPathParams

/**
 * List gitspaces for account
 */
export const useListGitspacesForAccount = ({ accountIdentifier, ...props }: UseListGitspacesForAccountProps) =>
  useGet<TypesGitspaceConfig[], unknown, void, ListGitspacesForAccountPathParams>(
    (paramsInPath: ListGitspacesForAccountPathParams) => `/accounts/${paramsInPath.accountIdentifier}/gitspaces`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier }, ...props }
  )

export interface GetUsageForAccountPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
}

export type GetUsageForAccountProps = Omit<GetProps<TypesUsage, unknown, void, GetUsageForAccountPathParams>, 'path'> &
  GetUsageForAccountPathParams

/**
 * Get usage for account
 */
export const GetUsageForAccount = ({ accountIdentifier, ...props }: GetUsageForAccountProps) => (
  <Get<TypesUsage, unknown, void, GetUsageForAccountPathParams>
    path={`/accounts/${accountIdentifier}/gitspaces/usage`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGetUsageForAccountProps = Omit<
  UseGetProps<TypesUsage, unknown, void, GetUsageForAccountPathParams>,
  'path'
> &
  GetUsageForAccountPathParams

/**
 * Get usage for account
 */
export const useGetUsageForAccount = ({ accountIdentifier, ...props }: UseGetUsageForAccountProps) =>
  useGet<TypesUsage, unknown, void, GetUsageForAccountPathParams>(
    (paramsInPath: GetUsageForAccountPathParams) => `/accounts/${paramsInPath.accountIdentifier}/gitspaces/usage`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier }, ...props }
  )

export interface ListGitspacesQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * The substring which is used to filter the gitspaces by their name or idenitifer.
   */
  query?: string
  gitspace_owner?: EnumGitspaceOwner
  gitspace_states?: EnumGitspaceFilterState[]
  sort?: EnumGitspaceSort
  order?: 'asc' | 'desc'
}

export interface ListGitspacesPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type ListGitspacesProps = Omit<
  GetProps<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, ListGitspacesPathParams>,
  'path'
> &
  ListGitspacesPathParams

/**
 * List gitspaces
 */
export const ListGitspaces = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: ListGitspacesProps) => (
  <Get<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, ListGitspacesPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseListGitspacesProps = Omit<
  UseGetProps<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, ListGitspacesPathParams>,
  'path'
> &
  ListGitspacesPathParams

/**
 * List gitspaces
 */
export const useListGitspaces = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseListGitspacesProps) =>
  useGet<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, ListGitspacesPathParams>(
    (paramsInPath: ListGitspacesPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface CreateGitspacePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type CreateGitspaceProps = Omit<
  MutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiCreateGitspaceRequest, CreateGitspacePathParams>,
  'path' | 'verb'
> &
  CreateGitspacePathParams

/**
 * Create gitspace config
 */
export const CreateGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: CreateGitspaceProps) => (
  <Mutate<TypesGitspaceConfig, UsererrorError, void, OpenapiCreateGitspaceRequest, CreateGitspacePathParams>
    verb="POST"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseCreateGitspaceProps = Omit<
  UseMutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiCreateGitspaceRequest, CreateGitspacePathParams>,
  'path' | 'verb'
> &
  CreateGitspacePathParams

/**
 * Create gitspace config
 */
export const useCreateGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseCreateGitspaceProps) =>
  useMutate<TypesGitspaceConfig, UsererrorError, void, OpenapiCreateGitspaceRequest, CreateGitspacePathParams>(
    'POST',
    (paramsInPath: CreateGitspacePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface DeleteGitspacePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type DeleteGitspaceProps = Omit<
  MutateProps<void, UsererrorError, void, string, DeleteGitspacePathParams>,
  'path' | 'verb'
> &
  DeleteGitspacePathParams

/**
 * Delete gitspace config
 */
export const DeleteGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: DeleteGitspaceProps) => (
  <Mutate<void, UsererrorError, void, string, DeleteGitspacePathParams>
    verb="DELETE"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseDeleteGitspaceProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, DeleteGitspacePathParams>,
  'path' | 'verb'
> &
  DeleteGitspacePathParams

/**
 * Delete gitspace config
 */
export const useDeleteGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseDeleteGitspaceProps) =>
  useMutate<void, UsererrorError, void, string, DeleteGitspacePathParams>(
    'DELETE',
    (paramsInPath: DeleteGitspacePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface FindGitspacePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type FindGitspaceProps = Omit<
  GetProps<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>,
  'path'
> &
  FindGitspacePathParams

/**
 * Get gitspace
 */
export const FindGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: FindGitspaceProps) => (
  <Get<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseFindGitspaceProps = Omit<
  UseGetProps<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>,
  'path'
> &
  FindGitspacePathParams

/**
 * Get gitspace
 */
export const useFindGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseFindGitspaceProps) =>
  useGet<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>(
    (paramsInPath: FindGitspacePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface UpdateGitspacePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type UpdateGitspaceProps = Omit<
  MutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiUpdateGitspaceRequest, UpdateGitspacePathParams>,
  'path' | 'verb'
> &
  UpdateGitspacePathParams

/**
 * Update gitspace config
 */
export const UpdateGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UpdateGitspaceProps) => (
  <Mutate<TypesGitspaceConfig, UsererrorError, void, OpenapiUpdateGitspaceRequest, UpdateGitspacePathParams>
    verb="PUT"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseUpdateGitspaceProps = Omit<
  UseMutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiUpdateGitspaceRequest, UpdateGitspacePathParams>,
  'path' | 'verb'
> &
  UpdateGitspacePathParams

/**
 * Update gitspace config
 */
export const useUpdateGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseUpdateGitspaceProps) =>
  useMutate<TypesGitspaceConfig, UsererrorError, void, OpenapiUpdateGitspaceRequest, UpdateGitspacePathParams>(
    'PUT',
    (paramsInPath: UpdateGitspacePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface GitspaceActionPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type GitspaceActionProps = Omit<
  MutateProps<TypesGitspaceConfig, unknown, void, OpenapiGitspaceActionRequest, GitspaceActionPathParams>,
  'path' | 'verb'
> &
  GitspaceActionPathParams

/**
 * Gitspace action
 */
export const GitspaceAction = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: GitspaceActionProps) => (
  <Mutate<TypesGitspaceConfig, unknown, void, OpenapiGitspaceActionRequest, GitspaceActionPathParams>
    verb="POST"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}/actions`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGitspaceActionProps = Omit<
  UseMutateProps<TypesGitspaceConfig, unknown, void, OpenapiGitspaceActionRequest, GitspaceActionPathParams>,
  'path' | 'verb'
> &
  GitspaceActionPathParams

/**
 * Gitspace action
 */
export const useGitspaceAction = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseGitspaceActionProps) =>
  useMutate<TypesGitspaceConfig, unknown, void, OpenapiGitspaceActionRequest, GitspaceActionPathParams>(
    'POST',
    (paramsInPath: GitspaceActionPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}/actions`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface GetGitspaceEventsPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type GetGitspaceEventsProps = Omit<
  GetProps<TypesGitspaceEventResponse[], unknown, void, GetGitspaceEventsPathParams>,
  'path'
> &
  GetGitspaceEventsPathParams

/**
 * Get gitspace events
 */
export const GetGitspaceEvents = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: GetGitspaceEventsProps) => (
  <Get<TypesGitspaceEventResponse[], unknown, void, GetGitspaceEventsPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}/events`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGetGitspaceEventsProps = Omit<
  UseGetProps<TypesGitspaceEventResponse[], unknown, void, GetGitspaceEventsPathParams>,
  'path'
> &
  GetGitspaceEventsPathParams

/**
 * Get gitspace events
 */
export const useGetGitspaceEvents = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseGetGitspaceEventsProps) =>
  useGet<TypesGitspaceEventResponse[], unknown, void, GetGitspaceEventsPathParams>(
    (paramsInPath: GetGitspaceEventsPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}/events`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface GetGitspaceInstanceLogsPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type GetGitspaceInstanceLogsProps = Omit<
  GetProps<OpenapiGetGitspaceLogsResponse, unknown, void, GetGitspaceInstanceLogsPathParams>,
  'path'
> &
  GetGitspaceInstanceLogsPathParams

/**
 * Get gitspace instance logs
 */
export const GetGitspaceInstanceLogs = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: GetGitspaceInstanceLogsProps) => (
  <Get<OpenapiGetGitspaceLogsResponse, unknown, void, GetGitspaceInstanceLogsPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}/logs`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGetGitspaceInstanceLogsProps = Omit<
  UseGetProps<OpenapiGetGitspaceLogsResponse, unknown, void, GetGitspaceInstanceLogsPathParams>,
  'path'
> &
  GetGitspaceInstanceLogsPathParams

/**
 * Get gitspace instance logs
 */
export const useGetGitspaceInstanceLogs = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseGetGitspaceInstanceLogsProps) =>
  useGet<OpenapiGetGitspaceLogsResponse, unknown, void, GetGitspaceInstanceLogsPathParams>(
    (paramsInPath: GetGitspaceInstanceLogsPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}/logs`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface GetTokenPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * gitspace identifier.
   */
  gitspace_identifier: string
}

export type GetTokenProps = Omit<GetProps<OpenapiGetTokenResponse, unknown, void, GetTokenPathParams>, 'path'> &
  GetTokenPathParams

/**
 * Get gitspace token
 */
export const GetToken = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: GetTokenProps) => (
  <Get<OpenapiGetTokenResponse, unknown, void, GetTokenPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/${gitspace_identifier}/token`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGetTokenProps = Omit<UseGetProps<OpenapiGetTokenResponse, unknown, void, GetTokenPathParams>, 'path'> &
  GetTokenPathParams

/**
 * Get gitspace token
 */
export const useGetToken = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  gitspace_identifier,
  ...props
}: UseGetTokenProps) =>
  useGet<OpenapiGetTokenResponse, unknown, void, GetTokenPathParams>(
    (paramsInPath: GetTokenPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/${paramsInPath.gitspace_identifier}/token`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, gitspace_identifier },
      ...props
    }
  )

export interface ListGitspaceBranchesQueryParams {
  /**
   * Repository type: github, gitlab, bitbucket, harness_code, unknown
   */
  repo_type: string
  /**
   * Repository URL
   */
  repo_url: string
  /**
   * Term to search
   */
  search_term: string
}

export interface ListGitspaceBranchesPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type ListGitspaceBranchesProps = Omit<
  GetProps<TypesListBranchesResponse, UsererrorError, ListGitspaceBranchesQueryParams, ListGitspaceBranchesPathParams>,
  'path'
> &
  ListGitspaceBranchesPathParams

/**
 * List branches
 */
export const ListGitspaceBranches = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: ListGitspaceBranchesProps) => (
  <Get<TypesListBranchesResponse, UsererrorError, ListGitspaceBranchesQueryParams, ListGitspaceBranchesPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/list-branches`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseListGitspaceBranchesProps = Omit<
  UseGetProps<
    TypesListBranchesResponse,
    UsererrorError,
    ListGitspaceBranchesQueryParams,
    ListGitspaceBranchesPathParams
  >,
  'path'
> &
  ListGitspaceBranchesPathParams

/**
 * List branches
 */
export const useListGitspaceBranches = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseListGitspaceBranchesProps) =>
  useGet<TypesListBranchesResponse, UsererrorError, ListGitspaceBranchesQueryParams, ListGitspaceBranchesPathParams>(
    (paramsInPath: ListGitspaceBranchesPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/list-branches`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface ListGitspaceReposQueryParams {
  /**
   * Repository type: github, gitlab, bitbucket, harness_code, unknown
   */
  repo_type: string
  /**
   * Term to search
   */
  search_term: string
}

export interface ListGitspaceReposPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type ListGitspaceReposProps = Omit<
  GetProps<TypesListRepoResponse, UsererrorError, ListGitspaceReposQueryParams, ListGitspaceReposPathParams>,
  'path'
> &
  ListGitspaceReposPathParams

/**
 * List repositories
 */
export const ListGitspaceRepos = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: ListGitspaceReposProps) => (
  <Get<TypesListRepoResponse, UsererrorError, ListGitspaceReposQueryParams, ListGitspaceReposPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/list-repos`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseListGitspaceReposProps = Omit<
  UseGetProps<TypesListRepoResponse, UsererrorError, ListGitspaceReposQueryParams, ListGitspaceReposPathParams>,
  'path'
> &
  ListGitspaceReposPathParams

/**
 * List repositories
 */
export const useListGitspaceRepos = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseListGitspaceReposProps) =>
  useGet<TypesListRepoResponse, UsererrorError, ListGitspaceReposQueryParams, ListGitspaceReposPathParams>(
    (paramsInPath: ListGitspaceReposPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/list-repos`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface RepoLookupForGitspacePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type RepoLookupForGitspaceProps = Omit<
  MutateProps<
    ScmCodeRepositoryResponse,
    UsererrorError,
    void,
    OpenapiLookupRepoGitspaceRequest,
    RepoLookupForGitspacePathParams
  >,
  'path' | 'verb'
> &
  RepoLookupForGitspacePathParams

/**
 * Validate git repo for gitspaces
 */
export const RepoLookupForGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: RepoLookupForGitspaceProps) => (
  <Mutate<
    ScmCodeRepositoryResponse,
    UsererrorError,
    void,
    OpenapiLookupRepoGitspaceRequest,
    RepoLookupForGitspacePathParams
  >
    verb="POST"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/gitspaces/lookup-repo`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseRepoLookupForGitspaceProps = Omit<
  UseMutateProps<
    ScmCodeRepositoryResponse,
    UsererrorError,
    void,
    OpenapiLookupRepoGitspaceRequest,
    RepoLookupForGitspacePathParams
  >,
  'path' | 'verb'
> &
  RepoLookupForGitspacePathParams

/**
 * Validate git repo for gitspaces
 */
export const useRepoLookupForGitspace = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseRepoLookupForGitspaceProps) =>
  useMutate<
    ScmCodeRepositoryResponse,
    UsererrorError,
    void,
    OpenapiLookupRepoGitspaceRequest,
    RepoLookupForGitspacePathParams
  >(
    'POST',
    (paramsInPath: RepoLookupForGitspacePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/gitspaces/lookup-repo`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface ListInfraProvidersPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type ListInfraProvidersProps = Omit<
  GetProps<TypesInfraProviderConfig[], unknown, void, ListInfraProvidersPathParams>,
  'path'
> &
  ListInfraProvidersPathParams

/**
 * List infraproviders
 */
export const ListInfraProviders = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: ListInfraProvidersProps) => (
  <Get<TypesInfraProviderConfig[], unknown, void, ListInfraProvidersPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/infraproviders`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseListInfraProvidersProps = Omit<
  UseGetProps<TypesInfraProviderConfig[], unknown, void, ListInfraProvidersPathParams>,
  'path'
> &
  ListInfraProvidersPathParams

/**
 * List infraproviders
 */
export const useListInfraProviders = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseListInfraProvidersProps) =>
  useGet<TypesInfraProviderConfig[], unknown, void, ListInfraProvidersPathParams>(
    (paramsInPath: ListInfraProvidersPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/infraproviders`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface CreateInfraProviderPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
}

export type CreateInfraProviderProps = Omit<
  MutateProps<
    TypesInfraProviderConfig,
    UsererrorError,
    void,
    OpenapiCreateInfraProviderConfigRequest,
    CreateInfraProviderPathParams
  >,
  'path' | 'verb'
> &
  CreateInfraProviderPathParams

/**
 * Create infraProvider config
 */
export const CreateInfraProvider = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: CreateInfraProviderProps) => (
  <Mutate<
    TypesInfraProviderConfig,
    UsererrorError,
    void,
    OpenapiCreateInfraProviderConfigRequest,
    CreateInfraProviderPathParams
  >
    verb="POST"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/infraproviders`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseCreateInfraProviderProps = Omit<
  UseMutateProps<
    TypesInfraProviderConfig,
    UsererrorError,
    void,
    OpenapiCreateInfraProviderConfigRequest,
    CreateInfraProviderPathParams
  >,
  'path' | 'verb'
> &
  CreateInfraProviderPathParams

/**
 * Create infraProvider config
 */
export const useCreateInfraProvider = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  ...props
}: UseCreateInfraProviderProps) =>
  useMutate<
    TypesInfraProviderConfig,
    UsererrorError,
    void,
    OpenapiCreateInfraProviderConfigRequest,
    CreateInfraProviderPathParams
  >(
    'POST',
    (paramsInPath: CreateInfraProviderPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/infraproviders`,
    { base: getConfig('cde/api/v1'), pathParams: { accountIdentifier, orgIdentifier, projectIdentifier }, ...props }
  )

export interface GetInfraProviderPathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * infra Provider Config Identifier.
   */
  infraprovider_identifier: string
}

export type GetInfraProviderProps = Omit<
  GetProps<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>,
  'path'
> &
  GetInfraProviderPathParams

/**
 * Get infraProviderConfig
 */
export const GetInfraProvider = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  infraprovider_identifier,
  ...props
}: GetInfraProviderProps) => (
  <Get<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/infraproviders/${infraprovider_identifier}`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseGetInfraProviderProps = Omit<
  UseGetProps<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>,
  'path'
> &
  GetInfraProviderPathParams

/**
 * Get infraProviderConfig
 */
export const useGetInfraProvider = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  infraprovider_identifier,
  ...props
}: UseGetInfraProviderProps) =>
  useGet<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>(
    (paramsInPath: GetInfraProviderPathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/infraproviders/${paramsInPath.infraprovider_identifier}`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, infraprovider_identifier },
      ...props
    }
  )

export interface CreateInfraProviderResourcePathParams {
  /**
   * account identifier.
   */
  accountIdentifier: string
  /**
   * org identifier.
   */
  orgIdentifier: string
  /**
   * project identifier.
   */
  projectIdentifier: string
  /**
   * infra Provider Config Identifier.
   */
  infraprovider_identifier: string
}

export type CreateInfraProviderResourceProps = Omit<
  MutateProps<TypesInfraProviderResource[], unknown, void, void, CreateInfraProviderResourcePathParams>,
  'path' | 'verb'
> &
  CreateInfraProviderResourcePathParams

/**
 * Create InfraProvider Resource
 */
export const CreateInfraProviderResource = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  infraprovider_identifier,
  ...props
}: CreateInfraProviderResourceProps) => (
  <Mutate<TypesInfraProviderResource[], unknown, void, void, CreateInfraProviderResourcePathParams>
    verb="POST"
    path={`/accounts/${accountIdentifier}/orgs/${orgIdentifier}/projects/${projectIdentifier}/infraproviders/${infraprovider_identifier}/resources`}
    base={getConfig('cde/api/v1')}
    {...props}
  />
)

export type UseCreateInfraProviderResourceProps = Omit<
  UseMutateProps<TypesInfraProviderResource[], unknown, void, void, CreateInfraProviderResourcePathParams>,
  'path' | 'verb'
> &
  CreateInfraProviderResourcePathParams

/**
 * Create InfraProvider Resource
 */
export const useCreateInfraProviderResource = ({
  accountIdentifier,
  orgIdentifier,
  projectIdentifier,
  infraprovider_identifier,
  ...props
}: UseCreateInfraProviderResourceProps) =>
  useMutate<TypesInfraProviderResource[], unknown, void, void, CreateInfraProviderResourcePathParams>(
    'POST',
    (paramsInPath: CreateInfraProviderResourcePathParams) =>
      `/accounts/${paramsInPath.accountIdentifier}/orgs/${paramsInPath.orgIdentifier}/projects/${paramsInPath.projectIdentifier}/infraproviders/${paramsInPath.infraprovider_identifier}/resources`,
    {
      base: getConfig('cde/api/v1'),
      pathParams: { accountIdentifier, orgIdentifier, projectIdentifier, infraprovider_identifier },
      ...props
    }
  )
