import { upperFirst, camelCase } from 'lodash-es'

export const renderComponent = ({ iconset, iconName, svg }) =>
  `// This file is automatically generated. Modifying its content manually is discouraged.
import { registerIcon } from '@harnessio/svg-icon'
import { Icon, type IconProps } from '@harnessio/svg-icon-react'

const name = '${iconName}${iconset ? '/' + iconset : ''}'

registerIcon(
  name,
  \`${svg}\`
)

export function ${componentName(iconName)}(props: IconProps) {
  return <Icon name={name} {...props} />
}

${componentName(iconName)}.prototype.name = name
`

export const renderIndex = iconNames =>
  `// This file is automatically generated. Modifying its content manually is discouraged.
${iconNames
  .map(iconName => componentName(iconName))
  .sort()
  .map(componentName => `export { ${componentName} } from './${componentName}'`)
  .join('\r\n')}`

export const componentFile = iconName => `${componentName(iconName)}.tsx`

export const INDEX_FILE = 'index.ts'

const componentName = iconName => {
  const name = upperFirst(camelCase(iconName))
  return /^\d/.test(name) ? `Svg${name}` : name // Prefix `Svg` to component name if it starts with a number
}
