/*
 * Copyright 2024 Harness, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Generated by restful-react */

import React from 'react'
import { Get, GetProps, useGet, UseGetProps, Mutate, MutateProps, useMutate, UseMutateProps } from 'restful-react'

import { getConfig } from '../../services/config'
export const SPEC_VERSION = '0.0.0'
export interface ApiFileDiffRequest {
  path?: string
  start_line?: number
}

export type EnumCIStatus = string

export type EnumCheckPayloadKind = '' | 'markdown' | 'pipeline' | 'raw'

export type EnumCheckStatus = 'error' | 'failure' | 'pending' | 'running' | 'success'

export type EnumContentEncodingType = 'base64' | 'utf8'

export type EnumFileDiffStatus = string

export type EnumGitspaceAccessType = 'jwt_token' | 'user_credentials' | 'ssh_key'

export type EnumGitspaceCodeRepoType = 'github' | 'gitlab' | 'harness_code' | 'bitbucket' | 'unknown' | 'gitness'

export type EnumGitspaceEntityType = 'gitspace_config' | 'gitspace_instance'

export type EnumGitspaceEventType =
  | 'gitspace_action_start'
  | 'gitspace_action_start_completed'
  | 'gitspace_action_start_failed'
  | 'gitspace_action_stop'
  | 'gitspace_action_stop_completed'
  | 'gitspace_action_stop_failed'
  | 'fetch_devcontainer_start'
  | 'fetch_devcontainer_completed'
  | 'fetch_devcontainer_failed'
  | 'infra_provisioning_start'
  | 'infra_provisioning_completed'
  | 'infra_provisioning_failed'
  | 'infra_unprovisioning_start'
  | 'infra_unprovisioning_completed'
  | 'infra_unprovisioning_failed'
  | 'agent_connect_start'
  | 'agent_connect_completed'
  | 'agent_connect_failed'
  | 'agent_gitspace_creation_start'
  | 'agent_gitspace_creation_completed'
  | 'agent_gitspace_creation_failed'
  | 'agent_gitspace_deletion_start'
  | 'agent_gitspace_deletion_completed'
  | 'agent_gitspace_deletion_failed'
  | 'agent_gitspace_state_report_running'
  | 'agent_gitspace_state_report_error'
  | 'agent_gitspace_state_report_stopped'
  | 'agent_gitspace_state_report_unknown'

export type EnumGitspaceInstanceStateType =
  | 'running'
  | 'uninitialized'
  | 'unknown'
  | 'error'
  | 'deleted'
  | 'starting'
  | 'stopping'

export type EnumGitspaceStateType = 'running' | 'stopped' | 'error' | 'uninitialized' | 'starting' | 'stopping'

export type EnumIDEType = 'vs_code' | 'vs_code_web' | 'intellij'

export type EnumInfraProviderType = 'docker' | 'harness_gcp'

export type EnumMembershipRole = 'contributor' | 'executor' | 'reader' | 'space_owner'

export type EnumMergeCheckStatus = string

export type EnumMergeMethod = 'merge' | 'rebase' | 'squash'

export type EnumParentResourceType = 'space' | 'repo'

export type EnumPrincipalType = 'service' | 'serviceaccount' | 'user'

export type EnumPublicKeyUsage = 'auth'

export type EnumPullReqActivityKind = 'change-comment' | 'comment' | 'system'

export type EnumPullReqActivityType =
  | 'branch-delete'
  | 'branch-update'
  | 'code-comment'
  | 'comment'
  | 'merge'
  | 'review-submit'
  | 'state-change'
  | 'title-change'

export type EnumPullReqCommentStatus = 'active' | 'resolved'

export type EnumPullReqReviewDecision = 'approved' | 'changereq' | 'pending' | 'reviewed'

export type EnumPullReqReviewerType = 'assigned' | 'requested' | 'self_assigned'

export type EnumPullReqState = 'closed' | 'merged' | 'open'

export type EnumRepoState = number

export type EnumResolverType = string

export type EnumRuleState = 'active' | 'disabled' | 'monitor' | null

export type EnumTokenType = string

export type EnumTriggerAction =
  | 'branch_created'
  | 'branch_updated'
  | 'pullreq_branch_updated'
  | 'pullreq_closed'
  | 'pullreq_created'
  | 'pullreq_merged'
  | 'pullreq_reopened'
  | 'tag_created'
  | 'tag_updated'

export type EnumWebhookExecutionResult = 'fatal_error' | 'retriable_error' | 'success' | null

export type EnumWebhookParent = 'repo' | 'space'

export type EnumWebhookTrigger =
  | 'branch_created'
  | 'branch_deleted'
  | 'branch_updated'
  | 'pullreq_branch_updated'
  | 'pullreq_closed'
  | 'pullreq_comment_created'
  | 'pullreq_created'
  | 'pullreq_merged'
  | 'pullreq_reopened'
  | 'tag_created'
  | 'tag_deleted'
  | 'tag_updated'

export interface GitBlamePart {
  commit?: GitCommit
  lines?: string[] | null
}

export interface GitCommit {
  author?: GitSignature
  committer?: GitSignature
  file_stats?: GitCommitFileStats[]
  message?: string
  parent_shas?: ShaSHA[]
  sha?: ShaSHA
  title?: string
}

export interface GitCommitFileStats {
  [key: string]: any
}

export type GitFileAction = 'CREATE' | 'UPDATE' | 'DELETE' | 'MOVE' | 'PATCH_TEXT'

export interface GitFileDiff {
  additions?: number
  changes?: number
  deletions?: number
  is_binary?: boolean
  is_submodule?: boolean
  old_path?: string
  old_sha?: string
  patch?: number[]
  path?: string
  sha?: string
  status?: EnumFileDiffStatus
}

export interface GitIdentity {
  email?: string
  name?: string
}

export interface GitPathDetails {
  last_commit?: GitCommit
  path?: string
}

export interface GitSignature {
  identity?: GitIdentity
  when?: string
}

export type ImporterPipelineOption = 'convert' | 'ignore'

export interface ImporterProvider {
  host?: string
  password?: string
  type?: ImporterProviderType
  username?: string
}

export type ImporterProviderType = 'github' | 'gitlab' | 'bitbucket' | 'stash' | 'gitea' | 'gogs' | 'azure'

export interface InfraproviderResourceInput {
  cpu?: string | null
  disk?: string | null
  gateway_host?: string | null
  gateway_port?: string | null
  identifier?: string
  infra_provider_type?: EnumInfraProviderType
  memory?: string | null
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  network?: string | null
  region?: string[] | null
  template_identifier?: string | null
}

export interface JobProgress {
  failure?: string
  progress?: number
  result?: string
  state?: JobState
}

export type JobState = 'canceled' | 'failed' | 'finished' | 'running' | 'scheduled'

export interface LivelogLine {
  out?: string
  pos?: number
  time?: number
}

export interface OpenapiAdminUsersCreateRequest {
  display_name?: string
  email?: string
  password?: string
  uid?: string
}

export interface OpenapiAdminUsersUpdateRequest {
  display_name?: string | null
  email?: string | null
  password?: string | null
}

export interface OpenapiCalculateCommitDivergenceRequest {
  max_count?: number
  requests?: RepoCommitDivergenceRequest[] | null
}

export interface OpenapiCommentApplySuggestionstRequest {
  bypass_rules?: boolean
  dry_run_rules?: boolean
  message?: string
  suggestions?: PullreqSuggestionReference[] | null
  title?: string
}

export interface OpenapiCommentCreatePullReqRequest {
  line_end?: number
  line_end_new?: boolean
  line_start?: number
  line_start_new?: boolean
  parent_id?: number
  path?: string
  source_commit_sha?: string
  target_commit_sha?: string
  text?: string
}

export interface OpenapiCommentStatusPullReqRequest {
  status?: EnumPullReqCommentStatus
}

export interface OpenapiCommentUpdatePullReqRequest {
  text?: string
}

export interface OpenapiCommitFilesRequest {
  actions?: RepoCommitFileAction[] | null
  branch?: string
  bypass_rules?: boolean
  dry_run_rules?: boolean
  message?: string
  new_branch?: string
  title?: string
}

export type OpenapiContent = RepoFileContent | OpenapiDirContent | RepoSymlinkContent | RepoSubmoduleContent

export interface OpenapiContentInfo {
  latest_commit?: TypesCommit
  name?: string
  path?: string
  sha?: string
  type?: OpenapiContentType
}

export type OpenapiContentType = 'file' | 'dir' | 'symlink' | 'submodule'

export interface OpenapiCreateBranchRequest {
  bypass_rules?: boolean
  name?: string
  target?: string
}

export interface OpenapiCreateConnectorRequest {
  data?: string
  description?: string
  identifier?: string
  space_ref?: string
  type?: string
  uid?: string
}

export interface OpenapiCreateGitspaceRequest {
  branch?: string
  code_repo_url?: string | null
  code_repo_ref?: string
  code_repo_type?: EnumGitspaceCodeRepoType
  devcontainer_path?: string | null
  ide?: EnumIDEType
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resource_identifier?: string
  space_ref?: string
}

export interface OpenapiCreateInfraProviderConfigRequest {
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resources?: InfraproviderResourceInput[] | null
  space_ref?: string
  type?: EnumInfraProviderType
}

export interface OpenapiCreatePipelineRequest {
  config_path?: string
  default_branch?: string
  description?: string
  disabled?: boolean
  identifier?: string
  uid?: string
}

export interface OpenapiCreatePullReqRequest {
  description?: string
  is_draft?: boolean
  source_branch?: string
  source_repo_ref?: string
  target_branch?: string
  title?: string
}

export interface OpenapiCreateRepositoryRequest {
  default_branch?: string
  description?: string
  fork_id?: number
  git_ignore?: string
  identifier?: string
  is_public?: boolean
  license?: string
  parent_ref?: string
  readme?: boolean
  uid?: string
}

export interface OpenapiCreateSecretRequest {
  data?: string
  description?: string
  identifier?: string
  space_ref?: string
  uid?: string
}

export interface OpenapiCreateSpaceRequest {
  description?: string
  identifier?: string
  is_public?: boolean
  parent_ref?: string
  uid?: string
}

export interface OpenapiCreateTagRequest {
  bypass_rules?: boolean
  message?: string
  name?: string
  target?: string
}

export interface OpenapiCreateTemplateRequest {
  data?: string
  description?: string
  identifier?: string
  space_ref?: string
  uid?: string
}

export interface OpenapiCreateTokenRequest {
  identifier?: string
  lifetime?: TimeDuration
  uid?: string
}

export interface OpenapiCreateTriggerRequest {
  actions?: EnumTriggerAction[] | null
  description?: string
  disabled?: boolean
  identifier?: string
  secret?: string
  uid?: string
}

export interface OpenapiCreateWebhookRequest {
  description?: string
  display_name?: string
  enabled?: boolean
  identifier?: string
  insecure?: boolean
  secret?: string
  triggers?: EnumWebhookTrigger[] | null
  uid?: string
  url?: string
}

export interface OpenapiDirContent {
  entries?: OpenapiContentInfo[] | null
}

export interface OpenapiExportSpaceRequest {
  account_id?: string
  org_identifier?: string
  project_identifier?: string
  token?: string
}

export interface OpenapiFileViewAddPullReqRequest {
  commit_sha?: string
  path?: string
}

export interface OpenapiGeneralSettingsRequest {
  file_size_limit?: number | null
}

export interface OpenapiGetContentOutput {
  content?: OpenapiContent
  latest_commit?: TypesCommit
  name?: string
  path?: string
  sha?: string
  type?: OpenapiContentType
}

export interface OpenapiLoginRequest {
  login_identifier?: string
  password?: string
}

export interface OpenapiLookupRepoGitspaceRequest {
  space_ref?: string
  url?: string
}

export interface OpenapiMergePullReq {
  bypass_rules?: boolean
  dry_run?: boolean
  message?: string
  method?: EnumMergeMethod
  source_sha?: string
  title?: string
}

export interface OpenapiMoveRepoRequest {
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiMoveSpaceRequest {
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiPathsDetailsRequest {
  paths?: string[] | null
}

export type OpenapiPostRawDiffRequest = ApiFileDiffRequest[] | null

export type OpenapiPostRawPRDiffRequest = ApiFileDiffRequest[] | null

export interface OpenapiRegisterRequest {
  display_name?: string
  email?: string
  password?: string
  uid?: string
}

export interface OpenapiRestoreRequest {
  new_identifier?: string | null
  new_parent_ref?: string | null
}

export interface OpenapiRestoreSpaceRequest {
  new_identifier?: string | null
  new_parent_ref?: string | null
}

export interface OpenapiReviewSubmitPullReqRequest {
  commit_sha?: string
  decision?: EnumPullReqReviewDecision
}

export interface OpenapiReviewerAddPullReqRequest {
  reviewer_id?: number
}

export interface OpenapiRule {
  created?: number
  created_by?: TypesPrincipalInfo
  definition?: OpenapiRuleDefinition
  description?: string
  identifier?: string
  pattern?: ProtectionPattern
  state?: EnumRuleState
  type?: OpenapiRuleType
  updated?: number
  users?: {
    [key: string]: TypesPrincipalInfo
  } | null
}

export type OpenapiRuleDefinition = ProtectionBranch

export type OpenapiRuleType = 'branch'

export interface OpenapiSecuritySettingsRequest {
  secret_scanning_enabled?: boolean | null
}

export interface OpenapiStatePullReqRequest {
  is_draft?: boolean
  state?: EnumPullReqState
}

export interface OpenapiUpdateAdminRequest {
  admin?: boolean
}

export interface OpenapiUpdateConnectorRequest {
  data?: string | null
  description?: string | null
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiUpdatePipelineRequest {
  config_path?: string | null
  description?: string | null
  disabled?: boolean | null
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiUpdatePullReqRequest {
  description?: string
  title?: string
}

export interface OpenapiUpdateRepoPublicAccessRequest {
  is_public?: boolean
}

export interface OpenapiUpdateRepoRequest {
  description?: string | null
}

export interface OpenapiUpdateSecretRequest {
  data?: string | null
  description?: string | null
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiUpdateSpacePublicAccessRequest {
  is_public?: boolean
}

export interface OpenapiUpdateSpaceRequest {
  description?: string | null
}

export interface OpenapiUpdateTemplateRequest {
  data?: string | null
  description?: string | null
  identifier?: string | null
  uid?: string | null
}

export interface OpenapiUpdateTriggerRequest {
  actions?: EnumTriggerAction[] | null
  description?: string | null
  disabled?: boolean | null
  identifier?: string | null
  secret?: string | null
  uid?: string | null
}

export interface OpenapiUpdateWebhookRequest {
  description?: string | null
  display_name?: string | null
  enabled?: boolean | null
  identifier?: string | null
  insecure?: boolean | null
  secret?: string | null
  triggers?: EnumWebhookTrigger[] | null
  uid?: string | null
  url?: string | null
}

export interface OpenapiWebhookType {
  created?: number
  created_by?: number
  description?: string
  display_name?: string
  enabled?: boolean
  has_secret?: boolean
  id?: number
  identifier?: string
  insecure?: boolean
  latest_execution_result?: EnumWebhookExecutionResult
  parent_id?: number
  parent_type?: EnumWebhookParent
  triggers?: EnumWebhookTrigger[] | null
  updated?: number
  url?: string
  version?: number
}

export interface ProtectionBranch {
  bypass?: ProtectionDefBypass
  lifecycle?: ProtectionDefLifecycle
  pullreq?: ProtectionDefPullReq
}

export interface ProtectionDefApprovals {
  require_code_owners?: boolean
  require_latest_commit?: boolean
  require_minimum_count?: number
  require_no_change_request?: boolean
}

export interface ProtectionDefBypass {
  repo_owners?: boolean
  user_ids?: number[]
}

export interface ProtectionDefComments {
  require_resolve_all?: boolean
}

export interface ProtectionDefLifecycle {
  create_forbidden?: boolean
  delete_forbidden?: boolean
  update_forbidden?: boolean
}

export interface ProtectionDefMerge {
  delete_branch?: boolean
  strategies_allowed?: EnumMergeMethod[]
}

export interface ProtectionDefPullReq {
  approvals?: ProtectionDefApprovals
  comments?: ProtectionDefComments
  merge?: ProtectionDefMerge
  status_checks?: ProtectionDefStatusChecks
}

export interface ProtectionDefStatusChecks {
  require_identifiers?: string[]
}

export type ProtectionPattern = {
  default?: boolean
  exclude?: string[]
  include?: string[]
} | null

export interface PullreqCommentApplySuggestionsOutput {
  commit_id?: string
  dry_run_rules?: boolean
  rule_violations?: TypesRuleViolations[]
}

export interface PullreqSuggestionReference {
  check_sum?: string
  comment_id?: number
}

export interface RepoBranch {
  commit?: TypesCommit
  name?: string
  sha?: string
}

export interface RepoCommitDivergence {
  ahead?: number
  behind?: number
}

export interface RepoCommitDivergenceRequest {
  from?: string
  to?: string
}

export interface RepoCommitFileAction {
  action?: GitFileAction
  encoding?: EnumContentEncodingType
  path?: string
  payload?: string
  sha?: ShaSHA
}

export interface RepoCommitTag {
  commit?: TypesCommit
  is_annotated?: boolean
  message?: string
  name?: string
  sha?: string
  tagger?: TypesSignature
  title?: string
}

export type RepoContent = {}

export interface RepoContentInfo {
  latest_commit?: TypesCommit
  name?: string
  path?: string
  sha?: string
  type?: RepoContentType
}

export type RepoContentType = string

export interface RepoFileContent {
  data?: string
  data_size?: number
  encoding?: EnumContentEncodingType
  size?: number
}

export interface RepoListPathsOutput {
  directories?: string[]
  files?: string[]
}

export interface RepoMergeCheck {
  conflict_files?: string[]
  mergeable?: boolean
}

export interface RepoPathsDetailsOutput {
  details?: GitPathDetails[] | null
}

export interface RepoRepositoryOutput {
  created?: number
  created_by?: number
  default_branch?: string
  deleted?: number | null
  description?: string
  fork_id?: number
  git_ssh_url?: string
  git_url?: string
  id?: number
  identifier?: string
  importing?: boolean
  is_empty?: boolean
  is_public?: boolean
  num_closed_pulls?: number
  num_forks?: number
  num_merged_pulls?: number
  num_open_pulls?: number
  num_pulls?: number
  parent_id?: number
  path?: string
  size?: number
  size_updated?: number
  state?: EnumRepoState
  updated?: number
}

export interface RepoSoftDeleteResponse {
  deleted_at?: number
}

export interface RepoSubmoduleContent {
  commit_sha?: string
  url?: string
}

export interface RepoSymlinkContent {
  size?: number
  target?: string
}

export interface ReposettingsGeneralSettings {
  file_size_limit?: number | null
}

export interface ReposettingsSecuritySettings {
  secret_scanning_enabled?: boolean | null
}

export interface ScmCodeRepositoryResponse {
  branch?: string
  is_private?: boolean
  url?: string
}

/**
 * Git object hash
 */
export type ShaSHA = string

export interface SpaceExportProgressOutput {
  repos?: JobProgress[] | null
}

export interface SpaceImportRepositoriesOutput {
  duplicate_repos?: RepoRepositoryOutput[] | null
  importing_repos?: RepoRepositoryOutput[] | null
}

export interface SpaceSoftDeleteResponse {
  deleted_at?: number
}

export interface SpaceSpaceOutput {
  created?: number
  created_by?: number
  deleted?: number | null
  description?: string
  id?: number
  identifier?: string
  is_public?: boolean
  parent_id?: number
  path?: string
  updated?: number
}

export interface SystemConfigOutput {
  public_resource_creation_enabled?: boolean
  ssh_enabled?: boolean
  user_signup_allowed?: boolean
}

export type TimeDuration = number | null

export interface TypesChangeStats {
  changes?: number
  deletions?: number
  insertions?: number
}

export interface TypesCheck {
  created?: number
  ended?: number
  id?: number
  identifier?: string
  link?: string
  metadata?: {}
  payload?: TypesCheckPayload
  reported_by?: TypesPrincipalInfo
  started?: number
  status?: EnumCheckStatus
  summary?: string
  updated?: number
}

export interface TypesCheckPayload {
  data?: {}
  kind?: EnumCheckPayloadKind
  version?: string
}

export interface TypesCodeCommentFields {
  line_new?: number
  line_old?: number
  merge_base_sha?: string
  outdated?: boolean
  path?: string
  source_sha?: string
  span_new?: number
  span_old?: number
}

export interface TypesCodeOwnerEvaluation {
  evaluation_entries?: TypesCodeOwnerEvaluationEntry[] | null
  file_sha?: string
}

export interface TypesCodeOwnerEvaluationEntry {
  line_number?: number
  owner_evaluations?: TypesOwnerEvaluation[] | null
  pattern?: string
  user_group_owner_evaluations?: TypesUserGroupOwnerEvaluation[] | null
}

export interface TypesCommit {
  author?: TypesSignature
  committer?: TypesSignature
  message?: string
  parent_shas?: string[]
  sha?: string
  stats?: TypesCommitStats
  title?: string
}

export interface TypesCommitFileStats {
  changes?: number
  deletions?: number
  insertions?: number
  old_path?: string
  path?: string
  status?: EnumFileDiffStatus
}

export interface TypesCommitFilesResponse {
  commit_id?: string
  dry_run_rules?: boolean
  rule_violations?: TypesRuleViolations[]
}

export interface TypesCommitStats {
  files?: TypesCommitFileStats[]
  total?: TypesChangeStats
}

export interface TypesConnector {
  created?: number
  data?: string
  description?: string
  identifier?: string
  space_id?: number
  type?: string
  updated?: number
}

export interface TypesDiffStats {
  commits?: number | null
  files_changed?: number | null
}

export interface TypesExecution {
  action?: string
  after?: string
  author_avatar?: string
  author_email?: string
  author_login?: string
  author_name?: string
  before?: string
  created?: number
  created_by?: number
  cron?: string
  debug?: boolean
  deploy_id?: number
  deploy_to?: string
  error?: string
  event?: string
  finished?: number
  link?: string
  message?: string
  number?: number
  params?: {
    [key: string]: string
  }
  parent?: number
  pipeline_id?: number
  ref?: string
  repo_id?: number
  sender?: string
  source?: string
  source_repo?: string
  stages?: TypesStage[]
  started?: number
  status?: EnumCIStatus
  target?: string
  timestamp?: number
  title?: string
  trigger?: string
  updated?: number
}

export interface TypesGitspaceConfig {
  branch?: string
  code_repo_type?: EnumGitspaceCodeRepoType
  code_repo_url?: string
  created?: number
  devcontainer_path?: string | null
  ide?: EnumIDEType
  identifier?: string
  instance?: TypesGitspaceInstance
  name?: string
  resource_identifier?: string
  space_path?: string
  state?: EnumGitspaceStateType
  updated?: number
  user_id?: string
}

export interface TypesGitspaceEventResponse {
  entity_type?: EnumGitspaceEntityType
  event?: EnumGitspaceEventType
  event_time?: string
  message?: string
  query_key?: string
  timestamp?: number
}

export type TypesGitspaceInstance = {
  access_key?: string | null
  access_type?: EnumGitspaceAccessType
  created?: number
  error_message?: string | null
  identifier?: string
  last_used?: number
  machine_user?: string | null
  resource_usage?: string | null
  space_path?: string
  state?: EnumGitspaceInstanceStateType
  total_time_used?: number
  tracked_changes?: string | null
  updated?: number
  url?: string | null
} | null

export interface TypesIdentity {
  email?: string
  name?: string
}

export interface TypesInfraProviderConfig {
  created?: number
  identifier?: string
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  resources?: TypesInfraProviderResource[] | null
  space_path?: string
  type?: EnumInfraProviderType
  updated?: number
}

export interface TypesInfraProviderResource {
  config_identifier?: string
  cpu?: string | null
  created?: number
  disk?: string | null
  gateway_host?: string | null
  gateway_port?: string | null
  identifier?: string
  infra_provider_type?: EnumInfraProviderType
  memory?: string | null
  metadata?: {
    [key: string]: string
  } | null
  name?: string
  network?: string | null
  region?: string
  space_path?: string
  template_identifier?: string | null
  updated?: number
}

export interface TypesListCommitResponse {
  commits?: TypesCommit[] | null
  rename_details?: TypesRenameDetails[] | null
  total_commits?: number
}

export interface TypesMembershipSpace {
  added_by?: TypesPrincipalInfo
  created?: number
  role?: EnumMembershipRole
  space?: TypesSpace
  updated?: number
}

export interface TypesMembershipUser {
  added_by?: TypesPrincipalInfo
  created?: number
  principal?: TypesPrincipalInfo
  role?: EnumMembershipRole
  updated?: number
}

export interface TypesMergeResponse {
  allowed_methods?: EnumMergeMethod[]
  branch_deleted?: boolean
  conflict_files?: string[]
  dry_run?: boolean
  minimum_required_approvals_count?: number
  minimum_required_approvals_count_latest?: number
  requires_code_owners_approval?: boolean
  requires_code_owners_approval_latest?: boolean
  requires_comment_resolution?: boolean
  requires_no_change_requests?: boolean
  rule_violations?: TypesRuleViolations[]
  sha?: string
}

export interface TypesMergeViolations {
  conflict_files?: string[]
  rule_violations?: TypesRuleViolations[]
}

export interface TypesOwnerEvaluation {
  owner?: TypesPrincipalInfo
  review_decision?: EnumPullReqReviewDecision
  review_sha?: string
}

export interface TypesPipeline {
  config_path?: string
  created?: number
  created_by?: number
  default_branch?: string
  description?: string
  disabled?: boolean
  execution?: TypesExecution
  id?: number
  identifier?: string
  repo_id?: number
  seq?: number
  updated?: number
}

export interface TypesPlugin {
  description?: string
  identifier?: string
  logo?: string
  spec?: string
  type?: string
  version?: string
}

export interface TypesPrincipalInfo {
  created?: number
  display_name?: string
  email?: string
  id?: number
  type?: EnumPrincipalType
  uid?: string
  updated?: number
}

export interface TypesPublicKey {
  comment?: string
  created?: number
  fingerprint?: string
  identifier?: string
  type?: string
  usage?: EnumPublicKeyUsage
  verified?: number | null
}

export interface TypesPullReq {
  author?: TypesPrincipalInfo
  closed?: number | null
  created?: number
  description?: string
  edited?: number
  is_draft?: boolean
  merge_base_sha?: string
  merge_check_status?: EnumMergeCheckStatus
  merge_conflicts?: string[]
  merge_method?: EnumMergeMethod
  merge_target_sha?: string | null
  merged?: number | null
  merger?: TypesPrincipalInfo
  number?: number
  source_branch?: string
  source_repo_id?: number
  source_sha?: string
  state?: EnumPullReqState
  stats?: TypesPullReqStats
  target_branch?: string
  target_repo_id?: number
  title?: string
}

export interface TypesPullReqActivity {
  author?: TypesPrincipalInfo
  code_comment?: TypesCodeCommentFields
  created?: number
  deleted?: number | null
  edited?: number
  id?: number
  kind?: EnumPullReqActivityKind
  mentions?: {
    [key: string]: TypesPrincipalInfo
  }
  metadata?: TypesPullReqActivityMetadata
  order?: number
  parent_id?: number | null
  payload?: {}
  pullreq_id?: number
  repo_id?: number
  resolved?: number | null
  resolver?: TypesPrincipalInfo
  sub_order?: number
  text?: string
  type?: EnumPullReqActivityType
  updated?: number
}

export interface TypesPullReqActivityMentionsMetadata {
  ids?: number[]
}

export interface TypesPullReqActivityMetadata {
  mentions?: TypesPullReqActivityMentionsMetadata
  suggestions?: TypesPullReqActivitySuggestionsMetadata
}

export interface TypesPullReqActivitySuggestionsMetadata {
  applied_check_sum?: string
  applied_commit_sha?: string
  check_sums?: string[]
}

export interface TypesPullReqCheck {
  bypassable?: boolean
  check?: TypesCheck
  required?: boolean
}

export interface TypesPullReqChecks {
  checks?: TypesPullReqCheck[] | null
  commit_sha?: string
}

export interface TypesPullReqFileView {
  obsolete?: boolean
  path?: string
  sha?: string
}

export interface TypesPullReqReviewer {
  added_by?: TypesPrincipalInfo
  created?: number
  latest_review_id?: number | null
  review_decision?: EnumPullReqReviewDecision
  reviewer?: TypesPrincipalInfo
  sha?: string
  type?: EnumPullReqReviewerType
  updated?: number
}

export interface TypesPullReqStats {
  commits?: number | null
  conversations?: number
  files_changed?: number | null
  unresolved_count?: number
}

export interface TypesRenameDetails {
  commit_sha_after?: string
  commit_sha_before?: string
  new_path?: string
  old_path?: string
}

export interface TypesRepository {
  created?: number
  created_by?: number
  default_branch?: string
  deleted?: number | null
  description?: string
  fork_id?: number
  git_ssh_url?: string
  git_url?: string
  id?: number
  identifier?: string
  is_empty?: boolean
  num_closed_pulls?: number
  num_forks?: number
  num_merged_pulls?: number
  num_open_pulls?: number
  num_pulls?: number
  parent_id?: number
  path?: string
  size?: number
  size_updated?: number
  state?: EnumRepoState
  updated?: number
}

export interface TypesRepositoryPullReqSummary {
  closed_count?: number
  merged_count?: number
  open_count?: number
}

export interface TypesRepositorySummary {
  branch_count?: number
  default_branch_commit_count?: number
  pull_req_summary?: TypesRepositoryPullReqSummary
  tag_count?: number
}

export interface TypesRuleInfo {
  identifier?: string
  repo_path?: string
  space_path?: string
  state?: EnumRuleState
  type?: TypesRuleType
}

export type TypesRuleType = string

export interface TypesRuleViolations {
  bypassable?: boolean
  bypassed?: boolean
  rule?: TypesRuleInfo
  violations?: TypesViolation[] | null
}

export interface TypesRulesViolations {
  violations?: TypesRuleViolations[] | null
}

export interface TypesSecret {
  created?: number
  created_by?: number
  description?: string
  identifier?: string
  space_id?: number
  updated?: number
}

export interface TypesServiceAccount {
  admin?: boolean
  blocked?: boolean
  created?: number
  display_name?: string
  email?: string
  parent_id?: number
  parent_type?: EnumParentResourceType
  uid?: string
  updated?: number
}

export interface TypesSignature {
  identity?: TypesIdentity
  when?: string
}

export interface TypesSpace {
  created?: number
  created_by?: number
  deleted?: number | null
  description?: string
  id?: number
  identifier?: string
  parent_id?: number
  path?: string
  updated?: number
}

export interface TypesStage {
  arch?: string
  depends_on?: string[]
  errignore?: boolean
  error?: string
  execution_id?: number
  exit_code?: number
  kernel?: string
  kind?: string
  labels?: {
    [key: string]: string
  }
  limit?: number
  machine?: string
  name?: string
  number?: number
  on_failure?: boolean
  on_success?: boolean
  os?: string
  repo_id?: number
  started?: number
  status?: EnumCIStatus
  steps?: TypesStep[]
  stopped?: number
  throttle?: number
  type?: string
  variant?: string
}

export interface TypesStep {
  depends_on?: string[]
  detached?: boolean
  errignore?: boolean
  error?: string
  exit_code?: number
  image?: string
  name?: string
  number?: number
  schema?: string
  started?: number
  status?: EnumCIStatus
  stopped?: number
}

export interface TypesTemplate {
  created?: number
  data?: string
  description?: string
  identifier?: string
  space_id?: number
  type?: EnumResolverType
  updated?: number
}

export interface TypesToken {
  created_by?: number
  expires_at?: number | null
  identifier?: string
  issued_at?: number
  principal_id?: number
  type?: EnumTokenType
}

export interface TypesTokenResponse {
  access_token?: string
  token?: TypesToken
}

export interface TypesTrigger {
  actions?: EnumTriggerAction[] | null
  created?: number
  created_by?: number
  description?: string
  disabled?: boolean
  identifier?: string
  pipeline_id?: number
  repo_id?: number
  trigger_type?: string
  updated?: number
}

export interface TypesUser {
  admin?: boolean
  blocked?: boolean
  created?: number
  display_name?: string
  email?: string
  uid?: string
  updated?: number
}

export interface TypesUserGroupOwnerEvaluation {
  evaluations?: TypesOwnerEvaluation[] | null
  id?: string
  name?: string
}

export interface TypesViolation {
  code?: string
  message?: string
  params?: {}[] | null
}

export interface TypesWebhookExecution {
  created?: number
  duration?: number
  error?: string
  id?: number
  request?: TypesWebhookExecutionRequest
  response?: TypesWebhookExecutionResponse
  result?: EnumWebhookExecutionResult
  retrigger_of?: number | null
  retriggerable?: boolean
  trigger_type?: EnumWebhookTrigger
  webhook_id?: number
}

export interface TypesWebhookExecutionRequest {
  body?: string
  headers?: string
  url?: string
}

export interface TypesWebhookExecutionResponse {
  body?: string
  headers?: string
  status?: string
  status_code?: number
}

export interface UploadResult {
  file_path?: string
}

export interface UserCreatePublicKeyInput {
  content?: string
  identifier?: string
  usage?: EnumPublicKeyUsage
}

export interface UserUpdateInput {
  display_name?: string | null
  email?: string | null
  password?: string | null
}

export interface UsererrorError {
  message?: string
  values?: { [key: string]: any }
}

export interface AdminListUsersQueryParams {
  sort?: 'id' | 'email' | 'created' | 'updated'
  order?: 'asc' | 'desc'
  page?: number
  limit?: number
}

export type AdminListUsersProps = Omit<GetProps<TypesUser[], UsererrorError, AdminListUsersQueryParams, void>, 'path'>

export const AdminListUsers = (props: AdminListUsersProps) => (
  <Get<TypesUser[], UsererrorError, AdminListUsersQueryParams, void>
    path={`/admin/users`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseAdminListUsersProps = Omit<
  UseGetProps<TypesUser[], UsererrorError, AdminListUsersQueryParams, void>,
  'path'
>

export const useAdminListUsers = (props: UseAdminListUsersProps) =>
  useGet<TypesUser[], UsererrorError, AdminListUsersQueryParams, void>(`/admin/users`, {
    base: getConfig('api/v1'),
    ...props
  })

export type AdminCreateUserProps = Omit<
  MutateProps<TypesUser, UsererrorError, void, OpenapiAdminUsersCreateRequest, void>,
  'path' | 'verb'
>

export const AdminCreateUser = (props: AdminCreateUserProps) => (
  <Mutate<TypesUser, UsererrorError, void, OpenapiAdminUsersCreateRequest, void>
    verb="POST"
    path={`/admin/users`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseAdminCreateUserProps = Omit<
  UseMutateProps<TypesUser, UsererrorError, void, OpenapiAdminUsersCreateRequest, void>,
  'path' | 'verb'
>

export const useAdminCreateUser = (props: UseAdminCreateUserProps) =>
  useMutate<TypesUser, UsererrorError, void, OpenapiAdminUsersCreateRequest, void>('POST', `/admin/users`, {
    base: getConfig('api/v1'),
    ...props
  })

export type AdminDeleteUserProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const AdminDeleteUser = (props: AdminDeleteUserProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/admin/users`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseAdminDeleteUserProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const useAdminDeleteUser = (props: UseAdminDeleteUserProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/admin/users`, { base: getConfig('api/v1'), ...props })

export interface AdminGetUserPathParams {
  user_uid: string
}

export type AdminGetUserProps = Omit<GetProps<TypesUser, UsererrorError, void, AdminGetUserPathParams>, 'path'> &
  AdminGetUserPathParams

export const AdminGetUser = ({ user_uid, ...props }: AdminGetUserProps) => (
  <Get<TypesUser, UsererrorError, void, AdminGetUserPathParams>
    path={`/admin/users/${user_uid}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseAdminGetUserProps = Omit<UseGetProps<TypesUser, UsererrorError, void, AdminGetUserPathParams>, 'path'> &
  AdminGetUserPathParams

export const useAdminGetUser = ({ user_uid, ...props }: UseAdminGetUserProps) =>
  useGet<TypesUser, UsererrorError, void, AdminGetUserPathParams>(
    (paramsInPath: AdminGetUserPathParams) => `/admin/users/${paramsInPath.user_uid}`,
    { base: getConfig('api/v1'), pathParams: { user_uid }, ...props }
  )

export interface AdminUpdateUserPathParams {
  user_uid: string
}

export type AdminUpdateUserProps = Omit<
  MutateProps<TypesUser, UsererrorError, void, OpenapiAdminUsersUpdateRequest, AdminUpdateUserPathParams>,
  'path' | 'verb'
> &
  AdminUpdateUserPathParams

export const AdminUpdateUser = ({ user_uid, ...props }: AdminUpdateUserProps) => (
  <Mutate<TypesUser, UsererrorError, void, OpenapiAdminUsersUpdateRequest, AdminUpdateUserPathParams>
    verb="PATCH"
    path={`/admin/users/${user_uid}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseAdminUpdateUserProps = Omit<
  UseMutateProps<TypesUser, UsererrorError, void, OpenapiAdminUsersUpdateRequest, AdminUpdateUserPathParams>,
  'path' | 'verb'
> &
  AdminUpdateUserPathParams

export const useAdminUpdateUser = ({ user_uid, ...props }: UseAdminUpdateUserProps) =>
  useMutate<TypesUser, UsererrorError, void, OpenapiAdminUsersUpdateRequest, AdminUpdateUserPathParams>(
    'PATCH',
    (paramsInPath: AdminUpdateUserPathParams) => `/admin/users/${paramsInPath.user_uid}`,
    { base: getConfig('api/v1'), pathParams: { user_uid }, ...props }
  )

export interface UpdateUserAdminPathParams {
  user_uid: string
}

export type UpdateUserAdminProps = Omit<
  MutateProps<TypesUser, UsererrorError, void, OpenapiUpdateAdminRequest, UpdateUserAdminPathParams>,
  'path' | 'verb'
> &
  UpdateUserAdminPathParams

export const UpdateUserAdmin = ({ user_uid, ...props }: UpdateUserAdminProps) => (
  <Mutate<TypesUser, UsererrorError, void, OpenapiUpdateAdminRequest, UpdateUserAdminPathParams>
    verb="PATCH"
    path={`/admin/users/${user_uid}/admin`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateUserAdminProps = Omit<
  UseMutateProps<TypesUser, UsererrorError, void, OpenapiUpdateAdminRequest, UpdateUserAdminPathParams>,
  'path' | 'verb'
> &
  UpdateUserAdminPathParams

export const useUpdateUserAdmin = ({ user_uid, ...props }: UseUpdateUserAdminProps) =>
  useMutate<TypesUser, UsererrorError, void, OpenapiUpdateAdminRequest, UpdateUserAdminPathParams>(
    'PATCH',
    (paramsInPath: UpdateUserAdminPathParams) => `/admin/users/${paramsInPath.user_uid}/admin`,
    { base: getConfig('api/v1'), pathParams: { user_uid }, ...props }
  )

export type CreateConnectorProps = Omit<
  MutateProps<TypesConnector, UsererrorError, void, OpenapiCreateConnectorRequest, void>,
  'path' | 'verb'
>

export const CreateConnector = (props: CreateConnectorProps) => (
  <Mutate<TypesConnector, UsererrorError, void, OpenapiCreateConnectorRequest, void>
    verb="POST"
    path={`/connectors`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateConnectorProps = Omit<
  UseMutateProps<TypesConnector, UsererrorError, void, OpenapiCreateConnectorRequest, void>,
  'path' | 'verb'
>

export const useCreateConnector = (props: UseCreateConnectorProps) =>
  useMutate<TypesConnector, UsererrorError, void, OpenapiCreateConnectorRequest, void>('POST', `/connectors`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeleteConnectorProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const DeleteConnector = (props: DeleteConnectorProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/connectors`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteConnectorProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const useDeleteConnector = (props: UseDeleteConnectorProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/connectors`, { base: getConfig('api/v1'), ...props })

export interface FindConnectorPathParams {
  connector_ref: string
}

export type FindConnectorProps = Omit<GetProps<TypesConnector, UsererrorError, void, FindConnectorPathParams>, 'path'> &
  FindConnectorPathParams

export const FindConnector = ({ connector_ref, ...props }: FindConnectorProps) => (
  <Get<TypesConnector, UsererrorError, void, FindConnectorPathParams>
    path={`/connectors/${connector_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindConnectorProps = Omit<
  UseGetProps<TypesConnector, UsererrorError, void, FindConnectorPathParams>,
  'path'
> &
  FindConnectorPathParams

export const useFindConnector = ({ connector_ref, ...props }: UseFindConnectorProps) =>
  useGet<TypesConnector, UsererrorError, void, FindConnectorPathParams>(
    (paramsInPath: FindConnectorPathParams) => `/connectors/${paramsInPath.connector_ref}`,
    { base: getConfig('api/v1'), pathParams: { connector_ref }, ...props }
  )

export interface UpdateConnectorPathParams {
  connector_ref: string
}

export type UpdateConnectorProps = Omit<
  MutateProps<TypesConnector, UsererrorError, void, OpenapiUpdateConnectorRequest, UpdateConnectorPathParams>,
  'path' | 'verb'
> &
  UpdateConnectorPathParams

export const UpdateConnector = ({ connector_ref, ...props }: UpdateConnectorProps) => (
  <Mutate<TypesConnector, UsererrorError, void, OpenapiUpdateConnectorRequest, UpdateConnectorPathParams>
    verb="PATCH"
    path={`/connectors/${connector_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateConnectorProps = Omit<
  UseMutateProps<TypesConnector, UsererrorError, void, OpenapiUpdateConnectorRequest, UpdateConnectorPathParams>,
  'path' | 'verb'
> &
  UpdateConnectorPathParams

export const useUpdateConnector = ({ connector_ref, ...props }: UseUpdateConnectorProps) =>
  useMutate<TypesConnector, UsererrorError, void, OpenapiUpdateConnectorRequest, UpdateConnectorPathParams>(
    'PATCH',
    (paramsInPath: UpdateConnectorPathParams) => `/connectors/${paramsInPath.connector_ref}`,
    { base: getConfig('api/v1'), pathParams: { connector_ref }, ...props }
  )

export interface ListGitspacesQueryParams {
  sort?: 'id' | 'created' | 'updated'
  order?: 'asc' | 'desc'
  page?: number
  limit?: number
}

export type ListGitspacesProps = Omit<
  GetProps<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, void>,
  'path'
>

/**
 * List gitspaces
 */
export const ListGitspaces = (props: ListGitspacesProps) => (
  <Get<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, void>
    path={`/gitspaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListGitspacesProps = Omit<
  UseGetProps<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, void>,
  'path'
>

/**
 * List gitspaces
 */
export const useListGitspaces = (props: UseListGitspacesProps) =>
  useGet<TypesGitspaceConfig[], UsererrorError, ListGitspacesQueryParams, void>(`/gitspaces`, {
    base: getConfig('cde/api/v1'),
    ...props
  })

export type CreateGitspaceProps = Omit<
  MutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>,
  'path' | 'verb'
>

/**
 * Create gitspace config
 */
export const CreateGitspace = (props: CreateGitspaceProps) => (
  <Mutate<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>
    verb="POST"
    path={`/gitspaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateGitspaceProps = Omit<
  UseMutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>,
  'path' | 'verb'
>

/**
 * Create gitspace config
 */
export const useCreateGitspace = (props: UseCreateGitspaceProps) =>
  useMutate<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>('POST', `/gitspaces`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeleteGitspaceProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

/**
 * Delete gitspace config
 */
export const DeleteGitspace = (props: DeleteGitspaceProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/gitspaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteGitspaceProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

/**
 * Delete gitspace config
 */
export const useDeleteGitspace = (props: UseDeleteGitspaceProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/gitspaces`, { base: getConfig('api/v1'), ...props })

export interface FindGitspacePathParams {
  gitspace_identifier: string
}

export type FindGitspaceProps = Omit<
  GetProps<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>,
  'path'
> &
  FindGitspacePathParams

/**
 * Get gitspace
 */
export const FindGitspace = ({ gitspace_identifier, ...props }: FindGitspaceProps) => (
  <Get<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>
    path={`/gitspaces/${gitspace_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindGitspaceProps = Omit<
  UseGetProps<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>,
  'path'
> &
  FindGitspacePathParams

/**
 * Get gitspace
 */
export const useFindGitspace = ({ gitspace_identifier, ...props }: UseFindGitspaceProps) =>
  useGet<TypesGitspaceConfig, UsererrorError, void, FindGitspacePathParams>(
    (paramsInPath: FindGitspacePathParams) => `/gitspaces/${paramsInPath.gitspace_identifier}`,
    { base: getConfig('api/v1'), pathParams: { gitspace_identifier }, ...props }
  )

export interface ListGitspaceEventsQueryParams {
  page?: number
  limit?: number
}

export interface ListGitspaceEventsPathParams {
  gitspace_identifier: string
}

export type ListGitspaceEventsProps = Omit<
  GetProps<TypesGitspaceEventResponse[], UsererrorError, ListGitspaceEventsQueryParams, ListGitspaceEventsPathParams>,
  'path'
> &
  ListGitspaceEventsPathParams

/**
 * List gitspace events
 */
export const ListGitspaceEvents = ({ gitspace_identifier, ...props }: ListGitspaceEventsProps) => (
  <Get<TypesGitspaceEventResponse[], UsererrorError, ListGitspaceEventsQueryParams, ListGitspaceEventsPathParams>
    path={`/gitspaces/${gitspace_identifier}/events`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListGitspaceEventsProps = Omit<
  UseGetProps<
    TypesGitspaceEventResponse[],
    UsererrorError,
    ListGitspaceEventsQueryParams,
    ListGitspaceEventsPathParams
  >,
  'path'
> &
  ListGitspaceEventsPathParams

/**
 * List gitspace events
 */
export const useListGitspaceEvents = ({ gitspace_identifier, ...props }: UseListGitspaceEventsProps) =>
  useGet<TypesGitspaceEventResponse[], UsererrorError, ListGitspaceEventsQueryParams, ListGitspaceEventsPathParams>(
    (paramsInPath: ListGitspaceEventsPathParams) => `/gitspaces/${paramsInPath.gitspace_identifier}/events`,
    { base: getConfig('api/v1'), pathParams: { gitspace_identifier }, ...props }
  )

export interface OpStreamLogsPathParams {
  gitspace_identifier: string
}

export type OpStreamLogsProps = Omit<GetProps<LivelogLine[], UsererrorError, void, OpStreamLogsPathParams>, 'path'> &
  OpStreamLogsPathParams

export const OpStreamLogs = ({ gitspace_identifier, ...props }: OpStreamLogsProps) => (
  <Get<LivelogLine[], UsererrorError, void, OpStreamLogsPathParams>
    path={`/gitspaces/${gitspace_identifier}/logs/stream`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseOpStreamLogsProps = Omit<
  UseGetProps<LivelogLine[], UsererrorError, void, OpStreamLogsPathParams>,
  'path'
> &
  OpStreamLogsPathParams

export const useOpStreamLogs = ({ gitspace_identifier, ...props }: UseOpStreamLogsProps) =>
  useGet<LivelogLine[], UsererrorError, void, OpStreamLogsPathParams>(
    (paramsInPath: OpStreamLogsPathParams) => `/gitspaces/${paramsInPath.gitspace_identifier}/logs/stream`,
    { base: getConfig('api/v1'), pathParams: { gitspace_identifier }, ...props }
  )

export type GitspacelookupProps = Omit<
  MutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>,
  'path' | 'verb'
>

/**
 * Create gitspace config
 */
export const Gitspacelookup = (props: GitspacelookupProps) => (
  <Mutate<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>
    verb="POST"
    path={`/gitspaces/lookup-repo`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGitspacelookupProps = Omit<
  UseMutateProps<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>,
  'path' | 'verb'
>

/**
 * Create gitspace config
 */
export const useGitspacelookup = (props: UseGitspacelookupProps) =>
  useMutate<TypesGitspaceConfig, UsererrorError, void, OpenapiLookupRepoGitspaceRequest, void>(
    'POST',
    `/gitspaces/lookup-repo`,
    { base: getConfig('api/v1'), ...props }
  )

export type CreateInfraProviderProps = Omit<
  MutateProps<TypesInfraProviderConfig, UsererrorError, void, OpenapiCreateInfraProviderConfigRequest, void>,
  'path' | 'verb'
>

/**
 * Create infraProvider config
 */
export const CreateInfraProvider = (props: CreateInfraProviderProps) => (
  <Mutate<TypesInfraProviderConfig, UsererrorError, void, OpenapiCreateInfraProviderConfigRequest, void>
    verb="POST"
    path={`/infraproviders`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateInfraProviderProps = Omit<
  UseMutateProps<TypesInfraProviderConfig, UsererrorError, void, OpenapiCreateInfraProviderConfigRequest, void>,
  'path' | 'verb'
>

/**
 * Create infraProvider config
 */
export const useCreateInfraProvider = (props: UseCreateInfraProviderProps) =>
  useMutate<TypesInfraProviderConfig, UsererrorError, void, OpenapiCreateInfraProviderConfigRequest, void>(
    'POST',
    `/infraproviders`,
    { base: getConfig('api/v1'), ...props }
  )

export interface GetInfraProviderPathParams {
  infraprovider_identifier: string
}

export type GetInfraProviderProps = Omit<
  GetProps<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>,
  'path'
> &
  GetInfraProviderPathParams

/**
 * Get infraProviderConfig
 */
export const GetInfraProvider = ({ infraprovider_identifier, ...props }: GetInfraProviderProps) => (
  <Get<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>
    path={`/infraproviders/${infraprovider_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetInfraProviderProps = Omit<
  UseGetProps<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>,
  'path'
> &
  GetInfraProviderPathParams

/**
 * Get infraProviderConfig
 */
export const useGetInfraProvider = ({ infraprovider_identifier, ...props }: UseGetInfraProviderProps) =>
  useGet<TypesInfraProviderConfig, UsererrorError, void, GetInfraProviderPathParams>(
    (paramsInPath: GetInfraProviderPathParams) => `/infraproviders/${paramsInPath.infraprovider_identifier}`,
    { base: getConfig('api/v1'), pathParams: { infraprovider_identifier }, ...props }
  )

export interface OnLoginQueryParams {
  /**
   * If set to true the token is also returned as a cookie.
   */
  include_cookie?: boolean
}

export type OnLoginProps = Omit<
  MutateProps<TypesTokenResponse, UsererrorError, OnLoginQueryParams, OpenapiLoginRequest, void>,
  'path' | 'verb'
>

export const OnLogin = (props: OnLoginProps) => (
  <Mutate<TypesTokenResponse, UsererrorError, OnLoginQueryParams, OpenapiLoginRequest, void>
    verb="POST"
    path={`/login`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseOnLoginProps = Omit<
  UseMutateProps<TypesTokenResponse, UsererrorError, OnLoginQueryParams, OpenapiLoginRequest, void>,
  'path' | 'verb'
>

export const useOnLogin = (props: UseOnLoginProps) =>
  useMutate<TypesTokenResponse, UsererrorError, OnLoginQueryParams, OpenapiLoginRequest, void>('POST', `/login`, {
    base: getConfig('api/v1'),
    ...props
  })

export type OpLogoutProps = Omit<MutateProps<void, UsererrorError, void, void, void>, 'path' | 'verb'>

export const OpLogout = (props: OpLogoutProps) => (
  <Mutate<void, UsererrorError, void, void, void> verb="POST" path={`/logout`} base={getConfig('api/v1')} {...props} />
)

export type UseOpLogoutProps = Omit<UseMutateProps<void, UsererrorError, void, void, void>, 'path' | 'verb'>

export const useOpLogout = (props: UseOpLogoutProps) =>
  useMutate<void, UsererrorError, void, void, void>('POST', `/logout`, { base: getConfig('api/v1'), ...props })

export interface ListPluginsQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * The substring which is used to filter the plugins by their name.
   */
  query?: string
}

export type ListPluginsProps = Omit<GetProps<TypesPlugin[], UsererrorError, ListPluginsQueryParams, void>, 'path'>

export const ListPlugins = (props: ListPluginsProps) => (
  <Get<TypesPlugin[], UsererrorError, ListPluginsQueryParams, void>
    path={`/plugins`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPluginsProps = Omit<UseGetProps<TypesPlugin[], UsererrorError, ListPluginsQueryParams, void>, 'path'>

export const useListPlugins = (props: UseListPluginsProps) =>
  useGet<TypesPlugin[], UsererrorError, ListPluginsQueryParams, void>(`/plugins`, {
    base: getConfig('api/v1'),
    ...props
  })

export interface ListPrincipalsQueryParams {
  /**
   * The substring by which the principals are filtered.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * The types of principals to include.
   */
  type?: ('service' | 'serviceaccount' | 'user')[]
}

export type ListPrincipalsProps = Omit<
  GetProps<TypesPrincipalInfo[], UsererrorError, ListPrincipalsQueryParams, void>,
  'path'
>

export const ListPrincipals = (props: ListPrincipalsProps) => (
  <Get<TypesPrincipalInfo[], UsererrorError, ListPrincipalsQueryParams, void>
    path={`/principals`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPrincipalsProps = Omit<
  UseGetProps<TypesPrincipalInfo[], UsererrorError, ListPrincipalsQueryParams, void>,
  'path'
>

export const useListPrincipals = (props: UseListPrincipalsProps) =>
  useGet<TypesPrincipalInfo[], UsererrorError, ListPrincipalsQueryParams, void>(`/principals`, {
    base: getConfig('api/v1'),
    ...props
  })

export interface OnRegisterQueryParams {
  /**
   * If set to true the token is also returned as a cookie.
   */
  include_cookie?: boolean
}

export type OnRegisterProps = Omit<
  MutateProps<TypesTokenResponse, UsererrorError, OnRegisterQueryParams, OpenapiRegisterRequest, void>,
  'path' | 'verb'
>

export const OnRegister = (props: OnRegisterProps) => (
  <Mutate<TypesTokenResponse, UsererrorError, OnRegisterQueryParams, OpenapiRegisterRequest, void>
    verb="POST"
    path={`/register`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseOnRegisterProps = Omit<
  UseMutateProps<TypesTokenResponse, UsererrorError, OnRegisterQueryParams, OpenapiRegisterRequest, void>,
  'path' | 'verb'
>

export const useOnRegister = (props: UseOnRegisterProps) =>
  useMutate<TypesTokenResponse, UsererrorError, OnRegisterQueryParams, OpenapiRegisterRequest, void>(
    'POST',
    `/register`,
    { base: getConfig('api/v1'), ...props }
  )

export interface CreateRepositoryQueryParams {
  /**
   * path of parent space (Not needed in standalone).
   */
  space_path?: string
}

export type CreateRepositoryProps = Omit<
  MutateProps<RepoRepositoryOutput, UsererrorError, CreateRepositoryQueryParams, OpenapiCreateRepositoryRequest, void>,
  'path' | 'verb'
>

export const CreateRepository = (props: CreateRepositoryProps) => (
  <Mutate<RepoRepositoryOutput, UsererrorError, CreateRepositoryQueryParams, OpenapiCreateRepositoryRequest, void>
    verb="POST"
    path={`/repos`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateRepositoryProps = Omit<
  UseMutateProps<
    RepoRepositoryOutput,
    UsererrorError,
    CreateRepositoryQueryParams,
    OpenapiCreateRepositoryRequest,
    void
  >,
  'path' | 'verb'
>

export const useCreateRepository = (props: UseCreateRepositoryProps) =>
  useMutate<RepoRepositoryOutput, UsererrorError, CreateRepositoryQueryParams, OpenapiCreateRepositoryRequest, void>(
    'POST',
    `/repos`,
    { base: getConfig('api/v1'), ...props }
  )

export type DeleteRepositoryProps = Omit<
  MutateProps<RepoSoftDeleteResponse, UsererrorError, void, string, void>,
  'path' | 'verb'
>

export const DeleteRepository = (props: DeleteRepositoryProps) => (
  <Mutate<RepoSoftDeleteResponse, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/repos`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteRepositoryProps = Omit<
  UseMutateProps<RepoSoftDeleteResponse, UsererrorError, void, string, void>,
  'path' | 'verb'
>

export const useDeleteRepository = (props: UseDeleteRepositoryProps) =>
  useMutate<RepoSoftDeleteResponse, UsererrorError, void, string, void>('DELETE', `/repos`, {
    base: getConfig('api/v1'),
    ...props
  })

export interface FindRepositoryPathParams {
  repo_ref: string
}

export type FindRepositoryProps = Omit<
  GetProps<RepoRepositoryOutput, UsererrorError, void, FindRepositoryPathParams>,
  'path'
> &
  FindRepositoryPathParams

export const FindRepository = ({ repo_ref, ...props }: FindRepositoryProps) => (
  <Get<RepoRepositoryOutput, UsererrorError, void, FindRepositoryPathParams>
    path={`/repos/${repo_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindRepositoryProps = Omit<
  UseGetProps<RepoRepositoryOutput, UsererrorError, void, FindRepositoryPathParams>,
  'path'
> &
  FindRepositoryPathParams

export const useFindRepository = ({ repo_ref, ...props }: UseFindRepositoryProps) =>
  useGet<RepoRepositoryOutput, UsererrorError, void, FindRepositoryPathParams>(
    (paramsInPath: FindRepositoryPathParams) => `/repos/${paramsInPath.repo_ref}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface UpdateRepositoryPathParams {
  repo_ref: string
}

export type UpdateRepositoryProps = Omit<
  MutateProps<RepoRepositoryOutput, UsererrorError, void, OpenapiUpdateRepoRequest, UpdateRepositoryPathParams>,
  'path' | 'verb'
> &
  UpdateRepositoryPathParams

export const UpdateRepository = ({ repo_ref, ...props }: UpdateRepositoryProps) => (
  <Mutate<RepoRepositoryOutput, UsererrorError, void, OpenapiUpdateRepoRequest, UpdateRepositoryPathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateRepositoryProps = Omit<
  UseMutateProps<RepoRepositoryOutput, UsererrorError, void, OpenapiUpdateRepoRequest, UpdateRepositoryPathParams>,
  'path' | 'verb'
> &
  UpdateRepositoryPathParams

export const useUpdateRepository = ({ repo_ref, ...props }: UseUpdateRepositoryProps) =>
  useMutate<RepoRepositoryOutput, UsererrorError, void, OpenapiUpdateRepoRequest, UpdateRepositoryPathParams>(
    'PATCH',
    (paramsInPath: UpdateRepositoryPathParams) => `/repos/${paramsInPath.repo_ref}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface ArchiveQueryParams {
  /**
   * Without an optional path parameter, all files and subdirectories of the current working directory are included in the archive. If one or more paths are specified, only these are included.
   */
  path?: string[]
  /**
   * Prepend <prefix>/ to paths in the archive.
   */
  prefix?: string
  /**
   * Look for attributes in .gitattributes files in the working tree as well
   */
  attributes?: string
  /**
   * Set modification time of archive entries. Without this option the committer time is used if <tree-ish> is a commit or tag, and the current time if it is a tree.
   */
  time?: string
  /**
   * Specify compression level. Larger values allow the command to spend more time to compress to smaller size.
   */
  compression?: number
}

export interface ArchivePathParams {
  repo_ref: string
  git_ref: string
  format: string
}

export type ArchiveProps = Omit<GetProps<void, UsererrorError, ArchiveQueryParams, ArchivePathParams>, 'path'> &
  ArchivePathParams

export const Archive = ({ repo_ref, git_ref, format, ...props }: ArchiveProps) => (
  <Get<void, UsererrorError, ArchiveQueryParams, ArchivePathParams>
    path={`/repos/${repo_ref}/archive/${git_ref}.${format}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseArchiveProps = Omit<UseGetProps<void, UsererrorError, ArchiveQueryParams, ArchivePathParams>, 'path'> &
  ArchivePathParams

export const useArchive = ({ repo_ref, git_ref, format, ...props }: UseArchiveProps) =>
  useGet<void, UsererrorError, ArchiveQueryParams, ArchivePathParams>(
    (paramsInPath: ArchivePathParams) =>
      `/repos/${paramsInPath.repo_ref}/archive/${paramsInPath.git_ref}.${paramsInPath.format}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, git_ref, format }, ...props }
  )

export interface GetBlameQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
  /**
   * Line number from which the file data is considered
   */
  line_from?: number
  /**
   * Line number to which the file data is considered
   */
  line_to?: number
}

export interface GetBlamePathParams {
  repo_ref: string
  path: string
}

export type GetBlameProps = Omit<
  GetProps<GitBlamePart[], UsererrorError, GetBlameQueryParams, GetBlamePathParams>,
  'path'
> &
  GetBlamePathParams

export const GetBlame = ({ repo_ref, path, ...props }: GetBlameProps) => (
  <Get<GitBlamePart[], UsererrorError, GetBlameQueryParams, GetBlamePathParams>
    path={`/repos/${repo_ref}/blame/${path}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetBlameProps = Omit<
  UseGetProps<GitBlamePart[], UsererrorError, GetBlameQueryParams, GetBlamePathParams>,
  'path'
> &
  GetBlamePathParams

export const useGetBlame = ({ repo_ref, path, ...props }: UseGetBlameProps) =>
  useGet<GitBlamePart[], UsererrorError, GetBlameQueryParams, GetBlamePathParams>(
    (paramsInPath: GetBlamePathParams) => `/repos/${paramsInPath.repo_ref}/blame/${paramsInPath.path}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, path }, ...props }
  )

export interface ListBranchesQueryParams {
  /**
   * Indicates whether optional commit information should be included in the response.
   */
  include_commit?: boolean
  /**
   * The substring by which the branches are filtered.
   */
  query?: string
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The data by which the branches are sorted.
   */
  sort?: 'name' | 'date'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListBranchesPathParams {
  repo_ref: string
}

export type ListBranchesProps = Omit<
  GetProps<RepoBranch[], UsererrorError, ListBranchesQueryParams, ListBranchesPathParams>,
  'path'
> &
  ListBranchesPathParams

export const ListBranches = ({ repo_ref, ...props }: ListBranchesProps) => (
  <Get<RepoBranch[], UsererrorError, ListBranchesQueryParams, ListBranchesPathParams>
    path={`/repos/${repo_ref}/branches`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListBranchesProps = Omit<
  UseGetProps<RepoBranch[], UsererrorError, ListBranchesQueryParams, ListBranchesPathParams>,
  'path'
> &
  ListBranchesPathParams

export const useListBranches = ({ repo_ref, ...props }: UseListBranchesProps) =>
  useGet<RepoBranch[], UsererrorError, ListBranchesQueryParams, ListBranchesPathParams>(
    (paramsInPath: ListBranchesPathParams) => `/repos/${paramsInPath.repo_ref}/branches`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CreateBranchPathParams {
  repo_ref: string
}

export type CreateBranchProps = Omit<
  MutateProps<
    RepoBranch,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCreateBranchRequest,
    CreateBranchPathParams
  >,
  'path' | 'verb'
> &
  CreateBranchPathParams

export const CreateBranch = ({ repo_ref, ...props }: CreateBranchProps) => (
  <Mutate<RepoBranch, UsererrorError | TypesRulesViolations, void, OpenapiCreateBranchRequest, CreateBranchPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/branches`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateBranchProps = Omit<
  UseMutateProps<
    RepoBranch,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCreateBranchRequest,
    CreateBranchPathParams
  >,
  'path' | 'verb'
> &
  CreateBranchPathParams

export const useCreateBranch = ({ repo_ref, ...props }: UseCreateBranchProps) =>
  useMutate<
    RepoBranch,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCreateBranchRequest,
    CreateBranchPathParams
  >('POST', (paramsInPath: CreateBranchPathParams) => `/repos/${paramsInPath.repo_ref}/branches`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface DeleteBranchQueryParams {
  /**
   * Bypass rule violations if possible.
   */
  bypass_rules?: boolean
}

export interface DeleteBranchPathParams {
  repo_ref: string
}

export type DeleteBranchProps = Omit<
  MutateProps<void, UsererrorError | TypesRulesViolations, DeleteBranchQueryParams, string, DeleteBranchPathParams>,
  'path' | 'verb'
> &
  DeleteBranchPathParams

export const DeleteBranch = ({ repo_ref, ...props }: DeleteBranchProps) => (
  <Mutate<void, UsererrorError | TypesRulesViolations, DeleteBranchQueryParams, string, DeleteBranchPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/branches`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteBranchProps = Omit<
  UseMutateProps<void, UsererrorError | TypesRulesViolations, DeleteBranchQueryParams, string, DeleteBranchPathParams>,
  'path' | 'verb'
> &
  DeleteBranchPathParams

export const useDeleteBranch = ({ repo_ref, ...props }: UseDeleteBranchProps) =>
  useMutate<void, UsererrorError | TypesRulesViolations, DeleteBranchQueryParams, string, DeleteBranchPathParams>(
    'DELETE',
    (paramsInPath: DeleteBranchPathParams) => `/repos/${paramsInPath.repo_ref}/branches`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface GetBranchPathParams {
  repo_ref: string
  branch_name: string
}

export type GetBranchProps = Omit<GetProps<RepoBranch, UsererrorError, void, GetBranchPathParams>, 'path'> &
  GetBranchPathParams

export const GetBranch = ({ repo_ref, branch_name, ...props }: GetBranchProps) => (
  <Get<RepoBranch, UsererrorError, void, GetBranchPathParams>
    path={`/repos/${repo_ref}/branches/${branch_name}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetBranchProps = Omit<UseGetProps<RepoBranch, UsererrorError, void, GetBranchPathParams>, 'path'> &
  GetBranchPathParams

export const useGetBranch = ({ repo_ref, branch_name, ...props }: UseGetBranchProps) =>
  useGet<RepoBranch, UsererrorError, void, GetBranchPathParams>(
    (paramsInPath: GetBranchPathParams) => `/repos/${paramsInPath.repo_ref}/branches/${paramsInPath.branch_name}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, branch_name }, ...props }
  )

export interface ListStatusCheckResultsQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * The substring which is used to filter the status checks by their Identifier.
   */
  query?: string
}

export interface ListStatusCheckResultsPathParams {
  repo_ref: string
  commit_sha: string
}

export type ListStatusCheckResultsProps = Omit<
  GetProps<TypesCheck[], UsererrorError, ListStatusCheckResultsQueryParams, ListStatusCheckResultsPathParams>,
  'path'
> &
  ListStatusCheckResultsPathParams

export const ListStatusCheckResults = ({ repo_ref, commit_sha, ...props }: ListStatusCheckResultsProps) => (
  <Get<TypesCheck[], UsererrorError, ListStatusCheckResultsQueryParams, ListStatusCheckResultsPathParams>
    path={`/repos/${repo_ref}/checks/commits/${commit_sha}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListStatusCheckResultsProps = Omit<
  UseGetProps<TypesCheck[], UsererrorError, ListStatusCheckResultsQueryParams, ListStatusCheckResultsPathParams>,
  'path'
> &
  ListStatusCheckResultsPathParams

export const useListStatusCheckResults = ({ repo_ref, commit_sha, ...props }: UseListStatusCheckResultsProps) =>
  useGet<TypesCheck[], UsererrorError, ListStatusCheckResultsQueryParams, ListStatusCheckResultsPathParams>(
    (paramsInPath: ListStatusCheckResultsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/checks/commits/${paramsInPath.commit_sha}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, commit_sha }, ...props }
  )

export interface ReportStatusCheckResultsPathParams {
  repo_ref: string
  commit_sha: string
}

export interface ReportStatusCheckResultsRequestBody {
  check_uid?: string
  ended?: number
  identifier?: string
  link?: string
  payload?: TypesCheckPayload
  started?: number
  status?: EnumCheckStatus
  summary?: string
}

export type ReportStatusCheckResultsProps = Omit<
  MutateProps<
    TypesCheck,
    UsererrorError,
    void,
    ReportStatusCheckResultsRequestBody,
    ReportStatusCheckResultsPathParams
  >,
  'path' | 'verb'
> &
  ReportStatusCheckResultsPathParams

export const ReportStatusCheckResults = ({ repo_ref, commit_sha, ...props }: ReportStatusCheckResultsProps) => (
  <Mutate<TypesCheck, UsererrorError, void, ReportStatusCheckResultsRequestBody, ReportStatusCheckResultsPathParams>
    verb="PUT"
    path={`/repos/${repo_ref}/checks/commits/${commit_sha}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseReportStatusCheckResultsProps = Omit<
  UseMutateProps<
    TypesCheck,
    UsererrorError,
    void,
    ReportStatusCheckResultsRequestBody,
    ReportStatusCheckResultsPathParams
  >,
  'path' | 'verb'
> &
  ReportStatusCheckResultsPathParams

export const useReportStatusCheckResults = ({ repo_ref, commit_sha, ...props }: UseReportStatusCheckResultsProps) =>
  useMutate<TypesCheck, UsererrorError, void, ReportStatusCheckResultsRequestBody, ReportStatusCheckResultsPathParams>(
    'PUT',
    (paramsInPath: ReportStatusCheckResultsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/checks/commits/${paramsInPath.commit_sha}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, commit_sha }, ...props }
  )

export interface ListStatusCheckRecentQueryParams {
  /**
   * The substring which is used to filter the status checks by their Identifier.
   */
  query?: string
  /**
   * The timestamp (in Unix time millis) since the status checks have been run.
   */
  since?: number
}

export interface ListStatusCheckRecentPathParams {
  repo_ref: string
}

export type ListStatusCheckRecentProps = Omit<
  GetProps<string[], UsererrorError, ListStatusCheckRecentQueryParams, ListStatusCheckRecentPathParams>,
  'path'
> &
  ListStatusCheckRecentPathParams

export const ListStatusCheckRecent = ({ repo_ref, ...props }: ListStatusCheckRecentProps) => (
  <Get<string[], UsererrorError, ListStatusCheckRecentQueryParams, ListStatusCheckRecentPathParams>
    path={`/repos/${repo_ref}/checks/recent`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListStatusCheckRecentProps = Omit<
  UseGetProps<string[], UsererrorError, ListStatusCheckRecentQueryParams, ListStatusCheckRecentPathParams>,
  'path'
> &
  ListStatusCheckRecentPathParams

export const useListStatusCheckRecent = ({ repo_ref, ...props }: UseListStatusCheckRecentProps) =>
  useGet<string[], UsererrorError, ListStatusCheckRecentQueryParams, ListStatusCheckRecentPathParams>(
    (paramsInPath: ListStatusCheckRecentPathParams) => `/repos/${paramsInPath.repo_ref}/checks/recent`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CodeOwnersValidateQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
}

export interface CodeOwnersValidatePathParams {
  repo_ref: string
}

export type CodeOwnersValidateProps = Omit<
  GetProps<void, UsererrorError, CodeOwnersValidateQueryParams, CodeOwnersValidatePathParams>,
  'path'
> &
  CodeOwnersValidatePathParams

export const CodeOwnersValidate = ({ repo_ref, ...props }: CodeOwnersValidateProps) => (
  <Get<void, UsererrorError, CodeOwnersValidateQueryParams, CodeOwnersValidatePathParams>
    path={`/repos/${repo_ref}/codeowners/validate`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCodeOwnersValidateProps = Omit<
  UseGetProps<void, UsererrorError, CodeOwnersValidateQueryParams, CodeOwnersValidatePathParams>,
  'path'
> &
  CodeOwnersValidatePathParams

export const useCodeOwnersValidate = ({ repo_ref, ...props }: UseCodeOwnersValidateProps) =>
  useGet<void, UsererrorError, CodeOwnersValidateQueryParams, CodeOwnersValidatePathParams>(
    (paramsInPath: CodeOwnersValidatePathParams) => `/repos/${paramsInPath.repo_ref}/codeowners/validate`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface ListCommitsQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
  /**
   * The result should only contain commits that occurred after the provided reference.
   */
  after?: string
  /**
   * Path for which commit information should be retrieved
   */
  path?: string
  /**
   * Epoch since when commit information should be retrieved.
   */
  since?: number
  /**
   * Epoch until when commit information should be retrieved.
   */
  until?: number
  /**
   * Committer pattern for which commit information should be retrieved.
   */
  committer?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * Indicates whether optional stats should be included in the response.
   */
  include_stats?: boolean
}

export interface ListCommitsPathParams {
  repo_ref: string
}

export type ListCommitsProps = Omit<
  GetProps<TypesListCommitResponse[], UsererrorError, ListCommitsQueryParams, ListCommitsPathParams>,
  'path'
> &
  ListCommitsPathParams

export const ListCommits = ({ repo_ref, ...props }: ListCommitsProps) => (
  <Get<TypesListCommitResponse[], UsererrorError, ListCommitsQueryParams, ListCommitsPathParams>
    path={`/repos/${repo_ref}/commits`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListCommitsProps = Omit<
  UseGetProps<TypesListCommitResponse[], UsererrorError, ListCommitsQueryParams, ListCommitsPathParams>,
  'path'
> &
  ListCommitsPathParams

export const useListCommits = ({ repo_ref, ...props }: UseListCommitsProps) =>
  useGet<TypesListCommitResponse[], UsererrorError, ListCommitsQueryParams, ListCommitsPathParams>(
    (paramsInPath: ListCommitsPathParams) => `/repos/${paramsInPath.repo_ref}/commits`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CommitFilesPathParams {
  repo_ref: string
}

export type CommitFilesProps = Omit<
  MutateProps<
    TypesCommitFilesResponse,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommitFilesRequest,
    CommitFilesPathParams
  >,
  'path' | 'verb'
> &
  CommitFilesPathParams

export const CommitFiles = ({ repo_ref, ...props }: CommitFilesProps) => (
  <Mutate<
    TypesCommitFilesResponse,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommitFilesRequest,
    CommitFilesPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/commits`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommitFilesProps = Omit<
  UseMutateProps<
    TypesCommitFilesResponse,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommitFilesRequest,
    CommitFilesPathParams
  >,
  'path' | 'verb'
> &
  CommitFilesPathParams

export const useCommitFiles = ({ repo_ref, ...props }: UseCommitFilesProps) =>
  useMutate<
    TypesCommitFilesResponse,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommitFilesRequest,
    CommitFilesPathParams
  >('POST', (paramsInPath: CommitFilesPathParams) => `/repos/${paramsInPath.repo_ref}/commits`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface GetCommitPathParams {
  repo_ref: string
  commit_sha: string
}

export type GetCommitProps = Omit<GetProps<TypesCommit, UsererrorError, void, GetCommitPathParams>, 'path'> &
  GetCommitPathParams

export const GetCommit = ({ repo_ref, commit_sha, ...props }: GetCommitProps) => (
  <Get<TypesCommit, UsererrorError, void, GetCommitPathParams>
    path={`/repos/${repo_ref}/commits/${commit_sha}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetCommitProps = Omit<UseGetProps<TypesCommit, UsererrorError, void, GetCommitPathParams>, 'path'> &
  GetCommitPathParams

export const useGetCommit = ({ repo_ref, commit_sha, ...props }: UseGetCommitProps) =>
  useGet<TypesCommit, UsererrorError, void, GetCommitPathParams>(
    (paramsInPath: GetCommitPathParams) => `/repos/${paramsInPath.repo_ref}/commits/${paramsInPath.commit_sha}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, commit_sha }, ...props }
  )

export interface GetCommitDiffPathParams {
  repo_ref: string
  commit_sha: string
}

export type GetCommitDiffProps = Omit<GetProps<void, UsererrorError, void, GetCommitDiffPathParams>, 'path'> &
  GetCommitDiffPathParams

export const GetCommitDiff = ({ repo_ref, commit_sha, ...props }: GetCommitDiffProps) => (
  <Get<void, UsererrorError, void, GetCommitDiffPathParams>
    path={`/repos/${repo_ref}/commits/${commit_sha}/diff`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetCommitDiffProps = Omit<UseGetProps<void, UsererrorError, void, GetCommitDiffPathParams>, 'path'> &
  GetCommitDiffPathParams

export const useGetCommitDiff = ({ repo_ref, commit_sha, ...props }: UseGetCommitDiffProps) =>
  useGet<void, UsererrorError, void, GetCommitDiffPathParams>(
    (paramsInPath: GetCommitDiffPathParams) =>
      `/repos/${paramsInPath.repo_ref}/commits/${paramsInPath.commit_sha}/diff`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, commit_sha }, ...props }
  )

export interface CalculateCommitDivergencePathParams {
  repo_ref: string
}

export type CalculateCommitDivergenceProps = Omit<
  MutateProps<
    RepoCommitDivergence[],
    UsererrorError,
    void,
    OpenapiCalculateCommitDivergenceRequest,
    CalculateCommitDivergencePathParams
  >,
  'path' | 'verb'
> &
  CalculateCommitDivergencePathParams

export const CalculateCommitDivergence = ({ repo_ref, ...props }: CalculateCommitDivergenceProps) => (
  <Mutate<
    RepoCommitDivergence[],
    UsererrorError,
    void,
    OpenapiCalculateCommitDivergenceRequest,
    CalculateCommitDivergencePathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/commits/calculate-divergence`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCalculateCommitDivergenceProps = Omit<
  UseMutateProps<
    RepoCommitDivergence[],
    UsererrorError,
    void,
    OpenapiCalculateCommitDivergenceRequest,
    CalculateCommitDivergencePathParams
  >,
  'path' | 'verb'
> &
  CalculateCommitDivergencePathParams

export const useCalculateCommitDivergence = ({ repo_ref, ...props }: UseCalculateCommitDivergenceProps) =>
  useMutate<
    RepoCommitDivergence[],
    UsererrorError,
    void,
    OpenapiCalculateCommitDivergenceRequest,
    CalculateCommitDivergencePathParams
  >(
    'POST',
    (paramsInPath: CalculateCommitDivergencePathParams) =>
      `/repos/${paramsInPath.repo_ref}/commits/calculate-divergence`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface GetContentQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
  /**
   * Indicates whether optional commit information should be included in the response.
   */
  include_commit?: boolean
}

export interface GetContentPathParams {
  repo_ref: string
  path: string
}

export type GetContentProps = Omit<
  GetProps<OpenapiGetContentOutput, UsererrorError, GetContentQueryParams, GetContentPathParams>,
  'path'
> &
  GetContentPathParams

export const GetContent = ({ repo_ref, path, ...props }: GetContentProps) => (
  <Get<OpenapiGetContentOutput, UsererrorError, GetContentQueryParams, GetContentPathParams>
    path={`/repos/${repo_ref}/content/${path}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetContentProps = Omit<
  UseGetProps<OpenapiGetContentOutput, UsererrorError, GetContentQueryParams, GetContentPathParams>,
  'path'
> &
  GetContentPathParams

export const useGetContent = ({ repo_ref, path, ...props }: UseGetContentProps) =>
  useGet<OpenapiGetContentOutput, UsererrorError, GetContentQueryParams, GetContentPathParams>(
    (paramsInPath: GetContentPathParams) => `/repos/${paramsInPath.repo_ref}/content/${paramsInPath.path}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, path }, ...props }
  )

export interface DiffStatsQueryParams {
  /**
   * provide path for diff operation
   */
  path?: string[]
}

export interface DiffStatsPathParams {
  repo_ref: string
  range: string
}

export type DiffStatsProps = Omit<
  GetProps<TypesDiffStats, UsererrorError, DiffStatsQueryParams, DiffStatsPathParams>,
  'path'
> &
  DiffStatsPathParams

export const DiffStats = ({ repo_ref, range, ...props }: DiffStatsProps) => (
  <Get<TypesDiffStats, UsererrorError, DiffStatsQueryParams, DiffStatsPathParams>
    path={`/repos/${repo_ref}/diff-stats/${range}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDiffStatsProps = Omit<
  UseGetProps<TypesDiffStats, UsererrorError, DiffStatsQueryParams, DiffStatsPathParams>,
  'path'
> &
  DiffStatsPathParams

export const useDiffStats = ({ repo_ref, range, ...props }: UseDiffStatsProps) =>
  useGet<TypesDiffStats, UsererrorError, DiffStatsQueryParams, DiffStatsPathParams>(
    (paramsInPath: DiffStatsPathParams) => `/repos/${paramsInPath.repo_ref}/diff-stats/${paramsInPath.range}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, range }, ...props }
  )

export interface RawDiffQueryParams {
  /**
   * provide path for diff operation
   */
  path?: string[]
}

export interface RawDiffPathParams {
  repo_ref: string
  range: string
}

export type RawDiffProps = Omit<
  GetProps<GitFileDiff[], UsererrorError, RawDiffQueryParams, RawDiffPathParams>,
  'path'
> &
  RawDiffPathParams

export const RawDiff = ({ repo_ref, range, ...props }: RawDiffProps) => (
  <Get<GitFileDiff[], UsererrorError, RawDiffQueryParams, RawDiffPathParams>
    path={`/repos/${repo_ref}/diff/${range}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRawDiffProps = Omit<
  UseGetProps<GitFileDiff[], UsererrorError, RawDiffQueryParams, RawDiffPathParams>,
  'path'
> &
  RawDiffPathParams

export const useRawDiff = ({ repo_ref, range, ...props }: UseRawDiffProps) =>
  useGet<GitFileDiff[], UsererrorError, RawDiffQueryParams, RawDiffPathParams>(
    (paramsInPath: RawDiffPathParams) => `/repos/${paramsInPath.repo_ref}/diff/${paramsInPath.range}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, range }, ...props }
  )

export interface RawDiffPostPathParams {
  repo_ref: string
  range: string
}

export type RawDiffPostProps = Omit<
  MutateProps<GitFileDiff[], UsererrorError, void, OpenapiPostRawDiffRequest, RawDiffPostPathParams>,
  'path' | 'verb'
> &
  RawDiffPostPathParams

export const RawDiffPost = ({ repo_ref, range, ...props }: RawDiffPostProps) => (
  <Mutate<GitFileDiff[], UsererrorError, void, OpenapiPostRawDiffRequest, RawDiffPostPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/diff/${range}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRawDiffPostProps = Omit<
  UseMutateProps<GitFileDiff[], UsererrorError, void, OpenapiPostRawDiffRequest, RawDiffPostPathParams>,
  'path' | 'verb'
> &
  RawDiffPostPathParams

export const useRawDiffPost = ({ repo_ref, range, ...props }: UseRawDiffPostProps) =>
  useMutate<GitFileDiff[], UsererrorError, void, OpenapiPostRawDiffRequest, RawDiffPostPathParams>(
    'POST',
    (paramsInPath: RawDiffPostPathParams) => `/repos/${paramsInPath.repo_ref}/diff/${paramsInPath.range}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, range }, ...props }
  )

export interface MergeCheckQueryParams {
  /**
   * provide path for diff operation
   */
  path?: string[]
}

export interface MergeCheckPathParams {
  repo_ref: string
  range: string
}

export type MergeCheckProps = Omit<
  MutateProps<RepoMergeCheck, UsererrorError, MergeCheckQueryParams, void, MergeCheckPathParams>,
  'path' | 'verb'
> &
  MergeCheckPathParams

export const MergeCheck = ({ repo_ref, range, ...props }: MergeCheckProps) => (
  <Mutate<RepoMergeCheck, UsererrorError, MergeCheckQueryParams, void, MergeCheckPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/merge-check/${range}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMergeCheckProps = Omit<
  UseMutateProps<RepoMergeCheck, UsererrorError, MergeCheckQueryParams, void, MergeCheckPathParams>,
  'path' | 'verb'
> &
  MergeCheckPathParams

export const useMergeCheck = ({ repo_ref, range, ...props }: UseMergeCheckProps) =>
  useMutate<RepoMergeCheck, UsererrorError, MergeCheckQueryParams, void, MergeCheckPathParams>(
    'POST',
    (paramsInPath: MergeCheckPathParams) => `/repos/${paramsInPath.repo_ref}/merge-check/${paramsInPath.range}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, range }, ...props }
  )

export interface MoveRepositoryPathParams {
  repo_ref: string
}

export type MoveRepositoryProps = Omit<
  MutateProps<RepoRepositoryOutput, UsererrorError, void, OpenapiMoveRepoRequest, MoveRepositoryPathParams>,
  'path' | 'verb'
> &
  MoveRepositoryPathParams

export const MoveRepository = ({ repo_ref, ...props }: MoveRepositoryProps) => (
  <Mutate<RepoRepositoryOutput, UsererrorError, void, OpenapiMoveRepoRequest, MoveRepositoryPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/move`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMoveRepositoryProps = Omit<
  UseMutateProps<RepoRepositoryOutput, UsererrorError, void, OpenapiMoveRepoRequest, MoveRepositoryPathParams>,
  'path' | 'verb'
> &
  MoveRepositoryPathParams

export const useMoveRepository = ({ repo_ref, ...props }: UseMoveRepositoryProps) =>
  useMutate<RepoRepositoryOutput, UsererrorError, void, OpenapiMoveRepoRequest, MoveRepositoryPathParams>(
    'POST',
    (paramsInPath: MoveRepositoryPathParams) => `/repos/${paramsInPath.repo_ref}/move`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface PathDetailsQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
}

export interface PathDetailsPathParams {
  repo_ref: string
}

export type PathDetailsProps = Omit<
  MutateProps<
    RepoPathsDetailsOutput,
    UsererrorError,
    PathDetailsQueryParams,
    OpenapiPathsDetailsRequest,
    PathDetailsPathParams
  >,
  'path' | 'verb'
> &
  PathDetailsPathParams

export const PathDetails = ({ repo_ref, ...props }: PathDetailsProps) => (
  <Mutate<
    RepoPathsDetailsOutput,
    UsererrorError,
    PathDetailsQueryParams,
    OpenapiPathsDetailsRequest,
    PathDetailsPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/path-details`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UsePathDetailsProps = Omit<
  UseMutateProps<
    RepoPathsDetailsOutput,
    UsererrorError,
    PathDetailsQueryParams,
    OpenapiPathsDetailsRequest,
    PathDetailsPathParams
  >,
  'path' | 'verb'
> &
  PathDetailsPathParams

export const usePathDetails = ({ repo_ref, ...props }: UsePathDetailsProps) =>
  useMutate<
    RepoPathsDetailsOutput,
    UsererrorError,
    PathDetailsQueryParams,
    OpenapiPathsDetailsRequest,
    PathDetailsPathParams
  >('POST', (paramsInPath: PathDetailsPathParams) => `/repos/${paramsInPath.repo_ref}/path-details`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface ListPathsQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
  /**
   * Indicates whether directories should be included in the response.
   */
  include_directories?: boolean
}

export interface ListPathsPathParams {
  repo_ref: string
}

export type ListPathsProps = Omit<
  GetProps<RepoListPathsOutput, UsererrorError, ListPathsQueryParams, ListPathsPathParams>,
  'path'
> &
  ListPathsPathParams

export const ListPaths = ({ repo_ref, ...props }: ListPathsProps) => (
  <Get<RepoListPathsOutput, UsererrorError, ListPathsQueryParams, ListPathsPathParams>
    path={`/repos/${repo_ref}/paths`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPathsProps = Omit<
  UseGetProps<RepoListPathsOutput, UsererrorError, ListPathsQueryParams, ListPathsPathParams>,
  'path'
> &
  ListPathsPathParams

export const useListPaths = ({ repo_ref, ...props }: UseListPathsProps) =>
  useGet<RepoListPathsOutput, UsererrorError, ListPathsQueryParams, ListPathsPathParams>(
    (paramsInPath: ListPathsPathParams) => `/repos/${paramsInPath.repo_ref}/paths`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface ListPipelinesQueryParams {
  /**
   * The substring which is used to filter the repositories by their path name.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * Whether to fetch latest build information for each pipeline.
   */
  latest?: boolean
}

export interface ListPipelinesPathParams {
  repo_ref: string
}

export type ListPipelinesProps = Omit<
  GetProps<TypesPipeline[], UsererrorError, ListPipelinesQueryParams, ListPipelinesPathParams>,
  'path'
> &
  ListPipelinesPathParams

export const ListPipelines = ({ repo_ref, ...props }: ListPipelinesProps) => (
  <Get<TypesPipeline[], UsererrorError, ListPipelinesQueryParams, ListPipelinesPathParams>
    path={`/repos/${repo_ref}/pipelines`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPipelinesProps = Omit<
  UseGetProps<TypesPipeline[], UsererrorError, ListPipelinesQueryParams, ListPipelinesPathParams>,
  'path'
> &
  ListPipelinesPathParams

export const useListPipelines = ({ repo_ref, ...props }: UseListPipelinesProps) =>
  useGet<TypesPipeline[], UsererrorError, ListPipelinesQueryParams, ListPipelinesPathParams>(
    (paramsInPath: ListPipelinesPathParams) => `/repos/${paramsInPath.repo_ref}/pipelines`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CreatePipelinePathParams {
  repo_ref: string
}

export type CreatePipelineProps = Omit<
  MutateProps<TypesPipeline, UsererrorError, void, OpenapiCreatePipelineRequest, CreatePipelinePathParams>,
  'path' | 'verb'
> &
  CreatePipelinePathParams

export const CreatePipeline = ({ repo_ref, ...props }: CreatePipelineProps) => (
  <Mutate<TypesPipeline, UsererrorError, void, OpenapiCreatePipelineRequest, CreatePipelinePathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pipelines`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreatePipelineProps = Omit<
  UseMutateProps<TypesPipeline, UsererrorError, void, OpenapiCreatePipelineRequest, CreatePipelinePathParams>,
  'path' | 'verb'
> &
  CreatePipelinePathParams

export const useCreatePipeline = ({ repo_ref, ...props }: UseCreatePipelineProps) =>
  useMutate<TypesPipeline, UsererrorError, void, OpenapiCreatePipelineRequest, CreatePipelinePathParams>(
    'POST',
    (paramsInPath: CreatePipelinePathParams) => `/repos/${paramsInPath.repo_ref}/pipelines`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface DeletePipelinePathParams {
  repo_ref: string
}

export type DeletePipelineProps = Omit<
  MutateProps<void, UsererrorError, void, string, DeletePipelinePathParams>,
  'path' | 'verb'
> &
  DeletePipelinePathParams

export const DeletePipeline = ({ repo_ref, ...props }: DeletePipelineProps) => (
  <Mutate<void, UsererrorError, void, string, DeletePipelinePathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pipelines`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeletePipelineProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, DeletePipelinePathParams>,
  'path' | 'verb'
> &
  DeletePipelinePathParams

export const useDeletePipeline = ({ repo_ref, ...props }: UseDeletePipelineProps) =>
  useMutate<void, UsererrorError, void, string, DeletePipelinePathParams>(
    'DELETE',
    (paramsInPath: DeletePipelinePathParams) => `/repos/${paramsInPath.repo_ref}/pipelines`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface FindPipelinePathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type FindPipelineProps = Omit<GetProps<TypesPipeline, UsererrorError, void, FindPipelinePathParams>, 'path'> &
  FindPipelinePathParams

export const FindPipeline = ({ repo_ref, pipeline_identifier, ...props }: FindPipelineProps) => (
  <Get<TypesPipeline, UsererrorError, void, FindPipelinePathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindPipelineProps = Omit<
  UseGetProps<TypesPipeline, UsererrorError, void, FindPipelinePathParams>,
  'path'
> &
  FindPipelinePathParams

export const useFindPipeline = ({ repo_ref, pipeline_identifier, ...props }: UseFindPipelineProps) =>
  useGet<TypesPipeline, UsererrorError, void, FindPipelinePathParams>(
    (paramsInPath: FindPipelinePathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface UpdatePipelinePathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type UpdatePipelineProps = Omit<
  MutateProps<TypesPipeline, UsererrorError, void, OpenapiUpdatePipelineRequest, UpdatePipelinePathParams>,
  'path' | 'verb'
> &
  UpdatePipelinePathParams

export const UpdatePipeline = ({ repo_ref, pipeline_identifier, ...props }: UpdatePipelineProps) => (
  <Mutate<TypesPipeline, UsererrorError, void, OpenapiUpdatePipelineRequest, UpdatePipelinePathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdatePipelineProps = Omit<
  UseMutateProps<TypesPipeline, UsererrorError, void, OpenapiUpdatePipelineRequest, UpdatePipelinePathParams>,
  'path' | 'verb'
> &
  UpdatePipelinePathParams

export const useUpdatePipeline = ({ repo_ref, pipeline_identifier, ...props }: UseUpdatePipelineProps) =>
  useMutate<TypesPipeline, UsererrorError, void, OpenapiUpdatePipelineRequest, UpdatePipelinePathParams>(
    'PATCH',
    (paramsInPath: UpdatePipelinePathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface ListExecutionsQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListExecutionsPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type ListExecutionsProps = Omit<
  GetProps<TypesExecution[], UsererrorError, ListExecutionsQueryParams, ListExecutionsPathParams>,
  'path'
> &
  ListExecutionsPathParams

export const ListExecutions = ({ repo_ref, pipeline_identifier, ...props }: ListExecutionsProps) => (
  <Get<TypesExecution[], UsererrorError, ListExecutionsQueryParams, ListExecutionsPathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListExecutionsProps = Omit<
  UseGetProps<TypesExecution[], UsererrorError, ListExecutionsQueryParams, ListExecutionsPathParams>,
  'path'
> &
  ListExecutionsPathParams

export const useListExecutions = ({ repo_ref, pipeline_identifier, ...props }: UseListExecutionsProps) =>
  useGet<TypesExecution[], UsererrorError, ListExecutionsQueryParams, ListExecutionsPathParams>(
    (paramsInPath: ListExecutionsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface CreateExecutionQueryParams {
  /**
   * Branch to run the execution for.
   */
  branch?: string
}

export interface CreateExecutionPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type CreateExecutionProps = Omit<
  MutateProps<TypesExecution, UsererrorError, CreateExecutionQueryParams, void, CreateExecutionPathParams>,
  'path' | 'verb'
> &
  CreateExecutionPathParams

export const CreateExecution = ({ repo_ref, pipeline_identifier, ...props }: CreateExecutionProps) => (
  <Mutate<TypesExecution, UsererrorError, CreateExecutionQueryParams, void, CreateExecutionPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateExecutionProps = Omit<
  UseMutateProps<TypesExecution, UsererrorError, CreateExecutionQueryParams, void, CreateExecutionPathParams>,
  'path' | 'verb'
> &
  CreateExecutionPathParams

export const useCreateExecution = ({ repo_ref, pipeline_identifier, ...props }: UseCreateExecutionProps) =>
  useMutate<TypesExecution, UsererrorError, CreateExecutionQueryParams, void, CreateExecutionPathParams>(
    'POST',
    (paramsInPath: CreateExecutionPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface DeleteExecutionPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type DeleteExecutionProps = Omit<
  MutateProps<void, UsererrorError, void, string, DeleteExecutionPathParams>,
  'path' | 'verb'
> &
  DeleteExecutionPathParams

export const DeleteExecution = ({ repo_ref, pipeline_identifier, ...props }: DeleteExecutionProps) => (
  <Mutate<void, UsererrorError, void, string, DeleteExecutionPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteExecutionProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, DeleteExecutionPathParams>,
  'path' | 'verb'
> &
  DeleteExecutionPathParams

export const useDeleteExecution = ({ repo_ref, pipeline_identifier, ...props }: UseDeleteExecutionProps) =>
  useMutate<void, UsererrorError, void, string, DeleteExecutionPathParams>(
    'DELETE',
    (paramsInPath: DeleteExecutionPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface FindExecutionPathParams {
  repo_ref: string
  pipeline_identifier: string
  execution_number: string
}

export type FindExecutionProps = Omit<GetProps<TypesExecution, UsererrorError, void, FindExecutionPathParams>, 'path'> &
  FindExecutionPathParams

export const FindExecution = ({ repo_ref, pipeline_identifier, execution_number, ...props }: FindExecutionProps) => (
  <Get<TypesExecution, UsererrorError, void, FindExecutionPathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions/${execution_number}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindExecutionProps = Omit<
  UseGetProps<TypesExecution, UsererrorError, void, FindExecutionPathParams>,
  'path'
> &
  FindExecutionPathParams

export const useFindExecution = ({
  repo_ref,
  pipeline_identifier,
  execution_number,
  ...props
}: UseFindExecutionProps) =>
  useGet<TypesExecution, UsererrorError, void, FindExecutionPathParams>(
    (paramsInPath: FindExecutionPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions/${paramsInPath.execution_number}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier, execution_number }, ...props }
  )

export interface CancelExecutionPathParams {
  repo_ref: string
  pipeline_identifier: string
  execution_number: string
}

export type CancelExecutionProps = Omit<
  MutateProps<TypesExecution, UsererrorError, void, void, CancelExecutionPathParams>,
  'path' | 'verb'
> &
  CancelExecutionPathParams

export const CancelExecution = ({
  repo_ref,
  pipeline_identifier,
  execution_number,
  ...props
}: CancelExecutionProps) => (
  <Mutate<TypesExecution, UsererrorError, void, void, CancelExecutionPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions/${execution_number}/cancel`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCancelExecutionProps = Omit<
  UseMutateProps<TypesExecution, UsererrorError, void, void, CancelExecutionPathParams>,
  'path' | 'verb'
> &
  CancelExecutionPathParams

export const useCancelExecution = ({
  repo_ref,
  pipeline_identifier,
  execution_number,
  ...props
}: UseCancelExecutionProps) =>
  useMutate<TypesExecution, UsererrorError, void, void, CancelExecutionPathParams>(
    'POST',
    (paramsInPath: CancelExecutionPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions/${paramsInPath.execution_number}/cancel`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier, execution_number }, ...props }
  )

export interface ViewLogsPathParams {
  repo_ref: string
  pipeline_identifier: string
  execution_number: string
  stage_number: string
  step_number: string
}

export type ViewLogsProps = Omit<GetProps<LivelogLine[], UsererrorError, void, ViewLogsPathParams>, 'path'> &
  ViewLogsPathParams

export const ViewLogs = ({
  repo_ref,
  pipeline_identifier,
  execution_number,
  stage_number,
  step_number,
  ...props
}: ViewLogsProps) => (
  <Get<LivelogLine[], UsererrorError, void, ViewLogsPathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/executions/${execution_number}/logs/${stage_number}/${step_number}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseViewLogsProps = Omit<UseGetProps<LivelogLine[], UsererrorError, void, ViewLogsPathParams>, 'path'> &
  ViewLogsPathParams

export const useViewLogs = ({
  repo_ref,
  pipeline_identifier,
  execution_number,
  stage_number,
  step_number,
  ...props
}: UseViewLogsProps) =>
  useGet<LivelogLine[], UsererrorError, void, ViewLogsPathParams>(
    (paramsInPath: ViewLogsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/executions/${paramsInPath.execution_number}/logs/${paramsInPath.stage_number}/${paramsInPath.step_number}`,
    {
      base: getConfig('api/v1'),
      pathParams: { repo_ref, pipeline_identifier, execution_number, stage_number, step_number },
      ...props
    }
  )

export interface ListTriggersQueryParams {
  /**
   * The substring which is used to filter the repositories by their path name.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListTriggersPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type ListTriggersProps = Omit<
  GetProps<TypesTrigger[], UsererrorError, ListTriggersQueryParams, ListTriggersPathParams>,
  'path'
> &
  ListTriggersPathParams

export const ListTriggers = ({ repo_ref, pipeline_identifier, ...props }: ListTriggersProps) => (
  <Get<TypesTrigger[], UsererrorError, ListTriggersQueryParams, ListTriggersPathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/triggers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListTriggersProps = Omit<
  UseGetProps<TypesTrigger[], UsererrorError, ListTriggersQueryParams, ListTriggersPathParams>,
  'path'
> &
  ListTriggersPathParams

export const useListTriggers = ({ repo_ref, pipeline_identifier, ...props }: UseListTriggersProps) =>
  useGet<TypesTrigger[], UsererrorError, ListTriggersQueryParams, ListTriggersPathParams>(
    (paramsInPath: ListTriggersPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/triggers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface CreateTriggerPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type CreateTriggerProps = Omit<
  MutateProps<TypesTrigger, UsererrorError, void, OpenapiCreateTriggerRequest, CreateTriggerPathParams>,
  'path' | 'verb'
> &
  CreateTriggerPathParams

export const CreateTrigger = ({ repo_ref, pipeline_identifier, ...props }: CreateTriggerProps) => (
  <Mutate<TypesTrigger, UsererrorError, void, OpenapiCreateTriggerRequest, CreateTriggerPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/triggers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateTriggerProps = Omit<
  UseMutateProps<TypesTrigger, UsererrorError, void, OpenapiCreateTriggerRequest, CreateTriggerPathParams>,
  'path' | 'verb'
> &
  CreateTriggerPathParams

export const useCreateTrigger = ({ repo_ref, pipeline_identifier, ...props }: UseCreateTriggerProps) =>
  useMutate<TypesTrigger, UsererrorError, void, OpenapiCreateTriggerRequest, CreateTriggerPathParams>(
    'POST',
    (paramsInPath: CreateTriggerPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/triggers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface DeleteTriggerPathParams {
  repo_ref: string
  pipeline_identifier: string
}

export type DeleteTriggerProps = Omit<
  MutateProps<void, UsererrorError, void, string, DeleteTriggerPathParams>,
  'path' | 'verb'
> &
  DeleteTriggerPathParams

export const DeleteTrigger = ({ repo_ref, pipeline_identifier, ...props }: DeleteTriggerProps) => (
  <Mutate<void, UsererrorError, void, string, DeleteTriggerPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/triggers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteTriggerProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, DeleteTriggerPathParams>,
  'path' | 'verb'
> &
  DeleteTriggerPathParams

export const useDeleteTrigger = ({ repo_ref, pipeline_identifier, ...props }: UseDeleteTriggerProps) =>
  useMutate<void, UsererrorError, void, string, DeleteTriggerPathParams>(
    'DELETE',
    (paramsInPath: DeleteTriggerPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/triggers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier }, ...props }
  )

export interface FindTriggerPathParams {
  repo_ref: string
  pipeline_identifier: string
  trigger_identifier: string
}

export type FindTriggerProps = Omit<GetProps<TypesTrigger, UsererrorError, void, FindTriggerPathParams>, 'path'> &
  FindTriggerPathParams

export const FindTrigger = ({ repo_ref, pipeline_identifier, trigger_identifier, ...props }: FindTriggerProps) => (
  <Get<TypesTrigger, UsererrorError, void, FindTriggerPathParams>
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/triggers/${trigger_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindTriggerProps = Omit<UseGetProps<TypesTrigger, UsererrorError, void, FindTriggerPathParams>, 'path'> &
  FindTriggerPathParams

export const useFindTrigger = ({ repo_ref, pipeline_identifier, trigger_identifier, ...props }: UseFindTriggerProps) =>
  useGet<TypesTrigger, UsererrorError, void, FindTriggerPathParams>(
    (paramsInPath: FindTriggerPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/triggers/${paramsInPath.trigger_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier, trigger_identifier }, ...props }
  )

export interface UpdateTriggerPathParams {
  repo_ref: string
  pipeline_identifier: string
  trigger_identifier: string
}

export type UpdateTriggerProps = Omit<
  MutateProps<TypesTrigger, UsererrorError, void, OpenapiUpdateTriggerRequest, UpdateTriggerPathParams>,
  'path' | 'verb'
> &
  UpdateTriggerPathParams

export const UpdateTrigger = ({ repo_ref, pipeline_identifier, trigger_identifier, ...props }: UpdateTriggerProps) => (
  <Mutate<TypesTrigger, UsererrorError, void, OpenapiUpdateTriggerRequest, UpdateTriggerPathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}/pipelines/${pipeline_identifier}/triggers/${trigger_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateTriggerProps = Omit<
  UseMutateProps<TypesTrigger, UsererrorError, void, OpenapiUpdateTriggerRequest, UpdateTriggerPathParams>,
  'path' | 'verb'
> &
  UpdateTriggerPathParams

export const useUpdateTrigger = ({
  repo_ref,
  pipeline_identifier,
  trigger_identifier,
  ...props
}: UseUpdateTriggerProps) =>
  useMutate<TypesTrigger, UsererrorError, void, OpenapiUpdateTriggerRequest, UpdateTriggerPathParams>(
    'PATCH',
    (paramsInPath: UpdateTriggerPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pipelines/${paramsInPath.pipeline_identifier}/triggers/${paramsInPath.trigger_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pipeline_identifier, trigger_identifier }, ...props }
  )

export interface UpdatePublicAccessPathParams {
  repo_ref: string
}

export type UpdatePublicAccessProps = Omit<
  MutateProps<
    RepoRepositoryOutput,
    UsererrorError,
    void,
    OpenapiUpdateRepoPublicAccessRequest,
    UpdatePublicAccessPathParams
  >,
  'path' | 'verb'
> &
  UpdatePublicAccessPathParams

export const UpdatePublicAccess = ({ repo_ref, ...props }: UpdatePublicAccessProps) => (
  <Mutate<
    RepoRepositoryOutput,
    UsererrorError,
    void,
    OpenapiUpdateRepoPublicAccessRequest,
    UpdatePublicAccessPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/public-access`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdatePublicAccessProps = Omit<
  UseMutateProps<
    RepoRepositoryOutput,
    UsererrorError,
    void,
    OpenapiUpdateRepoPublicAccessRequest,
    UpdatePublicAccessPathParams
  >,
  'path' | 'verb'
> &
  UpdatePublicAccessPathParams

export const useUpdatePublicAccess = ({ repo_ref, ...props }: UseUpdatePublicAccessProps) =>
  useMutate<
    RepoRepositoryOutput,
    UsererrorError,
    void,
    OpenapiUpdateRepoPublicAccessRequest,
    UpdatePublicAccessPathParams
  >('POST', (paramsInPath: UpdatePublicAccessPathParams) => `/repos/${paramsInPath.repo_ref}/public-access`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface ListPullReqQueryParams {
  /**
   * The state of the pull requests to include in the result.
   */
  state?: ('closed' | 'merged' | 'open')[]
  /**
   * Source repository ref of the pull requests.
   */
  source_repo_ref?: string
  /**
   * Source branch of the pull requests.
   */
  source_branch?: string
  /**
   * Target branch of the pull requests.
   */
  target_branch?: string
  /**
   * The substring by which the pull requests are filtered.
   */
  query?: string
  /**
   * List of principal IDs who created pull requests.
   */
  created_by?: number[]
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The data by which the pull requests are sorted.
   */
  sort?: 'created' | 'edited' | 'merged' | 'number' | 'updated'
  /**
   * The result should contain only entries created before this timestamp (unix millis).
   */
  created_lt?: number
  /**
   * The result should contain only entries created after this timestamp (unix millis).
   */
  created_gt?: number
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListPullReqPathParams {
  repo_ref: string
}

export type ListPullReqProps = Omit<
  GetProps<TypesPullReq[], UsererrorError, ListPullReqQueryParams, ListPullReqPathParams>,
  'path'
> &
  ListPullReqPathParams

export const ListPullReq = ({ repo_ref, ...props }: ListPullReqProps) => (
  <Get<TypesPullReq[], UsererrorError, ListPullReqQueryParams, ListPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPullReqProps = Omit<
  UseGetProps<TypesPullReq[], UsererrorError, ListPullReqQueryParams, ListPullReqPathParams>,
  'path'
> &
  ListPullReqPathParams

export const useListPullReq = ({ repo_ref, ...props }: UseListPullReqProps) =>
  useGet<TypesPullReq[], UsererrorError, ListPullReqQueryParams, ListPullReqPathParams>(
    (paramsInPath: ListPullReqPathParams) => `/repos/${paramsInPath.repo_ref}/pullreq`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CreatePullReqPathParams {
  repo_ref: string
}

export type CreatePullReqProps = Omit<
  MutateProps<TypesPullReq, UsererrorError, void, OpenapiCreatePullReqRequest, CreatePullReqPathParams>,
  'path' | 'verb'
> &
  CreatePullReqPathParams

export const CreatePullReq = ({ repo_ref, ...props }: CreatePullReqProps) => (
  <Mutate<TypesPullReq, UsererrorError, void, OpenapiCreatePullReqRequest, CreatePullReqPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pullreq`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreatePullReqProps = Omit<
  UseMutateProps<TypesPullReq, UsererrorError, void, OpenapiCreatePullReqRequest, CreatePullReqPathParams>,
  'path' | 'verb'
> &
  CreatePullReqPathParams

export const useCreatePullReq = ({ repo_ref, ...props }: UseCreatePullReqProps) =>
  useMutate<TypesPullReq, UsererrorError, void, OpenapiCreatePullReqRequest, CreatePullReqPathParams>(
    'POST',
    (paramsInPath: CreatePullReqPathParams) => `/repos/${paramsInPath.repo_ref}/pullreq`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface GetPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type GetPullReqProps = Omit<GetProps<TypesPullReq, UsererrorError, void, GetPullReqPathParams>, 'path'> &
  GetPullReqPathParams

export const GetPullReq = ({ repo_ref, pullreq_number, ...props }: GetPullReqProps) => (
  <Get<TypesPullReq, UsererrorError, void, GetPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetPullReqProps = Omit<UseGetProps<TypesPullReq, UsererrorError, void, GetPullReqPathParams>, 'path'> &
  GetPullReqPathParams

export const useGetPullReq = ({ repo_ref, pullreq_number, ...props }: UseGetPullReqProps) =>
  useGet<TypesPullReq, UsererrorError, void, GetPullReqPathParams>(
    (paramsInPath: GetPullReqPathParams) => `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface UpdatePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type UpdatePullReqProps = Omit<
  MutateProps<TypesPullReq, UsererrorError, void, OpenapiUpdatePullReqRequest, UpdatePullReqPathParams>,
  'path' | 'verb'
> &
  UpdatePullReqPathParams

export const UpdatePullReq = ({ repo_ref, pullreq_number, ...props }: UpdatePullReqProps) => (
  <Mutate<TypesPullReq, UsererrorError, void, OpenapiUpdatePullReqRequest, UpdatePullReqPathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdatePullReqProps = Omit<
  UseMutateProps<TypesPullReq, UsererrorError, void, OpenapiUpdatePullReqRequest, UpdatePullReqPathParams>,
  'path' | 'verb'
> &
  UpdatePullReqPathParams

export const useUpdatePullReq = ({ repo_ref, pullreq_number, ...props }: UseUpdatePullReqProps) =>
  useMutate<TypesPullReq, UsererrorError, void, OpenapiUpdatePullReqRequest, UpdatePullReqPathParams>(
    'PATCH',
    (paramsInPath: UpdatePullReqPathParams) => `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ListPullReqActivitiesQueryParams {
  /**
   * The kind of the pull request activity to include in the result.
   */
  kind?: ('change-comment' | 'comment' | 'system')[]
  /**
   * The type of the pull request activity to include in the result.
   */
  type?: (
    | 'branch-delete'
    | 'branch-update'
    | 'code-comment'
    | 'comment'
    | 'merge'
    | 'review-submit'
    | 'state-change'
    | 'title-change'
  )[]
  /**
   * The result should contain only entries created at and after this timestamp (unix millis).
   */
  after?: number
  /**
   * The result should contain only entries created before this timestamp (unix millis).
   */
  before?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListPullReqActivitiesPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ListPullReqActivitiesProps = Omit<
  GetProps<TypesPullReqActivity[], UsererrorError, ListPullReqActivitiesQueryParams, ListPullReqActivitiesPathParams>,
  'path'
> &
  ListPullReqActivitiesPathParams

export const ListPullReqActivities = ({ repo_ref, pullreq_number, ...props }: ListPullReqActivitiesProps) => (
  <Get<TypesPullReqActivity[], UsererrorError, ListPullReqActivitiesQueryParams, ListPullReqActivitiesPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/activities`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPullReqActivitiesProps = Omit<
  UseGetProps<
    TypesPullReqActivity[],
    UsererrorError,
    ListPullReqActivitiesQueryParams,
    ListPullReqActivitiesPathParams
  >,
  'path'
> &
  ListPullReqActivitiesPathParams

export const useListPullReqActivities = ({ repo_ref, pullreq_number, ...props }: UseListPullReqActivitiesProps) =>
  useGet<TypesPullReqActivity[], UsererrorError, ListPullReqActivitiesQueryParams, ListPullReqActivitiesPathParams>(
    (paramsInPath: ListPullReqActivitiesPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/activities`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ChecksPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ChecksPullReqProps = Omit<
  GetProps<TypesPullReqChecks[], UsererrorError, void, ChecksPullReqPathParams>,
  'path'
> &
  ChecksPullReqPathParams

export const ChecksPullReq = ({ repo_ref, pullreq_number, ...props }: ChecksPullReqProps) => (
  <Get<TypesPullReqChecks[], UsererrorError, void, ChecksPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/checks`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseChecksPullReqProps = Omit<
  UseGetProps<TypesPullReqChecks[], UsererrorError, void, ChecksPullReqPathParams>,
  'path'
> &
  ChecksPullReqPathParams

export const useChecksPullReq = ({ repo_ref, pullreq_number, ...props }: UseChecksPullReqProps) =>
  useGet<TypesPullReqChecks[], UsererrorError, void, ChecksPullReqPathParams>(
    (paramsInPath: ChecksPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/checks`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface CodeownersPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type CodeownersPullReqProps = Omit<
  GetProps<TypesCodeOwnerEvaluation, UsererrorError, void, CodeownersPullReqPathParams>,
  'path'
> &
  CodeownersPullReqPathParams

export const CodeownersPullReq = ({ repo_ref, pullreq_number, ...props }: CodeownersPullReqProps) => (
  <Get<TypesCodeOwnerEvaluation, UsererrorError, void, CodeownersPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/codeowners`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCodeownersPullReqProps = Omit<
  UseGetProps<TypesCodeOwnerEvaluation, UsererrorError, void, CodeownersPullReqPathParams>,
  'path'
> &
  CodeownersPullReqPathParams

export const useCodeownersPullReq = ({ repo_ref, pullreq_number, ...props }: UseCodeownersPullReqProps) =>
  useGet<TypesCodeOwnerEvaluation, UsererrorError, void, CodeownersPullReqPathParams>(
    (paramsInPath: CodeownersPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/codeowners`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface CommentCreatePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type CommentCreatePullReqProps = Omit<
  MutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentCreatePullReqRequest,
    CommentCreatePullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentCreatePullReqPathParams

export const CommentCreatePullReq = ({ repo_ref, pullreq_number, ...props }: CommentCreatePullReqProps) => (
  <Mutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentCreatePullReqRequest,
    CommentCreatePullReqPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/comments`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommentCreatePullReqProps = Omit<
  UseMutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentCreatePullReqRequest,
    CommentCreatePullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentCreatePullReqPathParams

export const useCommentCreatePullReq = ({ repo_ref, pullreq_number, ...props }: UseCommentCreatePullReqProps) =>
  useMutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentCreatePullReqRequest,
    CommentCreatePullReqPathParams
  >(
    'POST',
    (paramsInPath: CommentCreatePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/comments`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface CommentDeletePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type CommentDeletePullReqProps = Omit<
  MutateProps<void, UsererrorError, void, number, CommentDeletePullReqPathParams>,
  'path' | 'verb'
> &
  CommentDeletePullReqPathParams

export const CommentDeletePullReq = ({ repo_ref, pullreq_number, ...props }: CommentDeletePullReqProps) => (
  <Mutate<void, UsererrorError, void, number, CommentDeletePullReqPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/comments`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommentDeletePullReqProps = Omit<
  UseMutateProps<void, UsererrorError, void, number, CommentDeletePullReqPathParams>,
  'path' | 'verb'
> &
  CommentDeletePullReqPathParams

export const useCommentDeletePullReq = ({ repo_ref, pullreq_number, ...props }: UseCommentDeletePullReqProps) =>
  useMutate<void, UsererrorError, void, number, CommentDeletePullReqPathParams>(
    'DELETE',
    (paramsInPath: CommentDeletePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/comments`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface CommentUpdatePullReqPathParams {
  repo_ref: string
  pullreq_number: number
  pullreq_comment_id: number
}

export type CommentUpdatePullReqProps = Omit<
  MutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentUpdatePullReqRequest,
    CommentUpdatePullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentUpdatePullReqPathParams

export const CommentUpdatePullReq = ({
  repo_ref,
  pullreq_number,
  pullreq_comment_id,
  ...props
}: CommentUpdatePullReqProps) => (
  <Mutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentUpdatePullReqRequest,
    CommentUpdatePullReqPathParams
  >
    verb="PATCH"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/comments/${pullreq_comment_id}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommentUpdatePullReqProps = Omit<
  UseMutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentUpdatePullReqRequest,
    CommentUpdatePullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentUpdatePullReqPathParams

export const useCommentUpdatePullReq = ({
  repo_ref,
  pullreq_number,
  pullreq_comment_id,
  ...props
}: UseCommentUpdatePullReqProps) =>
  useMutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentUpdatePullReqRequest,
    CommentUpdatePullReqPathParams
  >(
    'PATCH',
    (paramsInPath: CommentUpdatePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/comments/${paramsInPath.pullreq_comment_id}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number, pullreq_comment_id }, ...props }
  )

export interface CommentStatusPullReqPathParams {
  repo_ref: string
  pullreq_number: number
  pullreq_comment_id: number
}

export type CommentStatusPullReqProps = Omit<
  MutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentStatusPullReqRequest,
    CommentStatusPullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentStatusPullReqPathParams

export const CommentStatusPullReq = ({
  repo_ref,
  pullreq_number,
  pullreq_comment_id,
  ...props
}: CommentStatusPullReqProps) => (
  <Mutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentStatusPullReqRequest,
    CommentStatusPullReqPathParams
  >
    verb="PUT"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/comments/${pullreq_comment_id}/status`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommentStatusPullReqProps = Omit<
  UseMutateProps<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentStatusPullReqRequest,
    CommentStatusPullReqPathParams
  >,
  'path' | 'verb'
> &
  CommentStatusPullReqPathParams

export const useCommentStatusPullReq = ({
  repo_ref,
  pullreq_number,
  pullreq_comment_id,
  ...props
}: UseCommentStatusPullReqProps) =>
  useMutate<
    TypesPullReqActivity,
    UsererrorError,
    void,
    OpenapiCommentStatusPullReqRequest,
    CommentStatusPullReqPathParams
  >(
    'PUT',
    (paramsInPath: CommentStatusPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/comments/${paramsInPath.pullreq_comment_id}/status`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number, pullreq_comment_id }, ...props }
  )

export interface CommentApplySuggestionsPathParams {
  repo_ref: string
  pullreq_number: number
}

export type CommentApplySuggestionsProps = Omit<
  MutateProps<
    PullreqCommentApplySuggestionsOutput,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommentApplySuggestionstRequest,
    CommentApplySuggestionsPathParams
  >,
  'path' | 'verb'
> &
  CommentApplySuggestionsPathParams

export const CommentApplySuggestions = ({ repo_ref, pullreq_number, ...props }: CommentApplySuggestionsProps) => (
  <Mutate<
    PullreqCommentApplySuggestionsOutput,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommentApplySuggestionstRequest,
    CommentApplySuggestionsPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/comments/apply-suggestions`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCommentApplySuggestionsProps = Omit<
  UseMutateProps<
    PullreqCommentApplySuggestionsOutput,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommentApplySuggestionstRequest,
    CommentApplySuggestionsPathParams
  >,
  'path' | 'verb'
> &
  CommentApplySuggestionsPathParams

export const useCommentApplySuggestions = ({ repo_ref, pullreq_number, ...props }: UseCommentApplySuggestionsProps) =>
  useMutate<
    PullreqCommentApplySuggestionsOutput,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCommentApplySuggestionstRequest,
    CommentApplySuggestionsPathParams
  >(
    'POST',
    (paramsInPath: CommentApplySuggestionsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/comments/apply-suggestions`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ListPullReqCommitsQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListPullReqCommitsPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ListPullReqCommitsProps = Omit<
  GetProps<TypesCommit[], UsererrorError, ListPullReqCommitsQueryParams, ListPullReqCommitsPathParams>,
  'path'
> &
  ListPullReqCommitsPathParams

export const ListPullReqCommits = ({ repo_ref, pullreq_number, ...props }: ListPullReqCommitsProps) => (
  <Get<TypesCommit[], UsererrorError, ListPullReqCommitsQueryParams, ListPullReqCommitsPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/commits`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPullReqCommitsProps = Omit<
  UseGetProps<TypesCommit[], UsererrorError, ListPullReqCommitsQueryParams, ListPullReqCommitsPathParams>,
  'path'
> &
  ListPullReqCommitsPathParams

export const useListPullReqCommits = ({ repo_ref, pullreq_number, ...props }: UseListPullReqCommitsProps) =>
  useGet<TypesCommit[], UsererrorError, ListPullReqCommitsQueryParams, ListPullReqCommitsPathParams>(
    (paramsInPath: ListPullReqCommitsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/commits`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface DiffPullReqQueryParams {
  /**
   * provide path for diff operation
   */
  path?: string[]
}

export interface DiffPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type DiffPullReqProps = Omit<
  GetProps<GitFileDiff[], UsererrorError, DiffPullReqQueryParams, DiffPullReqPathParams>,
  'path'
> &
  DiffPullReqPathParams

export const DiffPullReq = ({ repo_ref, pullreq_number, ...props }: DiffPullReqProps) => (
  <Get<GitFileDiff[], UsererrorError, DiffPullReqQueryParams, DiffPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/diff`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDiffPullReqProps = Omit<
  UseGetProps<GitFileDiff[], UsererrorError, DiffPullReqQueryParams, DiffPullReqPathParams>,
  'path'
> &
  DiffPullReqPathParams

export const useDiffPullReq = ({ repo_ref, pullreq_number, ...props }: UseDiffPullReqProps) =>
  useGet<GitFileDiff[], UsererrorError, DiffPullReqQueryParams, DiffPullReqPathParams>(
    (paramsInPath: DiffPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/diff`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface DiffPullReqPostPathParams {
  repo_ref: string
  pullreq_number: number
}

export type DiffPullReqPostProps = Omit<
  MutateProps<GitFileDiff[], UsererrorError, void, OpenapiPostRawPRDiffRequest, DiffPullReqPostPathParams>,
  'path' | 'verb'
> &
  DiffPullReqPostPathParams

export const DiffPullReqPost = ({ repo_ref, pullreq_number, ...props }: DiffPullReqPostProps) => (
  <Mutate<GitFileDiff[], UsererrorError, void, OpenapiPostRawPRDiffRequest, DiffPullReqPostPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/diff`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDiffPullReqPostProps = Omit<
  UseMutateProps<GitFileDiff[], UsererrorError, void, OpenapiPostRawPRDiffRequest, DiffPullReqPostPathParams>,
  'path' | 'verb'
> &
  DiffPullReqPostPathParams

export const useDiffPullReqPost = ({ repo_ref, pullreq_number, ...props }: UseDiffPullReqPostProps) =>
  useMutate<GitFileDiff[], UsererrorError, void, OpenapiPostRawPRDiffRequest, DiffPullReqPostPathParams>(
    'POST',
    (paramsInPath: DiffPullReqPostPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/diff`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface FileViewListPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type FileViewListPullReqProps = Omit<
  GetProps<TypesPullReqFileView[], UsererrorError, void, FileViewListPullReqPathParams>,
  'path'
> &
  FileViewListPullReqPathParams

export const FileViewListPullReq = ({ repo_ref, pullreq_number, ...props }: FileViewListPullReqProps) => (
  <Get<TypesPullReqFileView[], UsererrorError, void, FileViewListPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/file-views`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFileViewListPullReqProps = Omit<
  UseGetProps<TypesPullReqFileView[], UsererrorError, void, FileViewListPullReqPathParams>,
  'path'
> &
  FileViewListPullReqPathParams

export const useFileViewListPullReq = ({ repo_ref, pullreq_number, ...props }: UseFileViewListPullReqProps) =>
  useGet<TypesPullReqFileView[], UsererrorError, void, FileViewListPullReqPathParams>(
    (paramsInPath: FileViewListPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/file-views`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface FileViewAddPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type FileViewAddPullReqProps = Omit<
  MutateProps<
    TypesPullReqFileView,
    UsererrorError,
    void,
    OpenapiFileViewAddPullReqRequest,
    FileViewAddPullReqPathParams
  >,
  'path' | 'verb'
> &
  FileViewAddPullReqPathParams

export const FileViewAddPullReq = ({ repo_ref, pullreq_number, ...props }: FileViewAddPullReqProps) => (
  <Mutate<TypesPullReqFileView, UsererrorError, void, OpenapiFileViewAddPullReqRequest, FileViewAddPullReqPathParams>
    verb="PUT"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/file-views`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFileViewAddPullReqProps = Omit<
  UseMutateProps<
    TypesPullReqFileView,
    UsererrorError,
    void,
    OpenapiFileViewAddPullReqRequest,
    FileViewAddPullReqPathParams
  >,
  'path' | 'verb'
> &
  FileViewAddPullReqPathParams

export const useFileViewAddPullReq = ({ repo_ref, pullreq_number, ...props }: UseFileViewAddPullReqProps) =>
  useMutate<TypesPullReqFileView, UsererrorError, void, OpenapiFileViewAddPullReqRequest, FileViewAddPullReqPathParams>(
    'PUT',
    (paramsInPath: FileViewAddPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/file-views`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface FileViewDeletePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type FileViewDeletePullReqProps = Omit<
  MutateProps<void, UsererrorError, void, string, FileViewDeletePullReqPathParams>,
  'path' | 'verb'
> &
  FileViewDeletePullReqPathParams

export const FileViewDeletePullReq = ({ repo_ref, pullreq_number, ...props }: FileViewDeletePullReqProps) => (
  <Mutate<void, UsererrorError, void, string, FileViewDeletePullReqPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/file-views`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFileViewDeletePullReqProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, FileViewDeletePullReqPathParams>,
  'path' | 'verb'
> &
  FileViewDeletePullReqPathParams

export const useFileViewDeletePullReq = ({ repo_ref, pullreq_number, ...props }: UseFileViewDeletePullReqProps) =>
  useMutate<void, UsererrorError, void, string, FileViewDeletePullReqPathParams>(
    'DELETE',
    (paramsInPath: FileViewDeletePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/file-views`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface MergePullReqOpPathParams {
  repo_ref: string
  pullreq_number: number
}

export type MergePullReqOpProps = Omit<
  MutateProps<
    TypesMergeResponse,
    UsererrorError | TypesMergeViolations,
    void,
    OpenapiMergePullReq,
    MergePullReqOpPathParams
  >,
  'path' | 'verb'
> &
  MergePullReqOpPathParams

export const MergePullReqOp = ({ repo_ref, pullreq_number, ...props }: MergePullReqOpProps) => (
  <Mutate<
    TypesMergeResponse,
    UsererrorError | TypesMergeViolations,
    void,
    OpenapiMergePullReq,
    MergePullReqOpPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/merge`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMergePullReqOpProps = Omit<
  UseMutateProps<
    TypesMergeResponse,
    UsererrorError | TypesMergeViolations,
    void,
    OpenapiMergePullReq,
    MergePullReqOpPathParams
  >,
  'path' | 'verb'
> &
  MergePullReqOpPathParams

export const useMergePullReqOp = ({ repo_ref, pullreq_number, ...props }: UseMergePullReqOpProps) =>
  useMutate<
    TypesMergeResponse,
    UsererrorError | TypesMergeViolations,
    void,
    OpenapiMergePullReq,
    MergePullReqOpPathParams
  >(
    'POST',
    (paramsInPath: MergePullReqOpPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/merge`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface PullReqMetaDataPathParams {
  repo_ref: string
  pullreq_number: number
}

export type PullReqMetaDataProps = Omit<
  GetProps<TypesPullReqStats, UsererrorError, void, PullReqMetaDataPathParams>,
  'path'
> &
  PullReqMetaDataPathParams

export const PullReqMetaData = ({ repo_ref, pullreq_number, ...props }: PullReqMetaDataProps) => (
  <Get<TypesPullReqStats, UsererrorError, void, PullReqMetaDataPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/metadata`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UsePullReqMetaDataProps = Omit<
  UseGetProps<TypesPullReqStats, UsererrorError, void, PullReqMetaDataPathParams>,
  'path'
> &
  PullReqMetaDataPathParams

export const usePullReqMetaData = ({ repo_ref, pullreq_number, ...props }: UsePullReqMetaDataProps) =>
  useGet<TypesPullReqStats, UsererrorError, void, PullReqMetaDataPathParams>(
    (paramsInPath: PullReqMetaDataPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/metadata`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ReviewerListPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ReviewerListPullReqProps = Omit<
  GetProps<TypesPullReqReviewer[], UsererrorError, void, ReviewerListPullReqPathParams>,
  'path'
> &
  ReviewerListPullReqPathParams

export const ReviewerListPullReq = ({ repo_ref, pullreq_number, ...props }: ReviewerListPullReqProps) => (
  <Get<TypesPullReqReviewer[], UsererrorError, void, ReviewerListPullReqPathParams>
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/reviewers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseReviewerListPullReqProps = Omit<
  UseGetProps<TypesPullReqReviewer[], UsererrorError, void, ReviewerListPullReqPathParams>,
  'path'
> &
  ReviewerListPullReqPathParams

export const useReviewerListPullReq = ({ repo_ref, pullreq_number, ...props }: UseReviewerListPullReqProps) =>
  useGet<TypesPullReqReviewer[], UsererrorError, void, ReviewerListPullReqPathParams>(
    (paramsInPath: ReviewerListPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/reviewers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ReviewerAddPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ReviewerAddPullReqProps = Omit<
  MutateProps<
    TypesPullReqReviewer,
    UsererrorError,
    void,
    OpenapiReviewerAddPullReqRequest,
    ReviewerAddPullReqPathParams
  >,
  'path' | 'verb'
> &
  ReviewerAddPullReqPathParams

export const ReviewerAddPullReq = ({ repo_ref, pullreq_number, ...props }: ReviewerAddPullReqProps) => (
  <Mutate<TypesPullReqReviewer, UsererrorError, void, OpenapiReviewerAddPullReqRequest, ReviewerAddPullReqPathParams>
    verb="PUT"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/reviewers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseReviewerAddPullReqProps = Omit<
  UseMutateProps<
    TypesPullReqReviewer,
    UsererrorError,
    void,
    OpenapiReviewerAddPullReqRequest,
    ReviewerAddPullReqPathParams
  >,
  'path' | 'verb'
> &
  ReviewerAddPullReqPathParams

export const useReviewerAddPullReq = ({ repo_ref, pullreq_number, ...props }: UseReviewerAddPullReqProps) =>
  useMutate<TypesPullReqReviewer, UsererrorError, void, OpenapiReviewerAddPullReqRequest, ReviewerAddPullReqPathParams>(
    'PUT',
    (paramsInPath: ReviewerAddPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/reviewers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ReviewerDeletePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ReviewerDeletePullReqProps = Omit<
  MutateProps<void, UsererrorError, void, number, ReviewerDeletePullReqPathParams>,
  'path' | 'verb'
> &
  ReviewerDeletePullReqPathParams

export const ReviewerDeletePullReq = ({ repo_ref, pullreq_number, ...props }: ReviewerDeletePullReqProps) => (
  <Mutate<void, UsererrorError, void, number, ReviewerDeletePullReqPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/reviewers`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseReviewerDeletePullReqProps = Omit<
  UseMutateProps<void, UsererrorError, void, number, ReviewerDeletePullReqPathParams>,
  'path' | 'verb'
> &
  ReviewerDeletePullReqPathParams

export const useReviewerDeletePullReq = ({ repo_ref, pullreq_number, ...props }: UseReviewerDeletePullReqProps) =>
  useMutate<void, UsererrorError, void, number, ReviewerDeletePullReqPathParams>(
    'DELETE',
    (paramsInPath: ReviewerDeletePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/reviewers`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface ReviewSubmitPullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type ReviewSubmitPullReqProps = Omit<
  MutateProps<void, UsererrorError, void, OpenapiReviewSubmitPullReqRequest, ReviewSubmitPullReqPathParams>,
  'path' | 'verb'
> &
  ReviewSubmitPullReqPathParams

export const ReviewSubmitPullReq = ({ repo_ref, pullreq_number, ...props }: ReviewSubmitPullReqProps) => (
  <Mutate<void, UsererrorError, void, OpenapiReviewSubmitPullReqRequest, ReviewSubmitPullReqPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/reviews`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseReviewSubmitPullReqProps = Omit<
  UseMutateProps<void, UsererrorError, void, OpenapiReviewSubmitPullReqRequest, ReviewSubmitPullReqPathParams>,
  'path' | 'verb'
> &
  ReviewSubmitPullReqPathParams

export const useReviewSubmitPullReq = ({ repo_ref, pullreq_number, ...props }: UseReviewSubmitPullReqProps) =>
  useMutate<void, UsererrorError, void, OpenapiReviewSubmitPullReqRequest, ReviewSubmitPullReqPathParams>(
    'POST',
    (paramsInPath: ReviewSubmitPullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/reviews`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface StatePullReqPathParams {
  repo_ref: string
  pullreq_number: number
}

export type StatePullReqProps = Omit<
  MutateProps<TypesPullReq, UsererrorError, void, OpenapiStatePullReqRequest, StatePullReqPathParams>,
  'path' | 'verb'
> &
  StatePullReqPathParams

export const StatePullReq = ({ repo_ref, pullreq_number, ...props }: StatePullReqProps) => (
  <Mutate<TypesPullReq, UsererrorError, void, OpenapiStatePullReqRequest, StatePullReqPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/pullreq/${pullreq_number}/state`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseStatePullReqProps = Omit<
  UseMutateProps<TypesPullReq, UsererrorError, void, OpenapiStatePullReqRequest, StatePullReqPathParams>,
  'path' | 'verb'
> &
  StatePullReqPathParams

export const useStatePullReq = ({ repo_ref, pullreq_number, ...props }: UseStatePullReqProps) =>
  useMutate<TypesPullReq, UsererrorError, void, OpenapiStatePullReqRequest, StatePullReqPathParams>(
    'POST',
    (paramsInPath: StatePullReqPathParams) =>
      `/repos/${paramsInPath.repo_ref}/pullreq/${paramsInPath.pullreq_number}/state`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, pullreq_number }, ...props }
  )

export interface PurgeRepositoryQueryParams {
  /**
   * The exact time the resource was delete at in epoch format.
   */
  deleted_at: number
}

export interface PurgeRepositoryPathParams {
  repo_ref: string
}

export type PurgeRepositoryProps = Omit<
  MutateProps<void, UsererrorError, PurgeRepositoryQueryParams, void, PurgeRepositoryPathParams>,
  'path' | 'verb'
> &
  PurgeRepositoryPathParams

export const PurgeRepository = ({ repo_ref, ...props }: PurgeRepositoryProps) => (
  <Mutate<void, UsererrorError, PurgeRepositoryQueryParams, void, PurgeRepositoryPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/purge`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UsePurgeRepositoryProps = Omit<
  UseMutateProps<void, UsererrorError, PurgeRepositoryQueryParams, void, PurgeRepositoryPathParams>,
  'path' | 'verb'
> &
  PurgeRepositoryPathParams

export const usePurgeRepository = ({ repo_ref, ...props }: UsePurgeRepositoryProps) =>
  useMutate<void, UsererrorError, PurgeRepositoryQueryParams, void, PurgeRepositoryPathParams>(
    'POST',
    (paramsInPath: PurgeRepositoryPathParams) => `/repos/${paramsInPath.repo_ref}/purge`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface GetRawQueryParams {
  /**
   * The git reference (branch / tag / commitID) that will be used to retrieve the data. If no value is provided the default branch of the repository is used.
   */
  git_ref?: string
}

export interface GetRawPathParams {
  repo_ref: string
  path: string
}

export type GetRawProps = Omit<GetProps<void, UsererrorError, GetRawQueryParams, GetRawPathParams>, 'path'> &
  GetRawPathParams

export const GetRaw = ({ repo_ref, path, ...props }: GetRawProps) => (
  <Get<void, UsererrorError, GetRawQueryParams, GetRawPathParams>
    path={`/repos/${repo_ref}/raw/${path}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetRawProps = Omit<UseGetProps<void, UsererrorError, GetRawQueryParams, GetRawPathParams>, 'path'> &
  GetRawPathParams

export const useGetRaw = ({ repo_ref, path, ...props }: UseGetRawProps) =>
  useGet<void, UsererrorError, GetRawQueryParams, GetRawPathParams>(
    (paramsInPath: GetRawPathParams) => `/repos/${paramsInPath.repo_ref}/raw/${paramsInPath.path}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, path }, ...props }
  )

export interface RestoreRepositoryQueryParams {
  /**
   * The exact time the resource was delete at in epoch format.
   */
  deleted_at: number
}

export interface RestoreRepositoryPathParams {
  repo_ref: string
}

export type RestoreRepositoryProps = Omit<
  MutateProps<
    RepoRepositoryOutput,
    UsererrorError,
    RestoreRepositoryQueryParams,
    OpenapiRestoreRequest,
    RestoreRepositoryPathParams
  >,
  'path' | 'verb'
> &
  RestoreRepositoryPathParams

export const RestoreRepository = ({ repo_ref, ...props }: RestoreRepositoryProps) => (
  <Mutate<
    RepoRepositoryOutput,
    UsererrorError,
    RestoreRepositoryQueryParams,
    OpenapiRestoreRequest,
    RestoreRepositoryPathParams
  >
    verb="POST"
    path={`/repos/${repo_ref}/restore`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRestoreRepositoryProps = Omit<
  UseMutateProps<
    RepoRepositoryOutput,
    UsererrorError,
    RestoreRepositoryQueryParams,
    OpenapiRestoreRequest,
    RestoreRepositoryPathParams
  >,
  'path' | 'verb'
> &
  RestoreRepositoryPathParams

export const useRestoreRepository = ({ repo_ref, ...props }: UseRestoreRepositoryProps) =>
  useMutate<
    RepoRepositoryOutput,
    UsererrorError,
    RestoreRepositoryQueryParams,
    OpenapiRestoreRequest,
    RestoreRepositoryPathParams
  >('POST', (paramsInPath: RestoreRepositoryPathParams) => `/repos/${paramsInPath.repo_ref}/restore`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface RuleListQueryParams {
  /**
   * The substring by which the repository protection rules are filtered.
   */
  query?: string
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The field by which the protection rules are sorted.
   */
  sort?: 'created_at' | 'identifier' | 'uid' | 'updated_at'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface RuleListPathParams {
  repo_ref: string
}

export type RuleListProps = Omit<
  GetProps<OpenapiRule[], UsererrorError, RuleListQueryParams, RuleListPathParams>,
  'path'
> &
  RuleListPathParams

export const RuleList = ({ repo_ref, ...props }: RuleListProps) => (
  <Get<OpenapiRule[], UsererrorError, RuleListQueryParams, RuleListPathParams>
    path={`/repos/${repo_ref}/rules`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRuleListProps = Omit<
  UseGetProps<OpenapiRule[], UsererrorError, RuleListQueryParams, RuleListPathParams>,
  'path'
> &
  RuleListPathParams

export const useRuleList = ({ repo_ref, ...props }: UseRuleListProps) =>
  useGet<OpenapiRule[], UsererrorError, RuleListQueryParams, RuleListPathParams>(
    (paramsInPath: RuleListPathParams) => `/repos/${paramsInPath.repo_ref}/rules`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface RuleAddPathParams {
  repo_ref: string
}

export interface RuleAddRequestBody {
  definition?: OpenapiRuleDefinition
  description?: string
  identifier?: string
  pattern?: ProtectionPattern
  state?: EnumRuleState
  type?: OpenapiRuleType
  uid?: string
}

export type RuleAddProps = Omit<
  MutateProps<OpenapiRule, UsererrorError, void, RuleAddRequestBody, RuleAddPathParams>,
  'path' | 'verb'
> &
  RuleAddPathParams

export const RuleAdd = ({ repo_ref, ...props }: RuleAddProps) => (
  <Mutate<OpenapiRule, UsererrorError, void, RuleAddRequestBody, RuleAddPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/rules`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRuleAddProps = Omit<
  UseMutateProps<OpenapiRule, UsererrorError, void, RuleAddRequestBody, RuleAddPathParams>,
  'path' | 'verb'
> &
  RuleAddPathParams

export const useRuleAdd = ({ repo_ref, ...props }: UseRuleAddProps) =>
  useMutate<OpenapiRule, UsererrorError, void, RuleAddRequestBody, RuleAddPathParams>(
    'POST',
    (paramsInPath: RuleAddPathParams) => `/repos/${paramsInPath.repo_ref}/rules`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface RuleDeletePathParams {
  repo_ref: string
}

export type RuleDeleteProps = Omit<
  MutateProps<void, UsererrorError, void, string, RuleDeletePathParams>,
  'path' | 'verb'
> &
  RuleDeletePathParams

export const RuleDelete = ({ repo_ref, ...props }: RuleDeleteProps) => (
  <Mutate<void, UsererrorError, void, string, RuleDeletePathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/rules`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRuleDeleteProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, RuleDeletePathParams>,
  'path' | 'verb'
> &
  RuleDeletePathParams

export const useRuleDelete = ({ repo_ref, ...props }: UseRuleDeleteProps) =>
  useMutate<void, UsererrorError, void, string, RuleDeletePathParams>(
    'DELETE',
    (paramsInPath: RuleDeletePathParams) => `/repos/${paramsInPath.repo_ref}/rules`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface RuleGetPathParams {
  repo_ref: string
  rule_identifier: string
}

export type RuleGetProps = Omit<GetProps<OpenapiRule, UsererrorError, void, RuleGetPathParams>, 'path'> &
  RuleGetPathParams

export const RuleGet = ({ repo_ref, rule_identifier, ...props }: RuleGetProps) => (
  <Get<OpenapiRule, UsererrorError, void, RuleGetPathParams>
    path={`/repos/${repo_ref}/rules/${rule_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRuleGetProps = Omit<UseGetProps<OpenapiRule, UsererrorError, void, RuleGetPathParams>, 'path'> &
  RuleGetPathParams

export const useRuleGet = ({ repo_ref, rule_identifier, ...props }: UseRuleGetProps) =>
  useGet<OpenapiRule, UsererrorError, void, RuleGetPathParams>(
    (paramsInPath: RuleGetPathParams) => `/repos/${paramsInPath.repo_ref}/rules/${paramsInPath.rule_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, rule_identifier }, ...props }
  )

export interface RuleUpdatePathParams {
  repo_ref: string
  rule_identifier: string
}

export interface RuleUpdateRequestBody {
  definition?: OpenapiRuleDefinition
  description?: string | null
  identifier?: string | null
  pattern?: ProtectionPattern
  state?: EnumRuleState
  type?: OpenapiRuleType
  uid?: string | null
}

export type RuleUpdateProps = Omit<
  MutateProps<OpenapiRule, UsererrorError, void, RuleUpdateRequestBody, RuleUpdatePathParams>,
  'path' | 'verb'
> &
  RuleUpdatePathParams

export const RuleUpdate = ({ repo_ref, rule_identifier, ...props }: RuleUpdateProps) => (
  <Mutate<OpenapiRule, UsererrorError, void, RuleUpdateRequestBody, RuleUpdatePathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}/rules/${rule_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRuleUpdateProps = Omit<
  UseMutateProps<OpenapiRule, UsererrorError, void, RuleUpdateRequestBody, RuleUpdatePathParams>,
  'path' | 'verb'
> &
  RuleUpdatePathParams

export const useRuleUpdate = ({ repo_ref, rule_identifier, ...props }: UseRuleUpdateProps) =>
  useMutate<OpenapiRule, UsererrorError, void, RuleUpdateRequestBody, RuleUpdatePathParams>(
    'PATCH',
    (paramsInPath: RuleUpdatePathParams) => `/repos/${paramsInPath.repo_ref}/rules/${paramsInPath.rule_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, rule_identifier }, ...props }
  )

export interface ListRepositoryServiceAccountsPathParams {
  repo_ref: string
}

export type ListRepositoryServiceAccountsProps = Omit<
  GetProps<TypesServiceAccount[], UsererrorError, void, ListRepositoryServiceAccountsPathParams>,
  'path'
> &
  ListRepositoryServiceAccountsPathParams

export const ListRepositoryServiceAccounts = ({ repo_ref, ...props }: ListRepositoryServiceAccountsProps) => (
  <Get<TypesServiceAccount[], UsererrorError, void, ListRepositoryServiceAccountsPathParams>
    path={`/repos/${repo_ref}/service-accounts`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListRepositoryServiceAccountsProps = Omit<
  UseGetProps<TypesServiceAccount[], UsererrorError, void, ListRepositoryServiceAccountsPathParams>,
  'path'
> &
  ListRepositoryServiceAccountsPathParams

export const useListRepositoryServiceAccounts = ({ repo_ref, ...props }: UseListRepositoryServiceAccountsProps) =>
  useGet<TypesServiceAccount[], UsererrorError, void, ListRepositoryServiceAccountsPathParams>(
    (paramsInPath: ListRepositoryServiceAccountsPathParams) => `/repos/${paramsInPath.repo_ref}/service-accounts`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface FindGeneralSettingsPathParams {
  repo_ref: string
}

export type FindGeneralSettingsProps = Omit<
  GetProps<ReposettingsGeneralSettings, UsererrorError, void, FindGeneralSettingsPathParams>,
  'path'
> &
  FindGeneralSettingsPathParams

export const FindGeneralSettings = ({ repo_ref, ...props }: FindGeneralSettingsProps) => (
  <Get<ReposettingsGeneralSettings, UsererrorError, void, FindGeneralSettingsPathParams>
    path={`/repos/${repo_ref}/settings/general`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindGeneralSettingsProps = Omit<
  UseGetProps<ReposettingsGeneralSettings, UsererrorError, void, FindGeneralSettingsPathParams>,
  'path'
> &
  FindGeneralSettingsPathParams

export const useFindGeneralSettings = ({ repo_ref, ...props }: UseFindGeneralSettingsProps) =>
  useGet<ReposettingsGeneralSettings, UsererrorError, void, FindGeneralSettingsPathParams>(
    (paramsInPath: FindGeneralSettingsPathParams) => `/repos/${paramsInPath.repo_ref}/settings/general`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface UpdateGeneralSettingsPathParams {
  repo_ref: string
}

export type UpdateGeneralSettingsProps = Omit<
  MutateProps<
    ReposettingsGeneralSettings,
    UsererrorError,
    void,
    OpenapiGeneralSettingsRequest,
    UpdateGeneralSettingsPathParams
  >,
  'path' | 'verb'
> &
  UpdateGeneralSettingsPathParams

export const UpdateGeneralSettings = ({ repo_ref, ...props }: UpdateGeneralSettingsProps) => (
  <Mutate<
    ReposettingsGeneralSettings,
    UsererrorError,
    void,
    OpenapiGeneralSettingsRequest,
    UpdateGeneralSettingsPathParams
  >
    verb="PATCH"
    path={`/repos/${repo_ref}/settings/general`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateGeneralSettingsProps = Omit<
  UseMutateProps<
    ReposettingsGeneralSettings,
    UsererrorError,
    void,
    OpenapiGeneralSettingsRequest,
    UpdateGeneralSettingsPathParams
  >,
  'path' | 'verb'
> &
  UpdateGeneralSettingsPathParams

export const useUpdateGeneralSettings = ({ repo_ref, ...props }: UseUpdateGeneralSettingsProps) =>
  useMutate<
    ReposettingsGeneralSettings,
    UsererrorError,
    void,
    OpenapiGeneralSettingsRequest,
    UpdateGeneralSettingsPathParams
  >('PATCH', (paramsInPath: UpdateGeneralSettingsPathParams) => `/repos/${paramsInPath.repo_ref}/settings/general`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface FindSecuritySettingsPathParams {
  repo_ref: string
}

export type FindSecuritySettingsProps = Omit<
  GetProps<ReposettingsSecuritySettings, UsererrorError, void, FindSecuritySettingsPathParams>,
  'path'
> &
  FindSecuritySettingsPathParams

export const FindSecuritySettings = ({ repo_ref, ...props }: FindSecuritySettingsProps) => (
  <Get<ReposettingsSecuritySettings, UsererrorError, void, FindSecuritySettingsPathParams>
    path={`/repos/${repo_ref}/settings/security`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindSecuritySettingsProps = Omit<
  UseGetProps<ReposettingsSecuritySettings, UsererrorError, void, FindSecuritySettingsPathParams>,
  'path'
> &
  FindSecuritySettingsPathParams

export const useFindSecuritySettings = ({ repo_ref, ...props }: UseFindSecuritySettingsProps) =>
  useGet<ReposettingsSecuritySettings, UsererrorError, void, FindSecuritySettingsPathParams>(
    (paramsInPath: FindSecuritySettingsPathParams) => `/repos/${paramsInPath.repo_ref}/settings/security`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface UpdateSecuritySettingsPathParams {
  repo_ref: string
}

export type UpdateSecuritySettingsProps = Omit<
  MutateProps<
    ReposettingsSecuritySettings,
    UsererrorError,
    void,
    OpenapiSecuritySettingsRequest,
    UpdateSecuritySettingsPathParams
  >,
  'path' | 'verb'
> &
  UpdateSecuritySettingsPathParams

export const UpdateSecuritySettings = ({ repo_ref, ...props }: UpdateSecuritySettingsProps) => (
  <Mutate<
    ReposettingsSecuritySettings,
    UsererrorError,
    void,
    OpenapiSecuritySettingsRequest,
    UpdateSecuritySettingsPathParams
  >
    verb="PATCH"
    path={`/repos/${repo_ref}/settings/security`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateSecuritySettingsProps = Omit<
  UseMutateProps<
    ReposettingsSecuritySettings,
    UsererrorError,
    void,
    OpenapiSecuritySettingsRequest,
    UpdateSecuritySettingsPathParams
  >,
  'path' | 'verb'
> &
  UpdateSecuritySettingsPathParams

export const useUpdateSecuritySettings = ({ repo_ref, ...props }: UseUpdateSecuritySettingsProps) =>
  useMutate<
    ReposettingsSecuritySettings,
    UsererrorError,
    void,
    OpenapiSecuritySettingsRequest,
    UpdateSecuritySettingsPathParams
  >('PATCH', (paramsInPath: UpdateSecuritySettingsPathParams) => `/repos/${paramsInPath.repo_ref}/settings/security`, {
    base: getConfig('api/v1'),
    pathParams: { repo_ref },
    ...props
  })

export interface SummaryPathParams {
  repo_ref: string
}

export type SummaryProps = Omit<GetProps<TypesRepositorySummary, UsererrorError, void, SummaryPathParams>, 'path'> &
  SummaryPathParams

export const Summary = ({ repo_ref, ...props }: SummaryProps) => (
  <Get<TypesRepositorySummary, UsererrorError, void, SummaryPathParams>
    path={`/repos/${repo_ref}/summary`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseSummaryProps = Omit<
  UseGetProps<TypesRepositorySummary, UsererrorError, void, SummaryPathParams>,
  'path'
> &
  SummaryPathParams

export const useSummary = ({ repo_ref, ...props }: UseSummaryProps) =>
  useGet<TypesRepositorySummary, UsererrorError, void, SummaryPathParams>(
    (paramsInPath: SummaryPathParams) => `/repos/${paramsInPath.repo_ref}/summary`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface ListTagsQueryParams {
  /**
   * Indicates whether optional commit information should be included in the response.
   */
  include_commit?: boolean
  /**
   * The substring by which the tags are filtered.
   */
  query?: string
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The data by which the tags are sorted.
   */
  sort?: 'name' | 'date'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListTagsPathParams {
  repo_ref: string
}

export type ListTagsProps = Omit<
  GetProps<RepoCommitTag[], UsererrorError, ListTagsQueryParams, ListTagsPathParams>,
  'path'
> &
  ListTagsPathParams

export const ListTags = ({ repo_ref, ...props }: ListTagsProps) => (
  <Get<RepoCommitTag[], UsererrorError, ListTagsQueryParams, ListTagsPathParams>
    path={`/repos/${repo_ref}/tags`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListTagsProps = Omit<
  UseGetProps<RepoCommitTag[], UsererrorError, ListTagsQueryParams, ListTagsPathParams>,
  'path'
> &
  ListTagsPathParams

export const useListTags = ({ repo_ref, ...props }: UseListTagsProps) =>
  useGet<RepoCommitTag[], UsererrorError, ListTagsQueryParams, ListTagsPathParams>(
    (paramsInPath: ListTagsPathParams) => `/repos/${paramsInPath.repo_ref}/tags`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CreateTagPathParams {
  repo_ref: string
}

export type CreateTagProps = Omit<
  MutateProps<RepoCommitTag, UsererrorError | TypesRulesViolations, void, OpenapiCreateTagRequest, CreateTagPathParams>,
  'path' | 'verb'
> &
  CreateTagPathParams

export const CreateTag = ({ repo_ref, ...props }: CreateTagProps) => (
  <Mutate<RepoCommitTag, UsererrorError | TypesRulesViolations, void, OpenapiCreateTagRequest, CreateTagPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/tags`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateTagProps = Omit<
  UseMutateProps<
    RepoCommitTag,
    UsererrorError | TypesRulesViolations,
    void,
    OpenapiCreateTagRequest,
    CreateTagPathParams
  >,
  'path' | 'verb'
> &
  CreateTagPathParams

export const useCreateTag = ({ repo_ref, ...props }: UseCreateTagProps) =>
  useMutate<RepoCommitTag, UsererrorError | TypesRulesViolations, void, OpenapiCreateTagRequest, CreateTagPathParams>(
    'POST',
    (paramsInPath: CreateTagPathParams) => `/repos/${paramsInPath.repo_ref}/tags`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface DeleteTagQueryParams {
  /**
   * Bypass rule violations if possible.
   */
  bypass_rules?: boolean
}

export interface DeleteTagPathParams {
  repo_ref: string
}

export type DeleteTagProps = Omit<
  MutateProps<void, UsererrorError | TypesRulesViolations, DeleteTagQueryParams, string, DeleteTagPathParams>,
  'path' | 'verb'
> &
  DeleteTagPathParams

export const DeleteTag = ({ repo_ref, ...props }: DeleteTagProps) => (
  <Mutate<void, UsererrorError | TypesRulesViolations, DeleteTagQueryParams, string, DeleteTagPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/tags`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteTagProps = Omit<
  UseMutateProps<void, UsererrorError | TypesRulesViolations, DeleteTagQueryParams, string, DeleteTagPathParams>,
  'path' | 'verb'
> &
  DeleteTagPathParams

export const useDeleteTag = ({ repo_ref, ...props }: UseDeleteTagProps) =>
  useMutate<void, UsererrorError | TypesRulesViolations, DeleteTagQueryParams, string, DeleteTagPathParams>(
    'DELETE',
    (paramsInPath: DeleteTagPathParams) => `/repos/${paramsInPath.repo_ref}/tags`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface RepoArtifactUploadPathParams {
  repo_ref: string
}

export type RepoArtifactUploadProps = Omit<
  MutateProps<UploadResult, UsererrorError, void, void, RepoArtifactUploadPathParams>,
  'path' | 'verb'
> &
  RepoArtifactUploadPathParams

export const RepoArtifactUpload = ({ repo_ref, ...props }: RepoArtifactUploadProps) => (
  <Mutate<UploadResult, UsererrorError, void, void, RepoArtifactUploadPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/uploads`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRepoArtifactUploadProps = Omit<
  UseMutateProps<UploadResult, UsererrorError, void, void, RepoArtifactUploadPathParams>,
  'path' | 'verb'
> &
  RepoArtifactUploadPathParams

export const useRepoArtifactUpload = ({ repo_ref, ...props }: UseRepoArtifactUploadProps) =>
  useMutate<UploadResult, UsererrorError, void, void, RepoArtifactUploadPathParams>(
    'POST',
    (paramsInPath: RepoArtifactUploadPathParams) => `/repos/${paramsInPath.repo_ref}/uploads`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface RepoArtifactDownloadPathParams {
  repo_ref: string
  file_ref: string
}

export type RepoArtifactDownloadProps = Omit<
  GetProps<void, UsererrorError, void, RepoArtifactDownloadPathParams>,
  'path'
> &
  RepoArtifactDownloadPathParams

export const RepoArtifactDownload = ({ repo_ref, file_ref, ...props }: RepoArtifactDownloadProps) => (
  <Get<void, UsererrorError, void, RepoArtifactDownloadPathParams>
    path={`/repos/${repo_ref}/uploads/${file_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRepoArtifactDownloadProps = Omit<
  UseGetProps<void, UsererrorError, void, RepoArtifactDownloadPathParams>,
  'path'
> &
  RepoArtifactDownloadPathParams

export const useRepoArtifactDownload = ({ repo_ref, file_ref, ...props }: UseRepoArtifactDownloadProps) =>
  useGet<void, UsererrorError, void, RepoArtifactDownloadPathParams>(
    (paramsInPath: RepoArtifactDownloadPathParams) =>
      `/repos/${paramsInPath.repo_ref}/uploads/${paramsInPath.file_ref}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, file_ref }, ...props }
  )

export interface ListWebhooksQueryParams {
  /**
   * The substring which is used to filter the webhooks by their identifier.
   */
  query?: string
  /**
   * The data by which the webhooks are sorted.
   */
  sort?: 'id' | 'uid' | 'display_name' | 'created' | 'updated'
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListWebhooksPathParams {
  repo_ref: string
}

export type ListWebhooksProps = Omit<
  GetProps<OpenapiWebhookType[], UsererrorError, ListWebhooksQueryParams, ListWebhooksPathParams>,
  'path'
> &
  ListWebhooksPathParams

export const ListWebhooks = ({ repo_ref, ...props }: ListWebhooksProps) => (
  <Get<OpenapiWebhookType[], UsererrorError, ListWebhooksQueryParams, ListWebhooksPathParams>
    path={`/repos/${repo_ref}/webhooks`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListWebhooksProps = Omit<
  UseGetProps<OpenapiWebhookType[], UsererrorError, ListWebhooksQueryParams, ListWebhooksPathParams>,
  'path'
> &
  ListWebhooksPathParams

export const useListWebhooks = ({ repo_ref, ...props }: UseListWebhooksProps) =>
  useGet<OpenapiWebhookType[], UsererrorError, ListWebhooksQueryParams, ListWebhooksPathParams>(
    (paramsInPath: ListWebhooksPathParams) => `/repos/${paramsInPath.repo_ref}/webhooks`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface CreateWebhookPathParams {
  repo_ref: string
}

export type CreateWebhookProps = Omit<
  MutateProps<OpenapiWebhookType, UsererrorError, void, OpenapiCreateWebhookRequest, CreateWebhookPathParams>,
  'path' | 'verb'
> &
  CreateWebhookPathParams

export const CreateWebhook = ({ repo_ref, ...props }: CreateWebhookProps) => (
  <Mutate<OpenapiWebhookType, UsererrorError, void, OpenapiCreateWebhookRequest, CreateWebhookPathParams>
    verb="POST"
    path={`/repos/${repo_ref}/webhooks`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateWebhookProps = Omit<
  UseMutateProps<OpenapiWebhookType, UsererrorError, void, OpenapiCreateWebhookRequest, CreateWebhookPathParams>,
  'path' | 'verb'
> &
  CreateWebhookPathParams

export const useCreateWebhook = ({ repo_ref, ...props }: UseCreateWebhookProps) =>
  useMutate<OpenapiWebhookType, UsererrorError, void, OpenapiCreateWebhookRequest, CreateWebhookPathParams>(
    'POST',
    (paramsInPath: CreateWebhookPathParams) => `/repos/${paramsInPath.repo_ref}/webhooks`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface DeleteWebhookPathParams {
  repo_ref: string
}

export type DeleteWebhookProps = Omit<
  MutateProps<void, UsererrorError, void, number, DeleteWebhookPathParams>,
  'path' | 'verb'
> &
  DeleteWebhookPathParams

export const DeleteWebhook = ({ repo_ref, ...props }: DeleteWebhookProps) => (
  <Mutate<void, UsererrorError, void, number, DeleteWebhookPathParams>
    verb="DELETE"
    path={`/repos/${repo_ref}/webhooks`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteWebhookProps = Omit<
  UseMutateProps<void, UsererrorError, void, number, DeleteWebhookPathParams>,
  'path' | 'verb'
> &
  DeleteWebhookPathParams

export const useDeleteWebhook = ({ repo_ref, ...props }: UseDeleteWebhookProps) =>
  useMutate<void, UsererrorError, void, number, DeleteWebhookPathParams>(
    'DELETE',
    (paramsInPath: DeleteWebhookPathParams) => `/repos/${paramsInPath.repo_ref}/webhooks`,
    { base: getConfig('api/v1'), pathParams: { repo_ref }, ...props }
  )

export interface GetWebhookPathParams {
  repo_ref: string
  webhook_identifier: number
}

export type GetWebhookProps = Omit<GetProps<OpenapiWebhookType, UsererrorError, void, GetWebhookPathParams>, 'path'> &
  GetWebhookPathParams

export const GetWebhook = ({ repo_ref, webhook_identifier, ...props }: GetWebhookProps) => (
  <Get<OpenapiWebhookType, UsererrorError, void, GetWebhookPathParams>
    path={`/repos/${repo_ref}/webhooks/${webhook_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetWebhookProps = Omit<
  UseGetProps<OpenapiWebhookType, UsererrorError, void, GetWebhookPathParams>,
  'path'
> &
  GetWebhookPathParams

export const useGetWebhook = ({ repo_ref, webhook_identifier, ...props }: UseGetWebhookProps) =>
  useGet<OpenapiWebhookType, UsererrorError, void, GetWebhookPathParams>(
    (paramsInPath: GetWebhookPathParams) =>
      `/repos/${paramsInPath.repo_ref}/webhooks/${paramsInPath.webhook_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, webhook_identifier }, ...props }
  )

export interface UpdateWebhookPathParams {
  repo_ref: string
  webhook_identifier: number
}

export type UpdateWebhookProps = Omit<
  MutateProps<OpenapiWebhookType, UsererrorError, void, OpenapiUpdateWebhookRequest, UpdateWebhookPathParams>,
  'path' | 'verb'
> &
  UpdateWebhookPathParams

export const UpdateWebhook = ({ repo_ref, webhook_identifier, ...props }: UpdateWebhookProps) => (
  <Mutate<OpenapiWebhookType, UsererrorError, void, OpenapiUpdateWebhookRequest, UpdateWebhookPathParams>
    verb="PATCH"
    path={`/repos/${repo_ref}/webhooks/${webhook_identifier}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateWebhookProps = Omit<
  UseMutateProps<OpenapiWebhookType, UsererrorError, void, OpenapiUpdateWebhookRequest, UpdateWebhookPathParams>,
  'path' | 'verb'
> &
  UpdateWebhookPathParams

export const useUpdateWebhook = ({ repo_ref, webhook_identifier, ...props }: UseUpdateWebhookProps) =>
  useMutate<OpenapiWebhookType, UsererrorError, void, OpenapiUpdateWebhookRequest, UpdateWebhookPathParams>(
    'PATCH',
    (paramsInPath: UpdateWebhookPathParams) =>
      `/repos/${paramsInPath.repo_ref}/webhooks/${paramsInPath.webhook_identifier}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, webhook_identifier }, ...props }
  )

export interface ListWebhookExecutionsQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListWebhookExecutionsPathParams {
  repo_ref: string
  webhook_identifier: number
}

export type ListWebhookExecutionsProps = Omit<
  GetProps<TypesWebhookExecution[], UsererrorError, ListWebhookExecutionsQueryParams, ListWebhookExecutionsPathParams>,
  'path'
> &
  ListWebhookExecutionsPathParams

export const ListWebhookExecutions = ({ repo_ref, webhook_identifier, ...props }: ListWebhookExecutionsProps) => (
  <Get<TypesWebhookExecution[], UsererrorError, ListWebhookExecutionsQueryParams, ListWebhookExecutionsPathParams>
    path={`/repos/${repo_ref}/webhooks/${webhook_identifier}/executions`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListWebhookExecutionsProps = Omit<
  UseGetProps<
    TypesWebhookExecution[],
    UsererrorError,
    ListWebhookExecutionsQueryParams,
    ListWebhookExecutionsPathParams
  >,
  'path'
> &
  ListWebhookExecutionsPathParams

export const useListWebhookExecutions = ({ repo_ref, webhook_identifier, ...props }: UseListWebhookExecutionsProps) =>
  useGet<TypesWebhookExecution[], UsererrorError, ListWebhookExecutionsQueryParams, ListWebhookExecutionsPathParams>(
    (paramsInPath: ListWebhookExecutionsPathParams) =>
      `/repos/${paramsInPath.repo_ref}/webhooks/${paramsInPath.webhook_identifier}/executions`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, webhook_identifier }, ...props }
  )

export interface GetWebhookExecutionQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface GetWebhookExecutionPathParams {
  repo_ref: string
  webhook_identifier: number
  webhook_execution_id: number
}

export type GetWebhookExecutionProps = Omit<
  GetProps<TypesWebhookExecution, UsererrorError, GetWebhookExecutionQueryParams, GetWebhookExecutionPathParams>,
  'path'
> &
  GetWebhookExecutionPathParams

export const GetWebhookExecution = ({
  repo_ref,
  webhook_identifier,
  webhook_execution_id,
  ...props
}: GetWebhookExecutionProps) => (
  <Get<TypesWebhookExecution, UsererrorError, GetWebhookExecutionQueryParams, GetWebhookExecutionPathParams>
    path={`/repos/${repo_ref}/webhooks/${webhook_identifier}/executions/${webhook_execution_id}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetWebhookExecutionProps = Omit<
  UseGetProps<TypesWebhookExecution, UsererrorError, GetWebhookExecutionQueryParams, GetWebhookExecutionPathParams>,
  'path'
> &
  GetWebhookExecutionPathParams

export const useGetWebhookExecution = ({
  repo_ref,
  webhook_identifier,
  webhook_execution_id,
  ...props
}: UseGetWebhookExecutionProps) =>
  useGet<TypesWebhookExecution, UsererrorError, GetWebhookExecutionQueryParams, GetWebhookExecutionPathParams>(
    (paramsInPath: GetWebhookExecutionPathParams) =>
      `/repos/${paramsInPath.repo_ref}/webhooks/${paramsInPath.webhook_identifier}/executions/${paramsInPath.webhook_execution_id}`,
    { base: getConfig('api/v1'), pathParams: { repo_ref, webhook_identifier, webhook_execution_id }, ...props }
  )

export interface ImportRepositoryQueryParams {
  /**
   * path of parent space (Not needed in standalone).
   */
  space_path?: string
}

export interface ImportRepositoryRequestBody {
  description?: string
  identifier?: string
  parent_ref?: string
  pipelines?: ImporterPipelineOption
  provider?: ImporterProvider
  provider_repo?: string
  uid?: string
}

export type ImportRepositoryProps = Omit<
  MutateProps<RepoRepositoryOutput, UsererrorError, ImportRepositoryQueryParams, ImportRepositoryRequestBody, void>,
  'path' | 'verb'
>

export const ImportRepository = (props: ImportRepositoryProps) => (
  <Mutate<RepoRepositoryOutput, UsererrorError, ImportRepositoryQueryParams, ImportRepositoryRequestBody, void>
    verb="POST"
    path={`/repos/import`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseImportRepositoryProps = Omit<
  UseMutateProps<RepoRepositoryOutput, UsererrorError, ImportRepositoryQueryParams, ImportRepositoryRequestBody, void>,
  'path' | 'verb'
>

export const useImportRepository = (props: UseImportRepositoryProps) =>
  useMutate<RepoRepositoryOutput, UsererrorError, ImportRepositoryQueryParams, ImportRepositoryRequestBody, void>(
    'POST',
    `/repos/import`,
    { base: getConfig('api/v1'), ...props }
  )

export type ListGitignoreProps = Omit<GetProps<string[], UsererrorError, void, void>, 'path'>

export const ListGitignore = (props: ListGitignoreProps) => (
  <Get<string[], UsererrorError, void, void> path={`/resources/gitignore`} base={getConfig('api/v1')} {...props} />
)

export type UseListGitignoreProps = Omit<UseGetProps<string[], UsererrorError, void, void>, 'path'>

export const useListGitignore = (props: UseListGitignoreProps) =>
  useGet<string[], UsererrorError, void, void>(`/resources/gitignore`, { base: getConfig('api/v1'), ...props })

export interface ListLicensesResponse {
  label?: string
  value?: string
}
;[]

export type ListLicensesProps = Omit<GetProps<ListLicensesResponse, UsererrorError, void, void>, 'path'>

export const ListLicenses = (props: ListLicensesProps) => (
  <Get<ListLicensesResponse, UsererrorError, void, void>
    path={`/resources/license`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListLicensesProps = Omit<UseGetProps<ListLicensesResponse, UsererrorError, void, void>, 'path'>

export const useListLicenses = (props: UseListLicensesProps) =>
  useGet<ListLicensesResponse, UsererrorError, void, void>(`/resources/license`, {
    base: getConfig('api/v1'),
    ...props
  })

export type CreateSecretProps = Omit<
  MutateProps<TypesSecret, UsererrorError, void, OpenapiCreateSecretRequest, void>,
  'path' | 'verb'
>

export const CreateSecret = (props: CreateSecretProps) => (
  <Mutate<TypesSecret, UsererrorError, void, OpenapiCreateSecretRequest, void>
    verb="POST"
    path={`/secrets`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateSecretProps = Omit<
  UseMutateProps<TypesSecret, UsererrorError, void, OpenapiCreateSecretRequest, void>,
  'path' | 'verb'
>

export const useCreateSecret = (props: UseCreateSecretProps) =>
  useMutate<TypesSecret, UsererrorError, void, OpenapiCreateSecretRequest, void>('POST', `/secrets`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeleteSecretProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const DeleteSecret = (props: DeleteSecretProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/secrets`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteSecretProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const useDeleteSecret = (props: UseDeleteSecretProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/secrets`, { base: getConfig('api/v1'), ...props })

export interface FindSecretPathParams {
  secret_ref: string
}

export type FindSecretProps = Omit<GetProps<TypesSecret, UsererrorError, void, FindSecretPathParams>, 'path'> &
  FindSecretPathParams

export const FindSecret = ({ secret_ref, ...props }: FindSecretProps) => (
  <Get<TypesSecret, UsererrorError, void, FindSecretPathParams>
    path={`/secrets/${secret_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindSecretProps = Omit<UseGetProps<TypesSecret, UsererrorError, void, FindSecretPathParams>, 'path'> &
  FindSecretPathParams

export const useFindSecret = ({ secret_ref, ...props }: UseFindSecretProps) =>
  useGet<TypesSecret, UsererrorError, void, FindSecretPathParams>(
    (paramsInPath: FindSecretPathParams) => `/secrets/${paramsInPath.secret_ref}`,
    { base: getConfig('api/v1'), pathParams: { secret_ref }, ...props }
  )

export interface UpdateSecretPathParams {
  secret_ref: string
}

export type UpdateSecretProps = Omit<
  MutateProps<TypesSecret, UsererrorError, void, OpenapiUpdateSecretRequest, UpdateSecretPathParams>,
  'path' | 'verb'
> &
  UpdateSecretPathParams

export const UpdateSecret = ({ secret_ref, ...props }: UpdateSecretProps) => (
  <Mutate<TypesSecret, UsererrorError, void, OpenapiUpdateSecretRequest, UpdateSecretPathParams>
    verb="PATCH"
    path={`/secrets/${secret_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateSecretProps = Omit<
  UseMutateProps<TypesSecret, UsererrorError, void, OpenapiUpdateSecretRequest, UpdateSecretPathParams>,
  'path' | 'verb'
> &
  UpdateSecretPathParams

export const useUpdateSecret = ({ secret_ref, ...props }: UseUpdateSecretProps) =>
  useMutate<TypesSecret, UsererrorError, void, OpenapiUpdateSecretRequest, UpdateSecretPathParams>(
    'PATCH',
    (paramsInPath: UpdateSecretPathParams) => `/secrets/${paramsInPath.secret_ref}`,
    { base: getConfig('api/v1'), pathParams: { secret_ref }, ...props }
  )

export type CreateSpaceProps = Omit<
  MutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiCreateSpaceRequest, void>,
  'path' | 'verb'
>

export const CreateSpace = (props: CreateSpaceProps) => (
  <Mutate<SpaceSpaceOutput, UsererrorError, void, OpenapiCreateSpaceRequest, void>
    verb="POST"
    path={`/spaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateSpaceProps = Omit<
  UseMutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiCreateSpaceRequest, void>,
  'path' | 'verb'
>

export const useCreateSpace = (props: UseCreateSpaceProps) =>
  useMutate<SpaceSpaceOutput, UsererrorError, void, OpenapiCreateSpaceRequest, void>('POST', `/spaces`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeleteSpaceProps = Omit<
  MutateProps<SpaceSoftDeleteResponse, UsererrorError, void, string, void>,
  'path' | 'verb'
>

export const DeleteSpace = (props: DeleteSpaceProps) => (
  <Mutate<SpaceSoftDeleteResponse, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/spaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteSpaceProps = Omit<
  UseMutateProps<SpaceSoftDeleteResponse, UsererrorError, void, string, void>,
  'path' | 'verb'
>

export const useDeleteSpace = (props: UseDeleteSpaceProps) =>
  useMutate<SpaceSoftDeleteResponse, UsererrorError, void, string, void>('DELETE', `/spaces`, {
    base: getConfig('api/v1'),
    ...props
  })

export interface GetSpacePathParams {
  space_ref: string
}

export type GetSpaceProps = Omit<GetProps<SpaceSpaceOutput, UsererrorError, void, GetSpacePathParams>, 'path'> &
  GetSpacePathParams

export const GetSpace = ({ space_ref, ...props }: GetSpaceProps) => (
  <Get<SpaceSpaceOutput, UsererrorError, void, GetSpacePathParams>
    path={`/spaces/${space_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseGetSpaceProps = Omit<UseGetProps<SpaceSpaceOutput, UsererrorError, void, GetSpacePathParams>, 'path'> &
  GetSpacePathParams

export const useGetSpace = ({ space_ref, ...props }: UseGetSpaceProps) =>
  useGet<SpaceSpaceOutput, UsererrorError, void, GetSpacePathParams>(
    (paramsInPath: GetSpacePathParams) => `/spaces/${paramsInPath.space_ref}`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface UpdateSpacePathParams {
  space_ref: string
}

export type UpdateSpaceProps = Omit<
  MutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiUpdateSpaceRequest, UpdateSpacePathParams>,
  'path' | 'verb'
> &
  UpdateSpacePathParams

export const UpdateSpace = ({ space_ref, ...props }: UpdateSpaceProps) => (
  <Mutate<SpaceSpaceOutput, UsererrorError, void, OpenapiUpdateSpaceRequest, UpdateSpacePathParams>
    verb="PATCH"
    path={`/spaces/${space_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateSpaceProps = Omit<
  UseMutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiUpdateSpaceRequest, UpdateSpacePathParams>,
  'path' | 'verb'
> &
  UpdateSpacePathParams

export const useUpdateSpace = ({ space_ref, ...props }: UseUpdateSpaceProps) =>
  useMutate<SpaceSpaceOutput, UsererrorError, void, OpenapiUpdateSpaceRequest, UpdateSpacePathParams>(
    'PATCH',
    (paramsInPath: UpdateSpacePathParams) => `/spaces/${paramsInPath.space_ref}`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ListConnectorsQueryParams {
  /**
   * The substring which is used to filter the repositories by their path name.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListConnectorsPathParams {
  space_ref: string
}

export type ListConnectorsProps = Omit<
  GetProps<TypesConnector[], UsererrorError, ListConnectorsQueryParams, ListConnectorsPathParams>,
  'path'
> &
  ListConnectorsPathParams

export const ListConnectors = ({ space_ref, ...props }: ListConnectorsProps) => (
  <Get<TypesConnector[], UsererrorError, ListConnectorsQueryParams, ListConnectorsPathParams>
    path={`/spaces/${space_ref}/connectors`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListConnectorsProps = Omit<
  UseGetProps<TypesConnector[], UsererrorError, ListConnectorsQueryParams, ListConnectorsPathParams>,
  'path'
> &
  ListConnectorsPathParams

export const useListConnectors = ({ space_ref, ...props }: UseListConnectorsProps) =>
  useGet<TypesConnector[], UsererrorError, ListConnectorsQueryParams, ListConnectorsPathParams>(
    (paramsInPath: ListConnectorsPathParams) => `/spaces/${paramsInPath.space_ref}/connectors`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ExportSpacePathParams {
  space_ref: string
}

export type ExportSpaceProps = Omit<
  MutateProps<void, UsererrorError, void, OpenapiExportSpaceRequest, ExportSpacePathParams>,
  'path' | 'verb'
> &
  ExportSpacePathParams

export const ExportSpace = ({ space_ref, ...props }: ExportSpaceProps) => (
  <Mutate<void, UsererrorError, void, OpenapiExportSpaceRequest, ExportSpacePathParams>
    verb="POST"
    path={`/spaces/${space_ref}/export`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseExportSpaceProps = Omit<
  UseMutateProps<void, UsererrorError, void, OpenapiExportSpaceRequest, ExportSpacePathParams>,
  'path' | 'verb'
> &
  ExportSpacePathParams

export const useExportSpace = ({ space_ref, ...props }: UseExportSpaceProps) =>
  useMutate<void, UsererrorError, void, OpenapiExportSpaceRequest, ExportSpacePathParams>(
    'POST',
    (paramsInPath: ExportSpacePathParams) => `/spaces/${paramsInPath.space_ref}/export`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ExportProgressSpacePathParams {
  space_ref: string
}

export type ExportProgressSpaceProps = Omit<
  GetProps<SpaceExportProgressOutput, UsererrorError, void, ExportProgressSpacePathParams>,
  'path'
> &
  ExportProgressSpacePathParams

export const ExportProgressSpace = ({ space_ref, ...props }: ExportProgressSpaceProps) => (
  <Get<SpaceExportProgressOutput, UsererrorError, void, ExportProgressSpacePathParams>
    path={`/spaces/${space_ref}/export-progress`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseExportProgressSpaceProps = Omit<
  UseGetProps<SpaceExportProgressOutput, UsererrorError, void, ExportProgressSpacePathParams>,
  'path'
> &
  ExportProgressSpacePathParams

export const useExportProgressSpace = ({ space_ref, ...props }: UseExportProgressSpaceProps) =>
  useGet<SpaceExportProgressOutput, UsererrorError, void, ExportProgressSpacePathParams>(
    (paramsInPath: ExportProgressSpacePathParams) => `/spaces/${paramsInPath.space_ref}/export-progress`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface MembershipListQueryParams {
  /**
   * The substring by which the space members are filtered.
   */
  query?: string
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The field by which the space members are sorted.
   */
  sort?: 'created' | 'name'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface MembershipListPathParams {
  space_ref: string
}

export type MembershipListProps = Omit<
  GetProps<TypesMembershipUser[], UsererrorError, MembershipListQueryParams, MembershipListPathParams>,
  'path'
> &
  MembershipListPathParams

export const MembershipList = ({ space_ref, ...props }: MembershipListProps) => (
  <Get<TypesMembershipUser[], UsererrorError, MembershipListQueryParams, MembershipListPathParams>
    path={`/spaces/${space_ref}/members`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMembershipListProps = Omit<
  UseGetProps<TypesMembershipUser[], UsererrorError, MembershipListQueryParams, MembershipListPathParams>,
  'path'
> &
  MembershipListPathParams

export const useMembershipList = ({ space_ref, ...props }: UseMembershipListProps) =>
  useGet<TypesMembershipUser[], UsererrorError, MembershipListQueryParams, MembershipListPathParams>(
    (paramsInPath: MembershipListPathParams) => `/spaces/${paramsInPath.space_ref}/members`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface MembershipAddPathParams {
  space_ref: string
}

export interface MembershipAddRequestBody {
  role?: EnumMembershipRole
  user_uid?: string
}

export type MembershipAddProps = Omit<
  MutateProps<TypesMembershipUser, UsererrorError, void, MembershipAddRequestBody, MembershipAddPathParams>,
  'path' | 'verb'
> &
  MembershipAddPathParams

export const MembershipAdd = ({ space_ref, ...props }: MembershipAddProps) => (
  <Mutate<TypesMembershipUser, UsererrorError, void, MembershipAddRequestBody, MembershipAddPathParams>
    verb="POST"
    path={`/spaces/${space_ref}/members`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMembershipAddProps = Omit<
  UseMutateProps<TypesMembershipUser, UsererrorError, void, MembershipAddRequestBody, MembershipAddPathParams>,
  'path' | 'verb'
> &
  MembershipAddPathParams

export const useMembershipAdd = ({ space_ref, ...props }: UseMembershipAddProps) =>
  useMutate<TypesMembershipUser, UsererrorError, void, MembershipAddRequestBody, MembershipAddPathParams>(
    'POST',
    (paramsInPath: MembershipAddPathParams) => `/spaces/${paramsInPath.space_ref}/members`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface MembershipDeletePathParams {
  space_ref: string
}

export type MembershipDeleteProps = Omit<
  MutateProps<void, UsererrorError, void, string, MembershipDeletePathParams>,
  'path' | 'verb'
> &
  MembershipDeletePathParams

export const MembershipDelete = ({ space_ref, ...props }: MembershipDeleteProps) => (
  <Mutate<void, UsererrorError, void, string, MembershipDeletePathParams>
    verb="DELETE"
    path={`/spaces/${space_ref}/members`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMembershipDeleteProps = Omit<
  UseMutateProps<void, UsererrorError, void, string, MembershipDeletePathParams>,
  'path' | 'verb'
> &
  MembershipDeletePathParams

export const useMembershipDelete = ({ space_ref, ...props }: UseMembershipDeleteProps) =>
  useMutate<void, UsererrorError, void, string, MembershipDeletePathParams>(
    'DELETE',
    (paramsInPath: MembershipDeletePathParams) => `/spaces/${paramsInPath.space_ref}/members`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface MembershipUpdatePathParams {
  space_ref: string
  user_uid: string
}

export interface MembershipUpdateRequestBody {
  role?: EnumMembershipRole
}

export type MembershipUpdateProps = Omit<
  MutateProps<TypesMembershipUser, UsererrorError, void, MembershipUpdateRequestBody, MembershipUpdatePathParams>,
  'path' | 'verb'
> &
  MembershipUpdatePathParams

export const MembershipUpdate = ({ space_ref, user_uid, ...props }: MembershipUpdateProps) => (
  <Mutate<TypesMembershipUser, UsererrorError, void, MembershipUpdateRequestBody, MembershipUpdatePathParams>
    verb="PATCH"
    path={`/spaces/${space_ref}/members/${user_uid}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMembershipUpdateProps = Omit<
  UseMutateProps<TypesMembershipUser, UsererrorError, void, MembershipUpdateRequestBody, MembershipUpdatePathParams>,
  'path' | 'verb'
> &
  MembershipUpdatePathParams

export const useMembershipUpdate = ({ space_ref, user_uid, ...props }: UseMembershipUpdateProps) =>
  useMutate<TypesMembershipUser, UsererrorError, void, MembershipUpdateRequestBody, MembershipUpdatePathParams>(
    'PATCH',
    (paramsInPath: MembershipUpdatePathParams) => `/spaces/${paramsInPath.space_ref}/members/${paramsInPath.user_uid}`,
    { base: getConfig('api/v1'), pathParams: { space_ref, user_uid }, ...props }
  )

export interface MoveSpacePathParams {
  space_ref: string
}

export type MoveSpaceProps = Omit<
  MutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiMoveSpaceRequest, MoveSpacePathParams>,
  'path' | 'verb'
> &
  MoveSpacePathParams

export const MoveSpace = ({ space_ref, ...props }: MoveSpaceProps) => (
  <Mutate<SpaceSpaceOutput, UsererrorError, void, OpenapiMoveSpaceRequest, MoveSpacePathParams>
    verb="POST"
    path={`/spaces/${space_ref}/move`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMoveSpaceProps = Omit<
  UseMutateProps<SpaceSpaceOutput, UsererrorError, void, OpenapiMoveSpaceRequest, MoveSpacePathParams>,
  'path' | 'verb'
> &
  MoveSpacePathParams

export const useMoveSpace = ({ space_ref, ...props }: UseMoveSpaceProps) =>
  useMutate<SpaceSpaceOutput, UsererrorError, void, OpenapiMoveSpaceRequest, MoveSpacePathParams>(
    'POST',
    (paramsInPath: MoveSpacePathParams) => `/spaces/${paramsInPath.space_ref}/move`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface UpdateSpacePublicAccessPathParams {
  space_ref: string
}

export type UpdateSpacePublicAccessProps = Omit<
  MutateProps<
    SpaceSpaceOutput,
    UsererrorError,
    void,
    OpenapiUpdateSpacePublicAccessRequest,
    UpdateSpacePublicAccessPathParams
  >,
  'path' | 'verb'
> &
  UpdateSpacePublicAccessPathParams

export const UpdateSpacePublicAccess = ({ space_ref, ...props }: UpdateSpacePublicAccessProps) => (
  <Mutate<
    SpaceSpaceOutput,
    UsererrorError,
    void,
    OpenapiUpdateSpacePublicAccessRequest,
    UpdateSpacePublicAccessPathParams
  >
    verb="POST"
    path={`/spaces/${space_ref}/public-access`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateSpacePublicAccessProps = Omit<
  UseMutateProps<
    SpaceSpaceOutput,
    UsererrorError,
    void,
    OpenapiUpdateSpacePublicAccessRequest,
    UpdateSpacePublicAccessPathParams
  >,
  'path' | 'verb'
> &
  UpdateSpacePublicAccessPathParams

export const useUpdateSpacePublicAccess = ({ space_ref, ...props }: UseUpdateSpacePublicAccessProps) =>
  useMutate<
    SpaceSpaceOutput,
    UsererrorError,
    void,
    OpenapiUpdateSpacePublicAccessRequest,
    UpdateSpacePublicAccessPathParams
  >('POST', (paramsInPath: UpdateSpacePublicAccessPathParams) => `/spaces/${paramsInPath.space_ref}/public-access`, {
    base: getConfig('api/v1'),
    pathParams: { space_ref },
    ...props
  })

export interface PurgeSpaceQueryParams {
  /**
   * The exact time the resource was delete at in epoch format.
   */
  deleted_at: number
}

export interface PurgeSpacePathParams {
  space_ref: string
}

export type PurgeSpaceProps = Omit<
  MutateProps<void, UsererrorError, PurgeSpaceQueryParams, void, PurgeSpacePathParams>,
  'path' | 'verb'
> &
  PurgeSpacePathParams

export const PurgeSpace = ({ space_ref, ...props }: PurgeSpaceProps) => (
  <Mutate<void, UsererrorError, PurgeSpaceQueryParams, void, PurgeSpacePathParams>
    verb="POST"
    path={`/spaces/${space_ref}/purge`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UsePurgeSpaceProps = Omit<
  UseMutateProps<void, UsererrorError, PurgeSpaceQueryParams, void, PurgeSpacePathParams>,
  'path' | 'verb'
> &
  PurgeSpacePathParams

export const usePurgeSpace = ({ space_ref, ...props }: UsePurgeSpaceProps) =>
  useMutate<void, UsererrorError, PurgeSpaceQueryParams, void, PurgeSpacePathParams>(
    'POST',
    (paramsInPath: PurgeSpacePathParams) => `/spaces/${paramsInPath.space_ref}/purge`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface RestoreSpaceQueryParams {
  /**
   * The exact time the resource was delete at in epoch format.
   */
  deleted_at: number
}

export interface RestoreSpacePathParams {
  space_ref: string
}

export type RestoreSpaceProps = Omit<
  MutateProps<
    SpaceSpaceOutput,
    UsererrorError,
    RestoreSpaceQueryParams,
    OpenapiRestoreSpaceRequest,
    RestoreSpacePathParams
  >,
  'path' | 'verb'
> &
  RestoreSpacePathParams

export const RestoreSpace = ({ space_ref, ...props }: RestoreSpaceProps) => (
  <Mutate<SpaceSpaceOutput, UsererrorError, RestoreSpaceQueryParams, OpenapiRestoreSpaceRequest, RestoreSpacePathParams>
    verb="POST"
    path={`/spaces/${space_ref}/restore`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseRestoreSpaceProps = Omit<
  UseMutateProps<
    SpaceSpaceOutput,
    UsererrorError,
    RestoreSpaceQueryParams,
    OpenapiRestoreSpaceRequest,
    RestoreSpacePathParams
  >,
  'path' | 'verb'
> &
  RestoreSpacePathParams

export const useRestoreSpace = ({ space_ref, ...props }: UseRestoreSpaceProps) =>
  useMutate<
    SpaceSpaceOutput,
    UsererrorError,
    RestoreSpaceQueryParams,
    OpenapiRestoreSpaceRequest,
    RestoreSpacePathParams
  >('POST', (paramsInPath: RestoreSpacePathParams) => `/spaces/${paramsInPath.space_ref}/restore`, {
    base: getConfig('api/v1'),
    pathParams: { space_ref },
    ...props
  })

export interface ListSecretsQueryParams {
  /**
   * The substring which is used to filter the repositories by their path name.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListSecretsPathParams {
  space_ref: string
}

export type ListSecretsProps = Omit<
  GetProps<TypesSecret[], UsererrorError, ListSecretsQueryParams, ListSecretsPathParams>,
  'path'
> &
  ListSecretsPathParams

export const ListSecrets = ({ space_ref, ...props }: ListSecretsProps) => (
  <Get<TypesSecret[], UsererrorError, ListSecretsQueryParams, ListSecretsPathParams>
    path={`/spaces/${space_ref}/secrets`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListSecretsProps = Omit<
  UseGetProps<TypesSecret[], UsererrorError, ListSecretsQueryParams, ListSecretsPathParams>,
  'path'
> &
  ListSecretsPathParams

export const useListSecrets = ({ space_ref, ...props }: UseListSecretsProps) =>
  useGet<TypesSecret[], UsererrorError, ListSecretsQueryParams, ListSecretsPathParams>(
    (paramsInPath: ListSecretsPathParams) => `/spaces/${paramsInPath.space_ref}/secrets`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ListServiceAccountsPathParams {
  space_ref: string
}

export type ListServiceAccountsProps = Omit<
  GetProps<TypesServiceAccount[], UsererrorError, void, ListServiceAccountsPathParams>,
  'path'
> &
  ListServiceAccountsPathParams

export const ListServiceAccounts = ({ space_ref, ...props }: ListServiceAccountsProps) => (
  <Get<TypesServiceAccount[], UsererrorError, void, ListServiceAccountsPathParams>
    path={`/spaces/${space_ref}/service-accounts`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListServiceAccountsProps = Omit<
  UseGetProps<TypesServiceAccount[], UsererrorError, void, ListServiceAccountsPathParams>,
  'path'
> &
  ListServiceAccountsPathParams

export const useListServiceAccounts = ({ space_ref, ...props }: UseListServiceAccountsProps) =>
  useGet<TypesServiceAccount[], UsererrorError, void, ListServiceAccountsPathParams>(
    (paramsInPath: ListServiceAccountsPathParams) => `/spaces/${paramsInPath.space_ref}/service-accounts`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ListSpacesQueryParams {
  /**
   * The substring which is used to filter the spaces by their path name.
   */
  query?: string
  /**
   * The data by which the spaces are sorted.
   */
  sort?: 'identifier' | 'created' | 'updated'
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListSpacesPathParams {
  space_ref: string
}

export type ListSpacesProps = Omit<
  GetProps<SpaceSpaceOutput[], UsererrorError, ListSpacesQueryParams, ListSpacesPathParams>,
  'path'
> &
  ListSpacesPathParams

export const ListSpaces = ({ space_ref, ...props }: ListSpacesProps) => (
  <Get<SpaceSpaceOutput[], UsererrorError, ListSpacesQueryParams, ListSpacesPathParams>
    path={`/spaces/${space_ref}/spaces`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListSpacesProps = Omit<
  UseGetProps<SpaceSpaceOutput[], UsererrorError, ListSpacesQueryParams, ListSpacesPathParams>,
  'path'
> &
  ListSpacesPathParams

export const useListSpaces = ({ space_ref, ...props }: UseListSpacesProps) =>
  useGet<SpaceSpaceOutput[], UsererrorError, ListSpacesQueryParams, ListSpacesPathParams>(
    (paramsInPath: ListSpacesPathParams) => `/spaces/${paramsInPath.space_ref}/spaces`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ListTemplatesQueryParams {
  /**
   * The substring which is used to filter the repositories by their path name.
   */
  query?: string
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export interface ListTemplatesPathParams {
  space_ref: string
}

export type ListTemplatesProps = Omit<
  GetProps<TypesTemplate[], UsererrorError, ListTemplatesQueryParams, ListTemplatesPathParams>,
  'path'
> &
  ListTemplatesPathParams

export const ListTemplates = ({ space_ref, ...props }: ListTemplatesProps) => (
  <Get<TypesTemplate[], UsererrorError, ListTemplatesQueryParams, ListTemplatesPathParams>
    path={`/spaces/${space_ref}/templates`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListTemplatesProps = Omit<
  UseGetProps<TypesTemplate[], UsererrorError, ListTemplatesQueryParams, ListTemplatesPathParams>,
  'path'
> &
  ListTemplatesPathParams

export const useListTemplates = ({ space_ref, ...props }: UseListTemplatesProps) =>
  useGet<TypesTemplate[], UsererrorError, ListTemplatesQueryParams, ListTemplatesPathParams>(
    (paramsInPath: ListTemplatesPathParams) => `/spaces/${paramsInPath.space_ref}/templates`,
    { base: getConfig('api/v1'), pathParams: { space_ref }, ...props }
  )

export interface ImportSpaceRequestBody {
  description?: string
  identifier?: string
  is_public?: boolean
  parent_ref?: string
  pipelines?: ImporterPipelineOption
  provider?: ImporterProvider
  provider_space?: string
  uid?: string
}

export type ImportSpaceProps = Omit<
  MutateProps<SpaceSpaceOutput, UsererrorError, void, ImportSpaceRequestBody, void>,
  'path' | 'verb'
>

export const ImportSpace = (props: ImportSpaceProps) => (
  <Mutate<SpaceSpaceOutput, UsererrorError, void, ImportSpaceRequestBody, void>
    verb="POST"
    path={`/spaces/import`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseImportSpaceProps = Omit<
  UseMutateProps<SpaceSpaceOutput, UsererrorError, void, ImportSpaceRequestBody, void>,
  'path' | 'verb'
>

export const useImportSpace = (props: UseImportSpaceProps) =>
  useMutate<SpaceSpaceOutput, UsererrorError, void, ImportSpaceRequestBody, void>('POST', `/spaces/import`, {
    base: getConfig('api/v1'),
    ...props
  })

export type GetSystemConfigProps = Omit<GetProps<SystemConfigOutput, UsererrorError, void, void>, 'path'>

export const GetSystemConfig = (props: GetSystemConfigProps) => (
  <Get<SystemConfigOutput, UsererrorError, void, void> path={`/system/config`} base={getConfig('api/v1')} {...props} />
)

export type UseGetSystemConfigProps = Omit<UseGetProps<SystemConfigOutput, UsererrorError, void, void>, 'path'>

export const useGetSystemConfig = (props: UseGetSystemConfigProps) =>
  useGet<SystemConfigOutput, UsererrorError, void, void>(`/system/config`, { base: getConfig('api/v1'), ...props })

export type CreateTemplateProps = Omit<
  MutateProps<TypesTemplate, UsererrorError, void, OpenapiCreateTemplateRequest, void>,
  'path' | 'verb'
>

export const CreateTemplate = (props: CreateTemplateProps) => (
  <Mutate<TypesTemplate, UsererrorError, void, OpenapiCreateTemplateRequest, void>
    verb="POST"
    path={`/templates`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateTemplateProps = Omit<
  UseMutateProps<TypesTemplate, UsererrorError, void, OpenapiCreateTemplateRequest, void>,
  'path' | 'verb'
>

export const useCreateTemplate = (props: UseCreateTemplateProps) =>
  useMutate<TypesTemplate, UsererrorError, void, OpenapiCreateTemplateRequest, void>('POST', `/templates`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeleteTemplateProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const DeleteTemplate = (props: DeleteTemplateProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/templates`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeleteTemplateProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const useDeleteTemplate = (props: UseDeleteTemplateProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/templates`, { base: getConfig('api/v1'), ...props })

export interface FindTemplatePathParams {
  template_ref: string
}

export type FindTemplateProps = Omit<GetProps<TypesTemplate, UsererrorError, void, FindTemplatePathParams>, 'path'> &
  FindTemplatePathParams

export const FindTemplate = ({ template_ref, ...props }: FindTemplateProps) => (
  <Get<TypesTemplate, UsererrorError, void, FindTemplatePathParams>
    path={`/templates/${template_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseFindTemplateProps = Omit<
  UseGetProps<TypesTemplate, UsererrorError, void, FindTemplatePathParams>,
  'path'
> &
  FindTemplatePathParams

export const useFindTemplate = ({ template_ref, ...props }: UseFindTemplateProps) =>
  useGet<TypesTemplate, UsererrorError, void, FindTemplatePathParams>(
    (paramsInPath: FindTemplatePathParams) => `/templates/${paramsInPath.template_ref}`,
    { base: getConfig('api/v1'), pathParams: { template_ref }, ...props }
  )

export interface UpdateTemplatePathParams {
  template_ref: string
}

export type UpdateTemplateProps = Omit<
  MutateProps<TypesTemplate, UsererrorError, void, OpenapiUpdateTemplateRequest, UpdateTemplatePathParams>,
  'path' | 'verb'
> &
  UpdateTemplatePathParams

export const UpdateTemplate = ({ template_ref, ...props }: UpdateTemplateProps) => (
  <Mutate<TypesTemplate, UsererrorError, void, OpenapiUpdateTemplateRequest, UpdateTemplatePathParams>
    verb="PATCH"
    path={`/templates/${template_ref}`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateTemplateProps = Omit<
  UseMutateProps<TypesTemplate, UsererrorError, void, OpenapiUpdateTemplateRequest, UpdateTemplatePathParams>,
  'path' | 'verb'
> &
  UpdateTemplatePathParams

export const useUpdateTemplate = ({ template_ref, ...props }: UseUpdateTemplateProps) =>
  useMutate<TypesTemplate, UsererrorError, void, OpenapiUpdateTemplateRequest, UpdateTemplatePathParams>(
    'PATCH',
    (paramsInPath: UpdateTemplatePathParams) => `/templates/${paramsInPath.template_ref}`,
    { base: getConfig('api/v1'), pathParams: { template_ref }, ...props }
  )

export type GetUserProps = Omit<GetProps<TypesUser, UsererrorError, void, void>, 'path'>

export const GetUser = (props: GetUserProps) => (
  <Get<TypesUser, UsererrorError, void, void> path={`/user`} base={getConfig('api/v1')} {...props} />
)

export type UseGetUserProps = Omit<UseGetProps<TypesUser, UsererrorError, void, void>, 'path'>

export const useGetUser = (props: UseGetUserProps) =>
  useGet<TypesUser, UsererrorError, void, void>(`/user`, { base: getConfig('api/v1'), ...props })

export type UpdateUserProps = Omit<MutateProps<TypesUser, UsererrorError, void, UserUpdateInput, void>, 'path' | 'verb'>

export const UpdateUser = (props: UpdateUserProps) => (
  <Mutate<TypesUser, UsererrorError, void, UserUpdateInput, void>
    verb="PATCH"
    path={`/user`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseUpdateUserProps = Omit<
  UseMutateProps<TypesUser, UsererrorError, void, UserUpdateInput, void>,
  'path' | 'verb'
>

export const useUpdateUser = (props: UseUpdateUserProps) =>
  useMutate<TypesUser, UsererrorError, void, UserUpdateInput, void>('PATCH', `/user`, {
    base: getConfig('api/v1'),
    ...props
  })

export interface ListPublicKeyQueryParams {
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
  /**
   * The substring which is used to filter the public keys by their path identifier.
   */
  query?: string
  /**
   * The data by which the public keys are sorted.
   */
  sort?: 'created' | 'identifier'
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
}

export type ListPublicKeyProps = Omit<
  GetProps<TypesPublicKey[], UsererrorError, ListPublicKeyQueryParams, void>,
  'path'
>

export const ListPublicKey = (props: ListPublicKeyProps) => (
  <Get<TypesPublicKey[], UsererrorError, ListPublicKeyQueryParams, void>
    path={`/user/keys`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseListPublicKeyProps = Omit<
  UseGetProps<TypesPublicKey[], UsererrorError, ListPublicKeyQueryParams, void>,
  'path'
>

export const useListPublicKey = (props: UseListPublicKeyProps) =>
  useGet<TypesPublicKey[], UsererrorError, ListPublicKeyQueryParams, void>(`/user/keys`, {
    base: getConfig('api/v1'),
    ...props
  })

export type CreatePublicKeyProps = Omit<
  MutateProps<TypesPublicKey, UsererrorError, void, UserCreatePublicKeyInput, void>,
  'path' | 'verb'
>

export const CreatePublicKey = (props: CreatePublicKeyProps) => (
  <Mutate<TypesPublicKey, UsererrorError, void, UserCreatePublicKeyInput, void>
    verb="POST"
    path={`/user/keys`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreatePublicKeyProps = Omit<
  UseMutateProps<TypesPublicKey, UsererrorError, void, UserCreatePublicKeyInput, void>,
  'path' | 'verb'
>

export const useCreatePublicKey = (props: UseCreatePublicKeyProps) =>
  useMutate<TypesPublicKey, UsererrorError, void, UserCreatePublicKeyInput, void>('POST', `/user/keys`, {
    base: getConfig('api/v1'),
    ...props
  })

export type DeletePublicKeyProps = Omit<MutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const DeletePublicKey = (props: DeletePublicKeyProps) => (
  <Mutate<void, UsererrorError, void, string, void>
    verb="DELETE"
    path={`/user/keys`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseDeletePublicKeyProps = Omit<UseMutateProps<void, UsererrorError, void, string, void>, 'path' | 'verb'>

export const useDeletePublicKey = (props: UseDeletePublicKeyProps) =>
  useMutate<void, UsererrorError, void, string, void>('DELETE', `/user/keys`, { base: getConfig('api/v1'), ...props })

export interface MembershipSpacesQueryParams {
  /**
   * The substring by which the spaces the users is a member of are filtered.
   */
  query?: string
  /**
   * The order of the output.
   */
  order?: 'asc' | 'desc'
  /**
   * The field by which the spaces the user is a member of are sorted.
   */
  sort?: 'created' | 'identifier' | 'uid'
  /**
   * The page to return.
   */
  page?: number
  /**
   * The maximum number of results to return.
   */
  limit?: number
}

export type MembershipSpacesProps = Omit<
  GetProps<TypesMembershipSpace[], UsererrorError, MembershipSpacesQueryParams, void>,
  'path'
>

export const MembershipSpaces = (props: MembershipSpacesProps) => (
  <Get<TypesMembershipSpace[], UsererrorError, MembershipSpacesQueryParams, void>
    path={`/user/memberships`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseMembershipSpacesProps = Omit<
  UseGetProps<TypesMembershipSpace[], UsererrorError, MembershipSpacesQueryParams, void>,
  'path'
>

export const useMembershipSpaces = (props: UseMembershipSpacesProps) =>
  useGet<TypesMembershipSpace[], UsererrorError, MembershipSpacesQueryParams, void>(`/user/memberships`, {
    base: getConfig('api/v1'),
    ...props
  })

export type CreateTokenProps = Omit<
  MutateProps<TypesTokenResponse, UsererrorError, void, OpenapiCreateTokenRequest, void>,
  'path' | 'verb'
>

export const CreateToken = (props: CreateTokenProps) => (
  <Mutate<TypesTokenResponse, UsererrorError, void, OpenapiCreateTokenRequest, void>
    verb="POST"
    path={`/user/token`}
    base={getConfig('api/v1')}
    {...props}
  />
)

export type UseCreateTokenProps = Omit<
  UseMutateProps<TypesTokenResponse, UsererrorError, void, OpenapiCreateTokenRequest, void>,
  'path' | 'verb'
>

export const useCreateToken = (props: UseCreateTokenProps) =>
  useMutate<TypesTokenResponse, UsererrorError, void, OpenapiCreateTokenRequest, void>('POST', `/user/token`, {
    base: getConfig('api/v1'),
    ...props
  })
