// Package artifact provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen/v2 version v2.1.0 DO NOT EDIT.
package artifact

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/getkin/kin-openapi/openapi3"
	"github.com/go-chi/chi/v5"
	"github.com/oapi-codegen/runtime"
	strictnethttp "github.com/oapi-codegen/runtime/strictmiddleware/nethttp"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Create Registry.
	// (POST /registry)
	CreateRegistry(w http.ResponseWriter, r *http.Request, params CreateRegistryParams)
	// Delete a Registry
	// (DELETE /registry/{registry_ref})
	DeleteRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam)
	// Returns Registry Details
	// (GET /registry/{registry_ref})
	GetRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam)
	// Updates a Registry
	// (PUT /registry/{registry_ref})
	ModifyRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam)
	// List Artifact Labels
	// (GET /registry/{registry_ref}/artifact/labels)
	ListArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params ListArtifactLabelsParams)
	// Get Artifact Stats
	// (GET /registry/{registry_ref}/artifact/stats)
	GetArtifactStatsForRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetArtifactStatsForRegistryParams)
	// Delete Artifact
	// (DELETE /registry/{registry_ref}/artifact/{artifact})
	DeleteArtifact(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam)
	// Update Artifact Labels
	// (PUT /registry/{registry_ref}/artifact/{artifact}/labels)
	UpdateArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam)
	// Get Artifact Stats
	// (GET /registry/{registry_ref}/artifact/{artifact}/stats)
	GetArtifactStats(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetArtifactStatsParams)
	// Get Artifact Summary
	// (GET /registry/{registry_ref}/artifact/{artifact}/summary)
	GetArtifactSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam)
	// Delete an Artifact Version
	// (DELETE /registry/{registry_ref}/artifact/{artifact}/version/{version})
	DeleteArtifactVersion(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam)
	// Describe Docker Artifact Detail
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/details)
	GetDockerArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactDetailsParams)
	// Describe Docker Artifact Layers
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/layers)
	GetDockerArtifactLayers(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactLayersParams)
	// Describe Docker Artifact Manifest
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifest)
	GetDockerArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactManifestParams)
	// Describe Docker Artifact Manifests
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifests)
	GetDockerArtifactManifests(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam)
	// Describe Helm Artifact Detail
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/details)
	GetHelmArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam)
	// Describe Helm Artifact Manifest
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/manifest)
	GetHelmArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam)
	// Get Artifact Version Summary
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/summary)
	GetArtifactVersionSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam)
	// List Artifact Versions
	// (GET /registry/{registry_ref}/artifact/{artifact}/versions)
	GetAllArtifactVersions(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetAllArtifactVersionsParams)
	// List Artifacts for Registry
	// (GET /registry/{registry_ref}/artifacts)
	GetAllArtifactsByRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetAllArtifactsByRegistryParams)
	// Returns CLI Client Setup Details
	// (GET /registry/{registry_ref}/client-setup-details)
	GetClientSetupDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetClientSetupDetailsParams)
	// Get Artifact Stats
	// (GET /spaces/{space_ref}/artifact/stats)
	GetArtifactStatsForSpace(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetArtifactStatsForSpaceParams)
	// List Artifacts
	// (GET /spaces/{space_ref}/artifacts)
	GetAllArtifacts(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllArtifactsParams)
	// List Registries
	// (GET /spaces/{space_ref}/registries)
	GetAllRegistries(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllRegistriesParams)
}

// Unimplemented server implementation that returns http.StatusNotImplemented for each endpoint.

type Unimplemented struct{}

// Create Registry.
// (POST /registry)
func (_ Unimplemented) CreateRegistry(w http.ResponseWriter, r *http.Request, params CreateRegistryParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Delete a Registry
// (DELETE /registry/{registry_ref})
func (_ Unimplemented) DeleteRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Returns Registry Details
// (GET /registry/{registry_ref})
func (_ Unimplemented) GetRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Updates a Registry
// (PUT /registry/{registry_ref})
func (_ Unimplemented) ModifyRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// List Artifact Labels
// (GET /registry/{registry_ref}/artifact/labels)
func (_ Unimplemented) ListArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params ListArtifactLabelsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Get Artifact Stats
// (GET /registry/{registry_ref}/artifact/stats)
func (_ Unimplemented) GetArtifactStatsForRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetArtifactStatsForRegistryParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Delete Artifact
// (DELETE /registry/{registry_ref}/artifact/{artifact})
func (_ Unimplemented) DeleteArtifact(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Update Artifact Labels
// (PUT /registry/{registry_ref}/artifact/{artifact}/labels)
func (_ Unimplemented) UpdateArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Get Artifact Stats
// (GET /registry/{registry_ref}/artifact/{artifact}/stats)
func (_ Unimplemented) GetArtifactStats(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetArtifactStatsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Get Artifact Summary
// (GET /registry/{registry_ref}/artifact/{artifact}/summary)
func (_ Unimplemented) GetArtifactSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Delete an Artifact Version
// (DELETE /registry/{registry_ref}/artifact/{artifact}/version/{version})
func (_ Unimplemented) DeleteArtifactVersion(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Docker Artifact Detail
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/details)
func (_ Unimplemented) GetDockerArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactDetailsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Docker Artifact Layers
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/layers)
func (_ Unimplemented) GetDockerArtifactLayers(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactLayersParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Docker Artifact Manifest
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifest)
func (_ Unimplemented) GetDockerArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactManifestParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Docker Artifact Manifests
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifests)
func (_ Unimplemented) GetDockerArtifactManifests(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Helm Artifact Detail
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/details)
func (_ Unimplemented) GetHelmArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Describe Helm Artifact Manifest
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/manifest)
func (_ Unimplemented) GetHelmArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Get Artifact Version Summary
// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/summary)
func (_ Unimplemented) GetArtifactVersionSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	w.WriteHeader(http.StatusNotImplemented)
}

// List Artifact Versions
// (GET /registry/{registry_ref}/artifact/{artifact}/versions)
func (_ Unimplemented) GetAllArtifactVersions(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetAllArtifactVersionsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// List Artifacts for Registry
// (GET /registry/{registry_ref}/artifacts)
func (_ Unimplemented) GetAllArtifactsByRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetAllArtifactsByRegistryParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Returns CLI Client Setup Details
// (GET /registry/{registry_ref}/client-setup-details)
func (_ Unimplemented) GetClientSetupDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetClientSetupDetailsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// Get Artifact Stats
// (GET /spaces/{space_ref}/artifact/stats)
func (_ Unimplemented) GetArtifactStatsForSpace(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetArtifactStatsForSpaceParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// List Artifacts
// (GET /spaces/{space_ref}/artifacts)
func (_ Unimplemented) GetAllArtifacts(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllArtifactsParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// List Registries
// (GET /spaces/{space_ref}/registries)
func (_ Unimplemented) GetAllRegistries(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllRegistriesParams) {
	w.WriteHeader(http.StatusNotImplemented)
}

// ServerInterfaceWrapper converts contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler            ServerInterface
	HandlerMiddlewares []MiddlewareFunc
	ErrorHandlerFunc   func(w http.ResponseWriter, r *http.Request, err error)
}

type MiddlewareFunc func(http.Handler) http.Handler

// CreateRegistry operation middleware
func (siw *ServerInterfaceWrapper) CreateRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params CreateRegistryParams

	// ------------- Optional query parameter "space_ref" -------------

	err = runtime.BindQueryParameter("form", true, false, "space_ref", r.URL.Query(), &params.SpaceRef)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "space_ref", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.CreateRegistry(w, r, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// DeleteRegistry operation middleware
func (siw *ServerInterfaceWrapper) DeleteRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteRegistry(w, r, registryRef)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetRegistry operation middleware
func (siw *ServerInterfaceWrapper) GetRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetRegistry(w, r, registryRef)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ModifyRegistry operation middleware
func (siw *ServerInterfaceWrapper) ModifyRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ModifyRegistry(w, r, registryRef)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// ListArtifactLabels operation middleware
func (siw *ServerInterfaceWrapper) ListArtifactLabels(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params ListArtifactLabelsParams

	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", r.URL.Query(), &params.Page)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page", Err: err})
		return
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", r.URL.Query(), &params.Size)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "size", Err: err})
		return
	}

	// ------------- Optional query parameter "search_term" -------------

	err = runtime.BindQueryParameter("form", true, false, "search_term", r.URL.Query(), &params.SearchTerm)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "search_term", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.ListArtifactLabels(w, r, registryRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetArtifactStatsForRegistry operation middleware
func (siw *ServerInterfaceWrapper) GetArtifactStatsForRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetArtifactStatsForRegistryParams

	// ------------- Optional query parameter "from" -------------

	err = runtime.BindQueryParameter("form", true, false, "from", r.URL.Query(), &params.From)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "from", Err: err})
		return
	}

	// ------------- Optional query parameter "to" -------------

	err = runtime.BindQueryParameter("form", true, false, "to", r.URL.Query(), &params.To)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "to", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetArtifactStatsForRegistry(w, r, registryRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// DeleteArtifact operation middleware
func (siw *ServerInterfaceWrapper) DeleteArtifact(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteArtifact(w, r, registryRef, artifact)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// UpdateArtifactLabels operation middleware
func (siw *ServerInterfaceWrapper) UpdateArtifactLabels(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.UpdateArtifactLabels(w, r, registryRef, artifact)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetArtifactStats operation middleware
func (siw *ServerInterfaceWrapper) GetArtifactStats(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetArtifactStatsParams

	// ------------- Optional query parameter "from" -------------

	err = runtime.BindQueryParameter("form", true, false, "from", r.URL.Query(), &params.From)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "from", Err: err})
		return
	}

	// ------------- Optional query parameter "to" -------------

	err = runtime.BindQueryParameter("form", true, false, "to", r.URL.Query(), &params.To)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "to", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetArtifactStats(w, r, registryRef, artifact, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetArtifactSummary operation middleware
func (siw *ServerInterfaceWrapper) GetArtifactSummary(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetArtifactSummary(w, r, registryRef, artifact)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// DeleteArtifactVersion operation middleware
func (siw *ServerInterfaceWrapper) DeleteArtifactVersion(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.DeleteArtifactVersion(w, r, registryRef, artifact, version)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetDockerArtifactDetails operation middleware
func (siw *ServerInterfaceWrapper) GetDockerArtifactDetails(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetDockerArtifactDetailsParams

	// ------------- Required query parameter "digest" -------------

	if paramValue := r.URL.Query().Get("digest"); paramValue != "" {

	} else {
		siw.ErrorHandlerFunc(w, r, &RequiredParamError{ParamName: "digest"})
		return
	}

	err = runtime.BindQueryParameter("form", true, true, "digest", r.URL.Query(), &params.Digest)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "digest", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDockerArtifactDetails(w, r, registryRef, artifact, version, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetDockerArtifactLayers operation middleware
func (siw *ServerInterfaceWrapper) GetDockerArtifactLayers(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetDockerArtifactLayersParams

	// ------------- Required query parameter "digest" -------------

	if paramValue := r.URL.Query().Get("digest"); paramValue != "" {

	} else {
		siw.ErrorHandlerFunc(w, r, &RequiredParamError{ParamName: "digest"})
		return
	}

	err = runtime.BindQueryParameter("form", true, true, "digest", r.URL.Query(), &params.Digest)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "digest", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDockerArtifactLayers(w, r, registryRef, artifact, version, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetDockerArtifactManifest operation middleware
func (siw *ServerInterfaceWrapper) GetDockerArtifactManifest(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetDockerArtifactManifestParams

	// ------------- Required query parameter "digest" -------------

	if paramValue := r.URL.Query().Get("digest"); paramValue != "" {

	} else {
		siw.ErrorHandlerFunc(w, r, &RequiredParamError{ParamName: "digest"})
		return
	}

	err = runtime.BindQueryParameter("form", true, true, "digest", r.URL.Query(), &params.Digest)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "digest", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDockerArtifactManifest(w, r, registryRef, artifact, version, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetDockerArtifactManifests operation middleware
func (siw *ServerInterfaceWrapper) GetDockerArtifactManifests(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetDockerArtifactManifests(w, r, registryRef, artifact, version)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetHelmArtifactDetails operation middleware
func (siw *ServerInterfaceWrapper) GetHelmArtifactDetails(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetHelmArtifactDetails(w, r, registryRef, artifact, version)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetHelmArtifactManifest operation middleware
func (siw *ServerInterfaceWrapper) GetHelmArtifactManifest(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetHelmArtifactManifest(w, r, registryRef, artifact, version)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetArtifactVersionSummary operation middleware
func (siw *ServerInterfaceWrapper) GetArtifactVersionSummary(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Path parameter "version" -------------
	var version VersionPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "version", chi.URLParam(r, "version"), &version, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetArtifactVersionSummary(w, r, registryRef, artifact, version)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetAllArtifactVersions operation middleware
func (siw *ServerInterfaceWrapper) GetAllArtifactVersions(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// ------------- Path parameter "artifact" -------------
	var artifact ArtifactPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "artifact", chi.URLParam(r, "artifact"), &artifact, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetAllArtifactVersionsParams

	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", r.URL.Query(), &params.Page)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page", Err: err})
		return
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", r.URL.Query(), &params.Size)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "size", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_order" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_order", r.URL.Query(), &params.SortOrder)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_order", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_field" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_field", r.URL.Query(), &params.SortField)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_field", Err: err})
		return
	}

	// ------------- Optional query parameter "search_term" -------------

	err = runtime.BindQueryParameter("form", true, false, "search_term", r.URL.Query(), &params.SearchTerm)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "search_term", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetAllArtifactVersions(w, r, registryRef, artifact, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetAllArtifactsByRegistry operation middleware
func (siw *ServerInterfaceWrapper) GetAllArtifactsByRegistry(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetAllArtifactsByRegistryParams

	// ------------- Optional query parameter "label" -------------

	err = runtime.BindQueryParameter("form", true, false, "label", r.URL.Query(), &params.Label)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "label", Err: err})
		return
	}

	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", r.URL.Query(), &params.Page)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page", Err: err})
		return
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", r.URL.Query(), &params.Size)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "size", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_order" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_order", r.URL.Query(), &params.SortOrder)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_order", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_field" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_field", r.URL.Query(), &params.SortField)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_field", Err: err})
		return
	}

	// ------------- Optional query parameter "search_term" -------------

	err = runtime.BindQueryParameter("form", true, false, "search_term", r.URL.Query(), &params.SearchTerm)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "search_term", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetAllArtifactsByRegistry(w, r, registryRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetClientSetupDetails operation middleware
func (siw *ServerInterfaceWrapper) GetClientSetupDetails(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "registry_ref" -------------
	var registryRef RegistryRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "registry_ref", chi.URLParam(r, "registry_ref"), &registryRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "registry_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetClientSetupDetailsParams

	// ------------- Optional query parameter "artifact" -------------

	err = runtime.BindQueryParameter("form", true, false, "artifact", r.URL.Query(), &params.Artifact)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "artifact", Err: err})
		return
	}

	// ------------- Optional query parameter "version" -------------

	err = runtime.BindQueryParameter("form", true, false, "version", r.URL.Query(), &params.Version)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "version", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetClientSetupDetails(w, r, registryRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetArtifactStatsForSpace operation middleware
func (siw *ServerInterfaceWrapper) GetArtifactStatsForSpace(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "space_ref" -------------
	var spaceRef SpaceRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "space_ref", chi.URLParam(r, "space_ref"), &spaceRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "space_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetArtifactStatsForSpaceParams

	// ------------- Optional query parameter "from" -------------

	err = runtime.BindQueryParameter("form", true, false, "from", r.URL.Query(), &params.From)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "from", Err: err})
		return
	}

	// ------------- Optional query parameter "to" -------------

	err = runtime.BindQueryParameter("form", true, false, "to", r.URL.Query(), &params.To)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "to", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetArtifactStatsForSpace(w, r, spaceRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetAllArtifacts operation middleware
func (siw *ServerInterfaceWrapper) GetAllArtifacts(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "space_ref" -------------
	var spaceRef SpaceRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "space_ref", chi.URLParam(r, "space_ref"), &spaceRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "space_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetAllArtifactsParams

	// ------------- Optional query parameter "reg_identifier" -------------

	err = runtime.BindQueryParameter("form", true, false, "reg_identifier", r.URL.Query(), &params.RegIdentifier)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "reg_identifier", Err: err})
		return
	}

	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", r.URL.Query(), &params.Page)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page", Err: err})
		return
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", r.URL.Query(), &params.Size)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "size", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_order" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_order", r.URL.Query(), &params.SortOrder)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_order", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_field" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_field", r.URL.Query(), &params.SortField)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_field", Err: err})
		return
	}

	// ------------- Optional query parameter "search_term" -------------

	err = runtime.BindQueryParameter("form", true, false, "search_term", r.URL.Query(), &params.SearchTerm)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "search_term", Err: err})
		return
	}

	// ------------- Optional query parameter "latest_version" -------------

	err = runtime.BindQueryParameter("form", true, false, "latest_version", r.URL.Query(), &params.LatestVersion)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "latest_version", Err: err})
		return
	}

	// ------------- Optional query parameter "package_type" -------------

	err = runtime.BindQueryParameter("form", true, false, "package_type", r.URL.Query(), &params.PackageType)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "package_type", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetAllArtifacts(w, r, spaceRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

// GetAllRegistries operation middleware
func (siw *ServerInterfaceWrapper) GetAllRegistries(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()

	var err error

	// ------------- Path parameter "space_ref" -------------
	var spaceRef SpaceRefPathParam

	err = runtime.BindStyledParameterWithOptions("simple", "space_ref", chi.URLParam(r, "space_ref"), &spaceRef, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "space_ref", Err: err})
		return
	}

	// Parameter object where we will unmarshal all parameters from the context
	var params GetAllRegistriesParams

	// ------------- Optional query parameter "package_type" -------------

	err = runtime.BindQueryParameter("form", true, false, "package_type", r.URL.Query(), &params.PackageType)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "package_type", Err: err})
		return
	}

	// ------------- Optional query parameter "type" -------------

	err = runtime.BindQueryParameter("form", true, false, "type", r.URL.Query(), &params.Type)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "type", Err: err})
		return
	}

	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", r.URL.Query(), &params.Page)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "page", Err: err})
		return
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", r.URL.Query(), &params.Size)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "size", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_order" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_order", r.URL.Query(), &params.SortOrder)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_order", Err: err})
		return
	}

	// ------------- Optional query parameter "sort_field" -------------

	err = runtime.BindQueryParameter("form", true, false, "sort_field", r.URL.Query(), &params.SortField)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "sort_field", Err: err})
		return
	}

	// ------------- Optional query parameter "search_term" -------------

	err = runtime.BindQueryParameter("form", true, false, "search_term", r.URL.Query(), &params.SearchTerm)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "search_term", Err: err})
		return
	}

	// ------------- Optional query parameter "recursive" -------------

	err = runtime.BindQueryParameter("form", true, false, "recursive", r.URL.Query(), &params.Recursive)
	if err != nil {
		siw.ErrorHandlerFunc(w, r, &InvalidParamFormatError{ParamName: "recursive", Err: err})
		return
	}

	handler := http.Handler(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		siw.Handler.GetAllRegistries(w, r, spaceRef, params)
	}))

	for _, middleware := range siw.HandlerMiddlewares {
		handler = middleware(handler)
	}

	handler.ServeHTTP(w, r.WithContext(ctx))
}

type UnescapedCookieParamError struct {
	ParamName string
	Err       error
}

func (e *UnescapedCookieParamError) Error() string {
	return fmt.Sprintf("error unescaping cookie parameter '%s'", e.ParamName)
}

func (e *UnescapedCookieParamError) Unwrap() error {
	return e.Err
}

type UnmarshalingParamError struct {
	ParamName string
	Err       error
}

func (e *UnmarshalingParamError) Error() string {
	return fmt.Sprintf("Error unmarshaling parameter %s as JSON: %s", e.ParamName, e.Err.Error())
}

func (e *UnmarshalingParamError) Unwrap() error {
	return e.Err
}

type RequiredParamError struct {
	ParamName string
}

func (e *RequiredParamError) Error() string {
	return fmt.Sprintf("Query argument %s is required, but not found", e.ParamName)
}

type RequiredHeaderError struct {
	ParamName string
	Err       error
}

func (e *RequiredHeaderError) Error() string {
	return fmt.Sprintf("Header parameter %s is required, but not found", e.ParamName)
}

func (e *RequiredHeaderError) Unwrap() error {
	return e.Err
}

type InvalidParamFormatError struct {
	ParamName string
	Err       error
}

func (e *InvalidParamFormatError) Error() string {
	return fmt.Sprintf("Invalid format for parameter %s: %s", e.ParamName, e.Err.Error())
}

func (e *InvalidParamFormatError) Unwrap() error {
	return e.Err
}

type TooManyValuesForParamError struct {
	ParamName string
	Count     int
}

func (e *TooManyValuesForParamError) Error() string {
	return fmt.Sprintf("Expected one value for %s, got %d", e.ParamName, e.Count)
}

// Handler creates http.Handler with routing matching OpenAPI spec.
func Handler(si ServerInterface) http.Handler {
	return HandlerWithOptions(si, ChiServerOptions{})
}

type ChiServerOptions struct {
	BaseURL          string
	BaseRouter       chi.Router
	Middlewares      []MiddlewareFunc
	ErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

// HandlerFromMux creates http.Handler with routing matching OpenAPI spec based on the provided mux.
func HandlerFromMux(si ServerInterface, r chi.Router) http.Handler {
	return HandlerWithOptions(si, ChiServerOptions{
		BaseRouter: r,
	})
}

func HandlerFromMuxWithBaseURL(si ServerInterface, r chi.Router, baseURL string) http.Handler {
	return HandlerWithOptions(si, ChiServerOptions{
		BaseURL:    baseURL,
		BaseRouter: r,
	})
}

// HandlerWithOptions creates http.Handler with additional options
func HandlerWithOptions(si ServerInterface, options ChiServerOptions) http.Handler {
	r := options.BaseRouter

	if r == nil {
		r = chi.NewRouter()
	}
	if options.ErrorHandlerFunc == nil {
		options.ErrorHandlerFunc = func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		}
	}
	wrapper := ServerInterfaceWrapper{
		Handler:            si,
		HandlerMiddlewares: options.Middlewares,
		ErrorHandlerFunc:   options.ErrorHandlerFunc,
	}

	r.Group(func(r chi.Router) {
		r.Post(options.BaseURL+"/registry", wrapper.CreateRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Delete(options.BaseURL+"/registry/{registry_ref}", wrapper.DeleteRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}", wrapper.GetRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Put(options.BaseURL+"/registry/{registry_ref}", wrapper.ModifyRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/labels", wrapper.ListArtifactLabels)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/stats", wrapper.GetArtifactStatsForRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Delete(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}", wrapper.DeleteArtifact)
	})
	r.Group(func(r chi.Router) {
		r.Put(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/labels", wrapper.UpdateArtifactLabels)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/stats", wrapper.GetArtifactStats)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/summary", wrapper.GetArtifactSummary)
	})
	r.Group(func(r chi.Router) {
		r.Delete(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}", wrapper.DeleteArtifactVersion)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/details", wrapper.GetDockerArtifactDetails)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/layers", wrapper.GetDockerArtifactLayers)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifest", wrapper.GetDockerArtifactManifest)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifests", wrapper.GetDockerArtifactManifests)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/details", wrapper.GetHelmArtifactDetails)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/manifest", wrapper.GetHelmArtifactManifest)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/version/{version}/summary", wrapper.GetArtifactVersionSummary)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifact/{artifact}/versions", wrapper.GetAllArtifactVersions)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/artifacts", wrapper.GetAllArtifactsByRegistry)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/registry/{registry_ref}/client-setup-details", wrapper.GetClientSetupDetails)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/spaces/{space_ref}/artifact/stats", wrapper.GetArtifactStatsForSpace)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/spaces/{space_ref}/artifacts", wrapper.GetAllArtifacts)
	})
	r.Group(func(r chi.Router) {
		r.Get(options.BaseURL+"/spaces/{space_ref}/registries", wrapper.GetAllRegistries)
	})

	return r
}

type ArtifactLabelResponseJSONResponse struct {
	// Data Harness Artifact Summary
	Data ArtifactSummary `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ArtifactStatsResponseJSONResponse struct {
	// Data Harness Artifact Stats
	Data ArtifactStats `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ArtifactSummaryResponseJSONResponse struct {
	// Data Harness Artifact Summary
	Data ArtifactSummary `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ArtifactVersionSummaryResponseJSONResponse struct {
	// Data Docker Artifact Version Summary
	Data ArtifactVersionSummary `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type BadRequestJSONResponse Error

type ClientSetupDetailsResponseJSONResponse struct {
	// Data Client Setup Details
	Data ClientSetupDetails `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type DockerArtifactDetailResponseJSONResponse struct {
	// Data Docker Artifact Detail
	Data DockerArtifactDetail `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type DockerArtifactManifestResponseJSONResponse struct {
	// Data Docker Artifact Manifest
	Data DockerArtifactManifest `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type DockerLayersResponseJSONResponse struct {
	// Data Harness Layers Summary
	Data DockerLayersSummary `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type DockerManifestsResponseJSONResponse struct {
	// Data Harness Manifests
	Data DockerManifests `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type HelmArtifactDetailResponseJSONResponse struct {
	// Data Helm Artifact Detail
	Data HelmArtifactDetail `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type HelmArtifactManifestResponseJSONResponse struct {
	// Data Helm Artifact Manifest
	Data HelmArtifactManifest `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type InternalServerErrorJSONResponse Error

type ListArtifactLabelResponseJSONResponse struct {
	// Data A list of Harness Artifact Labels
	Data ListArtifactLabel `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ListArtifactResponseJSONResponse struct {
	// Data A list of Artifacts
	Data ListArtifact `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ListArtifactVersionResponseJSONResponse struct {
	// Data A list of Artifact versions
	Data ListArtifactVersion `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ListRegistryArtifactResponseJSONResponse struct {
	// Data A list of Artifacts
	Data ListRegistryArtifact `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type ListRegistryResponseJSONResponse struct {
	// Data A list of Harness Artifact Registries
	Data ListRegistry `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type NotFoundJSONResponse Error

type RegistryResponseJSONResponse struct {
	// Data Harness Artifact Registry
	Data Registry `json:"data"`

	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type SuccessJSONResponse struct {
	// Status Indicates if the request was successful or not
	Status Status `json:"status"`
}

type UnauthenticatedJSONResponse Error

type UnauthorizedJSONResponse Error

type CreateRegistryRequestObject struct {
	Params CreateRegistryParams
	Body   *CreateRegistryJSONRequestBody
}

type CreateRegistryResponseObject interface {
	VisitCreateRegistryResponse(w http.ResponseWriter) error
}

type CreateRegistry201JSONResponse struct{ RegistryResponseJSONResponse }

func (response CreateRegistry201JSONResponse) VisitCreateRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(201)

	return json.NewEncoder(w).Encode(response)
}

type CreateRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response CreateRegistry400JSONResponse) VisitCreateRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type CreateRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response CreateRegistry401JSONResponse) VisitCreateRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type CreateRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response CreateRegistry403JSONResponse) VisitCreateRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type CreateRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response CreateRegistry500JSONResponse) VisitCreateRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
}

type DeleteRegistryResponseObject interface {
	VisitDeleteRegistryResponse(w http.ResponseWriter) error
}

type DeleteRegistry200JSONResponse struct{ SuccessJSONResponse }

func (response DeleteRegistry200JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response DeleteRegistry400JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response DeleteRegistry401JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteRegistry403JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistry404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteRegistry404JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteRegistry500JSONResponse) VisitDeleteRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
}

type GetRegistryResponseObject interface {
	VisitGetRegistryResponse(w http.ResponseWriter) error
}

type GetRegistry200JSONResponse struct{ RegistryResponseJSONResponse }

func (response GetRegistry200JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response GetRegistry400JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetRegistry401JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetRegistry403JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistry404JSONResponse struct{ NotFoundJSONResponse }

func (response GetRegistry404JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetRegistry500JSONResponse) VisitGetRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Body        *ModifyRegistryJSONRequestBody
}

type ModifyRegistryResponseObject interface {
	VisitModifyRegistryResponse(w http.ResponseWriter) error
}

type ModifyRegistry200JSONResponse struct{ RegistryResponseJSONResponse }

func (response ModifyRegistry200JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response ModifyRegistry400JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response ModifyRegistry401JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response ModifyRegistry403JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistry404JSONResponse struct{ NotFoundJSONResponse }

func (response ModifyRegistry404JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type ModifyRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response ModifyRegistry500JSONResponse) VisitModifyRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabelsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Params      ListArtifactLabelsParams
}

type ListArtifactLabelsResponseObject interface {
	VisitListArtifactLabelsResponse(w http.ResponseWriter) error
}

type ListArtifactLabels200JSONResponse struct {
	ListArtifactLabelResponseJSONResponse
}

func (response ListArtifactLabels200JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabels400JSONResponse struct{ BadRequestJSONResponse }

func (response ListArtifactLabels400JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabels401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response ListArtifactLabels401JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabels403JSONResponse struct{ UnauthorizedJSONResponse }

func (response ListArtifactLabels403JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabels404JSONResponse struct{ NotFoundJSONResponse }

func (response ListArtifactLabels404JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type ListArtifactLabels500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response ListArtifactLabels500JSONResponse) VisitListArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Params      GetArtifactStatsForRegistryParams
}

type GetArtifactStatsForRegistryResponseObject interface {
	VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error
}

type GetArtifactStatsForRegistry200JSONResponse struct {
	ArtifactStatsResponseJSONResponse
}

func (response GetArtifactStatsForRegistry200JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response GetArtifactStatsForRegistry400JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetArtifactStatsForRegistry401JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetArtifactStatsForRegistry403JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistry404JSONResponse struct{ NotFoundJSONResponse }

func (response GetArtifactStatsForRegistry404JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetArtifactStatsForRegistry500JSONResponse) VisitGetArtifactStatsForRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
}

type DeleteArtifactResponseObject interface {
	VisitDeleteArtifactResponse(w http.ResponseWriter) error
}

type DeleteArtifact200JSONResponse struct{ SuccessJSONResponse }

func (response DeleteArtifact200JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifact400JSONResponse struct{ BadRequestJSONResponse }

func (response DeleteArtifact400JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifact401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response DeleteArtifact401JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifact403JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteArtifact403JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifact404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteArtifact404JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifact500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteArtifact500JSONResponse) VisitDeleteArtifactResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabelsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Body        *UpdateArtifactLabelsJSONRequestBody
}

type UpdateArtifactLabelsResponseObject interface {
	VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error
}

type UpdateArtifactLabels200JSONResponse struct {
	ArtifactLabelResponseJSONResponse
}

func (response UpdateArtifactLabels200JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabels400JSONResponse struct{ BadRequestJSONResponse }

func (response UpdateArtifactLabels400JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabels401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response UpdateArtifactLabels401JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabels403JSONResponse struct{ UnauthorizedJSONResponse }

func (response UpdateArtifactLabels403JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabels404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateArtifactLabels404JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateArtifactLabels500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response UpdateArtifactLabels500JSONResponse) VisitUpdateArtifactLabelsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Params      GetArtifactStatsParams
}

type GetArtifactStatsResponseObject interface {
	VisitGetArtifactStatsResponse(w http.ResponseWriter) error
}

type GetArtifactStats200JSONResponse struct {
	ArtifactStatsResponseJSONResponse
}

func (response GetArtifactStats200JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStats400JSONResponse struct{ BadRequestJSONResponse }

func (response GetArtifactStats400JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStats401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetArtifactStats401JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStats403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetArtifactStats403JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStats404JSONResponse struct{ NotFoundJSONResponse }

func (response GetArtifactStats404JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStats500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetArtifactStats500JSONResponse) VisitGetArtifactStatsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummaryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
}

type GetArtifactSummaryResponseObject interface {
	VisitGetArtifactSummaryResponse(w http.ResponseWriter) error
}

type GetArtifactSummary200JSONResponse struct {
	ArtifactSummaryResponseJSONResponse
}

func (response GetArtifactSummary200JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummary400JSONResponse struct{ BadRequestJSONResponse }

func (response GetArtifactSummary400JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummary401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetArtifactSummary401JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummary403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetArtifactSummary403JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummary404JSONResponse struct{ NotFoundJSONResponse }

func (response GetArtifactSummary404JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactSummary500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetArtifactSummary500JSONResponse) VisitGetArtifactSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersionRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
}

type DeleteArtifactVersionResponseObject interface {
	VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error
}

type DeleteArtifactVersion200JSONResponse struct{ SuccessJSONResponse }

func (response DeleteArtifactVersion200JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersion400JSONResponse struct{ BadRequestJSONResponse }

func (response DeleteArtifactVersion400JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersion401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response DeleteArtifactVersion401JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersion403JSONResponse struct{ UnauthorizedJSONResponse }

func (response DeleteArtifactVersion403JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersion404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteArtifactVersion404JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteArtifactVersion500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response DeleteArtifactVersion500JSONResponse) VisitDeleteArtifactVersionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetailsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
	Params      GetDockerArtifactDetailsParams
}

type GetDockerArtifactDetailsResponseObject interface {
	VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error
}

type GetDockerArtifactDetails200JSONResponse struct {
	DockerArtifactDetailResponseJSONResponse
}

func (response GetDockerArtifactDetails200JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetails400JSONResponse struct{ BadRequestJSONResponse }

func (response GetDockerArtifactDetails400JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetails401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetDockerArtifactDetails401JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetails403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDockerArtifactDetails403JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetails404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDockerArtifactDetails404JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactDetails500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDockerArtifactDetails500JSONResponse) VisitGetDockerArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayersRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
	Params      GetDockerArtifactLayersParams
}

type GetDockerArtifactLayersResponseObject interface {
	VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error
}

type GetDockerArtifactLayers200JSONResponse struct {
	DockerLayersResponseJSONResponse
}

func (response GetDockerArtifactLayers200JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayers400JSONResponse struct{ BadRequestJSONResponse }

func (response GetDockerArtifactLayers400JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayers401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetDockerArtifactLayers401JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayers403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDockerArtifactLayers403JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayers404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDockerArtifactLayers404JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactLayers500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDockerArtifactLayers500JSONResponse) VisitGetDockerArtifactLayersResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifestRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
	Params      GetDockerArtifactManifestParams
}

type GetDockerArtifactManifestResponseObject interface {
	VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error
}

type GetDockerArtifactManifest200JSONResponse struct {
	DockerArtifactManifestResponseJSONResponse
}

func (response GetDockerArtifactManifest200JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifest400JSONResponse struct{ BadRequestJSONResponse }

func (response GetDockerArtifactManifest400JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifest401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetDockerArtifactManifest401JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifest403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDockerArtifactManifest403JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifest404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDockerArtifactManifest404JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifest500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDockerArtifactManifest500JSONResponse) VisitGetDockerArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifestsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
}

type GetDockerArtifactManifestsResponseObject interface {
	VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error
}

type GetDockerArtifactManifests200JSONResponse struct {
	DockerManifestsResponseJSONResponse
}

func (response GetDockerArtifactManifests200JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifests400JSONResponse struct{ BadRequestJSONResponse }

func (response GetDockerArtifactManifests400JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifests401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetDockerArtifactManifests401JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifests403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetDockerArtifactManifests403JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifests404JSONResponse struct{ NotFoundJSONResponse }

func (response GetDockerArtifactManifests404JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetDockerArtifactManifests500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetDockerArtifactManifests500JSONResponse) VisitGetDockerArtifactManifestsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetailsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
}

type GetHelmArtifactDetailsResponseObject interface {
	VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error
}

type GetHelmArtifactDetails200JSONResponse struct {
	HelmArtifactDetailResponseJSONResponse
}

func (response GetHelmArtifactDetails200JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetails400JSONResponse struct{ BadRequestJSONResponse }

func (response GetHelmArtifactDetails400JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetails401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetHelmArtifactDetails401JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetails403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetHelmArtifactDetails403JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetails404JSONResponse struct{ NotFoundJSONResponse }

func (response GetHelmArtifactDetails404JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactDetails500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetHelmArtifactDetails500JSONResponse) VisitGetHelmArtifactDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifestRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
}

type GetHelmArtifactManifestResponseObject interface {
	VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error
}

type GetHelmArtifactManifest200JSONResponse struct {
	HelmArtifactManifestResponseJSONResponse
}

func (response GetHelmArtifactManifest200JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifest400JSONResponse struct{ BadRequestJSONResponse }

func (response GetHelmArtifactManifest400JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifest401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetHelmArtifactManifest401JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifest403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetHelmArtifactManifest403JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifest404JSONResponse struct{ NotFoundJSONResponse }

func (response GetHelmArtifactManifest404JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetHelmArtifactManifest500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetHelmArtifactManifest500JSONResponse) VisitGetHelmArtifactManifestResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummaryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Version     VersionPathParam     `json:"version"`
}

type GetArtifactVersionSummaryResponseObject interface {
	VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error
}

type GetArtifactVersionSummary200JSONResponse struct {
	ArtifactVersionSummaryResponseJSONResponse
}

func (response GetArtifactVersionSummary200JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummary400JSONResponse struct{ BadRequestJSONResponse }

func (response GetArtifactVersionSummary400JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummary401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetArtifactVersionSummary401JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummary403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetArtifactVersionSummary403JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummary404JSONResponse struct{ NotFoundJSONResponse }

func (response GetArtifactVersionSummary404JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactVersionSummary500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetArtifactVersionSummary500JSONResponse) VisitGetArtifactVersionSummaryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersionsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Artifact    ArtifactPathParam    `json:"artifact"`
	Params      GetAllArtifactVersionsParams
}

type GetAllArtifactVersionsResponseObject interface {
	VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error
}

type GetAllArtifactVersions200JSONResponse struct {
	ListArtifactVersionResponseJSONResponse
}

func (response GetAllArtifactVersions200JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersions400JSONResponse struct{ BadRequestJSONResponse }

func (response GetAllArtifactVersions400JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersions401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetAllArtifactVersions401JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersions403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetAllArtifactVersions403JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersions404JSONResponse struct{ NotFoundJSONResponse }

func (response GetAllArtifactVersions404JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactVersions500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetAllArtifactVersions500JSONResponse) VisitGetAllArtifactVersionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistryRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Params      GetAllArtifactsByRegistryParams
}

type GetAllArtifactsByRegistryResponseObject interface {
	VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error
}

type GetAllArtifactsByRegistry200JSONResponse struct {
	ListRegistryArtifactResponseJSONResponse
}

func (response GetAllArtifactsByRegistry200JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistry400JSONResponse struct{ BadRequestJSONResponse }

func (response GetAllArtifactsByRegistry400JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistry401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetAllArtifactsByRegistry401JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistry403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetAllArtifactsByRegistry403JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistry404JSONResponse struct{ NotFoundJSONResponse }

func (response GetAllArtifactsByRegistry404JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsByRegistry500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetAllArtifactsByRegistry500JSONResponse) VisitGetAllArtifactsByRegistryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetailsRequestObject struct {
	RegistryRef RegistryRefPathParam `json:"registry_ref"`
	Params      GetClientSetupDetailsParams
}

type GetClientSetupDetailsResponseObject interface {
	VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error
}

type GetClientSetupDetails200JSONResponse struct {
	ClientSetupDetailsResponseJSONResponse
}

func (response GetClientSetupDetails200JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetails400JSONResponse struct{ BadRequestJSONResponse }

func (response GetClientSetupDetails400JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetails401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetClientSetupDetails401JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetails403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetClientSetupDetails403JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetails404JSONResponse struct{ NotFoundJSONResponse }

func (response GetClientSetupDetails404JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetClientSetupDetails500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetClientSetupDetails500JSONResponse) VisitGetClientSetupDetailsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpaceRequestObject struct {
	SpaceRef SpaceRefPathParam `json:"space_ref"`
	Params   GetArtifactStatsForSpaceParams
}

type GetArtifactStatsForSpaceResponseObject interface {
	VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error
}

type GetArtifactStatsForSpace200JSONResponse struct {
	ArtifactStatsResponseJSONResponse
}

func (response GetArtifactStatsForSpace200JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpace400JSONResponse struct{ BadRequestJSONResponse }

func (response GetArtifactStatsForSpace400JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpace401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetArtifactStatsForSpace401JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpace403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetArtifactStatsForSpace403JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpace404JSONResponse struct{ NotFoundJSONResponse }

func (response GetArtifactStatsForSpace404JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetArtifactStatsForSpace500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetArtifactStatsForSpace500JSONResponse) VisitGetArtifactStatsForSpaceResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifactsRequestObject struct {
	SpaceRef SpaceRefPathParam `json:"space_ref"`
	Params   GetAllArtifactsParams
}

type GetAllArtifactsResponseObject interface {
	VisitGetAllArtifactsResponse(w http.ResponseWriter) error
}

type GetAllArtifacts200JSONResponse struct {
	ListArtifactResponseJSONResponse
}

func (response GetAllArtifacts200JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifacts400JSONResponse struct{ BadRequestJSONResponse }

func (response GetAllArtifacts400JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifacts401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetAllArtifacts401JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifacts403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetAllArtifacts403JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifacts404JSONResponse struct{ NotFoundJSONResponse }

func (response GetAllArtifacts404JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetAllArtifacts500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetAllArtifacts500JSONResponse) VisitGetAllArtifactsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistriesRequestObject struct {
	SpaceRef SpaceRefPathParam `json:"space_ref"`
	Params   GetAllRegistriesParams
}

type GetAllRegistriesResponseObject interface {
	VisitGetAllRegistriesResponse(w http.ResponseWriter) error
}

type GetAllRegistries200JSONResponse struct {
	ListRegistryResponseJSONResponse
}

func (response GetAllRegistries200JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistries400JSONResponse struct{ BadRequestJSONResponse }

func (response GetAllRegistries400JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistries401JSONResponse struct{ UnauthenticatedJSONResponse }

func (response GetAllRegistries401JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(401)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistries403JSONResponse struct{ UnauthorizedJSONResponse }

func (response GetAllRegistries403JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(403)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistries404JSONResponse struct{ NotFoundJSONResponse }

func (response GetAllRegistries404JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetAllRegistries500JSONResponse struct {
	InternalServerErrorJSONResponse
}

func (response GetAllRegistries500JSONResponse) VisitGetAllRegistriesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

// StrictServerInterface represents all server handlers.
type StrictServerInterface interface {
	// Create Registry.
	// (POST /registry)
	CreateRegistry(ctx context.Context, request CreateRegistryRequestObject) (CreateRegistryResponseObject, error)
	// Delete a Registry
	// (DELETE /registry/{registry_ref})
	DeleteRegistry(ctx context.Context, request DeleteRegistryRequestObject) (DeleteRegistryResponseObject, error)
	// Returns Registry Details
	// (GET /registry/{registry_ref})
	GetRegistry(ctx context.Context, request GetRegistryRequestObject) (GetRegistryResponseObject, error)
	// Updates a Registry
	// (PUT /registry/{registry_ref})
	ModifyRegistry(ctx context.Context, request ModifyRegistryRequestObject) (ModifyRegistryResponseObject, error)
	// List Artifact Labels
	// (GET /registry/{registry_ref}/artifact/labels)
	ListArtifactLabels(ctx context.Context, request ListArtifactLabelsRequestObject) (ListArtifactLabelsResponseObject, error)
	// Get Artifact Stats
	// (GET /registry/{registry_ref}/artifact/stats)
	GetArtifactStatsForRegistry(ctx context.Context, request GetArtifactStatsForRegistryRequestObject) (GetArtifactStatsForRegistryResponseObject, error)
	// Delete Artifact
	// (DELETE /registry/{registry_ref}/artifact/{artifact})
	DeleteArtifact(ctx context.Context, request DeleteArtifactRequestObject) (DeleteArtifactResponseObject, error)
	// Update Artifact Labels
	// (PUT /registry/{registry_ref}/artifact/{artifact}/labels)
	UpdateArtifactLabels(ctx context.Context, request UpdateArtifactLabelsRequestObject) (UpdateArtifactLabelsResponseObject, error)
	// Get Artifact Stats
	// (GET /registry/{registry_ref}/artifact/{artifact}/stats)
	GetArtifactStats(ctx context.Context, request GetArtifactStatsRequestObject) (GetArtifactStatsResponseObject, error)
	// Get Artifact Summary
	// (GET /registry/{registry_ref}/artifact/{artifact}/summary)
	GetArtifactSummary(ctx context.Context, request GetArtifactSummaryRequestObject) (GetArtifactSummaryResponseObject, error)
	// Delete an Artifact Version
	// (DELETE /registry/{registry_ref}/artifact/{artifact}/version/{version})
	DeleteArtifactVersion(ctx context.Context, request DeleteArtifactVersionRequestObject) (DeleteArtifactVersionResponseObject, error)
	// Describe Docker Artifact Detail
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/details)
	GetDockerArtifactDetails(ctx context.Context, request GetDockerArtifactDetailsRequestObject) (GetDockerArtifactDetailsResponseObject, error)
	// Describe Docker Artifact Layers
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/layers)
	GetDockerArtifactLayers(ctx context.Context, request GetDockerArtifactLayersRequestObject) (GetDockerArtifactLayersResponseObject, error)
	// Describe Docker Artifact Manifest
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifest)
	GetDockerArtifactManifest(ctx context.Context, request GetDockerArtifactManifestRequestObject) (GetDockerArtifactManifestResponseObject, error)
	// Describe Docker Artifact Manifests
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/docker/manifests)
	GetDockerArtifactManifests(ctx context.Context, request GetDockerArtifactManifestsRequestObject) (GetDockerArtifactManifestsResponseObject, error)
	// Describe Helm Artifact Detail
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/details)
	GetHelmArtifactDetails(ctx context.Context, request GetHelmArtifactDetailsRequestObject) (GetHelmArtifactDetailsResponseObject, error)
	// Describe Helm Artifact Manifest
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/helm/manifest)
	GetHelmArtifactManifest(ctx context.Context, request GetHelmArtifactManifestRequestObject) (GetHelmArtifactManifestResponseObject, error)
	// Get Artifact Version Summary
	// (GET /registry/{registry_ref}/artifact/{artifact}/version/{version}/summary)
	GetArtifactVersionSummary(ctx context.Context, request GetArtifactVersionSummaryRequestObject) (GetArtifactVersionSummaryResponseObject, error)
	// List Artifact Versions
	// (GET /registry/{registry_ref}/artifact/{artifact}/versions)
	GetAllArtifactVersions(ctx context.Context, request GetAllArtifactVersionsRequestObject) (GetAllArtifactVersionsResponseObject, error)
	// List Artifacts for Registry
	// (GET /registry/{registry_ref}/artifacts)
	GetAllArtifactsByRegistry(ctx context.Context, request GetAllArtifactsByRegistryRequestObject) (GetAllArtifactsByRegistryResponseObject, error)
	// Returns CLI Client Setup Details
	// (GET /registry/{registry_ref}/client-setup-details)
	GetClientSetupDetails(ctx context.Context, request GetClientSetupDetailsRequestObject) (GetClientSetupDetailsResponseObject, error)
	// Get Artifact Stats
	// (GET /spaces/{space_ref}/artifact/stats)
	GetArtifactStatsForSpace(ctx context.Context, request GetArtifactStatsForSpaceRequestObject) (GetArtifactStatsForSpaceResponseObject, error)
	// List Artifacts
	// (GET /spaces/{space_ref}/artifacts)
	GetAllArtifacts(ctx context.Context, request GetAllArtifactsRequestObject) (GetAllArtifactsResponseObject, error)
	// List Registries
	// (GET /spaces/{space_ref}/registries)
	GetAllRegistries(ctx context.Context, request GetAllRegistriesRequestObject) (GetAllRegistriesResponseObject, error)
}

type StrictHandlerFunc = strictnethttp.StrictHTTPHandlerFunc
type StrictMiddlewareFunc = strictnethttp.StrictHTTPMiddlewareFunc

type StrictHTTPServerOptions struct {
	RequestErrorHandlerFunc  func(w http.ResponseWriter, r *http.Request, err error)
	ResponseErrorHandlerFunc func(w http.ResponseWriter, r *http.Request, err error)
}

func NewStrictHandler(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: StrictHTTPServerOptions{
		RequestErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusBadRequest)
		},
		ResponseErrorHandlerFunc: func(w http.ResponseWriter, r *http.Request, err error) {
			http.Error(w, err.Error(), http.StatusInternalServerError)
		},
	}}
}

func NewStrictHandlerWithOptions(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc, options StrictHTTPServerOptions) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares, options: options}
}

type strictHandler struct {
	ssi         StrictServerInterface
	middlewares []StrictMiddlewareFunc
	options     StrictHTTPServerOptions
}

// CreateRegistry operation middleware
func (sh *strictHandler) CreateRegistry(w http.ResponseWriter, r *http.Request, params CreateRegistryParams) {
	var request CreateRegistryRequestObject

	request.Params = params

	var body CreateRegistryJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.CreateRegistry(ctx, request.(CreateRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(CreateRegistryResponseObject); ok {
		if err := validResponse.VisitCreateRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteRegistry operation middleware
func (sh *strictHandler) DeleteRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	var request DeleteRegistryRequestObject

	request.RegistryRef = registryRef

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteRegistry(ctx, request.(DeleteRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteRegistryResponseObject); ok {
		if err := validResponse.VisitDeleteRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetRegistry operation middleware
func (sh *strictHandler) GetRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	var request GetRegistryRequestObject

	request.RegistryRef = registryRef

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetRegistry(ctx, request.(GetRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetRegistryResponseObject); ok {
		if err := validResponse.VisitGetRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// ModifyRegistry operation middleware
func (sh *strictHandler) ModifyRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam) {
	var request ModifyRegistryRequestObject

	request.RegistryRef = registryRef

	var body ModifyRegistryJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.ModifyRegistry(ctx, request.(ModifyRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ModifyRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(ModifyRegistryResponseObject); ok {
		if err := validResponse.VisitModifyRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// ListArtifactLabels operation middleware
func (sh *strictHandler) ListArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params ListArtifactLabelsParams) {
	var request ListArtifactLabelsRequestObject

	request.RegistryRef = registryRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.ListArtifactLabels(ctx, request.(ListArtifactLabelsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListArtifactLabels")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(ListArtifactLabelsResponseObject); ok {
		if err := validResponse.VisitListArtifactLabelsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetArtifactStatsForRegistry operation middleware
func (sh *strictHandler) GetArtifactStatsForRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetArtifactStatsForRegistryParams) {
	var request GetArtifactStatsForRegistryRequestObject

	request.RegistryRef = registryRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetArtifactStatsForRegistry(ctx, request.(GetArtifactStatsForRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetArtifactStatsForRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetArtifactStatsForRegistryResponseObject); ok {
		if err := validResponse.VisitGetArtifactStatsForRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteArtifact operation middleware
func (sh *strictHandler) DeleteArtifact(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	var request DeleteArtifactRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteArtifact(ctx, request.(DeleteArtifactRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteArtifact")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteArtifactResponseObject); ok {
		if err := validResponse.VisitDeleteArtifactResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateArtifactLabels operation middleware
func (sh *strictHandler) UpdateArtifactLabels(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	var request UpdateArtifactLabelsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact

	var body UpdateArtifactLabelsJSONRequestBody
	if err := json.NewDecoder(r.Body).Decode(&body); err != nil {
		sh.options.RequestErrorHandlerFunc(w, r, fmt.Errorf("can't decode JSON body: %w", err))
		return
	}
	request.Body = &body

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateArtifactLabels(ctx, request.(UpdateArtifactLabelsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateArtifactLabels")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(UpdateArtifactLabelsResponseObject); ok {
		if err := validResponse.VisitUpdateArtifactLabelsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetArtifactStats operation middleware
func (sh *strictHandler) GetArtifactStats(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetArtifactStatsParams) {
	var request GetArtifactStatsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetArtifactStats(ctx, request.(GetArtifactStatsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetArtifactStats")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetArtifactStatsResponseObject); ok {
		if err := validResponse.VisitGetArtifactStatsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetArtifactSummary operation middleware
func (sh *strictHandler) GetArtifactSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam) {
	var request GetArtifactSummaryRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetArtifactSummary(ctx, request.(GetArtifactSummaryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetArtifactSummary")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetArtifactSummaryResponseObject); ok {
		if err := validResponse.VisitGetArtifactSummaryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteArtifactVersion operation middleware
func (sh *strictHandler) DeleteArtifactVersion(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	var request DeleteArtifactVersionRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteArtifactVersion(ctx, request.(DeleteArtifactVersionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteArtifactVersion")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(DeleteArtifactVersionResponseObject); ok {
		if err := validResponse.VisitDeleteArtifactVersionResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDockerArtifactDetails operation middleware
func (sh *strictHandler) GetDockerArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactDetailsParams) {
	var request GetDockerArtifactDetailsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDockerArtifactDetails(ctx, request.(GetDockerArtifactDetailsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDockerArtifactDetails")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDockerArtifactDetailsResponseObject); ok {
		if err := validResponse.VisitGetDockerArtifactDetailsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDockerArtifactLayers operation middleware
func (sh *strictHandler) GetDockerArtifactLayers(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactLayersParams) {
	var request GetDockerArtifactLayersRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDockerArtifactLayers(ctx, request.(GetDockerArtifactLayersRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDockerArtifactLayers")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDockerArtifactLayersResponseObject); ok {
		if err := validResponse.VisitGetDockerArtifactLayersResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDockerArtifactManifest operation middleware
func (sh *strictHandler) GetDockerArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam, params GetDockerArtifactManifestParams) {
	var request GetDockerArtifactManifestRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDockerArtifactManifest(ctx, request.(GetDockerArtifactManifestRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDockerArtifactManifest")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDockerArtifactManifestResponseObject); ok {
		if err := validResponse.VisitGetDockerArtifactManifestResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDockerArtifactManifests operation middleware
func (sh *strictHandler) GetDockerArtifactManifests(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	var request GetDockerArtifactManifestsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetDockerArtifactManifests(ctx, request.(GetDockerArtifactManifestsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDockerArtifactManifests")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetDockerArtifactManifestsResponseObject); ok {
		if err := validResponse.VisitGetDockerArtifactManifestsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetHelmArtifactDetails operation middleware
func (sh *strictHandler) GetHelmArtifactDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	var request GetHelmArtifactDetailsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetHelmArtifactDetails(ctx, request.(GetHelmArtifactDetailsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetHelmArtifactDetails")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetHelmArtifactDetailsResponseObject); ok {
		if err := validResponse.VisitGetHelmArtifactDetailsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetHelmArtifactManifest operation middleware
func (sh *strictHandler) GetHelmArtifactManifest(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	var request GetHelmArtifactManifestRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetHelmArtifactManifest(ctx, request.(GetHelmArtifactManifestRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetHelmArtifactManifest")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetHelmArtifactManifestResponseObject); ok {
		if err := validResponse.VisitGetHelmArtifactManifestResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetArtifactVersionSummary operation middleware
func (sh *strictHandler) GetArtifactVersionSummary(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, version VersionPathParam) {
	var request GetArtifactVersionSummaryRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Version = version

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetArtifactVersionSummary(ctx, request.(GetArtifactVersionSummaryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetArtifactVersionSummary")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetArtifactVersionSummaryResponseObject); ok {
		if err := validResponse.VisitGetArtifactVersionSummaryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetAllArtifactVersions operation middleware
func (sh *strictHandler) GetAllArtifactVersions(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, artifact ArtifactPathParam, params GetAllArtifactVersionsParams) {
	var request GetAllArtifactVersionsRequestObject

	request.RegistryRef = registryRef
	request.Artifact = artifact
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetAllArtifactVersions(ctx, request.(GetAllArtifactVersionsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetAllArtifactVersions")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetAllArtifactVersionsResponseObject); ok {
		if err := validResponse.VisitGetAllArtifactVersionsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetAllArtifactsByRegistry operation middleware
func (sh *strictHandler) GetAllArtifactsByRegistry(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetAllArtifactsByRegistryParams) {
	var request GetAllArtifactsByRegistryRequestObject

	request.RegistryRef = registryRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetAllArtifactsByRegistry(ctx, request.(GetAllArtifactsByRegistryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetAllArtifactsByRegistry")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetAllArtifactsByRegistryResponseObject); ok {
		if err := validResponse.VisitGetAllArtifactsByRegistryResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetClientSetupDetails operation middleware
func (sh *strictHandler) GetClientSetupDetails(w http.ResponseWriter, r *http.Request, registryRef RegistryRefPathParam, params GetClientSetupDetailsParams) {
	var request GetClientSetupDetailsRequestObject

	request.RegistryRef = registryRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetClientSetupDetails(ctx, request.(GetClientSetupDetailsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetClientSetupDetails")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetClientSetupDetailsResponseObject); ok {
		if err := validResponse.VisitGetClientSetupDetailsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetArtifactStatsForSpace operation middleware
func (sh *strictHandler) GetArtifactStatsForSpace(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetArtifactStatsForSpaceParams) {
	var request GetArtifactStatsForSpaceRequestObject

	request.SpaceRef = spaceRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetArtifactStatsForSpace(ctx, request.(GetArtifactStatsForSpaceRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetArtifactStatsForSpace")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetArtifactStatsForSpaceResponseObject); ok {
		if err := validResponse.VisitGetArtifactStatsForSpaceResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetAllArtifacts operation middleware
func (sh *strictHandler) GetAllArtifacts(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllArtifactsParams) {
	var request GetAllArtifactsRequestObject

	request.SpaceRef = spaceRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetAllArtifacts(ctx, request.(GetAllArtifactsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetAllArtifacts")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetAllArtifactsResponseObject); ok {
		if err := validResponse.VisitGetAllArtifactsResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetAllRegistries operation middleware
func (sh *strictHandler) GetAllRegistries(w http.ResponseWriter, r *http.Request, spaceRef SpaceRefPathParam, params GetAllRegistriesParams) {
	var request GetAllRegistriesRequestObject

	request.SpaceRef = spaceRef
	request.Params = params

	handler := func(ctx context.Context, w http.ResponseWriter, r *http.Request, request interface{}) (interface{}, error) {
		return sh.ssi.GetAllRegistries(ctx, request.(GetAllRegistriesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetAllRegistries")
	}

	response, err := handler(r.Context(), w, r, request)

	if err != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, err)
	} else if validResponse, ok := response.(GetAllRegistriesResponseObject); ok {
		if err := validResponse.VisitGetAllRegistriesResponse(w); err != nil {
			sh.options.ResponseErrorHandlerFunc(w, r, err)
		}
	} else if response != nil {
		sh.options.ResponseErrorHandlerFunc(w, r, fmt.Errorf("unexpected response type: %T", response))
	}
}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+xd33OcuJP/VyjdPRKPs5u7B785tpO41k58njhXqa1USoaeGTYMsJKwM5vy//4tSQgE",
	"SCDG8ysbnuIMLXXT+nSrJbWaHyhIl1maQMIoOvmBMkzwEhgQ8b8rfA8xveG/8f+GQAMSZSxKE3QiHx4h",
	"H0X8f3/nQFbIRwleAjpBMX+IfESDBSwxbxwxWIpO2SrjFJSRKJmjJ1/9gAnBK/T05KNbmEeUkdVlCAmL",
	"ZhEQiwiK0KsoLfIQmH+NdKJnCfZxlUGfSJzGIgyTjyoRIMmX6ORP9Ony9uPd6RXy0d3N9OPtxek1+uI3",
	"5XryESYsmuGAWWQ4FY+ZhbtqXJOgiwdbWPi8x0vw0pmnSEswZJgtjAwJ/J1HBEJ0wkgO3QKE0Ryo7RXP",
	"xUMb+mTTgfxmJF2eY2YbWP7oyHuTkiVm3gvv+npyfj75/PnzZ4sMvLseFceYAWWfgFDBom1g/LFXPPfe",
	"RDEDYjc4Tvz1oejMwPg+TWPAieCc4eAbnoMLjm8kaReei96+tnA9wLQyPIf3+fIeSFuWs5wQSJjHabxE",
	"EtkkmdclCGGG85ihk5c+momxQycoStj/vkKlEFHCYA6kFGMa/QMGsAu+HO7irbwMiFewM0lCeSdGSX47",
	"dhOFQJATGj3YRuj/F8AWQDyWenFEmUfkiEVAvbJpvDqyOsSCxCzkDMcUfBN0CjarW5h1uIa7JPo7ByXT",
	"yuMeweIeFM1XArOBJksBk2DxEYhBAvnM4w9tOpAkXxlv38MoJexNBHFo4FM+sjBJCfs6Kwj6eHwgockA",
	"qkcdPNKCoJNHhgNwGjlB2TVsgmCdMStE+D/+Cq4y2N5bk6GLJ0s36NhZ2sOt8MEWdp9KD23qvMN/mzj0",
	"Ts2nxdyrZhHLYFZs3YfySRIDZa/TMALh5xU7ERveyqf89yBNGCTiT5xlcRRgLufkLyrnvYrJf/PBPEH/",
	"NanC0ol8SifGzoUc9XcvpOKOMc9CzKAMUDwRllKkhXKbFrLZb4d8s5R4AQEhYBIqWZU7LJwtzdKEGpUr",
	"nwwSPCNpBoQVgxVi5qzzab5cYi6UjyjDLKd9DaeSSqFEQupP1diXzKvgNr3/CwKLtuSL8uGcA2uMpace",
	"c8lKYRlmdNcK4jwPST28K2pWjxzLEUG0EklJWbjJ/aiozvwANBWmwTcglcKKaUJX3GscbtqFXhCSEpN4",
	"r3HoEeVXfXQWR5CwKbA8OweGo3hXNt9mvM+xEtOIkMijXCQvrGQ6FwOo8CWF3ZGSTKwPENJhKVhd4Guc",
	"RDOgbC/aUswPUF9LTTQp9BVeAaE71ZNkeZAxCRes0o0ayN2qp+R6mKp5B/FyLy6pzfgAFLSAeGlyR7qw",
	"O3ZGJtYHpyndEV0mDEiC4ymQByAyfth6NKKYelRw9UAS+ugqomwfa7UW331HJWJb0rD21gXdg24OSi1N",
	"fRRrgD2oRW1MHYJ2ioUG1U+XlKbUDsseENRkfZBIqnagdq6Xg9AH0YR5n7I3aZ6E258NPi7AoxkE0SwC",
	"vkqlaU4C8B4x9ZKUeTMhRW3fcSejcygjI/c5fRkSmjY7fTTNgwAofYZCNvGCLm9WSOrdaptrdwnO2QIS",
	"xoWFHQCuybCUISXRP7sToOAmTnZkC7FVLRT0B6ymEBBgf8CqPVpY0RgPiHG9By3Bw4F6muEALkONtDxY",
	"NdPeYLYwdkyV/D0ClHSdrOtUFqZNXBok+PLko9MkTVbLVOBd28BsnrzUdV7EYMOO5nVpig7aVlJJcA0M",
	"K9dkyksJmFeS+E2Xlj4mcYpDepbmEri9J+X+Gi/F21B2nYbCWxsbyIMxwwMtdaLPdG40Ut4yj+OzdLnE",
	"iZklaaU9dZJZMftQJZR0Q0u8o5FvMzelwbVr+OVBSGvs32GScJ9ZYkDS2QAwZPxVG5W34dCEpQzHU5YS",
	"Ld3DoVmeDeLz1KWmYvPKQVEFZVNVckoNT5kRBGtZUrTEc3hvQ/46drYsbMwi5brG1AByJXe9yy6cFtB2",
	"8FYqAcvutUS6WaloO0KHDQZt5Yc103H+3X6MFna2ByfWOIlr54zIXfEWRGy22m1YEb3qH+n1x8t5PtDN",
	"qMoI6TWonC2UVA0LqgJUrpwiPVAlu95RIDeY0seUhMg3hYx6kNPOg/XRGddNnt2kcRQYBql47MnnYhnS",
	"cq63ZdJca8zgexYROMcrajbqPsu6ITCLvg9zlyqxZ3BT01RjOKY06EgcHAoiT1E1NbHEUfIOcGiPfbuf",
	"cl71ecPxdHUq2/ZGpZqAujga8y/d+lGMuvWjqJr6WXS8PYNsvVdnkA0eZtGo5x04SSuUkN58bUHVbGBA",
	"dIdumIMrazAqZ/8+LWjzU48yPEXqm9ZK5gAbx7llZuqTy+woDURNb8nD5ShAPnoLCRDM4GP6DRKjWzSe",
	"vPdOYQXd3qNMp8lwS2Gle2wzNGjxUU7i563WzLNzTSDJpX/KtmQb9GKkpGzPEFUX3W9RUtrlEqf7Fwlz",
	"Wh3JVACbR3tGXKl66JGT9i7kJJk1NCzuqpgXXKviIpaTU25pz+COU3pKAoddp0Iq+8srKFgjC+eR6nYw",
	"du2s5Xus7+8Ki/JqUaxep+iyX1UdSqpItrByWOr8ByCpOcT2eHU952XSWHl23zTn0DBtflyAt2Ask0fv",
	"niDyEXzHyyzm3b461kCgAccG2dMwjPifOFY5dB6+T3PmsQUUx/sGkZdAKZ5bxCOAKV/6iD+LtG8cxRAi",
	"v9f/iLdRvZuUZchnaSMM4mXvJF8eIZowto0IYJzjtz7HG5N4euCx7fm9loXRNj95fqvdWqFWpFKX5sh3",
	"c3etkwuDp+MdlRBv27nYUC7uJpZ3BHVn5HL/UF4/HMCFk9e5HB8787lMQvhu5hNoFy717t07N9+h5H0n",
	"9nuUurKMFyIrmFU46MPZlVrG2dBiCFTEPndrJt4JAtbZZB9R44iajtNLUyaUg4spM5WsnuqTIhjY2yDP",
	"1TzMGB3Yz+/AytSdIb6rYz97BMB+AVDGcWrhv9aYOrkFBR27P2igUZOsD44HGL81RRvd4L/EDd7U13jN",
	"/MIZEOqx1CuWQtpu+fmHsz8ubpGPrk8/XbxHPnp78f7i9vIM+ejdxdW1cdvc7m9tFtnezMNxnD5CeIMZ",
	"A5IMi+Lu4zT4tmbboHkS6niKo7cydZsms2juan5nkrp/y0BXrmlTqztv4IDSUGwrfnOKQq3+VHG847aW",
	"tzq4nzrFzpbestXklc0kp2wzB6VhTq0hnub38pHKNw9EasOniLAcx15KvLuMMgJ4qfupMOJ9LKMEM7nB",
	"usRZxt/l5EdVbMyiQtVfIZFf1imz0BeiVP6gQODqvVb/7MlHaQIfZujkz+4BbPbWTd2Q9elLE/8up856",
	"nbfWYLM+K7Vbp3UisZtrOUEOyojs8bDrbdpu3i33uohnbPLaNm+V/U1tm7jDAeI4DRQuX3+nxqTAu+lC",
	"ljWve4w79hVZPAehPDa/5fS9xwKGyME1ZugLnnlDHsWXpdqiI/AeqskkLxyqaQ6x+PVB5Sx9NC2v7TQv",
	"2Ibibgv1olntBO0RU4/KOzizXAiZpEzPlbk7O7uYTpGP3pxeXt3dXiAfXdzefrg1sm/MGO3kHPF7TmQS",
	"ozGLUHVxQ9Lvpq0XnEtn5Dbh1RIj++a7KkOyl7KdYPn05ckXwrnAt8zzFLXqchKAXrpUHhkv8nvko7Oc",
	"MlH88vSRXgTEqHUnj1mK1gK4j76/qMHxRZGUVUGND62uyfZ1MZebRbT/QhF1uEeUUyCWU/zGO5eUfGzq",
	"sc8AaKpo0GVjMG+g91lpp/ynKJml6v5ZsVNU1JmzB0AvvBAeIOZy0WImPEELxjJ6Mpk8Pj4eLWTToygV",
	"YkQs7u7w9OZSO0Q9QS+Pjo+ORdSZQYKzCJ2g38VPMlYQbzsh2h5AlpoOTM+Kgm0loyMkupRjwCFSkOh7",
	"BFpRZYvtVyQTQ4FEHsVWtfZWNkutleNrV6JrlJP77filvaOCbtK6rvrko1fHx/0NtbpQookDL8ONxlfH",
	"v7u2UxcRffQ/LvKZSkaIS4wqnUuNtD7ODM/5ECLNmL7wRiVuJj/0aqZPEj4xMMMMfC5+14DkRTJPBAcB",
	"j8qFOfP/z6MHSLxvIh++DjTZxdpAM1ZylVCrwcRBm+ru7k+AjlfHr/oblffGNwen1njb8OSjOTBTQWaW",
	"k4RWcCnSsobD5i2wQ8DMz+ha9gUe2+DbMZTlBgzdiVv39FlOR6zXV9sA0MbntxGEGwVhGz1rTIkTtaE1",
	"qVbbRn93FVHWzMlpx1qtTB+6IUT6ve20ivWO1GLLyYFWK2u+nmu1V6Aa4W2FtwlwGsCrM21HfFN1Ed4I",
	"77fAGnfhj0wTde1W/ZuUbNjv9mOx/lUMhwZ6rfX10Gsu4zwi14rcNpaeg9sf6i+X5cup9ukX0+JES+XY",
	"DV7bn60ZVzTbXdFoQ7wBzGlhQUcI2x8YSLo9hQY2EA6McM0fPHiOSx2DgUGx7ibDAQ3im48M9onsMYYY",
	"Y4gusFf3Yx3gLom7AV9dpP2pIgrb5zdGUDqCshz3TcCyOBia/Cj+GBLs6h9T6gp6P2k1dA7WObe+JTXG",
	"y1s+AUhaQNoWpify6w0T7caz1Qeb64FQkyc2FRihPxvK+9voHyBdzyg6P78yWkqHpXB03oNnLVKjzKVB",
	"sFGrqcpvOBtNWeOix2aqWhijyZhMpvFNmdFUhptKCbFdmIpeH8DZWLRqAz3motclGA2ma45pfSlmNJ3h",
	"pqPBbZfGQ9eyHupuPvSXWInYvrw1WsL6lrD1eWQB8dJpmWKqZ2Q0gXZxpF8D/h1fVxstoN8CLPWyFPhr",
	"jzcIfacAylqsqRP8P2vw9Gz0j7HQs/FviIS2YAGDjggapdY7jwoaZdx/BQPo+ZD1aAJuhw3tgv4b3KDt",
	"TnqkHo5jkYTblMZyEBzHp81aUweN9C0mTqaEfSChW8ec+E0EcbjzlMzmNx5Ho3RMytTwva45DrU9KlLi",
	"tbTLLvujr1c7T9CUmSmj8fUZn/WzoaP1uVlfyxIGp/4H4jMHLyiwPHvRt9hXV17Ori4901dKvHtMIfTS",
	"RJV/Ul9MaBmo4Tsou58fh0aB60eA7dcdoe5+w8oGty68ixu7dPJD/LuLWwDirvnaF4vH3L1fOXevA6yD",
	"Y6O+9QjdDUZvW3W3fplwqJ+6Xn/M6SXLwjLPsWLjR/5HI3aMtTQDFs6+w3rrVWUdzLeav2z2Wy8Wsn0D",
	"bkPO3egHNfr3mzuBICc0eni27Y43owfabs1o2sYrCgXxDqQZNRc75apKVr6Z4CyaPLwU41f01Sr1eXMp",
	"CnipT+vLT+r7sooy0YUpiu9oAnIgmXubAyu6wJovKnqo3FNnB+XXc9KZJ3McTJ21zpGd+1xAvDT12Dia",
	"ePry9J8AAAD//7UL4SbfoAAA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
