<h1 align="center" id="title">Absolutely Developer</h1>

![absolutely-developer](https://socialify.git.ci/harithzainudin/absolutely-developer/image?description=1&language=1&name=1&owner=1&pattern=Solid&theme=Light)

<p align="center"><img src="https://img.shields.io/github/stars/harithzainudin/absolutely-developer?style=social" alt="shields"> <img src="https://img.shields.io/github/followers/harithzainudin?style=social" alt="shields"> <img src="https://img.shields.io/github/last-commit/harithzainudin/absolutely-developer?style=social" alt="shields"></p>

---

This repository contains a carefully curated collection of tools and resources that I've used to become a full stack cloud developer. Whether you're a beginner or an experienced developer, you'll find something useful in this repository to help you take your development skills to the next level. From tutorials and articles to code snippets and frameworks, we've got you covered.

## Table of contents

- [📦 Content](#content)
  - [Amazon Web Services (AWS)](#amazon-web-services-aws)
  - [Serverless](#serverless)
  - [Javascript/NodeJs](#javascriptnodejs)
  - [Typescript](#typescript)
  - [Python](#python)
  - [Web Development](#web-development)
    - [CSS, Designs and Illustrations](#css-designs-and-illustrations)
    - [Tailwind CSS](#tailwind-css)
    - [Vue.js](#vuejs)
    - [Vuetify](#vuetify)
  - [DevOps and Code Improvement](#devops-and-code-improvement)
  - [Git](#git)
  - [Miscellaneous](#miscellaneous)
    - [Websites and Publications](#websites-and-publications)
    - [Utility Tools](#utility-tools)
    - [Beautifier Tools](#beautifier-tools)
    - [Markdown/Readme](#markdownreadme)
    - [AI Tools](#ai-tools)
- [🍰 Contribution Guidelines](#contribution-guidelines)
- [💻 Built with](#built-with)
- [🛡️ License](#license)
- [💖Like my work?](#like-my-work)

---

## Content:

### Amazon Web Services (AWS)

**🛠 Tools/Development**

| Name                                                                                | Description                                                                                                                                                                                                                                                   |
| ----------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [AWS Lambda Power Tuning](https://github.com/alexcasalboni/aws-lambda-power-tuning) | An open-source tool that can help you visualize and fine-tune the memory/power configuration of Lambda functions. It runs in your own AWS account - powered by AWS Step Functions - and it supports three optimization strategies: cost, speed, and balanced. |
| [Cloud Custodian](https://cloudcustodian.io/)                                       | Cloud Custodian enables you to manage your cloud resources by filtering, tagging, and then applying actions to them. The YAML DSL allows defininition of rules to enable well-managed cloud infrastructure that's both secure and cost optimized.             |
| [Amazon DynamoDB Data Modeler](https://rh-web-bucket.s3.amazonaws.com/index.html#)  | This utility creates a data model with one or more virtual Tables, allowing users to visualize how relational data might be stored and indexed in DynamoDB in order to help design efficient schema for your application.                                     |
| [DynamoDB Calculator](https://zaccharles.github.io/dynamodb-calculator/)            | DynamoDB Item Size and Consumed Capacity Calculator                                                                                                                                                                                                           |

**📒 Resources**

| Name                                                                                              | Description                                                                                                                                                                                                                          |
| ------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [AWS Stash](https://awsstash.com/)                                                                | A collection of AWS related videos, podcasts, code repositories, whitepapers, and feature releases, all in a single, easy to search interface.                                                                                       |
| [AWS Hands-On Tutorial](https://aws.amazon.com/getting-started/hands-on/)                         | Get started with step-by-step tutorials to launch your first application                                                                                                                                                             |
| [AWS CLI Command Reference](https://awscli.amazonaws.com/v2/documentation/api/latest/index.html)  | The AWS Command Line Interface is a unified tool that provides a consistent interface for interacting with all parts of AWS.                                                                                                         |
| [AWS Workshops](https://workshops.aws/)                                                           | This website lists workshops created by the teams at Amazon Web Services (AWS). Workshops are hands-on events designed to teach or introduce practical skills, techniques, or concepts which you can use to solve business problems. |
| [AWS Resource Hub](https://resources.awscloud.com/)                                               | Learn how to start building and accelerate your invotion on AWS. Whether you are new to AWS, or an experienced user, you'll find something useful to read, watch, and share.                                                         |
| [AWS Skillbuilder](https://skillbuilder.aws/)                                                     | Your learning center to build in-demand cloud skills. Skill Builder provides 500+ free digital courses, 25+ learning plans, and 19 Ramp-Up Guides                                                                                    |
| [AWS Blogs](https://aws.amazon.com/blogs)                                                         | Get the latest news about AWS launches, events, and more.                                                                                                                                                                            |
| [AWS Architecture Center](https://aws.amazon.com/architecture)                                    | Reference architecture examples and diagrams                                                                                                                                                                                         |
| [Open Guides AWS](https://github.com/open-guides/og-aws)                                          | 📙 Amazon Web Services — a practical guide                                                                                                                                                                                           |
| [AWS Partner Webinars](https://aws.amazon.com/webinars/partner-webinars/)                         | Master your cloud computing journey with help from trusted AWS Partners. AWS Partner Webinars feature live demonstrations, customer use cases, and real-time Q&A sessions with AWS experts and select AWS Partners.                  |
| [CloudFormation Cheatsheet](https://theburningmonk.com/cloudformation-ref-and-getatt-cheatsheet/) | Cheatsheet for ref and getatt in cloudformation                                                                                                                                                                                      |
| [Cloudformation User Guide](https://github.com/awsdocs/aws-cloudformation-user-guide)             | The open source version of the AWS CloudFormation User Guide                                                                                                                                                                         |
| [AWS Icons](https://awsicons.dev/)                                                                | Quickly Find & Copy AWS IconsOpen source SVG icon library with over 500+ icons                                                                                                                                                       |
| [Awesome DynamoDB](https://github.com/alexdebrie/awesome-dynamodb)                                | List of resources for learning about modeling, operating, and using Amazon DynamoDB                                                                                                                                                  |

[🆙 Go to Table of Contents](#table-of-contents)

---

### Serverless

This serverless section is more into AWS serverless and Serverless Framework.

**🛠 Tools/Development**

| Name                                                                          | Description                                                                                                                                                                          |
| ----------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [EventCatalog](https://www.eventcatalog.dev/)                                 | Documentation tool for Event-Driven Architectures. It is an Open Source project that helps you document your events, services and domainsPowered by markdown, components and plugins |
| [Async API](https://www.asyncapi.com/)                                        | Open-Source tools to easily build and maintain your event-driven architecture. All powered by the AsyncAPI specification, the industry standard for defining asynchronous APIs.      |
| [EventBridge Atlas](https://eventbridge-atlas.netlify.app/)                   | Document, Discover and Share AWS EventBridge Schemas. Turn your EventBridge Schemas into Documentation                                                                               |
| [Serverless Esbuild](https://github.com/floydspace/serverless-esbuild)        | 💨 A Serverless framework plugin to bundle JavaScript and TypeScript with extremely fast esbuild                                                                                     |
| [Serverless Webpack](https://github.com/serverless-heaven/serverless-webpack) | Serverless plugin to bundle your lambdas with Webpack                                                                                                                                |

**📒 Resources**

| Name                                                                    | Description                                                                                                                                                                                                                |
| ----------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Serverless Examples](https://www.serverless.com/examples/)             | Real world serverless code examples.                                                                                                                                                                                       |
| [Serverless Land](https://serverlessland.com/)                          | This site brings together the latest information, blogs, videos, code, and learning resources for AWS Serverless. Learn to use and build apps that scale automatically on low-cost, fully-managed serverless architecture. |
| [Awesome Eventbridge](https://github.com/boyney123/awesome-eventbridge) | List of resources for learning about events, patterns, and using Amazon EventBridge                                                                                                                                        |

[🆙 Go to Table of Contents](#table-of-contents)

---

### Javascript/NodeJs

**🛠 Tools/Development**

| Name                                      | Description                                                                                                                                                                                                                                                                               |
| ----------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Bundlephobia](https://bundlephobia.com/) | Find the cost of adding a npm package to your bundle                                                                                                                                                                                                                                      |
| [Flow](https://flow.org/)                 | This is alternative to TypeScript. Flow is a static type checker for your JavaScript code. It does a lot of work to make you more productive. Making you code faster, smarter, more confidently, and to a bigger scale. Flow checks your code for errors through static type annotations. |

**📒 Resources**

| Name                                                                                                           | Description                                                                                                                                                                                                                                       |
| -------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Ultimate Node js](https://github.com/DhanushNehru/Ultimate-NodeJs-Resources)                                  | All resources related to Node Js at one place.                                                                                                                                                                                                    |
| [You don't know JS yet](https://github.com/getify/You-Dont-Know-JS)                                            | Series of books diving deep into the core mechanisms of the JavaScript language.                                                                                                                                                                  |
| [JavasSript Questions](https://github.com/lydiahallie/javascript-questions)                                    | A long list of (advanced) JavaScript questions, and their explanations ✨                                                                                                                                                                         |
| [33 js Concepts](https://github.com/leonardomso/33-js-concepts)                                                | 📜 33 JavaScript concepts every developer should know.                                                                                                                                                                                            |
| [JavaScript Info](https://javascript.info/)                                                                    | Here we learn JavaScript, starting from scratch and go on to advanced concepts like OOP.                                                                                                                                                          |
| [Clean Code JavaScript](https://github.com/ryanmcdermott/clean-code-javascript)                                | 🛁 Clean Code concepts adapted for JavaScript                                                                                                                                                                                                     |
| [Node.js best Practice](https://github.com/goldbergyoni/nodebestpractices)                                     | Contain all Node.js best practices                                                                                                                                                                                                                |
| [Practica](https://github.com/practicajs/practica)                                                             | Node.js solution starter that is production-ready, packed with ✅ best practices and built with simplicity in mind                                                                                                                                |
| [Data Structures Algorithms JS](https://github.com/amejiarosario/dsa.js-data-structures-algorithms-javascript) | 🥞Data Structures and Algorithms explained and implemented in JavaScript + eBook                                                                                                                                                                  |
| [JavaScript Algorithms](https://github.com/trekhleb/javascript-algorithms)                                     | This repository contains JavaScript based examples of many popular algorithms and data structures.                                                                                                                                                |
| [Modern JavaScript Cheatsheet](https://github.com/mbeaudru/modern-js-cheatsheet)                               | Cheatsheet for the JavaScript knowledge you will frequently encounter in modern projects.                                                                                                                                                         |
| [Vanilla JS Toolkit](https://vanillajstoolkit.com/)                                                            | A collection of tools and snippets for working with JavaScript. Find modern JS methods and utility functions, and browse hand‑selected libraries, boilerplates, and learning resources.                                                           |
| [JavaScript Reference](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference)                      | The JavaScript reference serves as a repository of facts about the JavaScript language. The entire language is described here in detail. As you write JavaScript code, you'll refer to these pages often (thus the title "JavaScript reference"). |
| [JS Cheatsheet from I Love Coding](https://ilovecoding.org/blog/js-cheatsheet)                                 | JavaScript Cheatsheet - Comprehensive PDF included. From basic to advanced concepts. ES6+, simple explanations, DOM API, Event loop, functions, array, object, Type and so much more. Everything explained in this 13 page JavaScript Cheatsheet  |
| [Javascript Testing Best Practices](https://github.com/goldbergyoni/javascript-testing-best-practices)         | 📗🌐 🚢 Comprehensive and exhaustive JavaScript & Node.js testing best practices                                                                                                                                                                  |

We concentrate on the language itself here, with the minimum of environment-specific notes.|

[🆙 Go to Table of Contents](#table-of-contents)

---

### Typescript

**🛠 Tools/Development**

| Name                                                         | Description                                                                                                                                                                                                                |
| ------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [TS-toolbelt](https://millsp.github.io/ts-toolbelt/)         | TypeScript's largest utility library. Spend less time, build stronger. Benefit from a wide range of generic type functions to achieve better type safety. Work just like lodash, or ramda, but applied to the type system. |
| [Utility Types](https://github.com/piotrwitek/utility-types) | Collection of utility types, complementing TypeScript built-in mapped types and aliases (think "lodash" for static types).                                                                                                 |

**📒 Resources**

| Name                                                                       | Description                                                                                                                                                                                                                                                                                                                                                                     |
| -------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Type Challenge](https://github.com/type-challenges/type-challenges)       | Collection of TypeScript type challenges with online judge. This project is aimed at helping you better understand how the type system works, writing your own utilities, or just having fun with the challenges. We are also trying to form a community where you can ask questions and get answers you have faced in the real world - they may become part of the challenges! |
| [Clean code Typescript](https://github.com/labs42io/clean-code-typescript) | Clean Code concepts adapted for TypeScript.                                                                                                                                                                                                                                                                                                                                     |

[🆙 Go to Table of Contents](#table-of-contents)

---

### Python

[Awesome Python](https://awesome-python.com/) - A curated list of awesome Python frameworks, libraries, software and resources

[🆙 Go to Table of Contents](#table-of-contents)

---

### Web Development

**🛠 Tools/Development**

| Name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Description                                                                                                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Responsively](https://responsively.app/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Develop responsive web apps 5x faster! A must-have DevTool for all Front-End developers that will make your job easier. All target screens are displayed side by side in a single window                                 |
| [Codepen](https://codepen.io/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Web-based development platform that allows users to modify front-end languages such as HTML, CSS, and JavaScript without having to install any software.                                                                 |
| [Public Apis](https://github.com/public-apis/public-apis)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | A collective list of free APIs for use in software and web development                                                                                                                                                   |
| [JSitor](https://jsitor.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Online tool for testing and showcasing user-created and collaboration HTML, CSS, JavaScript and NodeJS snippets                                                                                                          |
| [CodeSandbox](https://codesandbox.io/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Create, share, and get feedback with collaborative sandboxes for rapid web development.                                                                                                                                  |
| [JSFiddle](https://jsfiddle.net/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Test your JavaScript, CSS, HTML or CoffeeScript online                                                                                                                                                                   |
| [Github Pages](https://pages.github.com/), [Glitch](https://glitch.com/), [Fleek](https://fleek.co/), [Netlify](https://www.netlify.com/), [Render](https://render.com/), [Surge](https://surge.sh/), [Vercel](https://vercel.com/), [Hostman](https://hostman.com/), [Cloudfare Pages](https://pages.cloudflare.com/), [W3Schools Spaces](https://www.w3schools.com/spaces/), [Heroku](https://www.heroku.com/home), [Firebase Google](https://firebase.google.com/), [DigitalOcean](https://www.digitalocean.com/), [GitLab Pages](https://docs.gitlab.com/ee/user/project/pages/), [Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html) | List of Free Hosting Providers (Some are not totally free, but they got free/limited plan. To check the differences, read [this article](https://blog.bitsrc.io/15-free-hosting-for-front-end-developers-9224bc34e14a) ) |
| [Lorem Space](https://lorem.space/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | API for placeholder images but useful!                                                                                                                                                                                   |
| [Openbase](https://openbase.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Choose the right package every time. Compare open-source packages with powerful metrics and user reviews. Package for JavaScript, Go, Python, Swift, Java and Rust                                                       |
| [oAuth Debugger](https://oauthdebugger.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Test OAuth 2.0 requests and debug responses.                                                                                                                                                                             |
| [Frontend Checklist](https://frontendchecklist.io/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 🗂 The Front-End Checklist Application is perfect for modern websites and meticulous developers!                                                                                                                          |
| [Jam](https://jam.dev)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Report bugs in seconds, without disrupting your workflow. Capture your screen plus developer logs in one click. It’s so easy, you’ll forget you hate bugs.                                                               |
| [Locofy](https://www.locofy.ai/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Turn your designs into production-ready frontend code for mobile apps and web                                                                                                                                            |
| [{JSON} Placeholder](https://jsonplaceholder.typicode.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Free fake API for testing and prototyping. Powered by JSON Server + LowDB. Tested with XV.                                                                                                                               |
| [DummyJSON](https://dummyjson.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Get dummy/fake JSON data to use as placeholder in development or in prototype testing.                                                                                                                                   |
| [Logo ipsum](https://logoipsum.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Temporary fill the logo space with logoipsum until you have the real logo, because that top left corner doesn't looks good to be empty.                                                                                  |
| [Stoplight Spectral](https://stoplight.io/open-source/spectral)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | An Open-Source API Style Guide Enforcer / Linter                                                                                                                                                                         |
| [GTmetric](https://gtmetrix.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | See how your site performs, reveal why it's slow and discover optimization opportunities.                                                                                                                                |
| [MapLibre](https://maplibre.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Open-source mapping libraries for web and mobile app developers.                                                                                                                                                         |
| [OpenLayers](https://openlayers.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | A high-performance, feature-packed library for all your mapping needs.                                                                                                                                                   |
| [Leaflet JS](https://leafletjs.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | An open-source JavaScript library for mobile-friendly interactive maps                                                                                                                                                   |
| [Flexbox Defense](http://www.flexboxdefense.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Your job is to stop the incoming enemies from getting past your defenses. Unlike other tower defense games, you must position your towers using CSS!                                                                     |
| [FontJoy](https://fontjoy.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Font pairing made simple. Generate font combinations with deep learning                                                                                                                                                  |
| [FrontEnd Tools](https://murtazajoo.me/tools/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Top frontend free development online tools you must know. FREE Frontend website all at one place,html biolerplate , js tools , frontend css.                                                                             |
| [LocalTunnel](https://theboroer.github.io/localtunnel-www/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Localtunnel allows you to easily share a web service on your local development machine without messing with DNS and firewall settings.                                                                                   |

**📒 Resources**

| Name                                                                                                     | Description                                                                                                                                      |
| -------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Ultimate Web Development Resources](https://github.com/DhanushNehru/Ultimate-Web-Development-Resources) | A collection of Web Developement Resources at one place                                                                                          |
| [App Ideas](https://github.com/florinpop17/app-ideas)                                                    | A Collection of application ideas which can be used to improve your coding skills.                                                               |
| [Awesome Web Dev Resources](https://web-dev-resources.com/#/)                                            | This is an awesome project about Web Development resources.                                                                                      |
| [Big List of Naughty String](https://github.com/minimaxir/big-list-of-naughty-strings)                   | The Big List of Naughty Strings is a list of strings which have a high probability of causing issues when used as user-input data.               |
| [50 Projects 50 Days](https://github.com/bradtraversy/50projects50days)                                  | 50+ mini web projects using HTML, CSS & JS                                                                                                       |
| [DevHints](https://devhints.io/)                                                                         | A ridiculous collection of web developments cheatsheets                                                                                          |
| [Scrimba](https://scrimba.com/allcourses?price=free)                                                     | Interactive coding learning platform that features coding screencasts, a code editor, and a community feature for learners and instructors.      |
| [APILayer](https://apilayer.com/)                                                                        | A leading provider of cloud API and SaaS brands trusted by close to 1 million customers — from developers, startups all the way to Fortune 500s. |
| [Rapid API](https://rapidapi.com/hub)                                                                    | Discover and connect to thousands of APIs                                                                                                        |
| [HTML Head](https://htmlhead.dev/)                                                                       | A simple guide to HTML <head> elements                                                                                                           |
| [HTML Cheatsheet](https://htmlcheatsheet.com/)                                                           | Online interactive HTML Cheat Sheet contains useful code examples and web developer tools, markup generators and more.                           |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### CSS, Designs and Illustrations

| Name                                                                     | Description                                                                                                                                                                                                                 |
| ------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Storytale](https://storytale.io/)                                       | High-class illustrations for web and mobile projects                                                                                                                                                                        |
| [Color Hunt](https://colorhunt.co/)                                      | Website that allows you to select gorgeous colour palettes                                                                                                                                                                  |
| [Popmotion](https://popmotion.io/)                                       | The animator’s JavaScript toolbox.                                                                                                                                                                                          |
| [Animate CSS](https://animate.style/)                                    | Animate.css is a library of ready-to-use, cross-browser animations for use in your web projects. Great for emphasis, home pages, sliders, and attention-guiding hints.                                                      |
| [Checklist Design](https://www.checklist.design/)                        | A place to synthesize website design knowledge through providing information and essential elements when designing website elements                                                                                         |
| [UX Challenges](https://uxtools.co/challenges/)                          | Practical UX skills and tools and A collection of exercises on Ux design for websites.                                                                                                                                      |
| [Animista](https://animista.net/)                                        | CSS Animations on demand                                                                                                                                                                                                    |
| [Patternpad](https://patternpad.com/)                                    | Design beautiful patterns from endless variations                                                                                                                                                                           |
| [CSS Buttons Generator](https://markodenic.com/tools/buttons-generator/) | A collection of CSS button generator that you can copy and paste directly                                                                                                                                                   |
| [Hover](https://ianlunn.github.io/Hover/)                                | A collection of CSS3 powered hover effects to be applied to links, buttons, logos, SVG, featured images and so on. Easily apply to your own elements, modify or just use for inspiration. Available in CSS, Sass, and LESS. |
| [CollectUI](https://collectui.com/)                                      | Daily inspiration collected from daily ui archive and beyond. Hand picked, updating daily.                                                                                                                                  |
| [Three Dots](https://nzbin.github.io/three-dots/)                        | 🔮 Three Dots is a set of CSS loading animations made with just single element.                                                                                                                                             |
| [Anime JS](https://animejs.com/)                                         | A lightweight JavaScript animation library with a simple, yet powerful API. It works with CSS properties, SVG, DOM attributes and JavaScript Objects.                                                                       |
| [Shaper](https://hihayk.github.io/shaper/)                               | Interface styles shaper                                                                                                                                                                                                     |
| [Scale](https://hihayk.github.io/scale)                                  | Color Scale Generator                                                                                                                                                                                                       |
| [unDraw](https://undraw.co/)                                             | Open-source illustrations for any idea you can imagine and create. A constantly updated design project with beautiful SVG images that you can use completely free and without attribution.                                  |
| [Loading.io](https://loading.io/)                                        | Animation made easy. Ajax Loader, Animated Icons, Live Background ... in GIF / SVG / APNG / CSS !                                                                                                                           |
| [Coolors](https://coolors.co/)                                           | The super fast color palettes generator! Create the perfect palette or get inspired by thousands of beautiful color schemes.                                                                                                |
| [CSS Layout Generators](https://layout.bradwoods.io/)                    | A CSS Grid generator & CSS Flexbox generator. A tool for generating UI layout component code.                                                                                                                               |
| [CSS Grid Generator](https://github.com/sdras/cssgridgenerator)          | 🧮 Generate basic CSS Grid code to make dynamic layouts!                                                                                                                                                                    |
| [CSS Gradient](https://cssgradient.io/)                                  | CSS Gradient is a happy little website and free tool that lets you create a gradient background for websites.                                                                                                               |
| [Smooth Shadow](https://shadows.brumm.af/)                               | Make a smooth shadow, friend.                                                                                                                                                                                               |
| [SVG Backgrounds](https://www.svgbackgrounds.com/)                       | Customize and apply backgrounds fast. Create stunning websites easily with fullscreen graphics under 5KB                                                                                                                    |
| [Grabient](https://www.grabient.com/)                                    | Beautiful and simple UI for generating web gradients.                                                                                                                                                                       |
| [ColorSpace](https://mycolor.space/)                                     | Never waste Hours on finding the perfect Color Palette again! JUST ENTER A COLOR! And Generate nice Color Palettes                                                                                                          |
| [Error 404](https://error404.fun/)                                       | Make a unique journey through 404 error pages on your website Use these illustrations that describe better than words                                                                                                       |
| [Glassmorphism CSS Generator](https://ui.glass/generator/)               | Get started with this free CSS generator based on the glassmorphism design specifications to quickly design and customize the style properties.                                                                             |
| [Neumorphism](https://neumorphism.io/)                                   | Generate Soft-UI CSS code                                                                                                                                                                                                   |
| [UIVerse](https://uiverse.io/)                                           | Open-Source UI elements for any project. Create, share, and use beautiful custom elements made with HTML and CSS.                                                                                                           |
| [Hero Patterns](https://heropatterns.com/)                               | A collection of repeatable SVG background patterns for you to use on your web projects.                                                                                                                                     |
| [haikei](https://haikei.app/)                                            | Generate unique SVG design assets. Haikei is a web app to generate stunning visual content – ready to use with your design tools and workflow. Free, no signups, no credit cards.                                           |
| [three.js](https://threejs.org/)                                         | Cross-browser JavaScript library and application programming interface used to create and display animated 3D computer graphics in a web browser using WebGL                                                                |
| [ScrollMagic](https://scrollmagic.io/)                                   | The javascript library for magical scroll interactions. ScrollMagic helps you to easily react to the user's current scroll position.                                                                                        |
| [Locomotive Scroll](https://github.com/locomotivemtl/locomotive-scroll)  | 🛤 Detection of elements in viewport & smooth scrolling with parallax.                                                                                                                                                       |
| [Swiper JS](https://swiperjs.com/)                                       | The Most Modern Mobile Touch Slider                                                                                                                                                                                         |
| [Lax JS](https://github.com/alexfoxy/lax.js)                             | Simple & lightweight (<4kb gzipped) vanilla JavaScript library to create smooth & beautiful animations when you scroll.                                                                                                     |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Tailwind CSS

Main references - [Awesome Tailwind CSS](https://github.com/aniftyco/awesome-tailwindcss)

Below list is the one that doesn't make it to Awesome Tailwind CSS

| Name                                                                                                              | Description                                                                                                                                                                                                                |
| ----------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Creative Tim: Tailwind Starter Kit](https://www.creative-tim.com/learning-lab/tailwind-starter-kit/presentation) | Tailwind Starter Kit is Free and Open Source. It does not change or add any CSS to the already one from TailwindCSS. It features multiple HTML elements and it comes with dynamic components for ReactJS, Vue and Angular. |
| [DevDojo Buttons](https://devdojo.com/tailwindcss/buttons)                                                        | A unique collection of Copy & Paste TailwindCSS buttons 🙌                                                                                                                                                                 |

😎 Awesome things related to Tailwind CSS

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Vue.js

This is the only repository that you need to know, it contains everything!

[Awesome Vue](https://github.com/vuejs/awesome-vue)

🎉 A curated list of awesome things related to Vue.js

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Vuetify

This is the only repository that you need to know, it contains everything!

[Awesome Vuetify](https://github.com/vuetifyjs/awesome-vuetify)

🎉 The best resources related to Vuetify

[🆙 Go to Table of Contents](#table-of-contents)

---

### DevOps and Code Improvement

**🛠 Tools/Development**

| Name                                         | Description                                                                                                                                                                                                                    |
| -------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Husky](https://typicode.github.io/husky/#/) | Husky improves your commits and more 🐶 woof! You can use it to lint your commit messages, run tests, lint code, etc... when you commit or push. Husky supports all Git hooks.                                                 |
| [jscpd](https://github.com/kucherenko/jscpd) | Copy/paste detector for programming source code.                                                                                                                                                                               |
| [Danger](https://danger.systems/)            | Danger runs during your CI process, and gives teams the chance to automate common code review chores.This provides another logical step in your build, through this Danger can help lint your rote tasks in daily code review. |

**📒 Resources**

| Name                                                                 | Description                                                                                                                                                                                     |
| -------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [90 Days of DevOps](https://github.com/MichaelCade/90DaysOfDevOps)   | Documenting repository for learning the world of DevOps                                                                                                                                         |
| [Level Up Gitlab](https://levelup.gitlab.com/)                       | Boost your DevOps skills With GitLab’s DevOps training Learn. Earn. Grow.                                                                                                                       |
| [DevOps Exercises](https://github.com/bregman-arie/devops-exercises) | Linux, Jenkins, AWS, SRE, Prometheus, Docker, Python, Ansible, Git, Kubernetes, Terraform, OpenStack, SQL, NoSQL, Azure, GCP, DNS, Elastic, Network, Virtualization. DevOps Interview Questions |

[🆙 Go to Table of Contents](#table-of-contents)

---

### Git

**🛠 Tools/Development**

| Name                                                     | Description                                     |
| -------------------------------------------------------- | ----------------------------------------------- |
| [GitIgnore](https://www.toptal.com/developers/gitignore) | Create useful .gitignore files for your project |
| [What the commit](http://whatthecommit.com/)             | Generate random funny and useless commit        |

**📒 Resources**

| Name                                                     | Description                                                                                                                                                                                                     |
| -------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Git for Everybody](https://gitforeverybody.com/)        | Learn the git flow you'll use everyday as a developer                                                                                                                                                           |
| [Learn Git Branching](https://learngitbranching.js.org/) | The most visual and interactive way to learn Git on the web; you'll be challenged with exciting levels, given step-by-step demonstrations of powerful features, and maybe even have a bit of fun along the way. |

[🆙 Go to Table of Contents](#table-of-contents)

---

### Miscellaneous

**🛠 Tools/Development**

| Name                                                 | Description                                                                                                                                                                                                                                                                                       |
| ---------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Parrot Live](https://github.com/hugomd/parrot.live) | Using frames from terminal-parrot, to allow any computer with curl to display an animated party parrot                                                                                                                                                                                            |
| [Github Gist](https://gist.github.com/)              | Share snippets or excerpts of data/code with others                                                                                                                                                                                                                                               |
| [Regex 101](https://regex101.com/)                   | Build, test, and debug Regex. They have regex cheatsheet in here also                                                                                                                                                                                                                             |
| [Snyk](https://snyk.io/test/)                        | Check for known vulnerabilities in public GitHub repos, npm packages and Docker images                                                                                                                                                                                                            |
| [FauxID](https://fauxid.com/)                        | Fake name & ID generator. Including bank address, phone number, DOB, banking number, companies and others! To make dummy data without you need to think                                                                                                                                           |
| [Generate Random](https://generate-random.org/)      | Generate random Identities, passwords, numbers, letters, words, strings, Base64 strings, UUIDs, API Keys, Encryption Keys, API Tokens, Dices, Risk Dices, Lottery Drawing, QR Codes, Barcodes, Colors, Random Pickers, List Randomizer, and Teams Generator                                       |
| [Learn Anything](https://learn-anything.xyz/)        | The platform for knowledge discovery that helps you understand any topic through the most efficient paths, as voted by the community                                                                                                                                                              |
| [Loom](https://www.loom.com/)                        | Record quick videos of your screen and cam. An essential tool for hybrid workplaces                                                                                                                                                                                                               |
| [DrawKit](https://drawkit.com/)                      | Beautiful, free illustrations. Hand-drawn vector illustrations and icon resources, perfect for your next project.                                                                                                                                                                                 |
| [Uneed](https://www.uneed.best/)                     | The best tools on the internet, curated by hand, daily                                                                                                                                                                                                                                            |
| [Coding Game](https://www.codingame.com/start)       | Step up your coding game. The new way to improve your programming skills while having fun and getting noticed                                                                                                                                                                                     |
| [Codiga](https://www.codiga.io/)                     | Customizable static code analysis that works in your IDE, CI/CD pipelines and more                                                                                                                                                                                                                |
| [CodeGeeX](https://codegeex.ai/)                     | Free AI Coding Assistant.  Automatic Code Generation, Functional-level Code Completion, Cross-lingual Code Translation, 10+ Programming Languages, Support VSCode, Jetbrains IDEs                                                                                                                 |
| [Thunderclient](https://www.thunderclient.com/)      | Hand-crafted lightweight Rest Client for Testing APIs                                                                                                                                                                                                                                             |
| [Exercism](https://exercism.org/)                    | Get really good at programming. Develop fluency in 62 programming languages with our unique blend of learning, practice and mentoring. Exercism is fun, effective and 100% free, forever.                                                                                                         |
| [Streamline](https://www.streamlinehq.com/)          | Access the world's largest and most consistent icon and illustration sets. Customise 140,000+ vector graphics, and add them to your projects in seconds ⚡️                                                                                                                                       |
| [CodeChef](https://www.codechef.com/)                | CodeChef was created as a platform to help programmers make it big in the world of algorithms, computer programming, and programming contests                                                                                                                                                     |
| [LeetCode](https://leetcode.com/)                    | The best platform to help you enhance your skills, expand your knowledge and prepare for technical interviews.                                                                                                                                                                                    |
| [HackerRank](https://www.hackerrank.com/)            | HackerRank is a place where programmers from all over the world come together to solve problems in a wide range of Computer Science domains such as algorithms, machine learning, or artificial intelligence, as well as to practice different programming paradigms like functional programming. |

**📒 Resources**

| Name                                                                                                   | Description                                                                                                                                                                                                                                       |
| ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [freeCodeCamp](https://github.com/freeCodeCamp/freeCodeCamp)                                           | Friendly community where you can learn to code for free. Their full-stack web development and machine learning curriculum is completely free and self-paced. They have thousands of interactive coding challenges to help you expand your skills. |
| [Coding Interview University](https://github.com/jwasham/coding-interview-university)                  | Multi-month study plan for becoming a software engineer for a large company.                                                                                                                                                                      |
| [Awesome](https://github.com/sindresorhus/awesome)                                                     | 😎 Awesome lists about all kinds of interesting topics                                                                                                                                                                                            |
| [The Algorithms](https://the-algorithms.com/)                                                          | Open Source resource for learning Data Structures & Algorithms and their implementation in any Programming Language                                                                                                                               |
| [You don't need](https://github.com/you-dont-need)                                                     | A Github Repository that show you may not need a certain technologies/things to achieve something                                                                                                                                                 |
| [30 Seconds of Code](https://www.30secondsofcode.org/)                                                 | Provides a wide variety of snippet and article collections for all your development needs                                                                                                                                                         |
| [Project Based Learning](https://github.com/practical-tutorials/project-based-learning)                | Curated list of project-based tutorials                                                                                                                                                                                                           |
| [Build your own X](https://github.com/codecrafters-io/build-your-own-x#build-your-own-game)            | Master programming by recreating your favorite technologies from scratch.                                                                                                                                                                         |
| [DevDocs](https://devdocs.io/)                                                                         | Brings together numerous API documentation in a single, searchable interface. You will find docs related to various programming languages, technologies in one place                                                                              |
| [Developer Roadmaps](https://roadmap.sh/)                                                              | Community effort to create roadmaps, guides and other educational content to help guide the developers in picking up the path and guide their learnings                                                                                           |
| [Programmer Humor](https://programmerhumor.io/)                                                        | Various memes and jokes related to programming and developers. Have Fun.                                                                                                                                                                          |
| Free For Dev - [Github](https://github.com/ripienaar/free-for-dev), [Website](https://free-for.dev/#/) | A list of SaaS, PaaS and IaaS offerings that have free tiers of interest to devops and infradev                                                                                                                                                   |
| [Internet is Beautiful](https://www.internetisbeautiful.co/)                                           | Discover the most interesting, useful and awesome websites from the depths of the internet.                                                                                                                                                       |
| [Every Programmer Should Know](https://github.com/mtdvio/every-programmer-should-know)                 | A collection of (mostly) technical things every software developer should know about                                                                                                                                                              |
| [VS Code can do that??](https://vscodecandothat.com/)                                                  | All the best things about Visual Studio Code that nobody ever bothered to tell you                                                                                                                                                                |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Websites and Publications

| Name                                                        | Description                                                                                                                                                                                                                                                                                                                 |
| ----------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Dev.to](https://dev.to/)                                   | Community of amazing Developers. Place where coders share, stay up-to-date and grow their careers                                                                                                                                                                                                                           |
| [daily.dev](https://app.daily.dev/)                         | Platform where you can find so many good articles to read daily. It shows the best articles from various platforms directly in your feed. They have browser extension also.                                                                                                                                                 |
| [Scrum Guides](https://scrumguides.org/)                    | Official Scrum Body of Knowledge. It was written by Ken Schwaber and Jeff Sutherland, co-creators of Scrum.                                                                                                                                                                                                                 |
| [Scrum Org](https://www.scrum.org/)                         | Scrum.org, the Home of Scrum, was founded by Scrum co-creator Ken Schwaber as a mission-based organization to help people and teams solve complex problems. We do this by enabling people to apply Professional Scrum through training courses, certifications and ongoing learning all based on a common competency model. |
| [Code Magazine](https://www.codemag.com/magazine/allissues) | Magazine for developer to read                                                                                                                                                                                                                                                                                              |
| [Web Dev by Chrome DevRel Team](https://web.dev/)           | Guidance to build modern web experiences that work on any browser.                                                                                                                                                                                                                                                          |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Utility Tools

| Name                                                      | Description                                                                                                                                                                                 |
| --------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Small Dev Tools](https://smalldev.tools/)                | Offers a variety of free developer tools, including encoders/decoders, HTML/CSS/Javascript formatters, minifies, fake or test data generators, and more. It also allows you to share codes. |
| [Kody tools](https://www.kodytools.com/)                  | Hub of online tools such as code formatters, code minifiers, converters, calculators, hash generators, text generators, encoders, decoders, etc.                                            |
| [SE Tools](https://www.setools.xyz/)                      | Free online tools                                                                                                                                                                           |
| [FreeCodeTools](https://freecodetools.org/)               | Build better and faster. FreeCodeTools project was created to help you to do stuff faster. It's free and always will be.                                                                    |
| [ASCII Tree Generator](https://ascii-tree-generator.com/) | Visualize and create your perfect folder structure for your next project. Easily convert to an ASCII format to save to your documentation.                                                  |
| [Array This](https://arraythis.com/)                      | Instantly convert your text list to array; valid for JS, PHP, PERL, PYTHON (as list) and much more.                                                                                         |
| [KeyFrames](https://keyframes.app/)                       | More tools for devs. Browser-based, mobile-friendly, actually private tools that make CSS a little less bad.                                                                                |
| [Matter](https://hihayk.github.io/matter/)                | A task manager that highlights what matters most to you. No account needed. Simple, easy and straight forward.                                                                              |
| [Omatsuri App](https://omatsuri.app/)                     | Open source browser tools for everyday use                                                                                                                                                  |
| [Lepton](https://hackjutsu.com/Lepton/)                   | A lean snippet manager powered by GitHub Gist                                                                                                                                               |
| [Snibox](https://snibox.github.io/)                       | Self-hosted snippet manager. Developed to collect and organize code snippets.                                                                                                               |
| [massCode](https://masscode.io/)                          | A free and open source code snippets manager for developers. It helps you create and organize your own personal snippet collection and have quick access to it.                             |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Beautifier Tools

| Name                                       | Description                                                                                                                 |
| ------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------- |
| [Screely](https://www.screely.com/)        | Instantly turn a screenshot into a browser mockup                                                                           |
| [Code Beautify](https://codebeautify.org/) | Not only beautify the code, they also have different type of converter, sorter, tools, generator.. Everything, you name it! |
| [Profile Pic Maker](https://pfpmaker.com/) | Creates a professional and beautiful profile for each photo in your Web developer portfolio                                 |
| [ASCII Cinema](https://asciinema.org/)     | Record and share your terminal sessions, the simple way.                                                                    |
| [ray.so](https://ray.so/)                  | Create beautiful images of your code.                                                                                       |
| [poest.so](https://poet.so/)               | Create beautiful images of Twitter posts                                                                                    |
| [Carbon](https://carbon.now.sh/)           | Create and share beautiful images of your source code                                                                       |
| [Socialify](https://socialify.git.ci/)     | Generate a beautiful project image                                                                                          |
| [Shields](https://shields.io/)             | Service for creating legible badges in SVG format, which can easily be included in GitHub readmes or any other web page.    |
| [resume.io](https://resume.io/)            | Create a professional resume by providing you with well-tested templates                                                    |
| [BrowserFrame](https://browserframe.com/)  | The easiest way to wrap screenshots in browser frames. Supports multiple browsers, operating systems, and themes.           |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### Markdown/Readme

**🛠 Tools/Development**

| Name                                                                                          | Description                                                                                                             |
| --------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------- |
| [Readme-Gen](https://readme-gen.vercel.app/)                                                  | Advanced README generator for GitHub projects                                                                           |
| [Stackedit](https://stackedit.io/)                                                            | In browser Markdown editor                                                                                              |
| [Online Markdown Table of Contents Generator](https://luciopaiva.com/markdown-toc/)           | Generate Table of Contents for your markdown file                                                                       |
| [readme.so](https://readme.so/)                                                               | Simple editor that allows you to quickly add and customize all the sections you need for your project's readme          |
| [Github Profile ReadmMe Maker](https://gprm.itsvg.in/)                                        | Create your perfect GitHub Profile ReadMe in the best possible way. Lots of features and tools included, all for free ! |
| [ProfileMe](https://www.profileme.dev/)                                                       | Create an amazing GitHub profile in minutes                                                                             |
| [REHeader](https://reheader.glitch.me/)                                                       | Generate beautiful header images for your GitHub profile READMEs.                                                       |
| [Github Profile Readme Generator](https://rahuldkjain.github.io/gh-profile-readme-generator/) | Direct and Straightforward Github Profile Readme Generator                                                              |
| [Profilinator](https://profilinator.rishav.dev/)                                              | Another Profile Readme Generator that contain many skillset                                                             |

**📒 Resources**

| Name                                                                                           | Description                                       |
| ---------------------------------------------------------------------------------------------- | ------------------------------------------------- |
| [Markdown here - cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet) | Markdown cheatsheet from Markdown here repository |

[🆙 Go to Table of Contents](#table-of-contents)

---

#### AI Tools

| Name                                                                             | Description                                                                                                                                                                                                                              |
| -------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Futurepedia](https://www.futurepedia.io/)                                       | THE LARGEST AI TOOLS DIRECTORY, UPDATED DAILY.                                                                                                                                                                                           |
| [Perplexity ai](https://www.perplexity.ai/)                                      | New search interface that uses advanced artificial intelligence technologies, such as OpenAI's GPT-3 model, to provide direct answers to questions and summaries and citations for search results.                                       |
| [ChatGPT](https://chat.openai.com/chat)                                          | Chatbot developed by OpenAI and launched in November 2022. It is built on top of OpenAI's GPT-3 family of large language models and has been fine-tuned using both supervised and reinforcement learning techniques.                     |
| [ChatGPT chrome extension](https://github.com/gragland/chatgpt-chrome-extension) | A ChatGPT Chrome extension. Integrates ChatGPT into every text box on the internet.                                                                                                                                                      |
| [ChatGPT Google Extension](https://github.com/wong2/chatgpt-google-extension)    | Integrate ChatGPT into browser                                                                                                                                                                                                           |
| [Text2SQL](https://www.text2sql.ai/)                                             | Generate SQL with AI in seconds. SQL is hard. Improve your skills and save time                                                                                                                                                          |
| [Humata](https://www.humata.ai/)                                                 | Ask AI anything about your filesResearch 100X Faster. Learn 100X Faster. Create Reports 100X Faster. Analyze Legal Documents 100X Faster. Understand Technical Papers 100X Faster. Ask Questions & Get Answers About Any File Instantly. |
| [ElevenLabs](https://elevenlabs.io)                                              | Prime Voice AIThe most realistic and versatile AI speech software, ever. Eleven brings the most compelling, rich and lifelike voices to creators and publishers seeking the ultimate tools for storytelling.                             |
| [Codeium](https://codeium.com/)                                                  | The modern coding superpower                                                                                                                                                                                                             |
| [Speechify](https://speechify.com)                                               | The #1 AI Text to Speech Reader                                                                                                                                                                                                          |
| [Simplified](https://simplified.com/)                                            | Unleash the power of AI to supercharge content creation for everyone                                                                                                                                                                     |
| [Wonsulting Resume AI](https://www.wonsulting.com/resumai)                       | Let AI write your resume for you                                                                                                                                                                                                         |
| [Rytr](https://rytr.me/)                                                         | Rytr is an AI writing assistant that helps you create high-quality content, in just a few seconds, at a fraction of the cost!                                                                                                            |
| [TLDV ](https://tldv.io/)                                                        | The meeting recorder that transcribes & summarizes your calls with customers, prospects, and your team.                                                                                                                                  |

[🆙 Go to Table of Contents](#table-of-contents)

---

## Contribution Guidelines

Well if you want to contribute just submit a pull request and I will review it! Feel free to add anything that you think is useful. There are no particular guidelines.

If you encounter any website or repo that is not active, do raise an issue and I will remove it. Thank you!

## Built with

- ❤️ Love

---

## License

This project is licensed under the [MIT License](https://github.com/harithzainudin/absolutely-developer/blob/main/LICENSE)

## Like my work?

Hmm I just want other people to benefit from this repo. Feel free to give me any other suggestions to improve this repository. You can start a discussion I believe or create a pull request to discuss
