﻿var province = [];
var weatherData = null;
var MZ_weather = {
	weatherUrl: '/',
	cookiePre: 'MZ_weather',
	
	$: function(id) {
		return document.getElementById(id);
	},
	
	extend: function(destination, source) {
		for (var property in source) {
			destination[property] = source[property];
		}
		return destination;
	},
	
	loadJs: function(file, callback, charset) {
		var head = document.getElementsByTagName('head')[0];
		var js = document.createElement('script');
		js.setAttribute('type', 'text/javascript');
		js.setAttribute('src', file);
		if (charset) js.setAttribute('charset', charset);
		head.appendChild(js);
		js.onload = js.onreadystatechange = function() {
			if (js.readyState && js.readyState != 'loaded' && js.readyState != 'complete') return;
			js.onreadystatechange = js.onload = null;
			if (callback) callback();
		}
		return false;
	},
	
	tool: function(type, valArr, target, noCahce) {
		var varStrArr = ['plusName=' + type, 'callback=MZ_weather.$("'+target+'").innerHTML={0};{1}'];
		for (var i = 0; i < valArr.length; i++) {
			varStrArr.push(valArr[i] + '=' + this.$(valArr[i]).value);
		}
		if (noCahce) varStrArr.push('r=' + new Date().getTime());
		this.loadJs(MZ_weather.weatherUrl + '?action=tool&' + varStrArr.join('&'));
	},
	
	getCookie: function(name) {
		name = this.cookiePre + '_' + name;
		var cookie_start = document.cookie.indexOf(name);
		var cookie_end = document.cookie.indexOf(";", cookie_start);
		return cookie_start == -1 ? '' : unescape(document.cookie.substring(cookie_start + name.length + 1, (cookie_end > cookie_start ? cookie_end : document.cookie.length)));
	},
	
	setCookie: function(name, value, seconds, path, domain, secure) {
		name = this.cookiePre + '_' + name;
		var expires = new Date();
		expires.setTime(expires.getTime() + seconds);
		document.cookie = escape(name) + '=' + escape(value)
			+ (expires ? '; expires=' + expires.toGMTString() : '')
			+ (path ? '; path=' + path : '/')
			+ (domain ? '; domain=' + domain : '')
			+ (secure ? '; secure' : '');
	},
	
	set: function(cityId, msg) {
		this.setCookie('cityId', cityId, 31536000000, '/', this.cookieDomain);
		if (msg) alert(msg);
	},
	
	show: function(data) {
		if (this.cityId == 0) {
			this.set(data.cityId);
		}
		data.url = this.weatherUrl + data.url;
		if (this.jump) {
			top.location.href = data.url;
		}
		weatherData = data;
		this.template = this.template || this.$(this.templateId).innerHTML
			.replace(/%7B/img, '{').replace(/%7D/img, '}')
			.replace(/%5B/img, '[').replace(/%5D/img, ']')
			.replace('<!--', '').replace('-->', '');
		this.$(this.templateId).innerHTML = this.template.replace(/\{(.*?)\}/img, function(str, label) {
			var content = '';
			if (label.indexOf('_pic') != -1) {
				var _pic = 1;
				label = label.replace('_pic', 'pic');
			}
			try {
				content = eval('('+label+')') || '';
			} catch (e) {}
			if (_pic) {
				content = content.replace(/[nd]/, '');
			}
			return content;
		});
		if (this.$(this.templateId+'-load')) {
			this.$(this.templateId+'-load').style.display = 'none';
		}
		this.cancel();
	},
	
	load: function(obj) {
		if (obj != 'auto') {
			if (!this.$(obj.templateId)) return;
			this.extend(this, obj);
			obj.cityId = obj.cityId || this.getCookie('cityId') || 0;
		}
		if (obj != 'auto' && obj.cityId) {
			this.get(obj.cityId);
		} else {
			this.loadJs('http://search.hao123.com/weather/bin/forecast.php', function() {
				var remoteId = HaoForecast ? HaoForecast.URL.match(/(\d+)\.shtml/i)[1] : '';
				MZ_weather.loadJs(MZ_weather.weatherUrl + 'Include/Plus/forecast.asp?remoteId=' + remoteId);
			});
		}
	},
	
	get: function(id) {
		MZ_weather.loadJs(this.weatherUrl + 'Public/Data/dy/'+id+'.js');
	},
	
	showSet: function() {
		if (!this.$(this.templateId+'-set')) return;
		this.$(this.templateId).style.display = 'none';
		this.$(this.templateId+'-set').style.display = '';
	},
	
	changeProvince: function(id, areaCityId, countyCityId) {
		var areaCity = this.$('areaCity');
		areaCity.options.length = 1;
		if (id) {
			if (!province[id]) {
				this.loadJs(this.weatherUrl + 'Public/Data/js/p'+id+'.js', function() {
					MZ_weather.changeProvince(id, areaCityId, countyCityId);
				});
			} else {
				this.selectProvince = province[id];
				var i = 0;
				for (var key in province[id]) {
					areaCity.options[i] = new Option(province[id][key][1] + ' ' + province[id][key][0], key);
					if (areaCityId ? key == areaCityId : i == 0) {
						this.changeAreaCity(key, countyCityId);
					}
					i++;
				}
			}
		} else {
			areaCity.options[0] = new Option('选择城市', '');
			this.changeAreaCity('');
		}
	},
	
	changeAreaCity: function(id, countyCityId) {
		var countyCity = this.$('countyCity');
		countyCity.options.length = 1;
		if (id) {
			var i = 0;
			var countyCitys = this.selectProvince[id][2];
			for (var key in countyCitys) {
				countyCity.options[i] = new Option(countyCitys[key][1] + ' ' + countyCitys[key][0], key);
				if (countyCityId ? key == countyCityId : i == 0) {
					this.changeCountyCity(key);
				}
				i++;
			}
		} else {
			this.changeCountyCity();
			countyCity.options[0] = new Option('选择区县', '');
		}
	},
	
	changeCountyCity: function(id) {
		this.selectCity = id || null;
	},
	
	cancel: function() {
		this.$(this.templateId).style.display = '';
		if (this.$(this.templateId+'-set')) {
			this.$(this.templateId+'-set').style.display = 'none';
		}
	},
	
	setCity: function() {
		this.get(this.selectCity);
		this.cancel();
	},
	
	autoSet: function() {
		this.load('auto');
	},
	
	go: function(form) {
		if (!this.selectCity) return false;
		this.jump = 1;
		this.get(this.selectCity);
	}
};