function [Cphit_V] = hwCphit_2D(Cpsit_V,K,L,Lx,Ly,xr,yr,k,l,f,KappaD,Kappas)
%Get Cphit_V from Cpsit_V (2D) (V denotes Vortex part)

Lkt=1./((KappaD^2)/f./(K.^2+L.^2+Kappas^2)./(K.^2+L.^2+KappaD^2));

%Applying the symmeteric expression like the one seen in Salmon's
%textbook. The expression described in the paper should generate the same
%result though, but the computation time will be doubled.
%(Note the factor 2 here)
Cphit_V=1/4*1./(Lkt.^2)*2.*(...
    hwFT2(Lx,Ly,xr,yr,k,l,K.^6.*Cpsit_V,L.^2.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^5.*L.*Cpsit_V,K.*L.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^4.*L.^2.*Cpsit_V,K.^2.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^4.*Cpsit_V,K.^2.*L.^2.*Cpsit_V)...
    +2*hwFT2(Lx,Ly,xr,yr,k,l,K.^4.*L.^2.*Cpsit_V,L.^2.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^4.*Cpsit_V,L.^4.*Cpsit_V)...
    +4*hwFT2(Lx,Ly,xr,yr,k,l,K.^3.*L.*Cpsit_V,K.^3.*L.*Cpsit_V)...
    -4*hwFT2(Lx,Ly,xr,yr,k,l,K.^3.*L.^3.*Cpsit_V,K.*L.*Cpsit_V)...
    +4*hwFT2(Lx,Ly,xr,yr,k,l,K.^3.*L.^1.*Cpsit_V,K.^1.*L.^3.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^2.*Cpsit_V,K.^4.*L.^0.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^0.*Cpsit_V,K.^4.*L.^2.*Cpsit_V)...
    +2*hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^4.*Cpsit_V,K.^2.*L.^0.*Cpsit_V)...
    -4*hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^2.*Cpsit_V,K.^2.*L.^2.*Cpsit_V)...
    +2*hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^0.*Cpsit_V,K.^2.*L.^4.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^4.*Cpsit_V,K.^0.*L.^2.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^2.*Cpsit_V,K.^0.*L.^4.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^2.*L.^0.*Cpsit_V,K.^0.*L.^6.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^1.*Cpsit_V,K.^5.*L.^1.*Cpsit_V)...
    +4*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^3.*Cpsit_V,K.^3.*L.^1.*Cpsit_V)...
    -4*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^1.*Cpsit_V,K.^3.*L.^3.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^5.*Cpsit_V,K.^1.*L.^1.*Cpsit_V)...
    +4*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^3.*Cpsit_V,K.^1.*L.^3.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^1.*L.^1.*Cpsit_V,K.^1.*L.^5.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^2.*Cpsit_V,K.^6.*L.^0.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^4.*Cpsit_V,K.^4.*L.^0.*Cpsit_V)...
    +2*hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^2.*Cpsit_V,K.^4.*L.^2.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^6.*Cpsit_V,K.^2.*L.^0.*Cpsit_V)...
    -2*hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^4.*Cpsit_V,K.^2.*L.^2.*Cpsit_V)...
    +hwFT2(Lx,Ly,xr,yr,k,l,K.^0.*L.^2.*Cpsit_V,K.^2.*L.^4.*Cpsit_V));
end

