Unit fscrypt;

{
by Franco Milani (franco@intercity.it). Rev. 3.2 (9 Aug 98).

Source released under the terms of the GNU General Public License
as published by the Free Software Foundation.

This very fast unit encrypts a password in passwd format. The routines
are optimized for speed. Further improvements can be made by using
assembler.

Parameters:
pas: the password (if length(pas)<8 join #0 characters up the length 8);
slt: the salt (two characters);
out: the crypted password (13 characters).

the result is a string of 13 bytes:
two first bytes of the salt, followed by 11 bytes from the set
[./0-9A-Za-z],

}

INTERFACE
uses hyperStr;

Function Crypt(password : string; salt : string = '') : string;
procedure vcrypt(pas: string; slt: string; var out: string);

IMPLEMENTATION

{$R-}
Function Crypt(password : string; salt : string = '') : string;
var
 i:integer;
 t : String;
begin
 if Length(password)=0 then
 begin
  Result:='';
  Exit;
 end;
 password:=copy(password,1,8);
 while length(password)<8 do
  password:=password+#0;

 if length(salt)>=2 then
  salt:=copy(salt,1,2)
 else
  begin
   t:=BuildTable('./0-9A-Za-z');
   salt:=RandomText(2,t);
  end;

 setlength(Result,13);
 VCrypt(password,salt,Result);
end;

Type

vec32 = array [0..31] of longint;
vec64 = array [0..63] of longint;

long = record
case byte of
0 : (l0,l1 : longint);
1 : (c : array [0..7] of byte);
end;

CONST

S0L : vec64 =
(537010176, 536870912,         0, 537010176,         0, 537010176, 536870912,
         0, 537010176, 537010176, 536870912,    139264,    139264,         0,
         0, 536870912, 536870912,         0,    139264, 537010176, 537010176,
 536870912,    139264,    139264,         0,    139264, 537010176, 536870912,
    139264,    139264, 536870912,         0,         0, 537010176,    139264,
 536870912, 537010176, 536870912,    139264,    139264, 536870912,    139264,
 537010176,         0, 537010176,         0,         0, 536870912, 537010176,
 537010176, 536870912,    139264,         0,    139264, 536870912,         0,
 536870912,         0,    139264, 537010176,         0, 536870912,    139264,
 537010176);
S1L : vec64 =
( 35651588,         0,  35651584,         0,         4,  35651588,  35651584,
  35651584,  35651584,         4,         4,  35651584,         4,  35651584,
         0,         4,         0,  35651588,         4,  35651584,  35651588,
         0,         0,         4,  35651588,  35651588,  35651584,         4,
         0,         0,  35651588,  35651588,         4,  35651584,  35651584,
  35651588,  35651588,         4,         4,         0,         0,  35651588,
         0,         4,  35651584,         0,  35651588,  35651588,  35651584,
  35651584,         0,         4,         4,  35651588,  35651584,         0,
         4,         0,  35651588,  35651584,  35651588,         4,         0,
  35651584);
S2L : vec64 =
(        0, 268436480,      1024,      1024, 268435456,         0,      1024,
 268436480,      1024, 268435456, 268435456,         0, 268436480,      1024,
         0, 268435456,         0, 268435456, 268436480,      1024,      1024,
 268436480, 268435456,         0, 268435456,      1024, 268436480, 268435456,
 268436480,         0,         0, 268436480, 268436480,      1024,         0,
 268435456,      1024, 268435456, 268435456,      1024,         0, 268436480,
 268436480, 268435456, 268435456,         0, 268436480,         0, 268436480,
         0,         0, 268436480, 268435456,      1024,      1024, 268436480,
      1024,         0, 268435456,      1024,         0, 268436480,      1024,
 268435456);
S3L : vec64 =
(   262146,    262144,         2,    262146,         0,         0,    262146,
         2,    262144,         2,         0,    262146,         2,    262146,
         0,         0,         2,    262144,    262144,         2,    262144,
    262146,         0,    262144,    262146,         0,         2,    262144,
    262144,         2,    262146,         0,         2,    262146,         0,
         2,    262144,    262144,         2,         0,    262146,         0,
    262144,         2,         0,         2,    262144,    262144,         0,
    262146,    262146,         0,    262146,         2,    262144,    262146,
         2,    262144,         0,    262146,    262146,         0,         2,
    262144);
S4L : vec64 =
(        0,  67108864,     69632,  67178504,  67108872,     69632,  67178504,
  67108864,  67108864,         8,         8,  67178496,     69640,  67108872,
  67178496,         0,  67178496,         0,  67108872,     69640,     69632,
  67178504,         0,         8,         8,     69640,  67178504,  67108872,
  67108864,     69632,     69640,  67178496,  67178496,     69640,  67108872,
  67108864,  67108864,         8,         8,     69632,         0,  67178496,
  67178504,         0,  67178504,         0,     69632,  67108872,     69640,
     69632,         0,  67178504,  67108872,  67178496,     69640,  67108864,
  67178496,  67108872,     69632,     69640,         8,  67178504,  67108864,
         8);
S5L : vec64 =
(      272,       272,         0,    524288,       272,    524288,    524560,
         0,    524560,    524560,    524288,         0,    524288,       272,
         0,    524560,         0,    524560,       272,         0,    524288,
       272,    524288,       272,    524560,         0,         0,    524560,
       272,    524288,    524560,    524288,    524560,         0,    524288,
    524560,    524288,       272,         0,    524288,         0,    524288,
       272,         0,       272,    524560,    524288,       272,    524560,
    524288,         0,    524560,       272,         0,    524560,         0,
    524288,       272,    524560,    524288,         0,    524560,       272,
       272);
S6L : vec64 =
( 17825792,      2048,      2048,         1,  17827841,  17825793,  17827840,
         0,         0,      2049,      2049,  17825792,         1,  17827840,
  17825792,      2049,      2049,  17825792,  17825793,  17827841,         0,
      2048,         1,  17827840,  17825793,  17827841,  17827840,         1,
  17827841,  17825793,      2048,         0,  17827841,  17825792,  17825793,
      2049,  17825792,      2048,         0,  17825793,      2049,  17827841,
  17827840,         0,      2048,         1,         1,      2048,         0,
      2049,      2048,  17827840,      2049,  17825792,  17827841,         0,
  17827840,         1,  17825793,  17827841,         1,  17827840,  17825792,
  17825793);
S7L : vec64 =
(      544, 134217728, 134218272,         0, 134217728,       544,         0,
 134218272,       544,         0, 134217728, 134218272, 134218272, 134218272,
       544,         0, 134217728, 134218272,       544, 134217728, 134218272,
       544,         0, 134217728,         0,         0, 134218272,       544,
         0, 134217728, 134217728,       544,         0, 134217728,       544,
 134218272, 134218272,         0,         0, 134217728,       544, 134218272,
 134217728,       544, 134217728,       544,       544, 134217728, 134218272,
         0,         0,       544, 134217728, 134218272, 134218272,         0,
       544, 134217728, 134218272,         0,         0,       544, 134217728,
 134218272);
S0H : vec64 =
(     2050,         2, 134219776, 134219778,      2048, 134217730, 134217730,
 134219776, 134217730,      2050,      2050, 134217728, 134219776,      2048,
         0, 134217730,         2, 134217728,      2048,         2, 134219778,
      2050, 134217728,      2048, 134217728,         0,         2, 134219778,
         0, 134219776, 134219778,         0,         0, 134219778,      2048,
 134217730,      2050,         2, 134217728,      2048, 134219778,         0,
         2, 134219776, 134217730, 134217728, 134219776,      2050, 134219778,
         2,      2050, 134219776,      2048, 134217728, 134217730,         0,
         2,      2048, 134219776,      2050, 134217728, 134219778,         0,
 134217730);
S1H : vec64 =
( 17825796,         0,         4,  17825796,  17825792,         0,  17825792,
         4,         0,  17825796,         0,  17825792,         4,  17825796,
  17825796,         0,         4,  17825792,  17825796,         0,         4,
  17825792,         0,         4,  17825792,         4,  17825796,  17825792,
  17825792,         4,         0,  17825796,         4,  17825796,  17825792,
         4,  17825796,         4,  17825792,         0,  17825792,         0,
         4,  17825796,         0,  17825792,         4,  17825792,  17825796,
         0,         0,  17825792,         0,  17825796,         4,  17825796,
  17825796,         4,         0,  17825792,  17825792,         0,  17825796,
         4);
S2H : vec64 =
( 67178496,     69633,         0,  67178496,  67108865,     69632,  67178496,
         1,     69632,         1,     69633,  67108864,  67178497,  67108864,
  67108864,  67178497,         0,  67108865,     69633,         0,  67108864,
  67178497,         1,  67178496,  67178497,     69632,  67108865,     69633,
         1,         0,     69632,  67108865,     69633,         0,  67108864,
         1,  67108864,  67108865,     69633,  67178496,         0,     69633,
         1,  67178497,  67108865,     69632,  67178497,  67108864,  67108865,
  67178496,     69632,  67178497,         1,     69632,  67178496,         1,
     69632,         0,  67178497,  67108864,  67178496,  67108865,         0,
     69633);
S3H : vec64 =
(536871184,    262144, 536870912, 537133328,         0,    262416, 537133056,
 536871184,    262416, 537133056,    262144, 536870912, 537133056, 536871184,
       272,    262144, 537133328,       272,         0, 536870912,       272,
 537133056,    262416,         0, 536870912,         0, 536871184,    262416,
    262144, 537133328, 537133328,       272, 537133328, 536870912,       272,
 537133056,       272,    262144, 536870912,    262416, 537133056,         0,
         0, 536871184,         0, 537133328,    262416,         0,    262144,
 537133328, 536871184,       272, 537133328, 536870912,    262144, 536871184,
 536871184,       272,    262416, 537133056, 536870912,    262144, 537133056,
    262416);
S4H : vec64 =
(   139264,         0,         0,    139264,    139264,    139264,         0,
    139264,         0,         0,    139264,         0,    139264,    139264,
    139264,         0,         0,    139264,         0,         0,    139264,
         0,         0,    139264,         0,    139264,    139264,         0,
    139264,         0,         0,    139264,    139264,    139264,         0,
    139264,         0,         0,    139264,    139264,    139264,         0,
    139264,         0,         0,    139264,         0,         0,    139264,
         0,         0,    139264,    139264,    139264,         0,         0,
         0,    139264,    139264,         0,         0,         0,    139264,
    139264);
S5H : vec64 =
( 35651584,         8,         0,  35651592,         8,         0,  35651584,
         8,         0,  35651592,         8,  35651584,  35651584,  35651584,
  35651592,         8,         8,  35651584,  35651592,         0,         0,
         0,  35651592,  35651592,  35651592,  35651592,  35651584,         0,
         0,         8,         8,  35651584,         0,  35651584,  35651584,
         8,  35651592,         8,         0,  35651584,  35651584,         0,
  35651592,         8,         8,  35651592,         8,         0,  35651592,
         8,         8,  35651584,  35651584,  35651592,         8,         0,
         0,  35651584,  35651584,  35651592,  35651592,         0,         0,
  35651592);
S6H : vec64 =
(        0,         0,      1024, 268436480, 268436480, 268435456,         0,
         0,      1024, 268436480, 268435456,      1024, 268435456,      1024,
      1024, 268435456, 268436480,         0, 268435456, 268436480,         0,
      1024, 268436480,         0, 268436480, 268435456,      1024, 268435456,
 268435456, 268436480,         0,      1024, 268435456,      1024, 268436480,
 268435456,         0,         0,      1024, 268436480, 268436480, 268435456,
         0,         0,         0, 268436480, 268435456,      1024,         0,
 268436480,      1024,         0, 268435456,         0, 268436480,      1024,
      1024, 268435456, 268435456, 268436480, 268436480,      1024,      1024,
 268435456);
S7H : vec64 =
(   524832,    524832,         0,         0,    524288,       544,    524832,
    524832,         0,    524288,       544,         0,       544,    524288,
    524288,    524832,         0,       544,       544,    524288,    524832,
    524288,         0,       544,    524288,       544,    524288,    524832,
       544,         0,    524832,         0,       544,         0,    524288,
    524832,         0,    524288,         0,       544,    524832,    524288,
    524288,       544,    524832,         0,       544,    524288,    524832,
       544,    524832,    524288,       544,         0,    524288,    524832,
         0,    524832,       544,         0,    524288,    524832,         0,
       544);

{* Salts conversion tables *}

salt0 : array [0..255] of word=
(     18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
      34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
      50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,  0,  1,
       2,  3,  4,  5,  6,  7,  8,  9, 10, 11,  5,  6,  7,  8,  9, 10,
      11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
      27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 32, 33, 34, 35, 36,
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
      53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,  0,  1,  2,  3,  4,
       5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
      53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,  0,  1,  2,  3,  4,
       5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
      53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,  0,  1,  2,  3,  4);

salt1 : array [0..255] of word =
(  4608, 4864, 5120, 5376, 5632, 5888, 6144, 6400, 6656, 6912, 7168, 7424,
   7680, 7936, 8192, 8448, 8704, 8960, 9216, 9472, 9728, 9984,10240,10496,
  10752,11008,11264,11520,11776,12032,12288,12544,12800,13056,13312,13568,
  13824,14080,14336,14592,14848,15104,15360,15616,15872,16128,    0,  256,
    512,  768, 1024, 1280, 1536, 1792, 2048, 2304, 2560, 2816, 1280, 1536,
   1792, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 3840, 4096, 4352, 4608,
   4864, 5120, 5376, 5632, 5888, 6144, 6400, 6656, 6912, 7168, 7424, 7680,
   7936, 8192, 8448, 8704, 8960, 9216, 9472, 8192, 8448, 8704, 8960, 9216,
   9472, 9728, 9984,10240,10496,10752,11008,11264,11520,11776,12032,12288,
  12544,12800,13056,13312,13568,13824,14080,14336,14592,14848,15104,15360,
  15616,15872,16128,    0,  256,  512,  768, 1024, 1280, 1536, 1792, 2048,
   2304, 2560, 2816, 3072, 3328, 3584, 3840, 4096, 4352, 4608, 4864, 5120,
   5376, 5632, 5888, 6144, 6400, 6656, 6912, 7168, 7424, 7680, 7936, 8192,
   8448, 8704, 8960, 9216, 9472, 9728, 9984,10240,10496,10752,11008,11264,
  11520,11776,12032,12288,12544,12800,13056,13312,13568,13824,14080,14336,
  14592,14848,15104,15360,15616,15872,16128,    0,  256,  512,  768, 1024,
   1280, 1536, 1792, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 3840, 4096,
   4352, 4608, 4864, 5120, 5376, 5632, 5888, 6144, 6400, 6656, 6912, 7168,
   7424, 7680, 7936, 8192, 8448, 8704, 8960, 9216, 9472, 9728, 9984,10240,
  10496,10752,11008,11264,11520,11776,12032,12288,12544,12800,13056,13312,
  13568,13824,14080,14336,14592,14848,15104,15360,15616,15872,16128,    0,
    256,  512,  768, 1024);

final : array [0..255] of char =
(#46, #47, #48, #49, #50, #51, #52, #53, #54, #55, #56, #57, #65, #66, #67,
 #68, #69, #70, #71, #72, #73, #74, #75, #76, #77, #78, #79, #80, #81, #82,
 #83, #84, #85, #86, #87, #88, #89, #90, #97, #98, #99,#100,#101,#102,#103,
#104,#105,#106,#107,#108,#109,#110,#111,#112,#113,#114,#115,#116,#117,#118,
#119,#120,#121,#122,#123,#124,#125,#126,#127,#128,#129,#130,#131,#132,#133,
#134,#135,#136,#137,#138,#139,#140,#141,#142,#143,#144,#145,#146,#147,#148,
#149,#150,#151,#152,#153,#154,#155,#156,#157,#158,#159,#160,#161,#162,#163,
#164,#165,#166,#167,#168,#169,#170,#171,#172,#173,#174,#175,#176,#177,#178,
#179,#180,#181,#182,#183,#184,#185,#186,#187,#188,#189,#190,#191,#192,#193,
#194,#195,#196,#197,#198,#199,#200,#201,#202,#203,#204,#205,#206,#207,#208,
#209,#210,#211,#212,#213,#214,#215,#216,#217,#218,#219,#220,#221,#222,#223,
#224,#225,#226,#227,#228,#229,#230,#231,#232,#233,#234,#235,#236,#237,#238,
#239,#240,#241,#242,#243,#244,#245,#246,#247,#248,#249,#250,#251,#252,#253,
#254,#255,  #0,  #1,  #2,  #3,  #4,  #5,  #6,  #7,  #8,  #9, #10, #11, #12,
 #13, #14, #15, #16, #17, #18, #19, #20, #21, #22, #23, #24, #25, #26, #27,
 #28, #29, #30, #31, #32, #33, #34, #35, #36, #37, #38, #39, #40, #41, #42,
 #43, #44, #45, #46, #47, #48, #49, #50, #51, #52, #53, #54, #55, #56, #57,
 #58);

KN : vec32 =
    (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

VAR

K : vec32;
d : long;
saltvalue : longint;
u : byte;
Rl,Rh,Ll,Lh : longint;
v : longint;
b : array[0..7] of byte;

procedure vcrypt(pas: string; slt: string; var out: string);
begin
saltvalue:=salt0[ord(slt[1])] or salt1[ord(slt[2])];
{* from the password evaluates the array K *}
K:=KN;
u:=ord(pas[1]);
if odd(u shr 6) then begin
inc(K[0],33554432);   inc(K[2],2048);       inc(K[4],524288);
inc(K[6],536870912);  inc(K[8],512);        inc(K[10],1048576);
inc(K[12],8);         inc(K[16],4096);      inc(K[18],131072);
inc(K[20],2);         inc(K[22],1024);      inc(K[24],268435456);
inc(K[26],4);         inc(K[30],2097152);
end;
if odd(u shr 5) then begin
inc(K[0],1024);       inc(K[2],1);          inc(K[4],262144);
inc(K[6],8192);       inc(K[8],2097152);    inc(K[10],2048);
inc(K[12],524288);    inc(K[14],536870912); inc(K[16],16);
inc(K[18],67108864);  inc(K[22],65536);     inc(K[24],4096);
inc(K[26],131072);    inc(K[28],2);         inc(K[30],16777216);
end;
if odd(u shr 4) then begin
inc(K[0],65536);      inc(K[4],134217728);  inc(K[8],16777216);
inc(K[10],1);         inc(K[12],262144);    inc(K[14],8192);
inc(K[18],33554432);  inc(K[20],32);        inc(K[22],256);
inc(K[24],16);        inc(K[26],67108864);  inc(K[30],8);
end;
if odd(u shr 3) then begin
inc(K[1],32);         inc(K[5],2);          inc(K[7],67108864);
inc(K[9],8192);       inc(K[11],16777216);  inc(K[13],65536);
inc(K[15],33554432);  inc(K[17],1);         inc(K[19],262144);
inc(K[21],8);         inc(K[25],4096);      inc(K[27],4);
inc(K[29],268435456); inc(K[31],524288);
end;
if odd(u shr 2) then begin
inc(K[1],1024);       inc(K[3],67108864);   inc(K[5],8192);
inc(K[7],16777216);   inc(K[9],65536);      inc(K[11],33554432);
inc(K[13],512);       inc(K[17],8);         inc(K[21],4096);
inc(K[23],4);         inc(K[25],268435456); inc(K[27],32);
inc(K[29],2097152);   inc(K[31],2);
end;
if odd(u shr 1) then begin
inc(K[3],33554432);   inc(K[5],512);        inc(K[9],134217728);
inc(K[11],1048576);   inc(K[13],536870912); inc(K[15],256);
inc(K[17],268435456); inc(K[19],32);        inc(K[21],2097152);
inc(K[23],1024);      inc(K[25],131072);    inc(K[27],16);
inc(K[29],2048);      inc(K[31],65536);
end;
if odd(u) then begin
inc(K[3],1048576);    inc(K[5],536870912);  inc(K[7],256);
inc(K[9],524288);     inc(K[13],2);         inc(K[15],67108864);
inc(K[17],131072);    inc(K[19],16);        inc(K[21],2048);
inc(K[25],1);         inc(K[27],262144);    inc(K[29],8);
inc(K[31],134217728);
end;
u:=ord(pas[2]);
if odd(u shr 6) then begin
inc(K[0],2048);       inc(K[2],32);         inc(K[4],256);
inc(K[6],16);         inc(K[8],67108864);   inc(K[12],65536);
inc(K[14],4096);      inc(K[16],134217728); inc(K[20],16777216);
inc(K[22],1);         inc(K[24],262144);    inc(K[26],8192);
inc(K[28],2097152);   inc(K[30],33554432);
end;
if odd(u shr 5) then begin
inc(K[0],1);          inc(K[2],268435456);  inc(K[4],4);
inc(K[8],33554432);   inc(K[10],32);        inc(K[12],256);
inc(K[14],16);        inc(K[16],512);       inc(K[18],1048576);
inc(K[20],8);         inc(K[24],134217728); inc(K[28],16777216);
inc(K[30],1024);
end;
if odd(u shr 4) then begin
inc(K[2],4096);       inc(K[4],131072);     inc(K[6],2);
inc(K[8],1024);       inc(K[10],268435456); inc(K[12],4);
inc(K[16],2097152);   inc(K[18],2048);      inc(K[20],524288);
inc(K[22],536870912); inc(K[24],512);       inc(K[26],1048576);
inc(K[28],8);         inc(K[30],65536);
end;
if odd(u shr 3) then begin
inc(K[3],2097152);    inc(K[5],1024);       inc(K[7],131072);
inc(K[9],16);         inc(K[11],2048);      inc(K[15],1);
inc(K[17],512);       inc(K[21],134217728); inc(K[23],1048576);
inc(K[25],536870912); inc(K[27],256);       inc(K[29],524288);
inc(K[31],32);
end;
if odd(u shr 2) then begin
inc(K[1],67108864);   inc(K[3],131072);     inc(K[5],16);
inc(K[7],2048);       inc(K[11],1);         inc(K[13],262144);
inc(K[15],8);         inc(K[17],134217728); inc(K[19],1048576);
inc(K[21],536870912); inc(K[23],256);       inc(K[25],524288);
inc(K[29],2);         inc(K[31],1024);
end;
if odd(u shr 1) then begin
inc(K[1],33554432);   inc(K[3],1);          inc(K[5],262144);
inc(K[7],8);          inc(K[11],4096);      inc(K[13],4);
inc(K[15],268435456); inc(K[17],524288);    inc(K[21],2);
inc(K[23],67108864);  inc(K[25],8192);      inc(K[27],16777216);
inc(K[29],65536);
end;
if odd(u) then begin
inc(K[1],1048576);    inc(K[3],4096);       inc(K[5],4);
inc(K[7],268435456);  inc(K[9],32);         inc(K[11],2097152);
inc(K[13],1024);      inc(K[15],131072);    inc(K[17],8192);
inc(K[19],16777216);  inc(K[21],65536);     inc(K[23],33554432);
inc(K[25],512);       inc(K[29],134217728);
end;
u:=ord(pas[3]);
if odd(u shr 6) then begin
inc(K[0],32);         inc(K[2],524288);     inc(K[4],536870912);
inc(K[6],512);        inc(K[8],1048576);    inc(K[10],8);
inc(K[14],134217728); inc(K[16],131072);    inc(K[18],2);
inc(K[20],1024);      inc(K[22],268435456); inc(K[24],4);
inc(K[28],33554432);  inc(K[30],2048);
end;
if odd(u shr 5) then begin
inc(K[0],268435456);  inc(K[2],262144);     inc(K[4],8192);
inc(K[6],2097152);    inc(K[8],2048);       inc(K[10],524288);
inc(K[12],536870912); inc(K[14],512);       inc(K[16],67108864);
inc(K[20],65536);     inc(K[22],4096);      inc(K[24],131072);
inc(K[26],2);         inc(K[28],1024);      inc(K[30],1);
end;
if odd(u shr 4) then begin
inc(K[0],4096);       inc(K[2],134217728);  inc(K[6],16777216);
inc(K[8],1);          inc(K[10],262144);    inc(K[12],8192);
inc(K[14],2097152);   inc(K[16],33554432);  inc(K[18],32);
inc(K[20],256);       inc(K[22],16);        inc(K[24],67108864);
inc(K[28],65536);
end;
if odd(u shr 3) then begin
inc(K[1],2097152);    inc(K[3],2);          inc(K[5],67108864);
inc(K[7],8192);       inc(K[9],16777216);   inc(K[11],65536);
inc(K[13],33554432);  inc(K[15],512);       inc(K[17],262144);
inc(K[19],8);         inc(K[23],4096);      inc(K[25],4);
inc(K[27],268435456); inc(K[29],32);
end;
if odd(u shr 2) then begin
inc(K[1],131072);     inc(K[3],8192);       inc(K[5],16777216);
inc(K[7],65536);      inc(K[9],33554432);   inc(K[11],512);
inc(K[15],134217728); inc(K[19],4096);      inc(K[21],4);
inc(K[23],268435456); inc(K[25],32);        inc(K[27],2097152);
inc(K[29],1024);      inc(K[31],67108864);
end;
if odd(u shr 1) then begin
inc(K[1],1);          inc(K[3],512);        inc(K[7],134217728);
inc(K[9],1048576);    inc(K[11],536870912); inc(K[13],256);
inc(K[15],524288);    inc(K[17],32);        inc(K[19],2097152);
inc(K[21],1024);      inc(K[23],131072);    inc(K[25],16);
inc(K[27],2048);      inc(K[31],33554432);
end;
if odd(u) then begin
inc(K[1],4096);       inc(K[3],536870912);  inc(K[5],256);
inc(K[7],524288);     inc(K[11],2);         inc(K[13],67108864);
inc(K[15],8192);      inc(K[17],16);        inc(K[19],2048);
inc(K[23],1);         inc(K[25],262144);    inc(K[27],8);
inc(K[31],1048576);
end;
u:=ord(pas[4]);
if odd(u shr 6) then begin
inc(K[0],524288);     inc(K[2],256);        inc(K[4],16);
inc(K[6],67108864);   inc(K[10],65536);     inc(K[12],4096);
inc(K[14],131072);    inc(K[18],16777216);  inc(K[20],1);
inc(K[22],262144);    inc(K[24],8192);      inc(K[26],2097152);
inc(K[28],2048);      inc(K[30],32);
end;
if odd(u shr 5) then begin
inc(K[0],262144);     inc(K[2],4);          inc(K[6],33554432);
inc(K[8],32);         inc(K[10],256);       inc(K[12],16);
inc(K[14],67108864);  inc(K[16],1048576);   inc(K[18],8);
inc(K[22],134217728); inc(K[26],16777216);  inc(K[28],1);
inc(K[30],268435456);
end;
if odd(u shr 4) then begin
inc(K[0],134217728);  inc(K[2],131072);     inc(K[4],2);
inc(K[6],1024);       inc(K[8],268435456);  inc(K[10],4);
inc(K[14],33554432);  inc(K[16],2048);      inc(K[18],524288);
inc(K[20],536870912); inc(K[22],512);       inc(K[24],1048576);
inc(K[26],8);         inc(K[30],4096);
end;
if odd(u shr 3) then begin
inc(K[1],2);          inc(K[3],1024);       inc(K[5],131072);
inc(K[7],16);         inc(K[9],2048);       inc(K[13],1);
inc(K[15],262144);    inc(K[19],134217728); inc(K[21],1048576);
inc(K[23],536870912); inc(K[25],256);       inc(K[27],524288);
inc(K[31],2097152);
end;
if odd(u shr 2) then begin
inc(K[1],8192);       inc(K[3],16);         inc(K[5],2048);
inc(K[9],1);          inc(K[11],262144);    inc(K[13],8);
inc(K[17],1048576);   inc(K[19],536870912); inc(K[21],256);
inc(K[23],524288);    inc(K[27],2);         inc(K[29],67108864);
inc(K[31],131072);
end;
if odd(u shr 1) then begin
inc(K[1],512);        inc(K[3],262144);     inc(K[5],8);
inc(K[9],4096);       inc(K[11],4);         inc(K[13],268435456);
inc(K[15],32);        inc(K[19],2);         inc(K[21],67108864);
inc(K[23],8192);      inc(K[25],16777216);  inc(K[27],65536);
inc(K[29],33554432);  inc(K[31],1);
end;
if odd(u) then begin
inc(K[1],536870912);  inc(K[3],4);          inc(K[5],268435456);
inc(K[7],32);         inc(K[9],2097152);    inc(K[11],1024);
inc(K[13],131072);    inc(K[15],16);        inc(K[17],16777216);
inc(K[19],65536);     inc(K[21],33554432);  inc(K[23],512);
inc(K[27],134217728); inc(K[29],1048576);   inc(K[31],4096);
end;
u:=ord(pas[5]);
if odd(u shr 6) then begin
inc(K[0],256);        inc(K[2],536870912);  inc(K[4],512);
inc(K[6],1048576);    inc(K[8],8);          inc(K[12],134217728);
inc(K[16],2);         inc(K[18],1024);      inc(K[20],268435456);
inc(K[22],4);         inc(K[26],33554432);  inc(K[28],32);
inc(K[30],524288);
end;
if odd(u shr 5) then begin
inc(K[0],4);          inc(K[2],8192);       inc(K[4],2097152);
inc(K[6],2048);       inc(K[8],524288);     inc(K[10],536870912);
inc(K[12],512);       inc(K[14],1048576);   inc(K[18],65536);
inc(K[20],4096);      inc(K[22],131072);    inc(K[24],2);
inc(K[26],1024);      inc(K[28],268435456); inc(K[30],262144);
end;
if odd(u shr 4) then begin
inc(K[0],131072);     inc(K[4],16777216);   inc(K[6],1);
inc(K[8],262144);     inc(K[10],8192);      inc(K[12],2097152);
inc(K[14],2048);      inc(K[16],32);        inc(K[18],256);
inc(K[20],16);        inc(K[22],67108864);  inc(K[26],65536);
inc(K[28],4096);      inc(K[30],134217728);
end;
if odd(u shr 3) then begin
inc(K[0],67108864);   inc(K[2],1048576);    inc(K[4],8);
inc(K[8],134217728);  inc(K[12],16777216);  inc(K[14],1);
inc(K[16],268435456); inc(K[18],4);         inc(K[22],33554432);
inc(K[24],32);        inc(K[26],256);       inc(K[28],16);
inc(K[30],512);
end;
if odd(u shr 2) then begin
inc(K[1],16);         inc(K[3],16777216);   inc(K[5],65536);
inc(K[7],33554432);   inc(K[9],512);        inc(K[13],134217728);
inc(K[15],1048576);   inc(K[17],4096);      inc(K[19],4);
inc(K[21],268435456); inc(K[23],32);        inc(K[25],2097152);
inc(K[27],1024);      inc(K[29],131072);    inc(K[31],8192);
end;
if odd(u shr 1) then begin
inc(K[1],262144);     inc(K[5],134217728);  inc(K[7],1048576);
inc(K[9],536870912);  inc(K[11],256);       inc(K[13],524288);
inc(K[17],2097152);   inc(K[19],1024);      inc(K[21],131072);
inc(K[23],16);        inc(K[25],2048);      inc(K[29],1);
inc(K[31],512);
end;
if odd(u) then begin
inc(K[1],4);          inc(K[3],256);        inc(K[5],524288);
inc(K[9],2);          inc(K[11],67108864);  inc(K[13],8192);
inc(K[15],16777216);  inc(K[17],2048);      inc(K[21],1);
inc(K[23],262144);    inc(K[25],8);         inc(K[29],4096);
inc(K[31],536870912);
end;
u:=ord(pas[6]);
if odd(u shr 6) then begin
inc(K[0],536870912);  inc(K[2],16);         inc(K[4],67108864);
inc(K[8],65536);      inc(K[10],4096);      inc(K[12],131072);
inc(K[14],2);         inc(K[16],16777216);  inc(K[18],1);
inc(K[20],262144);    inc(K[22],8192);      inc(K[24],2097152);
inc(K[26],2048);      inc(K[28],524288);    inc(K[30],256);
end;
if odd(u shr 5) then begin
inc(K[0],8192);       inc(K[4],33554432);   inc(K[6],32);
inc(K[8],256);        inc(K[10],16);        inc(K[12],67108864);
inc(K[16],8);         inc(K[20],134217728); inc(K[24],16777216);
inc(K[26],1);         inc(K[28],262144);    inc(K[30],4);
end;
if odd(u shr 4) then begin
inc(K[2],2);          inc(K[4],1024);       inc(K[6],268435456);
inc(K[8],4);          inc(K[12],33554432);  inc(K[14],32);
inc(K[16],524288);    inc(K[18],536870912); inc(K[20],512);
inc(K[22],1048576);   inc(K[24],8);         inc(K[28],134217728);
inc(K[30],131072);
end;
if odd(u shr 3) then begin
inc(K[0],1048576);    inc(K[4],65536);      inc(K[6],4096);
inc(K[8],131072);     inc(K[10],2);         inc(K[12],1024);
inc(K[14],268435456); inc(K[16],262144);    inc(K[18],8192);
inc(K[20],2097152);   inc(K[22],2048);      inc(K[24],524288);
inc(K[26],536870912); inc(K[28],512);       inc(K[30],67108864);
end;
if odd(u shr 2) then begin
inc(K[1],16777216);   inc(K[3],2048);       inc(K[7],1);
inc(K[9],262144);     inc(K[11],8);         inc(K[15],4096);
inc(K[17],536870912); inc(K[19],256);       inc(K[21],524288);
inc(K[25],2);         inc(K[27],67108864);  inc(K[29],8192);
inc(K[31],16);
end;
if odd(u shr 1) then begin
inc(K[3],8);          inc(K[7],4096);       inc(K[9],4);
inc(K[11],268435456); inc(K[13],32);        inc(K[15],2097152);
inc(K[17],2);         inc(K[19],67108864);  inc(K[21],8192);
inc(K[23],16777216);  inc(K[25],65536);     inc(K[27],33554432);
inc(K[29],512);       inc(K[31],262144);
end;
if odd(u) then begin
inc(K[1],256);        inc(K[3],268435456);  inc(K[5],32);
inc(K[7],2097152);    inc(K[9],1024);       inc(K[11],131072);
inc(K[13],16);        inc(K[15],2048);      inc(K[17],65536);
inc(K[19],33554432);  inc(K[21],512);       inc(K[25],134217728);
inc(K[27],1048576);   inc(K[29],536870912); inc(K[31],4);
end;
u:=ord(pas[7]);
if odd(u shr 6) then begin
inc(K[0],16);         inc(K[2],512);        inc(K[4],1048576);
inc(K[6],8);          inc(K[10],134217728); inc(K[14],16777216);
inc(K[16],1024);      inc(K[18],268435456); inc(K[20],4);
inc(K[24],33554432);  inc(K[26],32);        inc(K[28],256);
inc(K[30],536870912);
end;
if odd(u shr 5) then begin
inc(K[2],2097152);    inc(K[4],2048);       inc(K[6],524288);
inc(K[8],536870912);  inc(K[10],512);       inc(K[12],1048576);
inc(K[14],8);         inc(K[16],65536);     inc(K[18],4096);
inc(K[20],131072);    inc(K[22],2);         inc(K[24],1024);
inc(K[26],268435456); inc(K[28],4);         inc(K[30],8192);
end;
if odd(u shr 4) then begin
inc(K[0],2);          inc(K[2],16777216);   inc(K[4],1);
inc(K[6],262144);     inc(K[8],8192);       inc(K[10],2097152);
inc(K[12],2048);      inc(K[14],524288);    inc(K[16],256);
inc(K[18],16);        inc(K[20],67108864);  inc(K[24],65536);
inc(K[26],4096);      inc(K[28],131072);
end;
if odd(u shr 3) then begin
inc(K[2],8);          inc(K[6],134217728);  inc(K[10],16777216);
inc(K[12],1);         inc(K[14],262144);    inc(K[16],4);
inc(K[20],33554432);  inc(K[22],32);        inc(K[24],256);
inc(K[26],16);        inc(K[28],67108864);  inc(K[30],1048576);
end;
if odd(u shr 2) then begin
inc(K[1],2048);       inc(K[3],65536);      inc(K[5],33554432);
inc(K[7],512);        inc(K[11],134217728); inc(K[13],1048576);
inc(K[15],536870912); inc(K[17],4);         inc(K[19],268435456);
inc(K[21],32);        inc(K[23],2097152);   inc(K[25],1024);
inc(K[27],131072);    inc(K[29],16);        inc(K[31],16777216);
end;
if odd(u shr 1) then begin
inc(K[1],8);          inc(K[3],134217728);  inc(K[5],1048576);
inc(K[7],536870912);  inc(K[9],256);        inc(K[11],524288);
inc(K[15],2);         inc(K[17],1024);      inc(K[19],131072);
inc(K[21],16);        inc(K[23],2048);      inc(K[27],1);
inc(K[29],262144);
end;
if odd(u) then begin
inc(K[1],268435456);  inc(K[3],524288);     inc(K[7],2);
inc(K[9],67108864);   inc(K[11],8192);      inc(K[13],16777216);
inc(K[15],65536);     inc(K[19],1);         inc(K[21],262144);
inc(K[23],8);         inc(K[27],4096);      inc(K[29],4);
inc(K[31],256);
end;
u:=ord(pas[8]);
if odd(u shr 6) then begin
inc(K[0],512);        inc(K[2],67108864);   inc(K[6],65536);
inc(K[8],4096);       inc(K[10],131072);    inc(K[12],2);
inc(K[14],1024);      inc(K[16],1);         inc(K[18],262144);
inc(K[20],8192);      inc(K[22],2097152);   inc(K[24],2048);
inc(K[26],524288);    inc(K[28],536870912); inc(K[30],16);
end;
if odd(u shr 5) then begin
inc(K[0],2097152);    inc(K[2],33554432);   inc(K[4],32);
inc(K[6],256);        inc(K[8],16);         inc(K[10],67108864);
inc(K[14],65536);     inc(K[18],134217728); inc(K[22],16777216);
inc(K[24],1);         inc(K[26],262144);    inc(K[28],8192);
end;
if odd(u shr 4) then begin
inc(K[0],16777216);   inc(K[2],1024);       inc(K[4],268435456);
inc(K[6],4);          inc(K[10],33554432);  inc(K[12],32);
inc(K[14],256);       inc(K[16],536870912); inc(K[18],512);
inc(K[20],1048576);   inc(K[22],8);         inc(K[26],134217728);
inc(K[30],2);
end;
if odd(u shr 3) then begin
inc(K[0],8);          inc(K[2],65536);      inc(K[4],4096);
inc(K[6],131072);     inc(K[8],2);          inc(K[10],1024);
inc(K[12],268435456); inc(K[14],4);         inc(K[16],8192);
inc(K[18],2097152);   inc(K[20],2048);      inc(K[22],524288);
inc(K[24],536870912); inc(K[26],512);       inc(K[28],1048576);
end;
if odd(u shr 2) then begin
inc(K[1],65536);      inc(K[5],1);          inc(K[7],262144);
inc(K[9],8);          inc(K[13],4096);      inc(K[15],4);
inc(K[17],256);       inc(K[19],524288);    inc(K[23],2);
inc(K[25],67108864);  inc(K[27],8192);      inc(K[29],16777216);
inc(K[31],2048);
end;
if odd(u shr 1) then begin
inc(K[1],134217728);  inc(K[5],4096);       inc(K[7],4);
inc(K[9],268435456);  inc(K[11],32);        inc(K[13],2097152);
inc(K[15],1024);      inc(K[17],67108864);  inc(K[19],8192);
inc(K[21],16777216);  inc(K[23],65536);     inc(K[25],33554432);
inc(K[27],512);       inc(K[31],8);
end;
if odd(u) then begin
inc(K[1],524288);     inc(K[3],32);         inc(K[5],2097152);
inc(K[7],1024);       inc(K[9],131072);     inc(K[11],16);
inc(K[13],2048);      inc(K[17],33554432);  inc(K[19],512);
inc(K[23],134217728); inc(K[25],1048576);   inc(K[27],536870912);
inc(K[29],256);       inc(K[31],268435456);
end;
{* 25 iterations of DES *}
Rl:=0; Rh:=0; Ll:=0; Lh:=0;
for u:=0 to 24 do begin
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[0]; d.l1:=v xor Rh xor K[1];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[2]; d.l1:=v xor Lh xor K[3];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[4]; d.l1:=v xor Rh xor K[5];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[6]; d.l1:=v xor Lh xor K[7];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[8]; d.l1:=v xor Rh xor K[9];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[10]; d.l1:=v xor Lh xor K[11];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[12]; d.l1:=v xor Rh xor K[13];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[14]; d.l1:=v xor Lh xor K[15];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[16]; d.l1:=v xor Rh xor K[17];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[18]; d.l1:=v xor Lh xor K[19];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[20]; d.l1:=v xor Rh xor K[21];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[22]; d.l1:=v xor Lh xor K[23];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[24]; d.l1:=v xor Rh xor K[25];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[26]; d.l1:=v xor Lh xor K[27];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Rl xor Rh) and saltvalue;
d.l0:=v xor Rl xor K[28]; d.l1:=v xor Rh xor K[29];
Ll:=Ll xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Lh:=Lh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
       xor  S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=(Ll xor Lh) and saltvalue;
d.l0:=v xor Ll xor K[30]; d.l1:=v xor Lh xor K[31];
Rl:=Rl xor (S0L[d.c[0]] xor S1L[d.c[1]] xor S2L[d.c[2]] xor S3L[d.c[3]]
       xor  S4L[d.c[4]] xor S5L[d.c[5]] xor S6L[d.c[6]] xor S7L[d.c[7]]);
Rh:=Rh xor (S0H[d.c[0]] xor S1H[d.c[1]] xor S2H[d.c[2]] xor S3H[d.c[3]]
        xor S4H[d.c[4]] xor S5H[d.c[5]] xor S6H[d.c[6]] xor S7H[d.c[7]]);
v:=Ll; Ll:=Rl; Rl:=v;
v:=Lh; Lh:=Rh; Rh:=v;
end;
{* conversion of LL,Lh,Rl,Rh to 8 bytes b[0],...,b[7] *}
d.l0:=Rl; d.l1:=Rh;
b[0]:=(d.c[0] shr 1) or (d.c[1] shl 3);
b[2]:=(d.c[2] shr 1) or (d.c[3] shl 3);
b[4]:=(d.c[4] shr 1) or (d.c[5] shl 3);
b[6]:=(d.c[6] shr 1) or (d.c[7] shl 3);
d.l0:=Ll; d.l1:=Lh;
b[1]:=(d.c[0] shr 1) or (d.c[1] shl 3);
b[3]:=(d.c[2] shr 1) or (d.c[3] shl 3);
b[5]:=(d.c[4] shr 1) or (d.c[5] shl 3);
b[7]:=(d.c[6] shr 1) or (d.c[7] shl 3);
{* from the 8 bytes b[0],...,b[7] evaluates the crypted password *}
u:=0;
if b[0] and 128>0 then inc(u,32);
if b[1] and 128>0 then inc(u,16);
if b[2] and 128>0 then inc(u,8);
if b[3] and 128>0 then inc(u,4);
if b[4] and 128>0 then inc(u,2);
if b[5] and 128>0 then inc(u);
out[3]:=final[u];
u:=0;
if b[6] and 128>0 then inc(u,32);
if b[7] and 128>0 then inc(u,16);
if b[0] and 64>0 then inc(u,8);
if b[1] and 64>0 then inc(u,4);
if b[2] and 64>0 then inc(u,2);
if b[3] and 64>0 then inc(u);
out[4]:=final[u];
u:=0;
if b[4] and 64>0 then inc(u,32);
if b[5] and 64>0 then inc(u,16);
if b[6] and 64>0 then inc(u,8);
if b[7] and 64>0 then inc(u,4);
if b[0] and 32>0 then inc(u,2);
if b[1] and 32>0 then inc(u);
out[5]:=final[u];
u:=0;
if b[2] and 32>0 then inc(u,32);
if b[3] and 32>0 then inc(u,16);
if b[4] and 32>0 then inc(u,8);
if b[5] and 32>0 then inc(u,4);
if b[6] and 32>0 then inc(u,2);
if b[7] and 32>0 then inc(u);
out[6]:=final[u];
u:=0;
if b[0] and 16>0 then inc(u,32);
if b[1] and 16>0 then inc(u,16);
if b[2] and 16>0 then inc(u,8);
if b[3] and 16>0 then inc(u,4);
if b[4] and 16>0 then inc(u,2);
if b[5] and 16>0 then inc(u);
out[7]:=final[u];
u:=0;
if b[6] and 16>0 then inc(u,32);
if b[7] and 16>0 then inc(u,16);
if b[0] and 8>0 then inc(u,8);
if b[1] and 8>0 then inc(u,4);
if b[2] and 8>0 then inc(u,2);
if b[3] and 8>0 then inc(u);
out[8]:=final[u];
u:=0;
if b[4] and 8>0 then inc(u,32);
if b[5] and 8>0 then inc(u,16);
if b[6] and 8>0 then inc(u,8);
if b[7] and 8>0 then inc(u,4);
if b[0] and 4>0 then inc(u,2);
if b[1] and 4>0 then inc(u);
out[9]:=final[u];
u:=0;
if b[2] and 4>0 then inc(u,32);
if b[3] and 4>0 then inc(u,16);
if b[4] and 4>0 then inc(u,8);
if b[5] and 4>0 then inc(u,4);
if b[6] and 4>0 then inc(u,2);
if b[7] and 4>0 then inc(u);
out[10]:=final[u];
u:=0;
if b[0] and 2>0 then inc(u,32);
if b[1] and 2>0 then inc(u,16);
if b[2] and 2>0 then inc(u,8);
if b[3] and 2>0 then inc(u,4);
if b[4] and 2>0 then inc(u,2);
if b[5] and 2>0 then inc(u);
out[11]:=final[u];
u:=0;
if b[6] and 2>0 then inc(u,32);
if b[7] and 2>0 then inc(u,16);
if b[0] and 1>0 then inc(u,8);
if b[1] and 1>0 then inc(u,4);
if b[2] and 1>0 then inc(u,2);
if b[3] and 1>0 then inc(u,1);
out[12]:=final[u];
u:=0;
if b[4] and 1>0 then inc(u,32);
if b[5] and 1>0 then inc(u,16);
if b[6] and 1>0 then inc(u,8);
if b[7] and 1>0 then inc(u,4);
out[13]:=final[u];
if out[4]=#0 then out[4]:=out[3];
out[1]:=slt[1];
out[2]:=slt[2];
end;

END.
