{******************************************************************}
{                                                                  }
{       Borland Delphi Runtime Library                             }
{       Public Definitions of HID USAGES                           }
{                                                                  }
{ Portions created by Microsoft are                                }
{ Copyright (c) 1996, 1997 Microsoft Corporation                   }
{ All Rights Reserved.                                             }
{                                                                  }
{ The original file is: hidusage.h, released March 1999.           }
{ The original Pascal code is: HidUsage.pas, released 31 Jan 2000. }
{ The initial developer of the Pascal code is Robert Marquardt     }
{ (robert_marquardt@gmx.de)                                        }
{                                                                  }
{ Portions created by Robert Marquardt are                         }
{ Copyright (c) 1999, 2000 Robert Marquardt.                       }
{                                                                  }
{ Contributor(s): Marcel van Brakel (brakelm@bart.nl)              }
{                                                                  }
{ Obtained through:                                                }
{ Joint Endeavour of Delphi Innovators (Project JEDI)              }
{                                                                  }
{ You may retrieve the latest version of this file at the Project  }
{ JEDI home page, located at http://delphi-jedi.org                }
{                                                                  }
{ The contents of this file are used with permission, subject to   }
{ the Mozilla Public License Version 1.1 (the "License"); you may  }
{ not use this file except in compliance with the License. You may }
{ obtain a copy of the License at                                  }
{ http://www.mozilla.org/NPL/NPL-1_1Final.html                     }
{                                                                  }
{ Software distributed under the License is distributed on an      }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or   }
{ implied. See the License for the specific language governing     }
{ rights and limitations under the License.                        }
{                                                                  }
{******************************************************************}

unit HidUsage;

interface

{$WEAKPACKAGEUNIT}

uses Windows;

(*$HPPEMIT ''*)
(*$HPPEMIT '#include "hidusage.h"'*)
(*$HPPEMIT ''*)

//
// Usage Pages
//

const
  HID_USAGE_PAGE_GENERIC      = $01;
  {$EXTERNALSYM HID_USAGE_PAGE_GENERIC}
  HID_USAGE_PAGE_SIMULATION   = $02;
  {$EXTERNALSYM HID_USAGE_PAGE_SIMULATION}
  HID_USAGE_PAGE_VR           = $03;
  {$EXTERNALSYM HID_USAGE_PAGE_VR}
  HID_USAGE_PAGE_SPORT        = $04;
  {$EXTERNALSYM HID_USAGE_PAGE_SPORT}
  HID_USAGE_PAGE_GAME         = $05;
  {$EXTERNALSYM HID_USAGE_PAGE_GAME}
  HID_USAGE_PAGE_KEYBOARD     = $07;
  {$EXTERNALSYM HID_USAGE_PAGE_KEYBOARD}
  HID_USAGE_PAGE_LED          = $08;
  {$EXTERNALSYM HID_USAGE_PAGE_LED}
  HID_USAGE_PAGE_BUTTON       = $09;
  {$EXTERNALSYM HID_USAGE_PAGE_BUTTON}
  HID_USAGE_PAGE_ORDINAL      = $0A;
  {$EXTERNALSYM HID_USAGE_PAGE_ORDINAL}
  HID_USAGE_PAGE_TELEPHONY    = $0B;
  {$EXTERNALSYM HID_USAGE_PAGE_TELEPHONY}
  HID_USAGE_PAGE_CONSUMER     = $0C;
  {$EXTERNALSYM HID_USAGE_PAGE_CONSUMER}
  HID_USAGE_PAGE_DIGITIZER    = $0D;
  {$EXTERNALSYM HID_USAGE_PAGE_DIGITIZER}
  HID_USAGE_PAGE_UNICODE      = $10;
  {$EXTERNALSYM HID_USAGE_PAGE_UNICODE}
  HID_USAGE_PAGE_ALPHANUMERIC = $14;
  {$EXTERNALSYM HID_USAGE_PAGE_ALPHANUMERIC}

//
// Usages from Generic Desktop Page (0x01)
//

  HID_USAGE_GENERIC_POINTER    = $01;
  {$EXTERNALSYM HID_USAGE_GENERIC_POINTER}
  HID_USAGE_GENERIC_MOUSE      = $02;
  {$EXTERNALSYM HID_USAGE_GENERIC_MOUSE}
  HID_USAGE_GENERIC_JOYSTICK   = $04;
  {$EXTERNALSYM HID_USAGE_GENERIC_JOYSTICK}
  HID_USAGE_GENERIC_GAMEPAD    = $05;
  {$EXTERNALSYM HID_USAGE_GENERIC_GAMEPAD}
  HID_USAGE_GENERIC_KEYBOARD   = $06;
  {$EXTERNALSYM HID_USAGE_GENERIC_KEYBOARD}
  HID_USAGE_GENERIC_KEYPAD     = $07;
  {$EXTERNALSYM HID_USAGE_GENERIC_KEYPAD}
  HID_USAGE_GENERIC_MULTIAXIS  = $08;
  {$EXTERNALSYM HID_USAGE_GENERIC_MULTIAXIS}
  HID_USAGE_GENERIC_SYSTEM_CTL = $80;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSTEM_CTL}

  HID_USAGE_GENERIC_X                   = $30;
  {$EXTERNALSYM HID_USAGE_GENERIC_X}
  HID_USAGE_GENERIC_Y                   = $31;
  {$EXTERNALSYM HID_USAGE_GENERIC_Y}
  HID_USAGE_GENERIC_Z                   = $32;
  {$EXTERNALSYM HID_USAGE_GENERIC_Z}
  HID_USAGE_GENERIC_RX                  = $33;
  {$EXTERNALSYM HID_USAGE_GENERIC_RX}
  HID_USAGE_GENERIC_RY                  = $34;
  {$EXTERNALSYM HID_USAGE_GENERIC_RY}
  HID_USAGE_GENERIC_RZ                  = $35;
  {$EXTERNALSYM HID_USAGE_GENERIC_RZ}
  HID_USAGE_GENERIC_SLIDER              = $36;
  {$EXTERNALSYM HID_USAGE_GENERIC_SLIDER}
  HID_USAGE_GENERIC_DIAL                = $37;
  {$EXTERNALSYM HID_USAGE_GENERIC_DIAL}
  HID_USAGE_GENERIC_WHEEL               = $38;
  {$EXTERNALSYM HID_USAGE_GENERIC_WHEEL}
  HID_USAGE_GENERIC_HATSWITCH           = $39;
  {$EXTERNALSYM HID_USAGE_GENERIC_HATSWITCH}
  HID_USAGE_GENERIC_COUNTED_BUFFER      = $3A;
  {$EXTERNALSYM HID_USAGE_GENERIC_COUNTED_BUFFER}
  HID_USAGE_GENERIC_BYTE_COUNT          = $3B;
  {$EXTERNALSYM HID_USAGE_GENERIC_BYTE_COUNT}
  HID_USAGE_GENERIC_MOTION_WAKEUP       = $3C;
  {$EXTERNALSYM HID_USAGE_GENERIC_MOTION_WAKEUP}
  HID_USAGE_GENERIC_START               = $3D;
  {$EXTERNALSYM HID_USAGE_GENERIC_START}
  HID_USAGE_GENERIC_SELECT              = $3E;
  {$EXTERNALSYM HID_USAGE_GENERIC_SELECT}
  HID_USAGE_GENERIC_VX                  = $40;
  {$EXTERNALSYM HID_USAGE_GENERIC_VX}
  HID_USAGE_GENERIC_VY                  = $41;
  {$EXTERNALSYM HID_USAGE_GENERIC_VY}
  HID_USAGE_GENERIC_VZ                  = $42;
  {$EXTERNALSYM HID_USAGE_GENERIC_VZ}
  HID_USAGE_GENERIC_VBRX                = $43;
  {$EXTERNALSYM HID_USAGE_GENERIC_VBRX}
  HID_USAGE_GENERIC_VBRY                = $44;
  {$EXTERNALSYM HID_USAGE_GENERIC_VBRY}
  HID_USAGE_GENERIC_VBRZ                = $45;
  {$EXTERNALSYM HID_USAGE_GENERIC_VBRZ}
  HID_USAGE_GENERIC_VNO                 = $46;
  {$EXTERNALSYM HID_USAGE_GENERIC_VNO}
  HID_USAGE_GENERIC_SYSCTL_POWER        = $81;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_POWER}
  HID_USAGE_GENERIC_SYSCTL_SLEEP        = $82;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_SLEEP}
  HID_USAGE_GENERIC_SYSCTL_WAKE         = $83;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_WAKE}
  HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU = $84;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU}
  HID_USAGE_GENERIC_SYSCTL_MAIN_MENU    = $85;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MAIN_MENU}
  HID_USAGE_GENERIC_SYSCTL_APP_MENU     = $86;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_APP_MENU}
  HID_USAGE_GENERIC_SYSCTL_HELP_MENU    = $87;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_HELP_MENU}
  HID_USAGE_GENERIC_SYSCTL_MENU_EXIT    = $88;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_EXIT}
  HID_USAGE_GENERIC_SYSCTL_MENU_SELECT  = $89;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_SELECT}
  HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT   = $8A;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT}
  HID_USAGE_GENERIC_SYSCTL_MENU_LEFT    = $8B;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_LEFT}
  HID_USAGE_GENERIC_SYSCTL_MENU_UP      = $8C;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_UP}
  HID_USAGE_GENERIC_SYSCTL_MENU_DOWN    = $8D;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_MENU_DOWN}
  HID_USAGE_GENERIC_SYSCTL_DPAD_UP      = $90;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_DPAD_UP}
  HID_USAGE_GENERIC_SYSCTL_DPAD_DOWN    = $91;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_DPAD_DOWN}
  HID_USAGE_GENERIC_SYSCTL_DPAD_RIGHT   = $92;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_DPAD_RIGHT}
  HID_USAGE_GENERIC_SYSCTL_DPAD_LEFT    = $93;
  {$EXTERNALSYM HID_USAGE_GENERIC_SYSCTL_DPAD_LEFT}

//
// Usages from Simulation Controls Page (0x02)
//

  HID_USAGE_SIMULATION_RUDDER   = $BA;
  {$EXTERNALSYM HID_USAGE_SIMULATION_RUDDER}
  HID_USAGE_SIMULATION_THROTTLE = $BB;
  {$EXTERNALSYM HID_USAGE_SIMULATION_THROTTLE}

//
// Virtual Reality Controls Page (0x03)
//


//
// Sport Controls Page (0x04)
//


//
// Game Controls Page (0x05)
//


//
// Keyboard/Keypad Page (0x07)
//

  // Error "keys"
  HID_USAGE_KEYBOARD_NOEVENT      = $00;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_NOEVENT}
  HID_USAGE_KEYBOARD_ROLLOVER     = $01;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ROLLOVER}
  HID_USAGE_KEYBOARD_POSTFAIL     = $02;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_POSTFAIL}
  HID_USAGE_KEYBOARD_UNDEFINED    = $03;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_UNDEFINED}

  // Letters
  HID_USAGE_KEYBOARD_aA           = $04;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_aA}
  HID_USAGE_KEYBOARD_bB           = $05;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_bB}
  HID_USAGE_KEYBOARD_cC           = $06;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_cC}
  HID_USAGE_KEYBOARD_dD           = $07;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_dD}
  HID_USAGE_KEYBOARD_eE           = $08;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_eE}
  HID_USAGE_KEYBOARD_fF           = $09;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_fF}
  HID_USAGE_KEYBOARD_gG           = $0A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_gG}
  HID_USAGE_KEYBOARD_hH           = $0B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_hH}
  HID_USAGE_KEYBOARD_iI           = $0C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_iI}
  HID_USAGE_KEYBOARD_jJ           = $0D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_jJ}
  HID_USAGE_KEYBOARD_kK           = $0E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_kK}
  HID_USAGE_KEYBOARD_lL           = $0F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_lL}
  HID_USAGE_KEYBOARD_mM           = $10;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_mM}
  HID_USAGE_KEYBOARD_nN           = $11;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_nN}
  HID_USAGE_KEYBOARD_oO           = $12;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_oO}
  HID_USAGE_KEYBOARD_pP           = $13;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_pP}
  HID_USAGE_KEYBOARD_qQ           = $14;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_qQ}
  HID_USAGE_KEYBOARD_rR           = $15;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_rR}
  HID_USAGE_KEYBOARD_sS           = $16;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_sS}
  HID_USAGE_KEYBOARD_tT           = $17;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_tT}
  HID_USAGE_KEYBOARD_uU           = $18;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_uU}
  HID_USAGE_KEYBOARD_vV           = $19;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_vV}
  HID_USAGE_KEYBOARD_wW           = $1A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_wW}
  HID_USAGE_KEYBOARD_xX           = $1B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_xX}
  HID_USAGE_KEYBOARD_yY           = $1C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_yY}
  HID_USAGE_KEYBOARD_zZ           = $1D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_zZ}

  // Numbers
  HID_USAGE_KEYBOARD_ONE          = $1E; // or !
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ONE}
  HID_USAGE_KEYBOARD_TWO          = $1F; // or @
  {$EXTERNALSYM HID_USAGE_KEYBOARD_TWO}
  HID_USAGE_KEYBOARD_THREE        = $20; // or #
  {$EXTERNALSYM HID_USAGE_KEYBOARD_THREE}
  HID_USAGE_KEYBOARD_FOUR         = $21; // or $
  {$EXTERNALSYM HID_USAGE_KEYBOARD_FOUR}
  HID_USAGE_KEYBOARD_FIVE         = $22; // or %
  {$EXTERNALSYM HID_USAGE_KEYBOARD_FIVE}
  HID_USAGE_KEYBOARD_SIX          = $23; // or ^
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SIX}
  HID_USAGE_KEYBOARD_SEVEN        = $24; // or &
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SEVEN}
  HID_USAGE_KEYBOARD_EIGHT        = $25; // or *
  {$EXTERNALSYM HID_USAGE_KEYBOARD_EIGHT}
  HID_USAGE_KEYBOARD_NINE         = $26; // or (
  {$EXTERNALSYM HID_USAGE_KEYBOARD_NINE}
  HID_USAGE_KEYBOARD_ZERO         = $27; // or )
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ZERO}

  HID_USAGE_KEYBOARD_ENTER        = $28; // RETURN is another key
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ENTER}
  HID_USAGE_KEYBOARD_ESCAPE       = $29;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ESCAPE}
  HID_USAGE_KEYBOARD_BACKSPACE    = $2A; // Delete left char
  {$EXTERNALSYM HID_USAGE_KEYBOARD_BACKSPACE}
  HID_USAGE_KEYBOARD_TAB          = $2B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_TAB}
  HID_USAGE_KEYBOARD_SPACE        = $2C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SPACE}
  HID_USAGE_KEYBOARD_MINUS        = $2D; // or _
  {$EXTERNALSYM HID_USAGE_KEYBOARD_MINUS}
  HID_USAGE_KEYBOARD_EQUAL        = $2E; // or +
  {$EXTERNALSYM HID_USAGE_KEYBOARD_EQUAL}
  HID_USAGE_KEYBOARD_LSQBRACKET   = $2F; // or {
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LSQBRACKET}
  HID_USAGE_KEYBOARD_RSQBRACKET   = $30; // or }
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RSQBRACKET}
  HID_USAGE_KEYBOARD_BACKSLASH    = $31; // or |
  {$EXTERNALSYM HID_USAGE_KEYBOARD_BACKSLASH}
  HID_USAGE_KEYBOARD_HASHMARK2    = $32; // or ~ Non US Key
  {$EXTERNALSYM HID_USAGE_KEYBOARD_HASHMARK2}
  HID_USAGE_KEYBOARD_SEMICOLON    = $33;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SEMICOLON}
  HID_USAGE_KEYBOARD_APOSTROPH    = $34; // or :
  {$EXTERNALSYM HID_USAGE_KEYBOARD_APOSTROPH}
  HID_USAGE_KEYBOARD_GRAVEACCENT  = $35; // or Tilde
  {$EXTERNALSYM HID_USAGE_KEYBOARD_GRAVEACCENT}
  HID_USAGE_KEYBOARD_COMMA        = $36; // or <
  {$EXTERNALSYM HID_USAGE_KEYBOARD_COMMA}
  HID_USAGE_KEYBOARD_DOT          = $37; // or >
  {$EXTERNALSYM HID_USAGE_KEYBOARD_DOT}
  HID_USAGE_KEYBOARD_SLASH        = $38; // or ?
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SLASH}

  HID_USAGE_KEYBOARD_CAPS_LOCK    = $39;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CAPS_LOCK}

  // Function keys
  HID_USAGE_KEYBOARD_F1           = $3A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F1}
  HID_USAGE_KEYBOARD_F2           = $3B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F2}
  HID_USAGE_KEYBOARD_F3           = $3C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F3}
  HID_USAGE_KEYBOARD_F4           = $3D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F4}
  HID_USAGE_KEYBOARD_F5           = $3E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F5}
  HID_USAGE_KEYBOARD_F6           = $3F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F6}
  HID_USAGE_KEYBOARD_F7           = $40;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F7}
  HID_USAGE_KEYBOARD_F8           = $41;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F8}
  HID_USAGE_KEYBOARD_F9           = $42;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F9}
  HID_USAGE_KEYBOARD_F10          = $43;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F10}
  HID_USAGE_KEYBOARD_F11          = $44;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F11}
  HID_USAGE_KEYBOARD_F12          = $45;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F12}

  HID_USAGE_KEYBOARD_PRINT_SCREEN = $46;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PRINT_SCREEN}
  HID_USAGE_KEYBOARD_SCROLL_LOCK  = $47;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SCROLL_LOCK}

  HID_USAGE_KEYBOARD_PAUSE        = $48;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PAUSE}
  HID_USAGE_KEYBOARD_INSERT       = $49;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INSERT}
  HID_USAGE_KEYBOARD_HOME         = $4A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_HOME}
  HID_USAGE_KEYBOARD_PAGEUP       = $4B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PAGEUP}
  HID_USAGE_KEYBOARD_DELETE       = $4C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_DELETE}
  HID_USAGE_KEYBOARD_END          = $4D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_END}
  HID_USAGE_KEYBOARD_PAGEDOWN     = $4E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PAGEDOWN}
  HID_USAGE_KEYBOARD_RIGHT        = $4F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RIGHT}
  HID_USAGE_KEYBOARD_LEFT         = $50;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LEFT}
  HID_USAGE_KEYBOARD_DOWN         = $51;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_DOWN}
  HID_USAGE_KEYBOARD_UP           = $52;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_UP}

  HID_USAGE_KEYPAD_NUM_LOCK       = $53;
  {$EXTERNALSYM HID_USAGE_KEYPAD_NUM_LOCK}
  HID_USAGE_KEYPAD_SLASH          = $54;
  {$EXTERNALSYM HID_USAGE_KEYPAD_SLASH}
  HID_USAGE_KEYPAD_STAR           = $55;
  {$EXTERNALSYM HID_USAGE_KEYPAD_STAR}
  HID_USAGE_KEYPAD_MINUS          = $56;
  {$EXTERNALSYM HID_USAGE_KEYPAD_MINUS}
  HID_USAGE_KEYPAD_PLUS           = $57;
  {$EXTERNALSYM HID_USAGE_KEYPAD_PLUS}
  HID_USAGE_KEYPAD_ENTER          = $58;
  {$EXTERNALSYM HID_USAGE_KEYPAD_ENTER}
  HID_USAGE_KEYPAD_ONE            = $59;
  {$EXTERNALSYM HID_USAGE_KEYPAD_ONE}
  HID_USAGE_KEYPAD_TWO            = $5A;
  {$EXTERNALSYM HID_USAGE_KEYPAD_TWO}
  HID_USAGE_KEYPAD_THREE          = $5B;
  {$EXTERNALSYM HID_USAGE_KEYPAD_THREE}
  HID_USAGE_KEYPAD_FOUR           = $5C;
  {$EXTERNALSYM HID_USAGE_KEYPAD_FOUR}
  HID_USAGE_KEYPAD_FIVE           = $5D;
  {$EXTERNALSYM HID_USAGE_KEYPAD_FIVE}
  HID_USAGE_KEYPAD_SIX            = $5E;
  {$EXTERNALSYM HID_USAGE_KEYPAD_SIX}
  HID_USAGE_KEYPAD_SEVEN          = $5F;
  {$EXTERNALSYM HID_USAGE_KEYPAD_SEVEN}
  HID_USAGE_KEYPAD_EIGHT          = $60;
  {$EXTERNALSYM HID_USAGE_KEYPAD_EIGHT}
  HID_USAGE_KEYPAD_NINE           = $61;
  {$EXTERNALSYM HID_USAGE_KEYPAD_NINE}
  HID_USAGE_KEYPAD_ZERO           = $62;
  {$EXTERNALSYM HID_USAGE_KEYPAD_ZERO}
  HID_USAGE_KEYPAD_DOT            = $63;
  {$EXTERNALSYM HID_USAGE_KEYPAD_DOT}

  HID_USAGE_KEYBOARD_BACKSLASH2   = $64; // or | Non US key
  {$EXTERNALSYM HID_USAGE_KEYBOARD_BACKSLASH2}

  HID_USAGE_KEYBOARD_APPLICATION  = $65;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_APPLICATION}

  // Keys not for Windows
  HID_USAGE_KEYBOARD_POWER        = $66;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_POWER}
  HID_USAGE_KEYPAD_EQUAL2         = $67;
  {$EXTERNALSYM HID_USAGE_KEYPAD_EQUAL2}

  // Keys not for Windows
  HID_USAGE_KEYBOARD_F13          = $68;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F13}
  HID_USAGE_KEYBOARD_F14          = $69;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F14}
  HID_USAGE_KEYBOARD_F15          = $6A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F15}
  HID_USAGE_KEYBOARD_F16          = $6B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F16}
  HID_USAGE_KEYBOARD_F17          = $6C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F17}
  HID_USAGE_KEYBOARD_F18          = $6D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F18}
  HID_USAGE_KEYBOARD_F19          = $6E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F19}
  HID_USAGE_KEYBOARD_F20          = $6F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F20}
  HID_USAGE_KEYBOARD_F21          = $70;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F21}
  HID_USAGE_KEYBOARD_F22          = $71;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F22}
  HID_USAGE_KEYBOARD_F23          = $72;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F23}
  HID_USAGE_KEYBOARD_F24          = $73;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_F24}
  HID_USAGE_KEYBOARD_EXECUTE      = $74;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_EXECUTE}
  HID_USAGE_KEYBOARD_HELP         = $75;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_HELP}
  HID_USAGE_KEYBOARD_MENU         = $76;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_MENU}
  HID_USAGE_KEYBOARD_SELECT       = $77;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SELECT}
  HID_USAGE_KEYBOARD_STOP         = $78;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_STOP}
  HID_USAGE_KEYBOARD_AGAIN        = $79;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_AGAIN}
  HID_USAGE_KEYBOARD_UNDO         = $7A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_UNDO}
  HID_USAGE_KEYBOARD_CUT          = $7B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CUT}
  HID_USAGE_KEYBOARD_COPY         = $7C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_COPY}
  HID_USAGE_KEYBOARD_PASTE        = $7D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PASTE}
  HID_USAGE_KEYBOARD_FIND         = $7E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_FIND}
  HID_USAGE_KEYBOARD_MUTE         = $7F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_MUTE}
  HID_USAGE_KEYBOARD_VOLUME_UP    = $80;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_VOLUME_UP}
  HID_USAGE_KEYBOARD_VOLUME_DOWN  = $81;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_VOLUME_DOWN}

  HID_USAGE_KEYBOARD_LOCKCAPS     = $82;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LOCKCAPS}
  HID_USAGE_KEYBOARD_LOCKNUM      = $83;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LOCKNUM}
  HID_USAGE_KEYBOARD_LOCKSCROLL   = $84;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LOCKSCROLL}

  HID_USAGE_KEYPAD_COMMA          = $85;
  {$EXTERNALSYM HID_USAGE_KEYPAD_COMMA}
  HID_USAGE_KEYPAD_EQUALSIGN      = $86;
  {$EXTERNALSYM HID_USAGE_KEYPAD_EQUALSIGN}

  HID_USAGE_KEYBOARD_INATL1       = $87;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL1}
  HID_USAGE_KEYBOARD_INATL2       = $88;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL2}
  HID_USAGE_KEYBOARD_INATL3       = $89;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL3}
  HID_USAGE_KEYBOARD_INATL4       = $8A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL4}
  HID_USAGE_KEYBOARD_INATL5       = $8B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL5}
  HID_USAGE_KEYBOARD_INATL6       = $8C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL6}
  HID_USAGE_KEYBOARD_INATL7       = $8D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL7}
  HID_USAGE_KEYBOARD_INATL8       = $8E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL8}
  HID_USAGE_KEYBOARD_INATL9       = $8F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_INATL9}
  HID_USAGE_KEYBOARD_LANG1        = $90;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG1}
  HID_USAGE_KEYBOARD_LANG2        = $91;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG2}
  HID_USAGE_KEYBOARD_LANG3        = $92;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG3}
  HID_USAGE_KEYBOARD_LANG4        = $93;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG4}
  HID_USAGE_KEYBOARD_LANG5        = $94;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG5}
  HID_USAGE_KEYBOARD_LANG6        = $95;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG6}
  HID_USAGE_KEYBOARD_LANG7        = $96;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG7}
  HID_USAGE_KEYBOARD_LANG8        = $97;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG8}
  HID_USAGE_KEYBOARD_LANG9        = $98;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LANG9}

  HID_USAGE_KEYBOARD_ALTERASE     = $99;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_ALTERASE}
  HID_USAGE_KEYBOARD_SYSREQ       = $9A;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SYSREQ}
  HID_USAGE_KEYBOARD_CANCEL       = $9B;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CANCEL}
  HID_USAGE_KEYBOARD_CLEAR        = $9C;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CLEAR}
  HID_USAGE_KEYBOARD_PRIOR        = $9D;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_PRIOR}
  HID_USAGE_KEYBOARD_RETURN       = $9E;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RETURN}
  HID_USAGE_KEYBOARD_SEPARATOR    = $9F;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_SEPARATOR}
  HID_USAGE_KEYBOARD_OUT          = $A0;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_OUT}
  HID_USAGE_KEYBOARD_OPER         = $A1;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_OPER}
  HID_USAGE_KEYBOARD_CLEAR_AGAIN  = $A2;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CLEAR_AGAIN}
  HID_USAGE_KEYBOARD_CRSEL        = $A3;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_CRSEL}
  HID_USAGE_KEYBOARD_EXSEL        = $A4;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_EXSEL}

  HID_USAGE_KEYBOARD_LCTRL        = $E0;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LCTRL}
  HID_USAGE_KEYBOARD_LSHFT        = $E1;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LSHFT}
  HID_USAGE_KEYBOARD_LALT         = $E2;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LALT}
  HID_USAGE_KEYBOARD_LGUI         = $E3;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_LGUI}
  HID_USAGE_KEYBOARD_RCTRL        = $E4;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RCTRL}
  HID_USAGE_KEYBOARD_RSHFT        = $E5;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RSHFT}
  HID_USAGE_KEYBOARD_RALT         = $E6;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RALT}
  HID_USAGE_KEYBOARD_RGUI         = $E7;
  {$EXTERNALSYM HID_USAGE_KEYBOARD_RGUI}

// and hundreds more...
  // (rom) $E8 to $FFFF are reserved in "USB HID Usage Tables 1.1rc3.pdf"

//
// LED Page (0x08)
//

  HID_USAGE_LED_NUM_LOCK             = $01;
  {$EXTERNALSYM HID_USAGE_LED_NUM_LOCK}
  HID_USAGE_LED_CAPS_LOCK            = $02;
  {$EXTERNALSYM HID_USAGE_LED_CAPS_LOCK}
  HID_USAGE_LED_SCROLL_LOCK          = $03;
  {$EXTERNALSYM HID_USAGE_LED_SCROLL_LOCK}
  HID_USAGE_LED_COMPOSE              = $04;
  {$EXTERNALSYM HID_USAGE_LED_COMPOSE}
  HID_USAGE_LED_KANA                 = $05;
  {$EXTERNALSYM HID_USAGE_LED_KANA}
  HID_USAGE_LED_POWER                = $06;
  {$EXTERNALSYM HID_USAGE_LED_POWER}
  HID_USAGE_LED_SHIFT                = $07;
  {$EXTERNALSYM HID_USAGE_LED_SHIFT}
  HID_USAGE_LED_DO_NOT_DISTURB       = $08;
  {$EXTERNALSYM HID_USAGE_LED_DO_NOT_DISTURB}
  HID_USAGE_LED_MUTE                 = $09;
  {$EXTERNALSYM HID_USAGE_LED_MUTE}
  HID_USAGE_LED_TONE_ENABLE          = $0A;
  {$EXTERNALSYM HID_USAGE_LED_TONE_ENABLE}
  HID_USAGE_LED_HIGH_CUT_FILTER      = $0B;
  {$EXTERNALSYM HID_USAGE_LED_HIGH_CUT_FILTER}
  HID_USAGE_LED_LOW_CUT_FILTER       = $0C;
  {$EXTERNALSYM HID_USAGE_LED_LOW_CUT_FILTER}
  HID_USAGE_LED_EQUALIZER_ENABLE     = $0D;
  {$EXTERNALSYM HID_USAGE_LED_EQUALIZER_ENABLE}
  HID_USAGE_LED_SOUND_FIELD_ON       = $0E;
  {$EXTERNALSYM HID_USAGE_LED_SOUND_FIELD_ON}
  HID_USAGE_LED_SURROUND_FIELD_ON    = $0F;
  {$EXTERNALSYM HID_USAGE_LED_SURROUND_FIELD_ON}
  HID_USAGE_LED_REPEAT               = $10;
  {$EXTERNALSYM HID_USAGE_LED_REPEAT}
  HID_USAGE_LED_STEREO               = $11;
  {$EXTERNALSYM HID_USAGE_LED_STEREO}
  HID_USAGE_LED_SAMPLING_RATE_DETECT = $12;
  {$EXTERNALSYM HID_USAGE_LED_SAMPLING_RATE_DETECT}
  HID_USAGE_LED_SPINNING             = $13;
  {$EXTERNALSYM HID_USAGE_LED_SPINNING}
  HID_USAGE_LED_CAV                  = $14;
  {$EXTERNALSYM HID_USAGE_LED_CAV}
  HID_USAGE_LED_CLV                  = $15;
  {$EXTERNALSYM HID_USAGE_LED_CLV}
  HID_USAGE_LED_RECORDING_FORMAT_DET = $16;
  {$EXTERNALSYM HID_USAGE_LED_RECORDING_FORMAT_DET}
  HID_USAGE_LED_OFF_HOOK             = $17;
  {$EXTERNALSYM HID_USAGE_LED_OFF_HOOK}
  HID_USAGE_LED_RING                 = $18;
  {$EXTERNALSYM HID_USAGE_LED_RING}
  HID_USAGE_LED_MESSAGE_WAITING      = $19;
  {$EXTERNALSYM HID_USAGE_LED_MESSAGE_WAITING}
  HID_USAGE_LED_DATA_MODE            = $1A;
  {$EXTERNALSYM HID_USAGE_LED_DATA_MODE}
  HID_USAGE_LED_BATTERY_OPERATION    = $1B;
  {$EXTERNALSYM HID_USAGE_LED_BATTERY_OPERATION}
  HID_USAGE_LED_BATTERY_OK           = $1C;
  {$EXTERNALSYM HID_USAGE_LED_BATTERY_OK}
  HID_USAGE_LED_BATTERY_LOW          = $1D;
  {$EXTERNALSYM HID_USAGE_LED_BATTERY_LOW}
  HID_USAGE_LED_SPEAKER              = $1E;
  {$EXTERNALSYM HID_USAGE_LED_SPEAKER}
  HID_USAGE_LED_HEAD_SET             = $1F;
  {$EXTERNALSYM HID_USAGE_LED_HEAD_SET}
  HID_USAGE_LED_HOLD                 = $20;
  {$EXTERNALSYM HID_USAGE_LED_HOLD}
  HID_USAGE_LED_MICROPHONE           = $21;
  {$EXTERNALSYM HID_USAGE_LED_MICROPHONE}
  HID_USAGE_LED_COVERAGE             = $22;
  {$EXTERNALSYM HID_USAGE_LED_COVERAGE}
  HID_USAGE_LED_NIGHT_MODE           = $23;
  {$EXTERNALSYM HID_USAGE_LED_NIGHT_MODE}
  HID_USAGE_LED_SEND_CALLS           = $24;
  {$EXTERNALSYM HID_USAGE_LED_SEND_CALLS}
  HID_USAGE_LED_CALL_PICKUP          = $25;
  {$EXTERNALSYM HID_USAGE_LED_CALL_PICKUP}
  HID_USAGE_LED_CONFERENCE           = $26;
  {$EXTERNALSYM HID_USAGE_LED_CONFERENCE}
  HID_USAGE_LED_STAND_BY             = $27;
  {$EXTERNALSYM HID_USAGE_LED_STAND_BY}
  HID_USAGE_LED_CAMERA_ON            = $28;
  {$EXTERNALSYM HID_USAGE_LED_CAMERA_ON}
  HID_USAGE_LED_CAMERA_OFF           = $29;
  {$EXTERNALSYM HID_USAGE_LED_CAMERA_OFF}
  HID_USAGE_LED_ON_LINE              = $2A;
  {$EXTERNALSYM HID_USAGE_LED_ON_LINE}
  HID_USAGE_LED_OFF_LINE             = $2B;
  {$EXTERNALSYM HID_USAGE_LED_OFF_LINE}
  HID_USAGE_LED_BUSY                 = $2C;
  {$EXTERNALSYM HID_USAGE_LED_BUSY}
  HID_USAGE_LED_READY                = $2D;
  {$EXTERNALSYM HID_USAGE_LED_READY}
  HID_USAGE_LED_PAPER_OUT            = $2E;
  {$EXTERNALSYM HID_USAGE_LED_PAPER_OUT}
  HID_USAGE_LED_PAPER_JAM            = $2F;
  {$EXTERNALSYM HID_USAGE_LED_PAPER_JAM}
  HID_USAGE_LED_REMOTE               = $30;
  {$EXTERNALSYM HID_USAGE_LED_REMOTE}
  HID_USAGE_LED_FORWARD              = $31;
  {$EXTERNALSYM HID_USAGE_LED_FORWARD}
  HID_USAGE_LED_REVERSE              = $32;
  {$EXTERNALSYM HID_USAGE_LED_REVERSE}
  HID_USAGE_LED_STOP                 = $33;
  {$EXTERNALSYM HID_USAGE_LED_STOP}
  HID_USAGE_LED_REWIND               = $34;
  {$EXTERNALSYM HID_USAGE_LED_REWIND}
  HID_USAGE_LED_FAST_FORWARD         = $35;
  {$EXTERNALSYM HID_USAGE_LED_FAST_FORWARD}
  HID_USAGE_LED_PLAY                 = $36;
  {$EXTERNALSYM HID_USAGE_LED_PLAY}
  HID_USAGE_LED_PAUSE                = $37;
  {$EXTERNALSYM HID_USAGE_LED_PAUSE}
  HID_USAGE_LED_RECORD               = $38;
  {$EXTERNALSYM HID_USAGE_LED_RECORD}
  HID_USAGE_LED_ERROR                = $39;
  {$EXTERNALSYM HID_USAGE_LED_ERROR}
  HID_USAGE_LED_SELECTED_INDICATOR   = $3A;
  {$EXTERNALSYM HID_USAGE_LED_SELECTED_INDICATOR}
  HID_USAGE_LED_IN_USE_INDICATOR     = $3B;
  {$EXTERNALSYM HID_USAGE_LED_IN_USE_INDICATOR}
  HID_USAGE_LED_MULTI_MODE_INDICATOR = $3C;
  {$EXTERNALSYM HID_USAGE_LED_MULTI_MODE_INDICATOR}
  HID_USAGE_LED_INDICATOR_ON         = $3D;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_ON}
  HID_USAGE_LED_INDICATOR_FLASH      = $3E;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_FLASH}
  HID_USAGE_LED_INDICATOR_SLOW_BLINK = $3F;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_SLOW_BLINK}
  HID_USAGE_LED_INDICATOR_FAST_BLINK = $40;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_FAST_BLINK}
  HID_USAGE_LED_INDICATOR_OFF        = $41;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_OFF}
  HID_USAGE_LED_FLASH_ON_TIME        = $42;
  {$EXTERNALSYM HID_USAGE_LED_FLASH_ON_TIME}
  HID_USAGE_LED_SLOW_BLINK_ON_TIME   = $43;
  {$EXTERNALSYM HID_USAGE_LED_SLOW_BLINK_ON_TIME}
  HID_USAGE_LED_SLOW_BLINK_OFF_TIME  = $44;
  {$EXTERNALSYM HID_USAGE_LED_SLOW_BLINK_OFF_TIME}
  HID_USAGE_LED_FAST_BLINK_ON_TIME   = $45;
  {$EXTERNALSYM HID_USAGE_LED_FAST_BLINK_ON_TIME}
  HID_USAGE_LED_FAST_BLINK_OFF_TIME  = $46;
  {$EXTERNALSYM HID_USAGE_LED_FAST_BLINK_OFF_TIME}
  HID_USAGE_LED_INDICATOR_COLOR      = $47;
  {$EXTERNALSYM HID_USAGE_LED_INDICATOR_COLOR}
  HID_USAGE_LED_RED                  = $48;
  {$EXTERNALSYM HID_USAGE_LED_RED}
  HID_USAGE_LED_GREEN                = $49;
  {$EXTERNALSYM HID_USAGE_LED_GREEN}
  HID_USAGE_LED_AMBER                = $4A;
  {$EXTERNALSYM HID_USAGE_LED_AMBER}
  HID_USAGE_LED_GENERIC_INDICATOR    = $4B;
  {$EXTERNALSYM HID_USAGE_LED_GENERIC_INDICATOR}
  HID_USAGE_LED_SYSTEM_SUSPEND       = $4C;
  {$EXTERNALSYM HID_USAGE_LED_SYSTEM_SUSPEND}
  HID_USAGE_LED_EXTERNAL_POWER       = $4D;
  {$EXTERNALSYM HID_USAGE_LED_EXTERNAL_POWER}

//
//  Button Page (0x09)
//
//  There is no need to label these usages.
//


//
//  Ordinal Page (0x0A)
//
//  There is no need to label these usages.
//

//
//  Telephony Device Page (0x0B)
//

  HID_USAGE_TELEPHONY_PHONE               = $01;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_PHONE}
  HID_USAGE_TELEPHONY_ANSWERING_MACHINE   = $02;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_ANSWERING_MACHINE}
  HID_USAGE_TELEPHONY_MESSAGE_CONTROLS    = $03;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_MESSAGE_CONTROLS}
  HID_USAGE_TELEPHONY_HANDSET             = $04;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_HANDSET}
  HID_USAGE_TELEPHONY_HEADSET             = $05;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_HEADSET}
  HID_USAGE_TELEPHONY_KEYPAD              = $06;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_KEYPAD}
  HID_USAGE_TELEPHONY_PROGRAMMABLE_BUTTON = $07;
  {$EXTERNALSYM HID_USAGE_TELEPHONY_PROGRAMMABLE_BUTTON}

//
// and others...
//

implementation

end.
