---
name: 'Whackamole!'
description: 'Build a Whackamole game'
author: '@sohamb117'
img: "https://cloud-qqtj6180q-hack-club-bot.vercel.app/0whackamole_.png"
---

# Whackamole

We'll be building the game Whackamole today! It's an extremely popular game where you click the "mole" before the timer runs out. It's a fun game, and pretty easy to build on your own. So today, you'll be doing exactly that: building Whackamole all by yourself.

[Check out the Demo!](https://whackamole-demo.sohamb117.repl.co/)
[![whackamole demo](https://cloud-blecn0kdn-hack-club-bot.vercel.app/0image.png)](https://whackamole-demo.sohamb117.repl.co/)

### How to Build It

We're providing some [starter code](https://replit.com/@sohamb117/Whackamole-Student-Version), but you'll be writing most of this on your own!

Here's a rough guide for how to start.

- Start by going through all the [demos](https://hackclub.github.io/clicker-game-examples/) and clearly understanding them. Think about how you could use them in your own code.
- Go through your HTML, JS, and CSS files. Read any comments and complete any immediate tasks you notice. **Hint:** One task is to link your JS file in your HTML code. *Check the comments.*
- Start your JS by adding constants that refer to HTML elements that you'll be using
- Write the relocate function - it handles what happens when a mole is clicked. Also, remember to add the `onClick` bind in your JS.
- Write the timer function. This will keep track of the time to make sure that the game ends when time runs out, and that the timer keeps going down. Refer to the examples!
- Write the game state management. This can work however you want, just make sure that it ends the game when the timer hits 0.
- Test and customize! Add new functionality, animations, features, and maybe even gameplay mechanics! Or, just change how it looks! Have fun!


### Resources

Here's all the resources you'll need to make this work, but remember, the internet is always a resource we can use. So if you need help, feel free to Google it! 

*   [Starter Code](https://replit.com/@sohamb117/Whackamole-Student-Version) - Provide this to club members as a starting point for their own work
*   [Code Demos](https://hackclub.github.io/clicker-game-examples/) - These are the demos you'll want club members to use as reference
*   [Example Project](https://Whackamole-Demo.sohamb117.repl.co) - Showcase this as an example of what we're trying to build


### After Building

**Congratulations!**
You've built Whackamole *on your own!* Now, put your own spin on it! Make it look nicer, add some animations, maybe even add new mechanics. Here's a few fun things you can do to start.

- Add a reset button
- Add bombs that end the game when clicked
- Add an option to change the time

But there's so many things you can do to expand this. You can even make whole other games! 
So go forth, and good luck!
