# Field Report 

### Author: Tevan Goldberg 
### Workshop: Stressed Ball (A.K.A. Reverse Workshop #1)
### Location: Pierson Library, Shelburne VT 
### Date and Time: Nov. 4th at 4:00 PM 
### Attendence: 15 

<img width="1643" alt="Piersonclubmeeting" src="https://user-images.githubusercontent.com/27078897/141187635-3976eaf4-a70f-4949-8606-17f219e0d130.png">

## Overview 

This was our first test of a new workshop format, what we're calling the 'reverse workshop.' The idea was to present our club members with a final output and then try to help them decipher the steps needed to get there. This is in contrast to many code tutorials which simply provide you with the needed code in sequential order, limiting opportunities for problem-solving and collaboration. 

Our goal was to write a Javascript program that would display a circle on a simple canvas, fidgeting through different colors and positions in what could only be called...stressful. Making the leap from HTML/CSS to JavaScript is difficult, and many people don't know where to start, so we wanted to create an achievable challenge that touched on a number of 'real' computer science concepts like loops, variables, and interpolation. Our workshop template thus became a series of problems like "draw a circle," "color the circle," etc. The hope was that by posing the right questions to Google (and StackOverflow) our attendees would independently discover the solutions and fit them into their code editor. 

I think the exercise was mostly successful, but had some important lessons for future workshop design if we want to stick it. 

## Meeting Flow

 After Leo took five minutes or so to introduce the topic, we basically just set them loose and wandered around to answer questions, then took about 15 minutes at the end of the meeting to demo. Our club is mostly comprised of local middle schoolers from the nearby Shelburne Community School, which is walking distance from the library. This meeting had our best attendence to date, but we have a recurring issue of people arriving without laptops or bringing iPads. This did result in at least one fruitful collaboration though, as two girls shared a laptop and ended up assembling one of the more interesting projects on it, this funky rippling circle: 

![ripplingcircle](https://user-images.githubusercontent.com/27078897/141187679-e590c98e-a77d-4e5c-a90b-ede29793b919.gif)

 This was also our first meeting that made use of Leo's live editor for Hack Club, instead of Replit. We found that Replit tends to overcomplicate things, occasionally bugs out, and generally offers less control over the experience. Attendees defaulted to Replit initially out of habit, but most switched to the live editor in the course of the meeting. It also makes it easier to save and share example projects, which is a feature we hope to make standard in future workshop design. 

<img width="1670" alt="liveeditor" src="https://user-images.githubusercontent.com/27078897/141187834-8bfe8386-45d0-412e-8a5f-6620ddd64b1b.png">

 The energy of the meeting was a little different than previous ones - there was a lot of confusion and requests for help, and it was a little quieter and more focused. Surprisingly no one seemed totally frustrated or resigned, though a few didn't really end up doing much. As usual I didn't prove to be terribly helpful with solving code problems, having barely figured it out myself the day before. However I did somewhat enjoy being so useless as it only reinforced to the attendees that they needed to figure it out themselves. 

 When it became clear that time was running out I did hear a few people ask whether they could keep working on their projects at home, which was heartening. I suppose we'll see this week if they actually did, but nevertheless it was the right sentiment. We want our meetings to be a point of entry rather than the entire activity. 

 About 7 people or so demoed projects at the end, roughly half of the attendees. No one was able to get the ball to change color randomly, but many were able to get it moving across the canvas and bump off the edges, which required some use of variables. 


 ## Conclusions 

In general we were pleased that our club members rose to the challenge of doing 'real' coding, and seemed to find the activity gratifying. We did encounter some issues with the "just Google it" learning approach that are worth considering though; most notably, they would often get sidetracked on irrelevant pages or otherwise imported unhelpful code to solve problems. However there were some cases where following the suggested search queries led them to the correct answer. There are aspects to this which I find useful though, as it shows how hard it is to find what you're looking for, and the importance of good search terms. 

There was also a general bottleneck when arriving at the "move the circle" stage, which required some intervention by Leo and Max. When one club member was able to get it working though I did notice that a few others were able to successfully work off of his example. This was an intended outcome, although we found that most generally didn't use the shared notepad to report their progress/give hints to the others.  In general our club seems to barely read any of the workshop write up unless heavily prompted by us, which is likely due to their younger age. 

Moving forward, we are hoping to double down on the minimalist exposition of the reverse workshops by using even less text and scaffolding, instead presenting compatible code snippets with very little explanation and having the attendees try to piece them together and mess with the parameters. We also found that the delight in making colorful outputs was a positive motivator, so we hope to do more around making art with accessible code. 


