# Field Report 

### Leader: Leo McElroy
### Workshop: Generative Art 
### Location: Pierson Library, Shelburne VT
### Date: Thursday, Nov. 11th 2021 
### Attendence: 20 
### Written by: Tevan Goldberg

![11/11 meeting](https://cloud-675c4j3rq-hack-club-bot.vercel.app/2img_14fb77f25dac-1.jpeg)

## Overview

Our club is clearly starting to get popular in the local area as we struggled to fit everyone in the room this week! The fact that it was a holiday probably increased attendence further. The mood was somewhat chaotic but settled into a productive hum by the end, especially since some people left early. 

 This week featured another new workshop concept that built on the basic 'reverse workshop' premise from the prior week. The main structural change was moving from providing search query prompts (the "just Google it" approach) to a page of copyable code snippets which could be combined to produce geometric delights on JS canvas. 

 I was personally quite pleased with many of the results, as well as the vibe of the meeting. While a minority of attendees still didn't fully participate in the workshop, those that did seemed to get a lot out of it. 



## Meeting Flow

There was some initial confusion as to whether our club would meet in the library on Veteran's Day, but somehow that didn't ultimately dissuade anyone from coming. I was actually kind of touched to recieve so many emails from our club members asking if the meeting was still on. 

Leo threw on a pretty sample output of the workshop on the big monitor before the meeting, which piqued interest in the topic. Getting everyone on task was challenging at first, especially because the link to begin (hack.af/lib) was only verbally communicated in a loud room, and didn't work for a few minutes. The WiFi was also a little strained from all the connections. 

By about ten minutes in we were more on track, although I was still busy getting people onto the correct pages for over 30 minutes. Like with the last reverse workshop there was some confusion and resistance at first, which gave way to excitement once the basic workshop mechanics were deciphered. The key once again was encouraging close reading of the example code, which looked like this:

![codesnippet](https://cloud-675c4j3rq-hack-club-bot.vercel.app/3screen_shot_2021-11-15_at_2.34.03_pm.png)


 Most people began by copying and pasting the snippets wholesale into the editor, which resulted in many redundant lines. Getting them to think more precisely about fitting them together and finding the differences/similarities between each example worked pretty well. 

Here are some of the notable outputs from the meeting: 

![rainbow](https://cloud-675c4j3rq-hack-club-bot.vercel.app/0screen_shot_2021-11-15_at_1.11.10_pm.png)

![flower_of_lines](https://cloud-675c4j3rq-hack-club-bot.vercel.app/1screen_shot_2021-11-15_at_1.11.32_pm.png)

![rainbowdots](https://cloud-61tmjabiu-hack-club-bot.vercel.app/0screen_shot_2021-11-15_at_3.06.33_pm.png)

Pretty groovy for 1 hour of intro JavaScript huh? 

The major breakthrough needed to achieve our generative artworks was utilizing the `step` command, which Leo subtly introduced to one club member, Charlie, who then passed it on to others. I suspected that they wouldn't have intuited it otherwise (I couldn't). In general our 'teaching' style for these meetings, like the workshop write-up, is pretty minimalist. We just walk around and talk to them if/when they get stuck. I think this is mostly fine, although there were times where it might have been more efficient to interrupt the meeting to show one thing like `step`, then let them run with that. This might reduce the setup time and increase experimentation. 

We continue to have a few attendees who seem uninterested in following the workshops. In some cases they prefer to simply work on pre-existing projects more relevant to them, while some just hang out and play computer games. We don't necessarily have a problem with this, especially considering this is all voluntary anyway, but I do wonder if there's a better way to reach them.

Attendence declined over the course of the meeting back down to a more managable number, most of them familiar characters from the last few weeks. This group is starting to feel a little more cohesive and motivated. We had about 8 presenters at the end. Not everyone figured out how to generate the full canvases but I felt that morale was pretty good despite that. One attendee, Zoe, even asked for homework at the end!


## Conclusions 

It still remains to be seen how replicable our results are when Leo is not in the room, but we both felt this meeting to be our best yet in terms of of attendence and output quality. The utility of having a local Hack Club is becoming manifest now. As a code novice I found the workshop design simple to understand since it was just reading, copying, tinkering, and had more producutive interactions with our club members for that reason. Taking the artistic approach is useful because it makes code more subjective and personally meaningful, and results in these beautiful sharable images. 

We're aware that a lot more has to happen before our club members are truly coding on their own. Not having a good answer for "can I have homework" has led to us to thinking about a workshop design that would incentivize independent study outside of the meeting. We also need to try harder to engage our repeat attendees that don't do the workshops and find out why they don't. 

Finally, I think we need to work on owning the attention space more at the beginning of the meeting. Demanding order in a room full of middle schoolers is tough and runs contrary to our style a bit, but it's worth it to avoid spending so much meeting time on person-by-person setup. 

