---
name: 'Reverse Workshop: Generative Art'
description: 'use a toolbox of examples to compose dynamic art pieces'
author: '@leomcelroy'
locales: 'es-xl'
---

# Reverse Workshop: Generative Art

Let's create something like this:

![Workshop's target project](https://cloud-7m2tx179d-hack-club-bot.vercel.app/0gif1.gif)

This is another reverse workshop, instead of telling you how to make something step-by-step I'm going to give you some inspiration and the materials you need to make it.

I recommend working in the live editor but the whole project is just an HTML file so you can use the environment you are most comfortable with. To run this meeting show your club the example target project. After that have people open up this page. Most of the workshop will be spent in the editor and on the examples page finding useful code snippets (both linked below). It's okay if people don't make the example target project exactly. It's a source of inspiration not a prescription.

This workshop is all about taking simple ideas and examples and composing them together into more interesting programs.

A few tips:

- Tell people they can only have **one** `draw` function so you'll have to take bits and pieces of each example and put them together.
- As a club leader start out the meeting by demonstrating how to put two code snippets together.
- Encourage people to read each line of the code snippets they are trying to combine. Often they can get themselves "unstuck" just by paying closer attention to details.

## Template

[A starter template can be found here.](https://hackclub.github.io/live-editor/) 

Click on "Examples" > "Canvas Starter"

<img width="1204" alt="Examples window" src="https://user-images.githubusercontent.com/27078897/141502840-742144d2-8b45-4254-8e87-d4bad254a74e.png">

## Examples

[Helpful examples can be found here.](https://hackclub.github.io/js-canvas-examples/) 

Copy code snippets from these examples to compose your drawing. 

<img width="1185" alt="Examples page" src="https://user-images.githubusercontent.com/27078897/141502874-ae243edd-2c53-46bf-a31c-d437d1a343ae.png">

If you're having trouble getting something interesting to happen you can take a look at [this example](https://hackclub.github.io/live-editor/?file=rec0dC5MA1jcNF7hP). But be **warned** it may spoil some of the fun of figuring out how to do it yourself.

## Reverse Steps

There are helpful intermediate stages shown below. Try to identify what changes from one example to the next. They are **not** instructions to follow. They are a way of thinking about what makes the original example by taking away components of that drawing one at a time. Try to identify what changes from one video to the next.

https://user-images.githubusercontent.com/27078897/141503170-06212409-a648-4576-8ebf-61810830bef4.mov

https://user-images.githubusercontent.com/27078897/141503205-86c35c00-6d90-4da5-aefe-ff2fcfa8c9c0.mov

https://user-images.githubusercontent.com/27078897/141503239-26abb376-1221-4fb2-9bf6-3e7a65d0ecb1.mov

https://user-images.githubusercontent.com/27078897/141503268-23232efb-3cb6-452a-b8da-edab8b0c7af2.mov

https://user-images.githubusercontent.com/27078897/141503316-33d9ee88-cec8-4d8f-ada8-925eb62d13ed.mov

https://user-images.githubusercontent.com/27078897/141503346-c58cb0a9-19e8-452e-aa86-dc28f37f8b3c.mov

https://user-images.githubusercontent.com/27078897/141503359-a56bd2da-e731-429a-a267-7703412f62ef.mov


