---
name: Preface
description: Read this before beginning any of the workshops
author: Hack Club staff
---

# Preface

_Adapted from [here](https://medium.freecodecamp.com/things-i-wish-someone-had-told-me-when-i-was-learning-how-to-code-565fc9dcb329)_

---

If you're reading this, that means that you've decided to embark on the journey of learning to code. Congratulations and welcome, we're excited for you. Before you get started, there are 3 things we think you should know:

## 1. Coding is Not Special

First and foremost, coding is a skill like any other. Like learning a language, there's grammar and vocabulary to acquire. Like math, there are processes to work through specific types of problems.

Like any type of craftsmanship and art-making, there are techniques and best practices that have developed over time.

Someone will always tell you you're doing it wrong. Coding problems generally have more than one solution. A lot of programmers get good at advocating for their personal preferences, but keep in mind there's more than one way to bake a cake.

## 2. It Never Works the First Time

When you first start learning to code, you'll very quickly run up against this particular experience: you think you've set up everything the way you're supposed to, you've checked and re-checked it, and it still. doesn't. work. You don't have a clue where to begin trying to fix it, and the error message (if you're lucky enough to have one at all) might as well say "this is impossible". You might be tempted to give up at this point, thinking that you'll never figure it out, that you're not cut out for this.

But this experience is so common for programmers of all skill levels that it says absolutely nothing about your intelligence, tech-savviness, or suitability for the coding life. It will happen to you as a beginner, but it will also happen to you as an experienced programmer. The main difference will be in how you respond to it.

A big difference between new coders and experienced coders is faith: faith that things are going wrong for a logical and discoverable reason, faith that problems are fixable, faith that there is a way to accomplish the goal. The path from "not working" to "working" might not be obvious, but with patience you can usually find it.

## 3. Persistence Beats the Method

There's no shortage of opinions about the "right" or "best" way to learn how to code, and there are lots of potential approaches. You can learn the concepts from a book or by completing interactive exercises or by building things on your own.

Regardless of your method, if you keep putting bricks on top of each other, it might take a long time but eventually you'll have a wall. This is where that faith mentioned earlier comes in handy. If you believe that with time and patience you can figure the whole coding thing out, in time you almost certainly will.

[Return to the workshop list](https://workshops.hackclub.com/)
