---
name: 'Jamming with Muse'
description: 'Compose music with code'
author: '@leomcelroy'
img: "https://cloud-9ltsqwncl-hack-club-bot.vercel.app/0demo.png"
locales: 'es-xl'
---

# Muse

**Think your meetings are too quiet? Not anymore 🔊!** We wanted to make a tool that would make coding in a workshop lively, interactive, and which would require very little explanation before you can get started hacking, so we made Muse.

Muse is a simple language for making music. It is embedded inside of JavaScript. You can get started with Muse as your first experience programming or you can make complicated JavaScript laced compositions if you're an audio algorithm wizard.

To get a sense of how small Muse is the sample below uses pretty much every construct in the language.

```
[ a4+ ;- c5 ;- e5 ;- ] x 2
[ a4+ ;- c5 ;- e5 ;- ] ^ 5 x 2
[ a4+ ;- c5 ;- e5 ;- ] _ 3 x 2
```

For a quick introduction to Muse you can watch [this video](https://youtu.be/hAcQ2x1PTYM).

For more documentation refer to the [GitHub repository](https://github.com/hackclub/muse).

[Launch the editor here](https://muse.hackclub.dev/) or by clicking the image below.

[![muse editor](https://cloud-9ltsqwncl-hack-club-bot.vercel.app/0demo.png)](https://muse.hackclub.dev/)

Here are some slightly more involved pieces which will give you a sense of some things you can do in Muse. 

[Fill-up Glassy](https://hackclub.github.io/muse/?file=recYJJltQstKbefwZ) is an example that uses only synthesized sounds.

[Samples in the Klerb](https://hackclub.github.io/muse/?file=recwU2R3A0KfL11Ka) is an example that uses only samples.


Of course you can mix synthesized sounds and samples (and add your own samples)!

## Tips on composing your first song

**Think small, then repeat.** Most music (and code) is composed of repetitive chunks that combine to make more elaborate structures. This approach to composing works quite well in Muse, and will save you some typing! Start with a cell like [c4; e4; g4; e4;], then multiply it. The Starter template in Examples also has key bindings for notes, which allows you to sketch out ideas before you write them down. 

**Layer sounds.** Once you have a musical idea you like, try writing more `createMuse` functions to complement it. You can write as many as you want! Try creating a beat with the samples, change the synthesizer (e.g sine, sawtooth, piano, etc), or throw in a bassline by writing in a lower octave.

**Keep track of your beats.** Running multiple functions will quickly dissolve into chaos without careful timing. Make use of the pause symbol (;) to ensure everything is coming in and out at the right time. Using even numbers of beats makes this process easier, but anything works as long as you’re consistent - try a song based on multiples of 13! 

**Progress vertically.** Most songs are built around a repeated chord progression. You can build chords in Muse by stacking individual notes like so: `[c4 e4 g4 b4;]`. Experiment with unexpected combinations and durations of notes to craft a unique harmony. 

We often compose by first finding sounds we like while playing keys. We then copy the notes from the console and add pauses. Try offsetting the notes to form chords (offsetting by 5 has nice consonance).

In order for the key bindings to work you have to run the program. When you first load the page the keys won't make any sound until you hit "play/attach".

## Running Muse as a club meeting

If you're running Muse in your club as a workshop we recommend showing the introduction video and listening to some examples of what other people have made in Muse. After that let people get started playing on their own. If possible try to play the music out loud so every one can overhear each other's songs.

## How does it work?

Muse makes use of some really interesting techniques and technologies. Digging into the codebase you can learn about parsers (specifically [parser combinators](https://fsharpforfunandprofit.com/posts/understanding-parser-combinators/)), [language grammars](https://en.wikipedia.org/wiki/Backus%E2%80%93Naur_form), [compilers](https://en.wikipedia.org/wiki/Compilers:_Principles,_Techniques,_and_Tools), [tagged template literals](https://patelhemil.medium.com/magic-of-tagged-templates-literals-in-javascript-e0e2379b1ffc), the [Web Audio API](https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API), RegEx, and a whole lot more. Of course you don't need to deal with any of this to use Muse!

## Sharing Your Muse Song

We'd love to hear what you made in Muse. To share your song with the Hack Club community join the ship channel in the Hack Club Slack and submit the link generated by pressing the share button.

![share button](https://cloud-9ltsqwncl-hack-club-bot.vercel.app/1share.png)

You can also pop the link into the sharing input box shown below!
