---
name: Emailing Mentors
description: Reach out to your heroes
author: '@SamNChiet'
---

# A Pocket Guide to Mailing A Mentor

## Getting Started

### How to Choose a Mentor

So who do you want to contact? You usually want to choose someone whose work you look up to, and fits the following criteria:

1. Their work has personally affected you in some way
2. They have an open door to contact (a public twitter, they share their contact info at the end of talks they give, they give an email on the about page of their website, etc)
3. Ideally they're in your area, or you're in theirs!

Still don't have someone specific in mind? No need to worry - the internet has your back. There are plenty of public mentor lists filled with people willing to help from all fields. [Check this out to get started!](http://stephaniehurlburt.com/blog/2016/11/14/list-of-engineers-willing-to-mentor-you)

Before you email, give some thought to what you want to know from this person!
Brainstorm a few questions you want to ask! It helps to have a clear idea of what you're getting into. I made a list on a piece of paper.

## Writing that Electronic Mail

### Writing the Email

You know who you want to talk to, and now it's time to do start reaching out. This is the scariest part of the process. But there's a logic to it!

The basic structure goes:

- Introduce yourself
- Why them? How do you know their work, and what is it about their stuff that compelled you to email them? Don't be afraid to lay on the compliments, but if you're going to say something, mean it! Be sincere!
- Say a few things you've done and are currently doing - keep it around three! As a general rule, ensure the projects you mention are relevant to the person you're contacting.
- If you're not on social media, let them know how you got their email!
- Make the request - ask them to go get coffee or lunch.
- Gracefully farewell!

Not too complicated! And as an example...

I'm going to break down an email I wrote to Jason Gregory, the lead programmer at Naughty Dog. I'll split it into six parts based on the list above and talk a little about each one.

---

The artifact:
![This is an image of my email to Jason](https://cdn.discordapp.com/attachments/239737791225790464/459533405936156672/unknown.png)

Now let's start from the start.

1. **Greeting**  
   _Hi Jason!
   I'm a high school student in Los Angeles and completely enamored with game programming. I've been following your work for a while and - I hope this isn't weird to say - you're a bit of a personal hero to me._

   This part's simple, you're just saying their name and giving an overview of your link to them!

---

2.  **How I know you/got your email**  
    _Your book, Game Engine Architecture, was huge for me..._

    This part's important - if you're emailing them directly, you should drop in how you actually found that email! In this case, Jason posted his email on the website for his book, so mentioning that I know him through said book will cover it.

    Next paragraph...

---

3. **How your work has affected me (why did I email you specifically?)**  
   _Your book, Game Engine Architecture, was huge for me - I read it cover-to-cover when I was 15. Then there's the engine work being done at Naughty Dog, which is completely amazing and has inspired me to keep pushing my understanding of what's possible with hardware._

   It should be clear, but Jason has had a pretty significant impact on my programming career.
   Don't be afraid to lay on the compliments. Programmers can be distant with praise and lavish with criticism, so avoid that trap!
   But also, be earnest about your praise. If you're making stuff up it's going to come through.
   In Zach's wise words via Slack…

   > ...  
   > make sure to lay on the compliments  
   > [the person you're emailing] doesn't know you yet, so you need to work twice as hard to communicate what you're trying to
   > but also stay genuine  
   > if you feel like you're pushing the envelope of what you can honestly say, don't say it  
   > programmers tend to be terrible fraudsters

---

5. **What you do!**  
   _I'm currently working on various small learning projects using Vulkan, writing a Game Boy programming library, and I'm *planning* on doing PS2 homebrew just as soon as I can figure out how to get my hands on a console (ProcGen could be fun with VUs, once I figure out how to work them)!_

   This just boils down to "I'm working on/learning A, B, C." Super simple! Don't write a novel here - you're not pitching an investor, you're just trying to give them a rapid overview of what you're about.
   2 things to keep in mind:

   1. This shows the person you're emailing that that you're motivated and putting in work to learn things on your own.
   2. Unless you're trying to make a point about how diverse you are, try and keep your list relevant to the domain of the person you're emailing, and the area of knowledge you're asking about.

   > For me, what made my list worth mentioning:
   >
   > - Vulkan is modern graphics programming
   > - Game Boy engine programming is low-level game systems stuff. It's got 'neat' factor too.
   > - PS2 is also more fun low-level game systems stuff, and Jason worked on PS2 titles in addition to writing about them in his book.
   >
   > I wouldn't mention, say, my limited network programming experience because it's not super relevant!

---

5.  **The Ask**  
    _I know this is a bit of a long shot, but is there any chance you would be willing to offer an hour of your time to offer some career advice to me? It would mean the world to me to have lunch together. I'm pretty flexible schedule-wise!_

    This is the scary part. Be humble, and show that you respect their time! Be clear on what you want to ask [I asked for some career advice -> an hour for lunch]. They are doing you a favor and you should be accommodating to that [be flexible schedule-wise].

---

6. **The Closer**  
   _Best,
   Sam_

   And you're done.

---

That's it! All the ingredients to a successful email!

Here are a few more tips on writing a good email from people who are _not_ me!

- Don't write a book!
- Don't be selling.
- You want to get yourself across as quickly as possible. Don't send a one-sentence rush job, but respect their time! Be succinct.
- Keep it appropriate, for whatever that means for your situation.
- Obvious one, leave the slang, ego, and swearing at the door, and be respectful of the other person.

---

## Yes, you can do this.

"I'm not good enough to warrant meeting with this person yet. Maybe when I'm better..."
"This is terrifying!" I hear you say. "Besides, they'll probably say no."

This kind of talk almost kept me from sending that email. But I'm really glad I did.

Yes, you can do this.

It's not as scary as it first seems. Chances are, whomever you're emailing has done this kind of thing before and will be happy to talk to you. They know what it's like to be a beginner and seek advice from experienced developers, those who fought through the rough and 'made it'. People in the industry are generally nice and willing to help, so keep your chin up and carry yourself with confidence!
