# Hack Club

## Organization

### Organization name:

Hack Club

### Organization URL, if any:

https://hackclub.com

### If you have a demo, what's the URL? For non-software, demo can be a video. (Please don't password protect it; just use an obscure URL.)

N/A

### Describe your organization in 50 characters or less.

Nonprofit high school coding club franchise

### What will your organization do?

Hack Club is a nonprofit network of student-led high school coding clubs that teach beginners how to code.

It works like a franchise. We provide high schoolers with a "club in a box" that includes a brand, club structure, leadership guidelines, and content for meetings. We also provide an online community and one-on-one mentoring to support clubs as they grow.

The typical Hack Club is led by 2-3 students, has 15-20 members, and meets weekly after-school for 1.5 hours. Meetings resemble mini-hackathons, where students learn to code by building self-directed projects.

### Which category best applies to your organization?

Education

### Where do you live now, and where would the organization be based after YC?

SF, SF

## Contact

### Email address of the founder who is filling out this application:

zach@hackclub.com

### Phone number(s):

[redacted]

## Founders

### Please enter the URL of a 1 minute unlisted (not private) YouTube video introducing the founders. (Follow the [Video Guidelines](https://www.ycombinator.com/video/).)

[redacted]

### Please tell us about an interesting project, preferably outside of class or work, that two or more of you created together. Include URLs if possible.

When Hack Club was first getting started, we wrote a script that automatically exploited referral codes across multiple services to order food, delivery included, for less than \$2 per meal to cut costs.

We even had a regional manager from one of the companies we were ordering through reach out and, after having lunch with us, encourage us to continue using the script.

### How long have the founders known one another and how did you meet? Have any of the founders not met in person?

N/A

## Progress

### How far along are you?

Hack Club started as a series of curriculum experiments before we formalized the process for starting clubs in January 2016. We reached out to 100 students in our network and grew to 82 schools in just five months.

The subsequent school year, from September 2016 - June 2017, we moved out of spreadsheets, started doing automated data collection, and grew from 82 to 160 high schools.

Today, in October 2017, we're in 186 high schools across 25 states and 13 countries.

### How long have each of you been working on this? Have you been part-time or full-time? Please explain.

I've been working on Hack Club full-time since October 2014.

### Which of the following best describes your progress?

Launched

### When will you have a prototype or beta?

N/A (launched)

### How many active users or customers do you have? If you have some particularly valuable customers, who are they?

2,500 students in clubs and 300 club leaders.

I'm particularly proud of Athul Blesson, one of our leaders in India. He's the first person in [redacted link].

### Do you have revenue?

No

### What was your revenue in the last full calendar month? (Please use USD. If none, enter '0')

N/A

### Your revenue 2 months ago?

N/A

### Your revenue 3 months ago?

N/A

### Your revenue 4 months ago?

N/A

### Your revenue 5 months ago?

N/A

### Your revenue 6 months ago?

N/A

### Do you generate direct program revenue or does it comes from donors? If both, what's the split?

All revenue is currently from donors.

### How much money do you spend per month?

5000

### How much money does your company have in the bank now?

18319.04

### How long is your runway? (e.g. 5 months)

3 months

### If you've applied previously with the same idea, how much progress have you made since the last time you applied? Anything change?

- We doubled in size, from 90 clubs to 186
- We started tracking per-meeting attendance with a Slack bot (screenshot: https://cloud-pdsvvm06t-hack-club-bot.vercel.app/0w8qr2Re.png) and significantly tightened the criteria for what qualifies as an active club – we had to kill a lot of clubs as part of this
- We received our own 501(c)(3) status

If you have already participated or committed to participate in an incubator, "accelerator" or "pre-accelerator" program, please tell us about it.

We participated in the Fast Forward nonprofit accelerator the summer of 2016. It helped us learn more about building a fundraising strategy and enabled the funding that's carried us through today.

## Idea

### Why did you pick this idea to work on? Do you have domain expertise in this area? How do you know this is going to work?

From an early age, I bought into the idea that you can find meaning and fulfillment in life through education. But growing up, I always found myself leaving school tired and frustrated because it felt like I was just memorizing information for someone else.

School reform isn't a new idea and has been tried countless times, but everything seems to fail for the same reasons – they either fail to get buy-in from the myriad of decision makers in schools (New Math, Common Core, big policy changes), become so warped that by the time they reach students they no longer accomplish their stated goals (Seymour Papert, lots of education research, technology in the classroom), or ultimately lack a path to changing the public school experience (charter schools).

With Hack Club, I think we have something different. Our clubs are low-cost, easy to start, scalable, have very promising early outcomes, and can realistically reach every public high school in America – in fact, we're already in 1%.

Most importantly, we have a clear path towards scaling Hack Club beyond clubs: just make it part of the school day. We've already had schools approach us about this.

Today, Hack Club is building a movement of students who are creating the classes they wish they had. Tomorrow, Hack Club is starting a dialogue around how these student-led classes are resulting in better outcomes than their traditional alternatives. Next week, classes are being modeled after Hack Clubs. Next year, it's not just about coding – it's about learning as a whole.

Hack Club is working and I think it will continue to grow because:

1. Our student-led franchise model is not new and has been done at scale for nearly every other subject besides coding (see Key Club, Science Olympiad, FIRST Robotics, Lion's Club, DECA, etc).
2. Talented high school coders that are qualified to lead Hack Club chapters exist, but aren't being utilized. I know this because I ran the largest high school developer community with over 5,000 high schoolers involved. If every single one of them started a Hack Club, we'd be in 1/4th of the US's high schools.
3. Coding isn't something that only the nerds do anymore. Students want to learn to code and existing CS classes aren't satisfying the need. They're eager to join Hack Clubs because they want to learn to build real things—like apps—quickly, something you won't find in most CS classes. We've had clubs where >100 people have shown up to meetings.

### What's new about what you plan to do?

Instead of taking a top-down approach to reform, we're going grassroots and bottom-up, allowing us to have an in-person program in 186 high schools with only 3 staff.

Since Hack Club is just students starting extracurricular clubs, there's virtually no red tape involved in bringing the program to schools. We don't need policymaker, administration, or even faculty buy-in – nearly every high school has an existing clubs program and due to the Equal Access Act, schools literally can't say no.

### Who else works in your space, and who might in the future?

Key Club, Science Olympiad, FIRST Robotics, Lion's Club, DECA, and Rotary's Interact are all programs that follow the franchised student-led model and have programs that have been around for decades.

There aren't too many new clubs programs. http://www.launchx.com/ is getting started for entrepreneurship clubs and Girls Who Code has an after-school clubs program, but it's led by adults and is closer to a traditional class.

### What do you understand about your space that other organizations just don't get?

We drastically and systemically underestimate 14 year olds. Putting students in charge is key. Students know what students want best and when you join a club that's led by a student, you know it's not going to be anything like a class.

This is why our clubs aren't just clubs. They expand beyond the school. They build projects for their communities. They host events. This past semester, from January - June 2017, Hack Clubs hosted events that reached over 1,000 first-time coders.

### How do or will you make money? How much could you make? (We realize you can't know precisely, but give your best estimate.)

We expect to take a three-tiered approach to funding, where 1/3rd of revenue is from major gifts, 1/3rd from corporate sponsorships, and 1/3rd from program dues.

Assuming we charged $25 in dues annually, we'd expect to make $60k from dues, $60k from sponsorships, and $60k from major gifts, totaling to \$180k annually at our current size (note: this is a _very_ rough estimate and we'd need to spend a lot of time thinking through how to structure the dues).

## Formation

### Have you incorporated, or formed any legal entity (like an LLC) yet?

Yes

### What kind of entity and in what state or country was the entity formed? (e.g. Delaware C Corp)

California Public Benefit Corporation

### If you're already incorporated, when were you? If you've had funding, how much and from whom?

Incorporated June 1, 2017. Received 501(c)(3) tax-exemption January 6, 2017.

### Have you obtained your 501(c)(3) tax-exempt status yet?

Yes

### Please provide any other relevant information about the structure or formation of the company.

N/A

## Legal

### Who writes code, or does other technical work on your product? Was any of it done by a non-founder? Please explain.

We have a 3 person team, myself included, in SF that writes the majority of our code. We are an open source project and have received contributions from our students.

## Others

### If you had any other ideas you considered applying with, please list them. One may be something we've been waiting for.

N/A

### Please tell us something surprising or amusing that one of you has discovered. (The answer need not be related to your project.)

Public school buses form a larger transit network than every city's public transit combined, both in size and usage (8.8 billion trips on school buses vs. 5.2 billion trips on city transit).

## Curious

### What convinced you to apply to Y Combinator?

Mackenzie Burnett

### How did you hear about Y Combinator?

Hacker News

---

# Founder Profile

## Founder

### Name\* (Required)

Zach Latta

### Email Address\* (Required)

zach@hackclub.com

### Age

19

### Gender

Male

### City

San Francisco

### State / Province

CA

### Country

United States

## Background

### Schools, Degrees and Years of Graduation (Use a separate line for each school.)

Thiel Fellowship, 2015  
El Segundo High School, High School, N/A (tested out)

### Employers, Position / Titles and Dates (Use a separate line for each job, most recent first.)

Hack Club, Executive Director, October 2014 - Current  
Yo, Lead Backend Engineer, July 2014 - September 2014  
Run Games, Junior Programmer, February 2013 - February 2014

## Presence

### Personal website

https://zachlatta.com

### GitHub URL

https://github.com/zachlatta

### LinkedIn URL

https://www.linkedin.com/in/zachlatta

### Facebook URL

https://facebook.com/crynix

### Twitter URL

https://twitter.com/zachlatta

## Skills

### Please tell us about the time you, zachlatta, most successfully hacked some (non-computer) system to your advantage.

I hacked high school. Through exploiting a loophole in the California K-12 course credit system, I was able to combine community college and high school classes to get twice the credits in half the time, allowing me to graduate before the end of what would have been my sophomore year.

### Please tell us in one or two sentences about the most impressive thing other than this startup that you have built or achieved.

I moved out of my parent's home in Los Angeles and to the Bay Area when I was 16. The day after I moved, I was hired as the first engineer at Yo where I grew and led their engineering team during the press wave. I managed our millions of users, custom integrations for partnerships with companies like the NBA and Motorola, and led the migration from Parse to our own servers.

### Are you a technical founder? (You are a programmer or engineer who can build the product without outside assistance.)

Yes

## Commitment

### Will you move and live in the Bay Area January through March 2018, if we fund you?

Yes

### Will you commit to working exclusively on this project for the next year? (No school, no other jobs)

Yes

### Do you have any other commitments between January through March 2018 inclusive?

No.

### Do you have any commitments in the future and if so what? (e.g. finishing college, going to grad school)

No.

## Curious

### Have you been to any YC events? If so, which ones? (e.g. Startup School, University Tour, Office Hours, etc.)

Startup School 2014 & 2016
