# YC Application

hackEDU's nonprofit YC application for W16.

### Application

**Organization name**

hackEDU

**Organization URL, if any**

https://hackedu.us

**If you have an online demo, what's the URL?**

N/A

**What will your organization do?**

hackEDU helps high school students start coding clubs. We provide prospective
club leaders with open-source materials for starting clubs and with a supportive
community of leaders around the globe. Our club playbook contains facilitation
guidelines and workshops that focus on shipping cool projects in <60 minutes
(ex. https://git.io/vCsTC).

Our goal is to provide every student, regardless of ethnicity, gender, or
socioeconomic status, the opportunity to experience the joys of hacking because
we believe coding is one of the most empowering things someone can learn. If
we're able to accomplish this, not only does that mean a larger and more diverse
technology workforce, but it means living in a more empowered world where more
people create the change they want to see. And that is a world we want to live
in.

**Where do you live now, and where would the organization be based after YC?**

San Francisco, CA / San Francisco, CA

**Email address we should contact you at**

zach@hackedu.us

**Phone number(s)**

[redacted]

**Please provide an email address for each founder in the organization,
including yourself. Founders must have at least 10% equity in the company. We
will send an email to each founder to fill out additional information about
themselves.**

- zach@hackedu.us
- jonathan@hackedu.us

**Please enter the URL of a 1 minute unlisted (not private) YouTube video
introducing the founders.**

https://youtu.be/ZM-FOOCxRoI

**Please tell us about an interesting project, preferably outside of class or
work, that two or more of you created together. Include URLs if possible.**

We wrote a script that automatically exploits referral codes to order food with
delivery for less than \$2 per meal. We used it nearly every weekday from
November 2014 to June 2015 to cut costs.

**How long have the founders known one another and how did you meet? Have any
of the founders not met in person?**

We've known each other since September 2014 (13 months) and have been living
together since November 2014 (11 months). We met after a mutual friend
introduced Zach, who had just won PennApps, the University of Pennsylvania's
hackathon, to Jonathan, who was a former lead organizer of PennApps.

**How far along are you?**

We've launched and are in 47 schools across 11 states and 4 countries, reaching
1500 high school students. 32% of our members are female (nearly 2x the national
average) and 37% are minorities in tech (7x industry average).

**If you've already started working on it, how long have you been working and
how many lines of code (if applicable) have you written?**

We've been working on hackEDU full-time for 12 months.

- Lines of Markdown: 31,199 across 348 files (148,653 words)
- Lines of code: 12,333 (excludes 2113 blank lines)
  - This comes from the code in our workshops and various pieces of software
    we've written to manage our clubs

**Which of the following best describes your progress?**

- [ ] Nothing Built
- [ ] Sketches
- [ ] Mocks / Renderings
- [ ] Prototype
- [ ] Private Beta
- [ ] Public Beta
- [ ] Taking Preorders
- [x] Launched

**Do you have revenue?**

- [ ] No
- [x] Yes

**How much revenue?**

\$91,715.00 in contributions from foundations and individuals in 2015

**If you've applied previously with the same idea, how much progress have you
made since the last time you applied? Anything change?**

- Onboarded 11 more schools, bringing our total reach to 47 schools in 11 states
  and 4 countries (1,500 students)
- Added 36 schools from 10 states and two countries to our waitlist. We'll begin
  onboarding them in January 2016.
- Hired Dave Fontenot as our Director of Community, bringing the total team size
  to four people (more about him in the domain expertise section)
- Secured an additional \$80,000 in contributions

In addition to the above, and perhaps our largest development, we ran a summer
camp and used it to successfully build a prototype of our club playbook. Here's
what one participant had to say about the camp (grammar in quote is corrected):

> "It is an understatement to say that hackEDU is one of those experiences that
> impacted my life. There's a strict, obvious contrast with high school: a place
> full of judgment, an environment that devalues creative freedom, an atmosphere
> so lonely with constant glorification of useless issues. It is such a
> wonderful thing to know a place so different from that exists."

Initially we experimented with combinations of lectures, videos, and websites
like CodeHS and Treehouse, but found that students weren't engaged because they
weren't finishing exciting projects in single sittings. About halfway through
Hack Camp we created our own written workshops that focused on shipping cool
projects quickly. Engagement skyrocketed. We're now using this workshop format
in our club playbook and have heard from leaders that members are similarly
engaged.

**If you have already participated or committed to participate in an incubator,
"accelerator" or "pre-accelerator" program, please tell us about it.**

No.

**Why did you pick this idea to work on? Do you have domain expertise in this
area? How do you know this is going to work?**

When Zach was in high school he wanted a community where he could build things
with others, so he started a coding club. By the club's second year, he and his
classmates did things they didn't previously believe were possible: they
launched games on the Android Play Store, won high-profile hackathons, and
founded a web design firm.

However, the club was not without its problems and after meeting other high
school students who started clubs and ran into similar issues, he started
hackEDU to fix them.

We think this is going to work because we high school students are already
starting clubs without our support and failing for the same reasons: they lack
curriculum suited for a club, they're not sure how to create an environment that
facilitates hacking, and they lack a community supporting what they do bigger
than their school. We've been able to help our clubs solve all three with our
club playbook and community

Our team has a significant amount of experience building curriculum and
communities:

- Zach runs HS Hackers, a Facebook group for high school developers that engages
  over 5,000 high schoolers that go to over 1,000 schools from all 50 states and
  over 100 countries worldwide.
- Jonathan has over 4 years of curriculum design and teaching experience and
  previously was a lead organizer of PennApps, one of the largest hackathons in
  the world.
- We recently brought on Dave Fontenot to be our Director of Community. Dave
  previously started MHacks, the largest hackathon in the world, and was key in
  bringing hackathons to colleges all around the globe: 50,000 people will
  attend collegiate hackathons by the end of this year compared to the estimated
  500 attendees at the end of 2011.
  - In addition to MHacks, he started Hackathon Hackers, the Facebook group for
    the hackathon community. It now has over 18,000 members and over 300,000
    posts were made in the past year.

**What's new about what you plan to do?**

Two things: (1) high school students lead our clubs, not us, and (2) we think we
will be able to build better content by being open source.

1. Many other initiatives in our space, including Girls Who Code, ScriptEd, and
   CodeNow, run in-person programs that require finding a location, recruiting
   volunteers, and hiring instructors. Instead of doing the legwork ourselves,
   we provide a playbook that enables students to start their own clubs. And
   since they're just regular student-led school clubs, our leaders don't need
   to find their own space (the school is their space), recruit external
   volunteers (their friends are volunteers), or hire teachers (they teach using
   our pre-written workshops). This model makes the cost of starting a new club
   virtually \$0 from our end and we think it'll let us scale where others
   haven't.
2. While many other initiatives, like Girls Who Code, believe in the power of
   intellectual property, we believe we can build better materials if everyone
   is part of the conversation and contributing from the beginning. We're open
   source with everything from our club playbook[0] to our financials[1] on our
   GitHub (even this application was created in a pull request[2]) As a result
   of this, we've already seen club leaders contributing workshops and have
   received curriculum contributions from people not involved in our clubs.

[0] https://github.com/hackedu/hackedu
[1] https://github.com/hackedu/finances
[2] https://github.com/hackedu/meta/pull/201

**Have you incorporated, or formed any legal entity (like an LLC) yet?**

Yes.

**What kind of entity and in what state or country was the entity formed?**

Delaware non-stock non-profit corporation.

**If you're already incorporated, when were you? If you've had funding, how
much and from whom?**

hackEDU was incorporated in January 2014. We've secured \$91,715.00 in
contributions from the following (sorted alphabetically):

[redacted]

**Have you obtained your 501(c)(3) tax-exempt status yet?**

No.

**Please provide any other relevant information about the structure or
formation of the company.**

We have partnered with Mission Bit (http://www.missionbit.com/) as our fiscal
sponsor with a 3% fee (industry standard is 7-12%).

**Are any of the following true?**

- You are the only founder.
- You are a student who may return to school when the next term starts.
- Half or more of your group can't move to the Bay Area.
- One or more founders will keep their current jobs.

- [ ] Yes
- [x] No

**If you had any other ideas you considered applying with, please list them.
One may be something we've been waiting for.**

**Please tell us something surprising or amusing that one of you has
discovered. (The answer need not be related to your project.)**

`fortune | cowsay | lolcat` speaks volumes of truth.

**What convinced you to apply to Y Combinator?**

Engaging with the community on Hacker News, meeting partners, and meeting YC
founders, some of whom encouraged us and helped us apply (thank you!).

**How did you hear about Y Combinator?**

Alonzo Church's PhD thesis (just kidding, Hacker News)

### Founder Profiles

#### Zach Latta

**Name**

Zach Latta

**Email Address**

zach@hackedu.us

**Age**

17 (I'll be 18 when the W16 batch starts)

**Gender**

Male

**Schools, Degrees and Years of Graduation**

- Thiel Fellowship, 2015
- El Segundo High School, High School, N/A (tested out)
- West Los Angeles College, Worked towards my AS in computer science, N/A

**Employers, Position / Titles and Dates**

- hackEDU, Executive Director, October 2014 - Current
- Yo, Lead Backend Engineer, July 2014 - September 2014
- Grasp, Technical Lead, June 2013 - January 2014
- Run Games, Junior Programmer, February 2013 - February 2014

**Personal website**

https://zachlatta.com

**GitHub URL**

https://github.com/zachlatta

**LinkedIn URL**

https://www.linkedin.com/in/zachlatta

**Facebook URL**

https://facebook.com/crynix

**Twitter URL**

https://twitter.com/zachlatta

**Please tell us about the time you most successfully hacked some
(non-computer) system to your advantage.**

I hacked my high school education. I exploited a loophole in the California K-12
education system to get twice the credits in half the time. College credits
count for twice the amount of high school credits and for core classes, like
language, count for four times the credits. By taking college level classes
full-time, I could have graduated in two years---but I ended up testing out
anyway in one and a half instead.

**Please tell us in one or two sentences about the most impressive thing other
than this startup that you have built or achieved.**

I moved out of my parent's home in Los Angeles and to the Bay Area when I
was 16. The day after I moved I was hired as the first engineer at Yo where I
grew and led their engineering team during the massive press wave. I managed our
millions of users, custom integrations for partnerships with big names like the
NBA and Motorola, and led the migration from Parse to our own servers.

**Will you live in the Bay Area June through August 2015, if we fund you?**

Yes.

**Will you commit to working exclusively on this project for the next year?**

Yes.

**Do you have any other commitments between June through August 2015
inclusive?**

No.

**Do you have any commitments in the future and if so what?**

No.

#### Jonathan Leung

**Name**

Jonathan Leung

**Email Address**

jonathan@hackedu.us

**Age**

24

**Gender**

Male

**Schools, Degrees and Years of Graduation**

University of Pennsylvania, Bachelor of Science in Computer Engineering, 2013  
The Haverford School, High School, 2009

**Employers, Position / Titles and Dates**

PennApps  
Lead Organizer  
2010 - 2012

All Star Code  
Curriculum Developer And Facilitator  
Mar - Aug 2014

General Assembly  
Instructor for the 12-Week Ruby on Rails Course  
Sep - Dec 2013

Perceptual Networks  
Full Stack Intern  
Jun - Aug 2012

Learners' House  
http://learnershouse.org  
Creator  
Dec 28 - Jan 7, 2014

Gobbler  
Full Stack Intern  
Jun - Aug 2011

**Personal website**

http://jonl.org/

**GitHub URL**

https://github.com/jonleung

**LinkedIn URL**

https://www.linkedin.com/in/jonathanjleung

**Facebook URL**

http://fb.jonl.org

**Twitter URL**

https://twitter.com/jonathanjleung

**Please tell us about the time you most successfully hacked some
(non-computer) system to your advantage.**

I set the status quo for hackathons to provide transportation reimbursement by
hacking Megabus's perception of hackathons.

As a lead organizer of PennApps, the University of Pennsylvania's hackathon,
from 2010 - 2012, I wanted Megabus to pay for transportation. I coined the title
"official transportation sponsor" and asked if they'd be interested in
partnering at that level. They were interested but afraid of associating
themselves with the "hackers" in the news.

To alleviate their concerns, I sent them the link to the Wikipedia entry for
Hackathon--after I added this: 'Although "hack" is in the root of hackathon,
hackathons have nothing to do with malicious "hacking" done by hackers, rather
the spirit of a hackathon is to collaboratively build programs and
applications.'

Megabus subsequently agreed to sponsor, making us the first student-run
collegiate hackathon to sponsor travel for attendees.

**Please tell us in one or two sentences about the most impressive thing other
than this startup that you have built or achieved.**

As a lead organizer of PennApps, the first multi-university, student-run
hackathon, from 2010 - 2012, I helped grow it from 80 to over 1000 attendees. As
a result of the movement that PennApps started, 50,000 people will attend
collegiate hackathons by the end of 2015, compared to the estimated 500 in the
beginning of 2012.

**Will you live in the Bay Area June through August 2015, if we fund you?**

Yes.

**Will you commit to working exclusively on this project for the next year?**

Yes.

**Do you have any other commitments between June through August 2015
inclusive?**

No.

**Do you have any commitments in the future and if so what?**

No.
