# YC Application

hackEDU's nonprofit YC application for S15.

### Application

**Organization name**

hackEDU

**Organization URL, if any**

https://hackedu.us

**If you have an online demo, what's the URL?**

N/A

**What will your organization do?**

hackEDU will create a programming club at every high school in America.

We think it's tragic that students who love music can join band, students who
love sports can join an athletic team, but students who code (or might be
interested in learning) have to go home and build things alone. In our clubs we
create communities for the builders (and potential builders) in high school. We
do this through providing a "club in a box"--a "plug-and-play" framework for
high school students starting successful and autonomous clubs, which we're
currently in the process of building. The box will include club leader
training, sample projects, development tools, resources, and best practices for
high school students wanting to start clubs.

Moreover, we build and orchestrate a vibrant community between our clubs and
the larger hacking community through online social media and in-person events.

We want to create 2,500 Amy Sortos at schools around the country (keep reading
to see who she is and why this would be so amazing).

**Where do you live now, and where would the organization be based after YC?**

SF. SF.

**Email address we should contact you at**

zach@hackedu.us

**Phone number(s)**

[redacted]

**Please provide an email address for each founder in the organization,
including yourself. Founders must have at least 10% equity in the company. We
will send an email to each founder to fill out additional information about
themselves.**

- zach@hackedu.us
- jonathan@hackedu.us

**Please enter the URL of a 1 minute unlisted (not private) YouTube video
introducing the founders.**

https://youtu.be/RxdJ2zDuiV0

**Please tell us about an interesting project, preferably outside of class or
work, that two or more of you created together. Include URLs if possible.**

We wrote a script that exploits referral codes to order food and delivery for
less than \$2 per meal. We've been using it nearly every weekday since November
to cut costs.

https://github.com/zachlatta/2-dollar-dinosaurs

**How long have the founders known one another and how did you meet? Have any
of the founders not met in person?**

We've known each other since September 2014 (7 months) and have been living
together since November. We met after a mutual friend introduced Zach, who had
just won PennApps, the University of Pennsylvania's hackathon, to Jonathan, who
was a former lead organizer of PennApps.

**How far along are you?**

We're currently running a pilot with 38 schools and have reached 1300 students.
32% of our members are female (nearly 2x national average) and 37% are
minorities in tech (7x national average).

At MHacks V and PennApps X, the two largest collegiate hackathons with >1000
attendees flown in from schools including Stanford, MIT, and Harvard, half of
the winning teams were led by high school students. All of the winning high
school teams were led by a hackEDU hacker.

Running a programming club has been such an empowering experience for Amy
Sorto, one of our club leaders from New Jersey, she decided to put together a
summer camp to teach 24 girls in middle school how to code. She's already
secured a blank check from Panasonic, laptop donations from Codestarter, and a
donated venue in Newark.

Here are some of the things that our club leaders have been saying:

> hackEDU has given me the confidence and resources to lead my club. The
> students in my club have learned many skills and some students have even gone
> to hackathons and won prizes! It is an incredible feeling to know that I am
> making a difference in my school and community.

Amy Sorto  
Junior at Elizabeth High School  
Elizabeth, NJ

> This is my club's first year and it's been leaps and bounds better than
> expected. Over the course of the year our more than 80 members have made games
> and websites, participated in hackathons, and have volunteered at a local
> middle school for their hour of code. I started my club after talking to the
> hackEDU guys and can say it wouldn't be a reality if they weren't around.

Raphael Kats  
Senior at Mundelein High School  
Mundelein, IL

> Leading a hack club in Austin allowed me to start a technology community at my
> high school and make great friends while learning tons.

Luke Wright  
Junior Austin High School  
Austin, TX

> hackEDU has connected me to a network of people who have years of experience
> in the domain that I'm in. They have connected me to people and more over
> ideas on how best to do what I do, to inspire kids to build the next
> generation of technology.

Taylor Blau  
Junior at Cranbrook Schools  
Bloomfield Township, MI

**If you've already started working on it, how long have you been working and
how many lines of code (if applicable) have you written?**

We've been working on hackEDU full-time for 5 months.

**Which of the following best describes your progress?**

- [ ] Nothing Built
- [ ] Sketches
- [ ] Mocks / Renderings
- [ ] Prototype
- [x] Private Beta
- [ ] Public Beta
- [ ] Taking Preorders
- [ ] Launched

**Do you have revenue?**

- [ ] No
- [x] Yes

**If you've applied previously with the same idea, how much progress have you
made since the last time you applied? Anything change?**

Last time we applied we got the feedback that Zach's age was a worrying factor.
Since then, we've brought on Jonathan (24), to the team and have made
significant progress in shaping and working towards our vision. Both of us are
extremely committed to hackEDU and plan to work on this for a very long time,
with or without YC. Zach does not plan to go to college.

Additionally, since last applying, we:

- Ran our planned 25 school pilot (5 of the original 30 planned schools
  dropped), onboarded 13 additional schools, and reached over 1,300 students.
  - A majority of the students from every one of our 13 additional schools are
    on free or reduced lunch.
- Brought on a full-time volunteer and two part-time volunteers.

We have also secured a small amount of funding (~\$10k).

**If you have already participated or committed to participate in an incubator,
"accelerator" or "pre-accelerator" program, please tell us about it.**

We have not.

**Why did you pick this idea to work on? Do you have domain expertise in this
area? How do you know this is going to work?**

When in high school, Zach wanted a community of other people to build things
with at his school because he didn't feel a sense of belonging. He started a
programming club to create this community. By the end of its 2nd year, the
members of his club launched games on the Android Play Store, won high-profile
hackathons, founded a web design firm, and secured over \$30,000 in investment.
After meeting other high school students who had also started programming
clubs, he decided to start hackEDU to scale the model. Being 17, he is the age
of our target demographic and has made himself a leader in the high school
programming community. In addition to being an avid participant in hackathons
(over 20 this past year), Zach runs HS Hackers, the largest global online
community for high school hackers (Facebook shared a post about it to 2.3
million readers
https://www.facebookstories.com/stories/112524/building-a-community-for-high-schoolers-who-code).
HS Hackers currently has 5,000 members from over 1000 schools, nearly every
state, and over 90 countries.

Jonathan has been teaching programming since high school and helped create the
hacking movement at Penn, where he was one of the lead PennApps organizers and
grew it from 80 to >1000 hackers. Jonathan realized he cared deeply about
empowering others and began to feel how liberating the idea of "Everything
around you that you call life, was made up by people that were no smarter than
you." he couldn't help but share it. To pursue this, Jonathan taught the 12
week Ruby on Rails bootcamp at at General Assembly and most recently designed
and ran a 6 week summer immersive at All Star Code for high schoolers where he
continued to be inspired by his students.

Zach was the first person Jonathan met who was as obsessed with this as he was.
hackEDU's model of students teaching their peers speaks to his passion for
student empowerment. That's why he's all in.

**What's new about what you plan to do?**

We provide a framework that enables people to start their own clubs without
requiring us to recruit volunteers or maintain partnerships with schools.
hackEDU chapters are autonomous and led by high school students themselves.
Starting a new chapter is just as easy as creating a chess or film club
(generally a one-page form with the school and the commitment of a teacher
sponsor).

When we talked with a former employee of a comparable organization, they said
that the process of forming a partnership with a school and reaching its
students took 2-3 months of full-time work. Our model allows us to avoid all of
that work and skip the red-tape and bureaucracy of partnering with schools.
This is similar to Airbnb's model of not having hosts on staff or owning
property, allowing us to scale in-person coding education which is something we
haven't seen done before.

**Have you incorporated, or formed any legal entity (like an LLC) yet?**

Yes.

**What kind of entity and in what state or country was the entity formed?**

hackEDU is incorporated in the state of Delaware as a non-stock non-profit
corporation.

**If you're already incorporated, when were you? If you've had funding, how
much and from whom?**

HackEDU was incorporated in January of 2014. We've secured a small amount
(\$10k) of funding from various corporate sponsors and private donors.

**Have you obtained your 501(c)(3) tax-exempt status yet?**

We have not, but are in the final stages of closing a fiscal sponsor and are in
the application process.

**Please provide any other relevant information about the structure or
formation of the company.**

N/A

**Are any of the following true?**

- You are the only founder.
- You are a student who may return to school when the next term starts.
- Half or more of your group can't move to the Bay Area.
- One or more founders will keep their current jobs.

- [ ] Yes
- [x] No

**If you had any other ideas you considered applying with, please list them.
One may be something we've been waiting for.**

**Please tell us something surprising or amusing that one of you has
discovered. (The answer need not be related to your project.)**

`fortune | cowsay | lolcat` speaks volumes of truth.

**What convinced you to apply to Y Combinator?**

Engaging with the community on Hacker News and meeting several of the partners
and many YC founders, many of whom encouraged us and helped us apply.

**How did you hear about Y Combinator?**

Hacker News.

### Founder Profiles

#### Zach Latta

**Name**

Zach Latta

**Email Address**

zach@hackedu.us

**Age**

17

**Gender**

Male

**Schools, Degrees and Years of Graduation**

- El Segundo High School, 2014
- West Los Angeles College, N/A

**Employers, Position / Titles and Dates**

- Yo, Lead Backend Engineer, July 2014 - September 2014
- Grasp, Technical Lead, June 2013 - January 2014
- Run Games, Junior Programmer, February 2013 - February 2014

**Personal website**

https://zachlatta.com

**GitHub URL**

https://github.com/zachlatta

**LinkedIn URL**

https://www.linkedin.com/in/zachlatta

**Facebook URL**

https://facebook.com/crynix

**Twitter URL**

https://twitter.com/zachlatta

**Please tell us about the time you most successfully hacked some
(non-computer) system to your advantage.**

I hacked my high school education. I exploited a loophole in the California
K-12 education system to get twice the credits in half the time. College
credits count for twice the amount of high school credits and for core classes,
like language, count for four times the credits. By taking college level
classes full-time, I could have graduated in two years--but I ended up testing
out anyway in one and a half instead.

**Please tell us in one or two sentences about the most impressive thing other
than this startup that you have built or achieved.**

In my freshman year of high school, I joined Run Games as the first employee
and brought our game from an early prototype to launching in the App Store and
getting over one million users. We reached #5 in the top free charts, #1 in
games, #1 in sports, #1 in arcade, and were featured by Apple on the front page
of the App Store.

**Will you live in the Bay Area June through August 2015, if we fund you?**

Yes.

**Will you commit to working exclusively on this project for the next year?**

Yes.

**Do you have any other commitments between June through August 2015
inclusive?**

No.

**Do you have any commitments in the future and if so what?**

No.

#### Jonathan Leung

**Name**

Jonathan Leung

**Email Address**

jonathan@hackedu.us

**Age**

24

**Gender**

Male

**Schools, Degrees and Years of Graduation**

University of Pennsylvania, Bachelor of Science in Computer Engineering, 2013
The Haverford School, GED, 2009

**Employers, Position / Titles and Dates**

```
PennApps
Lead Organizer
2010 - 2012

All Star Code
Curriculum Developer And Facilitator
Mar - Aug 2014

General Assembly
Instructor for the 12-Week Ruby on Rails Course
Sep - Dec 2013

Perceptual Networks
Full Stack Intern
Jun - Aug 2012

Learners' House
learnershouse.org
Creator
Dec 28 - Jan 7, 2014

Gobbler
Full Stack Intern
Jun - Aug 2011
```

**Personal website**

http://jonl.org/

**GitHub URL**

https://github.com/jonleung

**LinkedIn URL**

www.linkedin.com/in/jonathanjleung

**Facebook URL**

http://fb.jonl.org

**Twitter URL**

https://twitter.com/jonathanjleung

**Please tell us about the time you most successfully hacked some
(non-computer) system to your advantage.**

I set the status quo for hackathons to provide transportation reimbursement by
"hacking" Megabus's perception of hackathons.

While organizing PennApps in 2011, I wanted Megabus to become our "official
transportation sponsor". They were interested but afraid of associating
themselves with the "hackers" in the news.

To alleviate their concerns, I innocently sent them the link to the Wikipedia
entry for Hackathon--after I added this: 'Although "hack" is in the root of
hackathon, hackathons have nothing to do with malicious "hacking" done by
hackers, rather the spirit of a hackathon is to collaboratively build programs
and applications.' [1]

By convincing Megabus to sponsor us by "hacking" Wikipedia page, PennApps set
the status quo for the hackathon transportation reimbursement.

[1] https://en.wikipedia.org/w/index.php?title=Hackathon&diff=442741932&oldid=437209790

**Please tell us in one or two sentences about the most impressive thing other
than this startup that you have built or achieved.**

This past summer I created and taught a curriculum that took 20 high school
students, many of whom lacked confidence, technical ability, and initiative,
and turned them into hackers. After the program, some of my students went on to
start their own non-profit that organizes hackathons in NYC, one of which
Jeremy Rossmann, founder of Make School, called "one of the best hackathons
[he's] been to".

> Jonathan, thank you for all you've taught me. Now I feel like wherever life
> takes me, I'll be more than okay.

Austin Carvey, friend and former student

**Will you live in the Bay Area June through August 2015, if we fund you?**

Yes.

**Will you commit to working exclusively on this project for the next year?**

Yes.

**Do you have any other commitments between June through August 2015
inclusive?**

No.

**Do you have any commitments in the future and if so what?**

No.
