# The Reva & David Logan Foundation Full Board Grant Proposal

## General Information

### Have you been invited by one or more of our directors to submit this?

_Full question: Have you been invited by one or more of our directors to submit
this proposal? If so, who?_

[redacted]

### Project Name

hackEDU

### Project Description

hackEDU helps high school students start coding clubs. We provide prospective
club leaders with a club playbook that outlines running a club and with a
supportive community of leaders around the globe.

Our club playbook consists of a series of workshops that focus on building and
publishing cool projects in under 60 minutes (ex. https://git.io/vCsTC) and of
suggested guidelines for how to run the day-to-day components of a club.

Our goal is to provide every student, regardless of ethnicity, gender, or
socioeconomic status, the opportunity to experience the joys of coding because
we believe coding is one of the most empowering things someone can learn. If
we're able to accomplish this, not only does that mean a larger and more diverse
technology workforce, but it means living in a more empowered world where more
people create the change they want to see. And that is a world we want to live
in.

### Amount Requested

\$75,000

### The Payment

Is this proposal:

- [x] for one year, a single payment?
- [ ] or to be paid equally over two years?
- [ ] or to be paid equally over three years?
- [ ] or is it a matching grant?
- [ ] or is it a challenge grant?
- [ ] or other. If other, please answer the question below.

### Payment Continued

If you marked other in the question above, please explain.

_N/A_

### Geographic Area

International.

### If you answered "Other" in the question above, please state the area served.

_N/A_

## In-Depth Information

### Statement of Need

The lack of access to computer science education is a national problem.
Computing jobs are growing at twice the national rate of other types of jobs
[0]. By 2020, accordingly to the Bureau of Labor Statistics, there will be 1
million more computing jobs than graduates to fill them [1].

3 in 5 STEM (science, technology, engineering, and mathematics) college students
decide to study STEM in high school [2], but only one in four high schools offer
any computer science and Black and lower-income communities have the least
access [3]. Bringing a computer science program to a school requires school and
district administrator buy-in, but less than half of the principals and
superintendents surveyed in [3] said that their school board thinks offering
computer science education is important.

We think that a low-cost program that introduces computer science education to a
school without administrator buy-in would give more students access to computer
science, and, as a result, more economic opportunity. Our clubs are low-cost,
easy to start, and equip members with the latest industry knowledge (we can do
this because we don't have to adhere to testing standards). Since our clubs are
just regular school clubs, like a chess club, our leaders don't need to find
their own space (the school is their space), recruit external volunteers (their
friends are volunteers), or hire teachers (they teach using our pre-written
workshops). This model makes the cost of starting a new club virtually \$0 and we
think it'll let us scale and reach new audiences where others haven't.

[0] https://docs.google.com/document/d/1gySkItxiJn_vwb8HIIKNXqen184mRtzDX12cux0ZgZk/pub
[1] http://www.bls.gov/opub/mlr/2012/01/art5full.pdf
[2] https://news.microsoft.com/download/archived/presskits/citizenship/docs/stemperceptionsreport.pdf
[3] https://services.google.com/fh/files/misc/searching-for-computer-science_report.pdf

### Population to be served

hackEDU's coding clubs serve high school students, aged 13-18, who are
interested in learning coding at their schools. hackEDU currently serves
approximately 1,500 students in 47 schools across 11 states and 4 countries. Of
those 1,500 students, 32% are female and 38% are black or Hispanic.

### Organization Mission and History

Our mission is to give every student the opportunity to experience the joys of
coding, regardless of their ethnicity, gender, or socioeconomic status. We
believe coding is one of the most empowering things someone can learn and if
everyone had the opportunity to learn, tomorrow's citizens would be more
empowered to create the change they want to see in the world.

We've been hard at work towards this mission and have made significant strides
forward.

Key points:

- Spring 2014: Zach Latta starts hackEDU with a 7 school pilot
- October 2014: Zach starts working on hackEDU full-time and Jonathan Leung
  joins as a founder. Pilot is expanded to 26 schools.
- April 2015: Pilot is expanded to 36 schools, reaching 1,300 students across 11
  states and 2 countries. The Reva & David Logan Foundation joins as a
  supporter.
- Summer 2015: hackEDU runs four sessions of Hack Camp, its 2 week summer
  program, to test new curriculum and a redesigned club experience. The final
  session is led by high school club leaders from a guide created during the
  previous sessions.
- September 2015: The 2015 - 2016 school year begins and our clubs start strong
  with 47 schools across 11 states and 4 countries. The Labs program starts,
  where hackEDU works with 12 clubs to redesign the club experience from the
  ground-up and build the Hack Club Playbook for all future clubs.

### Achievements and Challenges

_Tell us about your organization's achievements and challenges over the last
three years._

Key achievements:

- Grew from nothing to reaching 1,500 students across 47 schools with our clubs
  - In 11 states and 4 countries
  - 32% of club members are female (nearly 2x high school computer science
    course average [0])
  - 37% of club members are black or Hispanic (7x industry average [1])
- 48 schools are on our waitlist, which we'll begin onboarding from January 2015
- Raised \$91,715.00 in support from The Reva & David Logan Foundation, Thiel
  Capital, and individual supporters
- Mentioned in:
  - California Sunday magazine (cover story, LA Times & SF Chronicle, 400k+
    readers) [2]
  - The Today Show [3]
  - USA TODAY [4]
  - EdSurge [5]

Challenges:

- We haven't been collecting enough data regularly
  - We previously manually surveyed our club leaders to collect data, but that
    has been a time-intensive process and hasn't given us data for each
    individual meeting. We've been experimenting with software to collect
    attendance and feedback from club members, but haven't seen much success and
    are going to spend these next two weeks working towards a better solution.
- Our facilitation guidelines are weak (and often nonexistant)
  - We prioritized creating workshops over facilitation guidelines in our club
    playbook. As a result of this, most of our playbook currently consists of
    pre-written workshops. After we sort out data collection, we're going to
    improve our facilitation guidelines.
- Building our club playbook has proved more challenging and time intensive than
  originally planned
  - This goes hand-in-hand with our lack of data collection. Iterating on our
    playbook without weekly metrics to back up our work has proven difficult and
    made our iteration cycle for workshops longer than we'd like.

[0] http://b.gatech.edu/1NDopUl
[1] https://bit.ly/1Wln4Dy
[2] https://bit.ly/1Wln6vj
[3] http://on.today.com/1LZXO0O
[4] http://usat.ly/1HekFUp
[5] https://bit.ly/1MkUtsD

### Theoretical Rationale

_What's the thinking behind your mission and how do you see its evolution._

When you write code, no matter who or where you are, you have the tools and
distribution that the best engineers in the world have. The best software is
free online and you can reach millions of people at literally the touch of a
button. Having access to that power at a young age changed our lives because it
gave us a paintbrush that could impact the entire world. It gave us agency and
made us realize the world is malleable.

If we succeed, we're going to see our club members go on to work at great
companies, but that isn't our goal. Coding is special to us because we believe
that it's one of the best ways to inspire agency, not because you can get jobs
doing it. Our mission is to give every student the opportunity to experience the
joys of coding because we think everyone deserves access agency and to the
mindset that the world is malleable.

The reason we're focused on clubs is because they're low-cost, they're easy to
start, and you can build communities around them. For the foreseeable future our
goal is to focus on growing our clubs program with the aim of getting it into
every high school in the US. As we grow, we expect to throw events,
competitions, and do larger partnerships to make sure we're maximizing our reach
and impact.

### Management and Program Staff

_Who from your organization will carry out this work? Has your organization
experienced any significant staff changes in the last 12 months?_

Members of the team:

- Zach Latta :: Executive Director & Co-Founder
- Jonathan Leung :: Director of Curriculum & Co-Founder (joined October 2014)
- Max Wofford :: Technical Fellow (joined January 2015)
- Dave Fontenot :: Director of Community (joined August 2015)

Before hackEDU, Zach led the engineering team at Yo and helped launch a game
with over 1 million users on the App Store. Over 4 million people use software
he's worked on.

Jonathan has over 4 years of curriculum design and teaching experience. He was
previously a lead organizer of PennApps, one of the largest hackathons in the
world.

Prior to hackEDU, Max was in high school and has provided many insights into the
high school experience to the team.

Dave previously started MHacks, the largest hackathon in the world, and was key
in bringing hackathons to colleges all around the globe. 50,000 people will
attend hackathons by the end of 2015 (compared to the estimated 500 attendees in
2011). He also started Hackathon Hackers, the Facebook group for collegiate
hackathons, which currently has 18,000 members. Over 300,000 posts have been
made this past year in the group.

### Research and Evaluation Activities

_Studies/metrics that support your work._

Computing jobs are growing at twice the national rate of other types of jobs.
https://docs.google.com/document/d/1gySkItxiJn_vwb8HIIKNXqen184mRtzDX12cux0ZgZk/pub

By 2020 there will be 1 mill more computing jobs than graduates to fill them.
http://www.bls.gov/opub/mlr/2012/01/art5full.pdf

3 in 5 STEM college students decide to study STEM in high school. 4 in 5 decide
to study STEM before college, making high school the most important time to
capture interest.
https://news.microsoft.com/download/archived/presskits/citizenship/docs/stemperceptionsreport.pdf

Google did a survey in August 2015 to measure interest in computer science by
district. Three in four of the schools surveyed didn't have any computer
science courses and over half of the principals and superintendents surveyed
said that their school boards didn't think computer science was important. They
also found that black, Hispanic, and lower-income communities had the least
access to computer science, but wanted it the most.
https://services.google.com/fh/files/misc/searching-for-computer-science_report.pdf

### Outcomes and Goals

_What are your goals; what outcomes are you looking for?_

We want to see our club members go on to start companies, nonprofits, and, above
all else, take initiative in their lives.

We're spending the remainder of 2015 focused on building our club playbook with
the 12 clubs in our Labs program. In January 2015 we're planning to start
onboarding new schools from our waitlist with the club playbook. Our goal is to
have hackEDU in 75 schools by the end of the 2015 - 2016 school year.

### Board of Directors

_Tell us about the role your Board of Directors plays in your organization's
fundraising efforts?_

We don't currently have a board of directors, but we've been very fortunate to
grow and maintain an exceptionally talented team of advisors.

- Tom Gruber - Inventor of Siri (sold to Apple for \$200M, installed on every
  iPhone, iPod Touch, and iPad manufactured since October 2012)
- Tom Preston-Werner - Co-founder and former CEO of GitHub (valued at \$2B, over
  10M users)
- Cary Rosenzweig - Former CEO of IMVU (3M active users, brought the company to
  \$50M/year in revenue)
- Quinn Slack - Founder of Sourcegraph & Blend Labs, early employee at Palantir
- Pierre Arys - Founder of Bookneto (acquired), early employee at Addepar

Two of our advisors, Quinn Slack and Pierre Arys, have been directly involved in
our fundraising efforts, through contributing directly or making a direct
introduction to a contributor. The rest of our advisors have offered advice when
fundraising, but have not directly impacted our efforts (but have been very
helpful).

### Board List

_Please upload a list of your board members and their affiliations_

See `board_list.md` (or `board_list.pdf` if you're looking at compiled files).

### Fundraising Efforts - Individual Donors

_How do you raise money from individuals? How many individual donors do you
have? How much did your organization raise from individuals this year and in the
previous year?_

We leverage our personal network to individually reach high net worth
individuals. We currently have 6 individual donors, listed below:

- Beyang Liu (founder of Sourcegraph)
- Christina Halpern (founder of All Star Code)
- Geoff Ralston (partner at Y Combinator)
- Joe Lonsdale (founder of Palantir, Addepar, and Formation 8)
- Quinn Slack (founder of Sourcegraph)
- Will Gaybrick (general partner at Thrive Capital)

In total we've received $30,950.00 in support from individuals in 2015. In 2014
we received $0.

### Fundraising Efforts - Corporate and Foundation Giving

_Please upload a list of your corporate and foundation supporters, with giving
amounts, for this year and the previous fiscal year._

See `corporate_and_foundation_supporters.md` (or
`corporate_and_foundation_supporters.pdf` if you're looking at compiled files).

### Budgets

_Please upload operating and project budgets for last year and this year.
Budgets should include year-to-date actuals and state your fiscal year._

See `budgets.md` (or `budgets.pdf` if you're looking at compiled files).

### Audit Report

_Please upload your most recent audited financial statements._

See `audit_report.md` (or `audit_report.pdf` if you're looking at compiled
files).

### IRS Form 990

_Please upload your organization's most recent 990._

### IRS Determination Letter

_Please upload your IRS Determination Letter below._

### Key Staff Bios

_Please upload bios for key staff._

See `key_staff_bios.md` (or `key_staff_bios.pdf` if you're looking at compiled
files).

### Photo

_Please upload a photo illustrating your organization's work in `.jpg` format. A
color photo is preferred, if available._

![HS Hackers Meetup at HackingEDU](img/hackingedu_hs_hackers_meetup.jpg)

### Additional Documents

_Please upload any additional documents you'd like to share with us such as
reviews, articles, or reports._

See `attachments_preface.md` and the `attachments` directory (or
`attachments.pdf` if you're looking at compiled files).

## Feedback

### Please share any comments you have on our online grants applications process

_Full question: Please share any comments you have on our online grants
applications process. Where any questions unclear? Was the process burdensome?
If so, how?_

The requirements and expectations were very clear and the process was generally
a breeze. I had a bit of trouble answering a few of the questions (especially
putting together our budget document), but Richard was very helpful when I had
questions.
