# Fast Forward Application

Hack Club's nonprofit Fast Forward application for Summer 2016.

## Application

Note: This application uses Hack Club's AngelList profile to apply.

### About Your Founders

**Name**

Zach Latta

**Most impressive accomplishment**

I moved out of my parent's home in Los Angeles and to the Bay Area when I was 16. The day after I moved I was hired as the first engineer at Yo where I grew and led their engineering team during the massive press wave. I managed our millions of users, custom integrations for partnerships with big names like the NBA and Motorola, and led the migration from Parse to our own servers.

### About Hack Club

**Product - What are you building?**

Hack Club helps high schoolers start after-school coding clubs. We provide everything needed to start awesome clubs: content for club meetings, leadership training, our community of club leaders, and events.

Our clubs have gone on to host hackathons with hundreds of participants, build some pretty awesome projects (check out http://mhacksv.devpost.com/submissions/31699-datawave), and bring coding to traditionally underserved and underrepresented communities.

**Video - Give a link to a short (~3 minute) video of your founders presenting the opportunity.**

https://www.youtube.com/watch?v=L8M4ji46gCQ

**Who we are - How did the founders meet and how long have you been working together? How do you delineate your roles and responsibilities? Why did you choose to work together?**

I (Zach) have been programming since I was 7. When I was 16, I tested out of high school and moved to San Francisco, where I joined Yo as their first engineer. While I was there, I led their engineering team during the large press cycle (NYT, TIME, WIRED, WSJ) and built out features for partnerships with the NBA and Motorola, among others. I've been fortunate enough to be included in the 2016 Forbes 30 Under 30, Daily Dot's 20 Under 20, and I'm a recipient of the Thiel Fellowship.

**Why we're doing this - Why are you pursuing this particular idea? Do you have domain expertise in it? Have you tested it with customers? What unique insights or belief(s) do you have about this market?**

When I was in high school, I started a coding club to build the hacker community I wished existed. I got a tremendous amount of value out of the club, but we ran into a bunch of issues: we lacked curriculum, we didn't know how to create a good environment for hacking, and we weren't a part of something larger than our school. After meeting other high schoolers who also started clubs, but ran into the exact same issues, I decided to start Hack Club.

### Questions from Fast Forward

**How will your nonprofit organization improve the world? What is your plan for making this change happen? How will Fast Forward's accelerator program help you pursue this vision? Include what you hope your organization will accomplish in the next 6 months and in the next 2 years.**

Coding is a superpower that anyone can learn, and we think every student deserves the opportunity. Hack Club will improve the world by introducing coding to thousands of students that otherwise wouldn't have the opportunity.

We already have a working product and need help building a fundraising strategy and scaling our operations. Over the next six months we plan to run our summer program and launch for the 2016 - 2017 school year. We're not sure what our targets will be yet, but we think if we push for more clubs, we can reach 200 by the end of 2016. Over the next two years, we hope to bring Hack Clubs to every major continent and over 1000 schools worldwide.

**How big is the problem you're chasing? Who or what are you competing with? What competitive advantages or disadvantages do you have?**

There are 14.9 million high school students in the US, 75% of whom don't have access to coding classes. For us, it's not about beating the competition – there are still 11.2 million students without access. What matters most is finding a model that scales to fill the massive need.

There are a few other organizations in our space, including Girls Who Code, CS First, and Code Club, but none that are both in high schools and fully led by students. By having high schoolers lead the clubs, we're able to bypass the red tape typically associated with bringing computer science to a school or a community. Our leaders don't need to find their own space (the school is their space), recruit external volunteers (their friends are volunteers), or hire teachers (they teach using our pre-written workshops). This model makes the cost of starting a new club virtually \$0 from our end and we think it'll let us scale where others haven't.

**Who is your target audience? What's your strategy for reaching, acquiring, engaging, and retaining that audience?**

We have two types of users: club leaders and club members. Club leaders find us through traditional press or online, and then apply to join on our website. See https://gist.github.com/zachlatta/18918cf5c69035a3acc5b6917e849553 for an application we received a few days ago. Club members are recruited by club leaders through the school's existing club advertisement mechanisms: club posters, school-wide announcements, and school-organized "club fairs."

Clubs meet once or twice a week. The biggest challenge is retaining members during the first few meetings – after the fourth or fifth meeting, members are generally committed. Our current strategy is to make sure every club member "ships" a project by the end of each meeting, with the goal of showing complete beginners that coding isn't nearly as intimidating or difficult as it may seem. While this has worked for many clubs, we think we can do a much better job with our content.

**Please have each person tell us about a risk you've taken or challenge you've faced. How did you respond? Did you fail or succeed?**

I tested out of high school and moved from my family's home in Los Angeles to San Francisco when I was 16. To be candid, I had no idea how I'd pay rent.

The CEO of Yo asked for a meeting with me the day after I moved and he offered me a job as their lead engineer. I decided to join as a contractor for two months and lived off my savings from that for 10 months while I started Hack Club.

It's hard to say whether I failed or succeeded, since there's so much ahead. But if there's one thing that coding has taught me, it's that there are countless solutions to any given problem – whether you're building a website or getting an education. I'm currently getting joy out of my work, feeling challenged every day, and so happy that I decided to pursue this path.

**Please describe your current funding situation. What is your annual budget for this calendar year and next? Do you have any funding secured? What's your funding strategy for the next 6 months? The next 2 years?**

We raised money for the first time in 2015. So far we've raised \$165,765.00 from The Reva & David Logan Foundation, Joe Lonsdale, and other individual contributors.

We don't have a very formal annual budget, but we're currently budgeting to spend $5,000 each month (and spending slightly less than this). We currently have $90k in the bank.

We plan to continue raising money from grants and high net-worth individuals. We think pursuing lots of regional grants for cities we have clubs in may be an interesting way to create "deal flow". Our current donors have been very pleased by our progress and The Reva & David Logan Foundation has been a major repeat contributor. We think one of the ways Fast Forward could be most helpful is through helping us build our fundraising strategy.

**Finally, how did you hear about Fast Forward?**

Allyson Dias, from the Thiel Fellowship, referred me for this application cycle. I first heard about Fast Forward when talking with an intern at Feeding Forward.
