By Jack Margeson (@margeson.jack) and Ava Scherocman (@ava). 05 Aug 2019

_Originally named “Koding 4 Kidz”._

---

# Introduction

Hello! This article is about helping middle and elementary school students learn to code and how to combat some of the problems that come with. We also included what you need to know to run your first successful event for kids. It’s also an adaptation of a talk performed at the 2019 Flagship Summit!

## A little about ourselves…

Ava: I started coding my freshman year when I took a programming class. I’ve helped plan a Girl Scout day camp for elementary schoolers for 5 years, and I’ve taught at several after school classes, camps, and events focused on teaching kids to code. I love working with kids because they’re so endlessly creative! I’ve also run several hackathons and events for high school students.

Jack: I was introduced into coding through the Mason Hack Club my Sophomore year, of which I am now the Executive Director. When I was younger, I led my Boy Scout troop of 50+ children in multiple campouts and events. Teaching others to code, especially younger children, is one of my passions. Like Ava, I’ve also run several hackathons and events for older students as well.

We both go to Mason High School, and both of us joined our school’s Hack Club, the Mason Hack Club, in the fall of 2017. We’ve been teaching kids how to code as outreach ever since. Some of the events we’ve run together include Mason Hack Camp, a yearly week long coding camp for kids, and CincyHacks Jr., Mason’s first middle school hackathon.

![](https://cloud-al9r256lr.vercel.app/6img_4064.jpg)

**_Here we are looking stressed at CincyHacks Jr check-in._**

# Patience and Frustration

Everyone who ever learns to code, regardless of their age, will need instruction and guidance at first. Whether it’s a mentor, a teacher, a tutorial, or something else, everyone has to learn from somewhere; coding isn’t self-explanatory like some other skills.

We’ll all admit that coding can be frustrating sometimes. Even though it’s frustrating for everyone, coding is potentially even more frustrating for kids because of their short attention span and lack of patience. Code often doesn’t work the first time you compile it, which is a new concept to many kids. They find it hard to make mistakes, and when things don’t go right instantly, they often just want to quit.

When a student begins to become frustrated with coding, it’s your job as a teacher to help them refocus. You’re a role model to them—it’s important for them to realize that everyone makes mistakes and that you’re there to help. We like to tell our own personal stories about the first times we coded—everyone struggles at first and that’s okay.

![](https://cloud-al9r256lr.vercel.app/5pasted_image_0.jpg)

**_Young coders hard at work at CincyHacks Jr._**

Patience is the most important key to working well with younger kids—it can significantly contribute to their learning. Being there for your students when they have questions, get frustrated, or want to give up is one of the most critical tasks you have as an instructor to children. Plenty of things are going to test your patience, we promise. Often, you’ll have several kids need help at the same time, or your compiler will stop working, or the WiFi will go out—all situations beyond your control.

This is a great time to delegate tasks. If you have other volunteers helping you, you can often ask one of them to help one kid while you help another. If not, you can always tell the kid calmly, “I have to help x person at the moment because their problem came up first. Can you hang tight for a few seconds and I’ll help you as soon as I can?” Usually, kids are pretty understanding about this if you ask them nicely. They understand that you can’t do everything at once, as long as you make them aware of your intent to help them in an easy to understand manner.

# Incorporating Interests

Often, parents do that thing where they sign their kids up for any random activity because they want to get rid of them for a few hours. Doesn’t matter if the kid wants to go or not. You’ve probably been this kid and/or will have one of these kids. It’s universal.

The best way to combat frustration and/or indifference to what you’re teaching is to encourage kids to integrate their interests into what they’re doing. Our best practice in the past has been making our first activity at events a personal website workshop.

![](https://cloud-al9r256lr.vercel.app/4pasted_image_1.jpg)

**_Teaching a personal website workshop at CincyHacks Jr._**

This allows kids to make a website about whatever they want. Kids can be creatively wonderful and awesome—and it opens up a lot of cool ideas for projects. Coding is a creative outlet as much as it is a tool for learning—letting kids incorporate their interests into their projects allows them to see that there’s a fun side to coding and that there’s a reason they should continue. We’ve had students make websites about everything from Dorito Devito (Danny Devito as a Dorito) to Fartnite (a parody of Fortnite with all poop-themed locations). Every kid is excited about something outside of coding—help them find it! If a student looks stuck on what to build, we usually ask what their favorite activity, food, or animal is.

![](https://cloud-al9r256lr.vercel.app/3pasted_image_2.png)

**_An attendee presents their project at CincyHacks Jr._**

# Teaching Strategies

One of the biggest struggles with teaching young students is that they’re often dependent on step-by-step instruction. When you give directions, it’s important to be clear and concise while also putting things into terms for kids to understand.

When you’re teaching kids, you’ll find that you sound like a broken record. Kids sometimes don’t listen the first time you say something, or they’ll ask you a question you already answered because they didn’t understand what you told them. Like we said, patience in these situations is important! When you find yourself repeating the same thing over and over again, try to rephrase what you’re teaching to make it easier to understand. Remember that these are new coders and younger kids—their brains don’t work quite like yours. Giving them an example other than the code they’re working on is a good place to start.

![](https://cloud-al9r256lr.vercel.app/2pasted_image_3.png)

**_Kids being taught by Mason Hack Club members_**

A good tactic is to explain things with analogies to everyday life—we usually talk about if statements being similar to the weather. If statements check a condition, like the weather outside, and decide what to do based on what the condition is. If it’s cold outside, you would wear a coat. If it’s warm out, you wear shorts. Not checking the weather and just choosing a random item to wear never goes well, so using an if test here is a good idea.

# Forming a Team

No one can do it alone! You’re going to need to find a capable group of people to help you manage activities and make sure all of your students return to their parents alive and content. Our team mostly consists of members of our Hack Club, and we would be nowhere without their help. We’ve found that there are a few consistent qualities that allow people to work well with younger students.

One of the biggest qualities we look for in team members is adaptivity. When running events, plans and timing can change quickly and unexpectedly. Having a team who can adapt to different situations on the spot as well as communicate changes to kids effectively are great people to work with. Another super important quality our kid-approved team members tend to have is a fun attitude. Cracking jokes and being silly makes teaching a lesson more lighthearted and less like a boring traditional classroom, and it keeps kids interested in what you have to say.

![](https://cloud-al9r256lr.vercel.app/1pasted_image_4.png)

**_The CincyHacks Jr. 2019 team!_**

The best way to improve your team and your students’ experience is to get feedback from the kids themselves. Sometimes people don’t realize it, but kids are RUTHLESS. They have absolutely no filter. If you’re doing something wrong, you better believe that they won’t hesitate to tell you. Always make sure to get feedback! At Hack Camp, we send out a daily survey as a Google Form.

# Finding a Venue

An important part of any event for younger students is the venue. Venue can make or break your event! When picking a space, there are a few things to keep in mind.

The biggest question you should ask yourself when picking a venue: is this space going to be accommodating for all of the kids in attendance? Can they spread out throughout the venue? Are there bathrooms and water fountains nearby? Aim for friendly, open spaces that allow kids to spread out and work in groups.

Another aspect you need to look for when choosing a venue: quality of outdoor spaces. If you’re running an event in the hotter months, you’re definitely going to want to run outdoor breaks. They’re beneficial in two ways: one, they let kids blow off steam and tire themselves out (trust us, you’re going to want it) and two, team members who aren’t supervising the outdoor break get time to recollect and take a break as well (trust us, you’re going to need it). Tag, night at the museum, and mafia and other no-supplies-required outdoor games are super fun and let kids take a brain break from code for a bit.

![](https://cloud-al9r256lr.vercel.app/0pasted_image_5.png)

**_CincyHacks Jr. attendees outside Cengage Learning in Mason, Ohio_**

# Snacks

The final thing we’re going to talk about today is snacks. A small but important detail—kids are extremely food motivated. Snacks can help kids stay on task and provide them with quick food in order to keep them from getting cranky. They also make great extra rewards for following directions, getting questions right, etc.

And just like we touched upon in the venue section, snacks give the opportunity for younger students to have a break and recharge their brains for even more coding and learning.

# Conclusion

If you’ve made it this far, thank you for reading! We hope that you’ve learned something about teaching children and have a good idea about where to start and some of the things to think about when organizing your first event for kids. If you have any questions, comments, or concerns, don’t hesitate to reach out! We’re available on the Slack (@margeson.jack & @ava) and you can find all of our other contact stuff and boring things like that on our websites: [https://marg.es/on/](https://marg.es/on/) & [https://avascherocman.com/](https://avascherocman.com/). Until next time—happy hacking!

---

_Edited by @megan._
