By Dina Elhanan (@digitaldina). 31 Jul 2019

---

_Meetings can be tough to run, so here’s what Dina chose to do with her meetings outside of the typical workshop structure!_

One of the best meetings I've ever had was with micro:bits. I want to share what made that meeting great so that every meeting you run can be just as great 😁

# Planning the Meeting

A few days before our meeting, I talked with my computer engineering teacher to figure out what resources our school has that I could use for a workshop. My teacher pointed me to a closet full of hardware, where I found our Microbits.

Microbits (styled micro:bit) are like Arduinos but much simpler. They're created for use in schools, and they were given to my school for free by Microsoft Education Canada. I highly recommend you reach out to companies with a focus on education for hardware resources because most are happy to send some for free especially when they hear the awesome things you want to do at your Hack Club 😁 Microbits have LED lights, speakers, buttons, and more built into the board, so they're perfect for beginners.

### Back to the meeting

A day before the meeting, I created slides for the meeting that describe what the workshop is, how it's going to run, and what Hack Club members will create by the end of the workshop. You can see the slides for the micro:bit (and other hardware) workshop [here](https://docs.google.com/presentation/d/17NNwABNel13nqclkjgogvjG7ir7VO25L3p_Jj5aAcLI). I always tell members that they're free to bring in their laptops or use the school computers, so while planning the workshop, I make sure to make it school computer friendly (school computers block some sites and don't have elevated permissions so that is something to take into account if your workshop requires installing things). If your school doesn't have computers that students can use, I highly recommend that you also reach out to different tech organizations, especially those with a focus on education, and describe what you're planning on doing at your Hack Club and why you need computers to do so. Getting your teacher sponsor to help you out is also helpful, but asking those companies yourself as a high school (or younger) student is a lot more impressive.

# How the Meeting Runs

I ran the micro:bit meeting much like my other meetings (see my meeting model [@digitaldina: CTF & Cyber Security](https://www.notion.so/28e90391-e984-47f8-a971-aca21ab2606c) ) I waited 10 minutes for everyone to arrive while welcoming music played and the welcome slide was up. After everyone was settled, I started going through the slides, then doing the demo. After the demo, I give the club members until 10-15 minutes (more on this and why it's a range in the "Sharing Time" section) before the end of the meeting to build on the demo. For the micro:bits specifically, the demo was me showing them how to turn on an LED light, where they can find documentation on the micro:bits, what files they're editing, and how to use the online IDE. While everyone is working, my teacher sponsor and I walk around to check in on and help students that are working on their own. This helps club members stay on task and feel more comfortable with asking questions since they won't have to put their hands up in a class-like setting. Once we get close to the point where there's 10-15 minutes left in the meeting, I remind everyone that our "Sharing Time" is about to start (I don't actually call it this; I just say "We're about to present in 8 minutes, so make sure your work is ready or that you've thought of something cool about this meeting that you want to share").

# Sharing Time

"Sharing Time" is an idea I ~~stole~~ borrowed from @itsmingjie. At the end of every meeting, I give time for club members to share what they've created, solved, etc. Even if members didn't finish, I make sure to mention that sharing their ideas or what they liked during the meeting is just as good. At the end, we all vote on the coolest _presentation_. **This is important because it isn't about who's the better coder, but who's the best at communicating their ideas**, giving everyone the chance to get appreciated.

"Sharing Time" encourages the club members to stay on task during the meeting so that they have something to show for it, so that they can open up to one another, and so that club members practice their presentation skills, helping them be more than just better coders!

Now, what should you do if you have shy members? I had to figure this out because one of my members was uncomfortable with getting up in front of the other members and presenting. The best way I found to handle this is to mold the "Sharing Time" to their comfort zone. For this particular member, I told her that she could just talk to her screen at her table about what she made, and that worked out great! It eased her into presenting and now she's progressing into looking around the room while sitting down and presenting.

This is the best part of leading a Hack Club — I get to see how much the club has changed people for the better. During the micro:bit meeting, the projects that people made blew me away. Just to remind you, all I did was show them where the files and documentation is, answer any questions they had while walking around, and show them how to turn on one single LED light. During "Sharing Time", two club members who teamed up and made rock paper scissors using their micro:bits demoed their game. Both players shake the micro:bit (which has a \[name of shaking sensor\]) and then the micro:bit randomly chooses between rock (a circle on the LED grid), scissors (an X on the LED grid), and paper (a square on the LED grid).

# A few last things

Throughout this meeting model, I used very specific examples which I tried to link to more general ideas that are applicable to other types of hardware. Hardware workshops are different than software ones because they usually take time and don't have documentation that is as great as some software that you can use in workshops. If you don't find useful documentation for hardware that you really want to use for a workshop, I highly recommend doing what I did with ReactVR which is to create a simple, short piece of documentation on say a google doc and share a tinyURL of the doc during the demo presentation that club members can access throughout the workshop.

I also tried to cover as much ground as I could when it comes to hardware workshops, but if you feel like I missed something or you've got a specific question, feel free to reach out about anything! I'm @digitaldina on the [Hack Club slack](http://hackclub.slack.com) and [Twitter](https://twitter.com/d1g1t4ld1n4). I'm also [@dinaelhanan](http://instagram.com/dinaelhanan/) on most other social media.

---

_Edited by @megan._