By Jack Margeson (@margeson.jack). 19 Aug 2019

--

**Introduction**

A good use of an earlier-in-the-year club meeting would be to teach your club members about Git. In this article, I’m going to give you a little bit of information about Git, what it can be used for, and some materials to help you _git_ started teaching your club members (Haha, _git_ it?). By the end of reading, you should have a good starting point for a meeting all about Git.

**What is Git?**

From it’s Linux ‘man’ manual page, Git describes itself as “the stupid content tracker”. And… that’s not too far off from what it actually is. Git tracks changes made in the programs that you create using a system of ‘commits’, which allows you to check progress, revert changes, and collaborate with others. Git often interacts with services like GitHub, GitKraken, and GitBucket to provide a better, modern interface over the terminal. We’ll be using GitHub and the program GitHub Desktop.  
  
**Why should I teach Git?**

For starters, Git (and by extension GitHub) is a great tool for programmers. It allows for communication and code to be consistent for teams and groups of your members—something especially important for running things like group programming challenges or development teams (Shameless plug: you can read my article about development teams [here](../meeting_models/Meeting-Model-#1%20-Development-Teams-(@margeson.jack).md)).

Another benefit of teaching Git is that your club members will be able to create a portfolio of everything they’ve programmed—which gives them a great resource for future internships and opportunities.

**The Git Workshop**

When I first taught the Git workshop for the Mason Hack Club, I created a slide presentation to aid teaching which you can find [here.](https://docs.google.com/presentation/d/1ZOAz0HUuWxd1WtsGoEb_Da1huZBFkD9u5QBgdcPHIRI/edit?usp=sharing) If you’re reading through this article and come across something that you don’t know how to do, there are a lot of pictures on these slides which could come in handy. Another good resource is the official GitHub guide for getting started, which can be found [here](https://guides.github.com/activities/hello-world/).

In order to properly teach your club members Git efficiently, you’re going to need to know a few things. One, a basic understanding (and an account) with GitHub and GitHub Desktop. Two, a couple of volunteers who can help members who are versed in Git and can help other club members by walking around and answering questions.

The first thing that you’re going to have your members do is create a repository, which you can do through the main page of GitHub. Remind them that they need to check the box that adds a README to the repository, as this will save those following along on the command line a lot of headache later.

After creating a repository, have your members set up GitHub Desktop. Walk them through the setup process (downloading, installing, and signing into their account) and then have them pull the repository they’ve created from GitHub. Instruct them to use their computer’s Notepad to create a new text file in the folder where GitHub has pulled the repository. More often than not, it’s inside a folder in the Documents portion of the file system.

Back on GitHub Desktop, have your members observe that there has been local changes detected, and have them add a commit message in the bottom left of the client. Use the button at the top to commit the changes, and press that button again to commit the changes to the ‘master’ branch. As members are doing this, explain Git’s commit system and the idea of multiple branches.

Finally, going back to GitHub, your members can now see the new file that they have created. Have them use GitHub’s collaborative features to share access to the repository with others, and give them a brief overview of GitHub’s Issues and Pull Request systems. I recommend teaching only the basics: creating and closing issues, and submitting and merging pull requests.

End off the meeting by giving your members a little speech about what Git can do to impact them, such as communication in programming teams, and having a virtual portfolio of all of their work. Give them the rest of the time to experiment and play around with Git and GitHub—a fun activity that you could have them do if there is an excess of extra time is to have a GitHub scavenger hunt by giving your members the name of a file in the Hack Club repository and having them find it.

**Conclusion**

Thanks for reading! Hopefully you should have a good idea about how to teach your club members about Git. If you have any questions, comments, or concerns, don’t hesitate to reach out! I’m always happy to talk on Slack (@margeson.jack), and if that doesn’t work, all my other social media handles and stuff can be found on my website [https://marg.es/on](https://marg.es/on). Until next time — happy hacking!

---

_Edited by @megan._