By Jack Margeson (@margeson.jack). 31 Jul 2019

---

_Meetings can be tough to run, so here’s what Jack chose to do with his meetings outside of the typical workshop structure!_

# Introduction

A great way to get your club interested in doing work for the community and to market your club at the same time is to organize development teams. In this article, I'll be explaining what development teams are and what they do for your community, your club members, and your leadership team. By the end of reading, you should have a good idea on how to organize these teams and be able to implement them in your own club.

# So uh… what are they?

In short, development teams are small groups of hackers (think 4-6) with a common goal to build something for the community. The “something” that these groups can be building can be vastly different (and up for you to decide!), but as an example, the Mason Hack Club uses development teams to publish websites for upcoming events and other clubs at our high school.

# How do I create development teams?

To answer this question fully, I have to tell you a bit about Mason’s leadership structure. I recommend reading this article( [Mason's Leadership Structure (@megan)](../Mason's-Leadership-Structure-(@megan).md) )on the subject, but as a small TL;DR, we have a director of the club delegated specifically to working on development team formation. What I would suggest is having a leader of the club to hold this position.

When starting to build development teams, scout for local organizations (nonprofits best) or clubs at your school that may not already have websites. Not only are these opportunities easy to find, web development is easy for new club members to get in to. Get in contact with these potential benefactors and pitch your idea — the members of your Hack Club are going to create them a great looking website, for free. They usually love this idea, and just like that, you have the basis of a development team.

When you have an opportunity for your club, let your members know about it. Tell them a little about the benefactor, what they do, and what they’re looking for. Take note of who seems interested! You’re going to want to get people who are passionate about the project and looking to do genuine, hard work. Remember, they’re representing your club, so choose members wisely!

When you’ve made your picks and formed a team, I suggest creating a Slack channel for them and teaching them the basics of code collaboration. Give them a deadline (we liked to pick the end of the semester) and watch them work! It’s important to do periodic check ins with your development teams to facilitate work.

# What do they do for my club members?

One of the great things about development teams is that it lets club members practice their skills in development on real world, practical situations. Your members are going to be building things that have a genuine impact on the community around them. It gives them the chance to not only learn these real world skills — but also communication skills by working in small teams.

Not only that, but it gives them a reason to come to Hack Club every week! Creating development teams is a great way to keep members engaged and interested in coming to all of your meetings.

# What do they do for ME as a leader?

Development teams bring many benefits to you and your leadership team. The benefit that I believe to be most important, especially for larger sized clubs like Mason, is the fact that it splits up members into easier to manage teams. While some of the club might be working on a workshop, your development teams can go off on their own and get some progress done during meetings, leaving you with a lighter load of club students to teach.

Marking is a great side effect of development teams. Have your teams slap a “Made with love by the Hack Club” in the footer of each website, and soon, other clubs and organization’s websites will be advertising your club for free.

# Why should I believe you?

Well, here’s some examples of things that the development teams at the Mason Hack Club have made in the past, and even some testimonials from development team members:

![](https://cloud-3oid2r0cx.vercel.app/1pasted_image_0.png)

[_Mason Hack Camp 2019 website_](https://web.archive.org/web/20201024151413/https://camp.masonhackclub.com/)  

![](https://cloud-3oid2r0cx.vercel.app/0pasted_image_1.png)

_The AMs, Live Music Club website_

> “Working with a dev team for the first time really threw me into the quick and fast-paced work of creating something for a certain deadline, being pushed to help coordinate a team effort towards building a website taught me how to communicate efficiently with different people, who in turn possess different skills. I would definitely do it again!” - Faham Tak (@faham)

> “In school, I don't think we often get chances to work as a group on a product, or in this case a website, that will actually be used and seen by a decent amount of people. So being on a dev team is definitely a new experience for most of the people who haven't done an internship or something of the sort. It helped reinforce to me how important communication is when you're on a team and being able to dedicate roles to people to get it done efficiently.” - Ayush Verma (@Ayush)

# Conclusion

Thanks for reading! Hopefully you should have a good idea on how to organize development teams and be able to implement them in your own club. If you have any questions, comments, or concerns, don’t hesitate to reach out! I’m always happy to talk on Slack (@margeson.jack), and if that doesn’t work, all my other social media handles and stuff can be found on my website [https://margeson.org](https://margeson.org/). Until next time — happy hacking!

---

_Edited by @megan. Jack is awesome! Unbiased._ ![(heart)](https://cloud-3oid2r0cx.vercel.app/2heart.png)