By Megan Cui (@megan). 06 Aug 2019

---

[Youtube link](https://youtu.be/j86_TxXIDwM)

# Video Overview

- Marketing is one of the most important parts of preparing for your meetings, which is why this is a separate video from running your club meetings. If you haven't started your first meeting yet, watch this video first, and move on to the "running your first meeting" video.
- By the end of this video, you should be well equipped to establish your own marketing strategies tailored for your own school. You should be ready to kick off your first (or next) meeting with high attendance!

# Creating a narrative

In order to create an effective narrative, you should consider a few factors.

## 1\. Average skill level of students in your school

- General surrounding area
- Existence and quality of CS courses
  - If great CS education, make sure you tell students about how Hack Club will let them apply their learning to build incredible and impactful things
  - If no CS education, tell them about all the amazing workshops that Hack Club has that are easy to get started in. Emphasize that your club will teach them to program even if they have NO experience, and you don't have to be good at STEM to be an amazing programmer

## 2\. Competitors

You'll have to create a nuanced pitch based on the types of competitors you have.

### Other tech clubs

Organizations like ACM, Robotics, and Girls Who Code.

- Your org is different because you're focused on building amazing things with code that impact others
- Participating in these two orgs are not mutually exclusive, realize that these other orgs are really cool as well
- Inclusive of all skill levels and genders at Hack Club — we'll teach you how to code from 0 experience
- Over 300 clubs world wide and more than 4000 members
- Run amazing events like free coding competitions called hackathons

### Competitive orgs

- Not mutually exclusive
- You get to pursue things for your own sake
- No pressure to be the best while developing important coding and potentially organizing skills
- Uniquely likely to get development internship opportunities!
- Just give it a shot. We'll make it worth it!

## 3\. Your resources and opportunities

If you have amazing resources, you should definitely let people know about them.

- Tons of free, amazingly awesome swag!
- Connections with local companies
- Priority registration at events
- A huge community
- Amazing alumni network
- Volunteering opportunities
- Etc.

# Doing the marketing

Three tips:

- Be aggressive (in the most polite way you can) — don't be afraid to ask people to come to meetings personally, even if you don't know them too well.
- Be shameless — don't worry about potentially being seen as weird or uncool. Hack Club wasn't cool at Mason until we ran some big events, raised a lot of money, and passed out tons of free lanyards, bracelets, stickers, and shirts.
- Be proud — make sure people know that you're proud to be a part of your Hack Club. It's contagious!

Here are a few good ways to market.

### Club Fair

Many schools have club or extracurricular activity fairs. If your school has one, MAKE SURE you get involved!! Make a bright, colorful poster, and have multiple representatives at your poster to present to multiple people at once. You could also lay swag out on your table, encouraging people to come get some free stuff while learning about your club at the same time.

Make sure you engage these people the right way. I always made sure that I asked about their skill level and interests, then I geared the conversation to align with both of those. For example, if they've never coded before, I'd let them know that our club ran beginner-friendly workshops. If they were experienced programmers, I told them about the Development Teams that our club also had to connect students to real-world programming.

### Announcements

Make sure you get your first few club meetings announced on your school announcements. This could be through morning announcements through the entire school, but it could also just be a post on your school's network (Schoology, Edline, Blackboard, etc.).

In the announcements, you want to make sure your message has your meeting time, date, and location. You should also have a 1-2 sentence description of Hack Club and what the first meeting may entail.

Mason used this:

> Are you interested in coding? Do you want to learn how to make a game or learn a new programming language? Join Mason Hack Club! All skill levels are welcome. The 2nd semester kickoff meeting is Tuesday the 29th right after school in room B112. This will be a short meeting about our new meeting structure and opportunities. Free pizza will be served.

Announcements should happen before every major meeting, such as your first meeting of the semester/quarter/trimester.

### Posters

Hang posters EVERYWHERE.

Hang posters in

*   Classrooms
*   Hallways
*   Bulletins
*   Libraries
*   Cafeterias

The goal is that every single person in the school knows what Hack Club is, even if they don't come.

Make sure these posters are colorful, clear, but concise. Good graphics/pictures will make the design more noticeable and memorable! You can make your own posters on a great website called Canva.

![](https://cloud-g8xtbr32u.vercel.app/0untitled.png)

### Swag

Swag is the best way to spread your Hack Club brand.

On top of stickers, if you have the budget, you can consider investing in these kinds of swag items.

- Custom lanyards
- Custom wristbands
- Custom club stickers

You could also pass out:

- Old hackathon or camp swag

The best part about marketing through swag is that a lot of this swag is enduring. Stickers will be stuck to respective laptops until someone puts in the focus and effort to take it off their laptop. Shirts will be worn again. Wristbands are fun accessories. Lanyards have a lot of functionality.

One of the most prominent ways that Mason Hack Club's brand spread through our high school was through one of our extremely charismatic and friendly leaders. He approached people one on one and politely yet firmly gave them random Hack Club swag. After that, stickers started appearing on laptops all around the school, especially on the laptops of people I didn't know.

I **definitely** recommend this style of marketing.

Though it takes a bit of confidence, you should also keep in mind that you're giving them free stuff and hopefully also giving them an opportunity to explore technology in a way they've never done so before.

# Conclusion

Thanks for watching! I hope you feel confident and equipped to get more people into your awesome meetings. Check out other videos on this channel & other articles in the Help Center. More details can be found in the video description. DM me if you have any questions. Happy hacking!

---

_Edited by @megan._