By Megan Cui (@megan). 02 Aug 2019

---

> PLEASE DM ME @megan IF I'M MISSING INFORMATION. I AM SO TIRED LOL

Mason Hack Camp has been one of the most transformative experiences I've had when it comes to Hack Club events. The vigor and pressure needed to make this event happen is absolutely tiring but worth it, and it's an incredible pipeline for students to learn about Hack Club at a young age.

With that being said, I know this post will be a long one. A brief disclaimer that I'm not writing my most beautifully, but I want to get this information out. I'm going to break it up into a few sections:

- [Overview of Mason Hack Camp](#overview-of-mason-hack-camp)
- [Camp ≠ Hackathon](#camp--hackathon)
- [Why run Hack Camp?](#why-run-hack-camp)
- [Date & Venue](#date--venue)
  - [Date](#date)
  - [Venue](#venue)
- [Registration & Marketing](#registration--marketing)
  - [Website](#website)
  - [Registration](#registration)
  - [Marketing](#marketing)
- [Curriculum](#curriculum)
- [Shark Tank](#shark-tank)
- [Instructors](#instructors)
  - [Instructors at Camp](#instructors-at-camp)
  - [Dealing with Instructor Conflicts](#dealing-with-instructor-conflicts)
- [Sample Schedule](#sample-schedule)
  - [Brief Timeline](#brief-timeline)
  - [3 months before](#3-months-before)
  - [2 months before](#2-months-before)
  - [1 month before](#1-month-before)
  - [2 weeks before](#2-weeks-before)
  - [1 week before](#1-week-before)
  - [1 day before](#1-day-before)
  - [First day](#first-day)
  - [Before the last day](#before-the-last-day)
  - [After camp](#after-camp)
- [Conclusion](#conclusion)

# Overview of Mason Hack Camp

Mason Hack Camp has run for **three** years already — 2017, 2018, and 2019. I was the lead organizer in 2017 and 2018, and stepped back to hand off the organizing reins to the new leadership team in 2019.

Quick bullets:

- We teach incoming 5th through 9th graders (though we've taken older and younger students) about the basics of web development.
- We have two levels: Beginner (basic HTML/CSS/JS) and Advanced (ReactJS)
- These skill levels are split randomly by Morning and Afternoon. We teach camp from 9am-12:30pm in the morning and 1:30pm-5pm in the afternoon.
- We taught camp at our sponsor's facilities (our sponsor is Cengage Learning)
- We had 100 attendees in 2017, 85 in 2018, and 70 in 2019
- We charged $150 for camp in 2018 and 2019; $125 in 2017
- We hold camp between mid-June and mid-July every year
- In total, we raised ~$12K in 2017 & 2018 and ~$10k in 2019. We run the club primarily off of this money (we were able to run CincyHacks 2018 and CincyHacks Jr. 2019 off of it!)

![](https://cloud-bgvqkuigj.vercel.app/5image-20190802-204140.png)
![](https://cloud-bgvqkuigj.vercel.app/4image-20190802-204155.png)
![](https://cloud-bgvqkuigj.vercel.app/3image-20190802-204205.png)
![](https://cloud-bgvqkuigj.vercel.app/2image-20190802-204215.png)
![](https://cloud-bgvqkuigj.vercel.app/1image-20190802-204223.png)
![](https://cloud-bgvqkuigj.vercel.app/0image-20190802-204257.png)

From now on, I will refer to Mason Hack Camp as Camp. Everything here is simply my experience with camps!

# Camp ≠ Hackathon

I don't want to scare you, but Camp, in many ways, is more difficult to run than a hackathon.

- Camp runs for longer than hackathons — five days vs. 24 hours
- Camp works with much younger, highly energetic, less independent students — 10-14 yr olds vs. 15-18 yr olds
- Camp actually charges a fee which turns this from a simple event to an actual product. This means that parents can complain and you have to work with refunds and reviews.
- You have to teach more content at Camp because most students can't really code
- You need way more people who are dedicated to run Camp — Mason had 20 instructors vs. CincyHacks 2017 only had 5 organizers, but both had ~100 people
- You have way more liability issues because you're probably associated with your school when you run Camp AND you're working with younger students
- Camp will probably be run with your school, meaning payments are harder and overhead is higher
- You have to deal with youth sizing at Camp

However, it's also easier in some other ways.

- You don't have to stay up overnight for Camp
- Students themselves are less likely to see mistakes
- You can fix things if they go wrong because you have multiple days of Camp
- You don't have to raise money to run Camp; you actually MAKE money from Camp
- You know you're making an impact on these students, giving them an experience you probably wish you had
- You get easier marketing through your school

# Why run Hack Camp?

You made it this far after my long list of reasons why Camp could be ridiculously hard, so I'm gonna pull a 180 and tell you why you should run Camp.

- Your club can make a LOT of money from this — in total, we've made ~$30K+
- You get experience teaching young students, giving you a leg up on any potential jobs working with children (like babysitting or tutoring)
- You get to be in the most formative part of the students' lives — you know that you can help them fall in love with tech
- It's amazing experience if you want to run another event (like a hackathon)
- You could get volunteer hours, depending on your school's policies (Mason doesn't allow this, unfortunately)

I do not recommend Camp be the first thing you ever run (especially on a new leadership team), though. If you do not have experience with running a hackathon, volunteering program, etc. before, you should start small and go bigger after you get experience.

# Date & Venue

## Date

The dates of your camp can make or break your event. I have a few tips on this:

- Don't run your camp over a weekend — parents want to spend time with their children on the weekends (as I'm sure your parents would like to spend time with you then as well)
- Don't run your camp too close to a big holiday — for example, we made sure that we were decently spaced away from July 4th all the time because we knew students would likely be on vacation or at family parties
- Don't run your camp on the same week as another major camp happening near you — we always avoided the Speech & Debate camp, MUN camp, Drama camp, and Journalism camp. You can probably coordinate dates with those organizations if you reach out!
- Don't run your camp too late — students should not expect to get out of camp then go straight into the new school year
- It's also best if all of the leadership team can be at every day of camp, so find dates that work with that, if possible!

## Venue

We were pretty lucky with the venue. We developed close relations with Cengage Learning since one of our advisors worked there, so we were able to use it as a venue for our camp all three years.

Even if you don't have a relationship built already, you have a few options to find a good venue:

- Your school — they're probably already used to running camps and would be a good fallback if you can't find another venue since they might also charge a fee
- Your parents' company facilities — your parents might be able to help you pull a few strings, especially if they work at a relatively large facility or at a university
- Other random companies — you can offer some benefits in return for a free venue (such as being on your camp shirts). In our experience, Cengage Learning HQ actually learned about what we were doing at the Mason office, and, if I remember correctly, we got onto their national newsletter!

Make sure your venue has:

- Good wifi — we had a problem in 2017 and had an angry parent as a result of it
- A place for students to let off steam — we let them run outdoors since there was a nice lawn in front of the building
- Enough space — we used two conference rooms to run our camp
- It should be decently easy to access as well; otherwise, it'll be tough to direct people to the right place especially with so many young students

# Registration & Marketing

## Website

You should build a website for your camp with an easy link to access it. For examples of websites, you can look at [camp.masonhackclub.com](http://camp.masonhackclub.com) or [2018.camp.masonhackclub.com](http://2018.camp.masonhackclub.com). Your website should have a registration button and basic information about your event.

## Registration

To preface this, you need to have your registration open before you start marketing. I know that hackathons sometimes have email lists, but the audience here is parents who are likely not too well-versed in tech. You just need a really easy registration form up (it could be a Google Form).

You need to collect enough information when you're getting registrations. This is some information we collected:

- Name, email, age, grade (the normal stuff)
- T-shirt size (youth and adult)
- Experience/skill level in coding
- Beginner or advanced
- Morning or afternoon
- How they heard about Hack Camp
- Confirmation that they would bring their own laptop
- Uploaded copy of their EMA/waiver

Parents don't really care how this looks — a Google form would definitely be enough here (unlike a hackathon!).

## Marketing

Marketing for Camp is way easier than hackathons. Even though it costs money, many parents will see Camp as a cheap babysitter for their student (except that your camp actually teaches their student something). So, no need to stress too much!

I have a few suggestions on where to market:

- Your social media — ask your followers (or their siblings) to attend
- Your parents' friends
- Libraries
- Recreation centers
- **Teachers at your school**
- **Your school's platform (Schoology, Edline, Peachjar, etc.)**

Depending on the size of your school, you should easily get enough to run your Camp.

# Curriculum

Curriculum is difficult. Even after three years, we found ourselves scrambling every single day to come up with new, fun curriculum for students, which became harder when we added another level to the camp.

I would recommend all camps to start with only one level where all students learn the same workshops/curriculum. HTML, CSS, and JavaScript are what we use as introductory languages and I would recommend the same to you. That way, you can riff off of existing Hack Club workshops.

What we do is this:

_I will be referring to many Hack Club workshops here: [https://workshops.hackclub.com](https://workshops.hackclub.com)._

- Day 1: Intro to HTML and CSS — Set-up, Personal Website, playing with CSS
- Day 2: Intro to JavaScript — That Was Easy, Big Foot
- Day 3: Choose your own workshops. Workshops offered were:
  - [Musical Boxes](https://googlecreativelab.github.io/coder-projects/projects/music_boxes/)
  - Choose Your Own Adventure
  - Build a Calculator
  - Encryption
  - Password-protected Website
  - Material Design Lite
  - High-Low Game
- Day 4: Choose your own workshop — only one, second half of day is Shark Tank
- Day 5: Shark Tank (will explain this later)

Be ready to change your structure at any time, whether it's the content or the style of teaching. We would completely change our structure each year depending on the progress of the students, so there's no stress to get it all perfect from Day 1. Just make sure you have a basic template of what you want to do, then be flexible to any changes!

# Shark Tank

After the first few days of Hack Camp 2017, I knew that we needed to change something. The students weren't interested, the content was strenuous and boring, and we honestly needed a miracle to make them leave camp wanting to return the next year.

This is when we thought of Shark Tank. Though we'd thought of the idea of competitions in Camp, we didn't realize how much the students would love a session like Shark Tank to finish off the camp.

Here's the way it works:

- Students split off into groups of 2-4 of their choice (you might need to help some students join groups as well)
- They are asked to make a website to advertise a product or service of their choice (real or fake). Some previous projects were:
  -  Yodeling Pickle
  -  Bathroom Light
  -  Potty Putter
  -  Dehydrated Water
- Instructors typically work with multiple different groups rather than one-on-one mentoring a group; they play a role of debugging more than leading
- Where applicable, we'd show students how to wireframe and basic steps of the design process
- Students get half of Thursday and half of Friday to build their website (we used collaborative coding websites like [Repl.it](http://repl.it) or CodeSandbox; instructors will need to help students set this up)
- Students present their website in front of the entire group. They get 2-3 minutes to present with 30 seconds of questions from a panel of judges (who were typically Cengage employees, but instructors could judge as well)
- Friday ends with closing remarks and awards (much like a hackathon)

We gave our students a choice of whatever prizes they wanted, ordered them after the event, and asked the students/parents to pick up the prize at our high school.

Prizes offered were all around $20 and included:

- An Arduino starter kit
- A Raspberry Pi Zero starter kit
- Basic VR goggles
- Bluetooth speakers

# Instructors

Instructors are incredibly important to make Camp happen. As I learned over the past three years, it's better to have less, more dedicated instructors than many instructors who have not even touched coding before.

Our instructors were typically students from Mason Hack Club with some who were personal friends. We asked our instructors to go over the planned curriculum and all of the included workshops, and we also held a mandatory instructor training session before Camp to go over guidelines, expectations, and give them an idea of what Camp would be like.

The ratio we used for the number of instructors needed was 1 instructor for every 4-6 students. From this, we got a good idea of how many instructors we needed, and we asked specific students from Mason Hack Club personally to help out. We also posted a sign-up to be an instructor on our Schoology page. For instructors who stayed for both sessions in one day, Cengage Learning and Mason Hack Club provided lunch for them.

## Instructors at Camp

At the 2019 camp, we set expectations that instructors should be fully focused on facilitating the learning of the students. This worked magically, and 2019 was the best group of instructors we've really ever had. Make sure that you enforce these expectations among the leadership team as well.

Based on our iterations through the teaching process, we found that it was significantly more effective to teach students in smaller groups with 1-2 dedicated instructors. We arranged tables into a U shape, and placed a table on the other side with a big computer monitor. The monitor allowed students to see the screen better, and instructors were in charge of bringing in monitors/borrowing others' monitors. We assigned instructors as Leads or Assists of each group, having the Lead take charge of whatever was shown on the monitor. The Assists would walk around the tables, helping students debug their code or making small talk with them.

## Dealing with Instructor Conflicts

There are instances where instructors will do things that require a stern talk. In this case, the leader of the camp should discuss this gently with them, and if that is not enough, your teacher advisor or other adult figure can step in. Be aware of your surroundings and mannerisms; you don't want to students to see this conflict.

# Sample Schedule

![](https://cloud-opoj9n97p.vercel.app/0image-20190802-204106.png)

An important distinction is that we always had one outdoor break every single day (O and Y were different groups of students), and instructors would go outside to play games with students (like Sharks & Minnows, Ninja, Tag, etc.).

What's not shown on the schedule is that we gave snacks to student 1-2 times a day, typically before and after the break.

We also always had people checking students in and out. Students would grab their name tags at check-in, and we'd take the name tags back after their checked out to do head counts and make sure that students didn't lose their name tag between days.

## Brief Timeline

So, now that you've read all of this, hopefully you want to run a camp! Here's a brief timeline to get you started.

## 3 months before

- Choose dates
- Find a venue
- Get your event approved by your school
- Determine curriculum and target demographic
- Start building a camp website

## 2 months before

- Camp website should be done
- Open registration (earlier is better; confirmation email should be sent with payment details)
- Make a flyer
- Start marketing (send all marketing materials out before school ends!!)

## 1 month before

- Gauge the amount of interest you have and order:
  - Shirts
  - Water bottles (opt)
  - Stickers
  - Bags (opt)
- Prepare shopping list (snacks)
- Ask for instructors (confirmation email should be sent with curriculum and link to join GroupMe for instructors)
- Email students who haven't paid yet

## 2 weeks before

- Close registration
- Make sure received orders are correct
- Email students who haven't paid yet again
- Email instructors about mandatory meeting (should happen at least one week before Camp)
- Find instructors to teach the opt-in workshops

## 1 week before

- Build a schedule (including everyone's roles)
- Determine how you want to teach students
- Send a reminder to all students including final email information
  - Date
  - Location
  - Time
  - Check-in/check-out procedures
  - Bring a laptop!
  - Make sure they have an email they can sign up for accounts with
- Purchase snacks
  - 2 snacks per student per day, N number of students, 5 days a week = total number of snacks needed
  - Add extra snacks for sneaky instructors to chow on
- Ask instructors to bring in enough speakers and monitors for the room(s) you'll use

## 1 day before

- Write student name tags and attach lanyards
- Organizers should have a day-before meeting so everything moves smoothly
- Prepare opening slides (welcome, rules, etc.)
- If possible, set up tables/chairs/power strips/extension cords
- Prepare check-in and check-out spreadsheets/software
- Make sure EMAs are easily accessible

## First day

- Set up room arrangement
- Set up monitors
- Set up opening slide and freeze the slide
- Start playing music
- Prepare check-in table (with swag and name tags)
- Make sure instructors are prepped to start teaching

## Before the last day

- Set up YouTube Live for project presentations and awards ceremony (make sure you have a photo and video release from everyone!)
- Send livestream link out on social media and to parents' emails
- Prepare judges for judging
- Print rubrics for judges
- Set up project submission system
- Make slides for closing and awards ceremony
- Remind students to wear their camp tshirts

## After camp

- Send a thank you email to all people involved in Camp (excluding students and parents)
  - School administration
  - Your teacher advisor
  - Instructors
- Send a final email to all students and parents. Include:
  - Pictures, if any
  - Link to projects
  - Link to project presentations and awards ceremony
  - Promote your club

# Conclusion

Gonna keep this brief. You're awesome! You can run this camp! If I missed anything here, DM me at @megan. Peace!

---

_Edited by @megan._