# How to Run a Successful Hack Club

_A step-by-step guide by the Hack Club community._

**Table of Contents**

- [What is a Hack Club?](#what-is-a-hack-club)
- [Planning Your Hack Club](#planning-your-hack-club)
  - [Leadership Team](#leadership-team)
  - [Teacher Sponsor and Space](#teacher-sponsor-and-space)
  - [Club Registration](#club-registration)
  - [Student Sign-Ups](#student-sign-ups)
  - [Check If Sites Are Blocked](#check-if-sites-are-blocked)
- [The First Meeting](#the-first-meeting)
  - [Waiting for Hackers to Arrive](#waiting-for-hackers-to-arrive)
  - [Introduction Presentation](#introduction-presentation)
  - [Name Game](#name-game)
  - [First Website Workshop](#first-website-workshop)
  - [Free-Form Hacking](#free-form-hacking)
  - [Second Meeting Reminder](#second-meeting-reminder)
- [The Second Meeting](#the-second-meeting)
  - [Wait for Hackers to Arrive](#wait-for-hackers-to-arrive)
  - [Announcements](#announcements)
  - [Example Demo](#example-demo)
  - [Hacking Time](#hacking-time)
  - [Demos](#demos)
- [Meeting Templates](#meeting-templates)
  - [Slideshow Presentations](#slideshow-presentations)
  - [Workshop Days](#workshop-days)
    - [Hacker Arrival](#hacker-arrival)
    - [Making Announcements](#making-announcements)
    - [Workshop](#workshop)
    - [Hacking](#hacking)
    - [Next Meeting Reminder](#next-meeting-reminder)
  - [Hack Days](#hack-days)
    - [Waiting for Hackers](#waiting-for-hackers)
    - [Hacking on Projects](#hacking-on-projects)
    - [Running Demos](#running-demos)
    - [Reminder for Next Meeting](#reminder-for-next-meeting)
- [Common Questions](#common-questions)
  - [What if I can’t call my club Hack Club?](#what-if-i-cant-call-my-club-hack-club)
  - [What if a member of my club does something inappropriate?](#what-if-a-member-of-my-club-does-something-inappropriate)
  - [What if our adviser does not want to let us meet every week?](#what-if-our-adviser-does-not-want-to-let-us-meet-every-week)
  - [What if people come and do non club related activities?](#What-if-people-come-and-do-non-club-related-activities)

## What is a Hack Club?

Hack Clubs are after-school sessions where people come together to hack-- solve
problems creatively.

Throughout the year, Hack Clubs go to (and sometimes host) hackathons, work on
large group projects, and, most importantly, develop into a thriving community
of hackers at their high schools.

In the sections below, we'll walk you through the process of setting up your
Hack Club and running your first few meetings. After hosting the first two
meetings, you will get the hang of how to host subsequent meetings.

## Planning Your Hack Club

You should begin this process two to three weeks before the anticipated date of
your first meeting. There isn't an enormous amount of planning required for
starting a club, but it's very important to get each of these right:

- Choosing a leadership team
- Securing a teacher sponsor and space
- Registering your club with the school
- Getting 50 signups for the first meeting

_(each of the sections below corresponds with a bullet point)_

### Leadership Team

We recommend having 2-3 people running the club. When choosing your team,
consider close friends who you think have strong leadership skills. In fact,
leadership skills are far more important than technical abilities. Great clubs
have been started by leaders that have never coded before.

It's also a good idea to have a mix of genders on the team, we've noticed that
club member demographics tend to reflect those of the leaders (i.e., if the
leadership is all-male, the club will be almost all-male).

When putting together the leadership team, choose one leader who is "in charge"
(this will usually be you). This person will have the final authority to make
changes in the club.

A common pitfall is to create a democratic selection process where everyone has
an equal vote on decisions. We've found that this tends not to work because it
makes it too easy for less-active leaders to override decisions of the club
president. The best system is one where leaders get a say proportional to their
investment in the club and the easiest way to implement this is to have a fair
leader who delegates authority.

### Teacher Sponsor and Space

A good teacher sponsor is key to having access to regular space for club
meetings and a good relationship with your school. Your sponsor is the person
who will get you a classroom for after-school meetings. If things go wrong with
the school administration, your sponsor will be your advocate. Choosing the
wrong sponsor can be fatal to clubs, so give it careful thought.

The best sponsors are personally invested in spreading coding to students. This
is generally the teacher most likely to start a computer science class (or, if
you already have one, the current computer science teacher). If you're new to
your school and not very familiar with the teachers, a good place to start
looking is the math and science department. If your school has a computer lab,
start with the teachers that teach classes in it (or if your school has
classrooms with computers in it, start with the teachers with computer
classrooms). If none of these are available to you, choose a teacher you
already like.

Once you've decided on a few potential teacher sponsors, reach out to them and
tell them about your idea to start a Hack Club. The best way to do this is to
come to their classroom right after school ends (or during lunch) and talk to
them in person. If you don't already know the teacher, introduce yourself, tell
them that you're looking for a teacher sponsor for this thing called a Hack
Club that you're starting, and explain the club to them. Here's an example of
what you might want to say:

> Hi Ms. Byrd, I'm Zach. I'm currently a freshman and I'm starting a Hack Club
> at the school. It's essentially a computer coding club where students meet
> regularly to build things like apps, websites, and games together. I've put
> together a leadership team and I'm currently looking for a teacher sponsor for
> the club. I figured I'd reach out because I heard you ran the Hour of Code in
> your classroom in December.

You'll want to get your teacher sponsor to commit to providing a space for each
of your meetings at a set time.

The difficulty of getting a teacher sponsor varies widely school to school. At
some schools you'll find a good teacher sponsor on your first try and at others
it'll take talking to 5-6 teachers. The most important thing is to be
persistent.

### Club Registration

Most high schools require you to register your club with the student council or
school administration before having your first meeting.

Generally they have an application to fill out [click here for an example][lowell_club_application].
Some schools require having a club constitution that outlines the club's
purpose and operational procedures. We've created a template constitution for
you, which you can find [here][club_constitution_template].

This shouldn't take very long, especially once you have a teacher sponsor
backing you.

[lowell_club_application]: https://docs.google.com/forms/d/1Tr8OkMX3IN8SWsYkWeTTW4GIyNSDdvco8uks9UE_FOE/viewform
[club_constitution_template]: constitution.md

### Student Sign-Ups

Now for the most important part of this whole process: actually getting people
to come to your club.

There are generally two primary channels for driving sign-ups:

1. Club fair
2. Posters

We'll go into depth on both of these in the sections below.

Your sign-up goal should be driven by the number of people you want to attend
your meetings -- aim for double that number. If you want to have 20 to 30
members come to your first meeting, you should shoot for at least 50 sign-ups.
If you want 30-40 to come, shoot for at least 70.

When it comes to pitching Hack Club, keep it short and simple, like the
following:

> Hack Club is a place where people come together to build things with code
> (like apps, websites, and games).
>
> - By the end of the first meeting, everyone has built their first website and
>   put it online.
> - By the end of the third meeting, everyone has built a website that can call
>   and text your phone.
> - By the fifth meeting, everyone has built their first game and has put it
>   online.
>
> Hack Club is like a continuous hackathon that happens twice a week at school.

Now to go into depth on the three channels for driving sign-ups.

#### Club Fair

Most schools have a day for advertising clubs at the beginning of each
semester. This commonly called the "club fair", "club day", "club rush", or
"club showcase". It is extremely important that you have a presence at this
event -- this is your opportunity to get the most important members (freshmen
and sophomores) to your first club meeting.

The best way to take advantage of your school's "club day" (or equivalent) is
to bring food and be extremely proactive about getting people to give you their
names, emails, and phone numbers. Excel or Google Sheets is a good way to
collect this info, though it's a good idea to also bring a pencil and a
clipboard in case of technical difficulties.

#### Posters

Having posters for your club in the hallways and in classrooms exposes new
members to your club and reminds people where and when the club meets.

Check out the [`posters/`](posters/) sub-directory for example club posters.

### Check If Sites Are Blocked

Before starting your first meeting, be sure to make sure that the following
websites are **not** blocked by your school!

- https://hackclub.com
- https://workshops.hackclub.com
- https://hackclub.slack.com
- https://github.com
- https://replit.com

It is super important that you can access these sites as you will be using them
for the entire school year. If any of the sites are blocked by your school,
please let a staff member know on the
[`#hq`](https://hackclub.slack.com/messages/hq/) Slack channel.

## The First Meeting

> The following is a format commonly used by leaders, but this is *_your_* club, 
> so be creative and do what you think is best for your club.

At the first meeting, start by explaining that Hack Club allows people to learn
and build things together over the course of the year, and then have members
begin building their _first real thing™_ (a personal website), using our
[Personal Website](../workshops/personal_website/) workshop.

At the second meeting, club members will complete their websites and demo their
work at the end.

Attendance tends to drop by approximately 25% after the first two meetings. On
the bright side, members who return for the third meeting tend to return to
subsequent meetings for the rest of the year. Your goal is to reduce that
attrition rate by making the first two meetings exciting, engaging, and
inspiring.

Here are two quick tips to help that happen:

1. Bring food! Full bellies lead to fonder memories. Pastries or cookies from a
   local supermarket are easy, inexpensive, and effective.
2. Make an effort to chat with members who arrive early and leave late. Talk to
   them about their goals and interests, and get them personally pumped about
   what they'll do in Hack Club.

We recommend the following format for your first meeting. There are
corresponding slides in the [First Meeting
presentation][first_meeting_template], and we've gone into more detail in the
linked sections below.

1. [Wait for hackers (club members) to arrive (5 minutes)][1]
2. [Introduction presentation (5 minutes)][2]
3. [Name game (10 minutes)][3]
4. [Build your first website workshop (45 minutes)][4]
5. [Free-form hacking (25 minutes)][5]
6. [Second meeting reminder][6]

[1]: #waiting-for-hackers-to-arrive
[2]: #introduction-presentation
[3]: #name-game
[4]: #first-website-workshop
[5]: #free-form-hacking
[6]: #second-meeting-reminder

#### Waiting for Hackers to Arrive

As hackers start to arrive, your goal is to make them feel welcome. We
recommend doing the following four things to accomplish this:

1. Put the first slide of the aforementioned presentation on the projector
2. Put some music on (not too loud, [click here][playlist] for a good pre-made
   Spotify playlist)
3. Make people feel welcome as they walk in

- Introduce yourself
- Ask a couple questions to initiate conversation
  - "How did you hear about Hack Club?"
  - "What sorts of things are you interested in learning?"
  - "What other interests or hobbies do you have?"
- If someone is sitting alone, be proactive and make conversation with them.
  Bring them into existing conversations.
- You want people to feel good about their decision to come to Hack Club

4. Tell people what will be happening next (e.g., "We're going to get the first
   meeting started in about 10 minutes after people are done trickling in. In
   the meantime, please make yourself at home and let me know if I can be
   helpful with anything.")

[playlist]: https://open.spotify.com/user/zachlatta/playlist/16lRCHBANauZr4utynaA2B

#### Introduction Presentation

The purpose of the introduction presentation is to tell members what Hack Club
is, what you're going to be doing throughout the year, when you meet, and,
_most importantly_, get them excited about the club.

Refer to the [slideshow presentation][first_meeting_template], which contains
slides to run with the introduction presentation.

#### Name Game

The name game is a simple icebreaker activity that will warm the atmosphere and
make club members more comfortable around each other. This will be especially
helpful to freshman, who probably don't know people from the higher grades.

Have the club members gather in a large circle. Start by saying your name and
creating a mnemonic for it (e.g., "Hey everyone, I'm Zach. Zany Zach."). Then
have the person to your left do the same and then repeat what you said (e.g.,
"I'm Jolly Jane. And he is Zany Zach"). Then have the person to their left do
the same and then say the names and mnemonics for everyone that has gone so
far, in order. Continue doing this through the whole circle until everyone has
gone. This will get significantly more difficult (and fun!) as more people go
-- if someone gets stuck, encourage others to help them out.

#### First Website Workshop

To get members started, you'll want to run the [Personal
Website](../workshops/personal_website/) workshop. It's going to walk
club members through the process of building their first website and getting it
online. It'll also get them set up with all the tools they'll use throughout
Hack Club.

1. Tell everyone that, we'll begin by running the Personal Website workshop,
   which will walk them through the process of building their first website.
2. Show the slide with the output of the Personal Website workshop and tell
   everyone that this is what they'll build by the end of the workshop, which
   will take around 45 minutes.
3. Explain that after the workshop, the rest of the meeting will be completely
   free-form for members to continue building their websites. Show examples of
   websites that other Hack Clubs' members have made to give your members
   inspiration for their own sites. Say that at the end of the next meeting,
   everyone is going to come to the front and demo what they've built.

#### Free-Form Hacking

After hackers finish the Personal Website workshop, they're going to transition
into free-form hacking to continue building their websites. During this time,
the most important thing for you to do is create an environment where people
are comfortable asking for help.

When people do have questions, be eager to help them out. It's also a good idea
to turn the music back on (not too loud, people should feel comfortable
talking).

#### Second Meeting Reminder

Five minutes before the meeting is over, get everyone's attention to remind
them about the next meeting. Tell them when and where it'll be and make sure
that everyone knows they will be finishing the websites they started on and
presenting them at the end. Most importantly, thank them for coming to this
meeting!

An effective way to remind people about club meetings is to send them a text
message the night before. A popular service that lets you send announcements
through text messages used by many of the clubs is called
[Remind](https://remind.com). Just make sure to set up your Remind account the
day before the meeting so you don't run into any issues. The end of the club
meeting would be a really good time for everyone else to setup an account. All
they need to do now is text `81010` with your Club's Remind code (like
`@ehs-hacks`) and that'll add them to your remind. You'll be able to send them
any announcements about club meetings via text message the night before. If any
members are concerned about privacy, inform them Remind does not give out their
phone number.

## The Second Meeting

The second meeting will pick up where the first left off. The majority of the
meeting will be free-form time for hackers to continue expanding their portfolio
websites. At the end of the meeting, everyone will come up to the front of the
room and demo their website. As in the first meeting, bringing food is a good
idea :wink:.

[Click here][second_meeting_template] for our slideshow template for the second
meeting. Make sure to [customize it](#slideshow-presentations).

Here's our suggested schedule:

1. [Wait for hackers to arrive (5 minutes)][1]
2. [Announcements (5 minutes)][2]
3. [Example demo (5 minutes)][3]
4. [Hacking Time (45 minutes)][4]
5. [Demos (30 minutes)][5]

[1]: #wait-for-hackers-to-arrive
[2]: #announcements
[3]: #example-demo
[4]: #hacking-time
[5]: #demos

#### Wait for Hackers to Arrive

This'll be very similar to the first meeting. Put on a playlist (not too loud)
and have a slide on the projector to let people know they're in the right
place.

#### Announcements

Announcements are your opportunity to share any updates with your members and
let them know what they'll be doing in this meeting. In addition to sharing the
meeting's schedule, they're useful for sharing upcoming events, upcoming guest
visits, and any other information relevant to your members.

Tell your members that for this meeting, they're going to continue where they
left off and continue building their websites. 30 minutes before the end of the
meeting, everyone will come up to the front and demo the websites they've
built. If they don't finish their website before demos, that's okay -- they'll
demo whatever they have.

After announcements, you're going to give an example of what a demo looks like.

#### Example Demo

You'll want to give an example of what a demo looks like so your members know
what to expect at the end of the meeting. The best way to do this is to demo a
project that you or another person have built for the Personal Website
workshop.

If you don't have a website that you built to demo, go ahead and pull up one of
the Personal Website workshop examples that were shown in the first meeting and
use it. [Click here][demo] for an example of what a project demo looks like
(this demo was given at a conference).

[demo]: https://www.youtube.com/watch?v=MY01d647S9Y

#### Hacking Time

This'll basically be the same as the free-form hacking section in the first
meeting. Members will continue building their websites. Your role is to foster
an environment where people are comfortable asking for help.

Just like in the first meeting, when people do have questions, be eager to help
them out. It's also a good idea to put on an upbeat playlist (but again, not
too loud -- people should feel comfortable talking with one another).

#### Demos

Before getting to the demos themselves, give your members 30, 15 minute, and 5
minute warnings so they aren't caught off guard.

30 minutes before demos start, have everyone email you a link to their website.
After making this announcement, go to each person individually to confirm that
they emailed you a link. If they run into any trouble, help them now. Hackers
will be able to continue to add to their websites after they email you the link
-- any changes they make will be live at the same URL they emailed you after
they push to GitHub. Tell everyone not to worry if they don't finish, and that
it's fine to demo whatever they have.

**Quick warning before we get into the nitty-gritty of running demos: these are
hard to facilitate and you're going to have to be detail-oriented when running
them.**

To run the demos themselves, pick a hacker to demo first and a direction to
form "the line" for demoing in (e.g., clockwise around the room). Have the
first person come up and pull up their website from your email. Have the person
who'll demo second also come up and be ready to start their demo as soon as the
first person finishes. While the second person is pulling up their demo, have
the third person come up and be ready to start their demo as soon as the second
person finishes. Continue this until everyone has demoed.

After each person demos, celebrate. Clap and cheer for them. Have fun and get
members doing this with you -- you want the person demoing to feel accomplished
after they finish.

Demos easily get backlogged, so it's important to keep them moving fast. Each
demo should be a minute long -- make an announcement that everyone will need to
keep their demos under a minute.

## Meeting Templates

A common Hack Club format for meetings is to alternate between running workshops
and free-form hacking (with demos). From here on out, we'll refer to meetings
with workshops as _workshop days_ and meetings with free-form hacking and demos
as _hack days_.

## Slideshow Presentations

In addition to the templates for the [first][first_meeting_template] and
[second][second_meeting_template] meetings, we've also created two more
templates to help you prepare. We'll refer to these throughout the sections
below. One of the presentations is a standard [Workshop Day
Template][workshop_day_template], and the other is a standard [Hack Day
Template][hack_day_template]. To use the presentations:

1. Make a copy of the presentation to customize it for your club (to do this,
   go to `File > Make a copy...`).
2. In the first two slides, update the recap (if applicable) and the schedule
   for what you'll be doing.
3. Customize the remainder of the slides according to the type of meeting:
   - For Workshop Day:
     - Choose the workshop you'll want to run for this meeting and put its name
       in the appropriate slide.
     - Add the images corresponding to this workshop. A good tip is to add one
       or two standard examples of what the workshop will produce, and then one
       or two examples of what it would look like to expand on the
       workshop, as inspiration.
     - Include a link at the end of the workshop to
       `workshops.hackclub.com/[WORKSHOP]`.
   - For Hack Day:
     - Add the images corresponding to the workshop started in the previous
       Workshop Day, perhaps one standard example and a few examples that take
       it further.
     - Choose a workshop for the following week and add a sneak preview to the
       end of the slideshow.
4. Double check: make sure you have replaced any text in brackets, like
   `[HIGH_SCHOOL]`, with the proper information for your club, as well as any
   sample images, with actual images.
5. Share your customized presentation with your leadership team and get
   feedback.
6. Publish to your club's website.

[first_meeting_template]: https://docs.google.com/presentation/d/1QhErlJS6rnqu78guPBWuJ1SUyPJKLbxzLNuSN9qVw0c/edit
[second_meeting_template]: https://docs.google.com/presentation/d/1WCerU9JhJY6L5kM7SrIlYcABwxpqcjmxmSRXilvWAaY/edit
[workshop_day_template]: https://docs.google.com/presentation/d/1LnbH5c7K-V608jMXNk3VyoVaZLaEuet7faHZCbYhOCs/edit
[hack_day_template]: https://docs.google.com/presentation/d/1uIcNYRY5ZLaLgEMO_1p-ZPmdaxeh1osy-0UpDjG2Z7w/edit

### Workshop Days

Here's our suggested schedule:

1. Wait for hackers to arrive (5 minutes)
2. Announcements (5 minutes)
3. Workshop (45 minutes)
4. Free-form hacking (30 minutes)
5. Next meeting reminder (5 minutes)

[Click here][workshop_day_template] for our slideshow template for Workshop
Days. Make sure to [customize it](#slideshow-presentations).

#### Hacker Arrival

Put on a playlist and have the first slide on the projector to let people know
they're in the right place.

#### Making Announcements

As in the second meeting, announcements are your opportunity to share updates
about the club, talk about upcoming events, and let your members know what
they'll be doing in this meeting.

Start with the following for this meeting's announcements:

1. Introduce the new workshop for this meeting.
2. Show examples (edit these into the slideshow) of what other people have
   built from the workshop
3. Say that after the workshop, the club will transition into free-form hacking
   and everyone will demo at the end of the next meeting, just like the first
   two meetings

There's a slide with a template schedule that you should show during
announcements.

#### Workshop

This'll be just like how you ran the first website workshop, except for the
current workshop you're on. [Click here][workshop_order] for our suggested
workshop order (and [click here][first_workshop] for a link to the first
workshop guidelines).

[workshop_order]: ../workshops/README.md#tracks
[first_workshop]: #first-website-workshop

#### Hacking

After hackers finish the workshop, they're going to transition into free-form
hacking to continue building upon what they have from the workshop. During this
time, the most important thing for you to do is create an environment where
people are comfortable asking for help.

When people do have questions, be eager to help them out. You want to set the
example that asking for help is a good thing. It's also a good idea to turn the
music back on (not too loud, people should feel comfortable talking).

#### Next Meeting Reminder

Five minutes before the meeting is over, get everyone's attention to remind
them about the next meeting. Say when and where it'll be and that everyone will
be finishing up what they worked on today and demoing at the end of the
meeting.

And thank them for coming!

### Hack Days

Here's our suggested schedule for Hack Days:

1. Wait for hackers to arrive (5 minutes)
2. Announcements (5 minutes)
3. Free-form hacking (45 minutes)
4. Demos (30 minutes)
5. Next meeting reminder (5 minutes)

[Click here][hack_day_template] for our slideshow template for Hack Days. Make
sure to [customize it](#slideshow-presentations).

[slideshow]: https://docs.google.com/presentation/d/1uIcNYRY5ZLaLgEMO_1p-ZPmdaxeh1osy-0UpDjG2Z7w/edit?usp=sharing

#### Waiting For Hackers

Put music on and have the first slide on the projector to let people know
they're in the right place.

#### Hacking on Projects

This'll be the same as the free-form hacking section in the second meeting.
Members will continue building on what they started during the previous
meeting. Your role will be to create an environment where people are
comfortable asking for help.

#### Running Demos

You'll want to do the same thing you did in the second meeting to run demos.
[Click here](#demos) to go to second meeting's section on running demos.

#### Reminder for Next Meeting

- Five minutes before the meeting is over, make sure to hit the last slide in
  the presentation and tell everyone the time and place for the next meeting.
- Let everyone know they’ll be doing a new workshop next time, and give a
  brief and enticing description.
- Thank them for coming!

## Common Questions

### What if I can't call my club "Hack Club"?

Teachers/club sponsors/school administrators will sometimes try to ban a club from calling itself "Hack Club" because it includes the word "hack". To fix this, try explaining what "hack" means:

> The word ["hacker"](http://www.dictionary.com/browse/hacker) has two meanings, the one we refer to is: a person who is skilled with computers or using tools in new ways.

> When we say "hack", we're referring to solving problems cleverly with code – just like "life hacking", except with computers.

> When we call ourselves "Hack Club", it means we're building apps, websites, games, and anything else you can imagine.

If that still doesn't work, just reach out to us on [Slack](https://hackclub.slack.com/messages/C0J7C6YET/). A bunch of club leaders have had to deal with this and we're happy to help out.

### What if a member of my club does something inappropriate?

You should warn and ask them stop. You'll want to make sure to tell them what is inappropriate about their actions, as they themselves may not realize that they are doing something inappropriate.

If this persists past the warning, then talk to your teacher/club sponsor/school administrator about the proper course of action to take.

Refer to our [Code of Conduct](https://github.com/hackclub/hackclub/blob/master/CONDUCT.md) for more information.

### What if our adviser does not want to let us meet every week?

Sometimes, an advisor might not have the time in their schedule to meet weekly. Ask if you can get a second advisor to meet on the weeks that your current one can't.

Try explaining to advisors why it's important to meet once per week. For example:

> We want our club members to be interested and engaged during meetings so club members have the right expectation for club meetings. It's important to meet at least once per week so club members stay interested in their projects. If we can't meet each week, people might get distracted in the off-time.

Alternatively, you could find a public space to meet in and have your club meeting there.

### What if people come and do non club related activities?

Hack Clubs should be a fun, chill, and creative spaces, where the focus is to create an environment where people want to learn to hack. However, it's not cool when people come with the intention of doing non club related activities, such as playing games or messing around for the fun of it.

If this happens, make them aware of their actions, as they themselves might not know what they are doing is wrong.

If this persists past the warning, then talk to your teacher/club sponsor/school administrator about the proper course of action to take.

Refer to our [Code of Conduct](https://github.com/hackclub/hackclub/blob/master/CONDUCT.md) for more information.
