# Code of Conduct

## TL;DR

- Treat everyone with respect and kindness.
- Be thoughtful in how you communicate.
- Don't be destructive or inflammatory.
- If you encounter an issue, please mail <conduct@hackclub.com>.

## Why have a Code of Conduct?

Hack Club's community includes people from many different backgrounds. The Hack Club contributors are committed to providing a friendly, safe, and welcoming environment for all, regardless of age, disability, gender, nationality, race, religion, sexuality, or similar personal characteristic.

The first goal of the Code of Conduct is to specify a baseline standard of behavior so that people with different social values and communication styles can communicate effectively, productively, and respectfully.

The second goal is to provide a mechanism for resolving conflicts in the community when they arise.

The third goal of the Code of Conduct is to make our community welcoming to people from different backgrounds. Diversity is critical in order for us to build a thriving community; for Hack Club to be successful, it needs hackers from all backgrounds.

With that said, a healthy community must allow for disagreement and debate. The Code of Conduct is not a mechanism for people to silence others with whom they disagree.

## Where does the Code of Conduct apply?

If you join in or contribute to the Hack Club ecosystem in any way, you are encouraged to follow the Code of Conduct while doing so.

Explicit enforcement of the Code of Conduct applies to all official online Hack Club groups, in-person meetings, and events including:

- The [Slack](https://hackclub.com/slack/)
- The [Events](https://events.hackclub.com/), including [AMAs](https://hackclub.com/amas/), [Hack Night](https://hackclub.com/night/), & Zoom calls on Slack
- The [GitHub projects](https://github.com/hackclub)
- Club Meetings

Anyone associated with HQ is required to follow and model the Code of Conduct in all situations, including places with explicit enforcement and in other spaces too. There is a higher bar for anyone associated with HQ.

Other Hack Club groups (such as hackathons, conferences, meetups, and other unofficial forums) are encouraged to adopt this Code of Conduct. Those groups must provide their own moderators and/or working group (see below).

## Hacker Values

These are the values to which people in the Hack Club community should aspire.

- Be friendly and welcoming
- Be patient
  - Remember that people have varying communication styles and that not everyone is using their native language (meaning and tone can be lost in translation).
- Be thoughtful
  - Productive communication requires effort. Think about how your words will be interpreted.
  - Remember that sometimes it is best to refrain entirely from commenting.
- Be respectful
  - In particular, respect differences of opinion.
- Be charitable
  - Interpret the arguments of others in good faith, do not seek to disagree.
  - When we do disagree, try to understand why.
- Avoid destructive behavior:
  - Derailing: stay on topic; if you want to talk about something else, start a new conversation.
  - Unconstructive criticism: don't merely condemn the current state of affairs; offer—or at least solicit—suggestions as to how things may be improved.
  - Snarking (pithy, unproductive, sniping comments)
  - Discussing potentially offensive or sensitive issues; this all too often leads to unnecessary conflict.
  - Microaggressions: brief and commonplace verbal, behavioral, and environmental indignities that communicate hostile, derogatory or negative slights and insults to a person or group.

People are complicated. You should expect to be misunderstood and to misunderstand others; when this inevitably occurs, resist the urge to be defensive or assign blame. Try not to take offense where no offense was intended. Give people the benefit of the doubt. Even if the intent was to provoke, do not rise to it. It is the responsibility of _all parties_ to de-escalate conflict when it arises.

## Unwelcome behavior

These actions are explicitly forbidden in Hack Club spaces:

- Expressing or provoking:
  - insulting, demeaning, hateful, or threatening remarks;
  - discrimination based on age, nationality, race, (dis)ability, gender (identity or expression), sexuality, religion, or similar personal characteristic;
  - bullying or systematic harassment;
  - unwelcome sexual advances, including sexually explicit content.
- Advertising or recruiting for events, companies, organizations, etc - unless specifically given permission by Hack Club HQ.
- Posting spam-like content that disrupts the environment of the community.
- Defrauding Hack Club, including HCB, by collecting funds or resources under false information, identity, or pretenses. This is treated as a **third offense** and could result in a call to **your school admin**.

## Moderation & Enforcement

Please understand that speech and actions have consequences, and unacceptable behavior will not be tolerated. When you participate in [areas where the code of conduct applies](#where-does-the-code-of-conduct-apply), you should act in the spirit of the "Hacker Values". If you conduct yourself in a way that is explicitly forbidden by the Code of Conduct, you will be warned and asked to stop, and your messages may be removed by community moderators. Repeated offenses may result in a temporary or permanent ban from the community.

- On your first offense, you will receive a written notice from one of our community moderators. Depending on the degree of the reported behavior, you may be asked to apologize, either in public or directly to the party that you have offended.
- On a second offense, you will be temporarily removed from the community. The period of the temporary ban may vary from 3 days to a month, decided based on the seriousness of the reported behavior. Please note that this ban **does not indicate that you are no longer welcomed in the community** - it represents an official warning for your behavior.
- On a third offense, you may be asked to leave the community. Your account may be suspended for an indefinite amount of time, and you may be publicly identified.

This procedure only serves as a general guideline for moderation & enforcement of our community conduct. Under all circumstances, the Working Group or Hack Club's staff members may take any action we deem appropriate, including immediate removal from the community. Being banned from the Hack Club community may also prevent you from participating in our community events, including but not restricted to: local club meetings, hackathons, or challenges.

Please understand that we will not restrict your ability to contact the [Code of Conduct working group](#working-group) under any circumstance. If you have any questions or concerns about our decision, please reach out to us directly. If your Slack account is under suspension, email us directly at <conduct@hackclub.com>.

## Working Group

The Working Group is responsible for handling conduct-related issues. Their mission is to de-escalate conflicts and try to resolve issues to the satisfaction of all parties. For all [projects related to and/or maintained by Hack Club HQ](#where-does-the-code-of-conduct-apply), the Working Group is made up of the [Hack Club staff team](https://hackclub.com/team/) and [Fire Dept](https://app.slack.com/client/T0266FRGM/C01D7AHKMPF). The specific team member(s) handling each violation depend on the location and nature of the issue.

## Reporting Issues

If you encounter a conduct-related issue, you should report it to the Working Group using the process described below. **Do not** post about the issue publicly or try to rally sentiment against a particular individual or group.

- Mail <conduct@hackclub.com>
  - Your message will reach the Working Group.
  - Reports are confidential within the Working Group.
  - Should you choose to remain anonymous then the Working Group cannot notify you of the outcome of your report.
  - You may contact a member of the group directly if you do not feel comfortable contacting the group as a whole. That member will then raise the issue with the Working Group as a whole, preserving the privacy of the reporter (if desired).
  - If your report concerns a member of the Working Group, they will be recused from Working Group discussions of the report.
  - The Working Group will strive to handle reports with discretion and sensitivity, to protect the privacy of the involved parties, and to avoid conflicts of interest.
- You should receive a response within 48 hours (likely sooner). (Should you choose to contact a single Working Group member, it may take longer to receive a response.)
- The Working Group will meet to review the incident and determine what happened.
  - With the permission of the person reporting the incident, the Working Group may reach out to other community members for more context.
  - The Working Group will reach a decision as to how to act. These may include:
    - Nothing.
    - A request for a private or public apology.
    - A private or public warning.
    - An imposed vacation (for instance, asking someone to abstain for a week from the Slack or a GitHub project).
    - A permanent or temporary ban from some or all Hack Club spaces.
- The Working Group will reach out to the original reporter to let them know the decision.
- Appeals to the decision may be made to the Working Group or to any of its members directly.

**Note that the goal of the Code of Conduct and the Working Group is to resolve conflicts in the most harmonious way possible.** We hope that in most cases issues may be resolved through polite discussion and mutual agreement. Bannings and other forceful measures are to be employed only as a last resort.

Changes to the Code of Conduct should be proposed by [creating an issue](https://github.com/hackclub/hackclub/issues/new) or making a pull request to this document.

## Acknowledgments

This was adapted from [Go's Code of Conduct](https://github.com/golang/go/commit/aa487e66f869785837275ee20441a53888a51bb2). It is to be noted that many parts of Go's Code of Conduct are adopted from the Code of Conduct documents of the Django, FreeBSD, and Rust projects.
