# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `tzinfo` gem.
# Please instead update this file by running `bin/tapioca gem tzinfo`.

# The top level module for TZInfo.
#
# source://tzinfo-2.0.5/lib/tzinfo.rb:5
module TZInfo
  class << self
    # Instructs the current {DataSource} to load all timezone and country data
    # into memory (initializing the {DataSource} first if not previously
    # accessed or set).
    #
    # This may be desirable in production environments to improve copy-on-write
    # performance and to avoid flushing the constant cache every time a new
    # timezone or country is loaded from {DataSources::RubyDataSource}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo.rb:14
    def eager_load!; end
  end
end

# Defines transitions that occur on the zero-based nth day of the year.
#
# Day 0 is 1 January.
#
# Leap days are counted. Day 59 will be 29 February on a leap year and 1 March
# on a non-leap year. Day 365 will be 31 December on a leap year and 1 January
# the following year on a non-leap year.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:129
class TZInfo::AbsoluteDayOfYearTransitionRule < ::TZInfo::DayOfYearTransitionRule
  # Initializes a new {AbsoluteDayOfYearTransitionRule}.
  #
  # @param day [Integer] the zero-based day of the year on which the
  #   transition occurs (0 to 365 inclusive).
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `day` is not an `Integer`.
  # @raise [ArgumentError] if `day` is less than 0 or greater than 365.
  # @return [AbsoluteDayOfYearTransitionRule] a new instance of AbsoluteDayOfYearTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:130
  def initialize(day, transition_at = T.unsafe(nil)); end

  # Determines if this {AbsoluteDayOfYearTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {AbsoluteDayOfYearTransitionRule}
  #   with the same {transition_at} and day as this
  #   {AbsoluteDayOfYearTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:153
  def ==(r); end

  # Determines if this {AbsoluteDayOfYearTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {AbsoluteDayOfYearTransitionRule}
  #   with the same {transition_at} and day as this
  #   {AbsoluteDayOfYearTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:153
  def eql?(r); end

  # @return [Boolean] `true` if the day specified by this transition is the
  #   first in the year (a day number of 0), otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:137
  def is_always_first_day_of_year?; end

  # @return [Boolean] `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:142
  def is_always_last_day_of_year?; end

  protected

  # Returns a `Time` representing midnight local time on the day specified by
  # the rule for the given offset and year.
  #
  # @param offset [TimezoneOffset] the current offset at the time of the
  #   transition.
  # @param year [Integer] the year in which the transition occurs.
  # @return [Time] midnight local time on the day specified by the rule for
  #   the given offset and year.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:168
  def get_day(offset, year); end

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:173
  def hash_args; end
end

# {AmbiguousTime} is raised to indicate that a specified local time has more
# than one possible equivalent UTC time. Such ambiguities arise when the
# clocks are set back in a time zone, most commonly during the repeated hour
# when transitioning from daylight savings time to standard time.
#
# {AmbiguousTime} is raised by {Timezone#local_datetime},
# {Timezone#local_time}, {Timezone#local_timestamp}, {Timezone#local_to_utc}
# and {Timezone#period_for_local} when using an ambiguous time and not
# specifying how to resolve the ambiguity.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:16
class TZInfo::AmbiguousTime < ::StandardError; end

# A set of rules that define when transitions occur in time zones with
# annually occurring daylight savings time.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:9
class TZInfo::AnnualRules
  # Initializes a new {AnnualRules} instance.
  #
  # @param std_offset [TimezoneOffset] the standard offset that applies when
  #   daylight savings time is not in force.
  # @param dst_offset [TimezoneOffset] the offset that applies when daylight
  #   savings time is in force.
  # @param dst_start_rule [TransitionRule] the rule that determines when
  #   daylight savings time starts.
  # @param dst_end_rule [TransitionRule] the rule that determines when daylight
  #   savings time ends.
  # @return [AnnualRules] a new instance of AnnualRules
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:36
  def initialize(std_offset, dst_offset, dst_start_rule, dst_end_rule); end

  # @return [TransitionRule] the rule that determines when daylight savings
  #   time ends.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:24
  def dst_end_rule; end

  # @return [TimezoneOffset] the offset that applies when daylight savings
  #   time is in force.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:16
  def dst_offset; end

  # @return [TransitionRule] the rule that determines when daylight savings
  #   time starts.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:20
  def dst_start_rule; end

  # @return [TimezoneOffset] the standard offset that applies when daylight
  #   savings time is not in force.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:12
  def std_offset; end

  # Returns the transitions between standard and daylight savings time for a
  # given year. The results are ordered by time of occurrence (earliest to
  # latest).
  #
  # @param year [Integer] the year to calculate transitions for.
  # @return [Array<TimezoneTransition>] the transitions for the year.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:49
  def transitions(year); end

  private

  # Applies a given rule between offsets on a year.
  #
  # @param rule [TransitionRule] the rule to apply.
  # @param from_offset [TimezoneOffset] the offset the rule transitions from.
  # @param to_offset [TimezoneOffset] the offset the rule transitions to.
  # @param year [Integer] the year when the transition occurs.
  # @return [TimezoneTransition] the transition determined by the rule.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/annual_rules.rb:65
  def apply_rule(rule, from_offset, to_offset, year); end
end

# A thread-safe version of {StringDeduper}.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:50
class TZInfo::ConcurrentStringDeduper < ::TZInfo::StringDeduper
  protected

  # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:53
  def create_hash(&block); end
end

# The {Country} class represents an ISO 3166-1 country. It can be used to
# obtain a list of time zones observed by a country. For example:
#
#     united_states = Country.get('US')
#     united_states.zone_identifiers
#     united_states.zones
#     united_states.zone_info
#
# The {Country} class is thread-safe. It is safe to use class and instance
# methods of {Country} in concurrently executing threads. Instances of
# {Country} can be shared across thread boundaries.
#
# Country information available through TZInfo is intended as an aid for
# users, to help them select time zone data appropriate for their practical
# needs. It is not intended to take or endorse any position on legal or
# territorial claims.
#
# source://tzinfo-2.0.5/lib/tzinfo/country.rb:26
class TZInfo::Country
  include ::Comparable

  # Initializes a new {Country} based upon a {DataSources::CountryInfo}
  # instance.
  #
  # {Country} instances should not normally be constructed directly. Use
  # the {Country.get} method to obtain instances instead.
  #
  # @param info [DataSources::CountryInfo] the data to base the new {Country}
  #   instance upon.
  # @return [Country] a new instance of Country
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:72
  def initialize(info); end

  # Compares this {Country} with another based on their {code}.
  #
  # @param c [Object] an `Object` to compare this {Country} with.
  # @return [Integer] -1 if `c` is less than `self`, 0 if `c` is equal to
  #   `self` and +1 if `c` is greater than `self`, or `nil` if `c` is not an
  #   instance of {Country}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:162
  def <=>(c); end

  # Matches `regexp` against the {code} of this {Country}.
  #
  # @param regexp [Regexp] a `Regexp` to match against the {code} of
  #   this {Country}.
  # @return [Integer] the position the match starts, or `nil` if there is no
  #   match.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:185
  def =~(regexp); end

  # Returns a serialized representation of this {Country}. This method is
  # called when using `Marshal.dump` with an instance of {Country}.
  #
  # @param limit [Integer] the maximum depth to dump - ignored.
  # @return [String] a serialized representation of this {Country}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:194
  def _dump(limit); end

  # @return [String] the ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:77
  def code; end

  # @param c [Object] an `Object` to compare this {Country} with.
  # @return [Boolean] `true` if `c` is an instance of {Country} and has the
  #   same code as `self`, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:170
  def eql?(c); end

  # @return [Integer] a hash based on the {code}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:175
  def hash; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:94
  def inspect; end

  # @return [String] the name of the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:82
  def name; end

  # @return [String] a `String` representation of this {Country} (the name of
  #   the country).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:88
  def to_s; end

  # Returns an `Array` containing the identifier for each time zone observed
  # by the country. These are in an order that
  #
  # 1. makes some geographical sense, and
  # 2. puts the most populous zones first, where that does not contradict 1.
  #
  # Returned zone identifiers may refer to cities and regions outside of the
  # country. This will occur if the zone covers multiple countries. Any zones
  # referring to a city or region in a different country will be listed after
  # those relating to this country.
  #
  # @return [Array<String>] an `Array` containing the identifier for each time
  #   zone observed by the country
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:111
  def zone_identifiers; end

  # Returns a frozen `Array` containing a {CountryTimezone} instance for each
  # time zone observed by the country. These are in an order that
  #
  # 1. makes some geographical sense, and
  # 2. puts the most populous zones first, where that does not contradict 1.
  #
  # The {CountryTimezone} instances can be used to obtain the location and
  # descriptions of the observed time zones.
  #
  # Identifiers and descriptions of the time zones returned may refer to
  # cities and regions outside of the country. This will occur if the time
  # zone covers multiple countries. Any zones referring to a city or region in
  # a different country will be listed after those relating to this country.
  #
  # @return [Array<CountryTimezone>] a frozen `Array` containing a
  #   {CountryTimezone} instance for each time zone observed by the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:152
  def zone_info; end

  # Returns an `Array` containing the identifier for each time zone observed
  # by the country. These are in an order that
  #
  # 1. makes some geographical sense, and
  # 2. puts the most populous zones first, where that does not contradict 1.
  #
  # Returned zone identifiers may refer to cities and regions outside of the
  # country. This will occur if the zone covers multiple countries. Any zones
  # referring to a city or region in a different country will be listed after
  # those relating to this country.
  #
  # @return [Array<String>] an `Array` containing the identifier for each time
  #   zone observed by the country
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:111
  def zone_names; end

  # Returns An `Array` containing a {Timezone} instance for each time zone
  # observed by the country. These are in an order that
  #
  # 1. makes some geographical sense, and
  # 2. puts the most populous zones first, where that does not contradict 1.
  #
  # The identifiers of the time zones returned may refer to cities and regions
  # outside of the country. This will occur if the time zone covers multiple
  # countries. Any zones referring to a city or region in a different country
  # will be listed after those relating to this country.
  #
  # The results are actually instances of {TimezoneProxy} in order to defer
  # loading of the time zone transition data until it is first needed.
  #
  # @return [Array<Timezone>] an `Array` containing a {Timezone} instance for
  #   each time zone observed by the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country.rb:132
  def zones; end

  class << self
    # Loads a {Country} from the serialized representation returned by {_dump}.
    # This is method is called when using `Marshal.load` or `Marshal.restore`
    # to restore a serialized {Country}.
    #
    # @param data [String] a serialized representation of a {Country}.
    # @return [Country] the result of converting `data` back into a {Country}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/country.rb:204
    def _load(data); end

    # @return [Array<Country>] an `Array` containing one {Country} instance
    #   for each defined country.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/country.rb:52
    def all; end

    # @return [Array<String>] an `Array` containing all the valid ISO 3166-1
    #   alpha-2 country codes.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/country.rb:46
    def all_codes; end

    # Gets a {Country} by its ISO 3166-1 alpha-2 code.
    #
    # The {Country.all_codes} method can be used to obtain a list of valid ISO
    # 3166-1 alpha-2 codes.
    #
    # @param code [String] An ISO 3166-1 alpha-2 code.
    # @raise [InvalidCountryCode] If {code} is not a valid ISO 3166-1 alpha-2
    #   code it couldn't be found.
    # @return [Country] a {Country} instance representing the ISO-3166-1
    #   country identified by the `code` parameter.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/country.rb:40
    def get(code); end

    private

    # @return [DataSource] the current DataSource.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/country.rb:59
    def data_source; end
  end
end

# Alias used by TZInfo::Data format1 releases.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:62
TZInfo::CountryIndexDefinition = TZInfo::Format1::CountryIndexDefinition

# Information about a time zone used by a {Country}.
#
# source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:5
class TZInfo::CountryTimezone
  # Creates a new {CountryTimezone}.
  #
  # The passed in identifier and description instances will be frozen.
  #
  # {CountryTimezone} instances should normally only be constructed
  # by implementations of {DataSource}.
  #
  # @param identifier [String] the {Timezone} identifier.
  # @param latitude [Rational] the latitude of the time zone.
  # @param longitude [Rational] the longitude of the time zone.
  # @param description [String] an optional description of the time zone.
  # @return [CountryTimezone] a new instance of CountryTimezone
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:44
  def initialize(identifier, latitude, longitude, description = T.unsafe(nil)); end

  # Tests if the given object is equal to the current instance (has the same
  # identifier, latitude, longitude and description).
  #
  # @param ct [Object] the object to be compared.
  # @return [TrueClass] `true` if `ct` is equal to the current instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:72
  def ==(ct); end

  # A description of this time zone in relation to the country, e.g. "Eastern
  # Time". This is usually `nil` for countries that have a single time zone.
  #
  # @return [String] an optional description of the time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:31
  def description; end

  # @return [String] the {description} if present, otherwise a human-readable
  #   representation of the identifier (using {Timezone#friendly_identifier}).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:63
  def description_or_friendly_identifier; end

  # Tests if the given object is equal to the current instance (has the same
  # identifier, latitude, longitude and description).
  #
  # @param ct [Object] the object to be compared.
  # @return [Boolean] `true` if `ct` is equal to the current instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:83
  def eql?(ct); end

  # {longitude} and {description}.
  #
  # @return [Integer] a hash based on the {identifier}, {latitude},
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:89
  def hash; end

  # @return [String] the identifier of the {Timezone} being described.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:7
  def identifier; end

  # The latitude of this time zone in degrees. Positive numbers are degrees
  # north and negative numbers are degrees south.
  #
  # Note that depending on the data source, the position given by {#latitude}
  # and {#longitude} may not be within the country.
  #
  # @return [Rational] the latitude in degrees.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:16
  def latitude; end

  # The longitude of this time zone in degrees. Positive numbers are degrees
  # east and negative numbers are degrees west.
  #
  # Note that depending on the data source, the position given by {#latitude}
  # and {#longitude} may not be within the country.
  #
  # @return [Rational] the longitude in degrees.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:25
  def longitude; end

  # Returns the associated {Timezone}.
  #
  # The result is actually an instance of {TimezoneProxy} in order to defer
  # loading of the time zone transition data until it is first needed.
  #
  # @return [Timezone] the associated {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/country_timezone.rb:57
  def timezone; end
end

# TZInfo can be used with different data sources for time zone and country
# data. Each source of data is implemented as a subclass of {DataSource}.
#
# To choose a data source and override the default selection, use the
# {DataSource.set} method.
#
# @abstract To create a custom data source, create a subclass of {DataSource}
#   and implement the {load_timezone_info}, {data_timezone_identifiers},
#   {linked_timezone_identifiers}, {load_country_info} and {country_codes}
#   methods.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:29
class TZInfo::DataSource
  # Initializes a new {DataSource} instance. Typically only called via
  # subclasses of {DataSource}.
  #
  # @return [DataSource] a new instance of DataSource
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:166
  def initialize; end

  # Returns a frozen `Array` of all the available ISO 3166-1 alpha-2 country
  # codes. The identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available ISO 3166-1
  #   alpha-2 country codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:246
  def country_codes; end

  # Returns a frozen `Array` of all the available time zone identifiers for
  # data time zones (i.e. those that actually contain definitions). The
  # identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available time zone
  #   identifiers for data time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:218
  def data_timezone_identifiers; end

  # Loads all timezone and country data into memory.
  #
  # This may be desirable in production environments to improve copy-on-write
  # performance and to avoid flushing the constant cache every time a new
  # timezone or country is loaded from {DataSources::RubyDataSource}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:255
  def eager_load!; end

  # @param code [String] an ISO 3166-1 alpha-2 country code.
  # @raise [InvalidCountryCode] if the country could not be found or the code
  #   is invalid.
  # @return [DataSources::CountryInfo] a {DataSources::CountryInfo} instance
  #   for the given ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:237
  def get_country_info(code); end

  # Returns a {DataSources::TimezoneInfo} instance for the given identifier.
  # The result will derive from either {DataSources::DataTimezoneInfo} for
  # time zones that define their own data or {DataSources::LinkedTimezoneInfo}
  # for links or aliases to other time zones.
  #
  # {get_timezone_info} calls {load_timezone_info} to create the
  # {DataSources::TimezoneInfo} instance. The returned instance is cached and
  # returned in subsequent calls to {get_timezone_info} for the identifier.
  #
  # @param identifier [String] A time zone identifier.
  # @raise [InvalidTimezoneIdentifier] if the time zone is not found or the
  #   identifier is invalid.
  # @return [DataSources::TimezoneInfo] a {DataSources::TimezoneInfo} instance
  #   for a given identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:184
  def get_timezone_info(identifier); end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:268
  def inspect; end

  # Returns a frozen `Array` of all the available time zone identifiers that
  # are links to other time zones. The identifiers are sorted according to
  # `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available time zone
  #   identifiers that are links to other time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:228
  def linked_timezone_identifiers; end

  # @return [Array<String>] a frozen `Array`` of all the available time zone
  #   identifiers. The identifiers are sorted according to `String#<=>`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:204
  def timezone_identifiers; end

  # @return [String] a description of the {DataSource}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:262
  def to_s; end

  protected

  # @param code [String] an ISO 3166-1 alpha-2 country code.
  # @raise [InvalidCountryCode] if the country could not be found or the code
  #   is invalid.
  # @return [DataSources::CountryInfo] a {DataSources::CountryInfo} instance
  #   for the given ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:294
  def load_country_info(code); end

  # Returns a {DataSources::TimezoneInfo} instance for the given time zone
  # identifier. The result should derive from either
  # {DataSources::DataTimezoneInfo} for time zones that define their own data
  # or {DataSources::LinkedTimezoneInfo} for links to or aliases for other
  # time zones.
  #
  # @param identifier [String] A time zone identifier.
  # @raise [InvalidTimezoneIdentifier] if the time zone is not found or the
  #   identifier is invalid.
  # @return [DataSources::TimezoneInfo] a {DataSources::TimezoneInfo} instance
  #   for the given time zone identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:285
  def load_timezone_info(identifier); end

  # Looks up a given code in the given hash of code to
  # {DataSources::CountryInfo} mappings. If the code is found the
  # {DataSources::CountryInfo} is returned. Otherwise an {InvalidCountryCode}
  # exception is raised.
  #
  # @param hash [String, DataSources::CountryInfo] a mapping from ISO 3166-1
  #   alpha-2 country codes to {DataSources::CountryInfo} instances.
  # @param code [String] a country code to lookup.
  # @param encoding [Encoding] the encoding used for the country codes in
  #   `hash`.
  # @raise [InvalidCountryCode] if `code` was not found in `hash`.
  # @return [DataSources::CountryInfo] the {DataSources::CountryInfo} instance
  #   corresponding to `code`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:337
  def lookup_country_info(hash, code, encoding = T.unsafe(nil)); end

  # @return [Encoding] the `Encoding` used by the `String` instances returned
  #   by {data_timezone_identifiers} and {linked_timezone_identifiers}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:300
  def timezone_identifier_encoding; end

  # Checks that the given identifier is a valid time zone identifier (can be
  # found in the {timezone_identifiers} `Array`). If the identifier is valid,
  # the `String` instance representing that identifier from
  # `timezone_identifiers` is returned. Otherwise an
  # {InvalidTimezoneIdentifier} exception is raised.
  #
  # @param identifier [String] a time zone identifier to be validated.
  # @raise [InvalidTimezoneIdentifier] if `identifier` was not found in
  #   {timezone_identifiers}.
  # @return [String] the `String` instance equivalent to `identifier` from
  #   {timezone_identifiers}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:315
  def validate_timezone_identifier(identifier); end

  private

  # Combines {data_timezone_identifiers} and {linked_timezone_identifiers}
  # to create an `Array` containing all valid time zone identifiers. If
  # {linked_timezone_identifiers} is empty, the {data_timezone_identifiers}
  # instance is returned.
  #
  # The returned `Array` is frozen. The identifiers are sorted according to
  # `String#<=>`.
  #
  # @return [Array<String>] an `Array` containing all valid time zone
  #   identifiers.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:366
  def build_timezone_identifiers; end

  # If the given `identifier` is contained within the {timezone_identifiers}
  # `Array`, the `String` instance representing that identifier from
  # {timezone_identifiers} is returned. Otherwise, `nil` is returned.
  #
  # :nocov_array_bsearch:
  #
  # @param identifier [String] A time zone identifier to search for.
  # @return [String] the `String` instance representing `identifier` from
  #   {timezone_identifiers} if found, or `nil` if not found.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:382
  def find_timezone_identifier(identifier); end

  # Raises {InvalidDataSource} to indicate that a method has not been
  # overridden by a particular data source implementation.
  #
  # @raise [InvalidDataSource] always.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:352
  def raise_invalid_data_source(method_name); end

  # Tries an operation using `string` directly. If the operation fails, the
  # string is copied and encoded with `encoding` and the operation is tried
  # again.
  #
  # fails and `string` is already encoded with `encoding`.
  #
  # @param string [String] The `String` to perform the operation on.
  # @param encoding [Encoding] The `Encoding` to use if the initial attempt
  #   fails.
  # @return [Object] the result of the operation or `nil` if the first attempt
  # @yield [s] the caller will be yielded to once or twice to attempt the
  #   operation.
  # @yieldparam s [String] either `string` or an encoded copy of `string`.
  # @yieldreturn [Object] The result of the operation. Must be truthy if
  #   successful.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:436
  def try_with_encoding(string, encoding); end

  class << self
    # @return [DataSource] the currently selected source of data.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:42
    def get; end

    # Sets the currently selected data source for time zone and country data.
    #
    # This should usually be set to one of the two standard data source types:
    #
    # * `:ruby` - read data from the Ruby modules included in the TZInfo::Data
    #   library (tzinfo-data gem).
    # * `:zoneinfo` - read data from the zoneinfo files included with most
    #   Unix-like operating systems (e.g. in /usr/share/zoneinfo).
    #
    # To set TZInfo to use one of the standard data source types, call
    # `TZInfo::DataSource.set`` in one of the following ways:
    #
    #     TZInfo::DataSource.set(:ruby)
    #     TZInfo::DataSource.set(:zoneinfo)
    #     TZInfo::DataSource.set(:zoneinfo, zoneinfo_dir)
    #     TZInfo::DataSource.set(:zoneinfo, zoneinfo_dir, iso3166_tab_file)
    #
    # `DataSource.set(:zoneinfo)` will automatically search for the zoneinfo
    # directory by checking the paths specified in
    # {DataSources::ZoneinfoDataSource.search_path}.
    # {DataSources::ZoneinfoDirectoryNotFound} will be raised if no valid
    # zoneinfo directory could be found.
    #
    # `DataSource.set(:zoneinfo, zoneinfo_dir)` uses the specified
    # `zoneinfo_dir` directory as the data source. If the directory is not a
    # valid zoneinfo directory, a {DataSources::InvalidZoneinfoDirectory}
    # exception will be raised.
    #
    # `DataSource.set(:zoneinfo, zoneinfo_dir, iso3166_tab_file)` uses the
    # specified `zoneinfo_dir` directory as the data source, but loads the
    # `iso3166.tab` file from the path given by `iso3166_tab_file`. If the
    # directory is not a valid zoneinfo directory, a
    # {DataSources::InvalidZoneinfoDirectory} exception will be raised.
    #
    # Custom data sources can be created by subclassing TZInfo::DataSource and
    # implementing the following methods:
    #
    # * {load_timezone_info}
    # * {data_timezone_identifiers}
    # * {linked_timezone_identifiers}
    # * {load_country_info}
    # * {country_codes}
    #
    # To have TZInfo use the custom data source, call {DataSource.set},
    # passing an instance of the custom data source implementation as follows:
    #
    #     TZInfo::DataSource.set(CustomDataSource.new)
    #
    # Calling {DataSource.set} will only affect instances of {Timezone} and
    # {Country} obtained with {Timezone.get} and {Country.get} subsequent to
    # the {DataSource.set} call. Existing {Timezone} and {Country} instances
    # will be unaffected.
    #
    # If {DataSource.set} is not called, TZInfo will by default attempt to use
    # TZInfo::Data as the data source. If TZInfo::Data is not available (i.e.
    # if `require 'tzinfo/data'` fails), then TZInfo will search for a
    # zoneinfo directory instead (using the search path specified by
    # {DataSources::ZoneinfoDataSource.search_path}).
    #
    # @param data_source_or_type [Object] either `:ruby`, `:zoneinfo` or an
    #   instance of a {DataSource}.
    # @param args [Array<Object>] when `data_source_or_type` is a symbol,
    #   optional arguments to use when initializing the data source.
    # @raise [ArgumentError] if `data_source_or_type` is not `:ruby`,
    #   `:zoneinfo` or an instance of {DataSource}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:127
    def set(data_source_or_type, *args); end

    private

    # Creates a {DataSource} instance for use as the default. Used if no
    # preference has been specified manually.
    #
    # @return [DataSource] the newly created default {DataSource} instance.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:145
    def create_default_data_source; end
  end
end

# {DataSourceNotFound} is raised if no data source could be found (i.e. if
# `'tzinfo/data'` cannot be found on the load path and no valid zoneinfo
# directory can be found on the system).
#
# source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:16
class TZInfo::DataSourceNotFound < ::StandardError; end

# {DataSource} implementations and classes used by {DataSource}
# implementations.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources.rb:6
module TZInfo::DataSources; end

# Represents a data time zone defined by a constantly observed offset.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:8
class TZInfo::DataSources::ConstantOffsetDataTimezoneInfo < ::TZInfo::DataSources::DataTimezoneInfo
  # Initializes a new {ConstantOffsetDataTimezoneInfo}.
  #
  # The passed in `identifier` instance will be frozen. A reference to the
  # passed in {TimezoneOffset} will be retained.
  #
  # @param identifier [String] the identifier of the time zone.
  # @param constant_offset [TimezoneOffset] the constantly observed offset.
  # @raise [ArgumentError] if `identifier` or `constant_offset` is `nil`.
  # @return [ConstantOffsetDataTimezoneInfo] a new instance of ConstantOffsetDataTimezoneInfo
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:19
  def initialize(identifier, constant_offset); end

  # @return [TimezoneOffset] the offset that is constantly observed.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:9
  def constant_offset; end

  # @param timestamp [Timestamp] ignored.
  # @return [TimezonePeriod] an unbounded {TimezonePeriod} for the time
  #   zone's constantly observed offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:28
  def period_for(timestamp); end

  # @param local_timestamp [Timestamp] ignored.
  # @return [Array<TimezonePeriod>] an `Array` containing a single unbounded
  #   {TimezonePeriod} for the time zone's constantly observed offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:35
  def periods_for_local(local_timestamp); end

  # @param to_timestamp [Timestamp] ignored.
  # @param from_timestamp [Timestamp] ignored.
  # @return [Array] an empty `Array`, since there are no transitions in time
  #   zones that observe a constant offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:43
  def transitions_up_to(to_timestamp, from_timestamp = T.unsafe(nil)); end

  private

  # @return [TimezonePeriod] an unbounded {TimezonePeriod} with the constant
  #   offset of this timezone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/constant_offset_data_timezone_info.rb:51
  def constant_period; end
end

# Represents a country and references to its time zones as returned by a
# {DataSource}.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:8
class TZInfo::DataSources::CountryInfo
  # Initializes a new {CountryInfo}. The passed in `code`, `name` and
  # `zones` instances will be frozen.
  #
  # @param code [String] an ISO 3166-1 alpha-2 country code.
  # @param name [String] the name of the country.
  # @param zones [Array<CountryTimezone>] the time zones observed in the
  #   country.
  # @raise [ArgumentError] if `code`, `name` or `zones` is `nil`.
  # @return [CountryInfo] a new instance of CountryInfo
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:26
  def initialize(code, name, zones); end

  # @return [String] the ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:10
  def code; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:37
  def inspect; end

  # @return [String] the name of the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:13
  def name; end

  # @return [Array<CountryTimezone>] the time zones observed in the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/country_info.rb:16
  def zones; end
end

# The base class for time zones defined as either a series of transitions
# ({TransitionsDataTimezoneInfo}) or a constantly observed offset
# ({ConstantOffsetDataTimezoneInfo}).
#
# @abstract Data sources return instances of {DataTimezoneInfo} subclasses.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:17
class TZInfo::DataSources::DataTimezoneInfo < ::TZInfo::DataSources::TimezoneInfo
  # @return [DataTimezone] a new {DataTimezone} instance for the time zone
  #   represented by this {DataTimezoneInfo}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:76
  def create_timezone; end

  # @param timestamp [Timestamp] a {Timestamp} with a specified
  #   {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `timestamp` is `nil` or does not
  #   have a specified {Timestamp#utc_offset utc_offset}.
  # @return [TimezonePeriod] the {TimezonePeriod} observed at the time
  #   specified by `timestamp`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:18
  def period_for(timestamp); end

  # Returns an `Array` containing the {TimezonePeriod TimezonePeriods} that
  # could be observed at the local time specified by `local_timestamp`. The
  # results are are ordered by increasing UTC start date. An empty `Array`
  # is returned if no periods are found for the given local time.
  #
  # @param local_timestamp [Timestamp] a {Timestamp} representing a local
  #   time - must have an unspecified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `local_timestamp` is `nil`, or
  #   has a specified {Timestamp#utc_offset utc_offset}.
  # @return [Array<TimezonePeriod>] an `Array` containing the
  #   {TimezonePeriod TimezonePeriods} that could be observed at the local
  #   time specified by `local_timestamp`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:34
  def periods_for_local(local_timestamp); end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the time zone changes.
  #
  # Transitions are returned up to a given {Timestamp} (`to_timestamp`).
  #
  # A from {Timestamp} may also be supplied using the `from_timestamp`
  # parameter. If `from_timestamp` is specified, only transitions from that
  # time onwards will be returned.
  #
  # Comparisons with `to_timestamp` are exclusive. Comparisons with
  # `from_timestamp` are inclusive. If a transition falls precisely on
  # `to_timestamp`, it will be excluded. If a transition falls on
  # `from_timestamp`, it will be included.
  #
  # Transitions returned are ordered by when they occur, from earliest to
  # latest.
  #
  # @param to_timestamp [Timestamp] a {Timestamp} with a specified
  #   {Timestamp#utc_offset utc_offset}. Transitions are returned if they
  #   occur before this time.
  # @param from_timestamp [Timestamp] an optional {Timestamp} with a
  #   specified {Timestamp#utc_offset utc_offset}. If specified, transitions
  #   are returned if they occur at or after this time.
  # @raise [ArgumentError] may be raised if `to_timestamp` is `nil` or does
  #   not have a specified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `from_timestamp` is specified
  #   but does not have a specified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `from_timestamp` is specified
  #   but is not earlier than or at the same time as `to_timestamp`.
  # @return [Array<TimezoneTransition>] an `Array` of {TimezoneTransition}
  #   instances representing the times where the UTC offset of the time zone
  #   changes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:70
  def transitions_up_to(to_timestamp, from_timestamp = T.unsafe(nil)); end

  private

  # Raises a {NotImplementedError} to indicate that the base class is
  # incorrectly being used directly.
  #
  # raise [NotImplementedError] always.
  #
  # @raise [NotImplementedError]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/data_timezone_info.rb:86
  def raise_not_implemented(method_name); end
end

# An {InvalidPosixTimeZone} exception is raised if an invalid POSIX-style
# time zone string is encountered.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:16
class TZInfo::DataSources::InvalidPosixTimeZone < ::StandardError; end

# An {InvalidZoneinfoDirectory} exception is raised if {ZoneinfoDataSource}
# is initialized with a specific zoneinfo path that is not a valid zoneinfo
# directory. A valid zoneinfo directory is one that contains time zone
# files, a country code index file named iso3166.tab and a time zone index
# file named zone1970.tab or zone.tab.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:15
class TZInfo::DataSources::InvalidZoneinfoDirectory < ::StandardError; end

# An {InvalidZoneinfoFile} exception is raised if an attempt is made to load
# an invalid zoneinfo file.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:12
class TZInfo::DataSources::InvalidZoneinfoFile < ::StandardError; end

# Represents a time zone that is defined as a link to or alias of another
# zone.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/linked_timezone_info.rb:9
class TZInfo::DataSources::LinkedTimezoneInfo < ::TZInfo::DataSources::TimezoneInfo
  # Initializes a new {LinkedTimezoneInfo}. The passed in `identifier` and
  # `link_to_identifier` instances will be frozen.
  #
  # `nil`.
  #
  # @param identifier [String] the identifier of the time zone.
  # @param link_to_identifier [String] the identifier of the time zone that
  #   this zone link to.
  # @raise [ArgumentError] if `identifier` or `link_to_identifier` are
  # @return [LinkedTimezoneInfo] a new instance of LinkedTimezoneInfo
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/linked_timezone_info.rb:20
  def initialize(identifier, link_to_identifier); end

  # @return [LinkedTimezone] a new {LinkedTimezone} instance for the time
  #   zone represented by this {LinkedTimezoneInfo}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/linked_timezone_info.rb:28
  def create_timezone; end

  # (that this zone links to or is an alias for).
  #
  # @return [String] the identifier of the time zone that provides the data
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/linked_timezone_info.rb:10
  def link_to_identifier; end
end

# A parser for POSIX-style TZ strings used in zoneinfo files and specified
# by tzfile.5 and tzset.3.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:24
class TZInfo::DataSources::PosixTimeZoneParser
  # Initializes a new {PosixTimeZoneParser}.
  #
  # @param string_deduper [StringDeduper] a {StringDeduper} instance to use
  #   to dedupe abbreviations.
  # @return [PosixTimeZoneParser] a new instance of PosixTimeZoneParser
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:29
  def initialize(string_deduper); end

  # Parses a POSIX-style TZ string.
  #
  # @param tz_string [String] the string to parse.
  # @raise [InvalidPosixTimeZone] if `tz_string` is not a `String`.
  # @raise [InvalidPosixTimeZone] if `tz_string` is is not valid.
  # @return [Object] either a {TimezoneOffset} for a constantly applied
  #   offset or an {AnnualRules} instance representing the rules.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:40
  def parse(tz_string); end

  private

  # Scans for a pattern and raises an exception if the pattern does not
  # match the input.
  #
  # @param s [StringScanner] the `StringScanner` to scan.
  # @param pattern [Regexp] the pattern to match.
  # @raise [InvalidPosixTimeZone] if the pattern does not match the input.
  # @return [String] the result of the scan.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:173
  def check_scan(s, pattern); end

  # Returns an offset in seconds from hh:mm:ss values. The value can be
  # negative. -02:33:12 would represent 2 hours, 33 minutes and 12 seconds
  # ahead of UTC.
  #
  # @param h [String] the hours.
  # @param m [String] the minutes.
  # @param s [String] the seconds.
  # @raise [InvalidPosixTimeZone] if the mm and ss values are greater than
  #   59.
  # @return [Integer] the offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:136
  def get_offset_from_hms(h, m, s); end

  # Returns the seconds from midnight from hh:mm:ss values. Hours can exceed
  # 24 for a time on the following day. Hours can be negative to subtract
  # hours from midnight on the given day. -02:33:12 represents 22:33:12 on
  # the prior day.
  #
  # @param h [String] the hour.
  # @param m [String] the minutes past the hour.
  # @param s [String] the seconds past the minute.
  # @raise [InvalidPosixTimeZone] if the mm and ss values are greater than
  #   59.
  # @return [Integer] the number of seconds after midnight.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:157
  def get_seconds_after_midnight_from_hms(h, m, s); end

  # Parses a rule.
  #
  # @param s [StringScanner] the `StringScanner` to read the rule from.
  # @param type [String] the type of rule (either `'start'` or `'end'`).
  # @raise [InvalidPosixTimeZone] if the rule is not valid.
  # @return [TransitionRule] the parsed rule.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/posix_time_zone_parser.rb:96
  def parse_rule(s, type); end
end

# A DataSource implementation that loads data from the set of Ruby modules
# included in the tzinfo-data gem.
#
# TZInfo will use {RubyDataSource} by default if the tzinfo-data gem
# is available on the load path. It can also be selected by calling
# {DataSource.set} as follows:
#
#     TZInfo::DataSource.set(:ruby)
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:25
class TZInfo::DataSources::RubyDataSource < ::TZInfo::DataSource
  # Initializes a new {RubyDataSource} instance.
  #
  # @raise [TZInfoDataNotFound] if the tzinfo-data gem could not be found
  #   (i.e. `require 'tzinfo/data'` failed).
  # @return [RubyDataSource] a new instance of RubyDataSource
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:38
  def initialize; end

  # Returns a frozen `Array` of all the available ISO 3166-1 alpha-2 country
  # codes. The identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available ISO 3166-1
  #   alpha-2 country codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:32
  def country_codes; end

  # Returns a frozen `Array` of all the available time zone identifiers for
  # data time zones (i.e. those that actually contain definitions). The
  # identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available time zone
  #   identifiers for data time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:26
  def data_timezone_identifiers; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:76
  def inspect; end

  # Returns a frozen `Array` of all the available time zone identifiers that
  # are links to other time zones. The identifiers are sorted according to
  # `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available time zone
  #   identifiers that are links to other time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:29
  def linked_timezone_identifiers; end

  # @return [String] a description of the {DataSource}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:71
  def to_s; end

  protected

  # @param code [String] an ISO 3166-1 alpha-2 country code.
  # @raise [InvalidCountryCode] if the country could not be found or the code
  #   is invalid.
  # @return [DataSources::CountryInfo] a {DataSources::CountryInfo} instance
  #   for the given ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:108
  def load_country_info(code); end

  # Returns a {TimezoneInfo} instance for the given time zone identifier.
  # The result will either be a {ConstantOffsetDataTimezoneInfo}, a
  # {TransitionsDataTimezoneInfo} or a {LinkedTimezoneInfo} depending on the
  # type of time zone.
  #
  # @param identifier [String] A time zone identifier.
  # @raise [InvalidTimezoneIdentifier] if the time zone is not found or the
  #   identifier is invalid.
  # @return [TimezoneInfo] a {TimezoneInfo} instance for the given time zone
  #   identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:92
  def load_timezone_info(identifier); end

  private

  # Requires a file from tzinfo/data.
  #
  # @param file [Array<String>] a relative path to a file to be required.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:132
  def require_data(*file); end

  # Requires a zone definition by its identifier (split on /).
  #
  # @param identifier [Array<string>] the component parts of a time zone
  #   identifier (split on /). This must have already been validated.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:118
  def require_definition(identifier); end

  # Requires an index by its name.
  #
  # @param name [String] an index name.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:125
  def require_index(name); end

  # @return [String] a `String` containing TZInfo::Data version infomation
  #   for inclusion in the #to_s and #inspect output.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:138
  def version_info; end
end

# A {TZInfoDataNotFound} exception is raised if the tzinfo-data gem could
# not be found (i.e. `require 'tzinfo/data'` failed) when selecting the Ruby
# data source.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/ruby_data_source.rb:13
class TZInfo::DataSources::TZInfoDataNotFound < ::StandardError; end

# Represents a time zone defined by a data source.
#
# @abstract Data sources return instances of {TimezoneInfo} subclasses.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:9
class TZInfo::DataSources::TimezoneInfo
  # Initializes a new TimezoneInfo. The passed in `identifier` instance will
  # be frozen.
  #
  # @param identifier [String] the identifier of the time zone.
  # @raise [ArgumentError] if `identifier` is `nil`.
  # @return [TimezoneInfo] a new instance of TimezoneInfo
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:18
  def initialize(identifier); end

  # @return [Timezone] a new {Timezone} instance for the time zone
  #   represented by this {TimezoneInfo}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:31
  def create_timezone; end

  # @return [String] the identifier of the time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:11
  def identifier; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:25
  def inspect; end

  private

  # Raises a {NotImplementedError}.
  #
  # @param method_name [String] the name of the method that must be
  #   overridden.
  # @raise NotImplementedError always.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/timezone_info.rb:42
  def raise_not_implemented(method_name); end
end

# Represents a data time zone defined by a list of transitions that change
# the locally observed time.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:10
class TZInfo::DataSources::TransitionsDataTimezoneInfo < ::TZInfo::DataSources::DataTimezoneInfo
  # Initializes a new {TransitionsDataTimezoneInfo}.
  #
  # The passed in `identifier` instance will be frozen. A reference to the
  # passed in `Array` will be retained.
  #
  # The `transitions` `Array` must be sorted in order of ascending
  # timestamp. Each transition must have a
  # {TimezoneTransition#timestamp_value timestamp_value} that is greater
  # than the {TimezoneTransition#timestamp_value timestamp_value} of the
  # prior transition.
  #
  # @param identifier [String] the identifier of the time zone.
  # @param transitions [Array<TimezoneTransitions>] an `Array` of
  #   transitions that each indicate when a change occurs in the locally
  #   observed time.
  # @raise [ArgumentError] if `identifier` is `nil`.
  # @raise [ArgumentError] if `transitions` is `nil`.
  # @raise [ArgumentError] if `transitions` is an empty `Array`.
  # @return [TransitionsDataTimezoneInfo] a new instance of TransitionsDataTimezoneInfo
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:31
  def initialize(identifier, transitions); end

  # @param timestamp [Timestamp] a {Timestamp} with a specified
  #   {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `timestamp` is `nil` or does not
  #   have a specified {Timestamp#utc_offset utc_offset}.
  # @return [TimezonePeriod] the {TimezonePeriod} observed at the time
  #   specified by `timestamp`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:39
  def period_for(timestamp); end

  # Returns an `Array` containing the {TimezonePeriod TimezonePeriods} that
  # could be observed at the local time specified by `local_timestamp`. The
  # results are are ordered by increasing UTC start date. An empty `Array`
  # is returned if no periods are found for the given local time.
  #
  # @param local_timestamp [Timestamp] a {Timestamp} representing a local
  #   time - must have an unspecified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `local_timestamp` is `nil`, or
  #   has a specified {Timestamp#utc_offset utc_offset}.
  # @return [Array<TimezonePeriod>] an `Array` containing the
  #   {TimezonePeriod TimezonePeriods} that could be observed at the local
  #   time specified by `local_timestamp`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:70
  def periods_for_local(local_timestamp); end

  # @return [Array<TimezoneTransition>] the transitions that define this
  #   time zone in order of ascending timestamp.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:11
  def transitions; end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the time zone changes.
  #
  # Transitions are returned up to a given {Timestamp} (`to_timestamp`).
  #
  # A from {Timestamp} may also be supplied using the `from_timestamp`
  # parameter. If `from_timestamp` is specified, only transitions from that
  # time onwards will be returned.
  #
  # Comparisons with `to_timestamp` are exclusive. Comparisons with
  # `from_timestamp` are inclusive. If a transition falls precisely on
  # `to_timestamp`, it will be excluded. If a transition falls on
  # `from_timestamp`, it will be included.
  #
  # Transitions returned are ordered by when they occur, from earliest to
  # latest.
  #
  # @param to_timestamp [Timestamp] a {Timestamp} with a specified
  #   {Timestamp#utc_offset utc_offset}. Transitions are returned if they
  #   occur before this time.
  # @param from_timestamp [Timestamp] an optional {Timestamp} with a
  #   specified {Timestamp#utc_offset utc_offset}. If specified, transitions
  #   are returned if they occur at or after this time.
  # @raise [ArgumentError] may be raised if `to_timestamp` is `nil` or does
  #   not have a specified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `from_timestamp` is specified
  #   but does not have a specified {Timestamp#utc_offset utc_offset}.
  # @raise [ArgumentError] may be raised if `from_timestamp` is specified
  #   but is not earlier than or at the same time as `to_timestamp`.
  # @return [Array<TimezoneTransition>] an `Array` of {TimezoneTransition}
  #   instances representing the times where the UTC offset of the time zone
  #   changes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:111
  def transitions_up_to(to_timestamp, from_timestamp = T.unsafe(nil)); end

  private

  # Performs a binary search on {transitions} to find the index of the
  # earliest transition satisfying a condition.
  #
  # :nocov_array_bsearch_index:
  #
  # @return [Integer] the index of the earliest transition safisfying
  #   the condition or `nil` if there are no such transitions.
  # @yield [transition] the caller will be yielded to to test the search
  #   condition.
  # @yieldparam transition [TimezoneTransition] a {TimezoneTransition}
  #   instance from {transitions}.
  # @yieldreturn [Boolean] `true` for the earliest transition that
  #   satisfies the condition and return `true` for all subsequent
  #   transitions. In all other cases, the result of the block must be
  #   `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:159
  def find_minimum_transition(&block); end

  # Determines if a transition occurs at or after a given {Timestamp},
  # taking the {Timestamp#sub_second sub_second} into consideration.
  #
  # @param transition [TimezoneTransition] the transition to compare.
  # @param timestamp [Timestamp] the timestamp to compare.
  # @return [Boolean] `true` if `transition` occurs at or after `timestamp`,
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/transitions_data_timezone_info.rb:207
  def transition_on_or_after_timestamp?(transition, timestamp); end
end

# A DataSource implementation that loads data from a 'zoneinfo' directory
# containing compiled "TZif" version 3 (or earlier) files in addition to
# iso3166.tab and zone1970.tab or zone.tab index files.
#
# To have TZInfo load the system zoneinfo files, call
# {TZInfo::DataSource.set} as follows:
#
#     TZInfo::DataSource.set(:zoneinfo)
#
# To load zoneinfo files from a particular directory, pass the directory to
# {TZInfo::DataSource.set}:
#
#     TZInfo::DataSource.set(:zoneinfo, directory)
#
# To load zoneinfo files from a particular directory, but load the
# iso3166.tab index file from a separate location, pass the directory and
# path to the iso3166.tab file to {TZInfo::DataSource.set}:
#
#     TZInfo::DataSource.set(:zoneinfo, directory, iso3166_path)
#
# Please note that versions of the 'zic' tool (used to build zoneinfo files)
# that were released prior to February 2006 created zoneinfo files that used
# 32-bit integers for transition timestamps. Later versions of zic produce
# zoneinfo files that use 64-bit integers. If you have 32-bit zoneinfo files
# on your system, then any queries falling outside of the range 1901-12-13
# 20:45:52 to 2038-01-19 03:14:07 may be inaccurate.
#
# Most modern platforms include 64-bit zoneinfo files. However, Mac OS X (up
# to at least 10.8.4) still uses 32-bit zoneinfo files.
#
# To check whether your zoneinfo files contain 32-bit or 64-bit transition
# data, you can run the following code (substituting the identifier of the
# zone you want to test for `zone_identifier`):
#
#     TZInfo::DataSource.set(:zoneinfo)
#     dir = TZInfo::DataSource.get.zoneinfo_dir
#     File.open(File.join(dir, zone_identifier), 'r') {|f| f.read(5) }
#
# If the last line returns `"TZif\\x00"`, then you have a 32-bit zoneinfo
# file. If it returns `"TZif2"` or `"TZif3"` then you have a 64-bit zoneinfo
# file.
#
# It is also worth noting that as of the 2017c release of the IANA Time Zone
# Database, 64-bit zoneinfo files only include future transitions up to
# 2038-01-19 03:14:07. Any queries falling after this time may be
# inaccurate.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:73
class TZInfo::DataSources::ZoneinfoDataSource < ::TZInfo::DataSource
  # Initializes a new {ZoneinfoDataSource}.
  #
  # If `zoneinfo_dir` is specified, it will be checked and used as the
  # source of zoneinfo files.
  #
  # The directory must contain a file named iso3166.tab and a file named
  # either zone1970.tab or zone.tab. These may either be included in the
  # root of the directory or in a 'tab' sub-directory and named country.tab
  # and zone_sun.tab respectively (as is the case on Solaris).
  #
  # Additionally, the path to iso3166.tab can be overridden using the
  # `alternate_iso3166_tab_path` parameter.
  #
  # If `zoneinfo_dir` is not specified or `nil`, the paths referenced in
  # {search_path} are searched in order to find a valid zoneinfo directory
  # (one that contains zone1970.tab or zone.tab and iso3166.tab files as
  # above).
  #
  # The paths referenced in {alternate_iso3166_tab_search_path} are also
  # searched to find an iso3166.tab file if one of the searched zoneinfo
  # directories doesn't contain an iso3166.tab file.
  #
  # @param zoneinfo_dir [String] an optional path to a directory to use as
  #   the source of zoneinfo files.
  # @param alternate_iso3166_tab_path [String] an optional path to the
  #   iso3166.tab file.
  # @raise [InvalidZoneinfoDirectory] if the iso3166.tab and zone1970.tab or
  #   zone.tab files cannot be found using the `zoneinfo_dir` and
  #   `alternate_iso3166_tab_path` parameters.
  # @raise [ZoneinfoDirectoryNotFound] if no valid directory can be found
  #   by searching.
  # @return [ZoneinfoDataSource] a new instance of ZoneinfoDataSource
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:241
  def initialize(zoneinfo_dir = T.unsafe(nil), alternate_iso3166_tab_path = T.unsafe(nil)); end

  # Returns a frozen `Array` of all the available ISO 3166-1 alpha-2 country
  # codes. The identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available ISO 3166-1
  #   alpha-2 country codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:208
  def country_codes; end

  # Returns a frozen `Array` of all the available time zone identifiers. The
  # identifiers are sorted according to `String#<=>`.
  #
  # @return [Array<String>] a frozen `Array` of all the available time zone
  #   identifiers.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:275
  def data_timezone_identifiers; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:294
  def inspect; end

  # Returns an empty `Array`. There is no information about linked/aliased
  # time zones in the zoneinfo files. When using {ZoneinfoDataSource}, every
  # time zone will be returned as a {DataTimezone}.
  #
  # @return [Array<String>] an empty `Array`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:284
  def linked_timezone_identifiers; end

  # @return [String] a description of the {DataSource}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:289
  def to_s; end

  # @return [String] the zoneinfo directory being used.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:205
  def zoneinfo_dir; end

  protected

  # @param code [String] an ISO 3166-1 alpha-2 country code.
  # @raise [InvalidCountryCode] if the country could not be found or the code
  #   is invalid.
  # @return [DataSources::CountryInfo] a {DataSources::CountryInfo} instance
  #   for the given ISO 3166-1 alpha-2 country code.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:330
  def load_country_info(code); end

  # Returns a {TimezoneInfo} instance for the given time zone identifier.
  # The result will either be a {ConstantOffsetDataTimezoneInfo} or a
  # {TransitionsDataTimezoneInfo}.
  #
  # @param identifier [String] A time zone identifier.
  # @raise [InvalidTimezoneIdentifier] if the time zone is not found, the
  #   identifier is invalid, the zoneinfo file cannot be opened or the
  #   zoneinfo file is not valid.
  # @return [TimezoneInfo] a {TimezoneInfo} instance for the given time zone
  #   identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:310
  def load_timezone_info(identifier); end

  private

  # Converts degrees, minutes and seconds to a Rational.
  #
  # @param sign [String] `'-'` or `'+'`.
  # @param degrees [String] the number of degrees.
  # @param minutes [String] the number of minutes.
  # @param seconds [String] the number of seconds (optional).
  # @return [Rational] the result of converting from degrees, minutes and
  #   seconds to a `Rational`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:583
  def dms_to_rational(sign, degrees, minutes, seconds = T.unsafe(nil)); end

  # Recursively enumerate a directory of time zones.
  #
  # @param dir [Array<String>] the directory to enumerate as an `Array` of
  #   path components.
  # @param exclude [Array<String>] file names to exclude when scanning
  #   `dir`.
  # @yield [path] the path of each time zone file found is passed to
  #   the block.
  # @yieldparam path [Array<String>] the path of a time zone file as an
  #   `Array` of path components.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:438
  def enum_timezones(dir, exclude = T.unsafe(nil), &block); end

  # Finds a zoneinfo directory using {search_path} and
  # {alternate_iso3166_tab_search_path}.
  #
  # @return [Array<String>] an `Array` containing the iso3166.tab and
  #   zone.tab paths if a zoneinfo directory was found, otherwise `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:393
  def find_zoneinfo_dir; end

  # Uses the iso3166.tab and zone1970.tab or zone.tab files to return a Hash
  # mapping country codes to CountryInfo instances.
  #
  # @param iso3166_tab_path [String] the path to the iso3166.tab file.
  # @param zone_tab_path [String] the path to the zone.tab file.
  # @return [Hash<String, CountryInfo>] a mapping from ISO 3166-1 alpha-2
  #   country codes to {CountryInfo} instances.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:467
  def load_countries(iso3166_tab_path, zone_tab_path); end

  # Scans @zoneinfo_dir and returns an `Array` of available time zone
  # identifiers. The result is sorted according to `String#<=>`.
  #
  # @return [Array<String>] an `Array` containing all the time zone
  #   identifiers found.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:418
  def load_timezone_identifiers; end

  # Attempts to resolve the path to a tab file given its standard names and
  # tab sub-directory name (as used on Solaris).
  #
  # @param zoneinfo_path [String] the path to a zoneinfo directory.
  # @param standard_names [Array<String>] the standard names for the tab
  #   file.
  # @param tab_name [String] the alternate name for the tab file to check in
  #   the tab sub-directory.
  # @return [String] the path to the tab file.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:376
  def resolve_tab_path(zoneinfo_path, standard_names, tab_name); end

  # Validates a zoneinfo directory and returns the paths to the iso3166.tab
  # and zone1970.tab or zone.tab files if valid. If the directory is not
  # valid, returns `nil`.
  #
  # The path to the iso3166.tab file may be overridden by passing in a path.
  # This is treated as either absolute or relative to the current working
  # directory.
  #
  # @param path [String] the path to a possible zoneinfo directory.
  # @param iso3166_tab_path [String] an optional path to an external
  #   iso3166.tab file.
  # @return [Array<String>] an `Array` containing the iso3166.tab and
  #   zone.tab paths if the directory is valid, otherwise `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:349
  def validate_zoneinfo_dir(path, iso3166_tab_path = T.unsafe(nil)); end

  class << self
    # An `Array` of paths that will be checked to find an alternate
    # iso3166.tab file if one was not included in the zoneinfo directory
    # (for example, on FreeBSD and OpenBSD systems).
    #
    # Paths are checked in the order they appear in the `Array`.
    #
    # The default value is `['/usr/share/misc/iso3166.tab',
    # '/usr/share/misc/iso3166']`.
    #
    # @return [Array<String>] an `Array` of paths to check in order to
    #   locate an iso3166.tab file.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:160
    def alternate_iso3166_tab_search_path; end

    # Sets the paths to check to locate an alternate iso3166.tab file if one
    # was not included in the zoneinfo directory.
    #
    # Can be set to an `Array` of paths or a `String` containing paths
    # separated with `File::PATH_SEPARATOR`.
    #
    # Paths are checked in the order they appear in the array.
    #
    # Set to `nil` to revert to the default paths.
    #
    # @param alternate_iso3166_tab_search_path [Object] either `nil` or a
    #   list of paths to check as either an `Array` of `String` or a
    #   `File::PATH_SEPARATOR` separated `String`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:177
    def alternate_iso3166_tab_search_path=(alternate_iso3166_tab_search_path); end

    # An `Array` of directories that will be checked to find the system
    # zoneinfo directory.
    #
    # Directories are checked in the order they appear in the `Array`.
    #
    # The default value is `['/usr/share/zoneinfo',
    # '/usr/share/lib/zoneinfo', '/etc/zoneinfo']`.
    #
    # @return [Array<String>] an `Array` of directories to check in order to
    #   find the system zoneinfo directory.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:127
    def search_path; end

    # Sets the directories to be checked when locating the system zoneinfo
    # directory.
    #
    # Can be set to an `Array` of directories or a `String` containing
    # directories separated with `File::PATH_SEPARATOR`.
    #
    # Directories are checked in the order they appear in the `Array` or
    # `String`.
    #
    # Set to `nil` to revert to the default paths.
    #
    # @param search_path [Object] either `nil` or a list of directories to
    #   check as either an `Array` of `String` or a `File::PATH_SEPARATOR`
    #   separated `String`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:145
    def search_path=(search_path); end

    private

    # Processes a path for use as the {search_path} or
    # {alternate_iso3166_tab_search_path}.
    #
    # @param path [Object] either `nil` or a list of paths to check as
    #   either an `Array` of `String` or a `File::PATH_SEPARATOR` separated
    #   `String`.
    # @param default [Array<String>] the default value.
    # @return [Array<String>] the processed path.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:191
    def process_search_path(path, default); end
  end
end

# The default value of {ZoneinfoDataSource.alternate_iso3166_tab_search_path}.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:78
TZInfo::DataSources::ZoneinfoDataSource::DEFAULT_ALTERNATE_ISO3166_TAB_SEARCH_PATH = T.let(T.unsafe(nil), Array)

# The default value of {ZoneinfoDataSource.search_path}.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:74
TZInfo::DataSources::ZoneinfoDataSource::DEFAULT_SEARCH_PATH = T.let(T.unsafe(nil), Array)

# Files and directories in the top level zoneinfo directory that will be
# excluded from the list of available time zones:
#
#   - +VERSION is included on Mac OS X.
#   - leapseconds is a list of leap seconds.
#   - localtime is the current local timezone (may be a link).
#   - posix, posixrules and right are directories containing other
#     versions of the zoneinfo files.
#   - SECURITY is included in the Arch Linux tzdata package.
#   - src is a directory containing the tzdata source included on Solaris.
#   - timeconfig is a symlink included on Slackware.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:92
TZInfo::DataSources::ZoneinfoDataSource::EXCLUDED_FILENAMES = T.let(T.unsafe(nil), Array)

# A {ZoneinfoDirectoryNotFound} exception is raised if no valid zoneinfo
# directory could be found when checking the paths listed in
# {ZoneinfoDataSource.search_path}. A valid zoneinfo directory is one that
# contains time zone files, a country code index file named iso3166.tab and
# a time zone index file named zone1970.tab or zone.tab.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_data_source.rb:23
class TZInfo::DataSources::ZoneinfoDirectoryNotFound < ::StandardError; end

# Reads compiled zoneinfo TZif (\0, 2 or 3) files.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:16
class TZInfo::DataSources::ZoneinfoReader
  # Initializes a new {ZoneinfoReader}.
  #
  # @param posix_tz_parser [PosixTimeZoneParser] a {PosixTimeZoneParser}
  #   instance to use to parse POSIX-style TZ strings.
  # @param string_deduper [StringDeduper] a {StringDeduper} instance to use
  #   to dedupe abbreviations.
  # @return [ZoneinfoReader] a new instance of ZoneinfoReader
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:29
  def initialize(posix_tz_parser, string_deduper); end

  # Reads a zoneinfo structure from the given path. Returns either a
  # {TimezoneOffset} that is constantly observed or an `Array`
  # {TimezoneTransition}s.
  #
  # @param file_path [String] the path of a zoneinfo file.
  # @raise [SecurityError] if safe mode is enabled and `file_path` is
  #   tainted.
  # @raise [InvalidZoneinfoFile] if `file_path`` does not refer to a valid
  #   zoneinfo file.
  # @return [Object] either a {TimezoneOffset} or an `Array` of
  #   {TimezoneTransition}s.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:45
  def read(file_path); end

  private

  # Apply the rules from the TZ string when there were defined
  # transitions. Checks for a matching offset with the last transition.
  # Redefines the last transition if required and if the rules don't
  # specific a constant offset, generates transitions until 100 years into
  # the future (at the time of loading zoneinfo_reader.rb).
  #
  # @param file [IO] the file being processed.
  # @param transitions [Array<TimezoneTransition>] the defined transitions.
  # @param offsets [Array<TimezoneOffset>] the offsets used by the defined
  #   transitions.
  # @param rules [Object] a {TimezoneOffset} specifying a constant offset or
  #   {AnnualRules} instance specfying transitions.
  # @raise [InvalidZoneinfoFile] if the first offset does not match the
  #   rules.
  # @raise [InvalidZoneinfoFile] if the previous offset of the first
  #   generated transition does not match the offset of the last defined
  #   transition.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:315
  def apply_rules_with_transitions(file, transitions, offsets, rules); end

  # Apply the rules from the TZ string when there were no defined
  # transitions. Checks for a matching offset. Returns the rules-based
  # constant offset or generates transitions from 1970 until 100 years into
  # the future (at the time of loading zoneinfo_reader.rb).
  #
  # @param file [IO] the file being processed.
  # @param first_offset [TimezoneOffset] the first offset included in the
  #   file that would normally apply without the rules.
  # @param rules [Object] a {TimezoneOffset} specifying a constant offset or
  #   {AnnualRules} instance specfying transitions.
  # @raise [InvalidZoneinfoFile] if the first offset does not match the
  #   rules.
  # @return [Object] either a {TimezoneOffset} or an `Array` of
  #   {TimezoneTransition}s.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:203
  def apply_rules_without_transitions(file, first_offset, rules); end

  # Reads the given number of bytes from the given file and checks that the
  # correct number of bytes could be read.
  #
  # @param file [IO] the file to read from.
  # @param bytes [Integer] the number of bytes to read.
  # @raise [InvalidZoneinfoFile] if the number of bytes available didn't
  #   match the number requested.
  # @return [String] the bytes that were read.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:80
  def check_read(file, bytes); end

  # Zoneinfo files don't include the offset from standard time (std_offset)
  # for DST periods. Derive the base offset (base_utc_offset) where DST is
  # observed from either the previous or next non-DST period.
  #
  # @param transitions [Array<Hash>] an `Array` of transition hashes.
  # @param offsets [Array<Hash>] an `Array` of offset hashes.
  # @return [Integer] the index of the offset to be used prior to the first
  #   transition.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:98
  def derive_offsets(transitions, offsets); end

  # Finds an offset that is equivalent to the one specified in the given
  # `Array`. Matching is performed with {TimezoneOffset#==}.
  #
  # @param offsets [Array<TimezoneOffset>] an `Array` to search.
  # @param offset [TimezoneOffset] the offset to search for.
  # @return [TimezoneOffset] the matching offset from `offsets` or `nil`
  #   if not found.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:237
  def find_existing_offset(offsets, offset); end

  # Translates an unsigned 32-bit integer (as returned by unpack) to signed
  # 32-bit.
  #
  # @param long [Integer] an unsigned 32-bit integer.
  # @return [Integer] {long} translated to signed 32-bit.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:56
  def make_signed_int32(long); end

  # Translates a pair of unsigned 32-bit integers (as returned by unpack,
  # most significant first) to a signed 64-bit integer.
  #
  # @param high [Integer] the most significant 32-bits.
  # @param low [Integer] the least significant 32-bits.
  # @return [Integer] {high} and {low} combined and translated to signed
  #   64-bit.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:67
  def make_signed_int64(high, low); end

  # Determines if the offset from a transition matches the offset from a
  # rule. This is a looser match than equality, not requiring that the
  # base_utc_offset and std_offset both match (which have to be derived for
  # transitions, but are known for rules.
  #
  # @param offset [TimezoneOffset] an offset from a transition.
  # @param rule_offset [TimezoneOffset] an offset from a rule.
  # @return [Boolean] whether the offsets match.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:183
  def offset_matches_rule?(offset, rule_offset); end

  # Parses a zoneinfo file and returns either a {TimezoneOffset} that is
  # constantly observed or an `Array` of {TimezoneTransition}s.
  #
  # @param file [IO] the file to be read.
  # @raise [InvalidZoneinfoFile] if the file is not a valid zoneinfo file.
  # @return [Object] either a {TimezoneOffset} or an `Array` of
  #   {TimezoneTransition}s.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:347
  def parse(file); end

  # Returns a new AnnualRules instance with standard and daylight savings
  # offsets replaced with equivalents from an array. This reduces the memory
  # requirement for loaded time zones by reusing offsets for rule-generated
  # transitions.
  #
  # @param offsets [Array<TimezoneOffset>] an `Array` to search for
  #   equivalent offsets.
  # @param annual_rules [AnnualRules] the {AnnualRules} instance to check.
  # @return [AnnualRules] either a new {AnnualRules} instance with either
  #   the {AnnualRules#std_offset std_offset} or {AnnualRules#dst_offset
  #   dst_offset} replaced, or the original instance if no equivalent for
  #   either {AnnualRules#std_offset std_offset} or {AnnualRules#dst_offset
  #   dst_offset} could be found.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:254
  def replace_with_existing_offsets(offsets, annual_rules); end

  # Validates the offset indicated to be observed by the rules before the
  # first generated transition against the offset of the last defined
  # transition.
  #
  # Fix the last defined transition if it differ on just base/std offsets
  # (which are derived). Raise an error if the observed UTC offset or
  # abbreviations differ.
  #
  # @param file [IO] the file being processed.
  # @param last_defined [TimezoneTransition] the last defined transition in
  #   the file.
  # @param first_rule_offset [TimezoneOffset] the offset the rules indicate
  #   is observed prior to the first rules generated transition.
  # @raise [InvalidZoneinfoFile] if the offset of {last_defined} and
  #   {first_rule_offset} do not match.
  # @return [TimezoneTransition] the last defined transition (either the
  #   original instance or a replacement).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:282
  def validate_and_fix_last_defined_transition_offset(file, last_defined, first_rule_offset); end
end

# The year to generate transitions up to.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/data_sources/zoneinfo_reader.rb:20
TZInfo::DataSources::ZoneinfoReader::GENERATE_UP_TO = T.let(T.unsafe(nil), Integer)

# Represents time zones that are defined by rules that set out when
# transitions occur.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_timezone.rb:8
class TZInfo::DataTimezone < ::TZInfo::InfoTimezone
  # Returns the canonical {Timezone} instance for this {DataTimezone}.
  #
  # For a {DataTimezone}, this is always `self`.
  #
  # @return [Timezone] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_timezone.rb:40
  def canonical_zone; end

  # Returns the {TimezonePeriod} that is valid at a given time.
  #
  # Unlike {period_for_local} and {period_for_utc}, the UTC offset of the
  # `time` parameter is taken into consideration.
  #
  # @param time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified
  #   offset.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at `time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_timezone.rb:9
  def period_for(time); end

  # Returns the set of {TimezonePeriod}s that are valid for the given
  # local time as an `Array`.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`).
  #
  # This will typically return an `Array` containing a single
  # {TimezonePeriod}. More than one {TimezonePeriod} will be returned when the
  # local time is ambiguous (for example, when daylight savings time ends). An
  # empty `Array` will be returned when the local time is not valid (for
  # example, when daylight savings time begins).
  #
  # To obtain just a single {TimezonePeriod} in all cases, use
  # {period_for_local} instead and specify how ambiguities should be resolved.
  #
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [Array<TimezonePeriod>] the set of {TimezonePeriod}s that are
  #   valid at `local_time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_timezone.rb:17
  def periods_for_local(local_time); end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the timezone changes.
  #
  # Transitions are returned up to a given time (`to`).
  #
  # A from time may also be supplied using the `from` parameter. If from is
  # not `nil`, only transitions from that time onwards will be returned.
  #
  # Comparisons with `to` are exclusive. Comparisons with `from` are
  # inclusive. If a transition falls precisely on `to`, it will be excluded.
  # If a transition falls on `from`, it will be included.
  #
  # @param to [Object] a `Time`, `DateTime` or {Timestamp} specifying the
  #   latest (exclusive) transition to return.
  # @param from [Object] an optional `Time`, `DateTime` or {Timestamp}
  #   specifying the earliest (inclusive) transition to return.
  # @raise [ArgumentError] if `from` is specified and `to` is not greater than
  #   `from`.
  # @raise [ArgumentError] is raised if `to` is `nil`.
  # @raise [ArgumentError] if either `to` or `from` is a {Timestamp} with an
  #   unspecified offset.
  # @return [Array<TimezoneTransition>] the transitions that are earlier than
  #   `to` and, if specified, at or later than `from`. Transitions are ordered
  #   by when they occur, from earliest to latest.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/data_timezone.rb:23
  def transitions_up_to(to, from = T.unsafe(nil)); end
end

# A subclass of `DateTime` used to represent local times. {DateTimeWithOffset}
# holds a reference to the related {TimezoneOffset} and overrides various
# methods to return results appropriate for the {TimezoneOffset}. Certain
# operations will clear the associated {TimezoneOffset} (if the
# {TimezoneOffset} would not necessarily be valid for the result). Once the
# {TimezoneOffset} has been cleared, {DateTimeWithOffset} behaves identically
# to `DateTime`.
#
# Arithmetic performed on {DateTimeWithOffset} instances is _not_ time
# zone-aware. Regardless of whether transitions in the time zone are crossed,
# results of arithmetic operations will always maintain the same offset from
# UTC (`offset`). The associated {TimezoneOffset} will aways be cleared.
#
# source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:19
class TZInfo::DateTimeWithOffset < ::DateTime
  include ::TZInfo::WithOffset

  # An overridden version of `DateTime#downto` that clears the associated
  # {TimezoneOffset} of the returned or yielded instances.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:61
  def downto(min); end

  # An overridden version of `DateTime#england` that preserves the associated
  # {TimezoneOffset}.
  #
  # @return [DateTime]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:75
  def england; end

  # An overridden version of `DateTime#gregorian` that preserves the
  # associated {TimezoneOffset}.
  #
  # @return [DateTime]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:85
  def gregorian; end

  # An overridden version of `DateTime#italy` that preserves the associated
  # {TimezoneOffset}.
  #
  # @return [DateTime]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:95
  def italy; end

  # An overridden version of `DateTime#julian` that preserves the associated
  # {TimezoneOffset}.
  #
  # @return [DateTime]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:105
  def julian; end

  # An overridden version of `DateTime#new_start` that preserves the
  # associated {TimezoneOffset}.
  #
  # @return [DateTime]
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:115
  def new_start(start = T.unsafe(nil)); end

  # Sets the associated {TimezoneOffset}.
  #
  # @param timezone_offset [TimezoneOffset] a {TimezoneOffset} valid at the
  #   time and for the offset of this {DateTimeWithOffset}.
  # @raise [ArgumentError] if `timezone_offset` is `nil`.
  # @raise [ArgumentError] if `timezone_offset.observed_utc_offset` does not
  #   equal `self.offset * 86400`.
  # @return [DateTimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:34
  def set_timezone_offset(timezone_offset); end

  # An overridden version of `DateTime#step` that clears the associated
  # {TimezoneOffset} of the returned or yielded instances.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:121
  def step(limit, step = T.unsafe(nil)); end

  # @return [TimezoneOffset] the {TimezoneOffset} associated with this
  #   instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:24
  def timezone_offset; end

  # An overridden version of `DateTime#to_time` that, if there is an
  # associated {TimezoneOffset}, returns a {DateTimeWithOffset} with that
  # offset.
  #
  # @return [Time] if there is an associated {TimezoneOffset}, a
  #   {TimeWithOffset} representation of this {DateTimeWithOffset}, otherwise
  #   a `Time` representation.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:48
  def to_time; end

  # An overridden version of `DateTime#upto` that clears the associated
  # {TimezoneOffset} of the returned or yielded instances.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:133
  def upto(max); end

  protected

  # Clears the associated {TimezoneOffset}.
  #
  # @return [DateTimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/datetime_with_offset.rb:148
  def clear_timezone_offset; end
end

# A rule that transitions on the nth occurrence of a particular day of week
# of a calendar month.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:339
class TZInfo::DayOfMonthTransitionRule < ::TZInfo::DayOfWeekTransitionRule
  # Initializes a new {DayOfMonthTransitionRule}.
  #
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @param week [Integer] the week of the month when the transition occurs (1
  #   to 4).
  # @param day_of_week [Integer] the day of the week when the transition
  #   occurs. 0 is Sunday, 6 is Saturday.
  # @param month [Integer] the month of the year when the transition occurs.
  # @raise [ArgumentError] if `week` is less than 1 or greater than 4.
  # @raise [ArgumentError] if `day_of_week` is not an `Integer`.
  # @raise [ArgumentError] if `day_of_week` is less than 0 or greater than 6.
  # @raise [ArgumentError] if `month` is less than 1 or greater than 12.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `month` is not an `Integer`.
  # @raise [ArgumentError] if `week` is not an `Integer`.
  # @return [DayOfMonthTransitionRule] a new instance of DayOfMonthTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:340
  def initialize(month, week, day_of_week, transition_at = T.unsafe(nil)); end

  # Determines if this {DayOfMonthTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfMonthTransitionRule} with the
  #   same {transition_at}, month, week and day of week as this
  #   {DayOfMonthTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:353
  def ==(r); end

  # Determines if this {DayOfMonthTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfMonthTransitionRule} with the
  #   same {transition_at}, month, week and day of week as this
  #   {DayOfMonthTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:353
  def eql?(r); end

  protected

  # Returns a `Time` representing midnight local time on the day specified by
  # the rule for the given offset and year.
  #
  # @param offset [TimezoneOffset] the current offset at the time of the
  #   transition.
  # @param year [Integer] the year in which the transition occurs.
  # @return [Time] midnight local time on the day specified by the rule for
  #   the given offset and year.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:372
  def get_day(offset, year); end

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:386
  def hash_args; end

  # @return [Integer] the day the week starts on for a month starting on a
  #   Sunday.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:362
  def offset_start; end
end

# A base class for rules that transition on a particular day of week of a
# given week (subclasses specify which week of the month).
#
# @abstract
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:273
class TZInfo::DayOfWeekTransitionRule < ::TZInfo::TransitionRule
  # Initializes a new {DayOfWeekTransitionRule}.
  #
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @param day_of_week [Integer] the day of the week when the transition
  #   occurs. 0 is Sunday, 6 is Saturday.
  # @param month [Integer] the month of the year when the transition occurs.
  # @raise [ArgumentError] if `day_of_week` is not an `Integer`.
  # @raise [ArgumentError] if `day_of_week` is less than 0 or greater than 6.
  # @raise [ArgumentError] if `month` is not an `Integer`.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `month` is less than 1 or greater than 12.
  # @return [DayOfWeekTransitionRule] a new instance of DayOfWeekTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:274
  def initialize(month, day_of_week, transition_at); end

  # Determines if this {DayOfWeekTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfWeekTransitionRule} with the
  #   same {transition_at}, month and day of week as this
  #   {DayOfWeekTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:299
  def ==(r); end

  # Determines if this {DayOfWeekTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfWeekTransitionRule} with the
  #   same {transition_at}, month and day of week as this
  #   {DayOfWeekTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:299
  def eql?(r); end

  # @return [Boolean] `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:283
  def is_always_first_day_of_year?; end

  # @return [Boolean] `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:288
  def is_always_last_day_of_year?; end

  protected

  # @return [Integer] the day of the week (0 to 6 for Sunday to Monday).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:310
  def day_of_week; end

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:313
  def hash_args; end

  # @return [Integer] the month of the year (1 to 12).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:307
  def month; end
end

# A base class for transition rules that activate based on an integer day of
# the year.
#
# @abstract
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:81
class TZInfo::DayOfYearTransitionRule < ::TZInfo::TransitionRule
  # Initializes a new {DayOfYearTransitionRule}.
  #
  # @param day [Integer] the day of the year on which the transition occurs.
  #   The precise meaning is defined by subclasses.
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `day` is not an `Integer`.
  # @return [DayOfYearTransitionRule] a new instance of DayOfYearTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:82
  def initialize(day, transition_at); end

  # Determines if this {DayOfYearTransitionRule} is equal to another instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfYearTransitionRule} with the
  #   same {transition_at} and day as this {DayOfYearTransitionRule},
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:94
  def ==(r); end

  # Determines if this {DayOfYearTransitionRule} is equal to another instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {DayOfYearTransitionRule} with the
  #   same {transition_at} and day as this {DayOfYearTransitionRule},
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:94
  def eql?(r); end

  protected

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:105
  def hash_args; end

  # @return [Integer] the day multipled by the number of seconds in a day.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:102
  def seconds; end
end

# Modules and classes used by the format 1 version of TZInfo::Data.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1.rb:7
module TZInfo::Format1; end

# Instances of {Format1::CountryDefiner} are yielded to the format 1 version
# of `TZInfo::Data::Indexes::Countries` by {CountryIndexDefinition} to allow
# the zones of a country to be specified.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/country_definer.rb:11
class TZInfo::Format1::CountryDefiner < ::TZInfo::Format2::CountryDefiner
  # Initializes a new {CountryDefiner}.
  #
  # @return [CountryDefiner] a new instance of CountryDefiner
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/country_definer.rb:12
  def initialize(identifier_deduper, description_deduper); end
end

# The format 1 TZInfo::Data country index file includes
# {Format1::CountryIndexDefinition}, which provides a
# {CountryIndexDefinition::ClassMethods#country country} method used to
# define each country in the index.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:11
module TZInfo::Format1::CountryIndexDefinition
  mixes_in_class_methods ::TZInfo::Format1::CountryIndexDefinition::ClassMethods

  class << self
    # Adds class methods to the includee and initializes class instance
    # variables.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:16
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:25
module TZInfo::Format1::CountryIndexDefinition::ClassMethods
  # @return [Hash<String, DataSources::CountryInfo>] a frozen `Hash`
  #   of all the countries that have been defined in the index keyed by
  #   their codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:29
  def countries; end

  private

  # Defines a country with an ISO 3166-1 alpha-2 country code and name.
  #
  # @param code [String] the ISO 3166-1 alpha-2 country code.
  # @param name [String] the name of the country.
  # @yield [definer] (optional) to obtain the time zones for the country.
  # @yieldparam definer [CountryDefiner] a {CountryDefiner} instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/country_index_definition.rb:42
  def country(code, name); end
end

# Instances of {Format1::TimezoneDefiner} are yielded to TZInfo::Data
# format 1 modules by {TimezoneDefinition} to allow the offsets and
# transitions of the time zone to be specified.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definer.rb:11
class TZInfo::Format1::TimezoneDefiner < ::TZInfo::Format2::TimezoneDefiner
  # Defines an offset.
  #
  # @param id [Symbol] an arbitrary value used identify the offset in
  #   subsequent calls to transition. It must be unique.
  # @param utc_offset [Integer] the base offset from UTC of the zone in
  #   seconds. This does not include daylight savings time.
  # @param std_offset [Integer] the daylight savings offset from the base
  #   offset in seconds. Typically either 0 or 3600.
  # @param abbreviation [Symbol] an abbreviation for the offset, for
  #   example, `:EST` or `:EDT`.
  # @raise [ArgumentError] if another offset has already been defined with
  #   the given id.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definer.rb:26
  def offset(id, utc_offset, std_offset, abbreviation); end

  # Defines a transition to a given offset.
  #
  # Transitions must be defined in increasing time order.
  #
  # @param year [Integer] the UTC year in which the transition occurs. Used
  #   in earlier versions of TZInfo, but now ignored.
  # @param month [Integer] the UTC month in which the transition occurs.
  #   Used in earlier versions of TZInfo, but now ignored.
  # @param offset_id [Symbol] references the id of a previously defined
  #   offset (see #offset).
  # @param timestamp_value [Integer] the time the transition occurs as an
  #   Integer number of seconds since 1970-01-01 00:00:00 UTC ignoring leap
  #   seconds (i.e. each day is treated as if it were 86,400 seconds long).
  # @param datetime_numerator [Integer] the time of the transition as the
  #   numerator of the `Rational` returned by `DateTime#ajd`. Used in
  #   earlier versions of TZInfo, but now ignored.
  # @param datetime_denominator [Integer] the time of the transition as the
  #   denominator of the `Rational` returned by `DateTime#ajd`. Used in
  #   earlier versions of TZInfo, but now ignored.
  # @raise [ArgumentError] if `offset_id` does not reference a defined
  #   offset.
  # @raise [ArgumentError] if `timestamp_value` is not greater than the
  #   `timestamp_value` of the previously defined transition.
  # @raise [ArgumentError] if `datetime_numerator` is specified, but
  #   `datetime_denominator` is not. In older versions of TZInfo, it was
  #   possible to define a transition with the `DateTime` numerator as the
  #   4th parameter and the denominator as the 5th parameter. This style of
  #   definition is not used in released versions of TZInfo::Data.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definer.rb:58
  def transition(year, month, offset_id, timestamp_value, datetime_numerator = T.unsafe(nil), datetime_denominator = T.unsafe(nil)); end
end

# {Format1::TimezoneDefinition} is included into format 1 time zone
# definition modules and provides the methods for defining time zones.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definition.rb:9
module TZInfo::Format1::TimezoneDefinition
  mixes_in_class_methods ::TZInfo::Format2::TimezoneDefinition::ClassMethods
  mixes_in_class_methods ::TZInfo::Format1::TimezoneDefinition::ClassMethods

  class << self
    # Adds class methods to the includee.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definition.rb:13
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definition.rb:22
module TZInfo::Format1::TimezoneDefinition::ClassMethods
  private

  # {Format2::TimezoneDefinition::ClassMethods#timezone}.
  #
  # @return the class to be instantiated and yielded by
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definition.rb:27
  def timezone_definer_class; end
end

# The format 1 TZInfo::Data time zone index file includes
# {Format1::TimezoneIndexDefinition}, which provides methods used to define
# time zones in the index.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:10
module TZInfo::Format1::TimezoneIndexDefinition
  mixes_in_class_methods ::TZInfo::Format1::TimezoneIndexDefinition::ClassMethods

  class << self
    # Adds class methods to the includee and initializes class instance
    # variables.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:15
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:28
module TZInfo::Format1::TimezoneIndexDefinition::ClassMethods
  # @return [Array<String>] a frozen `Array` containing the identifiers of
  #   all data time zones. Identifiers are sorted according to
  #   `String#<=>`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:32
  def data_timezones; end

  # @return [Array<String>] a frozen `Array` containing the identifiers of
  #   all linked time zones. Identifiers are sorted according to
  #   `String#<=>`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:42
  def linked_timezones; end

  private

  # Adds a linked time zone to the index.
  #
  # @param identifier [String] the time zone identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:63
  def linked_timezone(identifier); end

  # Adds a data time zone to the index.
  #
  # @param identifier [String] the time zone identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:54
  def timezone(identifier); end
end

# Modules and classes used by the format 2 version of TZInfo::Data.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2.rb:7
module TZInfo::Format2; end

# Instances of {Format2::CountryDefiner} are yielded to the format 2 version
# of `TZInfo::Data::Indexes::Countries` by {CountryIndexDefiner} to allow
# the zones of a country to be specified.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/country_definer.rb:11
class TZInfo::Format2::CountryDefiner
  # Initializes a new {CountryDefiner}.
  #
  # @param shared_timezones [Hash<Symbol, CountryTimezone>] a `Hash`
  #   containing time zones shared by more than one country, keyed by a
  #   unique reference.
  # @param identifier_deduper [StringDeduper] a {StringDeduper} instance to
  #   use when deduping time zone identifiers.
  # @param description_deduper [StringDeduper] a {StringDeduper} instance to
  #   use when deduping time zone descriptions.
  # @return [CountryDefiner] a new instance of CountryDefiner
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_definer.rb:24
  def initialize(shared_timezones, identifier_deduper, description_deduper); end

  # @overload timezone
  # @overload timezone
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_definer.rb:46
  def timezone(identifier_or_reference, latitude_numerator = T.unsafe(nil), latitude_denominator = T.unsafe(nil), longitude_numerator = T.unsafe(nil), longitude_denominator = T.unsafe(nil), description = T.unsafe(nil)); end

  # @return [Array<CountryTimezone>] the time zones observed in the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_definer.rb:13
  def timezones; end
end

# Instances of {Format2::CountryIndexDefiner} are yielded to the format 2
# version of `TZInfo::Data::Indexes::Countries` by {CountryIndexDefinition}
# to allow countries and their time zones to be specified.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definer.rb:10
class TZInfo::Format2::CountryIndexDefiner
  # Initializes a new {CountryIndexDefiner}.
  #
  # @param identifier_deduper [StringDeduper] a {StringDeduper} instance to
  #   use when deduping time zone identifiers.
  # @param description_deduper [StringDeduper] a {StringDeduper} instance to
  #   use when deduping time zone descriptions.
  # @return [CountryIndexDefiner] a new instance of CountryIndexDefiner
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definer.rb:21
  def initialize(identifier_deduper, description_deduper); end

  # @return [Hash<String, CountryInfo>] a `Hash` of all the countries that
  #   have been defined in the index keyed by their codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definer.rb:13
  def countries; end

  # Defines a country.
  #
  # @param code [String] The ISO 3166-1 alpha-2 code of the country.
  # @param name [String] Then name of the country.
  # @yield [definer] yields (optional) to obtain the time zones for the
  #   country.
  # @yieldparam definer [CountryDefiner] a {CountryDefiner}
  #   instance that should be used to specify the time zones of the country.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definer.rb:56
  def country(code, name); end

  # Defines a time zone shared by many countries with an reference for
  # subsequent use in country definitions. The latitude and longitude are
  # given as the numerator and denominator of a `Rational`.
  #
  # @param reference [Symbol] a unique reference for the time zone.
  # @param identifier [String] the time zone identifier.
  # @param latitude_numerator [Integer] the numerator of the latitude.
  # @param latitude_denominator [Integer] the denominator of the latitude.
  # @param longitude_numerator [Integer] the numerator of the longitude.
  # @param longitude_denominator [Integer] the denominator of the longitude.
  # @param description [String] an optional description for the time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definer.rb:39
  def timezone(reference, identifier, latitude_numerator, latitude_denominator, longitude_numerator, longitude_denominator, description = T.unsafe(nil)); end
end

# The format 2 country index file includes
# {Format2::CountryIndexDefinition}, which provides a
# {CountryIndexDefinition::ClassMethods#country_index country_index} method
# used to define the country index.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definition.rb:11
module TZInfo::Format2::CountryIndexDefinition
  mixes_in_class_methods ::TZInfo::Format2::CountryIndexDefinition::ClassMethods

  class << self
    # Adds class methods to the includee and initializes class instance
    # variables.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definition.rb:16
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definition.rb:25
module TZInfo::Format2::CountryIndexDefinition::ClassMethods
  # @return [Hash<String, DataSources::CountryInfo>] a frozen `Hash`
  #   of all the countries that have been defined in the index keyed by
  #   their codes.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definition.rb:29
  def countries; end

  private

  # Defines the index.
  #
  # @yield [definer] yields to allow the index to be defined.
  # @yieldparam definer [CountryIndexDefiner] a {CountryIndexDefiner}
  #   instance that should be used to define the index.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/country_index_definition.rb:38
  def country_index; end
end

# Instances of {TimezoneDefiner} are yielded to TZInfo::Data modules by
# {TimezoneDefinition} to allow the offsets and transitions of the time zone
# to be specified.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:11
class TZInfo::Format2::TimezoneDefiner
  # Initializes a new TimezoneDefiner.
  #
  # @param string_deduper [StringDeduper] a {StringDeduper} instance to use
  #   when deduping abbreviations.
  # @return [TimezoneDefiner] a new instance of TimezoneDefiner
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:20
  def initialize(string_deduper); end

  # Returns the first offset to be defined or `nil` if no offsets have been
  #  defined. The first offset is observed before the time of the first
  #  transition.
  #
  # @return [TimezoneOffset] the first offset to be defined or `nil` if no
  #   offsets have been defined.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:32
  def first_offset; end

  # Defines an offset.
  #
  # @param id [Symbol] an arbitrary value used identify the offset in
  #   subsequent calls to transition. It must be unique.
  # @param base_utc_offset [Integer] the base offset from UTC of the zone in
  #   seconds. This does not include daylight savings time.
  # @param std_offset [Integer] the daylight savings offset from the base
  #   offset in seconds. Typically either 0 or 3600.
  # @param abbreviation [String] an abbreviation for the offset, for
  #   example, EST or EDT.
  # @raise [ArgumentError] if another offset has already been defined with
  #   the given id.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:49
  def offset(id, base_utc_offset, std_offset, abbreviation); end

  # Defines the rules that will be used for handling instants after the last
  # transition.
  #
  # This method is currently just a placeholder for forward compatibility
  # that accepts and ignores any arguments passed.
  #
  # Support for subsequent rules will be added in a future version of TZInfo
  # and the rules will be included in format 2 releases of TZInfo::Data.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:90
  def subsequent_rules(*args); end

  # Defines a transition to a given offset.
  #
  # Transitions must be defined in increasing time order.
  #
  # @param offset_id [Symbol] references the id of a previously defined
  #   offset.
  # @param timestamp_value [Integer] the time the transition occurs as a
  #   number of seconds since 1970-01-01 00:00:00 UTC ignoring leap seconds
  #   (i.e. each day is treated as if it were 86,400 seconds long).
  # @raise [ArgumentError] if `offset_id` does not reference a defined
  #   offset.
  # @raise [ArgumentError] if `timestamp_value` is not greater than the
  #   `timestamp_value` of the previously defined transition.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:74
  def transition(offset_id, timestamp_value); end

  # @return [Array<TimezoneTransition>] the defined transitions of the time
  #   zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definer.rb:14
  def transitions; end
end

# {Format2::TimezoneDefinition} is included into format 2 time zone
# definition modules and provides methods for defining time zones.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:9
module TZInfo::Format2::TimezoneDefinition
  mixes_in_class_methods ::TZInfo::Format2::TimezoneDefinition::ClassMethods

  class << self
    # Adds class methods to the includee.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:13
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:21
module TZInfo::Format2::TimezoneDefinition::ClassMethods
  # @return [TimezoneInfo] the last time zone to be defined.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:23
  def get; end

  private

  # Defines a linked time zone.
  #
  # @param identifier [String] the identifier of the time zone being
  #   defined.
  # @param link_to_identifier [String] the identifier the new time zone
  #   links to (is an alias for).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:64
  def linked_timezone(identifier, link_to_identifier); end

  # Defines a data time zone.
  #
  # @param identifier [String] the identifier of the time zone.
  # @yield [definer] yields to the caller to define the time zone.
  # @yieldparam definer [Object] an instance of the class returned by
  #   {#timezone_definer_class}, typically {TimezoneDefiner}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:41
  def timezone(identifier); end

  # @return [Class] the class to be instantiated and yielded by
  #   {#timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_definition.rb:31
  def timezone_definer_class; end
end

# Instances of {TimezoneIndexDefiner} are yielded by
# {TimezoneIndexDefinition} to allow the time zone index to be defined.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:9
class TZInfo::Format2::TimezoneIndexDefiner
  # Initializes a new TimezoneDefiner.
  #
  # @param string_deduper [StringDeduper] a {StringDeduper} instance to use
  #   when deduping identifiers.
  # @return [TimezoneIndexDefiner] a new instance of TimezoneIndexDefiner
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:20
  def initialize(string_deduper); end

  # Adds a data time zone to the index.
  #
  # @param identifier [String] the time zone identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:29
  def data_timezone(identifier); end

  # @return [Array<String>] the identifiers of all data time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:11
  def data_timezones; end

  # Adds a linked time zone to the index.
  #
  # @param identifier [String] the time zone identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:38
  def linked_timezone(identifier); end

  # @return [Array<String>] the identifiers of all linked time zones.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definer.rb:14
  def linked_timezones; end
end

# The format 2 time zone index file includes {TimezoneIndexDefinition},
# which provides the {TimezoneIndexDefinition::ClassMethods#timezone_index
# timezone_index} method used to define the index.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:10
module TZInfo::Format2::TimezoneIndexDefinition
  mixes_in_class_methods ::TZInfo::Format2::TimezoneIndexDefinition::ClassMethods

  class << self
    # Adds class methods to the includee and initializes class instance
    # variables.
    #
    # @param base [Module] the includee.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:15
    def append_features(base); end
  end
end

# Class methods for inclusion.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:29
module TZInfo::Format2::TimezoneIndexDefinition::ClassMethods
  # @return [Array<String>] a frozen `Array` containing the identifiers of
  #   all data time zones. Identifiers are sorted according to
  #   `String#<=>`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:33
  def data_timezones; end

  # @return [Array<String>] a frozen `Array` containing the identifiers of
  #   all linked time zones. Identifiers are sorted according to
  #   `String#<=>`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:38
  def linked_timezones; end

  # Defines the index.
  #
  # @yield [definer] yields to the caller to allow the index to be
  #   defined.
  # @yieldparam definer [TimezoneIndexDefiner] a {TimezoneIndexDefiner}
  #   instance that should be used to define the index.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/format2/timezone_index_definition.rb:46
  def timezone_index; end
end

# A {Timezone} based on a {DataSources::TimezoneInfo}.
#
# @abstract
#
# source://tzinfo-2.0.5/lib/tzinfo/info_timezone.rb:16
class TZInfo::InfoTimezone < ::TZInfo::Timezone
  # Initializes a new {InfoTimezone}.
  #
  # {InfoTimezone} instances should not normally be created directly. Use
  # the {Timezone.get} method to obtain {Timezone} instances.
  #
  # @param info [DataSources::TimezoneInfo] a {DataSources::TimezoneInfo}
  #   instance supplied by a {DataSource} that will be used as the source of
  #   data for this {InfoTimezone}.
  # @return [InfoTimezone] a new instance of InfoTimezone
  #
  # source://tzinfo-2.0.5/lib/tzinfo/info_timezone.rb:17
  def initialize(info); end

  # @return [String] the identifier of the time zone, for example,
  #   `"Europe/Paris"`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/info_timezone.rb:23
  def identifier; end

  protected

  # @return [DataSources::TimezoneInfo] the {DataSources::TimezoneInfo} this
  #   {InfoTimezone} is based on.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/info_timezone.rb:31
  def info; end
end

# {InvalidCountryCode} is raised by {Country#get} if the code given is not a
# valid ISO 3166-1 alpha-2 code.
#
# source://tzinfo-2.0.5/lib/tzinfo/country.rb:7
class TZInfo::InvalidCountryCode < ::StandardError; end

# {InvalidDataSource} is raised if the selected {DataSource} doesn't implement
# one of the required methods.
#
# source://tzinfo-2.0.5/lib/tzinfo/data_source.rb:10
class TZInfo::InvalidDataSource < ::StandardError; end

# {InvalidTimezoneIdentifier} is raised by {Timezone.get} if the identifier
# given is not valid.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:26
class TZInfo::InvalidTimezoneIdentifier < ::StandardError; end

# Defines transitions that occur on the one-based nth Julian day of the year.
#
# Leap days are not counted. Day 1 is 1 January. Day 60 is always 1 March.
# Day 365 is always 31 December.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:185
class TZInfo::JulianDayOfYearTransitionRule < ::TZInfo::DayOfYearTransitionRule
  # Initializes a new {JulianDayOfYearTransitionRule}.
  #
  # @param day [Integer] the one-based Julian day of the year on which the
  #   transition occurs (1 to 365 inclusive).
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `day` is not an `Integer`.
  # @raise [ArgumentError] if `day` is less than 1 or greater than 365.
  # @return [JulianDayOfYearTransitionRule] a new instance of JulianDayOfYearTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:202
  def initialize(day, transition_at = T.unsafe(nil)); end

  # Determines if this {JulianDayOfYearTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {JulianDayOfYearTransitionRule} with
  #   the same {transition_at} and day as this
  #   {JulianDayOfYearTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:226
  def ==(r); end

  # Determines if this {JulianDayOfYearTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {JulianDayOfYearTransitionRule} with
  #   the same {transition_at} and day as this
  #   {JulianDayOfYearTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:226
  def eql?(r); end

  # @return [Boolean] `true` if the day specified by this transition is the
  #   first in the year (a day number of 1), otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:209
  def is_always_first_day_of_year?; end

  # @return [Boolean] `true` if the day specified by this transition is the
  #   last in the year (a day number of 365), otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:215
  def is_always_last_day_of_year?; end

  protected

  # Returns a `Time` representing midnight local time on the day specified by
  # the rule for the given offset and year.
  #
  # @param offset [TimezoneOffset] the current offset at the time of the
  #   transition.
  # @param year [Integer] the year in which the transition occurs.
  # @return [Time] midnight local time on the day specified by the rule for
  #   the given offset and year.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:241
  def get_day(offset, year); end

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:250
  def hash_args; end
end

# The 60 days in seconds.
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:186
TZInfo::JulianDayOfYearTransitionRule::LEAP = T.let(T.unsafe(nil), Integer)

# The length of a non-leap year in seconds.
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:190
TZInfo::JulianDayOfYearTransitionRule::YEAR = T.let(T.unsafe(nil), Integer)

# A rule that transitions on the last occurrence of a particular day of week
# of a calendar month.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:408
class TZInfo::LastDayOfMonthTransitionRule < ::TZInfo::DayOfWeekTransitionRule
  # Initializes a new {LastDayOfMonthTransitionRule}.
  #
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @param day_of_week [Integer] the day of the week when the transition
  #   occurs. 0 is Sunday, 6 is Saturday.
  # @param month [Integer] the month of the year when the transition occurs.
  # @raise [ArgumentError] if `day_of_week` is not an `Integer`.
  # @raise [ArgumentError] if `day_of_week` is less than 0 or greater than 6.
  # @raise [ArgumentError] if `month` is not an `Integer`.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @raise [ArgumentError] if `month` is less than 1 or greater than 12.
  # @return [LastDayOfMonthTransitionRule] a new instance of LastDayOfMonthTransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:409
  def initialize(month, day_of_week, transition_at = T.unsafe(nil)); end

  # Determines if this {LastDayOfMonthTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {LastDayOfMonthTransitionRule} with
  #   the same {transition_at}, month and day of week as this
  #   {LastDayOfMonthTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:420
  def ==(r); end

  # Determines if this {LastDayOfMonthTransitionRule} is equal to another
  # instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {LastDayOfMonthTransitionRule} with
  #   the same {transition_at}, month and day of week as this
  #   {LastDayOfMonthTransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:420
  def eql?(r); end

  protected

  # Returns a `Time` representing midnight local time on the day specified by
  # the rule for the given offset and year.
  #
  # @param offset [TimezoneOffset] the current offset at the time of the
  #   transition.
  # @param year [Integer] the year in which the transition occurs.
  # @return [Time] midnight local time on the day specified by the rule for
  #   the given offset and year.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:435
  def get_day(offset, year); end
end

# Represents time zones that are defined as a link to or alias for another
# time zone.
#
# source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:14
class TZInfo::LinkedTimezone < ::TZInfo::InfoTimezone
  # Initializes a new {LinkedTimezone}.
  #
  # {LinkedTimezone} instances should not normally be created directly. Use
  # the {Timezone.get} method to obtain {Timezone} instances.
  #
  # @param info [DataSources::LinkedTimezoneInfo] a
  #   {DataSources::LinkedTimezoneInfo} instance supplied by a {DataSource}
  #   that will be used as the source of data for this {LinkedTimezone}.
  # @return [LinkedTimezone] a new instance of LinkedTimezone
  #
  # source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:15
  def initialize(info); end

  # Returns the canonical {Timezone} instance for this {LinkedTimezone}.
  #
  # For a {LinkedTimezone}, this is the canonical zone of the link target.
  #
  # @return [Timezone] the canonical {Timezone} instance for this {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:40
  def canonical_zone; end

  # Returns the {TimezonePeriod} that is valid at a given time.
  #
  # Unlike {period_for_local} and {period_for_utc}, the UTC offset of the
  # `time` parameter is taken into consideration.
  #
  # @param time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified
  #   offset.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at `time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:21
  def period_for(time); end

  # Returns the set of {TimezonePeriod}s that are valid for the given
  # local time as an `Array`.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`).
  #
  # This will typically return an `Array` containing a single
  # {TimezonePeriod}. More than one {TimezonePeriod} will be returned when the
  # local time is ambiguous (for example, when daylight savings time ends). An
  # empty `Array` will be returned when the local time is not valid (for
  # example, when daylight savings time begins).
  #
  # To obtain just a single {TimezonePeriod} in all cases, use
  # {period_for_local} instead and specify how ambiguities should be resolved.
  #
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [Array<TimezonePeriod>] the set of {TimezonePeriod}s that are
  #   valid at `local_time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:26
  def periods_for_local(local_time); end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the timezone changes.
  #
  # Transitions are returned up to a given time (`to`).
  #
  # A from time may also be supplied using the `from` parameter. If from is
  # not `nil`, only transitions from that time onwards will be returned.
  #
  # Comparisons with `to` are exclusive. Comparisons with `from` are
  # inclusive. If a transition falls precisely on `to`, it will be excluded.
  # If a transition falls on `from`, it will be included.
  #
  # @param to [Object] a `Time`, `DateTime` or {Timestamp} specifying the
  #   latest (exclusive) transition to return.
  # @param from [Object] an optional `Time`, `DateTime` or {Timestamp}
  #   specifying the earliest (inclusive) transition to return.
  # @raise [ArgumentError] if `from` is specified and `to` is not greater than
  #   `from`.
  # @raise [ArgumentError] is raised if `to` is `nil`.
  # @raise [ArgumentError] if either `to` or `from` is a {Timestamp} with an
  #   unspecified offset.
  # @return [Array<TimezoneTransition>] the transitions that are earlier than
  #   `to` and, if specified, at or later than `from`. Transitions are ordered
  #   by when they occur, from earliest to latest.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/linked_timezone.rb:31
  def transitions_up_to(to, from = T.unsafe(nil)); end
end

# Represents the infinite period of time in a time zone that constantly
# observes the same offset from UTC (has an unbounded start and end).
#
# source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:10
class TZInfo::OffsetTimezonePeriod < ::TZInfo::TimezonePeriod
  # Initializes an {OffsetTimezonePeriod}.
  #
  # @param offset [TimezoneOffset] the offset that is constantly observed.
  # @raise [ArgumentError] if `offset` is `nil`.
  # @return [OffsetTimezonePeriod] a new instance of OffsetTimezonePeriod
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:11
  def initialize(offset); end

  # Determines if this {OffsetTimezonePeriod} is equal to another instance.
  #
  # @param p [Object] the instance to test for equality.
  # @return [Boolean] `true` if `p` is a {OffsetTimezonePeriod} with the same
  #   {offset}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:32
  def ==(p); end

  # @return [TimezoneTransition] the transition that defines the end of this
  #   {TimezonePeriod}, always `nil` for {OffsetTimezonePeriod}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:23
  def end_transition; end

  # Determines if this {OffsetTimezonePeriod} is equal to another instance.
  #
  # @param p [Object] the instance to test for equality.
  # @return [Boolean] `true` if `p` is a {OffsetTimezonePeriod} with the same
  #   {offset}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:32
  def eql?(p); end

  # @return [Integer] a hash based on {offset}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:38
  def hash; end

  # @return [TimezoneTransition] the transition that defines the start of this
  #   {TimezonePeriod}, always `nil` for {OffsetTimezonePeriod}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/offset_timezone_period.rb:17
  def start_transition; end
end

# {PeriodNotFound} is raised to indicate that no {TimezonePeriod} matching a
# given time could be found.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:21
class TZInfo::PeriodNotFound < ::StandardError; end

# Maintains a pool of `String` instances. The {#dedupe} method will return
# either a pooled copy of a given `String` or add the instance to the pool.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:11
class TZInfo::StringDeduper
  # Initializes a new {StringDeduper}.
  #
  # @return [StringDeduper] a new instance of StringDeduper
  #
  # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:20
  def initialize; end

  # @param string [String] the string to deduplicate.
  # @return [bool] `string` if it is frozen, otherwise a frozen, possibly
  #   pre-existing copy of `string`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:30
  def dedupe(string); end

  protected

  # Creates a `Hash` to store pooled `String` instances.
  #
  # @param block [Proc] Default value block to be passed to `Hash.new`.
  # @return [Hash] a `Hash` to store pooled `String` instances.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:41
  def create_hash(&block); end

  class << self
    # @return [StringDeduper] a globally available singleton instance of
    #   {StringDeduper}. This instance is safe for use in concurrently
    #   executing threads.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:16
    def global; end
  end
end

# A subclass of `Time` used to represent local times. {TimeWithOffset} holds a
# reference to the related {TimezoneOffset} and overrides various methods to
# return results appropriate for the {TimezoneOffset}. Certain operations will
# clear the associated {TimezoneOffset} (if the {TimezoneOffset} would not
# necessarily be valid for the result). Once the {TimezoneOffset} has been
# cleared, {TimeWithOffset} behaves identically to `Time`.
#
# Arithmetic performed on {TimeWithOffset} instances is _not_ time zone-aware.
# Regardless of whether transitions in the time zone are crossed, results of
# arithmetic operations will always maintain the same offset from UTC
# (`utc_offset`). The associated {TimezoneOffset} will aways be cleared.
#
# source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:16
class TZInfo::TimeWithOffset < ::Time
  include ::TZInfo::WithOffset

  # An overridden version of `Time#dst?` that, if there is an associated
  # {TimezoneOffset}, returns the result of calling {TimezoneOffset#dst? dst?}
  # on that offset.
  #
  # @return [Boolean] `true` if daylight savings time is being observed,
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:43
  def dst?; end

  # An overridden version of `Time#getlocal` that clears the associated
  # {TimezoneOffset} if the base implementation of `getlocal` returns a
  # {TimeWithOffset}.
  #
  # @return [Time] a representation of the {TimeWithOffset} using either the
  #   local time zone or the given offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:55
  def getlocal(*args); end

  # An overridden version of `Time#gmtime` that clears the associated
  # {TimezoneOffset}.
  #
  # @return [TimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:69
  def gmtime; end

  # An overridden version of `Time#dst?` that, if there is an associated
  # {TimezoneOffset}, returns the result of calling {TimezoneOffset#dst? dst?}
  # on that offset.
  #
  # @return [Boolean] `true` if daylight savings time is being observed,
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:43
  def isdst; end

  # An overridden version of `Time#localtime` that clears the associated
  # {TimezoneOffset}.
  #
  # @return [TimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:79
  def localtime(*args); end

  # An overridden version of `Time#round` that, if there is an associated
  # {TimezoneOffset}, returns a {TimeWithOffset} preserving that offset.
  #
  # @return [Time] the rounded time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:89
  def round(ndigits = T.unsafe(nil)); end

  # Marks this {TimeWithOffset} as a local time with the UTC offset of a given
  # {TimezoneOffset} and sets the associated {TimezoneOffset}.
  #
  # @param timezone_offset [TimezoneOffset] the {TimezoneOffset} to use to set
  #   the offset of this {TimeWithOffset}.
  # @raise [ArgumentError] if `timezone_offset` is `nil`.
  # @return [TimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:30
  def set_timezone_offset(timezone_offset); end

  # @return [TimezoneOffset] the {TimezoneOffset} associated with this
  #   instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:21
  def timezone_offset; end

  # An overridden version of `Time#to_a`. The `isdst` (index 8) and `zone`
  # (index 9) elements of the array are set according to the associated
  # {TimezoneOffset}.
  #
  # @return [Array] an `Array` representation of the {TimeWithOffset}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:98
  def to_a; end

  # An overridden version of `Time#to_datetime` that, if there is an
  # associated {TimezoneOffset}, returns a {DateTimeWithOffset} with that
  # offset.
  #
  # @return [DateTime] if there is an associated {TimezoneOffset}, a
  #   {DateTimeWithOffset} representation of this {TimeWithOffset}, otherwise
  #   a `Time` representation.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:135
  def to_datetime; end

  # An overridden version of `Time#utc` that clears the associated
  # {TimezoneOffset}.
  #
  # @return [TimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:110
  def utc; end

  # An overridden version of `Time#zone` that, if there is an associated
  # {TimezoneOffset}, returns the {TimezoneOffset#abbreviation abbreviation}
  # of that offset.
  #
  # @return [String] the {TimezoneOffset#abbreviation abbreviation} of the
  #   associated {TimezoneOffset}, or the result from `Time#zone` if there is
  #   no such offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:123
  def zone; end

  protected

  # Clears the associated {TimezoneOffset}.
  #
  # @return [TimeWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/time_with_offset.rb:149
  def clear_timezone_offset; end
end

# A time represented as an `Integer` number of seconds since 1970-01-01
# 00:00:00 UTC (ignoring leap seconds and using the proleptic Gregorian
# calendar), the fraction through the second (sub_second as a `Rational`) and
# an optional UTC offset. Like Ruby's `Time` class, {Timestamp} can
# distinguish between a local time with a zero offset and a time specified
# explicitly as UTC.
#
# source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:11
class TZInfo::Timestamp
  include ::Comparable

  # Initializes a new {Timestamp}.
  #
  # @param value [Integer] the number of seconds since 1970-01-01 00:00:00 UTC
  #   ignoring leap seconds.
  # @param utc_offset [Object] either `nil` for a {Timestamp} without a
  #   specified offset, an offset from UTC specified as an `Integer` number of
  #   seconds or the `Symbol` `:utc`).
  # @param sub_second [Numeric] the fractional part of the second as either a
  #   `Rational` that is greater than or equal to 0 and less than 1, or
  #   the `Integer` 0.
  # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer` and
  #   not the `Symbol` `:utc`.
  # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
  #   `Integer` 0.
  # @raise [ArgumentError] if `value` is not an `Integer`.
  # @raise [RangeError] if `sub_second` is a `Rational` but that is less
  #   than 0 or greater than or equal to 1.
  # @return [Timestamp] a new instance of Timestamp
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:344
  def initialize(value, sub_second = T.unsafe(nil), utc_offset = T.unsafe(nil)); end

  # Compares this {Timestamp} with another.
  #
  # {Timestamp} instances without a defined UTC offset are not comparable with
  # {Timestamp} instances that have a defined UTC offset.
  #
  # @param t [Timestamp] the {Timestamp} to compare this instance with.
  # @return [Integer] -1, 0 or 1 depending if this instance is earlier, equal
  #   or later than `t` respectively. Returns `nil` when comparing a
  #   {Timestamp} that does not have a defined UTC offset with a {Timestamp}
  #   that does have a defined UTC offset. Returns `nil` if `t` is not a
  #   {Timestamp}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:454
  def <=>(t); end

  # Adds a number of seconds to the {Timestamp} value, setting the UTC offset
  # of the result.
  #
  # @param seconds [Integer] the number of seconds to be added.
  # @param utc_offset [Object] either `nil` for a {Timestamp} without a
  #   specified offset, an offset from UTC specified as an `Integer` number of
  #   seconds or the `Symbol` `:utc`).
  # @raise [ArgumentError] if `seconds` is not an `Integer`.
  # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer` and
  #   not the `Symbol` `:utc`.
  # @return [Timestamp] the result of adding `seconds` to the
  #   {Timestamp} value as a new {Timestamp} instance with the chosen
  #   `utc_offset`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:372
  def add_and_set_utc_offset(seconds, utc_offset); end

  def eql?(_arg0); end

  # @return [Integer] a hash based on the value, sub-second and whether there
  #   is a defined UTC offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:468
  def hash; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:474
  def inspect; end

  # Formats this {Timestamp} according to the directives in the given format
  # string.
  #
  # @param format [String] the format string. Please refer to `Time#strftime`
  #   for a list of supported format directives.
  # @raise [ArgumentError] if `format` is not specified.
  # @return [String] the formatted {Timestamp}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:426
  def strftime(format); end

  # @return [Numeric] the fraction of a second elapsed since timestamp as
  #   either a `Rational` or the `Integer` 0. Always greater than or equal to
  #   0 and less than 1.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:321
  def sub_second; end

  # Converts this {Timestamp} to a Gregorian `DateTime`.
  #
  # @return [DateTime] a Gregorian `DateTime` representation of this
  #   {Timestamp}. If the UTC offset of this {Timestamp} is not specified, a
  #   UTC `DateTime` will be returned.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:406
  def to_datetime; end

  # Converts this {Timestamp} to an `Integer` number of seconds since
  # 1970-01-01 00:00:00 UTC (ignoring leap seconds).
  #
  # @return [Integer] an `Integer` representation of this {Timestamp} (the
  #   number of seconds since 1970-01-01 00:00:00 UTC ignoring leap seconds).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:415
  def to_i; end

  # @return [String] a `String` representation of this {Timestamp}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:432
  def to_s; end

  # Converts this {Timestamp} to a `Time`.
  #
  # @return [Time] a `Time` representation of this {Timestamp}. If the UTC
  #   offset of this {Timestamp} is not specified, a UTC `Time` will be
  #   returned.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:391
  def to_time; end

  # @return [Timestamp] a UTC {Timestamp} equivalent to this instance. Returns
  #   `self` if {#utc? self.utc?} is `true`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:381
  def utc; end

  # @return [Boolean] `true` if this {Timestamp} represents UTC, `false` if
  #   the {Timestamp} wasn't specified as UTC or `nil` if the {Timestamp} has
  #   no specified offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:355
  def utc?; end

  # @return [Integer] the offset from UTC in seconds or `nil` if the
  #   {Timestamp} doesn't have a specified offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:325
  def utc_offset; end

  # @return [Integer] the number of seconds since 1970-01-01 00:00:00 UTC
  #   ignoring leap seconds (i.e. each day is treated as if it were 86,400
  #   seconds long).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:316
  def value; end

  protected

  # Constructs a new instance of a `DateTime` or `DateTime`-like class with
  # the same {value}, {sub_second} and {utc_offset} as this {Timestamp}.
  #
  # @param klass [Class] the class to instantiate.
  # @private
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:496
  def new_datetime(klass = T.unsafe(nil)); end

  # Creates a new instance of a `Time` or `Time`-like class matching the
  # {value} and {sub_second} of this {Timestamp}, but not setting the offset.
  #
  # @param klass [Class] the class to instantiate.
  # @private
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:486
  def new_time(klass = T.unsafe(nil)); end

  private

  # Initializes a new {Timestamp} without validating the parameters. This
  # method is used internally within {Timestamp} to avoid the overhead of
  # checking parameters.
  #
  # @param value [Integer] the number of seconds since 1970-01-01 00:00:00 UTC
  #   ignoring leap seconds.
  # @param sub_second [Numeric] the fractional part of the second as either a
  #   `Rational` that is greater than or equal to 0 and less than 1, or the
  #   `Integer` 0.
  # @param utc_offset [Object] either `nil` for a {Timestamp} without a
  #   specified offset, an offset from UTC specified as an `Integer` number of
  #   seconds or the `Symbol` `:utc`).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:538
  def initialize!(value, sub_second = T.unsafe(nil), utc_offset = T.unsafe(nil)); end

  # Converts the {sub_second} value to a `String` suitable for appending to
  # the `String` representation of a {Timestamp}.
  #
  # @return [String] a `String` representation of {sub_second}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:518
  def sub_second_to_s; end

  # Converts the value and sub-seconds to a `String`, adding on the given
  # offset.
  #
  # @param offset [Integer] the offset to add to the value.
  # @return [String] the value and sub-seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:510
  def value_and_sub_second_to_s(offset = T.unsafe(nil)); end

  class << self
    # Returns a new {Timestamp} representing the (proleptic Gregorian
    # calendar) date and time specified by the supplied parameters.
    #
    # If `utc_offset` is `nil`, `:utc` or 0, the date and time parameters will
    # be interpreted as representing a UTC date and time. Otherwise the date
    # and time parameters will be interpreted as a local date and time with
    # the given offset.
    #
    # @param month [Integer] the month (1-12).
    # @param day [Integer] the day of the month (1-31).
    # @param hour [Integer] the hour (0-23).
    # @param minute [Integer] the minute (0-59).
    # @param second [Integer] the second (0-59).
    # @param sub_second [Numeric] the fractional part of the second as either
    #   a `Rational` that is greater than or equal to 0 and less than 1, or
    #   the `Integer` 0.
    # @param utc_offset [Object] either `nil` for a {Timestamp} without a
    #   specified offset, an offset from UTC specified as an `Integer` number
    #   of seconds or the `Symbol` `:utc`).
    # @param year [Integer] the year.
    # @raise [RangeError] if `sub_second` is a `Rational` but that is less
    #   than 0 or greater than or equal to 1.
    # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
    #   `Integer` 0.
    # @raise [ArgumentError] if either of `year`, `month`, `day`, `hour`,
    #   `minute`, or `second` is not an `Integer`.
    # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer`
    #   and not the `Symbol` `:utc`.
    # @raise [RangeError] if `month` is not between 1 and 12.
    # @raise [RangeError] if `day` is not between 1 and 31.
    # @raise [RangeError] if `hour` is not between 0 and 23.
    # @raise [RangeError] if `minute` is not between 0 and 59.
    # @raise [RangeError] if `second` is not between 0 and 59.
    # @return [Timestamp] a new {Timestamp} representing the specified
    #   (proleptic Gregorian calendar) date and time.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:55
    def create(year, month = T.unsafe(nil), day = T.unsafe(nil), hour = T.unsafe(nil), minute = T.unsafe(nil), second = T.unsafe(nil), sub_second = T.unsafe(nil), utc_offset = T.unsafe(nil)); end

    # When used without a block, returns a {Timestamp} representation of a
    # given `Time`, `DateTime` or {Timestamp}.
    #
    # When called with a block, the {Timestamp} representation of `value` is
    # passed to the block. The block must then return a {Timestamp}, which
    # will be converted back to the type of the initial value. If the initial
    # value was a {Timestamp}, the block result will be returned. If the
    # initial value was a `DateTime`, a Gregorian `DateTime` will be returned.
    #
    # The UTC offset of `value` can either be preserved (the {Timestamp}
    # representation will have the same UTC offset as `value`), ignored (the
    # {Timestamp} representation will have no defined UTC offset), or treated
    # as though it were UTC (the {Timestamp} representation will have a
    # {utc_offset} of 0 and {utc?} will return `true`).
    #
    # @param value [Object] a `Time`, `DateTime` or {Timestamp}.
    # @param offset [Symbol] either `:preserve` to preserve the offset of
    #   `value`, `:ignore` to ignore the offset of `value` and create a
    #   {Timestamp} with an unspecified offset, or `:treat_as_utc` to treat
    #   the offset of `value` as though it were UTC and create a UTC
    #   {Timestamp}.
    # @raise [ArgumentError]
    # @return [Object] if called without a block, the {Timestamp}
    #   representation of `value`, otherwise the result of the block,
    #   converted back to the type of `value`.
    # @yield [timestamp] if a block is provided, the {Timestamp}
    #   representation is passed to the block.
    # @yieldparam timestamp [Timestamp] the {Timestamp} representation of
    #   `value`.
    # @yieldreturn [Timestamp] a {Timestamp} to be converted back to the type
    #   of `value`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:112
    def for(value, offset = T.unsafe(nil)); end

    # Creates a new UTC {Timestamp}.
    #
    # @param value [Integer] the number of seconds since 1970-01-01 00:00:00
    #   UTC ignoring leap seconds.
    # @param sub_second [Numeric] the fractional part of the second as either
    #   a `Rational` that is greater than or equal to 0 and less than 1, or
    #   the `Integer` 0.
    # @raise [ArgumentError] if `value` is not an `Integer`.
    # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
    #   `Integer` 0.
    # @raise [RangeError] if `sub_second` is a `Rational` but that is less
    #   than 0 or greater than or equal to 1.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:172
    def utc(value, sub_second = T.unsafe(nil)); end

    private

    # Creates a {Timestamp} that represents a given `DateTime`, optionally
    # ignoring the offset.
    #
    # @param datetime [DateTime] a `DateTime`.
    # @param ignore_offset [Boolean] whether to ignore the offset of
    #   `datetime`.
    # @param target_utc_offset [Object] if `ignore_offset` is `true`, the UTC
    #   offset of the result (`:utc`, `nil` or an `Integer`).
    # @return [Timestamp] the {Timestamp} representation of `datetime`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:231
    def for_datetime(datetime, ignore_offset, target_utc_offset); end

    # Creates a {Timestamp} that represents a given `Time`, optionally
    # ignoring the offset.
    #
    # @param time [Time] a `Time`.
    # @param ignore_offset [Boolean] whether to ignore the offset of `time`.
    # @param target_utc_offset [Object] if `ignore_offset` is `true`, the UTC
    #   offset of the result (`:utc`, `nil` or an `Integer`).
    # @return [Timestamp] the {Timestamp} representation of `time`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:206
    def for_time(time, ignore_offset, target_utc_offset); end

    # Creates a {Timestamp} that represents a given `Time`-like object,
    # optionally ignoring the offset (if the `time_like` responds to
    # `utc_offset`).
    #
    # @param time_like [Object] a `Time`-like object.
    # @param ignore_offset [Boolean] whether to ignore the offset of `time`.
    # @param target_utc_offset [Object] if `ignore_offset` is `true`, the UTC
    #   offset of the result (`:utc`, `nil` or an `Integer`).
    # @return [Timestamp] the {Timestamp} representation of `time_like`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:296
    def for_time_like(time_like, ignore_offset, target_utc_offset); end

    # Returns a {Timestamp} that represents another {Timestamp}, optionally
    # ignoring the offset. If the result would be identical to `value`, the
    # same instance is returned. If the passed in value is an instance of a
    # subclass of {Timestamp}, then a new {Timestamp} will always be returned.
    #
    # @param timestamp [Timestamp] a {Timestamp}.
    # @param ignore_offset [Boolean] whether to ignore the offset of
    #   `timestamp`.
    # @param target_utc_offset [Object] if `ignore_offset` is `true`, the UTC
    #   offset of the result (`:utc`, `nil` or an `Integer`).
    # @return [Timestamp] a [Timestamp] representation of `timestamp`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:256
    def for_timestamp(timestamp, ignore_offset, target_utc_offset); end

    # Determines if an object is like a `Time` (for the purposes of converting
    # to a {Timestamp} with {for}), responding to `to_i` and `subsec`.
    #
    # @param value [Object] an object to test.
    # @return [Boolean] `true` if the object is `Time`-like, otherwise
    #   `false`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:283
    def is_time_like?(value); end

    # Constructs a new instance of `self` (i.e. {Timestamp} or a subclass of
    # {Timestamp}) without validating the parameters. This method is used
    # internally within {Timestamp} to avoid the overhead of checking
    # parameters.
    #
    # @param value [Integer] the number of seconds since 1970-01-01 00:00:00
    #   UTC ignoring leap seconds.
    # @param sub_second [Numeric] the fractional part of the second as either
    #   a `Rational` that is greater than or equal to 0 and less than 1, or
    #   the `Integer` 0.
    # @param utc_offset [Object] either `nil` for a {Timestamp} without a
    #   specified offset, an offset from UTC specified as an `Integer` number
    #   of seconds or the `Symbol` `:utc`).
    # @return [Timestamp] a new instance of `self`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:192
    def new!(value, sub_second = T.unsafe(nil), utc_offset = T.unsafe(nil)); end
  end
end

# The Unix epoch (1970-01-01 00:00:00 UTC) as a chronological Julian day
# number.
#
# source://tzinfo-2.0.5/lib/tzinfo/timestamp.rb:16
TZInfo::Timestamp::JD_EPOCH = T.let(T.unsafe(nil), Integer)

# A subclass of {Timestamp} used to represent local times.
# {TimestampWithOffset} holds a reference to the related {TimezoneOffset} and
# overrides various methods to return results appropriate for the
# {TimezoneOffset}. Certain operations will clear the associated
# {TimezoneOffset} (if the {TimezoneOffset} would not necessarily be valid for
# the result). Once the {TimezoneOffset} has been cleared,
# {TimestampWithOffset} behaves identically to {Timestamp}.
#
# source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:12
class TZInfo::TimestampWithOffset < ::TZInfo::Timestamp
  include ::TZInfo::WithOffset

  # Sets the associated {TimezoneOffset} of this {TimestampWithOffset}.
  #
  # @param timezone_offset [TimezoneOffset] a {TimezoneOffset} valid at the time
  #   and for the offset of this {TimestampWithOffset}.
  # @raise [ArgumentError] if `timezone_offset` is `nil`.
  # @raise [ArgumentError] if {utc? self.utc?} is `true`.
  # @raise [ArgumentError] if `timezone_offset.observed_utc_offset` does not equal
  #   `self.utc_offset`.
  # @return [TimestampWithOffset] `self`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:47
  def set_timezone_offset(timezone_offset); end

  # @return [TimezoneOffset] the {TimezoneOffset} associated with this
  #   instance.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:17
  def timezone_offset; end

  # An overridden version of {Timestamp#to_datetime}, if there is an
  # associated {TimezoneOffset}, returns a {DateTimeWithOffset} with that
  # offset.
  #
  # @return [DateTime] if there is an associated {TimezoneOffset}, a
  #   {DateTimeWithOffset} representation of this {TimestampWithOffset},
  #   otherwise a `DateTime` representation.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:76
  def to_datetime; end

  # An overridden version of {Timestamp#to_time} that, if there is an
  # associated {TimezoneOffset}, returns a {TimeWithOffset} with that offset.
  #
  # @return [Time] if there is an associated {TimezoneOffset}, a
  #   {TimeWithOffset} representation of this {TimestampWithOffset}, otherwise
  #   a `Time` representation.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:60
  def to_time; end

  class << self
    # Creates a new {TimestampWithOffset} from a given {Timestamp} and
    # {TimezoneOffset}.
    #
    # time of `timestamp`.
    #
    # @param timestamp [Timestamp] a {Timestamp}.
    # @param timezone_offset [TimezoneOffset] a {TimezoneOffset} valid at the
    # @raise [ArgumentError] if `timestamp` or `timezone_offset` is `nil`.
    # @return [TimestampWithOffset] a {TimestampWithOffset} that has the same
    #   {value value} and {sub_second sub_second} as the `timestamp` parameter,
    #   a {utc_offset utc_offset} equal to the
    #   {TimezoneOffset#observed_utc_offset observed_utc_offset} of the
    #   `timezone_offset` parameter and {timezone_offset timezone_offset} set to
    #   the `timezone_offset` parameter.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timestamp_with_offset.rb:32
    def set_timezone_offset(timestamp, timezone_offset); end
  end
end

# The {Timezone} class represents a time zone. It provides a factory method,
# {get}, to retrieve {Timezone} instances by their identifier.
#
# The {Timezone#to_local} method can be used to convert `Time` and `DateTime`
# instances to the local time for the zone. For example:
#
#     tz = TZInfo::Timezone.get('America/New_York')
#     local_time = tz.to_local(Time.utc(2005,8,29,15,35,0))
#     local_datetime = tz.to_local(DateTime.new(2005,8,29,15,35,0))
#
# Local `Time` and `DateTime` instances returned by `Timezone` have the
# correct local offset.
#
# The {Timezone#local_to_utc} method can by used to convert local `Time` and
# `DateTime` instances to UTC. {Timezone#local_to_utc} ignores the UTC offset
# of the supplied value and treats if it is a local time for the zone. For
# example:
#
#     tz = TZInfo::Timezone.get('America/New_York')
#     utc_time = tz.local_to_utc(Time.new(2005,8,29,11,35,0))
#     utc_datetime = tz.local_to_utc(DateTime.new(2005,8,29,11,35,0))
#
# Each time zone is treated as sequence of periods of time ({TimezonePeriod})
# that observe the same offset ({TimezoneOffset}). Transitions
# ({TimezoneTransition}) denote the end of one period and the start of the
# next. The {Timezone} class has methods that allow the periods, offsets and
# transitions of a time zone to be interrogated.
#
# All methods that take `Time` objects as parameters can be used with
# arbitrary `Time`-like objects that respond to both `to_i` and `subsec` and
# optionally `utc_offset`.
#
# The {Timezone} class is thread-safe. It is safe to use class and instance
# methods of {Timezone} in concurrently executing threads. Instances of
# {Timezone} can be shared across thread boundaries.
#
# The IANA Time Zone Database maintainers recommend that time zone identifiers
# are not made visible to end-users (see [Names of
# timezones](https://data.iana.org/time-zones/theory.html#naming)). The
# {Country} class can be used to obtain lists of time zones by country,
# including user-friendly descriptions and approximate locations.
#
# @abstract The {get} method returns an instance of either {DataTimezone} or
#   {LinkedTimezone}. The {get_proxy} method and other methods returning
#   collections of time zones return instances of {TimezoneProxy}.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:80
class TZInfo::Timezone
  include ::Comparable

  # Compares this {Timezone} with another based on the {identifier}.
  #
  # @param tz [Object] an `Object` to compare this {Timezone} with.
  # @return [Integer] -1 if `tz` is less than `self`, 0 if `tz` is equal to
  #   `self` and +1 if `tz` is greater than `self`, or `nil` if `tz` is not an
  #   instance of {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1105
  def <=>(tz); end

  # Matches `regexp` against the {identifier} of this {Timezone}.
  #
  # @param regexp [Regexp] a `Regexp` to match against the {identifier} of
  #   this {Timezone}.
  # @return [Integer] the position the match starts, or `nil` if there is no
  #   match.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1128
  def =~(regexp); end

  # Returns a serialized representation of this {Timezone}. This method is
  # called when using `Marshal.dump` with an instance of {Timezone}.
  #
  # @param limit [Integer] the maximum depth to dump - ignored.
  # @return [String] a serialized representation of this {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1137
  def _dump(limit); end

  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [String] the abbreviation of this {Timezone} at the given time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1048
  def abbr(time = T.unsafe(nil)); end

  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [String] the abbreviation of this {Timezone} at the given time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1048
  def abbreviation(time = T.unsafe(nil)); end

  # Returns the base offset from UTC in seconds at the given time. This does
  # not include any adjustment made for daylight savings time and will
  # typically remain constant throughout the year.
  #
  # To obtain the observed offset from UTC, including the effect of daylight
  # savings time, use {observed_utc_offset} instead.
  #
  # If you require accurate {base_utc_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of
  # {base_utc_offset} has to be derived from changes to the observed UTC
  # offset and DST status since it is not included in zoneinfo files.
  #
  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [Integer] the base offset from UTC in seconds at the given time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1081
  def base_utc_offset(time = T.unsafe(nil)); end

  # Returns the canonical identifier of this time zone.
  #
  # This is a shortcut for calling `canonical_zone.identifier`. Please refer
  # to the {canonical_zone} documentation for further information.
  #
  # @return [String] the canonical identifier of this time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:987
  def canonical_identifier; end

  # Returns the canonical {Timezone} instance for this {Timezone}.
  #
  # The IANA Time Zone database contains two types of definition: Zones and
  # Links. Zones are defined by rules that set out when transitions occur.
  # Links are just references to fully defined Zone, creating an alias for
  # that Zone.
  #
  # Links are commonly used where a time zone has been renamed in a release of
  # the Time Zone database. For example, the US/Eastern Zone was renamed as
  # America/New_York. A US/Eastern Link was added in its place, linking to
  # (and creating an alias for) America/New_York.
  #
  # Links are also used for time zones that are currently identical to a full
  # Zone, but that are administered separately. For example, Europe/Vatican is
  # a Link to (and alias for) Europe/Rome.
  #
  # For a full Zone (implemented by {DataTimezone}), {canonical_zone} returns
  # self.
  #
  # For a Link (implemented by {LinkedTimezone}), {canonical_zone} returns a
  # {Timezone} instance representing the full Zone that the link targets.
  #
  # TZInfo can be used with different data sources (see the documentation for
  # {TZInfo::DataSource}). Some DataSource implementations may not support
  # distinguishing between full Zones and Links and will treat all time zones
  # as full Zones. In this case, {canonical_zone} will always return `self`.
  #
  # There are two built-in DataSource implementations.
  # {DataSources::RubyDataSource} (which will be used if the tzinfo-data gem
  # is available) supports Link zones. {DataSources::ZoneinfoDataSource}
  # returns Link zones as if they were full Zones. If the {canonical_zone} or
  # {canonical_identifier} methods are needed, the tzinfo-data gem should be
  # installed.
  #
  # The {TZInfo::DataSource.get} method can be used to check which DataSource
  # implementation is being used.
  #
  # @return [Timezone] the canonical {Timezone} instance for this {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:412
  def canonical_zone; end

  # @return [TimezonePeriod] the current {TimezonePeriod} for the time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:997
  def current_period; end

  # Returns the current local time and {TimezonePeriod} for the time zone as
  # an `Array`. The first element is the time as a {TimeWithOffset}. The
  # second element is the period.
  #
  # @return [Array] an `Array` containing the current {TimeWithOffset} for the
  #   time zone as the first element and the current {TimezonePeriod} for the
  #   time zone as the second element.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1008
  def current_period_and_time; end

  # Returns the current local time and {TimezonePeriod} for the time zone as
  # an `Array`. The first element is the time as a {TimeWithOffset}. The
  # second element is the period.
  #
  # @return [Array] an `Array` containing the current {TimeWithOffset} for the
  #   time zone as the first element and the current {TimezonePeriod} for the
  #   time zone as the second element.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1008
  def current_time_and_period; end

  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [Boolean] whether daylight savings time is in effect at the given
  #   time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1059
  def dst?(time = T.unsafe(nil)); end

  # @param tz [Object] an `Object` to compare this {Timezone} with.
  # @return [Boolean] `true` if `tz` is an instance of {Timezone} and has the
  #   same {identifier} as `self`, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1113
  def eql?(tz); end

  # Returns {identifier}, modified to make it more readable. Set
  # `skip_first_part` to omit the first part of the identifier (typically a
  # region name) where there is more than one part.
  #
  # For example:
  #
  #     TZInfo::Timezone.get('Europe/Paris').friendly_identifier(false)         #=> "Europe - Paris"
  #     TZInfo::Timezone.get('Europe/Paris').friendly_identifier(true)          #=> "Paris"
  #     TZInfo::Timezone.get('America/Indiana/Knox').friendly_identifier(false) #=> "America - Knox, Indiana"
  #     TZInfo::Timezone.get('America/Indiana/Knox').friendly_identifier(true)  #=> "Knox, Indiana"
  #
  # @param skip_first_part [Boolean] whether the first part of the identifier
  #   (typically a region name) should be omitted.
  # @return [String] the modified identifier.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:277
  def friendly_identifier(skip_first_part = T.unsafe(nil)); end

  # @return [Integer] a hash based on the {identifier}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1118
  def hash; end

  # @return [String] the identifier of the time zone, for example,
  #   `"Europe/Paris"`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:241
  def identifier; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:259
  def inspect; end

  # Creates a `DateTime` object based on the given (Gregorian calendar) date
  # and time parameters. The parameters are interpreted as a local time in the
  # time zone. The result has the appropriate `offset` and
  # {DateTimeWithOffset#timezone_offset timezone_offset}.
  #
  # _Warning:_ There are time values that are not valid as local times in a
  # time zone (for example, during the transition from standard time to
  # daylight savings time). There are also time values that are ambiguous,
  # occurring more than once with different offsets to UTC (for example,
  # during the transition from daylight savings time to standard time).
  #
  # In the first case (an invalid local time), a {PeriodNotFound} exception
  # will be raised.
  #
  # In the second case (more than one occurrence), an {AmbiguousTime}
  # exception will be raised unless the optional `dst` parameter or block
  # handles the ambiguity.
  #
  # If the ambiguity is due to a transition from daylight savings time to
  # standard time, the `dst` parameter can be used to select whether the
  # daylight savings time or local time is used. For example, the following
  # code would raise an {AmbiguousTime} exception:
  #
  #     tz = TZInfo::Timezone.get('America/New_York')
  #     tz.local_datetime(2004,10,31,1,30,0,0)
  #
  # Specifying `dst = true` would return a `Time` with a UTC offset of -4
  # hours and abbreviation EDT (Eastern Daylight Time). Specifying `dst =
  # false` would return a `Time` with a UTC offset of -5 hours and
  # abbreviation EST (Eastern Standard Time).
  #
  # The `dst` parameter will not be able to resolve an ambiguity resulting
  # from the clocks being set back without changing from daylight savings time
  # to standard time. In this case, if a block is specified, it will be called
  # to resolve the ambiguity. The block must take a single parameter - an
  # `Array` of {TimezonePeriod}s that need to be resolved. The block can
  # select and return a single {TimezonePeriod} or return `nil` or an empty
  # `Array` to cause an {AmbiguousTime} exception to be raised.
  #
  # The default value of the `dst` parameter can be specified using
  # {Timezone.default_dst=}.
  #
  # values, interpreted as a local time in the time zone.
  #
  # @param hour [Integer] the hour (0-23).
  # @param minute [Integer] the minute (0-59).
  # @param second [Integer] the second (0-59).
  # @param sub_second [Numeric] the fractional part of the second as either
  #   a `Rational` that is greater than or equal to 0 and less than 1, or
  #   the `Integer` 0.
  # @param dst [Boolean] whether to resolve ambiguous local times by always
  #   selecting the period observing daylight savings time (`true`), always
  #   selecting the period observing standard time (`false`), or leaving the
  #   ambiguity unresolved (`nil`).
  # @param month [Integer] the month (1-12).
  # @param day [Integer] the day of the month (1-31).
  # @param year [Integer] the year.
  # @raise [RangeError] if `sub_second` is a `Rational` but that is less
  #   than 0 or greater than or equal to 1.
  # @raise [PeriodNotFound] if the date and time parameters do not specify a
  #   valid local time in the time zone.
  # @raise [AmbiguousTime] if the date and time parameters are ambiguous for
  #   the time zone and the `dst` parameter or block did not resolve the
  #   ambiguity.
  # @raise [RangeError] if `month` is not between 1 and 12.
  # @raise [ArgumentError] if either of `year`, `month`, `day`, `hour`,
  #   `minute`, or `second` is not an `Integer`.
  # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
  #   `Integer` 0.
  # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer`
  #   and not the `Symbol` `:utc`.
  # @raise [RangeError] if `day` is not between 1 and 31.
  # @raise [RangeError] if `hour` is not between 0 and 23.
  # @raise [RangeError] if `minute` is not between 0 and 59.
  # @raise [RangeError] if `second` is not between 0 and 59.
  # @return [DateTimeWithOffset] a new `DateTime` object based on the given
  # @yield [periods] if the `dst` parameter did not resolve an ambiguity, an
  #   optional block is yielded to.
  # @yieldparam periods [Array<TimezonePeriod>] an `Array` containing all
  #   the {TimezonePeriod}s that still match `local_time` after applying the
  #   `dst` parameter.
  # @yieldreturn [Object] to resolve the ambiguity: a chosen {TimezonePeriod}
  #   or an `Array` containing a chosen {TimezonePeriod}; to leave the
  #   ambiguity unresolved: an empty `Array`, an `Array` containing more than
  #   one {TimezonePeriod}, or `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:831
  def local_datetime(year, month = T.unsafe(nil), day = T.unsafe(nil), hour = T.unsafe(nil), minute = T.unsafe(nil), second = T.unsafe(nil), sub_second = T.unsafe(nil), dst = T.unsafe(nil), &block); end

  # Creates a `Time` object based on the given (Gregorian calendar) date and
  # time parameters. The parameters are interpreted as a local time in the
  # time zone. The result has the appropriate `utc_offset`, `zone` and
  # {TimeWithOffset#timezone_offset timezone_offset}.
  #
  # _Warning:_ There are time values that are not valid as local times in a
  # time zone (for example, during the transition from standard time to
  # daylight savings time). There are also time values that are ambiguous,
  # occurring more than once with different offsets to UTC (for example,
  # during the transition from daylight savings time to standard time).
  #
  # In the first case (an invalid local time), a {PeriodNotFound} exception
  # will be raised.
  #
  # In the second case (more than one occurrence), an {AmbiguousTime}
  # exception will be raised unless the optional `dst` parameter or block
  # handles the ambiguity.
  #
  # If the ambiguity is due to a transition from daylight savings time to
  # standard time, the `dst` parameter can be used to select whether the
  # daylight savings time or local time is used. For example, the following
  # code would raise an {AmbiguousTime} exception:
  #
  #     tz = TZInfo::Timezone.get('America/New_York')
  #     tz.local_time(2004,10,31,1,30,0,0)
  #
  # Specifying `dst = true` would return a `Time` with a UTC offset of -4
  # hours and abbreviation EDT (Eastern Daylight Time). Specifying `dst =
  # false` would return a `Time` with a UTC offset of -5 hours and
  # abbreviation EST (Eastern Standard Time).
  #
  # The `dst` parameter will not be able to resolve an ambiguity resulting
  # from the clocks being set back without changing from daylight savings time
  # to standard time. In this case, if a block is specified, it will be called
  # to resolve the ambiguity. The block must take a single parameter - an
  # `Array` of {TimezonePeriod}s that need to be resolved. The block can
  # select and return a single {TimezonePeriod} or return `nil` or an empty
  # `Array` to cause an {AmbiguousTime} exception to be raised.
  #
  # The default value of the `dst` parameter can be specified using
  # {Timezone.default_dst=}.
  #
  # @param hour [Integer] the hour (0-23).
  # @param minute [Integer] the minute (0-59).
  # @param second [Integer] the second (0-59).
  # @param sub_second [Numeric] the fractional part of the second as either
  #   a `Rational` that is greater than or equal to 0 and less than 1, or
  #   the `Integer` 0.
  # @param dst [Boolean] whether to resolve ambiguous local times by always
  #   selecting the period observing daylight savings time (`true`), always
  #   selecting the period observing standard time (`false`), or leaving the
  #   ambiguity unresolved (`nil`).
  # @param month [Integer] the month (1-12).
  # @param day [Integer] the day of the month (1-31).
  # @param year [Integer] the year.
  # @raise [RangeError] if `sub_second` is a `Rational` but that is less
  #   than 0 or greater than or equal to 1.
  # @raise [PeriodNotFound] if the date and time parameters do not specify a
  #   valid local time in the time zone.
  # @raise [AmbiguousTime] if the date and time parameters are ambiguous for
  #   the time zone and the `dst` parameter or block did not resolve the
  #   ambiguity.
  # @raise [RangeError] if `month` is not between 1 and 12.
  # @raise [ArgumentError] if either of `year`, `month`, `day`, `hour`,
  #   `minute`, or `second` is not an `Integer`.
  # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
  #   `Integer` 0.
  # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer`
  #   and not the `Symbol` `:utc`.
  # @raise [RangeError] if `day` is not between 1 and 31.
  # @raise [RangeError] if `hour` is not between 0 and 23.
  # @raise [RangeError] if `minute` is not between 0 and 59.
  # @raise [RangeError] if `second` is not between 0 and 59.
  # @return [TimeWithOffset] a new `Time` object based on the given values,
  #   interpreted as a local time in the time zone.
  # @yield [periods] if the `dst` parameter did not resolve an ambiguity, an
  #   optional block is yielded to.
  # @yieldparam periods [Array<TimezonePeriod>] an `Array` containing all
  #   the {TimezonePeriod}s that still match `local_time` after applying the
  #   `dst` parameter.
  # @yieldreturn [Object] to resolve the ambiguity: a chosen {TimezonePeriod}
  #   or an `Array` containing a chosen {TimezonePeriod}; to leave the
  #   ambiguity unresolved: an empty `Array`, an `Array` containing more than
  #   one {TimezonePeriod}, or `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:743
  def local_time(year, month = T.unsafe(nil), day = T.unsafe(nil), hour = T.unsafe(nil), minute = T.unsafe(nil), second = T.unsafe(nil), sub_second = T.unsafe(nil), dst = T.unsafe(nil), &block); end

  # Creates a {Timestamp} object based on the given (Gregorian calendar) date
  # and time parameters. The parameters are interpreted as a local time in the
  # time zone. The result has the appropriate {Timestamp#utc_offset
  # utc_offset} and {TimestampWithOffset#timezone_offset timezone_offset}.
  #
  # _Warning:_ There are time values that are not valid as local times in a
  # time zone (for example, during the transition from standard time to
  # daylight savings time). There are also time values that are ambiguous,
  # occurring more than once with different offsets to UTC (for example,
  # during the transition from daylight savings time to standard time).
  #
  # In the first case (an invalid local time), a {PeriodNotFound} exception
  # will be raised.
  #
  # In the second case (more than one occurrence), an {AmbiguousTime}
  # exception will be raised unless the optional `dst` parameter or block
  # handles the ambiguity.
  #
  # If the ambiguity is due to a transition from daylight savings time to
  # standard time, the `dst` parameter can be used to select whether the
  # daylight savings time or local time is used. For example, the following
  # code would raise an {AmbiguousTime} exception:
  #
  #     tz = TZInfo::Timezone.get('America/New_York')
  #     tz.local_timestamp(2004,10,31,1,30,0,0)
  #
  # Specifying `dst = true` would return a `Time` with a UTC offset of -4
  # hours and abbreviation EDT (Eastern Daylight Time). Specifying `dst =
  # false` would return a `Time` with a UTC offset of -5 hours and
  # abbreviation EST (Eastern Standard Time).
  #
  # The `dst` parameter will not be able to resolve an ambiguity resulting
  # from the clocks being set back without changing from daylight savings time
  # to standard time. In this case, if a block is specified, it will be called
  # to resolve the ambiguity. The block must take a single parameter - an
  # `Array` of {TimezonePeriod}s that need to be resolved. The block can
  # select and return a single {TimezonePeriod} or return `nil` or an empty
  # `Array` to cause an {AmbiguousTime} exception to be raised.
  #
  # The default value of the `dst` parameter can be specified using
  # {Timezone.default_dst=}.
  #
  # @param hour [Integer] the hour (0-23).
  # @param minute [Integer] the minute (0-59).
  # @param second [Integer] the second (0-59).
  # @param sub_second [Numeric] the fractional part of the second as either
  #   a `Rational` that is greater than or equal to 0 and less than 1, or
  #   the `Integer` 0.
  # @param dst [Boolean] whether to resolve ambiguous local times by always
  #   selecting the period observing daylight savings time (`true`), always
  #   selecting the period observing standard time (`false`), or leaving the
  #   ambiguity unresolved (`nil`).
  # @param month [Integer] the month (1-12).
  # @param day [Integer] the day of the month (1-31).
  # @param year [Integer] the year.
  # @raise [RangeError] if `sub_second` is a `Rational` but that is less
  #   than 0 or greater than or equal to 1.
  # @raise [PeriodNotFound] if the date and time parameters do not specify a
  #   valid local time in the time zone.
  # @raise [AmbiguousTime] if the date and time parameters are ambiguous for
  #   the time zone and the `dst` parameter or block did not resolve the
  #   ambiguity.
  # @raise [RangeError] if `month` is not between 1 and 12.
  # @raise [ArgumentError] if either of `year`, `month`, `day`, `hour`,
  #   `minute`, or `second` is not an `Integer`.
  # @raise [ArgumentError] if `sub_second` is not a `Rational`, or the
  #   `Integer` 0.
  # @raise [ArgumentError] if `utc_offset` is not `nil`, not an `Integer`
  #   and not the `Symbol` `:utc`.
  # @raise [RangeError] if `day` is not between 1 and 31.
  # @raise [RangeError] if `hour` is not between 0 and 23.
  # @raise [RangeError] if `minute` is not between 0 and 59.
  # @raise [RangeError] if `second` is not between 0 and 59.
  # @return [TimestampWithOffset] a new {Timestamp} object based on the given
  #   values, interpreted as a local time in the time zone.
  # @yield [periods] if the `dst` parameter did not resolve an ambiguity, an
  #   optional block is yielded to.
  # @yieldparam periods [Array<TimezonePeriod>] an `Array` containing all
  #   the {TimezonePeriod}s that still match `local_time` after applying the
  #   `dst` parameter.
  # @yieldreturn [Object] to resolve the ambiguity: a chosen {TimezonePeriod}
  #   or an `Array` containing a chosen {TimezonePeriod}; to leave the
  #   ambiguity unresolved: an empty `Array`, an `Array` containing more than
  #   one {TimezonePeriod}, or `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:919
  def local_timestamp(year, month = T.unsafe(nil), day = T.unsafe(nil), hour = T.unsafe(nil), minute = T.unsafe(nil), second = T.unsafe(nil), sub_second = T.unsafe(nil), dst = T.unsafe(nil), &block); end

  # Converts a local time for the time zone to UTC.
  #
  # The result will either be a `Time`, `DateTime` or {Timestamp} according to
  # the type of the `local_time` parameter.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`).
  #
  # _Warning:_ There are local times that have no equivalent UTC times (for
  # example, during the transition from standard time to daylight savings
  # time). There are also local times that have more than one UTC equivalent
  # (for example, during the transition from daylight savings time to standard
  # time).
  #
  # In the first case (no equivalent UTC time), a {PeriodNotFound} exception
  # will be raised.
  #
  # In the second case (more than one equivalent UTC time), an {AmbiguousTime}
  # exception will be raised unless the optional `dst` parameter or block
  # handles the ambiguity.
  #
  # If the ambiguity is due to a transition from daylight savings time to
  # standard time, the `dst` parameter can be used to select whether the
  # daylight savings time or local time is used. For example, the following
  # code would raise an {AmbiguousTime} exception:
  #
  #     tz = TZInfo::Timezone.get('America/New_York')
  #     tz.period_for_local(Time.new(2004,10,31,1,30,0))
  #
  # Specifying `dst = true` would select the daylight savings period from
  # April to October 2004. Specifying `dst = false` would return the
  # standard time period from October 2004 to April 2005.
  #
  # The `dst` parameter will not be able to resolve an ambiguity resulting
  # from the clocks being set back without changing from daylight savings time
  # to standard time. In this case, if a block is specified, it will be called
  # to resolve the ambiguity. The block must take a single parameter - an
  # `Array` of {TimezonePeriod}s that need to be resolved. The block can
  # select and return a single {TimezonePeriod} or return `nil` or an empty
  # `Array` to cause an {AmbiguousTime} exception to be raised.
  #
  # The default value of the `dst` parameter can be specified using
  # {Timezone.default_dst=}.
  #
  # @param dst [Boolean] whether to resolve ambiguous local times by always
  #   selecting the period observing daylight savings time (`true`), always
  #   selecting the period observing standard time (`false`), or leaving the
  #   ambiguity unresolved (`nil`).
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [PeriodNotFound] if `local_time` is not valid for the time zone
  #   (there is no equivalent UTC time).
  # @raise [AmbiguousTime] if `local_time` was ambiguous for the time zone and
  #   the `dst` parameter or block did not resolve the ambiguity.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [Object] the UTC equivalent of `local_time` as a `Time`,
  #   `DateTime` or {Timestamp}.
  # @yield [periods] if the `dst` parameter did not resolve an ambiguity, an
  #   optional block is yielded to.
  # @yieldparam periods [Array<TimezonePeriod>] an `Array` containing all
  #   the {TimezonePeriod}s that still match `local_time` after applying the
  #   `dst` parameter.
  # @yieldreturn [Object] to resolve the ambiguity: a chosen {TimezonePeriod}
  #   or an `Array` containing a chosen {TimezonePeriod}; to leave the
  #   ambiguity unresolved: an empty `Array`, an `Array` containing more than
  #   one {TimezonePeriod}, or `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:645
  def local_to_utc(local_time, dst = T.unsafe(nil)); end

  # @return [String] the identifier of the time zone, for example,
  #   `"Europe/Paris"`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:247
  def name; end

  # @return [TimeWithOffset] the current local time in the time zone.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:992
  def now; end

  # Returns the observed offset from UTC in seconds at the given time. This
  # includes adjustments made for daylight savings time.
  #
  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [Integer] the observed offset from UTC in seconds at the given
  #   time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1094
  def observed_utc_offset(time = T.unsafe(nil)); end

  # Returns the unique offsets used by the time zone up to a given time (`to`)
  # as an `Array` of {TimezoneOffset} instances.
  #
  # A from time may also be supplied using the `from` parameter. If from is
  # not `nil`, only offsets used from that time onwards will be returned.
  #
  # Comparisons with `to` are exclusive. Comparisons with `from` are
  # inclusive.
  #
  # @param to [Object] a `Time`, `DateTime` or {Timestamp} specifying the
  #   latest (exclusive) offset to return.
  # @param from [Object] an optional `Time`, `DateTime` or {Timestamp}
  #   specifying the earliest (inclusive) offset to return.
  # @raise [ArgumentError] if `from` is specified and `to` is not greater than
  #   `from`.
  # @raise [ArgumentError] is raised if `to` is `nil`.
  # @raise [ArgumentError] if either `to` or `from` is a {Timestamp} with an
  #   unspecified offset.
  # @return [Array<TimezoneOffsets>] the offsets that are used earlier than
  #   `to` and, if specified, at or later than `from`. Offsets may be returned
  #   in any order.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:947
  def offsets_up_to(to, from = T.unsafe(nil)); end

  # Returns the {TimezonePeriod} that is valid at a given time.
  #
  # Unlike {period_for_local} and {period_for_utc}, the UTC offset of the
  # `time` parameter is taken into consideration.
  #
  # @param time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified
  #   offset.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at `time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:319
  def period_for(time); end

  # Returns the {TimezonePeriod} that is valid at the given local time.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`). Use the {period_for}
  # method instead if the the UTC offset of the time needs to be taken into
  # consideration.
  #
  # _Warning:_ There are local times that have no equivalent UTC times (for
  # example, during the transition from standard time to daylight savings
  # time). There are also local times that have more than one UTC equivalent
  # (for example, during the transition from daylight savings time to standard
  # time).
  #
  # In the first case (no equivalent UTC time), a {PeriodNotFound} exception
  # will be raised.
  #
  # In the second case (more than one equivalent UTC time), an {AmbiguousTime}
  # exception will be raised unless the optional `dst` parameter or block
  # handles the ambiguity.
  #
  # If the ambiguity is due to a transition from daylight savings time to
  # standard time, the `dst` parameter can be used to select whether the
  # daylight savings time or local time is used. For example, the following
  # code would raise an {AmbiguousTime} exception:
  #
  #     tz = TZInfo::Timezone.get('America/New_York')
  #     tz.period_for_local(Time.new(2004,10,31,1,30,0))
  #
  # Specifying `dst = true` would select the daylight savings period from
  # April to October 2004. Specifying `dst = false` would return the
  # standard time period from October 2004 to April 2005.
  #
  # The `dst` parameter will not be able to resolve an ambiguity resulting
  # from the clocks being set back without changing from daylight savings time
  # to standard time. In this case, if a block is specified, it will be called
  # to resolve the ambiguity. The block must take a single parameter - an
  # `Array` of {TimezonePeriod}s that need to be resolved. The block can
  # select and return a single {TimezonePeriod} or return `nil` or an empty
  # `Array` to cause an {AmbiguousTime} exception to be raised.
  #
  # The default value of the `dst` parameter can be specified using
  # {Timezone.default_dst=}.
  #
  # @param dst [Boolean] whether to resolve ambiguous local times by always
  #   selecting the period observing daylight savings time (`true`), always
  #   selecting the period observing standard time (`false`), or leaving the
  #   ambiguity unresolved (`nil`).
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [PeriodNotFound] if `local_time` is not valid for the time zone
  #   (there is no equivalent UTC time).
  # @raise [AmbiguousTime] if `local_time` was ambiguous for the time zone and
  #   the `dst` parameter or block did not resolve the ambiguity.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at
  #   `local_time`.
  # @yield [periods] if the `dst` parameter did not resolve an ambiguity, an
  #   optional block is yielded to.
  # @yieldparam periods [Array<TimezonePeriod>] an `Array` containing all
  #   the {TimezonePeriod}s that still match `local_time` after applying the
  #   `dst` parameter.
  # @yieldreturn [Object] to resolve the ambiguity: a chosen {TimezonePeriod}
  #   or an `Array` containing a chosen {TimezonePeriod}; to leave the
  #   ambiguity unresolved: an empty `Array`, an `Array` containing more than
  #   one {TimezonePeriod}, or `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:494
  def period_for_local(local_time, dst = T.unsafe(nil)); end

  # Returns the {TimezonePeriod} that is valid at a given time.
  #
  # The UTC offset of the `utc_time` parameter is ignored (it is treated as a
  # UTC time). Use the {period_for} method instead if the UTC offset of the
  # time needs to be taken into consideration.
  #
  # @param utc_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `utc_time` is `nil`.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at `utc_time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:425
  def period_for_utc(utc_time); end

  # Returns the set of {TimezonePeriod}s that are valid for the given
  # local time as an `Array`.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`).
  #
  # This will typically return an `Array` containing a single
  # {TimezonePeriod}. More than one {TimezonePeriod} will be returned when the
  # local time is ambiguous (for example, when daylight savings time ends). An
  # empty `Array` will be returned when the local time is not valid (for
  # example, when daylight savings time begins).
  #
  # To obtain just a single {TimezonePeriod} in all cases, use
  # {period_for_local} instead and specify how ambiguities should be resolved.
  #
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [Array<TimezonePeriod>] the set of {TimezonePeriod}s that are
  #   valid at `local_time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:342
  def periods_for_local(local_time); end

  # Converts a time to local time for the time zone and returns a `String`
  # representation of the local time according to the given format.
  #
  # `Timezone#strftime` first expands any occurrences of `%Z` in the format
  # string to the time zone abbreviation for the local time (for example, EST
  # or EDT). Depending on the type of `time` parameter, the result of the
  # expansion is then passed to either `Time#strftime`, `DateTime#strftime` or
  # `Timestamp#strftime` to handle any other format directives.
  #
  # This method is equivalent to the following:
  #
  #     time_zone.to_local(time).strftime(format)
  #
  # @param format [String] the format string.
  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `format` or `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [String] the formatted local time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1039
  def strftime(format, time = T.unsafe(nil)); end

  # Converts a time to the local time for the time zone.
  #
  # The result will be of type {TimeWithOffset} (if passed a `Time`),
  # {DateTimeWithOffset} (if passed a `DateTime`) or {TimestampWithOffset} (if
  # passed a {Timestamp}). {TimeWithOffset}, {DateTimeWithOffset} and
  # {TimestampWithOffset} are subclasses of `Time`, `DateTime` and {Timestamp}
  # that provide additional information about the local result.
  #
  # Unlike {utc_to_local}, {to_local} takes the UTC offset of the given time
  # into consideration.
  #
  # @param time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} that does not have a
  #   specified UTC offset.
  # @return [Object] the local equivalent of `time` as a {TimeWithOffset},
  #   {DateTimeWithOffset} or {TimestampWithOffset}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:548
  def to_local(time); end

  # @return [String] {identifier}, modified to make it more readable.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:253
  def to_s; end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the timezone changes.
  #
  # Transitions are returned up to a given time (`to`).
  #
  # A from time may also be supplied using the `from` parameter. If from is
  # not `nil`, only transitions from that time onwards will be returned.
  #
  # Comparisons with `to` are exclusive. Comparisons with `from` are
  # inclusive. If a transition falls precisely on `to`, it will be excluded.
  # If a transition falls on `from`, it will be included.
  #
  # @param to [Object] a `Time`, `DateTime` or {Timestamp} specifying the
  #   latest (exclusive) transition to return.
  # @param from [Object] an optional `Time`, `DateTime` or {Timestamp}
  #   specifying the earliest (inclusive) transition to return.
  # @raise [ArgumentError] if `from` is specified and `to` is not greater than
  #   `from`.
  # @raise [ArgumentError] is raised if `to` is `nil`.
  # @raise [ArgumentError] if either `to` or `from` is a {Timestamp} with an
  #   unspecified offset.
  # @return [Array<TimezoneTransition>] the transitions that are earlier than
  #   `to` and, if specified, at or later than `from`. Transitions are ordered
  #   by when they occur, from earliest to latest.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:370
  def transitions_up_to(to, from = T.unsafe(nil)); end

  # Returns the observed offset from UTC in seconds at the given time. This
  # includes adjustments made for daylight savings time.
  #
  # @param time [Object] a `Time`, `DateTime` or `Timestamp`.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified UTC
  #   offset.
  # @return [Integer] the observed offset from UTC in seconds at the given
  #   time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1094
  def utc_offset(time = T.unsafe(nil)); end

  # Converts a time in UTC to the local time for the time zone.
  #
  # The result will be of type {TimeWithOffset} (if passed a `Time`),
  # {DateTimeWithOffset} (if passed a `DateTime`) or {TimestampWithOffset} (if
  # passed a {Timestamp}). {TimeWithOffset}, {DateTimeWithOffset} and
  # {TimestampWithOffset} are subclasses of `Time`, `DateTime` and {Timestamp}
  # that provide additional information about the local result.
  #
  # The UTC offset of the `utc_time` parameter is ignored (it is treated as a
  # UTC time). Use the {to_local} method instead if the the UTC offset of the
  # time needs to be taken into consideration.
  #
  # @param utc_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `utc_time` is `nil`.
  # @return [Object] the local equivalent of `utc_time` as a {TimeWithOffset},
  #   {DateTimeWithOffset} or {TimestampWithOffset}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:572
  def utc_to_local(utc_time); end

  private

  # Raises an {UnknownTimezone} exception.
  #
  # @raise [UnknownTimezone] always.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1156
  def raise_unknown_timezone; end

  class << self
    # Loads a {Timezone} from the serialized representation returned by {_dump}.
    # This is method is called when using `Marshal.load` or `Marshal.restore`
    # to restore a serialized {Timezone}.
    #
    # @param data [String] a serialized representation of a {Timezone}.
    # @return [Timezone] the result of converting `data` back into a {Timezone}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:1147
    def _load(data); end

    # Returns an `Array` of all the available time zones.
    #
    # {TimezoneProxy} instances are returned to avoid the overhead of loading
    # time zone data until it is first needed.
    #
    # @return [Array<Timezone>] all available time zones.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:151
    def all; end

    # Returns an `Array` of the identifiers of all the time zones that are
    # observed by at least one {Country}. This is not the complete set of time
    # zone identifiers as some are not country specific (e.g. `'Etc/GMT'`).
    #
    # {TimezoneProxy} instances are returned to avoid the overhead of loading
    # time zone data until it is first needed.
    #
    # zones that are observed by at least one {Country}.
    #
    # @return [Array<String>] an `Array` of the identifiers of all the time
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:219
    def all_country_zone_identifiers; end

    # Returns an `Array` of all the time zones that are observed by at least
    # one {Country}. This is not the complete set of time zones as some are
    # not country specific (e.g. `'Etc/GMT'`).
    #
    # {TimezoneProxy} instances are returned to avoid the overhead of loading
    # time zone data until it is first needed.
    #
    # @return [Array<Timezone>] an `Array` of all the time zones that are
    #   observed by at least one {Country}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:206
    def all_country_zones; end

    # time zones that are defined by offsets and transitions.
    #
    # @return [Array<String>] an `Array` of the identifiers of all available
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:175
    def all_data_zone_identifiers; end

    # Returns an `Array` of all the available time zones that are
    # defined by offsets and transitions.
    #
    # {TimezoneProxy} instances are returned to avoid the overhead of loading
    # time zone data until it is first needed.
    #
    # @return [Array<Timezone>] an `Array` of all the available time zones
    #   that are defined by offsets and transitions.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:169
    def all_data_zones; end

    # @return [Array<String>] an `Array` containing the identifiers of all the
    #   available time zones.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:157
    def all_identifiers; end

    # time zones that are defined as links to / aliases for other time zones.
    #
    # @return [Array<String>] an `Array` of the identifiers of all available
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:193
    def all_linked_zone_identifiers; end

    # Returns an `Array` of all the available time zones that are
    # defined as links to / aliases for other time zones.
    #
    # {TimezoneProxy} instances are returned to avoid the overhead of loading
    # time zone data until it is first needed.
    #
    # @return [Array<Timezone>] an `Array` of all the available time zones
    #   that are defined as links to / aliases for other time zones.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:187
    def all_linked_zones; end

    # Returns the default value of the optional `dst` parameter of the
    # {local_time}, {local_datetime} and {local_timestamp}, {local_to_utc}
    # and {period_for_local} methods (`nil`, `true` or `false`).
    #
    # {default_dst} defaults to `nil` unless changed with {default_dst=}.
    #
    # @return [Boolean] the default value of the optional `dst` parameter of
    #   the {local_time}, {local_datetime} and {local_timestamp},
    #   {local_to_utc} and {period_for_local} methods (`nil`, `true` or
    #   `false`).
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:110
    def default_dst; end

    # Sets the default value of the optional `dst` parameter of the
    # {local_datetime}, {local_time}, {local_timestamp}, {local_to_utc} and
    # {period_for_local} methods. Can be set to `nil`, `true` or `false`.
    #
    # @param value [Boolean] `nil`, `true` or `false`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:96
    def default_dst=(value); end

    # Returns a time zone by its IANA Time Zone Database identifier (e.g.
    # `"Europe/London"` or `"America/Chicago"`). Call {all_identifiers} for a
    # list of all the valid identifiers.
    #
    # The {get} method will return a subclass of {Timezone}, either a
    # {DataTimezone} (for a time zone defined by rules that set out when
    # transitions occur) or a {LinkedTimezone} (for a time zone that is just a
    # link to or alias for a another time zone).
    #
    # @param identifier [String] an IANA Time Zone Database time zone
    #   identifier.
    # @raise [InvalidTimezoneIdentifier] if the `identifier` is not valid.
    # @return [Timezone] the {Timezone} with the given `identifier`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:127
    def get(identifier); end

    # Returns a proxy for the time zone with the given identifier. This allows
    # loading of the time zone data to be deferred until it is first needed.
    #
    # The identifier will not be validated. If an invalid identifier is
    # specified, no exception will be raised until the proxy is used.
    #
    # @param identifier [String] an IANA Time Zone Database time zone
    #   identifier.
    # @return [TimezoneProxy] a proxy for the time zone with the given
    #   `identifier`.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:141
    def get_proxy(identifier); end

    private

    # @return [DataSource] the current DataSource.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:234
    def data_source; end

    # @param identifiers [Enumerable<String>] an `Enumerable` of time zone
    #   identifiers.
    # @return [Array<TimezoneProxy>] an `Array` of {TimezoneProxy}
    #   instances corresponding to the given identifiers.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:229
    def get_proxies(identifiers); end
  end
end

# Alias used by TZInfo::Data format1 releases.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_definition.rb:37
TZInfo::TimezoneDefinition = TZInfo::Format1::TimezoneDefinition

# Alias used by TZInfo::Data format 1 releases.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/format1/timezone_index_definition.rb:75
TZInfo::TimezoneIndexDefinition = TZInfo::Format1::TimezoneIndexDefinition

# Represents an offset from UTC observed by a time zone.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:6
class TZInfo::TimezoneOffset
  # Initializes a new {TimezoneOffset}.
  #
  # {TimezoneOffset} instances should not normally be constructed manually.
  #
  # The passed in `abbreviation` instance will be frozen.
  #
  # @param base_utc_offset [Integer] the base offset from UTC in seconds.
  # @param std_offset [Integer] the offset from standard time in seconds.
  # @param abbreviation [String] the abbreviation identifying the offset.
  # @return [TimezoneOffset] a new instance of TimezoneOffset
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:62
  def initialize(base_utc_offset, std_offset, abbreviation); end

  # Determines if this {TimezoneOffset} is equal to another instance.
  #
  # @param toi [Object] the instance to test for equality.
  # @return [Boolean] `true` if `toi` is a {TimezoneOffset} with the same
  #   {utc_offset}, {std_offset} and {abbreviation} as this {TimezoneOffset},
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:84
  def ==(toi); end

  # The abbreviation that identifies this offset. For example GMT
  # (Greenwich Mean Time) or BST (British Summer Time) for Europe/London.
  #
  # @return [String] the abbreviation that identifies this offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:50
  def abbr; end

  # The abbreviation that identifies this offset. For example GMT
  # (Greenwich Mean Time) or BST (British Summer Time) for Europe/London.
  #
  # @return [String] the abbreviation that identifies this offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:50
  def abbreviation; end

  # Returns the base offset from UTC in seconds (`observed_utc_offset -
  # std_offset`). This does not include any adjustment made for daylight
  # savings time and will typically remain constant throughout the year.
  #
  # To obtain the currently observed offset from UTC, including the effect of
  # daylight savings time, use {observed_utc_offset} instead.
  #
  # If you require accurate {base_utc_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of
  # {base_utc_offset} has to be derived from changes to the observed UTC
  # offset and DST status since it is not included in zoneinfo files.
  #
  # @return [Integer] the base offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:21
  def base_utc_offset; end

  # Determines if daylight savings is in effect (i.e. if {std_offset} is
  # non-zero).
  #
  # @return [Boolean] `true` if {std_offset} is non-zero, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:74
  def dst?; end

  # Determines if this {TimezoneOffset} is equal to another instance.
  #
  # @param toi [Object] the instance to test for equality.
  # @return [Boolean] `true` if `toi` is a {TimezoneOffset} with the same
  #   {utc_offset}, {std_offset} and {abbreviation} as this {TimezoneOffset},
  #   otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:95
  def eql?(toi); end

  # @return [Integer] a hash based on {utc_offset}, {std_offset} and
  #   {abbreviation}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:101
  def hash; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:107
  def inspect; end

  # Returns the observed offset from UTC in seconds (`base_utc_offset +
  # std_offset`). This includes adjustments made for daylight savings time.
  #
  # @return [Integer] the observed offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:43
  def observed_utc_offset; end

  # Returns the offset from the time zone's standard time in seconds
  # (`observed_utc_offset - base_utc_offset`). Zero when daylight savings time
  # is not in effect. Non-zero (usually 3600 = 1 hour) if daylight savings is
  # being observed.
  #
  # If you require accurate {std_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of {std_offset}
  # has to be derived from changes to the observed UTC offset and DST status
  # since it is not included in zoneinfo files.
  #
  # @return [Integer] the offset from the time zone's standard time in
  #   seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:37
  def std_offset; end

  # Returns the base offset from UTC in seconds (`observed_utc_offset -
  # std_offset`). This does not include any adjustment made for daylight
  # savings time and will typically remain constant throughout the year.
  #
  # To obtain the currently observed offset from UTC, including the effect of
  # daylight savings time, use {observed_utc_offset} instead.
  #
  # If you require accurate {base_utc_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of
  # {base_utc_offset} has to be derived from changes to the observed UTC
  # offset and DST status since it is not included in zoneinfo files.
  #
  # @return [Integer] the base offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:21
  def utc_offset; end

  # Returns the observed offset from UTC in seconds (`base_utc_offset +
  # std_offset`). This includes adjustments made for daylight savings time.
  #
  # @return [Integer] the observed offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_offset.rb:43
  def utc_total_offset; end
end

# {TimezonePeriod} represents a period of time for a time zone where the same
# offset from UTC applies. It provides access to the observed offset, time
# zone abbreviation, start time and end time.
#
# The period of time can be unbounded at the start, end, or both the start
# and end.
#
# @abstract Time zone period data will returned as an instance of one of the
#   subclasses of {TimezonePeriod}.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:14
class TZInfo::TimezonePeriod
  # Initializes a {TimezonePeriod}.
  #
  # @param offset [TimezoneOffset] the offset that is observed for the period
  #   of time.
  # @raise [ArgumentError] if `offset` is `nil`.
  # @return [TimezonePeriod] a new instance of TimezonePeriod
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:23
  def initialize(offset); end

  # The abbreviation that identifies this offset. For example GMT
  # (Greenwich Mean Time) or BST (British Summer Time) for Europe/London.
  #
  # @return [String] the abbreviation that identifies this offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:80
  def abbr; end

  # The abbreviation that identifies this offset. For example GMT
  # (Greenwich Mean Time) or BST (British Summer Time) for Europe/London.
  #
  # @return [String] the abbreviation that identifies this offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:80
  def abbreviation; end

  # Returns the base offset from UTC in seconds (`observed_utc_offset -
  # std_offset`). This does not include any adjustment made for daylight
  # savings time and will typically remain constant throughout the year.
  #
  # To obtain the currently observed offset from UTC, including the effect of
  # daylight savings time, use {observed_utc_offset} instead.
  #
  # If you require accurate {base_utc_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of
  # {base_utc_offset} has to be derived from changes to the observed UTC
  # offset and DST status since it is not included in zoneinfo files.
  #
  # @return [Integer] the base offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:54
  def base_utc_offset; end

  # Determines if daylight savings is in effect (i.e. if {std_offset} is
  # non-zero).
  #
  # @return [Boolean] `true` if {std_offset} is non-zero, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:99
  def dst?; end

  # @return [TimezoneTransition] the transition that defines the end of this
  #   {TimezonePeriod} (`nil` if the end is unbounded).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:36
  def end_transition; end

  # Returns the UTC end time of the period or `nil` if the end of the period
  # is unbounded.
  #
  # The result is returned as a {Timestamp}. To obtain the end time as a
  # `Time` or `DateTime`, call either {Timestamp#to_time to_time} or
  # {Timestamp#to_datetime to_datetime} on the result.
  #
  # @return [Timestamp] the UTC end time of the period or `nil` if the end of
  #   the period is unbounded.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:125
  def ends_at; end

  # Returns the local end time of the period or `nil` if the end of the period
  # is unbounded.
  #
  # The result is returned as a {TimestampWithOffset}. To obtain the end time
  # as a `Time` or `DateTime`, call either {TimestampWithOffset#to_time
  # to_time} or {TimestampWithOffset#to_datetime to_datetime} on the result.
  #
  # @return [TimestampWithOffset] the local end time of the period or `nil` if
  #   the end of the period is unbounded.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:151
  def local_ends_at; end

  # Returns the local start time of the period or `nil` if the start of the
  # period is unbounded.
  #
  # The result is returned as a {TimestampWithOffset}. To obtain the start
  # time as a `Time` or `DateTime`, call either {TimestampWithOffset#to_time
  # to_time} or {TimestampWithOffset#to_datetime to_datetime} on the result.
  #
  # @return [TimestampWithOffset] the local start time of the period or `nil`
  #   if the start of the period is unbounded.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:138
  def local_starts_at; end

  # Returns the observed offset from UTC in seconds (`base_utc_offset +
  # std_offset`). This includes adjustments made for daylight savings time.
  #
  # @return [Integer] the observed offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:90
  def observed_utc_offset; end

  # @return [TimezoneOffset] the offset that applies in the period of time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:16
  def offset; end

  # @return [TimezoneTransition] the transition that defines the start of this
  #   {TimezonePeriod} (`nil` if the start is unbounded).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:30
  def start_transition; end

  # Returns the UTC start time of the period or `nil` if the start of the
  # period is unbounded.
  #
  # The result is returned as a {Timestamp}. To obtain the start time as a
  # `Time` or `DateTime`, call either {Timestamp#to_time to_time} or
  # {Timestamp#to_datetime to_datetime} on the result.
  #
  # @return [Timestamp] the UTC start time of the period or `nil` if the start
  #   of the period is unbounded.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:112
  def starts_at; end

  # Returns the offset from the time zone's standard time in seconds
  # (`observed_utc_offset - base_utc_offset`). Zero when daylight savings time
  # is not in effect. Non-zero (usually 3600 = 1 hour) if daylight savings is
  # being observed.
  #
  # If you require accurate {std_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of {std_offset}
  # has to be derived from changes to the observed UTC offset and DST status
  # since it is not included in zoneinfo files.
  #
  # @return [Integer] the offset from the time zone's standard time in
  #   seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:72
  def std_offset; end

  # Returns the base offset from UTC in seconds (`observed_utc_offset -
  # std_offset`). This does not include any adjustment made for daylight
  # savings time and will typically remain constant throughout the year.
  #
  # To obtain the currently observed offset from UTC, including the effect of
  # daylight savings time, use {observed_utc_offset} instead.
  #
  # If you require accurate {base_utc_offset} values, you should install the
  # tzinfo-data gem and set {DataSources::RubyDataSource} as the {DataSource}.
  # When using {DataSources::ZoneinfoDataSource}, the value of
  # {base_utc_offset} has to be derived from changes to the observed UTC
  # offset and DST status since it is not included in zoneinfo files.
  #
  # @return [Integer] the base offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:54
  def utc_offset; end

  # Returns the observed offset from UTC in seconds (`base_utc_offset +
  # std_offset`). This includes adjustments made for daylight savings time.
  #
  # @return [Integer] the observed offset from UTC in seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:90
  def utc_total_offset; end

  # The abbreviation that identifies this offset. For example GMT
  # (Greenwich Mean Time) or BST (British Summer Time) for Europe/London.
  #
  # @return [String] the abbreviation that identifies this offset.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:80
  def zone_identifier; end

  private

  # Raises a {NotImplementedError} to indicate that subclasses should override
  # a method.
  #
  # @raise [NotImplementedError] always.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:161
  def raise_not_implemented(method_name); end

  # @param transition [TimezoneTransition] a transition or `nil`.
  # @return [Timestamp] the {Timestamp} representing when a transition occurs,
  #   or `nil` if `transition` is `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:168
  def timestamp(transition); end

  # @param transition [TimezoneTransition] a transition or `nil`.
  # @return [TimestampWithOffset] a {Timestamp} representing when a transition
  #   occurs with offset set to {#offset}, or `nil` if `transition` is `nil`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_period.rb:175
  def timestamp_with_offset(transition); end
end

# A proxy class standing in for a {Timezone} with a given identifier.
# {TimezoneProxy} inherits from {Timezone} and can be treated identically to
# {Timezone} instances loaded with {Timezone.get}.
#
# {TimezoneProxy} instances are used to avoid the performance overhead of
# loading time zone data into memory, for example, by {Timezone.all}.
#
# The first time an attempt is made to access the data for the time zone, the
# real {Timezone} will be loaded is loaded. If the proxy's identifier was not
# valid, then an exception will be raised at this point.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:22
class TZInfo::TimezoneProxy < ::TZInfo::Timezone
  # Initializes a new {TimezoneProxy}.
  #
  # The `identifier` parameter is not checked when initializing the proxy. It
  # will be validated when the real {Timezone} instance is loaded.
  #
  # @param identifier [String] an IANA Time Zone Database time zone
  #   identifier.
  # @return [TimezoneProxy] a new instance of TimezoneProxy
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:23
  def initialize(identifier); end

  # Returns a serialized representation of this {TimezoneProxy}. This method
  # is called when using `Marshal.dump` with an instance of {TimezoneProxy}.
  #
  # @param limit [Integer] the maximum depth to dump - ignored. @return
  #   [String] a serialized representation of this {TimezoneProxy}.
  # @return [String] a serialized representation of this {TimezoneProxy}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:60
  def _dump(limit); end

  # Returns the canonical {Timezone} instance for this {Timezone}.
  #
  # The IANA Time Zone database contains two types of definition: Zones and
  # Links. Zones are defined by rules that set out when transitions occur.
  # Links are just references to fully defined Zone, creating an alias for
  # that Zone.
  #
  # Links are commonly used where a time zone has been renamed in a release of
  # the Time Zone database. For example, the US/Eastern Zone was renamed as
  # America/New_York. A US/Eastern Link was added in its place, linking to
  # (and creating an alias for) America/New_York.
  #
  # Links are also used for time zones that are currently identical to a full
  # Zone, but that are administered separately. For example, Europe/Vatican is
  # a Link to (and alias for) Europe/Rome.
  #
  # For a full Zone (implemented by {DataTimezone}), {canonical_zone} returns
  # self.
  #
  # For a Link (implemented by {LinkedTimezone}), {canonical_zone} returns a
  # {Timezone} instance representing the full Zone that the link targets.
  #
  # TZInfo can be used with different data sources (see the documentation for
  # {TZInfo::DataSource}). Some DataSource implementations may not support
  # distinguishing between full Zones and Links and will treat all time zones
  # as full Zones. In this case, {canonical_zone} will always return `self`.
  #
  # There are two built-in DataSource implementations.
  # {DataSources::RubyDataSource} (which will be used if the tzinfo-data gem
  # is available) supports Link zones. {DataSources::ZoneinfoDataSource}
  # returns Link zones as if they were full Zones. If the {canonical_zone} or
  # {canonical_identifier} methods are needed, the tzinfo-data gem should be
  # installed.
  #
  # The {TZInfo::DataSource.get} method can be used to check which DataSource
  # implementation is being used.
  #
  # @return [Timezone] the canonical {Timezone} instance for this {Timezone}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:50
  def canonical_zone; end

  # @return [String] the identifier of the time zone, for example,
  #   `"Europe/Paris"`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:30
  def identifier; end

  # Returns the {TimezonePeriod} that is valid at a given time.
  #
  # Unlike {period_for_local} and {period_for_utc}, the UTC offset of the
  # `time` parameter is taken into consideration.
  #
  # @param time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `time` is `nil`.
  # @raise [ArgumentError] if `time` is a {Timestamp} with an unspecified
  #   offset.
  # @return [TimezonePeriod] the {TimezonePeriod} that is valid at `time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:35
  def period_for(time); end

  # Returns the set of {TimezonePeriod}s that are valid for the given
  # local time as an `Array`.
  #
  # The UTC offset of the `local_time` parameter is ignored (it is treated as
  # a time in the time zone represented by `self`).
  #
  # This will typically return an `Array` containing a single
  # {TimezonePeriod}. More than one {TimezonePeriod} will be returned when the
  # local time is ambiguous (for example, when daylight savings time ends). An
  # empty `Array` will be returned when the local time is not valid (for
  # example, when daylight savings time begins).
  #
  # To obtain just a single {TimezonePeriod} in all cases, use
  # {period_for_local} instead and specify how ambiguities should be resolved.
  #
  # @param local_time [Object] a `Time`, `DateTime` or {Timestamp}.
  # @raise [ArgumentError] if `local_time` is `nil`.
  # @return [Array<TimezonePeriod>] the set of {TimezonePeriod}s that are
  #   valid at `local_time`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:40
  def periods_for_local(local_time); end

  # Returns an `Array` of {TimezoneTransition} instances representing the
  # times where the UTC offset of the timezone changes.
  #
  # Transitions are returned up to a given time (`to`).
  #
  # A from time may also be supplied using the `from` parameter. If from is
  # not `nil`, only transitions from that time onwards will be returned.
  #
  # Comparisons with `to` are exclusive. Comparisons with `from` are
  # inclusive. If a transition falls precisely on `to`, it will be excluded.
  # If a transition falls on `from`, it will be included.
  #
  # @param to [Object] a `Time`, `DateTime` or {Timestamp} specifying the
  #   latest (exclusive) transition to return.
  # @param from [Object] an optional `Time`, `DateTime` or {Timestamp}
  #   specifying the earliest (inclusive) transition to return.
  # @raise [ArgumentError] if `from` is specified and `to` is not greater than
  #   `from`.
  # @raise [ArgumentError] is raised if `to` is `nil`.
  # @raise [ArgumentError] if either `to` or `from` is a {Timestamp} with an
  #   unspecified offset.
  # @return [Array<TimezoneTransition>] the transitions that are earlier than
  #   `to` and, if specified, at or later than `from`. Transitions are ordered
  #   by when they occur, from earliest to latest.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:45
  def transitions_up_to(to, from = T.unsafe(nil)); end

  private

  # Returns the real {Timezone} instance being proxied.
  #
  # The real {Timezone} is loaded using {Timezone.get} on the first access.
  #
  # @return [Timezone] the real {Timezone} instance being proxied.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:82
  def real_timezone; end

  class << self
    # Loads a {TimezoneProxy} from the serialized representation returned by
    # {_dump}. This is method is called when using `Marshal.load` or
    # `Marshal.restore` to restore a serialized {Timezone}.
    #
    # @param data [String] a serialized representation of a {TimezoneProxy}.
    # @return [TimezoneProxy] the result of converting `data` back into a
    #   {TimezoneProxy}.
    #
    # source://tzinfo-2.0.5/lib/tzinfo/timezone_proxy.rb:71
    def _load(data); end
  end
end

# Represents a transition from one observed UTC offset ({TimezoneOffset} to
# another for a time zone.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:7
class TZInfo::TimezoneTransition
  # Initializes a new {TimezoneTransition}.
  #
  # {TimezoneTransition} instances should not normally be constructed
  # manually.
  #
  # @param offset [TimezoneOffset] the offset the transition changes to.
  # @param previous_offset [TimezoneOffset] the offset the transition changes
  #   from.
  # @param timestamp_value [Integer] when the transition occurs as a
  #   number of seconds since 1970-01-01 00:00:00 UTC ignoring leap seconds
  #   (i.e. each day is treated as if it were 86,400 seconds long).
  # @return [TimezoneTransition] a new instance of TimezoneTransition
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:34
  def initialize(offset, previous_offset, timestamp_value); end

  # Determines if this {TimezoneTransition} is equal to another instance.
  #
  # @param tti [Object] the instance to test for equality.
  # @return [Boolean] `true` if `tti` is a {TimezoneTransition} with the same
  #   {offset}, {previous_offset} and {timestamp_value} as this
  #   {TimezoneTransition}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:86
  def ==(tti); end

  # Returns a {Timestamp} instance representing the UTC time when this
  # transition occurs.
  #
  # To obtain the result as a `Time` or `DateTime`, call either
  # {Timestamp#to_time to_time} or {Timestamp#to_datetime to_datetime} on the
  # {Timestamp} instance that is returned.
  #
  # @return [Timestamp] the UTC time when this transition occurs.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:48
  def at; end

  # Determines if this {TimezoneTransition} is equal to another instance.
  #
  # @param tti [Object] the instance to test for equality.
  # @return [Boolean] `true` if `tti` is a {TimezoneTransition} with the same
  #   {offset}, {previous_offset} and {timestamp_value} as this
  #   {TimezoneTransition}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:86
  def eql?(tti); end

  # @return [Integer] a hash based on {offset}, {previous_offset} and
  #   {timestamp_value}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:94
  def hash; end

  # Returns a {TimestampWithOffset} instance representing the local time when
  # this transition causes the previous observance to end (calculated from
  # {at} using {previous_offset}).
  #
  # To obtain the result as a `Time` or `DateTime`, call either
  # {TimestampWithOffset#to_time to_time} or {TimestampWithOffset#to_datetime
  # to_datetime} on the {TimestampWithOffset} instance that is returned.
  #
  # @return [TimestampWithOffset] the local time when this transition causes
  #   the previous observance to end.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:62
  def local_end_at; end

  # Returns a {TimestampWithOffset} instance representing the local time when
  # this transition causes the next observance to start (calculated from {at}
  # using {offset}).
  #
  # To obtain the result as a `Time` or `DateTime`, call either
  # {TimestampWithOffset#to_time to_time} or {TimestampWithOffset#to_datetime
  # to_datetime} on the {TimestampWithOffset} instance that is returned.
  #
  # @return [TimestampWithOffset] the local time when this transition causes
  #   the next observance to start.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:76
  def local_start_at; end

  # @return [TimezoneOffset] the offset this transition changes to.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:9
  def offset; end

  # @return [TimezoneOffset] the offset this transition changes from.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:12
  def previous_offset; end

  # When this transition occurs as an `Integer` number of seconds since
  # 1970-01-01 00:00:00 UTC ignoring leap seconds (i.e. each day is treated as
  # if it were 86,400 seconds long). Equivalent to the result of calling the
  # {Timestamp#value value} method on the {Timestamp} returned by {at}.
  #
  # @return [Integer] when this transition occurs as a number of seconds since
  #   1970-01-01 00:00:00 UTC ignoring leap seconds.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/timezone_transition.rb:21
  def timestamp_value; end
end

# Base class for rules definining the transition between standard and daylight
# savings time.
#
# @abstract
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:10
class TZInfo::TransitionRule
  # Initializes a new {TransitionRule}.
  #
  # @param transition_at [Integer] the time in seconds after midnight local
  #   time at which the transition occurs.
  # @raise [ArgumentError] if `transition_at` is not an `Integer`.
  # @return [TransitionRule] a new instance of TransitionRule
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:25
  def initialize(transition_at); end

  # Determines if this {TransitionRule} is equal to another instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {TransitionRule} with the same
  #   {transition_at} as this {TransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:47
  def ==(r); end

  # Calculates the time of the transition from a given offset on a given year.
  #
  # @param offset [TimezoneOffset] the current offset at the time the rule
  #   will transition.
  # @param year [Integer] the year in which the transition occurs (local
  #   time).
  # @return [TimestampWithOffset] the time at which the transition occurs.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:37
  def at(offset, year); end

  # Determines if this {TransitionRule} is equal to another instance.
  #
  # @param r [Object] the instance to test for equality.
  # @return [Boolean] `true` if `r` is a {TransitionRule} with the same
  #   {transition_at} as this {TransitionRule}, otherwise `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:47
  def eql?(r); end

  # @return [Integer] a hash based on {hash_args} (defaulting to
  #   {transition_at}).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:54
  def hash; end

  # Returns the number of seconds after midnight local time on the day
  # identified by the rule at which the transition occurs. Can be negative to
  # denote a time on the prior day. Can be greater than or equal to 86,400 to
  # denote a time of the following day.
  #
  # @return [Integer] the time in seconds after midnight local time at which
  #   the transition occurs.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:18
  def transition_at; end

  protected

  # @return [Array] an `Array` of parameters that will influence the output of
  #   {hash}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transition_rule.rb:62
  def hash_args; end
end

# Represents a period of time in a time zone where the same offset from UTC
# applies. The period of time is bounded at at least one end, either having a
# start transition, end transition or both start and end transitions.
#
# source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:10
class TZInfo::TransitionsTimezonePeriod < ::TZInfo::TimezonePeriod
  # Initializes a {TransitionsTimezonePeriod}.
  #
  # At least one of `start_transition` and `end_transition` must be specified.
  #
  # @param start_transition [TimezoneTransition] the transition that defines
  #   the start of the period, or `nil` if the start is unbounded.
  # @param end_transition [TimezoneTransition] the transition that defines the
  #   end of the period, or `nil` if the end is unbounded.
  # @raise [ArgumentError] if both `start_transition` and `end_transition` are
  #   `nil`.
  # @return [TransitionsTimezonePeriod] a new instance of TransitionsTimezonePeriod
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:27
  def initialize(start_transition, end_transition); end

  # Determines if this {TransitionsTimezonePeriod} is equal to another
  # instance.
  #
  # @param p [Object] the instance to test for equality.
  # @return [Boolean] `true` if `p` is a {TransitionsTimezonePeriod} with the
  #   same {offset}, {start_transition} and {end_transition}, otherwise
  #   `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:47
  def ==(p); end

  # @return [TimezoneTransition] the transition that defines the end of this
  #   {TimezonePeriod} (`nil` if the end is unbounded).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:15
  def end_transition; end

  # Determines if this {TransitionsTimezonePeriod} is equal to another
  # instance.
  #
  # @param p [Object] the instance to test for equality.
  # @return [Boolean] `true` if `p` is a {TransitionsTimezonePeriod} with the
  #   same {offset}, {start_transition} and {end_transition}, otherwise
  #   `false`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:47
  def eql?(p); end

  # @return [Integer] a hash based on {start_transition} and {end_transition}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:53
  def hash; end

  # @return [String] the internal object state as a programmer-readable
  #   `String`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:59
  def inspect; end

  # @return [TimezoneTransition] the transition that defines the start of this
  #   {TimezonePeriod} (`nil` if the start is unbounded).
  #
  # source://tzinfo-2.0.5/lib/tzinfo/transitions_timezone_period.rb:11
  def start_transition; end
end

# An implementation of {StringDeduper} using the `String#-@` method where
# that method performs deduplication (Ruby 2.5 and later).
#
# Note that this is slightly different to the plain {StringDeduper}
# implementation. In this implementation, frozen literal strings are already
# in the pool and are candidates for being returned, even when passed
# another equal frozen non-literal string. {StringDeduper} will always
# return frozen strings.
#
# There are also differences in encoding handling. This implementation will
# treat strings with different encodings as different strings.
# {StringDeduper} will treat strings with the compatible encodings as the
# same string.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:90
class TZInfo::UnaryMinusGlobalStringDeduper
  # @param string [String] the string to deduplicate.
  # @return [bool] `string` if it is frozen, otherwise a frozen, possibly
  #   pre-existing copy of `string`.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/string_deduper.rb:94
  def dedupe(string); end
end

# {UnknownTimezone} is raised when calling methods on an instance of
# {Timezone} that was created directly. To obtain {Timezone} instances the
# {Timezone.get} method should be used instead.
#
# source://tzinfo-2.0.5/lib/tzinfo/timezone.rb:32
class TZInfo::UnknownTimezone < ::StandardError; end

# Object#untaint is deprecated in Ruby >= 2.7 and will be removed in 3.2.
# UntaintExt adds a refinement to make Object#untaint a no-op and avoid the
# warning.
#
# @private
#
# source://tzinfo-2.0.5/lib/tzinfo/untaint_ext.rb:10
module TZInfo::UntaintExt; end

# The TZInfo version number.
#
# source://tzinfo-2.0.5/lib/tzinfo/version.rb:6
TZInfo::VERSION = T.let(T.unsafe(nil), String)

# The {WithOffset} module is included in {TimeWithOffset},
# {DateTimeWithOffset} and {TimestampWithOffset}. It provides an override for
# the {strftime} method that handles expanding the `%Z` directive according to
# the {TimezoneOffset#abbreviation abbreviation} of the {TimezoneOffset}
# associated with a local time.
#
# source://tzinfo-2.0.5/lib/tzinfo/with_offset.rb:10
module TZInfo::WithOffset
  # Overrides the `Time`, `DateTime` or {Timestamp} version of `strftime`,
  # replacing `%Z` with the {TimezoneOffset#abbreviation abbreviation} of the
  # associated {TimezoneOffset}. If there is no associated offset, `%Z` is
  # expanded by the base class instead.
  #
  # All the format directives handled by the base class are supported.
  #
  # @param format [String] the format string.
  # @raise [ArgumentError] if `format` is `nil`.
  # @return [String] the formatted time.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/with_offset.rb:21
  def strftime(format); end

  protected

  # Performs a calculation if there is an associated {TimezoneOffset}.
  #
  # @param result [Object] a result value that can be manipulated by the block
  #   if there is an associated {TimezoneOffset}.
  # @private
  # @return [Object] the result of the block if there is an associated
  #   {TimezoneOffset}, otherwise the `result` parameter.
  # @yield [period, result] if there is an associated {TimezoneOffset}, the
  #   block is yielded to in order to calculate the method result.
  # @yieldparam period [TimezoneOffset] the associated {TimezoneOffset}.
  # @yieldparam result [Object] the `result` parameter.
  # @yieldreturn [Object] the result of the calculation performed if there is
  #   an associated {TimezoneOffset}.
  #
  # source://tzinfo-2.0.5/lib/tzinfo/with_offset.rb:56
  def if_timezone_offset(result = T.unsafe(nil)); end
end
