# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `thor` gem.
# Please instead update this file by running `bin/tapioca gem thor`.

# source://thor-1.2.1/lib/thor/command.rb:1
class Thor
  include ::Thor::Base
  include ::Thor::Invocation
  include ::Thor::Shell
  extend ::Thor::Base::ClassMethods
  extend ::Thor::Invocation::ClassMethods

  # source://thor-1.2.1/lib/thor.rb:505
  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  class << self
    # Extend check unknown options to accept a hash of conditions.
    #
    # === Parameters
    # options<Hash>: A hash containing :only and/or :except keys
    #
    # source://thor-1.2.1/lib/thor.rb:255
    def check_unknown_options!(options = T.unsafe(nil)); end

    # Overwrite check_unknown_options? to take subcommands and options into account.
    #
    # @return [Boolean]
    #
    # source://thor-1.2.1/lib/thor.rb:268
    def check_unknown_options?(config); end

    # Prints help information for the given command.
    #
    # ==== Parameters
    # shell<Thor::Shell>
    # command_name<String>
    #
    # source://thor-1.2.1/lib/thor.rb:172
    def command_help(shell, command_name); end

    # Sets the default command when thor is executed without an explicit command to be called.
    #
    # ==== Parameters
    # meth<Symbol>:: name of the default command
    #
    # source://thor-1.2.1/lib/thor.rb:21
    def default_command(meth = T.unsafe(nil)); end

    # Sets the default command when thor is executed without an explicit command to be called.
    #
    # ==== Parameters
    # meth<Symbol>:: name of the default command
    #
    # source://thor-1.2.1/lib/thor.rb:21
    def default_task(meth = T.unsafe(nil)); end

    # source://thor-1.2.1/lib/thor/base.rb:26
    def deprecation_warning(message); end

    # Defines the usage and the description of the next command.
    #
    # ==== Parameters
    # usage<String>
    # description<String>
    # options<String>
    #
    # source://thor-1.2.1/lib/thor.rb:54
    def desc(usage, description, options = T.unsafe(nil)); end

    # Disable the check for required options for the given commands.
    # This is useful if you have a command that does not need the required options
    # to work, like help.
    #
    # ==== Parameters
    # Symbol ...:: A list of commands that should be affected.
    #
    # source://thor-1.2.1/lib/thor.rb:339
    def disable_required_check!(*command_names); end

    # @return [Boolean]
    #
    # source://thor-1.2.1/lib/thor.rb:343
    def disable_required_check?(command); end

    # Prints help information for this class.
    #
    # ==== Parameters
    # shell<Thor::Shell>
    #
    # source://thor-1.2.1/lib/thor.rb:195
    def help(shell, subcommand = T.unsafe(nil)); end

    # Defines the long description of the next command.
    #
    # ==== Parameters
    # long description<String>
    #
    # source://thor-1.2.1/lib/thor.rb:71
    def long_desc(long_description, options = T.unsafe(nil)); end

    # Maps an input to a command. If you define:
    #
    #   map "-T" => "list"
    #
    # Running:
    #
    #   thor -T
    #
    # Will invoke the list command.
    #
    # ==== Parameters
    # Hash[String|Array => Symbol]:: Maps the string or the strings in the array to the given command.
    #
    # source://thor-1.2.1/lib/thor.rb:93
    def map(mappings = T.unsafe(nil), **kw); end

    # Adds an option to the set of method options. If :for is given as option,
    # it allows you to change the options from a previous defined command.
    #
    #   def previous_command
    #     # magic
    #   end
    #
    #   method_option :foo => :bar, :for => :previous_command
    #
    #   def next_command
    #     # magic
    #   end
    #
    # ==== Parameters
    # name<Symbol>:: The name of the argument.
    # options<Hash>:: Described below.
    #
    # ==== Options
    # :desc     - Description for the argument.
    # :required - If the argument is required or not.
    # :default  - Default value for this argument. It cannot be required and have default values.
    # :aliases  - Aliases for this option.
    # :type     - The type of the argument, can be :string, :hash, :array, :numeric or :boolean.
    # :banner   - String to show on usage notes.
    # :hide     - If you want to hide this option from the help.
    #
    # source://thor-1.2.1/lib/thor.rb:155
    def method_option(name, options = T.unsafe(nil)); end

    # Declares the options for the next command to be declared.
    #
    # ==== Parameters
    # Hash[Symbol => Object]:: The hash key is the name of the option and the value
    # is the type of the option. Can be :string, :array, :hash, :boolean, :numeric
    # or :required (string). If you give a value, the type of the value is used.
    #
    # source://thor-1.2.1/lib/thor.rb:121
    def method_options(options = T.unsafe(nil)); end

    # Adds an option to the set of method options. If :for is given as option,
    # it allows you to change the options from a previous defined command.
    #
    #   def previous_command
    #     # magic
    #   end
    #
    #   method_option :foo => :bar, :for => :previous_command
    #
    #   def next_command
    #     # magic
    #   end
    #
    # ==== Parameters
    # name<Symbol>:: The name of the argument.
    # options<Hash>:: Described below.
    #
    # ==== Options
    # :desc     - Description for the argument.
    # :required - If the argument is required or not.
    # :default  - Default value for this argument. It cannot be required and have default values.
    # :aliases  - Aliases for this option.
    # :type     - The type of the argument, can be :string, :hash, :array, :numeric or :boolean.
    # :banner   - String to show on usage notes.
    # :hide     - If you want to hide this option from the help.
    #
    # source://thor-1.2.1/lib/thor.rb:155
    def option(name, options = T.unsafe(nil)); end

    # Declares the options for the next command to be declared.
    #
    # ==== Parameters
    # Hash[Symbol => Object]:: The hash key is the name of the option and the value
    # is the type of the option. Can be :string, :array, :hash, :boolean, :numeric
    # or :required (string). If you give a value, the type of the value is used.
    #
    # source://thor-1.2.1/lib/thor.rb:121
    def options(options = T.unsafe(nil)); end

    # Allows for custom "Command" package naming.
    #
    # === Parameters
    # name<String>
    # options<Hash>
    #
    # source://thor-1.2.1/lib/thor.rb:12
    def package_name(name, _ = T.unsafe(nil)); end

    # Returns commands ready to be printed.
    #
    # source://thor-1.2.1/lib/thor.rb:214
    def printable_commands(all = T.unsafe(nil), subcommand = T.unsafe(nil)); end

    # Returns commands ready to be printed.
    #
    # source://thor-1.2.1/lib/thor.rb:214
    def printable_tasks(all = T.unsafe(nil), subcommand = T.unsafe(nil)); end

    # Registers another Thor subclass as a command.
    #
    # ==== Parameters
    # klass<Class>:: Thor subclass to register
    # command<String>:: Subcommand name to use
    # usage<String>:: Short usage for the subcommand
    # description<String>:: Description for the subcommand
    #
    # source://thor-1.2.1/lib/thor.rb:37
    def register(klass, subcommand_name, usage, description, options = T.unsafe(nil)); end

    # Stop parsing of options as soon as an unknown option or a regular
    # argument is encountered.  All remaining arguments are passed to the command.
    # This is useful if you have a command that can receive arbitrary additional
    # options, and where those additional options should not be handled by
    # Thor.
    #
    # ==== Example
    #
    # To better understand how this is useful, let's consider a command that calls
    # an external command.  A user may want to pass arbitrary options and
    # arguments to that command.  The command itself also accepts some options,
    # which should be handled by Thor.
    #
    #   class_option "verbose",  :type => :boolean
    #   stop_on_unknown_option! :exec
    #   check_unknown_options!  :except => :exec
    #
    #   desc "exec", "Run a shell command"
    #   def exec(*args)
    #     puts "diagnostic output" if options[:verbose]
    #     Kernel.exec(*args)
    #   end
    #
    # Here +exec+ can be called with +--verbose+ to get diagnostic output,
    # e.g.:
    #
    #   $ thor exec --verbose echo foo
    #   diagnostic output
    #   foo
    #
    # But if +--verbose+ is given after +echo+, it is passed to +echo+ instead:
    #
    #   $ thor exec echo --verbose foo
    #   --verbose foo
    #
    # ==== Parameters
    # Symbol ...:: A list of commands that should be affected.
    #
    # source://thor-1.2.1/lib/thor.rb:325
    def stop_on_unknown_option!(*command_names); end

    # @return [Boolean]
    #
    # source://thor-1.2.1/lib/thor.rb:329
    def stop_on_unknown_option?(command); end

    # source://thor-1.2.1/lib/thor.rb:234
    def subcommand(subcommand, subcommand_class); end

    # source://thor-1.2.1/lib/thor.rb:230
    def subcommand_classes; end

    # source://thor-1.2.1/lib/thor.rb:225
    def subcommands; end

    # source://thor-1.2.1/lib/thor.rb:234
    def subtask(subcommand, subcommand_class); end

    # source://thor-1.2.1/lib/thor.rb:225
    def subtasks; end

    # Prints help information for the given command.
    #
    # ==== Parameters
    # shell<Thor::Shell>
    # command_name<String>
    #
    # source://thor-1.2.1/lib/thor.rb:172
    def task_help(shell, command_name); end

    protected

    # The banner for this class. You can customize it if you are invoking the
    # thor class by another ways which is not the Thor::Runner. It receives
    # the command that is going to be invoked and a boolean which indicates if
    # the namespace should be displayed as arguments.
    #
    # source://thor-1.2.1/lib/thor.rb:400
    def banner(command, namespace = T.unsafe(nil), subcommand = T.unsafe(nil)); end

    # source://thor-1.2.1/lib/thor.rb:406
    def baseclass; end

    # source://thor-1.2.1/lib/thor.rb:414
    def create_command(meth); end

    # source://thor-1.2.1/lib/thor.rb:414
    def create_task(meth); end

    # help command has the required check disabled by default.
    #
    # source://thor-1.2.1/lib/thor.rb:354
    def disable_required_check; end

    # The method responsible for dispatching given the args.
    #
    # @yield [instance]
    #
    # source://thor-1.2.1/lib/thor.rb:359
    def dispatch(meth, given_args, given_opts, config); end

    # source://thor-1.2.1/lib/thor.rb:410
    def dynamic_command_class; end

    # this is the logic that takes the command name passed in by the user
    # and determines whether it is an unambiguous substrings of a command or
    # alias name.
    #
    # source://thor-1.2.1/lib/thor.rb:476
    def find_command_possibilities(meth); end

    # this is the logic that takes the command name passed in by the user
    # and determines whether it is an unambiguous substrings of a command or
    # alias name.
    #
    # source://thor-1.2.1/lib/thor.rb:476
    def find_task_possibilities(meth); end

    # source://thor-1.2.1/lib/thor.rb:436
    def initialize_added; end

    # receives a (possibly nil) command name and returns a name that is in
    # the commands hash. In addition to normalizing aliases, this logic
    # will determine if a shortened command is an unambiguous substring of
    # a command or alias.
    #
    # +normalize_command_name+ also converts names like +animal-prison+
    # into +animal_prison+.
    #
    # @raise [AmbiguousTaskError]
    #
    # source://thor-1.2.1/lib/thor.rb:455
    def normalize_command_name(meth); end

    # receives a (possibly nil) command name and returns a name that is in
    # the commands hash. In addition to normalizing aliases, this logic
    # will determine if a shortened command is an unambiguous substring of
    # a command or alias.
    #
    # +normalize_command_name+ also converts names like +animal-prison+
    # into +animal_prison+.
    #
    # @raise [AmbiguousTaskError]
    #
    # source://thor-1.2.1/lib/thor.rb:455
    def normalize_task_name(meth); end

    # Retrieve the command name from given args.
    #
    # source://thor-1.2.1/lib/thor.rb:442
    def retrieve_command_name(args); end

    # Retrieve the command name from given args.
    #
    # source://thor-1.2.1/lib/thor.rb:442
    def retrieve_task_name(args); end

    # source://thor-1.2.1/lib/thor.rb:349
    def stop_on_unknown_option; end

    # source://thor-1.2.1/lib/thor.rb:491
    def subcommand_help(cmd); end

    # source://thor-1.2.1/lib/thor.rb:491
    def subtask_help(cmd); end
  end
end

# source://thor-1.2.1/lib/thor/actions/empty_directory.rb:2
module Thor::Actions
  mixes_in_class_methods ::Thor::Actions::ClassMethods

  # Extends initializer to add more configuration options.
  #
  # ==== Configuration
  # behavior<Symbol>:: The actions default behavior. Can be :invoke or :revoke.
  #                    It also accepts :force, :skip and :pretend to set the behavior
  #                    and the respective option.
  #
  # destination_root<String>:: The root directory needed for some actions.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:72
  def initialize(args = T.unsafe(nil), options = T.unsafe(nil), config = T.unsafe(nil)); end

  # Wraps an action object and call it accordingly to the thor class behavior.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:89
  def action(instance); end

  # Create a new file relative to the destination root with the given data,
  # which is the return value of a block or a data string.
  #
  # ==== Parameters
  # destination<String>:: the relative path to the destination root.
  # data<String|NilClass>:: the data to append to the file.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   create_file "lib/fun_party.rb" do
  #     hostname = ask("What is the virtual hostname I should use?")
  #     "vhost.name = #{hostname}"
  #   end
  #
  #   create_file "config/apache.conf", "your apache config"
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:22
  def add_file(destination, *args, &block); end

  # Create a new file relative to the destination root from the given source.
  #
  # ==== Parameters
  # destination<String>:: the relative path to the destination root.
  # source<String|NilClass>:: the relative path to the source root.
  # config<Hash>:: give :verbose => false to not log the status.
  #   :: give :symbolic => false for hard link.
  #
  # ==== Examples
  #
  #   create_link "config/apache.conf", "/etc/apache.conf"
  #
  # source://thor-1.2.1/lib/thor/actions/create_link.rb:17
  def add_link(destination, *args); end

  # Append text to a file. Since it depends on insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # data<String>:: the data to append to the file, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   append_to_file 'config/environments/test.rb', 'config.gem "rspec"'
  #
  #   append_to_file 'config/environments/test.rb' do
  #     'config.gem "rspec"'
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:195
  def append_file(path, *args, &block); end

  # Append text to a file. Since it depends on insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # data<String>:: the data to append to the file, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   append_to_file 'config/environments/test.rb', 'config.gem "rspec"'
  #
  #   append_to_file 'config/environments/test.rb' do
  #     'config.gem "rspec"'
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:195
  def append_to_file(path, *args, &block); end

  # Loads an external file and execute it in the instance binding.
  #
  # ==== Parameters
  # path<String>:: The path to the file to execute. Can be a web address or
  #                a relative path from the source root.
  #
  # ==== Examples
  #
  #   apply "http://gist.github.com/103208"
  #
  #   apply "recipes/jquery.rb"
  #
  # source://thor-1.2.1/lib/thor/actions.rb:216
  def apply(path, config = T.unsafe(nil)); end

  # Returns the value of attribute behavior.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:10
  def behavior; end

  # Sets the attribute behavior
  #
  # @param value the value to set the attribute behavior to.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:10
  def behavior=(_arg0); end

  # Changes the mode of the given file or directory.
  #
  # ==== Parameters
  # mode<Integer>:: the file mode
  # path<String>:: the name of the file to change mode
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   chmod "script/server", 0755
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:148
  def chmod(path, mode, config = T.unsafe(nil)); end

  # Comment all lines matching a given regex.  It will leave the space
  # which existed before the beginning of the line in tact and will insert
  # a single space after the comment hash.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # flag<Regexp|String>:: the regexp or string used to decide which lines to comment
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   comment_lines 'config/initializers/session_store.rb', /cookie_store/
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:312
  def comment_lines(path, flag, *args); end

  # ==== Examples
  #
  #   copy_file "README", "doc/README"
  #
  #   copy_file "doc/README"
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:21
  def copy_file(source, *args, &block); end

  # Create a new file relative to the destination root with the given data,
  # which is the return value of a block or a data string.
  #
  # ==== Parameters
  # destination<String>:: the relative path to the destination root.
  # data<String|NilClass>:: the data to append to the file.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   create_file "lib/fun_party.rb" do
  #     hostname = ask("What is the virtual hostname I should use?")
  #     "vhost.name = #{hostname}"
  #   end
  #
  #   create_file "config/apache.conf", "your apache config"
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:22
  def create_file(destination, *args, &block); end

  # Create a new file relative to the destination root from the given source.
  #
  # ==== Parameters
  # destination<String>:: the relative path to the destination root.
  # source<String|NilClass>:: the relative path to the source root.
  # config<Hash>:: give :verbose => false to not log the status.
  #   :: give :symbolic => false for hard link.
  #
  # ==== Examples
  #
  #   create_link "config/apache.conf", "/etc/apache.conf"
  #
  # source://thor-1.2.1/lib/thor/actions/create_link.rb:17
  def create_link(destination, *args); end

  # Returns the root for this thor class (also aliased as destination root).
  #
  # source://thor-1.2.1/lib/thor/actions.rb:99
  def destination_root; end

  # Sets the root for this thor class. Relatives path are added to the
  # directory where the script was invoked and expanded.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:106
  def destination_root=(root); end

  # Copies recursively the files from source directory to root directory.
  # If any of the files finishes with .tt, it's considered to be a template
  # and is placed in the destination without the extension .tt. If any
  # empty directory is found, it's copied and all .empty_directory files are
  # ignored. If any file name is wrapped within % signs, the text within
  # the % signs will be executed as a method and replaced with the returned
  # value. Let's suppose a doc directory with the following files:
  #
  #   doc/
  #     components/.empty_directory
  #     README
  #     rdoc.rb.tt
  #     %app_name%.rb
  #
  # When invoked as:
  #
  #   directory "doc"
  #
  # It will create a doc directory in the destination with the following
  # files (assuming that the `app_name` method returns the value "blog"):
  #
  #   doc/
  #     components/
  #     README
  #     rdoc.rb
  #     blog.rb
  #
  # <b>Encoded path note:</b> Since Thor internals use Object#respond_to? to check if it can
  # expand %something%, this `something` should be a public method in the class calling
  # #directory. If a method is private, Thor stack raises PrivateMethodEncodedError.
  #
  # ==== Parameters
  # source<String>:: the relative path to the source root.
  # destination<String>:: the relative path to the destination root.
  # config<Hash>:: give :verbose => false to not log the status.
  #                If :recursive => false, does not look for paths recursively.
  #                If :mode => :preserve, preserve the file mode from the source.
  #                If :exclude_pattern => /regexp/, prevents copying files that match that regexp.
  #
  # ==== Examples
  #
  #   directory "doc"
  #   directory "doc", "_docs", :recursive => false
  #
  # source://thor-1.2.1/lib/thor/actions/directory.rb:49
  def directory(source, *args, &block); end

  # Creates an empty directory.
  #
  # ==== Parameters
  # destination<String>:: the relative path to the destination root.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   empty_directory "doc"
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:13
  def empty_directory(destination, config = T.unsafe(nil)); end

  # Receives a file or directory and search for it in the source paths.
  #
  # @raise [Error]
  #
  # source://thor-1.2.1/lib/thor/actions.rb:133
  def find_in_source_paths(file); end

  # Gets the content at the given address and places it at the given relative
  # destination. If a block is given instead of destination, the content of
  # the url is yielded and used as location.
  #
  # +get+ relies on open-uri, so passing application user input would provide
  # a command injection attack vector.
  #
  # ==== Parameters
  # source<String>:: the address of the given content.
  # destination<String>:: the relative path to the destination root.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   get "http://gist.github.com/103208", "doc/README"
  #
  #   get "http://gist.github.com/103208" do |content|
  #     content.split("\n").first
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:79
  def get(source, *args, &block); end

  # Run a regular expression replacement on a file.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # flag<Regexp|String>:: the regexp or string to be replaced
  # replacement<String>:: the replacement, can be also given as a block
  # config<Hash>:: give :verbose => false to not log the status, and
  #                :force => true, to force the replacement regardles of runner behavior.
  #
  # ==== Example
  #
  #   gsub_file 'app/controllers/application_controller.rb', /#\s*(filter_parameter_logging :password)/, '\1'
  #
  #   gsub_file 'README', /rake/, :green do |match|
  #     match << " no more. Use thor!"
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:265
  def gsub_file(path, flag, *args, &block); end

  # Goes to the root and execute the given block.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:200
  def in_root; end

  # Injects text right after the class definition. Since it depends on
  # insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # klass<String|Class>:: the class to be manipulated
  # data<String>:: the data to append to the class, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   inject_into_class "app/controllers/application_controller.rb", "ApplicationController", "  filter_parameter :password\n"
  #
  #   inject_into_class "app/controllers/application_controller.rb", "ApplicationController" do
  #     "  filter_parameter :password\n"
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:219
  def inject_into_class(path, klass, *args, &block); end

  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:26
  def inject_into_file(destination, *args, &block); end

  # Injects text right after the module definition. Since it depends on
  # insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # module_name<String|Class>:: the module to be manipulated
  # data<String>:: the data to append to the class, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   inject_into_module "app/helpers/application_helper.rb", "ApplicationHelper", "  def help; 'help'; end\n"
  #
  #   inject_into_module "app/helpers/application_helper.rb", "ApplicationHelper" do
  #     "  def help; 'help'; end\n"
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:242
  def inject_into_module(path, module_name, *args, &block); end

  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:26
  def insert_into_file(destination, *args, &block); end

  # Do something in the root or on a provided subfolder. If a relative path
  # is given it's referenced from the current root. The full path is yielded
  # to the block you provide. The path is set back to the previous path when
  # the method exits.
  #
  # Returns the value yielded by the block.
  #
  # ==== Parameters
  # dir<String>:: the directory to move to.
  # config<Hash>:: give :verbose => true to log and use padding.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:170
  def inside(dir = T.unsafe(nil), config = T.unsafe(nil), &block); end

  # Links the file from the relative source to the relative destination. If
  # the destination is not given it's assumed to be equal to the source.
  #
  # ==== Parameters
  # source<String>:: the relative path to the source root.
  # destination<String>:: the relative path to the destination root.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   link_file "README", "doc/README"
  #
  #   link_file "doc/README"
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:51
  def link_file(source, *args); end

  # Prepend text to a file. Since it depends on insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # data<String>:: the data to prepend to the file, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   prepend_to_file 'config/environments/test.rb', 'config.gem "rspec"'
  #
  #   prepend_to_file 'config/environments/test.rb' do
  #     'config.gem "rspec"'
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:173
  def prepend_file(path, *args, &block); end

  # Prepend text to a file. Since it depends on insert_into_file, it's reversible.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # data<String>:: the data to prepend to the file, can be also given as a block.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   prepend_to_file 'config/environments/test.rb', 'config.gem "rspec"'
  #
  #   prepend_to_file 'config/environments/test.rb' do
  #     'config.gem "rspec"'
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:173
  def prepend_to_file(path, *args, &block); end

  # Returns the given path relative to the absolute root (ie, root where
  # the script started).
  #
  # source://thor-1.2.1/lib/thor/actions.rb:114
  def relative_to_original_destination_root(path, remove_dot = T.unsafe(nil)); end

  # Removes a file at the given location.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   remove_file 'README'
  #   remove_file 'app/controllers/application_controller.rb'
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:329
  def remove_dir(path, config = T.unsafe(nil)); end

  # Removes a file at the given location.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   remove_file 'README'
  #   remove_file 'app/controllers/application_controller.rb'
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:329
  def remove_file(path, config = T.unsafe(nil)); end

  # Executes a command returning the contents of the command.
  #
  # ==== Parameters
  # command<String>:: the command to be executed.
  # config<Hash>:: give :verbose => false to not log the status, :capture => true to hide to output. Specify :with
  #                to append an executable to command execution.
  #
  # ==== Example
  #
  #   inside('vendor') do
  #     run('ln -s ~/edge rails')
  #   end
  #
  # source://thor-1.2.1/lib/thor/actions.rb:248
  def run(command, config = T.unsafe(nil)); end

  # Executes a ruby script (taking into account WIN32 platform quirks).
  #
  # ==== Parameters
  # command<String>:: the command to be executed.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:285
  def run_ruby_script(command, config = T.unsafe(nil)); end

  # Holds source paths in instance so they can be manipulated.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:127
  def source_paths; end

  # Gets an ERB template at the relative source, executes it and makes a copy
  # at the relative destination. If the destination is not given it's assumed
  # to be equal to the source removing .tt from the filename.
  #
  # ==== Parameters
  # source<String>:: the relative path to the source root.
  # destination<String>:: the relative path to the destination root.
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Examples
  #
  #   template "README", "doc/README"
  #
  #   template "doc/README"
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:115
  def template(source, *args, &block); end

  # Run a thor command. A hash of options can be given and it's converted to
  # switches.
  #
  # ==== Parameters
  # command<String>:: the command to be invoked
  # args<Array>:: arguments to the command
  # config<Hash>:: give :verbose => false to not log the status, :capture => true to hide to output.
  #                Other options are given as parameter to Thor.
  #
  #
  # ==== Examples
  #
  #   thor :install, "http://gist.github.com/103208"
  #   #=> thor install http://gist.github.com/103208
  #
  #   thor :list, :all => true, :substring => 'rails'
  #   #=> thor list --all --substring=rails
  #
  # source://thor-1.2.1/lib/thor/actions.rb:308
  def thor(command, *args); end

  # Uncomment all lines matching a given regex.  It will leave the space
  # which existed before the comment hash in tact but will remove any spacing
  # between the comment hash and the beginning of the line.
  #
  # ==== Parameters
  # path<String>:: path of the file to be changed
  # flag<Regexp|String>:: the regexp or string used to decide which lines to uncomment
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # ==== Example
  #
  #   uncomment_lines 'config/initializers/session_store.rb', /active_record/
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:293
  def uncomment_lines(path, flag, *args); end

  protected

  # source://thor-1.2.1/lib/thor/actions.rb:329
  def _cleanup_options_and_set(options, key); end

  # Allow current root to be shared between invocations.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:325
  def _shared_configuration; end

  private

  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:350
  def capture(*args); end

  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:346
  def concat(string); end

  # Returns the value of attribute output_buffer.
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:341
  def output_buffer; end

  # Sets the attribute output_buffer
  #
  # @param value the value to set the attribute output_buffer to.
  #
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:341
  def output_buffer=(_arg0); end

  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:354
  def with_output_buffer(buf = T.unsafe(nil)); end

  class << self
    # source://thor-1.2.1/lib/thor/actions.rb:12
    def included(base); end
  end
end

# Thor::Actions#capture depends on what kind of buffer is used in ERB.
# Thus CapturableERB fixes ERB to use String buffer.
#
# source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:366
class Thor::Actions::CapturableERB < ::ERB
  # source://thor-1.2.1/lib/thor/actions/file_manipulation.rb:367
  def set_eoutvar(compiler, eoutvar = T.unsafe(nil)); end
end

# source://thor-1.2.1/lib/thor/actions.rb:17
module Thor::Actions::ClassMethods
  # Add runtime options that help actions execution.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:48
  def add_runtime_options!; end

  # Hold source paths for one Thor instance. source_paths_for_search is the
  # method responsible to gather source_paths from this current class,
  # inherited paths and the source root.
  #
  # source://thor-1.2.1/lib/thor/actions.rb:22
  def source_paths; end

  # Returns the source paths in the following order:
  #
  #   1) This class source paths
  #   2) Source root
  #   3) Parents source paths
  #
  # source://thor-1.2.1/lib/thor/actions.rb:38
  def source_paths_for_search; end

  # Stores and return the source root for this class
  #
  # source://thor-1.2.1/lib/thor/actions.rb:27
  def source_root(path = T.unsafe(nil)); end
end

# CreateFile is a subset of Template, which instead of rendering a file with
# ERB, it gets the content from the user.
#
# source://thor-1.2.1/lib/thor/actions/create_file.rb:32
class Thor::Actions::CreateFile < ::Thor::Actions::EmptyDirectory
  # @return [CreateFile] a new instance of CreateFile
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:35
  def initialize(base, destination, data, config = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/actions/create_file.rb:33
  def data; end

  # Checks if the content of the file at the destination is identical to the rendered result.
  #
  # ==== Returns
  # Boolean:: true if it is identical, false otherwise.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:45
  def identical?; end

  # source://thor-1.2.1/lib/thor/actions/create_file.rb:59
  def invoke!; end

  # Holds the content to be added to the file.
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:51
  def render; end

  protected

  # Shows the file collision menu to the user and gets the result.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:99
  def force_on_collision?; end

  # If force is true, run the action, otherwise check if it's not being
  # skipped. If both are false, show the file_collision menu, if the menu
  # returns true, force it, otherwise skip.
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:85
  def force_or_skip_or_conflict(force, skip, &block); end

  # Now on conflict we check if the file is identical or not.
  #
  # source://thor-1.2.1/lib/thor/actions/create_file.rb:72
  def on_conflict_behavior(&block); end
end

# CreateLink is a subset of CreateFile, which instead of taking a block of
# data, just takes a source string from the user.
#
# source://thor-1.2.1/lib/thor/actions/create_link.rb:27
class Thor::Actions::CreateLink < ::Thor::Actions::CreateFile
  # source://thor-1.2.1/lib/thor/actions/create_link.rb:28
  def data; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/create_link.rb:56
  def exists?; end

  # Checks if the content of the file at the destination is identical to the rendered result.
  #
  # ==== Returns
  # Boolean:: true if it is identical, false otherwise.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/create_link.rb:35
  def identical?; end

  # source://thor-1.2.1/lib/thor/actions/create_link.rb:40
  def invoke!; end
end

# source://thor-1.2.1/lib/thor/actions/directory.rb:55
class Thor::Actions::Directory < ::Thor::Actions::EmptyDirectory
  # @return [Directory] a new instance of Directory
  #
  # source://thor-1.2.1/lib/thor/actions/directory.rb:58
  def initialize(base, source, destination = T.unsafe(nil), config = T.unsafe(nil), &block); end

  # source://thor-1.2.1/lib/thor/actions/directory.rb:64
  def invoke!; end

  # source://thor-1.2.1/lib/thor/actions/directory.rb:69
  def revoke!; end

  # Returns the value of attribute source.
  #
  # source://thor-1.2.1/lib/thor/actions/directory.rb:56
  def source; end

  protected

  # source://thor-1.2.1/lib/thor/actions/directory.rb:75
  def execute!; end

  # source://thor-1.2.1/lib/thor/actions/directory.rb:99
  def file_level_lookup(previous_lookup); end

  # source://thor-1.2.1/lib/thor/actions/directory.rb:103
  def files(lookup); end
end

# source://thor-1.2.1/lib/thor/actions/empty_directory.rb:23
class Thor::Actions::EmptyDirectory
  # Initializes given the source and destination.
  #
  # ==== Parameters
  # base<Thor::Base>:: A Thor::Base instance
  # source<String>:: Relative path to the source of this file
  # destination<String>:: Relative path to the destination of this file
  # config<Hash>:: give :verbose => false to not log the status.
  #
  # @return [EmptyDirectory] a new instance of EmptyDirectory
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:34
  def initialize(base, destination, config = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:24
  def base; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:24
  def config; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:24
  def destination; end

  # Checks if the destination file already exists.
  #
  # ==== Returns
  # Boolean:: true if the file exists, false otherwise.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:45
  def exists?; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:24
  def given_destination; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:49
  def invoke!; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:24
  def relative_destination; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:56
  def revoke!; end

  protected

  # Filenames in the encoded form are converted. If you have a file:
  #
  #   %file_name%.rb
  #
  # It calls #file_name from the base and replaces %-string with the
  # return value (should be String) of #file_name:
  #
  #   user.rb
  #
  # The method referenced can be either public or private.
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:103
  def convert_encoded_instructions(filename); end

  # Sets the absolute destination value from a relative destination value.
  # It also stores the given and relative destination. Let's suppose our
  # script is being executed on "dest", it sets the destination root to
  # "dest". The destination, given_destination and relative_destination
  # are related in the following way:
  #
  #   inside "bar" do
  #     empty_directory "baz"
  #   end
  #
  #   destination          #=> dest/bar/baz
  #   relative_destination #=> bar/baz
  #   given_destination    #=> baz
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:85
  def destination=(destination); end

  # Receives a hash of options and just execute the block if some
  # conditions are met.
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:113
  def invoke_with_conflict_check(&block); end

  # What to do when the destination file already exists.
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:132
  def on_conflict_behavior; end

  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:126
  def on_file_clash_behavior; end

  # Shortcut for pretend.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:67
  def pretend?; end

  # Shortcut to say_status shell method.
  #
  # source://thor-1.2.1/lib/thor/actions/empty_directory.rb:138
  def say_status(status, color); end
end

# source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:36
class Thor::Actions::InjectIntoFile < ::Thor::Actions::EmptyDirectory
  # @return [InjectIntoFile] a new instance of InjectIntoFile
  #
  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:39
  def initialize(base, destination, data, config); end

  # Returns the value of attribute behavior.
  #
  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:37
  def behavior; end

  # Returns the value of attribute flag.
  #
  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:37
  def flag; end

  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:52
  def invoke!; end

  # Returns the value of attribute replacement.
  #
  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:37
  def replacement; end

  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:72
  def revoke!; end

  protected

  # Adds the content to the file.
  #
  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:108
  def replace!(regexp, string, force); end

  # source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:88
  def say_status(behavior, warning: T.unsafe(nil), color: T.unsafe(nil)); end
end

# Injects the given content into a file. Different from gsub_file, this
# method is reversible.
#
# ==== Parameters
# destination<String>:: Relative path to the destination root
# data<String>:: Data to add to the file. Can be given as a block.
# config<Hash>:: give :verbose => false to not log the status and the flag
#                for injection (:after or :before) or :force => true for
#                insert two or more times the same content.
#
# ==== Examples
#
#   insert_into_file "config/environment.rb", "config.gem :thor", :after => "Rails::Initializer.run do |config|\n"
#
#   insert_into_file "config/environment.rb", :after => "Rails::Initializer.run do |config|\n" do
#     gems = ask "Which gems would you like to add?"
#     gems.split(" ").map{ |gem| "  config.gem :#{gem}" }.join("\n")
#   end
#
# source://thor-1.2.1/lib/thor/actions/inject_into_file.rb:24
Thor::Actions::WARNINGS = T.let(T.unsafe(nil), Hash)

# source://thor-1.2.1/lib/thor/error.rb:60
class Thor::AmbiguousCommandError < ::Thor::Error; end

# source://thor-1.2.1/lib/thor/error.rb:62
Thor::AmbiguousTaskError = Thor::AmbiguousCommandError

# source://thor-1.2.1/lib/thor/parser/argument.rb:2
class Thor::Argument
  # @raise [ArgumentError]
  # @return [Argument] a new instance of Argument
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:8
  def initialize(name, options = T.unsafe(nil)); end

  # Returns the value of attribute banner.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def banner; end

  # Returns the value of attribute default.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def default; end

  # Returns the value of attribute description.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def description; end

  # Returns the value of attribute enum.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def enum; end

  # Returns the value of attribute name.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def human_name; end

  # Returns the value of attribute name.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def name; end

  # Returns the value of attribute required.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def required; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:31
  def required?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:35
  def show_default?; end

  # Returns the value of attribute type.
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:5
  def type; end

  # source://thor-1.2.1/lib/thor/parser/argument.rb:27
  def usage; end

  protected

  # source://thor-1.2.1/lib/thor/parser/argument.rb:55
  def default_banner; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:51
  def valid_type?(type); end

  # @raise [ArgumentError]
  #
  # source://thor-1.2.1/lib/thor/parser/argument.rb:46
  def validate!; end
end

# source://thor-1.2.1/lib/thor/parser/argument.rb:3
Thor::Argument::VALID_TYPES = T.let(T.unsafe(nil), Array)

# source://thor-1.2.1/lib/thor/parser/arguments.rb:2
class Thor::Arguments
  # Takes an array of Thor::Argument objects.
  #
  # @return [Arguments] a new instance of Arguments
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:26
  def initialize(arguments = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/parser/arguments.rb:44
  def parse(args); end

  # source://thor-1.2.1/lib/thor/parser/arguments.rb:57
  def remaining; end

  private

  # Raises an error if @non_assigned_required array is not empty.
  #
  # @raise [RequiredArgumentMissingError]
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:170
  def check_requirement!; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:88
  def current_is_value?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:68
  def last?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:63
  def no_or_skip?(arg); end

  # Runs through the argument array getting all strings until no string is
  # found or a switch is found.
  #
  #   ["a", "b", "c"]
  #
  # And returns it as an array:
  #
  #   ["a", "b", "c"]
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:122
  def parse_array(name); end

  # Runs through the argument array getting strings that contains ":" and
  # mark it as a hash:
  #
  #   [ "name:string", "age:integer" ]
  #
  # Becomes:
  #
  #   { "name" => "string", "age" => "integer" }
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:101
  def parse_hash(name); end

  # Check if the peek is numeric format and return a Float or Integer.
  # Check if the peek is included in enum if enum is provided.
  # Otherwise raises an error.
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:133
  def parse_numeric(name); end

  # Parse string:
  # for --string-arg, just return the current value in the pile
  # for --no-string-arg, nil
  # Check if the peek is included in enum if enum is provided. Otherwise raises an error.
  #
  # source://thor-1.2.1/lib/thor/parser/arguments.rb:154
  def parse_string(name); end

  # source://thor-1.2.1/lib/thor/parser/arguments.rb:72
  def peek; end

  # source://thor-1.2.1/lib/thor/parser/arguments.rb:76
  def shift; end

  # source://thor-1.2.1/lib/thor/parser/arguments.rb:80
  def unshift(arg); end

  class << self
    # source://thor-1.2.1/lib/thor/parser/arguments.rb:19
    def parse(*args); end

    # Receives an array of args and returns two arrays, one with arguments
    # and one with switches.
    #
    # source://thor-1.2.1/lib/thor/parser/arguments.rb:8
    def split(args); end
  end
end

# source://thor-1.2.1/lib/thor/parser/arguments.rb:3
Thor::Arguments::NUMERIC = T.let(T.unsafe(nil), Regexp)

# source://thor-1.2.1/lib/thor/shell.rb:4
module Thor::Base
  include ::Thor::Invocation
  include ::Thor::Shell

  mixes_in_class_methods ::Thor::Base::ClassMethods
  mixes_in_class_methods ::Thor::Invocation::ClassMethods

  # It receives arguments in an Array and two hashes, one for options and
  # other for configuration.
  #
  # Notice that it does not check if all required arguments were supplied.
  # It should be done by the parser.
  #
  # ==== Parameters
  # args<Array[Object]>:: An array of objects. The objects are applied to their
  #                       respective accessors declared with <tt>argument</tt>.
  #
  # options<Hash>:: An options hash that will be available as self.options.
  #                 The hash given is converted to a hash with indifferent
  #                 access, magic predicates (options.skip?) and then frozen.
  #
  # config<Hash>:: Configuration for this Thor class.
  #
  # source://thor-1.2.1/lib/thor/base.rb:53
  def initialize(args = T.unsafe(nil), local_options = T.unsafe(nil), config = T.unsafe(nil)); end

  # Returns the value of attribute args.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def args; end

  # Sets the attribute args
  #
  # @param value the value to set the attribute args to.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def args=(_arg0); end

  # Returns the value of attribute options.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def options=(_arg0); end

  # Returns the value of attribute parent_options.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def parent_options; end

  # Sets the attribute parent_options
  #
  # @param value the value to set the attribute parent_options to.
  #
  # source://thor-1.2.1/lib/thor/base.rb:35
  def parent_options=(_arg0); end

  class << self
    # source://thor-1.2.1/lib/thor/base.rb:100
    def included(base); end

    # Whenever a class inherits from Thor or Thor::Group, we should track the
    # class and the file on Thor::Base. This is the method responsible for it.
    #
    # source://thor-1.2.1/lib/thor/base.rb:128
    def register_klass_file(klass); end

    # Returns the shell used in all Thor classes. If you are in a Unix platform
    # it will use a colored log, otherwise it will use a basic one without color.
    #
    # source://thor-1.2.1/lib/thor/shell.rb:11
    def shell; end

    # Sets the attribute shell
    #
    # @param value the value to set the attribute shell to.
    #
    # source://thor-1.2.1/lib/thor/shell.rb:6
    def shell=(_arg0); end

    # Returns the files where the subclasses are kept.
    #
    # ==== Returns
    # Hash[path<String> => Class]
    #
    # source://thor-1.2.1/lib/thor/base.rb:121
    def subclass_files; end

    # Returns the classes that inherits from Thor or Thor::Group.
    #
    # ==== Returns
    # Array[Class]
    #
    # source://thor-1.2.1/lib/thor/base.rb:112
    def subclasses; end
  end
end

# source://thor-1.2.1/lib/thor/base.rb:137
module Thor::Base::ClassMethods
  # Returns the commands for this Thor class and all subclasses.
  #
  # ==== Returns
  # Hash:: An ordered hash with commands names as keys and Thor::Command
  #        objects as values.
  #
  # source://thor-1.2.1/lib/thor/base.rb:383
  def all_commands; end

  # Returns the commands for this Thor class and all subclasses.
  #
  # ==== Returns
  # Hash:: An ordered hash with commands names as keys and Thor::Command
  #        objects as values.
  #
  # source://thor-1.2.1/lib/thor/base.rb:383
  def all_tasks; end

  # If you want to use defaults that don't match the type of an option,
  # either specify `check_default_type: false` or call `allow_incompatible_default_type!`
  #
  # source://thor-1.2.1/lib/thor/base.rb:173
  def allow_incompatible_default_type!; end

  # Adds an argument to the class and creates an attr_accessor for it.
  #
  # Arguments are different from options in several aspects. The first one
  # is how they are parsed from the command line, arguments are retrieved
  # from position:
  #
  #   thor command NAME
  #
  # Instead of:
  #
  #   thor command --name=NAME
  #
  # Besides, arguments are used inside your code as an accessor (self.argument),
  # while options are all kept in a hash (self.options).
  #
  # Finally, arguments cannot have type :default or :boolean but can be
  # optional (supplying :optional => :true or :required => false), although
  # you cannot have a required argument after a non-required argument. If you
  # try it, an error is raised.
  #
  # ==== Parameters
  # name<Symbol>:: The name of the argument.
  # options<Hash>:: Described below.
  #
  # ==== Options
  # :desc     - Description for the argument.
  # :required - If the argument is required or not.
  # :optional - If the argument is optional or not.
  # :type     - The type of the argument, can be :string, :hash, :array, :numeric.
  # :default  - Default value for this argument. It cannot be required and have default values.
  # :banner   - String to show on usage notes.
  #
  # ==== Errors
  # ArgumentError:: Raised if you supply a required argument after a non required one.
  #
  # source://thor-1.2.1/lib/thor/base.rb:245
  def argument(name, options = T.unsafe(nil)); end

  # Returns this class arguments, looking up in the ancestors chain.
  #
  # ==== Returns
  # Array[Thor::Argument]
  #
  # source://thor-1.2.1/lib/thor/base.rb:277
  def arguments; end

  # source://thor-1.2.1/lib/thor/base.rb:146
  def attr_accessor(*_arg0); end

  # source://thor-1.2.1/lib/thor/base.rb:138
  def attr_reader(*_arg0); end

  # source://thor-1.2.1/lib/thor/base.rb:142
  def attr_writer(*_arg0); end

  # source://thor-1.2.1/lib/thor/base.rb:177
  def check_default_type; end

  # If you want to raise an error when the default value of an option does not match
  # the type call check_default_type!
  # This will be the default; for compatibility a deprecation warning is issued if necessary.
  #
  # source://thor-1.2.1/lib/thor/base.rb:167
  def check_default_type!; end

  # source://thor-1.2.1/lib/thor/base.rb:156
  def check_unknown_options; end

  # If you want to raise an error for unknown options, call check_unknown_options!
  # This is disabled by default to allow dynamic invocations.
  #
  # source://thor-1.2.1/lib/thor/base.rb:152
  def check_unknown_options!; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:160
  def check_unknown_options?(config); end

  # Adds an option to the set of class options
  #
  # ==== Parameters
  # name<Symbol>:: The name of the argument.
  # options<Hash>:: Described below.
  #
  # ==== Options
  # :desc::     -- Description for the argument.
  # :required:: -- If the argument is required or not.
  # :default::  -- Default value for this argument.
  # :group::    -- The group for this options. Use by class options to output options in different levels.
  # :aliases::  -- Aliases for this option. <b>Note:</b> Thor follows a convention of one-dash-one-letter options. Thus aliases like "-something" wouldn't be parsed; use either "\--something" or "-s" instead.
  # :type::     -- The type of the argument, can be :string, :hash, :array, :numeric or :boolean.
  # :banner::   -- String to show on usage notes.
  # :hide::     -- If you want to hide this option from the help.
  #
  # source://thor-1.2.1/lib/thor/base.rb:312
  def class_option(name, options = T.unsafe(nil)); end

  # Adds a bunch of options to the set of class options.
  #
  #   class_options :foo => false, :bar => :required, :baz => :string
  #
  # If you prefer more detailed declaration, check class_option.
  #
  # ==== Parameters
  # Hash[Symbol => Object]
  #
  # source://thor-1.2.1/lib/thor/base.rb:290
  def class_options(options = T.unsafe(nil)); end

  # Returns the commands for this Thor class.
  #
  # ==== Returns
  # Hash:: An ordered hash with commands names as keys and Thor::Command
  #        objects as values.
  #
  # source://thor-1.2.1/lib/thor/base.rb:372
  def commands; end

  # If true, option set will not suspend the execution of the command when
  # a required option is not provided.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:191
  def disable_required_check?(command_name); end

  # A flag that makes the process exit with status 1 if any error happens.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:529
  def exit_on_failure?; end

  # Defines the group. This is used when thor list is invoked so you can specify
  # that only commands from a pre-defined group will be shown. Defaults to standard.
  #
  # ==== Parameters
  # name<String|Symbol>
  #
  # source://thor-1.2.1/lib/thor/base.rb:358
  def group(name = T.unsafe(nil)); end

  # @raise [InvocationError]
  #
  # source://thor-1.2.1/lib/thor/base.rb:519
  def handle_argument_error(command, error, args, arity); end

  # @raise [UndefinedCommandError]
  #
  # source://thor-1.2.1/lib/thor/base.rb:514
  def handle_no_command_error(command, has_namespace = T.unsafe(nil)); end

  # @raise [UndefinedCommandError]
  #
  # source://thor-1.2.1/lib/thor/base.rb:514
  def handle_no_task_error(command, has_namespace = T.unsafe(nil)); end

  # Sets the namespace for the Thor or Thor::Group class. By default the
  # namespace is retrieved from the class name. If your Thor class is named
  # Scripts::MyScript, the help method, for example, will be called as:
  #
  #   thor scripts:my_script -h
  #
  # If you change the namespace:
  #
  #   namespace :my_scripts
  #
  # You change how your commands are invoked:
  #
  #   thor my_scripts -h
  #
  # Finally, if you change your namespace to default:
  #
  #   namespace :default
  #
  # Your commands can be invoked with a shortcut. Instead of:
  #
  #   thor :my_command
  #
  # source://thor-1.2.1/lib/thor/base.rb:467
  def namespace(name = T.unsafe(nil)); end

  # All methods defined inside the given block are not added as commands.
  #
  # So you can do:
  #
  #   class MyScript < Thor
  #     no_commands do
  #       def this_is_not_a_command
  #       end
  #     end
  #   end
  #
  # You can also add the method and remove it from the command list:
  #
  #   class MyScript < Thor
  #     def this_is_not_a_command
  #     end
  #     remove_command :this_is_not_a_command
  #   end
  #
  # source://thor-1.2.1/lib/thor/base.rb:431
  def no_commands(&block); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:441
  def no_commands?; end

  # source://thor-1.2.1/lib/thor/base.rb:437
  def no_commands_context; end

  # All methods defined inside the given block are not added as commands.
  #
  # So you can do:
  #
  #   class MyScript < Thor
  #     no_commands do
  #       def this_is_not_a_command
  #       end
  #     end
  #   end
  #
  # You can also add the method and remove it from the command list:
  #
  #   class MyScript < Thor
  #     def this_is_not_a_command
  #     end
  #     remove_command :this_is_not_a_command
  #   end
  #
  # source://thor-1.2.1/lib/thor/base.rb:431
  def no_tasks(&block); end

  # Allows to use private methods from parent in child classes as commands.
  #
  # ==== Parameters
  #   names<Array>:: Method names to be used as commands
  #
  # ==== Examples
  #
  #   public_command :foo
  #   public_command :foo, :bar, :baz
  #
  # source://thor-1.2.1/lib/thor/base.rb:507
  def public_command(*names); end

  # Allows to use private methods from parent in child classes as commands.
  #
  # ==== Parameters
  #   names<Array>:: Method names to be used as commands
  #
  # ==== Examples
  #
  #   public_command :foo
  #   public_command :foo, :bar, :baz
  #
  # source://thor-1.2.1/lib/thor/base.rb:507
  def public_task(*names); end

  # Removes a previous defined argument. If :undefine is given, undefine
  # accessors as well.
  #
  # ==== Parameters
  # names<Array>:: Arguments to be removed
  #
  # ==== Examples
  #
  #   remove_argument :foo
  #   remove_argument :foo, :bar, :baz, :undefine => true
  #
  # source://thor-1.2.1/lib/thor/base.rb:327
  def remove_argument(*names); end

  # Removes a previous defined class option.
  #
  # ==== Parameters
  # names<Array>:: Class options to be removed
  #
  # ==== Examples
  #
  #   remove_class_option :foo
  #   remove_class_option :foo, :bar, :baz
  #
  # source://thor-1.2.1/lib/thor/base.rb:346
  def remove_class_option(*names); end

  # Removes a given command from this Thor class. This is usually done if you
  # are inheriting from another class and don't want it to be available
  # anymore.
  #
  # By default it only remove the mapping to the command. But you can supply
  # :undefine => true to undefine the method from the class as well.
  #
  # ==== Parameters
  # name<Symbol|String>:: The name of the command to be removed
  # options<Hash>:: You can give :undefine => true if you want commands the method
  #                 to be undefined from the class as well.
  #
  # source://thor-1.2.1/lib/thor/base.rb:401
  def remove_command(*names); end

  # Removes a given command from this Thor class. This is usually done if you
  # are inheriting from another class and don't want it to be available
  # anymore.
  #
  # By default it only remove the mapping to the command. But you can supply
  # :undefine => true to undefine the method from the class as well.
  #
  # ==== Parameters
  # name<Symbol|String>:: The name of the command to be removed
  # options<Hash>:: You can give :undefine => true if you want commands the method
  #                 to be undefined from the class as well.
  #
  # source://thor-1.2.1/lib/thor/base.rb:401
  def remove_task(*names); end

  # Parses the command and options from the given args, instantiate the class
  # and invoke the command. This method is used when the arguments must be parsed
  # from an array. If you are inside Ruby and want to use a Thor class, you
  # can simply initialize it:
  #
  #   script = MyScript.new(args, options, config)
  #   script.invoke(:command, first_arg, second_arg, third_arg)
  #
  # source://thor-1.2.1/lib/thor/base.rb:483
  def start(given_args = T.unsafe(nil), config = T.unsafe(nil)); end

  # If true, option parsing is suspended as soon as an unknown option or a
  # regular argument is encountered.  All remaining arguments are passed to
  # the command as regular arguments.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:185
  def stop_on_unknown_option?(command_name); end

  # source://thor-1.2.1/lib/thor/base.rb:202
  def strict_args_position; end

  # If you want only strict string args (useful when cascading thor classes),
  # call strict_args_position! This is disabled by default to allow dynamic
  # invocations.
  #
  # source://thor-1.2.1/lib/thor/base.rb:198
  def strict_args_position!; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:206
  def strict_args_position?(config); end

  # Returns the commands for this Thor class.
  #
  # ==== Returns
  # Hash:: An ordered hash with commands names as keys and Thor::Command
  #        objects as values.
  #
  # source://thor-1.2.1/lib/thor/base.rb:372
  def tasks; end

  protected

  # SIGNATURE: Sets the baseclass. This is where the superclass lookup
  # finishes.
  #
  # source://thor-1.2.1/lib/thor/base.rb:679
  def baseclass; end

  # The basename of the program invoking the thor class.
  #
  # source://thor-1.2.1/lib/thor/base.rb:673
  def basename; end

  # Build an option and adds it to the given scope.
  #
  # ==== Parameters
  # name<Symbol>:: The name of the argument.
  # options<Hash>:: Described in both class_option and method_option.
  # scope<Hash>:: Options hash that is being built up
  #
  # source://thor-1.2.1/lib/thor/base.rb:590
  def build_option(name, options, scope); end

  # Receives a hash of options, parse them and add to the scope. This is a
  # fast way to set a bunch of options:
  #
  #   build_options :foo => true, :bar => :required, :baz => :string
  #
  # ==== Parameters
  # Hash[Symbol => Object]
  #
  # source://thor-1.2.1/lib/thor/base.rb:601
  def build_options(options, scope); end

  # Prints the class options per group. If an option does not belong to
  # any group, it's printed as Class option.
  #
  # source://thor-1.2.1/lib/thor/base.rb:539
  def class_options_help(shell, groups = T.unsafe(nil)); end

  # SIGNATURE: Creates a new command if valid_command? is true. This method is
  # called when a new method is added to the class.
  #
  # source://thor-1.2.1/lib/thor/base.rb:684
  def create_command(meth); end

  # SIGNATURE: Creates a new command if valid_command? is true. This method is
  # called when a new method is added to the class.
  #
  # source://thor-1.2.1/lib/thor/base.rb:684
  def create_task(meth); end

  # SIGNATURE: The hook invoked by start.
  #
  # @raise [NotImplementedError]
  #
  # source://thor-1.2.1/lib/thor/base.rb:694
  def dispatch(command, given_args, given_opts, config); end

  # Finds a command with the given name. If the command belongs to the current
  # class, just return it, otherwise dup it and add the fresh copy to the
  # current command hash.
  #
  # source://thor-1.2.1/lib/thor/base.rb:610
  def find_and_refresh_command(name); end

  # Finds a command with the given name. If the command belongs to the current
  # class, just return it, otherwise dup it and add the fresh copy to the
  # current command hash.
  #
  # source://thor-1.2.1/lib/thor/base.rb:610
  def find_and_refresh_task(name); end

  # Retrieves a value from superclass. If it reaches the baseclass,
  # returns default.
  #
  # source://thor-1.2.1/lib/thor/base.rb:651
  def from_superclass(method, default = T.unsafe(nil)); end

  # Everytime someone inherits from a Thor class, register the klass
  # and file into baseclass.
  #
  # source://thor-1.2.1/lib/thor/base.rb:623
  def inherited(klass); end

  # SIGNATURE: Defines behavior when the initialize method is added to the
  # class.
  #
  # source://thor-1.2.1/lib/thor/base.rb:690
  def initialize_added; end

  # Raises an error if the word given is a Thor reserved word.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/base.rb:579
  def is_thor_reserved_word?(word, type); end

  # Fire this callback whenever a method is added. Added methods are
  # tracked as commands by invoking the create_command method.
  #
  # source://thor-1.2.1/lib/thor/base.rb:631
  def method_added(meth); end

  # Receives a set of options and print them.
  #
  # source://thor-1.2.1/lib/thor/base.rb:557
  def print_options(shell, options, group_name = T.unsafe(nil)); end
end

# source://thor-1.2.1/lib/thor/command.rb:2
class Thor::Command < ::Struct
  # @return [Command] a new instance of Command
  #
  # source://thor-1.2.1/lib/thor/command.rb:5
  def initialize(name, description, long_description, usage, options = T.unsafe(nil)); end

  # Returns the formatted usage by injecting given required arguments
  # and required options into the given usage.
  #
  # source://thor-1.2.1/lib/thor/command.rb:41
  def formatted_usage(klass, namespace = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:14
  def hidden?; end

  # By default, a command invokes a method in the thor class. You can change this
  # implementation to create custom commands.
  #
  # source://thor-1.2.1/lib/thor/command.rb:20
  def run(instance, args = T.unsafe(nil)); end

  protected

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:105
  def handle_argument_error?(instance, error, caller); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:112
  def handle_no_method_error?(instance, error, caller); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:95
  def local_method?(instance, name); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:78
  def not_debugging?(instance); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:91
  def private_method?(instance); end

  # Given a target, checks if this class name is a public method.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:87
  def public_method?(instance); end

  # Add usage with required arguments
  #
  # source://thor-1.2.1/lib/thor/command.rb:68
  def required_arguments_for(klass, usage); end

  # source://thor-1.2.1/lib/thor/command.rb:82
  def required_options; end

  # source://thor-1.2.1/lib/thor/command.rb:100
  def sans_backtrace(backtrace, caller); end

  private

  # source://thor-1.2.1/lib/thor/command.rb:9
  def initialize_copy(other); end
end

# source://thor-1.2.1/lib/thor/command.rb:3
Thor::Command::FILE_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:2
module Thor::CoreExt; end

# A hash with indifferent access and magic predicates.
#
#   hash = Thor::CoreExt::HashWithIndifferentAccess.new 'foo' => 'bar', 'baz' => 'bee', 'force' => true
#
#   hash[:foo]  #=> 'bar'
#   hash['foo'] #=> 'bar'
#   hash.foo?   #=> true
#
# source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:11
class Thor::CoreExt::HashWithIndifferentAccess < ::Hash
  # @return [HashWithIndifferentAccess] a new instance of HashWithIndifferentAccess
  #
  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:12
  def initialize(hash = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:19
  def [](key); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:23
  def []=(key, value); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:27
  def delete(key); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:31
  def except(*keys); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:37
  def fetch(key, *args); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:41
  def key?(key); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:49
  def merge(other); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:53
  def merge!(other); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:68
  def replace(other_hash); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:60
  def reverse_merge(other); end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:64
  def reverse_merge!(other_hash); end

  # Convert to a Hash with String keys.
  #
  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:73
  def to_hash; end

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:45
  def values_at(*indices); end

  protected

  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:79
  def convert_key(key); end

  # Magic predicates. For instance:
  #
  #   options.force?                  # => !!options['force']
  #   options.shebang                 # => "/usr/lib/local/ruby"
  #   options.test_framework?(:rspec) # => options[:test_framework] == :rspec
  #
  # source://thor-1.2.1/lib/thor/core_ext/hash_with_indifferent_access.rb:89
  def method_missing(method, *args); end
end

# source://thor-1.2.1/lib/thor/error.rb:2
Thor::Correctable = DidYouMean::Correctable

# A dynamic command that handles method missing scenarios.
#
# source://thor-1.2.1/lib/thor/command.rb:128
class Thor::DynamicCommand < ::Thor::Command
  # @return [DynamicCommand] a new instance of DynamicCommand
  #
  # source://thor-1.2.1/lib/thor/command.rb:129
  def initialize(name, options = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/command.rb:133
  def run(instance, args = T.unsafe(nil)); end
end

# source://thor-1.2.1/lib/thor/command.rb:141
Thor::DynamicTask = Thor::DynamicCommand

# Thor::Error is raised when it's caused by wrong usage of thor classes. Those
# errors have their backtrace suppressed and are nicely shown to the user.
#
# Errors that are caused by the developer, like declaring a method which
# overwrites a thor keyword, SHOULD NOT raise a Thor::Error. This way, we
# ensure that developer errors are shown with full backtrace.
#
# source://thor-1.2.1/lib/thor/error.rb:23
class Thor::Error < ::StandardError; end

# Thor has a special class called Thor::Group. The main difference to Thor class
# is that it invokes all commands at once. It also include some methods that allows
# invocations to be done at the class method, which are not available to Thor
# commands.
#
# source://thor-1.2.1/lib/thor/group.rb:7
class Thor::Group
  include ::Thor::Base
  include ::Thor::Invocation
  include ::Thor::Shell
  extend ::Thor::Base::ClassMethods
  extend ::Thor::Invocation::ClassMethods

  protected

  # Shortcut to invoke with padding and block handling. Use internally by
  # invoke and invoke_from_option class methods.
  #
  # source://thor-1.2.1/lib/thor/group.rb:265
  def _invoke_for_class_method(klass, command = T.unsafe(nil), *args, &block); end

  class << self
    # Overwrite class options help to allow invoked generators options to be
    # shown recursively when invoking a generator.
    #
    # source://thor-1.2.1/lib/thor/group.rb:161
    def class_options_help(shell, groups = T.unsafe(nil)); end

    # The description for this Thor::Group. If none is provided, but a source root
    # exists, tries to find the USAGE one folder above it, otherwise searches
    # in the superclass.
    #
    # ==== Parameters
    # description<String>:: The description for this Thor::Group.
    #
    # source://thor-1.2.1/lib/thor/group.rb:16
    def desc(description = T.unsafe(nil)); end

    # Get invocations array and merge options from invocations. Those
    # options are added to group_options hash. Options that already exists
    # in base_options are not added twice.
    #
    # source://thor-1.2.1/lib/thor/group.rb:172
    def get_options_from_invocations(group_options, base_options); end

    # @raise [error]
    #
    # source://thor-1.2.1/lib/thor/group.rb:207
    def handle_argument_error(command, error, _args, arity); end

    # Prints help information.
    #
    # ==== Options
    # short:: When true, shows only usage.
    #
    # source://thor-1.2.1/lib/thor/group.rb:29
    def help(shell); end

    # Stores invocation blocks used on invoke_from_option.
    #
    # source://thor-1.2.1/lib/thor/group.rb:45
    def invocation_blocks; end

    # Stores invocations for this class merging with superclass values.
    #
    # source://thor-1.2.1/lib/thor/group.rb:39
    def invocations; end

    # Invoke the given namespace or class given. It adds an instance
    # method that will invoke the klass and command. You can give a block to
    # configure how it will be invoked.
    #
    # The namespace/class given will have its options showed on the help
    # usage. Check invoke_from_option for more information.
    #
    # source://thor-1.2.1/lib/thor/group.rb:56
    def invoke(*names, &block); end

    # Invoke a thor class based on the value supplied by the user to the
    # given option named "name". A class option must be created before this
    # method is invoked for each name given.
    #
    # ==== Examples
    #
    #   class GemGenerator < Thor::Group
    #     class_option :test_framework, :type => :string
    #     invoke_from_option :test_framework
    #   end
    #
    # ==== Boolean options
    #
    # In some cases, you want to invoke a thor class if some option is true or
    # false. This is automatically handled by invoke_from_option. Then the
    # option name is used to invoke the generator.
    #
    # ==== Preparing for invocation
    #
    # In some cases you want to customize how a specified hook is going to be
    # invoked. You can do that by overwriting the class method
    # prepare_for_invocation. The class method must necessarily return a klass
    # and an optional command.
    #
    # ==== Custom invocations
    #
    # You can also supply a block to customize how the option is going to be
    # invoked. The block receives two parameters, an instance of the current
    # class and the klass to be invoked.
    #
    # source://thor-1.2.1/lib/thor/group.rb:110
    def invoke_from_option(*names, &block); end

    # Returns commands ready to be printed.
    #
    # source://thor-1.2.1/lib/thor/group.rb:199
    def printable_commands(*_arg0); end

    # Returns commands ready to be printed.
    #
    # source://thor-1.2.1/lib/thor/group.rb:199
    def printable_tasks(*_arg0); end

    # Remove a previously added invocation.
    #
    # ==== Examples
    #
    #   remove_invocation :test_framework
    #
    # source://thor-1.2.1/lib/thor/group.rb:149
    def remove_invocation(*names); end

    protected

    # The banner for this class. You can customize it if you are invoking the
    # thor class by another ways which is not the Thor::Runner.
    #
    # source://thor-1.2.1/lib/thor/group.rb:238
    def banner; end

    # source://thor-1.2.1/lib/thor/group.rb:248
    def baseclass; end

    # source://thor-1.2.1/lib/thor/group.rb:252
    def create_command(meth); end

    # source://thor-1.2.1/lib/thor/group.rb:252
    def create_task(meth); end

    # The method responsible for dispatching given the args.
    #
    # @yield [instance]
    #
    # source://thor-1.2.1/lib/thor/group.rb:217
    def dispatch(command, given_args, given_opts, config); end

    # Represents the whole class as a command.
    #
    # source://thor-1.2.1/lib/thor/group.rb:243
    def self_command; end

    # Represents the whole class as a command.
    #
    # source://thor-1.2.1/lib/thor/group.rb:243
    def self_task; end
  end
end

# Shortcuts for help.
#
# source://thor-1.2.1/lib/thor/base.rb:17
Thor::HELP_MAPPINGS = T.let(T.unsafe(nil), Array)

# A command that is hidden in help messages but still invocable.
#
# source://thor-1.2.1/lib/thor/command.rb:120
class Thor::HiddenCommand < ::Thor::Command
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/command.rb:121
  def hidden?; end
end

# source://thor-1.2.1/lib/thor/command.rb:125
Thor::HiddenTask = Thor::HiddenCommand

# source://thor-1.2.1/lib/thor/invocation.rb:2
module Thor::Invocation
  mixes_in_class_methods ::Thor::Invocation::ClassMethods

  # Make initializer aware of invocations and the initialization args.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:23
  def initialize(args = T.unsafe(nil), options = T.unsafe(nil), config = T.unsafe(nil), &block); end

  # Make the current command chain accessible with in a Thor-(sub)command
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:30
  def current_command_chain; end

  # Receives a name and invokes it. The name can be a string (either "command" or
  # "namespace:command"), a Thor::Command, a Class or a Thor instance. If the
  # command cannot be guessed by name, it can also be supplied as second argument.
  #
  # You can also supply the arguments, options and configuration values for
  # the command to be invoked, if none is given, the same values used to
  # initialize the invoker are used to initialize the invoked.
  #
  # When no name is given, it will invoke the default command of the current class.
  #
  # ==== Examples
  #
  #   class A < Thor
  #     def foo
  #       invoke :bar
  #       invoke "b:hello", ["Erik"]
  #     end
  #
  #     def bar
  #       invoke "b:hello", ["Erik"]
  #     end
  #   end
  #
  #   class B < Thor
  #     def hello(name)
  #       puts "hello #{name}"
  #     end
  #   end
  #
  # You can notice that the method "foo" above invokes two commands: "bar",
  # which belongs to the same class and "hello" which belongs to the class B.
  #
  # By using an invocation system you ensure that a command is invoked only once.
  # In the example above, invoking "foo" will invoke "b:hello" just once, even
  # if it's invoked later by "bar" method.
  #
  # When class A invokes class B, all arguments used on A initialization are
  # supplied to B. This allows lazy parse of options. Let's suppose you have
  # some rspec commands:
  #
  #   class Rspec < Thor::Group
  #     class_option :mock_framework, :type => :string, :default => :rr
  #
  #     def invoke_mock_framework
  #       invoke "rspec:#{options[:mock_framework]}"
  #     end
  #   end
  #
  # As you noticed, it invokes the given mock framework, which might have its
  # own options:
  #
  #   class Rspec::RR < Thor::Group
  #     class_option :style, :type => :string, :default => :mock
  #   end
  #
  # Since it's not rspec concern to parse mock framework options, when RR
  # is invoked all options are parsed again, so RR can extract only the options
  # that it's going to use.
  #
  # If you want Rspec::RR to be initialized with its own set of options, you
  # have to do that explicitly:
  #
  #   invoke "rspec:rr", [], :style => :foo
  #
  # Besides giving an instance, you can also give a class to invoke:
  #
  #   invoke Rspec::RR, [], :style => :foo
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:102
  def invoke(name = T.unsafe(nil), *args); end

  # Invoke all commands for the current instance.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:133
  def invoke_all; end

  # Invoke the given command if the given args.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:122
  def invoke_command(command, *args); end

  # Invoke the given command if the given args.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:122
  def invoke_task(command, *args); end

  # Invokes using shell padding.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:138
  def invoke_with_padding(*args); end

  protected

  # Initialize klass using values stored in the @_initializer.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:166
  def _parse_initialization_options(args, opts, config); end

  # This method simply retrieves the class and command to be invoked.
  # If the name is nil or the given name is a command in the current class,
  # use the given name and return self as class. Otherwise, call
  # prepare_for_invocation in the current class.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:153
  def _retrieve_class_and_command(name, sent_command = T.unsafe(nil)); end

  # This method simply retrieves the class and command to be invoked.
  # If the name is nil or the given name is a command in the current class,
  # use the given name and return self as class. Otherwise, call
  # prepare_for_invocation in the current class.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:153
  def _retrieve_class_and_task(name, sent_command = T.unsafe(nil)); end

  # Configuration values that are shared between invocations.
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:145
  def _shared_configuration; end

  class << self
    # source://thor-1.2.1/lib/thor/invocation.rb:3
    def included(base); end
  end
end

# source://thor-1.2.1/lib/thor/invocation.rb:8
module Thor::Invocation::ClassMethods
  # This method is responsible for receiving a name and find the proper
  # class and command for it. The key is an optional parameter which is
  # available only in class methods invocations (i.e. in Thor::Group).
  #
  # source://thor-1.2.1/lib/thor/invocation.rb:12
  def prepare_for_invocation(key, name); end
end

# Raised when a command was found, but not invoked properly.
#
# source://thor-1.2.1/lib/thor/error.rb:65
class Thor::InvocationError < ::Thor::Error; end

# source://thor-1.2.1/lib/thor/line_editor/basic.rb:2
module Thor::LineEditor
  class << self
    # source://thor-1.2.1/lib/thor/line_editor.rb:10
    def best_available; end

    # source://thor-1.2.1/lib/thor/line_editor.rb:6
    def readline(prompt, options = T.unsafe(nil)); end
  end
end

# source://thor-1.2.1/lib/thor/line_editor/basic.rb:3
class Thor::LineEditor::Basic
  # @return [Basic] a new instance of Basic
  #
  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:10
  def initialize(prompt, options); end

  # Returns the value of attribute options.
  #
  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:4
  def options; end

  # Returns the value of attribute prompt.
  #
  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:4
  def prompt; end

  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:15
  def readline; end

  private

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:32
  def echo?; end

  # source://thor-1.2.1/lib/thor/line_editor/basic.rb:22
  def get_input; end

  class << self
    # @return [Boolean]
    #
    # source://thor-1.2.1/lib/thor/line_editor/basic.rb:6
    def available?; end
  end
end

# source://thor-1.2.1/lib/thor/line_editor/readline.rb:3
class Thor::LineEditor::Readline < ::Thor::LineEditor::Basic
  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:13
  def readline; end

  private

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:28
  def add_to_history?; end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:42
  def completion_options; end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:32
  def completion_proc; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:46
  def use_path_completion?; end

  class << self
    # @return [Boolean]
    #
    # source://thor-1.2.1/lib/thor/line_editor/readline.rb:4
    def available?; end
  end
end

# source://thor-1.2.1/lib/thor/line_editor/readline.rb:50
class Thor::LineEditor::Readline::PathCompletion
  # @return [PathCompletion] a new instance of PathCompletion
  #
  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:54
  def initialize(text); end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:58
  def matches; end

  private

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:68
  def absolute_matches; end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:82
  def base_path; end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:78
  def glob_pattern; end

  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:64
  def relative_matches; end

  # Returns the value of attribute text.
  #
  # source://thor-1.2.1/lib/thor/line_editor/readline.rb:51
  def text; end
end

# source://thor-1.2.1/lib/thor/error.rb:101
class Thor::MalformattedArgumentError < ::Thor::InvocationError; end

# source://thor-1.2.1/lib/thor/nested_context.rb:2
class Thor::NestedContext
  # @return [NestedContext] a new instance of NestedContext
  #
  # source://thor-1.2.1/lib/thor/nested_context.rb:3
  def initialize; end

  # source://thor-1.2.1/lib/thor/nested_context.rb:7
  def enter; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/nested_context.rb:15
  def entered?; end

  private

  # source://thor-1.2.1/lib/thor/nested_context.rb:25
  def pop; end

  # source://thor-1.2.1/lib/thor/nested_context.rb:21
  def push; end
end

# source://thor-1.2.1/lib/thor/error.rb:8
class Thor::NoKwargSpellChecker < ::DidYouMean::SpellChecker
  # source://thor-1.2.1/lib/thor/error.rb:9
  def initialize(dictionary); end
end

# source://thor-1.2.1/lib/thor/parser/option.rb:2
class Thor::Option < ::Thor::Argument
  # @return [Option] a new instance of Option
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:7
  def initialize(name, options = T.unsafe(nil)); end

  # Returns the value of attribute aliases.
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:3
  def aliases; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:105
  def array?; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:105
  def boolean?; end

  # Returns the value of attribute group.
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:3
  def group; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:105
  def hash?; end

  # Returns the value of attribute hide.
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:3
  def hide; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:79
  def human_name; end

  # Returns the value of attribute lazy_default.
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:3
  def lazy_default; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:105
  def numeric?; end

  # Returns the value of attribute repeatable.
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:3
  def repeatable; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:105
  def string?; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:75
  def switch_name; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:83
  def usage(padding = T.unsafe(nil)); end

  protected

  # source://thor-1.2.1/lib/thor/parser/option.rb:155
  def dasherize(str); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:147
  def dasherized?; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:151
  def undasherize(str); end

  # @raise [ArgumentError]
  #
  # source://thor-1.2.1/lib/thor/parser/option.rb:113
  def validate!; end

  # source://thor-1.2.1/lib/thor/parser/option.rb:118
  def validate_default_type!; end

  class << self
    # This parse quick options given as method_options. It makes several
    # assumptions, but you can be more specific using the option method.
    #
    #   parse :foo => "bar"
    #   #=> Option foo with default value bar
    #
    #   parse [:foo, :baz] => "bar"
    #   #=> Option foo with default value bar and alias :baz
    #
    #   parse :foo => :required
    #   #=> Required option foo without default value
    #
    #   parse :foo => 2
    #   #=> Option foo with default value 2 and type numeric
    #
    #   parse :foo => :numeric
    #   #=> Option foo without default value and type numeric
    #
    #   parse :foo => true
    #   #=> Option foo with default value true and type boolean
    #
    # The valid types are :boolean, :numeric, :hash, :array and :string. If none
    # is given a default type is assumed. This default type accepts arguments as
    # string (--foo=value) or booleans (just --foo).
    #
    # By default all options are optional, unless :required is given.
    #
    # source://thor-1.2.1/lib/thor/parser/option.rb:45
    def parse(key, value); end
  end
end

# source://thor-1.2.1/lib/thor/parser/option.rb:5
Thor::Option::VALID_TYPES = T.let(T.unsafe(nil), Array)

# source://thor-1.2.1/lib/thor/parser/options.rb:2
class Thor::Options < ::Thor::Arguments
  # Takes a hash of Thor::Option and a hash with defaults.
  #
  # If +stop_on_unknown+ is true, #parse will stop as soon as it encounters
  # an unknown option or a regular argument.
  #
  # @return [Options] a new instance of Options
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:32
  def initialize(hash_options = T.unsafe(nil), defaults = T.unsafe(nil), stop_on_unknown = T.unsafe(nil), disable_required_check = T.unsafe(nil)); end

  # @raise [UnknownArgumentError]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:141
  def check_unknown!; end

  # source://thor-1.2.1/lib/thor/parser/options.rb:88
  def parse(args); end

  # source://thor-1.2.1/lib/thor/parser/options.rb:64
  def peek; end

  # source://thor-1.2.1/lib/thor/parser/options.rb:60
  def remaining; end

  # source://thor-1.2.1/lib/thor/parser/options.rb:78
  def shift; end

  # source://thor-1.2.1/lib/thor/parser/options.rb:83
  def unshift(arg, is_value: T.unsafe(nil)); end

  protected

  # source://thor-1.2.1/lib/thor/parser/options.rb:151
  def assign_result!(option, result); end

  # Check if the current value in peek is a registered switch.
  #
  # Two booleans are returned.  The first is true if the current value
  # starts with a hyphen; the second is true if it is a registered switch.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:165
  def current_is_switch?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:177
  def current_is_switch_formatted?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:187
  def current_is_value?; end

  # Check if the given argument is actually a shortcut.
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:206
  def normalize_switch(arg); end

  # Parse boolean values which can be given as --foo=true, --foo or --no-foo.
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:217
  def parse_boolean(switch); end

  # Parse the value at the peek analyzing if it requires an input or not.
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:235
  def parse_peek(switch, option); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:210
  def parsing_options?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/parser/options.rb:192
  def switch?(arg); end

  # source://thor-1.2.1/lib/thor/parser/options.rb:196
  def switch_option(arg); end

  class << self
    # Receives a hash and makes it switches.
    #
    # source://thor-1.2.1/lib/thor/parser/options.rb:11
    def to_switches(options); end
  end
end

# source://thor-1.2.1/lib/thor/parser/options.rb:5
Thor::Options::EQ_RE = T.let(T.unsafe(nil), Regexp)

# source://thor-1.2.1/lib/thor/parser/options.rb:3
Thor::Options::LONG_RE = T.let(T.unsafe(nil), Regexp)

# source://thor-1.2.1/lib/thor/parser/options.rb:8
Thor::Options::OPTS_END = T.let(T.unsafe(nil), String)

# source://thor-1.2.1/lib/thor/parser/options.rb:7
Thor::Options::SHORT_NUM = T.let(T.unsafe(nil), Regexp)

# source://thor-1.2.1/lib/thor/parser/options.rb:4
Thor::Options::SHORT_RE = T.let(T.unsafe(nil), Regexp)

# Allow either -x -v or -xv style for single char args
#
# source://thor-1.2.1/lib/thor/parser/options.rb:6
Thor::Options::SHORT_SQ_RE = T.let(T.unsafe(nil), Regexp)

# Adds a compatibility layer to your Thor classes which allows you to use
# rake package tasks. For example, to use rspec rake tasks, one can do:
#
#   require 'thor/rake_compat'
#   require 'rspec/core/rake_task'
#
#   class Default < Thor
#     include Thor::RakeCompat
#
#     RSpec::Core::RakeTask.new(:spec) do |t|
#       t.spec_opts = ['--options', './.rspec']
#       t.spec_files = FileList['spec/**/*_spec.rb']
#     end
#   end
#
# source://thor-1.2.1/lib/thor/rake_compat.rb:20
module Thor::RakeCompat
  include ::FileUtils::StreamUtils_
  include ::FileUtils
  include ::Rake::FileUtilsExt
  include ::Rake::DSL

  class << self
    # @private
    #
    # source://thor-1.2.1/lib/thor/rake_compat.rb:27
    def included(base); end

    # source://thor-1.2.1/lib/thor/rake_compat.rb:23
    def rake_classes; end
  end
end

# source://thor-1.2.1/lib/thor/error.rb:98
class Thor::RequiredArgumentMissingError < ::Thor::InvocationError; end

# source://thor-1.2.1/lib/thor/util.rb:4
module Thor::Sandbox; end

# source://thor-1.2.1/lib/thor/shell.rb:23
module Thor::Shell
  # Add shell to initialize config values.
  #
  # ==== Configuration
  # shell<Object>:: An instance of the shell to be used.
  #
  # ==== Examples
  #
  #   class MyScript < Thor
  #     argument :first, :type => :numeric
  #   end
  #
  #   MyScript.new [1.0], { :foo => :bar }, :shell => Thor::Shell::Basic.new
  #
  # source://thor-1.2.1/lib/thor/shell.rb:44
  def initialize(args = T.unsafe(nil), options = T.unsafe(nil), config = T.unsafe(nil)); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def ask(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def error(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def file_collision(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def no?(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def print_in_columns(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def print_table(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def print_wrapped(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def say(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def say_error(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def say_status(*args, &block); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def set_color(*args, &block); end

  # Holds the shell for the given Thor instance. If no shell is given,
  # it gets a default shell from Thor::Base.shell.
  #
  # source://thor-1.2.1/lib/thor/shell.rb:52
  def shell; end

  # Sets the attribute shell
  #
  # @param value the value to set the attribute shell to.
  #
  # source://thor-1.2.1/lib/thor/shell.rb:25
  def shell=(_arg0); end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def terminal_width(*args, &block); end

  # Yields the given block with padding.
  #
  # source://thor-1.2.1/lib/thor/shell.rb:66
  def with_padding; end

  # source://thor-1.2.1/lib/thor/shell.rb:59
  def yes?(*args, &block); end

  protected

  # Allow shell to be shared between invocations.
  #
  # source://thor-1.2.1/lib/thor/shell.rb:77
  def _shared_configuration; end
end

# source://thor-1.2.1/lib/thor/shell/basic.rb:3
class Thor::Shell::Basic
  # Initialize base, mute and padding to nil.
  #
  # @return [Basic] a new instance of Basic
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:11
  def initialize; end

  # Asks something to the user and receives a response.
  #
  # If a default value is specified it will be presented to the user
  # and allows them to select that value with an empty response. This
  # option is ignored when limited answers are supplied.
  #
  # If asked to limit the correct responses, you can pass in an
  # array of acceptable answers.  If one of those is not supplied,
  # they will be shown a message stating that one of those answers
  # must be given and re-asked the question.
  #
  # If asking for sensitive information, the :echo option can be set
  # to false to mask user input from $stdin.
  #
  # If the required input is a path, then set the path option to
  # true. This will enable tab completion for file paths relative
  # to the current working directory on systems that support
  # Readline.
  #
  # ==== Example
  # ask("What is your name?")
  #
  # ask("What is the planet furthest from the sun?", :default => "Pluto")
  #
  # ask("What is your favorite Neopolitan flavor?", :limited_to => ["strawberry", "chocolate", "vanilla"])
  #
  # ask("What is your password?", :echo => false)
  #
  # ask("Where should the file be saved?", :path => true)
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:78
  def ask(statement, *args); end

  # Returns the value of attribute base.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:6
  def base; end

  # Sets the attribute base
  #
  # @param value the value to set the attribute base to.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:6
  def base=(_arg0); end

  # Called if something goes wrong during the execution. This is used by Thor
  # internally and should not be used inside your scripts. If something went
  # wrong, you can always raise an exception. If you raise a Thor::Error, it
  # will be rescued and wrapped in the method below.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:342
  def error(statement); end

  # Deals with file collision and returns true if the file should be
  # overwritten and false otherwise. If a block is given, it uses the block
  # response as the content for the diff.
  #
  # ==== Parameters
  # destination<String>:: the destination file to solve conflicts
  # block<Proc>:: an optional block that returns the value to be used in diff and merge
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:285
  def file_collision(destination); end

  # Sets the output padding while executing a block and resets it.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:41
  def indent(count = T.unsafe(nil)); end

  # Mute everything that's inside given block
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:20
  def mute; end

  # Check if base is muted
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:29
  def mute?; end

  # Make a question the to user and returns true if the user replies "n" or
  # "no".
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:154
  def no?(statement, color = T.unsafe(nil)); end

  # Returns the value of attribute padding.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:7
  def padding; end

  # Sets the output padding, not allowing less than zero values.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:35
  def padding=(value); end

  # Prints values in columns
  #
  # ==== Parameters
  # Array[String, String, ...]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:163
  def print_in_columns(array); end

  # Prints a table.
  #
  # ==== Parameters
  # Array[Array[String, String, ...]]
  #
  # ==== Options
  # indent<Integer>:: Indent the first column by indent value.
  # colwidth<Integer>:: Force the first column to colwidth spaces wide.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:185
  def print_table(array, options = T.unsafe(nil)); end

  # Prints a long string, word-wrapping the text to the current width of the
  # terminal display. Ideal for printing heredocs.
  #
  # ==== Parameters
  # String
  #
  # ==== Options
  # indent<Integer>:: Indent each line of the printed paragraph by indent value.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:247
  def print_wrapped(message, options = T.unsafe(nil)); end

  # Say (print) something to the user. If the sentence ends with a whitespace
  # or tab character, a new line is not appended (print + flush). Otherwise
  # are passed straight to puts (behavior got from Highline).
  #
  # ==== Example
  # say("I know you knew that.")
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:96
  def say(message = T.unsafe(nil), color = T.unsafe(nil), force_new_line = T.unsafe(nil)); end

  # Say (print) an error to the user. If the sentence ends with a whitespace
  # or tab character, a new line is not appended (print + flush). Otherwise
  # are passed straight to puts (behavior got from Highline).
  #
  # ==== Example
  # say_error("error: something went wrong")
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:113
  def say_error(message = T.unsafe(nil), color = T.unsafe(nil), force_new_line = T.unsafe(nil)); end

  # Say a status with the given color and appends the message. Since this
  # method is used frequently by actions, it allows nil or false to be given
  # in log_status, avoiding the message from being shown. If a Symbol is
  # given in log_status, it's used as the color.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:128
  def say_status(status, message, log_status = T.unsafe(nil)); end

  # Apply color to the given string with optional bold. Disabled in the
  # Thor::Shell::Basic class.
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:349
  def set_color(string, *_arg1); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:326
  def terminal_width; end

  # Make a question the to user and returns true if the user replies "y" or
  # "yes".
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:147
  def yes?(statement, color = T.unsafe(nil)); end

  protected

  # source://thor-1.2.1/lib/thor/shell/basic.rb:486
  def answer_match(possibilities, answer, case_insensitive); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:443
  def as_unicode; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:473
  def ask_filtered(statement, color, options); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:456
  def ask_simply(statement, color, options); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:360
  def can_display_colors?; end

  # Calculate the dynamic width of the terminal
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:415
  def dynamic_width; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:419
  def dynamic_width_stty; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:423
  def dynamic_width_tput; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:387
  def file_collision_help; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:507
  def git_merge_tool; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:377
  def is?(value); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:364
  def lookup_color(color); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:494
  def merge(destination, content); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:503
  def merge_tool; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:355
  def prepare_message(message, *color); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:410
  def quiet?; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:399
  def show_diff(destination, content); end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:373
  def stderr; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:369
  def stdout; end

  # source://thor-1.2.1/lib/thor/shell/basic.rb:431
  def truncate(string, width); end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/basic.rb:427
  def unix?; end
end

# source://thor-1.2.1/lib/thor/shell/basic.rb:4
Thor::Shell::Basic::DEFAULT_TERMINAL_WIDTH = T.let(T.unsafe(nil), Integer)

# Inherit from Thor::Shell::Basic and add set_color behavior. Check
# Thor::Shell::Basic to see all available methods.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:9
class Thor::Shell::Color < ::Thor::Shell::Basic
  # Set color by using a string or one of the defined constants. If a third
  # option is set to true, it also adds bold to the string. This is based
  # on Highline implementation and it automatically appends CLEAR to the end
  # of the returned String.
  #
  # Pass foreground, background and bold options to this method as
  # symbols.
  #
  # Example:
  #
  #   set_color "Hi!", :red, :on_white, :bold
  #
  # The available colors are:
  #
  #   :bold
  #   :black
  #   :red
  #   :green
  #   :yellow
  #   :blue
  #   :magenta
  #   :cyan
  #   :white
  #   :on_black
  #   :on_red
  #   :on_green
  #   :on_yellow
  #   :on_blue
  #   :on_magenta
  #   :on_cyan
  #   :on_white
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:79
  def set_color(string, *colors); end

  protected

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:107
  def are_colors_disabled?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:103
  def are_colors_supported?; end

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:99
  def can_display_colors?; end

  # Check if Diff::LCS is loaded. If it is, use it to create pretty output
  # for diff.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:144
  def diff_lcs_loaded?; end

  # source://thor-1.2.1/lib/thor/shell/color.rb:127
  def output_diff_line(diff); end

  # Overwrite show_diff to show diff with colors if Diff::LCS is
  # available.
  #
  # source://thor-1.2.1/lib/thor/shell/color.rb:114
  def show_diff(destination, content); end
end

# Set the terminal's foreground ANSI color to black.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:15
Thor::Shell::Color::BLACK = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to blue.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:23
Thor::Shell::Color::BLUE = T.let(T.unsafe(nil), String)

# The start of an ANSI bold sequence.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:12
Thor::Shell::Color::BOLD = T.let(T.unsafe(nil), String)

# Embed in a String to clear all previous ANSI sequences.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:10
Thor::Shell::Color::CLEAR = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to cyan.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:27
Thor::Shell::Color::CYAN = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to green.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:19
Thor::Shell::Color::GREEN = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to magenta.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:25
Thor::Shell::Color::MAGENTA = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to black.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:32
Thor::Shell::Color::ON_BLACK = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to blue.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:40
Thor::Shell::Color::ON_BLUE = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to cyan.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:44
Thor::Shell::Color::ON_CYAN = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to green.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:36
Thor::Shell::Color::ON_GREEN = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to magenta.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:42
Thor::Shell::Color::ON_MAGENTA = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to red.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:34
Thor::Shell::Color::ON_RED = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to white.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:46
Thor::Shell::Color::ON_WHITE = T.let(T.unsafe(nil), String)

# Set the terminal's background ANSI color to yellow.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:38
Thor::Shell::Color::ON_YELLOW = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to red.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:17
Thor::Shell::Color::RED = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to white.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:29
Thor::Shell::Color::WHITE = T.let(T.unsafe(nil), String)

# Set the terminal's foreground ANSI color to yellow.
#
# source://thor-1.2.1/lib/thor/shell/color.rb:21
Thor::Shell::Color::YELLOW = T.let(T.unsafe(nil), String)

# Inherit from Thor::Shell::Basic and add set_color behavior. Check
# Thor::Shell::Basic to see all available methods.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:9
class Thor::Shell::HTML < ::Thor::Shell::Basic
  # Ask something to the user and receives a response.
  #
  # ==== Example
  # ask("What is your name?")
  #
  # TODO: Implement #ask for Thor::Shell::HTML
  #
  # @raise [NotImplementedError]
  #
  # source://thor-1.2.1/lib/thor/shell/html.rb:70
  def ask(statement, color = T.unsafe(nil)); end

  # Set color by using a string or one of the defined constants. If a third
  # option is set to true, it also adds bold to the string. This is based
  # on Highline implementation and it automatically appends CLEAR to the end
  # of the returned String.
  #
  # source://thor-1.2.1/lib/thor/shell/html.rb:51
  def set_color(string, *colors); end

  protected

  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/html.rb:76
  def can_display_colors?; end

  # Check if Diff::LCS is loaded. If it is, use it to create pretty output
  # for diff.
  #
  # @return [Boolean]
  #
  # source://thor-1.2.1/lib/thor/shell/html.rb:113
  def diff_lcs_loaded?; end

  # source://thor-1.2.1/lib/thor/shell/html.rb:96
  def output_diff_line(diff); end

  # Overwrite show_diff to show diff with colors if Diff::LCS is
  # available.
  #
  # source://thor-1.2.1/lib/thor/shell/html.rb:83
  def show_diff(destination, content); end
end

# Set the terminal's foreground HTML color to black.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:13
Thor::Shell::HTML::BLACK = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to blue.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:21
Thor::Shell::HTML::BLUE = T.let(T.unsafe(nil), String)

# The start of an HTML bold sequence.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:10
Thor::Shell::HTML::BOLD = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to cyan.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:25
Thor::Shell::HTML::CYAN = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to green.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:17
Thor::Shell::HTML::GREEN = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to magenta.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:23
Thor::Shell::HTML::MAGENTA = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to black.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:30
Thor::Shell::HTML::ON_BLACK = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to blue.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:38
Thor::Shell::HTML::ON_BLUE = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to cyan.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:42
Thor::Shell::HTML::ON_CYAN = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to green.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:34
Thor::Shell::HTML::ON_GREEN = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to magenta.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:40
Thor::Shell::HTML::ON_MAGENTA = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to red.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:32
Thor::Shell::HTML::ON_RED = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to white.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:44
Thor::Shell::HTML::ON_WHITE = T.let(T.unsafe(nil), String)

# Set the terminal's background HTML color to yellow.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:36
Thor::Shell::HTML::ON_YELLOW = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to red.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:15
Thor::Shell::HTML::RED = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to white.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:27
Thor::Shell::HTML::WHITE = T.let(T.unsafe(nil), String)

# Set the terminal's foreground HTML color to yellow.
#
# source://thor-1.2.1/lib/thor/shell/html.rb:19
Thor::Shell::HTML::YELLOW = T.let(T.unsafe(nil), String)

# source://thor-1.2.1/lib/thor/shell.rb:24
Thor::Shell::SHELL_DELEGATED_METHODS = T.let(T.unsafe(nil), Array)

# source://thor-1.2.1/lib/thor/base.rb:23
Thor::TEMPLATE_EXTNAME = T.let(T.unsafe(nil), String)

# Thor methods that should not be overwritten by the user.
#
# source://thor-1.2.1/lib/thor/base.rb:20
Thor::THOR_RESERVED_WORDS = T.let(T.unsafe(nil), Array)

# source://thor-1.2.1/lib/thor/command.rb:117
Thor::Task = Thor::Command

# Raised when a command was not found.
#
# source://thor-1.2.1/lib/thor/error.rb:27
class Thor::UndefinedCommandError < ::Thor::Error
  include ::DidYouMean::Correctable

  # @return [UndefinedCommandError] a new instance of UndefinedCommandError
  #
  # source://thor-1.2.1/lib/thor/error.rb:46
  def initialize(command, all_commands, namespace); end

  # Returns the value of attribute all_commands.
  #
  # source://thor-1.2.1/lib/thor/error.rb:44
  def all_commands; end

  # Returns the value of attribute command.
  #
  # source://thor-1.2.1/lib/thor/error.rb:44
  def command; end
end

# source://thor-1.2.1/lib/thor/error.rb:28
class Thor::UndefinedCommandError::SpellChecker
  # @return [SpellChecker] a new instance of SpellChecker
  #
  # source://thor-1.2.1/lib/thor/error.rb:31
  def initialize(error); end

  # source://thor-1.2.1/lib/thor/error.rb:35
  def corrections; end

  # Returns the value of attribute error.
  #
  # source://thor-1.2.1/lib/thor/error.rb:29
  def error; end

  # source://thor-1.2.1/lib/thor/error.rb:39
  def spell_checker; end
end

# source://thor-1.2.1/lib/thor/error.rb:58
Thor::UndefinedTaskError = Thor::UndefinedCommandError

# source://thor-1.2.1/lib/thor/error.rb:68
class Thor::UnknownArgumentError < ::Thor::Error
  include ::DidYouMean::Correctable

  # @return [UnknownArgumentError] a new instance of UnknownArgumentError
  #
  # source://thor-1.2.1/lib/thor/error.rb:88
  def initialize(switches, unknown); end

  # Returns the value of attribute switches.
  #
  # source://thor-1.2.1/lib/thor/error.rb:86
  def switches; end

  # Returns the value of attribute unknown.
  #
  # source://thor-1.2.1/lib/thor/error.rb:86
  def unknown; end
end

# source://thor-1.2.1/lib/thor/error.rb:69
class Thor::UnknownArgumentError::SpellChecker
  # @return [SpellChecker] a new instance of SpellChecker
  #
  # source://thor-1.2.1/lib/thor/error.rb:72
  def initialize(error); end

  # source://thor-1.2.1/lib/thor/error.rb:76
  def corrections; end

  # Returns the value of attribute error.
  #
  # source://thor-1.2.1/lib/thor/error.rb:70
  def error; end

  # source://thor-1.2.1/lib/thor/error.rb:81
  def spell_checker; end
end

# This module holds several utilities:
#
# 1) Methods to convert thor namespaces to constants and vice-versa.
#
#   Thor::Util.namespace_from_thor_class(Foo::Bar::Baz) #=> "foo:bar:baz"
#
# 2) Loading thor files and sandboxing:
#
#   Thor::Util.load_thorfile("~/.thor/foo")
#
# source://thor-1.2.1/lib/thor/util.rb:17
module Thor::Util
  class << self
    # Receives a string and convert it to camel case. camel_case returns CamelCase.
    #
    # ==== Parameters
    # String
    #
    # ==== Returns
    # String
    #
    # source://thor-1.2.1/lib/thor/util.rb:104
    def camel_case(str); end

    # Returns a string that has had any glob characters escaped.
    # The glob characters are `* ? { } [ ]`.
    #
    # ==== Examples
    #
    #   Thor::Util.escape_globs('[apps]')   # => '\[apps\]'
    #
    # ==== Parameters
    # String
    #
    # ==== Returns
    # String
    #
    # source://thor-1.2.1/lib/thor/util.rb:263
    def escape_globs(path); end

    # Returns a string that has had any HTML characters escaped.
    #
    # ==== Examples
    #
    #   Thor::Util.escape_html('<div>')   # => "&lt;div&gt;"
    #
    # ==== Parameters
    # String
    #
    # ==== Returns
    # String
    #
    # source://thor-1.2.1/lib/thor/util.rb:279
    def escape_html(string); end

    # Receives a namespace and search for it in the Thor::Base subclasses.
    #
    # ==== Parameters
    # namespace<String>:: The namespace to search for.
    #
    # source://thor-1.2.1/lib/thor/util.rb:24
    def find_by_namespace(namespace); end

    # Receives a namespace and tries to retrieve a Thor or Thor::Group class
    # from it. It first searches for a class using the all the given namespace,
    # if it's not found, removes the highest entry and searches for the class
    # again. If found, returns the highest entry as the class name.
    #
    # ==== Examples
    #
    #   class Foo::Bar < Thor
    #     def baz
    #     end
    #   end
    #
    #   class Baz::Foo < Thor::Group
    #   end
    #
    #   Thor::Util.namespace_to_thor_class("foo:bar")     #=> Foo::Bar, nil # will invoke default command
    #   Thor::Util.namespace_to_thor_class("baz:foo")     #=> Baz::Foo, nil
    #   Thor::Util.namespace_to_thor_class("foo:bar:baz") #=> Foo::Bar, "baz"
    #
    # ==== Parameters
    # namespace<String>
    #
    # source://thor-1.2.1/lib/thor/util.rb:131
    def find_class_and_command_by_namespace(namespace, fallback = T.unsafe(nil)); end

    # Receives a namespace and tries to retrieve a Thor or Thor::Group class
    # from it. It first searches for a class using the all the given namespace,
    # if it's not found, removes the highest entry and searches for the class
    # again. If found, returns the highest entry as the class name.
    #
    # ==== Examples
    #
    #   class Foo::Bar < Thor
    #     def baz
    #     end
    #   end
    #
    #   class Baz::Foo < Thor::Group
    #   end
    #
    #   Thor::Util.namespace_to_thor_class("foo:bar")     #=> Foo::Bar, nil # will invoke default command
    #   Thor::Util.namespace_to_thor_class("baz:foo")     #=> Baz::Foo, nil
    #   Thor::Util.namespace_to_thor_class("foo:bar:baz") #=> Foo::Bar, "baz"
    #
    # ==== Parameters
    # namespace<String>
    #
    # source://thor-1.2.1/lib/thor/util.rb:131
    def find_class_and_task_by_namespace(namespace, fallback = T.unsafe(nil)); end

    # Where to look for Thor files.
    #
    # source://thor-1.2.1/lib/thor/util.rb:212
    def globs_for(path); end

    # Receives a path and load the thor file in the path. The file is evaluated
    # inside the sandbox to avoid namespacing conflicts.
    #
    # source://thor-1.2.1/lib/thor/util.rb:152
    def load_thorfile(path, content = T.unsafe(nil), debug = T.unsafe(nil)); end

    # Receives a constant and converts it to a Thor namespace. Since Thor
    # commands can be added to a sandbox, this method is also responsible for
    # removing the sandbox namespace.
    #
    # This method should not be used in general because it's used to deal with
    # older versions of Thor. On current versions, if you need to get the
    # namespace from a class, just call namespace on it.
    #
    # ==== Parameters
    # constant<Object>:: The constant to be converted to the thor path.
    #
    # ==== Returns
    # String:: If we receive Foo::Bar::Baz it returns "foo:bar:baz"
    #
    # source://thor-1.2.1/lib/thor/util.rb:43
    def namespace_from_thor_class(constant); end

    # Given the contents, evaluate it inside the sandbox and returns the
    # namespaces defined in the sandbox.
    #
    # ==== Parameters
    # contents<String>
    #
    # ==== Returns
    # Array[Object]
    #
    # source://thor-1.2.1/lib/thor/util.rb:58
    def namespaces_in_content(contents, file = T.unsafe(nil)); end

    # Return the path to the ruby interpreter taking into account multiple
    # installations and windows extensions.
    #
    # source://thor-1.2.1/lib/thor/util.rb:220
    def ruby_command; end

    # Receives a string and convert it to snake case. SnakeCase returns snake_case.
    #
    # ==== Parameters
    # String
    #
    # ==== Returns
    # String
    #
    # source://thor-1.2.1/lib/thor/util.rb:90
    def snake_case(str); end

    # Returns the thor classes declared inside the given class.
    #
    # source://thor-1.2.1/lib/thor/util.rb:74
    def thor_classes_in(klass); end

    # Returns the root where thor files are located, depending on the OS.
    #
    # source://thor-1.2.1/lib/thor/util.rb:191
    def thor_root; end

    # Returns the files in the thor root. On Windows thor_root will be something
    # like this:
    #
    #   C:\Documents and Settings\james\.thor
    #
    # If we don't #gsub the \ character, Dir.glob will fail.
    #
    # source://thor-1.2.1/lib/thor/util.rb:202
    def thor_root_glob; end

    # source://thor-1.2.1/lib/thor/util.rb:167
    def user_home; end
  end
end
