# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `tapioca` gem.
# Please instead update this file by running `bin/tapioca gem tapioca`.

class Bundler::Dependency < ::Gem::Dependency
  include ::Tapioca::Gemfile::AutoRequireHook
end

# We need to do the alias-method-chain dance since Bootsnap does the same,
# and prepended modules and alias-method-chain don't play well together.
#
# So, why does Bootsnap do alias-method-chain and not prepend? Glad you asked!
# That's because RubyGems does alias-method-chain for Kernel#require and such,
# so, if Bootsnap were to do prepend, it might end up breaking RubyGems.
class Module
  def append_features(constant); end
  def autoload(const_name, path); end
  def extend_object(obj); end
  def prepend_features(constant); end
end

Module::DELEGATION_RESERVED_KEYWORDS = T.let(T.unsafe(nil), Array)
Module::DELEGATION_RESERVED_METHOD_NAMES = T.let(T.unsafe(nil), Set)
Module::RUBY_RESERVED_KEYWORDS = T.let(T.unsafe(nil), Array)
module RBI; end

class RBI::Tree < ::RBI::NodeWithComments
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)
    ).returns(::RBI::Scope)
  end
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  sig { params(name: ::String, value: ::String).void }
  def create_constant(name, value:); end

  sig { params(name: ::String).void }
  def create_extend(name); end

  sig { params(name: ::String).void }
  def create_include(name); end

  sig do
    params(
      name: ::String,
      parameters: T::Array[::RBI::TypedParam],
      return_type: ::String,
      class_method: T::Boolean,
      visibility: ::RBI::Visibility
    ).void
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil)); end

  sig { params(name: ::String).void }
  def create_mixes_in_class_methods(name); end

  sig { params(name: ::String, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_module(name, &block); end

  sig { params(constant: ::Module, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).void }
  def create_path(constant, &block); end

  sig do
    params(
      name: ::String,
      type: ::String,
      variance: ::Symbol,
      fixed: T.nilable(::String),
      upper: T.nilable(::String),
      lower: T.nilable(::String)
    ).void
  end
  def create_type_variable(name, type:, variance: T.unsafe(nil), fixed: T.unsafe(nil), upper: T.unsafe(nil), lower: T.unsafe(nil)); end

  sig { params(annotation: ::String).void }
  def deannotate!(annotation); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { void }
  def group_nodes!; end

  sig { returns(::RBI::Index) }
  def index; end

  sig do
    params(
      other: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).returns(::RBI::MergeTree)
  end
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  sig { void }
  def nest_non_public_methods!; end

  sig { void }
  def nest_singleton_methods!; end

  sig { returns(T::Array[::RBI::Node]) }
  def nodes; end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { void }
  def sort_nodes!; end

  private

  sig { params(node: ::RBI::Node).returns(::RBI::Node) }
  def create_node(node); end

  sig { returns(T::Hash[::String, ::RBI::Node]) }
  def nodes_cache; end
end

class RBI::TypedParam < ::T::Struct
  const :param, ::RBI::Param
  const :type, ::String

  class << self
    def inherited(s); end
  end
end

RBI::VERSION = T.let(T.unsafe(nil), String)

module T::Generic
  def [](*types); end
  def type_member(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
  def type_template(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
end

# This module intercepts calls to generic type instantiations and type variable definitions.
# Tapioca stores the data from those calls in a `GenericTypeRegistry` which can then be used
# to look up the original call details when we are trying to do code generation.
#
# We are interested in the data of the `[]`, `type_member` and `type_template` calls which
# are all needed to generate good generic information at runtime.
module T::Generic::TypeStoragePatch
  def [](*types); end
  def type_member(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
  def type_template(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
end

class T::Types::Simple < ::T::Types::Base
  def name; end
end

module T::Types::Simple::GenericPatch
  # This method intercepts calls to the `name` method for simple types, so that
  # it can ask the name to the type if the type is generic, since, by this point,
  # we've created a clone of that type with the `name` method returning the
  # appropriate name for that specific concrete type.
  def name; end
end

module T::Types::Simple::NamePatch
  def name; end
end

module T::Utils
  class << self
    def coerce(val); end
  end
end

module T::Utils::CoercePatch
  def coerce(val); end
end

module Tapioca
  class << self
    sig do
      type_parameters(:Result)
        .params(
          blk: T.proc.returns(T.type_parameter(:Result))
        ).returns(T.type_parameter(:Result))
    end
    def silence_warnings(&blk); end
  end
end

Tapioca::BINARY_FILE = T.let(T.unsafe(nil), String)
Tapioca::CENTRAL_REPO_ANNOTATIONS_DIR = T.let(T.unsafe(nil), String)
Tapioca::CENTRAL_REPO_INDEX_PATH = T.let(T.unsafe(nil), String)
Tapioca::CENTRAL_REPO_ROOT_URI = T.let(T.unsafe(nil), String)

class Tapioca::Cli < ::Thor
  include ::Tapioca::CliHelper
  include ::Tapioca::ConfigHelper
  include ::Tapioca::EnvHelper

  def __print_version; end
  def annotations; end
  def check_shims; end
  def configure; end
  def dsl(*constants); end
  def gem(*gems); end
  def init; end
  def require; end
  def todo; end

  private

  def print_init_next_steps; end

  class << self
    def exit_on_failure?; end
  end
end

Tapioca::Cli::FILE_HEADER_OPTION_DESC = T.let(T.unsafe(nil), String)

module Tapioca::CliHelper
  requires_ancestor { Thor::Shell }

  sig { params(options: T::Hash[::Symbol, T.untyped]).returns(T.nilable(::String)) }
  def netrc_file(options); end

  sig { params(options: T::Hash[::Symbol, T.untyped]).returns(::Tapioca::RBIFormatter) }
  def rbi_formatter(options); end

  sig { params(message: ::String, color: T.any(::Symbol, T::Array[::Symbol])).void }
  def say_error(message = T.unsafe(nil), *color); end
end

module Tapioca::Commands; end

class Tapioca::Commands::Annotations < ::Tapioca::Commands::Command
  sig do
    params(
      central_repo_root_uris: T::Array[::String],
      auth: T.nilable(::String),
      netrc_file: T.nilable(::String),
      central_repo_index_path: ::String,
      typed_overrides: T::Hash[::String, ::String]
    ).void
  end
  def initialize(central_repo_root_uris:, auth: T.unsafe(nil), netrc_file: T.unsafe(nil), central_repo_index_path: T.unsafe(nil), typed_overrides: T.unsafe(nil)); end

  sig { override.void }
  def execute; end

  private

  sig { params(name: ::String, content: ::String).returns(::String) }
  def add_header(name, content); end

  sig { params(name: ::String, content: ::String).returns(::String) }
  def apply_typed_override(name, content); end

  sig { params(repo_uris: T::Array[::String], gem_name: ::String).void }
  def fetch_annotation(repo_uris, gem_name); end

  sig { params(gem_names: T::Array[::String]).returns(T::Array[::String]) }
  def fetch_annotations(gem_names); end

  sig { params(repo_uri: ::String, path: ::String).returns(T.nilable(::String)) }
  def fetch_file(repo_uri, path); end

  sig { params(repo_uri: ::String, path: ::String).returns(T.nilable(::String)) }
  def fetch_http_file(repo_uri, path); end

  sig { params(repo_uri: ::String, repo_number: T.nilable(::Integer)).returns(T.nilable(Tapioca::RepoIndex)) }
  def fetch_index(repo_uri, repo_number:); end

  sig { returns(T::Hash[::String, Tapioca::RepoIndex]) }
  def fetch_indexes; end

  sig { params(repo_uri: ::String, path: ::String).returns(T.nilable(::String)) }
  def fetch_local_file(repo_uri, path); end

  sig { returns(T::Array[::String]) }
  def list_gemfile_gems; end

  sig { params(gem_name: ::String, contents: T::Array[::String]).returns(T.nilable(::String)) }
  def merge_files(gem_name, contents); end

  sig { params(project_gems: T::Array[::String]).void }
  def remove_expired_annotations(project_gems); end

  sig { returns(T::Hash[::String, T.nilable(::String)]) }
  def repo_tokens; end

  sig { params(path: ::String, repo_uri: ::String, message: ::String).void }
  def say_http_error(path, repo_uri, message:); end

  sig { params(repo_uri: ::String).returns(T.nilable(::String)) }
  def token_for(repo_uri); end
end

class Tapioca::Commands::CheckShims < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIFilesHelper

  sig do
    params(
      gem_rbi_dir: ::String,
      dsl_rbi_dir: ::String,
      annotations_rbi_dir: ::String,
      shim_rbi_dir: ::String,
      todo_rbi_file: ::String,
      payload: T::Boolean
    ).void
  end
  def initialize(gem_rbi_dir:, dsl_rbi_dir:, annotations_rbi_dir:, shim_rbi_dir:, todo_rbi_file:, payload:); end

  sig { override.void }
  def execute; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Tapioca::Commands::Command
  include ::Thor::Base
  include ::Thor::Invocation
  include ::Thor::Shell
  include ::Tapioca::CliHelper
  extend ::Thor::Base::ClassMethods
  extend ::Thor::Invocation::ClassMethods

  abstract!

  sig { void }
  def initialize; end

  # @abstract
  sig { abstract.void }
  def execute; end

  sig { returns(::Thor::Actions) }
  def file_writer; end

  private

  sig do
    params(
      path: T.any(::Pathname, ::String),
      content: ::String,
      force: T::Boolean,
      skip: T::Boolean,
      verbose: T::Boolean
    ).void
  end
  def create_file(path, content, force: T.unsafe(nil), skip: T.unsafe(nil), verbose: T.unsafe(nil)); end

  sig { params(command: ::Symbol, args: ::String).returns(::String) }
  def default_command(command, *args); end

  sig { params(path: T.any(::Pathname, ::String), verbose: T::Boolean).void }
  def remove_file(path, verbose: T.unsafe(nil)); end
end

class Tapioca::Commands::Command::FileWriter < ::Thor
  include ::Thor::Actions
  extend ::Thor::Actions::ClassMethods
end

class Tapioca::Commands::Configure < ::Tapioca::Commands::Command
  sig { params(sorbet_config: ::String, tapioca_config: ::String, default_postrequire: ::String).void }
  def initialize(sorbet_config:, tapioca_config:, default_postrequire:); end

  sig { override.void }
  def execute; end

  private

  sig { void }
  def create_binstub; end

  sig { void }
  def create_post_require; end

  sig { void }
  def create_sorbet_config; end

  sig { void }
  def create_tapioca_config; end

  sig { returns(::Bundler::Installer) }
  def installer; end

  sig { returns(::Bundler::StubSpecification) }
  def spec; end
end

class Tapioca::Commands::Dsl < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIFilesHelper

  sig do
    params(
      requested_constants: T::Array[::String],
      outpath: ::Pathname,
      only: T::Array[::String],
      exclude: T::Array[::String],
      file_header: T::Boolean,
      compiler_path: ::String,
      tapioca_path: ::String,
      should_verify: T::Boolean,
      quiet: T::Boolean,
      verbose: T::Boolean,
      number_of_workers: T.nilable(::Integer),
      auto_strictness: T::Boolean,
      gem_dir: ::String,
      rbi_formatter: ::Tapioca::RBIFormatter
    ).void
  end
  def initialize(requested_constants:, outpath:, only:, exclude:, file_header:, compiler_path:, tapioca_path:, should_verify: T.unsafe(nil), quiet: T.unsafe(nil), verbose: T.unsafe(nil), number_of_workers: T.unsafe(nil), auto_strictness: T.unsafe(nil), gem_dir: T.unsafe(nil), rbi_formatter: T.unsafe(nil)); end

  sig { override.void }
  def execute; end

  private

  sig { void }
  def abort_if_pending_migrations!; end

  sig { params(cause: ::Symbol, files: T::Array[::String]).returns(::String) }
  def build_error_for_files(cause, files); end

  sig do
    params(
      constant_name: ::String,
      rbi: ::RBI::File,
      outpath: ::Pathname,
      quiet: T::Boolean
    ).returns(T.nilable(::Pathname))
  end
  def compile_dsl_rbi(constant_name, rbi, outpath: T.unsafe(nil), quiet: T.unsafe(nil)); end

  sig { params(constant_names: T::Array[::String]).returns(T::Array[::Module]) }
  def constantize(constant_names); end

  sig { params(compiler_names: T::Array[::String]).returns(T::Array[T.class_of(Tapioca::Dsl::Compiler)]) }
  def constantize_compilers(compiler_names); end

  sig { params(constant_name: ::String).returns(::Pathname) }
  def dsl_rbi_filename(constant_name); end

  sig { params(requested_constants: T::Array[::String], path: ::Pathname).returns(T::Set[::Pathname]) }
  def existing_rbi_filenames(requested_constants, path: T.unsafe(nil)); end

  sig { params(constant: ::String).returns(::String) }
  def generate_command_for(constant); end

  sig { params(eager_load: T::Boolean).void }
  def load_application(eager_load:); end

  sig { void }
  def load_dsl_compilers; end

  sig { void }
  def load_dsl_extensions; end

  sig { returns(::Tapioca::Runtime::Loader) }
  def loader; end

  sig { params(dir: ::Pathname).void }
  def perform_dsl_verification(dir); end

  sig { params(files: T::Set[::Pathname]).void }
  def purge_stale_dsl_rbi_files(files); end

  sig { params(constant: ::String).returns(::String) }
  def rbi_filename_for(constant); end

  sig { params(path: ::Pathname).returns(T::Array[::Pathname]) }
  def rbi_files_in(path); end

  sig { params(diff: T::Hash[::String, ::Symbol], command: ::Symbol).void }
  def report_diff_and_exit_if_out_of_date(diff, command); end

  sig { params(name: ::String).returns(T.nilable(T.class_of(Tapioca::Dsl::Compiler))) }
  def resolve(name); end

  sig { params(class_name: ::String).returns(::String) }
  def underscore(class_name); end

  sig { params(tmp_dir: ::Pathname).returns(T::Hash[::String, ::Symbol]) }
  def verify_dsl_rbi(tmp_dir:); end
end

class Tapioca::Commands::Gem < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIFilesHelper

  sig do
    params(
      gem_names: T::Array[::String],
      exclude: T::Array[::String],
      prerequire: T.nilable(::String),
      postrequire: ::String,
      typed_overrides: T::Hash[::String, ::String],
      outpath: ::Pathname,
      file_header: T::Boolean,
      include_doc: T::Boolean,
      include_exported_rbis: T::Boolean,
      number_of_workers: T.nilable(::Integer),
      auto_strictness: T::Boolean,
      dsl_dir: ::String,
      rbi_formatter: ::Tapioca::RBIFormatter
    ).void
  end
  def initialize(gem_names:, exclude:, prerequire:, postrequire:, typed_overrides:, outpath:, file_header:, include_doc:, include_exported_rbis:, number_of_workers: T.unsafe(nil), auto_strictness: T.unsafe(nil), dsl_dir: T.unsafe(nil), rbi_formatter: T.unsafe(nil)); end

  sig { override.void }
  def execute; end

  sig { params(should_verify: T::Boolean).void }
  def sync(should_verify: T.unsafe(nil)); end

  private

  sig { returns(T::Array[::String]) }
  def added_rbis; end

  sig { params(cause: ::Symbol, files: T::Array[::String]).returns(::String) }
  def build_error_for_files(cause, files); end

  sig { returns(::Tapioca::Gemfile) }
  def bundle; end

  sig { params(gem: ::Tapioca::Gemfile::GemSpec).void }
  def compile_gem_rbi(gem); end

  sig { params(gem_name: ::String).returns(::Pathname) }
  def existing_rbi(gem_name); end

  sig { returns(T::Hash[::String, ::String]) }
  def existing_rbis; end

  sig { params(gem_name: ::String).returns(::Pathname) }
  def expected_rbi(gem_name); end

  sig { returns(T::Hash[::String, ::String]) }
  def expected_rbis; end

  sig { params(file: ::String, error: ::LoadError).void }
  def explain_failed_require(file, error); end

  sig { params(gem_name: ::String).returns(T::Boolean) }
  def gem_rbi_exists?(gem_name); end

  sig { params(gem_name: ::String, version: ::String).returns(::Pathname) }
  def gem_rbi_filename(gem_name, version); end

  sig { params(gem_names: T::Array[::String]).returns(T::Array[::Tapioca::Gemfile::GemSpec]) }
  def gems_to_generate(gem_names); end

  sig { returns(::Tapioca::Runtime::Loader) }
  def loader; end

  sig { params(gem: ::Tapioca::Gemfile::GemSpec, file: ::RBI::File).void }
  def merge_with_exported_rbi(gem, file); end

  sig { params(old_filename: ::Pathname, new_filename: ::Pathname).void }
  def move(old_filename, new_filename); end

  sig { void }
  def perform_additions; end

  sig { void }
  def perform_removals; end

  sig { void }
  def perform_sync_verification; end

  sig { returns(T::Array[::String]) }
  def removed_rbis; end

  sig { params(diff: T::Hash[::String, ::Symbol], command: ::Symbol).void }
  def report_diff_and_exit_if_out_of_date(diff, command); end

  sig { void }
  def require_gem_file; end
end

class Tapioca::Commands::Require < ::Tapioca::Commands::Command
  sig { params(requires_path: ::String, sorbet_config_path: ::String).void }
  def initialize(requires_path:, sorbet_config_path:); end

  sig { override.void }
  def execute; end
end

class Tapioca::Commands::Todo < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper

  sig { params(todo_file: ::String, file_header: T::Boolean).void }
  def initialize(todo_file:, file_header:); end

  sig { override.void }
  def execute; end

  private

  sig { params(constants: T::Array[::String], command: ::String).returns(::RBI::File) }
  def rbi(constants, command:); end

  sig { returns(T::Array[::String]) }
  def unresolved_constants; end
end

module Tapioca::ConfigHelper
  requires_ancestor { Thor }

  sig { params(args: T.untyped, local_options: T.untyped, config: T.untyped).void }
  def initialize(args = T.unsafe(nil), local_options = T.unsafe(nil), config = T.unsafe(nil)); end

  sig { returns(::String) }
  def command_name; end

  sig { returns(::Thor::CoreExt::HashWithIndifferentAccess) }
  def defaults; end

  sig { returns(::Thor::CoreExt::HashWithIndifferentAccess) }
  def options; end

  private

  sig { params(msg: ::String).returns(::Tapioca::ConfigHelper::ConfigError) }
  def build_error(msg); end

  sig do
    params(
      options: ::Thor::CoreExt::HashWithIndifferentAccess
    ).returns(::Thor::CoreExt::HashWithIndifferentAccess)
  end
  def config_options(options); end

  sig { params(options: T::Hash[::Symbol, ::Thor::Option]).void }
  def filter_defaults(options); end

  sig do
    params(
      options: T.nilable(::Thor::CoreExt::HashWithIndifferentAccess)
    ).returns(::Thor::CoreExt::HashWithIndifferentAccess)
  end
  def merge_options(*options); end

  sig { params(config_file: ::String, errors: T::Array[::Tapioca::ConfigHelper::ConfigError]).void }
  def print_errors(config_file, errors); end

  sig { params(config_file: ::String, config: T::Hash[T.untyped, T.untyped]).void }
  def validate_config!(config_file, config); end

  sig do
    params(
      command_options: T::Hash[::Symbol, ::Thor::Option],
      config_key: ::String,
      config_options: T::Hash[T.untyped, T.untyped]
    ).returns(T::Array[::Tapioca::ConfigHelper::ConfigError])
  end
  def validate_config_options(command_options, config_key, config_options); end
end

class Tapioca::ConfigHelper::ConfigError < ::T::Struct
  const :message_parts, T::Array[::Tapioca::ConfigHelper::ConfigErrorMessagePart]

  class << self
    def inherited(s); end
  end
end

class Tapioca::ConfigHelper::ConfigErrorMessagePart < ::T::Struct
  const :colors, T::Array[::Symbol]
  const :message, ::String

  class << self
    def inherited(s); end
  end
end

Tapioca::DEFAULT_ANNOTATIONS_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_DSL_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_ENVIRONMENT = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_GEM_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_OVERRIDES = T.let(T.unsafe(nil), Hash)
Tapioca::DEFAULT_POSTREQUIRE_FILE = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_RBI_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_RBI_FORMATTER = T.let(T.unsafe(nil), Tapioca::RBIFormatter)
Tapioca::DEFAULT_RBI_MAX_LINE_LENGTH = T.let(T.unsafe(nil), Integer)
Tapioca::DEFAULT_SHIM_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_TODO_FILE = T.let(T.unsafe(nil), String)
module Tapioca::Dsl; end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Tapioca::Dsl::Compiler
  extend T::Generic
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIHelper
  include ::Tapioca::Runtime::Reflection
  extend ::Tapioca::Runtime::Reflection

  abstract!

  ConstantType = type_member { { upper: Module } }

  sig { params(pipeline: ::Tapioca::Dsl::Pipeline, root: ::RBI::Tree, constant: ConstantType).void }
  def initialize(pipeline, root, constant); end

  # NOTE: This should eventually accept an `Error` object or `Exception` rather than simply a `String`.
  sig { params(error: ::String).void }
  def add_error(error); end

  sig { params(compiler_name: ::String).returns(T::Boolean) }
  def compiler_enabled?(compiler_name); end

  sig { returns(ConstantType) }
  def constant; end

  # @abstract
  sig { abstract.void }
  def decorate; end

  sig { returns(::RBI::Tree) }
  def root; end

  private

  sig { params(type: ::String).returns(::String) }
  def as_nilable_type(type); end

  sig { params(method_def: T.any(::Method, ::UnboundMethod)).returns(T::Array[::RBI::TypedParam]) }
  def compile_method_parameters_to_rbi(method_def); end

  sig { params(method_def: T.any(::Method, ::UnboundMethod)).returns(::String) }
  def compile_method_return_type_to_rbi(method_def); end

  sig { params(scope: ::RBI::Scope, method_def: T.any(::Method, ::UnboundMethod), class_method: T::Boolean).void }
  def create_method_from_def(scope, method_def, class_method: T.unsafe(nil)); end

  # Get the types of each parameter from a method signature
  sig { params(method_def: T.any(::Method, ::UnboundMethod), signature: T.untyped).returns(T::Array[::String]) }
  def parameters_types_from_signature(method_def, signature); end

  class << self
    # @abstract
    sig { abstract.returns(T::Enumerable[::Module]) }
    def gather_constants; end

    sig { params(constant: ::Module).returns(T::Boolean) }
    def handles?(constant); end

    sig { returns(T::Set[::Module]) }
    def processable_constants; end

    private

    sig { returns(T::Enumerable[::Class]) }
    def all_classes; end

    sig { returns(T::Enumerable[::Module]) }
    def all_modules; end
  end
end

module Tapioca::Dsl::Compilers; end
Tapioca::Dsl::Compilers::DIRECTORY = T.let(T.unsafe(nil), String)

# DSL compilers are either built-in to Tapioca and live under the
# `Tapioca::Dsl::Compilers` namespace (i.e. this namespace), and
# can be referred to by just using the class name, or they live in
# a different namespace and can only be referred to using their fully
# qualified name. This constant encapsulates that dual lookup when
# a compiler needs to be resolved by name.
Tapioca::Dsl::Compilers::NAMESPACES = T.let(T.unsafe(nil), Array)

class Tapioca::Dsl::Pipeline
  sig do
    params(
      requested_constants: T::Array[::Module],
      requested_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      excluded_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      error_handler: T.proc.params(error: ::String).void,
      number_of_workers: T.nilable(::Integer)
    ).void
  end
  def initialize(requested_constants:, requested_compilers: T.unsafe(nil), excluded_compilers: T.unsafe(nil), error_handler: T.unsafe(nil), number_of_workers: T.unsafe(nil)); end

  sig { params(error: ::String).void }
  def add_error(error); end

  sig { params(compiler_name: ::String).returns(T::Boolean) }
  def compiler_enabled?(compiler_name); end

  sig { returns(T::Enumerable[T.class_of(Tapioca::Dsl::Compiler)]) }
  def compilers; end

  sig { returns(T.proc.params(error: ::String).void) }
  def error_handler; end

  sig { returns(T::Array[::String]) }
  def errors; end

  sig { returns(T::Array[::Module]) }
  def requested_constants; end

  sig do
    type_parameters(:T)
      .params(
        blk: T.proc.params(constant: ::Module, rbi: ::RBI::File).returns(T.type_parameter(:T))
      ).returns(T::Array[T.type_parameter(:T)])
  end
  def run(&blk); end

  private

  sig { params(constants: T::Set[::Module]).returns(T::Set[::Module]) }
  def filter_anonymous_and_reloaded_constants(constants); end

  sig do
    params(
      requested_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      excluded_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)]
    ).returns(T::Enumerable[T.class_of(Tapioca::Dsl::Compiler)])
  end
  def gather_compilers(requested_compilers, excluded_compilers); end

  sig { params(requested_constants: T::Array[::Module]).returns(T::Set[::Module]) }
  def gather_constants(requested_constants); end

  sig { params(constant: ::Module).returns(T.nilable(::RBI::File)) }
  def rbi_for_constant(constant); end

  sig { params(error: ::String).returns(T.noreturn) }
  def report_error(error); end
end

module Tapioca::EnvHelper
  requires_ancestor { Thor }

  sig { params(options: T::Hash[::Symbol, T.untyped]).void }
  def set_environment(options); end
end

class Tapioca::Error < ::StandardError; end

class Tapioca::Executor
  sig { params(queue: T::Array[T.untyped], number_of_workers: T.nilable(::Integer)).void }
  def initialize(queue, number_of_workers: T.unsafe(nil)); end

  sig do
    type_parameters(:T)
      .params(
        block: T.proc.params(item: T.untyped).returns(T.type_parameter(:T))
      ).returns(T::Array[T.type_parameter(:T)])
  end
  def run_in_parallel(&block); end
end

Tapioca::Executor::MINIMUM_ITEMS_PER_WORKER = T.let(T.unsafe(nil), Integer)
module Tapioca::Gem; end

class Tapioca::Gem::ConstNodeAdded < ::Tapioca::Gem::NodeAdded
  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Const).void }
  def initialize(symbol, constant, node); end

  sig { returns(::RBI::Const) }
  def node; end
end

class Tapioca::Gem::ConstantFound < ::Tapioca::Gem::Event
  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def initialize(symbol, constant); end

  sig { returns(::BasicObject) }
  def constant; end

  sig { returns(::String) }
  def symbol; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Tapioca::Gem::Event
  abstract!

  def initialize(*args, **_arg1, &blk); end
end

class Tapioca::Gem::ForeignConstantFound < ::Tapioca::Gem::ConstantFound
  sig { params(symbol: ::String, constant: ::Module).void }
  def initialize(symbol, constant); end

  sig { override.returns(::Module) }
  def constant; end
end

class Tapioca::Gem::ForeignScopeNodeAdded < ::Tapioca::Gem::ScopeNodeAdded; end
module Tapioca::Gem::Listeners; end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Tapioca::Gem::Listeners::Base
  abstract!

  sig { params(pipeline: ::Tapioca::Gem::Pipeline).void }
  def initialize(pipeline); end

  sig { params(event: ::Tapioca::Gem::NodeAdded).void }
  def dispatch(event); end

  private

  sig { params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { params(event: ::Tapioca::Gem::ConstNodeAdded).void }
  def on_const(event); end

  sig { params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::DynamicMixins < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::ForeignConstants < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { params(location: ::String).returns(T::Boolean) }
  def mixed_in_by_gem?(location); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::Methods < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIHelper
  include ::Tapioca::Runtime::Reflection

  private

  sig { params(tree: ::RBI::Tree, module_name: ::String, mod: ::Module, for_visibility: T::Array[::Symbol]).void }
  def compile_directly_owned_methods(tree, module_name, mod, for_visibility = T.unsafe(nil)); end

  sig do
    params(
      tree: ::RBI::Tree,
      symbol_name: ::String,
      constant: ::Module,
      method: T.nilable(::UnboundMethod),
      visibility: ::RBI::Visibility
    ).void
  end
  def compile_method(tree, symbol_name, constant, method, visibility = T.unsafe(nil)); end

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { params(constant: ::Module).returns(T.nilable(::UnboundMethod)) }
  def initialize_method_for(constant); end

  sig { params(mod: ::Module).returns(T::Hash[::Symbol, T::Array[::Symbol]]) }
  def method_names_by_visibility(mod); end

  # Check whether the method is defined by the constant.
  #
  # In most cases, it works to check that the constant is the method owner. However,
  # in the case that a method is also defined in a module prepended to the constant, it
  # will be owned by the prepended module, not the constant.
  #
  # This method implements a better way of checking whether a constant defines a method.
  # It walks up the ancestor tree via the `super_method` method; if any of the super
  # methods are owned by the constant, it means that the constant declares the method.
  sig { params(method: ::UnboundMethod, constant: ::Module).returns(T::Boolean) }
  def method_owned_by_constant?(method, constant); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end

  sig { params(constant: ::Module, method_name: ::String).returns(T::Boolean) }
  def struct_method?(constant, method_name); end
end

class Tapioca::Gem::Listeners::Mixins < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig do
    params(
      tree: ::RBI::Tree,
      constant: ::Module,
      mods: T::Array[::Module],
      mixin_type: ::Tapioca::Runtime::Trackers::Mixin::Type
    ).void
  end
  def add_mixins(tree, constant, mods, mixin_type); end

  sig { params(mixin_name: ::String).returns(T::Boolean) }
  def filtered_mixin?(mixin_name); end

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def interesting_ancestors_of(constant); end

  sig do
    params(
      constant: ::Module,
      mixin: ::Module,
      mixin_type: ::Tapioca::Runtime::Trackers::Mixin::Type
    ).returns(T::Boolean)
  end
  def mixed_in_by_gem?(constant, mixin, mixin_type); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::RemoveEmptyPayloadScopes < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetEnums < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetHelpers < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetProps < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetRequiredAncestors < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetSignatures < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIHelper

  private

  sig { params(signature: T.untyped, parameters: T::Array[[::Symbol, ::String]]).returns(::RBI::Sig) }
  def compile_signature(signature, parameters); end

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { params(signature: T.untyped).returns(T::Boolean) }
  def signature_final?(signature); end
end

Tapioca::Gem::Listeners::SorbetSignatures::TYPE_PARAMETER_MATCHER = T.let(T.unsafe(nil), Regexp)

class Tapioca::Gem::Listeners::SorbetTypeVariables < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { params(tree: ::RBI::Tree, constant: ::Module).void }
  def compile_type_variable_declarations(tree, constant); end

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::Subconstants < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::YardDoc < ::Tapioca::Gem::Listeners::Base
  sig { params(pipeline: ::Tapioca::Gem::Pipeline).void }
  def initialize(pipeline); end

  private

  sig { params(name: ::String, sigs: T::Array[::RBI::Sig]).returns(T::Array[::RBI::Comment]) }
  def documentation_comments(name, sigs: T.unsafe(nil)); end

  sig { override.params(event: ::Tapioca::Gem::NodeAdded).returns(T::Boolean) }
  def ignore?(event); end

  sig { override.params(event: ::Tapioca::Gem::ConstNodeAdded).void }
  def on_const(event); end

  sig { override.params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

Tapioca::Gem::Listeners::YardDoc::IGNORED_COMMENTS = T.let(T.unsafe(nil), Array)
Tapioca::Gem::Listeners::YardDoc::IGNORED_SIG_TAGS = T.let(T.unsafe(nil), Array)

class Tapioca::Gem::MethodNodeAdded < ::Tapioca::Gem::NodeAdded
  sig do
    params(
      symbol: ::String,
      constant: ::Module,
      node: ::RBI::Method,
      signature: T.untyped,
      parameters: T::Array[[::Symbol, ::String]]
    ).void
  end
  def initialize(symbol, constant, node, signature, parameters); end

  sig { returns(::RBI::Method) }
  def node; end

  sig { returns(T::Array[[::Symbol, ::String]]) }
  def parameters; end

  sig { returns(T.untyped) }
  def signature; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Tapioca::Gem::NodeAdded < ::Tapioca::Gem::Event
  abstract!

  sig { params(symbol: ::String, constant: ::Module).void }
  def initialize(symbol, constant); end

  sig { returns(::Module) }
  def constant; end

  sig { returns(::String) }
  def symbol; end
end

class Tapioca::Gem::Pipeline
  include ::Tapioca::Runtime::Reflection
  include ::Tapioca::SorbetHelper
  include ::Tapioca::RBIHelper

  sig { params(gem: ::Tapioca::Gemfile::GemSpec, include_doc: T::Boolean).void }
  def initialize(gem, include_doc: T.unsafe(nil)); end

  sig { returns(::RBI::Tree) }
  def compile; end

  sig { returns(::Tapioca::Gemfile::GemSpec) }
  def gem; end

  sig { params(method: ::UnboundMethod).returns(T::Boolean) }
  def method_in_gem?(method); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def name_of(constant); end

  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Const).void }
  def push_const(symbol, constant, node); end

  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def push_constant(symbol, constant); end

  sig { params(symbol: ::String, constant: ::Module).void }
  def push_foreign_constant(symbol, constant); end

  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Scope).void }
  def push_foreign_scope(symbol, constant, node); end

  sig do
    params(
      symbol: ::String,
      constant: ::Module,
      node: ::RBI::Method,
      signature: T.untyped,
      parameters: T::Array[[::Symbol, ::String]]
    ).void
  end
  def push_method(symbol, constant, node, signature, parameters); end

  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Scope).void }
  def push_scope(symbol, constant, node); end

  sig { params(symbol: ::String).void }
  def push_symbol(symbol); end

  sig { params(symbol_name: ::String).returns(T::Boolean) }
  def symbol_in_payload?(symbol_name); end

  private

  sig { params(name: ::String).void }
  def add_to_alias_namespace(name); end

  sig { params(name: ::String).returns(T::Boolean) }
  def alias_namespaced?(name); end

  sig { params(name: ::String, constant: ::Module).void }
  def compile_alias(name, constant); end

  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def compile_constant(symbol, constant); end

  # Compile
  sig { params(symbol: ::String, constant: ::Module).void }
  def compile_foreign_constant(symbol, constant); end

  sig { params(name: ::String, constant: ::Module, foreign_constant: T::Boolean).void }
  def compile_module(name, constant, foreign_constant: T.unsafe(nil)); end

  sig { params(name: ::String, value: ::BasicObject).void }
  def compile_object(name, value); end

  sig { params(constant: ::Class).returns(T.nilable(::String)) }
  def compile_superclass(constant); end

  sig { params(constant: ::Module, strict: T::Boolean).returns(T::Boolean) }
  def defined_in_gem?(constant, strict: T.unsafe(nil)); end

  sig { params(event: ::Tapioca::Gem::Event).void }
  def dispatch(event); end

  sig { params(constant: T.all(::Module, ::T::Generic)).returns(::String) }
  def generic_name_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::String]) }
  def get_file_candidates(constant); end

  sig { params(gem: ::Tapioca::Gemfile::GemSpec).returns(T::Set[::String]) }
  def load_bootstrap_symbols(gem); end

  sig { params(name: ::String).void }
  def mark_seen(name); end

  sig { params(constant: ::Module, class_name: T.nilable(::String)).returns(T.nilable(::String)) }
  def name_of_proxy_target(constant, class_name); end

  sig { returns(::Tapioca::Gem::Event) }
  def next_event; end

  sig { params(event: ::Tapioca::Gem::ConstantFound).void }
  def on_constant(event); end

  sig { params(event: ::Tapioca::Gem::NodeAdded).void }
  def on_node(event); end

  sig { params(event: ::Tapioca::Gem::SymbolFound).void }
  def on_symbol(event); end

  sig { params(name: ::String).returns(T::Boolean) }
  def seen?(name); end
end

Tapioca::Gem::Pipeline::IGNORED_SYMBOLS = T.let(T.unsafe(nil), Array)

class Tapioca::Gem::ScopeNodeAdded < ::Tapioca::Gem::NodeAdded
  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Scope).void }
  def initialize(symbol, constant, node); end

  sig { returns(::RBI::Scope) }
  def node; end
end

class Tapioca::Gem::SymbolFound < ::Tapioca::Gem::Event
  sig { params(symbol: ::String).void }
  def initialize(symbol); end

  sig { returns(::String) }
  def symbol; end
end

module Tapioca::GemHelper
  sig { params(gemfile_dir: ::String, full_gem_path: ::String).returns(T::Boolean) }
  def gem_in_app_dir?(gemfile_dir, full_gem_path); end

  sig { params(full_gem_path: ::String).returns(T::Boolean) }
  def gem_in_bundle_path?(full_gem_path); end

  sig { params(path: T.any(::Pathname, ::String)).returns(::String) }
  def to_realpath(path); end
end

class Tapioca::Gemfile
  sig { params(exclude: T::Array[::String]).void }
  def initialize(exclude); end

  sig { returns(::Bundler::Definition) }
  def definition; end

  sig { returns(T::Array[::Tapioca::Gemfile::GemSpec]) }
  def dependencies; end

  sig { params(gem_name: ::String).returns(T.nilable(::Tapioca::Gemfile::GemSpec)) }
  def gem(gem_name); end

  sig { returns(T::Array[::String]) }
  def missing_specs; end

  sig { void }
  def require_bundle; end

  private

  sig { returns(::String) }
  def dir; end

  sig { returns(::File) }
  def gemfile; end

  sig { returns(T::Array[::Symbol]) }
  def groups; end

  sig { returns([T::Array[::Tapioca::Gemfile::GemSpec], T::Array[::String]]) }
  def load_dependencies; end

  # @return [File]
  def lockfile; end

  sig { returns([T::Enumerable[T.any(::Bundler::StubSpecification, ::Gem::Specification)], T::Array[::String]]) }
  def materialize_deps; end

  sig { returns(::Bundler::Runtime) }
  def runtime; end
end

# This is a module that gets prepended to `Bundler::Dependency` and
# makes sure even gems marked as `require: false` are required during
# `Bundler.require`.
module Tapioca::Gemfile::AutoRequireHook
  requires_ancestor { Bundler::Dependency }

  sig { returns(T.untyped) }
  def autorequire; end

  class << self
    sig { params(exclude: T::Array[::String]).returns(T::Array[::String]) }
    def exclude=(exclude); end

    sig { params(name: T.untyped).returns(T::Boolean) }
    def excluded?(name); end
  end
end

class Tapioca::Gemfile::GemSpec
  include ::Tapioca::GemHelper

  sig { params(spec: T.any(::Bundler::StubSpecification, ::Gem::Specification)).void }
  def initialize(spec); end

  sig { params(path: ::String).returns(T::Boolean) }
  def contains_path?(path); end

  sig { returns(T::Boolean) }
  def export_rbi_files?; end

  sig { returns(T::Array[::String]) }
  def exported_rbi_files; end

  sig { returns(::RBI::MergeTree) }
  def exported_rbi_tree; end

  sig { returns(T::Array[::Pathname]) }
  def files; end

  sig { returns(::String) }
  def full_gem_path; end

  sig { params(gemfile_dir: ::String).returns(T::Boolean) }
  def ignore?(gemfile_dir); end

  sig { returns(::String) }
  def name; end

  sig { void }
  def parse_yard_docs; end

  sig { returns(::String) }
  def rbi_file_name; end

  # @return [String]
  def version; end

  private

  sig { returns(T::Array[::Pathname]) }
  def collect_files; end

  sig { returns(T.nilable(T::Boolean)) }
  def default_gem?; end

  sig { returns(T::Boolean) }
  def gem_ignored?; end

  sig { params(path: ::String).returns(T::Boolean) }
  def has_parent_gemspec?(path); end

  sig { returns(::Regexp) }
  def require_paths_prefix_matcher; end

  sig { params(file: ::String).returns(::Pathname) }
  def resolve_to_ruby_lib_dir(file); end

  sig { returns(::String) }
  def version_string; end
end

Tapioca::Gemfile::GemSpec::IGNORED_GEMS = T.let(T.unsafe(nil), Array)
Tapioca::Gemfile::Spec = T.type_alias { T.any(::Bundler::StubSpecification, ::Gem::Specification) }

module Tapioca::RBIFilesHelper
  requires_ancestor { Tapioca::SorbetHelper }
  requires_ancestor { Thor::Shell }

  sig do
    params(
      index: ::RBI::Index,
      shim_rbi_dir: ::String,
      todo_rbi_file: ::String
    ).returns(T::Hash[::String, T::Array[::RBI::Node]])
  end
  def duplicated_nodes_from_index(index, shim_rbi_dir:, todo_rbi_file:); end

  sig { params(index: ::RBI::Index, dir: ::String).void }
  def index_payload(index, dir); end

  sig { params(index: ::RBI::Index, kind: ::String, file: ::String).void }
  def index_rbi(index, kind, file); end

  sig { params(index: ::RBI::Index, kind: ::String, dir: ::String).void }
  def index_rbis(index, kind, dir); end

  sig { params(loc: ::RBI::Loc, path_prefix: T.nilable(::String)).returns(::String) }
  def location_to_payload_url(loc, path_prefix:); end

  sig do
    params(
      command: ::String,
      gem_dir: ::String,
      dsl_dir: ::String,
      auto_strictness: T::Boolean,
      gems: T::Array[::Tapioca::Gemfile::GemSpec],
      compilers: T::Enumerable[::Class]
    ).void
  end
  def validate_rbi_files(command:, gem_dir:, dsl_dir:, auto_strictness:, gems: T.unsafe(nil), compilers: T.unsafe(nil)); end

  private

  sig { params(nodes: T::Array[::RBI::Node]).returns(T::Array[::RBI::Scope]) }
  def extract_empty_scopes(nodes); end

  sig { params(nodes: T::Array[::RBI::Node]).returns(T::Array[T.any(::RBI::Attr, ::RBI::Method)]) }
  def extract_methods_and_attrs(nodes); end

  sig { params(nodes: T::Array[::RBI::Node]).returns(T::Array[T.any(::RBI::Mixin, ::RBI::RequiresAncestor)]) }
  def extract_mixins(nodes); end

  sig do
    params(
      nodes: T::Array[T.any(::RBI::Attr, ::RBI::Method)]
    ).returns(T::Array[T.any(::RBI::Attr, ::RBI::Method)])
  end
  def extract_nodes_with_sigs(nodes); end

  sig do
    params(
      nodes: T::Array[::RBI::Node],
      shim_rbi_dir: ::String,
      todo_rbi_file: ::String
    ).returns(T::Array[::RBI::Node])
  end
  def extract_shims_and_todos(nodes, shim_rbi_dir:, todo_rbi_file:); end

  sig { params(path: ::String).returns(::String) }
  def gem_name_from_rbi_path(path); end

  sig { params(index: ::RBI::Index, file: ::String).void }
  def parse_and_index_file(index, file); end

  sig { params(index: ::RBI::Index, files: T::Array[::String]).void }
  def parse_and_index_files(index, files); end

  sig { params(nodes: T::Array[::RBI::Node], shim_rbi_dir: ::String, todo_rbi_file: ::String).returns(T::Boolean) }
  def shims_or_todos_have_duplicates?(nodes, shim_rbi_dir:, todo_rbi_file:); end

  sig { params(errors: T::Array[::Spoom::Sorbet::Errors::Error], gem_dir: ::String).void }
  def update_gem_rbis_strictnesses(errors, gem_dir); end
end

class Tapioca::RBIFormatter < ::RBI::Formatter
  sig { params(file: ::RBI::File).void }
  def write_empty_body_comment!(file); end

  sig { params(file: ::RBI::File, command: ::String, reason: T.nilable(::String)).void }
  def write_header!(file, command, reason: T.unsafe(nil)); end
end

module Tapioca::RBIHelper
  include ::Tapioca::SorbetHelper
  extend ::Tapioca::SorbetHelper
  extend ::Tapioca::RBIHelper

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_block_param(name, type:); end

  sig { params(name: ::String, type: ::String, default: ::String).returns(::RBI::TypedParam) }
  def create_kw_opt_param(name, type:, default:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_kw_param(name, type:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_kw_rest_param(name, type:); end

  sig { params(name: ::String, type: ::String, default: ::String).returns(::RBI::TypedParam) }
  def create_opt_param(name, type:, default:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_param(name, type:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_rest_param(name, type:); end

  sig { params(param: ::RBI::Param, type: ::String).returns(::RBI::TypedParam) }
  def create_typed_param(param, type); end

  sig { params(sig_string: ::String).returns(::String) }
  def sanitize_signature_types(sig_string); end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_method_name?(name); end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_parameter_name?(name); end

  class << self
    sig do
      params(
        type: ::String,
        variance: ::Symbol,
        fixed: T.nilable(::String),
        upper: T.nilable(::String),
        lower: T.nilable(::String)
      ).returns(::String)
    end
    def serialize_type_variable(type, variance, fixed, upper, lower); end
  end
end

class Tapioca::RepoIndex
  sig { void }
  def initialize; end

  sig { params(gem_name: ::String).void }
  def <<(gem_name); end

  sig { returns(T::Enumerable[::String]) }
  def gems; end

  sig { params(gem_name: ::String).returns(T::Boolean) }
  def has_gem?(gem_name); end

  class << self
    sig { params(hash: T::Hash[::String, T::Hash[T.untyped, T.untyped]]).returns(Tapioca::RepoIndex) }
    def from_hash(hash); end

    sig { params(json: ::String).returns(Tapioca::RepoIndex) }
    def from_json(json); end
  end
end

module Tapioca::Runtime; end

class Tapioca::Runtime::DynamicMixinCompiler
  include ::Tapioca::Runtime::Reflection

  sig { params(constant: ::Module).void }
  def initialize(constant); end

  # @return [Array<Symbol>]
  def class_attribute_predicates; end

  sig { returns(T::Array[::Symbol]) }
  def class_attribute_readers; end

  # @return [Array<Symbol>]
  def class_attribute_writers; end

  sig { params(tree: ::RBI::Tree).void }
  def compile_class_attributes(tree); end

  sig { params(tree: ::RBI::Tree).returns([T::Array[::Module], T::Array[::Module]]) }
  def compile_mixes_in_class_methods(tree); end

  sig { returns(T::Array[::Module]) }
  def dynamic_extends; end

  # @return [Array<Module>]
  def dynamic_includes; end

  sig { returns(T::Boolean) }
  def empty_attributes?; end

  sig { params(qualified_mixin_name: ::String).returns(T::Boolean) }
  def filtered_mixin?(qualified_mixin_name); end

  # @return [Array<Symbol>]
  def instance_attribute_predicates; end

  sig { returns(T::Array[::Symbol]) }
  def instance_attribute_readers; end

  # @return [Array<Symbol>]
  def instance_attribute_writers; end

  sig { params(mod: ::Module, dynamic_extends: T::Array[::Module]).returns(T::Boolean) }
  def module_included_by_another_dynamic_extend?(mod, dynamic_extends); end
end

# This class is responsible for storing and looking up information related to generic types.
#
# The class stores 2 different kinds of data, in two separate lookup tables:
#   1. a lookup of generic type instances by name: `@generic_instances`
#   2. a lookup of type variable serializer by constant and type variable
#      instance: `@type_variables`
#
# By storing the above data, we can cheaply query each constant against this registry
# to see if it declares any generic type variables. This becomes a simple lookup in the
# `@type_variables` hash table with the given constant.
#
# If there is no entry, then we can cheaply know that we can skip generic type
# information generation for this type.
#
# On the other hand, if we get a result, then the result will be a hash of type
# variable to type variable serializers. This allows us to associate type variables
# to the constant names that represent them, easily.
module Tapioca::Runtime::GenericTypeRegistry
  class << self
    sig { params(instance: ::Object).returns(T::Boolean) }
    def generic_type_instance?(instance); end

    sig { params(constant: ::Module).returns(T.nilable(T::Array[::Tapioca::TypeVariableModule])) }
    def lookup_type_variables(constant); end

    # This method is responsible for building the name of the instantiated concrete type
    # and cloning the given constant so that we can return a type that is the same
    # as the current type but is a different instance and has a different name method.
    #
    # We cache those cloned instances by their name in `@generic_instances`, so that
    # we don't keep instantiating a new type every single time it is referenced.
    # For example, `[Foo[Integer], Foo[Integer], Foo[Integer], Foo[String]]` will only
    # result in 2 clones (1 for `Foo[Integer]` and another for `Foo[String]`) and
    # 2 hash lookups (for the other two `Foo[Integer]`s).
    #
    # This method returns the created or cached clone of the constant.
    sig { params(constant: T.untyped, types: T.untyped).returns(::Module) }
    def register_type(constant, types); end

    # This method is called from intercepted calls to `type_member` and `type_template`.
    # We get passed all the arguments to those methods, as well as the `T::Types::TypeVariable`
    # instance generated by the Sorbet defined `type_member`/`type_template` call on `T::Generic`.
    #
    # This method creates a `String` with that data and stores it in the
    # `@type_variables` lookup table, keyed by the `constant` and `type_variable`.
    #
    # Finally, the original `type_variable` is returned from this method, so that the caller
    # can return it from the original methods as well.
    sig { params(constant: T.untyped, type_variable: ::Tapioca::TypeVariableModule).void }
    def register_type_variable(constant, type_variable); end

    private

    sig { params(constant: ::Module, name: ::String).returns(::Module) }
    def create_generic_type(constant, name); end

    sig { params(constant: ::Class).returns(::Class) }
    def create_safe_subclass(constant); end

    sig { params(constant: ::Module).returns(T::Array[::Tapioca::TypeVariableModule]) }
    def lookup_or_initialize_type_variables(constant); end
  end
end

class Tapioca::Runtime::Loader
  include ::Tapioca::GemHelper

  sig do
    params(
      gemfile: ::Tapioca::Gemfile,
      initialize_file: T.nilable(::String),
      require_file: T.nilable(::String)
    ).void
  end
  def load_bundle(gemfile, initialize_file, require_file); end

  sig { params(environment_load: T::Boolean, eager_load: T::Boolean).void }
  def load_rails_application(environment_load: T.unsafe(nil), eager_load: T.unsafe(nil)); end

  private

  sig { void }
  def eager_load_rails_app; end

  sig { void }
  def load_rails_engines; end

  sig { returns(T::Array[T.untyped]) }
  def rails_engines; end

  sig { params(file: T.nilable(::String)).void }
  def require_helper(file); end

  sig { params(path: ::String).void }
  def safe_require(path); end

  sig { void }
  def silence_deprecations; end
end

module Tapioca::Runtime::Reflection
  extend ::Tapioca::Runtime::Reflection

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def ancestors_of(constant); end

  sig { params(object: ::BasicObject, other: ::BasicObject).returns(T::Boolean) }
  def are_equal?(object, other); end

  sig { params(singleton_class: ::Module).returns(T.nilable(::Module)) }
  def attached_class_of(singleton_class); end

  sig { params(object: ::BasicObject).returns(::Class) }
  def class_of(object); end

  sig { params(symbol: ::String, inherit: T::Boolean, namespace: ::Module).returns(::BasicObject) }
  def constantize(symbol, inherit: T.unsafe(nil), namespace: T.unsafe(nil)); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def constants_of(constant); end

  # Returns an array with all classes that are < than the supplied class.
  #
  #   class C; end
  #   descendants_of(C) # => []
  #
  #   class B < C; end
  #   descendants_of(C) # => [B]
  #
  #   class A < B; end
  #   descendants_of(C) # => [B, A]
  #
  #   class D < C; end
  #   descendants_of(C) # => [B, A, D]
  sig do
    type_parameters(:U)
      .params(
        klass: T.all(::Class, T.type_parameter(:U))
      ).returns(T::Array[T.type_parameter(:U)])
  end
  def descendants_of(klass); end

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def inherited_ancestors_of(constant); end

  sig { params(constant: ::Module, method: ::Symbol).returns(::Method) }
  def method_of(constant, method); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def name_of(constant); end

  sig { params(type: ::T::Types::Base).returns(::String) }
  def name_of_type(type); end

  sig { params(object: ::BasicObject).returns(::Integer) }
  def object_id_of(object); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def private_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def protected_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def public_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def qualified_name_of(constant); end

  # Examines the call stack to identify the closest location where a "require" is performed
  # by searching for the label "<top (required)>". If none is found, it returns the location
  # labeled "<main>", which is the original call site.
  sig { returns(::String) }
  def required_from_location; end

  sig { params(method: T.any(::Method, ::UnboundMethod)).returns(T.untyped) }
  def signature_of(method); end

  sig { params(constant: ::Module).returns(::Class) }
  def singleton_class_of(constant); end

  sig { params(constant: ::Class).returns(T.nilable(::Class)) }
  def superclass_of(constant); end
end

Tapioca::Runtime::Reflection::ANCESTORS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::CLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::CONSTANTS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::EQUAL_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::METHOD_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::NAME_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::OBJECT_ID_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PRIVATE_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PROTECTED_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PUBLIC_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::REQUIRED_FROM_LABELS = T.let(T.unsafe(nil), Array)
Tapioca::Runtime::Reflection::SINGLETON_CLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::SUPERCLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
module Tapioca::Runtime::Trackers; end

module Tapioca::Runtime::Trackers::Autoload
  class << self
    sig { void }
    def eager_load_all!; end

    sig { params(constant_name: ::String).void }
    def register(constant_name); end

    sig do
      type_parameters(:Result)
        .params(
          block: T.proc.returns(T.type_parameter(:Result))
        ).returns(T.type_parameter(:Result))
    end
    def with_disabled_exits(&block); end
  end
end

Tapioca::Runtime::Trackers::Autoload::NOOP_METHOD = T.let(T.unsafe(nil), Proc)

# Registers a TracePoint immediately upon load to track points at which
# classes and modules are opened for definition. This is used to track
# correspondence between classes/modules and files, as this information isn't
# available in the ruby runtime without extra accounting.
module Tapioca::Runtime::Trackers::ConstantDefinition
  extend ::Tapioca::Runtime::Reflection

  class << self
    # Returns the files in which this class or module was opened. Doesn't know
    # about situations where the class was opened prior to +require+ing,
    # or where metaprogramming was used via +eval+, etc.
    def files_for(klass); end
  end
end

class Tapioca::Runtime::Trackers::ConstantDefinition::ConstantLocation < ::T::Struct
  const :lineno, ::Integer
  const :path, ::String

  class << self
    def inherited(s); end
  end
end

module Tapioca::Runtime::Trackers::Mixin
  class << self
    sig do
      params(
        mixin: ::Module
      ).returns(T::Hash[::Tapioca::Runtime::Trackers::Mixin::Type, T::Hash[::Module, ::String]])
    end
    def constants_with_mixin(mixin); end

    sig { params(constant: ::Module, mixin: ::Module, mixin_type: ::Tapioca::Runtime::Trackers::Mixin::Type).void }
    def register(constant, mixin, mixin_type); end

    sig do
      type_parameters(:Result)
        .params(
          block: T.proc.returns(T.type_parameter(:Result))
        ).returns(T.type_parameter(:Result))
    end
    def with_disabled_registration(&block); end
  end
end

class Tapioca::Runtime::Trackers::Mixin::Type < ::T::Enum
  enums do
    Prepend = new
    Include = new
    Extend = new
  end
end

module Tapioca::Runtime::Trackers::RequiredAncestor
  class << self
    sig { params(requiring: ::T::Helpers, block: T.proc.returns(::Module)).void }
    def register(requiring, block); end

    sig { params(mod: ::Module).returns(T::Array[T.proc.returns(::Module)]) }
    def required_ancestors_blocks_by(mod); end

    sig { params(mod: ::Module).returns(T::Array[T.nilable(::Module)]) }
    def required_ancestors_by(mod); end
  end
end

Tapioca::SORBET_CONFIG_FILE = T.let(T.unsafe(nil), String)
Tapioca::SORBET_DIR = T.let(T.unsafe(nil), String)

module Tapioca::SorbetHelper
  sig { params(sorbet_args: ::String).returns(::Spoom::ExecResult) }
  def sorbet(*sorbet_args); end

  sig { returns(::String) }
  def sorbet_path; end

  sig { params(feature: ::Symbol, version: T.nilable(::Gem::Version)).returns(T::Boolean) }
  def sorbet_supports?(feature, version: T.unsafe(nil)); end
end

Tapioca::SorbetHelper::FEATURE_REQUIREMENTS = T.let(T.unsafe(nil), Hash)
Tapioca::SorbetHelper::SORBET_BIN = T.let(T.unsafe(nil), Pathname)
Tapioca::SorbetHelper::SORBET_EXE_PATH_ENV_VAR = T.let(T.unsafe(nil), String)
Tapioca::SorbetHelper::SORBET_GEM_SPEC = T.let(T.unsafe(nil), Gem::Specification)
Tapioca::SorbetHelper::SORBET_PAYLOAD_URL = T.let(T.unsafe(nil), String)
module Tapioca::Static; end

class Tapioca::Static::RequiresCompiler
  sig { params(sorbet_path: ::String).void }
  def initialize(sorbet_path); end

  sig { returns(::String) }
  def compile; end

  private

  sig { params(config: ::Spoom::Sorbet::Config).returns(T::Array[::String]) }
  def collect_files(config); end

  sig { params(file_path: ::String).returns(T::Enumerable[::String]) }
  def collect_requires(file_path); end

  sig { params(config: ::Spoom::Sorbet::Config, file_path: ::Pathname).returns(T::Boolean) }
  def file_ignored_by_sorbet?(config, file_path); end

  sig { params(path: ::Pathname).returns(T::Array[::String]) }
  def path_parts(path); end
end

module Tapioca::Static::SymbolLoader
  extend ::Tapioca::SorbetHelper
  extend ::Tapioca::Runtime::Reflection

  class << self
    sig { params(gem: ::Tapioca::Gemfile::GemSpec).returns(T::Set[::String]) }
    def engine_symbols(gem); end

    sig { params(gem: ::Tapioca::Gemfile::GemSpec).returns(T::Set[::String]) }
    def gem_symbols(gem); end

    sig { returns(T::Set[::String]) }
    def payload_symbols; end

    private

    # @return [Array<T.class_of(Rails::Engine)>]
    def engines(*args, **_arg1, &blk); end

    sig { params(input: ::String, table_type: ::String).returns(::String) }
    def symbol_table_json_from(input, table_type: T.unsafe(nil)); end

    sig { params(paths: T::Array[::Pathname]).returns(T::Set[::String]) }
    def symbols_from_paths(paths); end
  end
end

class Tapioca::Static::SymbolTableParser
  sig { void }
  def initialize; end

  sig { params(name: ::String).returns(::String) }
  def fully_qualified_name(name); end

  sig { params(object: T::Hash[::String, T.untyped]).void }
  def parse_object(object); end

  sig { returns(T::Set[::String]) }
  def symbols; end

  class << self
    sig { params(json_string: ::String).returns(T::Set[::String]) }
    def parse_json(json_string); end
  end
end

Tapioca::TAPIOCA_CONFIG_FILE = T.let(T.unsafe(nil), String)
Tapioca::TAPIOCA_DIR = T.let(T.unsafe(nil), String)

class Tapioca::TypeVariable < ::T::Types::TypeVariable
  # @return [TypeVariable] a new instance of TypeVariable
  def initialize(name, variance); end

  # Returns the value of attribute name.
  def name; end
end

# This is subclassing from `Module` so that instances of this type will be modules.
# The reason why we want that is because that means those instances will automatically
# get bound to the constant names they are assigned to by Ruby. As a result, we don't
# need to do any matching of constants to type variables to bind their names, Ruby will
# do that automatically for us and we get the `name` method for free from `Module`.
class Tapioca::TypeVariableModule < ::Module
  sig do
    params(
      context: ::Module,
      type: ::Tapioca::TypeVariableModule::Type,
      variance: ::Symbol,
      fixed: T.untyped,
      lower: T.untyped,
      upper: T.untyped,
      bounds_proc: T.nilable(T.proc.returns(T::Hash[::Symbol, T.untyped]))
    ).void
  end
  def initialize(context, type, variance, fixed, lower, upper, bounds_proc); end

  sig { returns(::Tapioca::TypeVariable) }
  def coerce_to_type_variable; end

  sig { returns(T.nilable(::String)) }
  def name; end

  sig { returns(::String) }
  def serialize; end

  private

  sig do
    params(
      fixed: T.untyped,
      lower: T.untyped,
      upper: T.untyped
    ).returns(T.proc.returns(T::Hash[::Symbol, T.untyped]))
  end
  def build_bounds_proc(fixed, lower, upper); end

  sig do
    type_parameters(:Result)
      .params(
        block: T.proc.returns(T.type_parameter(:Result))
      ).returns(T.type_parameter(:Result))
  end
  def with_bound_name_pre_3_0(&block); end
end

class Tapioca::TypeVariableModule::Type < ::T::Enum
  enums do
    Member = new
    Template = new
  end
end

Tapioca::VERSION = T.let(T.unsafe(nil), String)
