# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `spoom` gem.
# Please instead update this file by running `bin/tapioca gem spoom`.

module Spoom
  class << self
    sig { params(cmd: ::String, arg: ::String, path: ::String, capture_err: T::Boolean).returns(::Spoom::ExecResult) }
    def exec(cmd, *arg, path: T.unsafe(nil), capture_err: T.unsafe(nil)); end
  end
end

module Spoom::Cli; end

class Spoom::Cli::Bump < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  sig { params(directory: ::String).void }
  def bump(directory = T.unsafe(nil)); end

  def config_files(path: T.unsafe(nil)); end
  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end
  def print_changes(files, command:, from: T.unsafe(nil), to: T.unsafe(nil), dry: T.unsafe(nil), path: T.unsafe(nil)); end
  def undo_changes(files, from_strictness); end
end

class Spoom::Cli::Config < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end
  def show; end
end

class Spoom::Cli::Coverage < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  def bundle_install(path, sha); end
  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end
  def message_no_data(file); end
  def open(file = T.unsafe(nil)); end
  def parse_time(string, option); end
  def report; end
  def snapshot; end
  def timeline; end
end

Spoom::Cli::Coverage::DATA_DIR = T.let(T.unsafe(nil), String)

module Spoom::Cli::Helper
  include ::Spoom::Colorize

  requires_ancestor { Thor }

  sig { params(string: ::String).returns(::String) }
  def blue(string); end

  sig { params(exit_code: ::Integer, block: T.nilable(T.proc.void)).void }
  def check_sorbet_segfault(exit_code, &block); end

  # Is the `--color` option true?
  sig { returns(T::Boolean) }
  def color?; end

  # Colorize a string if `color?`
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  sig { params(string: ::String).returns(::String) }
  def cyan(string); end

  # Return the path specified through `--path`
  sig { returns(::String) }
  def exec_path; end

  sig { params(string: ::String).returns(::String) }
  def gray(string); end

  sig { params(string: ::String).returns(::String) }
  def green(string); end

  sig { params(string: ::String).returns(::String) }
  def highlight(string); end

  # Enforce that `spoom` is ran inside a project with a `sorbet/config` file
  #
  # Display an error message and exit otherwise.
  sig { void }
  def in_sorbet_project!; end

  # Is `spoom` ran inside a project with a `sorbet/config` file?
  sig { returns(T::Boolean) }
  def in_sorbet_project?; end

  sig { params(string: ::String).returns(::String) }
  def red(string); end

  # Print `message` on `$stdout`
  sig { params(message: ::String).void }
  def say(message); end

  # Print `message` on `$stderr`
  #
  # The message is prefixed by a status (default: `Error`).
  sig { params(message: ::String, status: T.nilable(::String), nl: T::Boolean).void }
  def say_error(message, status: T.unsafe(nil), nl: T.unsafe(nil)); end

  sig { returns(::Spoom::Sorbet::Config) }
  def sorbet_config; end

  sig { returns(::String) }
  def sorbet_config_file; end

  sig { params(string: ::String).returns(::String) }
  def yellow(string); end
end

class Spoom::Cli::LSP < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # TODO: options, filter, limit, kind etc.. filter rbi
  def defs(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def find(query); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def hover(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def list; end

  def lsp_client; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def refs(file, line, col); end

  def run(&block); end
  def show; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def sigs(file, line, col); end

  def symbol_printer; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def symbols(file); end

  def to_uri(path); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  def types(file, line, col); end
end

class Spoom::Cli::Main < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  def __print_version; end
  def bump(*args); end
  def config(*args); end
  def coverage(*args); end
  def files; end
  def lsp(*args); end
  def tc(*args); end

  class << self
    # @return [Boolean]
    def exit_on_failure?; end
  end
end

class Spoom::Cli::Run < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  def colorize_message(message); end
  def format_error(error, format); end
  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end
  def tc(*paths_to_select); end
end

Spoom::Cli::Run::DEFAULT_FORMAT = T.let(T.unsafe(nil), String)
Spoom::Cli::Run::SORT_CODE = T.let(T.unsafe(nil), String)
Spoom::Cli::Run::SORT_ENUM = T.let(T.unsafe(nil), Array)
Spoom::Cli::Run::SORT_LOC = T.let(T.unsafe(nil), String)

class Spoom::Color < ::T::Enum
  enums do
    CLEAR = new
    BOLD = new
    BLACK = new
    RED = new
    GREEN = new
    YELLOW = new
    BLUE = new
    MAGENTA = new
    CYAN = new
    WHITE = new
    LIGHT_BLACK = new
    LIGHT_RED = new
    LIGHT_GREEN = new
    LIGHT_YELLOW = new
    LIGHT_BLUE = new
    LIGHT_MAGENTA = new
    LIGHT_CYAN = new
    LIGHT_WHITE = new
  end

  sig { returns(::String) }
  def ansi_code; end
end

module Spoom::Colorize
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def set_color(string, *color); end
end

# An abstraction to a Ruby project context
#
# A context maps to a directory in the file system.
# It is used to manipulate files and run commands in the context of this directory.
class Spoom::Context
  # Create a new context about `absolute_path`
  #
  # The directory will not be created if it doesn't exist.
  # Call `#make!` to create it.
  sig { params(absolute_path: ::String).void }
  def initialize(absolute_path); end

  # The absolute path to the directory this context is about
  sig { returns(::String) }
  def absolute_path; end

  # Returns the absolute path to `relative_path` in the context's directory
  sig { params(relative_path: ::String).returns(::String) }
  def absolute_path_to(relative_path); end

  # Run a command with `bundle` in this context directory
  sig { params(command: ::String, version: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def bundle(command, version: T.unsafe(nil)); end

  # Run a command `bundle exec` in this context directory
  sig { params(command: ::String, version: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def bundle_exec(command, version: T.unsafe(nil)); end

  # Run `bundle install` in this context directory
  sig { params(version: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def bundle_install!(version: T.unsafe(nil)); end

  # Delete this context and its content
  #
  # Warning: it will `rm -rf` the context directory on the file system.
  sig { void }
  def destroy!; end

  # Run a command in this context directory
  sig { params(command: ::String, capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def exec(command, capture_err: T.unsafe(nil)); end

  # Does `relative_path` point to an existing file in this context directory?
  sig { params(relative_path: ::String).returns(T::Boolean) }
  def file?(relative_path); end

  # Run a command prefixed by `git` in this context directory
  sig { params(command: ::String).returns(::Spoom::ExecResult) }
  def git(command); end

  # Run `git checkout` in this context directory
  sig { params(ref: ::String).returns(::Spoom::ExecResult) }
  def git_checkout!(ref: T.unsafe(nil)); end

  # Get the current git branch in this context directory
  sig { returns(T.nilable(::String)) }
  def git_current_branch; end

  # Run `git init` in this context directory
  sig { params(branch: ::String).void }
  def git_init!(branch: T.unsafe(nil)); end

  # List all files in this context matching `pattern`
  sig { params(pattern: ::String).returns(T::Array[::String]) }
  def glob(pattern = T.unsafe(nil)); end

  # List all files at the top level of this context directory
  sig { returns(T::Array[::String]) }
  def list; end

  # Create the context directory at `absolute_path`
  sig { void }
  def mkdir!; end

  # Move the file or directory from `from_relative_path` to `to_relative_path`
  sig { params(from_relative_path: ::String, to_relative_path: ::String).void }
  def move!(from_relative_path, to_relative_path); end

  # Return the contents of the file at `relative_path` in this context directory
  #
  # Will raise if the file doesn't exist.
  sig { params(relative_path: ::String).returns(::String) }
  def read(relative_path); end

  # Read the strictness sigil from the file at `relative_path` (returns `nil` if no sigil)
  sig { params(relative_path: ::String).returns(T.nilable(::String)) }
  def read_file_strictness(relative_path); end

  # Read the `contents` of the Gemfile in this context directory
  sig { returns(T.nilable(::String)) }
  def read_gemfile; end

  # Read the contents of `sorbet/config` in this context directory
  sig { returns(::String) }
  def read_sorbet_config; end

  # Remove the path at `relative_path` (recursive + force) in this context directory
  sig { params(relative_path: ::String).void }
  def remove!(relative_path); end

  # Run `bundle exec srb` in this context directory
  sig { params(command: ::String).returns(::Spoom::ExecResult) }
  def srb(command); end

  # Write `contents` in the file at `relative_path` in this context directory
  #
  # Append to the file if `append` is true.
  sig { params(relative_path: ::String, contents: ::String, append: T::Boolean).void }
  def write!(relative_path, contents = T.unsafe(nil), append: T.unsafe(nil)); end

  # Set the `contents` of the Gemfile in this context directory
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_gemfile!(contents, append: T.unsafe(nil)); end

  # Set the `contents` of `sorbet/config` in this context directory
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_sorbet_config!(contents, append: T.unsafe(nil)); end

  class << self
    # Create a new context in the system's temporary directory
    #
    # `name` is used as prefix to the temporary directory name.
    # The directory will be created if it doesn't exist.
    sig { params(name: T.nilable(::String)).returns(T.attached_class) }
    def mktmp!(name = T.unsafe(nil)); end
  end
end

module Spoom::Coverage
  class << self
    sig do
      params(
        snapshots: T::Array[::Spoom::Coverage::Snapshot],
        palette: ::Spoom::Coverage::D3::ColorPalette,
        path: ::String
      ).returns(::Spoom::Coverage::Report)
    end
    def report(snapshots, palette:, path: T.unsafe(nil)); end

    sig { params(path: ::String).returns(::Spoom::FileTree) }
    def sigils_tree(path: T.unsafe(nil)); end

    sig do
      params(
        path: ::String,
        rbi: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(::Spoom::Coverage::Snapshot)
    end
    def snapshot(path: T.unsafe(nil), rbi: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end

    sig { params(path: ::String).returns(::Spoom::Sorbet::Config) }
    def sorbet_config(path: T.unsafe(nil)); end
  end
end

module Spoom::Coverage::Cards; end

class Spoom::Coverage::Cards::Card < ::Spoom::Coverage::Template
  sig { params(template: ::String, title: T.nilable(::String), body: T.nilable(::String)).void }
  def initialize(template: T.unsafe(nil), title: T.unsafe(nil), body: T.unsafe(nil)); end

  # @return [String, nil]
  def body; end

  sig { returns(T.nilable(::String)) }
  def title; end
end

Spoom::Coverage::Cards::Card::TEMPLATE = T.let(T.unsafe(nil), String)

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::Cards::Erb < ::Spoom::Coverage::Cards::Card
  abstract!

  sig { void }
  def initialize; end

  # @abstract
  sig { abstract.returns(::String) }
  def erb; end

  sig { override.returns(::String) }
  def html; end
end

class Spoom::Coverage::Cards::Map < ::Spoom::Coverage::Cards::Card
  sig { params(sigils_tree: ::Spoom::FileTree, title: ::String).void }
  def initialize(sigils_tree:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Snapshot < ::Spoom::Coverage::Cards::Card
  sig { params(snapshot: ::Spoom::Coverage::Snapshot, title: ::String).void }
  def initialize(snapshot:, title: T.unsafe(nil)); end

  sig { returns(::Spoom::Coverage::D3::Pie::Calls) }
  def pie_calls; end

  sig { returns(::Spoom::Coverage::D3::Pie::Sigils) }
  def pie_sigils; end

  sig { returns(::Spoom::Coverage::D3::Pie::Sigs) }
  def pie_sigs; end

  sig { returns(::Spoom::Coverage::Snapshot) }
  def snapshot; end
end

Spoom::Coverage::Cards::Snapshot::TEMPLATE = T.let(T.unsafe(nil), String)

class Spoom::Coverage::Cards::SorbetIntro < ::Spoom::Coverage::Cards::Erb
  sig { params(sorbet_intro_commit: T.nilable(::String), sorbet_intro_date: T.nilable(::Time)).void }
  def initialize(sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  sig { override.returns(::String) }
  def erb; end
end

class Spoom::Coverage::Cards::Timeline < ::Spoom::Coverage::Cards::Card
  sig { params(title: ::String, timeline: ::Spoom::Coverage::D3::Timeline).void }
  def initialize(title:, timeline:); end
end

class Spoom::Coverage::Cards::Timeline::Calls < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Timeline::RBIs < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Timeline::Runtimes < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Timeline::Sigils < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Timeline::Sigs < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

class Spoom::Coverage::Cards::Timeline::Versions < ::Spoom::Coverage::Cards::Timeline
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

module Spoom::Coverage::D3
  class << self
    sig { params(palette: ::Spoom::Coverage::D3::ColorPalette).returns(::String) }
    def header_script(palette); end

    sig { returns(::String) }
    def header_style; end
  end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::D3::Base
  abstract!

  sig { params(id: ::String, data: T.untyped).void }
  def initialize(id, data); end

  sig { returns(::String) }
  def html; end

  sig { returns(::String) }
  def id; end

  # @abstract
  sig { abstract.returns(::String) }
  def script; end

  sig { returns(::String) }
  def tooltip; end

  class << self
    sig { returns(::String) }
    def header_script; end

    sig { returns(::String) }
    def header_style; end
  end
end

Spoom::Coverage::D3::COLOR_FALSE = T.let(T.unsafe(nil), String)
Spoom::Coverage::D3::COLOR_IGNORE = T.let(T.unsafe(nil), String)
Spoom::Coverage::D3::COLOR_STRICT = T.let(T.unsafe(nil), String)
Spoom::Coverage::D3::COLOR_STRONG = T.let(T.unsafe(nil), String)
Spoom::Coverage::D3::COLOR_TRUE = T.let(T.unsafe(nil), String)

class Spoom::Coverage::D3::CircleMap < ::Spoom::Coverage::D3::Base
  sig { override.returns(::String) }
  def script; end

  class << self
    sig { returns(::String) }
    def header_script; end

    sig { returns(::String) }
    def header_style; end
  end
end

class Spoom::Coverage::D3::CircleMap::Sigils < ::Spoom::Coverage::D3::CircleMap
  sig { params(id: ::String, sigils_tree: ::Spoom::FileTree).void }
  def initialize(id, sigils_tree); end

  sig { params(node: ::Spoom::FileTree::Node).returns(::Float) }
  def tree_node_score(node); end

  sig { params(node: ::Spoom::FileTree::Node).returns(T.nilable(::String)) }
  def tree_node_strictness(node); end

  sig { params(node: ::Spoom::FileTree::Node).returns(T::Hash[::Symbol, T.untyped]) }
  def tree_node_to_json(node); end
end

class Spoom::Coverage::D3::ColorPalette < ::T::Struct
  prop :false, ::String
  prop :ignore, ::String
  prop :strict, ::String
  prop :strong, ::String
  prop :true, ::String

  class << self
    def inherited(s); end
  end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::D3::Pie < ::Spoom::Coverage::D3::Base
  abstract!

  sig { params(id: ::String, title: ::String, data: T.untyped).void }
  def initialize(id, title, data); end

  sig { override.returns(::String) }
  def script; end

  class << self
    sig { returns(::String) }
    def header_script; end

    sig { returns(::String) }
    def header_style; end
  end
end

class Spoom::Coverage::D3::Pie::Calls < ::Spoom::Coverage::D3::Pie
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Pie::Sigils < ::Spoom::Coverage::D3::Pie
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Pie::Sigs < ::Spoom::Coverage::D3::Pie
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::D3::Timeline < ::Spoom::Coverage::D3::Base
  abstract!

  sig { params(id: ::String, data: T.untyped, keys: T::Array[::String]).void }
  def initialize(id, data, keys); end

  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def area(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # @abstract
  sig { abstract.returns(::String) }
  def plot; end

  sig { params(y: ::String).returns(::String) }
  def points(y:); end

  sig { override.returns(::String) }
  def script; end

  sig { returns(::String) }
  def x_scale; end

  sig { returns(::String) }
  def x_ticks; end

  sig { params(min: ::String, max: ::String, ticks: ::String).returns(::String) }
  def y_scale(min:, max:, ticks:); end

  sig { params(ticks: ::String, format: ::String, padding: ::Integer).returns(::String) }
  def y_ticks(ticks:, format:, padding:); end

  class << self
    sig { returns(::String) }
    def header_script; end

    sig { returns(::String) }
    def header_style; end
  end
end

class Spoom::Coverage::D3::Timeline::Calls < ::Spoom::Coverage::D3::Timeline::Stacked
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Timeline::RBIs < ::Spoom::Coverage::D3::Timeline::Stacked
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  sig { override.returns(::String) }
  def plot; end

  sig { override.returns(::String) }
  def script; end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Timeline::Runtimes < ::Spoom::Coverage::D3::Timeline
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.returns(::String) }
  def plot; end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Timeline::Sigils < ::Spoom::Coverage::D3::Timeline::Stacked
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.returns(::String) }
  def tooltip; end
end

class Spoom::Coverage::D3::Timeline::Sigs < ::Spoom::Coverage::D3::Timeline::Stacked
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::D3::Timeline::Stacked < ::Spoom::Coverage::D3::Timeline
  abstract!

  def initialize(*args, **_arg1, &blk); end

  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  sig { override.returns(::String) }
  def plot; end

  sig { override.returns(::String) }
  def script; end
end

class Spoom::Coverage::D3::Timeline::Versions < ::Spoom::Coverage::D3::Timeline
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  sig { override.returns(::String) }
  def plot; end

  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::Page < ::Spoom::Coverage::Template
  abstract!

  sig { params(title: ::String, palette: ::Spoom::Coverage::D3::ColorPalette, template: ::String).void }
  def initialize(title:, palette:, template: T.unsafe(nil)); end

  sig { returns(::String) }
  def body_html; end

  # @abstract
  sig { abstract.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  sig { returns(::String) }
  def footer_html; end

  sig { returns(::String) }
  def header_html; end

  sig { returns(::String) }
  def header_script; end

  sig { returns(::String) }
  def header_style; end

  sig { returns(::Spoom::Coverage::D3::ColorPalette) }
  def palette; end

  sig { returns(::String) }
  def title; end
end

Spoom::Coverage::Page::TEMPLATE = T.let(T.unsafe(nil), String)

class Spoom::Coverage::Report < ::Spoom::Coverage::Page
  sig do
    params(
      project_name: ::String,
      palette: ::Spoom::Coverage::D3::ColorPalette,
      snapshots: T::Array[::Spoom::Coverage::Snapshot],
      sigils_tree: ::Spoom::FileTree,
      sorbet_intro_commit: T.nilable(::String),
      sorbet_intro_date: T.nilable(::Time)
    ).void
  end
  def initialize(project_name:, palette:, snapshots:, sigils_tree:, sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  sig { override.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  sig { override.returns(::String) }
  def header_html; end

  sig { returns(::String) }
  def project_name; end

  sig { returns(::Spoom::FileTree) }
  def sigils_tree; end

  sig { returns(T::Array[::Spoom::Coverage::Snapshot]) }
  def snapshots; end

  sig { returns(T.nilable(::String)) }
  def sorbet_intro_commit; end

  sig { returns(T.nilable(::Time)) }
  def sorbet_intro_date; end
end

class Spoom::Coverage::Snapshot < ::T::Struct
  prop :calls_typed, ::Integer, default: T.unsafe(nil)
  prop :calls_untyped, ::Integer, default: T.unsafe(nil)
  prop :classes, ::Integer, default: T.unsafe(nil)
  prop :commit_sha, T.nilable(::String), default: T.unsafe(nil)
  prop :commit_timestamp, T.nilable(::Integer), default: T.unsafe(nil)
  prop :duration, ::Integer, default: T.unsafe(nil)
  prop :files, ::Integer, default: T.unsafe(nil)
  prop :methods_with_sig, ::Integer, default: T.unsafe(nil)
  prop :methods_without_sig, ::Integer, default: T.unsafe(nil)
  prop :modules, ::Integer, default: T.unsafe(nil)
  prop :rbi_files, ::Integer, default: T.unsafe(nil)
  prop :sigils, T::Hash[::String, ::Integer], default: T.unsafe(nil)
  prop :singleton_classes, ::Integer, default: T.unsafe(nil)
  prop :timestamp, ::Integer, default: T.unsafe(nil)
  prop :version_runtime, T.nilable(::String), default: T.unsafe(nil)
  prop :version_static, T.nilable(::String), default: T.unsafe(nil)

  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def print(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  sig { params(arg: T.untyped).returns(::String) }
  def to_json(*arg); end

  class << self
    sig { params(json: ::String).returns(::Spoom::Coverage::Snapshot) }
    def from_json(json); end

    sig { params(obj: T::Hash[::String, T.untyped]).returns(::Spoom::Coverage::Snapshot) }
    def from_obj(obj); end

    def inherited(s); end
  end
end

# The strictness name as found in the Sorbet metrics file
Spoom::Coverage::Snapshot::STRICTNESSES = T.let(T.unsafe(nil), Array)

class Spoom::Coverage::SnapshotPrinter < ::Spoom::Printer
  sig { params(snapshot: ::Spoom::Coverage::Snapshot).void }
  def print_snapshot(snapshot); end

  private

  sig { params(value: T.nilable(::Integer), total: T.nilable(::Integer)).returns(::String) }
  def percent(value, total); end

  sig { params(hash: T::Hash[::String, ::Integer], total: ::Integer).void }
  def print_map(hash, total); end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Coverage::Template
  abstract!

  # Create a new template from an Erb file path
  sig { params(template: ::String).void }
  def initialize(template:); end

  sig { returns(::String) }
  def erb; end

  sig { returns(::Binding) }
  def get_binding; end

  sig { returns(::String) }
  def html; end
end

class Spoom::Error < ::StandardError; end

class Spoom::ExecResult < ::T::Struct
  const :err, ::String
  const :exit_code, ::Integer
  const :out, ::String
  const :status, T::Boolean

  sig { returns(::String) }
  def to_s; end

  class << self
    def inherited(s); end
  end
end

# Build a file hierarchy from a set of file paths.
class Spoom::FileTree
  sig { params(paths: T::Enumerable[::String], strip_prefix: T.nilable(::String)).void }
  def initialize(paths = T.unsafe(nil), strip_prefix: T.unsafe(nil)); end

  # Add a `path` to the tree
  #
  # This will create all nodes until the root of `path`.
  sig { params(path: ::String).returns(::Spoom::FileTree::Node) }
  def add_path(path); end

  # Add all `paths` to the tree
  sig { params(paths: T::Enumerable[::String]).void }
  def add_paths(paths); end

  # All the nodes in this tree
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def nodes; end

  # All the paths in this tree
  sig { returns(T::Array[::String]) }
  def paths; end

  sig do
    params(
      out: T.any(::IO, ::StringIO),
      show_strictness: T::Boolean,
      colors: T::Boolean,
      indent_level: ::Integer
    ).void
  end
  def print(out: T.unsafe(nil), show_strictness: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # All root nodes
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def roots; end

  sig { returns(T.nilable(::String)) }
  def strip_prefix; end

  private

  sig do
    params(
      node: ::Spoom::FileTree::Node,
      collected_nodes: T::Array[::Spoom::FileTree::Node]
    ).returns(T::Array[::Spoom::FileTree::Node])
  end
  def collect_nodes(node, collected_nodes = T.unsafe(nil)); end
end

# A node representing either a file or a directory inside a FileTree
class Spoom::FileTree::Node < ::T::Struct
  const :children, T::Hash[::String, ::Spoom::FileTree::Node], default: T.unsafe(nil)
  const :name, ::String
  const :parent, T.nilable(::Spoom::FileTree::Node)

  # Full path to this node from root
  sig { returns(::String) }
  def path; end

  class << self
    def inherited(s); end
  end
end

# An internal class used to print a FileTree
#
# See `FileTree#print`
class Spoom::FileTree::TreePrinter < ::Spoom::Printer
  sig do
    params(
      tree: ::Spoom::FileTree,
      out: T.any(::IO, ::StringIO),
      show_strictness: T::Boolean,
      colors: T::Boolean,
      indent_level: ::Integer
    ).void
  end
  def initialize(tree:, out: T.unsafe(nil), show_strictness: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  sig { params(node: ::Spoom::FileTree::Node).void }
  def print_node(node); end

  sig { params(nodes: T::Array[::Spoom::FileTree::Node]).void }
  def print_nodes(nodes); end

  sig { void }
  def print_tree; end

  sig { returns(::Spoom::FileTree) }
  def tree; end

  private

  sig { params(node: ::Spoom::FileTree::Node).returns(T.nilable(::String)) }
  def node_strictness(node); end

  sig { params(strictness: T.nilable(::String)).returns(::Spoom::Color) }
  def strictness_color(strictness); end
end

# Execute git commands
module Spoom::Git
  class << self
    # Git commands
    sig { params(arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def checkout(*arg, path: T.unsafe(nil)); end

    # Get the commit Time for a `sha`
    sig { params(sha: ::String, path: ::String).returns(T.nilable(::Time)) }
    def commit_time(sha, path: T.unsafe(nil)); end

    # Get the commit epoch timestamp for a `sha`
    sig { params(sha: ::String, path: ::String).returns(T.nilable(::Integer)) }
    def commit_timestamp(sha, path: T.unsafe(nil)); end

    sig { params(path: ::String).returns(T.nilable(::String)) }
    def current_branch(path: T.unsafe(nil)); end

    sig { params(arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def diff(*arg, path: T.unsafe(nil)); end

    # Translate a git epoch timestamp into a Time
    sig { params(timestamp: ::String).returns(::Time) }
    def epoch_to_time(timestamp); end

    # Execute a `command`
    sig { params(command: ::String, arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def exec(command, *arg, path: T.unsafe(nil)); end

    # Get the last commit sha
    sig { params(path: ::String).returns(T.nilable(::String)) }
    def last_commit(path: T.unsafe(nil)); end

    sig { params(arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def log(*arg, path: T.unsafe(nil)); end

    sig { params(arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def rev_parse(*arg, path: T.unsafe(nil)); end

    sig { params(arg: ::String, path: ::String).returns(::Spoom::ExecResult) }
    def show(*arg, path: T.unsafe(nil)); end

    # Get the hash of the commit introducing the `sorbet/config` file
    sig { params(path: ::String).returns(T.nilable(::String)) }
    def sorbet_intro_commit(path: T.unsafe(nil)); end

    # Get the hash of the commit removing the `sorbet/config` file
    sig { params(path: ::String).returns(T.nilable(::String)) }
    def sorbet_removal_commit(path: T.unsafe(nil)); end

    # Is there uncommited changes in `path`?
    sig { params(path: ::String).returns(T::Boolean) }
    def workdir_clean?(path: T.unsafe(nil)); end
  end
end

module Spoom::LSP; end

class Spoom::LSP::Client
  sig { params(sorbet_bin: ::String, sorbet_args: ::String, path: ::String).void }
  def initialize(sorbet_bin, *sorbet_args, path: T.unsafe(nil)); end

  sig { void }
  def close; end

  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def definitions(uri, line, column); end

  sig { params(uri: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def document_symbols(uri); end

  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T.nilable(::Spoom::LSP::Hover)) }
  def hover(uri, line, column); end

  sig { returns(::Integer) }
  def next_id; end

  # LSP requests
  #
  # @raise [Error::AlreadyOpen]
  sig { params(workspace_path: ::String).void }
  def open(workspace_path); end

  sig { returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def read; end

  # @raise [Error::BadHeaders]
  sig { returns(T.nilable(::String)) }
  def read_raw; end

  sig do
    params(
      uri: ::String,
      line: ::Integer,
      column: ::Integer,
      include_decl: T::Boolean
    ).returns(T::Array[::Spoom::LSP::Location])
  end
  def references(uri, line, column, include_decl = T.unsafe(nil)); end

  sig { params(message: ::Spoom::LSP::Message).returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def send(message); end

  sig { params(json_string: ::String).void }
  def send_raw(json_string); end

  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::SignatureHelp]) }
  def signatures(uri, line, column); end

  sig { params(query: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def symbols(query); end

  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def type_definitions(uri, line, column); end
end

class Spoom::LSP::Diagnostic < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :code, ::Integer
  const :informations, ::Object
  const :message, ::String
  const :range, ::Spoom::LSP::Range

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Diagnostic) }
    def from_json(json); end

    def inherited(s); end
  end
end

class Spoom::LSP::DocumentSymbol < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :children, T::Array[::Spoom::LSP::DocumentSymbol]
  const :detail, T.nilable(::String)
  const :kind, ::Integer
  const :location, T.nilable(::Spoom::LSP::Location)
  const :name, ::String
  const :range, T.nilable(::Spoom::LSP::Range)

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def kind_string; end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::DocumentSymbol) }
    def from_json(json); end

    def inherited(s); end
  end
end

Spoom::LSP::DocumentSymbol::SYMBOL_KINDS = T.let(T.unsafe(nil), Hash)
class Spoom::LSP::Error < ::StandardError; end
class Spoom::LSP::Error::AlreadyOpen < ::Spoom::LSP::Error; end
class Spoom::LSP::Error::BadHeaders < ::Spoom::LSP::Error; end

class Spoom::LSP::Error::Diagnostics < ::Spoom::LSP::Error
  sig { params(uri: ::String, diagnostics: T::Array[::Spoom::LSP::Diagnostic]).void }
  def initialize(uri, diagnostics); end

  sig { returns(T::Array[::Spoom::LSP::Diagnostic]) }
  def diagnostics; end

  sig { returns(::String) }
  def uri; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Error::Diagnostics) }
    def from_json(json); end
  end
end

class Spoom::LSP::Hover < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :contents, ::String
  const :range, T.nilable(T::Range[T.untyped])

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Hover) }
    def from_json(json); end

    def inherited(s); end
  end
end

class Spoom::LSP::Location < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :range, ::Spoom::LSP::Range
  const :uri, ::String

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Location) }
    def from_json(json); end

    def inherited(s); end
  end
end

# A general message as defined by JSON-RPC.
#
# The language server protocol always uses `"2.0"` as the `jsonrpc` version.
class Spoom::LSP::Message
  sig { void }
  def initialize; end

  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def as_json; end

  sig { returns(::String) }
  def jsonrpc; end

  sig { params(args: T.untyped).returns(::String) }
  def to_json(*args); end
end

# A notification message.
#
# A processed notification message must not send a response back. They work like events.
class Spoom::LSP::Notification < ::Spoom::LSP::Message
  sig { params(method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(method, params); end

  sig { returns(::String) }
  def method; end

  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

class Spoom::LSP::Position < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :char, ::Integer
  const :line, ::Integer

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Position) }
    def from_json(json); end

    def inherited(s); end
  end
end

# @abstract Subclasses must implement the `abstract` methods below.
module Spoom::LSP::PrintableSymbol
  interface!

  # @abstract
  sig { abstract.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end
end

class Spoom::LSP::Range < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :end, ::Spoom::LSP::Position
  const :start, ::Spoom::LSP::Position

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Range) }
    def from_json(json); end

    def inherited(s); end
  end
end

# A request message to describe a request between the client and the server.
#
# Every processed request must send a response back to the sender of the request.
class Spoom::LSP::Request < ::Spoom::LSP::Message
  sig { params(id: ::Integer, method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(id, method, params); end

  sig { returns(::Integer) }
  def id; end

  sig { returns(::String) }
  def method; end

  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

class Spoom::LSP::ResponseError < ::Spoom::LSP::Error
  sig { params(code: ::Integer, message: ::String, data: T::Hash[T.untyped, T.untyped]).void }
  def initialize(code, message, data); end

  sig { returns(::Integer) }
  def code; end

  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def data; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::ResponseError) }
    def from_json(json); end
  end
end

class Spoom::LSP::SignatureHelp < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :doc, ::Object
  const :label, T.nilable(::String)
  const :params, T::Array[T.untyped]

  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  sig { returns(::String) }
  def to_s; end

  class << self
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::SignatureHelp) }
    def from_json(json); end

    def inherited(s); end
  end
end

class Spoom::LSP::SymbolPrinter < ::Spoom::Printer
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      colors: T::Boolean,
      indent_level: ::Integer,
      prefix: T.nilable(::String)
    ).void
  end
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil), prefix: T.unsafe(nil)); end

  sig { params(uri: ::String).returns(::String) }
  def clean_uri(uri); end

  sig { returns(T.nilable(::String)) }
  def prefix; end

  # @return [String, nil]
  def prefix=(_arg0); end

  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_list(objects); end

  sig { params(object: T.nilable(::Spoom::LSP::PrintableSymbol)).void }
  def print_object(object); end

  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_objects(objects); end

  sig { returns(T::Set[::Integer]) }
  def seen; end

  # @return [Set<Integer>]
  def seen=(_arg0); end
end

# @abstract It cannont be directly instantiated. Subclasses must implement the `abstract` methods below.
class Spoom::Printer
  include ::Spoom::Colorize

  abstract!

  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # Colorize `string` with color if `@colors`
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  # Decrease indent level
  sig { void }
  def dedent; end

  # Increase indent level
  sig { void }
  def indent; end

  sig { returns(T.any(::IO, ::StringIO)) }
  def out; end

  # @return [IO, StringIO]
  def out=(_arg0); end

  # Print `string` into `out`
  sig { params(string: T.nilable(::String)).void }
  def print(string); end

  # Print `string` colored with `color` into `out`
  #
  # Does not use colors unless `@colors`.
  sig { params(string: T.nilable(::String), color: ::Spoom::Color).void }
  def print_colored(string, *color); end

  # Print `string` with indent and newline
  sig { params(string: T.nilable(::String)).void }
  def printl(string); end

  # Print a new line into `out`
  sig { void }
  def printn; end

  # Print an indent space into `out`
  sig { void }
  def printt; end
end

Spoom::SPOOM_PATH = T.let(T.unsafe(nil), String)

module Spoom::Sorbet
  class << self
    sig do
      params(
        arg: ::String,
        path: ::String,
        capture_err: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(::Spoom::ExecResult)
    end
    def srb(*arg, path: T.unsafe(nil), capture_err: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end

    # List all files typechecked by Sorbet from its `config`
    sig { params(config: ::Spoom::Sorbet::Config, path: ::String).returns(T::Array[::String]) }
    def srb_files(config, path: T.unsafe(nil)); end

    sig do
      params(
        arg: ::String,
        path: ::String,
        capture_err: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(T.nilable(T::Hash[::String, ::Integer]))
    end
    def srb_metrics(*arg, path: T.unsafe(nil), capture_err: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end

    sig do
      params(
        arg: ::String,
        path: ::String,
        capture_err: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(::Spoom::ExecResult)
    end
    def srb_tc(*arg, path: T.unsafe(nil), capture_err: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end

    sig do
      params(
        arg: ::String,
        path: ::String,
        capture_err: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(T.nilable(::String))
    end
    def srb_version(*arg, path: T.unsafe(nil), capture_err: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end

    # Get `gem` version from the `Gemfile.lock` content
    #
    # Returns `nil` if `gem` cannot be found in the Gemfile.
    sig { params(gem: ::String, path: ::String).returns(T.nilable(::String)) }
    def version_from_gemfile_lock(gem: T.unsafe(nil), path: T.unsafe(nil)); end
  end
end

Spoom::Sorbet::BIN_PATH = T.let(T.unsafe(nil), String)
Spoom::Sorbet::CONFIG_PATH = T.let(T.unsafe(nil), String)

# Parse Sorbet config files
#
# Parses a Sorbet config file:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_file("sorbet/config")
# puts config.paths   # "."
# ```
#
# Parses a Sorbet config string:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_string(<<~CONFIG)
#   a
#   --file=b
#   --ignore=c
# CONFIG
# puts config.paths   # "a", "b"
# puts config.ignore  # "c"
# ```
class Spoom::Sorbet::Config
  sig { void }
  def initialize; end

  # @return [Array<String>]
  def allowed_extensions; end

  sig { returns(::Spoom::Sorbet::Config) }
  def copy; end

  # @return [Array<String>]
  def ignore; end

  sig { returns(T::Boolean) }
  def no_stdlib; end

  # @return [Boolean]
  def no_stdlib=(_arg0); end

  # Returns self as a string of options that can be passed to Sorbet
  #
  # Example:
  # ~~~rb
  # config = Sorbet::Config.new
  # config.paths << "/foo"
  # config.paths << "/bar"
  # config.ignore << "/baz"
  # config.allowed_extensions << ".rb"
  #
  # puts config.options_string # "/foo /bar --ignore /baz --allowed-extension .rb"
  # ~~~
  sig { returns(::String) }
  def options_string; end

  sig { returns(T::Array[::String]) }
  def paths; end

  class << self
    sig { params(sorbet_config_path: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_file(sorbet_config_path); end

    sig { params(sorbet_config: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_string(sorbet_config); end

    private

    sig { params(line: ::String).returns(::String) }
    def parse_option(line); end
  end
end

module Spoom::Sorbet::Errors
  class << self
    sig { params(errors: T::Array[::Spoom::Sorbet::Errors::Error]).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def sort_errors_by_code(errors); end
  end
end

Spoom::Sorbet::Errors::DEFAULT_ERROR_URL_BASE = T.let(T.unsafe(nil), String)

class Spoom::Sorbet::Errors::Error
  include ::Comparable

  sig do
    params(
      file: T.nilable(::String),
      line: T.nilable(::Integer),
      message: T.nilable(::String),
      code: T.nilable(::Integer),
      more: T::Array[::String]
    ).void
  end
  def initialize(file, line, message, code, more = T.unsafe(nil)); end

  # By default errors are sorted by location
  sig { params(other: T.untyped).returns(::Integer) }
  def <=>(other); end

  # @return [Integer, nil]
  def code; end

  sig { returns(T.nilable(::String)) }
  def file; end

  # Other files associated with the error
  sig { returns(T::Set[::String]) }
  def files_from_error_sections; end

  sig { returns(T.nilable(::Integer)) }
  def line; end

  # @return [String, nil]
  def message; end

  sig { returns(T::Array[::String]) }
  def more; end

  sig { returns(::String) }
  def to_s; end
end

# Parse errors from Sorbet output
class Spoom::Sorbet::Errors::Parser
  sig { params(error_url_base: ::String).void }
  def initialize(error_url_base: T.unsafe(nil)); end

  sig { params(output: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
  def parse(output); end

  private

  sig { params(line: ::String).void }
  def append_error(line); end

  sig { void }
  def close_error; end

  sig { params(error_url_base: ::String).returns(::Regexp) }
  def error_line_match_regexp(error_url_base); end

  sig { params(line: ::String).returns(T.nilable(::Spoom::Sorbet::Errors::Error)) }
  def match_error_line(line); end

  sig { params(error: ::Spoom::Sorbet::Errors::Error).void }
  def open_error(error); end

  class << self
    sig { params(output: ::String, error_url_base: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def parse_string(output, error_url_base: T.unsafe(nil)); end
  end
end

Spoom::Sorbet::Errors::Parser::HEADER = T.let(T.unsafe(nil), Array)
Spoom::Sorbet::GEM_PATH = T.let(T.unsafe(nil), String)

module Spoom::Sorbet::MetricsParser
  class << self
    sig { params(path: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_file(path, prefix = T.unsafe(nil)); end

    sig { params(obj: T::Hash[::String, T.untyped], prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_hash(obj, prefix = T.unsafe(nil)); end

    sig { params(string: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_string(string, prefix = T.unsafe(nil)); end
  end
end

Spoom::Sorbet::MetricsParser::DEFAULT_PREFIX = T.let(T.unsafe(nil), String)
Spoom::Sorbet::SEGFAULT_CODE = T.let(T.unsafe(nil), Integer)

module Spoom::Sorbet::Sigils
  class << self
    # changes the sigil in the file at the passed path to the specified new strictness
    sig { params(path: T.any(::Pathname, ::String), new_strictness: ::String).returns(T::Boolean) }
    def change_sigil_in_file(path, new_strictness); end

    # changes the sigil to have a new strictness in a list of files
    sig { params(path_list: T::Array[::String], new_strictness: ::String).returns(T::Array[::String]) }
    def change_sigil_in_files(path_list, new_strictness); end

    # returns a string containing the strictness of a sigil in a file at the passed path
    # * returns nil if no sigil
    sig { params(path: T.any(::Pathname, ::String)).returns(T.nilable(::String)) }
    def file_strictness(path); end

    # finds all files in the specified directory with the passed strictness
    sig do
      params(
        directory: T.any(::Pathname, ::String),
        strictness: ::String,
        extension: ::String
      ).returns(T::Array[::String])
    end
    def files_with_sigil_strictness(directory, strictness, extension: T.unsafe(nil)); end

    # returns the full sigil comment string for the passed strictness
    sig { params(strictness: ::String).returns(::String) }
    def sigil_string(strictness); end

    # returns the strictness of a sigil in the passed file content string (nil if no sigil)
    sig { params(content: ::String).returns(T.nilable(::String)) }
    def strictness_in_content(content); end

    # returns a string which is the passed content but with the sigil updated to a new strictness
    sig { params(content: ::String, new_strictness: ::String).returns(::String) }
    def update_sigil(content, new_strictness); end

    # returns true if the passed string is a valid strictness (else false)
    sig { params(strictness: ::String).returns(T::Boolean) }
    def valid_strictness?(strictness); end
  end
end

Spoom::Sorbet::Sigils::SIGIL_REGEXP = T.let(T.unsafe(nil), Regexp)
Spoom::Sorbet::Sigils::STRICTNESS_FALSE = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::STRICTNESS_IGNORE = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::STRICTNESS_INTERNAL = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::STRICTNESS_STRICT = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::STRICTNESS_STRONG = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::STRICTNESS_TRUE = T.let(T.unsafe(nil), String)
Spoom::Sorbet::Sigils::VALID_STRICTNESS = T.let(T.unsafe(nil), Array)

class Spoom::Timeline
  sig { params(from: ::Time, to: ::Time, path: ::String).void }
  def initialize(from, to, path: T.unsafe(nil)); end

  # Return one commit for each date in `dates`
  sig { params(dates: T::Array[::Time]).returns(T::Array[::String]) }
  def commits_for_dates(dates); end

  # Return all months between `from` and `to`
  sig { returns(T::Array[::Time]) }
  def months; end

  # Return one commit for each month between `from` and `to`
  sig { returns(T::Array[::String]) }
  def ticks; end
end

Spoom::VERSION = T.let(T.unsafe(nil), String)
