# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sawyer` gem.
# Please instead update this file by running `bin/tapioca gem sawyer`.

module Sawyer; end

class Sawyer::Agent
  # Agents handle making the requests, and passing responses to
  # Sawyer::Response.
  #
  # endpoint - String URI of the API entry point.
  # options  - Hash of options.
  #            :allow_undefined_methods  - Allow relations to call all the HTTP verbs,
  #                                        not just the ones defined.
  #            :faraday                  - Optional Faraday::Connection to use.
  #            :links_parser             - Optional parser to parse link relations
  #                                        Defaults: Sawyer::LinkParsers::Hal.new
  #            :serializer               - Optional serializer Class.  Defaults to
  #                                        self.serializer_class.
  #
  # Yields the Faraday::Connection if a block is given.
  #
  # @return [Agent] a new instance of Agent
  # @yield [@conn]
  def initialize(endpoint, options = T.unsafe(nil)); end

  # Returns the value of attribute allow_undefined_methods.
  def allow_undefined_methods; end

  # Sets the attribute allow_undefined_methods
  #
  # @param value the value to set the attribute allow_undefined_methods to.
  def allow_undefined_methods=(_arg0); end

  # @return [Boolean]
  def allow_undefined_methods?; end

  # Makes a request through Faraday.
  #
  # method  - The Symbol name of an HTTP method.
  # url     - The String URL to access.  This can be relative to the Agent's
  #           endpoint.
  # data    - The Optional Hash or Resource body to be sent.  :get or :head
  #           requests can have no body, so this can be the options Hash
  #           instead.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #
  # Returns a Sawyer::Response.
  def call(method, url, data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Public: Close the underlying connection.
  def close; end

  # Decodes a String response body to a resource.
  #
  # str - The String body from the response.
  #
  # Returns an Object resource (Hash by default).
  def decode_body(str); end

  # Encodes an object to a string for the API request.
  #
  # data - The Hash or Resource that is being sent.
  #
  # Returns a String.
  def encode_body(data); end

  def expand_url(url, options = T.unsafe(nil)); end
  def inspect; end

  # Returns the value of attribute links_parser.
  def links_parser; end

  # Sets the attribute links_parser
  #
  # @param value the value to set the attribute links_parser to.
  def links_parser=(_arg0); end

  def marshal_dump; end
  def marshal_load(dumped); end
  def parse_links(data); end

  # Public: Retains a reference to the root relations of the API.
  #
  # Returns a Sawyer::Relation::Map.
  def rels; end

  # Public: Retains a reference to the root response of the API.
  #
  # Returns a Sawyer::Response.
  def root; end

  # Public: Hits the root of the API to get the initial actions.
  #
  # Returns a Sawyer::Response.
  def start; end

  # private
  def to_yaml_properties; end

  class << self
    def decode(data); end
    def encode(data); end
    def serializer; end

    # Sets the attribute serializer
    #
    # @param value the value to set the attribute serializer to.
    def serializer=(_arg0); end
  end
end

Sawyer::Agent::NO_BODY = T.let(T.unsafe(nil), Set)
class Sawyer::Error < ::StandardError; end
module Sawyer::LinkParsers; end

class Sawyer::LinkParsers::Hal
  def parse(data); end
end

class Sawyer::LinkParsers::Simple
  # Public: Parses simple *_url style links on resources
  #
  # data   - Hash of resource data
  #
  # Returns a Hash of data with separate links Hash
  def parse(data); end
end

Sawyer::LinkParsers::Simple::LINK_REGEX = T.let(T.unsafe(nil), Regexp)

class Sawyer::Relation
  # A Relation represents an available next action for a resource.
  #
  # agent  - The Sawyer::Agent that made the request.
  # name   - The Symbol name of the relation.
  # href   - The String URL of the location of the next action.
  # method - The Symbol HTTP method.  Default: :get
  #
  # @return [Relation] a new instance of Relation
  def initialize(agent, name, href, method = T.unsafe(nil)); end

  # Returns the value of attribute agent.
  def agent; end

  # Returns the value of attribute available_methods.
  def available_methods; end

  # Public: Makes an API request with the curent Relation.
  #
  # data    - The Optional Hash or Resource body to be sent.  :get or :head
  #           requests can have no body, so this can be the options Hash
  #           instead.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Raises ArgumentError if the :method value is not in @available_methods.
  # Returns a Sawyer::Response.
  def call(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using DELETE.
  #
  # data    - The Optional Hash or Resource body to be sent.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def delete(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using GET.
  #
  # data    - The Optional Hash or Resource body to be sent.  :get or :head
  #           requests can have no body, so this can be the options Hash
  #           instead.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def get(options = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using HEAD.
  #
  # data    - The Optional Hash or Resource body to be sent.  :get or :head
  #           requests can have no body, so this can be the options Hash
  #           instead.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def head(options = T.unsafe(nil)); end

  def href(options = T.unsafe(nil)); end

  # Returns the value of attribute href_template.
  def href_template; end

  def inspect; end

  # Returns the value of attribute method.
  def method; end

  # Returns the value of attribute name.
  def name; end

  # Public: Makes an API request with the curent Relation using OPTIONS.
  #
  # data    - The Optional Hash or Resource body to be sent.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def options(data = T.unsafe(nil), opt = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using PATCH.
  #
  # data    - The Optional Hash or Resource body to be sent.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def patch(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using POST.
  #
  # data    - The Optional Hash or Resource body to be sent.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def post(data = T.unsafe(nil), options = T.unsafe(nil)); end

  # Public: Makes an API request with the curent Relation using PUT.
  #
  # data    - The Optional Hash or Resource body to be sent.
  # options - Hash of option to configure the API request.
  #           :headers - Hash of API headers to set.
  #           :query   - Hash of URL query params to set.
  #           :method  - Symbol HTTP method.
  #
  # Returns a Sawyer::Response.
  def put(data = T.unsafe(nil), options = T.unsafe(nil)); end

  class << self
    # Public: Builds a single Relation from the given options.  These are
    # usually taken from a `_links` property in a resource.
    #
    # agent   - The Sawyer::Agent that made the request.
    # name    - The Symbol name of the Relation.
    # options - A Hash containing the other Relation properties.
    #           :href   - The String URL of the next action's location.
    #           :method - The optional String HTTP method.
    #
    # Returns a Relation.
    def from_link(agent, name, options); end

    # Public: Builds an index of Relations from the value of a `_links`
    # property in a resource.  :get is the default method.  Any links with
    # multiple specified methods will get multiple relations created.
    #
    # index - The Hash mapping Relation names to the Hash Relation
    #         options.
    # rels  - A Relation::Map to store the Relations.
    #
    # Returns a Relation::Map
    def from_links(agent, index, rels = T.unsafe(nil)); end
  end
end

class Sawyer::Relation::Map
  # Tracks the available next actions for a resource, and
  # issues requests for them.
  #
  # @return [Map] a new instance of Map
  def initialize; end

  # Adds a Relation to the map.
  #
  # rel - A Relation.
  #
  # Returns nothing.
  def <<(rel); end

  # Gets the raw Relation by its name.
  #
  # key - The Symbol name of the Relation.
  #
  # Returns a Relation.
  def [](key); end

  def inspect; end

  # Gets a list of the Relation names.
  #
  # Returns an Array of Symbols in no specific order.
  def keys; end

  # Gets the number of mapped Relations.
  #
  # Returns an Integer.
  def size; end

  def to_h; end
  def to_hash; end
end

class Sawyer::Resource
  include ::Enumerable
  extend ::Forwardable

  # Initializes a Resource with the given data.
  #
  # agent - The Sawyer::Agent that made the API request.
  # data  - Hash of key/value properties.
  #
  # @return [Resource] a new instance of Resource
  def initialize(agent, data = T.unsafe(nil)); end

  # Allow fields to be retrieved via Hash notation
  #
  # method - key name
  #
  # Returns the value from attrs if exists
  def [](method); end

  # Allow fields to be set via Hash notation
  #
  # method - key name
  # value - value to set for the attr key
  #
  # Returns - value
  def []=(method, value); end

  # Returns the value of attribute _agent.
  def _agent; end

  # Returns the value of attribute _fields.
  def _fields; end

  # Returns the value of attribute _rels.
  def _rels; end

  # Returns the value of attribute attrs.
  def attrs; end

  def dig(*args, **_arg1, &block); end
  def each(&block); end
  def fetch(*args, **_arg1, &block); end
  def inspect; end

  # Checks to see if the given key is in this resource.
  #
  # key - A Symbol key.
  #
  # Returns true if the key exists, or false.
  #
  # @return [Boolean]
  def key?(key); end

  def marshal_dump; end
  def marshal_load(dumped); end

  # Provides access to a resource's attributes.
  def method_missing(method, *args); end

  # Processes an individual value of this resource.  Hashes get exploded
  # into another Resource, and Arrays get their values processed too.
  #
  # value - An Object value of a Resource's data.
  #
  # Returns an Object to set as the value of a Resource key.
  def process_value(value); end

  def to_attrs; end
  def to_h; end
  def to_hash; end

  # private
  def to_yaml_properties; end

  class << self
    # Wire up accessor methods to pull from attrs
    def attr_accessor(*attrs); end
  end
end

Sawyer::Resource::ATTR_PREDICATE = T.let(T.unsafe(nil), String)
Sawyer::Resource::ATTR_SETTER = T.let(T.unsafe(nil), String)
Sawyer::Resource::SPECIAL_METHODS = T.let(T.unsafe(nil), Set)

class Sawyer::Response
  # Builds a Response after a completed request.
  #
  # agent - The Sawyer::Agent that is managing the API connection.
  # res   - A Faraday::Response.
  #
  # @return [Response] a new instance of Response
  def initialize(agent, res, options = T.unsafe(nil)); end

  # Returns the value of attribute agent.
  def agent; end

  # Returns the value of attribute body.
  def body; end

  def data; end

  # Returns the value of attribute env.
  def env; end

  # Returns the value of attribute headers.
  def headers; end

  def inspect; end

  # Turns parsed contents from an API response into a Resource or
  # collection of Resources.
  #
  # data - Either an Array or Hash parsed from JSON.
  #
  # Returns either a Resource or Array of Resources.
  def process_data(data); end

  # Finds link relations from 'Link' response header
  #
  # Returns an array of Relations
  def process_rels; end

  # Returns the value of attribute rels.
  def rels; end

  # Returns the value of attribute status.
  def status; end

  def time; end
  def timing; end
end

class Sawyer::Serializer
  # Public: Wraps a serialization format for Sawyer.  Nested objects are
  # prepared for serialization (such as changing Times to ISO 8601 Strings).
  # Any serialization format that responds to #dump and #load will work.
  #
  # @return [Serializer] a new instance of Serializer
  def initialize(format, dump_method_name = T.unsafe(nil), load_method_name = T.unsafe(nil)); end

  # Public: Decodes a String into an Object (usually a Hash or Array of
  # Hashes).
  #
  # data - An encoded String.
  #
  # Returns a decoded Object.
  def decode(data); end

  def decode_hash(hash); end
  def decode_hash_value(key, value); end
  def decode_object(data); end

  # Public: Encodes an Object (usually a Hash or Array of Hashes).
  #
  # data - Object to be encoded.
  #
  # Returns an encoded String.
  def dump(data); end

  # Public: Encodes an Object (usually a Hash or Array of Hashes).
  #
  # data - Object to be encoded.
  #
  # Returns an encoded String.
  def encode(data); end

  def encode_hash(hash); end
  def encode_object(data); end

  # Public: Decodes a String into an Object (usually a Hash or Array of
  # Hashes).
  #
  # data - An encoded String.
  #
  # Returns a decoded Object.
  def load(data); end

  # @return [Boolean]
  def time_field?(key, value); end

  class << self
    def any_json; end
    def json; end
    def message_pack; end
    def multi_json; end
    def yajl; end
  end
end

Sawyer::VERSION = T.let(T.unsafe(nil), String)
