# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop` gem.
# Please instead update this file by running `bin/tapioca gem rubocop`.

class Parser::Source::Range
  include ::RuboCop::Ext::Range
end

class Regexp::Expression::Base
  include ::RuboCop::Ext::RegexpParser::Expression::Base
end

class Regexp::Expression::CharacterSet < ::Regexp::Expression::Subexpression
  include ::RuboCop::Ext::RegexpParser::Expression::CharacterSet
end

module RuboCop; end

class RuboCop::AST::ProcessedSource
  include ::RuboCop::Ext::ProcessedSource
end

class RuboCop::AST::RegexpNode < ::RuboCop::AST::Node
  include ::RuboCop::Ext::RegexpNode
end

# The CLI is a class responsible of handling all the command line interface
# logic.
class RuboCop::CLI
  # @return [CLI] a new instance of CLI
  def initialize; end

  # Returns the value of attribute config_store.
  def config_store; end

  # Returns the value of attribute options.
  def options; end

  # Entry point for the application logic. Here we
  # do the command line arguments processing and inspect
  # the target files.
  #
  #
  # @api public
  # @param args [Array<String>] command line arguments
  # @return [Integer] UNIX exit code
  def run(args = T.unsafe(nil)); end

  private

  def act_on_options; end
  def apply_default_formatter; end
  def execute_runners; end

  # @raise [Finished]
  def handle_exiting_options; end

  def parallel_by_default!; end
  def run_command(name); end
  def set_options_to_config_loader; end
  def suggest_extensions; end

  # @raise [OptionArgumentError]
  def validate_options_vs_config; end
end

# Home of subcommands in the CLI.
#
# @api private
module RuboCop::CLI::Command
  class << self
    # Find the command with a given name and run it in an environment.
    #
    # @api private
    def run(env, name); end

    private

    # @api private
    def class_for(name); end
  end
end

# Generate a configuration file acting as a TODO list.
#
# @api private
class RuboCop::CLI::Command::AutoGenerateConfig < ::RuboCop::CLI::Command::Base
  # @api private
  def run; end

  private

  # @api private
  def add_formatter; end

  # @api private
  def add_inheritance_from_auto_generated_file(config_file); end

  # @api private
  def execute_runner; end

  # @api private
  def existing_configuration(config_file); end

  # @api private
  def line_length_cop(config); end

  # @api private
  # @return [Boolean]
  def line_length_enabled?(config); end

  # @api private
  def max_line_length(config); end

  # @api private
  def maybe_run_line_length_cop; end

  # @api private
  # @return [Boolean]
  def options_config_in_root?; end

  # @api private
  def relative_path_to_todo_from_options_config; end

  # @api private
  def reset_config_and_auto_gen_file; end

  # @api private
  def run_all_cops(line_length_contents); end

  # Do an initial run with only Layout/LineLength so that cops that
  # depend on Layout/LineLength:Max get the correct value for that
  # parameter.
  #
  # @api private
  def run_line_length_cop; end

  # @api private
  # @return [Boolean]
  def same_max_line_length?(config1, config2); end

  # @api private
  def skip_line_length_cop(reason); end

  # @api private
  def write_config_file(file_name, file_string, rubocop_yml_contents); end
end

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::AUTO_GENERATED_FILE = T.let(T.unsafe(nil), String)

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1 = T.let(T.unsafe(nil), String)

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_DISABLED = T.let(T.unsafe(nil), String)

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_1_OVERRIDDEN = T.let(T.unsafe(nil), String)

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::PHASE_2 = T.let(T.unsafe(nil), String)

# @api private
RuboCop::CLI::Command::AutoGenerateConfig::YAML_OPTIONAL_DOC_START = T.let(T.unsafe(nil), Regexp)

# A subcommand in the CLI.
#
# @api private
class RuboCop::CLI::Command::Base
  # @api private
  # @return [Base] a new instance of Base
  def initialize(env); end

  # @api private
  def env; end

  class << self
    # @api private
    def by_command_name(name); end

    # @api private
    def command_name; end

    # @api private
    def command_name=(_arg0); end

    # @api private
    # @private
    def inherited(subclass); end
  end
end

# Run all the selected cops and report the result.
#
# @api private
class RuboCop::CLI::Command::ExecuteRunner < ::RuboCop::CLI::Command::Base
  include ::RuboCop::Formatter::TextUtil

  # @api private
  def run; end

  private

  # @api private
  def display_error_summary(errors); end

  # @api private
  def display_summary(runner); end

  # @api private
  def display_warning_summary(warnings); end

  # @api private
  def execute_runner(paths); end

  # @api private
  def maybe_print_corrected_source; end

  # @api private
  def with_redirect; end
end

# Combination of short and long formatter names.
#
# @api private
RuboCop::CLI::Command::ExecuteRunner::INTEGRATION_FORMATTERS = T.let(T.unsafe(nil), Array)

# Generate a .rubocop.yml file in the current directory.
#
# @api private
class RuboCop::CLI::Command::InitDotfile < ::RuboCop::CLI::Command::Base
  # @api private
  def run; end
end

# @api private
RuboCop::CLI::Command::InitDotfile::DOTFILE = T.let(T.unsafe(nil), String)

# Shows the given cops, or all cops by default, and their configurations
# for the current directory.
#
# @api private
class RuboCop::CLI::Command::ShowCops < ::RuboCop::CLI::Command::Base
  # @api private
  # @return [ShowCops] a new instance of ShowCops
  def initialize(env); end

  # @api private
  def run; end

  private

  # @api private
  def config_lines(cop); end

  # @api private
  def cops_of_department(cops, department); end

  # @api private
  def print_available_cops; end

  # @api private
  def print_cop_details(cops); end

  # @api private
  def print_cops_of_department(registry, department, show_all); end

  # @api private
  def selected_cops_of_department(cops, department); end
end

# Prints out url to documentation of provided cops
# or documentation base url by default.
#
# @api private
class RuboCop::CLI::Command::ShowDocsUrl < ::RuboCop::CLI::Command::Base
  # @api private
  # @return [ShowDocsUrl] a new instance of ShowDocsUrl
  def initialize(env); end

  # @api private
  def run; end

  private

  # @api private
  def cops_array; end

  # @api private
  def print_documentation_url; end

  # @api private
  def registry_hash; end
end

# Suggest RuboCop extensions to install based on Gemfile dependencies.
# Only primary dependencies are evaluated, so if a dependency depends on a
# gem with an extension, it is not suggested. However, if an extension is
# a transitive dependency, it will not be suggested.
#
# @api private
class RuboCop::CLI::Command::SuggestExtensions < ::RuboCop::CLI::Command::Base
  # @api private
  def run; end

  private

  # @api private
  def all_extensions; end

  # @api private
  def current_formatter; end

  # @api private
  def dependent_gems; end

  # @api private
  def extensions; end

  # @api private
  def installed_and_not_loaded_extensions; end

  # @api private
  def installed_extensions; end

  # @api private
  def installed_gems; end

  # @api private
  def loaded_extensions; end

  # @api private
  def lockfile; end

  # @api private
  def not_installed_extensions; end

  # @api private
  def print_install_suggestions; end

  # @api private
  def print_load_suggestions; end

  # @api private
  def print_opt_out_instruction; end

  # @api private
  def puts(*args); end

  # @api private
  # @return [Boolean]
  def skip?; end
end

# Combination of short and long formatter names.
#
# @api private
RuboCop::CLI::Command::SuggestExtensions::INCLUDED_FORMATTERS = T.let(T.unsafe(nil), Array)

# Display version.
#
# @api private
class RuboCop::CLI::Command::Version < ::RuboCop::CLI::Command::Base
  # @api private
  def run; end
end

RuboCop::CLI::DEFAULT_PARALLEL_OPTIONS = T.let(T.unsafe(nil), Array)

# Execution environment for a CLI command.
#
# @api private
class RuboCop::CLI::Environment
  # @api private
  # @return [Environment] a new instance of Environment
  def initialize(options, config_store, paths); end

  # @api private
  def config_store; end

  # @api private
  def options; end

  # @api private
  def paths; end

  # Run a command in this environment.
  #
  # @api private
  def run(name); end
end

class RuboCop::CLI::Finished < ::StandardError; end
RuboCop::CLI::STATUS_ERROR = T.let(T.unsafe(nil), Integer)
RuboCop::CLI::STATUS_INTERRUPTED = T.let(T.unsafe(nil), Integer)
RuboCop::CLI::STATUS_OFFENSES = T.let(T.unsafe(nil), Integer)
RuboCop::CLI::STATUS_SUCCESS = T.let(T.unsafe(nil), Integer)

# This class represents the cache config of the caching RuboCop runs.
#
# @api private
class RuboCop::CacheConfig
  class << self
    # @api private
    def root_dir; end
  end
end

# Converts RuboCop objects to and from the serialization format JSON.
#
# @api private
class RuboCop::CachedData
  # @api private
  # @return [CachedData] a new instance of CachedData
  def initialize(filename); end

  # @api private
  def from_json(text); end

  # @api private
  def to_json(offenses); end

  private

  # Restore an offense object loaded from a JSON file.
  #
  # @api private
  def deserialize_offenses(offenses); end

  # @api private
  def message(offense); end

  # @api private
  def serialize_offense(offense); end
end

# and provides a way to check if each cop is enabled at arbitrary line.
class RuboCop::CommentConfig
  # @return [CommentConfig] a new instance of CommentConfig
  def initialize(processed_source); end

  # @return [Boolean]
  def comment_only_line?(line_number); end

  def cop_disabled_line_ranges; end

  # @return [Boolean]
  def cop_enabled_at_line?(cop, line_number); end

  def extra_enabled_comments; end

  # Returns the value of attribute processed_source.
  def processed_source; end

  private

  def analyze; end
  def analyze_cop(analysis, directive); end
  def analyze_disabled(analysis, directive); end
  def analyze_rest(analysis, directive); end
  def analyze_single_line(analysis, directive); end
  def cop_line_ranges(analysis); end
  def each_directive; end
  def extra_enabled_comments_with_names(extras:, names:); end
  def handle_enable_all(directive, names, extras); end

  # Collect cops that have been disabled or enabled by name in a directive comment
  # so that `Lint/RedundantCopEnableDirective` can register offenses correctly.
  def handle_switch(directive, names, extras); end

  def non_comment_token_line_numbers; end
  def qualified_cop_name(cop_name); end
end

class RuboCop::CommentConfig::CopAnalysis < ::Struct
  # Returns the value of attribute line_ranges
  #
  # @return [Object] the current value of line_ranges
  def line_ranges; end

  # Sets the attribute line_ranges
  #
  # @param value [Object] the value to set the attribute line_ranges to.
  # @return [Object] the newly set value
  def line_ranges=(_); end

  # Returns the value of attribute start_line_number
  #
  # @return [Object] the current value of start_line_number
  def start_line_number; end

  # Sets the attribute start_line_number
  #
  # @param value [Object] the value to set the attribute start_line_number to.
  # @return [Object] the newly set value
  def start_line_number=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This class represents the configuration of the RuboCop application
# and all its cops. A Config is associated with a YAML configuration
# file from which it was read. Several different Configs can be used
# during a run of the rubocop program, if files in several
# directories are inspected.
class RuboCop::Config
  include ::RuboCop::PathUtil
  include ::RuboCop::FileFinder
  extend ::Forwardable

  # @return [Config] a new instance of Config
  def initialize(hash = T.unsafe(nil), loaded_path = T.unsafe(nil)); end

  def [](*args, **_arg1, &block); end
  def []=(*args, **_arg1, &block); end

  # @return [Boolean]
  def active_support_extensions_enabled?; end

  def add_excludes_from_higher_level(highest_config); end

  # @return [Boolean]
  def allowed_camel_case_file?(file); end

  # Paths specified in configuration files starting with .rubocop are
  # relative to the directory where that file is. Paths in other config files
  # are relative to the current directory. This is so that paths in
  # config/default.yml, for example, are not relative to RuboCop's config
  # directory since that wouldn't work.
  def base_dir_for_path_parameters; end

  def bundler_lock_file_path; end
  def check; end
  def delete(*args, **_arg1, &block); end
  def deprecation_check; end
  def dig(*args, **_arg1, &block); end

  # @return [Boolean]
  def disabled_new_cops?; end

  def each(*args, **_arg1, &block); end
  def each_key(*args, **_arg1, &block); end

  # @return [Boolean]
  def enabled_new_cops?; end

  def fetch(*args, **_arg1, &block); end

  # @return [Boolean]
  def file_to_exclude?(file); end

  # @return [Boolean]
  def file_to_include?(file); end

  def for_all_cops; end

  # Note: the 'Enabled' attribute is same as that returned by `for_cop`
  #
  # @return [Config] for the given cop merged with that of its department (if any)
  def for_badge(badge); end

  # Note: the 'Enabled' attribute is calculated according to the department's
  # and 'AllCops' configuration; other attributes are not inherited.
  #
  # @return [Config] for the given cop / cop name.
  def for_cop(cop); end

  # Note: the 'Enabled' attribute will be present only if specified
  # at the department's level
  #
  # @return [Config] for the given department name.
  def for_department(department_name); end

  # True if this is a config file that is shipped with RuboCop
  #
  # @return [Boolean]
  def internal?; end

  def key?(*args, **_arg1, &block); end
  def keys(*args, **_arg1, &block); end
  def loaded_features; end

  # Returns the value of attribute loaded_path.
  def loaded_path; end

  def make_excludes_absolute; end
  def map(*args, **_arg1, &block); end
  def merge(*args, **_arg1, &block); end
  def path_relative_to_config(path); end
  def patterns_to_exclude; end
  def patterns_to_include; end
  def pending_cops; end

  # Returns true if there's a chance that an Include pattern matches hidden
  # files, false if that's definitely not possible.
  #
  # @return [Boolean]
  def possibly_include_hidden?; end

  def replace(*args, **_arg1, &block); end
  def signature; end
  def smart_loaded_path; end
  def target_rails_version; end
  def target_ruby_version(*args, **_arg1, &block); end
  def to_h(*args, **_arg1, &block); end
  def to_hash(*args, **_arg1, &block); end
  def to_s; end
  def transform_values(*args, **_arg1, &block); end
  def validate(*args, **_arg1, &block); end
  def validate_after_resolution; end

  private

  def department_of(qualified_cop_name); end

  # @return [Boolean]
  def enable_cop?(qualified_cop_name, cop_options); end

  def read_rails_version_from_bundler_lock_file; end
  def target_rails_version_from_bundler_lock_file; end

  class << self
    def create(hash, path, check: T.unsafe(nil)); end
  end
end

class RuboCop::Config::CopConfig < ::Struct
  # Returns the value of attribute metadata
  #
  # @return [Object] the current value of metadata
  def metadata; end

  # Sets the attribute metadata
  #
  # @param value [Object] the value to set the attribute metadata to.
  # @return [Object] the newly set value
  def metadata=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RuboCop::Config::DEFAULT_RAILS_VERSION = T.let(T.unsafe(nil), Float)

# This class has methods related to finding configuration path.
#
# @api private
class RuboCop::ConfigFinder
  extend ::RuboCop::FileFinder

  class << self
    # @api private
    def find_config_path(target_dir); end

    # Returns the path RuboCop inferred as the root of the project. No file
    # searches will go past this directory.
    #
    # @api private
    def project_root; end

    # @api private
    def project_root=(_arg0); end

    private

    # @api private
    def expand_path(path); end

    # @api private
    def find_project_dotfile(target_dir); end

    # @api private
    def find_project_root; end

    # @api private
    def find_user_dotfile; end

    # @api private
    def find_user_xdg_config; end
  end
end

# @api private
RuboCop::ConfigFinder::DEFAULT_FILE = T.let(T.unsafe(nil), String)

# @api private
RuboCop::ConfigFinder::DOTFILE = T.let(T.unsafe(nil), String)

# @api private
RuboCop::ConfigFinder::RUBOCOP_HOME = T.let(T.unsafe(nil), String)

# @api private
RuboCop::ConfigFinder::XDG_CONFIG = T.let(T.unsafe(nil), String)

# This class represents the configuration of the RuboCop application
# and all its cops. A Config is associated with a YAML configuration
# file from which it was read. Several different Configs can be used
# during a run of the rubocop program, if files in several
# directories are inspected.
class RuboCop::ConfigLoader
  extend ::RuboCop::FileFinder

  class << self
    def add_excludes_from_files(config, config_file); end

    # Used to add features that were required inside a config or from
    # the CLI using `--require`.
    #
    # @api private
    def add_loaded_features(loaded_features); end

    def add_missing_namespaces(path, hash); end
    def clear_options; end

    # Returns the path of .rubocop.yml searching upwards in the
    # directory structure starting at the given directory where the
    # inspected file is. If no .rubocop.yml is found there, the
    # user's home directory is checked. If there's no .rubocop.yml
    # there either, the path to the default file is returned.
    def configuration_file_for(target_dir); end

    def configuration_from_file(config_file, check: T.unsafe(nil)); end

    # Returns the value of attribute debug.
    def debug; end

    # Sets the attribute debug
    #
    # @param value the value to set the attribute debug to.
    def debug=(_arg0); end

    # Returns the value of attribute debug.
    def debug?; end

    def default_configuration; end

    # Sets the attribute default_configuration
    #
    # @param value the value to set the attribute default_configuration to.
    def default_configuration=(_arg0); end

    # Returns the value of attribute disable_pending_cops.
    def disable_pending_cops; end

    # Sets the attribute disable_pending_cops
    #
    # @param value the value to set the attribute disable_pending_cops to.
    def disable_pending_cops=(_arg0); end

    # Returns the value of attribute enable_pending_cops.
    def enable_pending_cops; end

    # Sets the attribute enable_pending_cops
    #
    # @param value the value to set the attribute enable_pending_cops to.
    def enable_pending_cops=(_arg0); end

    # Returns the value of attribute ignore_parent_exclusion.
    def ignore_parent_exclusion; end

    # Sets the attribute ignore_parent_exclusion
    #
    # @param value the value to set the attribute ignore_parent_exclusion to.
    def ignore_parent_exclusion=(_arg0); end

    # Returns the value of attribute ignore_parent_exclusion.
    def ignore_parent_exclusion?; end

    # Returns the value of attribute ignore_unrecognized_cops.
    def ignore_unrecognized_cops; end

    # Sets the attribute ignore_unrecognized_cops
    #
    # @param value the value to set the attribute ignore_unrecognized_cops to.
    def ignore_unrecognized_cops=(_arg0); end

    def load_file(file, check: T.unsafe(nil)); end

    # @raise [TypeError]
    def load_yaml_configuration(absolute_path); end

    # Returns the value of attribute loaded_features.
    def loaded_features; end

    # Return a recursive merge of two hashes. That is, a normal hash merge,
    # with the addition that any value that is a hash, and occurs in both
    # arguments, will also be merged. And so on.
    def merge(base_hash, derived_hash); end

    # Merges the given configuration with the default one.
    def merge_with_default(config, config_file, unset_nil: T.unsafe(nil)); end

    # @return [Boolean]
    def possible_new_cops?(config); end

    # Returns the path RuboCop inferred as the root of the project. No file
    # searches will go past this directory.
    #
    # @deprecated Use `RuboCop::ConfigFinder.project_root` instead.
    def project_root; end

    def warn_on_pending_cops(pending_cops); end
    def warn_pending_cop(cop); end

    private

    def check_duplication(yaml_code, absolute_path); end
    def file_path(file); end

    # Read the specified file, or exit with a friendly, concise message on
    # stderr. Care is taken to use the standard OS exit code for a "file not
    # found" error.
    def read_file(absolute_path); end

    def resolver; end
    def yaml_safe_load(yaml_code, filename); end
    def yaml_safe_load!(yaml_code, filename); end
  end
end

RuboCop::ConfigLoader::DEFAULT_FILE = T.let(T.unsafe(nil), String)
RuboCop::ConfigLoader::DOTFILE = T.let(T.unsafe(nil), String)
RuboCop::ConfigLoader::RUBOCOP_HOME = T.let(T.unsafe(nil), String)

# A help class for ConfigLoader that handles configuration resolution.
#
# @api private
class RuboCop::ConfigLoaderResolver
  # When one .rubocop.yml file inherits from another .rubocop.yml file, the Include paths in the
  # base configuration are relative to the directory where the base configuration file is. For the
  # derived configuration, we need to make those paths relative to where the derived configuration
  # file is.
  #
  # @api private
  def fix_include_paths(base_config_path, hash, path, key, value); end

  # Return a recursive merge of two hashes. That is, a normal hash merge,
  # with the addition that any value that is a hash, and occurs in both
  # arguments, will also be merged. And so on.
  #
  #
  # @api private
  def merge(base_hash, derived_hash, **opts); end

  # Merges the given configuration with the default one. If
  # AllCops:DisabledByDefault is true, it changes the Enabled params so that
  # only cops from user configuration are enabled. If
  # AllCops:EnabledByDefault is true, it changes the Enabled params so that
  # only cops explicitly disabled in user configuration are disabled.
  #
  # @api private
  def merge_with_default(config, config_file, unset_nil:); end

  # An `Enabled: true` setting in user configuration for a cop overrides an
  # `Enabled: false` setting for its department.
  #
  # @api private
  def override_department_setting_for_cops(base_hash, derived_hash); end

  # If a cop was previously explicitly enabled, but then superseded by the
  # department being disabled, disable it.
  #
  # @api private
  def override_enabled_for_disabled_departments(base_hash, derived_hash); end

  # @api private
  def resolve_inheritance(path, hash, file, debug); end

  # @api private
  def resolve_inheritance_from_gems(hash); end

  # @api private
  def resolve_requires(path, hash); end

  private

  # @api private
  def base_configs(path, inherit_from, file); end

  # @api private
  def determine_inherit_mode(hash, key); end

  # @api private
  # @return [Boolean]
  def disabled?(hash, department); end

  # @api private
  # @return [Boolean]
  def duplicate_setting?(base_hash, derived_hash, key, inherited_file); end

  # @api private
  def gem_config_path(gem_name, relative_config_path); end

  # @api private
  def handle_disabled_by_default(config, new_default_configuration); end

  # @api private
  def inherited_file(path, inherit_from, file); end

  # @api private
  # @return [Boolean]
  def merge_hashes?(base_hash, derived_hash, key); end

  # @api private
  # @return [Boolean]
  def remote_file?(uri); end

  # @api private
  # @return [Boolean]
  def should_merge?(mode, key); end

  # @api private
  # @return [Boolean]
  def should_override?(mode, key); end

  # @api private
  # @return [Boolean]
  def should_union?(derived_hash, base_hash, root_mode, key); end

  # @api private
  def transform(config, &block); end

  # @api private
  def warn_on_duplicate_setting(base_hash, derived_hash, key, **opts); end
end

# Raised when a RuboCop configuration file is not found.
class RuboCop::ConfigNotFoundError < ::RuboCop::Error; end

# This class handles obsolete configuration.
#
# @api private
class RuboCop::ConfigObsoletion
  # @api private
  # @return [ConfigObsoletion] a new instance of ConfigObsoletion
  def initialize(config); end

  # @api private
  # @raise [ValidationError]
  def reject_obsolete!; end

  # @api private
  def rules; end

  # @api private
  def warnings; end

  private

  # Cop rules are keyed by the name of the original cop
  #
  # @api private
  def load_cop_rules(rules); end

  # Parameter rules may apply to multiple cops and multiple parameters
  # and are given as an array. Each combination is turned into a separate
  # rule object.
  #
  # @api private
  def load_parameter_rules(rules); end

  # Default rules for obsoletions are in config/obsoletion.yml
  # Additional rules files can be added with `RuboCop::ConfigObsoletion.files << filename`
  #
  # @api private
  def load_rules; end

  # @api private
  def obsoletions; end

  class << self
    # @api private
    def files; end

    # @api private
    def files=(_arg0); end

    # @api private
    def legacy_cop_names; end
  end
end

# @api private
RuboCop::ConfigObsoletion::COP_RULE_CLASSES = T.let(T.unsafe(nil), Hash)

# Encapsulation of a ConfigObsoletion rule for changing a parameter
#
# @api private
class RuboCop::ConfigObsoletion::ChangedEnforcedStyles < ::RuboCop::ConfigObsoletion::ParameterRule
  # @api private
  def message; end

  # @api private
  # @return [Boolean]
  def violated?; end

  private

  # @api private
  def value; end
end

# @api private
RuboCop::ConfigObsoletion::ChangedEnforcedStyles::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for changing a parameter
#
# @api private
class RuboCop::ConfigObsoletion::ChangedParameter < ::RuboCop::ConfigObsoletion::ParameterRule
  # @api private
  def message; end
end

# @api private
RuboCop::ConfigObsoletion::ChangedParameter::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Base class for ConfigObsoletion rules relating to cops
#
# @api private
class RuboCop::ConfigObsoletion::CopRule < ::RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [CopRule] a new instance of CopRule
  def initialize(config, old_name); end

  # @api private
  # @return [Boolean]
  def cop_rule?; end

  # @api private
  def message; end

  # @api private
  def old_name; end

  # @api private
  # @return [Boolean]
  def violated?; end

  # Cop rules currently can only be failures, not warnings
  #
  # @api private
  # @return [Boolean]
  def warning?; end
end

# @api private
RuboCop::ConfigObsoletion::DEFAULT_RULES_FILE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for splitting a cop's
# functionality into multiple new cops.
#
# @api private
class RuboCop::ConfigObsoletion::ExtractedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [ExtractedCop] a new instance of ExtractedCop
  def initialize(config, old_name, gem); end

  # @api private
  def department; end

  # @api private
  def gem; end

  # @api private
  def rule_message; end

  # @api private
  # @return [Boolean]
  def violated?; end

  private

  # @api private
  def affected_cops; end

  # @api private
  # @return [Boolean]
  def feature_loaded?; end
end

# @api private
RuboCop::ConfigObsoletion::PARAMETER_RULE_CLASSES = T.let(T.unsafe(nil), Hash)

# Base class for ConfigObsoletion rules relating to parameters
#
# @api private
class RuboCop::ConfigObsoletion::ParameterRule < ::RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [ParameterRule] a new instance of ParameterRule
  def initialize(config, cop, parameter, metadata); end

  # @api private
  def cop; end

  # @api private
  def metadata; end

  # @api private
  def parameter; end

  # @api private
  # @return [Boolean]
  def parameter_rule?; end

  # @api private
  # @return [Boolean]
  def violated?; end

  # @api private
  # @return [Boolean]
  def warning?; end

  private

  # @api private
  def alternative; end

  # @api private
  def alternatives; end

  # @api private
  def reason; end

  # @api private
  def severity; end
end

# Encapsulation of a ConfigObsoletion rule for removing
# a previously defined cop.
#
# @api private
class RuboCop::ConfigObsoletion::RemovedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [RemovedCop] a new instance of RemovedCop
  def initialize(config, old_name, metadata); end

  # @api private
  def metadata; end

  # @api private
  def old_name; end

  # @api private
  def rule_message; end

  private

  # @api private
  def alternatives; end

  # @api private
  def reason; end
end

# @api private
RuboCop::ConfigObsoletion::RemovedCop::BASE_MESSAGE = T.let(T.unsafe(nil), String)

# Encapsulation of a ConfigObsoletion rule for renaming
# a cop or moving it to a new department.
#
# @api private
class RuboCop::ConfigObsoletion::RenamedCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [RenamedCop] a new instance of RenamedCop
  def initialize(config, old_name, new_name); end

  # @api private
  def new_name; end

  # @api private
  def rule_message; end

  private

  # @api private
  # @return [Boolean]
  def moved?; end

  # @api private
  def verb; end
end

# Abstract base class for ConfigObsoletion rules
#
# @api private
class RuboCop::ConfigObsoletion::Rule
  # @api private
  # @return [Rule] a new instance of Rule
  def initialize(config); end

  # Does this rule relate to cops?
  #
  # @api private
  # @return [Boolean]
  def cop_rule?; end

  # Does this rule relate to parameters?
  #
  # @api private
  # @return [Boolean]
  def parameter_rule?; end

  # @api private
  # @raise [NotImplementedError]
  # @return [Boolean]
  def violated?; end

  private

  # @api private
  def config; end

  # @api private
  def smart_loaded_path; end

  # @api private
  def to_sentence(collection, connector: T.unsafe(nil)); end
end

# Encapsulation of a ConfigObsoletion rule for splitting a cop's
# functionality into multiple new cops.
#
# @api private
class RuboCop::ConfigObsoletion::SplitCop < ::RuboCop::ConfigObsoletion::CopRule
  # @api private
  # @return [SplitCop] a new instance of SplitCop
  def initialize(config, old_name, metadata); end

  # @api private
  def metadata; end

  # @api private
  def rule_message; end

  private

  # @api private
  def alternatives; end
end

# This class handles collecting the options for regenerating a TODO file.
#
# @api private
class RuboCop::ConfigRegeneration
  # Get options from the comment in the TODO file, and parse them as options
  #
  # @api private
  def options; end

  private

  # @api private
  def generation_command; end

  # @api private
  # @return [Boolean]
  def todo_exists?; end
end

# @api private
RuboCop::ConfigRegeneration::AUTO_GENERATED_FILE = T.let(T.unsafe(nil), String)

# @api private
RuboCop::ConfigRegeneration::COMMAND_REGEX = T.let(T.unsafe(nil), Regexp)

# @api private
RuboCop::ConfigRegeneration::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# Handles caching of configurations and association of inspected
# ruby files to configurations.
class RuboCop::ConfigStore
  # @return [ConfigStore] a new instance of ConfigStore
  def initialize; end

  # If type (file/dir) is known beforehand,
  # prefer using #for_file or #for_dir for improved performance
  def for(file_or_dir); end

  def for_dir(dir); end
  def for_file(file); end
  def for_pwd; end
  def force_default_config!; end
  def options_config=(options_config); end
  def unvalidated; end

  # Returns the value of attribute validated.
  def validated; end

  # Returns the value of attribute validated.
  def validated?; end
end

# Handles validation of configuration, for example cop names, parameter
# names, and Ruby versions.
class RuboCop::ConfigValidator
  extend ::Forwardable

  # @return [ConfigValidator] a new instance of ConfigValidator
  def initialize(config); end

  def for_all_cops(*args, **_arg1, &block); end
  def smart_loaded_path(*args, **_arg1, &block); end
  def target_ruby_version; end
  def validate; end

  # Validations that should only be run after all config resolving has
  # taken place:
  # * The target ruby version is only checked once the entire inheritance
  # chain has been loaded so that only the final value is validated, and
  # any obsolete but overridden values are ignored.
  def validate_after_resolution; end

  # @raise [ValidationError]
  def validate_section_presence(name); end

  private

  # @raise [ValidationError]
  def alert_about_unrecognized_cops(invalid_cop_names); end

  def check_cop_config_value(hash, parent = T.unsafe(nil)); end
  def check_obsoletions; end

  # @raise [ValidationError]
  def check_target_ruby; end

  def each_invalid_parameter(cop_name); end
  def list_unknown_cops(invalid_cop_names); end

  # FIXME: Handling colors in exception messages like this is ugly.
  def msg_not_boolean(parent, key, value); end

  def reject_conflicting_safe_settings; end

  # @raise [ValidationError]
  def reject_mutually_exclusive_defaults; end

  def suggestion(name); end

  # Returns the value of attribute target_ruby.
  def target_ruby; end

  def validate_enforced_styles(valid_cop_names); end

  # @raise [ValidationError]
  def validate_new_cops_parameter; end

  def validate_parameter_names(valid_cop_names); end
  def validate_support_and_has_list(name, formats, valid); end

  # @raise [ValidationError]
  def validate_syntax_cop; end
end

# @api private
RuboCop::ConfigValidator::COMMON_PARAMS = T.let(T.unsafe(nil), Array)

RuboCop::ConfigValidator::CONFIG_CHECK_DEPARTMENTS = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::ConfigValidator::CONFIG_CHECK_KEYS = T.let(T.unsafe(nil), Set)

# @api private
RuboCop::ConfigValidator::INTERNAL_PARAMS = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::ConfigValidator::NEW_COPS_VALUES = T.let(T.unsafe(nil), Array)

module RuboCop::Cop; end

# This module checks for nodes that should be aligned to the left or right.
# This amount is determined by the instance variable @column_delta.
module RuboCop::Cop::Alignment
  private

  def check_alignment(items, base_column = T.unsafe(nil)); end

  # Returns the value of attribute column_delta.
  def column_delta; end

  def configured_indentation_width; end

  # @api public
  def display_column(range); end

  # @api private
  def each_bad_alignment(items, base_column); end

  # @deprecated Use processed_source.comment_at_line(line)
  def end_of_line_comment(line); end

  def indentation(node); end
  def offset(node); end

  # @api private
  def register_offense(offense_node, message_node); end

  # @api public
  # @return [Boolean]
  def within?(inner, outer); end
end

RuboCop::Cop::Alignment::SPACE = T.let(T.unsafe(nil), String)

# This class does autocorrection of nodes that should just be moved to
# the left or to the right, amount being determined by the instance
# variable column_delta.
class RuboCop::Cop::AlignmentCorrector
  extend ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::Alignment

  class << self
    def align_end(corrector, processed_source, node, align_to); end
    def correct(corrector, processed_source, node, column_delta); end

    # Returns the value of attribute processed_source.
    def processed_source; end

    private

    def alignment_column(align_to); end
    def autocorrect_line(corrector, line_begin_pos, expr, column_delta, taboo_ranges); end

    # @return [Boolean]
    def block_comment_within?(expr); end

    def calculate_range(expr, line_begin_pos, column_delta); end

    # Some special kinds of string literals are not composed of literal
    # characters between two delimiters:
    # - The source map of `?a` responds to :begin and :end but its end is
    #   nil.
    # - The source map of `__FILE__` responds to neither :begin nor :end.
    #
    # @return [Boolean]
    def delimited_string_literal?(node); end

    def each_line(expr); end
    def inside_string_range(node); end
    def inside_string_ranges(node); end
    def remove(range, corrector); end
    def whitespace_range(node); end
  end
end

# This module encapsulates the ability to allow certain identifiers in a cop.
module RuboCop::Cop::AllowedIdentifiers
  # @return [Boolean]
  def allowed_identifier?(name); end

  def allowed_identifiers; end
end

# if a variable starts with a sigil it will be removed
RuboCop::Cop::AllowedIdentifiers::SIGILS = T.let(T.unsafe(nil), String)

# This module encapsulates the ability to allow certain methods when
# parsing.
module RuboCop::Cop::AllowedMethods
  private

  # @api public
  # @return [Boolean]
  def allowed_method?(name); end

  # @api public
  def allowed_methods; end

  def cop_config_deprecated_values; end

  # @api public
  # @deprecated Use allowed_method? instead
  # @return [Boolean]
  def ignored_method?(name); end
end

# This module encapsulates the ability to ignore certain lines when
# parsing.
module RuboCop::Cop::AllowedPattern
  private

  # @return [Boolean]
  def allowed_line?(line); end

  def allowed_patterns; end
  def cop_config_deprecated_methods_values; end

  # @deprecated Use allowed_line? instead
  # @return [Boolean]
  def ignored_line?(line); end

  # @return [Boolean]
  def matches_allowed_pattern?(line); end

  # @deprecated Use matches_allowed_pattern?? instead
  # @return [Boolean]
  def matches_ignored_pattern?(line); end
end

# Error raised when an unqualified cop name is used that could
# refer to two or more cops under different departments
class RuboCop::Cop::AmbiguousCopName < ::RuboCop::Error
  # @return [AmbiguousCopName] a new instance of AmbiguousCopName
  def initialize(name, origin, badges); end
end

RuboCop::Cop::AmbiguousCopName::MSG = T.let(T.unsafe(nil), String)

# Representation of an annotation comment in source code (eg. `# TODO: blah blah blah`).
class RuboCop::Cop::AnnotationComment
  extend ::Forwardable

  # @param comment [Parser::Source::Comment]
  # @param keywords [Array<String>]
  # @return [AnnotationComment] a new instance of AnnotationComment
  def initialize(comment, keywords); end

  # @return [Boolean]
  def annotation?; end

  # Returns the range bounds for just the annotation
  def bounds; end

  # Returns the value of attribute colon.
  def colon; end

  # Returns the value of attribute comment.
  def comment; end

  # @return [Boolean]
  def correct?(colon:); end

  # Returns the value of attribute keyword.
  def keyword; end

  # Returns the value of attribute margin.
  def margin; end

  # Returns the value of attribute note.
  def note; end

  # Returns the value of attribute space.
  def space; end

  private

  # @return [Boolean]
  def just_keyword_of_sentence?; end

  # @return [Boolean]
  def keyword_appearance?; end

  # Returns the value of attribute keywords.
  def keywords; end

  def split_comment(comment); end
end

# Handles the `MinSize` configuration option for array-based cops
# `Style/SymbolArray` and `Style/WordArray`, which check for use of the
# relevant percent literal syntax such as `%i[...]` and `%w[...]`
module RuboCop::Cop::ArrayMinSize
  private

  def array_style_detected(style, ary_size); end

  # @return [Boolean]
  def below_array_length?(node); end

  def largest_brackets_size(style, ary_size); end
  def min_size_config; end
  def smallest_percent_size(style, ary_size); end
end

# Common code for ordinary arrays with [] that can be written with %
# syntax.
module RuboCop::Cop::ArraySyntax
  private

  # @return [Boolean]
  def bracketed_array_of?(element_type, node); end
end

# extend this module to signal autocorrection support
module RuboCop::Cop::AutoCorrector
  # @return [Boolean]
  def support_autocorrect?; end
end

# This module encapsulates the logic for autocorrect behavior for a cop.
module RuboCop::Cop::AutocorrectLogic
  # @return [Boolean]
  def autocorrect?; end

  # @return [Boolean]
  def autocorrect_enabled?; end

  # @return [Boolean]
  def autocorrect_requested?; end

  # @return [Boolean]
  def autocorrect_with_disable_uncorrectable?; end

  # @return [Boolean]
  def correctable?; end

  # @return [Boolean]
  def disable_uncorrectable?; end

  # @return [Boolean]
  def safe_autocorrect?; end

  private

  def disable_offense(range); end
  def disable_offense_at_end_of_line(range, eol_comment); end
  def disable_offense_before_and_after(range_by_lines); end
  def max_line_length; end

  # Expand the given range to include all of any lines it covers. Does not
  # include newline at end of the last line.
  def range_by_lines(range); end

  def range_of_first_line(range); end
  def surrounding_heredoc(offense_range); end
end

# Identifier of all cops containing a department and cop name.
#
# All cops are identified by their badge. For example, the badge for
# `RuboCop::Cop::Layout::IndentationStyle` is `Layout/IndentationStyle`.
# Badges can be parsed as either `Department/CopName` or just `CopName` to
# allow for badge references in source files that omit the department for
# RuboCop to infer.
class RuboCop::Cop::Badge
  # @return [Badge] a new instance of Badge
  def initialize(class_name_parts); end

  def ==(other); end

  # Returns the value of attribute cop_name.
  def cop_name; end

  # Returns the value of attribute department.
  def department; end

  def eql?(other); end
  def hash; end

  # @return [Boolean]
  def match?(other); end

  # @return [Boolean]
  def qualified?; end

  def to_s; end
  def with_department(department); end

  class << self
    def camel_case(name_part); end
    def for(class_name); end
    def parse(identifier); end
  end
end

# A scaffold for concrete cops.
#
# The Cop::Base class is meant to be extended.
#
# Cops track offenses and can autocorrect them on the fly.
#
# A commissioner object is responsible for traversing the AST and invoking
# the specific callbacks on each cop.
#
# First the callback `on_new_investigation` is called;
# if a cop needs to do its own processing of the AST or depends on
# something else.
#
# Then callbacks like `on_def`, `on_send` (see AST::Traversal) are called
# with their respective nodes.
#
# Finally the callback `on_investigation_end` is called.
#
# Within these callbacks, cops are meant to call `add_offense` or
# `add_global_offense`. Use the `processed_source` method to
# get the currently processed source being investigated.
#
# In case of invalid syntax / unparsable content,
# the callback `on_other_file` is called instead of all the other
# `on_...` callbacks.
#
# Private methods are not meant for custom cops consumption,
# nor are any instance variables.
class RuboCop::Cop::Base
  include ::RuboCop::AST::Sexp
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util
  include ::RuboCop::Cop::IgnoredNode
  include ::RuboCop::Cop::AutocorrectLogic
  extend ::RuboCop::AST::Sexp
  extend ::RuboCop::AST::NodePattern::Macros
  extend ::RuboCop::ExcludeLimit

  # @return [Base] a new instance of Base
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # @return [Boolean]
  def active_support_extensions_enabled?; end

  # Adds an offense that has no particular location.
  # No correction can be applied to global offenses
  def add_global_offense(message = T.unsafe(nil), severity: T.unsafe(nil)); end

  # Adds an offense on the specified range (or node with an expression)
  # Unless that offense is disabled for this range, a corrector will be yielded
  # to provide the cop the opportunity to autocorrect the offense.
  # If message is not specified, the method `message` will be called.
  def add_offense(node_or_range, message: T.unsafe(nil), severity: T.unsafe(nil), &block); end

  # @api private
  def callbacks_needed; end

  # Returns the value of attribute config.
  def config; end

  def config_to_allow_offenses; end
  def config_to_allow_offenses=(hash); end

  # Configuration Helpers
  def cop_config; end

  def cop_name; end

  # @return [Boolean]
  def excluded_file?(file); end

  # This method should be overridden when a cop's behavior depends
  # on state that lives outside of these locations:
  #
  #   (1) the file under inspection
  #   (2) the cop's source code
  #   (3) the config (eg a .rubocop.yml file)
  #
  # For example, some cops may want to look at other parts of
  # the codebase being inspected to find violations. A cop may
  # use the presence or absence of file `foo.rb` to determine
  # whether a certain violation exists in `bar.rb`.
  #
  # Overriding this method allows the cop to indicate to RuboCop's
  # ResultCache system when those external dependencies change,
  # ie when the ResultCache should be invalidated.
  def external_dependency_checksum; end

  # Gets called if no message is specified when calling `add_offense` or
  # `add_global_offense`
  # Cops are discouraged to override this; instead pass your message directly
  def message(_range = T.unsafe(nil)); end

  def name; end

  # @deprecated Make potential errors with previous API more obvious
  def offenses; end

  # Called after all on_... have been called
  # When refining this method, always call `super`
  def on_investigation_end; end

  # Called before all on_... have been called
  # When refining this method, always call `super`
  def on_new_investigation; end

  # Called instead of all on_... callbacks for unrecognized files / syntax errors
  # When refining this method, always call `super`
  def on_other_file; end

  # There should be very limited reasons for a Cop to do it's own parsing
  def parse(source, path = T.unsafe(nil)); end

  # Returns the value of attribute processed_source.
  def processed_source; end

  # Called between investigations
  #
  # @api private
  def ready; end

  # @return [Boolean]
  def relevant_file?(file); end

  def target_rails_version; end
  def target_ruby_version; end

  private

  def annotate(message); end
  def apply_correction(corrector); end

  # @return [Symbol] offense status
  def attempt_correction(range, corrector); end

  # Called before any investigation
  def begin_investigation(processed_source); end

  # Reserved for Cop::Cop
  def callback_argument(range); end

  # Called to complete an investigation
  def complete_investigation; end

  # @return [Symbol, Corrector] offense status
  def correct(range); end

  # Reserved for Commissioner:
  def current_offense_locations; end

  def currently_disabled_lines; end
  def custom_severity; end
  def default_severity; end
  def disable_uncorrectable(range); end

  # @return [Boolean]
  def enabled_line?(line_number); end

  # @return [Boolean]
  def file_name_matches_any?(file, parameter, default_result); end

  def find_message(range, message); end
  def find_severity(_range, severity); end
  def range_from_node_or_range(node_or_range); end
  def reset_investigation; end

  # @return [Symbol] offense status
  def use_corrector(range, corrector); end

  class << self
    # List of cops that should not try to autocorrect at the same
    # time as this cop
    #
    # @api public
    # @return [Array<RuboCop::Cop::Cop>]
    def autocorrect_incompatible_with; end

    # Naming
    def badge; end

    # @api private
    def callbacks_needed; end

    def cop_name; end
    def department; end

    # Cops (other than builtin) are encouraged to implement this
    #
    # @api public
    # @return [String, nil]
    def documentation_url; end

    # Call for abstract Cop classes
    def exclude_from_registry; end

    # @private
    def inherited(subclass); end

    # Override and return the Force class(es) you need to join
    def joining_forces; end

    # @return [Boolean]
    def lint?; end

    # Returns true if the cop name or the cop namespace matches any of the
    # given names.
    #
    # @return [Boolean]
    def match?(given_names); end

    # Returns if class supports autocorrect.
    # It is recommended to extend AutoCorrector instead of overriding
    #
    # @return [Boolean]
    def support_autocorrect?; end

    # Override if your cop should be called repeatedly for multiple investigations
    # Between calls to `on_new_investigation` and `on_investigation_end`,
    # the result of `processed_source` will remain constant.
    # You should invalidate any caches that depend on the current `processed_source`
    # in the `on_new_investigation` callback.
    # If your cop does autocorrections, be aware that your instance may be called
    # multiple times with the same `processed_source.path` but different content.
    #
    # @return [Boolean]
    def support_multiple_source?; end

    private

    # Actually private methods
    #
    # @return [Boolean]
    def builtin?; end

    def restrict_on_send; end
  end
end

# Reports of an investigation.
# Immutable
# Consider creation API private
class RuboCop::Cop::Base::InvestigationReport < ::Struct
  # Returns the value of attribute cop
  #
  # @return [Object] the current value of cop
  def cop; end

  # Sets the attribute cop
  #
  # @param value [Object] the value to set the attribute cop to.
  # @return [Object] the newly set value
  def cop=(_); end

  # Returns the value of attribute corrector
  #
  # @return [Object] the current value of corrector
  def corrector; end

  # Sets the attribute corrector
  #
  # @param value [Object] the value to set the attribute corrector to.
  # @return [Object] the newly set value
  def corrector=(_); end

  # Returns the value of attribute offenses
  #
  # @return [Object] the current value of offenses
  def offenses; end

  # Sets the attribute offenses
  #
  # @param value [Object] the value to set the attribute offenses to.
  # @return [Object] the newly set value
  def offenses=(_); end

  # Returns the value of attribute processed_source
  #
  # @return [Object] the current value of processed_source
  def processed_source; end

  # Sets the attribute processed_source
  #
  # @param value [Object] the value to set the attribute processed_source to.
  # @return [Object] the newly set value
  def processed_source=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# List of methods names to restrict calls for `on_send` / `on_csend`
RuboCop::Cop::Base::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

module RuboCop::Cop::Bundler; end

# A Gem's requirements should be listed only once in a Gemfile.
#
# @example
#   # bad
#   gem 'rubocop'
#   gem 'rubocop'
#
#   # bad
#   group :development do
#   gem 'rubocop'
#   end
#
#   group :test do
#   gem 'rubocop'
#   end
#
#   # good
#   group :development, :test do
#   gem 'rubocop'
#   end
#
#   # good
#   gem 'rubocop', groups: [:development, :test]
#
#   # good - conditional declaration
#   if Dir.exist?(local)
#   gem 'rubocop', path: local
#   elsif ENV['RUBOCOP_VERSION'] == 'master'
#   gem 'rubocop', git: 'https://github.com/rubocop/rubocop.git'
#   else
#   gem 'rubocop', '~> 0.90.0'
#   end
class RuboCop::Cop::Bundler::DuplicatedGem < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def gem_declarations(param0); end
  def on_new_investigation; end

  private

  # @return [Boolean]
  def conditional_declaration?(nodes); end

  def duplicated_gem_nodes; end
  def register_offense(node, gem_name, line_of_first_occurrence); end

  # @return [Boolean]
  def within_conditional?(node, conditional_node); end
end

RuboCop::Cop::Bundler::DuplicatedGem::MSG = T.let(T.unsafe(nil), String)

# Each gem in the Gemfile should have a comment explaining
# its purpose in the project, or the reason for its version
# or source.
#
# The optional "OnlyFor" configuration array
# can be used to only register offenses when the gems
# use certain options or have version specifiers.
#
# When "version_specifiers" is included, a comment
# will be enforced if the gem has any version specifier.
#
# When "restrictive_version_specifiers" is included, a comment
# will be enforced if the gem has a version specifier that
# holds back the version of the gem.
#
# For any other value in the array, a comment will be enforced for
# a gem if an option by the same name is present.
# A useful use case is to enforce a comment when using
# options that change the source of a gem:
#
# - `bitbucket`
# - `gist`
# - `git`
# - `github`
# - `source`
#
# For a full list of options supported by bundler,
# see https://bundler.io/man/gemfile.5.html
# .
#
# @example OnlyFor: [] (default)
#   # bad
#
#   gem 'foo'
#
#   # good
#
#   # Helpers for the foo things.
#   gem 'foo'
# @example OnlyFor: ['version_specifiers']
#   # bad
#
#   gem 'foo', '< 2.1'
#
#   # good
#
#   # Version 2.1 introduces breaking change baz
#   gem 'foo', '< 2.1'
# @example OnlyFor: ['restrictive_version_specifiers']
#   # bad
#
#   gem 'foo', '< 2.1'
#
#   # good
#
#   gem 'foo', '>= 1.0'
#
#   # Version 2.1 introduces breaking change baz
#   gem 'foo', '< 2.1'
# @example OnlyFor: ['version_specifiers', 'github']
#   # bad
#
#   gem 'foo', github: 'some_account/some_fork_of_foo'
#
#   gem 'bar', '< 2.1'
#
#   # good
#
#   # Using this fork because baz
#   gem 'foo', github: 'some_account/some_fork_of_foo'
#
#   # Version 2.1 introduces breaking change baz
#   gem 'bar', '< 2.1'
class RuboCop::Cop::Bundler::GemComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::GemDeclaration

  def on_send(node); end

  private

  # @return [Boolean]
  def checked_options_present?(node); end

  # @return [Boolean]
  def commented?(node); end

  # @return [Boolean]
  def commented_any_descendant?(node); end

  # @return [Boolean]
  def contains_checked_options?(node); end

  def gem_options(node); end

  # @return [Boolean]
  def ignored_gem?(node); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  def precede?(node1, node2); end

  # @return [Boolean]
  def preceding_comment?(node1, node2); end

  def preceding_lines(node); end

  # Version specifications that restrict all updates going forward. This excludes versions
  # like ">= 1.0" or "!= 2.0.3".
  #
  # @return [Boolean]
  def restrictive_version_specified_gem?(node); end

  # Besides the gem name, all other *positional* arguments to `gem` are version specifiers,
  # as long as it has one we know there's at least one version specifier.
  #
  # @return [Boolean]
  def version_specified_gem?(node); end
end

RuboCop::Cop::Bundler::GemComment::CHECKED_OPTIONS_CONFIG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemComment::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemComment::RESTRICTIVE_VERSION_PATTERN = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Bundler::GemComment::RESTRICTIVE_VERSION_SPECIFIERS_OPTION = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemComment::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Bundler::GemComment::VERSION_SPECIFIERS_OPTION = T.let(T.unsafe(nil), String)

# Verifies that a project contains Gemfile or gems.rb file and correct
# associated lock file based on the configuration.
#
# @example EnforcedStyle: Gemfile (default)
#   # bad
#   Project contains gems.rb and gems.locked files
#
#   # bad
#   Project contains Gemfile and gems.locked file
#
#   # good
#   Project contains Gemfile and Gemfile.lock
# @example EnforcedStyle: gems.rb
#   # bad
#   Project contains Gemfile and Gemfile.lock files
#
#   # bad
#   Project contains gems.rb and Gemfile.lock file
#
#   # good
#   Project contains gems.rb and gems.locked files
class RuboCop::Cop::Bundler::GemFilename < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  # @return [Boolean]
  def expected_gemfile?(basename); end

  # @return [Boolean]
  def gemfile_offense?(basename); end

  # @return [Boolean]
  def gemfile_required?; end

  # @return [Boolean]
  def gems_rb_offense?(basename); end

  # @return [Boolean]
  def gems_rb_required?; end

  def register_gemfile_offense(file_path, basename); end
  def register_gems_rb_offense(file_path, basename); end
  def register_offense(file_path, basename); end
end

RuboCop::Cop::Bundler::GemFilename::GEMFILE_FILES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Bundler::GemFilename::GEMS_RB_FILES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Bundler::GemFilename::MSG_GEMFILE_MISMATCHED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemFilename::MSG_GEMFILE_REQUIRED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemFilename::MSG_GEMS_RB_MISMATCHED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemFilename::MSG_GEMS_RB_REQUIRED = T.let(T.unsafe(nil), String)

# Enforce that Gem version specifications or a commit reference (branch,
# ref, or tag) are either required or forbidden.
#
# @example EnforcedStyle: required (default)
#   # bad
#   gem 'rubocop'
#
#   # good
#   gem 'rubocop', '~> 1.12'
#
#   # good
#   gem 'rubocop', '>= 1.10.0'
#
#   # good
#   gem 'rubocop', '>= 1.5.0', '< 1.10.0'
#
#   # good
#   gem 'rubocop', branch: 'feature-branch'
#
#   # good
#   gem 'rubocop', ref: '74b5bfbb2c4b6fd6cdbbc7254bd7084b36e0c85b'
#
#   # good
#   gem 'rubocop', tag: 'v1.17.0'
# @example EnforcedStyle: forbidden
#   # good
#   gem 'rubocop'
#
#   # bad
#   gem 'rubocop', '~> 1.12'
#
#   # bad
#   gem 'rubocop', '>= 1.10.0'
#
#   # bad
#   gem 'rubocop', '>= 1.5.0', '< 1.10.0'
#
#   # bad
#   gem 'rubocop', branch: 'feature-branch'
#
#   # bad
#   gem 'rubocop', ref: '74b5bfbb2c4b6fd6cdbbc7254bd7084b36e0c85b'
#
#   # bad
#   gem 'rubocop', tag: 'v1.17.0'
class RuboCop::Cop::Bundler::GemVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::GemDeclaration

  def includes_commit_reference?(param0 = T.unsafe(nil)); end
  def includes_version_specification?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_gem?(node); end

  def allowed_gems; end

  # @return [Boolean]
  def forbidden_offense?(node); end

  # @return [Boolean]
  def forbidden_style?; end

  def message(range); end

  # @return [Boolean]
  def offense?(node); end

  # @return [Boolean]
  def required_offense?(node); end

  # @return [Boolean]
  def required_style?; end

  # @return [Boolean]
  def version_specification?(expression); end
end

RuboCop::Cop::Bundler::GemVersion::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemVersion::REQUIRED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::GemVersion::VERSION_SPECIFICATION_REGEX = T.let(T.unsafe(nil), Regexp)

# Passing symbol arguments to `source` (e.g. `source :rubygems`) is
# deprecated because they default to using HTTP requests. Instead, specify
# `'https://rubygems.org'` if possible, or `'http://rubygems.org'` if not.
#
# When autocorrecting, this cop will replace symbol arguments with
# `'https://rubygems.org'`.
#
# This cop will not replace existing sources that use `http://`. This may
# be necessary where HTTPS is not available. For example, where using an
# internal gem server via an intranet, or where HTTPS is prohibited.
# However, you should strongly prefer `https://` where possible, as it is
# more secure.
#
# If you don't allow `http://`, please set `false` to `AllowHttpProtocol`.
# This option is `true` by default for safe autocorrection.
#
# @example
#   # bad
#   source :gemcutter
#   source :rubygems
#   source :rubyforge
#
#   # good
#   source 'https://rubygems.org' # strongly recommended
# @example AllowHttpProtocol: true (default)
#
#   # good
#   source 'http://rubygems.org' # use only if HTTPS is unavailable
# @example AllowHttpProtocol: false
#
#   # bad
#   source 'http://rubygems.org'
class RuboCop::Cop::Bundler::InsecureProtocolSource < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def insecure_protocol_source?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allow_http_protocol?; end
end

RuboCop::Cop::Bundler::InsecureProtocolSource::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::InsecureProtocolSource::MSG_HTTP_PROTOCOL = T.let(T.unsafe(nil), String)
RuboCop::Cop::Bundler::InsecureProtocolSource::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Gems should be alphabetically sorted within groups.
#
# @example
#   # bad
#   gem 'rubocop'
#   gem 'rspec'
#
#   # good
#   gem 'rspec'
#   gem 'rubocop'
#
#   # good
#   gem 'rubocop'
#
#   gem 'rspec'
#
#   # good only if TreatCommentsAsGroupSeparators is true
#   # For code quality
#   gem 'rubocop'
#   # For tests
#   gem 'rspec'
class RuboCop::Cop::Bundler::OrderedGems < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::AutoCorrector

  def gem_declarations(param0); end
  def on_new_investigation; end

  private

  def previous_declaration(node); end
end

RuboCop::Cop::Bundler::OrderedGems::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking assignment nodes.
module RuboCop::Cop::CheckAssignment
  def on_and_asgn(node); end
  def on_casgn(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_op_asgn(node); end
  def on_or_asgn(node); end
  def on_send(node); end

  private

  def extract_rhs(node); end

  class << self
    def extract_rhs(node); end
  end
end

# This mixin detects collections that are safe to "break"
# by inserting new lines. This is useful for breaking
# up long lines.
#
# Let's look at hashes as an example:
#
# We know hash keys are safe to break across lines. We can add
# linebreaks into hashes on lines longer than the specified maximum.
# Then in further passes cops can clean up the multi-line hash.
# For example, say the maximum line length is as indicated below:
#
#                                         |
#                                         v
# {foo: "0000000000", bar: "0000000000", baz: "0000000000"}
#
# In a LineLength autocorrection pass, a line is added before
# the first key that exceeds the column limit:
#
# {foo: "0000000000", bar: "0000000000",
# baz: "0000000000"}
#
# In a MultilineHashKeyLineBreaks pass, lines are inserted
# before all keys:
#
# {foo: "0000000000",
# bar: "0000000000",
# baz: "0000000000"}
#
# Then in future passes FirstHashElementLineBreak,
# MultilineHashBraceLayout, and TrailingCommaInHashLiteral will
# manipulate as well until we get:
#
# {
#   foo: "0000000000",
#   bar: "0000000000",
#   baz: "0000000000",
# }
#
# (Note: Passes may not happen exactly in this sequence.)
module RuboCop::Cop::CheckLineBreakable
  def extract_breakable_node(node, max); end

  private

  # @api private
  # @return [Boolean]
  def all_on_same_line?(nodes); end

  # @api private
  # @return [Boolean]
  def already_on_multiple_lines?(node); end

  # @api private
  # @return [Boolean]
  def breakable_collection?(node, elements); end

  # @api private
  # @return [Boolean]
  def children_could_be_broken_up?(children); end

  # @api private
  # @return [Boolean]
  def contained_by_breakable_collection_on_same_line?(node); end

  # @api private
  # @return [Boolean]
  def contained_by_multiline_collection_that_could_be_broken_up?(node); end

  # @api private
  def extract_breakable_node_from_elements(node, elements, max); end

  # @api private
  def extract_first_element_over_column_limit(node, elements, max); end

  # @api private
  # @return [Boolean]
  def first_argument_is_heredoc?(node); end

  # @api private
  def process_args(args); end

  # @api private
  # @return [Boolean]
  def safe_to_ignore?(node); end

  # If a send node contains a heredoc argument, splitting cannot happen
  # after the heredoc or else it will cause a syntax error.
  #
  # @api private
  def shift_elements_for_heredoc_arg(node, elements, index); end

  # @api private
  # @return [Boolean]
  def within_column_limit?(element, max, line); end
end

# Common functionality for checking length of code segments.
module RuboCop::Cop::CodeLength
  extend ::RuboCop::ExcludeLimit

  def max=(value); end

  private

  def build_code_length_calculator(node); end
  def check_code_length(node); end
  def count_as_one; end

  # @return [Boolean]
  def count_comments?; end

  # Returns true for lines that shall not be included in the count.
  def irrelevant_line(source_line); end

  def max_length; end
  def message(length, max_length); end
end

RuboCop::Cop::CodeLength::MSG = T.let(T.unsafe(nil), String)

# Help methods for working with nodes containing comments.
module RuboCop::Cop::CommentsHelp
  def comments_in_range(node); end

  # @return [Boolean]
  def contains_comments?(node); end

  def source_range_with_comment(node); end

  private

  def begin_pos_with_comment(node); end
  def buffer; end
  def end_position_for(node); end

  # Returns the end line of a node, which might be a comment and not part of the AST
  # End line is considered either the line at which another node starts, or
  # the line at which the parent node ends.
  def find_end_line(node); end

  def start_line_position(node); end
end

# Commissioner class is responsible for processing the AST and delegating
# work to the specified cops.
class RuboCop::Cop::Commissioner
  include ::RuboCop::AST::Traversal

  # @return [Commissioner] a new instance of Commissioner
  def initialize(cops, forces = T.unsafe(nil), options = T.unsafe(nil)); end

  # Returns the value of attribute errors.
  def errors; end

  # @return [InvestigationReport]
  def investigate(processed_source); end

  def on___ENCODING__(node); end
  def on___FILE__(node); end
  def on___LINE__(node); end
  def on_alias(node); end
  def on_and(node); end
  def on_and_asgn(node); end
  def on_arg(node); end
  def on_arg_expr(node); end
  def on_args(node); end
  def on_array(node); end
  def on_array_pattern(node); end
  def on_array_pattern_with_tail(node); end
  def on_back_ref(node); end
  def on_begin(node); end
  def on_block(node); end
  def on_block_pass(node); end
  def on_blockarg(node); end
  def on_break(node); end
  def on_case(node); end
  def on_case_match(node); end
  def on_casgn(node); end
  def on_cbase(node); end
  def on_class(node); end
  def on_complex(node); end
  def on_const(node); end
  def on_const_pattern(node); end
  def on_csend(node); end
  def on_cvar(node); end
  def on_cvasgn(node); end
  def on_def(node); end
  def on_defined?(node); end
  def on_defs(node); end
  def on_dstr(node); end
  def on_dsym(node); end
  def on_eflipflop(node); end
  def on_empty_else(node); end
  def on_ensure(node); end
  def on_erange(node); end
  def on_false(node); end
  def on_find_pattern(node); end
  def on_float(node); end
  def on_for(node); end
  def on_forward_arg(node); end
  def on_forward_args(node); end
  def on_forwarded_args(node); end
  def on_gvar(node); end
  def on_gvasgn(node); end
  def on_hash(node); end
  def on_hash_pattern(node); end
  def on_if(node); end
  def on_if_guard(node); end
  def on_iflipflop(node); end
  def on_in_match(node); end
  def on_in_pattern(node); end
  def on_index(node); end
  def on_indexasgn(node); end
  def on_int(node); end
  def on_irange(node); end
  def on_ivar(node); end
  def on_ivasgn(node); end
  def on_kwarg(node); end
  def on_kwargs(node); end
  def on_kwbegin(node); end
  def on_kwnilarg(node); end
  def on_kwoptarg(node); end
  def on_kwrestarg(node); end
  def on_kwsplat(node); end
  def on_lambda(node); end
  def on_lvar(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_match_alt(node); end
  def on_match_as(node); end
  def on_match_current_line(node); end
  def on_match_nil_pattern(node); end
  def on_match_pattern(node); end
  def on_match_pattern_p(node); end
  def on_match_rest(node); end
  def on_match_var(node); end
  def on_match_with_lvasgn(node); end
  def on_match_with_trailing_comma(node); end
  def on_mlhs(node); end
  def on_module(node); end
  def on_next(node); end
  def on_nil(node); end
  def on_not(node); end
  def on_nth_ref(node); end
  def on_numblock(node); end
  def on_op_asgn(node); end
  def on_optarg(node); end
  def on_or(node); end
  def on_or_asgn(node); end
  def on_pair(node); end
  def on_pin(node); end
  def on_postexe(node); end
  def on_preexe(node); end
  def on_procarg0(node); end
  def on_rational(node); end
  def on_redo(node); end
  def on_regexp(node); end
  def on_regopt(node); end
  def on_resbody(node); end
  def on_rescue(node); end
  def on_restarg(node); end
  def on_retry(node); end
  def on_return(node); end
  def on_sclass(node); end
  def on_self(node); end
  def on_send(node); end
  def on_shadowarg(node); end
  def on_splat(node); end
  def on_str(node); end
  def on_super(node); end
  def on_sym(node); end
  def on_true(node); end
  def on_undef(node); end
  def on_unless_guard(node); end
  def on_until(node); end
  def on_until_post(node); end
  def on_when(node); end
  def on_while(node); end
  def on_while_post(node); end
  def on_xstr(node); end
  def on_yield(node); end
  def on_zsuper(node); end

  private

  def build_callbacks(cops); end
  def initialize_callbacks; end
  def invoke(callback, cops, *args); end
  def reset; end
  def restrict_callbacks(callbacks); end

  # NOTE: mutates `callbacks` in place
  def restricted_map(callbacks); end

  def trigger_responding_cops(callback, node); end
  def trigger_restricted_cops(event, node); end

  # Allow blind rescues here, since we're absorbing and packaging or
  # re-raising exceptions that can be raised from within the individual
  # cops' `#investigate` methods.
  def with_cop_error_handling(cop, node = T.unsafe(nil)); end
end

# How a Commissioner returns the results of the investigation
# as a list of Cop::InvestigationReport and any errors caught
# during the investigation.
# Immutable
# Consider creation API private
class RuboCop::Cop::Commissioner::InvestigationReport < ::Struct
  # Returns the value of attribute cop_reports
  #
  # @return [Object] the current value of cop_reports
  def cop_reports; end

  # Sets the attribute cop_reports
  #
  # @param value [Object] the value to set the attribute cop_reports to.
  # @return [Object] the newly set value
  def cop_reports=(_); end

  def cops; end
  def correctors; end

  # Returns the value of attribute errors
  #
  # @return [Object] the current value of errors
  def errors; end

  # Sets the attribute errors
  #
  # @param value [Object] the value to set the attribute errors to.
  # @return [Object] the newly set value
  def errors=(_); end

  def merge(investigation); end
  def offenses; end
  def offenses_per_cop; end

  # Returns the value of attribute processed_source
  #
  # @return [Object] the current value of processed_source
  def processed_source; end

  # Sets the attribute processed_source
  #
  # @param value [Object] the value to set the attribute processed_source to.
  # @return [Object] the newly set value
  def processed_source=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RuboCop::Cop::Commissioner::RESTRICTED_CALLBACKS = T.let(T.unsafe(nil), Array)

# This class does condition autocorrection
class RuboCop::Cop::ConditionCorrector
  class << self
    def correct_negative_condition(corrector, node); end

    private

    def negated_condition(node); end
  end
end

# Handles `EnforcedStyle` configuration parameters.
module RuboCop::Cop::ConfigurableEnforcedStyle
  def alternative_style; end
  def alternative_styles; end
  def ambiguous_style_detected(*possibilities); end
  def conflicting_styles_detected; end
  def correct_style_detected; end
  def detected_style; end
  def detected_style=(style); end
  def no_acceptable_style!; end

  # @return [Boolean]
  def no_acceptable_style?; end

  def opposite_style_detected; end
  def style; end

  # @return [Boolean]
  def style_configured?; end

  def style_detected(detected); end
  def style_parameter_name; end
  def supported_styles; end
  def unexpected_style_detected(unexpected); end
  def unrecognized_style_detected; end
end

# Shared functionality between mixins that enforce naming conventions
module RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def check_name(node, name, name_range); end

  # A class emitter method is a singleton method in a class/module, where
  # the method has the same name as a class defined in the class/module.
  #
  # @return [Boolean]
  def class_emitter_method?(node, name); end

  def report_opposing_styles(node, name); end

  # @return [Boolean]
  def valid_name?(node, name, given_style = T.unsafe(nil)); end
end

# Handles `Max` configuration parameters, especially setting them to an
# appropriate value with --auto-gen-config.
#
# @deprecated Use `exclude_limit ParameterName` instead.
module RuboCop::Cop::ConfigurableMax
  private

  def max=(value); end
  def max_parameter_name; end
end

# This module provides functionality for checking if names match the
# configured EnforcedStyle.
module RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

RuboCop::Cop::ConfigurableNaming::FORMATS = T.let(T.unsafe(nil), Hash)

# This module provides functionality for checking if numbering match the
# configured EnforcedStyle.
module RuboCop::Cop::ConfigurableNumbering
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
end

RuboCop::Cop::ConfigurableNumbering::FORMATS = T.let(T.unsafe(nil), Hash)

# Monkey-patch Cop for tests to provide easy access to messages and
# highlights.
class RuboCop::Cop::Cop < ::RuboCop::Cop::Base
  def add_offense(node_or_range, location: T.unsafe(nil), message: T.unsafe(nil), severity: T.unsafe(nil), &block); end

  # @deprecated
  def corrections; end

  def find_location(node, loc); end

  # Returns the value of attribute offenses.
  def offenses; end

  # Called after all on_... have been called
  def on_investigation_end; end

  # Called before all on_... have been called
  def on_new_investigation; end

  # @deprecated Use class method
  # @return [Boolean]
  def support_autocorrect?; end

  private

  def apply_correction(corrector); end
  def begin_investigation(processed_source); end

  # Override Base
  def callback_argument(_range); end

  def correction_lambda; end
  def dedup_on_node(node); end

  # Just for legacy
  #
  # @yield [corrector]
  def emulate_v0_callsequence(corrector); end

  def suppress_clobbering; end

  class << self
    # @deprecated Use Registry.all
    def all; end

    def joining_forces; end

    # @deprecated Use Registry.qualified_cop_name
    def qualified_cop_name(name, origin); end

    # @deprecated Use Registry.global
    def registry; end

    # @return [Boolean]
    def support_autocorrect?; end
  end
end

# @deprecated
class RuboCop::Cop::Cop::Correction < ::Struct
  def call(corrector); end

  # Returns the value of attribute cop
  #
  # @return [Object] the current value of cop
  def cop; end

  # Sets the attribute cop
  #
  # @param value [Object] the value to set the attribute cop to.
  # @return [Object] the newly set value
  def cop=(_); end

  # Returns the value of attribute lambda
  #
  # @return [Object] the current value of lambda
  def lambda; end

  # Sets the attribute lambda
  #
  # @param value [Object] the value to set the attribute lambda to.
  # @return [Object] the newly set value
  def lambda=(_); end

  # Returns the value of attribute node
  #
  # @return [Object] the current value of node
  def node; end

  # Sets the attribute node
  #
  # @param value [Object] the value to set the attribute node to.
  # @return [Object] the newly set value
  def node=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This class takes a source buffer and rewrite its source
# based on the different correction rules supplied.
#
# Important!
# The nodes modified by the corrections should be part of the
# AST of the source_buffer.
class RuboCop::Cop::Corrector < ::Parser::Source::TreeRewriter
  # corrector = Corrector.new(cop)
  #
  # @param source [Parser::Source::Buffer, or anything
  # leading to one via `(processed_source.)buffer`]
  # @return [Corrector] a new instance of Corrector
  def initialize(source); end

  # Removes `size` characters from the beginning of the given range.
  # If `size` is greater than the size of `range`, the removed region can
  # overrun the end of `range`.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  def remove_leading(node_or_range, size); end

  # Removes `size` characters prior to the source range.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  def remove_preceding(node_or_range, size); end

  # Removes `size` characters from the end of the given range.
  # If `size` is greater than the size of `range`, the removed region can
  # overrun the beginning of `range`.
  #
  # @param range [Parser::Source::Range, RuboCop::AST::Node] or node
  # @param size [Integer]
  def remove_trailing(node_or_range, size); end

  # Legacy
  def rewrite; end

  private

  def check_range_validity(node_or_range); end
  def to_range(node_or_range); end
  def validate_buffer(buffer); end

  class << self
    # Duck typing for get to a ::Parser::Source::Buffer
    def source_buffer(source); end
  end
end

# noop
RuboCop::Cop::Corrector::NOOP_CONSUMER = T.let(T.unsafe(nil), Proc)

# Common functionality for checking def nodes.
module RuboCop::Cop::DefNode
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::AST::NodePattern::Macros

  def non_public_modifier?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def non_public?(node); end

  # @return [Boolean]
  def preceding_non_public_modifier?(node); end
end

# Helpers for builtin documentation
module RuboCop::Cop::Documentation
  private

  # @api private
  def base_url_for(cop_class, config); end

  # @api private
  def default_base_url; end

  # @api private
  def department_to_basename(department); end

  # @api private
  def url_for(cop_class, config = T.unsafe(nil)); end

  class << self
    # @api private
    def base_url_for(cop_class, config); end

    # @api private
    def default_base_url; end

    # @api private
    def department_to_basename(department); end

    # @api private
    def url_for(cop_class, config = T.unsafe(nil)); end
  end
end

# Common functionality for checking documentation.
module RuboCop::Cop::DocumentationComment
  extend ::RuboCop::AST::NodePattern::Macros

  private

  def annotation_keywords; end

  # @return [Boolean]
  def documentation_comment?(node); end

  # @return [Boolean]
  def interpreter_directive_comment?(comment); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  def precede?(node1, node2); end

  # The args node1 & node2 may represent a RuboCop::AST::Node
  # or a Parser::Source::Comment. Both respond to #loc.
  #
  # @return [Boolean]
  def preceding_comment?(node1, node2); end

  def preceding_lines(node); end

  # @return [Boolean]
  def rubocop_directive_comment?(comment); end
end

# Common functionality for dealing with duplication.
module RuboCop::Cop::Duplication
  private

  # Returns the consecutive duplicates, leaving out the first instance of
  # the duplicated elements.
  #
  # @param collection [Array] an array to return consecutive duplicates for
  # @return [Array] the consecutive duplicates
  def consecutive_duplicates(collection); end

  # Returns all duplicates, including the first instance of the duplicated
  # elements.
  #
  # @param collection [Array] an array to return duplicates for
  # @return [Array] all the duplicates
  def duplicates(collection); end

  # Whether the `collection` contains any duplicates.
  #
  # @param collection [Array] an array to check for duplicates
  # @return [Boolean] whether the array contains any duplicates
  def duplicates?(collection); end

  # Returns a hash of grouped duplicates. The key will be the first
  # instance of the element, and  the value an `array` of the initial
  # element and all duplicate instances.
  #
  # @param collection [Array] an array to group duplicates for
  # @return [Array] the grouped duplicates
  def grouped_duplicates(collection); end
end

# This class autocorrects `#each` enumeration to `for` iteration.
class RuboCop::Cop::EachToForCorrector
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [EachToForCorrector] a new instance of EachToForCorrector
  def initialize(block_node); end

  def call(corrector); end

  private

  # Returns the value of attribute argument_node.
  def argument_node; end

  # Returns the value of attribute block_node.
  def block_node; end

  # Returns the value of attribute collection_node.
  def collection_node; end

  def correction; end
  def offending_range; end
  def replacement_range(end_pos); end
end

RuboCop::Cop::EachToForCorrector::CORRECTION_WITHOUT_ARGUMENTS = T.let(T.unsafe(nil), String)
RuboCop::Cop::EachToForCorrector::CORRECTION_WITH_ARGUMENTS = T.let(T.unsafe(nil), String)

# This class does empty line autocorrection
class RuboCop::Cop::EmptyLineCorrector
  class << self
    def correct(corrector, node); end
    def insert_before(corrector, node); end
  end
end

# Common code for empty parameter cops.
module RuboCop::Cop::EmptyParameter
  extend ::RuboCop::AST::NodePattern::Macros

  def empty_arguments?(param0 = T.unsafe(nil)); end

  private

  def check(node); end
end

# Functions for checking the alignment of the `end` keyword.
module RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  private

  # @return [Boolean]
  def accept_end_kw_alignment?(end_loc); end

  def add_offense_for_misalignment(node, align_with); end
  def check_end_kw_alignment(node, align_ranges); end
  def check_end_kw_in_node(node); end

  # @return [Boolean]
  def line_break_before_keyword?(whole_expression, rhs); end

  def matching_ranges(end_loc, align_ranges); end
  def start_line_range(node); end
  def style_parameter_name; end

  # @return [Boolean]
  def variable_alignment?(whole_expression, rhs, end_alignment_style); end
end

RuboCop::Cop::EndKeywordAlignment::MSG = T.let(T.unsafe(nil), String)

# Common functionality for enforcing a specific superclass.
#
# IMPORTANT: RuboCop core depended on this module when it supported Rails department.
# Rails department has been extracted to RuboCop Rails gem.
#
# It will not be updated to `RuboCop::Cop::Base` v1 API to maintain compatibility
# with existing RuboCop Rails 2.8 or lower.
#
# @api private
# @deprecated This module is deprecated and will be removed by RuboCop 2.0.
module RuboCop::Cop::EnforceSuperclass
  # @api private
  def on_class(node); end

  # @api private
  def on_send(node); end

  class << self
    # @api private
    # @private
    def included(base); end
  end
end

# Common functionality for checking for a line break before the first
# element in a multi-line collection.
module RuboCop::Cop::FirstElementLineBreak
  private

  def check_children_line_break(node, children, start = T.unsafe(nil)); end
  def check_method_line_break(node, children); end
  def first_by_line(nodes); end
  def last_by_line(nodes); end

  # @return [Boolean]
  def method_uses_parens?(node, limit); end
end

# This class autocorrects `for` iteration to `#each` enumeration.
class RuboCop::Cop::ForToEachCorrector
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [ForToEachCorrector] a new instance of ForToEachCorrector
  def initialize(for_node); end

  def call(corrector); end

  private

  def collection_end; end

  # Returns the value of attribute collection_node.
  def collection_node; end

  def collection_source; end
  def correction; end
  def end_position; end

  # Returns the value of attribute for_node.
  def for_node; end

  def keyword_begin; end
  def offending_range; end
  def replacement_range(end_pos); end

  # @return [Boolean]
  def requires_parentheses?; end

  # Returns the value of attribute variable_node.
  def variable_node; end
end

RuboCop::Cop::ForToEachCorrector::CORRECTION = T.let(T.unsafe(nil), String)

# A scaffold for concrete forces.
class RuboCop::Cop::Force
  # @return [Force] a new instance of Force
  def initialize(cops); end

  # Returns the value of attribute cops.
  def cops; end

  def investigate(_processed_source); end
  def name; end
  def run_hook(method_name, *args); end

  class << self
    def all; end
    def force_name; end

    # @private
    def inherited(subclass); end
  end
end

# Common functionality for dealing with frozen string literals.
module RuboCop::Cop::FrozenStringLiteral
  private

  def frozen_heredoc?(node); end
  def frozen_string_literal?(node); end
  def frozen_string_literal_comment_exists?; end
  def frozen_string_literal_specified?; end
  def frozen_string_literals_disabled?; end
  def frozen_string_literals_enabled?; end
  def leading_comment_lines; end
  def uninterpolated_string?(node); end

  class << self
    # @return [Boolean]
    def frozen_string_literal_comment_exists?; end
  end
end

RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL = T.let(T.unsafe(nil), String)
RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL_ENABLED = T.let(T.unsafe(nil), String)
RuboCop::Cop::FrozenStringLiteral::FROZEN_STRING_LITERAL_TYPES_RUBY27 = T.let(T.unsafe(nil), Array)

# Common functionality for checking gem declarations.
module RuboCop::Cop::GemDeclaration
  extend ::RuboCop::AST::NodePattern::Macros

  def gem_declaration?(param0 = T.unsafe(nil)); end
end

module RuboCop::Cop::Gemspec; end

# Enforce that gem dependency version specifications or a commit reference (branch,
# ref, or tag) are either required or forbidden.
#
# @example EnforcedStyle: required (default)
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
# @example EnforcedStyle: forbidden
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser', '>= 2.3.3.1', '< 3.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_dependency 'parser'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_development_dependency 'parser'
#   end
class RuboCop::Cop::Gemspec::DependencyVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::GemspecHelp

  def add_dependency_method_declarations(param0); end
  def includes_commit_reference?(param0 = T.unsafe(nil)); end
  def includes_version_specification?(param0 = T.unsafe(nil)); end
  def on_new_investigation; end

  private

  # @return [Boolean]
  def add_dependency_method?(method_name); end

  def add_dependency_method_nodes; end

  # @return [Boolean]
  def allowed_gem?(node); end

  def allowed_gems; end

  # @return [Boolean]
  def forbidden_offense?(node); end

  # @return [Boolean]
  def forbidden_style?; end

  # @return [Boolean]
  def match_block_variable_name?(receiver_name); end

  def message(range); end

  # @return [Boolean]
  def offense?(node); end

  # @return [Boolean]
  def required_offense?(node); end

  # @return [Boolean]
  def required_style?; end

  # @return [Boolean]
  def version_specification?(expression); end
end

RuboCop::Cop::Gemspec::DependencyVersion::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Gemspec::DependencyVersion::REQUIRED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Gemspec::DependencyVersion::VERSION_SPECIFICATION_REGEX = T.let(T.unsafe(nil), Regexp)

# Checks that deprecated attribute attributes are not set in a gemspec file.
# Removing deprecated attributes allows the user to receive smaller packed gems.
#
# @example
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   spec.test_files = Dir.glob('test/**/*')
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   spec.test_files += Dir.glob('test/**/*')
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.name = 'your_cool_gem_name'
#   end
class RuboCop::Cop::Gemspec::DeprecatedAttributeAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def gem_specification(param0 = T.unsafe(nil)); end
  def on_block(block_node); end

  private

  def format_message_from; end
  def node_and_method_name(node, attribute); end

  # @return [Boolean]
  def use_deprecated_attributes?(node, block_parameter); end
end

RuboCop::Cop::Gemspec::DeprecatedAttributeAssignment::MSG = T.let(T.unsafe(nil), String)

# An attribute assignment method calls should be listed only once
# in a gemspec.
#
# Assigning to an attribute with the same name using `spec.foo =` will be
# an unintended usage. On the other hand, duplication of methods such
# as `spec.requirements`, `spec.add_runtime_dependency`, and others are
# permitted because it is the intended use of appending values.
#
# @example
#   # bad
#   Gem::Specification.new do |spec|
#   spec.name = 'rubocop'
#   spec.name = 'rubocop2'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.name = 'rubocop'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.requirements << 'libmagick, v6.0'
#   spec.requirements << 'A good graphics card'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_runtime_dependency('parallel', '~> 1.10')
#   spec.add_runtime_dependency('parser', '>= 2.3.3.1', '< 3.0')
#   end
class RuboCop::Cop::Gemspec::DuplicatedAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::GemspecHelp

  def assignment_method_declarations(param0); end
  def on_new_investigation; end

  private

  def duplicated_assignment_method_nodes; end

  # @return [Boolean]
  def match_block_variable_name?(receiver_name); end

  def register_offense(node, assignment, line_of_first_occurrence); end
end

RuboCop::Cop::Gemspec::DuplicatedAssignment::MSG = T.let(T.unsafe(nil), String)

# Dependencies in the gemspec should be alphabetically sorted.
#
# @example
#   # bad
#   spec.add_dependency 'rubocop'
#   spec.add_dependency 'rspec'
#
#   # good
#   spec.add_dependency 'rspec'
#   spec.add_dependency 'rubocop'
#
#   # good
#   spec.add_dependency 'rubocop'
#
#   spec.add_dependency 'rspec'
#
#   # bad
#   spec.add_development_dependency 'rubocop'
#   spec.add_development_dependency 'rspec'
#
#   # good
#   spec.add_development_dependency 'rspec'
#   spec.add_development_dependency 'rubocop'
#
#   # good
#   spec.add_development_dependency 'rubocop'
#
#   spec.add_development_dependency 'rspec'
#
#   # bad
#   spec.add_runtime_dependency 'rubocop'
#   spec.add_runtime_dependency 'rspec'
#
#   # good
#   spec.add_runtime_dependency 'rspec'
#   spec.add_runtime_dependency 'rubocop'
#
#   # good
#   spec.add_runtime_dependency 'rubocop'
#
#   spec.add_runtime_dependency 'rspec'
#
#   # good only if TreatCommentsAsGroupSeparators is true
#   # For code quality
#   spec.add_dependency 'rubocop'
#   # For tests
#   spec.add_dependency 'rspec'
class RuboCop::Cop::Gemspec::OrderedDependencies < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::AutoCorrector

  def dependency_declarations(param0); end
  def on_new_investigation; end

  private

  def get_dependency_name(node); end
  def previous_declaration(node); end
end

RuboCop::Cop::Gemspec::OrderedDependencies::MSG = T.let(T.unsafe(nil), String)

# Requires a gemspec to have `rubygems_mfa_required` metadata set.
#
# This setting tells RubyGems that MFA (Multi-Factor Authentication) is
# required for accounts to be able perform privileged operations, such as
# (see RubyGems' documentation for the full list of privileged
# operations):
#
# * `gem push`
# * `gem yank`
# * `gem owner --add/remove`
# * adding or removing owners using gem ownership page
#
# This helps make your gem more secure, as users can be more
# confident that gem updates were pushed by maintainers.
#
# @example
#   # bad
#   Gem::Specification.new do |spec|
#   # no `rubygems_mfa_required` metadata specified
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'true'
#   }
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'true'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'false'
#   }
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata = {
#   'rubygems_mfa_required' => 'true'
#   }
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'false'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.metadata['rubygems_mfa_required'] = 'true'
#   end
class RuboCop::Cop::Gemspec::RequireMFA < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::GemspecHelp
  extend ::RuboCop::Cop::AutoCorrector

  def metadata(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def rubygems_mfa_required(param0); end
  def true_string?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node, block_var, metadata); end
  def change_value(corrector, value); end
  def correct_metadata(corrector, metadata); end
  def insert_mfa_required(corrector, node, block_var); end
  def mfa_value(metadata_value); end
end

RuboCop::Cop::Gemspec::RequireMFA::MSG = T.let(T.unsafe(nil), String)

# Checks that `required_ruby_version` in a gemspec file is set to a valid
# value (non-blank) and matches `TargetRubyVersion` as set in RuboCop's
# configuration for the gem.
#
# This ensures that RuboCop is using the same Ruby version as the gem.
#
# @example
#   # When `TargetRubyVersion` of .rubocop.yml is `2.5`.
#
#   # bad
#   Gem::Specification.new do |spec|
#   # no `required_ruby_version` specified
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.4.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.6.0'
#   end
#
#   # bad
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = ''
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.5.0'
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '>= 2.5'
#   end
#
#   # accepted but not recommended
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = ['>= 2.5.0', '< 2.7.0']
#   end
#
#   # accepted but not recommended, since
#   # Ruby does not really follow semantic versioning
#   Gem::Specification.new do |spec|
#   spec.required_ruby_version = '~> 2.5'
#   end
class RuboCop::Cop::Gemspec::RequiredRubyVersion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def defined_ruby_version(param0 = T.unsafe(nil)); end
  def on_new_investigation; end
  def on_send(node); end
  def required_ruby_version?(param0); end

  private

  # @return [Boolean]
  def dynamic_version?(node); end

  def extract_ruby_version(required_ruby_version); end
  def not_equal_message(required_ruby_version, target_ruby_version); end
end

RuboCop::Cop::Gemspec::RequiredRubyVersion::MISSING_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Gemspec::RequiredRubyVersion::NOT_EQUAL_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Gemspec::RequiredRubyVersion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks that `RUBY_VERSION` constant is not used in gemspec.
# Using `RUBY_VERSION` is dangerous because value of the
# constant is determined by `rake release`.
# It's possible to have dependency based on ruby version used
# to execute `rake release` and not user's ruby version.
#
# @example
#
#   # bad
#   Gem::Specification.new do |spec|
#   if RUBY_VERSION >= '3.0'
#   spec.add_runtime_dependency 'gem_a'
#   else
#   spec.add_runtime_dependency 'gem_b'
#   end
#   end
#
#   # good
#   Gem::Specification.new do |spec|
#   spec.add_runtime_dependency 'gem_a'
#   end
class RuboCop::Cop::Gemspec::RubyVersionGlobalsUsage < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::GemspecHelp

  def on_const(node); end
  def ruby_version?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def gem_spec_with_ruby_version?(node); end
end

RuboCop::Cop::Gemspec::RubyVersionGlobalsUsage::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking gem declarations.
module RuboCop::Cop::GemspecHelp
  extend ::RuboCop::AST::NodePattern::Macros

  def gem_specification(param0); end
  def gem_specification?(param0 = T.unsafe(nil)); end
end

# Source and spec generator for new cops
#
# This generator will take a cop name and generate a source file
# and spec file when given a valid qualified cop name.
#
# @api private
class RuboCop::Cop::Generator
  # @api private
  # @raise [ArgumentError]
  # @return [Generator] a new instance of Generator
  def initialize(name, output: T.unsafe(nil)); end

  # @api private
  def inject_config(config_file_path: T.unsafe(nil), version_added: T.unsafe(nil)); end

  # @api private
  def inject_require(root_file_path: T.unsafe(nil)); end

  # @api private
  def todo; end

  # @api private
  def write_source; end

  # @api private
  def write_spec; end

  private

  # @api private
  def badge; end

  # @api private
  def generate(template); end

  # @api private
  def generated_source; end

  # @api private
  def generated_spec; end

  # @api private
  def output; end

  # @api private
  def snake_case(camel_case_string); end

  # @api private
  def source_path; end

  # @api private
  def spec_path; end

  # @api private
  def write_unless_file_exists(path, contents); end
end

# @api private
RuboCop::Cop::Generator::CONFIGURATION_ADDED_MESSAGE = T.let(T.unsafe(nil), String)

# A class that injects a require directive into the root RuboCop file.
# It looks for other directives that require files in the same (cop)
# namespace and injects the provided one in alpha
class RuboCop::Cop::Generator::ConfigurationInjector
  # @return [ConfigurationInjector] a new instance of ConfigurationInjector
  def initialize(configuration_file_path:, badge:, version_added: T.unsafe(nil)); end

  def inject; end

  private

  # Returns the value of attribute badge.
  def badge; end

  def configuration_entries; end

  # Returns the value of attribute configuration_file_path.
  def configuration_file_path; end

  # @return [Boolean]
  def cop_name_line?(yaml); end

  def find_target_line; end
  def new_configuration_entry; end

  # Returns the value of attribute output.
  def output; end

  # Returns the value of attribute version_added.
  def version_added; end
end

RuboCop::Cop::Generator::ConfigurationInjector::TEMPLATE = T.let(T.unsafe(nil), String)

# A class that injects a require directive into the root RuboCop file.
# It looks for other directives that require files in the same (cop)
# namespace and injects the provided one in alpha
class RuboCop::Cop::Generator::RequireFileInjector
  # @return [RequireFileInjector] a new instance of RequireFileInjector
  def initialize(source_path:, root_file_path:, output: T.unsafe(nil)); end

  def inject; end

  private

  def injectable_require_directive; end

  # Returns the value of attribute output.
  def output; end

  # Returns the value of attribute require_entries.
  def require_entries; end

  # @return [Boolean]
  def require_exists?; end

  def require_path; end
  def require_path_fragments(require_directive); end

  # Returns the value of attribute root_file_path.
  def root_file_path; end

  # Returns the value of attribute source_path.
  def source_path; end

  def target_line; end
  def updated_directives; end
end

RuboCop::Cop::Generator::RequireFileInjector::REQUIRE_PATH = T.let(T.unsafe(nil), Regexp)

# @api private
RuboCop::Cop::Generator::SOURCE_TEMPLATE = T.let(T.unsafe(nil), String)

# @api private
RuboCop::Cop::Generator::SPEC_TEMPLATE = T.let(T.unsafe(nil), String)

# Common functionality for checking hash alignment.
module RuboCop::Cop::HashAlignmentStyles; end

# Handles calculation of deltas when the enforced style is 'key'.
class RuboCop::Cop::HashAlignmentStyles::KeyAlignment
  # @return [Boolean]
  def checkable_layout?(_node); end

  def deltas(first_pair, current_pair); end
  def deltas_for_first_pair(first_pair, _node); end

  private

  def separator_delta(pair); end
  def value_delta(pair); end
end

# Handles calculation of deltas for `kwsplat` nodes.
# This is a special case that just ensures the kwsplat is aligned with the rest of the hash
# since a `kwsplat` does not have a key, separator or value.
class RuboCop::Cop::HashAlignmentStyles::KeywordSplatAlignment
  def deltas(first_pair, current_pair); end
end

# Handles calculation of deltas when the enforced style is 'separator'.
class RuboCop::Cop::HashAlignmentStyles::SeparatorAlignment
  include ::RuboCop::Cop::HashAlignmentStyles::ValueAlignment

  def deltas_for_first_pair(*_nodes); end

  private

  def hash_rocket_delta(first_pair, current_pair); end
  def key_delta(first_pair, current_pair); end
  def value_delta(first_pair, current_pair); end
end

# Handles calculation of deltas when the enforced style is 'table'.
class RuboCop::Cop::HashAlignmentStyles::TableAlignment
  include ::RuboCop::Cop::HashAlignmentStyles::ValueAlignment

  # @return [TableAlignment] a new instance of TableAlignment
  def initialize; end

  def deltas_for_first_pair(first_pair, node); end

  private

  def hash_rocket_delta(first_pair, current_pair); end
  def key_delta(first_pair, current_pair); end

  # Returns the value of attribute max_key_width.
  def max_key_width; end

  # Sets the attribute max_key_width
  #
  # @param value the value to set the attribute max_key_width to.
  def max_key_width=(_arg0); end

  def value_delta(first_pair, current_pair); end
end

# Common functionality for checking alignment of hash values.
module RuboCop::Cop::HashAlignmentStyles::ValueAlignment
  # @return [Boolean]
  def checkable_layout?(node); end

  def deltas(first_pair, current_pair); end

  private

  def separator_delta(first_pair, current_pair, key_delta); end
end

# This module checks for Ruby 3.1's hash value omission syntax.
module RuboCop::Cop::HashShorthandSyntax
  def on_hash_for_mixed_shorthand(hash_node); end
  def on_pair(node); end

  private

  def breakdown_value_types_of_hash(hash_node); end
  def each_omittable_value_pair(hash_value_type_breakdown, &block); end
  def each_omitted_value_pair(hash_value_type_breakdown, &block); end
  def enforced_shorthand_syntax; end

  # @return [Boolean]
  def hash_with_mixed_shorthand_syntax?(hash_value_type_breakdown); end

  # @return [Boolean]
  def hash_with_values_that_cant_be_omitted?(hash_value_type_breakdown); end

  # @return [Boolean]
  def ignore_hash_shorthand_syntax?(pair_node); end

  # @return [Boolean]
  def ignore_mixed_hash_shorthand_syntax?(hash_node); end

  def mixed_shorthand_syntax_check(hash_value_type_breakdown); end
  def no_mixed_shorthand_syntax_check(hash_value_type_breakdown); end
  def register_offense(node, message, replacement); end

  # @return [Boolean]
  def require_hash_value?(hash_key_source, node); end

  # @return [Boolean]
  def require_hash_value_for_around_hash_literal?(node); end

  # @return [Boolean]
  def use_element_of_hash_literal_as_receiver?(ancestor, parent); end

  # @return [Boolean]
  def use_modifier_form_without_parenthesized_method_call?(ancestor); end

  # @return [Boolean]
  def without_parentheses_call_expr_follows?(ancestor); end
end

RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_EXPLICIT_VALUE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_MSG_PREFIX = T.let(T.unsafe(nil), String)
RuboCop::Cop::HashShorthandSyntax::DO_NOT_MIX_OMIT_VALUE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::HashShorthandSyntax::EXPLICIT_HASH_VALUE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::HashShorthandSyntax::OMIT_HASH_VALUE_MSG = T.let(T.unsafe(nil), String)

# Common functionality for Style/HashTransformKeys and
# Style/HashTransformValues
module RuboCop::Cop::HashTransformMethod
  extend ::RuboCop::AST::NodePattern::Macros

  def array_receiver?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_csend(node); end
  def on_send(node); end

  private

  def execute_correction(corrector, node, correction); end

  # @abstract
  # @raise [NotImplementedError]
  # @return [Captures]
  def extract_captures(_match); end

  def handle_possible_offense(node, match, match_desc); end

  # @abstract
  # @raise [NotImplementedError]
  # @return [String]
  def new_method_name; end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  def on_bad_each_with_object(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  def on_bad_hash_brackets_map(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  def on_bad_map_to_h(_node); end

  # @abstract Implemented with `def_node_matcher`
  # @raise [NotImplementedError]
  def on_bad_to_h(_node); end

  def prepare_correction(node); end
end

# Internal helper class to hold autocorrect data
class RuboCop::Cop::HashTransformMethod::Autocorrection < ::Struct
  # Returns the value of attribute block_node
  #
  # @return [Object] the current value of block_node
  def block_node; end

  # Sets the attribute block_node
  #
  # @param value [Object] the value to set the attribute block_node to.
  # @return [Object] the newly set value
  def block_node=(_); end

  # Returns the value of attribute leading
  #
  # @return [Object] the current value of leading
  def leading; end

  # Sets the attribute leading
  #
  # @param value [Object] the value to set the attribute leading to.
  # @return [Object] the newly set value
  def leading=(_); end

  # Returns the value of attribute match
  #
  # @return [Object] the current value of match
  def match; end

  # Sets the attribute match
  #
  # @param value [Object] the value to set the attribute match to.
  # @return [Object] the newly set value
  def match=(_); end

  def set_new_arg_name(transformed_argname, corrector); end
  def set_new_body_expression(transforming_body_expr, corrector); end
  def set_new_method_name(new_method_name, corrector); end
  def strip_prefix_and_suffix(node, corrector); end

  # Returns the value of attribute trailing
  #
  # @return [Object] the current value of trailing
  def trailing; end

  # Sets the attribute trailing
  #
  # @param value [Object] the value to set the attribute trailing to.
  # @return [Object] the newly set value
  def trailing=(_); end

  class << self
    def [](*_arg0); end
    def from_each_with_object(node, match); end
    def from_hash_brackets_map(node, match); end
    def from_map_to_h(node, match); end
    def from_to_h(node, match); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Internal helper class to hold match data
class RuboCop::Cop::HashTransformMethod::Captures < ::Struct
  # @return [Boolean]
  def noop_transformation?; end

  # @return [Boolean]
  def transformation_uses_both_args?; end

  # Returns the value of attribute transformed_argname
  #
  # @return [Object] the current value of transformed_argname
  def transformed_argname; end

  # Sets the attribute transformed_argname
  #
  # @param value [Object] the value to set the attribute transformed_argname to.
  # @return [Object] the newly set value
  def transformed_argname=(_); end

  # Returns the value of attribute transforming_body_expr
  #
  # @return [Object] the current value of transforming_body_expr
  def transforming_body_expr; end

  # Sets the attribute transforming_body_expr
  #
  # @param value [Object] the value to set the attribute transforming_body_expr to.
  # @return [Object] the newly set value
  def transforming_body_expr=(_); end

  # Returns the value of attribute unchanged_body_expr
  #
  # @return [Object] the current value of unchanged_body_expr
  def unchanged_body_expr; end

  # Sets the attribute unchanged_body_expr
  #
  # @param value [Object] the value to set the attribute unchanged_body_expr to.
  # @return [Object] the newly set value
  def unchanged_body_expr=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RuboCop::Cop::HashTransformMethod::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Common functionality for working with heredoc strings.
module RuboCop::Cop::Heredoc
  def on_dstr(node); end

  # @raise [NotImplementedError]
  def on_heredoc(_node); end

  def on_str(node); end
  def on_xstr(node); end

  private

  def delimiter_string(node); end
  def heredoc_type(node); end
  def indent_level(str); end
end

RuboCop::Cop::Heredoc::OPENING_DELIMITER = T.let(T.unsafe(nil), Regexp)

# This class autocorrects `if...then` structures to a multiline `if` statement
class RuboCop::Cop::IfThenCorrector
  # @return [IfThenCorrector] a new instance of IfThenCorrector
  def initialize(if_node, indentation: T.unsafe(nil)); end

  def call(corrector); end

  private

  def branch_body_indentation; end

  # Returns the value of attribute if_node.
  def if_node; end

  # Returns the value of attribute indentation.
  def indentation; end

  def replacement(node = T.unsafe(nil), indentation = T.unsafe(nil)); end
  def rewrite_else_branch(else_branch, indentation); end
end

RuboCop::Cop::IfThenCorrector::DEFAULT_INDENTATION_WIDTH = T.let(T.unsafe(nil), Integer)

# @deprecated IgnoredMethods class has been replaced with AllowedMethods.
RuboCop::Cop::IgnoredMethods = RuboCop::Cop::AllowedMethods

# Handles adding and checking ignored nodes.
module RuboCop::Cop::IgnoredNode
  def ignore_node(node); end

  # @return [Boolean]
  def ignored_node?(node); end

  # @return [Boolean]
  def part_of_ignored_node?(node); end

  private

  def ignored_nodes; end
end

# @deprecated IgnoredPattern class has been replaced with AllowedPattern.
RuboCop::Cop::IgnoredPattern = RuboCop::Cop::AllowedPattern

# Common functionality for checking integer nodes.
module RuboCop::Cop::IntegerNode
  private

  def integer_part(node); end
end

# Common functionality for working with string interpolations.
#
# @abstract Subclasses are expected to implement {#on_interpolation}.
module RuboCop::Cop::Interpolation
  def on_dstr(node); end
  def on_dsym(node); end
  def on_node_with_interpolations(node); end
  def on_regexp(node); end
  def on_xstr(node); end
end

# This class autocorrects lambda literal to method notation.
class RuboCop::Cop::LambdaLiteralToMethodCorrector
  # @return [LambdaLiteralToMethodCorrector] a new instance of LambdaLiteralToMethodCorrector
  def initialize(block_node); end

  def call(corrector); end

  private

  # @return [Boolean]
  def arg_to_unparenthesized_call?; end

  # Returns the value of attribute arguments.
  def arguments; end

  def arguments_begin_pos; end
  def arguments_end_pos; end
  def block_begin; end
  def block_end; end

  # Returns the value of attribute block_node.
  def block_node; end

  def insert_arguments(corrector); end
  def insert_separating_space(corrector); end
  def lambda_arg_string; end

  # Returns the value of attribute method.
  def method; end

  # @return [Boolean]
  def needs_separating_space?; end

  def remove_arguments(corrector); end
  def remove_leading_whitespace(corrector); end
  def remove_trailing_whitespace(corrector); end
  def remove_unparenthesized_whitespace(corrector); end
  def replace_delimiters(corrector); end
  def replace_selector(corrector); end
  def selector_end; end

  # @return [Boolean]
  def separating_space?; end
end

module RuboCop::Cop::Layout; end

# Bare access modifiers (those not applying to specific methods) should be
# indented as deep as method definitions, or as deep as the class/module
# keyword, depending on configuration.
#
# @example EnforcedStyle: indent (default)
#   # bad
#   class Plumbus
#   private
#   def smooth; end
#   end
#
#   # good
#   class Plumbus
#   private
#   def smooth; end
#   end
# @example EnforcedStyle: outdent
#   # bad
#   class Plumbus
#   private
#   def smooth; end
#   end
#
#   # good
#   class Plumbus
#   private
#   def smooth; end
#   end
class RuboCop::Cop::Layout::AccessModifierIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_class(node); end
  def on_module(node); end
  def on_sclass(node); end

  private

  def autocorrect(corrector, node); end
  def check_body(body, node); end
  def check_modifier(send_node, end_range); end
  def expected_indent_offset; end
  def message(range); end

  # An offset that is not expected, but correct if the configuration is
  # changed.
  def unexpected_indent_offset; end
end

RuboCop::Cop::Layout::AccessModifierIndentation::MSG = T.let(T.unsafe(nil), String)

# Here we check if the arguments on a multi-line method
# definition are aligned.
#
# @example EnforcedStyle: with_first_argument (default)
#   # good
#
#   foo :bar,
#   :baz,
#   key: value
#
#   foo(
#   :bar,
#   :baz,
#   key: value
#   )
#
#   # bad
#
#   foo :bar,
#   :baz,
#   key: value
#
#   foo(
#   :bar,
#   :baz,
#   key: value
#   )
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   foo :bar,
#   :baz,
#   key: value
#
#   # bad
#
#   foo :bar,
#   :baz,
#   key: value
class RuboCop::Cop::Layout::ArgumentAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  def arguments_or_first_arg_pairs(node); end
  def arguments_with_last_arg_pairs(node); end
  def autocorrect(corrector, node); end

  # @return [Boolean]
  def autocorrect_incompatible_with_other_cops?; end

  def base_column(node, first_argument); end

  # @return [Boolean]
  def enforce_hash_argument_with_separator?; end

  # @return [Boolean]
  def fixed_indentation?; end

  def flattened_arguments(node); end
  def hash_argument_config; end
  def message(_node); end

  # @return [Boolean]
  def multiple_arguments?(node); end

  def target_method_lineno(node); end

  # @return [Boolean]
  def with_first_argument_style?; end
end

RuboCop::Cop::Layout::ArgumentAlignment::ALIGN_PARAMS_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ArgumentAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Here we check if the elements of a multi-line array literal are
# aligned.
#
# @example EnforcedStyle: with_first_element (default)
#   # good
#
#   array = [1, 2, 3,
#   4, 5, 6]
#   array = ['run',
#   'forrest',
#   'run']
#
#   # bad
#
#   array = [1, 2, 3,
#   4, 5, 6]
#   array = ['run',
#   'forrest',
#   'run']
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   array = [1, 2, 3,
#   4, 5, 6]
#
#   # bad
#
#   array = [1, 2, 3,
#   4, 5, 6]
class RuboCop::Cop::Layout::ArrayAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end

  private

  def autocorrect(corrector, node); end
  def base_column(node, args); end

  # @return [Boolean]
  def fixed_indentation?; end

  def message(_range); end
  def target_method_lineno(node); end
end

RuboCop::Cop::Layout::ArrayAlignment::ALIGN_ELEMENTS_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ArrayAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first line of the
# right-hand-side of a multi-line assignment.
#
# The indentation of the remaining lines can be corrected with
# other cops such as `IndentationConsistency` and `EndAlignment`.
#
# @example
#   # bad
#   value =
#   if foo
#   'bar'
#   end
#
#   # good
#   value =
#   if foo
#   'bar'
#   end
class RuboCop::Cop::Layout::AssignmentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  private

  def autocorrect(corrector, node); end
  def check_assignment(node, rhs); end
  def leftmost_multiple_assignment(node); end
end

RuboCop::Cop::Layout::AssignmentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keyword of `begin` is aligned properly.
#
# Two modes are supported through the `EnforcedStyleAlignWith` configuration
# parameter. If it's set to `start_of_line` (which is the default), the
# `end` shall be aligned with the start of the line where the `begin`
# keyword is. If it's set to `begin`, the `end` shall be aligned with the
# `begin` keyword.
#
# `Layout/EndAlignment` cop aligns with keywords (e.g. `if`, `while`, `case`)
# by default. On the other hand, `||= begin` that this cop targets tends to
# align with the start of the line, it defaults to `EnforcedStyleAlignWith: start_of_line`.
# These style can be configured by each cop.
#
# @example EnforcedStyleAlignWith: start_of_line (default)
#   # bad
#   foo ||= begin
#   do_something
#   end
#
#   # good
#   foo ||= begin
#   do_something
#   end
# @example EnforcedStyleAlignWith: begin
#   # bad
#   foo ||= begin
#   do_something
#   end
#
#   # good
#   foo ||= begin
#   do_something
#   end
class RuboCop::Cop::Layout::BeginEndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_kwbegin(node); end

  private

  def alignment_node(node); end
  def autocorrect(corrector, node); end
  def check_begin_alignment(node); end
end

RuboCop::Cop::Layout::BeginEndAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keywords are aligned properly for do
# end blocks.
#
# Three modes are supported through the `EnforcedStyleAlignWith`
# configuration parameter:
#
# `start_of_block` : the `end` shall be aligned with the
# start of the line where the `do` appeared.
#
# `start_of_line` : the `end` shall be aligned with the
# start of the line where the expression started.
#
# `either` (which is the default) : the `end` is allowed to be in either
# location. The autofixer will default to `start_of_line`.
#
# @example EnforcedStyleAlignWith: either (default)
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   variable = lambda do |i|
#   i
#   end
# @example EnforcedStyleAlignWith: start_of_block
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   foo.bar
#   .each do
#   baz
#   end
# @example EnforcedStyleAlignWith: start_of_line
#   # bad
#
#   foo.bar
#   .each do
#   baz
#   end
#
#   # good
#
#   foo.bar
#   .each do
#   baz
#   end
class RuboCop::Cop::Layout::BlockAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def block_end_align_target?(param0 = T.unsafe(nil), param1); end
  def on_block(node); end
  def on_numblock(node); end
  def style_parameter_name; end

  private

  def add_space_before(corrector, loc, delta); end
  def alt_start_msg(start_loc, source_line_column); end
  def autocorrect(corrector, node); end
  def block_end_align_target(node); end
  def check_block_alignment(start_node, block_node); end
  def compute_do_source_line_column(node, end_loc); end
  def compute_start_col(ancestor_node, node); end

  # @return [Boolean]
  def disqualified_parent?(parent, node); end

  # @return [Boolean]
  def end_align_target?(node, parent); end

  def format_message(start_loc, end_loc, do_source_line_column, error_source_line_column); end
  def format_source_line_column(source_line_column); end
  def loc_to_source_line_column(loc); end
  def register_offense(block_node, start_loc, end_loc, do_source_line_column); end
  def remove_space_before(corrector, end_pos, delta); end
  def start_for_block_node(block_node); end
end

RuboCop::Cop::Layout::BlockAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end statement of a do..end block
# is on its own line.
#
# @example
#   # bad
#   blah do |i|
#   foo(i) end
#
#   # good
#   blah do |i|
#   foo(i)
#   end
#
#   # bad
#   blah { |i|
#   foo(i) }
#
#   # good
#   blah { |i|
#   foo(i)
#   }
class RuboCop::Cop::Layout::BlockEndNewline < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end

  private

  def end_of_method_chain(node); end
  def last_heredoc_argument(node); end
  def message(node); end
  def offense_range(node); end
  def register_offense(node); end
end

RuboCop::Cop::Layout::BlockEndNewline::MSG = T.let(T.unsafe(nil), String)

# Checks how the `when` and ``in``s of a `case` expression
# are indented in relation to its `case` or `end` keyword.
#
# It will register a separate offense for each misaligned `when` and `in`.
#
# @example
#   # If Layout/EndAlignment is set to keyword style (default)
#   # *case* and *end* should always be aligned to same depth,
#   # and therefore *when* should always be aligned to both -
#   # regardless of configuration.
#
#   # bad for all styles
#   case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good for all styles
#   case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
# @example EnforcedStyle: case (default)
#   # if EndAlignment is set to other style such as
#   # start_of_line (as shown below), then *when* alignment
#   # configuration does have an effect.
#
#   # bad
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
# @example EnforcedStyle: end
#   # bad
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
#
#   # good
#   a = case n
#   when 0
#   x * 2
#   else
#   y / 3
#   end
#
#   a = case n
#   in pattern
#   x * 2
#   else
#   y / 3
#   end
class RuboCop::Cop::Layout::CaseIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(case_node); end
  def on_case_match(case_match_node); end

  private

  def base_column(case_node, base); end
  def check_when(when_node, branch_type); end
  def detect_incorrect_style(when_node); end

  # @return [Boolean]
  def end_and_last_conditional_same_line?(node); end

  # @return [Boolean]
  def enforced_style_end?; end

  def incorrect_style(when_node, branch_type); end

  # @return [Boolean]
  def indent_one_step?; end

  def indentation_width; end
  def replacement(node); end
  def whitespace_range(node); end
end

RuboCop::Cop::Layout::CaseIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks if the code style follows the ExpectedOrder configuration:
#
# `Categories` allows us to map macro names into a category.
#
# Consider an example of code style that covers the following order:
#
# * Module inclusion (include, prepend, extend)
# * Constants
# * Associations (has_one, has_many)
# * Public attribute macros (attr_accessor, attr_writer, attr_reader)
# * Other macros (validates, validate)
# * Public class methods
# * Initializer
# * Public instance methods
# * Protected attribute macros (attr_accessor, attr_writer, attr_reader)
# * Protected instance methods
# * Private attribute macros (attr_accessor, attr_writer, attr_reader)
# * Private instance methods
#
# You can configure the following order:
#
# [source,yaml]
# ----
#  Layout/ClassStructure:
#    ExpectedOrder:
#      - module_inclusion
#      - constants
#      - association
#      - public_attribute_macros
#      - public_delegate
#      - macros
#      - public_class_methods
#      - initializer
#      - public_methods
#      - protected_attribute_macros
#      - protected_methods
#      - private_attribute_macros
#      - private_delegate
#      - private_methods
# ----
#
# Instead of putting all literals in the expected order, is also
# possible to group categories of macros. Visibility levels are handled
# automatically.
#
# [source,yaml]
# ----
#  Layout/ClassStructure:
#    Categories:
#      association:
#        - has_many
#        - has_one
#      attribute_macros:
#        - attr_accessor
#        - attr_reader
#        - attr_writer
#      macros:
#        - validates
#        - validate
#      module_inclusion:
#        - include
#        - prepend
#        - extend
# ----
#
# @example
#   # bad
#   # Expect extend be before constant
#   class Person < ApplicationRecord
#   has_many :orders
#   ANSWER = 42
#
#   extend SomeModule
#   include AnotherModule
#   end
#
#   # good
#   class Person
#   # extend and include go first
#   extend SomeModule
#   include AnotherModule
#
#   # inner classes
#   CustomError = Class.new(StandardError)
#
#   # constants are next
#   SOME_CONSTANT = 20
#
#   # afterwards we have public attribute macros
#   attr_reader :name
#
#   # followed by other macros (if any)
#   validates :name
#
#   # then we have public delegate macros
#   delegate :to_s, to: :name
#
#   # public class methods are next in line
#   def self.some_method
#   end
#
#   # initialization goes between class methods and instance methods
#   def initialize
#   end
#
#   # followed by other public instance methods
#   def some_method
#   end
#
#   # protected attribute macros and methods go next
#   protected
#
#   attr_reader :protected_name
#
#   def some_protected_method
#   end
#
#   # private attribute macros, delegate macros and methods
#   # are grouped near the end
#   private
#
#   attr_reader :private_name
#
#   delegate :some_private_delegate, to: :name
#
#   def some_private_method
#   end
#   end
# @see https://rubystyle.guide#consistent-classes
class RuboCop::Cop::Layout::ClassStructure < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::Cop::AutoCorrector

  def dynamic_constant?(param0 = T.unsafe(nil)); end

  # Validates code style on class declaration.
  # Add offense when find a node out of expected order.
  def on_class(class_node); end

  private

  # Autocorrect by swapping between two nodes autocorrecting them
  def autocorrect(corrector, node); end

  def begin_pos_with_comment(node); end
  def buffer; end

  # Setting categories hash allow you to group methods in group to match
  # in the {expected_order}.
  def categories; end

  def class_elements(class_node); end

  # Classifies a node to match with something in the {expected_order}
  #
  # @param node to be analysed
  # @return String when the node type is a `:block` then
  #   {classify} recursively with the first children
  # @return String when the node type is a `:send` then {find_category}
  #   by method name
  # @return String otherwise trying to {humanize_node} of the current node
  def classify(node); end

  def end_position_for(node); end

  # Load expected order from `ExpectedOrder` config.
  # Define new terms in the expected order by adding new {categories}.
  def expected_order; end

  # Categorize a node according to the {expected_order}
  # Try to match {categories} values against the node's method_name given
  # also its visibility.
  #
  # @param node to be analysed.
  # @return [String] with the key category or the `method_name` as string
  def find_category(node); end

  def find_heredoc(node); end
  def humanize_node(node); end

  # @return [Boolean]
  def ignore?(classification); end

  # @return [Boolean]
  def ignore_for_autocorrect?(node, sibling); end

  def source_range_with_comment(node); end
  def start_line_position(node); end
  def walk_over_nested_class_definition(class_node); end

  # @return [Boolean]
  def whole_line_comment_at_line?(line); end
end

RuboCop::Cop::Layout::ClassStructure::HUMANIZED_NODE_TYPE = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Layout::ClassStructure::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of here document closings.
#
# @example
#
#   # bad
#   class Foo
#   def bar
#   <<~SQL
#   'Hi'
#   SQL
#   end
#   end
#
#   # good
#   class Foo
#   def bar
#   <<~SQL
#   'Hi'
#   SQL
#   end
#   end
#
#   # bad
#
#   # heredoc contents is before closing heredoc.
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
#
#   # good
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
#
#   # good
#   foo arg,
#   <<~EOS
#   Hi
#   EOS
class RuboCop::Cop::Layout::ClosingHeredocIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  def on_heredoc(node); end

  private

  # @return [Boolean]
  def argument_indentation_correct?(node); end

  def closing_indentation(node); end
  def find_node_used_heredoc_argument(node); end
  def heredoc_closing(node); end
  def heredoc_opening(node); end
  def indent_level(source_line); end
  def indented_end(node); end
  def message(node); end
  def opening_indentation(node); end
end

RuboCop::Cop::Layout::ClosingHeredocIndentation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ClosingHeredocIndentation::MSG_ARG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ClosingHeredocIndentation::SIMPLE_HEREDOC = T.let(T.unsafe(nil), String)

# Checks the indentation of hanging closing parentheses in
# method calls, method definitions, and grouped expressions. A hanging
# closing parenthesis means `)` preceded by a line break.
#
# @example
#
#   # bad
#   some_method(
#   a,
#   b
#   )
#
#   some_method(
#   a, b
#   )
#
#   some_method(a, b, c
#   )
#
#   some_method(a,
#   b,
#   c
#   )
#
#   some_method(a,
#   x: 1,
#   y: 2
#   )
#
#   # Scenario 1: When First Parameter Is On Its Own Line
#
#   # good: when first param is on a new line, right paren is *always*
#   #       outdented by IndentationWidth
#   some_method(
#   a,
#   b
#   )
#
#   # good
#   some_method(
#   a, b
#   )
#
#   # Scenario 2: When First Parameter Is On The Same Line
#
#   # good: when all other params are also on the same line, outdent
#   #       right paren by IndentationWidth
#   some_method(a, b, c
#   )
#
#   # good: when all other params are on multiple lines, but are lined
#   #       up, align right paren with left paren
#   some_method(a,
#   b,
#   c
#   )
#
#   # good: when other params are not lined up on multiple lines, outdent
#   #       right paren by IndentationWidth
#   some_method(a,
#   x: 1,
#   y: 2
#   )
class RuboCop::Cop::Layout::ClosingParenthesisIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_begin(node); end
  def on_csend(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def all_elements_aligned?(elements); end

  def autocorrect(corrector, node); end
  def check(node, elements); end
  def check_for_elements(node, elements); end
  def check_for_no_elements(node); end
  def correct_column_candidates(node, left_paren); end
  def expected_column(left_paren, elements); end
  def first_argument_line(elements); end
  def indentation_width; end

  # @return [Boolean]
  def line_break_after_left_paren?(left_paren, elements); end

  def message(correct_column, left_paren, right_paren); end
end

RuboCop::Cop::Layout::ClosingParenthesisIndentation::MSG_ALIGN = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ClosingParenthesisIndentation::MSG_INDENT = T.let(T.unsafe(nil), String)

# Checks the indentation of comments.
#
# @example
#   # bad
#   # comment here
#   def method_name
#   end
#
#   # comment here
#   a = 'hello'
#
#   # yet another comment
#   if true
#   true
#   end
#
#   # good
#   # comment here
#   def method_name
#   end
#
#   # comment here
#   a = 'hello'
#
#   # yet another comment
#   if true
#   true
#   end
# @example AllowForAlignment: false (default)
#   # bad
#   a = 1 # A really long comment
#   # spanning two lines.
#
#   # good
#   # A really long comment spanning one line.
#   a = 1
# @example AllowForAlignment: true
#   # good
#   a = 1 # A really long comment
#   # spanning two lines.
class RuboCop::Cop::Layout::CommentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(corrector, comment); end
  def autocorrect_one(corrector, comment); end

  # Corrects all comment lines that occur immediately before the given
  # comment and have the same indentation. This is to avoid a long chain
  # of correcting, saving the file, parsing and inspecting again, and
  # then correcting one more line, and so on.
  def autocorrect_preceding_comments(corrector, comment); end

  def check(comment, comment_index); end
  def correct_indentation(next_line); end

  # Returns true if:
  # a) the cop is configured to allow extra indentation for alignment, and
  # b) the currently inspected comment is aligned with the nearest preceding end-of-line
  #    comment.
  #
  # @return [Boolean]
  def correctly_aligned_with_preceding_comment?(comment_index, column); end

  # @return [Boolean]
  def less_indented?(line); end

  def line_after_comment(comment); end
  def message(column, correct_comment_indentation); end

  # @return [Boolean]
  def own_line_comment?(comment); end

  # @return [Boolean]
  def should_correct?(preceding_comment, reference_comment); end

  # @return [Boolean]
  def two_alternatives?(line); end
end

RuboCop::Cop::Layout::CommentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for conditions that are not on the same line as
# if/while/until.
#
# @example
#
#   # bad
#
#   if
#   some_condition
#   do_something
#   end
# @example
#
#   # good
#
#   if some_condition
#   do_something
#   end
class RuboCop::Cop::Layout::ConditionPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
  def on_until(node); end
  def on_while(node); end

  private

  def check(node); end
  def message(condition); end
end

RuboCop::Cop::Layout::ConditionPosition::MSG = T.let(T.unsafe(nil), String)

# Checks whether the end keywords of method definitions are
# aligned properly.
#
# Two modes are supported through the EnforcedStyleAlignWith configuration
# parameter. If it's set to `start_of_line` (which is the default), the
# `end` shall be aligned with the start of the line where the `def`
# keyword is. If it's set to `def`, the `end` shall be aligned with the
# `def` keyword.
#
# @example EnforcedStyleAlignWith: start_of_line (default)
#   # bad
#
#   private def foo
#   end
#
#   # good
#
#   private def foo
#   end
# @example EnforcedStyleAlignWith: def
#   # bad
#
#   private def foo
#   end
#
#   # good
#
#   private def foo
#   end
class RuboCop::Cop::Layout::DefEndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end

  private

  def autocorrect(corrector, node); end
end

RuboCop::Cop::Layout::DefEndAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks the . position in multi-line method calls.
#
# @example EnforcedStyle: leading (default)
#   # bad
#   something.
#   method
#
#   # good
#   something
#   .method
# @example EnforcedStyle: trailing
#   # bad
#   something
#   .method
#
#   # good
#   something.
#   method
class RuboCop::Cop::Layout::DotPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def ampersand_dot?(node); end

  def autocorrect(corrector, dot, node); end

  # @return [Boolean]
  def correct_dot_position_style?(dot_line, selector_line); end

  def end_range(node); end

  # @return [Boolean]
  def heredoc?(node); end

  def last_heredoc_line(node); end

  # @return [Boolean]
  def line_between?(first_line, second_line); end

  def message(dot); end

  # @return [Boolean]
  def proper_dot_position?(node); end

  def receiver_end_line(node); end
  def selector_range(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

# Checks the alignment of else keywords. Normally they should
# be aligned with an if/unless/while/until/begin/def/rescue keyword, but there
# are special cases when they should follow the same rules as the
# alignment of end.
#
# @example
#   # bad
#   if something
#   code
#   else
#   code
#   end
#
#   # bad
#   if something
#   code
#   elsif something
#   code
#   end
#
#   # good
#   if something
#   code
#   else
#   code
#   end
class RuboCop::Cop::Layout::ElseAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::CheckAssignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(node); end
  def on_case_match(node); end
  def on_if(node, base = T.unsafe(nil)); end
  def on_rescue(node); end

  private

  def assignment_node(node); end
  def autocorrect(corrector, node); end
  def base_for_method_definition(node); end
  def base_range_of_if(node, base); end
  def base_range_of_rescue(node); end
  def check_alignment(base_range, else_range); end
  def check_assignment(node, rhs); end
  def check_nested(node, base); end
end

RuboCop::Cop::Layout::ElseAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks empty comment.
#
# @example
#   # bad
#
#   #
#   class Foo
#   end
#
#   # good
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
# @example AllowBorderComment: true (default)
#   # good
#
#   def foo
#   end
#
#   #################
#
#   def bar
#   end
# @example AllowBorderComment: false
#   # bad
#
#   def foo
#   end
#
#   #################
#
#   def bar
#   end
# @example AllowMarginComment: true (default)
#   # good
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
# @example AllowMarginComment: false
#   # bad
#
#   #
#   # Description of `Foo` class.
#   #
#   class Foo
#   end
class RuboCop::Cop::Layout::EmptyComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # @return [Boolean]
  def allow_border_comment?; end

  # @return [Boolean]
  def allow_margin_comment?; end

  def autocorrect(corrector, node); end
  def comment_text(comment); end
  def concat_consecutive_comments(comments); end
  def current_token(comment); end

  # @return [Boolean]
  def empty_comment_only?(comment_text); end

  def investigate(comments); end
  def previous_token(node); end
end

RuboCop::Cop::Layout::EmptyComment::MSG = T.let(T.unsafe(nil), String)

# Enforces empty line after guard clause
#
# @example
#
#   # bad
#   def foo
#   return if need_return?
#   bar
#   end
#
#   # good
#   def foo
#   return if need_return?
#
#   bar
#   end
#
#   # good
#   def foo
#   return if something?
#   return if something_different?
#
#   bar
#   end
#
#   # also good
#   def foo
#   if something?
#   do_something
#   return if need_return?
#   end
#   end
class RuboCop::Cop::Layout::EmptyLineAfterGuardClause < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  def on_if(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def contains_guard_clause?(node); end

  # @return [Boolean]
  def correct_style?(node); end

  # @return [Boolean]
  def heredoc?(node); end

  def heredoc_line(node, heredoc_node); end
  def last_heredoc_argument(node); end
  def last_heredoc_argument_node(node); end

  # @return [Boolean]
  def multiple_statements_on_line?(node); end

  # @return [Boolean]
  def next_line_empty?(line); end

  # @return [Boolean]
  def next_line_empty_or_enable_directive_comment?(line); end

  # @return [Boolean]
  def next_line_enable_directive_comment?(line); end

  # @return [Boolean]
  def next_line_rescue_or_ensure?(node); end

  # @return [Boolean]
  def next_sibling_empty_or_guard_clause?(node); end

  # @return [Boolean]
  def next_sibling_parent_empty_or_else?(node); end

  def offense_location(node); end
end

RuboCop::Cop::Layout::EmptyLineAfterGuardClause::END_OF_HEREDOC_LINE = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Layout::EmptyLineAfterGuardClause::MSG = T.let(T.unsafe(nil), String)

# Checks for a newline after the final magic comment.
#
# @example
#   # good
#   # frozen_string_literal: true
#
#   # Some documentation for Person
#   class Person
#   # Some code
#   end
#
#   # bad
#   # frozen_string_literal: true
#   # Some documentation for Person
#   class Person
#   # Some code
#   end
class RuboCop::Cop::Layout::EmptyLineAfterMagicComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # Find the last magic comment in the source file.
  #
  # Take all comments that precede the first line of code, select the
  # magic comments, and return the last magic comment in the file.
  #
  # @return [Parser::Source::Comment] if magic comments exist before code
  # @return [nil] otherwise
  def last_magic_comment(source); end

  def offending_range(last_magic_comment); end
end

RuboCop::Cop::Layout::EmptyLineAfterMagicComment::MSG = T.let(T.unsafe(nil), String)

# Enforces empty line after multiline condition.
#
# @example
#   # bad
#   if multiline &&
#   condition
#   do_something
#   end
#
#   # good
#   if multiline &&
#   condition
#
#   do_something
#   end
#
#   # bad
#   case x
#   when foo,
#   bar
#   do_something
#   end
#
#   # good
#   case x
#   when foo,
#   bar
#
#   do_something
#   end
#
#   # bad
#   begin
#   do_something
#   rescue FooError,
#   BarError
#   handle_error
#   end
#
#   # good
#   begin
#   do_something
#   rescue FooError,
#   BarError
#
#   handle_error
#   end
class RuboCop::Cop::Layout::EmptyLineAfterMultilineCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(node); end
  def on_if(node); end
  def on_rescue(node); end
  def on_until(node); end
  def on_until_post(node); end
  def on_while(node); end
  def on_while_post(node); end

  private

  def autocorrect(node); end
  def check_condition(condition); end

  # @return [Boolean]
  def multiline_rescue_exceptions?(exception_nodes); end

  # @return [Boolean]
  def multiline_when_condition?(when_node); end

  # @return [Boolean]
  def next_line_empty?(line); end
end

RuboCop::Cop::Layout::EmptyLineAfterMultilineCondition::MSG = T.let(T.unsafe(nil), String)

# Checks whether class/module/method definitions are
# separated by one or more empty lines.
#
# `NumberOfEmptyLines` can be an integer (default is 1) or
# an array (e.g. [1, 2]) to specify a minimum and maximum
# number of empty lines permitted.
#
# `AllowAdjacentOneLineDefs` configures whether adjacent
# one-line definitions are considered an offense.
#
# @example AllowAdjacentOneLineDefs: false
#
#   # bad
#   class ErrorA < BaseError; end
#   class ErrorB < BaseError; end
#   class ErrorC < BaseError; end
#
#   # good
#   class ErrorA < BaseError; end
#
#   class ErrorB < BaseError; end
#
#   class ErrorC < BaseError; end
# @example
#
#   # good
#   def a
#   end
#
#   def b
#   end
# @example EmptyLineBetweenClassDefs: true (default)
#   # checks for empty lines between class definitions.
#
#   # bad
#   class A
#   end
#   class B
#   end
#   def b
#   end
# @example
#
#   # good
#   class A
#   end
#
#   class B
#   end
#
#   def b
#   end
# @example EmptyLineBetweenModuleDefs: true (default)
#   # checks for empty lines between module definitions.
#
#   # bad
#   module A
#   end
#   module B
#   end
#   def b
#   end
# @example
#
#   # good
#   module A
#   end
#
#   module B
#   end
#
#   def b
#   end
# @example AllowAdjacentOneLineDefs: true (default)
#
#   # good
#   class ErrorA < BaseError; end
#   class ErrorB < BaseError; end
#   class ErrorC < BaseError; end
#
#   # good
#   class ErrorA < BaseError; end
#
#   class ErrorB < BaseError; end
#
#   class ErrorC < BaseError; end
# @example EmptyLineBetweenMethodDefs: true (default)
#   # checks for empty lines between method definitions.
#
#   # bad
#   def a
#   end
#   def b
#   end
class RuboCop::Cop::Layout::EmptyLineBetweenDefs < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, prev_def, node, count); end
  def check_defs(nodes); end

  # We operate on `begin` nodes, instead of using `OnMethodDef`,
  # so that we can walk over pairs of consecutive nodes and
  # efficiently access a node's predecessor; #prev_node ends up
  # doing a linear scan over siblings, so we don't want to call
  # it on each def.
  def on_begin(node); end

  private

  # @return [Boolean]
  def allowance_range?; end

  def autocorrect_insert_lines(corrector, newline_pos, count); end
  def autocorrect_remove_lines(corrector, newline_pos, count); end
  def blank_lines_count_between(first_def_node, second_def_node); end

  # @return [Boolean]
  def candidate?(node); end

  # @return [Boolean]
  def class_candidate?(node); end

  def def_end(node); end
  def def_start(node); end
  def end_loc(node); end
  def expected_lines; end

  # @return [Boolean]
  def line_count_allowed?(count); end

  def lines_between_defs(first_def_node, second_def_node); end
  def maximum_empty_lines; end
  def message(node, count: T.unsafe(nil)); end

  # @return [Boolean]
  def method_candidate?(node); end

  def minimum_empty_lines; end

  # @return [Boolean]
  def module_candidate?(node); end

  # @return [Boolean]
  def multiple_blank_lines_groups?(first_def_node, second_def_node); end

  def node_type(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Layout::EmptyLineBetweenDefs::MSG = T.let(T.unsafe(nil), String)

# Checks for two or more consecutive blank lines.
#
# @example
#
#   # bad - It has two empty lines.
#   some_method
#   # one empty line
#   # two empty lines
#   some_method
#
#   # good
#   some_method
#   # one empty line
#   some_method
class RuboCop::Cop::Layout::EmptyLines < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def each_extra_empty_line(lines); end

  # @return [Boolean]
  def exceeds_line_offset?(line_diff); end

  # @return [Boolean]
  def previous_and_current_lines_empty?(line); end
end

RuboCop::Cop::Layout::EmptyLines::LINE_OFFSET = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Layout::EmptyLines::MSG = T.let(T.unsafe(nil), String)

# Access modifiers should be surrounded by blank lines.
#
# @example EnforcedStyle: around (default)
#
#   # bad
#   class Foo
#   def bar; end
#   private
#   def baz; end
#   end
#
#   # good
#   class Foo
#   def bar; end
#
#   private
#
#   def baz; end
#   end
# @example EnforcedStyle: only_before
#
#   # bad
#   class Foo
#   def bar; end
#   private
#   def baz; end
#   end
#
#   # good
#   class Foo
#   def bar; end
#
#   private
#   def baz; end
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [EmptyLinesAroundAccessModifier] a new instance of EmptyLinesAroundAccessModifier
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  def on_block(node); end
  def on_class(node); end
  def on_module(node); end
  def on_numblock(node); end
  def on_sclass(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_only_before_style?(node); end

  # @return [Boolean]
  def block_start?(line); end

  # @return [Boolean]
  def body_end?(line); end

  # @return [Boolean]
  def class_def?(line); end

  def correct_next_line_if_denied_style(corrector, node, line); end

  # @return [Boolean]
  def empty_lines_around?(node); end

  # @return [Boolean]
  def expected_empty_lines?(node); end

  def message(node); end
  def message_for_around_style(node); end
  def message_for_only_before_style(node); end
  def next_empty_line_range(node); end

  # @return [Boolean]
  def next_line_empty?(last_send_line); end

  # @return [Boolean]
  def previous_line_empty?(send_line); end

  def previous_line_ignoring_comments(processed_source, send_line); end
end

RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_AFTER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_AFTER_FOR_ONLY_BEFORE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_BEFORE_AND_AFTER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EmptyLinesAroundAccessModifier::MSG_BEFORE_FOR_ONLY_BEFORE = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the arguments
# of a method invocation.
#
# @example
#   # bad
#   do_something(
#   foo
#
#   )
#
#   process(bar,
#
#   baz: qux,
#   thud: fred)
#
#   some_method(
#
#   [1,2,3],
#   x: y
#   )
#
#   # good
#   do_something(
#   foo
#   )
#
#   process(bar,
#   baz: qux,
#   thud: fred)
#
#   some_method(
#   [1,2,3],
#   x: y
#   )
class RuboCop::Cop::Layout::EmptyLinesAroundArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  def empty_lines(node); end
  def extra_lines(node); end
  def inner_lines(node); end
  def line_numbers(node); end
  def outer_lines(node); end
  def processed_lines(node); end

  # @return [Boolean]
  def receiver_and_method_call_on_different_lines?(node); end
end

RuboCop::Cop::Layout::EmptyLinesAroundArguments::MSG = T.let(T.unsafe(nil), String)

# Checks for a newline after an attribute accessor or a group of them.
# `alias` syntax and `alias_method`, `public`, `protected`, and `private` methods are allowed
# by default. These are customizable with `AllowAliasSyntax` and `AllowedMethods` options.
#
# @example
#   # bad
#   attr_accessor :foo
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#   attr_reader :bar
#   attr_writer :baz
#   attr :qux
#
#   def do_something
#   end
# @example AllowAliasSyntax: true (default)
#   # good
#   attr_accessor :foo
#   alias :foo? :foo
#
#   def do_something
#   end
# @example AllowAliasSyntax: false
#   # bad
#   attr_accessor :foo
#   alias :foo? :foo
#
#   def do_something
#   end
#
#   # good
#   attr_accessor :foo
#
#   alias :foo? :foo
#
#   def do_something
#   end
# @example AllowedMethods: ['private']
#   # good
#   attr_accessor :foo
#   private :foo
#
#   def do_something
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundAttributeAccessor < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def allow_alias?(node); end

  # @return [Boolean]
  def allow_alias_syntax?; end

  # @return [Boolean]
  def attribute_or_allowed_method?(node); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def next_line_empty?(line); end

  # @return [Boolean]
  def next_line_empty_or_enable_directive_comment?(line); end

  # @return [Boolean]
  def next_line_enable_directive_comment?(line); end

  def next_line_node(node); end

  # @return [Boolean]
  def require_empty_line?(node); end
end

RuboCop::Cop::Layout::EmptyLinesAroundAttributeAccessor::MSG = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of begin-end
# blocks.
#
# @example
#
#   # good
#
#   begin
#   # ...
#   end
#
#   # bad
#
#   begin
#
#   # ...
#
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundBeginBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_kwbegin(node); end

  private

  def style; end
end

RuboCop::Cop::Layout::EmptyLinesAroundBeginBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of blocks match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   foo do |bar|
#   # ...
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   foo do |bar|
#
#   # ...
#
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundBlockBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
end

RuboCop::Cop::Layout::EmptyLinesAroundBlockBody::KIND = T.let(T.unsafe(nil), String)

# Common functionality for checking if presence/absence of empty lines
# around some kind of body matches the configuration.
module RuboCop::Cop::Layout::EmptyLinesAroundBody
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::AST::NodePattern::Macros

  def constant_definition?(param0 = T.unsafe(nil)); end
  def empty_line_required?(param0 = T.unsafe(nil)); end

  private

  def check(node, body, adjusted_first_line: T.unsafe(nil)); end
  def check_beginning(style, first_line); end
  def check_both(style, first_line, last_line); end
  def check_deferred_empty_line(body); end
  def check_empty_lines_except_namespace(body, first_line, last_line); end
  def check_empty_lines_special(body, first_line, last_line); end
  def check_ending(style, last_line); end
  def check_line(style, line, msg); end
  def check_source(style, line_no, desc); end
  def deferred_message(node); end

  # @return [Boolean]
  def first_child_requires_empty_line?(body); end

  def first_empty_line_required_child(body); end
  def message(type, desc); end

  # @return [Boolean]
  def namespace?(body, with_one_child: T.unsafe(nil)); end

  def previous_line_ignoring_comments(send_line); end

  # @return [Boolean]
  def valid_body_style?(body); end
end

RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_DEFERRED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_EXTRA = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EmptyLinesAroundBody::MSG_MISSING = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of classes match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   class Foo
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   class Foo
#
#   def bar
#   # ...
#   end
#
#   end
# @example EnforcedStyle: empty_lines_except_namespace
#   # good
#
#   class Foo
#   class Bar
#
#   # ...
#
#   end
#   end
# @example EnforcedStyle: empty_lines_special
#   # good
#   class Foo
#
#   def bar; end
#
#   end
# @example EnforcedStyle: beginning_only
#   # good
#
#   class Foo
#
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: ending_only
#   # good
#
#   class Foo
#   def bar
#   # ...
#   end
#
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundClassBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def on_sclass(node); end
end

RuboCop::Cop::Layout::EmptyLinesAroundClassBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of `begin`
# sections. This cop doesn't check empty lines at `begin` body
# beginning/end and around method definition body.
# `Style/EmptyLinesAroundBeginBody` or `Style/EmptyLinesAroundMethodBody`
# can be used for this purpose.
#
# @example
#
#   # good
#
#   begin
#   do_something
#   rescue
#   do_something2
#   else
#   do_something3
#   ensure
#   do_something4
#   end
#
#   # good
#
#   def foo
#   do_something
#   rescue
#   do_something2
#   end
#
#   # bad
#
#   begin
#   do_something
#
#   rescue
#
#   do_something2
#
#   else
#
#   do_something3
#
#   ensure
#
#   do_something4
#   end
#
#   # bad
#
#   def foo
#   do_something
#
#   rescue
#
#   do_something2
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundExceptionHandlingKeywords < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
  def on_kwbegin(node); end

  private

  def check_body(body, line_of_def_or_kwbegin); end
  def keyword_locations(node); end
  def keyword_locations_in_ensure(node); end
  def keyword_locations_in_rescue(node); end
  def last_rescue_and_end_on_same_line(body); end
  def message(location, keyword); end
  def style; end
end

RuboCop::Cop::Layout::EmptyLinesAroundExceptionHandlingKeywords::MSG = T.let(T.unsafe(nil), String)

# Checks if empty lines exist around the bodies of methods.
#
# @example
#
#   # good
#
#   def foo
#   # ...
#   end
#
#   # bad
#
#   def bar
#
#   # ...
#
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundMethodBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  def style; end
end

RuboCop::Cop::Layout::EmptyLinesAroundMethodBody::KIND = T.let(T.unsafe(nil), String)

# Checks if empty lines around the bodies of modules match
# the configuration.
#
# @example EnforcedStyle: no_empty_lines (default)
#   # good
#
#   module Foo
#   def bar
#   # ...
#   end
#   end
# @example EnforcedStyle: empty_lines
#   # good
#
#   module Foo
#
#   def bar
#   # ...
#   end
#
#   end
# @example EnforcedStyle: empty_lines_except_namespace
#   # good
#
#   module Foo
#   module Bar
#
#   # ...
#
#   end
#   end
# @example EnforcedStyle: empty_lines_special
#   # good
#   module Foo
#
#   def bar; end
#
#   end
class RuboCop::Cop::Layout::EmptyLinesAroundModuleBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Layout::EmptyLinesAroundBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_module(node); end
end

RuboCop::Cop::Layout::EmptyLinesAroundModuleBody::KIND = T.let(T.unsafe(nil), String)

# Checks whether the end keywords are aligned properly.
#
# Three modes are supported through the `EnforcedStyleAlignWith`
# configuration parameter:
#
# If it's set to `keyword` (which is the default), the `end`
# shall be aligned with the start of the keyword (if, class, etc.).
#
# If it's set to `variable` the `end` shall be aligned with the
# left-hand-side of the variable assignment, if there is one.
#
# If it's set to `start_of_line`, the `end` shall be aligned with the
# start of the line where the matching keyword appears.
#
# This `Layout/EndAlignment` cop aligns with keywords (e.g. `if`, `while`, `case`)
# by default. On the other hand, `Layout/BeginEndAlignment` cop aligns with
# `EnforcedStyleAlignWith: start_of_line` by default due to `||= begin` tends
# to align with the start of the line. These style can be configured by each cop.
#
# @example EnforcedStyleAlignWith: keyword (default)
#   # bad
#
#   variable = if true
#   end
#
#   # good
#
#   variable = if true
#   end
#
#   variable =
#   if true
#   end
# @example EnforcedStyleAlignWith: variable
#   # bad
#
#   variable = if true
#   end
#
#   # good
#
#   variable = if true
#   end
#
#   variable =
#   if true
#   end
# @example EnforcedStyleAlignWith: start_of_line
#   # bad
#
#   variable = if true
#   end
#
#   puts(if true
#   end)
#
#   # good
#
#   variable = if true
#   end
#
#   puts(if true
#   end)
#
#   variable =
#   if true
#   end
class RuboCop::Cop::Layout::EndAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(node); end
  def on_class(node); end
  def on_if(node); end
  def on_module(node); end
  def on_until(node); end
  def on_while(node); end

  private

  def alignment_node(node); end
  def alignment_node_for_variable_style(node); end
  def asgn_variable_align_with(outer_node, inner_node); end
  def assignment_or_operator_method(node); end
  def autocorrect(corrector, node); end
  def check_asgn_alignment(outer_node, inner_node); end
  def check_assignment(node, rhs); end
  def check_other_alignment(node); end
end

# Checks for Windows-style line endings in the source code.
#
# @example EnforcedStyle: native (default)
#   # The `native` style means that CR+LF (Carriage Return + Line Feed) is
#   # enforced on Windows, and LF is enforced on other platforms.
#
#   # bad
#   puts 'Hello' # Return character is LF on Windows.
#   puts 'Hello' # Return character is CR+LF on other than Windows.
#
#   # good
#   puts 'Hello' # Return character is CR+LF on Windows.
#   puts 'Hello' # Return character is LF on other than Windows.
# @example EnforcedStyle: lf
#   # The `lf` style means that LF (Line Feed) is enforced on
#   # all platforms.
#
#   # bad
#   puts 'Hello' # Return character is CR+LF on all platforms.
#
#   # good
#   puts 'Hello' # Return character is LF on all platforms.
# @example EnforcedStyle: crlf
#   # The `crlf` style means that CR+LF (Carriage Return + Line Feed) is
#   # enforced on all platforms.
#
#   # bad
#   puts 'Hello' # Return character is LF on all platforms.
#
#   # good
#   puts 'Hello' # Return character is CR+LF on all platforms.
class RuboCop::Cop::Layout::EndOfLine < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  def offense_message(line); end
  def on_new_investigation; end

  # If there is no LF on the last line, we don't care if there's no CR.
  #
  # @return [Boolean]
  def unimportant_missing_cr?(index, last_line, line); end

  private

  def last_line(processed_source); end
end

RuboCop::Cop::Layout::EndOfLine::MSG_DETECTED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::EndOfLine::MSG_MISSING = T.let(T.unsafe(nil), String)

# Checks for extra/unnecessary whitespace.
#
# @example
#
#   # good if AllowForAlignment is true
#   name      = "RuboCop"
#   # Some comment and an empty line
#
#   website  += "/rubocop/rubocop" unless cond
#   puts        "rubocop"          if     debug
#
#   # bad for any configuration
#   set_app("RuboCop")
#   website  = "https://github.com/rubocop/rubocop"
#
#   # good only if AllowBeforeTrailingComments is true
#   object.method(arg)  # this is a comment
#
#   # good even if AllowBeforeTrailingComments is false or not set
#   object.method(arg) # this is a comment
#
#   # good with either AllowBeforeTrailingComments or AllowForAlignment
#   object.method(arg)         # this is a comment
#   another_object.method(arg) # this is another comment
#   some_object.method(arg)    # this is some comment
class RuboCop::Cop::Layout::ExtraSpacing < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def align_column(asgn_token); end
  def align_equal_sign(corrector, token, align_to); end
  def align_equal_signs(range, corrector); end
  def aligned_locations(locs); end

  # @return [Boolean]
  def aligned_tok?(token); end

  def all_relevant_assignment_lines(line_number); end

  # @return [Boolean]
  def allow_for_trailing_comments?; end

  def check_assignment(token); end
  def check_other(token1, token2, ast); end
  def check_tokens(ast, token1, token2); end

  # @yield [range_between(start_pos, end_pos)]
  def extra_space_range(token1, token2); end

  # @return [Boolean]
  def force_equal_sign_alignment?; end

  # @return [Boolean]
  def ignored_range?(ast, start_pos); end

  # Returns an array of ranges that should not be reported. It's the
  # extra spaces between the keys and values in a multiline hash,
  # since those are handled by the Layout/HashAlignment cop.
  def ignored_ranges(ast); end
end

RuboCop::Cop::Layout::ExtraSpacing::MSG_UNALIGNED_ASGN = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ExtraSpacing::MSG_UNNECESSARY = T.let(T.unsafe(nil), String)

# Checks the indentation of the first argument in a method call.
# Arguments after the first one are checked by `Layout/ArgumentAlignment`,
# not by this cop.
#
# For indenting the first parameter of method _definitions_, check out
# `Layout/FirstParameterIndentation`.
#
# This cop will respect `Layout/ArgumentAlignment` and will not work when
# `EnforcedStyle: with_fixed_indentation` is specified for `Layout/ArgumentAlignment`.
#
# @example
#
#   # bad
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: special_for_inner_method_call_in_parentheses (default)
#   # Same as `special_for_inner_method_call` except that the special rule
#   # only applies if the outer method call encloses its arguments in
#   # parentheses.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: consistent
#   # The first argument should always be indented one step more than the
#   # preceding line.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
# @example EnforcedStyle: consistent_relative_to_receiver
#   # The first argument should always be indented one level relative to
#   # the parent that is receiving the argument
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_params
# @example EnforcedStyle: special_for_inner_method_call
#   # The first argument should normally be indented one step more than
#   # the preceding line, but if it's a argument for a method call that
#   # is itself a argument in a method call, then the inner argument
#   # should be indented relative to the inner method.
#
#   # good
#   some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(
#   first_param,
#   second_param)
#
#   foo = some_method(nested_call(
#   nested_first_param),
#   second_param)
#
#   foo = some_method(
#   nested_call(
#   nested_first_param),
#   second_param)
#
#   some_method nested_call(
#   nested_first_param),
#   second_param
class RuboCop::Cop::Layout::FirstArgumentIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def eligible_method_call?(param0 = T.unsafe(nil)); end
  def on_csend(node); end
  def on_send(node); end

  private

  def argument_alignment_config; end
  def autocorrect(corrector, node); end

  # @return [Boolean]
  def bare_operator?(node); end

  def base_indentation(node); end
  def base_range(send_node, arg_node); end

  # Returns the column of the given range. For single line ranges, this
  # is simple. For ranges with line breaks, we look a the last code line.
  def column_of(range); end

  def comment_lines; end

  # @return [Boolean]
  def enable_layout_first_method_argument_line_break?; end

  # @return [Boolean]
  def enforce_first_argument_with_fixed_indentation?; end

  def message(arg_node); end
  def on_new_investigation; end

  # Takes the line number of a given code line and returns a string
  # containing the previous line that's not a comment line or a blank
  # line.
  def previous_code_line(line_number); end

  # @return [Boolean]
  def special_inner_call_indentation?(node); end
end

RuboCop::Cop::Layout::FirstArgumentIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first element in an array literal
# where the opening bracket and the first element are on separate lines.
# The other elements' indentations are handled by the ArrayAlignment cop.
#
# By default, array literals that are arguments in a method call with
# parentheses, and where the opening square bracket of the array is on the
# same line as the opening parenthesis of the method call, shall have
# their first element indented one step (two spaces) more than the
# position inside the opening parenthesis.
#
# Other array literals shall have their first element indented one step
# more than the start of the line where the opening square bracket is.
#
# This default style is called 'special_inside_parentheses'. Alternative
# styles are 'consistent' and 'align_brackets'. Here are examples:
#
# @example EnforcedStyle: special_inside_parentheses (default)
#   # The `special_inside_parentheses` style enforces that the first
#   # element in an array literal where the opening bracket and first
#   # element are on separate lines is indented one step (two spaces) more
#   # than the position inside the opening parenthesis.
#
#   #bad
#   array = [
#   :value
#   ]
#   and_in_a_method_call([
#   :no_difference
#   ])
#
#   #good
#   array = [
#   :value
#   ]
#   but_in_a_method_call([
#   :its_like_this
#   ])
# @example EnforcedStyle: consistent
#   # The `consistent` style enforces that the first element in an array
#   # literal where the opening bracket and the first element are on
#   # separate lines is indented the same as an array literal which is not
#   # defined inside a method call.
#
#   #bad
#   # consistent
#   array = [
#   :value
#   ]
#   but_in_a_method_call([
#   :its_like_this
#   ])
#
#   #good
#   array = [
#   :value
#   ]
#   and_in_a_method_call([
#   :no_difference
#   ])
# @example EnforcedStyle: align_brackets
#   # The `align_brackets` style enforces that the opening and closing
#   # brackets are indented to the same position.
#
#   #bad
#   # align_brackets
#   and_now_for_something = [
#   :completely_different
#   ]
#
#   #good
#   # align_brackets
#   and_now_for_something = [
#   :completely_different
#   ]
class RuboCop::Cop::Layout::FirstArrayElementIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_csend(node); end
  def on_send(node); end

  private

  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  def base_description(indent_base_type); end

  def brace_alignment_style; end
  def check(array_node, left_parenthesis); end
  def check_right_bracket(right_bracket, first_elem, left_bracket, left_parenthesis); end
  def message(base_description); end
  def message_for_right_bracket(indent_base_type); end
end

RuboCop::Cop::Layout::FirstArrayElementIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first element in a
# multi-line array.
#
# @example
#
#   # bad
#   [ :a,
#   :b]
#
#   # good
#   [
#   :a,
#   :b]
class RuboCop::Cop::Layout::FirstArrayElementLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end

  private

  # @return [Boolean]
  def assignment_on_same_line?(node); end
end

RuboCop::Cop::Layout::FirstArrayElementLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first key in a hash literal
# where the opening brace and the first key are on separate lines. The
# other keys' indentations are handled by the HashAlignment cop.
#
# By default, Hash literals that are arguments in a method call with
# parentheses, and where the opening curly brace of the hash is on the
# same line as the opening parenthesis of the method call, shall have
# their first key indented one step (two spaces) more than the position
# inside the opening parenthesis.
#
# Other hash literals shall have their first key indented one step more
# than the start of the line where the opening curly brace is.
#
# This default style is called 'special_inside_parentheses'. Alternative
# styles are 'consistent' and 'align_braces'. Here are examples:
#
# @example EnforcedStyle: special_inside_parentheses (default)
#   # The `special_inside_parentheses` style enforces that the first key
#   # in a hash literal where the opening brace and the first key are on
#   # separate lines is indented one step (two spaces) more than the
#   # position inside the opening parentheses.
#
#   # bad
#   hash = {
#   key: :value
#   }
#   and_in_a_method_call({
#   no: :difference
#   })
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
#
#   # good
#   special_inside_parentheses
#   hash = {
#   key: :value
#   }
#   but_in_a_method_call({
#   its_like: :this
#   })
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
# @example EnforcedStyle: consistent
#   # The `consistent` style enforces that the first key in a hash
#   # literal where the opening brace and the first key are on
#   # separate lines is indented the same as a hash literal which is not
#   # defined inside a method call.
#
#   # bad
#   hash = {
#   key: :value
#   }
#   but_in_a_method_call({
#   its_like: :this
#   })
#
#   # good
#   hash = {
#   key: :value
#   }
#   and_in_a_method_call({
#   no: :difference
#   })
# @example EnforcedStyle: align_braces
#   # The `align_brackets` style enforces that the opening and closing
#   # braces are indented to the same position.
#
#   # bad
#   and_now_for_something = {
#   completely: :different
#   }
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
#
#   # good
#   and_now_for_something = {
#   completely: :different
#   }
#   takes_multi_pairs_hash(x: {
#   a: 1,
#   b: 2
#   },
#   y: {
#   c: 1,
#   d: 2
#   })
class RuboCop::Cop::Layout::FirstHashElementIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_hash(node); end
  def on_send(node); end

  private

  def argument_alignment_config; end
  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  def base_description(indent_base_type); end

  def brace_alignment_style; end
  def check(hash_node, left_parenthesis); end
  def check_based_on_longest_key(hash_node, left_brace, left_parenthesis); end
  def check_right_brace(right_brace, first_pair, left_brace, left_parenthesis); end

  # @return [Boolean]
  def enforce_first_argument_with_fixed_indentation?; end

  def message(base_description); end
  def message_for_right_brace(indent_base_type); end

  # @return [Boolean]
  def separator_style?(first_pair); end
end

RuboCop::Cop::Layout::FirstHashElementIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first element in a
# multi-line hash.
#
# @example
#
#   # bad
#   { a: 1,
#   b: 2}
#
#   # good
#   {
#   a: 1,
#   b: 2 }
class RuboCop::Cop::Layout::FirstHashElementLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end
end

RuboCop::Cop::Layout::FirstHashElementLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first argument in a
# multi-line method call.
#
# @example
#
#   # bad
#   method(foo, bar,
#   baz)
#
#   # good
#   method(
#   foo, bar,
#   baz)
#
#   # ignored
#   method foo, bar,
#   baz
class RuboCop::Cop::Layout::FirstMethodArgumentLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end
  def on_super(node); end
end

RuboCop::Cop::Layout::FirstMethodArgumentLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks for a line break before the first parameter in a
# multi-line method parameter definition.
#
# @example
#
#   # bad
#   def method(foo, bar,
#   baz)
#   do_something
#   end
#
#   # good
#   def method(
#   foo, bar,
#   baz)
#   do_something
#   end
#
#   # ignored
#   def method foo,
#   bar
#   do_something
#   end
class RuboCop::Cop::Layout::FirstMethodParameterLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FirstElementLineBreak
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
end

RuboCop::Cop::Layout::FirstMethodParameterLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the first parameter in a method
# definition. Parameters after the first one are checked by
# Layout/ParameterAlignment, not by this cop.
#
# For indenting the first argument of method _calls_, check out
# Layout/FirstArgumentIndentation, which supports options related to
# nesting that are irrelevant for method _definitions_.
#
# @example
#
#   # bad
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
# @example EnforcedStyle: consistent (default)
#   # The first parameter should always be indented one step more than the
#   # preceding line.
#
#   # good
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
# @example EnforcedStyle: align_parentheses
#   # The first parameter should always be indented one step more than the
#   # opening parenthesis.
#
#   # good
#   def some_method(
#   first_param,
#   second_param)
#   123
#   end
class RuboCop::Cop::Layout::FirstParameterIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineElementIndentation
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  def autocorrect(corrector, node); end

  # Returns the description of what the correct indentation is based on.
  def base_description(_); end

  def brace_alignment_style; end
  def check(def_node); end
  def message(base_description); end
end

RuboCop::Cop::Layout::FirstParameterIndentation::MSG = T.let(T.unsafe(nil), String)

# Check that the keys, separators, and values of a multi-line hash
# literal are aligned according to configuration. The configuration
# options are:
#
# * key (left align keys, one space before hash rockets and values)
# * separator (align hash rockets and colons, right align keys)
# * table (left align keys, hash rockets, and values)
#
# The treatment of hashes passed as the last argument to a method call
# can also be configured. The options are:
#
# * always_inspect
# * always_ignore
# * ignore_implicit (without curly braces)
#
# Alternatively you can specify multiple allowed styles. That's done by
# passing a list of styles to EnforcedStyles.
#
# @example EnforcedLastArgumentHashStyle: ignore_explicit
#   # Ignore only explicit hashes.
#
#   # bad
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
# @example EnforcedHashRocketStyle: separator
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#   {
#   :foo => bar,
#   :ba  => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba => baz
#   }
# @example EnforcedHashRocketStyle: table
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba  => baz
#   }
# @example EnforcedColonStyle: key (default)
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#   {
#   foo: bar,
#   ba:  baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba: baz
#   }
# @example EnforcedColonStyle: separator
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba: baz
#   }
# @example EnforcedColonStyle: table
#   # bad
#   {
#   foo: bar,
#   ba: baz
#   }
#
#   # good
#   {
#   foo: bar,
#   ba:  baz
#   }
# @example EnforcedLastArgumentHashStyle: always_inspect (default)
#   # Inspect both implicit and explicit hashes.
#
#   # bad
#   do_something(foo: 1,
#   bar: 2)
#
#   # bad
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something(
#   foo: 1,
#   bar: 2
#   )
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something({
#   foo: 1,
#   bar: 2
#   })
# @example EnforcedLastArgumentHashStyle: always_ignore
#   # Ignore both implicit and explicit hashes.
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
#
#   # good
#   do_something({foo: 1,
#   bar: 2})
# @example EnforcedLastArgumentHashStyle: ignore_implicit
#   # Ignore only implicit hashes.
#
#   # bad
#   do_something({foo: 1,
#   bar: 2})
#
#   # good
#   do_something(foo: 1,
#   bar: 2)
# @example EnforcedHashRocketStyle: key (default)
#   # bad
#   {
#   :foo => bar,
#   :ba => baz
#   }
#   {
#   :foo => bar,
#   :ba  => baz
#   }
#
#   # good
#   {
#   :foo => bar,
#   :ba => baz
#   }
class RuboCop::Cop::Layout::HashAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::HashAlignmentStyles
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # Returns the value of attribute column_deltas.
  def column_deltas; end

  # Sets the attribute column_deltas
  #
  # @param value the value to set the attribute column_deltas to.
  def column_deltas=(_arg0); end

  # Returns the value of attribute offenses_by.
  def offenses_by; end

  # Sets the attribute offenses_by
  #
  # @param value the value to set the attribute offenses_by to.
  def offenses_by=(_arg0); end

  def on_hash(node); end
  def on_send(node); end
  def on_super(node); end
  def on_yield(node); end

  private

  def add_offenses; end
  def adjust(corrector, delta, range); end
  def alignment_for(pair); end
  def alignment_for_colons; end
  def alignment_for_hash_rockets; end
  def argument_alignment_config; end
  def argument_before_hash(hash_node); end

  # @return [Boolean]
  def autocorrect_incompatible_with_other_cops?(node); end

  def check_delta(delta, node:, alignment:); end
  def check_pairs(node); end
  def correct_key_value(corrector, delta, key, value, separator); end
  def correct_no_value(corrector, key_delta, key); end
  def correct_node(corrector, node, delta); end

  # @return [Boolean]
  def double_splat?(node); end

  # @return [Boolean]
  def enforce_first_argument_with_fixed_indentation?; end

  # @return [Boolean]
  def good_alignment?(column_deltas); end

  # @return [Boolean]
  def ignore_hash_argument?(node); end

  def new_alignment(key); end
  def register_offenses_with_format(offenses, format); end
  def reset!; end
end

RuboCop::Cop::Layout::HashAlignment::MESSAGES = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Layout::HashAlignment::SEPARATOR_ALIGNMENT_STYLES = T.let(T.unsafe(nil), Array)

# Checks for the placement of the closing parenthesis
# in a method call that passes a HEREDOC string as an argument.
# It should be placed at the end of the line containing the
# opening HEREDOC tag.
#
# @example
#   # bad
#
#   foo(<<-SQL
#   bar
#   SQL
#   )
#
#   foo(<<-SQL, 123, <<-NOSQL,
#   bar
#   SQL
#   baz
#   NOSQL
#   )
#
#   foo(
#   bar(<<-SQL
#   baz
#   SQL
#   ),
#   123,
#   )
#
#   # good
#
#   foo(<<-SQL)
#   bar
#   SQL
#
#   foo(<<-SQL, 123, <<-NOSQL)
#   bar
#   SQL
#   baz
#   NOSQL
#
#   foo(
#   bar(<<-SQL),
#   baz
#   SQL
#   123,
#   )
class RuboCop::Cop::Layout::HeredocArgumentClosingParenthesis < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def add_correct_closing_paren(node, corrector); end
  def add_correct_external_trailing_comma(node, corrector); end

  # Autocorrection note:
  #
  # Commas are a bit tricky to handle when the method call is
  # embedded in another expression. Here's an example:
  #
  # [
  #   first_array_value,
  #   foo(<<-SQL, 123, 456,
  #     SELECT * FROM db
  #   SQL
  #   ),
  #   third_array_value,
  # ]
  #
  # The "internal" trailing comma is after `456`.
  # The "external" trailing comma is after `)`.
  #
  # To autocorrect, we remove the latter, and move the former up:
  #
  # [
  #   first_array_value,
  #   foo(<<-SQL, 123, 456),
  #     SELECT * FROM db
  #   SQL
  #   third_array_value,
  # ]
  def autocorrect(corrector, node); end

  # @return [Boolean]
  def exist_argument_between_heredoc_end_and_closing_parentheses?(node); end

  # @return [Boolean]
  def external_trailing_comma?(node); end

  # Returns nil if no trailing external comma.
  def external_trailing_comma_offset_from_loc_end(node); end

  def extract_heredoc(node); end
  def extract_heredoc_argument(node); end
  def find_most_bottom_of_heredoc_end(arguments); end
  def fix_closing_parenthesis(node, corrector); end

  # External trailing comma helpers.
  def fix_external_trailing_comma(node, corrector); end

  # @return [Boolean]
  def heredoc_node?(node); end

  def incorrect_parenthesis_removal_begin(node); end
  def incorrect_parenthesis_removal_end(node); end

  # @return [Boolean]
  def internal_trailing_comma?(node); end

  # Returns nil if no trailing internal comma.
  def internal_trailing_comma_offset_from_last_arg(node); end

  def outermost_send_on_same_line(heredoc); end
  def remove_incorrect_closing_paren(node, corrector); end
  def remove_incorrect_external_trailing_comma(node, corrector); end

  # Internal trailing comma helpers.
  def remove_internal_trailing_comma(node, corrector); end

  # @return [Boolean]
  def safe_to_remove_line_containing_closing_paren?(node); end

  # @return [Boolean]
  def send_missing_closing_parens?(parent, child, heredoc); end

  # @return [Boolean]
  def single_line_send_with_heredoc_receiver?(node); end

  # @return [Boolean]
  def space?(pos); end

  # Closing parenthesis helpers.
  #
  # @return [Boolean]
  def subsequent_closing_parentheses_in_same_line?(outermost_send); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Layout::HeredocArgumentClosingParenthesis::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the here document bodies. The bodies
# are indented one step.
#
# Note: When ``Layout/LineLength``'s `AllowHeredoc` is false (not default),
#       this cop does not add any offenses for long here documents to
#       avoid `Layout/LineLength`'s offenses.
#
# @example
#   # bad
#   <<-RUBY
#   something
#   RUBY
#
#   # good
#   <<~RUBY
#   something
#   RUBY
class RuboCop::Cop::Layout::HeredocIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  def on_heredoc(node); end

  private

  def adjust_minus(corrector, node); end
  def adjust_squiggly(corrector, node); end
  def base_indent_level(node); end
  def heredoc_body(node); end
  def heredoc_end(node); end

  # Returns '~', '-' or nil
  def heredoc_indent_type(node); end

  def indentation_width; end
  def indented_body(node); end
  def indented_end(node); end

  # @return [Boolean]
  def line_too_long?(node); end

  def longest_line(lines); end
  def max_line_length; end
  def message(heredoc_indent_type); end
  def register_offense(node, heredoc_indent_type); end
  def type_message(indentation_width, current_indent_type); end

  # @return [Boolean]
  def unlimited_heredoc_length?; end

  def width_message(indentation_width); end
end

RuboCop::Cop::Layout::HeredocIndentation::TYPE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::HeredocIndentation::WIDTH_MSG = T.let(T.unsafe(nil), String)

# Checks for inconsistent indentation.
#
# The difference between `indented_internal_methods` and `normal` is
# that the `indented_internal_methods` style prescribes that in
# classes and modules the `protected` and `private` modifier keywords
# shall be indented the same as public methods and that protected and
# private members shall be indented one step more than the modifiers.
# Other than that, both styles mean that entities on the same logical
# depth shall have the same indentation.
#
# @example EnforcedStyle: normal (default)
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
# @example EnforcedStyle: indented_internal_methods
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # bad
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   puts 'world'
#   end
#
#   protected
#
#   def foo
#   end
#
#   private
#
#   def bar
#   end
#   end
class RuboCop::Cop::Layout::IndentationConsistency < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_begin(node); end
  def on_kwbegin(node); end

  private

  def autocorrect(corrector, node); end

  # Not all nodes define `bare_access_modifier?` (for example,
  # `RuboCop::AST::DefNode` does not), so we must check `send_type?` first
  # to avoid a NoMethodError.
  #
  # @return [Boolean]
  def bare_access_modifier?(node); end

  # Returns an integer representing the correct indentation, or nil to
  # indicate that the correct indentation is that of the first child that
  # is not an access modifier.
  def base_column_for_normal_style(node); end

  def check(node); end
  def check_indented_internal_methods_style(node); end
  def check_normal_style(node); end
end

RuboCop::Cop::Layout::IndentationConsistency::MSG = T.let(T.unsafe(nil), String)

# Checks that the indentation method is consistent.
# Either tabs only or spaces only are used for indentation.
#
# @example EnforcedStyle: spaces (default)
#   # bad
#   # This example uses a tab to indent bar.
#   def foo
#   bar
#   end
#
#   # good
#   # This example uses spaces to indent bar.
#   def foo
#   bar
#   end
# @example EnforcedStyle: tabs
#   # bad
#   # This example uses spaces to indent bar.
#   def foo
#   bar
#   end
#
#   # good
#   # This example uses a tab to indent bar.
#   def foo
#   bar
#   end
class RuboCop::Cop::Layout::IndentationStyle < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(corrector, range); end
  def autocorrect_lambda_for_spaces(corrector, range); end
  def autocorrect_lambda_for_tabs(corrector, range); end
  def find_offense(line, lineno); end

  # @return [Boolean]
  def in_string_literal?(ranges, tabs_range); end

  def message(_node); end
  def string_literal_ranges(ast); end
end

RuboCop::Cop::Layout::IndentationStyle::MSG = T.let(T.unsafe(nil), String)

# Checks for indentation that doesn't use the specified number
# of spaces.
#
# See also the IndentationConsistency cop which is the companion to this
# one.
#
# @example
#   # bad
#   class A
#   def test
#   puts 'hello'
#   end
#   end
#
#   # good
#   class A
#   def test
#   puts 'hello'
#   end
#   end
# @example AllowedPatterns: ['^\s*module']
#   # bad
#   module A
#   class B
#   def test
#   puts 'hello'
#   end
#   end
#   end
#
#   # good
#   module A
#   class B
#   def test
#   puts 'hello'
#   end
#   end
#   end
class RuboCop::Cop::Layout::IndentationWidth < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def access_modifier?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_case(case_node); end
  def on_case_match(case_match); end
  def on_class(node); end
  def on_csend(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_ensure(node); end
  def on_for(node); end
  def on_if(node, base = T.unsafe(nil)); end
  def on_kwbegin(node); end
  def on_module(node); end
  def on_numblock(node); end
  def on_resbody(node); end
  def on_rescue(node); end
  def on_sclass(node); end
  def on_send(node); end
  def on_until(node, base = T.unsafe(nil)); end
  def on_while(node, base = T.unsafe(nil)); end

  private

  def access_modifier_indentation_style; end
  def autocorrect(corrector, node); end
  def check_assignment(node, rhs); end
  def check_if(node, body, else_clause, base_loc); end
  def check_indentation(base_loc, body_node, style = T.unsafe(nil)); end
  def check_members(base, members); end
  def check_members_for_indented_internal_methods_style(members); end
  def check_members_for_normal_style(base, members); end

  # @return [Boolean]
  def check_rescue?(rescue_node); end

  def configured_indentation_width; end
  def each_member(members); end
  def indentation_consistency_style; end

  # @return [Boolean]
  def indentation_to_check?(base_loc, body_node); end

  # @return [Boolean]
  def indented_internal_methods_style?; end

  def leftmost_modifier_of(node); end
  def message(configured_indentation_width, indentation, name); end
  def offending_range(body_node, indentation); end
  def offense(body_node, indentation, style); end

  # Returns true if the given node is within another node that has
  # already been marked for autocorrection by this cop.
  #
  # @return [Boolean]
  def other_offense_in_same_range?(node); end

  def select_check_member(member); end

  # @return [Boolean]
  def skip_check?(base_loc, body_node); end

  # @return [Boolean]
  def special_modifier?(node); end

  # @return [Boolean]
  def starts_with_access_modifier?(body_node); end
end

RuboCop::Cop::Layout::IndentationWidth::MSG = T.let(T.unsafe(nil), String)

# Checks for indentation of the first non-blank non-comment
# line in a file.
#
# @example
#   # bad
#   class A
#   def foo; end
#   end
#
#   # good
#   class A
#   def foo; end
#   end
class RuboCop::Cop::Layout::InitialIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def first_token; end

  # @yield [range_between(space_range.begin_pos, token.begin_pos)]
  def space_before(token); end
end

RuboCop::Cop::Layout::InitialIndentation::MSG = T.let(T.unsafe(nil), String)

# Checks whether comments have a leading space after the
# `#` denoting the start of the comment. The leading space is not
# required for some RDoc special syntax, like `#++`, `#--`,
# `#:nodoc`, `=begin`- and `=end` comments, "shebang" directives,
# or rackup options.
#
# @example
#
#   # bad
#   #Some comment
#
#   # good
#   # Some comment
# @example AllowDoxygenCommentStyle: false (default)
#
#   # bad
#
#   #**
#   # Some comment
#   # Another line of comment
#   #*
# @example AllowDoxygenCommentStyle: true
#
#   # good
#
#   #**
#   # Some comment
#   # Another line of comment
#   #*
# @example AllowGemfileRubyComment: false (default)
#
#   # bad
#
#   #ruby=2.7.0
#   #ruby-gemset=myproject
# @example AllowGemfileRubyComment: true
#
#   # good
#
#   #ruby=2.7.0
#   #ruby-gemset=myproject
class RuboCop::Cop::Layout::LeadingCommentSpace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # @return [Boolean]
  def allow_doxygen_comment?; end

  # @return [Boolean]
  def allow_gemfile_ruby_comment?; end

  # @return [Boolean]
  def allowed_on_first_line?(comment); end

  # @return [Boolean]
  def doxygen_comment_style?(comment); end

  # @return [Boolean]
  def gemfile?; end

  # @return [Boolean]
  def gemfile_ruby_comment?(comment); end

  def hash_mark(expr); end

  # @return [Boolean]
  def rackup_config_file?; end

  # @return [Boolean]
  def rackup_options?(comment); end

  # @return [Boolean]
  def ruby_comment_in_gemfile?(comment); end

  # @return [Boolean]
  def shebang?(comment); end
end

RuboCop::Cop::Layout::LeadingCommentSpace::MSG = T.let(T.unsafe(nil), String)

# Checks for unnecessary leading blank lines at the beginning
# of a file.
#
# @example
#
#   # bad
#   # (start of file)
#
#   class Foo
#   end
#
#   # bad
#   # (start of file)
#
#   # a comment
#
#   # good
#   # (start of file)
#   class Foo
#   end
#
#   # good
#   # (start of file)
#   # a comment
class RuboCop::Cop::Layout::LeadingEmptyLines < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
end

RuboCop::Cop::Layout::LeadingEmptyLines::MSG = T.let(T.unsafe(nil), String)

# Checks that strings broken over multiple lines (by a backslash) contain
# trailing spaces instead of leading spaces (default) or leading spaces
# instead of trailing spaces.
#
# @example EnforcedStyle: trailing (default)
#   # bad
#   'this text contains a lot of' \
#   '               spaces'
#
#   # good
#   'this text contains a lot of               ' \
#   'spaces'
#
#   # bad
#   'this text is too' \
#   ' long'
#
#   # good
#   'this text is too ' \
#   'long'
# @example EnforcedStyle: leading
#   # bad
#   'this text contains a lot of               ' \
#   'spaces'
#
#   # good
#   'this text contains a lot of' \
#   '               spaces'
#
#   # bad
#   'this text is too ' \
#   'long'
#
#   # good
#   'this text is too' \
#   ' long'
class RuboCop::Cop::Layout::LineContinuationLeadingSpace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_dstr(node); end

  private

  # @return [Boolean]
  def continuation?(line); end

  # @return [Boolean]
  def enforced_style_leading?; end

  def investigate_leading_style(first_line, end_of_first_line); end
  def investigate_trailing_style(second_line, end_of_first_line); end
  def leading_offense_range(end_of_first_line, matches); end
  def message(_range); end
  def raw_lines(node); end
  def trailing_offense_range(end_of_first_line, matches); end
end

# Checks that the backslash of a line continuation is separated from
# preceding text by exactly one space (default) or zero spaces.
#
# @example EnforcedStyle: space (default)
#   # bad
#   'a'\
#   'b'  \
#   'c'
#
#   # good
#   'a' \
#   'b' \
#   'c'
# @example EnforcedStyle: no_space
#   # bad
#   'a' \
#   'b'  \
#   'c'
#
#   # good
#   'a'\
#   'b'\
#   'c'
class RuboCop::Cop::Layout::LineContinuationSpacing < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(corrector, range); end
  def comment_ranges(comments); end
  def find_offensive_spacing(line); end

  # @return [Boolean]
  def ignore_range?(backtick_range); end

  def investigate(line, line_number); end
  def last_line(processed_source); end
  def message(_range); end

  # @return [Boolean]
  def no_space_style?; end

  # @return [Boolean]
  def space_style?; end

  def string_literal_ranges(ast); end
end

# Checks the indentation of the next line after a line that ends with a string
# literal and a backslash.
#
# If `EnforcedStyle: aligned` is set, the concatenated string parts shall be aligned with the
# first part. There are some exceptions, such as implicit return values, where the
# concatenated string parts shall be indented regardless of `EnforcedStyle` configuration.
#
# If `EnforcedStyle: indented` is set, it's the second line that shall be indented one step
# more than the first line. Lines 3 and forward shall be aligned with line 2.
#
# @example
#   # bad
#   def some_method
#   'x' \
#   'y' \
#   'z'
#   end
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   def some_method
#   'x' \
#   'y' \
#   'z'
#   end
# @example EnforcedStyle: aligned (default)
#   # bad
#   puts 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   puts 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
# @example EnforcedStyle: indented
#   # bad
#   result = 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
#
#   # good
#   result = 'x' \
#   'y'
#
#   my_hash = {
#   first: 'a message' \
#   'in two parts'
#   }
class RuboCop::Cop::Layout::LineEndStringConcatenationIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, node); end
  def on_dstr(node); end

  private

  def add_offense_and_correction(node, message); end

  # @return [Boolean]
  def always_indented?(dstr_node); end

  def base_column(child); end
  def check_aligned(children, start_index); end
  def check_indented(children); end

  # @return [Boolean]
  def strings_concatenated_with_backslash?(dstr_node); end
end

RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::MSG_ALIGN = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::MSG_INDENT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::LineEndStringConcatenationIndentation::PARENT_TYPES_FOR_INDENTED = T.let(T.unsafe(nil), Array)

# Checks the length of lines in the source code.
# The maximum length is configurable.
# The tab size is configured in the `IndentationWidth`
# of the `Layout/IndentationStyle` cop.
# It also ignores a shebang line by default.
#
# This cop has some autocorrection capabilities.
# It can programmatically shorten certain long lines by
# inserting line breaks into expressions that can be safely
# split across lines. These include arrays, hashes, and
# method calls with argument lists.
#
# If autocorrection is enabled, the following Layout cops
# are recommended to further format the broken lines.
# (Many of these are enabled by default.)
#
# * ArgumentAlignment
# * ArrayAlignment
# * BlockAlignment
# * BlockDelimiters
# * BlockEndNewline
# * ClosingParenthesisIndentation
# * FirstArgumentIndentation
# * FirstArrayElementIndentation
# * FirstHashElementIndentation
# * FirstParameterIndentation
# * HashAlignment
# * IndentationWidth
# * MultilineArrayLineBreaks
# * MultilineBlockLayout
# * MultilineHashBraceLayout
# * MultilineHashKeyLineBreaks
# * MultilineMethodArgumentLineBreaks
# * MultilineMethodParameterLineBreaks
# * ParameterAlignment
#
# Together, these cops will pretty print hashes, arrays,
# method calls, etc. For example, let's say the max columns
# is 25:
#
# @example
#
#   # bad
#   {foo: "0000000000", bar: "0000000000", baz: "0000000000"}
#
#   # good
#   {foo: "0000000000",
#   bar: "0000000000", baz: "0000000000"}
#
#   # good (with recommended cops enabled)
#   {
#   foo: "0000000000",
#   bar: "0000000000",
#   baz: "0000000000",
#   }
class RuboCop::Cop::Layout::LineLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckLineBreakable
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::LineLengthHelp
  extend ::RuboCop::Cop::AutoCorrector

  def max=(value); end
  def on_array(node); end
  def on_block(node); end
  def on_def(node); end
  def on_hash(node); end
  def on_investigation_end; end
  def on_new_investigation; end
  def on_numblock(node); end
  def on_potential_breakable_node(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allow_heredoc?; end

  def allowed_heredoc; end

  # @return [Boolean]
  def allowed_line?(line, line_index); end

  def breakable_block_range(block_node); end

  # Returns the value of attribute breakable_range.
  def breakable_range; end

  # Sets the attribute breakable_range
  #
  # @param value the value to set the attribute breakable_range to.
  def breakable_range=(_arg0); end

  def breakable_range_after_semicolon(semicolon_token); end
  def breakable_range_by_line_index; end
  def check_directive_line(line, line_index); end
  def check_for_breakable_block(block_node); end
  def check_for_breakable_node(node); end
  def check_for_breakable_semicolons(processed_source); end
  def check_line(line, line_index); end
  def check_uri_line(line, line_index); end
  def excess_range(uri_range, line, line_index); end
  def extract_heredocs(ast); end
  def heredocs; end
  def highlight_start(line); end

  # @return [Boolean]
  def line_in_heredoc?(line_number); end

  # @return [Boolean]
  def line_in_permitted_heredoc?(line_number); end

  def max; end
  def register_offense(loc, line, line_index, length: T.unsafe(nil)); end

  # @return [Boolean]
  def shebang?(line, line_index); end
end

RuboCop::Cop::Layout::LineLength::MSG = T.let(T.unsafe(nil), String)

# Checks that the closing brace in an array literal is either
# on the same line as the last array element or on a new line.
#
# When using the `symmetrical` (default) style:
#
# If an array's opening brace is on the same line as the first element
# of the array, then the closing brace should be on the same line as
# the last element of the array.
#
# If an array's opening brace is on the line above the first element
# of the array, then the closing brace should be on the line below
# the last element of the array.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line array literal must be on the line
# after the last element of the array.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line array literal must be on the same
# line as the last element of the array.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   [ :a,
#   :b
#   ]
#
#   # bad
#   [
#   :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b ]
#
#   # good
#   [
#   :a,
#   :b
#   ]
# @example EnforcedStyle: new_line
#   # bad
#   [
#   :a,
#   :b ]
#
#   # bad
#   [ :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b
#   ]
#
#   # good
#   [
#   :a,
#   :b
#   ]
# @example EnforcedStyle: same_line
#   # bad
#   [ :a,
#   :b
#   ]
#
#   # bad
#   [
#   :a,
#   :b
#   ]
#
#   # good
#   [
#   :a,
#   :b ]
#
#   # good
#   [ :a,
#   :b ]
class RuboCop::Cop::Layout::MultilineArrayBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
end

RuboCop::Cop::Layout::MultilineArrayBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineArrayBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineArrayBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineArrayBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each item in a multi-line array
# starts on a separate line.
#
# @example
#
#   # bad
#   [
#   a, b,
#   c
#   ]
#
#   # good
#   [
#   a,
#   b,
#   c
#   ]
class RuboCop::Cop::Layout::MultilineArrayLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
end

RuboCop::Cop::Layout::MultilineArrayLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks whether the multiline assignments have a newline
# after the assignment operator.
#
# @example EnforcedStyle: new_line (default)
#   # bad
#   foo = if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   begin
#   compute
#   rescue => e
#   nil
#   end
# @example EnforcedStyle: same_line
#   # good
#   foo = if expression
#   'bar'
#   end
# @example SupportedTypes: ['block', 'case', 'class', 'if', 'kwbegin', 'module'] (default)
#   # good
#   foo =
#   if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   [1].map do |i|
#   i + 1
#   end
# @example SupportedTypes: ['block']
#   # good
#   foo = if expression
#   'bar'
#   end
#
#   # good
#   foo =
#   [1].map do |i|
#   'bar' * i
#   end
class RuboCop::Cop::Layout::MultilineAssignmentLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def check_assignment(node, rhs); end
  def check_by_enforced_style(node, rhs); end
  def check_new_line_offense(node, rhs); end
  def check_same_line_offense(node, rhs); end

  private

  def supported_types; end
end

RuboCop::Cop::Layout::MultilineAssignmentLayout::NEW_LINE_OFFENSE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineAssignmentLayout::SAME_LINE_OFFENSE = T.let(T.unsafe(nil), String)

# Checks whether the multiline do end blocks have a newline
# after the start of the block. Additionally, it checks whether the block
# arguments, if any, are on the same line as the start of the
# block. Putting block arguments on separate lines, because the whole
# line would otherwise be too long, is accepted.
#
# @example
#   # bad
#   blah do |i| foo(i)
#   bar(i)
#   end
#
#   # bad
#   blah do
#   |i| foo(i)
#   bar(i)
#   end
#
#   # good
#   blah do |i|
#   foo(i)
#   bar(i)
#   end
#
#   # bad
#   blah { |i| foo(i)
#   bar(i)
#   }
#
#   # good
#   blah { |i|
#   foo(i)
#   bar(i)
#   }
#
#   # good
#   blah { |
#   long_list,
#   of_parameters,
#   that_would_not,
#   fit_on_one_line
#   |
#   foo(i)
#   bar(i)
#   }
class RuboCop::Cop::Layout::MultilineBlockLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end

  private

  def add_offense_for_expression(node, expr, msg); end

  # @return [Boolean]
  def args_on_beginning_line?(node); end

  def autocorrect(corrector, node); end
  def autocorrect_arguments(corrector, node); end
  def autocorrect_body(corrector, node, block_body); end
  def block_arg_string(node, args); end
  def characters_needed_for_space_and_pipes(node); end

  # @return [Boolean]
  def include_trailing_comma?(args); end

  # @return [Boolean]
  def line_break_necessary_in_args?(node); end

  def needed_length_for_args(node); end
end

RuboCop::Cop::Layout::MultilineBlockLayout::ARG_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineBlockLayout::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineBlockLayout::PIPE_SIZE = T.let(T.unsafe(nil), Integer)

# Checks that the closing brace in a hash literal is either
# on the same line as the last hash element, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a hash's opening brace is on the same line as the first element
# of the hash, then the closing brace should be on the same line as
# the last element of the hash.
#
# If a hash's opening brace is on the line above the first element
# of the hash, then the closing brace should be on the line below
# the last element of the hash.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line hash literal must be on the line
# after the last element of the hash.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line hash literal must be on the same
# line as the last element of the hash.
#
# @example EnforcedStyle: symmetrical (default)
#
#   # bad
#   { a: 1,
#   b: 2
#   }
#   # bad
#   {
#   a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2 }
#
#   # good
#   {
#   a: 1,
#   b: 2
#   }
# @example EnforcedStyle: new_line
#   # bad
#   {
#   a: 1,
#   b: 2 }
#
#   # bad
#   { a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2
#   }
# @example EnforcedStyle: same_line
#   # bad
#   { a: 1,
#   b: 2
#   }
#
#   # bad
#   {
#   a: 1,
#   b: 2
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2 }
#
#   # good
#   { a: 1,
#   b: 2 }
class RuboCop::Cop::Layout::MultilineHashBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end
end

RuboCop::Cop::Layout::MultilineHashBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineHashBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineHashBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineHashBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each key in a multi-line hash
# starts on a separate line.
#
# @example
#
#   # bad
#   {
#   a: 1, b: 2,
#   c: 3
#   }
#
#   # good
#   {
#   a: 1,
#   b: 2,
#   c: 3
#   }
class RuboCop::Cop::Layout::MultilineHashKeyLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end

  private

  # @return [Boolean]
  def starts_with_curly_brace?(node); end
end

RuboCop::Cop::Layout::MultilineHashKeyLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Ensures that each argument in a multi-line method call
# starts on a separate line.
#
# NOTE: This cop does not move the first argument, if you want that to
# be on a separate line, see `Layout/FirstMethodArgumentLineBreak`.
#
# @example
#
#   # bad
#   foo(a, b,
#   c
#   )
#
#   # good
#   foo(
#   a,
#   b,
#   c
#   )
#
#   # good
#   foo(a, b, c)
class RuboCop::Cop::Layout::MultilineMethodArgumentLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
end

RuboCop::Cop::Layout::MultilineMethodArgumentLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks that the closing brace in a method call is either
# on the same line as the last method argument, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a method call's opening brace is on the same line as the first
# argument of the call, then the closing brace should be on the same
# line as the last argument of the call.
#
# If an method call's opening brace is on the line above the first
# argument of the call, then the closing brace should be on the line
# below the last argument of the call.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line method call must be on the line
# after the last argument of the call.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line method call must be on the same
# line as the last argument of the call.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   foo(a,
#   b
#   )
#
#   # bad
#   foo(
#   a,
#   b)
#
#   # good
#   foo(a,
#   b)
#
#   # good
#   foo(
#   a,
#   b
#   )
# @example EnforcedStyle: new_line
#   # bad
#   foo(
#   a,
#   b)
#
#   # bad
#   foo(a,
#   b)
#
#   # good
#   foo(a,
#   b
#   )
#
#   # good
#   foo(
#   a,
#   b
#   )
# @example EnforcedStyle: same_line
#   # bad
#   foo(a,
#   b
#   )
#
#   # bad
#   foo(
#   a,
#   b
#   )
#
#   # good
#   foo(
#   a,
#   b)
#
#   # good
#   foo(a,
#   b)
class RuboCop::Cop::Layout::MultilineMethodCallBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def children(node); end

  # @return [Boolean]
  def ignored_literal?(node); end

  # @return [Boolean]
  def single_line_ignoring_receiver?(node); end
end

RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodCallBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Checks the indentation of the method name part in method calls
# that span more than one line.
#
# @example EnforcedStyle: aligned (default)
#   # bad
#   while myvariable
#   .b
#   # do something
#   end
#
#   # good
#   while myvariable
#   .b
#   # do something
#   end
#
#   # good
#   Thing.a
#   .b
#   .c
# @example EnforcedStyle: indented
#   # good
#   while myvariable
#   .b
#
#   # do something
#   end
# @example EnforcedStyle: indented_relative_to_receiver
#   # good
#   while myvariable
#   .a
#   .b
#
#   # do something
#   end
#
#   # good
#   myvariable = Thing
#   .a
#   .b
#   .c
class RuboCop::Cop::Layout::MultilineMethodCallIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::MultilineExpressionIndentation
  extend ::RuboCop::Cop::AutoCorrector

  # @raise [ValidationError]
  def validate_config; end

  private

  def align_with_base_message(rhs); end
  def alignment_base(node, rhs, given_style); end
  def autocorrect(corrector, node); end
  def base_source; end
  def extra_indentation(given_style, parent); end
  def first_call_has_a_dot(node); end
  def get_dot_right_above(node); end
  def message(node, lhs, rhs); end
  def no_base_message(lhs, rhs, node); end
  def offending_range(node, lhs, rhs, given_style); end

  # @yield [operation_rhs.first_argument]
  def operation_rhs(node); end

  # @return [Boolean]
  def operator_rhs?(node, receiver); end

  # a
  #   .b
  #   .c
  def receiver_alignment_base(node); end

  def relative_to_receiver_message(rhs); end

  # @return [Boolean]
  def relevant_node?(send_node); end

  def right_hand_side(send_node); end

  # a.b
  #  .c
  def semantic_alignment_base(node, rhs); end

  def semantic_alignment_node(node); end

  # @return [Boolean]
  def should_align_with_base?; end

  # @return [Boolean]
  def should_indent_relative_to_receiver?; end

  def syntactic_alignment_base(lhs, rhs); end
end

# Checks that the closing brace in a method definition is either
# on the same line as the last method parameter, or a new line.
#
# When using the `symmetrical` (default) style:
#
# If a method definition's opening brace is on the same line as the
# first parameter of the definition, then the closing brace should be
# on the same line as the last parameter of the definition.
#
# If an method definition's opening brace is on the line above the first
# parameter of the definition, then the closing brace should be on the
# line below the last parameter of the definition.
#
# When using the `new_line` style:
#
# The closing brace of a multi-line method definition must be on the line
# after the last parameter of the definition.
#
# When using the `same_line` style:
#
# The closing brace of a multi-line method definition must be on the same
# line as the last parameter of the definition.
#
# @example EnforcedStyle: symmetrical (default)
#   # bad
#   def foo(a,
#   b
#   )
#   end
#
#   # bad
#   def foo(
#   a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b)
#   end
#
#   # good
#   def foo(
#   a,
#   b
#   )
#   end
# @example EnforcedStyle: new_line
#   # bad
#   def foo(
#   a,
#   b)
#   end
#
#   # bad
#   def foo(a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b
#   )
#   end
# @example EnforcedStyle: same_line
#   # bad
#   def foo(a,
#   b
#   )
#   end
#
#   # bad
#   def foo(
#   a,
#   b
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b)
#   end
#
#   # good
#   def foo(a,
#   b)
#   end
class RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
end

RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::ALWAYS_NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::ALWAYS_SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::NEW_LINE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::MultilineMethodDefinitionBraceLayout::SAME_LINE_MESSAGE = T.let(T.unsafe(nil), String)

# Ensures that each parameter in a multi-line method definition
# starts on a separate line.
#
# NOTE: This cop does not move the first argument, if you want that to
# be on a separate line, see `Layout/FirstMethodParameterLineBreak`.
#
# @example
#
#   # bad
#   def foo(a, b,
#   c
#   )
#   end
#
#   # good
#   def foo(
#   a,
#   b,
#   c
#   )
#   end
#
#   # good
#   def foo(a, b, c)
#   end
class RuboCop::Cop::Layout::MultilineMethodParameterLineBreaks < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MultilineElementLineBreaks
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
end

RuboCop::Cop::Layout::MultilineMethodParameterLineBreaks::MSG = T.let(T.unsafe(nil), String)

# Checks the indentation of the right hand side operand in binary operations that
# span more than one line.
#
# The `aligned` style checks that operators are aligned if they are part of an `if` or `while`
# condition, an explicit `return` statement, etc. In other contexts, the second operand should
# be indented regardless of enforced style.
#
# @example EnforcedStyle: aligned (default)
#   # bad
#   if a +
#   b
#   something &&
#   something_else
#   end
#
#   # good
#   if a +
#   b
#   something &&
#   something_else
#   end
# @example EnforcedStyle: indented
#   # bad
#   if a +
#   b
#   something &&
#   something_else
#   end
#
#   # good
#   if a +
#   b
#   something &&
#   something_else
#   end
class RuboCop::Cop::Layout::MultilineOperationIndentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::MultilineExpressionIndentation
  extend ::RuboCop::Cop::AutoCorrector

  def on_and(node); end
  def on_or(node); end

  # @raise [ValidationError]
  def validate_config; end

  private

  def autocorrect(corrector, node); end
  def check_and_or(node); end
  def message(node, lhs, rhs); end
  def offending_range(node, lhs, rhs, given_style); end

  # @return [Boolean]
  def relevant_node?(node); end

  def right_hand_side(send_node); end

  # @return [Boolean]
  def should_align?(node, rhs, given_style); end
end

# Here we check if the parameters on a multi-line method call or
# definition are aligned.
#
# To set the alignment of the first argument, use the cop
# FirstParameterIndentation.
#
# @example EnforcedStyle: with_first_parameter (default)
#   # good
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   def foo(
#   bar,
#   baz
#   )
#   123
#   end
#
#   # bad
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   # bad
#
#   def foo(
#   bar,
#   baz)
#   123
#   end
# @example EnforcedStyle: with_fixed_indentation
#   # good
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   def foo(
#   bar,
#   baz
#   )
#   123
#   end
#
#   # bad
#
#   def foo(bar,
#   baz)
#   123
#   end
#
#   # bad
#
#   def foo(
#   bar,
#   baz)
#   123
#   end
class RuboCop::Cop::Layout::ParameterAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  def autocorrect(corrector, node); end
  def base_column(node, args); end

  # @return [Boolean]
  def fixed_indentation?; end

  def message(_node); end
  def target_method_lineno(node); end
end

RuboCop::Cop::Layout::ParameterAlignment::ALIGN_PARAMS_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::ParameterAlignment::FIXED_INDENT_MSG = T.let(T.unsafe(nil), String)

# Checks whether certain expressions, e.g. method calls, that could fit
# completely on a single line, are broken up into multiple lines unnecessarily.
#
# @example any configuration
#   # bad
#   foo(
#   a,
#   b
#   )
#
#   puts 'string that fits on ' \
#   'a single line'
#
#   things
#   .select { |thing| thing.cond? }
#   .join('-')
#
#   # good
#   foo(a, b)
#
#   puts 'string that fits on a single line'
#
#   things.select { |thing| thing.cond? }.join('-')
# @example InspectBlocks: false (default)
#   # good
#   foo(a) do |x|
#   puts x
#   end
# @example InspectBlocks: true
#   # bad
#   foo(a) do |x|
#   puts x
#   end
#
#   # good
#   foo(a) { |x| puts x }
class RuboCop::Cop::Layout::RedundantLineBreak < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CheckAssignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def check_assignment(node, _rhs); end

  # @return [Boolean]
  def comment_within?(node); end

  # @return [Boolean]
  def configured_to_not_be_inspected?(node); end

  # @return [Boolean]
  def convertible_block?(node); end

  def max_line_length; end

  # @return [Boolean]
  def offense?(node); end

  # @return [Boolean]
  def other_cop_takes_precedence?(node); end

  def register_offense(node); end

  # @return [Boolean]
  def single_line_block_chain_enabled?; end

  # @return [Boolean]
  def suitable_as_single_line?(node); end

  def to_single_line(source); end

  # @return [Boolean]
  def too_long?(node); end
end

RuboCop::Cop::Layout::RedundantLineBreak::MSG = T.let(T.unsafe(nil), String)

# Checks whether the rescue and ensure keywords are aligned
# properly.
#
# @example
#
#   # bad
#   begin
#   something
#   rescue
#   puts 'error'
#   end
#
#   # good
#   begin
#   something
#   rescue
#   puts 'error'
#   end
class RuboCop::Cop::Layout::RescueEnsureAlignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::EndKeywordAlignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_ensure(node); end
  def on_new_investigation; end
  def on_resbody(node); end

  private

  # @return [Boolean]
  def access_modifier?(node); end

  def access_modifier_node(node); end

  # @return [Boolean]
  def aligned_with_leading_dot?(do_keyword_line, send_node_loc, rescue_keyword_column); end

  # @return [Boolean]
  def aligned_with_line_break_method?(ancestor_node, node); end

  def alignment_location(alignment_node); end

  # We will use ancestor or wrapper with access modifier.
  def alignment_node(node); end

  def alignment_source(node, starting_loc); end
  def ancestor_node(node); end
  def assignment_node(node); end
  def autocorrect(corrector, node, alignment_location); end
  def begin_end_alignment_style; end

  # Check alignment of node with rescue or ensure modifiers.
  def check(node); end

  def format_message(alignment_node, alignment_loc, kw_loc); end

  # @return [Boolean]
  def modifier?(node); end

  def whitespace_range(node); end
end

RuboCop::Cop::Layout::RescueEnsureAlignment::ALTERNATIVE_ACCESS_MODIFIERS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Layout::RescueEnsureAlignment::ANCESTOR_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Layout::RescueEnsureAlignment::ANCESTOR_TYPES_WITH_ACCESS_MODIFIERS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Layout::RescueEnsureAlignment::MSG = T.let(T.unsafe(nil), String)

# Checks if method calls are chained onto single line blocks. It considers that a
# line break before the dot improves the readability of the code.
#
# @example
#   # bad
#   example.select { |item| item.cond? }.join('-')
#
#   # good
#   example.select { |item| item.cond? }
#   .join('-')
#
#   # good (not a concern for this cop)
#   example.select do |item|
#   item.cond?
#   end.join('-')
class RuboCop::Cop::Layout::SingleLineBlockChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def call_method_after_block?(node, dot_range, closing_block_delimiter_line_num); end

  def offending_range(node); end
  def selector_range(node); end
end

RuboCop::Cop::Layout::SingleLineBlockChain::MSG = T.let(T.unsafe(nil), String)

# Checks for colon (:) not followed by some kind of space.
# N.B. this cop does not handle spaces after a ternary operator, which are
# instead handled by Layout/SpaceAroundOperators.
#
# @example
#   # bad
#   def f(a:, b:2); {a:3}; end
#
#   # good
#   def f(a:, b: 2); {a: 3}; end
class RuboCop::Cop::Layout::SpaceAfterColon < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_kwoptarg(node); end
  def on_pair(node); end

  private

  # @return [Boolean]
  def followed_by_space?(colon); end

  def register_offense(colon); end
end

RuboCop::Cop::Layout::SpaceAfterColon::MSG = T.let(T.unsafe(nil), String)

# Checks for comma (,) not followed by some kind of space.
#
# @example
#
#   # bad
#   [1,2]
#   { foo:bar,}
#
#   # good
#   [1, 2]
#   { foo:bar, }
class RuboCop::Cop::Layout::SpaceAfterComma < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SpaceAfterPunctuation
  extend ::RuboCop::Cop::AutoCorrector

  def kind(token); end
  def space_style_before_rcurly; end
end

# Checks for space between a method name and a left parenthesis in defs.
#
# @example
#
#   # bad
#   def func (x) end
#   def method= (y) end
#
#   # good
#   def func(x) end
#   def method=(y) end
class RuboCop::Cop::Layout::SpaceAfterMethodName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
end

RuboCop::Cop::Layout::SpaceAfterMethodName::MSG = T.let(T.unsafe(nil), String)

# Checks for space after `!`.
#
# @example
#   # bad
#   ! something
#
#   # good
#   !something
class RuboCop::Cop::Layout::SpaceAfterNot < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def whitespace_after_operator?(node); end
end

RuboCop::Cop::Layout::SpaceAfterNot::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAfterNot::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for semicolon (;) not followed by some kind of space.
#
# @example
#   # bad
#   x = 1;y = 2
#
#   # good
#   x = 1; y = 2
class RuboCop::Cop::Layout::SpaceAfterSemicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SpaceAfterPunctuation
  extend ::RuboCop::Cop::AutoCorrector

  def kind(token); end
  def space_style_before_rcurly; end
end

# Checks the spacing inside and after block parameters pipes. Line breaks
# inside parameter pipes are checked by `Layout/MultilineBlockLayout` and
# not by this cop.
#
# @example EnforcedStyleInsidePipes: no_space (default)
#   # bad
#   {}.each { | x,  y |puts x }
#   ->( x,  y ) { puts x }
#
#   # good
#   {}.each { |x, y| puts x }
#   ->(x, y) { puts x }
# @example EnforcedStyleInsidePipes: space
#   # bad
#   {}.each { |x,  y| puts x }
#   ->(x,  y) { puts x }
#
#   # good
#   {}.each { | x, y | puts x }
#   ->( x, y ) { puts x }
class RuboCop::Cop::Layout::SpaceAroundBlockParameters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end

  private

  def check_after_closing_pipe(arguments); end
  def check_arg(arg); end
  def check_closing_pipe_space(arguments, closing_pipe); end
  def check_each_arg(args); end
  def check_inside_pipes(arguments); end
  def check_no_space(space_begin_pos, space_end_pos, msg); end
  def check_no_space_style_inside_pipes(arguments); end
  def check_opening_pipe_space(arguments, opening_pipe); end
  def check_space(space_begin_pos, space_end_pos, range, msg, node = T.unsafe(nil)); end
  def check_space_style_inside_pipes(arguments); end
  def last_end_pos_inside_pipes(arguments, range); end
  def pipes(arguments); end

  # @return [Boolean]
  def pipes?(arguments); end

  def style_parameter_name; end
end

# Checks that the equals signs in parameter default assignments
# have or don't have surrounding space depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # bad
#   def some_method(arg1=:default, arg2=nil, arg3=[])
#   # do something...
#   end
#
#   # good
#   def some_method(arg1 = :default, arg2 = nil, arg3 = [])
#   # do something...
#   end
# @example EnforcedStyle: no_space
#   # bad
#   def some_method(arg1 = :default, arg2 = nil, arg3 = [])
#   # do something...
#   end
#
#   # good
#   def some_method(arg1=:default, arg2=nil, arg3=[])
#   # do something...
#   end
class RuboCop::Cop::Layout::SpaceAroundEqualsInParameterDefault < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_optarg(node); end

  private

  def autocorrect(corrector, range); end
  def check_optarg(arg, equals, value); end
  def incorrect_style_detected(arg, value); end
  def message(_node); end

  # @return [Boolean]
  def no_surrounding_space?(arg, equals); end

  # @return [Boolean]
  def space_on_both_sides?(arg, equals); end
end

RuboCop::Cop::Layout::SpaceAroundEqualsInParameterDefault::MSG = T.let(T.unsafe(nil), String)

# Checks the spacing around the keywords.
#
# @example
#
#   # bad
#   something 'test'do|x|
#   end
#
#   while(something)
#   end
#
#   something = 123if test
#
#   # good
#   something 'test' do |x|
#   end
#
#   while (something)
#   end
#
#   something = 123 if test
class RuboCop::Cop::Layout::SpaceAroundKeyword < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_and(node); end
  def on_block(node); end
  def on_break(node); end
  def on_case(node); end
  def on_case_match(node); end

  # @return [Boolean]
  def on_defined?(node); end

  def on_ensure(node); end
  def on_for(node); end
  def on_if(node); end
  def on_if_guard(node); end
  def on_in_pattern(node); end
  def on_kwbegin(node); end

  # Handle one-line pattern matching syntax (`in`) with `Parser::Ruby27`.
  def on_match_pattern(node); end

  # Handle one-line pattern matching syntax (`in`) with `Parser::Ruby30`.
  def on_match_pattern_p(node); end

  def on_next(node); end
  def on_or(node); end
  def on_postexe(node); end
  def on_preexe(node); end
  def on_resbody(node); end
  def on_rescue(node); end
  def on_return(node); end
  def on_send(node); end
  def on_super(node); end
  def on_unless_guard(node); end
  def on_until(node); end
  def on_when(node); end
  def on_while(node); end
  def on_yield(node); end
  def on_zsuper(node); end

  private

  # @return [Boolean]
  def accept_left_parenthesis?(range); end

  # @return [Boolean]
  def accept_left_square_bracket?(range); end

  # @return [Boolean]
  def accept_namespace_operator?(range); end

  # @return [Boolean]
  def accepted_opening_delimiter?(range, char); end

  def check(node, locations, begin_keyword = T.unsafe(nil)); end
  def check_begin(node, range, begin_keyword); end
  def check_end(node, range, begin_keyword); end
  def check_keyword(node, range); end

  # @return [Boolean]
  def do?(node); end

  # @return [Boolean]
  def namespace_operator?(range, pos); end

  # @return [Boolean]
  def preceded_by_operator?(node, _range); end

  # @return [Boolean]
  def safe_navigation_call?(range, pos); end

  # @return [Boolean]
  def space_after_missing?(range); end

  # @return [Boolean]
  def space_before_missing?(range); end
end

RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_LEFT_PAREN = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_LEFT_SQUARE_BRACKET = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Layout::SpaceAroundKeyword::ACCEPT_NAMESPACE_OPERATOR = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundKeyword::DO = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundKeyword::MSG_AFTER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundKeyword::MSG_BEFORE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundKeyword::NAMESPACE_OPERATOR = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundKeyword::SAFE_NAVIGATION = T.let(T.unsafe(nil), String)

# Checks method call operators to not have spaces around them.
#
# @example
#   # bad
#   foo. bar
#   foo .bar
#   foo . bar
#   foo. bar .buzz
#   foo
#   . bar
#   . buzz
#   foo&. bar
#   foo &.bar
#   foo &. bar
#   foo &. bar&. buzz
#   RuboCop:: Cop
#   RuboCop:: Cop:: Cop
#   :: RuboCop::Cop
#
#   # good
#   foo.bar
#   foo.bar.buzz
#   foo
#   .bar
#   .buzz
#   foo&.bar
#   foo&.bar&.buzz
#   RuboCop::Cop
#   RuboCop::Cop::Cop
#   ::RuboCop::Cop
class RuboCop::Cop::Layout::SpaceAroundMethodCallOperator < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_const(node); end
  def on_csend(node); end
  def on_send(node); end

  private

  def check_space(begin_pos, end_pos); end
  def check_space_after_dot(node); end
  def check_space_after_double_colon(node); end
  def check_space_before_dot(node); end
end

RuboCop::Cop::Layout::SpaceAroundMethodCallOperator::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundMethodCallOperator::SPACES_REGEXP = T.let(T.unsafe(nil), Regexp)

# Checks that operators have space around them, except for ** which
# should or shouldn't have surrounding space depending on configuration.
# It allows vertical alignment consisting of one or more whitespace
# around operators.
#
# This cop has `AllowForAlignment` option. When `true`, allows most
# uses of extra spacing if the intent is to align with an operator on
# the previous or next line, not counting empty lines or comment lines.
#
# @example
#   # bad
#   total = 3*4
#   "apple"+"juice"
#   my_number = 38/4
#
#   # good
#   total = 3 * 4
#   "apple" + "juice"
#   my_number = 38 / 4
# @example AllowForAlignment: true (default)
#   # good
#   {
#   1 =>  2,
#   11 => 3
#   }
# @example AllowForAlignment: false
#   # bad
#   {
#   1 =>  2,
#   11 => 3
#   }
# @example EnforcedStyleForExponentOperator: no_space (default)
#   # bad
#   a ** b
#
#   # good
#   a**b
# @example EnforcedStyleForExponentOperator: space
#   # bad
#   a**b
#
#   # good
#   a ** b
class RuboCop::Cop::Layout::SpaceAroundOperators < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::RationalLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_and(node); end
  def on_and_asgn(node); end
  def on_assignment(node); end
  def on_binary(node); end
  def on_casgn(node); end
  def on_class(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_if(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_match_pattern(node); end
  def on_op_asgn(node); end
  def on_or(node); end
  def on_or_asgn(node); end
  def on_pair(node); end
  def on_resbody(node); end
  def on_sclass(node); end
  def on_send(node); end
  def on_special_asgn(node); end

  private

  def align_hash_cop_config; end
  def autocorrect(corrector, range); end
  def check_operator(type, operator, right_operand); end
  def enclose_operator_with_space(corrector, range); end

  # @return [Boolean]
  def excess_leading_space?(type, operator, with_space); end

  # @return [Boolean]
  def excess_trailing_space?(right_operand, with_space); end

  # @return [Boolean]
  def force_equal_sign_alignment?; end

  # @return [Boolean]
  def hash_table_style?; end

  # @yield [msg]
  def offense(type, operator, with_space, right_operand); end

  def offense_message(type, operator, with_space, right_operand); end

  # @return [Boolean]
  def operator_with_regular_syntax?(send_node); end

  # @return [Boolean]
  def regular_operator?(send_node); end

  # @return [Boolean]
  def should_not_have_surrounding_space?(operator); end

  # @return [Boolean]
  def space_around_exponent_operator?; end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Layout::SpaceAroundOperators::EXCESSIVE_SPACE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceAroundOperators::IRREGULAR_METHODS = T.let(T.unsafe(nil), Array)

# Checks that block braces have or don't have a space before the opening
# brace depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # bad
#   foo.map{ |a|
#   a.bar.to_s
#   }
#
#   # good
#   foo.map { |a|
#   a.bar.to_s
#   }
# @example EnforcedStyle: no_space
#   # bad
#   foo.map { |a|
#   a.bar.to_s
#   }
#
#   # good
#   foo.map{ |a|
#   a.bar.to_s
#   }
# @example EnforcedStyleForEmptyBraces: space (default)
#   # bad
#   7.times{}
#
#   # good
#   7.times {}
# @example EnforcedStyleForEmptyBraces: no_space
#   # bad
#   7.times {}
#
#   # good
#   7.times{}
class RuboCop::Cop::Layout::SpaceBeforeBlockBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end

  private

  def autocorrect(corrector, range); end
  def block_delimiters_style; end
  def check_empty(left_brace, space_plus_brace, used_style); end
  def check_non_empty(left_brace, space_plus_brace, used_style); end

  # @return [Boolean]
  def conflict_with_block_delimiters?(node); end

  # @return [Boolean]
  def empty_braces?(loc); end

  def space_detected(left_brace, space_plus_brace); end
  def space_missing(left_brace); end
  def style_for_empty_braces; end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Layout::SpaceBeforeBlockBraces::DETECTED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceBeforeBlockBraces::MISSING_MSG = T.let(T.unsafe(nil), String)

# Checks for space between the name of a receiver and a left
# brackets.
#
# @example
#
#   # bad
#   collection [index_or_key]
#
#   # good
#   collection[index_or_key]
class RuboCop::Cop::Layout::SpaceBeforeBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def dot_before_brackets?(node, receiver_end_pos, selector_begin_pos); end

  def offense_range(node, begin_pos); end
  def offense_range_for_assignment(node, begin_pos); end

  # @return [Boolean]
  def reference_variable_with_brackets?(node); end

  def register_offense(range); end
end

RuboCop::Cop::Layout::SpaceBeforeBrackets::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceBeforeBrackets::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for comma (,) preceded by space.
#
# @example
#   # bad
#   [1 , 2 , 3]
#   a(1 , 2)
#   each { |a , b| }
#
#   # good
#   [1, 2, 3]
#   a(1, 2)
#   each { |a, b| }
class RuboCop::Cop::Layout::SpaceBeforeComma < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SpaceBeforePunctuation
  extend ::RuboCop::Cop::AutoCorrector

  def kind(token); end
end

# Checks for missing space between a token and a comment on the
# same line.
#
# @example
#   # bad
#   1 + 1# this operation does ...
#
#   # good
#   1 + 1 # this operation does ...
class RuboCop::Cop::Layout::SpaceBeforeComment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
end

RuboCop::Cop::Layout::SpaceBeforeComment::MSG = T.let(T.unsafe(nil), String)

# Checks that exactly one space is used between a method name and the
# first argument for method calls without parentheses.
#
# Alternatively, extra spaces can be added to align the argument with
# something on a preceding or following line, if the AllowForAlignment
# config parameter is true.
#
# @example
#   # bad
#   something  x
#   something   y, z
#   something'hello'
#
#   # good
#   something x
#   something y, z
#   something 'hello'
class RuboCop::Cop::Layout::SpaceBeforeFirstArg < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::PrecedingFollowingAlignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def expect_params_after_method_name?(node); end

  # @return [Boolean]
  def no_space_between_method_name_and_first_argument?(node); end

  # @return [Boolean]
  def regular_method_call_with_arguments?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Layout::SpaceBeforeFirstArg::MSG = T.let(T.unsafe(nil), String)

# Checks for semicolon (;) preceded by space.
#
# @example
#   # bad
#   x = 1 ; y = 2
#
#   # good
#   x = 1; y = 2
class RuboCop::Cop::Layout::SpaceBeforeSemicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SpaceBeforePunctuation
  extend ::RuboCop::Cop::AutoCorrector

  def kind(token); end
end

# Checks for spaces between `->` and opening parameter
# parenthesis (`(`) in lambda literals.
#
# @example EnforcedStyle: require_no_space (default)
#   # bad
#   a = -> (x, y) { x + y }
#
#   # good
#   a = ->(x, y) { x + y }
# @example EnforcedStyle: require_space
#   # bad
#   a = ->(x, y) { x + y }
#
#   # good
#   a = -> (x, y) { x + y }
class RuboCop::Cop::Layout::SpaceInLambdaLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def arrow_lambda_with_args?(node); end

  def lambda_arguments(node); end
  def range_of_offense(node); end
  def space_after_arrow(lambda_node); end

  # @return [Boolean]
  def space_after_arrow?(lambda_node); end
end

RuboCop::Cop::Layout::SpaceInLambdaLiteral::MSG_REQUIRE_NO_SPACE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInLambdaLiteral::MSG_REQUIRE_SPACE = T.let(T.unsafe(nil), String)

# Checks that brackets used for array literals have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that array literals have
#   # no surrounding space.
#
#   # bad
#   array = [ a, b, c, d ]
#
#   # good
#   array = [a, b, c, d]
# @example EnforcedStyle: space
#   # The `space` style enforces that array literals have
#   # surrounding space.
#
#   # bad
#   array = [a, b, c, d]
#
#   # good
#   array = [ a, b, c, d ]
# @example EnforcedStyle: compact
#   # The `compact` style normally requires a space inside
#   # array brackets, with the exception that successive left
#   # or right brackets are collapsed together in nested arrays.
#
#   # bad
#   array = [ a, [ b, c ] ]
#   array = [
#   [ a ],
#   [ b, c ]
#   ]
#
#   # good
#   array = [ a, [ b, c ]]
#   array = [[ a ],
#   [ b, c ]]
# @example EnforcedStyleForEmptyBrackets: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty array brackets do not contain spaces.
#
#   # bad
#   foo = [ ]
#   bar = [     ]
#
#   # good
#   foo = []
#   bar = []
# @example EnforcedStyleForEmptyBrackets: space
#   # The `space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty array brackets contain exactly one space.
#
#   # bad
#   foo = []
#   bar = [    ]
#
#   # good
#   foo = [ ]
#   bar = [ ]
class RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end

  private

  def array_brackets(node); end
  def autocorrect(corrector, node); end
  def compact(corrector, bracket, side); end
  def compact_corrections(corrector, node, left, right); end
  def compact_offense(node, token, side: T.unsafe(nil)); end
  def compact_offenses(node, left, right, start_ok, end_ok); end
  def empty_config; end

  # @return [Boolean]
  def end_has_own_line?(token); end

  def index_for(node, token); end
  def issue_offenses(node, left, right, start_ok, end_ok); end
  def left_array_bracket(node); end
  def line_and_column_for(token); end

  # @return [Boolean]
  def multi_dimensional_array?(node, token, side: T.unsafe(nil)); end

  # @return [Boolean]
  def next_to_bracket?(token, side: T.unsafe(nil)); end

  # @return [Boolean]
  def next_to_comment?(node, token); end

  # @return [Boolean]
  def next_to_newline?(node, token); end

  # @return [Boolean]
  def qualifies_for_compact?(node, token, side: T.unsafe(nil)); end

  def right_array_bracket(node); end
end

RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets::EMPTY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideArrayLiteralBrackets::MSG = T.let(T.unsafe(nil), String)

# Checks for unnecessary additional spaces inside array percent literals
# (i.e. %i/%w).
#
# @example
#
#   # bad
#   %w(foo  bar  baz)
#   # good
#   %i(foo bar baz)
class RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_percent_literal(node); end

  private

  def each_unnecessary_space_match(node, &blk); end
end

RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideArrayPercentLiteral::MULTIPLE_SPACES_BETWEEN_ITEMS_REGEX = T.let(T.unsafe(nil), Regexp)

# Checks that block braces have or don't have surrounding space inside
# them on configuration. For blocks taking parameters, it checks that the
# left brace has or doesn't have trailing space depending on
# configuration.
#
# @example EnforcedStyle: space (default)
#   # The `space` style enforces that block braces have
#   # surrounding space.
#
#   # bad
#   some_array.each {puts e}
#
#   # good
#   some_array.each { puts e }
# @example EnforcedStyle: no_space
#   # The `no_space` style enforces that block braces don't
#   # have surrounding space.
#
#   # bad
#   some_array.each { puts e }
#
#   # good
#   some_array.each {puts e}
# @example EnforcedStyleForEmptyBraces: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBraces style enforces that
#   # block braces don't have a space in between when empty.
#
#   # bad
#   some_array.each {   }
#   some_array.each {  }
#   some_array.each { }
#
#   # good
#   some_array.each {}
# @example EnforcedStyleForEmptyBraces: space
#   # The `space` EnforcedStyleForEmptyBraces style enforces that
#   # block braces have at least a space in between when empty.
#
#   # bad
#   some_array.each {}
#
#   # good
#   some_array.each { }
#   some_array.each {  }
#   some_array.each {   }
# @example SpaceBeforeBlockParameters: true (default)
#   # The SpaceBeforeBlockParameters style set to `true` enforces that
#   # there is a space between `{` and `|`. Overrides `EnforcedStyle`
#   # if there is a conflict.
#
#   # bad
#   [1, 2, 3].each {|n| n * 2 }
#
#   # good
#   [1, 2, 3].each { |n| n * 2 }
# @example SpaceBeforeBlockParameters: false
#   # The SpaceBeforeBlockParameters style set to `false` enforces that
#   # there is no space between `{` and `|`. Overrides `EnforcedStyle`
#   # if there is a conflict.
#
#   # bad
#   [1, 2, 3].each { |n| n * 2 }
#
#   # good
#   [1, 2, 3].each {|n| n * 2 }
class RuboCop::Cop::Layout::SpaceInsideBlockBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end

  private

  def adjacent_braces(left_brace, right_brace); end

  # @return [Boolean]
  def aligned_braces?(left_brace, right_brace); end

  def braces_with_contents_inside(node, inner); end
  def check_inside(node, left_brace, right_brace); end
  def check_left_brace(inner, left_brace, args_delimiter); end
  def check_right_brace(inner, left_brace, right_brace, single_line); end

  # @return [Boolean]
  def multiline_block?(left_brace, right_brace); end

  def no_space(begin_pos, end_pos, msg); end
  def no_space_inside_left_brace(left_brace, args_delimiter); end
  def offense(begin_pos, end_pos, msg, style_param = T.unsafe(nil)); end

  # @return [Boolean]
  def pipe?(args_delimiter); end

  def space(begin_pos, end_pos, msg); end
  def space_inside_left_brace(left_brace, args_delimiter); end
  def space_inside_right_brace(right_brace); end
  def style_for_empty_braces; end
end

# Checks that braces used for hash literals have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: space (default)
#   # The `space` style enforces that hash literals have
#   # surrounding space.
#
#   # bad
#   h = {a: 1, b: 2}
#
#   # good
#   h = { a: 1, b: 2 }
# @example EnforcedStyle: no_space
#   # The `no_space` style enforces that hash literals have
#   # no surrounding space.
#
#   # bad
#   h = { a: 1, b: 2 }
#
#   # good
#   h = {a: 1, b: 2}
# @example EnforcedStyle: compact
#   # The `compact` style normally requires a space inside
#   # hash braces, with the exception that successive left
#   # braces or right braces are collapsed together in nested hashes.
#
#   # bad
#   h = { a: { b: 2 } }
#   foo = { { a: 1 } => { b: { c: 2 } } }
#
#   # good
#   h = { a: { b: 2 }}
#   foo = {{ a: 1 } => { b: { c: 2 }}}
# @example EnforcedStyleForEmptyBraces: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBraces style enforces that
#   # empty hash braces do not contain spaces.
#
#   # bad
#   foo = { }
#   bar = {    }
#
#   # good
#   foo = {}
#   bar = {}
# @example EnforcedStyleForEmptyBraces: space
#   # The `space` EnforcedStyleForEmptyBraces style enforces that
#   # empty hash braces contain space.
#
#   # bad
#   foo = {}
#
#   # good
#   foo = { }
#   foo = {  }
#   foo = {     }
class RuboCop::Cop::Layout::SpaceInsideHashLiteralBraces < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end

  private

  def ambiguous_or_unexpected_style_detected(style, is_match); end
  def autocorrect(corrector, range); end
  def check(token1, token2); end

  # @return [Boolean]
  def expect_space?(token1, token2); end

  def incorrect_style_detected(token1, token2, expect_space, is_empty_braces); end
  def message(brace, is_empty_braces, expect_space); end

  # @return [Boolean]
  def offense?(token1, expect_space); end

  def range_of_space_to_the_left(range); end
  def range_of_space_to_the_right(range); end
  def space_range(token_range); end
end

RuboCop::Cop::Layout::SpaceInsideHashLiteralBraces::MSG = T.let(T.unsafe(nil), String)

# Checks for spaces inside ordinary round parentheses.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that parentheses do not have spaces.
#
#   # bad
#   f( 3)
#   g = (a + 3 )
#   f( )
#
#   # good
#   f(3)
#   g = (a + 3)
#   f()
# @example EnforcedStyle: space
#   # The `space` style enforces that parentheses have a space at the
#   # beginning and end.
#   # Note: Empty parentheses should not have spaces.
#
#   # bad
#   f(3)
#   g = (a + 3)
#   y( )
#
#   # good
#   f( 3 )
#   g = ( a + 3 )
#   y()
# @example EnforcedStyle: compact
#   # The `compact` style enforces that parentheses have a space at the
#   # beginning with the exception that successive parentheses are allowed.
#   # Note: Empty parentheses should not have spaces.
#
#   # bad
#   f(3)
#   g = (a + 3)
#   y( )
#   g( f( x ) )
#   g( f( x( 3 ) ), 5 )
#   g( ( ( 3 + 5 ) * f) ** x, 5 )
#
#   # good
#   f( 3 )
#   g = ( a + 3 )
#   y()
#   g( f( x ))
#   g( f( x( 3 )), 5 )
#   g((( 3 + 5 ) * f ) ** x, 5 )
class RuboCop::Cop::Layout::SpaceInsideParens < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # @return [Boolean]
  def can_be_ignored?(token1, token2); end

  def correct_extaneus_space_between_consecutive_parens(token1, token2); end
  def correct_extraneous_space(tokens); end
  def correct_extraneous_space_in_empty_parens(token1, token2); end
  def correct_missing_space(token1, token2); end

  # @return [Boolean]
  def left_parens?(token1, token2); end

  # @return [Boolean]
  def parens?(token1, token2); end

  def process_with_compact_style(tokens); end
  def process_with_space_style(tokens); end

  # @return [Boolean]
  def right_parens?(token1, token2); end
end

RuboCop::Cop::Layout::SpaceInsideParens::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideParens::MSG_SPACE = T.let(T.unsafe(nil), String)

# Checks for unnecessary additional spaces inside the delimiters of
# %i/%w/%x literals.
#
# @example
#
#   # good
#   %i(foo bar baz)
#
#   # bad
#   %w( foo bar baz )
#
#   # bad
#   %x(  ls -l )
class RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_percent_literal(node); end
  def on_xstr(node); end

  private

  def add_offenses_for_unnecessary_spaces(node); end
  def regex_matches(node, &blk); end
end

RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::BEGIN_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::END_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Layout::SpaceInsidePercentLiteralDelimiters::MSG = T.let(T.unsafe(nil), String)

# Checks for spaces inside range literals.
#
# @example
#   # bad
#   1 .. 3
#
#   # good
#   1..3
#
#   # bad
#   'a' .. 'z'
#
#   # good
#   'a'..'z'
class RuboCop::Cop::Layout::SpaceInsideRangeLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_erange(node); end
  def on_irange(node); end

  private

  def check(node); end
end

RuboCop::Cop::Layout::SpaceInsideRangeLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks that reference brackets have or don't have
# surrounding space depending on configuration.
#
# @example EnforcedStyle: no_space (default)
#   # The `no_space` style enforces that reference brackets have
#   # no surrounding space.
#
#   # bad
#   hash[ :key ]
#   array[ index ]
#
#   # good
#   hash[:key]
#   array[index]
# @example EnforcedStyle: space
#   # The `space` style enforces that reference brackets have
#   # surrounding space.
#
#   # bad
#   hash[:key]
#   array[index]
#
#   # good
#   hash[ :key ]
#   array[ index ]
# @example EnforcedStyleForEmptyBrackets: no_space (default)
#   # The `no_space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty reference brackets do not contain spaces.
#
#   # bad
#   foo[ ]
#   foo[     ]
#
#   # good
#   foo[]
# @example EnforcedStyleForEmptyBrackets: space
#   # The `space` EnforcedStyleForEmptyBrackets style enforces that
#   # empty reference brackets contain exactly one space.
#
#   # bad
#   foo[]
#   foo[    ]
#
#   # good
#   foo[ ]
class RuboCop::Cop::Layout::SpaceInsideReferenceBrackets < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def autocorrect(corrector, node); end
  def closing_bracket(tokens, opening_bracket); end
  def empty_config; end
  def left_ref_bracket(node, tokens); end
  def previous_token(current_token); end
  def reference_brackets(node); end
end

RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::EMPTY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideReferenceBrackets::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for whitespace within string interpolations.
#
# @example EnforcedStyle: no_space (default)
#   # bad
#   var = "This is the #{ space } example"
#
#   # good
#   var = "This is the #{no_space} example"
# @example EnforcedStyle: space
#   # bad
#   var = "This is the #{no_space} example"
#
#   # good
#   var = "This is the #{ space } example"
class RuboCop::Cop::Layout::SpaceInsideStringInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_interpolation(begin_node); end

  private

  def autocorrect(corrector, begin_node); end
  def delimiters(begin_node); end
end

RuboCop::Cop::Layout::SpaceInsideStringInterpolation::NO_SPACE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Layout::SpaceInsideStringInterpolation::SPACE_MSG = T.let(T.unsafe(nil), String)

# Looks for trailing blank lines and a final newline in the
# source code.
#
# @example EnforcedStyle: final_newline (default)
#   # `final_newline` looks for one newline at the end of files.
#
#   # bad
#   class Foo; end
#
#   # EOF
#
#   # bad
#   class Foo; end # EOF
#
#   # good
#   class Foo; end
#   # EOF
# @example EnforcedStyle: final_blank_line
#   # `final_blank_line` looks for one blank line followed by a new line
#   # at the end of files.
#
#   # bad
#   class Foo; end
#   # EOF
#
#   # bad
#   class Foo; end # EOF
#
#   # good
#   class Foo; end
#
#   # EOF
class RuboCop::Cop::Layout::TrailingEmptyLines < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # @return [Boolean]
  def ends_in_end?(processed_source); end

  def message(wanted_blank_lines, blank_lines); end
  def offense_detected(buffer, wanted_blank_lines, blank_lines, whitespace_at_end); end
end

# Looks for trailing whitespace in the source code.
#
# @example
#   # The line in this example contains spaces after the 0.
#   # bad
#   x = 0
#
#   # The line in this example ends directly after the 0.
#   # good
#   x = 0
# @example AllowInHeredoc: false (default)
#   # The line in this example contains spaces after the 0.
#   # bad
#   code = <<~RUBY
#   x = 0
#   RUBY
#
#   # ok
#   code = <<~RUBY
#   x = 0 #{}
#   RUBY
#
#   # good
#   trailing_whitespace = ' '
#   code = <<~RUBY
#   x = 0#{trailing_whitespace}
#   RUBY
# @example AllowInHeredoc: true
#   # The line in this example contains spaces after the 0.
#   # good
#   code = <<~RUBY
#   x = 0
#   RUBY
class RuboCop::Cop::Layout::TrailingWhitespace < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::Heredoc
  extend ::RuboCop::Cop::AutoCorrector

  def on_heredoc(_node); end
  def on_new_investigation; end

  private

  def extract_heredocs(ast); end
  def find_heredoc(line_number); end
  def offense_range(lineno, line); end
  def process_line(line, lineno); end
  def process_line_in_heredoc(corrector, range, heredoc); end

  # @return [Boolean]
  def skip_heredoc?; end

  # @return [Boolean]
  def static?(heredoc); end

  # @return [Boolean]
  def whitespace_is_indentation?(range, level); end

  # @return [Boolean]
  def whitespace_only?(range); end
end

RuboCop::Cop::Layout::TrailingWhitespace::MSG = T.let(T.unsafe(nil), String)
module RuboCop::Cop::Legacy; end

# Legacy support for Corrector#corrections
# See https://docs.rubocop.org/rubocop/v1_upgrade_notes.html
class RuboCop::Cop::Legacy::CorrectionsProxy
  # @return [CorrectionsProxy] a new instance of CorrectionsProxy
  def initialize(corrector); end

  def <<(callable); end
  def concat(corrections); end

  # @return [Boolean]
  def empty?; end

  protected

  # Returns the value of attribute corrector.
  def corrector; end

  private

  def suppress_clobbering; end
end

# This class handles autocorrection for code that needs to be moved
# to new lines.
class RuboCop::Cop::LineBreakCorrector
  extend ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::TrailingBody
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  class << self
    def break_line_before(range:, node:, corrector:, configured_width:, indent_steps: T.unsafe(nil)); end
    def correct_trailing_body(configured_width:, corrector:, node:, processed_source:); end
    def move_comment(eol_comment:, node:, corrector:); end

    # Returns the value of attribute processed_source.
    def processed_source; end

    private

    def remove_semicolon(node, corrector); end
    def semicolon(node); end

    # @return [Boolean]
    def trailing_class_definition?(token, body); end
  end
end

# Help methods for determining if a line is too long.
module RuboCop::Cop::LineLengthHelp
  private

  # @return [Boolean]
  def allow_uri?; end

  # @return [Boolean]
  def allowed_uri_position?(line, uri_range); end

  # @return [Boolean]
  def directive_on_source_line?(line_index); end

  def extend_uri_end_position(line, end_position); end
  def find_excessive_uri_range(line); end

  # @return [Boolean]
  def ignore_cop_directives?; end

  def indentation_difference(line); end
  def line_length(line); end
  def line_length_without_directive(line); end
  def match_uris(string); end
  def tab_indentation_width; end
  def uri_regexp; end

  # @return [Boolean]
  def valid_uri?(uri_ish_string); end
end

module RuboCop::Cop::Lint; end

# Checks for mistyped shorthand assignments.
#
# @example
#   # bad
#   x =- y
#   x =+ y
#   x =* y
#   x =! y
#
#   # good
#   x -= y # or x = -y
#   x += y # or x = +y
#   x *= y # or x = *y
#   x != y # or x = !y
class RuboCop::Cop::Lint::AmbiguousAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_asgn(node); end
  def on_casgn(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end

  private

  def rhs(node); end
end

RuboCop::Cop::Lint::AmbiguousAssignment::MISTAKES = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Lint::AmbiguousAssignment::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::AmbiguousAssignment::SIMPLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# Checks for ambiguous block association with method
# when param passed without parentheses.
#
# This cop can customize allowed methods with `AllowedMethods`.
# By default, there are no methods to allowed.
#
# @example
#
#   # bad
#   some_method a { |val| puts val }
# @example
#
#   # good
#   # With parentheses, there's no ambiguity.
#   some_method(a { |val| puts val })
#   # or (different meaning)
#   some_method(a) { |val| puts val }
#
#   # good
#   # Operator methods require no disambiguation
#   foo == bar { |b| b.baz }
#
#   # good
#   # Lambda arguments require no disambiguation
#   foo = ->(bar) { bar.baz }
# @example AllowedMethods: [] (default)
#
#   # bad
#   expect { do_something }.to change { object.attribute }
# @example AllowedMethods: [change]
#
#   # good
#   expect { do_something }.to change { object.attribute }
# @example AllowedPatterns: [] (default)
#
#   # bad
#   expect { do_something }.to change { object.attribute }
# @example AllowedPatterns: [/change/]
#
#   # good
#   expect { do_something }.to change { object.attribute }
#   expect { do_something }.to not_change { object.attribute }
class RuboCop::Cop::Lint::AmbiguousBlockAssociation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_method_pattern?(node); end

  # @return [Boolean]
  def ambiguous_block_association?(send_node); end

  def message(send_node); end
end

RuboCop::Cop::Lint::AmbiguousBlockAssociation::MSG = T.let(T.unsafe(nil), String)

# Checks for ambiguous operators in the first argument of a
# method invocation without parentheses.
#
# @example
#
#   # bad
#
#   # The `*` is interpreted as a splat operator but it could possibly be
#   # a `*` method invocation (i.e. `do_something.*(some_array)`).
#   do_something *some_array
# @example
#
#   # good
#
#   # With parentheses, there's no ambiguity.
#   do_something(*some_array)
class RuboCop::Cop::Lint::AmbiguousOperator < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def find_offense_node_by(diagnostic); end
  def message(diagnostic); end
  def offense_node(node); end

  # @return [Boolean]
  def offense_position?(node, diagnostic); end

  # @return [Boolean]
  def unary_operator?(node, diagnostic); end
end

RuboCop::Cop::Lint::AmbiguousOperator::AMBIGUITIES = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Lint::AmbiguousOperator::MSG_FORMAT = T.let(T.unsafe(nil), String)

# Looks for expressions containing multiple binary operators
# where precedence is ambiguous due to lack of parentheses. For example,
# in `1 + 2 * 3`, the multiplication will happen before the addition, but
# lexically it appears that the addition will happen first.
#
# The cop does not consider unary operators (ie. `!a` or `-b`) or comparison
# operators (ie. `a =~ b`) because those are not ambiguous.
#
# NOTE: Ranges are handled by `Lint/AmbiguousRange`.
#
# @example
#   # bad
#   a + b * c
#   a || b && c
#   a ** b + c
#
#   # good (different precedence)
#   a + (b * c)
#   a || (b && c)
#   (a ** b) + c
#
#   # good (same precedence)
#   a + b + c
#   a * b / c % d
class RuboCop::Cop::Lint::AmbiguousOperatorPrecedence < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_and(node); end
  def on_new_investigation; end
  def on_send(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def greater_precedence?(node1, node2); end

  # @return [Boolean]
  def operator?(node); end

  def operator_name(node); end
  def precedence(node); end
end

RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::MSG = T.let(T.unsafe(nil), String)

# See https://ruby-doc.org/core-3.0.2/doc/syntax/precedence_rdoc.html
RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::PRECEDENCE = T.let(T.unsafe(nil), Array)

RuboCop::Cop::Lint::AmbiguousOperatorPrecedence::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for ambiguous ranges.
#
# Ranges have quite low precedence, which leads to unexpected behavior when
# using a range with other operators. This cop avoids that by making ranges
# explicit by requiring parenthesis around complex range boundaries (anything
# that is not a literal: numerics, strings, symbols, etc.).
#
# This cop can be configured with `RequireParenthesesForMethodChains` in order to
# specify whether method chains (including `self.foo`) should be wrapped in parens
# by this cop.
#
# NOTE: Regardless of this configuration, if a method receiver is a basic literal
# value, it will be wrapped in order to prevent the ambiguity of `1..2.to_a`.
#
# @example
#   # bad
#   x || 1..2
#   (x || 1..2)
#   1..2.to_a
#
#   # good, unambiguous
#   1..2
#   'a'..'z'
#   :bar..:baz
#   MyClass::MIN..MyClass::MAX
#   @min..@max
#   a..b
#   -a..b
#
#   # good, ambiguity removed
#   x || (1..2)
#   (x || 1)..2
#   (x || 1)..(y || 2)
#   (1..2).to_a
# @example RequireParenthesesForMethodChains: false (default)
#   # good
#   a.foo..b.bar
#   (a.foo)..(b.bar)
# @example RequireParenthesesForMethodChains: true
#   # bad
#   a.foo..b.bar
#
#   # good
#   (a.foo)..(b.bar)
class RuboCop::Cop::Lint::AmbiguousRange < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_erange(node); end
  def on_irange(node); end

  private

  # @return [Boolean]
  def acceptable?(node); end

  # @return [Boolean]
  def acceptable_call?(node); end

  # @yield [range.begin]
  def each_boundary(range); end

  # @return [Boolean]
  def require_parentheses_for_method_chain?; end
end

RuboCop::Cop::Lint::AmbiguousRange::MSG = T.let(T.unsafe(nil), String)

# Checks for ambiguous regexp literals in the first argument of
# a method invocation without parentheses.
#
# @example
#
#   # bad
#
#   # This is interpreted as a method invocation with a regexp literal,
#   # but it could possibly be `/` method invocations.
#   # (i.e. `do_something./(pattern)./(i)`)
#   do_something /pattern/i
# @example
#
#   # good
#
#   # With parentheses, there's no ambiguity.
#   do_something(/pattern/i)
class RuboCop::Cop::Lint::AmbiguousRegexpLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def find_offense_node(node, regexp_receiver); end
  def find_offense_node_by(diagnostic); end

  # @return [Boolean]
  def first_argument_is_regexp?(node); end

  # @return [Boolean]
  def method_chain_to_regexp_receiver?(node, regexp_receiver); end
end

RuboCop::Cop::Lint::AmbiguousRegexpLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks for assignments in the conditions of
# if/while/until.
#
# `AllowSafeAssignment` option for safe assignment.
# By safe assignment we mean putting parentheses around
# an assignment to indicate "I know I'm using an assignment
# as a condition. It's not a mistake."
#
# @example
#   # bad
#   if some_var = true
#   do_something
#   end
#
#   # good
#   if some_var == true
#   do_something
#   end
# @example AllowSafeAssignment: true (default)
#   # good
#   if (some_var = true)
#   do_something
#   end
# @example AllowSafeAssignment: false
#   # bad
#   if (some_var = true)
#   do_something
#   end
class RuboCop::Cop::Lint::AssignmentInCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SafeAssignment

  def on_if(node); end
  def on_until(node); end
  def on_while(node); end

  private

  # @return [Boolean]
  def allowed_construct?(asgn_node); end

  # @return [Boolean]
  def conditional_assignment?(asgn_node); end

  def message(_node); end

  # @return [Boolean]
  def skip_children?(asgn_node); end

  def traverse_node(node, &block); end
end

RuboCop::Cop::Lint::AssignmentInCondition::ASGN_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::AssignmentInCondition::MSG_WITHOUT_SAFE_ASSIGNMENT_ALLOWED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::AssignmentInCondition::MSG_WITH_SAFE_ASSIGNMENT_ALLOWED = T.let(T.unsafe(nil), String)

# `BigDecimal.new()` is deprecated since BigDecimal 1.3.3.
# This cop identifies places where `BigDecimal.new()`
# can be replaced by `BigDecimal()`.
#
# @example
#   # bad
#   BigDecimal.new(123.456, 3)
#
#   # good
#   BigDecimal(123.456, 3)
class RuboCop::Cop::Lint::BigDecimalNew < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def big_decimal_new(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Lint::BigDecimalNew::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::BigDecimalNew::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where binary operator has identical operands.
#
# It covers arithmetic operators: `-`, `/`, `%`;
# comparison operators: `==`, `===`, `=~`, `>`, `>=`, `<`, `<=`;
# bitwise operators: `|`, `^`, `&`;
# boolean operators: `&&`, `||`
# and "spaceship" operator - `<=>`.
#
# Simple arithmetic operations are allowed by this cop: `+`, `*`, `**`, `<<` and `>>`.
# Although these can be rewritten in a different way, it should not be necessary to
# do so. This does not include operations such as `-` or `/` where the result will
# always be the same (`x - x` will always be 0; `x / x` will always be 1), and
# thus are legitimate offenses.
#
# @example
#   # bad
#   x / x
#   x.top >= x.top
#
#   if a.x != 0 && a.x != 0
#   do_something
#   end
#
#   def child?
#   left_child || left_child
#   end
#
#   # good
#   x + x
#   1 << 1
class RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands < ::RuboCop::Cop::Base
  def on_and(node); end
  def on_or(node); end
  def on_send(node); end
end

RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands::ALLOWED_MATH_OPERATORS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::BinaryOperatorWithIdenticalOperands::MSG = T.let(T.unsafe(nil), String)

# Checks for `:true` and `:false` symbols.
# In most cases it would be a typo.
#
# @example
#
#   # bad
#   :true
#
#   # good
#   true
# @example
#
#   # bad
#   :false
#
#   # good
#   false
class RuboCop::Cop::Lint::BooleanSymbol < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def boolean_symbol?(param0 = T.unsafe(nil)); end
  def on_sym(node); end

  private

  def autocorrect(corrector, node); end
end

RuboCop::Cop::Lint::BooleanSymbol::MSG = T.let(T.unsafe(nil), String)

# Checks for circular argument references in optional keyword
# arguments and optional ordinal arguments.
#
# This cop mirrors a warning produced by MRI since 2.2.
#
# @example
#
#   # bad
#
#   def bake(pie: pie)
#   pie.heat_up
#   end
# @example
#
#   # good
#
#   def bake(pie:)
#   pie.refrigerate
#   end
# @example
#
#   # good
#
#   def bake(pie: self.pie)
#   pie.feed_to(user)
#   end
# @example
#
#   # bad
#
#   def cook(dry_ingredients = dry_ingredients)
#   dry_ingredients.reduce(&:+)
#   end
# @example
#
#   # good
#
#   def cook(dry_ingredients = self.dry_ingredients)
#   dry_ingredients.combine
#   end
class RuboCop::Cop::Lint::CircularArgumentReference < ::RuboCop::Cop::Base
  def on_kwoptarg(node); end
  def on_optarg(node); end

  private

  def check_for_circular_argument_references(arg_name, arg_value); end
end

RuboCop::Cop::Lint::CircularArgumentReference::MSG = T.let(T.unsafe(nil), String)

# Do not define constants within a block, since the block's scope does not
# isolate or namespace the constant in any way.
#
# If you are trying to define that constant once, define it outside of
# the block instead, or use a variable or method if defining the constant
# in the outer scope would be problematic.
#
# For meta-programming, use `const_set`.
#
# @example
#   # bad
#   task :lint do
#   FILES_TO_LINT = Dir['lib/*.rb']
#   end
#
#   # bad
#   describe 'making a request' do
#   class TestRequest; end
#   end
#
#   # bad
#   module M
#   extend ActiveSupport::Concern
#   included do
#   LIST = []
#   end
#   end
#
#   # good
#   task :lint do
#   files_to_lint = Dir['lib/*.rb']
#   end
#
#   # good
#   describe 'making a request' do
#   let(:test_request) { Class.new }
#   # see also `stub_const` for RSpec
#   end
#
#   # good
#   module M
#   extend ActiveSupport::Concern
#   included do
#   const_set(:LIST, [])
#   end
#   end
# @example AllowedMethods: ['enums'] (default)
#   # good
#
#   # `enums` for Typed Enums via `T::Enum` in Sorbet.
#   # https://sorbet.org/docs/tenum
#   class TestEnum < T::Enum
#   enums do
#   Foo = new("foo")
#   end
#   end
class RuboCop::Cop::Lint::ConstantDefinitionInBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods

  def constant_assigned_in_block?(param0 = T.unsafe(nil)); end
  def module_defined_in_block?(param0 = T.unsafe(nil)); end
  def on_casgn(node); end
  def on_class(node); end
  def on_module(node); end

  private

  def method_name(node); end
end

RuboCop::Cop::Lint::ConstantDefinitionInBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for overwriting an exception with an exception result by use `rescue =>`.
#
# You intended to write as `rescue StandardError`.
# However, you have written `rescue => StandardError`.
# In that case, the result of `rescue` will overwrite `StandardError`.
#
# @example
#
#   # bad
#   begin
#   something
#   rescue => StandardError
#   end
#
#   # good
#   begin
#   something
#   rescue StandardError
#   end
class RuboCop::Cop::Lint::ConstantOverwrittenInRescue < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_resbody(node); end
  def overwritten_constant(param0 = T.unsafe(nil)); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Lint::ConstantOverwrittenInRescue::MSG = T.let(T.unsafe(nil), String)

# Check that certain constants are fully qualified.
#
# This is not enabled by default because it would mark a lot of offenses
# unnecessarily.
#
# Generally, gems should fully qualify all constants to avoid conflicts with
# the code that uses the gem. Enable this cop without using `Only`/`Ignore`
#
# Large projects will over time end up with one or two constant names that
# are problematic because of a conflict with a library or just internally
# using the same name a namespace and a class. To avoid too many unnecessary
# offenses, Enable this cop with `Only: [The, Constant, Names, Causing, Issues]`
#
# @example
#   # By default checks every constant
#
#   # bad
#   User
#
#   # bad
#   User::Login
#
#   # good
#   ::User
#
#   # good
#   ::User::Login
# @example Only: ['Login']
#   # Restrict this cop to only being concerned about certain constants
#
#   # bad
#   Login
#
#   # good
#   ::Login
#
#   # good
#   User::Login
# @example Ignore: ['Login']
#   # Restrict this cop not being concerned about certain constants
#
#   # bad
#   User
#
#   # good
#   ::User::Login
#
#   # good
#   Login
class RuboCop::Cop::Lint::ConstantResolution < ::RuboCop::Cop::Base
  def on_const(node); end
  def unqualified_const?(param0 = T.unsafe(nil)); end

  private

  def allowed_names; end

  # @return [Boolean]
  def const_name?(name); end

  def ignored_names; end
end

RuboCop::Cop::Lint::ConstantResolution::MSG = T.let(T.unsafe(nil), String)

# Checks for debug calls (such as `debugger` or `binding.pry`) that should
# not be kept for production code.
#
# The cop can be configured using `DebuggerMethods`. By default, a number of gems
# debug entrypoints are configured (`Kernel`, `Byebug`, `Capybara`, `debug.rb`,
# `Pry`, `Rails`, `RubyJard`, and `WebConsole`). Additional methods can be added.
#
# Specific default groups can be disabled if necessary:
#
# [source,yaml]
# ----
# Lint/Debugger:
#   DebuggerMethods:
#     WebConsole: ~
# ----
#
# You can also add your own methods by adding a new category:
#
# [source,yaml]
# ----
# Lint/Debugger:
#   DebuggerMethods:
#     MyDebugger:
#       MyDebugger.debug_this
# ----
#
# @example
#
#   # bad (ok during development)
#
#   # using pry
#   def some_method
#   binding.pry
#   do_something
#   end
# @example
#
#   # bad (ok during development)
#
#   # using byebug
#   def some_method
#   byebug
#   do_something
#   end
# @example
#
#   # good
#
#   def some_method
#   do_something
#   end
# @example DebuggerMethods: [my_debugger]
#
#   # bad (ok during development)
#
#   def some_method
#   my_debugger
#   end
class RuboCop::Cop::Lint::Debugger < ::RuboCop::Cop::Base
  def on_send(node); end

  private

  # @return [Boolean]
  def debugger_method?(send_node); end

  def debugger_methods; end
  def message(node); end
  def receiver_chain(send_node); end
end

RuboCop::Cop::Lint::Debugger::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of the deprecated class method usages.
#
# @example
#
#   # bad
#   File.exists?(some_path)
#   Dir.exists?(some_path)
#   iterator?
#   ENV.freeze # Calling `Env.freeze` raises `TypeError` since Ruby 2.7.
#   ENV.clone
#   ENV.dup # Calling `Env.dup` raises `TypeError` since Ruby 3.1.
#   Socket.gethostbyname(host)
#   Socket.gethostbyaddr(host)
#
#   # good
#   File.exist?(some_path)
#   Dir.exist?(some_path)
#   block_given?
#   ENV # `ENV.freeze` cannot prohibit changes to environment variables.
#   ENV.to_h
#   ENV.to_h # `ENV.dup` cannot dup `ENV`, use `ENV.to_h` to get a copy of `ENV` as a hash.
#   Addrinfo.getaddrinfo(nodename, service)
#   Addrinfo.tcp(host, port).getnameinfo
class RuboCop::Cop::Lint::DeprecatedClassMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def check(node); end
  def replacement(deprecated); end
end

RuboCop::Cop::Lint::DeprecatedClassMethods::CLASS_METHOD_DELIMITER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DeprecatedClassMethods::DEPRECATED_METHODS_OBJECT = T.let(T.unsafe(nil), Hash)

# Inner class to DeprecatedClassMethods.
# This class exists to add abstraction and clean naming
# to the deprecated objects
class RuboCop::Cop::Lint::DeprecatedClassMethods::DeprecatedClassMethod
  include ::RuboCop::AST::Sexp

  # @return [DeprecatedClassMethod] a new instance of DeprecatedClassMethod
  def initialize(method, class_constant: T.unsafe(nil), correctable: T.unsafe(nil)); end

  # Returns the value of attribute class_constant.
  def class_constant; end

  def class_nodes; end

  # @return [Boolean]
  def correctable?; end

  # Returns the value of attribute method.
  def method; end

  def to_s; end

  private

  def delimiter; end
end

RuboCop::Cop::Lint::DeprecatedClassMethods::INSTANCE_METHOD_DELIMITER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DeprecatedClassMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DeprecatedClassMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Inner class to DeprecatedClassMethods.
# This class exists to add abstraction and clean naming
# to the replacements for deprecated objects
class RuboCop::Cop::Lint::DeprecatedClassMethods::Replacement
  # @return [Replacement] a new instance of Replacement
  def initialize(method, class_constant: T.unsafe(nil), instance_method: T.unsafe(nil)); end

  # Returns the value of attribute class_constant.
  def class_constant; end

  # Returns the value of attribute method.
  def method; end

  def to_s; end

  private

  def delimiter; end

  # @return [Boolean]
  def instance_method?; end
end

# Checks for deprecated constants.
#
# It has `DeprecatedConstants` config. If there is an alternative method, you can set
# alternative value as `Alternative`. And you can set the deprecated version as
# `DeprecatedVersion`. These options can be omitted if they are not needed.
#
#   DeprecatedConstants:
#     'DEPRECATED_CONSTANT':
#       Alternative: 'alternative_value'
#       DeprecatedVersion: 'deprecated_version'
#
# By default, `NIL`, `TRUE`, `FALSE` and `Random::DEFAULT` are configured.
#
# @example
#
#   # bad
#   NIL
#   TRUE
#   FALSE
#   Random::DEFAULT # Return value of Ruby 2 is `Random` instance, Ruby 3.0 is `Random` class.
#
#   # good
#   nil
#   true
#   false
#   Random.new # `::DEFAULT` has been deprecated in Ruby 3, `.new` is compatible with Ruby 2.
class RuboCop::Cop::Lint::DeprecatedConstants < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_const(node); end

  private

  def constant_name(node, nested_constant_name); end
  def deprecated_constants; end
  def message(good, bad, deprecated_version); end
end

RuboCop::Cop::Lint::DeprecatedConstants::DO_NOT_USE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DeprecatedConstants::SUGGEST_GOOD_MSG = T.let(T.unsafe(nil), String)

# Algorithmic constants for `OpenSSL::Cipher` and `OpenSSL::Digest`
# deprecated since OpenSSL version 2.2.0. Prefer passing a string
# instead.
#
# @example
#
#   # Example for OpenSSL::Cipher instantiation.
#
#   # bad
#   OpenSSL::Cipher::AES.new(128, :GCM)
#
#   # good
#   OpenSSL::Cipher.new('aes-128-gcm')
# @example
#
#   # Example for OpenSSL::Digest instantiation.
#
#   # bad
#   OpenSSL::Digest::SHA256.new
#
#   # good
#   OpenSSL::Digest.new('SHA256')
# @example
#
#   # Example for ::Digest inherited class methods.
#
#   # bad
#   OpenSSL::Digest::SHA256.digest('foo')
#
#   # good
#   OpenSSL::Digest.digest('SHA256', 'foo')
class RuboCop::Cop::Lint::DeprecatedOpenSSLConstant < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def algorithm_const(param0 = T.unsafe(nil)); end
  def digest_const?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def algorithm_name(node); end
  def autocorrect(corrector, node); end
  def build_cipher_arguments(node, algorithm_name, no_arguments); end
  def correction_range(node); end
  def message(node); end
  def openssl_class(node); end
  def replacement_args(node); end
  def sanitize_arguments(arguments); end
end

RuboCop::Cop::Lint::DeprecatedOpenSSLConstant::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DeprecatedOpenSSLConstant::NO_ARG_ALGORITHM = T.let(T.unsafe(nil), Array)

# Checks constructors for disjunctive assignments (`||=`) that should
# be plain assignments.
#
# So far, this cop is only concerned with disjunctive assignment of
# instance variables.
#
# In ruby, an instance variable is nil until a value is assigned, so the
# disjunction is unnecessary. A plain assignment has the same effect.
#
# @example
#   # bad
#   def initialize
#   @x ||= 1
#   end
#
#   # good
#   def initialize
#   @x = 1
#   end
class RuboCop::Cop::Lint::DisjunctiveAssignmentInConstructor < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end

  private

  # @param node [DefNode] a constructor definition
  def check(node); end

  def check_body(body); end

  # @param lines [Array] the logical lines of the constructor
  def check_body_lines(lines); end

  # Add an offense if the LHS of the given disjunctive assignment is
  # an instance variable.
  #
  # For now, we only care about assignments to instance variables.
  #
  # @param node [Node] a disjunctive assignment
  def check_disjunctive_assignment(node); end
end

RuboCop::Cop::Lint::DisjunctiveAssignmentInConstructor::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated bodies
# within `if/unless`, `case-when`, `case-in` and `rescue` constructs.
#
# With `IgnoreLiteralBranches: true`, branches are not registered
# as offenses if they return a basic literal value (string, symbol,
# integer, float, rational, complex, `true`, `false`, or `nil`), or
# return an array, hash, regexp or range that only contains one of
# the above basic literal values.
#
# With `IgnoreConstantBranches: true`, branches are not registered
# as offenses if they return a constant value.
#
# @example
#   # bad
#   if foo
#   do_foo
#   do_something_else
#   elsif bar
#   do_foo
#   do_something_else
#   end
#
#   # good
#   if foo || bar
#   do_foo
#   do_something_else
#   end
#
#   # bad
#   case x
#   when foo
#   do_foo
#   when bar
#   do_foo
#   else
#   do_something_else
#   end
#
#   # good
#   case x
#   when foo, bar
#   do_foo
#   else
#   do_something_else
#   end
#
#   # bad
#   begin
#   do_something
#   rescue FooError
#   handle_error
#   rescue BarError
#   handle_error
#   end
#
#   # good
#   begin
#   do_something
#   rescue FooError, BarError
#   handle_error
#   end
# @example IgnoreLiteralBranches: true
#   # good
#   case size
#   when "small" then 100
#   when "medium" then 250
#   when "large" then 1000
#   else 250
#   end
# @example IgnoreConstantBranches: true
#   # good
#   case size
#   when "small" then SMALL_SIZE
#   when "medium" then MEDIUM_SIZE
#   when "large" then LARGE_SIZE
#   else MEDIUM_SIZE
#   end
class RuboCop::Cop::Lint::DuplicateBranch < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode

  def on_branching_statement(node); end
  def on_case(node); end
  def on_case_match(node); end
  def on_if(node); end
  def on_rescue(node); end

  private

  def branches(node); end

  # @return [Boolean]
  def consider_branch?(branch); end

  # @return [Boolean]
  def const_branch?(branch); end

  # @return [Boolean]
  def ignore_constant_branches?; end

  # @return [Boolean]
  def ignore_literal_branches?; end

  # @return [Boolean]
  def literal_branch?(branch); end

  def offense_range(duplicate_branch); end
end

RuboCop::Cop::Lint::DuplicateBranch::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated conditions
# used in case 'when' expressions.
#
# @example
#
#   # bad
#
#   case x
#   when 'first'
#   do_something
#   when 'first'
#   do_something_else
#   end
# @example
#
#   # good
#
#   case x
#   when 'first'
#   do_something
#   when 'second'
#   do_something_else
#   end
class RuboCop::Cop::Lint::DuplicateCaseCondition < ::RuboCop::Cop::Base
  def on_case(case_node); end
end

RuboCop::Cop::Lint::DuplicateCaseCondition::MSG = T.let(T.unsafe(nil), String)

# Checks that there are no repeated conditions used in if 'elsif'.
#
# @example
#   # bad
#   if x == 1
#   do_something
#   elsif x == 1
#   do_something_else
#   end
#
#   # good
#   if x == 1
#   do_something
#   elsif x == 2
#   do_something_else
#   end
class RuboCop::Cop::Lint::DuplicateElsifCondition < ::RuboCop::Cop::Base
  def on_if(node); end
end

RuboCop::Cop::Lint::DuplicateElsifCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for duplicated keys in hash literals.
#
# This cop mirrors a warning in Ruby 2.2.
#
# @example
#
#   # bad
#
#   hash = { food: 'apple', food: 'orange' }
# @example
#
#   # good
#
#   hash = { food: 'apple', other_food: 'orange' }
class RuboCop::Cop::Lint::DuplicateHashKey < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Duplication

  def on_hash(node); end
end

RuboCop::Cop::Lint::DuplicateHashKey::MSG = T.let(T.unsafe(nil), String)

# Checks for duplicated instance (or singleton) method
# definitions.
#
# @example
#
#   # bad
#
#   def foo
#   1
#   end
#
#   def foo
#   2
#   end
# @example
#
#   # bad
#
#   def foo
#   1
#   end
#
#   alias foo bar
# @example
#
#   # good
#
#   def foo
#   1
#   end
#
#   def bar
#   2
#   end
# @example
#
#   # good
#
#   def foo
#   1
#   end
#
#   alias bar foo
class RuboCop::Cop::Lint::DuplicateMethods < ::RuboCop::Cop::Base
  # @return [DuplicateMethods] a new instance of DuplicateMethods
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  def alias_method?(param0 = T.unsafe(nil)); end
  def method_alias?(param0 = T.unsafe(nil)); end
  def on_alias(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end
  def sym_name(param0 = T.unsafe(nil)); end

  private

  def check_const_receiver(node, name, const_name); end
  def check_self_receiver(node, name); end
  def found_attr(node, args, readable: T.unsafe(nil), writable: T.unsafe(nil)); end
  def found_instance_method(node, name); end
  def found_method(node, method_name); end
  def lookup_constant(node, const_name); end
  def message_for_dup(node, method_name); end
  def on_attr(node, attr_name, args); end

  # @return [Boolean]
  def possible_dsl?(node); end

  def qualified_name(enclosing, namespace, mod_name); end
  def source_location(node); end
end

RuboCop::Cop::Lint::DuplicateMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DuplicateMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for duplicate elements in Regexp character classes.
#
# @example
#
#   # bad
#   r = /[xyx]/
#
#   # bad
#   r = /[0-9x0-9]/
#
#   # good
#   r = /[xy]/
#
#   # good
#   r = /[0-9x]/
class RuboCop::Cop::Lint::DuplicateRegexpCharacterClassElement < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def each_repeated_character_class_element_loc(node); end
  def on_regexp(node); end

  private

  def interpolation_locs(node); end

  # Since we blank interpolations with a space for every char of the interpolation, we would
  # mark every space (except the first) as duplicate if we do not skip regexp_parser nodes
  # that are within an interpolation.
  #
  # @return [Boolean]
  def within_interpolation?(node, child); end
end

RuboCop::Cop::Lint::DuplicateRegexpCharacterClassElement::MSG_REPEATED_ELEMENT = T.let(T.unsafe(nil), String)

# Checks for duplicate `require`s and `require_relative`s.
#
# @example
#   # bad
#   require 'foo'
#   require 'bar'
#   require 'foo'
#
#   # good
#   require 'foo'
#   require 'bar'
#
#   # good
#   require 'foo'
#   require_relative 'foo'
class RuboCop::Cop::Lint::DuplicateRequire < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
  def on_send(node); end
  def require_call?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::DuplicateRequire::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::DuplicateRequire::REQUIRE_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::DuplicateRequire::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Checks that there are no repeated exceptions
# used in 'rescue' expressions.
#
# @example
#   # bad
#   begin
#   something
#   rescue FirstException
#   handle_exception
#   rescue FirstException
#   handle_other_exception
#   end
#
#   # good
#   begin
#   something
#   rescue FirstException
#   handle_exception
#   rescue SecondException
#   handle_other_exception
#   end
class RuboCop::Cop::Lint::DuplicateRescueException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode

  def on_rescue(node); end
end

RuboCop::Cop::Lint::DuplicateRescueException::MSG = T.let(T.unsafe(nil), String)

# Checks if each_with_object is called with an immutable
# argument. Since the argument is the object that the given block shall
# make calls on to build something based on the enumerable that
# each_with_object iterates over, an immutable argument makes no sense.
# It's definitely a bug.
#
# @example
#
#   # bad
#
#   sum = numbers.each_with_object(0) { |e, a| a += e }
# @example
#
#   # good
#
#   num = 0
#   sum = numbers.each_with_object(num) { |e, a| a += e }
class RuboCop::Cop::Lint::EachWithObjectArgument < ::RuboCop::Cop::Base
  def each_with_object?(param0 = T.unsafe(nil)); end
  def on_csend(node); end
  def on_send(node); end
end

RuboCop::Cop::Lint::EachWithObjectArgument::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::EachWithObjectArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for odd `else` block layout - like
# having an expression on the same line as the `else` keyword,
# which is usually a mistake.
#
# Its autocorrection tweaks layout to keep the syntax. So, this autocorrection
# is compatible correction for bad case syntax, but if your code makes a mistake
# with `elsif` and `else`, you will have to correct it manually.
#
# @example
#
#   # bad
#
#   if something
#   # ...
#   else do_this
#   do_that
#   end
# @example
#
#   # good
#
#   # This code is compatible with the bad case. It will be autocorrected like this.
#   if something
#   # ...
#   else
#   do_this
#   do_that
#   end
#
#   # This code is incompatible with the bad case.
#   # If `do_this` is a condition, `elsif` should be used instead of `else`.
#   if something
#   # ...
#   elsif do_this
#   do_that
#   end
class RuboCop::Cop::Lint::ElseLayout < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def autocorrect(corrector, node, first_else); end
  def check(node); end
  def check_else(node); end
  def indentation_width; end
end

RuboCop::Cop::Lint::ElseLayout::MSG = T.let(T.unsafe(nil), String)

# Checks for blocks without a body.
# Such empty blocks are typically an oversight or we should provide a comment
# be clearer what we're aiming for.
#
# Empty lambdas and procs are ignored by default.
#
# NOTE: For backwards compatibility, the configuration that allows/disallows
# empty lambdas and procs is called `AllowEmptyLambdas`, even though it also
# applies to procs.
#
# @example
#   # bad
#   items.each { |item| }
#
#   # good
#   items.each { |item| puts item }
# @example AllowComments: true (default)
#   # good
#   items.each do |item|
#   # TODO: implement later (inner comment)
#   end
#
#   items.each { |item| } # TODO: implement later (inline comment)
# @example AllowComments: false
#   # bad
#   items.each do |item|
#   # TODO: implement later (inner comment)
#   end
#
#   items.each { |item| } # TODO: implement later (inline comment)
# @example AllowEmptyLambdas: true (default)
#   # good
#   allow(subject).to receive(:callable).and_return(-> {})
#
#   placeholder = lambda do
#   end
#   (callable || placeholder).call
#
#   proc { }
#
#   Proc.new { }
# @example AllowEmptyLambdas: false
#   # bad
#   allow(subject).to receive(:callable).and_return(-> {})
#
#   placeholder = lambda do
#   end
#   (callable || placeholder).call
#
#   proc { }
#
#   Proc.new { }
class RuboCop::Cop::Lint::EmptyBlock < ::RuboCop::Cop::Base
  def on_block(node); end

  private

  # @return [Boolean]
  def allow_comment?(node); end

  # @return [Boolean]
  def allow_empty_lambdas?; end

  # @return [Boolean]
  def comment_disables_cop?(comment); end

  # @return [Boolean]
  def lambda_or_proc?(node); end
end

RuboCop::Cop::Lint::EmptyBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for classes and metaclasses without a body.
# Such empty classes and metaclasses are typically an oversight or we should provide a comment
# to be clearer what we're aiming for.
#
# @example
#   # bad
#   class Foo
#   end
#
#   class Bar
#   class << self
#   end
#   end
#
#   class << obj
#   end
#
#   # good
#   class Foo
#   def do_something
#   # ... code
#   end
#   end
#
#   class Bar
#   class << self
#   attr_reader :bar
#   end
#   end
#
#   class << obj
#   attr_reader :bar
#   end
# @example AllowComments: false (default)
#   # bad
#   class Foo
#   # TODO: implement later
#   end
#
#   class Bar
#   class << self
#   # TODO: implement later
#   end
#   end
#
#   class << obj
#   # TODO: implement later
#   end
# @example AllowComments: true
#   # good
#   class Foo
#   # TODO: implement later
#   end
#
#   class Bar
#   class << self
#   # TODO: implement later
#   end
#   end
#
#   class << obj
#   # TODO: implement later
#   end
class RuboCop::Cop::Lint::EmptyClass < ::RuboCop::Cop::Base
  def on_class(node); end
  def on_sclass(node); end

  private

  # @return [Boolean]
  def body_or_allowed_comment_lines?(node); end
end

RuboCop::Cop::Lint::EmptyClass::CLASS_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::EmptyClass::METACLASS_MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `if`, `elsif` and `unless` branches without a body.
#
# NOTE: empty `else` branches are handled by `Style/EmptyElse`.
#
# @example
#   # bad
#   if condition
#   end
#
#   # bad
#   unless condition
#   end
#
#   # bad
#   if condition
#   do_something
#   elsif other_condition
#   end
#
#   # good
#   if condition
#   do_something
#   end
#
#   # good
#   unless condition
#   do_something
#   end
#
#   # good
#   if condition
#   do_something
#   elsif other_condition
#   do_something_else
#   end
# @example AllowComments: true (default)
#   # good
#   if condition
#   do_something
#   elsif other_condition
#   # noop
#   end
# @example AllowComments: false
#   # bad
#   if condition
#   do_something
#   elsif other_condition
#   # noop
#   end
class RuboCop::Cop::Lint::EmptyConditionalBody < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def autocorrect(corrector, node); end
  def branch_range(node); end
  def correct_other_branches(corrector, node); end
  def deletion_range(range); end
  def remove_comments(corrector, node); end
  def remove_empty_branch(corrector, node); end
end

RuboCop::Cop::Lint::EmptyConditionalBody::MSG = T.let(T.unsafe(nil), String)

# Checks for empty `ensure` blocks
#
# @example
#
#   # bad
#
#   def some_method
#   do_something
#   ensure
#   end
# @example
#
#   # bad
#
#   begin
#   do_something
#   ensure
#   end
# @example
#
#   # good
#
#   def some_method
#   do_something
#   ensure
#   do_something_else
#   end
# @example
#
#   # good
#
#   begin
#   do_something
#   ensure
#   do_something_else
#   end
class RuboCop::Cop::Lint::EmptyEnsure < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_ensure(node); end
end

RuboCop::Cop::Lint::EmptyEnsure::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of empty expressions.
#
# @example
#
#   # bad
#
#   foo = ()
#   if ()
#   bar
#   end
# @example
#
#   # good
#
#   foo = (some_expression)
#   if (some_expression)
#   bar
#   end
class RuboCop::Cop::Lint::EmptyExpression < ::RuboCop::Cop::Base
  def on_begin(node); end

  private

  # @return [Boolean]
  def empty_expression?(begin_node); end
end

RuboCop::Cop::Lint::EmptyExpression::MSG = T.let(T.unsafe(nil), String)

# Enforces that Ruby source files are not empty.
#
# @example
#   # bad
#   # Empty file
#
#   # good
#   # File containing non commented source lines
# @example AllowComments: true (default)
#   # good
#   # File consisting only of comments
# @example AllowComments: false
#   # bad
#   # File consisting only of comments
class RuboCop::Cop::Lint::EmptyFile < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  # @return [Boolean]
  def contains_only_comments?; end

  # @return [Boolean]
  def empty_file?; end

  # @return [Boolean]
  def offending?; end
end

RuboCop::Cop::Lint::EmptyFile::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `in` pattern branches without a body.
#
# @example
#
#   # bad
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   end
#
#   # good
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   nil
#   end
# @example AllowComments: true (default)
#
#   # good
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   # noop
#   end
# @example AllowComments: false
#
#   # bad
#   case condition
#   in [a]
#   do_something
#   in [a, b]
#   # noop
#   end
class RuboCop::Cop::Lint::EmptyInPattern < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_case_match(node); end
end

RuboCop::Cop::Lint::EmptyInPattern::MSG = T.let(T.unsafe(nil), String)

# Checks for empty interpolation.
#
# @example
#
#   # bad
#
#   "result is #{}"
# @example
#
#   # good
#
#   "result is #{some_result}"
class RuboCop::Cop::Lint::EmptyInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  extend ::RuboCop::Cop::AutoCorrector

  def on_interpolation(begin_node); end
end

RuboCop::Cop::Lint::EmptyInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of `when` branches without a body.
#
# @example
#
#   # bad
#   case foo
#   when bar
#   do_something
#   when baz
#   end
# @example
#
#   # good
#   case condition
#   when foo
#   do_something
#   when bar
#   nil
#   end
# @example AllowComments: true (default)
#
#   # good
#   case condition
#   when foo
#   do_something
#   when bar
#   # noop
#   end
# @example AllowComments: false
#
#   # bad
#   case condition
#   when foo
#   do_something
#   when bar
#   # do nothing
#   end
class RuboCop::Cop::Lint::EmptyWhen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp

  def on_case(node); end
end

RuboCop::Cop::Lint::EmptyWhen::MSG = T.let(T.unsafe(nil), String)

# Checks for `return` from an `ensure` block.
# `return` from an ensure block is a dangerous code smell as it
# will take precedence over any exception being raised,
# and the exception will be silently thrown away as if it were rescued.
#
# If you want to rescue some (or all) exceptions, best to do it explicitly
#
# @example
#
#   # bad
#
#   def foo
#   do_something
#   ensure
#   cleanup
#   return self
#   end
# @example
#
#   # good
#
#   def foo
#   do_something
#   self
#   ensure
#   cleanup
#   end
#
#   # also good
#
#   def foo
#   begin
#   do_something
#   rescue SomeException
#   # Let's ignore this exception
#   end
#   self
#   ensure
#   cleanup
#   end
class RuboCop::Cop::Lint::EnsureReturn < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_ensure(node); end
end

RuboCop::Cop::Lint::EnsureReturn::MSG = T.let(T.unsafe(nil), String)

# This cop emulates the following Ruby warnings in Ruby 2.6.
#
# [source,console]
# ----
# % cat example.rb
# ERB.new('hi', nil, '-', '@output_buffer')
# % ruby -rerb example.rb
# example.rb:1: warning: Passing safe_level with the 2nd argument of ERB.new is
# deprecated. Do not use it, and specify other arguments as keyword arguments.
# example.rb:1: warning: Passing trim_mode with the 3rd argument of ERB.new is
# deprecated. Use keyword argument like ERB.new(str, trim_mode:...) instead.
# example.rb:1: warning: Passing eoutvar with the 4th argument of ERB.new is
# deprecated. Use keyword argument like ERB.new(str, eoutvar: ...) instead.
# ----
#
# Now non-keyword arguments other than first one are softly deprecated
# and will be removed when Ruby 2.5 becomes EOL.
# `ERB.new` with non-keyword arguments is deprecated since ERB 2.2.0.
# Use `:trim_mode` and `:eoutvar` keyword arguments to `ERB.new`.
# This cop identifies places where `ERB.new(str, trim_mode, eoutvar)` can
# be replaced by `ERB.new(str, :trim_mode: trim_mode, eoutvar: eoutvar)`.
#
# @example
#   # Target codes supports Ruby 2.6 and higher only
#   # bad
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # good
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#
#   # Target codes supports Ruby 2.5 and lower only
#   # good
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # Target codes supports Ruby 2.6, 2.5 and lower
#   # bad
#   ERB.new(str, nil, '-', '@output_buffer')
#
#   # good
#   # Ruby standard library style
#   # https://github.com/ruby/ruby/commit/3406c5d
#   if ERB.instance_method(:initialize).parameters.assoc(:key) # Ruby 2.6+
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#   else
#   ERB.new(str, nil, '-', '@output_buffer')
#   end
#
#   # good
#   # Use `RUBY_VERSION` style
#   if RUBY_VERSION >= '2.6'
#   ERB.new(str, trim_mode: '-', eoutvar: '@output_buffer')
#   else
#   ERB.new(str, nil, '-', '@output_buffer')
#   end
class RuboCop::Cop::Lint::ErbNewArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def erb_new_with_non_keyword_arguments(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def arguments_range(node); end
  def autocorrect(corrector, node); end
  def build_kwargs(node); end

  # @return [Boolean]
  def correct_arguments?(arguments); end

  def override_by_legacy_args(kwargs, node); end
end

RuboCop::Cop::Lint::ErbNewArguments::MESSAGES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::ErbNewArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for uses of flip-flop operator
# based on the Ruby Style Guide.
#
# Here is the history of flip-flops in Ruby.
# flip-flop operator is deprecated in Ruby 2.6.0 and
# the deprecation has been reverted by Ruby 2.7.0 and
# backported to Ruby 2.6.
# See: https://bugs.ruby-lang.org/issues/5400
#
# @example
#   # bad
#   (1..20).each do |x|
#   puts x if (x == 5) .. (x == 10)
#   end
#
#   # good
#   (1..20).each do |x|
#   puts x if (x >= 5) && (x <= 10)
#   end
class RuboCop::Cop::Lint::FlipFlop < ::RuboCop::Cop::Base
  def on_eflipflop(node); end
  def on_iflipflop(node); end
end

RuboCop::Cop::Lint::FlipFlop::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of precise comparison of floating point numbers.
#
# Floating point values are inherently inaccurate, and comparing them for exact equality
# is almost never the desired semantics. Comparison via the `==/!=` operators checks
# floating-point value representation to be exactly the same, which is very unlikely
# if you perform any arithmetic operations involving precision loss.
#
# @example
#   # bad
#   x == 0.1
#   x != 0.1
#
#   # good - using BigDecimal
#   x.to_d == 0.1.to_d
#
#   # good
#   (x - 0.1).abs < Float::EPSILON
#
#   # good
#   tolerance = 0.0001
#   (x - 0.1).abs < tolerance
#
#   # Or some other epsilon based type of comparison:
#   # https://www.embeddeduse.com/2019/08/26/qt-compare-two-floats/
class RuboCop::Cop::Lint::FloatComparison < ::RuboCop::Cop::Base
  def on_send(node); end

  private

  def check_numeric_returning_method(node); end
  def check_send(node); end

  # @return [Boolean]
  def float?(node); end
end

RuboCop::Cop::Lint::FloatComparison::EQUALITY_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::FloatComparison::FLOAT_INSTANCE_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::FloatComparison::FLOAT_RETURNING_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::FloatComparison::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::FloatComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies Float literals which are, like, really really really
# really really really really really big. Too big. No-one needs Floats
# that big. If you need a float that big, something is wrong with you.
#
# @example
#
#   # bad
#
#   float = 3.0e400
# @example
#
#   # good
#
#   float = 42.9
class RuboCop::Cop::Lint::FloatOutOfRange < ::RuboCop::Cop::Base
  def on_float(node); end
end

RuboCop::Cop::Lint::FloatOutOfRange::MSG = T.let(T.unsafe(nil), String)

# This lint sees if there is a mismatch between the number of
# expected fields for format/sprintf/#% and what is actually
# passed as arguments.
#
# In addition it checks whether different formats are used in the same
# format string. Do not mix numbered, unnumbered, and named formats in
# the same format string.
#
# @example
#
#   # bad
#
#   format('A value: %s and another: %i', a_value)
# @example
#
#   # good
#
#   format('A value: %s and another: %i', a_value, another)
# @example
#
#   # bad
#
#   format('Unnumbered format: %s and numbered: %2$s', a_value, another)
# @example
#
#   # good
#
#   format('Numbered format: %1$s and numbered %2$s', a_value, another)
class RuboCop::Cop::Lint::FormatParameterMismatch < ::RuboCop::Cop::Base
  def called_on_string?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def count_format_matches(node); end
  def count_matches(node); end
  def count_percent_matches(node); end

  # @return [Boolean]
  def countable_format?(node); end

  # @return [Boolean]
  def countable_percent?(node); end

  def expected_fields_count(node); end

  # @return [Boolean]
  def format?(node); end

  # @return [Boolean]
  def format_method?(name, node); end

  # @return [Boolean]
  def format_string?(node); end

  # @return [Boolean]
  def heredoc?(node); end

  # @return [Boolean]
  def invalid_format_string?(node); end

  # @return [Boolean]
  def matched_arguments_count?(expected, passed); end

  def message(node); end

  # @return [Boolean]
  def method_with_format_args?(node); end

  # @return [Boolean]
  def offending_node?(node); end

  # @return [Boolean]
  def percent?(node); end

  # @return [Boolean]
  def splat_args?(node); end

  # @return [Boolean]
  def sprintf?(node); end
end

RuboCop::Cop::Lint::FormatParameterMismatch::KERNEL = T.let(T.unsafe(nil), String)

# http://rubular.com/r/CvpbxkcTzy
RuboCop::Cop::Lint::FormatParameterMismatch::MSG = T.let(T.unsafe(nil), String)

RuboCop::Cop::Lint::FormatParameterMismatch::MSG_INVALID = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::FormatParameterMismatch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::FormatParameterMismatch::SHOVEL = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::FormatParameterMismatch::STRING_TYPES = T.let(T.unsafe(nil), Array)

# Prefer using `Hash#compare_by_identity` rather than using `object_id`
# for hash keys.
#
# This cop looks for hashes being keyed by objects' `object_id`, using
# one of these methods: `key?`, `has_key?`, `fetch`, `[]` and `[]=`.
#
# @example
#   # bad
#   hash = {}
#   hash[foo.object_id] = :bar
#   hash.key?(baz.object_id)
#
#   # good
#   hash = {}.compare_by_identity
#   hash[foo] = :bar
#   hash.key?(baz)
class RuboCop::Cop::Lint::HashCompareByIdentity < ::RuboCop::Cop::Base
  def id_as_hash_key?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Lint::HashCompareByIdentity::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::HashCompareByIdentity::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the ordering of a method call where
# the receiver of the call is a HEREDOC.
#
# @example
#   # bad
#
#   <<-SQL
#   bar
#   SQL
#   .strip_indent
#
#   <<-SQL
#   bar
#   SQL
#   .strip_indent
#   .trim
#
#   # good
#
#   <<~SQL
#   bar
#   SQL
#
#   <<~SQL.trim
#   bar
#   SQL
class RuboCop::Cop::Lint::HeredocMethodCallPosition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def all_on_same_line?(nodes); end

  def autocorrect(corrector, node, heredoc); end
  def call_after_heredoc_range(heredoc); end
  def call_end_pos(node); end
  def call_line_range(node); end

  # Returns nil if no range can be safely repositioned.
  def call_range_to_safely_reposition(node, heredoc); end

  # @return [Boolean]
  def calls_on_multiple_lines?(node, _heredoc); end

  # @return [Boolean]
  def correctly_positioned?(node, heredoc); end

  def heredoc_begin_line_range(heredoc); end
  def heredoc_end_pos(heredoc); end

  # @return [Boolean]
  def heredoc_node?(node); end

  def heredoc_node_descendent_receiver(node); end

  # @return [Boolean]
  def send_node?(node); end

  # @return [Boolean]
  def trailing_comma?(call_source, call_line_source); end
end

RuboCop::Cop::Lint::HeredocMethodCallPosition::MSG = T.let(T.unsafe(nil), String)

# Prefer `equal?` over `==` when comparing `object_id`.
#
# `Object#equal?` is provided to compare objects for identity, and in contrast
# `Object#==` is provided for the purpose of doing value comparison.
#
# @example
#   # bad
#   foo.object_id == bar.object_id
#
#   # good
#   foo.equal?(bar)
class RuboCop::Cop::Lint::IdentityComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def compare_between_object_id_by_double_equal?(node); end

  # @return [Boolean]
  def object_id_method?(node); end
end

RuboCop::Cop::Lint::IdentityComparison::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::IdentityComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for implicit string concatenation of string literals
# which are on the same line.
#
# @example
#
#   # bad
#
#   array = ['Item 1' 'Item 2']
# @example
#
#   # good
#
#   array = ['Item 1Item 2']
#   array = ['Item 1' + 'Item 2']
#   array = [
#   'Item 1' \
#   'Item 2'
#   ]
class RuboCop::Cop::Lint::ImplicitStringConcatenation < ::RuboCop::Cop::Base
  def on_dstr(node); end

  private

  def display_str(node); end
  def each_bad_cons(node); end
  def ending_delimiter(str); end
  def str_content(node); end

  # @return [Boolean]
  def string_literal?(node); end

  # @return [Boolean]
  def string_literals?(node1, node2); end
end

RuboCop::Cop::Lint::ImplicitStringConcatenation::FOR_ARRAY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::ImplicitStringConcatenation::FOR_METHOD = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::ImplicitStringConcatenation::MSG = T.let(T.unsafe(nil), String)

# This cop checks for `IO.select` that is incompatible with Fiber Scheduler since Ruby 3.0.
#
# NOTE: When the method is successful the return value of `IO.select` is `[[IO]]`,
# and the return value of `io.wait_readable` and `io.wait_writable` are `self`.
# They are not autocorrected when assigning a return value because these types are different.
# It's up to user how to handle the return value.
#
# @example
#
#   # bad
#   IO.select([io], [], [], timeout)
#
#   # good
#   io.wait_readable(timeout)
#
#   # bad
#   IO.select([], [io], [], timeout)
#
#   # good
#   io.wait_writable(timeout)
class RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def io_select(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def preferred_method(read, write, timeout); end

  # @return [Boolean]
  def scheduler_compatible?(io1, io2); end
end

RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::IncompatibleIoSelectWithFiberScheduler::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `private` or `protected` access modifiers which are
# applied to a singleton method. These access modifiers do not make
# singleton methods private/protected. `private_class_method` can be
# used for that.
#
# @example
#
#   # bad
#
#   class C
#   private
#
#   def self.method
#   puts 'hi'
#   end
#   end
# @example
#
#   # good
#
#   class C
#   def self.method
#   puts 'hi'
#   end
#
#   private_class_method :method
#   end
# @example
#
#   # good
#
#   class C
#   class << self
#   private
#
#   def method
#   puts 'hi'
#   end
#   end
#   end
class RuboCop::Cop::Lint::IneffectiveAccessModifier < ::RuboCop::Cop::Base
  def on_class(node); end
  def on_module(node); end
  def private_class_methods(param0); end

  private

  # @return [Boolean]
  def access_modifier?(node); end

  def check_node(node); end

  # @return [Boolean]
  def correct_visibility?(node, modifier, ignored_methods); end

  def format_message(modifier); end
  def ineffective_modifier(node, ignored_methods = T.unsafe(nil), modifier = T.unsafe(nil), &block); end
  def private_class_method_names(node); end
end

RuboCop::Cop::Lint::IneffectiveAccessModifier::ALTERNATIVE_PRIVATE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::IneffectiveAccessModifier::ALTERNATIVE_PROTECTED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::IneffectiveAccessModifier::MSG = T.let(T.unsafe(nil), String)

# Looks for error classes inheriting from `Exception`.
# It is configurable to suggest using either `StandardError` (default) or
# `RuntimeError` instead.
#
# @example EnforcedStyle: standard_error (default)
#   # bad
#
#   class C < Exception; end
#
#   C = Class.new(Exception)
#
#   # good
#
#   class C < StandardError; end
#
#   C = Class.new(StandardError)
# @example EnforcedStyle: runtime_error
#   # bad
#
#   class C < Exception; end
#
#   C = Class.new(Exception)
#
#   # good
#
#   class C < RuntimeError; end
#
#   C = Class.new(RuntimeError)
class RuboCop::Cop::Lint::InheritException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def class_new_call?(param0 = T.unsafe(nil)); end
  def on_class(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def exception_class?(class_node); end

  def message(node); end
  def preferred_base_class; end
end

RuboCop::Cop::Lint::InheritException::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::InheritException::PREFERRED_BASE_CLASS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Lint::InheritException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for interpolation in a single quoted string.
#
# @example
#
#   # bad
#
#   foo = 'something with #{interpolation} inside'
# @example
#
#   # good
#
#   foo = "something with #{interpolation} inside"
class RuboCop::Cop::Lint::InterpolationCheck < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_str(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def heredoc?(node); end
end

RuboCop::Cop::Lint::InterpolationCheck::MSG = T.let(T.unsafe(nil), String)

# Checks uses of lambda without a literal block.
# It emulates the following warning in Ruby 3.0:
#
#   % ruby -vwe 'lambda(&proc {})'
#   ruby 3.0.0p0 (2020-12-25 revision 95aff21468) [x86_64-darwin19]
#   -e:1: warning: lambda without a literal block is deprecated; use the proc without
#   lambda instead
#
# This way, proc object is never converted to lambda.
# Autocorrection replaces with compatible proc argument.
#
# @example
#
#   # bad
#   lambda(&proc { do_something })
#   lambda(&Proc.new { do_something })
#
#   # good
#   proc { do_something }
#   Proc.new { do_something }
#   lambda { do_something } # If you use lambda.
class RuboCop::Cop::Lint::LambdaWithoutLiteralBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def lambda_with_symbol_proc?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Lint::LambdaWithoutLiteralBlock::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::LambdaWithoutLiteralBlock::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for literals used as the conditions or as
# operands in and/or expressions serving as the conditions of
# if/while/until/case-when/case-in.
#
# NOTE: Literals in `case-in` condition where the match variable is used in
# `in` are accepted as a pattern matching.
#
# @example
#
#   # bad
#   if 20
#   do_something
#   end
#
#   # bad
#   if some_var && true
#   do_something
#   end
#
#   # good
#   if some_var && some_condition
#   do_something
#   end
#
#   # good
#   # When using a boolean value for an infinite loop.
#   while true
#   break if condition
#   end
class RuboCop::Cop::Lint::LiteralAsCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def message(node); end
  def on_case(case_node); end
  def on_case_match(case_match_node); end
  def on_if(node); end
  def on_send(node); end
  def on_until(node); end
  def on_until_post(node); end
  def on_while(node); end
  def on_while_post(node); end

  private

  # @return [Boolean]
  def basic_literal?(node); end

  def check_case(case_node); end
  def check_for_literal(node); end
  def check_node(node); end
  def condition(node); end
  def handle_node(node); end

  # @return [Boolean]
  def primitive_array?(node); end

  def when_conditions_range(when_node); end
end

RuboCop::Cop::Lint::LiteralAsCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for interpolated literals.
#
# @example
#
#   # bad
#
#   "result is #{10}"
# @example
#
#   # good
#
#   "result is 10"
class RuboCop::Cop::Lint::LiteralInInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_interpolation(begin_node); end

  private

  def autocorrected_value(node); end
  def autocorrected_value_for_array(node); end
  def autocorrected_value_for_string(node); end
  def autocorrected_value_for_symbol(node); end

  # @return [Boolean]
  def ends_heredoc_line?(node); end

  # @return [Boolean]
  def in_array_percent_literal?(node); end

  # @return [Boolean]
  def offending?(node); end

  # Does node print its own source when converted to a string?
  #
  # @return [Boolean]
  def prints_as_self?(node); end

  # @return [Boolean]
  def space_literal?(node); end

  # @return [Boolean]
  def special_keyword?(node); end
end

RuboCop::Cop::Lint::LiteralInInterpolation::COMPOSITE = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::LiteralInInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of `begin...end while/until something`.
#
# @example
#
#   # bad
#
#   # using while
#   begin
#   do_something
#   end while some_condition
# @example
#
#   # bad
#
#   # using until
#   begin
#   do_something
#   end until some_condition
# @example
#
#   # good
#
#   # while replacement
#   loop do
#   do_something
#   break unless some_condition
#   end
# @example
#
#   # good
#
#   # until replacement
#   loop do
#   do_something
#   break if some_condition
#   end
class RuboCop::Cop::Lint::Loop < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_until_post(node); end
  def on_while_post(node); end

  private

  def build_break_line(node); end
  def keyword_and_condition_range(node); end
  def register_offense(node); end
end

RuboCop::Cop::Lint::Loop::MSG = T.let(T.unsafe(nil), String)

# cop disables on wide ranges of code, that latter contributors to
# a file wouldn't be aware of.
#
# @example
#   # Lint/MissingCopEnableDirective:
#   #   MaximumRangeSize: .inf
#
#   # good
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # rubocop:enable Layout/SpaceAroundOperators
#   # y = 1
#   # EOF
#
#   # bad
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # EOF
# @example
#   # Lint/MissingCopEnableDirective:
#   #   MaximumRangeSize: 2
#
#   # good
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   # With the previous, there are 2 lines on which cop is disabled.
#   # rubocop:enable Layout/SpaceAroundOperators
#
#   # bad
#   # rubocop:disable Layout/SpaceAroundOperators
#   x= 0
#   x += 1
#   # Including this, that's 3 lines on which the cop is disabled.
#   # rubocop:enable Layout/SpaceAroundOperators
class RuboCop::Cop::Lint::MissingCopEnableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  # @return [Boolean]
  def department_enabled?(cop, comment); end

  def each_missing_enable; end
  def max_range; end
  def message(cop, comment, type = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::MissingCopEnableDirective::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::MissingCopEnableDirective::MSG_BOUND = T.let(T.unsafe(nil), String)

# Checks for the presence of constructors and lifecycle callbacks
# without calls to `super`.
#
# This cop does not consider `method_missing` (and `respond_to_missing?`)
# because in some cases it makes sense to overtake what is considered a
# missing method. In other cases, the theoretical ideal handling could be
# challenging or verbose for no actual gain.
#
# @example
#   # bad
#   class Employee < Person
#   def initialize(name, salary)
#   @salary = salary
#   end
#   end
#
#   # good
#   class Employee < Person
#   def initialize(name, salary)
#   super(name)
#   @salary = salary
#   end
#   end
#
#   # bad
#   class Parent
#   def self.inherited(base)
#   do_something
#   end
#   end
#
#   # good
#   class Parent
#   def self.inherited(base)
#   super
#   do_something
#   end
#   end
class RuboCop::Cop::Lint::MissingSuper < ::RuboCop::Cop::Base
  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def callback_method_def?(node); end

  # @return [Boolean]
  def contains_super?(node); end

  # @return [Boolean]
  def inside_class_with_stateful_parent?(node); end

  # @return [Boolean]
  def offender?(node); end

  # @return [Boolean]
  def stateless_class?(node); end
end

RuboCop::Cop::Lint::MissingSuper::CALLBACKS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::MissingSuper::CALLBACK_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::MissingSuper::CLASS_LIFECYCLE_CALLBACKS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::MissingSuper::CONSTRUCTOR_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::MissingSuper::METHOD_LIFECYCLE_CALLBACKS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::MissingSuper::STATELESS_CLASSES = T.let(T.unsafe(nil), Array)

# Do not mix named captures and numbered captures in a Regexp literal
# because numbered capture is ignored if they're mixed.
# Replace numbered captures with non-capturing groupings or
# named captures.
#
#   # bad
#   /(?<foo>FOO)(BAR)/
#
#   # good
#   /(?<foo>FOO)(?<bar>BAR)/
#
#   # good
#   /(?<foo>FOO)(?:BAR)/
#
#   # good
#   /(FOO)(BAR)/
class RuboCop::Cop::Lint::MixedRegexpCaptureTypes < ::RuboCop::Cop::Base
  def on_regexp(node); end
end

RuboCop::Cop::Lint::MixedRegexpCaptureTypes::MSG = T.let(T.unsafe(nil), String)

# In math and Python, we can use `x < y < z` style comparison to compare
# multiple value. However, we can't use the comparison in Ruby. However,
# the comparison is not syntax error. This cop checks the bad usage of
# comparison operators.
#
# @example
#
#   # bad
#   x < y < z
#   10 <= x <= 20
#
#   # good
#   x < y && y < z
#   10 <= x && x <= 20
class RuboCop::Cop::Lint::MultipleComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def multiple_compare?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Lint::MultipleComparison::COMPARISON_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::MultipleComparison::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::MultipleComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::MultipleComparison::SET_OPERATION_OPERATORS = T.let(T.unsafe(nil), Array)

# Checks for nested method definitions.
#
# @example
#
#   # bad
#
#   # `bar` definition actually produces methods in the same scope
#   # as the outer `foo` method. Furthermore, the `bar` method
#   # will be redefined every time `foo` is invoked.
#   def foo
#   def bar
#   end
#   end
# @example
#
#   # good
#
#   def foo
#   bar = -> { puts 'hello' }
#   bar.call
#   end
# @example
#
#   # good
#
#   def foo
#   self.class.class_eval do
#   def bar
#   end
#   end
#   end
#
#   def foo
#   self.class.module_exec do
#   def bar
#   end
#   end
#   end
# @example
#
#   # good
#
#   def foo
#   class << self
#   def bar
#   end
#   end
#   end
class RuboCop::Cop::Lint::NestedMethodDefinition < ::RuboCop::Cop::Base
  def class_or_module_or_struct_new_call?(param0 = T.unsafe(nil)); end
  def eval_call?(param0 = T.unsafe(nil)); end
  def exec_call?(param0 = T.unsafe(nil)); end
  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def scoping_method_call?(child); end
end

RuboCop::Cop::Lint::NestedMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for nested percent literals.
#
# @example
#
#   # bad
#
#   # The percent literal for nested_attributes is parsed as four tokens,
#   # yielding the array [:name, :content, :"%i[incorrectly", :"nested]"].
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: %i[name content %i[incorrectly nested]]
#   }
#
#   # good
#
#   # Neither is incompatible with the bad case, but probably the intended code.
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: [:name, :content, %i[incorrectly nested]]
#   }
#
#   attributes = {
#   valid_attributes: %i[name content],
#   nested_attributes: [:name, :content, [:incorrectly, :nested]]
#   }
class RuboCop::Cop::Lint::NestedPercentLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral

  def on_array(node); end
  def on_percent_literal(node); end

  private

  # @return [Boolean]
  def contains_percent_literals?(node); end
end

RuboCop::Cop::Lint::NestedPercentLiteral::MSG = T.let(T.unsafe(nil), String)

# The array of regular expressions representing percent literals that,
# if found within a percent literal expression, will cause a
# NestedPercentLiteral violation to be emitted.
RuboCop::Cop::Lint::NestedPercentLiteral::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Array)

RuboCop::Cop::Lint::NestedPercentLiteral::REGEXES = T.let(T.unsafe(nil), Array)

# Don't omit the accumulator when calling `next` in a `reduce` block.
#
# @example
#
#   # bad
#
#   result = (1..4).reduce(0) do |acc, i|
#   next if i.odd?
#   acc + i
#   end
# @example
#
#   # good
#
#   result = (1..4).reduce(0) do |acc, i|
#   next acc if i.odd?
#   acc + i
#   end
class RuboCop::Cop::Lint::NextWithoutAccumulator < ::RuboCop::Cop::Base
  def on_block(node); end
  def on_block_body_of_reduce(param0 = T.unsafe(nil)); end
  def on_numblock(node); end
  def on_numblock_body_of_reduce(param0 = T.unsafe(nil)); end

  private

  def parent_block_node(node); end
  def parent_numblock_node(node); end
end

RuboCop::Cop::Lint::NextWithoutAccumulator::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of a `return` inside a `begin..end` block
# in assignment contexts.
# In this situation, the `return` will result in an exit from the current
# method, possibly leading to unexpected behavior.
#
# @example
#
#   # bad
#
#   @some_variable ||= begin
#   return some_value if some_condition_is_met
#
#   do_something
#   end
# @example
#
#   # good
#
#   @some_variable ||= begin
#   if some_condition_is_met
#   some_value
#   else
#   do_something
#   end
#   end
#
#   # good
#
#   some_variable = if some_condition_is_met
#   return if another_condition_is_met
#
#   some_value
#   else
#   do_something
#   end
class RuboCop::Cop::Lint::NoReturnInBeginEndBlocks < ::RuboCop::Cop::Base
  def on_lvasgn(node); end
  def on_op_asgn(node); end
  def on_or_asgn(node); end
end

RuboCop::Cop::Lint::NoReturnInBeginEndBlocks::MSG = T.let(T.unsafe(nil), String)

# Checks for non-atomic file operation.
# And then replace it with a nearly equivalent and atomic method.
#
# These can cause problems that are difficult to reproduce,
# especially in cases of frequent file operations in parallel,
# such as test runs with parallel_rspec.
#
# For examples: creating a directory if there is none, has the following problems
#
# An exception occurs when the directory didn't exist at the time of `exist?`,
# but someone else created it before `mkdir` was executed.
#
# Subsequent processes are executed without the directory that should be there
# when the directory existed at the time of `exist?`,
# but someone else deleted it shortly afterwards.
#
# @example
#   # bad - race condition with another process may result in an error in `mkdir`
#   unless Dir.exist?(path)
#   FileUtils.mkdir(path)
#   end
#
#   # good - atomic and idempotent creation
#   FileUtils.mkdir_p(path)
#
#   # bad - race condition with another process may result in an error in `remove`
#   if File.exist?(path)
#   FileUtils.remove(path)
#   end
#
#   # good - atomic and idempotent removal
#   FileUtils.rm_f(path)
class RuboCop::Cop::Lint::NonAtomicFileOperation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def explicit_not_force?(param0); end
  def force?(param0); end
  def on_send(node); end
  def receiver_and_method_name(param0 = T.unsafe(nil)); end
  def send_exist_node(param0); end

  private

  # @return [Boolean]
  def allowable_use_with_if?(if_node); end

  def autocorrect(corrector, node, range); end
  def autocorrect_replace_method(corrector, node); end

  # @return [Boolean]
  def force_method?(node); end

  # @return [Boolean]
  def force_method_name?(node); end

  # @return [Boolean]
  def force_option?(node); end

  # @return [Boolean]
  def if_node_child?(node); end

  def message_change_force_method(node); end
  def message_remove_file_exist_check(node); end
  def register_offense(node, exist_node); end
  def replacement_method(node); end
end

RuboCop::Cop::Lint::NonAtomicFileOperation::MAKE_FORCE_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::NonAtomicFileOperation::MAKE_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::NonAtomicFileOperation::MSG_CHANGE_FORCE_METHOD = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::NonAtomicFileOperation::MSG_REMOVE_FILE_EXIST_CHECK = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::NonAtomicFileOperation::REMOVE_FORCE_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::NonAtomicFileOperation::REMOVE_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::NonAtomicFileOperation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# `Dir[...]` and `Dir.glob(...)` do not make any guarantees about
# the order in which files are returned. The final order is
# determined by the operating system and file system.
# This means that using them in cases where the order matters,
# such as requiring files, can lead to intermittent failures
# that are hard to debug. To ensure this doesn't happen,
# always sort the list.
#
# `Dir.glob` and `Dir[]` sort globbed results by default in Ruby 3.0.
# So all bad cases are acceptable when Ruby 3.0 or higher are used.
#
# NOTE: This cop will be deprecated and removed when supporting only Ruby 3.0 and higher.
#
# @example
#
#   # bad
#   Dir["./lib/**/*.rb"].each do |file|
#   require file
#   end
#
#   # good
#   Dir["./lib/**/*.rb"].sort.each do |file|
#   require file
#   end
#
#   # bad
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb')) do |file|
#   require file
#   end
#
#   # good
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb')).sort.each do |file|
#   require file
#   end
#
#   # bad
#   Dir['./lib/**/*.rb'].each(&method(:require))
#
#   # good
#   Dir['./lib/**/*.rb'].sort.each(&method(:require))
#
#   # bad
#   Dir.glob(Rails.root.join('test', '*.rb'), &method(:require))
#
#   # good
#   Dir.glob(Rails.root.join('test', '*.rb')).sort.each(&method(:require))
#
#   # good - Respect intent if `sort` keyword option is specified in Ruby 3.0 or higher.
#   Dir.glob(Rails.root.join(__dir__, 'test', '*.rb'), sort: false).each(&method(:require))
class RuboCop::Cop::Lint::NonDeterministicRequireOrder < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def loop_variable(param0 = T.unsafe(nil)); end
  def method_require?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_block_pass(node); end
  def on_numblock(node); end
  def unsorted_dir_block?(param0 = T.unsafe(nil)); end
  def unsorted_dir_each?(param0 = T.unsafe(nil)); end
  def unsorted_dir_each_pass?(param0 = T.unsafe(nil)); end
  def unsorted_dir_glob_pass?(param0 = T.unsafe(nil)); end
  def var_is_required?(param0, param1); end

  private

  def correct_block(corrector, node); end
  def correct_block_pass(corrector, node); end

  # Returns range of last argument including comma and whitespace.
  #
  # @return [Parser::Source::Range]
  def last_arg_range(node); end

  # @return [Boolean]
  def unsorted_dir_loop?(node); end

  # @return [Boolean]
  def unsorted_dir_pass?(node); end
end

RuboCop::Cop::Lint::NonDeterministicRequireOrder::MSG = T.let(T.unsafe(nil), String)

# Checks for non-local exits from iterators without a return
# value. It registers an offense under these conditions:
#
# * No value is returned,
# * the block is preceded by a method chain,
# * the block has arguments,
# * the method which receives the block is not `define_method`
# or `define_singleton_method`,
# * the return is not contained in an inner scope, e.g. a lambda or a
# method definition.
#
# @example
#
#   class ItemApi
#   rescue_from ValidationError do |e| # non-iteration block with arg
#   return { message: 'validation error' } unless e.errors # allowed
#   error_array = e.errors.map do |error| # block with method chain
#   return if error.suppress? # warned
#   return "#{error.param}: invalid" unless error.message # allowed
#   "#{error.param}: #{error.message}"
#   end
#   { message: 'validation error', errors: error_array }
#   end
#
#   def update_items
#   transaction do # block without arguments
#   return unless update_necessary? # allowed
#   find_each do |item| # block without method chain
#   return if item.stock == 0 # false-negative...
#   item.update!(foobar: true)
#   end
#   end
#   end
#   end
class RuboCop::Cop::Lint::NonLocalExitFromIterator < ::RuboCop::Cop::Base
  def chained_send?(param0 = T.unsafe(nil)); end
  def define_method?(param0 = T.unsafe(nil)); end
  def on_return(return_node); end

  private

  # @return [Boolean]
  def return_value?(return_node); end

  # @return [Boolean]
  def scoped_node?(node); end
end

RuboCop::Cop::Lint::NonLocalExitFromIterator::MSG = T.let(T.unsafe(nil), String)

# Warns the usage of unsafe number conversions. Unsafe
# number conversion can cause unexpected error if auto type conversion
# fails. Cop prefer parsing with number class instead.
#
# Conversion with `Integer`, `Float`, etc. will raise an `ArgumentError`
# if given input that is not numeric (eg. an empty string), whereas
# `to_i`, etc. will try to convert regardless of input (`''.to_i => 0`).
# As such, this cop is disabled by default because it's not necessarily
# always correct to raise if a value is not numeric.
#
# NOTE: Some values cannot be converted properly using one of the `Kernel`
# method (for instance, `Time` and `DateTime` values are allowed by this
# cop by default). Similarly, Rails' duration methods do not work well
# with `Integer()` and can be allowed with `AllowedMethods`. By default,
# there are no methods to allowed.
#
# @example
#
#   # bad
#
#   '10'.to_i
#   '10.2'.to_f
#   '10'.to_c
#   '1/3'.to_r
#   ['1', '2', '3'].map(&:to_i)
#   foo.try(:to_f)
#   bar.send(:to_c)
#
#   # good
#
#   Integer('10', 10)
#   Float('10.2')
#   Complex('10')
#   Rational('1/3')
#   ['1', '2', '3'].map { |i| Integer(i, 10) }
#   foo.try { |i| Float(i) }
#   bar.send { |i| Complex(i) }
# @example AllowedMethods: [] (default)
#
#   # bad
#   10.minutes.to_i
# @example AllowedMethods: [minutes]
#
#   # good
#   10.minutes.to_i
# @example AllowedPatterns: [] (default)
#
#   # bad
#   10.minutes.to_i
# @example AllowedPatterns: [/min*/]
#
#   # good
#   10.minutes.to_i
# @example IgnoredClasses: [Time, DateTime] (default)
#
#   # good
#   Time.now.to_datetime.to_i
class RuboCop::Cop::Lint::NumberConversion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def to_method(param0 = T.unsafe(nil)); end
  def to_method_symbol(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def allow_receiver?(receiver); end

  # @return [Boolean]
  def allowed_method_name?(name); end

  # @return [Boolean]
  def conversion_method?(method_name); end

  def correct_method(node, receiver); end
  def correct_sym_method(to_method); end
  def handle_as_symbol(node); end
  def handle_conversion_method(node); end

  # @return [Boolean]
  def ignored_class?(name); end

  def ignored_classes; end
  def remove_parentheses(corrector, node); end
  def top_receiver(node); end
end

RuboCop::Cop::Lint::NumberConversion::CONVERSION_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::NumberConversion::CONVERSION_METHOD_CLASS_MAPPING = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Lint::NumberConversion::METHODS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::NumberConversion::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of numbered parameter assignment.
# It emulates the following warning in Ruby 2.7:
#
#   % ruby -ve '_1 = :value'
#   ruby 2.7.2p137 (2020-10-01 revision 5445e04352) [x86_64-darwin19]
#   -e:1: warning: `_1' is reserved for numbered parameter; consider another name
#
# Assigning to a numbered parameter (from `_1` to `_9`) causes an error in Ruby 3.0.
#
#   % ruby -ve '_1 = :value'
#   ruby 3.0.0p0 (2020-12-25 revision 95aff21468) [x86_64-darwin19]
#   -e:1: _1 is reserved for numbered parameter
#
# NOTE: The parametered parameters are from `_1` to `_9`. This cop checks `_0`, and over `_10`
# as well to prevent confusion.
#
# @example
#
#   # bad
#   _1 = :value
#
#   # good
#   non_numbered_parameter_name = :value
class RuboCop::Cop::Lint::NumberedParameterAssignment < ::RuboCop::Cop::Base
  def on_lvasgn(node); end
end

RuboCop::Cop::Lint::NumberedParameterAssignment::LVAR_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::NumberedParameterAssignment::NUMBERED_PARAMETER_RANGE = T.let(T.unsafe(nil), Range)
RuboCop::Cop::Lint::NumberedParameterAssignment::NUM_PARAM_MSG = T.let(T.unsafe(nil), String)

# Checks for unintended or-assignment to a constant.
#
# Constants should always be assigned in the same location. And its value
# should always be the same. If constants are assigned in multiple
# locations, the result may vary depending on the order of `require`.
#
# @example
#
#   # bad
#   CONST ||= 1
#
#   # good
#   CONST = 1
class RuboCop::Cop::Lint::OrAssignmentToConstant < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_or_asgn(node); end
end

RuboCop::Cop::Lint::OrAssignmentToConstant::MSG = T.let(T.unsafe(nil), String)

# Checks the proper ordering of magic comments and whether
# a magic comment is not placed before a shebang.
#
# @example
#   # bad
#
#   # frozen_string_literal: true
#   # encoding: ascii
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:UTF-8>]
#
#   # good
#
#   # encoding: ascii
#   # frozen_string_literal: true
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:US-ASCII>]
#
#   # good
#
#   #!/usr/bin/env ruby
#   # encoding: ascii
#   # frozen_string_literal: true
#   p [''.frozen?, ''.encoding] #=> [true, #<Encoding:US-ASCII>]
class RuboCop::Cop::Lint::OrderedMagicComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(corrector, encoding_line, frozen_string_literal_line); end
  def magic_comment_lines; end
  def magic_comments; end
end

RuboCop::Cop::Lint::OrderedMagicComments::MSG = T.let(T.unsafe(nil), String)

# This cops looks for references of Regexp captures that are out of range
# and thus always returns nil.
#
# @example
#
#   /(foo)bar/ =~ 'foobar'
#
#   # bad - always returns nil
#
#   puts $2 # => nil
#
#   # good
#
#   puts $1 # => foo
class RuboCop::Cop::Lint::OutOfRangeRegexpRef < ::RuboCop::Cop::Base
  def after_send(node); end
  def on_match_with_lvasgn(node); end
  def on_new_investigation; end
  def on_nth_ref(node); end
  def on_when(node); end

  private

  def check_regexp(node); end

  # @return [Boolean]
  def nth_ref_receiver?(send_node); end

  # @return [Boolean]
  def regexp_first_argument?(send_node); end

  # @return [Boolean]
  def regexp_receiver?(send_node); end
end

RuboCop::Cop::Lint::OutOfRangeRegexpRef::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_ARGUMENT_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_CAPTURE_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::OutOfRangeRegexpRef::REGEXP_RECEIVER_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Lint::OutOfRangeRegexpRef::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)

# Checks for space between the name of a called method and a left
# parenthesis.
#
# @example
#
#   # bad
#   do_something (foo)
#
#   # good
#   do_something(foo)
#   do_something (2 + 3) * 4
#   do_something (foo * bar).baz
class RuboCop::Cop::Lint::ParenthesesAsGroupedExpression < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def chained_calls?(node); end

  # @return [Boolean]
  def first_argument_starts_with_left_parenthesis?(node); end

  def space_range(expr, space_length); end
  def spaces_before_left_parenthesis(node); end

  # @return [Boolean]
  def ternary_expression?(node); end

  # @return [Boolean]
  def valid_context?(node); end

  # @return [Boolean]
  def valid_first_argument?(first_arg); end
end

RuboCop::Cop::Lint::ParenthesesAsGroupedExpression::MSG = T.let(T.unsafe(nil), String)

# Checks for quotes and commas in %w, e.g. `%w('foo', "bar")`
#
# It is more likely that the additional characters are unintended (for
# example, mistranslating an array of literals to percent string notation)
# rather than meant to be part of the resulting strings.
#
# @example
#
#   # bad
#
#   %w('foo', "bar")
# @example
#
#   # good
#
#   %w(foo bar)
class RuboCop::Cop::Lint::PercentStringArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_percent_literal(node); end

  private

  # @return [Boolean]
  def contains_quotes_or_commas?(node); end
end

RuboCop::Cop::Lint::PercentStringArray::LEADING_QUOTE = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Lint::PercentStringArray::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::PercentStringArray::QUOTES_AND_COMMAS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::PercentStringArray::TRAILING_QUOTE = T.let(T.unsafe(nil), Regexp)

# Checks for colons and commas in %i, e.g. `%i(:foo, :bar)`
#
# It is more likely that the additional characters are unintended (for
# example, mistranslating an array of literals to percent string notation)
# rather than meant to be part of the resulting symbols.
#
# @example
#
#   # bad
#
#   %i(:foo, :bar)
# @example
#
#   # good
#
#   %i(foo bar)
class RuboCop::Cop::Lint::PercentSymbolArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_percent_literal(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def contains_colons_or_commas?(node); end

  # @return [Boolean]
  def non_alphanumeric_literal?(literal); end
end

RuboCop::Cop::Lint::PercentSymbolArray::MSG = T.let(T.unsafe(nil), String)

# Checks for `raise` or `fail` statements which are
# raising `Exception` class.
#
# You can specify a module name that will be an implicit namespace
# using `AllowedImplicitNamespaces` option. The cop cause a false positive
# for namespaced `Exception` when a namespace is omitted. This option can
# prevent the false positive by specifying a namespace to be omitted for
# `Exception`. Alternatively, make `Exception` a fully qualified class
# name with an explicit namespace.
#
# @example
#   # bad
#   raise Exception, 'Error message here'
#
#   # good
#   raise StandardError, 'Error message here'
# @example AllowedImplicitNamespaces: ['Gem']
#   # good
#   module Gem
#   def self.foo
#   raise Exception # This exception means `Gem::Exception`.
#   end
#   end
class RuboCop::Cop::Lint::RaiseException < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def exception?(param0 = T.unsafe(nil)); end
  def exception_new_with_message?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def allow_implicit_namespaces; end
  def check(node); end

  # @return [Boolean]
  def implicit_namespace?(node); end
end

RuboCop::Cop::Lint::RaiseException::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RaiseException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `rand(1)` calls.
# Such calls always return `0`.
#
# @example
#
#   # bad
#
#   rand 1
#   Kernel.rand(-1)
#   rand 1.0
#   rand(-1.0)
# @example
#
#   # good
#
#   0 # just use 0 instead
class RuboCop::Cop::Lint::RandOne < ::RuboCop::Cop::Base
  def on_send(node); end
  def rand_one?(param0 = T.unsafe(nil)); end

  private

  def message(node); end
end

RuboCop::Cop::Lint::RandOne::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RandOne::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# removed without causing any offenses to be reported. It's implemented
# as a cop in that it inherits from the Cop base class and calls
# add_offense. The unusual part of its implementation is that it doesn't
# have any on_* methods or an investigate method. This means that it
# doesn't take part in the investigation phase when the other cops do
# their work. Instead, it waits until it's called in a later stage of the
# execution. The reason it can't be implemented as a normal cop is that
# it depends on the results of all other cops to do its work.
#
# @example
#   # bad
#   # rubocop:disable Layout/LineLength
#   x += 1
#   # rubocop:enable Layout/LineLength
#
#   # good
#   x += 1
class RuboCop::Cop::Lint::RedundantCopDisableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [RedundantCopDisableDirective] a new instance of RedundantCopDisableDirective
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil), offenses = T.unsafe(nil)); end

  # Returns the value of attribute offenses_to_check.
  def offenses_to_check; end

  # Sets the attribute offenses_to_check
  #
  # @param value the value to set the attribute offenses_to_check to.
  def offenses_to_check=(_arg0); end

  def on_new_investigation; end

  private

  def add_department_marker(department); end
  def add_offense_for_entire_comment(comment, cops); end
  def add_offense_for_some_cops(comment, cops); end
  def add_offenses(redundant_cops); end
  def all_cop_names; end

  # @return [Boolean]
  def all_disabled?(comment); end

  def comment_range_with_surrounding_space(directive_comment_range, line_comment_range); end
  def cop_disabled_line_ranges; end
  def cop_range(comment, cop); end

  # @return [Boolean]
  def department_disabled?(cop, comment); end

  # @return [Boolean]
  def department_marker?(department); end

  def describe(cop); end
  def directive_count(comment); end
  def directive_range_in_list(range, ranges); end
  def disabled_ranges; end
  def each_already_disabled(cop, line_ranges); end
  def each_line_range(cop, line_ranges); end
  def each_redundant_disable(&block); end

  # @return [Boolean]
  def ends_its_line?(range); end

  def find_redundant_all(range, next_range); end
  def find_redundant_cop(cop, range); end
  def find_redundant_department(cop, range); end

  # @return [Boolean]
  def followed_ranges?(range, next_range); end

  # @return [Boolean]
  def ignore_offense?(line_range); end

  def matching_range(haystack, needle); end
  def message(cop_names); end

  # @return [Boolean]
  def previous_line_blank?(range); end

  # @return [Boolean]
  def range_with_offense?(range, offenses = T.unsafe(nil)); end

  def remove_department_marker(department); end

  # @return [Boolean]
  def trailing_range?(ranges, range); end
end

RuboCop::Cop::Lint::RedundantCopDisableDirective::COP_NAME = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantCopDisableDirective::DEPARTMENT_MARKER = T.let(T.unsafe(nil), String)

# removed.
#
# that cop checks whether any cop was actually enabled.
#
# @example
#   # bad
#   foo = 1
#   # rubocop:enable Layout/LineLength
#
#   # good
#   foo = 1
# @example
#   # bad
#   # rubocop:disable Style/StringLiterals
#   foo = "1"
#   # rubocop:enable Style/StringLiterals
#   baz
#   # rubocop:enable all
#
#   # good
#   # rubocop:disable Style/StringLiterals
#   foo = "1"
#   # rubocop:enable all
#   baz
class RuboCop::Cop::Lint::RedundantCopEnableDirective < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def all_or_name(name); end
  def comment_start(comment); end
  def cop_name_indention(comment, name); end

  # @return [Boolean]
  def department?(directive, name); end

  def range_of_offense(comment, name); end
  def range_to_remove(begin_pos, end_pos, comment); end
  def range_with_comma(comment, name); end

  # If the list of cops is comma-separated, but without a empty space after the comma,
  # we should **not** remove the prepending empty space, thus begin_pos += 1
  def range_with_comma_after(comment, start, begin_pos, end_pos); end

  def range_with_comma_before(start, begin_pos, end_pos); end
  def register_offense(comment, cop_names); end
end

RuboCop::Cop::Lint::RedundantCopEnableDirective::MSG = T.let(T.unsafe(nil), String)

# Sort globbed results by default in Ruby 3.0.
# This cop checks for redundant `sort` method to `Dir.glob` and `Dir[]`.
#
# @example
#
#   # bad
#   Dir.glob('./lib/**/*.rb').sort.each do |file|
#   end
#
#   Dir['./lib/**/*.rb'].sort.each do |file|
#   end
#
#   # good
#   Dir.glob('./lib/**/*.rb').each do |file|
#   end
#
#   Dir['./lib/**/*.rb'].each do |file|
#   end
class RuboCop::Cop::Lint::RedundantDirGlobSort < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_send(node); end
end

RuboCop::Cop::Lint::RedundantDirGlobSort::GLOB_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::RedundantDirGlobSort::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantDirGlobSort::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for unnecessary `require` statement.
#
# The following features are unnecessary `require` statement because
# they are already loaded.
#
#   ruby -ve 'p $LOADED_FEATURES.reject { |feature| %r|/| =~ feature }'
#   ruby 2.2.8p477 (2017-09-14 revision 59906) [x86_64-darwin13]
#   ["enumerator.so", "rational.so", "complex.so", "thread.rb"]
#
# This cop targets Ruby 2.2 or higher containing these 4 features.
#
# @example
#   # bad
#   require 'unloaded_feature'
#   require 'thread'
#
#   # good
#   require 'unloaded_feature'
class RuboCop::Cop::Lint::RedundantRequireStatement < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_send(node); end
  def unnecessary_require_statement?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::RedundantRequireStatement::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantRequireStatement::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for redundant safe navigation calls.
# `instance_of?`, `kind_of?`, `is_a?`, `eql?`, `respond_to?`, and `equal?` methods
# are checked by default. These are customizable with `AllowedMethods` option.
#
# The `AllowedMethods` option specifies nil-safe methods,
# in other words, it is a method that is allowed to skip safe navigation.
# Note that the `AllowedMethod` option is not an option that specifies methods
# for which to suppress (allow) this cop's check.
#
# In the example below, the safe navigation operator (`&.`) is unnecessary
# because `NilClass` has methods like `respond_to?` and `is_a?`.
#
# @example
#   # bad
#   do_something if attrs&.respond_to?(:[])
#
#   # good
#   do_something if attrs.respond_to?(:[])
#
#   # bad
#   while node&.is_a?(BeginNode)
#   node = node.parent
#   end
#
#   # good
#   while node.is_a?(BeginNode)
#   node = node.parent
#   end
#
#   # good - without `&.` this will always return `true`
#   foo&.respond_to?(:to_a)
# @example AllowedMethods: [nil_safe_method]
#   # bad
#   do_something if attrs&.nil_safe_method(:[])
#
#   # good
#   do_something if attrs.nil_safe_method(:[])
#   do_something if attrs&.not_nil_safe_method(:[])
class RuboCop::Cop::Lint::RedundantSafeNavigation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def respond_to_nil_specific_method?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def check?(node); end

  # @return [Boolean]
  def condition?(parent, node); end
end

RuboCop::Cop::Lint::RedundantSafeNavigation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSafeNavigation::NIL_SPECIFIC_METHODS = T.let(T.unsafe(nil), Set)

# Checks for unneeded usages of splat expansion
#
# @example
#
#   # bad
#   a = *[1, 2, 3]
#   a = *'a'
#   a = *1
#   ['a', 'b', *%w(c d e), 'f', 'g']
#
#   # good
#   c = [1, 2, 3]
#   a = *c
#   a, b = *c
#   a, *b = *c
#   a = *1..10
#   a = ['a']
#   ['a', 'b', 'c', 'd', 'e', 'f', 'g']
#
#   # bad
#   do_something(*['foo', 'bar', 'baz'])
#
#   # good
#   do_something('foo', 'bar', 'baz')
#
#   # bad
#   begin
#   foo
#   rescue *[StandardError, ApplicationError]
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue StandardError, ApplicationError
#   bar
#   end
#
#   # bad
#   case foo
#   when *[1, 2, 3]
#   bar
#   else
#   baz
#   end
#
#   # good
#   case foo
#   when 1, 2, 3
#   bar
#   else
#   baz
#   end
# @example AllowPercentLiteralArrayArgument: true (default)
#
#   # good
#   do_something(*%w[foo bar baz])
# @example AllowPercentLiteralArrayArgument: false
#
#   # bad
#   do_something(*%w[foo bar baz])
class RuboCop::Cop::Lint::RedundantSplatExpansion < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def array_new?(param0 = T.unsafe(nil)); end
  def literal_expansion(param0 = T.unsafe(nil)); end
  def on_splat(node); end

  private

  # @return [Boolean]
  def allow_percent_literal_array_argument?; end

  # @return [Boolean]
  def array_new_inside_array_literal?(array_new_node); end

  # @return [Boolean]
  def array_splat?(node); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def method_argument?(node); end

  # @return [Boolean]
  def part_of_an_array?(node); end

  # @return [Boolean]
  def redundant_brackets?(node); end

  def redundant_splat_expansion(node); end
  def remove_brackets(array); end
  def replacement_range_and_content(node); end

  # @return [Boolean]
  def use_percent_literal_array_argument?(node); end
end

RuboCop::Cop::Lint::RedundantSplatExpansion::ARRAY_PARAM_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSplatExpansion::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::RedundantSplatExpansion::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_CAPITAL_I = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_CAPITAL_W = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_I = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantSplatExpansion::PERCENT_W = T.let(T.unsafe(nil), String)

# Checks for string conversion in string interpolation,
# which is redundant.
#
# @example
#
#   # bad
#
#   "result is #{something.to_s}"
# @example
#
#   # good
#
#   "result is #{something}"
class RuboCop::Cop::Lint::RedundantStringCoercion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  extend ::RuboCop::Cop::AutoCorrector

  def on_interpolation(begin_node); end
  def to_s_without_args?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::RedundantStringCoercion::MSG_DEFAULT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantStringCoercion::MSG_SELF = T.let(T.unsafe(nil), String)

# Checks for redundant `with_index`.
#
# @example
#   # bad
#   ary.each_with_index do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
#   # bad
#   ary.each.with_index do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
class RuboCop::Cop::Lint::RedundantWithIndex < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def redundant_with_index?(param0 = T.unsafe(nil)); end

  private

  def message(node); end
  def with_index_range(send); end
end

RuboCop::Cop::Lint::RedundantWithIndex::MSG_EACH_WITH_INDEX = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantWithIndex::MSG_WITH_INDEX = T.let(T.unsafe(nil), String)

# Checks for redundant `with_object`.
#
# @example
#   # bad
#   ary.each_with_object([]) do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
#
#   # bad
#   ary.each.with_object([]) do |v|
#   v
#   end
#
#   # good
#   ary.each do |v|
#   v
#   end
class RuboCop::Cop::Lint::RedundantWithObject < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def redundant_with_object?(param0 = T.unsafe(nil)); end

  private

  def message(node); end
  def with_object_range(send); end
end

RuboCop::Cop::Lint::RedundantWithObject::MSG_EACH_WITH_OBJECT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RedundantWithObject::MSG_WITH_OBJECT = T.let(T.unsafe(nil), String)

# Checks if `include` or `prepend` is called in `refine` block.
# These methods are deprecated and should be replaced with `Refinement#import_methods`.
#
# It emulates deprecation warnings in Ruby 3.1.
#
# @example
#
#   # bad
#   refine Foo do
#   include Bar
#   end
#
#   # bad
#   refine Foo do
#   prepend Bar
#   end
#
#   # good
#   refine Foo do
#   import_methods Bar
#   end
class RuboCop::Cop::Lint::RefinementImportMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_send(node); end
end

RuboCop::Cop::Lint::RefinementImportMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RefinementImportMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for regexp literals used as `match-current-line`.
# If a regexp literal is in condition, the regexp matches `$_` implicitly.
#
# @example
#   # bad
#   if /foo/
#   do_something
#   end
#
#   # good
#   if /foo/ =~ $_
#   do_something
#   end
class RuboCop::Cop::Lint::RegexpAsCondition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_match_current_line(node); end
end

RuboCop::Cop::Lint::RegexpAsCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for expressions where there is a call to a predicate
# method with at least one argument, where no parentheses are used around
# the parameter list, and a boolean operator, && or ||, is used in the
# last argument.
#
# The idea behind warning for these constructs is that the user might
# be under the impression that the return value from the method call is
# an operand of &&/||.
#
# @example
#
#   # bad
#
#   if day.is? :tuesday && month == :jan
#   # ...
#   end
# @example
#
#   # good
#
#   if day.is?(:tuesday) && month == :jan
#   # ...
#   end
class RuboCop::Cop::Lint::RequireParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_csend(node); end
  def on_send(node); end

  private

  def check_predicate(predicate, node); end
  def check_ternary(ternary, node); end
end

RuboCop::Cop::Lint::RequireParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks that a range literal is enclosed in parentheses when the end of the range is
# at a line break.
#
# NOTE: The following is maybe intended for `(42..)`. But, compatible is `42..do_something`.
# So, this cop does not provide autocorrection because it is left to user.
#
# [source,ruby]
# ----
# case condition
# when 42..
#   do_something
# end
# ----
#
# @example
#
#   # bad - Represents `(1..42)`, not endless range.
#   1..
#   42
#
#   # good - It's incompatible, but your intentions when using endless range may be:
#   (1..)
#   42
#
#   # good
#   1..42
#
#   # good
#   (1..42)
#
#   # good
#   (1..
#   42)
class RuboCop::Cop::Lint::RequireRangeParentheses < ::RuboCop::Cop::Base
  def on_erange(node); end
  def on_irange(node); end
end

RuboCop::Cop::Lint::RequireRangeParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks for uses a file requiring itself with `require_relative`.
#
# @example
#
#   # bad
#
#   # foo.rb
#   require_relative 'foo'
#   require_relative 'bar'
#
#   # good
#
#   # foo.rb
#   require_relative 'bar'
class RuboCop::Cop::Lint::RequireRelativeSelfPath < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def remove_ext(file_path); end

  # @return [Boolean]
  def same_file?(file_path, required_feature); end
end

RuboCop::Cop::Lint::RequireRelativeSelfPath::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::RequireRelativeSelfPath::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `rescue` blocks targeting the Exception class.
#
# @example
#
#   # bad
#
#   begin
#   do_something
#   rescue Exception
#   handle_exception
#   end
# @example
#
#   # good
#
#   begin
#   do_something
#   rescue ArgumentError
#   handle_exception
#   end
class RuboCop::Cop::Lint::RescueException < ::RuboCop::Cop::Base
  def on_resbody(node); end

  # @return [Boolean]
  def targets_exception?(rescue_arg_node); end
end

RuboCop::Cop::Lint::RescueException::MSG = T.let(T.unsafe(nil), String)

# Check for arguments to `rescue` that will result in a `TypeError`
# if an exception is raised.
#
# @example
#   # bad
#   begin
#   bar
#   rescue nil
#   baz
#   end
#
#   # bad
#   def foo
#   bar
#   rescue 1, 'a', "#{b}", 0.0, [], {}
#   baz
#   end
#
#   # good
#   begin
#   bar
#   rescue
#   baz
#   end
#
#   # good
#   def foo
#   bar
#   rescue NameError
#   baz
#   end
class RuboCop::Cop::Lint::RescueType < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, node); end
  def on_resbody(node); end

  private

  def correction(*exceptions); end
  def invalid_exceptions(exceptions); end
  def valid_exceptions(exceptions); end
end

RuboCop::Cop::Lint::RescueType::INVALID_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::RescueType::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of a return with a value in a context
# where the value will be ignored. (initialize and setter methods)
#
# @example
#
#   # bad
#   def initialize
#   foo
#   return :qux if bar?
#   baz
#   end
#
#   def foo=(bar)
#   return 42
#   end
# @example
#
#   # good
#   def initialize
#   foo
#   return if bar?
#   baz
#   end
#
#   def foo=(bar)
#   return
#   end
class RuboCop::Cop::Lint::ReturnInVoidContext < ::RuboCop::Cop::Base
  def on_return(return_node); end

  private

  def non_void_context(return_node); end
end

RuboCop::Cop::Lint::ReturnInVoidContext::MSG = T.let(T.unsafe(nil), String)

# The safe navigation operator returns nil if the receiver is
# nil. If you chain an ordinary method call after a safe
# navigation operator, it raises NoMethodError. We should use a
# safe navigation operator after a safe navigation operator.
# This cop checks for the problem outlined above.
#
# @example
#
#   # bad
#
#   x&.foo.bar
#   x&.foo + bar
#   x&.foo[bar]
# @example
#
#   # good
#
#   x&.foo&.bar
#   x&.foo || bar
class RuboCop::Cop::Lint::SafeNavigationChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::NilMethods
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def bad_method?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @param offense_range [Parser::Source::Range]
  # @param send_node [RuboCop::AST::SendNode]
  # @return [String]
  def add_safe_navigation_operator(offense_range:, send_node:); end

  # @param corrector [RuboCop::Cop::Corrector]
  # @param offense_range [Parser::Source::Range]
  # @param send_node [RuboCop::AST::SendNode]
  def autocorrect(corrector, offense_range:, send_node:); end

  def method_chain(node); end
end

RuboCop::Cop::Lint::SafeNavigationChain::MSG = T.let(T.unsafe(nil), String)

# Check to make sure that if safe navigation is used for a method
# call in an `&&` or `||` condition that safe navigation is used for all
# method calls on that same object.
#
# @example
#   # bad
#   foo&.bar && foo.baz
#
#   # bad
#   foo.bar || foo&.baz
#
#   # bad
#   foo&.bar && (foobar.baz || foo.baz)
#
#   # good
#   foo.bar && foo.baz
#
#   # good
#   foo&.bar || foo&.baz
#
#   # good
#   foo&.bar && (foobar.baz || foo&.baz)
class RuboCop::Cop::Lint::SafeNavigationConsistency < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::NilMethods
  extend ::RuboCop::Cop::AutoCorrector

  def check(node); end
  def on_csend(node); end

  private

  def autocorrect(corrector, node); end
  def location(node, unsafe_method_call); end
  def top_conditional_ancestor(node); end
  def unsafe_method_calls(method_calls, safe_nav_receiver); end
end

RuboCop::Cop::Lint::SafeNavigationConsistency::MSG = T.let(T.unsafe(nil), String)

# Checks to make sure safe navigation isn't used with `empty?` in
# a conditional.
#
# While the safe navigation operator is generally a good idea, when
# checking `foo&.empty?` in a conditional, `foo` being `nil` will actually
# do the opposite of what the author intends.
#
# @example
#   # bad
#   return if foo&.empty?
#   return unless foo&.empty?
#
#   # good
#   return if foo && foo.empty?
#   return unless foo && foo.empty?
class RuboCop::Cop::Lint::SafeNavigationWithEmpty < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
  def safe_navigation_empty_in_conditional?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::SafeNavigationWithEmpty::MSG = T.let(T.unsafe(nil), String)

# Checks if a file which has a shebang line as
# its first line is granted execute permission.
#
# @example
#   # bad
#
#   # A file which has a shebang line as its first line is not
#   # granted execute permission.
#
#   #!/usr/bin/env ruby
#   puts 'hello, world'
#
#   # good
#
#   # A file which has a shebang line as its first line is
#   # granted execute permission.
#
#   #!/usr/bin/env ruby
#   puts 'hello, world'
#
#   # good
#
#   # A file which has not a shebang line as its first line is not
#   # granted execute permission.
#
#   puts 'hello, world'
class RuboCop::Cop::Lint::ScriptPermission < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(comment); end

  # @return [Boolean]
  def executable?(processed_source); end

  def format_message_from(processed_source); end
end

RuboCop::Cop::Lint::ScriptPermission::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::ScriptPermission::SHEBANG = T.let(T.unsafe(nil), String)

# Checks for self-assignments.
#
# @example
#   # bad
#   foo = foo
#   foo, bar = foo, bar
#   Foo = Foo
#
#   # good
#   foo = bar
#   foo, bar = bar, foo
#   Foo = Bar
class RuboCop::Cop::Lint::SelfAssignment < ::RuboCop::Cop::Base
  def on_and_asgn(node); end
  def on_casgn(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_or_asgn(node); end

  private

  # @return [Boolean]
  def multiple_self_assignment?(node); end

  # @return [Boolean]
  def rhs_matches_lhs?(rhs, lhs); end
end

RuboCop::Cop::Lint::SelfAssignment::ASSIGNMENT_TYPE_TO_RHS_TYPE = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Lint::SelfAssignment::MSG = T.let(T.unsafe(nil), String)

# This cop checks for `send`, `public_send`, and `__send__` methods
# when using mix-in.
#
# `include` and `prepend` methods were private methods until Ruby 2.0,
# they were mixed-in via `send` method. This cop uses Ruby 2.1 or
# higher style that can be called by public methods.
# And `extend` method that was originally a public method is also targeted
# for style unification.
#
# @example
#   # bad
#   Foo.send(:include, Bar)
#   Foo.send(:prepend, Bar)
#   Foo.send(:extend, Bar)
#
#   # bad
#   Foo.public_send(:include, Bar)
#   Foo.public_send(:prepend, Bar)
#   Foo.public_send(:extend, Bar)
#
#   # bad
#   Foo.__send__(:include, Bar)
#   Foo.__send__(:prepend, Bar)
#   Foo.__send__(:extend, Bar)
#
#   # good
#   Foo.include Bar
#   Foo.prepend Bar
#   Foo.extend Bar
class RuboCop::Cop::Lint::SendWithMixinArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def send_with_mixin_argument?(param0 = T.unsafe(nil)); end

  private

  def bad_location(node); end
  def message(method, module_name, bad_method); end

  # @return [Boolean]
  def mixin_method?(node); end
end

RuboCop::Cop::Lint::SendWithMixinArgument::MIXIN_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::SendWithMixinArgument::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::SendWithMixinArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::SendWithMixinArgument::SEND_METHODS = T.let(T.unsafe(nil), Array)

# Checks for shadowed arguments.
#
# This cop has `IgnoreImplicitReferences` configuration option.
# It means argument shadowing is used in order to pass parameters
# to zero arity `super` when `IgnoreImplicitReferences` is `true`.
#
# @example
#
#   # bad
#   do_something do |foo|
#   foo = 42
#   puts foo
#   end
#
#   def do_something(foo)
#   foo = 42
#   puts foo
#   end
#
#   # good
#   do_something do |foo|
#   foo = foo + 42
#   puts foo
#   end
#
#   def do_something(foo)
#   foo = foo + 42
#   puts foo
#   end
#
#   def do_something(foo)
#   puts foo
#   end
# @example IgnoreImplicitReferences: false (default)
#
#   # bad
#   def do_something(foo)
#   foo = 42
#   super
#   end
#
#   def do_something(foo)
#   foo = super
#   bar
#   end
# @example IgnoreImplicitReferences: true
#
#   # good
#   def do_something(foo)
#   foo = 42
#   super
#   end
#
#   def do_something(foo)
#   foo = super
#   bar
#   end
class RuboCop::Cop::Lint::ShadowedArgument < ::RuboCop::Cop::Base
  def after_leaving_scope(scope, _variable_table); end
  def uses_var?(param0, param1); end

  private

  # Get argument references without assignments' references
  def argument_references(argument); end

  # Find the first argument assignment, which doesn't reference the
  # argument at the rhs. If the assignment occurs inside a branch or
  # block, it is impossible to tell whether it's executed, so precise
  # shadowing location is not known.
  def assignment_without_argument_usage(argument); end

  def check_argument(argument); end

  # @return [Boolean]
  def ignore_implicit_references?; end

  # Check whether the given node is nested into block or conditional.
  #
  # @return [Boolean]
  def node_within_block_or_conditional?(node, stop_search_node); end

  def reference_pos(node); end
  def shadowing_assignment(argument); end

  class << self
    def joining_forces; end
  end
end

RuboCop::Cop::Lint::ShadowedArgument::MSG = T.let(T.unsafe(nil), String)

# Checks for a rescued exception that get shadowed by a
# less specific exception being rescued before a more specific
# exception is rescued.
#
# An exception is considered shadowed if it is rescued after its
# ancestor is, or if it and its ancestor are both rescued in the
# same `rescue` statement. In both cases, the more specific rescue is
# unnecessary because it is covered by rescuing the less specific
# exception. (ie. `rescue Exception, StandardError` has the same behavior
# whether `StandardError` is included or not, because all `StandardError`s
# are rescued by `rescue Exception`).
#
# @example
#
#   # bad
#
#   begin
#   something
#   rescue Exception
#   handle_exception
#   rescue StandardError
#   handle_standard_error
#   end
#
#   # bad
#   begin
#   something
#   rescue Exception, StandardError
#   handle_error
#   end
#
#   # good
#
#   begin
#   something
#   rescue StandardError
#   handle_standard_error
#   rescue Exception
#   handle_exception
#   end
#
#   # good, however depending on runtime environment.
#   #
#   # This is a special case for system call errors.
#   # System dependent error code depends on runtime environment.
#   # For example, whether `Errno::EAGAIN` and `Errno::EWOULDBLOCK` are
#   # the same error code or different error code depends on environment.
#   # This good case is for `Errno::EAGAIN` and `Errno::EWOULDBLOCK` with
#   # the same error code.
#   begin
#   something
#   rescue Errno::EAGAIN, Errno::EWOULDBLOCK
#   handle_standard_error
#   end
class RuboCop::Cop::Lint::ShadowedException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode
  include ::RuboCop::Cop::RangeHelp

  def on_rescue(node); end

  private

  def compare_exceptions(exception, other_exception); end

  # @return [Boolean]
  def contains_multiple_levels_of_exceptions?(group); end

  def evaluate_exceptions(group); end
  def find_shadowing_rescue(rescues); end
  def offense_range(rescues); end

  # @param rescue_group [RuboCop::AST::Node] is a node of array_type
  def rescued_exceptions(rescue_group); end

  def rescued_groups_for(rescues); end

  # @return [Boolean]
  def sorted?(rescued_groups); end

  # @return [Boolean]
  def system_call_err?(error); end
end

RuboCop::Cop::Lint::ShadowedException::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of local variable names from an outer scope
# in block arguments or block-local variables. This mirrors the warning
# given by `ruby -cw` prior to Ruby 2.6:
# "shadowing outer local variable - foo".
#
# NOTE: Shadowing of variables in block passed to `Ractor.new` is allowed
# because `Ractor` should not access outer variables.
# eg. following style is encouraged:
#
#   worker_id, pipe = env
#   Ractor.new(worker_id, pipe) do |worker_id, pipe|
#   end
#
# @example
#
#   # bad
#
#   def some_method
#   foo = 1
#
#   2.times do |foo| # shadowing outer `foo`
#   do_something(foo)
#   end
#   end
# @example
#
#   # good
#
#   def some_method
#   foo = 1
#
#   2.times do |bar|
#   do_something(bar)
#   end
#   end
class RuboCop::Cop::Lint::ShadowingOuterLocalVariable < ::RuboCop::Cop::Base
  def before_declaring_variable(variable, variable_table); end
  def find_conditional_node_from_ascendant(node); end
  def ractor_block?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  def same_conditions_node_different_branch?(variable, outer_local_variable); end

  class << self
    def joining_forces; end
  end
end

RuboCop::Cop::Lint::ShadowingOuterLocalVariable::MSG = T.let(T.unsafe(nil), String)

# Checks unexpected overrides of the `Struct` built-in methods
# via `Struct.new`.
#
# @example
#   # bad
#   Bad = Struct.new(:members, :clone, :count)
#   b = Bad.new([], true, 1)
#   b.members #=> [] (overriding `Struct#members`)
#   b.clone #=> true (overriding `Object#clone`)
#   b.count #=> 1 (overriding `Enumerable#count`)
#
#   # good
#   Good = Struct.new(:id, :name)
#   g = Good.new(1, "foo")
#   g.members #=> [:id, :name]
#   g.clone #=> #<struct Good id=1, name="foo">
#   g.count #=> 2
class RuboCop::Cop::Lint::StructNewOverride < ::RuboCop::Cop::Base
  def on_send(node); end
  def struct_new(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::StructNewOverride::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::StructNewOverride::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::StructNewOverride::STRUCT_MEMBER_NAME_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::StructNewOverride::STRUCT_METHOD_NAMES = T.let(T.unsafe(nil), Array)

# Checks for `rescue` blocks with no body.
#
# @example
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   end
#
#   # good
#   def some_method
#   do_something
#   rescue
#   handle_exception
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   handle_exception
#   end
# @example AllowComments: true (default)
#
#   # good
#   def some_method
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
# @example AllowComments: false
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
# @example AllowNil: true (default)
#
#   # good
#   def some_method
#   do_something
#   rescue
#   nil
#   end
#
#   # good
#   begin
#   do_something
#   rescue
#   # do nothing
#   end
#
#   # good
#   do_something rescue nil
# @example AllowNil: false
#
#   # bad
#   def some_method
#   do_something
#   rescue
#   nil
#   end
#
#   # bad
#   begin
#   do_something
#   rescue
#   nil
#   end
#
#   # bad
#   do_something rescue nil
class RuboCop::Cop::Lint::SuppressedException < ::RuboCop::Cop::Base
  def on_resbody(node); end

  private

  # @return [Boolean]
  def comment_between_rescue_and_end?(node); end

  # @return [Boolean]
  def nil_body?(node); end
end

RuboCop::Cop::Lint::SuppressedException::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of literal strings converted to
# a symbol where a literal symbol could be used instead.
#
# There are two possible styles for this cop.
# `strict` (default) will register an offense for any incorrect usage.
# `consistent` additionally requires hashes to use the same style for
# every symbol key (ie. if any symbol key needs to be quoted it requires
# all keys to be quoted).
#
# @example
#   # bad
#   'string'.to_sym
#   :symbol.to_sym
#   'underscored_string'.to_sym
#   :'underscored_symbol'
#   'hyphenated-string'.to_sym
#
#   # good
#   :string
#   :symbol
#   :underscored_string
#   :underscored_symbol
#   :'hyphenated-string'
# @example EnforcedStyle: strict (default)
#
#   # bad
#   {
#   'a': 1,
#   "b": 2,
#   'c-d': 3
#   }
#
#   # good (don't quote keys that don't require quoting)
#   {
#   a: 1,
#   b: 2,
#   'c-d': 3
#   }
# @example EnforcedStyle: consistent
#
#   # bad
#   {
#   a: 1,
#   'b-c': 2
#   }
#
#   # good (quote all keys if any need quoting)
#   {
#   'a': 1,
#   'b-c': 2
#   }
#
#   # good (no quoting required)
#   {
#   a: 1,
#   b: 2
#   }
class RuboCop::Cop::Lint::SymbolConversion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::SymbolHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end
  def on_send(node); end
  def on_sym(node); end

  private

  def correct_hash_key(node); end
  def correct_inconsistent_hash_keys(keys); end

  # @return [Boolean]
  def in_alias?(node); end

  # @return [Boolean]
  def in_percent_literal_array?(node); end

  # @return [Boolean]
  def properly_quoted?(source, value); end

  def register_offense(node, correction:, message: T.unsafe(nil)); end

  # @return [Boolean]
  def requires_quotes?(sym_node); end
end

RuboCop::Cop::Lint::SymbolConversion::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::SymbolConversion::MSG_CONSISTENCY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::SymbolConversion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Repacks Parser's diagnostics/errors
# into RuboCop's offenses.
class RuboCop::Cop::Lint::Syntax < ::RuboCop::Cop::Base
  def on_other_file; end

  private

  def add_offense_from_diagnostic(diagnostic, ruby_version); end
  def add_offense_from_error(error); end
  def beautify_message(message); end
end

# Ensures that `to_enum`/`enum_for`, called for the current method,
# has correct arguments.
#
# @example
#   # bad
#   def foo(x, y = 1)
#   return to_enum(__callee__, x) # `y` is missing
#   end
#
#   # good
#   def foo(x, y = 1)
#   return to_enum(__callee__, x, y)
#   # alternatives to `__callee__` are `__method__` and `:foo`
#   end
class RuboCop::Cop::Lint::ToEnumArguments < ::RuboCop::Cop::Base
  def enum_conversion_call?(param0 = T.unsafe(nil)); end
  def method_name?(param0 = T.unsafe(nil), param1); end
  def on_send(node); end
  def passing_keyword_arg?(param0 = T.unsafe(nil), param1); end

  private

  # @return [Boolean]
  def argument_match?(send_arg, def_arg); end

  # @return [Boolean]
  def arguments_match?(arguments, def_node); end
end

RuboCop::Cop::Lint::ToEnumArguments::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::ToEnumArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks to make sure `#to_json` includes an optional argument.
# When overriding `#to_json`, callers may invoke JSON
# generation via `JSON.generate(your_obj)`.  Since `JSON#generate` allows
# for an optional argument, your method should too.
#
# @example
#   class Point
#   attr_reader :x, :y
#
#   # bad, incorrect arity
#   def to_json
#   JSON.generate([x, y])
#   end
#
#   # good, preserving args
#   def to_json(*args)
#   JSON.generate([x, y], *args)
#   end
#
#   # good, discarding args
#   def to_json(*_args)
#   JSON.generate([x, y])
#   end
#   end
class RuboCop::Cop::Lint::ToJSON < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
end

RuboCop::Cop::Lint::ToJSON::MSG = T.let(T.unsafe(nil), String)

# Checks for top level return with arguments. If there is a
# top-level return statement with an argument, then the argument is
# always ignored. This is detected automatically since Ruby 2.7.
#
# @example
#
#   # Detected since Ruby 2.7
#   return 1 # 1 is always ignored.
class RuboCop::Cop::Lint::TopLevelReturnWithArgument < ::RuboCop::Cop::Base
  def on_return(return_node); end

  private

  # @return [Boolean]
  def ancestors_valid?(return_node); end
end

# This cop works by validating the ancestors of the return node. A
# top-level return node's ancestors should not be of block, def, or
# defs type.
RuboCop::Cop::Lint::TopLevelReturnWithArgument::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing commas in attribute declarations, such as
# `#attr_reader`. Leaving a trailing comma will nullify the next method
# definition by overriding it with a getter method.
#
# @example
#
#   # bad
#   class Foo
#   attr_reader :foo,
#
#   def bar
#   puts "Unreachable."
#   end
#   end
#
#   # good
#   class Foo
#   attr_reader :foo
#
#   def bar
#   puts "No problem!"
#   end
#   end
class RuboCop::Cop::Lint::TrailingCommaInAttributeDeclaration < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def trailing_comma_range(node); end
end

RuboCop::Cop::Lint::TrailingCommaInAttributeDeclaration::MSG = T.let(T.unsafe(nil), String)

# Checks for "triple quotes" (strings delimited by any odd number
# of quotes greater than 1).
#
# Ruby allows multiple strings to be implicitly concatenated by just
# being adjacent in a statement (ie. `"foo""bar" == "foobar"`). This sometimes
# gives the impression that there is something special about triple quotes, but
# in fact it is just extra unnecessary quotes and produces the same string. Each
# pair of quotes produces an additional concatenated empty string, so the result
# is still only the "actual" string within the delimiters.
#
# NOTE: Although this cop is called triple quotes, the same behavior is present
# for strings delimited by 5, 7, etc. quotation marks.
#
# @example
#   # bad
#   """
#   A string
#   """
#
#   # bad
#   '''
#   A string
#   '''
#
#   # good
#   "
#   A string
#   "
#
#   # good
#   <<STRING
#   A string
#   STRING
#
#   # good (but not the same spacing as the bad case)
#   'A string'
class RuboCop::Cop::Lint::TripleQuotes < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_dstr(node); end

  private

  def empty_str_nodes(node); end
end

RuboCop::Cop::Lint::TripleQuotes::MSG = T.let(T.unsafe(nil), String)

# Checks for underscore-prefixed variables that are actually
# used.
#
# Since block keyword arguments cannot be arbitrarily named at call
# sites, the `AllowKeywordBlockArguments` will allow use of underscore-
# prefixed block keyword arguments.
#
# @example AllowKeywordBlockArguments: false (default)
#
#   # bad
#
#   [1, 2, 3].each do |_num|
#   do_something(_num)
#   end
#
#   query(:sales) do |_id:, revenue:, cost:|
#   {_id: _id, profit: revenue - cost}
#   end
#
#   # good
#
#   [1, 2, 3].each do |num|
#   do_something(num)
#   end
#
#   [1, 2, 3].each do |_num|
#   do_something # not using `_num`
#   end
# @example AllowKeywordBlockArguments: true
#
#   # good
#
#   query(:sales) do |_id:, revenue:, cost:|
#   {_id: _id, profit: revenue - cost}
#   end
class RuboCop::Cop::Lint::UnderscorePrefixedVariableName < ::RuboCop::Cop::Base
  def after_leaving_scope(scope, _variable_table); end
  def check_variable(variable); end

  private

  # @return [Boolean]
  def allowed_keyword_block_argument?(variable); end

  class << self
    def joining_forces; end
  end
end

RuboCop::Cop::Lint::UnderscorePrefixedVariableName::MSG = T.let(T.unsafe(nil), String)

# Checks for a block that is known to need more positional
# block arguments than are given (by default this is configured for
# `Enumerable` methods needing 2 arguments). Optional arguments are allowed,
# although they don't generally make sense as the default value will
# be used. Blocks that have no receiver, or take splatted arguments
# (ie. `*args`) are always accepted.
#
# Keyword arguments (including `**kwargs`) do not get counted towards
# this, as they are not used by the methods in question.
#
# Method names and their expected arity can be configured like this:
#
# [source,yaml]
# ----
# Methods:
#   inject: 2
#   reduce: 2
# ----
#
# @example
#   # bad
#   values.reduce {}
#   values.min { |a| a }
#   values.sort { |a; b| a + b }
#
#   # good
#   values.reduce { |memo, obj| memo << obj }
#   values.min { |a, b| a <=> b }
#   values.sort { |*x| x[0] <=> x[1] }
class RuboCop::Cop::Lint::UnexpectedBlockArity < ::RuboCop::Cop::Base
  def on_block(node); end
  def on_numblock(node); end

  private

  # @return [Boolean]
  def acceptable?(node); end

  def arg_count(node); end
  def expected_arity(method); end

  # @return [Boolean]
  def included_method?(name); end

  def methods; end
end

RuboCop::Cop::Lint::UnexpectedBlockArity::MSG = T.let(T.unsafe(nil), String)

# Checks for using Fixnum or Bignum constant.
#
# @example
#
#   # bad
#
#   1.is_a?(Fixnum)
#   1.is_a?(Bignum)
# @example
#
#   # good
#
#   1.is_a?(Integer)
class RuboCop::Cop::Lint::UnifiedInteger < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def fixnum_or_bignum_const(param0 = T.unsafe(nil)); end
  def on_const(node); end
end

RuboCop::Cop::Lint::UnifiedInteger::MSG = T.let(T.unsafe(nil), String)

# Looks for `reduce` or `inject` blocks where the value returned (implicitly or
# explicitly) does not include the accumulator. A block is considered valid as
# long as at least one return value includes the accumulator.
#
# If the accumulator is not included in the return value, then the entire
# block will just return a transformation of the last element value, and
# could be rewritten as such without a loop.
#
# Also catches instances where an index of the accumulator is returned, as
# this may change the type of object being retained.
#
# NOTE: For the purpose of reducing false positives, this cop only flags
# returns in `reduce` blocks where the element is the only variable in
# the expression (since we will not be able to tell what other variables
# relate to via static analysis).
#
# @example
#
#   # bad
#   (1..4).reduce(0) do |acc, el|
#   el * 2
#   end
#
#   # bad, may raise a NoMethodError after the first iteration
#   %w(a b c).reduce({}) do |acc, letter|
#   acc[letter] = true
#   end
#
#   # good
#   (1..4).reduce(0) do |acc, el|
#   acc + el * 2
#   end
#
#   # good, element is returned but modified using the accumulator
#   values.reduce do |acc, el|
#   el << acc
#   el
#   end
#
#   # good, returns the accumulator instead of the index
#   %w(a b c).reduce({}) do |acc, letter|
#   acc[letter] = true
#   acc
#   end
#
#   # good, at least one branch returns the accumulator
#   values.reduce(nil) do |result, value|
#   break result if something?
#   value
#   end
#
#   # good, recursive
#   keys.reduce(self) { |result, key| result[key] }
#
#   # ignored as the return value cannot be determined
#   enum.reduce do |acc, el|
#   x = foo(acc, el)
#   bar(x)
#   end
class RuboCop::Cop::Lint::UnmodifiedReduceAccumulator < ::RuboCop::Cop::Base
  def accumulator_index?(param0 = T.unsafe(nil), param1); end
  def element_modified?(param0, param1); end
  def expression_values(param0); end
  def lvar_used?(param0 = T.unsafe(nil), param1); end
  def on_block(node); end
  def on_numblock(node); end
  def reduce_with_block?(param0 = T.unsafe(nil)); end

  private

  # Determine if a return value is acceptable for the purposes of this cop
  # If it is an expression containing the accumulator, it is acceptable
  # Otherwise, it is only unacceptable if it contains the iterated element, since we
  # otherwise do not have enough information to prevent false positives.
  #
  # @return [Boolean]
  def acceptable_return?(return_val, element_name); end

  # Exclude `begin` nodes inside a `dstr` from being collected by `return_values`
  #
  # @return [Boolean]
  def allowed_type?(parent_node); end

  def block_arg_name(node, index); end
  def check_return_values(block_node); end

  # @return [Boolean]
  def potential_offense?(return_values, block_body, element_name, accumulator_name); end

  # Return values in a block are either the value given to next,
  # the last line of a multiline block, or the only line of the block
  def return_values(block_body_node); end

  # Look for an index of the accumulator being returned, except where the index
  # is the element.
  # This is always an offense, in order to try to catch potential exceptions
  # due to type mismatches
  def returned_accumulator_index(return_values, accumulator_name, element_name); end

  # If the accumulator is used in any return value, the node is acceptable since
  # the accumulator has a chance to change each iteration
  #
  # @return [Boolean]
  def returns_accumulator_anywhere?(return_values, accumulator_name); end
end

RuboCop::Cop::Lint::UnmodifiedReduceAccumulator::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::UnmodifiedReduceAccumulator::MSG_INDEX = T.let(T.unsafe(nil), String)

# Checks for unreachable code.
# The check are based on the presence of flow of control
# statement in non-final position in `begin` (implicit) blocks.
#
# @example
#
#   # bad
#
#   def some_method
#   return
#   do_something
#   end
#
#   # bad
#
#   def some_method
#   if cond
#   return
#   else
#   return
#   end
#   do_something
#   end
# @example
#
#   # good
#
#   def some_method
#   do_something
#   end
class RuboCop::Cop::Lint::UnreachableCode < ::RuboCop::Cop::Base
  def flow_command?(param0 = T.unsafe(nil)); end
  def on_begin(node); end
  def on_kwbegin(node); end

  private

  def check_case(node); end
  def check_if(node); end

  # @return [Boolean]
  def flow_expression?(node); end
end

RuboCop::Cop::Lint::UnreachableCode::MSG = T.let(T.unsafe(nil), String)

# Checks for loops that will have at most one iteration.
#
# A loop that can never reach the second iteration is a possible error in the code.
# In rare cases where only one iteration (or at most one iteration) is intended behavior,
# the code should be refactored to use `if` conditionals.
#
# NOTE: Block methods that are used with `Enumerable`s are considered to be loops.
#
# `AllowedPatterns` can be used to match against the block receiver in order to allow
# code that would otherwise be registered as an offense (eg. `times` used not in an
# `Enumerable` context).
#
# @example
#   # bad
#   while node
#   do_something(node)
#   node = node.parent
#   break
#   end
#
#   # good
#   while node
#   do_something(node)
#   node = node.parent
#   end
#
#   # bad
#   def verify_list(head)
#   item = head
#   begin
#   if verify(item)
#   return true
#   else
#   return false
#   end
#   end while(item)
#   end
#
#   # good
#   def verify_list(head)
#   item = head
#   begin
#   if verify(item)
#   item = item.next
#   else
#   return false
#   end
#   end while(item)
#
#   true
#   end
#
#   # bad
#   def find_something(items)
#   items.each do |item|
#   if something?(item)
#   return item
#   else
#   raise NotFoundError
#   end
#   end
#   end
#
#   # good
#   def find_something(items)
#   items.each do |item|
#   if something?(item)
#   return item
#   end
#   end
#   raise NotFoundError
#   end
#
#   # bad
#   2.times { raise ArgumentError }
# @example AllowedPatterns: [/(exactly|at_least|at_most)\(\d+\)\.times/] (default)
#
#   # good
#   exactly(2).times { raise StandardError }
class RuboCop::Cop::Lint::UnreachableLoop < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedPattern

  def break_command?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_for(node); end
  def on_numblock(node); end
  def on_until(node); end
  def on_until_post(node); end
  def on_while(node); end
  def on_while_post(node); end

  private

  # @return [Boolean]
  def break_statement?(node); end

  def check(node); end
  def check_case(node); end
  def check_if(node); end

  # @return [Boolean]
  def conditional_continue_keyword?(break_statement); end

  # @return [Boolean]
  def loop_method?(node); end

  # @return [Boolean]
  def preceded_by_continue_statement?(break_statement); end

  def statements(node); end
end

RuboCop::Cop::Lint::UnreachableLoop::CONTINUE_KEYWORDS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UnreachableLoop::MSG = T.let(T.unsafe(nil), String)

# Common functionality for cops handling unused arguments.
module RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::AST::NodePattern::Macros

  def after_leaving_scope(scope, _variable_table); end

  private

  def check_argument(variable); end
end

# Checks for unused block arguments.
#
# @example
#   # bad
#   do_something do |used, unused|
#   puts used
#   end
#
#   do_something do |bar|
#   puts :foo
#   end
#
#   define_method(:foo) do |bar|
#   puts :baz
#   end
#
#   # good
#   do_something do |used, _unused|
#   puts used
#   end
#
#   do_something do
#   puts :foo
#   end
#
#   define_method(:foo) do |_bar|
#   puts :baz
#   end
# @example IgnoreEmptyBlocks: true (default)
#   # good
#   do_something { |unused| }
# @example IgnoreEmptyBlocks: false
#   # bad
#   do_something { |unused| }
# @example AllowUnusedKeywordArguments: false (default)
#   # bad
#   do_something do |unused: 42|
#   foo
#   end
# @example AllowUnusedKeywordArguments: true
#   # good
#   do_something do |unused: 42|
#   foo
#   end
class RuboCop::Cop::Lint::UnusedBlockArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::Cop::AutoCorrector

  private

  # @return [Boolean]
  def allow_unused_keyword_arguments?; end

  # @return [Boolean]
  def allowed_block?(variable); end

  # @return [Boolean]
  def allowed_keyword_argument?(variable); end

  def augment_message(message, variable); end
  def autocorrect(corrector, node); end
  def check_argument(variable); end

  # @return [Boolean]
  def define_method_call?(variable); end

  # @return [Boolean]
  def empty_block?(variable); end

  # @return [Boolean]
  def ignore_empty_blocks?; end

  def message(variable); end
  def message_for_lambda(variable, all_arguments); end
  def message_for_normal_block(variable, all_arguments); end
  def message_for_underscore_prefix(variable); end

  # @return [Boolean]
  def used_block_local?(variable); end

  def variable_type(variable); end

  class << self
    def joining_forces; end
  end
end

# Checks for unused method arguments.
#
# @example
#   # bad
#   def some_method(used, unused, _unused_but_allowed)
#   puts used
#   end
#
#   # good
#   def some_method(used, _unused, _unused_but_allowed)
#   puts used
#   end
# @example AllowUnusedKeywordArguments: false (default)
#   # bad
#   def do_something(used, unused: 42)
#   used
#   end
# @example AllowUnusedKeywordArguments: true
#   # good
#   def do_something(used, unused: 42)
#   used
#   end
# @example IgnoreEmptyMethods: true (default)
#   # good
#   def do_something(unused)
#   end
# @example IgnoreEmptyMethods: false
#   # bad
#   def do_something(unused)
#   end
# @example IgnoreNotImplementedMethods: true (default)
#   # good
#   def do_something(unused)
#   raise NotImplementedError
#   end
#
#   def do_something_else(unused)
#   fail "TODO"
#   end
# @example IgnoreNotImplementedMethods: false
#   # bad
#   def do_something(unused)
#   raise NotImplementedError
#   end
#
#   def do_something_else(unused)
#   fail "TODO"
#   end
class RuboCop::Cop::Lint::UnusedMethodArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::Cop::AutoCorrector

  def not_implemented?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def check_argument(variable); end

  # @return [Boolean]
  def ignored_method?(body); end

  def message(variable); end

  class << self
    def joining_forces; end
  end
end

# Identifies places where `URI.escape` can be replaced by
# `CGI.escape`, `URI.encode_www_form`, or `URI.encode_www_form_component`
# depending on your specific use case.
# Also this cop identifies places where `URI.unescape` can be replaced by
# `CGI.unescape`, `URI.decode_www_form`,
# or `URI.decode_www_form_component` depending on your specific use case.
#
# @example
#   # bad
#   URI.escape('http://example.com')
#   URI.encode('http://example.com')
#
#   # good
#   CGI.escape('http://example.com')
#   URI.encode_www_form([['example', 'param'], ['lang', 'en']])
#   URI.encode_www_form(page: 10, locale: 'en')
#   URI.encode_www_form_component('http://example.com')
#
#   # bad
#   URI.unescape(enc_uri)
#   URI.decode(enc_uri)
#
#   # good
#   CGI.unescape(enc_uri)
#   URI.decode_www_form(enc_uri)
#   URI.decode_www_form_component(enc_uri)
class RuboCop::Cop::Lint::UriEscapeUnescape < ::RuboCop::Cop::Base
  def on_send(node); end
  def uri_escape_unescape?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Lint::UriEscapeUnescape::ALTERNATE_METHODS_OF_URI_ESCAPE = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UriEscapeUnescape::ALTERNATE_METHODS_OF_URI_UNESCAPE = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UriEscapeUnescape::METHOD_NAMES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UriEscapeUnescape::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::UriEscapeUnescape::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `URI.regexp` is obsolete and should
# not be used. Instead, use `URI::DEFAULT_PARSER.make_regexp`.
#
# @example
#   # bad
#   URI.regexp('http://example.com')
#
#   # good
#   URI::DEFAULT_PARSER.make_regexp('http://example.com')
class RuboCop::Cop::Lint::UriRegexp < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
end

RuboCop::Cop::Lint::UriRegexp::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::UriRegexp::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UriRegexp::URI_CONSTANTS = T.let(T.unsafe(nil), Array)

# Checks for redundant access modifiers, including those with no
# code, those which are repeated, and leading `public` modifiers in a
# class or module body. Conditionally-defined methods are considered as
# always being defined, and thus access modifiers guarding such methods
# are not redundant.
#
# This cop has `ContextCreatingMethods` option. The default setting value
# is an empty array that means no method is specified.
# This setting is an array of methods which, when called, are known to
# create its own context in the module's current access context.
#
# It also has `MethodCreatingMethods` option. The default setting value
# is an empty array that means no method is specified.
# This setting is an array of methods which, when called, are known to
# create other methods in the module's current access context.
#
# @example
#   # bad
#   class Foo
#   public # this is redundant (default access is public)
#
#   def method
#   end
#   end
#
#   # bad
#   class Foo
#   # The following is redundant (methods defined on the class'
#   # singleton class are not affected by the public modifier)
#   public
#
#   def self.method3
#   end
#   end
#
#   # bad
#   class Foo
#   protected
#
#   define_method(:method2) do
#   end
#
#   protected # this is redundant (repeated from previous modifier)
#
#   [1,2,3].each do |i|
#   define_method("foo#{i}") do
#   end
#   end
#   end
#
#   # bad
#   class Foo
#   private # this is redundant (no following methods are defined)
#   end
#
#   # good
#   class Foo
#   private # this is not redundant (a method is defined)
#
#   def method2
#   end
#   end
#
#   # good
#   class Foo
#   # The following is not redundant (conditionally defined methods are
#   # considered as always defining a method)
#   private
#
#   if condition?
#   def method
#   end
#   end
#   end
#
#   # good
#   class Foo
#   protected # this is not redundant (a method is defined)
#
#   define_method(:method2) do
#   end
#   end
# @example ContextCreatingMethods: concerning
#   # Lint/UselessAccessModifier:
#   #   ContextCreatingMethods:
#   #     - concerning
#
#   # good
#   require 'active_support/concern'
#   class Foo
#   concerning :Bar do
#   def some_public_method
#   end
#
#   private
#
#   def some_private_method
#   end
#   end
#
#   # this is not redundant because `concerning` created its own context
#   private
#
#   def some_other_private_method
#   end
#   end
# @example MethodCreatingMethods: delegate
#   # Lint/UselessAccessModifier:
#   #   MethodCreatingMethods:
#   #     - delegate
#
#   # good
#   require 'active_support/core_ext/module/delegation'
#   class Foo
#   # this is not redundant because `delegate` creates methods
#   private
#
#   delegate :method_a, to: :method_b
#   end
class RuboCop::Cop::Lint::UselessAccessModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def class_or_instance_eval?(param0 = T.unsafe(nil)); end
  def class_or_module_or_struct_new_call?(param0 = T.unsafe(nil)); end
  def dynamic_method_definition?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_class(node); end
  def on_module(node); end
  def on_numblock(node); end
  def on_sclass(node); end
  def static_method_definition?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def access_modifier?(node); end

  # @return [Boolean]
  def any_context_creating_methods?(child); end

  # @return [Boolean]
  def any_method_definition?(child); end

  def autocorrect(corrector, node); end
  def check_child_nodes(node, unused, cur_vis); end
  def check_new_visibility(node, unused, new_vis, cur_vis); end
  def check_node(node); end
  def check_scope(node); end
  def check_send_node(node, cur_vis, unused); end

  # @return [Boolean]
  def eval_call?(child); end

  # @return [Boolean]
  def method_definition?(child); end

  # @return [Boolean]
  def start_of_new_scope?(child); end
end

RuboCop::Cop::Lint::UselessAccessModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for every useless assignment to local variable in every
# scope.
# The basic idea for this cop was from the warning of `ruby -cw`:
#
#   assigned but unused variable - foo
#
# Currently this cop has advanced logic that detects unreferenced
# reassignments and properly handles varied cases such as branch, loop,
# rescue, ensure, etc.
#
# @example
#
#   # bad
#
#   def some_method
#   some_var = 1
#   do_something
#   end
# @example
#
#   # good
#
#   def some_method
#   some_var = 1
#   do_something(some_var)
#   end
class RuboCop::Cop::Lint::UselessAssignment < ::RuboCop::Cop::Base
  def after_leaving_scope(scope, _variable_table); end
  def check_for_unused_assignments(variable); end
  def collect_variable_like_names(scope); end
  def message_for_useless_assignment(assignment); end
  def message_specification(assignment, variable); end
  def multiple_assignment_message(variable_name); end
  def operator_assignment_message(scope, assignment); end

  # TODO: More precise handling (rescue, ensure, nested begin, etc.)
  def return_value_node_of_scope(scope); end

  def similar_name_message(variable); end

  # @return [Boolean]
  def variable_like_method_invocation?(node); end

  class << self
    def joining_forces; end
  end
end

RuboCop::Cop::Lint::UselessAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for useless `else` in `begin..end` without `rescue`.
#
# NOTE: This syntax is no longer valid on Ruby 2.6 or higher.
#
# @example
#
#   # bad
#
#   begin
#   do_something
#   else
#   do_something_else # This will never be run.
#   end
# @example
#
#   # good
#
#   begin
#   do_something
#   rescue
#   handle_errors
#   else
#   do_something_else
#   end
class RuboCop::Cop::Lint::UselessElseWithoutRescue < ::RuboCop::Cop::Base
  def on_new_investigation; end
end

RuboCop::Cop::Lint::UselessElseWithoutRescue::MSG = T.let(T.unsafe(nil), String)

# Checks for useless method definitions, specifically: empty constructors
# and methods just delegating to `super`.
#
# @example
#   # bad
#   def initialize
#   super
#   end
#
#   def method
#   super
#   end
#
#   # good - with default arguments
#   def initialize(x = Object.new)
#   super
#   end
#
#   # good
#   def initialize
#   super
#   initialize_internals
#   end
#
#   def method(*args)
#   super(:extra_arg, *args)
#   end
class RuboCop::Cop::Lint::UselessMethodDefinition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def delegating?(node, def_node); end

  # @return [Boolean]
  def optional_args?(node); end
end

RuboCop::Cop::Lint::UselessMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Looks for `ruby2_keywords` calls for methods that do not need it.
#
# `ruby2_keywords` should only be called on methods that accept an argument splat
# (`*args`) but do not explicit keyword arguments (`k:` or `k: true`) or
# a keyword splat (`**kwargs`).
#
# @example
#   # good (splat argument without keyword arguments)
#   ruby2_keywords def foo(*args); end
#
#   # bad (no arguments)
#   ruby2_keywords def foo; end
#
#   # good
#   def foo; end
#
#   # bad (positional argument)
#   ruby2_keywords def foo(arg); end
#
#   # good
#   def foo(arg); end
#
#   # bad (double splatted argument)
#   ruby2_keywords def foo(**args); end
#
#   # good
#   def foo(**args); end
#
#   # bad (keyword arguments)
#   ruby2_keywords def foo(i:, j:); end
#
#   # good
#   def foo(i:, j:); end
#
#   # bad (splat argument with keyword arguments)
#   ruby2_keywords def foo(*args, i:, j:); end
#
#   # good
#   def foo(*args, i:, j:); end
#
#   # bad (splat argument with double splat)
#   ruby2_keywords def foo(*args, **kwargs); end
#
#   # good
#   def foo(*args, **kwargs); end
#
#   # bad (ruby2_keywords given a symbol)
#   def foo; end
#   ruby2_keywords :foo
#
#   # good
#   def foo; end
#
#   # bad (ruby2_keywords with dynamic method)
#   define_method(:foo) { |arg| }
#   ruby2_keywords :foo
#
#   # good
#   define_method(:foo) { |arg| }
class RuboCop::Cop::Lint::UselessRuby2Keywords < ::RuboCop::Cop::Base
  # Looks for statically or dynamically defined methods with a given name
  def method_definition(param0 = T.unsafe(nil), param1); end

  def on_send(node); end

  private

  # `ruby2_keywords` is only allowed if there's a `restarg` and no keyword arguments
  def allowed_arguments(arguments); end

  def inspect_def(node, def_node); end
  def inspect_sym(node, sym_node); end
end

RuboCop::Cop::Lint::UselessRuby2Keywords::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::UselessRuby2Keywords::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for setter call to local variable as the final
# expression of a function definition.
#
# @example
#
#   # bad
#
#   def something
#   x = Something.new
#   x.attr = 5
#   end
# @example
#
#   # good
#
#   def something
#   x = Something.new
#   x.attr = 5
#   x
#   end
class RuboCop::Cop::Lint::UselessSetterCall < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
  def setter_call_to_local_variable?(param0 = T.unsafe(nil)); end

  private

  def last_expression(body); end
end

RuboCop::Cop::Lint::UselessSetterCall::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::UselessSetterCall::MSG = T.let(T.unsafe(nil), String)

# This class tracks variable assignments in a method body
# and if a variable contains object passed as argument at the end of
# the method.
class RuboCop::Cop::Lint::UselessSetterCall::MethodVariableTracker
  # @return [MethodVariableTracker] a new instance of MethodVariableTracker
  def initialize(body_node); end

  # @return [Boolean]
  def constructor?(node); end

  # @return [Boolean]
  def contain_local_object?(variable_name); end

  def process_assignment(asgn_node, rhs_node); end
  def process_assignment_node(node); end
  def process_binary_operator_assignment(op_asgn_node); end
  def process_logical_operator_assignment(asgn_node); end
  def process_multiple_assignment(masgn_node); end
  def scan(node, &block); end
end

# Checks for uses of `Integer#times` that will never yield
# (when the integer <= 0) or that will only ever yield once
# (`1.times`).
#
# @example
#   # bad
#   -5.times { do_something }
#   0.times { do_something }
#   1.times { do_something  }
#   1.times { |i| do_something(i) }
#
#   # good
#   do_something
#   do_something(1)
class RuboCop::Cop::Lint::UselessTimes < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def block_arg(param0 = T.unsafe(nil)); end
  def block_reassigns_arg?(param0, param1); end
  def on_send(node); end
  def times_call?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, count, node, proc_name); end
  def autocorrect_block(corrector, node); end
  def autocorrect_block_pass(corrector, node, proc_name); end
  def fix_indentation(source, range); end

  # @return [Boolean]
  def never_process?(count, node); end

  # @return [Boolean]
  def own_line?(node); end

  def remove_node(corrector, node); end
end

RuboCop::Cop::Lint::UselessTimes::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::UselessTimes::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for operators, variables, literals, and nonmutating
# methods used in void context.
#
# @example CheckForMethodsWithNoSideEffects: false (default)
#   # bad
#   def some_method
#   some_num * 10
#   do_something
#   end
#
#   def some_method(some_var)
#   some_var
#   do_something
#   end
# @example CheckForMethodsWithNoSideEffects: true
#   # bad
#   def some_method(some_array)
#   some_array.sort
#   do_something(some_array)
#   end
#
#   # good
#   def some_method
#   do_something
#   some_num * 10
#   end
#
#   def some_method(some_var)
#   do_something
#   some_var
#   end
#
#   def some_method(some_array)
#   some_array.sort!
#   do_something(some_array)
#   end
class RuboCop::Cop::Lint::Void < ::RuboCop::Cop::Base
  def on_begin(node); end
  def on_block(node); end
  def on_kwbegin(node); end
  def on_numblock(node); end

  private

  def check_begin(node); end
  def check_defined(node); end
  def check_expression(expr); end
  def check_literal(node); end
  def check_nonmutating(node); end
  def check_self(node); end
  def check_var(node); end
  def check_void_op(node); end

  # @return [Boolean]
  def in_void_context?(node); end
end

RuboCop::Cop::Lint::Void::BINARY_OPERATORS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::Void::DEFINED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::LIT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::NONMUTATING_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::Void::NONMUTATING_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::OPERATORS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::Void::OP_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::SELF_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::UNARY_OPERATORS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Lint::Void::VAR_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Lint::Void::VOID_CONTEXT_TYPES = T.let(T.unsafe(nil), Array)

# Common functionality for obtaining source ranges from regexp matches
module RuboCop::Cop::MatchRange
  include ::RuboCop::Cop::RangeHelp

  private

  # Return a new `Range` covering the first matching group number for each
  # match of `regex` inside `range`
  def each_match_range(range, regex); end

  # For a `match` inside `range`, return a new `Range` covering the match
  def match_range(range, match); end
end

# Message Annotator class annotates a basic offense message
# based on params passed into initializer.
#
#  #=> 'Cop/CopName: message (http://example.org/styleguide)'
#
# @example
#   RuboCop::Cop::MessageAnnotator.new(
#   config, cop_name, cop_config, @options
#   ).annotate('message')
# @see #initialize
class RuboCop::Cop::MessageAnnotator
  # @option cop_config
  # @option cop_config
  # @option cop_config
  # @option options
  # @option options
  # @option options
  # @option options
  # @param config [RuboCop::Config] Check configs for all cops
  #   @note Message Annotator specifically checks the
  #   following config options for_all_cops
  #   :StyleGuideBaseURL [String] URL for styleguide
  #   :DisplayStyleGuide [Boolean] Include styleguide and reference URLs
  #   :ExtraDetails [Boolean] Include cop details
  #   :DisplayCopNames [Boolean] Include cop name
  # @param cop_name [String] for specific cop name
  # @param cop_config [Hash] configs for specific cop, from config#for_cop
  # @param options [Hash, nil] optional
  # @return [MessageAnnotator] a new instance of MessageAnnotator
  def initialize(config, cop_name, cop_config, options); end

  # Returns the annotated message,
  # based on params passed into initializer
  #
  # @return [String] annotated message
  def annotate(message); end

  # Returns the value of attribute config.
  def config; end

  # Returns the value of attribute cop_config.
  def cop_config; end

  # Returns the value of attribute cop_name.
  def cop_name; end

  # Returns the value of attribute options.
  def options; end

  def urls; end

  private

  # @return [Boolean]
  def debug?; end

  def details; end

  # @return [Boolean]
  def display_cop_names?; end

  # @return [Boolean]
  def display_style_guide?; end

  # @return [Boolean]
  def extra_details?; end

  def reference_urls; end

  # Returns the base style guide URL from AllCops or the specific department
  #
  # @return [String] style guide URL
  def style_guide_base_url; end

  def style_guide_url; end

  class << self
    # Returns the value of attribute style_guide_urls.
    def style_guide_urls; end
  end
end

# This module handles measurement and reporting of complexity in methods.
#
# @api private
module RuboCop::Cop::MethodComplexity
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  extend ::RuboCop::AST::NodePattern::Macros
  extend ::RuboCop::ExcludeLimit

  def define_method?(param0 = T.unsafe(nil)); end
  def max=(value); end

  # @api private
  def on_block(node); end

  # @api private
  def on_def(node); end

  # @api private
  def on_defs(node); end

  # @api private
  def on_numblock(node); end

  private

  # @api private
  def check_complexity(node, method_name); end

  # @api private
  def complexity(body); end
end

# Common code for cops that deal with preferred methods.
module RuboCop::Cop::MethodPreference
  private

  def default_cop_config; end
  def preferred_method(method); end
  def preferred_methods; end
end

module RuboCop::Cop::Metrics; end

# Checks that the ABC size of methods is not higher than the
# configured maximum. The ABC size is based on assignments, branches
# (method calls), and conditions. See http://c2.com/cgi/wiki?AbcMetric
# and https://en.wikipedia.org/wiki/ABC_Software_Metric.
#
# Interpreting ABC size:
#
# * <= 17 satisfactory
# * 18..30 unsatisfactory
# * > 30 dangerous
#
# You can have repeated "attributes" calls count as a single "branch".
# For this purpose, attributes are any method with no argument; no attempt
# is meant to distinguish actual `attr_reader` from other methods.
#
# This cop also takes into account `AllowedMethods` (defaults to `[]`)
# And `AllowedPatterns` (defaults to `[]`)
#
# @example CountRepeatedAttributes: false (default is true)
#
#   # `model` and `current_user`, refenced 3 times each,
#   # are each counted as only 1 branch each if
#   # `CountRepeatedAttributes` is set to 'false'
#
#   def search
#   @posts = model.active.visible_by(current_user)
#   .search(params[:q])
#   @posts = model.some_process(@posts, current_user)
#   @posts = model.another_process(@posts, current_user)
#
#   render 'pages/search/page'
#   end
class RuboCop::Cop::Metrics::AbcSize < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  include ::RuboCop::Cop::MethodComplexity

  private

  def complexity(node); end
end

RuboCop::Cop::Metrics::AbcSize::MSG = T.let(T.unsafe(nil), String)

# Checks if the length of a block exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
# The cop can be configured to ignore blocks passed to certain methods.
#
# You can set literals you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', and 'heredoc'. Each literal
# will be counted as one line regardless of its actual size.
#
#
# NOTE: The `ExcludedMethods` configuration is deprecated and only kept
# for backwards compatibility. Please use `AllowedMethods` and `AllowedPatterns`
# instead. By default, there are no methods to allowed.
#
# NOTE: This cop does not apply for `Struct` definitions.
#
# @example CountAsOne: ['array', 'heredoc']
#
#   something do
#   array = [         # +1
#   1,
#   2
#   ]
#
#   hash = {          # +3
#   key: 'value'
#   }
#
#   msg = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#   end                 # 5 points
class RuboCop::Cop::Metrics::BlockLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  def on_block(node); end
  def on_numblock(node); end

  private

  def cop_label; end

  # @return [Boolean]
  def method_receiver_excluded?(node); end
end

RuboCop::Cop::Metrics::BlockLength::LABEL = T.let(T.unsafe(nil), String)

# Checks for excessive nesting of conditional and looping
# constructs.
#
# You can configure if blocks are considered using the `CountBlocks`
# option. When set to `false` (the default) blocks are not counted
# towards the nesting level. Set to `true` to count blocks as well.
#
# The maximum level of nesting allowed is configurable.
class RuboCop::Cop::Metrics::BlockNesting < ::RuboCop::Cop::Base
  def max=(value); end
  def on_new_investigation; end

  private

  def check_nesting_level(node, max, current_level); end

  # @return [Boolean]
  def consider_node?(node); end

  # @return [Boolean]
  def count_blocks?; end

  def message(max); end
end

RuboCop::Cop::Metrics::BlockNesting::NESTING_BLOCKS = T.let(T.unsafe(nil), Array)

# Checks if the length a class exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
#
# You can set literals you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', and 'heredoc'. Each literal
# will be counted as one line regardless of its actual size.
#
# NOTE: This cop also applies for `Struct` definitions.
#
# @example CountAsOne: ['array', 'heredoc']
#
#   class Foo
#   ARRAY = [         # +1
#   1,
#   2
#   ]
#
#   HASH = {          # +3
#   key: 'value'
#   }
#
#   MSG = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#   end                 # 5 points
class RuboCop::Cop::Metrics::ClassLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength

  def on_casgn(node); end
  def on_class(node); end

  private

  def message(length, max_length); end
end

# Checks that the cyclomatic complexity of methods is not higher
# than the configured maximum. The cyclomatic complexity is the number of
# linearly independent paths through a method. The algorithm counts
# decision points and adds one.
#
# An if statement (or unless or ?:) increases the complexity by one. An
# else branch does not, since it doesn't add a decision point. The &&
# operator (or keyword and) can be converted to a nested if statement,
# and ||/or is shorthand for a sequence of ifs, so they also add one.
# Loops can be said to have an exit condition, so they add one.
# Blocks that are calls to builtin iteration methods
# (e.g. `ary.map{...}) also add one, others are ignored.
#
#   def each_child_node(*types)               # count begins: 1
#     unless block_given?                     # unless: +1
#       return to_enum(__method__, *types)
#
#     children.each do |child|                # each{}: +1
#       next unless child.is_a?(Node)         # unless: +1
#
#       yield child if types.empty? ||        # if: +1, ||: +1
#                      types.include?(child.type)
#     end
#
#     self
#   end                                       # total: 6
class RuboCop::Cop::Metrics::CyclomaticComplexity < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  include ::RuboCop::Cop::MethodComplexity
  include ::RuboCop::Cop::Metrics::Utils::IteratingBlock

  private

  def complexity_score_for(node); end

  # @return [Boolean]
  def count_block?(block); end
end

RuboCop::Cop::Metrics::CyclomaticComplexity::COUNTED_NODES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Metrics::CyclomaticComplexity::MSG = T.let(T.unsafe(nil), String)

# Checks if the length of a method exceeds some maximum value.
# Comment lines can optionally be allowed.
# The maximum allowed length is configurable.
#
# You can set literals you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', and 'heredoc'. Each literal
# will be counted as one line regardless of its actual size.
#
# NOTE: The `ExcludedMethods` and `IgnoredMethods` configuration is
# deprecated and only kept for backwards compatibility.
# Please use `AllowedMethods` and `AllowedPatterns` instead.
# By default, there are no methods to allowed.
#
# @example CountAsOne: ['array', 'heredoc']
#
#   def m
#   array = [       # +1
#   1,
#   2
#   ]
#
#   hash = {        # +3
#   key: 'value'
#   }
#
#   <<~HEREDOC      # +1
#   Heredoc
#   content.
#   HEREDOC
#   end               # 5 points
class RuboCop::Cop::Metrics::MethodLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern

  def on_block(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_numblock(node); end

  private

  def cop_label; end
end

RuboCop::Cop::Metrics::MethodLength::LABEL = T.let(T.unsafe(nil), String)

# Checks if the length a module exceeds some maximum value.
# Comment lines can optionally be ignored.
# The maximum allowed length is configurable.
#
# You can set literals you want to fold with `CountAsOne`.
# Available are: 'array', 'hash', and 'heredoc'. Each literal
# will be counted as one line regardless of its actual size.
#
# @example CountAsOne: ['array', 'heredoc']
#
#   module M
#   ARRAY = [         # +1
#   1,
#   2
#   ]
#
#   HASH = {          # +3
#   key: 'value'
#   }
#
#   MSG = <<~HEREDOC  # +1
#   Heredoc
#   content.
#   HEREDOC
#   end                 # 5 points
class RuboCop::Cop::Metrics::ModuleLength < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CodeLength

  def module_definition?(param0 = T.unsafe(nil)); end
  def on_casgn(node); end
  def on_module(node); end

  private

  def message(length, max_length); end
end

# Checks for methods with too many parameters.
#
# The maximum number of parameters is configurable.
# Keyword arguments can optionally be excluded from the total count,
# as they add less complexity than positional or optional parameters.
#
# NOTE: Explicit block argument `&block` is not counted to prevent
# erroneous change that is avoided by making block argument implicit.
#
# This cop also checks for the maximum number of optional parameters.
# This can be configured using the `MaxOptionalParameters` config option.
#
# @example Max: 3
#   # good
#   def foo(a, b, c = 1)
#   end
# @example Max: 2
#   # bad
#   def foo(a, b, c = 1)
#   end
# @example CountKeywordArgs: true (default)
#   # counts keyword args towards the maximum
#
#   # bad (assuming Max is 3)
#   def foo(a, b, c, d: 1)
#   end
#
#   # good (assuming Max is 3)
#   def foo(a, b, c: 1)
#   end
# @example CountKeywordArgs: false
#   # don't count keyword args towards the maximum
#
#   # good (assuming Max is 3)
#   def foo(a, b, c, d: 1)
#   end
# @example MaxOptionalParameters: 3 (default)
#   # good
#   def foo(a = 1, b = 2, c = 3)
#   end
# @example MaxOptionalParameters: 2
#   # bad
#   def foo(a = 1, b = 2, c = 3)
#   end
class RuboCop::Cop::Metrics::ParameterLists < ::RuboCop::Cop::Base
  def argument_to_lambda_or_proc?(param0 = T.unsafe(nil)); end
  def max=(value); end
  def max_optional_parameters=(value); end
  def on_args(node); end
  def on_def(node); end
  def on_defs(node); end

  private

  def args_count(node); end

  # @return [Boolean]
  def count_keyword_args?; end

  def max_optional_parameters; end
  def max_params; end
end

RuboCop::Cop::Metrics::ParameterLists::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Metrics::ParameterLists::NAMED_KEYWORD_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Metrics::ParameterLists::OPTIONAL_PARAMETERS_MSG = T.let(T.unsafe(nil), String)

# Tries to produce a complexity score that's a measure of the
# complexity the reader experiences when looking at a method. For that
# reason it considers `when` nodes as something that doesn't add as much
# complexity as an `if` or a `&&`. Except if it's one of those special
# `case`/`when` constructs where there's no expression after `case`. Then
# the cop treats it as an `if`/`elsif`/`elsif`... and lets all the `when`
# nodes count. In contrast to the CyclomaticComplexity cop, this cop
# considers `else` nodes as adding complexity.
#
# @example
#
#   def my_method                   # 1
#   if cond                       # 1
#   case var                    # 2 (0.8 + 4 * 0.2, rounded)
#   when 1 then func_one
#   when 2 then func_two
#   when 3 then func_three
#   when 4..10 then func_other
#   end
#   else                          # 1
#   do_something until a && b   # 2
#   end                           # ===
#   end                             # 7 complexity points
class RuboCop::Cop::Metrics::PerceivedComplexity < ::RuboCop::Cop::Metrics::CyclomaticComplexity
  private

  def complexity_score_for(node); end
end

RuboCop::Cop::Metrics::PerceivedComplexity::COUNTED_NODES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Metrics::PerceivedComplexity::MSG = T.let(T.unsafe(nil), String)
module RuboCop::Cop::Metrics::Utils; end

# > ABC is .. a software size metric .. computed by counting the number
# > of assignments, branches and conditions for a section of code.
# > http://c2.com/cgi/wiki?AbcMetric
#
# We separate the *calculator* from the *cop* so that the calculation,
# the formula itself, is easier to test.
class RuboCop::Cop::Metrics::Utils::AbcSizeCalculator
  include ::RuboCop::AST::Sexp
  include ::RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount
  include ::RuboCop::Cop::Metrics::Utils::IteratingBlock
  include ::RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount

  # @return [AbcSizeCalculator] a new instance of AbcSizeCalculator
  def initialize(node, discount_repeated_attributes: T.unsafe(nil)); end

  def calculate; end
  def calculate_node(node); end

  # @return [Boolean]
  def else_branch?(node); end

  def evaluate_branch_nodes(node); end
  def evaluate_condition_node(node); end

  private

  # @return [Boolean]
  def argument?(node); end

  # @return [Boolean]
  def assignment?(node); end

  # @return [Boolean]
  def branch?(node); end

  # @return [Boolean]
  def capturing_variable?(name); end

  def compound_assignment(node); end

  # @return [Boolean]
  def condition?(node); end

  # @return [Boolean]
  def simple_assignment?(node); end

  # @yield [node]
  def visit_depth_last(node, &block); end

  class << self
    def calculate(node, discount_repeated_attributes: T.unsafe(nil)); end
  end
end

# TODO: move to rubocop-ast
RuboCop::Cop::Metrics::Utils::AbcSizeCalculator::ARGUMENT_TYPES = T.let(T.unsafe(nil), Array)

# > Branch -- an explicit forward program branch out of scope -- a
# > function call, class method call ..
# > http://c2.com/cgi/wiki?AbcMetric
RuboCop::Cop::Metrics::Utils::AbcSizeCalculator::BRANCH_NODES = T.let(T.unsafe(nil), Array)

# > Condition -- a logical/Boolean test, == != <= >= < > else case
# > default try catch ? and unary conditionals.
# > http://c2.com/cgi/wiki?AbcMetric
RuboCop::Cop::Metrics::Utils::AbcSizeCalculator::CONDITION_NODES = T.let(T.unsafe(nil), Array)

# Helps to calculate code length for the provided node.
class RuboCop::Cop::Metrics::Utils::CodeLengthCalculator
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [CodeLengthCalculator] a new instance of CodeLengthCalculator
  def initialize(node, processed_source, count_comments: T.unsafe(nil), foldable_types: T.unsafe(nil)); end

  def calculate; end

  private

  # @return [Boolean]
  def another_args?(node); end

  def build_foldable_checks(types); end
  def classlike_code_length(node); end

  # @return [Boolean]
  def classlike_node?(node); end

  def code_length(node); end

  # @return [Boolean]
  def count_comments?; end

  def each_top_level_descendant(node, types, &block); end
  def extract_body(node); end

  # @return [Boolean]
  def foldable_node?(node); end

  def heredoc_length(node); end

  # @return [Boolean]
  def heredoc_node?(node); end

  # Returns true for lines that shall not be included in the count.
  #
  # @return [Boolean]
  def irrelevant_line?(source_line); end

  def line_numbers_of_inner_nodes(node, *types); end

  # @return [Boolean]
  def namespace_module?(node); end

  def normalize_foldable_types(types); end
  def omit_length(descendant); end

  # @return [Boolean]
  def parenthesized?(node); end
end

RuboCop::Cop::Metrics::Utils::CodeLengthCalculator::CLASSLIKE_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Metrics::Utils::CodeLengthCalculator::FOLDABLE_TYPES = T.let(T.unsafe(nil), Array)

# Used to identify iterating blocks like `.map{}` and `.map(&:...)`
module RuboCop::Cop::Metrics::Utils::IteratingBlock
  # Returns the name of the method called with a block
  # if node is a block node, or a block-pass node.
  def block_method_name(node); end

  # Returns nil if node is neither a block node or a block-pass node.
  # Otherwise returns true/false if method call is a known iterating call
  #
  # @return [Boolean]
  def iterating_block?(node); end

  # Returns true iff name is a known iterating type (e.g. :each, :transform_values)
  #
  # @return [Boolean]
  def iterating_method?(name); end
end

RuboCop::Cop::Metrics::Utils::IteratingBlock::KNOWN_ITERATING_METHODS = T.let(T.unsafe(nil), Set)

# Identifies repetitions `{c}send` calls with no arguments:
#
#   foo.bar
#   foo.bar # => repeated
#   foo.bar.baz.qux # => inner send repeated
#   foo.bar.baz.other # => both inner send repeated
#   foo.bar(2) # => not repeated
#
# It also invalidates sequences if a receiver is reassigned:
#
#   xx.foo.bar
#   xx.foo.baz      # => inner send repeated
#   self.xx = any   # => invalidates everything so far
#   xx.foo.baz      # => no repetition
#   self.xx.foo.baz # => all repeated
#
# @api private
module RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount
  include ::RuboCop::AST::Sexp
  extend ::RuboCop::AST::NodePattern::Macros

  # Plug into the calculator
  #
  # @api private
  def initialize(node, discount_repeated_attributes: T.unsafe(nil)); end

  def attribute_call?(param0 = T.unsafe(nil)); end

  # @api private
  def calculate_node(node); end

  # @api private
  # @return [Boolean]
  def discount_repeated_attributes?; end

  # @api private
  def evaluate_branch_nodes(node); end

  def root_node?(param0 = T.unsafe(nil)); end

  private

  # @api private
  # @return [Boolean]
  def discount_repeated_attribute?(send_node); end

  # Returns the "known_attributes" for the `node` by walking the receiver tree
  # If at any step the subdirectory does not exist, it is yielded with the
  # associated key (method_name)
  # If the node is not a series of `(c)send` calls with no arguments,
  # then `nil` is yielded
  #
  # @api private
  def find_attributes(node, &block); end

  # or `nil` if it is not a setter.
  #
  # @api private
  def setter_to_getter(node); end

  # @api private
  def update_repeated_attribute(node); end
end

# @api private
RuboCop::Cop::Metrics::Utils::RepeatedAttributeDiscount::VAR_SETTER_TO_GETTER = T.let(T.unsafe(nil), Hash)

# Identifies repetitions `&.` on the same variable:
#
#  my_var&.foo
#  my_var&.bar # => repeated
#  my_var = baz # => reset
#  my_var&.qux # => not repeated
#
# @api private
module RuboCop::Cop::Metrics::Utils::RepeatedCsendDiscount
  # @api private
  # @return [Boolean]
  def discount_for_repeated_csend?(csend_node); end

  # @api private
  def reset_on_lvasgn(node); end

  # @api private
  def reset_repeated_csend; end
end

module RuboCop::Cop::Migration; end

# department name.
class RuboCop::Cop::Migration::DepartmentName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def check_cop_name(name, comment, offset); end

  # @return [Boolean]
  def contain_unexpected_character_for_department_name?(name); end

  def disable_comment_offset; end
  def qualified_legacy_cop_name(cop_name); end

  # @return [Boolean]
  def valid_content_token?(content_token); end
end

RuboCop::Cop::Migration::DepartmentName::DISABLE_COMMENT_FORMAT = T.let(T.unsafe(nil), Regexp)

# The token that makes up a disable comment.
# `DepartmentName/CopName` or` all`.
RuboCop::Cop::Migration::DepartmentName::DISABLING_COPS_CONTENT_TOKEN = T.let(T.unsafe(nil), Regexp)

RuboCop::Cop::Migration::DepartmentName::MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking minimum body length.
module RuboCop::Cop::MinBodyLength
  private

  def min_body_length; end

  # @return [Boolean]
  def min_body_length?(node); end
end

# Common code for indenting the first elements in multiline
# array literals, hash literals, and method definitions.
module RuboCop::Cop::MultilineElementIndentation
  private

  def check_expected_style(styles); end
  def check_first(first, left_brace, left_parenthesis, offset); end
  def detected_styles(actual_column, offset, left_parenthesis, left_brace); end
  def detected_styles_for_column(column, left_parenthesis, left_brace); end
  def each_argument_node(node, type); end
  def hash_pair_where_value_beginning_with(left_brace, first); end
  def incorrect_style_detected(styles, first, base_column_type); end
  def indent_base(left_brace, first, left_parenthesis); end

  # @return [Boolean]
  def key_and_value_begin_on_same_line?(pair); end

  # @return [Boolean]
  def right_sibling_begins_on_subsequent_line?(pair); end
end

# Common functionality for checking for a line break before each
# element in a multi-line collection.
module RuboCop::Cop::MultilineElementLineBreaks
  private

  # @return [Boolean]
  def all_on_same_line?(nodes); end

  def check_line_breaks(_node, children); end
end

# Common functionality for checking multiline method calls and binary
# operations.
module RuboCop::Cop::MultilineExpressionIndentation
  def on_send(node); end

  private

  def argument_in_method_call(node, kind); end
  def assignment_rhs(node); end
  def check(range, node, lhs, rhs); end

  # The correct indentation of `node` is usually `IndentationWidth`, with
  # one exception: prefix keywords.
  #
  # ```
  # while foo &&  # Here, `while` is called a "prefix keyword"
  #     bar       # This is called "special indentation"
  #   baz
  # end
  # ```
  #
  # Note that *postfix conditionals* do *not* get "special indentation".
  #
  # ```
  # next if foo &&
  #   bar # normal indentation, not special
  # ```
  def correct_indentation(node); end

  # @return [Boolean]
  def disqualified_rhs?(candidate, ancestor); end

  # @return [Boolean]
  def grouped_expression?(node); end

  def incorrect_style_detected(range, node, lhs, rhs); end
  def indentation(node); end
  def indented_keyword_expression(node); end

  # @return [Boolean]
  def inside_arg_list_parentheses?(node, ancestor); end

  def keyword_message_tail(node); end
  def kw_node_with_special_indentation(node); end

  # In a chain of method calls, we regard the top send node as the base
  # for indentation of all lines following the first. For example:
  # a.
  #   b c { block }.            <-- b is indented relative to a
  #   d                         <-- d is indented relative to a
  def left_hand_side(lhs); end

  # @return [Boolean]
  def not_for_this_cop?(node); end

  def operation_description(node, rhs); end
  def part_of_assignment_rhs(node, candidate); end

  # @return [Boolean]
  def part_of_block_body?(candidate, block_node); end

  # Returns true if `node` is a conditional whose `body` and `condition`
  # begin on the same line.
  #
  # @return [Boolean]
  def postfix_conditional?(node); end

  # The []= operator and setters (a.b = c) are parsed as :send nodes.
  #
  # @return [Boolean]
  def valid_method_rhs_candidate?(candidate, node); end

  # @return [Boolean]
  def valid_rhs?(candidate, ancestor); end

  # @return [Boolean]
  def valid_rhs_candidate?(candidate, node); end

  # @return [Boolean]
  def within_node?(inner, outer); end
end

RuboCop::Cop::MultilineExpressionIndentation::ASSIGNMENT_MESSAGE_TAIL = T.let(T.unsafe(nil), String)
RuboCop::Cop::MultilineExpressionIndentation::DEFAULT_MESSAGE_TAIL = T.let(T.unsafe(nil), String)
RuboCop::Cop::MultilineExpressionIndentation::KEYWORD_ANCESTOR_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::MultilineExpressionIndentation::KEYWORD_MESSAGE_TAIL = T.let(T.unsafe(nil), String)
RuboCop::Cop::MultilineExpressionIndentation::UNALIGNED_RHS_TYPES = T.let(T.unsafe(nil), Array)

# Autocorrection logic for the closing brace of a literal either
# on the same line as the last contained elements, or a new line.
class RuboCop::Cop::MultilineLiteralBraceCorrector
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MultilineLiteralBraceLayout
  include ::RuboCop::Cop::RangeHelp

  # @return [MultilineLiteralBraceCorrector] a new instance of MultilineLiteralBraceCorrector
  def initialize(corrector, node, processed_source); end

  def call; end

  private

  def content_if_comment_present(corrector, node); end
  def correct_next_line_brace(corrector); end
  def correct_same_line_brace(corrector); end

  # Returns the value of attribute corrector.
  def corrector; end

  def last_element_range_with_trailing_comma(node); end
  def last_element_trailing_comma_range(node); end

  # Returns the value of attribute node.
  def node; end

  # Returns the value of attribute processed_source.
  def processed_source; end

  def remove_trailing_content_of_comment(corrector, range); end
  def select_content_to_be_inserted_after_last_element(corrector, node); end

  class << self
    def correct(corrector, node, processed_source); end
  end
end

# Common functionality for checking the closing brace of a literal is
# either on the same line as the last contained elements or a new line.
module RuboCop::Cop::MultilineLiteralBraceLayout
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  private

  def check(node); end
  def check_brace_layout(node); end
  def check_new_line(node); end
  def check_same_line(node); end
  def check_symmetrical(node); end
  def children(node); end

  # This method depends on the fact that we have guarded
  # against implicit and empty literals.
  #
  # @return [Boolean]
  def closing_brace_on_same_line?(node); end

  # @return [Boolean]
  def empty_literal?(node); end

  # @return [Boolean]
  def ignored_literal?(node); end

  # @return [Boolean]
  def implicit_literal?(node); end

  # Starting with the parent node and recursively for the parent node's
  # children, check if the node is a HEREDOC and if the HEREDOC ends below
  # or on the last line of the parent node.
  #
  # Example:
  #
  #   # node is `b: ...` parameter
  #   # last_line_heredoc?(node) => false
  #   foo(a,
  #     b: {
  #       a: 1,
  #       c: <<-EOM
  #         baz
  #       EOM
  #     }
  #   )
  #
  #   # node is `b: ...` parameter
  #   # last_line_heredoc?(node) => true
  #   foo(a,
  #     b: <<-EOM
  #       baz
  #     EOM
  #   )
  #
  # @return [Boolean]
  def last_line_heredoc?(node, parent = T.unsafe(nil)); end

  # Returns true for the case
  #   [a,
  #    b # comment
  #   ].some_method
  #
  # @return [Boolean]
  def new_line_needed_before_closing_brace?(node); end

  # This method depends on the fact that we have guarded
  # against implicit and empty literals.
  #
  # @return [Boolean]
  def opening_brace_on_same_line?(node); end
end

module RuboCop::Cop::Naming; end

# Makes sure that accessor methods are named properly. Applies
# to both instance and class methods.
#
# NOTE: Offenses are only registered for methods with the expected
# arity. Getters (`get_attribute`) must have no arguments to be
# registered, and setters (`set_attribute(value)`) must have exactly
# one.
#
# @example
#   # bad
#   def set_attribute(value)
#   end
#
#   # good
#   def attribute=(value)
#   end
#
#   # bad
#   def get_attribute
#   end
#
#   # good
#   def attribute
#   end
#
#   # accepted, incorrect arity for getter
#   def get_value(attr)
#   end
#
#   # accepted, incorrect arity for setter
#   def set_value
#   end
class RuboCop::Cop::Naming::AccessorMethodName < ::RuboCop::Cop::Base
  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def bad_reader_name?(node); end

  # @return [Boolean]
  def bad_writer_name?(node); end

  def message(node); end
end

RuboCop::Cop::Naming::AccessorMethodName::MSG_READER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::AccessorMethodName::MSG_WRITER = T.let(T.unsafe(nil), String)

# Checks for non-ascii characters in identifier and constant names.
# Identifiers are always checked and whether constants are checked
# can be controlled using AsciiConstants config.
#
# @example
#   # bad
#   def καλημερα # Greek alphabet (non-ascii)
#   end
#
#   # bad
#   def こんにちはと言う # Japanese character (non-ascii)
#   end
#
#   # bad
#   def hello_🍣 # Emoji (non-ascii)
#   end
#
#   # good
#   def say_hello
#   end
#
#   # bad
#   신장 = 10 # Hangul character (non-ascii)
#
#   # good
#   height = 10
#
#   # bad
#   params[:عرض_gteq] # Arabic character (non-ascii)
#
#   # good
#   params[:width_gteq]
# @example AsciiConstants: true (default)
#   # bad
#   class Foö
#   end
#
#   FOÖ = "foo"
# @example AsciiConstants: false
#   # good
#   class Foö
#   end
#
#   FOÖ = "foo"
class RuboCop::Cop::Naming::AsciiIdentifiers < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  def first_non_ascii_chars(string); end
  def first_offense_range(identifier); end

  # @return [Boolean]
  def should_check?(token); end
end

RuboCop::Cop::Naming::AsciiIdentifiers::CONSTANT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::AsciiIdentifiers::IDENTIFIER_MSG = T.let(T.unsafe(nil), String)

# Makes sure that certain binary operator methods have their
# sole  parameter named `other`.
#
# @example
#
#   # bad
#   def +(amount); end
#
#   # good
#   def +(other); end
class RuboCop::Cop::Naming::BinaryOperatorParameterName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def op_method_candidate?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def op_method?(name); end
end

RuboCop::Cop::Naming::BinaryOperatorParameterName::EXCLUDED = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Naming::BinaryOperatorParameterName::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::BinaryOperatorParameterName::OP_LIKE_METHODS = T.let(T.unsafe(nil), Array)

# In Ruby 3.1, anonymous block forwarding has been added.
#
# This cop identifies places where `do_something(&block)` can be replaced
# by `do_something(&)`.
#
# It also supports the opposite style by alternative `explicit` option.
# You can specify the block variable name for autocorrection with `BlockForwardingName`.
# The default variable name is `block`. If the name is already in use, it will not be
# autocorrected.
#
# @example EnforcedStyle: anonymous (default)
#
#   # bad
#   def foo(&block)
#   bar(&block)
#   end
#
#   # good
#   def foo(&)
#   bar(&)
#   end
# @example EnforcedStyle: explicit
#
#   # bad
#   def foo(&)
#   bar(&)
#   end
#
#   # good
#   def foo(&block)
#   bar(&block)
#   end
class RuboCop::Cop::Naming::BlockForwarding < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def anonymous_block_argument?(node); end

  def block_forwarding_name; end

  # @return [Boolean]
  def expected_block_forwarding_style?(node, last_argument); end

  # @return [Boolean]
  def explicit_block_argument?(node); end

  def register_offense(block_argument, node); end

  # @return [Boolean]
  def use_block_argument_as_local_variable?(node, last_argument); end

  # @return [Boolean]
  def use_kwarg_in_method_definition?(node); end
end

RuboCop::Cop::Naming::BlockForwarding::MSG = T.let(T.unsafe(nil), String)

# Checks block parameter names for how descriptive they
# are. It is highly configurable.
#
# The `MinNameLength` config option takes an integer. It represents
# the minimum amount of characters the name must be. Its default is 1.
# The `AllowNamesEndingInNumbers` config option takes a boolean. When
# set to false, this cop will register offenses for names ending with
# numbers. Its default is false. The `AllowedNames` config option
# takes an array of permitted names that will never register an
# offense. The `ForbiddenNames` config option takes an array of
# restricted names that will always register an offense.
#
# @example
#   # bad
#   bar do |varOne, varTwo|
#   varOne + varTwo
#   end
#
#   # With `AllowNamesEndingInNumbers` set to false
#   foo { |num1, num2| num1 * num2 }
#
#   # With `MinNameLength` set to number greater than 1
#   baz { |a, b, c| do_stuff(a, b, c) }
#
#   # good
#   bar do |thud, fred|
#   thud + fred
#   end
#
#   foo { |speed, distance| speed * distance }
#
#   baz { |age, height, gender| do_stuff(age, height, gender) }
class RuboCop::Cop::Naming::BlockParameterName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::UncommunicativeName

  def on_block(node); end
end

# Checks for class and module names with
# an underscore in them.
#
# `AllowedNames` config takes an array of permitted names.
# Its default value is `['module_parent']`.
# These names can be full class/module names or part of the name.
# eg. Adding `my_class` to the `AllowedNames` config will allow names like
# `my_class`, `my_class::User`, `App::my_class`, `App::my_class::User`, etc.
#
# @example
#   # bad
#   class My_Class
#   end
#   module My_Module
#   end
#
#   # good
#   class MyClass
#   end
#   module MyModule
#   end
#   class module_parent::MyModule
#   end
class RuboCop::Cop::Naming::ClassAndModuleCamelCase < ::RuboCop::Cop::Base
  def on_class(node); end
  def on_module(node); end
end

RuboCop::Cop::Naming::ClassAndModuleCamelCase::MSG = T.let(T.unsafe(nil), String)

# Checks whether constant names are written using
# SCREAMING_SNAKE_CASE.
#
# To avoid false positives, it ignores cases in which we cannot know
# for certain the type of value that would be assigned to a constant.
#
# @example
#   # bad
#   InchInCm = 2.54
#   INCHinCM = 2.54
#   Inch_In_Cm = 2.54
#
#   # good
#   INCH_IN_CM = 2.54
class RuboCop::Cop::Naming::ConstantName < ::RuboCop::Cop::Base
  def class_or_struct_return_method?(param0 = T.unsafe(nil)); end
  def literal_receiver?(param0 = T.unsafe(nil)); end
  def on_casgn(node); end

  private

  # @return [Boolean]
  def allowed_assignment?(value); end

  # @return [Boolean]
  def allowed_conditional_expression_on_rhs?(node); end

  # @return [Boolean]
  def allowed_method_call_on_rhs?(node); end

  # @return [Boolean]
  def contains_constant?(node); end
end

RuboCop::Cop::Naming::ConstantName::MSG = T.let(T.unsafe(nil), String)

# Use POSIX character classes, so we allow accented characters rather
# than just standard ASCII characters
RuboCop::Cop::Naming::ConstantName::SNAKE_CASE = T.let(T.unsafe(nil), Regexp)

# Makes sure that Ruby source files have snake_case
# names. Ruby scripts (i.e. source files with a shebang in the
# first line) are ignored.
#
# The cop also ignores `.gemspec` files, because Bundler
# recommends using dashes to separate namespaces in nested gems
# (i.e. `bundler-console` becomes `Bundler::Console`). As such, the
# gemspec is supposed to be named `bundler-console.gemspec`.
#
# When `ExpectMatchingDefinition` (default: `false`) is `true`, the cop requires
# each file to have a class, module or `Struct` defined in it that matches
# the filename. This can be further configured using
# `CheckDefinitionPathHierarchy` (default: `true`) to determine whether the
# path should match the namespace of the above definition.
#
# When `IgnoreExecutableScripts` (default: `true`) is `true`, files that start
# with a shebang line are not considered by the cop.
#
# When `Regex` is set, the cop will flag any filename that does not match
# the regular expression.
#
# @example
#   # bad
#   lib/layoutManager.rb
#
#   anything/usingCamelCase
#
#   # good
#   lib/layout_manager.rb
#
#   anything/using_snake_case.rake
class RuboCop::Cop::Naming::FileName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end
  def struct_definition(param0 = T.unsafe(nil)); end

  private

  def allowed_acronyms; end

  # @return [Boolean]
  def bad_filename_allowed?; end

  # @return [Boolean]
  def check_definition_path_hierarchy?; end

  def defined_struct(node); end
  def definition_path_hierarchy_roots; end

  # @return [Boolean]
  def expect_matching_definition?; end

  # @return [Boolean]
  def filename_good?(basename); end

  def find_class_or_module(node, namespace); end
  def find_definition(node); end

  # @yield [source_range(processed_source.buffer, 1, 0), msg]
  def for_bad_filename(file_path); end

  # @return [Boolean]
  def ignore_executable_scripts?; end

  # @return [Boolean]
  def match?(expected); end

  # @return [Boolean]
  def match_acronym?(expected, name); end

  def match_namespace(node, namespace, expected); end

  # @return [Boolean]
  def matching_class?(file_name); end

  # @return [Boolean]
  def matching_definition?(file_path); end

  def no_definition_message(basename, file_path); end
  def other_message(basename); end
  def partial_matcher!(expected); end
  def perform_class_and_module_naming_checks(file_path, basename); end
  def regex; end
  def to_module_name(basename); end
  def to_namespace(path); end
end

RuboCop::Cop::Naming::FileName::MSG_NO_DEFINITION = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::FileName::MSG_REGEX = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::FileName::MSG_SNAKE_CASE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::FileName::SNAKE_CASE = T.let(T.unsafe(nil), Regexp)

# Checks that your heredocs are using the configured case.
# By default it is configured to enforce uppercase heredocs.
#
# @example EnforcedStyle: uppercase (default)
#   # bad
#   <<-sql
#   SELECT * FROM foo
#   sql
#
#   # good
#   <<-SQL
#   SELECT * FROM foo
#   SQL
# @example EnforcedStyle: lowercase
#   # bad
#   <<-SQL
#   SELECT * FROM foo
#   SQL
#
#   # good
#   <<-sql
#   SELECT * FROM foo
#   sql
class RuboCop::Cop::Naming::HeredocDelimiterCase < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_heredoc(node); end

  private

  # @return [Boolean]
  def correct_case_delimiters?(node); end

  def correct_delimiters(source); end
  def message(_node); end
end

RuboCop::Cop::Naming::HeredocDelimiterCase::MSG = T.let(T.unsafe(nil), String)

# Checks that your heredocs are using meaningful delimiters.
# By default it disallows `END` and `EO*`, and can be configured through
# forbidden listing additional delimiters.
#
# @example
#
#   # good
#   <<-SQL
#   SELECT * FROM foo
#   SQL
#
#   # bad
#   <<-END
#   SELECT * FROM foo
#   END
#
#   # bad
#   <<-EOS
#   SELECT * FROM foo
#   EOS
class RuboCop::Cop::Naming::HeredocDelimiterNaming < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc

  def on_heredoc(node); end

  private

  def forbidden_delimiters; end

  # @return [Boolean]
  def meaningful_delimiters?(node); end
end

RuboCop::Cop::Naming::HeredocDelimiterNaming::MSG = T.let(T.unsafe(nil), String)

# This cops recommends the use of inclusive language instead of problematic terms.
# The cop can check the following locations for offenses:
# - identifiers
# - constants
# - variables
# - strings
# - symbols
# - comments
# - file paths
# Each of these locations can be individually enabled/disabled via configuration,
# for example CheckIdentifiers = true/false.
#
# Flagged terms are configurable for the cop. For each flagged term an optional
# Regex can be specified to identify offenses. Suggestions for replacing a flagged term can
# be configured and will be displayed as part of the offense message.
# An AllowedRegex can be specified for a flagged term to exempt allowed uses of the term.
# `WholeWord: true` can be set on a flagged term to indicate the cop should only match when
# a term matches the whole word (partial matches will not be offenses).
#
# @example FlaggedTerms: { whitelist: { Suggestions: ['allowlist'] } }
#   # Suggest replacing identifier whitelist with allowlist
#
#   # bad
#   whitelist_users = %w(user1 user1)
#
#   # good
#   allowlist_users = %w(user1 user2)
# @example FlaggedTerms: { master: { Suggestions: ['main', 'primary', 'leader'] } }
#   # Suggest replacing master in an instance variable name with main, primary, or leader
#
#   # bad
#   @master_node = 'node1.example.com'
#
#   # good
#   @primary_node = 'node1.example.com'
# @example FlaggedTerms: { whitelist: { Regex: !ruby/regexp '/white[-_\s]?list' } }
#   # Identify problematic terms using a Regexp
#
#   # bad
#   white_list = %w(user1 user2)
#
#   # good
#   allow_list = %w(user1 user2)
# @example FlaggedTerms: { master: { AllowedRegex: 'master\'?s degree' } }
#   # Specify allowed uses of the flagged term as a string or regexp.
#
#   # bad
#   # They had a masters
#
#   # good
#   # They had a master's degree
# @example FlaggedTerms: { slave: { WholeWord: true } }
#   # Specify that only terms that are full matches will be flagged.
#
#   # bad
#   Slave
#
#   # good (won't be flagged despite containing `slave`)
#   TeslaVehicle
class RuboCop::Cop::Naming::InclusiveLanguage < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  # @return [InclusiveLanguage] a new instance of InclusiveLanguage
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  def on_new_investigation; end

  private

  def add_offenses_for_token(token, word_locations); end
  def add_to_flagged_term_hash(regex_string, term, term_definition); end
  def array_to_ignorecase_regex(strings); end

  # @return [Boolean]
  def check_token?(type); end

  def create_message(word, message = T.unsafe(nil)); end
  def create_multiple_word_message_for_file(words); end
  def create_single_word_message_for_file(word); end
  def ensure_regex_string(regex); end
  def extract_regexp(term, term_definition); end
  def find_flagged_term(word); end
  def format_suggestions(suggestions); end
  def investigate_filepath; end
  def investigate_tokens; end
  def mask_input(str); end
  def preprocess_check_config; end
  def preprocess_flagged_terms; end
  def preprocess_suggestions(suggestions); end
  def process_allowed_regex(allowed); end
  def scan_for_words(input); end
  def set_regexes(flagged_term_strings, allowed_strings); end
end

RuboCop::Cop::Naming::InclusiveLanguage::EMPTY_ARRAY = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Naming::InclusiveLanguage::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::InclusiveLanguage::MSG_FOR_FILE_PATH = T.let(T.unsafe(nil), String)

class RuboCop::Cop::Naming::InclusiveLanguage::WordLocation < ::Struct
  # Returns the value of attribute position
  #
  # @return [Object] the current value of position
  def position; end

  # Sets the attribute position
  #
  # @param value [Object] the value to set the attribute position to.
  # @return [Object] the newly set value
  def position=(_); end

  # Returns the value of attribute word
  #
  # @return [Object] the current value of word
  def word; end

  # Sets the attribute word
  #
  # @param value [Object] the value to set the attribute word to.
  # @return [Object] the newly set value
  def word=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Checks for memoized methods whose instance variable name
# does not match the method name. Applies to both regular methods
# (defined with `def`) and dynamic methods (defined with
# `define_method` or `define_singleton_method`).
#
# This cop can be configured with the EnforcedStyleForLeadingUnderscores
# directive. It can be configured to allow for memoized instance variables
# prefixed with an underscore. Prefixing ivars with an underscore is a
# convention that is used to implicitly indicate that an ivar should not
# be set or referenced outside of the memoization method.
#
# @example EnforcedStyleForLeadingUnderscores: disallowed (default)
#   # bad
#   # Method foo is memoized using an instance variable that is
#   # not `@foo`. This can cause confusion and bugs.
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @something if defined?(@something)
#   @something = calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= begin
#   calculate_expensive_thing
#   end
#   end
#
#   # good
#   def foo
#   helper_variable = something_we_need_to_calculate_foo
#   @foo ||= calculate_expensive_thing(helper_variable)
#   end
#
#   # good
#   define_method(:foo) do
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   return @foo if defined?(@foo)
#   @foo = calculate_expensive_thing
#   end
# @example EnforcedStyleForLeadingUnderscores: required
#   # bad
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   # bad
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @foo if defined?(@foo)
#   @foo = calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   def foo
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
# @example EnforcedStyleForLeadingUnderscores :optional
#   # bad
#   def foo
#   @something ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def _foo
#   @_foo ||= calculate_expensive_thing
#   end
#
#   # good
#   def foo
#   return @_foo if defined?(@_foo)
#   @_foo = calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @foo ||= calculate_expensive_thing
#   end
#
#   # good
#   define_method(:foo) do
#   @_foo ||= calculate_expensive_thing
#   end
class RuboCop::Cop::Naming::MemoizedInstanceVariableName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def defined_memoized?(param0 = T.unsafe(nil), param1); end
  def method_definition?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  def on_defined?(node); end

  def on_or_asgn(node); end

  private

  def find_definition(node); end

  # @return [Boolean]
  def matches?(method_name, ivar_assign); end

  def message(variable); end
  def style_parameter_name; end
  def suggested_var(method_name); end
  def variable_name_candidates(method_name); end
end

RuboCop::Cop::Naming::MemoizedInstanceVariableName::DYNAMIC_DEFINE_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Naming::MemoizedInstanceVariableName::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Naming::MemoizedInstanceVariableName::UNDERSCORE_REQUIRED = T.let(T.unsafe(nil), String)

# Makes sure that all methods use the configured style,
# snake_case or camelCase, for their names.
#
# This cop has `AllowedPatterns` configuration option.
#
#   Naming/MethodName:
#     AllowedPatterns:
#       - '\A\s*onSelectionBulkChange\s*'
#       - '\A\s*onSelectionCleared\s*'
#
# Method names matching patterns are always allowed.
#
# @example EnforcedStyle: snake_case (default)
#   # bad
#   def fooBar; end
#
#   # good
#   def foo_bar; end
# @example EnforcedStyle: camelCase
#   # bad
#   def foo_bar; end
#
#   # good
#   def fooBar; end
class RuboCop::Cop::Naming::MethodName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp

  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end
  def str_name(param0 = T.unsafe(nil)); end
  def sym_name(param0 = T.unsafe(nil)); end

  private

  def attr_name(name_item); end
  def message(style); end
  def range_position(node); end
end

RuboCop::Cop::Naming::MethodName::MSG = T.let(T.unsafe(nil), String)

# Checks method parameter names for how descriptive they
# are. It is highly configurable.
#
# The `MinNameLength` config option takes an integer. It represents
# the minimum amount of characters the name must be. Its default is 3.
# The `AllowNamesEndingInNumbers` config option takes a boolean. When
# set to false, this cop will register offenses for names ending with
# numbers. Its default is false. The `AllowedNames` config option
# takes an array of permitted names that will never register an
# offense. The `ForbiddenNames` config option takes an array of
# restricted names that will always register an offense.
#
# @example
#   # bad
#   def bar(varOne, varTwo)
#   varOne + varTwo
#   end
#
#   # With `AllowNamesEndingInNumbers` set to false
#   def foo(num1, num2)
#   num1 * num2
#   end
#
#   # With `MinNameLength` set to number greater than 1
#   def baz(a, b, c)
#   do_stuff(a, b, c)
#   end
#
#   # good
#   def bar(thud, fred)
#   thud + fred
#   end
#
#   def foo(speed, distance)
#   speed * distance
#   end
#
#   def baz(age_a, height_b, gender_c)
#   do_stuff(age_a, height_b, gender_c)
#   end
class RuboCop::Cop::Naming::MethodParameterName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::UncommunicativeName

  def on_def(node); end
  def on_defs(node); end
end

# Checks that predicate methods names end with a question mark and
# do not start with a forbidden prefix.
#
# A method is determined to be a predicate method if its name starts
# with one of the prefixes defined in the `NamePrefix` configuration.
# You can change what prefixes are considered by changing this option.
# Any method name that starts with one of these prefixes is required by
# the cop to end with a `?`. Other methods can be allowed by adding to
# the `AllowedMethods` configuration.
#
# NOTE: The `is_a?` method is allowed by default.
#
# If `ForbiddenPrefixes` is set, methods that start with the configured
# prefixes will not be allowed and will be removed by autocorrection.
#
# In other words, if `ForbiddenPrefixes` is empty, a method named `is_foo`
# will register an offense only due to the lack of question mark (and will be
# autocorrected to `is_foo?`). If `ForbiddenPrefixes` contains `is_`,
# `is_foo` will register an offense both because the ? is missing and because of
# the `is_` prefix, and will be corrected to `foo?`.
#
# NOTE: `ForbiddenPrefixes` is only applied to prefixes in `NamePrefix`;
# a prefix in the former but not the latter will not be considered by
# this cop.
#
# @example
#   # bad
#   def is_even(value)
#   end
#
#   def is_even?(value)
#   end
#
#   # good
#   def even?(value)
#   end
#
#   # bad
#   def has_value
#   end
#
#   def has_value?
#   end
#
#   # good
#   def value?
#   end
# @example AllowedMethods: ['is_a?'] (default)
#   # good
#   def is_a?(value)
#   end
class RuboCop::Cop::Naming::PredicateName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods

  def dynamic_method_define(param0 = T.unsafe(nil)); end
  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_method_name?(method_name, prefix); end

  def expected_name(method_name, prefix); end
  def forbidden_prefixes; end
  def message(method_name, new_name); end
  def method_definition_macros(macro_name); end
  def predicate_prefixes; end
end

# Makes sure that rescued exceptions variables are named as
# expected.
#
# The `PreferredName` config option takes a `String`. It represents
# the required name of the variable. Its default is `e`.
#
# NOTE: This cop does not consider nested rescues because it cannot
# guarantee that the variable from the outer rescue is not used within
# the inner rescue (in which case, changing the inner variable would
# shadow the outer variable).
#
# @example PreferredName: e (default)
#   # bad
#   begin
#   # do something
#   rescue MyException => exception
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => e
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => _e
#   # do something
#   end
# @example PreferredName: exception
#   # bad
#   begin
#   # do something
#   rescue MyException => e
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => exception
#   # do something
#   end
#
#   # good
#   begin
#   # do something
#   rescue MyException => _exception
#   # do something
#   end
class RuboCop::Cop::Naming::RescuedExceptionsVariableName < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_resbody(node); end

  private

  def correct_node(corrector, node, offending_name, preferred_name); end

  # If the exception variable is reassigned, that assignment needs to be corrected.
  # Further `lvar` nodes will not be corrected though since they now refer to a
  # different variable.
  def correct_reassignment(corrector, node, offending_name, preferred_name); end

  def message(node); end
  def offense_range(resbody); end
  def preferred_name(variable_name); end

  # @return [Boolean]
  def shadowed_variable_name?(node); end

  def variable_name(node); end

  # @return [Boolean]
  def variable_name_matches?(node, name); end
end

RuboCop::Cop::Naming::RescuedExceptionsVariableName::MSG = T.let(T.unsafe(nil), String)

# Makes sure that all variables use the configured style,
# snake_case or camelCase, for their names.
#
# @example EnforcedStyle: snake_case (default)
#   # bad
#   fooBar = 1
#
#   # good
#   foo_bar = 1
# @example EnforcedStyle: camelCase
#   # bad
#   foo_bar = 1
#
#   # good
#   fooBar = 1
# @example AllowedPatterns: ['_v\d+\z']
#   # good
#   :release_v1
class RuboCop::Cop::Naming::VariableName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedIdentifiers
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNaming
  include ::RuboCop::Cop::AllowedPattern

  def on_arg(node); end
  def on_blockarg(node); end
  def on_cvasgn(node); end
  def on_ivasgn(node); end
  def on_kwarg(node); end
  def on_kwoptarg(node); end
  def on_kwrestarg(node); end
  def on_lvar(node); end
  def on_lvasgn(node); end
  def on_optarg(node); end
  def on_restarg(node); end

  # @return [Boolean]
  def valid_name?(node, name, given_style = T.unsafe(nil)); end

  private

  def message(style); end
end

RuboCop::Cop::Naming::VariableName::MSG = T.let(T.unsafe(nil), String)

# Makes sure that all numbered variables use the
# configured style, snake_case, normalcase, or non_integer,
# for their numbering.
#
# Additionally, `CheckMethodNames` and `CheckSymbols` configuration options
# can be used to specify whether method names and symbols should be checked.
# Both are enabled by default.
#
# @example AllowedPatterns: ['_v\d+\z']
#   # good
#   :some_sym_v1
# @example EnforcedStyle: snake_case
#   # bad
#   :some_sym1
#   variable1 = 1
#
#   def some_method1; end
#
#   def some_method_1(arg1); end
#
#   # good
#   :some_sym_1
#   variable_1 = 1
#
#   def some_method_1; end
#
#   def some_method_1(arg_1); end
# @example EnforcedStyle: non_integer
#   # bad
#   :some_sym1
#   :some_sym_1
#
#   variable1 = 1
#   variable_1 = 1
#
#   def some_method1; end
#
#   def some_method_1; end
#
#   def some_methodone(arg1); end
#   def some_methodone(arg_1); end
#
#   # good
#   :some_symone
#   :some_sym_one
#
#   variableone = 1
#   variable_one = 1
#
#   def some_methodone; end
#
#   def some_method_one; end
#
#   def some_methodone(argone); end
#   def some_methodone(arg_one); end
#
#   # In the following examples, we assume `EnforcedStyle: normalcase` (default).
# @example CheckMethodNames: true (default)
#   # bad
#   def some_method_1; end
# @example CheckMethodNames: false
#   # good
#   def some_method_1; end
# @example CheckSymbols: true (default)
#   # bad
#   :some_sym_1
# @example CheckSymbols: false
#   # good
#   :some_sym_1
# @example AllowedIdentifiers: [capture3]
#   # good
#   expect(Open3).to receive(:capture3)
# @example EnforcedStyle: normalcase (default)
#   # bad
#   :some_sym_1
#   variable_1 = 1
#
#   def some_method_1; end
#
#   def some_method1(arg_1); end
#
#   # good
#   :some_sym1
#   variable1 = 1
#
#   def some_method1; end
#
#   def some_method1(arg1); end
class RuboCop::Cop::Naming::VariableNumber < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedIdentifiers
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::ConfigurableFormatting
  include ::RuboCop::Cop::ConfigurableNumbering
  include ::RuboCop::Cop::AllowedPattern

  def on_arg(node); end
  def on_cvasgn(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_sym(node); end

  # @return [Boolean]
  def valid_name?(node, name, given_style = T.unsafe(nil)); end

  private

  def message(style); end
end

RuboCop::Cop::Naming::VariableNumber::MSG = T.let(T.unsafe(nil), String)

# Some common code shared between `NegatedIf` and
# `NegatedWhile` cops.
module RuboCop::Cop::NegativeConditional
  extend ::RuboCop::AST::NodePattern::Macros

  def empty_condition?(param0 = T.unsafe(nil)); end
  def single_negative?(param0 = T.unsafe(nil)); end

  private

  def check_negative_conditional(node, message:, &block); end
end

RuboCop::Cop::NegativeConditional::MSG = T.let(T.unsafe(nil), String)

# This module provides a list of methods that are:
# 1. In the NilClass by default
# 2. Added to NilClass by explicitly requiring any standard libraries
# 3. Cop's configuration parameter AllowedMethods.
module RuboCop::Cop::NilMethods
  include ::RuboCop::Cop::AllowedMethods

  private

  def nil_methods; end
  def other_stdlib_methods; end
end

# An offense represents a style violation detected by RuboCop.
class RuboCop::Cop::Offense
  include ::Comparable

  # @api private
  # @return [Offense] a new instance of Offense
  def initialize(severity, location, message, cop_name, status = T.unsafe(nil), corrector = T.unsafe(nil)); end

  # Returns `-1`, `0`, or `+1`
  # if this offense is less than, equal to, or greater than `other`.
  #
  # @api public
  # @return [Integer] comparison result
  def <=>(other); end

  # @api public
  # @return [Boolean] returns `true` if two offenses contain same attributes
  def ==(other); end

  # @api private
  def column; end

  # @api private
  def column_length; end

  # @api private
  def column_range; end

  # @api public
  # @example
  #   'LineLength'
  # @return [String] a cop class name without department.
  #   i.e. type of the violation.
  def cop_name; end

  # @api public
  # @return [Boolean] whether this offense can be automatically corrected via
  #   autocorrect or a todo.
  def correctable?; end

  # @api public
  # @return [Boolean] whether this offense is automatically corrected via
  #   autocorrect or a todo.
  def corrected?; end

  # @api public
  # @return [Boolean] whether this offense is automatically disabled via a todo.
  def corrected_with_todo?; end

  # @api public
  # @return [Corrector | nil] the autocorrection for this offense, or `nil` when not available
  def corrector; end

  # @api public
  # @return [Boolean] whether this offense was locally disabled with a
  #   disable or todo where it occurred.
  def disabled?; end

  # @api public
  # @return [Boolean] returns `true` if two offenses contain same attributes
  def eql?(other); end

  # @api private
  def first_line; end

  def hash; end

  # @api public
  # @return [Parser::Source::Range] the range of the code that is highlighted
  def highlighted_area; end

  # @api private
  def last_column; end

  # @api private
  def last_line; end

  # @api private
  def line; end

  # @api public
  # @return [Parser::Source::Range] the location where the violation is detected.
  # @see https://www.rubydoc.info/gems/parser/Parser/Source/Range Parser::Source::Range
  def location; end

  # @api public
  # @example
  #   'Line is too long. [90/80]'
  # @return [String] human-readable message
  def message; end

  # Internally we use column number that start at 0, but when
  # outputting column numbers, we want them to start at 1. One
  # reason is that editors, such as Emacs, expect this.
  #
  # @api private
  def real_column; end

  # @api public
  # @return [RuboCop::Cop::Severity]
  def severity; end

  # @api private
  def source_line; end

  # @api private
  def status; end

  # This is just for debugging purpose.
  #
  # @api private
  def to_s; end
end

# @api private
RuboCop::Cop::Offense::COMPARISON_ATTRIBUTES = T.let(T.unsafe(nil), Array)

RuboCop::Cop::Offense::NO_LOCATION = T.let(T.unsafe(nil), RuboCop::Cop::Offense::PseudoSourceRange)

class RuboCop::Cop::Offense::PseudoSourceRange < ::Struct
  # Returns the value of attribute begin_pos
  #
  # @return [Object] the current value of begin_pos
  def begin_pos; end

  # Sets the attribute begin_pos
  #
  # @param value [Object] the value to set the attribute begin_pos to.
  # @return [Object] the newly set value
  def begin_pos=(_); end

  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def column; end

  # Sets the attribute column
  #
  # @param value [Object] the value to set the attribute column to.
  # @return [Object] the newly set value
  def column=(_); end

  def column_range; end

  # Returns the value of attribute end_pos
  #
  # @return [Object] the current value of end_pos
  def end_pos; end

  # Sets the attribute end_pos
  #
  # @param value [Object] the value to set the attribute end_pos to.
  # @return [Object] the newly set value
  def end_pos=(_); end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def first_line; end

  # Returns the value of attribute column
  #
  # @return [Object] the current value of column
  def last_column; end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def last_line; end

  def length; end

  # Returns the value of attribute line
  #
  # @return [Object] the current value of line
  def line; end

  # Sets the attribute line
  #
  # @param value [Object] the value to set the attribute line to.
  # @return [Object] the newly set value
  def line=(_); end

  def size; end

  # Returns the value of attribute source_line
  #
  # @return [Object] the current value of source_line
  def source_line; end

  # Sets the attribute source_line
  #
  # @param value [Object] the value to set the attribute source_line to.
  # @return [Object] the newly set value
  def source_line=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Common functionality for cops checking if and unless expressions.
module RuboCop::Cop::OnNormalIfUnless
  def on_if(node); end
end

# This autocorrects gem dependency order
class RuboCop::Cop::OrderedGemCorrector
  extend ::RuboCop::Cop::OrderedGemNode
  extend ::RuboCop::Cop::RangeHelp

  class << self
    # Returns the value of attribute comments_as_separators.
    def comments_as_separators; end

    def correct(processed_source, node, previous_declaration, comments_as_separators); end

    # Returns the value of attribute processed_source.
    def processed_source; end

    private

    def declaration_with_comment(node); end
    def swap_range(corrector, range1, range2); end
  end
end

# Common functionality for Bundler/OrderedGems and
# Gemspec/OrderedDependencies.
module RuboCop::Cop::OrderedGemNode
  private

  # @return [Boolean]
  def case_insensitive_out_of_order?(string_a, string_b); end

  def consecutive_lines(previous, current); end
  def find_gem_name(gem_node); end
  def gem_canonical_name(name); end
  def gem_name(declaration_node); end
  def get_source_range(node, comments_as_separators); end
  def register_offense(previous, current); end
  def treat_comments_as_separators; end
end

# Common functionality for handling parentheses.
module RuboCop::Cop::Parentheses
  private

  # @return [Boolean]
  def parens_required?(node); end
end

# This autocorrects parentheses
class RuboCop::Cop::ParenthesesCorrector
  extend ::RuboCop::Cop::RangeHelp

  class << self
    def correct(corrector, node); end

    private

    # Add a comma back after the heredoc identifier
    def add_heredoc_comma(corrector, node); end

    # If the node contains a heredoc, remove the comma too
    # It'll be added back in the right place later
    def extend_range_for_heredoc(node, range); end

    # If removing parentheses leaves a comma on its own line, remove all the whitespace
    # preceding it to prevent a syntax error.
    def handle_orphaned_comma(corrector, node); end

    # @return [Boolean]
    def heredoc?(node); end

    # @return [Boolean]
    def next_char_is_question_mark?(node); end

    # @return [Boolean]
    def only_closing_paren_before_comma?(node); end

    # Get a range for the closing parenthesis and all whitespace to the left of it
    def parens_range(node); end

    # @return [Boolean]
    def ternary_condition?(node); end
  end
end

# Common functionality for handling percent arrays.
module RuboCop::Cop::PercentArray
  private

  # @return [Boolean]
  def allowed_bracket_array?(node); end

  # @param node [RuboCop::AST::ArrayNode]
  # @param elements [Array<String>]
  # @return [String]
  def build_bracketed_array_with_appropriate_whitespace(elements:, node:); end

  # @param preferred_array_code [String]
  # @return [String]
  def build_message_for_bracketed_array(preferred_array_code); end

  def check_bracketed_array(node, literal_prefix); end
  def check_percent_array(node); end

  # @return [Boolean]
  def comments_in_array?(node); end

  # Override to determine values that are invalid in a percent array
  #
  # @return [Boolean]
  def invalid_percent_array_contents?(_node); end

  # Ruby does not allow percent arrays in an ambiguous block context.
  #
  # @example
  #
  #   foo %i[bar baz] { qux }
  # @return [Boolean]
  def invalid_percent_array_context?(node); end

  # Provides whitespace between elements for building a bracketed array.
  #   %w[  a   b   c    ]
  #         ^^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  def whitespace_between(node); end

  # Provides leading whitespace for building a bracketed array.
  #   %w[  a   b   c    ]
  #      ^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  def whitespace_leading(node); end

  # Provides trailing whitespace for building a bracketed array.
  #   %w[  a   b   c    ]
  #                 ^^^^
  #
  # @param node [RuboCop::AST::ArrayNode]
  # @return [String]
  def whitespace_trailing(node); end
end

# Common functionality for handling percent literals.
module RuboCop::Cop::PercentLiteral
  include ::RuboCop::Cop::RangeHelp

  private

  def begin_source(node); end

  # @return [Boolean]
  def percent_literal?(node); end

  def process(node, *types); end
  def type(node); end
end

# This autocorrects percent literals
class RuboCop::Cop::PercentLiteralCorrector
  include ::RuboCop::PathUtil
  include ::RuboCop::Cop::Util

  # @return [PercentLiteralCorrector] a new instance of PercentLiteralCorrector
  def initialize(config, preferred_delimiters); end

  # Returns the value of attribute config.
  def config; end

  def correct(corrector, node, char); end

  # Returns the value of attribute preferred_delimiters.
  def preferred_delimiters; end

  private

  def autocorrect_multiline_words(node, escape, delimiters); end
  def autocorrect_words(node, escape, delimiters); end
  def delimiters_for(type); end
  def end_content(source); end

  # @return [Boolean]
  def escape_words?(node); end

  # @return [Boolean]
  def first_line?(node, previous_line_num); end

  def fix_escaped_content(word_node, escape, delimiters); end
  def line_breaks(node, source, previous_line_num, base_line_num, node_indx); end
  def new_contents(node, escape, delimiters); end
  def process_lines(node, previous_line_num, base_line_num, source_in_lines); end
  def process_multiline_words(node, escape, delimiters); end
  def substitute_escaped_delimiters(content, delimiters); end
  def wrap_contents(corrector, node, contents, char, delimiters); end
end

# Common functionality for checking whether an AST node/token is aligned
# with something on a preceding or following line
module RuboCop::Cop::PrecedingFollowingAlignment
  private

  # @return [Boolean]
  def aligned_assignment?(range, line); end

  # @return [Boolean]
  def aligned_char?(range, line); end

  def aligned_comment_lines; end

  # @return [Boolean]
  def aligned_identical?(range, line); end

  # @return [Boolean]
  def aligned_operator?(range, line); end

  # @return [Boolean]
  def aligned_token?(range, line); end

  # @return [Boolean]
  def aligned_with_adjacent_line?(range, predicate); end

  # @return [Boolean]
  def aligned_with_any_line?(line_ranges, range, indent = T.unsafe(nil), &predicate); end

  # @return [Boolean]
  def aligned_with_any_line_range?(line_ranges, range, &predicate); end

  # @return [Boolean]
  def aligned_with_append_operator?(range, line); end

  def aligned_with_assignment(token, line_range); end

  # @return [Boolean]
  def aligned_with_line?(line_nos, range, indent = T.unsafe(nil)); end

  # @return [Boolean]
  def aligned_with_operator?(range); end

  def aligned_with_preceding_assignment(token); end

  # @return [Boolean]
  def aligned_with_something?(range); end

  def aligned_with_subsequent_assignment(token); end

  # @return [Boolean]
  def aligned_words?(range, line); end

  # @return [Boolean]
  def allow_for_alignment?; end

  def assignment_lines; end
  def assignment_tokens; end
  def relevant_assignment_lines(line_range); end
  def remove_optarg_equals(asgn_tokens, processed_source); end
end

# Common functionality for handling percent literal delimiters.
class RuboCop::Cop::PreferredDelimiters
  # @return [PreferredDelimiters] a new instance of PreferredDelimiters
  def initialize(type, config, preferred_delimiters); end

  # Returns the value of attribute config.
  def config; end

  def delimiters; end

  # Returns the value of attribute type.
  def type; end

  private

  # @raise [ArgumentError]
  def ensure_valid_preferred_delimiters; end

  def preferred_delimiters; end
  def preferred_delimiters_config; end
end

RuboCop::Cop::PreferredDelimiters::PERCENT_LITERAL_TYPES = T.let(T.unsafe(nil), Array)

# This autocorrects punctuation
class RuboCop::Cop::PunctuationCorrector
  class << self
    def add_space(corrector, token); end
    def remove_space(corrector, space_before); end
    def swap_comma(corrector, range); end
  end
end

# Methods that calculate and return Parser::Source::Ranges
module RuboCop::Cop::RangeHelp
  private

  def column_offset_between(base_range, range); end

  # A range containing only the contents of a literal with delimiters (e.g. in
  # `%i{1 2 3}` this will be the range covering `1 2 3` only).
  def contents_range(node); end

  def directions(side); end

  # Returns the column attribute of the range, except if the range is on
  # the first line and there's a byte order mark at the beginning of that
  # line, in which case 1 is subtracted from the column value. This gives
  # the column as it appears when viewing the file in an editor.
  def effective_column(range); end

  def final_pos(src, pos, increment, continuations, newlines, whitespace); end
  def move_pos(src, pos, step, condition, regexp); end
  def move_pos_str(src, pos, step, condition, needle); end
  def range_between(start_pos, end_pos); end
  def range_by_whole_lines(range, include_final_newline: T.unsafe(nil), buffer: T.unsafe(nil)); end
  def range_with_surrounding_comma(range, side = T.unsafe(nil)); end
  def range_with_surrounding_space(range_positional = T.unsafe(nil), range: T.unsafe(nil), side: T.unsafe(nil), newlines: T.unsafe(nil), whitespace: T.unsafe(nil), continuations: T.unsafe(nil), buffer: T.unsafe(nil)); end
  def source_range(source_buffer, line_number, column, length = T.unsafe(nil)); end
end

# The Unicode codepoint
RuboCop::Cop::RangeHelp::BYTE_ORDER_MARK = T.let(T.unsafe(nil), Integer)

module RuboCop::Cop::RangeHelp::NOT_GIVEN; end

# Common functionality for handling Rational literals.
module RuboCop::Cop::RationalLiteral
  extend ::RuboCop::AST::NodePattern::Macros

  def rational_literal?(param0 = T.unsafe(nil)); end
end

# Registry that tracks all cops by their badge and department.
class RuboCop::Cop::Registry
  include ::Enumerable

  # @return [Registry] a new instance of Registry
  def initialize(cops = T.unsafe(nil), options = T.unsafe(nil)); end

  def ==(other); end

  # @return [Boolean]
  def contains_cop_matching?(names); end

  def cops; end

  # @return [Boolean] Checks if given name is department
  def department?(name); end

  # @return [Boolean]
  def department_missing?(badge, name); end

  # @return [Array<Symbol>] list of departments for current cops.
  def departments; end

  def dismiss(cop); end
  def each(&block); end
  def enabled(config, only = T.unsafe(nil), only_safe: T.unsafe(nil)); end

  # @return [Boolean]
  def enabled?(cop, config, only_safe); end

  # @return [Boolean]
  def enabled_pending_cop?(cop_cfg, config); end

  def enlist(cop); end

  # @param cop_name [String]
  # @return [Class, nil]
  def find_by_cop_name(cop_name); end

  def freeze; end
  def length; end
  def names; end
  def names_for_department(department); end

  # Returns the value of attribute options.
  def options; end

  def print_warning(name, path); end

  # Convert a user provided cop name into a properly namespaced name
  #
  # @example gives back a correctly qualified cop name
  #
  #   cops = RuboCop::Cop::Cop.all
  #   cops.
  #   qualified_cop_name('Layout/EndOfLine') # => 'Layout/EndOfLine'
  # @example fixes incorrect namespaces
  #
  #   cops = RuboCop::Cop::Cop.all
  #   cops.qualified_cop_name('Lint/EndOfLine') # => 'Layout/EndOfLine'
  # @example namespaces bare cop identifiers
  #
  #   cops = RuboCop::Cop::Cop.all
  #   cops.qualified_cop_name('EndOfLine') # => 'Layout/EndOfLine'
  # @example passes back unrecognized cop names
  #
  #   cops = RuboCop::Cop::Cop.all
  #   cops.qualified_cop_name('NotACop') # => 'NotACop'
  # @note Emits a warning if the provided name has an incorrect namespace
  # @param name [String] Cop name extracted from config
  # @param path [String, nil] Path of file that `name` was extracted from
  # @raise [AmbiguousCopName] if a bare identifier with two possible namespaces is provided
  # @return [String] Qualified cop name
  def qualified_cop_name(name, path, warn: T.unsafe(nil)); end

  def select(&block); end
  def sort!; end

  # @return [Hash{String => Array<Class>}]
  def to_h; end

  def unqualified_cop_names; end

  # @return [Registry] Cops for that specific department.
  def with_department(department); end

  # @return [Registry] Cops not for a specific department.
  def without_department(department); end

  private

  def clear_enrollment_queue; end
  def initialize_copy(reg); end
  def qualify_badge(badge); end

  # @return [Boolean]
  def registered?(badge); end

  def resolve_badge(given_badge, real_badge, source_path); end
  def with(cops); end

  class << self
    def all; end

    # Returns the value of attribute global.
    def global; end

    def qualified_cop_name(name, origin); end
    def reset!; end

    # Changes momentarily the global registry
    # Intended for testing purposes
    def with_temporary_global(temp_global = T.unsafe(nil)); end
  end
end

# Ensure a require statement is present for a standard library determined
# by variable library_name
module RuboCop::Cop::RequireLibrary
  extend ::RuboCop::AST::NodePattern::Macros

  def ensure_required(corrector, node, library_name); end
  def on_send(node); end
  def remove_subsequent_requires(corrector, node, library_name); end
  def require_any_library?(param0 = T.unsafe(nil)); end
  def require_library_name?(param0 = T.unsafe(nil), param1); end

  private

  def on_new_investigation; end
end

# This class ensures a require statement is present for a standard library
# determined by the variable library_name
class RuboCop::Cop::RequireLibraryCorrector
  extend ::RuboCop::Cop::RangeHelp

  class << self
    def correct(corrector, node, library_name); end
    def require_statement(library_name); end
  end
end

# Common functionality for checking `rescue` nodes.
module RuboCop::Cop::RescueNode
  def on_new_investigation; end

  private

  # @return [Boolean]
  def rescue_modifier?(node); end

  # @deprecated Use ResbodyNode#exceptions instead
  def rescued_exceptions(resbody); end
end

# Common functionality for safe assignment. By safe assignment we mean
# putting parentheses around an assignment to indicate "I know I'm using an
# assignment as a condition. It's not a mistake."
module RuboCop::Cop::SafeAssignment
  extend ::RuboCop::AST::NodePattern::Macros

  def empty_condition?(param0 = T.unsafe(nil)); end
  def safe_assignment?(param0 = T.unsafe(nil)); end
  def setter_method?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def safe_assignment_allowed?; end
end

module RuboCop::Cop::Security; end

# Checks for implementations of the `hash` method which combine
# values using custom logic instead of delegating to `Array#hash`.
#
# Manually combining hashes is error prone and hard to follow, especially
# when there are many values. Poor implementations may also introduce
# performance or security concerns if they are prone to collisions.
# Delegating to `Array#hash` is clearer, faster, and safer.
#
# @example
#
#   # bad
#   def hash
#   @foo ^ @bar
#   end
#
#   # good
#   def hash
#   [@foo, @bar].hash
#   end
class RuboCop::Cop::Security::CompoundHash < ::RuboCop::Cop::Base
  def bad_hash_combinator?(param0 = T.unsafe(nil)); end

  # @return [Boolean]
  def contained_in_hash_method?(node, &block); end

  def dynamic_hash_method_definition?(param0 = T.unsafe(nil)); end
  def hash_method_definition?(param0 = T.unsafe(nil)); end
  def monuple_hash?(param0 = T.unsafe(nil)); end
  def on_op_asgn(node); end
  def on_send(node); end

  # @return [Boolean]
  def outer_bad_hash_combinator?(node); end

  def redundant_hash?(param0 = T.unsafe(nil)); end
  def static_hash_method_definition?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Security::CompoundHash::COMBINATOR_IN_HASH_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::CompoundHash::MONUPLE_HASH_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::CompoundHash::REDUNDANT_HASH_MSG = T.let(T.unsafe(nil), String)

# Checks for the use of `Kernel#eval` and `Binding#eval`.
#
# @example
#
#   # bad
#
#   eval(something)
#   binding.eval(something)
class RuboCop::Cop::Security::Eval < ::RuboCop::Cop::Base
  def eval?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Security::Eval::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::Eval::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the first argument to `IO.read`, `IO.binread`, `IO.write`, `IO.binwrite`,
# `IO.foreach`, and `IO.readlines`.
#
# If argument starts with a pipe character (`'|'`) and the receiver is the `IO` class,
# a subprocess is created in the same way as `Kernel#open`, and its output is returned.
# `Kernel#open` may allow unintentional command injection, which is the reason these
# `IO` methods are a security risk.
# Consider to use `File.read` to disable the behavior of subprocess invocation.
#
# @example
#
#   # bad
#   IO.read(path)
#   IO.read('path')
#
#   # good
#   File.read(path)
#   File.read('path')
#   IO.read('| command') # Allow intentional command invocation.
class RuboCop::Cop::Security::IoMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
end

RuboCop::Cop::Security::IoMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::IoMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of JSON class methods which have potential
# security issues.
#
# @example
#   # bad
#   JSON.load("{}")
#   JSON.restore("{}")
#
#   # good
#   JSON.parse("{}")
class RuboCop::Cop::Security::JSONLoad < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def json_load(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Security::JSONLoad::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::JSONLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of Marshal class methods which have
# potential security issues leading to remote code execution when
# loading from an untrusted source.
#
# @example
#   # bad
#   Marshal.load("{}")
#   Marshal.restore("{}")
#
#   # good
#   Marshal.dump("{}")
#
#   # okish - deep copy hack
#   Marshal.load(Marshal.dump({}))
class RuboCop::Cop::Security::MarshalLoad < ::RuboCop::Cop::Base
  def marshal_load(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Security::MarshalLoad::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::MarshalLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of `Kernel#open` and `URI.open` with dynamic
# data.
#
# `Kernel#open` and `URI.open` enable not only file access but also process
# invocation by prefixing a pipe symbol (e.g., `open("| ls")`).
# So, it may lead to a serious security risk by using variable input to
# the argument of `Kernel#open` and `URI.open`. It would be better to use
# `File.open`, `IO.popen` or `URI.parse#open` explicitly.
#
# NOTE: `open` and `URI.open` with literal strings are not flagged by this
# cop.
#
# @example
#   # bad
#   open(something)
#   open("| #{something}")
#   URI.open(something)
#
#   # good
#   File.open(something)
#   IO.popen(something)
#   URI.parse(something).open
#
#   # good (literal strings)
#   open("foo.text")
#   open("| foo")
#   URI.open("http://example.com")
class RuboCop::Cop::Security::Open < ::RuboCop::Cop::Base
  def on_send(node); end
  def open?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def composite_string?(node); end

  # @return [Boolean]
  def concatenated_string?(node); end

  # @return [Boolean]
  def interpolated_string?(node); end

  # @return [Boolean]
  def safe?(node); end

  # @return [Boolean]
  def safe_argument?(argument); end

  # @return [Boolean]
  def simple_string?(node); end
end

RuboCop::Cop::Security::Open::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::Open::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of YAML class methods which have
# potential security issues leading to remote code execution when
# loading from an untrusted source.
#
# NOTE: Ruby 3.1+ (Psych 4) uses `Psych.load` as `Psych.safe_load` by default.
#
# @example
#   # bad
#   YAML.load("--- !ruby/object:Foo {}") # Psych 3 is unsafe by default
#
#   # good
#   YAML.safe_load("--- !ruby/object:Foo {}", [Foo])                    # Ruby 2.5  (Psych 3)
#   YAML.safe_load("--- !ruby/object:Foo {}", permitted_classes: [Foo]) # Ruby 3.0- (Psych 3)
#   YAML.load("--- !ruby/object:Foo {}", permitted_classes: [Foo])      # Ruby 3.1+ (Psych 4)
#   YAML.dump(foo)
class RuboCop::Cop::Security::YAMLLoad < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def yaml_load(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Security::YAMLLoad::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Security::YAMLLoad::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Severity class is simple value object about severity
class RuboCop::Cop::Severity
  include ::Comparable

  # @api private
  # @raise [ArgumentError]
  # @return [Severity] a new instance of Severity
  def initialize(name_or_code); end

  def <=>(other); end
  def ==(other); end
  def code; end
  def hash; end
  def level; end

  # @api public
  # @return [Symbol] severity.
  #   any of `:info`, `:refactor`, `:convention`, `:warning`, `:error` or `:fatal`.
  def name; end

  def to_s; end

  class << self
    def name_from_code(code); end
  end
end

# @api private
RuboCop::Cop::Severity::CODE_TABLE = T.let(T.unsafe(nil), Hash)

RuboCop::Cop::Severity::NAMES = T.let(T.unsafe(nil), Array)

# Common functionality for cops checking for missing space after
# punctuation.
module RuboCop::Cop::SpaceAfterPunctuation
  def on_new_investigation; end

  private

  # @return [Boolean]
  def allowed_type?(token); end

  def each_missing_space(tokens); end

  # The normal offset, i.e., the distance from the punctuation
  # token where a space should be, is 1.
  def offset; end

  # @return [Boolean]
  def space_forbidden_before_rcurly?; end

  # @return [Boolean]
  def space_missing?(token1, token2); end

  # @return [Boolean]
  def space_required_before?(token); end
end

RuboCop::Cop::SpaceAfterPunctuation::MSG = T.let(T.unsafe(nil), String)

# Common functionality for cops checking for space before
# punctuation.
module RuboCop::Cop::SpaceBeforePunctuation
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  def each_missing_space(tokens); end

  # @return [Boolean]
  def space_missing?(token1, token2); end

  # @return [Boolean]
  def space_required_after?(token); end

  # @return [Boolean]
  def space_required_after_lcurly?; end
end

RuboCop::Cop::SpaceBeforePunctuation::MSG = T.let(T.unsafe(nil), String)

# This autocorrects whitespace
class RuboCop::Cop::SpaceCorrector
  extend ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::SurroundingSpace

  class << self
    def add_space(processed_source, corrector, left_token, right_token); end
    def empty_corrections(processed_source, corrector, empty_config, left_token, right_token); end

    # Returns the value of attribute processed_source.
    def processed_source; end

    def remove_space(processed_source, corrector, left_token, right_token); end
  end
end

# Common functionality for modifier cops.
module RuboCop::Cop::StatementModifier
  include ::RuboCop::Cop::LineLengthHelp

  private

  def code_after(node); end

  # @return [Boolean]
  def comment_disables_cop?(comment); end

  def first_line_comment(node); end
  def length_in_modifier_form(node); end
  def max_line_length; end

  # @return [Boolean]
  def modifier_fits_on_single_line?(node); end

  # @return [Boolean]
  def non_eligible_body?(body); end

  # @return [Boolean]
  def non_eligible_condition?(condition); end

  # @return [Boolean]
  def non_eligible_node?(node); end

  # @return [Boolean]
  def parenthesize?(node); end

  # @return [Boolean]
  def single_line_as_modifier?(node); end

  def to_modifier_form(node); end
end

# Classes that include this module just implement functions to determine
# what is an offense and how to do autocorrection. They get help with
# adding offenses for the faulty string nodes, and with filtering out
# nodes.
module RuboCop::Cop::StringHelp
  def on_regexp(node); end
  def on_str(node); end

  private

  # @return [Boolean]
  def inside_interpolation?(node); end
end

# This autocorrects string literals
class RuboCop::Cop::StringLiteralCorrector
  extend ::RuboCop::PathUtil
  extend ::RuboCop::Cop::Util

  class << self
    def correct(corrector, node, style); end
  end
end

# Common functionality for cops checking single/double quotes.
module RuboCop::Cop::StringLiteralsHelp
  private

  # @return [Boolean]
  def wrong_quotes?(src_or_node); end
end

module RuboCop::Cop::Style; end

# Access modifiers should be declared to apply to a group of methods
# or inline before each method, depending on configuration.
# EnforcedStyle config covers only method definitions.
# Applications of visibility methods to symbols can be controlled
# using AllowModifiersOnSymbols config.
#
# @example EnforcedStyle: group (default)
#   # bad
#   class Foo
#
#   private def bar; end
#   private def baz; end
#
#   end
#
#   # good
#   class Foo
#
#   private
#
#   def bar; end
#   def baz; end
#
#   end
# @example EnforcedStyle: inline
#   # bad
#   class Foo
#
#   private
#
#   def bar; end
#   def baz; end
#
#   end
#
#   # good
#   class Foo
#
#   private def bar; end
#   private def baz; end
#
#   end
# @example AllowModifiersOnSymbols: true (default)
#   # good
#   class Foo
#
#   private :bar, :baz
#
#   end
# @example AllowModifiersOnSymbols: false
#   # bad
#   class Foo
#
#   private :bar, :baz
#
#   end
class RuboCop::Cop::Style::AccessModifierDeclarations < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def access_modifier_with_symbol?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def access_modifier_is_inlined?(node); end

  # @return [Boolean]
  def access_modifier_is_not_inlined?(node); end

  # @return [Boolean]
  def allow_modifiers_on_symbols?(node); end

  # @return [Boolean]
  def group_style?; end

  # @return [Boolean]
  def inline_style?; end

  def message(range); end

  # @return [Boolean]
  def offense?(node); end
end

RuboCop::Cop::Style::AccessModifierDeclarations::GROUP_STYLE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::AccessModifierDeclarations::INLINE_STYLE_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::AccessModifierDeclarations::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for grouping of accessors in `class` and `module` bodies.
# By default it enforces accessors to be placed in grouped declarations,
# but it can be configured to enforce separating them in multiple declarations.
#
# NOTE: `Sorbet` is not compatible with "grouped" style. Consider "separated" style
# or disabling this cop.
#
# @example EnforcedStyle: grouped (default)
#   # bad
#   class Foo
#   attr_reader :bar
#   attr_reader :baz
#   end
#
#   # good
#   class Foo
#   attr_reader :bar, :baz
#   end
# @example EnforcedStyle: separated
#   # bad
#   class Foo
#   attr_reader :bar, :baz
#   end
#
#   # good
#   class Foo
#   attr_reader :bar
#   attr_reader :baz
#   end
class RuboCop::Cop::Style::AccessorGrouping < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def on_module(node); end
  def on_sclass(node); end

  private

  # @return [Boolean]
  def accessor?(send_node); end

  def autocorrect(corrector, node); end
  def check(send_node); end
  def class_send_elements(class_node); end
  def group_accessors(node, accessors); end

  # @return [Boolean]
  def grouped_style?; end

  def message(send_node); end
  def preferred_accessors(node); end

  # @return [Boolean]
  def previous_line_comment?(node); end

  def separate_accessors(node); end

  # @return [Boolean]
  def separated_style?; end

  def sibling_accessors(send_node); end
end

RuboCop::Cop::Style::AccessorGrouping::ACCESSOR_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::AccessorGrouping::GROUPED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::AccessorGrouping::SEPARATED_MSG = T.let(T.unsafe(nil), String)

# Enforces the use of either `#alias` or `#alias_method`
# depending on configuration.
# It also flags uses of `alias :symbol` rather than `alias bareword`.
#
# @example EnforcedStyle: prefer_alias (default)
#   # bad
#   alias_method :bar, :foo
#   alias :bar :foo
#
#   # good
#   alias bar foo
# @example EnforcedStyle: prefer_alias_method
#   # bad
#   alias :bar :foo
#   alias bar foo
#
#   # good
#   alias_method :bar, :foo
class RuboCop::Cop::Style::Alias < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def identifier(param0 = T.unsafe(nil)); end
  def on_alias(node); end
  def on_send(node); end

  private

  def add_offense_for_args(node, &block); end

  # @return [Boolean]
  def alias_keyword_possible?(node); end

  # @return [Boolean]
  def alias_method_possible?(node); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def bareword?(sym_node); end

  def correct_alias_method_to_alias(corrector, send_node); end
  def correct_alias_to_alias_method(corrector, node); end
  def correct_alias_with_symbol_args(corrector, node); end
  def lexical_scope_type(node); end

  # In this expression, will `self` be the same as the innermost enclosing
  # class or module block (:lexical)? Or will it be something else
  # (:dynamic)? If we're in an instance_eval block, return that.
  def scope_type(node); end
end

RuboCop::Cop::Style::Alias::MSG_ALIAS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Alias::MSG_ALIAS_METHOD = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Alias::MSG_SYMBOL_ARGS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Alias::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `and` and `or`, and suggests using `&&` and
# `||` instead. It can be configured to check only in conditions or in
# all contexts.
#
# @example EnforcedStyle: conditionals (default)
#   # bad
#   if foo and bar
#   end
#
#   # good
#   foo.save && return
#
#   # good
#   foo.save and return
#
#   # good
#   if foo && bar
#   end
# @example EnforcedStyle: always
#   # bad
#   foo.save and return
#
#   # bad
#   if foo and bar
#   end
#
#   # good
#   foo.save && return
#
#   # good
#   if foo && bar
#   end
class RuboCop::Cop::Style::AndOr < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_and(node); end
  def on_if(node); end
  def on_or(node); end
  def on_until(node); end
  def on_until_post(node); end
  def on_while(node); end
  def on_while_post(node); end

  private

  # ! is a special case:
  # 'x and !obj.method arg' can be autocorrected if we
  # recurse down a level and add parens to 'obj.method arg'
  # however, 'not x' also parses as (send x :!)
  def correct_not(node, receiver, corrector); end

  def correct_other(node, corrector); end
  def correct_send(node, corrector); end
  def correct_setter(node, corrector); end

  # @return [Boolean]
  def correctable_send?(node); end

  def keep_operator_precedence(corrector, node); end
  def message(node); end
  def on_conditionals(node); end
  def process_logical_operator(node); end
  def whitespace_before_arg(node); end
end

RuboCop::Cop::Style::AndOr::MSG = T.let(T.unsafe(nil), String)

# In Ruby 2.7, arguments forwarding has been added.
#
# This cop identifies places where `do_something(*args, &block)`
# can be replaced by `do_something(...)`.
#
# @example
#   # bad
#   def foo(*args, &block)
#   bar(*args, &block)
#   end
#
#   # bad
#   def foo(*args, **kwargs, &block)
#   bar(*args, **kwargs, &block)
#   end
#
#   # good
#   def foo(...)
#   bar(...)
#   end
# @example AllowOnlyRestArgument: true (default)
#   # good
#   def foo(*args)
#   bar(*args)
#   end
#
#   def foo(**kwargs)
#   bar(**kwargs)
#   end
# @example AllowOnlyRestArgument: false
#   # bad
#   # The following code can replace the arguments with `...`,
#   # but it will change the behavior. Because `...` forwards block also.
#   def foo(*args)
#   bar(*args)
#   end
#
#   def foo(**kwargs)
#   bar(**kwargs)
#   end
class RuboCop::Cop::Style::ArgumentsForwarding < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def forwarding_method_arguments?(param0 = T.unsafe(nil), param1, param2, param3); end
  def on_def(node); end
  def on_defs(node); end
  def only_rest_arguments?(param0 = T.unsafe(nil), param1); end
  def use_rest_arguments?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def all_lvars_as_forwarding_method_arguments?(def_node, forwarding_method); end

  # @return [Boolean]
  def allow_only_rest_arguments?; end

  def arguments_range(node); end
  def extract_argument_names_from(args); end

  # @return [Boolean]
  def forwarding_method?(node, rest_arg, kwargs, block_arg); end

  def register_offense_to_forwarding_method_arguments(forwarding_method); end
  def register_offense_to_method_definition_arguments(method_definition); end
end

RuboCop::Cop::Style::ArgumentsForwarding::MSG = T.let(T.unsafe(nil), String)

# Enforces the use of `Array()` instead of explicit `Array` check or `[*var]`.
#
# The cop is disabled by default due to safety concerns.
#
# @example
#   # bad
#   paths = [paths] unless paths.is_a?(Array)
#   paths.each { |path| do_something(path) }
#
#   # bad (always creates a new Array instance)
#   [*paths].each { |path| do_something(path) }
#
#   # good (and a bit more readable)
#   Array(paths).each { |path| do_something(path) }
class RuboCop::Cop::Style::ArrayCoercion < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def array_splat?(param0 = T.unsafe(nil)); end
  def on_array(node); end
  def on_if(node); end
  def unless_array?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Style::ArrayCoercion::CHECK_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ArrayCoercion::SPLAT_MSG = T.let(T.unsafe(nil), String)

# Checks for uses of "*" as a substitute for _join_.
#
# Not all cases can reliably checked, due to Ruby's dynamic
# types, so we consider only cases when the first argument is an
# array literal or the second is a string literal.
#
# @example
#
#   # bad
#   %w(foo bar baz) * ","
#
#   # good
#   %w(foo bar baz).join(",")
class RuboCop::Cop::Style::ArrayJoin < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def join_candidate?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Style::ArrayJoin::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ArrayJoin::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

class RuboCop::Cop::Style::AsciiComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_new_investigation; end

  private

  def allowed_non_ascii_chars; end
  def first_non_ascii_chars(string); end
  def first_offense_range(comment); end

  # @return [Boolean]
  def only_allowed_non_ascii_chars?(string); end
end

RuboCop::Cop::Style::AsciiComments::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of Module#attr.
#
# @example
#   # bad - creates a single attribute accessor (deprecated in Ruby 1.9)
#   attr :something, true
#   attr :one, :two, :three # behaves as attr_reader
#
#   # good
#   attr_accessor :something
#   attr_reader :one, :two, :three
class RuboCop::Cop::Style::Attr < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def class_eval?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def autocorrect(corrector, node); end
  def message(node); end
  def replacement_method(node); end
end

RuboCop::Cop::Style::Attr::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Attr::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for cases when you could use a block
# accepting version of a method that does automatic
# resource cleanup.
#
# @example
#
#   # bad
#   f = File.open('file')
#
#   # good
#   File.open('file') do |f|
#   # ...
#   end
class RuboCop::Cop::Style::AutoResourceCleanup < ::RuboCop::Cop::Base
  def on_send(node); end

  private

  # @return [Boolean]
  def cleanup?(node); end
end

RuboCop::Cop::Style::AutoResourceCleanup::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::AutoResourceCleanup::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::AutoResourceCleanup::TARGET_METHODS = T.let(T.unsafe(nil), Hash)

# Checks if usage of %() or %Q() matches configuration.
#
# @example EnforcedStyle: bare_percent (default)
#   # bad
#   %Q(He said: "#{greeting}")
#   %q{She said: 'Hi'}
#
#   # good
#   %(He said: "#{greeting}")
#   %{She said: 'Hi'}
# @example EnforcedStyle: percent_q
#   # bad
#   %|He said: "#{greeting}"|
#   %/She said: 'Hi'/
#
#   # good
#   %Q|He said: "#{greeting}"|
#   %q/She said: 'Hi'/
class RuboCop::Cop::Style::BarePercentLiterals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_dstr(node); end
  def on_str(node); end

  private

  def add_offense_for_wrong_style(node, good, bad); end
  def check(node); end

  # @return [Boolean]
  def requires_bare_percent?(source); end

  # @return [Boolean]
  def requires_percent_q?(source); end
end

RuboCop::Cop::Style::BarePercentLiterals::MSG = T.let(T.unsafe(nil), String)

# This cop checks for BEGIN blocks.
#
# @example
#   # bad
#   BEGIN { test }
class RuboCop::Cop::Style::BeginBlock < ::RuboCop::Cop::Base
  def on_preexe(node); end
end

RuboCop::Cop::Style::BeginBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for places where `attr_reader` and `attr_writer`
# for the same method can be combined into single `attr_accessor`.
#
# @example
#   # bad
#   class Foo
#   attr_reader :bar
#   attr_writer :bar
#   end
#
#   # good
#   class Foo
#   attr_accessor :bar
#   end
class RuboCop::Cop::Style::BisectedAttrAccessor < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  def after_class(class_node); end

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  def after_module(class_node); end

  # Each offending macro is captured and registered in `on_class` but correction
  # happens in `after_class` because a macro might have multiple attributes
  # rewritten from it
  def after_sclass(class_node); end

  def on_class(class_node); end
  def on_module(class_node); end
  def on_new_investigation; end
  def on_sclass(class_node); end

  private

  def correct_reader(corrector, macro, node, range); end
  def correct_writer(corrector, macro, node, range); end
  def find_bisection(macros); end
  def find_macros(class_def); end
  def register_offense(attr); end
end

RuboCop::Cop::Style::BisectedAttrAccessor::MSG = T.let(T.unsafe(nil), String)

# Representation of an `attr_reader`, `attr_writer` or `attr` macro
# for use by `Style/BisectedAttrAccessor`.
#
# @api private
class RuboCop::Cop::Style::BisectedAttrAccessor::Macro
  include ::RuboCop::Cop::VisibilityHelp

  # @api private
  # @return [Macro] a new instance of Macro
  def initialize(node); end

  # @api private
  # @return [Boolean]
  def all_bisected?; end

  # @api private
  def attr_names; end

  # @api private
  def attrs; end

  # @api private
  def bisect(*names); end

  # @api private
  def bisected_names; end

  # @api private
  def bisection; end

  # @api private
  def node; end

  # @api private
  # @return [Boolean]
  def reader?; end

  # @api private
  def rest; end

  # @api private
  def visibility; end

  # @api private
  # @return [Boolean]
  def writer?; end

  class << self
    # @api private
    # @return [Boolean]
    def macro?(node); end
  end
end

# Looks for uses of block comments (=begin...=end).
#
# @example
#   # bad
#   =begin
#   Multiple lines
#   of comments...
#   =end
#
#   # good
#   # Multiple lines
#   # of comments...
class RuboCop::Cop::Style::BlockComments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def eq_end_part(comment, expr); end
  def parts(comment); end
end

RuboCop::Cop::Style::BlockComments::BEGIN_LENGTH = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Style::BlockComments::END_LENGTH = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Style::BlockComments::MSG = T.let(T.unsafe(nil), String)

# Check for uses of braces or do/end around single line or
# multi-line blocks.
#
# Methods that can be either procedural or functional and cannot be
# categorised from their usage alone is ignored.
# `lambda`, `proc`, and `it` are their defaults.
# Additional methods can be added to the `AllowedMethods`.
#
# @example AllowedPatterns: [/map/]
#
#   # good
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
# @example EnforcedStyle: semantic
#   # Prefer `do...end` over `{...}` for procedural blocks.
#
#   # return value is used/assigned
#   # bad
#   foo = map do |x|
#   x
#   end
#   puts (map do |x|
#   x
#   end)
#
#   # return value is not used out of scope
#   # good
#   map do |x|
#   x
#   end
#
#   # Prefer `{...}` over `do...end` for functional blocks.
#
#   # return value is not used out of scope
#   # bad
#   each { |x|
#   x
#   }
#
#   # return value is used/assigned
#   # good
#   foo = map { |x|
#   x
#   }
#   map { |x|
#   x
#   }.inspect
#
#   # The AllowBracesOnProceduralOneLiners option is allowed unless the
#   # EnforcedStyle is set to `semantic`. If so:
#
#   # If the AllowBracesOnProceduralOneLiners option is unspecified, or
#   # set to `false` or any other falsey value, then semantic purity is
#   # maintained, so one-line procedural blocks must use do-end, not
#   # braces.
#
#   # bad
#   collection.each { |element| puts element }
#
#   # good
#   collection.each do |element| puts element end
#
#   # If the AllowBracesOnProceduralOneLiners option is set to `true`, or
#   # any other truthy value, then one-line procedural blocks may use
#   # either style. (There is no setting for requiring braces on them.)
#
#   # good
#   collection.each { |element| puts element }
#
#   # also good
#   collection.each do |element| puts element end
# @example EnforcedStyle: braces_for_chaining
#   # bad
#   words.each do |word|
#   word.flip.flop
#   end.join("-")
#
#   # good
#   words.each { |word|
#   word.flip.flop
#   }.join("-")
# @example EnforcedStyle: always_braces
#   # bad
#   words.each do |word|
#   word.flip.flop
#   end
#
#   # good
#   words.each { |word|
#   word.flip.flop
#   }
# @example BracesRequiredMethods: ['sig']
#
#   # Methods listed in the BracesRequiredMethods list, such as 'sig'
#   # in this example, will require `{...}` braces. This option takes
#   # precedence over all other configurations except AllowedMethods.
#
#   # bad
#   sig do
#   params(
#   foo: string,
#   ).void
#   end
#   def bar(foo)
#   puts foo
#   end
#
#   # good
#   sig {
#   params(
#   foo: string,
#   ).void
#   }
#   def bar(foo)
#   puts foo
#   end
# @example AllowedMethods: ['lambda', 'proc', 'it' ] (default)
#
#   # good
#   foo = lambda do |x|
#   puts "Hello, #{x}"
#   end
#
#   foo = lambda do |x|
#   x * 100
#   end
# @example AllowedPatterns: [] (default)
#
#   # bad
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
# @example EnforcedStyle: line_count_based (default)
#   # bad - single line block
#   items.each do |item| item / 5 end
#
#   # good - single line block
#   items.each { |item| item / 5 }
#
#   # bad - multi-line block
#   things.map { |thing|
#   something = thing.some_method
#   process(something)
#   }
#
#   # good - multi-line block
#   things.map do |thing|
#   something = thing.some_method
#   process(something)
#   end
class RuboCop::Cop::Style::BlockDelimiters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def array_or_range?(node); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def begin_required?(block_node); end

  def braces_for_chaining_message(node); end

  # @return [Boolean]
  def braces_for_chaining_style?(node); end

  def braces_required_message(node); end

  # @return [Boolean]
  def braces_required_method?(method_name); end

  def braces_required_methods; end

  # @return [Boolean]
  def braces_style?(node); end

  # @return [Boolean]
  def conditional?(node); end

  # @return [Boolean]
  def correction_would_break_code?(node); end

  def end_of_chain(node); end

  # @return [Boolean]
  def functional_block?(node); end

  # @return [Boolean]
  def functional_method?(method_name); end

  def get_blocks(node, &block); end

  # @return [Boolean]
  def line_count_based_block_style?(node); end

  def line_count_based_message(node); end
  def message(node); end
  def move_comment_before_block(corrector, comment, block_node, closing_brace); end

  # @return [Boolean]
  def procedural_method?(method_name); end

  # @return [Boolean]
  def procedural_oneliners_may_have_braces?; end

  # @return [Boolean]
  def proper_block_style?(node); end

  def replace_braces_with_do_end(corrector, loc); end
  def replace_do_end_with_braces(corrector, node); end

  # @return [Boolean]
  def return_value_of_scope?(node); end

  # @return [Boolean]
  def return_value_used?(node); end

  # @return [Boolean]
  def semantic_block_style?(node); end

  def semantic_message(node); end

  # @return [Boolean]
  def special_method?(method_name); end

  # @return [Boolean]
  def special_method_proper_block_style?(node); end

  # @return [Boolean]
  def whitespace_after?(range, length = T.unsafe(nil)); end

  # @return [Boolean]
  def whitespace_before?(range); end

  # @return [Boolean]
  def with_block?(node); end
end

RuboCop::Cop::Style::BlockDelimiters::ALWAYS_BRACES_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::BlockDelimiters::BRACES_REQUIRED_MESSAGE = T.let(T.unsafe(nil), String)

# Corrector to correct conditional assignment in `case` statements.
class RuboCop::Cop::Style::CaseCorrector
  extend ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::Cop::Style::ConditionalCorrectorHelper

  class << self
    def correct(corrector, cop, node); end
    def move_assignment_inside_condition(corrector, node); end

    private

    def extract_branches(case_node); end
    def extract_tail_branches(node); end
    def move_branch_inside_condition(corrector, branch, condition, assignment, column); end
  end
end

# Checks for uses of the case equality operator(===).
#
# If `AllowOnConstant` option is enabled, the cop will ignore violations when the receiver of
# the case equality operator is a constant.
#
# @example
#   # bad
#   (1..100) === 7
#   /something/ === some_string
#
#   # good
#   something.is_a?(Array)
#   (1..100).include?(7)
#   /something/.match?(some_string)
# @example AllowOnConstant: false (default)
#   # bad
#   Array === something
# @example AllowOnConstant: true
#   # good
#   Array === something
class RuboCop::Cop::Style::CaseEquality < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def case_equality?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def const?(node); end

  def replacement(lhs, rhs); end
end

RuboCop::Cop::Style::CaseEquality::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CaseEquality::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `if-elsif` constructions
# can be replaced with `case-when`.
#
# @example
#   # bad
#   if status == :active
#   perform_action
#   elsif status == :inactive || status == :hibernating
#   check_timeout
#   else
#   final_action
#   end
#
#   # good
#   case status
#   when :active
#   perform_action
#   when :inactive, :hibernating
#   check_timeout
#   else
#   final_action
#   end
class RuboCop::Cop::Style::CaseLikeIf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def autocorrect(corrector, node); end
  def branch_conditions(node); end

  # @return [Boolean]
  def class_reference?(node); end

  def collect_conditions(node, target, conditions); end
  def condition_from_binary_op(lhs, rhs, target); end
  def condition_from_equality_node(node, target); end
  def condition_from_include_or_cover_node(node, target); end
  def condition_from_match_node(node, target); end
  def condition_from_send_node(node, target); end

  # @return [Boolean]
  def const_reference?(node); end

  def correction_range(node); end
  def deparenthesize(node); end
  def find_target(node); end
  def find_target_in_equality_node(node); end
  def find_target_in_include_or_cover_node(node); end
  def find_target_in_match_node(node); end
  def find_target_in_send_node(node); end

  # @return [Boolean]
  def regexp_with_named_captures?(node); end

  # Named captures work with `=~` (if regexp is on lhs) and with `match` (both sides)
  #
  # @return [Boolean]
  def regexp_with_working_captures?(node); end

  # @return [Boolean]
  def should_check?(node); end
end

RuboCop::Cop::Style::CaseLikeIf::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of the character literal ?x.
# Starting with Ruby 1.9 character literals are
# essentially one-character strings, so this syntax
# is mostly redundant at this point.
#
# ? character literal can be used to express meta and control character.
# That's a good use case of ? literal so it doesn't count it as an offense.
#
# @example
#   # bad
#   ?x
#
#   # good
#   'x'
#
#   # good - control & meta escapes
#   ?\C-\M-d
#   "\C-\M-d" # same as above
class RuboCop::Cop::Style::CharacterLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::StringHelp
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, node); end

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  def correct_style_detected; end

  # @return [Boolean]
  def offense?(node); end

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  def opposite_style_detected; end
end

RuboCop::Cop::Style::CharacterLiteral::MSG = T.let(T.unsafe(nil), String)

# Checks the style of children definitions at classes and
# modules. Basically there are two different styles:
#
# The compact style is only forced for classes/modules with one child.
#
# @example EnforcedStyle: nested (default)
#   # good
#   # have each child on its own line
#   class Foo
#   class Bar
#   end
#   end
# @example EnforcedStyle: compact
#   # good
#   # combine definitions as much as possible
#   class Foo::Bar
#   end
class RuboCop::Cop::Style::ClassAndModuleChildren < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def on_module(node); end

  private

  def add_trailing_end(corrector, node, padding); end
  def autocorrect(corrector, node); end
  def check_compact_style(node, body); end
  def check_nested_style(node); end
  def check_style(node, body); end
  def compact_definition(corrector, node); end
  def compact_identifier_name(node); end
  def compact_node(corrector, node); end

  # @return [Boolean]
  def compact_node_name?(node); end

  def compact_replacement(node); end
  def configured_indentation_width; end
  def indent_width; end
  def leading_spaces(node); end

  # @return [Boolean]
  def needs_compacting?(body); end

  def nest_definition(corrector, node); end
  def nest_or_compact(corrector, node); end
  def remove_end(corrector, body); end
  def replace_namespace_keyword(corrector, node); end
  def split_on_double_colon(corrector, node, padding); end
  def unindent(corrector, node); end
end

RuboCop::Cop::Style::ClassAndModuleChildren::COMPACT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ClassAndModuleChildren::NESTED_MSG = T.let(T.unsafe(nil), String)

# Enforces consistent use of `Object#is_a?` or `Object#kind_of?`.
#
# @example EnforcedStyle: is_a? (default)
#   # bad
#   var.kind_of?(Date)
#   var.kind_of?(Integer)
#
#   # good
#   var.is_a?(Date)
#   var.is_a?(Integer)
# @example EnforcedStyle: kind_of?
#   # bad
#   var.is_a?(Time)
#   var.is_a?(String)
#
#   # good
#   var.kind_of?(Time)
#   var.kind_of?(String)
class RuboCop::Cop::Style::ClassCheck < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def message(node); end
  def on_send(node); end
end

RuboCop::Cop::Style::ClassCheck::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ClassCheck::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `Object#instance_of?` instead of class comparison
# for equality.
# `==`, `equal?`, and `eql?` methods are allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example
#   # bad
#   var.class == Date
#   var.class.equal?(Date)
#   var.class.eql?(Date)
#   var.class.name == 'Date'
#
#   # good
#   var.instance_of?(Date)
# @example AllowedMethods: [] (default)
#   # good
#   var.instance_of?(Date)
#
#   # bad
#   var.class == Date
#   var.class.equal?(Date)
#   var.class.eql?(Date)
#   var.class.name == 'Date'
# @example AllowedMethods: [`==`]
#   # good
#   var.instance_of?(Date)
#   var.class == Date
#   var.class.name == 'Date'
#
#   # bad
#   var.class.equal?(Date)
#   var.class.eql?(Date)
# @example AllowedPatterns: [] (default)
#   # good
#   var.instance_of?(Date)
#
#   # bad
#   var.class == Date
#   var.class.equal?(Date)
#   var.class.eql?(Date)
#   var.class.name == 'Date'
# @example AllowedPatterns: [`/eq/`]
#   # good
#   var.instance_of?(Date)
#   var.class.equal?(Date)
#   var.class.eql?(Date)
#
#   # bad
#   var.class == Date
#   var.class.name == 'Date'
class RuboCop::Cop::Style::ClassEqualityComparison < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def class_comparison_candidate?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def class_name(class_node, node); end
  def offense_range(receiver_node, node); end
end

RuboCop::Cop::Style::ClassEqualityComparison::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ClassEqualityComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of the class/module name instead of
# self, when defining class/module methods.
#
# @example
#   # bad
#   class SomeClass
#   def SomeClass.class_method
#   # ...
#   end
#   end
#
#   # good
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#   end
class RuboCop::Cop::Style::ClassMethods < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def on_module(node); end

  private

  def check_defs(name, node); end
end

RuboCop::Cop::Style::ClassMethods::MSG = T.let(T.unsafe(nil), String)

# Enforces using `def self.method_name` or `class << self` to define class methods.
#
# @example EnforcedStyle: def_self (default)
#   # bad
#   class SomeClass
#   class << self
#   attr_accessor :class_accessor
#
#   def class_method
#   # ...
#   end
#   end
#   end
#
#   # good
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#
#   class << self
#   attr_accessor :class_accessor
#   end
#   end
#
#   # good - contains private method
#   class SomeClass
#   class << self
#   attr_accessor :class_accessor
#
#   private
#
#   def private_class_method
#   # ...
#   end
#   end
#   end
# @example EnforcedStyle: self_class
#   # bad
#   class SomeClass
#   def self.class_method
#   # ...
#   end
#   end
#
#   # good
#   class SomeClass
#   class << self
#   def class_method
#   # ...
#   end
#   end
#   end
class RuboCop::Cop::Style::ClassMethodsDefinitions < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_defs(node); end
  def on_sclass(node); end

  private

  # @return [Boolean]
  def all_methods_public?(sclass_node); end

  def autocorrect_sclass(node, corrector); end
  def def_nodes(sclass_node); end

  # @return [Boolean]
  def def_self_style?; end

  def extract_def_from_sclass(def_node, sclass_node); end
  def indentation_diff(node1, node2); end

  # @return [Boolean]
  def sclass_only_has_methods?(node); end
end

RuboCop::Cop::Style::ClassMethodsDefinitions::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ClassMethodsDefinitions::MSG_SCLASS = T.let(T.unsafe(nil), String)

# Checks for uses of class variables. Offenses
# are signaled only on assignment to class variables to
# reduce the number of offenses that would be reported.
#
# You have to be careful when setting a value for a class
# variable; if a class has been inherited, changing the
# value of a class variable also affects the inheriting
# classes. This means that it's almost always better to
# use a class instance variable instead.
#
# @example
#   # bad
#   class A
#   @@test = 10
#   end
#
#   class A
#   def self.test(name, value)
#   class_variable_set("@@#{name}", value)
#   end
#   end
#
#   class A; end
#   A.class_variable_set(:@@test, 10)
#
#   # good
#   class A
#   @test = 10
#   end
#
#   class A
#   def test
#   @@test # you can access class variable without offense
#   end
#   end
#
#   class A
#   def self.test(name)
#   class_variable_get("@@#{name}") # you can access without offense
#   end
#   end
class RuboCop::Cop::Style::ClassVars < ::RuboCop::Cop::Base
  def on_cvasgn(node); end
  def on_send(node); end
end

RuboCop::Cop::Style::ClassVars::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ClassVars::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where custom logic on rejection nils from arrays
# and hashes can be replaced with `{Array,Hash}#{compact,compact!}`.
#
# @example
#   # bad
#   array.reject(&:nil?)
#   array.reject { |e| e.nil? }
#   array.select { |e| !e.nil? }
#
#   # good
#   array.compact
#
#   # bad
#   hash.reject!(&:nil?)
#   hash.reject! { |k, v| v.nil? }
#   hash.select! { |k, v| !v.nil? }
#
#   # good
#   hash.compact!
class RuboCop::Cop::Style::CollectionCompact < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def reject_method?(param0 = T.unsafe(nil)); end
  def reject_method_with_block_pass?(param0 = T.unsafe(nil)); end
  def select_method?(param0 = T.unsafe(nil)); end

  private

  def good_method_name(node); end
  def offense_range(node); end
  def range(begin_pos_node, end_pos_node); end
end

RuboCop::Cop::Style::CollectionCompact::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CollectionCompact::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of consistent method names
# from the Enumerable module.
#
# You can customize the mapping from undesired method to desired method.
#
# e.g. to use `detect` over `find`:
#
#   Style/CollectionMethods:
#     PreferredMethods:
#       find: detect
#
# @example
#   # These examples are based on the default mapping for `PreferredMethods`.
#
#   # bad
#   items.collect
#   items.collect!
#   items.inject
#   items.detect
#   items.find_all
#   items.member?
#
#   # good
#   items.map
#   items.map!
#   items.reduce
#   items.find
#   items.select
#   items.include?
class RuboCop::Cop::Style::CollectionMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MethodPreference
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def on_send(node); end

  private

  def check_method_node(node); end

  # @return [Boolean]
  def implicit_block?(node); end

  def message(node); end

  # Some enumerable methods accept a bare symbol (ie. _not_ Symbol#to_proc) instead
  # of a block.
  def methods_accepting_symbol; end
end

RuboCop::Cop::Style::CollectionMethods::MSG = T.let(T.unsafe(nil), String)

# Checks for methods invoked via the :: operator instead
# of the . operator (like FileUtils::rmdir instead of FileUtils.rmdir).
#
# @example
#   # bad
#   Timeout::timeout(500) { do_something }
#   FileUtils::rmdir(dir)
#   Marshal::dump(obj)
#
#   # good
#   Timeout.timeout(500) { do_something }
#   FileUtils.rmdir(dir)
#   Marshal.dump(obj)
class RuboCop::Cop::Style::ColonMethodCall < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def java_type_node?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::ColonMethodCall::MSG = T.let(T.unsafe(nil), String)

# Checks for class methods that are defined using the `::`
# operator instead of the `.` operator.
#
# @example
#   # bad
#   class Foo
#   def self::bar
#   end
#   end
#
#   # good
#   class Foo
#   def self.bar
#   end
#   end
class RuboCop::Cop::Style::ColonMethodDefinition < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_defs(node); end
end

RuboCop::Cop::Style::ColonMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for places where multiple consecutive loops over the same data
# can be combined into a single loop. It is very likely that combining them
# will make the code more efficient and more concise.
#
# @example
#   # bad
#   def method
#   items.each do |item|
#   do_something(item)
#   end
#
#   items.each do |item|
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   items.each do |item|
#   do_something(item)
#   do_something_else(item)
#   end
#   end
#
#   # bad
#   def method
#   for item in items do
#   do_something(item)
#   end
#
#   for item in items do
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   for item in items do
#   do_something(item)
#   do_something_else(item)
#   end
#   end
#
#   # good
#   def method
#   each_slice(2) { |slice| do_something(slice) }
#   each_slice(3) { |slice| do_something(slice) }
#   end
class RuboCop::Cop::Style::CombinableLoops < ::RuboCop::Cop::Base
  def on_block(node); end
  def on_for(node); end
  def on_numblock(node); end

  private

  # @return [Boolean]
  def collection_looping_method?(node); end

  # @return [Boolean]
  def same_collection_looping?(node, sibling); end
end

RuboCop::Cop::Style::CombinableLoops::MSG = T.let(T.unsafe(nil), String)

# Enforces using `` or %x around command literals.
#
# @example EnforcedStyle: backticks (default)
#   # bad
#   folders = %x(find . -type d).split
#
#   # bad
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
#
#   # good
#   folders = `find . -type d`.split
#
#   # good
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
# @example EnforcedStyle: mixed
#   # bad
#   folders = %x(find . -type d).split
#
#   # bad
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
#
#   # good
#   folders = `find . -type d`.split
#
#   # good
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
# @example EnforcedStyle: percent_x
#   # bad
#   folders = `find . -type d`.split
#
#   # bad
#   `
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   `
#
#   # good
#   folders = %x(find . -type d).split
#
#   # good
#   %x(
#   ln -s foo.example.yml foo.example
#   ln -s bar.example.yml bar.example
#   )
# @example AllowInnerBackticks: false (default)
#   # If `false`, the cop will always recommend using `%x` if one or more
#   # backticks are found in the command string.
#
#   # bad
#   `echo \`ls\``
#
#   # good
#   %x(echo `ls`)
# @example AllowInnerBackticks: true
#   # good
#   `echo \`ls\``
class RuboCop::Cop::Style::CommandLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_xstr(node); end

  private

  # @return [Boolean]
  def allow_inner_backticks?; end

  # @return [Boolean]
  def allowed_backtick_literal?(node); end

  # @return [Boolean]
  def allowed_percent_x_literal?(node); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def backtick_literal?(node); end

  def check_backtick_literal(node, message); end
  def check_percent_x_literal(node, message); end
  def command_delimiter; end

  # @return [Boolean]
  def contains_backtick?(node); end

  # @return [Boolean]
  def contains_disallowed_backtick?(node); end

  def default_delimiter; end
  def node_body(node); end
  def preferred_delimiter; end
  def preferred_delimiters_config; end
end

RuboCop::Cop::Style::CommandLiteral::MSG_USE_BACKTICKS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CommandLiteral::MSG_USE_PERCENT_X = T.let(T.unsafe(nil), String)

# Checks that comment annotation keywords are written according
# to guidelines.
#
# Annotation keywords can be specified by overriding the cop's `Keywords`
# configuration. Keywords are allowed to be single words or phrases.
#
# NOTE: With a multiline comment block (where each line is only a
# comment), only the first line will be able to register an offense, even
# if an annotation keyword starts another line. This is done to prevent
# incorrect registering of keywords (eg. `review`) inside a paragraph as an
# annotation.
#
# @example RequireColon: true (default)
#   # bad
#   # TODO make better
#
#   # good
#   # TODO: make better
#
#   # bad
#   # TODO:make better
#
#   # good
#   # TODO: make better
#
#   # bad
#   # fixme: does not work
#
#   # good
#   # FIXME: does not work
#
#   # bad
#   # Optimize does not work
#
#   # good
#   # OPTIMIZE: does not work
# @example RequireColon: false
#   # bad
#   # TODO: make better
#
#   # good
#   # TODO make better
#
#   # bad
#   # fixme does not work
#
#   # good
#   # FIXME does not work
#
#   # bad
#   # Optimize does not work
#
#   # good
#   # OPTIMIZE does not work
class RuboCop::Cop::Style::CommentAnnotation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def annotation_range(annotation); end
  def correct_offense(corrector, range, keyword); end

  # @return [Boolean]
  def first_comment_line?(comments, index); end

  # @return [Boolean]
  def inline_comment?(comment); end

  def keywords; end
  def register_offense(annotation); end

  # @return [Boolean]
  def requires_colon?; end
end

RuboCop::Cop::Style::CommentAnnotation::MISSING_NOTE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CommentAnnotation::MSG_COLON_STYLE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CommentAnnotation::MSG_SPACE_STYLE = T.let(T.unsafe(nil), String)

# Checks for comments put on the same line as some keywords.
# These keywords are: `class`, `module`, `def`, `begin`, `end`.
#
# Note that some comments
# are allowed.
#
# Autocorrection removes comments from `end` keyword and keeps comments
# for `class`, `module`, `def` and `begin` above the keyword.
#
# @example
#   # bad
#   if condition
#   statement
#   end # end if
#
#   # bad
#   class X # comment
#   statement
#   end
#
#   # bad
#   def x; end # comment
#
#   # good
#   if condition
#   statement
#   end
#
#   # good
#   class X # :nodoc:
#   y
#   end
class RuboCop::Cop::Style::CommentedKeyword < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  # @return [Boolean]
  def offensive?(comment); end

  def register_offense(comment, matched_keyword); end
  def source_line(comment); end
end

RuboCop::Cop::Style::CommentedKeyword::ALLOWED_COMMENTS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::CommentedKeyword::ALLOWED_COMMENT_REGEXES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::CommentedKeyword::KEYWORDS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::CommentedKeyword::KEYWORD_REGEXES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::CommentedKeyword::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::CommentedKeyword::REGEXP = T.let(T.unsafe(nil), Regexp)

# Check for `if` and `case` statements where each branch is used for
# assignment to the same variable when using the return of the
# condition can be used instead.
#
# @example EnforcedStyle: assign_to_condition (default)
#   # bad
#   if foo
#   bar = 1
#   else
#   bar = 2
#   end
#
#   case foo
#   when 'a'
#   bar += 1
#   else
#   bar += 2
#   end
#
#   if foo
#   some_method
#   bar = 1
#   else
#   some_other_method
#   bar = 2
#   end
#
#   # good
#   bar = if foo
#   1
#   else
#   2
#   end
#
#   bar += case foo
#   when 'a'
#   1
#   else
#   2
#   end
#
#   bar << if foo
#   some_method
#   1
#   else
#   some_other_method
#   2
#   end
# @example EnforcedStyle: assign_inside_condition
#   # bad
#   bar = if foo
#   1
#   else
#   2
#   end
#
#   bar += case foo
#   when 'a'
#   1
#   else
#   2
#   end
#
#   bar << if foo
#   some_method
#   1
#   else
#   some_other_method
#   2
#   end
#
#   # good
#   if foo
#   bar = 1
#   else
#   bar = 2
#   end
#
#   case foo
#   when 'a'
#   bar += 1
#   else
#   bar += 2
#   end
#
#   if foo
#   some_method
#   bar = 1
#   else
#   some_other_method
#   bar = 2
#   end
class RuboCop::Cop::Style::ConditionalAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # The shovel operator `<<` does not have its own type. It is a `send`
  # type.
  def assignment_type?(param0 = T.unsafe(nil)); end

  def candidate_condition?(param0 = T.unsafe(nil)); end
  def on_and_asgn(node); end
  def on_case(node); end
  def on_case_match(node); end
  def on_casgn(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_if(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_op_asgn(node); end
  def on_or_asgn(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_single_line?(branches); end

  # @return [Boolean]
  def allowed_statements?(branches); end

  # @return [Boolean]
  def allowed_ternary?(assignment); end

  def assignment_node(node); end

  # @return [Boolean]
  def assignment_types_match?(*nodes); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def candidate_node?(node); end

  def check_assignment_to_condition(node); end
  def check_node(node, branches); end

  # If `Layout/LineLength` is enabled, we do not want to introduce an
  # offense by autocorrecting this cop. Find the max configured line
  # length. Find the longest line of condition. Remove the assignment
  # from lines that contain the offending assignment because after
  # correcting, this will not be on the line anymore. Check if the length
  # of the longest line + the length of the corrected assignment is
  # greater than the max configured line length
  #
  # @return [Boolean]
  def correction_exceeds_line_limit?(node, branches); end

  # @return [Boolean]
  def include_ternary?; end

  def indentation_width; end

  # @return [Boolean]
  def lhs_all_match?(branches); end

  # @return [Boolean]
  def line_length_cop_enabled?; end

  def longest_line(node, assignment); end

  # @return [Boolean]
  def longest_line_exceeds_line_limit?(node, assignment); end

  def max_line_length; end
  def move_assignment_inside_condition(corrector, node); end
  def move_assignment_outside_condition(corrector, node); end

  # @return [Boolean]
  def single_line_conditions_only?; end

  # @return [Boolean]
  def ternary_condition?(node); end
end

RuboCop::Cop::Style::ConditionalAssignment::ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::ConditionalAssignment::ASSIGN_TO_CONDITION_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::ENABLED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::INDENTATION_WIDTH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::LINE_LENGTH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::MAX = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::SINGLE_LINE_CONDITIONS_ONLY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignment::VARIABLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::ConditionalAssignment::WIDTH = T.let(T.unsafe(nil), String)

# Helper module to provide common methods to classes needed for the
# ConditionalAssignment Cop.
module RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [Boolean]
  def end_with_eq?(sym); end

  # `elsif` branches show up in the `node` as an `else`. We need
  # to recursively iterate over all `else` branches and consider all
  # but the last `node` an `elsif` branch and consider the last `node`
  # the actual `else` branch.
  def expand_elses(branch); end

  # `when` nodes contain the entire branch including the condition.
  # We only need the contents of the branch, not the condition.
  def expand_when_branches(when_branches); end

  def indent(cop, source); end
  def lhs(node); end
  def tail(branch); end

  private

  # @return [Boolean]
  def assignment_rhs_exist?(node); end

  def expand_elsif(node, elsif_branches = T.unsafe(nil)); end
  def lhs_for_casgn(node); end
  def lhs_for_send(node); end

  # @return [Boolean]
  def setter_method?(method_name); end
end

RuboCop::Cop::Style::ConditionalAssignmentHelper::ALIGN_WITH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignmentHelper::END_ALIGNMENT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignmentHelper::EQUAL = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ConditionalAssignmentHelper::KEYWORD = T.let(T.unsafe(nil), String)

# Helper module to provide common methods to ConditionalAssignment
# correctors
module RuboCop::Cop::Style::ConditionalCorrectorHelper
  def assignment(node); end
  def correct_branches(corrector, branches); end
  def correct_if_branches(corrector, cop, node); end
  def remove_whitespace_in_branches(corrector, branch, condition, column); end
  def replace_branch_assignment(corrector, branch); end
  def white_space_range(node, column); end
end

# Checks that constants defined in classes and modules have
# an explicit visibility declaration. By default, Ruby makes all class-
# and module constants public, which litters the public API of the
# class or module. Explicitly declaring a visibility makes intent more
# clear, and prevents outside actors from touching private state.
#
# @example
#
#   # bad
#   class Foo
#   BAR = 42
#   BAZ = 43
#   end
#
#   # good
#   class Foo
#   BAR = 42
#   private_constant :BAR
#
#   BAZ = 43
#   public_constant :BAZ
#   end
# @example IgnoreModules: false (default)
#   # bad
#   class Foo
#   MyClass = Struct.new()
#   end
#
#   # good
#   class Foo
#   MyClass = Struct.new()
#   public_constant :MyClass
#   end
# @example IgnoreModules: true
#   # good
#   class Foo
#   MyClass = Struct.new()
#   end
class RuboCop::Cop::Style::ConstantVisibility < ::RuboCop::Cop::Base
  def on_casgn(node); end
  def visibility_declaration_for?(param0 = T.unsafe(nil), param1); end

  private

  # @return [Boolean]
  def class_or_module_scope?(node); end

  # @return [Boolean]
  def ignore_modules?; end

  # @return [Boolean]
  def match_name?(name, constant_name); end

  def message(node); end

  # @return [Boolean]
  def module?(node); end

  # @return [Boolean]
  def visibility_declaration?(node); end
end

RuboCop::Cop::Style::ConstantVisibility::MSG = T.let(T.unsafe(nil), String)

class RuboCop::Cop::Style::Copyright < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect_notice; end

  # @return [Boolean]
  def encoding_token?(processed_source, token_index); end

  def insert_notice_before(processed_source); end
  def notice; end

  # @return [Boolean]
  def notice_found?(processed_source); end

  def offense_range; end

  # @return [Boolean]
  def shebang_token?(processed_source, token_index); end

  # @raise [Warning]
  def verify_autocorrect_notice!; end
end

RuboCop::Cop::Style::Copyright::AUTOCORRECT_EMPTY_WARNING = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Copyright::MSG = T.let(T.unsafe(nil), String)

# Checks for consistent usage of the `DateTime` class over the
# `Time` class. This cop is disabled by default since these classes,
# although highly overlapping, have particularities that make them not
# replaceable in certain situations when dealing with multiple timezones
# and/or DST.
#
# @example
#
#   # bad - uses `DateTime` for current time
#   DateTime.now
#
#   # good - uses `Time` for current time
#   Time.now
#
#   # bad - uses `DateTime` for modern date
#   DateTime.iso8601('2016-06-29')
#
#   # good - uses `Time` for modern date
#   Time.iso8601('2016-06-29')
#
#   # good - uses `DateTime` with start argument for historical date
#   DateTime.iso8601('1751-04-23', Date::ENGLAND)
# @example AllowCoercion: false (default)
#
#   # bad - coerces to `DateTime`
#   something.to_datetime
#
#   # good - coerces to `Time`
#   something.to_time
# @example AllowCoercion: true
#
#   # good
#   something.to_datetime
#
#   # good
#   something.to_time
class RuboCop::Cop::Style::DateTime < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def date_time?(param0 = T.unsafe(nil)); end
  def historic_date?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def to_datetime?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def disallow_coercion?; end
end

RuboCop::Cop::Style::DateTime::CLASS_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::DateTime::COERCION_MSG = T.let(T.unsafe(nil), String)

# Checks for parentheses in the definition of a method,
# that does not take any arguments. Both instance and
# class/singleton methods are checked.
#
# @example
#
#   # bad
#   def foo()
#   do_something
#   end
#
#   # good
#   def foo
#   do_something
#   end
#
#   # bad
#   def foo() = do_something
#
#   # good
#   def foo = do_something
#
#   # good (without parentheses it's a syntax error)
#   def foo() do_something end
# @example
#
#   # bad
#   def Baz.foo()
#   do_something
#   end
#
#   # good
#   def Baz.foo
#   do_something
#   end
class RuboCop::Cop::Style::DefWithParentheses < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
end

RuboCop::Cop::Style::DefWithParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks for places where the `#__dir__` method can replace more
# complex constructs to retrieve a canonicalized absolute path to the
# current file.
#
# @example
#   # bad
#   path = File.expand_path(File.dirname(__FILE__))
#
#   # bad
#   path = File.dirname(File.realpath(__FILE__))
#
#   # good
#   path = __dir__
class RuboCop::Cop::Style::Dir < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def dir_replacement?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def file_keyword?(node); end
end

RuboCop::Cop::Style::Dir::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Dir::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Detects comments to enable/disable RuboCop.
# This is useful if want to make sure that every RuboCop error gets fixed
# and not quickly disabled with a comment.
#
# Specific cops can be allowed with the `AllowedCops` configuration. Note that
#
# @example
#   # bad
#   # rubocop:disable Metrics/AbcSize
#   def foo
#   end
#   # rubocop:enable Metrics/AbcSize
#
#   # good
#   def foo
#   end
# @example AllowedCops: [Metrics/AbcSize]
#   # good
#   # rubocop:disable Metrics/AbcSize
#   def foo
#   end
#   # rubocop:enable Metrics/AbcSize
class RuboCop::Cop::Style::DisableCopsWithinSourceCodeDirective < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def allowed_cops; end

  # @return [Boolean]
  def any_cops_allowed?; end

  def directive_cops(comment); end
  def register_offense(comment, directive_cops, disallowed_cops); end
end

RuboCop::Cop::Style::DisableCopsWithinSourceCodeDirective::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::DisableCopsWithinSourceCodeDirective::MSG_FOR_COPS = T.let(T.unsafe(nil), String)

# When using `class_eval` (or other `eval`) with string interpolation,
# add a comment block showing its appearance if interpolated (a practice used in Rails code).
#
# @example
#   # from activesupport/lib/active_support/core_ext/string/output_safety.rb
#
#   # bad
#   UNSAFE_STRING_METHODS.each do |unsafe_method|
#   if 'String'.respond_to?(unsafe_method)
#   class_eval <<-EOT, __FILE__, __LINE__ + 1
#   def #{unsafe_method}(*params, &block)
#   to_str.#{unsafe_method}(*params, &block)
#   end
#
#   def #{unsafe_method}!(*params)
#   @dirty = true
#   super
#   end
#   EOT
#   end
#   end
#
#   # good, inline comments in heredoc
#   UNSAFE_STRING_METHODS.each do |unsafe_method|
#   if 'String'.respond_to?(unsafe_method)
#   class_eval <<-EOT, __FILE__, __LINE__ + 1
#   def #{unsafe_method}(*params, &block)       # def capitalize(*params, &block)
#   to_str.#{unsafe_method}(*params, &block)  #   to_str.capitalize(*params, &block)
#   end                                         # end
#
#   def #{unsafe_method}!(*params)              # def capitalize!(*params)
#   @dirty = true                             #   @dirty = true
#   super                                     #   super
#   end                                         # end
#   EOT
#   end
#   end
#
#   # good, block comments in heredoc
#   class_eval <<-EOT, __FILE__, __LINE__ + 1
#   # def capitalize!(*params)
#   #   @dirty = true
#   #   super
#   # end
#
#   def #{unsafe_method}!(*params)
#   @dirty = true
#   super
#   end
#   EOT
#
#   # good, block comments before heredoc
#   class_eval(
#   # def capitalize!(*params)
#   #   @dirty = true
#   #   super
#   # end
#
#   <<-EOT, __FILE__, __LINE__ + 1
#   def #{unsafe_method}!(*params)
#   @dirty = true
#   super
#   end
#   EOT
#   )
#
#   # bad - interpolated string without comment
#   class_eval("def #{unsafe_method}!(*params); end")
#
#   # good - with inline comment or replace it with block comment using heredoc
#   class_eval("def #{unsafe_method}!(*params); end # def capitalize!(*params); end")
class RuboCop::Cop::Style::DocumentDynamicEvalDefinition < ::RuboCop::Cop::Base
  def on_send(node); end

  private

  # @return [Boolean]
  def comment_block_docs?(arg_node); end

  def comment_regexp(arg_node); end
  def heredoc_comment_blocks(heredoc_body); end

  # @return [Boolean]
  def inline_comment_docs?(node); end

  # @return [Boolean]
  def interpolated?(arg_node); end

  def merge_adjacent_comments(line, index, hash); end
  def preceding_comment_blocks(node); end
  def source_to_regexp(source); end
end

RuboCop::Cop::Style::DocumentDynamicEvalDefinition::BLOCK_COMMENT_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::DocumentDynamicEvalDefinition::COMMENT_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::DocumentDynamicEvalDefinition::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::DocumentDynamicEvalDefinition::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for missing top-level documentation of classes and
# modules. Classes with no body are exempt from the check and so are
# namespace modules - modules that have nothing in their bodies except
# classes, other modules, constant definitions or constant visibility
# declarations.
#
# The documentation requirement is annulled if the class or module has
# same for all its children.
#
# @example
#   # bad
#   class Person
#   # ...
#   end
#
#   module Math
#   end
#
#   # good
#   # Description/Explanation of Person class
#   class Person
#   # ...
#   end
#
#   # allowed
#   # Class without body
#   class Person
#   end
#
#   # Namespace - A namespace can be a class or a module
#   # Containing a class
#   module Namespace
#   # Description/Explanation of Person class
#   class Person
#   # ...
#   end
#   end
#
#   # Containing constant visibility declaration
#   module Namespace
#   class Private
#   end
#
#   private_constant :Private
#   end
#
#   # Containing constant definition
#   module Namespace
#   Public = Class.new
#   end
#
#   # Macro calls
#   module Namespace
#   extend Foo
#   end
# @example AllowedConstants: ['ClassMethods']
#
#   # good
#   module A
#   module ClassMethods
#   # ...
#   end
#   end
class RuboCop::Cop::Style::Documentation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::DocumentationComment
  include ::RuboCop::Cop::RangeHelp

  def constant_definition?(param0 = T.unsafe(nil)); end
  def constant_visibility_declaration?(param0 = T.unsafe(nil)); end
  def on_class(node); end
  def on_module(node); end
  def outer_module(param0); end

  private

  def allowed_constants; end
  def check(node, body); end

  # @return [Boolean]
  def compact_namespace?(node); end

  # @return [Boolean]
  def constant_allowed?(node); end

  # @return [Boolean]
  def constant_declaration?(node); end

  def identifier(node); end

  # @return [Boolean]
  def macro_only?(body); end

  # @return [Boolean]
  def namespace?(node); end

  def nodoc(node); end

  # @return [Boolean]
  def nodoc?(comment, require_all: T.unsafe(nil)); end

  # Note: How end-of-line comments are associated with code changed in
  # parser-2.2.0.4.
  #
  # @return [Boolean]
  def nodoc_comment?(node, require_all: T.unsafe(nil)); end

  # @return [Boolean]
  def nodoc_self_or_outer_module?(node); end

  def qualify_const(node); end
end

RuboCop::Cop::Style::Documentation::MSG = T.let(T.unsafe(nil), String)

# Checks for missing documentation comment for public methods.
# It can optionally be configured to also require documentation for
# non-public methods.
#
# @example
#
#   # bad
#
#   class Foo
#   def bar
#   puts baz
#   end
#   end
#
#   module Foo
#   def bar
#   puts baz
#   end
#   end
#
#   def foo.bar
#   puts baz
#   end
#
#   # good
#
#   class Foo
#   # Documentation
#   def bar
#   puts baz
#   end
#   end
#
#   module Foo
#   # Documentation
#   def bar
#   puts baz
#   end
#   end
#
#   # Documentation
#   def foo.bar
#   puts baz
#   end
# @example RequireForNonPublicMethods: false (default)
#   # good
#   class Foo
#   protected
#   def do_something
#   end
#   end
#
#   class Foo
#   private
#   def do_something
#   end
#   end
# @example RequireForNonPublicMethods: true
#   # bad
#   class Foo
#   protected
#   def do_something
#   end
#   end
#
#   class Foo
#   private
#   def do_something
#   end
#   end
#
#   # good
#   class Foo
#   protected
#   # Documentation
#   def do_something
#   end
#   end
#
#   class Foo
#   private
#   # Documentation
#   def do_something
#   end
#   end
class RuboCop::Cop::Style::DocumentationMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::DocumentationComment
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode

  def module_function_node?(param0 = T.unsafe(nil)); end
  def on_def(node); end
  def on_defs(node); end

  private

  def check(node); end

  # @return [Boolean]
  def require_for_non_public_methods?; end
end

RuboCop::Cop::Style::DocumentationMethod::MSG = T.let(T.unsafe(nil), String)

# Detects double disable comments on one line. This is mostly to catch
# automatically generated comments that need to be regenerated.
#
# @example
#   # bad
#   def f # rubocop:disable Style/For # rubocop:disable Metrics/AbcSize
#   end
#
#   # good
#   # rubocop:disable Metrics/AbcSize
#   def f # rubocop:disable Style/For
#   end
#   # rubocop:enable Metrics/AbcSize
#
#   # if both fit on one line
#   def f # rubocop:disable Style/For, Metrics/AbcSize
#   end
class RuboCop::Cop::Style::DoubleCopDisableDirective < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
end

RuboCop::Cop::Style::DoubleCopDisableDirective::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of double negation (`!!`) to convert something to a boolean value.
#
# When using `EnforcedStyle: allowed_in_returns`, allow double negation in contexts
# that use boolean as a return value. When using `EnforcedStyle: forbidden`, double negation
# should be forbidden always.
#
# NOTE: when `something` is a boolean value
# `!!something` and `!something.nil?` are not the same thing.
# As you're unlikely to write code that can accept values of any type
# this is rarely a problem in practice.
#
# @example
#   # bad
#   !!something
#
#   # good
#   !something.nil?
# @example EnforcedStyle: allowed_in_returns (default)
#   # good
#   def foo?
#   !!return_value
#   end
#
#   define_method :foo? do
#   !!return_value
#   end
#
#   define_singleton_method :foo? do
#   !!return_value
#   end
# @example EnforcedStyle: forbidden
#   # bad
#   def foo?
#   !!return_value
#   end
#
#   define_method :foo? do
#   !!return_value
#   end
#
#   define_singleton_method :foo? do
#   !!return_value
#   end
class RuboCop::Cop::Style::DoubleNegation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def double_negative?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_in_returns?(node); end

  # @return [Boolean]
  def define_mehod?(node); end

  # @return [Boolean]
  def double_negative_condition_return_value?(node, last_child, conditional_node); end

  # @return [Boolean]
  def end_of_method_definition?(node); end

  def find_conditional_node_from_ascendant(node); end
  def find_def_node_from_ascendant(node); end
  def find_last_child(node); end
  def find_parent_not_enumerable(node); end
end

RuboCop::Cop::Style::DoubleNegation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::DoubleNegation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for loops which iterate a constant number of times,
# using a Range literal and `#each`. This can be done more readably using
# `Integer#times`.
#
# This check only applies if the block takes no parameters.
#
# @example
#   # bad
#   (1..5).each { }
#
#   # good
#   5.times { }
# @example
#   # bad
#   (0...10).each {}
#
#   # good
#   10.times {}
class RuboCop::Cop::Style::EachForSimpleLoop < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def offending_each_range(param0 = T.unsafe(nil)); end
  def on_block(node); end
end

RuboCop::Cop::Style::EachForSimpleLoop::MSG = T.let(T.unsafe(nil), String)

# Looks for inject / reduce calls where the passed in object is
# returned at the end and so could be replaced by each_with_object without
# the need to return the object at the end.
#
# However, we can't replace with each_with_object if the accumulator
# parameter is assigned to within the block.
#
# @example
#   # bad
#   [1, 2].inject({}) { |a, e| a[e] = e; a }
#
#   # good
#   [1, 2].each_with_object({}) { |e, a| a[e] = e }
class RuboCop::Cop::Style::EachWithObject < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def each_with_object_block_candidate?(param0 = T.unsafe(nil)); end
  def each_with_object_numblock_candidate?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_numblock(node); end

  private

  # if the accumulator parameter is assigned to in the block,
  # then we can't convert to each_with_object
  #
  # @return [Boolean]
  def accumulator_param_assigned_to?(body, args); end

  def autocorrect_block(corrector, node, return_value); end
  def autocorrect_numblock(corrector, node); end

  # @return [Boolean]
  def first_argument_returned?(args, return_value); end

  def return_value(body); end

  # @return [Boolean]
  def return_value_occupies_whole_line?(node); end

  # @return [Boolean]
  def simple_method_arg?(method_arg); end

  def whole_line_expression(node); end
end

RuboCop::Cop::Style::EachWithObject::METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::EachWithObject::MSG = T.let(T.unsafe(nil), String)

# Checks for pipes for empty block parameters. Pipes for empty
# block parameters do not cause syntax errors, but they are redundant.
#
# @example
#   # bad
#   a do ||
#   do_something
#   end
#
#   # bad
#   a { || do_something }
#
#   # good
#   a do
#   end
#
#   # good
#   a { do_something }
class RuboCop::Cop::Style::EmptyBlockParameter < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EmptyParameter
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end

  private

  def autocorrect(corrector, node); end
end

RuboCop::Cop::Style::EmptyBlockParameter::MSG = T.let(T.unsafe(nil), String)

# Checks for case statements with an empty condition.
#
# @example
#
#   # bad:
#   case
#   when x == 0
#   puts 'x is 0'
#   when y == 0
#   puts 'y is 0'
#   else
#   puts 'neither is 0'
#   end
#
#   # good:
#   if x == 0
#   puts 'x is 0'
#   elsif y == 0
#   puts 'y is 0'
#   else
#   puts 'neither is 0'
#   end
#
#   # good: (the case condition node is not empty)
#   case n
#   when 0
#   puts 'zero'
#   when 1
#   puts 'one'
#   else
#   puts 'more'
#   end
class RuboCop::Cop::Style::EmptyCaseCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(case_node); end

  private

  def autocorrect(corrector, case_node); end
  def correct_case_when(corrector, case_node, when_nodes); end
  def correct_when_conditions(corrector, when_nodes); end
  def keep_first_when_comment(case_range, corrector); end
  def replace_then_with_line_break(corrector, conditions, when_node); end
end

RuboCop::Cop::Style::EmptyCaseCondition::MSG = T.let(T.unsafe(nil), String)

# Checks for empty else-clauses, possibly including comments and/or an
# explicit `nil` depending on the EnforcedStyle.
#
# @example EnforcedStyle: both (default)
#   # warn on empty else and else with nil in it
#
#   # bad
#   if condition
#   statement
#   else
#   nil
#   end
#
#   # bad
#   if condition
#   statement
#   else
#   end
#
#   # good
#   if condition
#   statement
#   else
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   end
# @example EnforcedStyle: empty
#   # warn only on empty else
#
#   # bad
#   if condition
#   statement
#   else
#   end
#
#   # good
#   if condition
#   statement
#   else
#   nil
#   end
#
#   # good
#   if condition
#   statement
#   else
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   end
# @example EnforcedStyle: nil
#   # warn on else with nil in it
#
#   # bad
#   if condition
#   statement
#   else
#   nil
#   end
#
#   # good
#   if condition
#   statement
#   else
#   end
#
#   # good
#   if condition
#   statement
#   else
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   end
# @example AllowComments: false (default)
#
#   # bad
#   if condition
#   statement
#   else
#   # something comment
#   nil
#   end
#
#   # bad
#   if condition
#   statement
#   else
#   # something comment
#   end
# @example AllowComments: true
#
#   # good
#   if condition
#   statement
#   else
#   # something comment
#   nil
#   end
#
#   # good
#   if condition
#   statement
#   else
#   # something comment
#   end
class RuboCop::Cop::Style::EmptyElse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OnNormalIfUnless
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(node); end
  def on_normal_if_unless(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def autocorrect_forbidden?(type); end

  def base_node(node); end
  def check(node); end

  # @return [Boolean]
  def comment_in_else?(loc); end

  def empty_check(node); end

  # @return [Boolean]
  def empty_style?; end

  def missing_else_style; end
  def nil_check(node); end

  # @return [Boolean]
  def nil_style?; end
end

RuboCop::Cop::Style::EmptyElse::MSG = T.let(T.unsafe(nil), String)

# Checks for using empty heredoc to reduce redundancy.
#
# @example
#
#   # bad
#   <<~EOS
#   EOS
#
#   <<-EOS
#   EOS
#
#   <<EOS
#   EOS
#
#   # good
#   ''
#
#   # bad
#   do_something(<<~EOS)
#   EOS
#
#   do_something(<<-EOS)
#   EOS
#
#   do_something(<<EOS)
#   EOS
#
#   # good
#   do_something('')
class RuboCop::Cop::Style::EmptyHeredoc < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Heredoc
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_heredoc(node); end

  private

  # @return [Boolean]
  def enforce_double_quotes?; end

  def preferred_string_literal; end
  def string_literals_config; end
end

RuboCop::Cop::Style::EmptyHeredoc::MSG = T.let(T.unsafe(nil), String)

# Checks for parentheses for empty lambda parameters. Parentheses
# for empty lambda parameters do not cause syntax errors, but they are
# redundant.
#
# @example
#   # bad
#   -> () { do_something }
#
#   # good
#   -> { do_something }
#
#   # good
#   -> (arg) { do_something(arg) }
class RuboCop::Cop::Style::EmptyLambdaParameter < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::EmptyParameter
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end

  private

  def autocorrect(corrector, node); end
end

RuboCop::Cop::Style::EmptyLambdaParameter::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of a method, the result of which
# would be a literal, like an empty array, hash, or string.
#
# @example
#   # bad
#   a = Array.new
#   h = Hash.new
#   s = String.new
#
#   # good
#   a = []
#   h = {}
#   s = ''
class RuboCop::Cop::Style::EmptyLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def array_node(param0 = T.unsafe(nil)); end
  def array_with_block(param0 = T.unsafe(nil)); end
  def hash_node(param0 = T.unsafe(nil)); end
  def hash_with_block(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def str_node(param0 = T.unsafe(nil)); end

  private

  def correction(node); end

  # @return [Boolean]
  def enforce_double_quotes?; end

  # @return [Boolean]
  def first_argument_unparenthesized?(node); end

  # @return [Boolean]
  def frozen_strings?; end

  # @return [Boolean]
  def offense_array_node?(node); end

  # @return [Boolean]
  def offense_hash_node?(node); end

  def offense_message(node); end
  def preferred_string_literal; end
  def replacement_range(node); end
  def string_literals_config; end
end

RuboCop::Cop::Style::EmptyLiteral::ARR_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EmptyLiteral::HASH_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EmptyLiteral::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::EmptyLiteral::STR_MSG = T.let(T.unsafe(nil), String)

# Checks for the formatting of empty method definitions.
# By default it enforces empty method definitions to go on a single
# line (compact style), but it can be configured to enforce the `end`
# to go on its own line (expanded style).
#
# NOTE: A method definition is not considered empty if it contains
# comments.
#
# NOTE: Autocorrection will not be applied for the `compact` style
# if the resulting code is longer than the `Max` configuration for
# `Layout/LineLength`, but an offense will still be registered.
#
# @example EnforcedStyle: compact (default)
#   # bad
#   def foo(bar)
#   end
#
#   def self.foo(bar)
#   end
#
#   # good
#   def foo(bar); end
#
#   def foo(bar)
#   # baz
#   end
#
#   def self.foo(bar); end
# @example EnforcedStyle: expanded
#   # bad
#   def foo(bar); end
#
#   def self.foo(bar); end
#
#   # good
#   def foo(bar)
#   end
#
#   def self.foo(bar)
#   end
class RuboCop::Cop::Style::EmptyMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def compact?(node); end

  # @return [Boolean]
  def compact_style?; end

  # @return [Boolean]
  def correct_style?(node); end

  def corrected(node); end

  # @return [Boolean]
  def expanded?(node); end

  # @return [Boolean]
  def expanded_style?; end

  def joint(node); end
  def max_line_length; end
  def message(_range); end
end

RuboCop::Cop::Style::EmptyMethod::MSG_COMPACT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EmptyMethod::MSG_EXPANDED = T.let(T.unsafe(nil), String)

# Checks ensures source files have no utf-8 encoding comments.
#
# @example
#   # bad
#   # encoding: UTF-8
#   # coding: UTF-8
#   # -*- coding: UTF-8 -*-
class RuboCop::Cop::Style::Encoding < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def comments; end

  # @return [Boolean]
  def offense?(comment); end

  def register_offense(line_number, comment); end
end

RuboCop::Cop::Style::Encoding::ENCODING_PATTERN = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::Encoding::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Encoding::SHEBANG = T.let(T.unsafe(nil), String)

# Checks for END blocks.
#
# @example
#   # bad
#   END { puts 'Goodbye!' }
#
#   # good
#   at_exit { puts 'Goodbye!' }
class RuboCop::Cop::Style::EndBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_postexe(node); end
end

RuboCop::Cop::Style::EndBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for endless methods.
#
# It can enforce either the use of endless methods definitions
# for single-lined method bodies, or disallow endless methods.
#
# Other method definition types are not considered by this cop.
#
# The supported styles are:
#
# * allow_single_line (default) - only single line endless method definitions are allowed.
# * allow_always - all endless method definitions are allowed.
# * disallow - all endless method definitions are disallowed.
#
# NOTE: Incorrect endless method definitions will always be
# corrected to a multi-line definition.
#
# @example EnforcedStyle: allow_single_line (default)
#   # good
#   def my_method() = x
#
#   # bad, multi-line endless method
#   def my_method() = x.foo
#   .bar
#   .baz
# @example EnforcedStyle: allow_always
#   # good
#   def my_method() = x
#
#   # good
#   def my_method() = x.foo
#   .bar
#   .baz
# @example EnforcedStyle: disallow
#   # bad
#   def my_method; x end
#
#   # bad
#   def my_method() = x.foo
#   .bar
#   .baz
class RuboCop::Cop::Style::EndlessMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::TargetRubyVersion
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end

  private

  def arguments(node, missing = T.unsafe(nil)); end
  def correct_to_multiline(corrector, node); end
  def handle_allow_style(node); end
  def handle_disallow_style(node); end
end

RuboCop::Cop::Style::EndlessMethod::CORRECTION_STYLES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::EndlessMethod::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EndlessMethod::MSG_MULTI_LINE = T.let(T.unsafe(nil), String)

# Checks for consistent usage of `ENV['HOME']`. If `nil` is used as
# the second argument of `ENV.fetch`, it is treated as a bad case like `ENV[]`.
#
# @example
#
#   # bad
#   ENV['HOME']
#   ENV.fetch('HOME', nil)
#
#   # good
#   Dir.home
#
#   # good
#   ENV.fetch('HOME', default)
class RuboCop::Cop::Style::EnvHome < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def env_home?(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Style::EnvHome::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EnvHome::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Ensures that eval methods (`eval`, `instance_eval`, `class_eval`
# and `module_eval`) are given filename and line number values (`__FILE__`
# and `__LINE__`). This data is used to ensure that any errors raised
# within the evaluated code will be given the correct identification
# in a backtrace.
#
# The cop also checks that the line number given relative to `__LINE__` is
# correct.
#
# This cop will autocorrect incorrect or missing filename and line number
# values. However, if `eval` is called without a binding argument, the cop
# will not attempt to automatically add a binding, or add filename and
# line values.
#
# This cop works only when a string literal is given as a code string.
# No offense is reported if a string variable is given as below:
#
# @example
#   # bad
#   eval <<-RUBY
#   def do_something
#   end
#   RUBY
#
#   # bad
#   C.class_eval <<-RUBY
#   def do_something
#   end
#   RUBY
#
#   # good
#   eval <<-RUBY, binding, __FILE__, __LINE__ + 1
#   def do_something
#   end
#   RUBY
#
#   # good
#   C.class_eval <<-RUBY, __FILE__, __LINE__ + 1
#   def do_something
#   end
#   RUBY
# @example
#   # not checked
#   code = <<-RUBY
#   def do_something
#   end
#   RUBY
#   eval code
class RuboCop::Cop::Style::EvalWithLocation < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def line_with_offset?(param0 = T.unsafe(nil), param1, param2); end
  def on_send(node); end
  def valid_eval_receiver?(param0 = T.unsafe(nil)); end

  private

  def add_offense_for_different_line(node, line_node, line_diff); end
  def add_offense_for_incorrect_line(method_name, line_node, sign, line_diff); end
  def add_offense_for_missing_line(node, code); end
  def add_offense_for_missing_location(node, code); end
  def add_offense_for_same_line(node, line_node); end
  def check_file(node, file_node); end
  def check_line(node, code); end
  def check_location(node, code); end
  def expected_line(sign, line_diff); end
  def file_and_line(node); end
  def line_difference(line_node, code); end
  def missing_line(node, code); end
  def register_offense(node, &block); end

  # @return [Boolean]
  def special_file_keyword?(node); end

  # @return [Boolean]
  def special_line_keyword?(node); end

  def string_first_line(str_node); end

  # @return [Boolean]
  def with_binding?(node); end

  # FIXME: It's a Style/ConditionalAssignment's false positive.
  #
  # @return [Boolean]
  def with_lineno?(node); end
end

RuboCop::Cop::Style::EvalWithLocation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EvalWithLocation::MSG_EVAL = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EvalWithLocation::MSG_INCORRECT_FILE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EvalWithLocation::MSG_INCORRECT_LINE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EvalWithLocation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where `Integer#even?` or `Integer#odd?`
# can be used.
#
# @example
#
#   # bad
#   if x % 2 == 0
#   end
#
#   # good
#   if x.even?
#   end
class RuboCop::Cop::Style::EvenOdd < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def even_odd_candidate?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def replacement_method(arg, method); end
end

RuboCop::Cop::Style::EvenOdd::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::EvenOdd::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for use of the `File.expand_path` arguments.
# Likewise, it also checks for the `Pathname.new` argument.
#
# Contrastive bad case and good case are alternately shown in
# the following examples.
#
# @example
#   # bad
#   File.expand_path('..', __FILE__)
#
#   # good
#   File.expand_path(__dir__)
#
#   # bad
#   File.expand_path('../..', __FILE__)
#
#   # good
#   File.expand_path('..', __dir__)
#
#   # bad
#   File.expand_path('.', __FILE__)
#
#   # good
#   File.expand_path(__FILE__)
#
#   # bad
#   Pathname(__FILE__).parent.expand_path
#
#   # good
#   Pathname(__dir__).expand_path
#
#   # bad
#   Pathname.new(__FILE__).parent.expand_path
#
#   # good
#   Pathname.new(__dir__).expand_path
class RuboCop::Cop::Style::ExpandPathArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def file_expand_path(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def pathname_new_parent_expand_path(param0 = T.unsafe(nil)); end
  def pathname_parent_expand_path(param0 = T.unsafe(nil)); end

  private

  def arguments_range(node); end
  def autocorrect(corrector, node); end
  def autocorrect_expand_path(corrector, current_path, default_dir); end
  def depth(current_path); end
  def inspect_offense_for_expand_path(node, current_path, default_dir); end
  def parent_path(current_path); end
  def remove_parent_method(corrector, default_dir); end
  def strip_surrounded_quotes!(path_string); end

  # @return [Boolean]
  def unrecommended_argument?(default_dir); end
end

RuboCop::Cop::Style::ExpandPathArguments::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ExpandPathArguments::PATHNAME_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ExpandPathArguments::PATHNAME_NEW_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ExpandPathArguments::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of explicit block argument to avoid writing
# block literal that just passes its arguments to another block.
#
# NOTE: This cop only registers an offense if the block args match the
# yield args exactly.
#
# @example
#   # bad
#   def with_tmp_dir
#   Dir.mktmpdir do |tmp_dir|
#   Dir.chdir(tmp_dir) { |dir| yield dir } # block just passes arguments
#   end
#   end
#
#   # bad
#   def nine_times
#   9.times { yield }
#   end
#
#   # good
#   def with_tmp_dir(&block)
#   Dir.mktmpdir do |tmp_dir|
#   Dir.chdir(tmp_dir, &block)
#   end
#   end
#
#   with_tmp_dir do |dir|
#   puts "dir is accessible as a parameter and pwd is set: #{dir}"
#   end
#
#   # good
#   def nine_times(&block)
#   9.times(&block)
#   end
class RuboCop::Cop::Style::ExplicitBlockArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # @return [ExplicitBlockArgument] a new instance of ExplicitBlockArgument
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  def on_yield(node); end
  def yielding_block?(param0 = T.unsafe(nil)); end

  private

  def add_block_argument(node, corrector, block_name); end
  def block_body_range(block_node, send_node); end

  # @return [Boolean]
  def call_like?(node); end

  def correct_call_node(node, corrector, block_name); end

  # @return [Boolean]
  def empty_arguments?(node); end

  def extract_block_name(def_node); end
  def insert_argument(node, corrector, block_name); end

  # @return [Boolean]
  def yielding_arguments?(block_args, yield_args); end
end

RuboCop::Cop::Style::ExplicitBlockArgument::MSG = T.let(T.unsafe(nil), String)

# Enforces consistency when using exponential notation
# for numbers in the code (eg 1.2e4). Different styles are supported:
#
# * `scientific` which enforces a mantissa between 1 (inclusive) and 10 (exclusive).
# * `engineering` which enforces the exponent to be a multiple of 3 and the mantissa
#   to be between 0.1 (inclusive) and 10 (exclusive).
# * `integral` which enforces the mantissa to always be a whole number without
#   trailing zeroes.
#
# @example EnforcedStyle: scientific (default)
#   # Enforces a mantissa between 1 (inclusive) and 10 (exclusive).
#
#   # bad
#   10e6
#   0.3e4
#   11.7e5
#   3.14e0
#
#   # good
#   1e7
#   3e3
#   1.17e6
#   3.14
# @example EnforcedStyle: engineering
#   # Enforces using multiple of 3 exponents,
#   # mantissa should be between 0.1 (inclusive) and 1000 (exclusive)
#
#   # bad
#   3.2e7
#   0.1e5
#   12e5
#   1232e6
#
#   # good
#   32e6
#   10e3
#   1.2e6
#   1.232e9
# @example EnforcedStyle: integral
#   # Enforces the mantissa to have no decimal part and no
#   # trailing zeroes.
#
#   # bad
#   3.2e7
#   0.1e5
#   120e4
#
#   # good
#   32e6
#   1e4
#   12e5
class RuboCop::Cop::Style::ExponentialNotation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def on_float(node); end

  private

  # @return [Boolean]
  def engineering?(node); end

  def integral(node); end
  def message(_node); end

  # @return [Boolean]
  def offense?(node); end

  # @return [Boolean]
  def scientific?(node); end
end

RuboCop::Cop::Style::ExponentialNotation::MESSAGES = T.let(T.unsafe(nil), Hash)

# Suggests `ENV.fetch` for the replacement of `ENV[]`.
# `ENV[]` silently fails and returns `nil` when the environment variable is unset,
# which may cause unexpected behaviors when the developer forgets to set it.
# On the other hand, `ENV.fetch` raises KeyError or returns the explicitly
# specified default value.
#
# @example
#   # bad
#   ENV['X']
#   x = ENV['X']
#
#   # good
#   ENV.fetch('X')
#   x = ENV.fetch('X')
#
#   # also good
#   !ENV['X']
#   ENV['X'].some_method # (e.g. `.nil?`)
class RuboCop::Cop::Style::FetchEnvVar < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def env_with_bracket?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # The following are allowed cases:
  #
  # - Used as a flag (e.g., `if ENV['X']` or `!ENV['X']`) because
  #   it simply checks whether the variable is set.
  # - Receiving a message with dot syntax, e.g. `ENV['X'].nil?`.
  # - `ENV['key']` assigned by logical AND/OR assignment.
  # - `ENV['key']` is the LHS of a `||`.
  #
  # @return [Boolean]
  def allowable_use?(node); end

  # @return [Boolean]
  def allowed_var?(node); end

  # The following are allowed cases:
  #
  # - `ENV['key']` is a receiver of `||=`, e.g. `ENV['X'] ||= y`.
  # - `ENV['key']` is a receiver of `&&=`, e.g. `ENV['X'] &&= y`.
  #
  # @return [Boolean]
  def assigned?(node); end

  # Check if the node is a receiver and receives a message with dot syntax.
  #
  # @return [Boolean]
  def message_chained_with_dot?(node); end

  def new_code(name_node); end

  # @return [Boolean]
  def offensive?(node); end

  # @return [Boolean]
  def or_lhs?(node); end

  # Avoid offending in the following cases:
  # `ENV['key'] if ENV['key'] = x`
  #
  # @return [Boolean]
  def partial_matched?(node, condition); end

  # @return [Boolean]
  def used_as_flag?(node); end

  def used_if_condition_in_body(node); end

  # @return [Boolean]
  def used_in_condition?(node, condition); end
end

RuboCop::Cop::Style::FetchEnvVar::MSG = T.let(T.unsafe(nil), String)

# Favor `File.(bin)read` convenience methods.
#
# @example
#   ## text mode
#   # bad
#   File.open(filename).read
#   File.open(filename, &:read)
#   File.open(filename) { |f| f.read }
#   File.open(filename) do |f|
#   f.read
#   end
#   File.open(filename, 'r').read
#   File.open(filename, 'r', &:read)
#   File.open(filename, 'r') do |f|
#   f.read
#   end
#
#   # good
#   File.read(filename)
# @example
#   ## binary mode
#   # bad
#   File.open(filename, 'rb').read
#   File.open(filename, 'rb', &:read)
#   File.open(filename, 'rb') do |f|
#   f.read
#   end
#
#   # good
#   File.binread(filename)
class RuboCop::Cop::Style::FileRead < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def block_read?(param0 = T.unsafe(nil)); end
  def file_open?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def send_read?(param0 = T.unsafe(nil)); end

  private

  def evidence(node); end

  # @return [Boolean]
  def file_open_read?(node); end

  def read_method(mode); end

  # @return [Boolean]
  def read_node?(node, block_pass); end
end

RuboCop::Cop::Style::FileRead::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FileRead::READ_FILE_START_TO_FINISH_MODES = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Style::FileRead::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Favor `File.(bin)write` convenience methods.
#
# NOTE: There are different method signatures between `File.write` (class method)
# and `File#write` (instance method). The following case will be allowed because
# static analysis does not know the contents of the splat argument:
#
# [source,ruby]
# ----
# File.open(filename, 'w') do |f|
#   f.write(*objects)
# end
# ----
#
# @example
#   ## text mode
#   # bad
#   File.open(filename, 'w').write(content)
#   File.open(filename, 'w') do |f|
#   f.write(content)
#   end
#
#   # good
#   File.write(filename, content)
# @example
#   ## binary mode
#   # bad
#   File.open(filename, 'wb').write(content)
#   File.open(filename, 'wb') do |f|
#   f.write(content)
#   end
#
#   # good
#   File.binwrite(filename, content)
class RuboCop::Cop::Style::FileWrite < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def block_write?(param0 = T.unsafe(nil)); end
  def evidence(node); end
  def file_open?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def send_write?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  # @yield [content]
  def file_open_write?(node); end

  # @return [Boolean]
  def heredoc?(write_node); end

  def heredoc_range(first_argument); end
  def replacement(mode, filename, content, write_node); end
  def write_method(mode); end
end

RuboCop::Cop::Style::FileWrite::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FileWrite::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Style::FileWrite::TRUNCATING_WRITE_MODES = T.let(T.unsafe(nil), Set)

# Checks for division with integers coerced to floats.
# It is recommended to either always use `fdiv` or coerce one side only.
# This cop also provides other options for code consistency.
#
# @example EnforcedStyle: single_coerce (default)
#   # bad
#   a.to_f / b.to_f
#
#   # good
#   a.to_f / b
#   a / b.to_f
# @example EnforcedStyle: left_coerce
#   # bad
#   a / b.to_f
#   a.to_f / b.to_f
#
#   # good
#   a.to_f / b
# @example EnforcedStyle: right_coerce
#   # bad
#   a.to_f / b
#   a.to_f / b.to_f
#
#   # good
#   a / b.to_f
# @example EnforcedStyle: fdiv
#   # bad
#   a / b.to_f
#   a.to_f / b
#   a.to_f / b.to_f
#
#   # good
#   a.fdiv(b)
class RuboCop::Cop::Style::FloatDivision < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def any_coerce?(param0 = T.unsafe(nil)); end
  def both_coerce?(param0 = T.unsafe(nil)); end
  def left_coerce?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def right_coerce?(param0 = T.unsafe(nil)); end

  private

  def add_to_f_method(corrector, node); end
  def correct_from_slash_to_fdiv(corrector, node, receiver, argument); end
  def extract_receiver_source(node); end
  def message(_node); end

  # @return [Boolean]
  def offense_condition?(node); end

  def remove_to_f_method(corrector, send_node); end
end

RuboCop::Cop::Style::FloatDivision::MESSAGES = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::FloatDivision::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for uses of the `for` keyword or `each` method. The
# preferred alternative is set in the EnforcedStyle configuration
# parameter. An `each` call with a block on a single line is always
# allowed.
#
# @example EnforcedStyle: each (default)
#   # bad
#   def foo
#   for n in [1, 2, 3] do
#   puts n
#   end
#   end
#
#   # good
#   def foo
#   [1, 2, 3].each do |n|
#   puts n
#   end
#   end
# @example EnforcedStyle: for
#   # bad
#   def foo
#   [1, 2, 3].each do |n|
#   puts n
#   end
#   end
#
#   # good
#   def foo
#   for n in [1, 2, 3] do
#   puts n
#   end
#   end
class RuboCop::Cop::Style::For < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_for(node); end
  def on_numblock(node); end

  private

  # @return [Boolean]
  def suspect_enumerable?(node); end
end

RuboCop::Cop::Style::For::EACH_LENGTH = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Style::For::PREFER_EACH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::For::PREFER_FOR = T.let(T.unsafe(nil), String)

# Enforces the use of a single string formatting utility.
# Valid options include Kernel#format, Kernel#sprintf and String#%.
#
# The detection of String#% cannot be implemented in a reliable
# manner for all cases, so only two scenarios are considered -
# if the first argument is a string literal and if the second
# argument is an array literal.
#
# @example EnforcedStyle: format (default)
#   # bad
#   puts sprintf('%10s', 'hoge')
#   puts '%10s' % 'hoge'
#
#   # good
#   puts format('%10s', 'hoge')
# @example EnforcedStyle: sprintf
#   # bad
#   puts format('%10s', 'hoge')
#   puts '%10s' % 'hoge'
#
#   # good
#   puts sprintf('%10s', 'hoge')
# @example EnforcedStyle: percent
#   # bad
#   puts format('%10s', 'hoge')
#   puts sprintf('%10s', 'hoge')
#
#   # good
#   puts '%10s' % 'hoge'
class RuboCop::Cop::Style::FormatString < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def formatter(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def variable_argument?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def autocorrect_from_percent(corrector, node); end
  def autocorrect_to_percent(corrector, node); end
  def format_single_parameter(arg); end
  def message(detected_style); end
  def method_name(style_name); end
end

RuboCop::Cop::Style::FormatString::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FormatString::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Use a consistent style for named format string tokens.
#
# NOTE: `unannotated` style cop only works for strings
# which are passed as arguments to those methods:
# `printf`, `sprintf`, `format`, `%`.
# The reason is that _unannotated_ format is very similar
# to encoded URLs or Date/Time formatting strings.
#
# This cop can be customized allowed methods with `AllowedMethods`.
# By default, there are no methods to allowed.
#
# It is allowed to contain unannotated token
# if the number of them is less than or equals to
# `MaxUnannotatedPlaceholdersAllowed`.
#
# @example AllowedPatterns: [/redirect/]
#
#   # good
#   redirect('foo/%{bar_id}')
# @example EnforcedStyle: template
#
#   # bad
#   format('%<greeting>s', greeting: 'Hello')
#   format('%s', 'Hello')
#
#   # good
#   format('%{greeting}', greeting: 'Hello')
# @example EnforcedStyle: unannotated
#
#   # bad
#   format('%<greeting>s', greeting: 'Hello')
#   format('%{greeting}', greeting: 'Hello')
#
#   # good
#   format('%s', 'Hello')
# @example MaxUnannotatedPlaceholdersAllowed: 0
#
#   # bad
#   format('%06d', 10)
#   format('%s %s.', 'Hello', 'world')
#
#   # good
#   format('%<number>06d', number: 10)
# @example MaxUnannotatedPlaceholdersAllowed: 1 (default)
#
#   # bad
#   format('%s %s.', 'Hello', 'world')
#
#   # good
#   format('%06d', 10)
# @example AllowedMethods: [] (default)
#
#   # bad
#   redirect('foo/%{bar_id}')
# @example AllowedMethods: [redirect]
#
#   # good
#   redirect('foo/%{bar_id}')
# @example AllowedPatterns: [] (default)
#
#   # bad
#   redirect('foo/%{bar_id}')
# @example EnforcedStyle: annotated (default)
#
#   # bad
#   format('%{greeting}', greeting: 'Hello')
#   format('%s', 'Hello')
#
#   # good
#   format('%<greeting>s', greeting: 'Hello')
class RuboCop::Cop::Style::FormatStringToken < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def format_string_in_typical_context?(param0 = T.unsafe(nil)); end
  def on_str(node); end

  private

  # @return [Boolean]
  def allowed_unannotated?(detections); end

  def autocorrect_sequence(corrector, detected_sequence, token_range); end
  def check_sequence(detected_sequence, token_range); end
  def collect_detections(node); end

  # @return [Boolean]
  def correctable_sequence?(detected_type); end

  # @return [Boolean]
  def format_string_token?(node); end

  def max_unannotated_placeholders_allowed; end
  def message(detected_style); end
  def message_text(style); end
  def str_contents(source_map); end
  def token_ranges(contents); end
  def tokens(str_node, &block); end

  # @return [Boolean]
  def unannotated_format?(node, detected_style); end

  # @return [Boolean]
  def use_allowed_method?(node); end
end

# Helps you transition from mutable string literals
# to frozen string literals.
# of files to enable frozen string literals. Frozen string literals may be
# default in future Ruby. The comment will be added below a shebang and
# encoding comment. The frozen string literal comment is only valid in Ruby 2.3+.
#
# Note that the cop will accept files where the comment exists but is set
# to `false` instead of `true`.
#
# To require a blank line after this comment, please see
# `Layout/EmptyLineAfterMagicComment` cop.
#
# @example EnforcedStyle: always (default)
#   # The `always` style will always add the frozen string literal comment
#   # to a file, regardless of the Ruby version or if `freeze` or `<<` are
#   # called on a string literal.
#   # bad
#   module Bar
#   # ...
#   end
#
#   # good
#   # frozen_string_literal: true
#
#   module Bar
#   # ...
#   end
#
#   # good
#   # frozen_string_literal: false
#
#   module Bar
#   # ...
#   end
# @example EnforcedStyle: never
#   # The `never` will enforce that the frozen string literal comment does
#   # not exist in a file.
#   # bad
#   # frozen_string_literal: true
#
#   module Baz
#   # ...
#   end
#
#   # good
#   module Baz
#   # ...
#   end
# @example EnforcedStyle: always_true
#   # The `always_true` style enforces that the frozen string literal
#   # comment is set to `true`. This is a stricter option than `always`
#   # and forces projects to use frozen string literals.
#   # bad
#   # frozen_string_literal: false
#
#   module Baz
#   # ...
#   end
#
#   # bad
#   module Baz
#   # ...
#   end
#
#   # good
#   # frozen_string_literal: true
#
#   module Bar
#   # ...
#   end
class RuboCop::Cop::Style::FrozenStringLiteralComment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::FrozenStringLiteral
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_new_investigation; end

  private

  def disabled_offense(processed_source); end
  def enable_comment(corrector); end
  def ensure_comment(processed_source); end
  def ensure_enabled_comment(processed_source); end
  def ensure_no_comment(processed_source); end
  def following_comment; end
  def frozen_string_literal_comment(processed_source); end
  def insert_comment(corrector); end
  def last_special_comment(processed_source); end
  def line_range(line); end
  def missing_offense(processed_source); end
  def missing_true_offense(processed_source); end
  def preceding_comment; end
  def remove_comment(corrector, node); end
  def unnecessary_comment_offense(processed_source); end
end

RuboCop::Cop::Style::FrozenStringLiteralComment::MSG_DISABLED = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FrozenStringLiteralComment::MSG_MISSING = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FrozenStringLiteralComment::MSG_MISSING_TRUE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FrozenStringLiteralComment::MSG_UNNECESSARY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::FrozenStringLiteralComment::SHEBANG = T.let(T.unsafe(nil), String)

# Enforces the use of `$stdout/$stderr/$stdin` instead of `STDOUT/STDERR/STDIN`.
# `STDOUT/STDERR/STDIN` are constants, and while you can actually
# reassign (possibly to redirect some stream) constants in Ruby, you'll get
# an interpreter warning if you do so.
#
# @example
#   # bad
#   STDOUT.puts('hello')
#
#   hash = { out: STDOUT, key: value }
#
#   def m(out = STDOUT)
#   out.puts('hello')
#   end
#
#   # good
#   $stdout.puts('hello')
#
#   hash = { out: $stdout, key: value }
#
#   def m(out = $stdout)
#   out.puts('hello')
#   end
class RuboCop::Cop::Style::GlobalStdStream < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def const_to_gvar_assignment?(param0 = T.unsafe(nil), param1); end
  def on_const(node); end

  private

  def gvar_name(const_name); end
  def message(const_name); end
end

RuboCop::Cop::Style::GlobalStdStream::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::GlobalStdStream::STD_STREAMS = T.let(T.unsafe(nil), Set)

# Looks for uses of global variables.
# It does not report offenses for built-in global variables.
# Built-in global variables are allowed by default. Additionally
# users can allow additional variables via the AllowedVariables option.
#
# Note that backreferences like $1, $2, etc are not global variables.
#
# @example
#   # bad
#   $foo = 2
#   bar = $foo + 5
#
#   # good
#   FOO = 2
#   foo = 2
#   $stdin.read
class RuboCop::Cop::Style::GlobalVars < ::RuboCop::Cop::Base
  # @return [Boolean]
  def allowed_var?(global_var); end

  def check(node); end
  def on_gvar(node); end
  def on_gvasgn(node); end
  def user_vars; end
end

# built-in global variables and their English aliases
# https://www.zenspider.com/ruby/quickref.html
RuboCop::Cop::Style::GlobalVars::BUILT_IN_VARS = T.let(T.unsafe(nil), Array)

RuboCop::Cop::Style::GlobalVars::MSG = T.let(T.unsafe(nil), String)

# Use a guard clause instead of wrapping the code inside a conditional
# expression
#
# A condition with an `elsif` or `else` branch is allowed unless
# one of `return`, `break`, `next`, `raise`, or `fail` is used
# in the body of the conditional expression.
#
# @example
#   # bad
#   def test
#   if something
#   work
#   end
#   end
#
#   # good
#   def test
#   return unless something
#
#   work
#   end
#
#   # also good
#   def test
#   work if something
#   end
#
#   # bad
#   if something
#   raise 'exception'
#   else
#   ok
#   end
#
#   # good
#   raise 'exception' if something
#   ok
#
#   # bad
#   if something
#   foo || raise('exception')
#   else
#   ok
#   end
#
#   # good
#   foo || raise('exception') if something
#   ok
# @example AllowConsecutiveConditionals: false (default)
#   # bad
#   def test
#   if foo?
#   work
#   end
#
#   if bar?  # <- reports an offense
#   work
#   end
#   end
# @example AllowConsecutiveConditionals: true
#   # good
#   def test
#   if foo?
#   work
#   end
#
#   if bar?
#   work
#   end
#   end
#
#   # bad
#   def test
#   if foo?
#   work
#   end
#
#   do_something
#
#   if bar?  # <- reports an offense
#   work
#   end
#   end
class RuboCop::Cop::Style::GuardClause < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MinBodyLength
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::StatementModifier

  def on_def(node); end
  def on_defs(node); end
  def on_if(node); end

  private

  # @return [Boolean]
  def accepted_form?(node, ending: T.unsafe(nil)); end

  # @return [Boolean]
  def accepted_if?(node, ending); end

  # @return [Boolean]
  def allowed_consecutive_conditionals?; end

  def check_ending_if(node); end

  # @return [Boolean]
  def consecutive_conditionals?(parent, node); end

  def guard_clause_source(guard_clause); end
  def register_offense(node, scope_exiting_keyword, conditional_keyword); end

  # @return [Boolean]
  def too_long_for_single_line?(node, example); end

  # @return [Boolean]
  def trivial?(node); end
end

RuboCop::Cop::Style::GuardClause::MSG = T.let(T.unsafe(nil), String)

# Checks for presence or absence of braces around hash literal as a last
# array item depending on configuration.
#
# NOTE: This cop will ignore arrays where all items are hashes, regardless of
# EnforcedStyle.
#
# @example EnforcedStyle: braces (default)
#   # bad
#   [1, 2, one: 1, two: 2]
#
#   # good
#   [1, 2, { one: 1, two: 2 }]
#
#   # good
#   [{ one: 1 }, { two: 2 }]
# @example EnforcedStyle: no_braces
#   # bad
#   [1, 2, { one: 1, two: 2 }]
#
#   # good
#   [1, 2, one: 1, two: 2]
#
#   # good
#   [{ one: 1 }, { two: 2 }]
class RuboCop::Cop::Style::HashAsLastArrayItem < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end

  private

  # @return [Boolean]
  def braces_style?; end

  def check_braces(node); end
  def check_no_braces(node); end
  def containing_array(hash_node); end

  # @return [Boolean]
  def explicit_array?(array); end

  # @return [Boolean]
  def last_array_item?(array, node); end

  def remove_last_element_trailing_comma(corrector, node); end
end

# Checks the usage of pre-2.1 `Hash[args]` method of converting enumerables and
# sequences of values to hashes.
#
# Correction code from splat argument (`Hash[*ary]`) is not simply determined. For example,
# `Hash[*ary]` can be replaced with `ary.each_slice(2).to_h` but it will be complicated.
# So, `AllowSplatArgument` option is true by default to allow splat argument for simple code.
#
# @example
#   # bad
#   Hash[ary]
#
#   # good
#   ary.to_h
#
#   # bad
#   Hash[key1, value1, key2, value2]
#
#   # good
#   {key1 => value1, key2 => value2}
# @example AllowSplatArgument: true (default)
#   # good
#   Hash[*ary]
# @example AllowSplatArgument: false
#   # bad
#   Hash[*ary]
class RuboCop::Cop::Style::HashConversion < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def hash_from_array?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_splat_argument?; end

  def args_to_hash(args); end
  def multi_argument(node); end
  def register_offense_for_hash(node, hash_argument); end
  def register_offense_for_zip_method(node, zip_method); end

  # @return [Boolean]
  def requires_parens?(node); end

  def single_argument(node); end

  # @return [Boolean]
  def use_zip_method_without_argument?(first_argument); end
end

RuboCop::Cop::Style::HashConversion::MSG_LITERAL_HASH_ARG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashConversion::MSG_LITERAL_MULTI_ARG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashConversion::MSG_SPLAT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashConversion::MSG_TO_H = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashConversion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `each_key` and `each_value` Hash methods.
#
# NOTE: If you have an array of two-element arrays, you can put
#   parentheses around the block arguments to indicate that you're not
#   working with a hash, and suppress RuboCop offenses.
#
# @example
#   # bad
#   hash.keys.each { |k| p k }
#   hash.values.each { |v| p v }
#
#   # good
#   hash.each_key { |k| p k }
#   hash.each_value { |v| p v }
# @example AllowedReceivers: ['execute']
#   # good
#   execute(sql).keys.each { |v| p v }
#   execute(sql).values.each { |v| p v }
class RuboCop::Cop::Style::HashEachMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Lint::UnusedArgument
  extend ::RuboCop::Cop::AutoCorrector

  def kv_each(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_numblock(node); end

  private

  # @return [Boolean]
  def allowed_receiver?(receiver); end

  def allowed_receivers; end
  def check_argument(variable); end
  def correct_args(node, corrector); end
  def correct_implicit(node, corrector, method_name); end
  def correct_key_value_each(node, corrector); end
  def kv_range(outer_node); end
  def register_kv_offense(node); end

  # @return [Boolean]
  def used?(arg); end
end

RuboCop::Cop::Style::HashEachMethods::MSG = T.let(T.unsafe(nil), String)

# Checks for usages of `Hash#reject`, `Hash#select`, and `Hash#filter` methods
# that can be replaced with `Hash#except` method.
#
# This cop should only be enabled on Ruby version 3.0 or higher.
# (`Hash#except` was added in Ruby 3.0.)
#
# For safe detection, it is limited to commonly used string and symbol comparisons
# when used `==`.
# And do not check `Hash#delete_if` and `Hash#keep_if` to change receiver object.
#
# @example
#
#   # bad
#   {foo: 1, bar: 2, baz: 3}.reject {|k, v| k == :bar }
#   {foo: 1, bar: 2, baz: 3}.select {|k, v| k != :bar }
#   {foo: 1, bar: 2, baz: 3}.filter {|k, v| k != :bar }
#   {foo: 1, bar: 2, baz: 3}.reject {|k, v| %i[foo bar].include?(k) }
#   {foo: 1, bar: 2, baz: 3}.select {|k, v| !%i[foo bar].include?(k) }
#   {foo: 1, bar: 2, baz: 3}.filter {|k, v| !%i[foo bar].include?(k) }
#
#   # good
#   {foo: 1, bar: 2, baz: 3}.except(:bar)
class RuboCop::Cop::Style::HashExcept < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::TargetRubyVersion
  extend ::RuboCop::Cop::AutoCorrector

  def bad_method_with_active_support?(param0 = T.unsafe(nil)); end
  def bad_method_with_poro?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  # @return [Boolean]
  def bad_method?(block); end

  def decorate_source(value); end
  def except_key(node); end
  def except_key_source(key); end
  def extract_body_if_nagated(body); end

  # @return [Boolean]
  def included?(negated, body); end

  # @return [Boolean]
  def not_included?(negated, body); end

  def offense_range(node); end

  # @return [Boolean]
  def safe_to_register_offense?(block, except_key); end

  # @return [Boolean]
  def semantically_except_method?(send, block); end
end

RuboCop::Cop::Style::HashExcept::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashExcept::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where `case-when` represents a simple 1:1
# mapping and can be replaced with a hash lookup.
#
# @example MinBranchesCount: 3 (default)
#   # bad
#   case country
#   when 'europe'
#   'http://eu.example.com'
#   when 'america'
#   'http://us.example.com'
#   when 'australia'
#   'http://au.example.com'
#   end
#
#   # good
#   SITES = {
#   'europe'    => 'http://eu.example.com',
#   'america'   => 'http://us.example.com',
#   'australia' => 'http://au.example.com'
#   }
#   SITES[country]
# @example MinBranchesCount: 4
#   # good
#   case country
#   when 'europe'
#   'http://eu.example.com'
#   when 'america'
#   'http://us.example.com'
#   when 'australia'
#   'http://au.example.com'
#   end
class RuboCop::Cop::Style::HashLikeCase < ::RuboCop::Cop::Base
  def hash_like_case?(param0 = T.unsafe(nil)); end
  def on_case(node); end

  private

  def min_branches_count; end

  # @return [Boolean]
  def nodes_of_same_type?(nodes); end
end

RuboCop::Cop::Style::HashLikeCase::MSG = T.let(T.unsafe(nil), String)

# Checks hash literal syntax.
#
# It can enforce either the use of the class hash rocket syntax or
# the use of the newer Ruby 1.9 syntax (when applicable).
#
# A separate offense is registered for each problematic pair.
#
# The supported styles are:
#
# * ruby19 - forces use of the 1.9 syntax (e.g. `{a: 1}`) when hashes have
# all symbols for keys
# * hash_rockets - forces use of hash rockets for all hashes
# * no_mixed_keys - simply checks for hashes with mixed syntaxes
# * ruby19_no_mixed_keys - forces use of ruby 1.9 syntax and forbids mixed
# syntax hashes
#
# This cop has `EnforcedShorthandSyntax` option.
# It can enforce either the use of the explicit hash value syntax or
# the use of Ruby 3.1's hash value shorthand syntax.
#
# The supported styles are:
#
# * always - forces use of the 3.1 syntax (e.g. {foo:})
# * never - forces use of explicit hash literal value
# * either - accepts both shorthand and explicit use of hash literal value
# * consistent - like "always", but will avoid mixing styles in a single hash
#
# @example EnforcedShorthandSyntax: consistent
#
#   # bad
#   {foo: , bar: bar}
#
#   # good
#   {foo:, bar:}
#
#   # bad
#   {foo: , bar: baz}
#
#   # good
#   {foo: foo, bar: baz}
# @example EnforcedStyle: hash_rockets
#   # bad
#   {a: 1, b: 2}
#   {c: 1, 'd' => 5}
#
#   # good
#   {:a => 1, :b => 2}
# @example EnforcedStyle: no_mixed_keys
#   # bad
#   {:a => 1, b: 2}
#   {c: 1, 'd' => 2}
#
#   # good
#   {:a => 1, :b => 2}
#   {c: 1, d: 2}
# @example EnforcedStyle: ruby19_no_mixed_keys
#   # bad
#   {:a => 1, :b => 2}
#   {c: 2, 'd' => 3} # should just use hash rockets
#
#   # good
#   {a: 1, b: 2}
#   {:c => 3, 'd' => 4}
# @example EnforcedShorthandSyntax: always (default)
#
#   # bad
#   {foo: foo, bar: bar}
#
#   # good
#   {foo:, bar:}
# @example EnforcedShorthandSyntax: never
#
#   # bad
#   {foo:, bar:}
#
#   # good
#   {foo: foo, bar: bar}
# @example EnforcedShorthandSyntax: either
#
#   # good
#   {foo: foo, bar: bar}
#
#   # good
#   {foo:, bar:}
# @example EnforcedStyle: ruby19 (default)
#   # bad
#   {:a => 2}
#   {b: 1, :c => 2}
#
#   # good
#   {a: 2, b: 1}
#   {:c => 2, 'd' => 2} # acceptable since 'd' isn't a symbol
#   {d: 1, 'e' => 2} # technically not forbidden
class RuboCop::Cop::Style::HashSyntax < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::HashShorthandSyntax
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def alternative_style; end
  def hash_rockets_check(pairs); end
  def no_mixed_keys_check(pairs); end
  def on_hash(node); end
  def ruby19_check(pairs); end
  def ruby19_no_mixed_keys_check(pairs); end

  private

  # @return [Boolean]
  def acceptable_19_syntax_symbol?(sym_name); end

  # @return [Boolean]
  def argument_without_space?(node); end

  def autocorrect(corrector, node); end
  def autocorrect_hash_rockets(corrector, pair_node); end
  def autocorrect_no_mixed_keys(corrector, pair_node); end
  def autocorrect_ruby19(corrector, pair_node); end
  def check(pairs, delim, msg); end

  # @return [Boolean]
  def force_hash_rockets?(pairs); end

  def range_for_autocorrect_ruby19(pair_node); end

  # @return [Boolean]
  def sym_indices?(pairs); end

  # @return [Boolean]
  def word_symbol_pair?(pair); end
end

RuboCop::Cop::Style::HashSyntax::MSG_19 = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashSyntax::MSG_HASH_ROCKETS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::HashSyntax::MSG_NO_MIXED_KEYS = T.let(T.unsafe(nil), String)

# Looks for uses of `_.each_with_object({}) {...}`,
# `_.map {...}.to_h`, and `Hash[_.map {...}]` that are actually just
# transforming the keys of a hash, and tries to use a simpler & faster
# call to `transform_keys` instead.
# It should only be enabled on Ruby version 2.5 or newer.
# (`transform_keys` was added in Ruby 2.5.)
#
# @example
#   # bad
#   {a: 1, b: 2}.each_with_object({}) { |(k, v), h| h[foo(k)] = v }
#   Hash[{a: 1, b: 2}.collect { |k, v| [foo(k), v] }]
#   {a: 1, b: 2}.map { |k, v| [k.to_s, v] }.to_h
#   {a: 1, b: 2}.to_h { |k, v| [k.to_s, v] }
#
#   # good
#   {a: 1, b: 2}.transform_keys { |k| foo(k) }
#   {a: 1, b: 2}.transform_keys { |k| k.to_s }
class RuboCop::Cop::Style::HashTransformKeys < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::HashTransformMethod
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_bad_each_with_object(param0 = T.unsafe(nil)); end
  def on_bad_hash_brackets_map(param0 = T.unsafe(nil)); end
  def on_bad_map_to_h(param0 = T.unsafe(nil)); end
  def on_bad_to_h(param0 = T.unsafe(nil)); end

  private

  def extract_captures(match); end
  def new_method_name; end
end

# Looks for uses of `_.each_with_object({}) {...}`,
# `_.map {...}.to_h`, and `Hash[_.map {...}]` that are actually just
# transforming the values of a hash, and tries to use a simpler & faster
# call to `transform_values` instead.
#
# @example
#   # bad
#   {a: 1, b: 2}.each_with_object({}) { |(k, v), h| h[k] = foo(v) }
#   Hash[{a: 1, b: 2}.collect { |k, v| [k, foo(v)] }]
#   {a: 1, b: 2}.map { |k, v| [k, v * v] }.to_h
#   {a: 1, b: 2}.to_h { |k, v| [k, v * v] }
#
#   # good
#   {a: 1, b: 2}.transform_values { |v| foo(v) }
#   {a: 1, b: 2}.transform_values { |v| v * v }
class RuboCop::Cop::Style::HashTransformValues < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::HashTransformMethod
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_bad_each_with_object(param0 = T.unsafe(nil)); end
  def on_bad_hash_brackets_map(param0 = T.unsafe(nil)); end
  def on_bad_map_to_h(param0 = T.unsafe(nil)); end
  def on_bad_to_h(param0 = T.unsafe(nil)); end

  private

  def extract_captures(match); end
  def new_method_name; end
end

# Checks for identical expressions at the beginning or end of
# each branch of a conditional expression. Such expressions should normally
# be placed outside the conditional expression - before or after it.
#
# NOTE: The cop is poorly named and some people might think that it actually
# checks for duplicated conditional branches. The name will probably be changed
# in a future major RuboCop release.
#
# @example
#   # bad
#   if condition
#   do_x
#   do_z
#   else
#   do_y
#   do_z
#   end
#
#   # good
#   if condition
#   do_x
#   else
#   do_y
#   end
#   do_z
#
#   # bad
#   if condition
#   do_z
#   do_x
#   else
#   do_z
#   do_y
#   end
#
#   # good
#   do_z
#   if condition
#   do_x
#   else
#   do_y
#   end
#
#   # bad
#   case foo
#   when 1
#   do_x
#   when 2
#   do_x
#   else
#   do_x
#   end
#
#   # good
#   case foo
#   when 1
#   do_x
#   do_y
#   when 2
#   # nothing
#   else
#   do_x
#   do_z
#   end
#
#   # bad
#   case foo
#   in 1
#   do_x
#   in 2
#   do_x
#   else
#   do_x
#   end
#
#   # good
#   case foo
#   in 1
#   do_x
#   do_y
#   in 2
#   # nothing
#   else
#   do_x
#   do_z
#   end
class RuboCop::Cop::Style::IdenticalConditionalBranches < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_case(node); end
  def on_case_match(node); end
  def on_if(node); end

  private

  def check_branches(node, branches); end
  def check_expressions(node, expressions, insert_position); end

  # @return [Boolean]
  def duplicated_expressions?(node, expressions); end

  # `elsif` branches show up in the if node as nested `else` branches. We
  # need to recursively iterate over all `else` branches.
  def expand_elses(branch); end

  def head(node); end
  def message(node); end
  def tail(node); end
end

RuboCop::Cop::Style::IdenticalConditionalBranches::MSG = T.let(T.unsafe(nil), String)

# Corrector to correct conditional assignment in `if` statements.
class RuboCop::Cop::Style::IfCorrector
  extend ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::Cop::Style::ConditionalCorrectorHelper

  class << self
    def correct(corrector, cop, node); end
    def move_assignment_inside_condition(corrector, node); end

    private

    def extract_tail_branches(node); end
    def move_branch_inside_condition(corrector, branch, condition, assignment, column); end
  end
end

# If the `else` branch of a conditional consists solely of an `if` node,
# it can be combined with the `else` to become an `elsif`.
# This helps to keep the nesting level from getting too deep.
#
# @example
#   # bad
#   if condition_a
#   action_a
#   else
#   if condition_b
#   action_b
#   else
#   action_c
#   end
#   end
#
#   # good
#   if condition_a
#   action_a
#   elsif condition_b
#   action_b
#   else
#   action_c
#   end
# @example AllowIfModifier: false (default)
#   # bad
#   if condition_a
#   action_a
#   else
#   action_b if condition_b
#   end
#
#   # good
#   if condition_a
#   action_a
#   elsif condition_b
#   action_b
#   end
# @example AllowIfModifier: true
#   # good
#   if condition_a
#   action_a
#   else
#   action_b if condition_b
#   end
#
#   # good
#   if condition_a
#   action_a
#   elsif condition_b
#   action_b
#   end
class RuboCop::Cop::Style::IfInsideElse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def allow_if_modifier?; end

  # @return [Boolean]
  def allow_if_modifier_in_else_branch?(else_branch); end

  def autocorrect(corrector, node); end
  def correct_to_elsif_from_if_inside_else_form(corrector, node, condition); end
  def correct_to_elsif_from_modifier_form(corrector, node); end
  def find_end_range(node); end
  def if_condition_range(node, condition); end

  # @return [Boolean]
  def then?(node); end
end

RuboCop::Cop::Style::IfInsideElse::MSG = T.let(T.unsafe(nil), String)

# Checks for `if` and `unless` statements that would fit on one line if
# written as modifier `if`/`unless`. The cop also checks for modifier
# `if`/`unless` lines that exceed the maximum line length.
#
# The maximum line length is configured in the `Layout/LineLength`
# cop. The tab size is configured in the `IndentationWidth` of the
# `Layout/IndentationStyle` cop.
#
# @example
#   # bad
#   if condition
#   do_stuff(bar)
#   end
#
#   unless qux.empty?
#   Foo.do_something
#   end
#
#   do_something_with_a_long_name(arg) if long_condition_that_prevents_code_fit_on_single_line
#
#   # good
#   do_stuff(bar) if condition
#   Foo.do_something unless qux.empty?
#
#   if long_condition_that_prevents_code_fit_on_single_line
#   do_something_with_a_long_name(arg)
#   end
#
#   if short_condition # a long comment that makes it too long if it were just a single line
#   do_something
#   end
class RuboCop::Cop::Style::IfUnlessModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::StatementModifier
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def allowed_patterns; end

  # @return [Boolean]
  def another_statement_on_same_line?(node); end

  def autocorrect(corrector, node); end
  def extract_heredoc_from(last_argument); end

  # @return [Boolean]
  def line_length_enabled_at_line?(line); end

  # @return [Boolean]
  def named_capture_in_condition?(node); end

  # @return [Boolean]
  def non_eligible_node?(node); end

  # @return [Boolean]
  def non_simple_if_unless?(node); end

  def remove_heredoc(corrector, heredoc); end
  def to_normal_form(node, indentation); end
  def to_normal_form_with_heredoc(node, indentation, heredoc); end

  # @return [Boolean]
  def too_long_due_to_modifier?(node); end

  # @return [Boolean]
  def too_long_line_based_on_allow_uri?(line); end

  # @return [Boolean]
  def too_long_line_based_on_config?(range, line); end

  # @return [Boolean]
  def too_long_line_based_on_ignore_cop_directives?(range, line); end

  # @return [Boolean]
  def too_long_single_line?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::IfUnlessModifier::MSG_USE_MODIFIER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::IfUnlessModifier::MSG_USE_NORMAL = T.let(T.unsafe(nil), String)

# Checks for if and unless statements used as modifiers of other if or
# unless statements.
#
# @example
#
#   # bad
#   tired? ? 'stop' : 'go faster' if running?
#
#   # bad
#   if tired?
#   "please stop"
#   else
#   "keep going"
#   end if running?
#
#   # good
#   if running?
#   tired? ? 'stop' : 'go faster'
#   end
class RuboCop::Cop::Style::IfUnlessModifierOfIfUnless < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::StatementModifier
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
end

RuboCop::Cop::Style::IfUnlessModifierOfIfUnless::MSG = T.let(T.unsafe(nil), String)

# Checks for redundant `if` with boolean literal branches.
# It checks only conditions to return boolean value (`true` or `false`) for safe detection.
# The conditions to be checked are comparison methods, predicate methods, and double negative.
# `nonzero?` method is allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example
#   # bad
#   if foo == bar
#   true
#   else
#   false
#   end
#
#   # bad
#   foo == bar ? true : false
#
#   # good
#   foo == bar
# @example
#   # bad
#   if foo.do_something?
#   true
#   else
#   false
#   end
#
#   # good (but potentially an unsafe correction)
#   foo.do_something?
# @example AllowedMethods: ['nonzero?'] (default)
#   # good
#   num.nonzero? ? true : false
class RuboCop::Cop::Style::IfWithBooleanLiteralBranches < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  def double_negative?(param0 = T.unsafe(nil)); end
  def if_with_boolean_literal_branches?(param0 = T.unsafe(nil)); end
  def on_if(node); end

  private

  # @return [Boolean]
  def assume_boolean_value?(condition); end

  def message(node, keyword); end
  def offense_range_with_keyword(node, condition); end

  # @return [Boolean]
  def opposite_condition?(node); end

  def replacement_condition(node, condition); end

  # @return [Boolean]
  def require_parentheses?(condition); end

  # @return [Boolean]
  def return_boolean_value?(condition); end
end

RuboCop::Cop::Style::IfWithBooleanLiteralBranches::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::IfWithBooleanLiteralBranches::MSG_FOR_ELSIF = T.let(T.unsafe(nil), String)

# Checks for uses of semicolon in if statements.
#
# @example
#
#   # bad
#   result = if some_condition; something else another_thing end
#
#   # good
#   result = some_condition ? something : another_thing
class RuboCop::Cop::Style::IfWithSemicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OnNormalIfUnless
  extend ::RuboCop::Cop::AutoCorrector

  def on_normal_if_unless(node); end

  private

  def autocorrect(node); end
  def build_else_branch(second_condition); end
  def correct_elsif(node); end
end

RuboCop::Cop::Style::IfWithSemicolon::MSG_IF_ELSE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::IfWithSemicolon::MSG_TERNARY = T.let(T.unsafe(nil), String)

# Checks for `raise` or `fail` statements which do not specify an
# explicit exception class. (This raises a `RuntimeError`. Some projects
# might prefer to use exception classes which more precisely identify the
# nature of the error.)
#
# @example
#   # bad
#   raise 'Error message here'
#
#   # good
#   raise ArgumentError, 'Error message here'
class RuboCop::Cop::Style::ImplicitRuntimeError < ::RuboCop::Cop::Base
  def implicit_runtime_error_raise_or_fail(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Style::ImplicitRuntimeError::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ImplicitRuntimeError::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `in;` uses in `case` expressions.
#
# @example
#   # bad
#   case expression
#   in pattern_a; foo
#   in pattern_b; bar
#   end
#
#   # good
#   case expression
#   in pattern_a then foo
#   in pattern_b then bar
#   end
class RuboCop::Cop::Style::InPatternThen < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_in_pattern(node); end

  private

  def alternative_pattern_source(pattern); end
end

RuboCop::Cop::Style::InPatternThen::MSG = T.let(T.unsafe(nil), String)

# Use `Kernel#loop` for infinite loops.
#
# @example
#   # bad
#   while true
#   work
#   end
#
#   # good
#   loop do
#   work
#   end
class RuboCop::Cop::Style::InfiniteLoop < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def after_leaving_scope(scope, _variable_table); end
  def on_until(node); end
  def on_until_post(node); end
  def on_while(node); end
  def on_while_post(node); end

  private

  # @return [Boolean]
  def assigned_before_loop?(var, range); end

  # @return [Boolean]
  def assigned_inside_loop?(var, range); end

  def autocorrect(corrector, node); end
  def configured_indent; end
  def modifier_replacement(node); end
  def non_modifier_range(node); end

  # @return [Boolean]
  def referenced_after_loop?(var, range); end

  def replace_begin_end_with_modifier(corrector, node); end
  def replace_source(corrector, range, replacement); end
  def while_or_until(node); end

  class << self
    def joining_forces; end
  end
end

RuboCop::Cop::Style::InfiniteLoop::LEADING_SPACE = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::InfiniteLoop::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing inline comments.
#
# @example
#
#   # good
#   foo.each do |f|
#   # Standalone comment
#   f.bar
#   end
#
#   # bad
#   foo.each do |f|
#   f.bar # Trailing inline comment
#   end
class RuboCop::Cop::Style::InlineComment < ::RuboCop::Cop::Base
  def on_new_investigation; end
end

RuboCop::Cop::Style::InlineComment::MSG = T.let(T.unsafe(nil), String)

# Check for usages of not (`not` or `!`) called on a method
# when an inverse of that method can be used instead.
#
# Methods that can be inverted by a not (`not` or `!`) should be defined
# in `InverseMethods`.
#
# Methods that are inverted by inverting the return
# of the block that is passed to the method should be defined in
# `InverseBlocks`.
#
# @example
#   # bad
#   !foo.none?
#   !foo.any? { |f| f.even? }
#   !foo.blank?
#   !(foo == bar)
#   foo.select { |f| !f.even? }
#   foo.reject { |f| f != 7 }
#
#   # good
#   foo.none?
#   foo.blank?
#   foo.any? { |f| f.even? }
#   foo != bar
#   foo == bar
#   !!('foo' =~ /^\w+$/)
#   !(foo.class < Numeric) # Checking class hierarchy is allowed
#   # Blocks with guard clauses are ignored:
#   foo.select do |f|
#   next if f.zero?
#   f != 1
#   end
class RuboCop::Cop::Style::InverseMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def inverse_block?(param0 = T.unsafe(nil)); end
  def inverse_candidate?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_numblock(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def camel_case_constant?(node); end

  def correct_inverse_block(corrector, node); end
  def correct_inverse_method(corrector, node); end
  def correct_inverse_selector(block, corrector); end
  def dot_range(loc); end
  def end_parentheses(node, method_call); end
  def inverse_blocks; end
  def inverse_methods; end
  def message(method, inverse); end

  # @return [Boolean]
  def negated?(node); end

  def not_to_receiver(node, method_call); end

  # When comparing classes, `!(Integer < Numeric)` is not the same as
  # `Integer > Numeric`.
  #
  # @return [Boolean]
  def possible_class_hierarchy_check?(lhs, rhs, method); end

  def remove_end_parenthesis(corrector, node, method, method_call); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::InverseMethods::CAMEL_CASE = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::InverseMethods::CLASS_COMPARISON_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::InverseMethods::EQUALITY_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::InverseMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::InverseMethods::NEGATED_EQUALITY_METHODS = T.let(T.unsafe(nil), Array)

# Checks for hardcoded IP addresses, which can make code
# brittle. IP addresses are likely to need to be changed when code
# is deployed to a different server or environment, which may break
# a deployment if forgotten. Prefer setting IP addresses in ENV or
# other configuration.
#
# @example
#
#   # bad
#   ip_address = '127.59.241.29'
#
#   # good
#   ip_address = ENV['DEPLOYMENT_IP_ADDRESS']
class RuboCop::Cop::Style::IpAddresses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::StringHelp

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  def correct_style_detected; end

  # @return [Boolean]
  def offense?(node); end

  # Dummy implementation of method in ConfigurableEnforcedStyle that is
  # called from StringHelp.
  def opposite_style_detected; end

  private

  def allowed_addresses; end

  # @return [Boolean]
  def could_be_ip?(str); end

  # @return [Boolean]
  def starts_with_hex_or_colon?(str); end

  # @return [Boolean]
  def too_long?(str); end
end

# IPv4-mapped IPv6 is the longest
RuboCop::Cop::Style::IpAddresses::IPV6_MAX_SIZE = T.let(T.unsafe(nil), Integer)

RuboCop::Cop::Style::IpAddresses::MSG = T.let(T.unsafe(nil), String)

# Enforces that optional keyword parameters are placed at the
# end of the parameters list.
#
# This improves readability, because when looking through the source,
# it is expected to find required parameters at the beginning of parameters list
# and optional parameters at the end.
#
# @example
#   # bad
#   def some_method(first: false, second:, third: 10)
#   # body omitted
#   end
#
#   # good
#   def some_method(second:, first: false, third: 10)
#   # body omitted
#   end
#
#   # bad
#   do_something do |first: false, second:, third: 10|
#   # body omitted
#   end
#
#   # good
#   do_something do |second:, first: false, third: 10|
#   # body omitted
#   end
class RuboCop::Cop::Style::KeywordParametersOrder < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_kwoptarg(node); end

  private

  def append_newline_to_last_kwoptarg(arguments, corrector); end
  def remove_kwargs(kwarg_nodes, corrector); end
end

RuboCop::Cop::Style::KeywordParametersOrder::MSG = T.let(T.unsafe(nil), String)

# (by default) checks for uses of the lambda literal syntax for
# single line lambdas, and the method call syntax for multiline lambdas.
# It is configurable to enforce one of the styles for both single line
# and multiline lambdas as well.
#
# @example EnforcedStyle: line_count_dependent (default)
#   # bad
#   f = lambda { |x| x }
#   f = ->(x) do
#   x
#   end
#
#   # good
#   f = ->(x) { x }
#   f = lambda do |x|
#   x
#   end
# @example EnforcedStyle: lambda
#   # bad
#   f = ->(x) { x }
#   f = ->(x) do
#   x
#   end
#
#   # good
#   f = lambda { |x| x }
#   f = lambda do |x|
#   x
#   end
# @example EnforcedStyle: literal
#   # bad
#   f = lambda { |x| x }
#   f = lambda do |x|
#   x
#   end
#
#   # good
#   f = ->(x) { x }
#   f = ->(x) do
#   x
#   end
class RuboCop::Cop::Style::Lambda < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end

  private

  def arguments_with_whitespace(node); end
  def autocorrect_method_to_literal(corrector, node); end
  def lambda_arg_string(args); end
  def message(node, selector); end
  def message_line_modifier(node); end

  # @return [Boolean]
  def offending_selector?(node, selector); end
end

RuboCop::Cop::Style::Lambda::LITERAL_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Lambda::METHOD_MESSAGE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Lambda::OFFENDING_SELECTORS = T.let(T.unsafe(nil), Hash)

# Checks for use of the lambda.(args) syntax.
#
# @example EnforcedStyle: call (default)
#   # bad
#   lambda.(x, y)
#
#   # good
#   lambda.call(x, y)
# @example EnforcedStyle: braces
#   # bad
#   lambda.call(x, y)
#
#   # good
#   lambda.(x, y)
class RuboCop::Cop::Style::LambdaCall < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def explicit_style?; end

  # @return [Boolean]
  def implicit_style?; end

  # @return [Boolean]
  def offense?(node); end

  def prefer(node); end
end

RuboCop::Cop::Style::LambdaCall::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::LambdaCall::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for string literal concatenation at
# the end of a line.
#
# @example
#
#   # bad
#   some_str = 'ala' +
#   'bala'
#
#   some_str = 'ala' <<
#   'bala'
#
#   # good
#   some_str = 'ala' \
#   'bala'
class RuboCop::Cop::Style::LineEndConcatenation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def autocorrect(corrector, operator_range); end
  def check_token_set(index); end

  # @return [Boolean]
  def eligible_next_successor?(next_successor); end

  # @return [Boolean]
  def eligible_operator?(operator); end

  # @return [Boolean]
  def eligible_predecessor?(predecessor); end

  # @return [Boolean]
  def eligible_successor?(successor); end

  # @return [Boolean]
  def eligible_token_set?(predecessor, operator, successor); end

  # @return [Boolean]
  def standard_string_literal?(token); end

  def token_after_last_string(successor, base_index); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::LineEndConcatenation::COMPLEX_STRING_BEGIN_TOKEN = T.let(T.unsafe(nil), Symbol)
RuboCop::Cop::Style::LineEndConcatenation::COMPLEX_STRING_END_TOKEN = T.let(T.unsafe(nil), Symbol)
RuboCop::Cop::Style::LineEndConcatenation::CONCAT_TOKEN_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::LineEndConcatenation::HIGH_PRECEDENCE_OP_TOKEN_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::LineEndConcatenation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::LineEndConcatenation::QUOTE_DELIMITERS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::LineEndConcatenation::SIMPLE_STRING_TOKEN_TYPE = T.let(T.unsafe(nil), Symbol)

# Ensures magic comments are written consistently throughout your code base.
# Looks for discrepancies in separators (`-` vs `_`) and capitalization for
# both magic comment directives and values.
#
# Required capitalization can be set with the `DirectiveCapitalization` and
# `ValueCapitalization` configuration keys.
#
# NOTE: If one of these configuration is set to nil, any capitalization is allowed.
#
# @example ValueCapitalization: uppercase
#   # bad
#   # frozen-string-literal: true
#
#   # good
#   # frozen-string-literal: TRUE
# @example EnforcedStyle: kebab_case
#   # The `kebab_case` style will enforce that the frozen string literal
#   # comment is written in kebab case. (Words separated by hyphens)
#   # bad
#   # frozen_string_literal: true
#
#   module Baz
#   # ...
#   end
#
#   # good
#   # frozen-string-literal: true
#
#   module Baz
#   # ...
#   end
# @example DirectiveCapitalization: lowercase (default)
#   # bad
#   # FROZEN-STRING-LITERAL: true
#
#   # good
#   # frozen-string-literal: true
# @example DirectiveCapitalization: uppercase
#   # bad
#   # frozen-string-literal: true
#
#   # good
#   # FROZEN-STRING-LITERAL: true
# @example DirectiveCapitalization: nil
#   # any capitalization is accepted
#
#   # good
#   # frozen-string-literal: true
#
#   # good
#   # FROZEN-STRING-LITERAL: true
# @example ValueCapitalization: nil (default)
#   # any capitalization is accepted
#
#   # good
#   # frozen-string-literal: true
#
#   # good
#   # frozen-string-literal: TRUE
# @example ValueCapitalization: lowercase
#   # when a value is not given, any capitalization is accepted
#
#   # bad
#   # frozen-string-literal: TRUE
#
#   # good
#   # frozen-string-literal: TRUE
# @example EnforcedStyle: snake_case (default)
#   # The `snake_case` style will enforce that the frozen string literal
#   # comment is written in snake case. (Words separated by underscores)
#   # bad
#   # frozen-string-literal: true
#
#   module Bar
#   # ...
#   end
#
#   # good
#   # frozen_string_literal: false
#
#   module Bar
#   # ...
#   end
class RuboCop::Cop::Style::MagicCommentFormat < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end

  private

  def correct_separator; end
  def directive_capitalization; end

  # @return [Boolean]
  def directive_offends?(directive); end

  def expected_style; end
  def find_issues(comment); end
  def fix_directives(issues); end
  def fix_values(issues); end

  # @return [Boolean]
  def incorrect_separator?(text); end

  def leading_comment_lines; end
  def line_range(line); end
  def magic_comments; end
  def register_offenses(issues); end
  def replace_capitalization(text, style); end
  def replace_separator(text); end
  def supported_capitalizations; end

  # @return [Boolean]
  def valid_capitalization?(style); end

  def value_capitalization; end

  # @return [Boolean]
  def wrong_capitalization?(text, expected_case); end

  def wrong_separator; end
end

# Value object to extract source ranges for the different parts of a magic comment
class RuboCop::Cop::Style::MagicCommentFormat::CommentRange
  extend ::Forwardable

  # @return [CommentRange] a new instance of CommentRange
  def initialize(comment); end

  # Returns the value of attribute comment.
  def comment; end

  # A magic comment can contain one directive (normal style) or
  # multiple directives (emacs style)
  def directives; end

  def loc(*args, **_arg1, &block); end
  def text(*args, **_arg1, &block); end

  # A magic comment can contain one value (normal style) or
  # multiple directives (emacs style)
  def values; end
end

RuboCop::Cop::Style::MagicCommentFormat::CommentRange::DIRECTIVE_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::MagicCommentFormat::CommentRange::VALUE_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::MagicCommentFormat::KEBAB_SEPARATOR = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MagicCommentFormat::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MagicCommentFormat::MSG_VALUE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MagicCommentFormat::SNAKE_SEPARATOR = T.let(T.unsafe(nil), String)

# Prefer `select` or `reject` over `map { ... }.compact`.
#
# @example
#
#   # bad
#   array.map { |e| some_condition? ? e : next }.compact
#
#   # bad
#   array.map do |e|
#   if some_condition?
#   e
#   else
#   next
#   end
#   end.compact
#
#   # bad
#   array.map do |e|
#   next if some_condition?
#
#   e
#   end.compact
#
#   # bad
#   array.map do |e|
#   e if some_condition?
#   end.compact
#
#   # good
#   array.select { |e| some_condition? }
#
#   # good
#   array.reject { |e| some_condition? }
class RuboCop::Cop::Style::MapCompactWithConditionalBlock < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def map_and_compact?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def range(node); end

  # @return [Boolean]
  def returns_block_argument?(block_argument_node, return_value_node); end

  # @return [Boolean]
  def truthy_branch?(node); end

  # @return [Boolean]
  def truthy_branch_for_guard?(node); end

  # @return [Boolean]
  def truthy_branch_for_if?(node); end
end

RuboCop::Cop::Style::MapCompactWithConditionalBlock::MSG = T.let(T.unsafe(nil), String)

# Looks for uses of `map.to_h` or `collect.to_h` that could be
# written with just `to_h` in Ruby >= 2.6.
#
# NOTE: `Style/HashTransformKeys` and `Style/HashTransformValues` will
# also change this pattern if only hash keys or hash values are being
# transformed.
#
# @example
#   # bad
#   something.map { |v| [v, v * 2] }.to_h
#
#   # good
#   something.to_h { |v| [v, v * 2] }
#
#   # bad
#   {foo: bar}.collect { |k, v| [k.to_s, v.do_something] }.to_h
#
#   # good
#   {foo: bar}.to_h { |k, v| [k.to_s, v.do_something] }
class RuboCop::Cop::Style::MapToHash < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def map_to_h?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def autocorrect(corrector, to_h, map); end
end

RuboCop::Cop::Style::MapToHash::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MapToHash::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the presence (default) or absence of parentheses in
# method calls containing parameters.
#
# In the default style (require_parentheses), macro methods are allowed.
# Additional methods can be added to the `AllowedMethods`
# or `AllowedPatterns` list. These options are
# valid only in the default style. Macros can be included by
# either setting `IgnoreMacros` to false or adding specific macros to
# the `IncludedMacros` list.
#
# Precedence of options is all follows:
#
# 1. `AllowedMethods`
# 2. `AllowedPatterns`
# 3. `IncludedMacros`
#
# eg. If a method is listed in both
# `IncludedMacros` and `AllowedMethods`, then the latter takes
# precedence (that is, the method is allowed).
#
# In the alternative style (omit_parentheses), there are three additional
# options.
#
# 1. `AllowParenthesesInChaining` is `false` by default. Setting it to
#    `true` allows the presence of parentheses in the last call during
#    method chaining.
#
# 2. `AllowParenthesesInMultilineCall` is `false` by default. Setting it
#     to `true` allows the presence of parentheses in multi-line method
#     calls.
#
# 3. `AllowParenthesesInCamelCaseMethod` is `false` by default. This
#     allows the presence of parentheses when calling a method whose name
#     begins with a capital letter and which has no arguments. Setting it
#     to `true` allows the presence of parentheses in such a method call
#     even with arguments.
#
# NOTE: Parentheses are still allowed in cases where omitting them
# results in ambiguous or syntactically incorrect code. For example,
# parentheses are required around a method with arguments when inside an
# endless method definition introduced in Ruby 3.0. Parentheses are also
# allowed when forwarding arguments with the triple-dot syntax introduced
# in Ruby 2.7 as omitting them starts an endless range.
# And Ruby 3.1's hash omission syntax has a case that requires parentheses
# because of the following issue: https://bugs.ruby-lang.org/issues/18396.
#
# @example AllowParenthesesInStringInterpolation: true
#
#   # good
#   "#{t('this.is.good')}"
#
#   # good
#   "#{t 'this.is.also.good'}"
# @example EnforcedStyle: omit_parentheses
#
#   # bad
#   array.delete(e)
#
#   # good
#   array.delete e
#
#   # bad
#   foo.enforce(strict: true)
#
#   # good
#   foo.enforce strict: true
#
#   # good
#   # Allows parens for calls that won't produce valid Ruby or be ambiguous.
#   model.validate strict(true)
#
#   # good
#   # Allows parens for calls that won't produce valid Ruby or be ambiguous.
#   yield path, File.basename(path)
#
#   # good
#   # Operators methods calls with parens
#   array&.[](index)
#
#   # good
#   # Operators methods without parens, if you prefer
#   array.[] index
#
#   # good
#   # Operators methods calls with parens
#   array&.[](index)
#
#   # good
#   # Operators methods without parens, if you prefer
#   array.[] index
# @example IgnoreMacros: true (default)
#
#   # good
#   class Foo
#   bar :baz
#   end
# @example IgnoreMacros: false
#
#   # bad
#   class Foo
#   bar :baz
#   end
# @example AllowParenthesesInMultilineCall: false (default)
#
#   # bad
#   foo.enforce(
#   strict: true
#   )
#
#   # good
#   foo.enforce \
#   strict: true
# @example AllowParenthesesInMultilineCall: true
#
#   # good
#   foo.enforce(
#   strict: true
#   )
#
#   # good
#   foo.enforce \
#   strict: true
# @example AllowParenthesesInChaining: false (default)
#
#   # bad
#   foo().bar(1)
#
#   # good
#   foo().bar 1
# @example AllowParenthesesInChaining: true
#
#   # good
#   foo().bar(1)
#
#   # good
#   foo().bar 1
# @example AllowParenthesesInCamelCaseMethod: false (default)
#
#   # bad
#   Array(1)
#
#   # good
#   Array 1
# @example AllowParenthesesInCamelCaseMethod: true
#
#   # good
#   Array(1)
#
#   # good
#   Array 1
# @example AllowParenthesesInStringInterpolation: false (default)
#
#   # bad
#   "#{t('this.is.bad')}"
#
#   # good
#   "#{t 'this.is.better'}"
# @example EnforcedStyle: require_parentheses (default)
#
#   # bad
#   array.delete e
#
#   # good
#   array.delete(e)
#
#   # good
#   # Operators don't need parens
#   foo == bar
#
#   # good
#   # Setter methods don't need parens
#   foo.bar = baz
#
#   # okay with `puts` listed in `AllowedMethods`
#   puts 'test'
#
#   # okay with `^assert` listed in `AllowedPatterns`
#   assert_equal 'test', x
class RuboCop::Cop::Style::MethodCallWithArgsParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  include ::RuboCop::Cop::Style::MethodCallWithArgsParentheses::RequireParentheses
  include ::RuboCop::Cop::Style::MethodCallWithArgsParentheses::OmitParentheses
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end
  def on_super(node); end
  def on_yield(node); end

  private

  def args_begin(node); end
  def args_end(node); end

  # @return [Boolean]
  def args_parenthesized?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

# Style omit_parentheses
module RuboCop::Cop::Style::MethodCallWithArgsParentheses::OmitParentheses
  private

  # @return [Boolean]
  def allowed_camel_case_method_call?(node); end

  # @return [Boolean]
  def allowed_chained_call_with_parentheses?(node); end

  # @return [Boolean]
  def allowed_multiline_call_with_parentheses?(node); end

  # @return [Boolean]
  def allowed_string_interpolation_method_call?(node); end

  # @return [Boolean]
  def ambiguous_literal?(node); end

  # @return [Boolean]
  def assigned_before?(node, target); end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def call_as_argument_or_chain?(node); end

  # @return [Boolean]
  def call_in_literals?(node); end

  # @return [Boolean]
  def call_in_logical_operators?(node); end

  # @return [Boolean]
  def call_in_optional_arguments?(node); end

  # @return [Boolean]
  def call_in_single_line_inheritance?(node); end

  # @return [Boolean]
  def call_with_ambiguous_arguments?(node); end

  # @return [Boolean]
  def call_with_braced_block?(node); end

  # Require hash value omission be enclosed in parentheses to prevent the following issue:
  # https://bugs.ruby-lang.org/issues/18396.
  #
  # @return [Boolean]
  def exist_next_line_expression?(node); end

  # @return [Boolean]
  def hash_literal?(node); end

  # @return [Boolean]
  def hash_literal_in_arguments?(node); end

  # @return [Boolean]
  def inside_endless_method_def?(node); end

  # @return [Boolean]
  def inside_string_interpolation?(node); end

  # @return [Boolean]
  def legitimate_call_with_parentheses?(node); end

  # @return [Boolean]
  def logical_operator?(node); end

  # @return [Boolean]
  def modifier_form?(node); end

  def offense_range(node); end
  def omit_parentheses(node); end

  # @return [Boolean]
  def parentheses_at_the_end_of_multiline_call?(node); end

  # @return [Boolean]
  def regexp_slash_literal?(node); end

  # @return [Boolean]
  def require_parentheses_for_hash_value_omission?(node); end

  # @return [Boolean]
  def splat?(node); end

  # @return [Boolean]
  def super_call_without_arguments?(node); end

  # @return [Boolean]
  def syntax_like_method_call?(node); end

  # @return [Boolean]
  def ternary_if?(node); end

  # @return [Boolean]
  def unary_literal?(node); end
end

RuboCop::Cop::Style::MethodCallWithArgsParentheses::OmitParentheses::OMIT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MethodCallWithArgsParentheses::OmitParentheses::TRAILING_WHITESPACE_REGEX = T.let(T.unsafe(nil), Regexp)

# Style require_parentheses
module RuboCop::Cop::Style::MethodCallWithArgsParentheses::RequireParentheses
  private

  # @return [Boolean]
  def allowed_method_name?(name); end

  # @return [Boolean]
  def eligible_for_parentheses_omission?(node); end

  # @return [Boolean]
  def ignored_macro?(node); end

  def included_macros_list; end
  def require_parentheses(node); end
end

RuboCop::Cop::Style::MethodCallWithArgsParentheses::RequireParentheses::REQUIRE_MSG = T.let(T.unsafe(nil), String)

# Checks for unwanted parentheses in parameterless method calls.
#
# This cop can be customized allowed methods with `AllowedMethods`.
# By default, there are no methods to allowed.
#
# @example
#   # bad
#   object.some_method()
#
#   # good
#   object.some_method
# @example AllowedMethods: [] (default)
#   # bad
#   object.foo()
# @example AllowedMethods: [foo]
#   # good
#   object.foo()
class RuboCop::Cop::Style::MethodCallWithoutArgsParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def allowed_method_name?(name); end

  # @return [Boolean]
  def any_assignment?(node); end

  # @return [Boolean]
  def default_argument?(node); end

  # @return [Boolean]
  def ineligible_node?(node); end

  def offense_range(node); end
  def register_offense(node); end

  # @return [Boolean]
  def same_name_assignment?(node); end

  # @return [Boolean]
  def variable_in_mass_assignment?(variable_name, node); end
end

RuboCop::Cop::Style::MethodCallWithoutArgsParentheses::MSG = T.let(T.unsafe(nil), String)

# Checks for methods called on a do...end block. The point of
# this check is that it's easy to miss the call tacked on to the block
# when reading code.
#
# @example
#   # bad
#   a do
#   b
#   end.c
#
#   # good
#   a { b }.c
#
#   # good
#   foo = a do
#   b
#   end
#   foo.c
class RuboCop::Cop::Style::MethodCalledOnDoEndBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_block(node); end
  def on_csend(node); end
  def on_numblock(node); end
  def on_send(node); end
end

RuboCop::Cop::Style::MethodCalledOnDoEndBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for parentheses around the arguments in method
# definitions. Both instance and class/singleton methods are checked.
#
# Regardless of style, parentheses are necessary for:
#
# 1. Endless methods
# 2. Argument lists containing a `forward-arg` (`...`)
# 3. Argument lists containing an anonymous block forwarding (`&`)
#
# Removing the parens would be a syntax error here.
#
# @example EnforcedStyle: require_parentheses (default)
#   # The `require_parentheses` style requires method definitions
#   # to always use parentheses
#
#   # bad
#   def bar num1, num2
#   num1 + num2
#   end
#
#   def foo descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name
#   do_something
#   end
#
#   # good
#   def bar(num1, num2)
#   num1 + num2
#   end
#
#   def foo(descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name)
#   do_something
#   end
# @example EnforcedStyle: require_no_parentheses
#   # The `require_no_parentheses` style requires method definitions
#   # to never use parentheses
#
#   # bad
#   def bar(num1, num2)
#   num1 + num2
#   end
#
#   def foo(descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name)
#   do_something
#   end
#
#   # good
#   def bar num1, num2
#   num1 + num2
#   end
#
#   def foo descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name
#   do_something
#   end
# @example EnforcedStyle: require_no_parentheses_except_multiline
#   # The `require_no_parentheses_except_multiline` style prefers no
#   # parentheses when method definition arguments fit on single line,
#   # but prefers parentheses when arguments span multiple lines.
#
#   # bad
#   def bar(num1, num2)
#   num1 + num2
#   end
#
#   def foo descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name
#   do_something
#   end
#
#   # good
#   def bar num1, num2
#   num1 + num2
#   end
#
#   def foo(descriptive_var_name,
#   another_descriptive_var_name,
#   last_descriptive_var_name)
#   do_something
#   end
class RuboCop::Cop::Style::MethodDefParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def anonymous_block_arg?(node); end

  # @return [Boolean]
  def arguments_without_parentheses?(node); end

  def correct_arguments(arg_node, corrector); end

  # @return [Boolean]
  def forced_parentheses?(node); end

  def missing_parentheses(node); end

  # @return [Boolean]
  def require_parentheses?(args); end

  def unwanted_parentheses(args); end
end

RuboCop::Cop::Style::MethodDefParentheses::MSG_MISSING = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MethodDefParentheses::MSG_PRESENT = T.let(T.unsafe(nil), String)

# Checks for potential uses of `Enumerable#minmax`.
#
# @example
#
#   # bad
#   bar = [foo.min, foo.max]
#   return foo.min, foo.max
#
#   # good
#   bar = foo.minmax
#   return foo.minmax
class RuboCop::Cop::Style::MinMax < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def min_max_candidate(param0 = T.unsafe(nil)); end
  def on_array(node); end
  def on_return(node); end

  private

  def argument_range(node); end
  def message(offender, receiver); end
  def offending_range(node); end
end

RuboCop::Cop::Style::MinMax::MSG = T.let(T.unsafe(nil), String)

# Checks for `if` expressions that do not have an `else` branch.
#
# NOTE: Pattern matching is allowed to have no `else` branch because unlike `if` and `case`,
# it raises `NoMatchingPatternError` if the pattern doesn't match and without having `else`.
#
# Supported styles are: if, case, both.
#
# @example EnforcedStyle: both (default)
#   # warn when an `if` or `case` expression is missing an `else` branch.
#
#   # bad
#   if condition
#   statement
#   end
#
#   # bad
#   case var
#   when condition
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
#
#   # good
#   case var
#   when condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
# @example EnforcedStyle: if
#   # warn when an `if` expression is missing an `else` branch.
#
#   # bad
#   if condition
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
#
#   # good
#   case var
#   when condition
#   statement
#   end
#
#   # good
#   case var
#   when condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
# @example EnforcedStyle: case
#   # warn when a `case` expression is missing an `else` branch.
#
#   # bad
#   case var
#   when condition
#   statement
#   end
#
#   # good
#   case var
#   when condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
#
#   # good
#   if condition
#   statement
#   end
#
#   # good
#   if condition
#   statement
#   else
#   # the content of `else` branch will be determined by Style/EmptyElse
#   end
class RuboCop::Cop::Style::MissingElse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OnNormalIfUnless
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def on_case(node); end
  def on_case_match(node); end
  def on_normal_if_unless(node); end

  private

  # @return [Boolean]
  def case_style?; end

  def check(node); end
  def empty_else_config; end

  # @return [Boolean]
  def empty_else_cop_enabled?; end

  def empty_else_style; end

  # @return [Boolean]
  def if_style?; end

  def message_template; end
  def unless_else_config; end

  # @return [Boolean]
  def unless_else_cop_enabled?; end
end

RuboCop::Cop::Style::MissingElse::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MissingElse::MSG_EMPTY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MissingElse::MSG_NIL = T.let(T.unsafe(nil), String)

# Checks for the presence of `method_missing` without also
# defining `respond_to_missing?`.
#
# @example
#   #bad
#   def method_missing(name, *args)
#   # ...
#   end
#
#   #good
#   def respond_to_missing?(name, include_private)
#   # ...
#   end
#
#   def method_missing(name, *args)
#   # ...
#   end
class RuboCop::Cop::Style::MissingRespondToMissing < ::RuboCop::Cop::Base
  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def implements_respond_to_missing?(node); end
end

RuboCop::Cop::Style::MissingRespondToMissing::MSG = T.let(T.unsafe(nil), String)

# Checks for grouping of mixins in `class` and `module` bodies.
# By default it enforces mixins to be placed in separate declarations,
# but it can be configured to enforce grouping them in one declaration.
#
# @example EnforcedStyle: separated (default)
#   # bad
#   class Foo
#   include Bar, Qox
#   end
#
#   # good
#   class Foo
#   include Qox
#   include Bar
#   end
# @example EnforcedStyle: grouped
#   # bad
#   class Foo
#   extend Bar
#   extend Qox
#   end
#
#   # good
#   class Foo
#   extend Qox, Bar
#   end
class RuboCop::Cop::Style::MixinGrouping < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def on_module(node); end

  private

  def check(send_node); end
  def check_grouped_style(send_node); end
  def check_separated_style(send_node); end
  def group_mixins(node, mixins); end

  # @return [Boolean]
  def grouped_style?; end

  def range_to_remove_for_subsequent_mixin(mixins, node); end
  def separate_mixins(node); end

  # @return [Boolean]
  def separated_style?; end

  def sibling_mixins(send_node); end
end

RuboCop::Cop::Style::MixinGrouping::MIXIN_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::MixinGrouping::MSG = T.let(T.unsafe(nil), String)

# Checks that `include`, `extend` and `prepend` statements appear
# inside classes and modules, not at the top level, so as to not affect
# the behavior of `Object`.
#
# @example
#   # bad
#   include M
#
#   class C
#   end
#
#   # bad
#   extend M
#
#   class C
#   end
#
#   # bad
#   prepend M
#
#   class C
#   end
#
#   # good
#   class C
#   include M
#   end
#
#   # good
#   class C
#   extend M
#   end
#
#   # good
#   class C
#   prepend M
#   end
class RuboCop::Cop::Style::MixinUsage < ::RuboCop::Cop::Base
  def in_top_level_scope?(param0 = T.unsafe(nil)); end
  def include_statement(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Style::MixinUsage::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MixinUsage::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for use of `extend self` or `module_function` in a
# module.
#
# Supported styles are: module_function, extend_self, forbidden. `forbidden`
# style prohibits the usage of both styles.
#
# NOTE: the cop won't be activated when the module contains any private methods.
#
# @example EnforcedStyle: module_function (default)
#   # bad
#   module Test
#   extend self
#   # ...
#   end
#
#   # good
#   module Test
#   module_function
#   # ...
#   end
# @example EnforcedStyle: module_function (default)
#   # good
#   module Test
#   extend self
#   # ...
#   private
#   # ...
#   end
# @example EnforcedStyle: extend_self
#   # bad
#   module Test
#   module_function
#   # ...
#   end
#
#   # good
#   module Test
#   extend self
#   # ...
#   end
# @example EnforcedStyle: forbidden
#   # bad
#   module Test
#   module_function
#   # ...
#   end
#
#   # bad
#   module Test
#   extend self
#   # ...
#   end
#
#   # bad
#   module Test
#   extend self
#   # ...
#   private
#   # ...
#   end
class RuboCop::Cop::Style::ModuleFunction < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def extend_self_node?(param0 = T.unsafe(nil)); end
  def module_function_node?(param0 = T.unsafe(nil)); end
  def on_module(node); end
  def private_directive?(param0 = T.unsafe(nil)); end

  private

  def check_extend_self(nodes); end
  def check_forbidden(nodes); end
  def check_module_function(nodes); end
  def each_wrong_style(nodes, &block); end
  def message(_range); end
end

RuboCop::Cop::Style::ModuleFunction::EXTEND_SELF_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ModuleFunction::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ModuleFunction::MODULE_FUNCTION_MSG = T.let(T.unsafe(nil), String)

# Checks for chaining of a block after another block that spans
# multiple lines.
#
# @example
#
#   # bad
#   Thread.list.select do |t|
#   t.alive?
#   end.map do |t|
#   t.object_id
#   end
#
#   # good
#   alive_threads = Thread.list.select do |t|
#   t.alive?
#   end
#   alive_threads.map do |t|
#   t.object_id
#   end
class RuboCop::Cop::Style::MultilineBlockChain < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp

  def on_block(node); end
  def on_numblock(node); end
end

RuboCop::Cop::Style::MultilineBlockChain::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of if/unless modifiers with multiple-lines bodies.
#
# @example
#
#   # bad
#   {
#   result: 'this should not happen'
#   } unless cond
#
#   # good
#   { result: 'ok' } if cond
class RuboCop::Cop::Style::MultilineIfModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::StatementModifier
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def configured_indentation_width; end
  def indented_body(body, node); end
  def to_normal_if(node); end
end

RuboCop::Cop::Style::MultilineIfModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of the `then` keyword in multi-line if statements.
#
# @example
#   # bad
#   # This is considered bad practice.
#   if cond then
#   end
#
#   # good
#   # If statements can contain `then` on the same line.
#   if cond then a
#   elsif cond then b
#   end
class RuboCop::Cop::Style::MultilineIfThen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::OnNormalIfUnless
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_normal_if_unless(node); end

  private

  # @return [Boolean]
  def non_modifier_then?(node); end
end

RuboCop::Cop::Style::MultilineIfThen::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MultilineIfThen::NON_MODIFIER_THEN = T.let(T.unsafe(nil), Regexp)

# Checks uses of the `then` keyword in multi-line `in` statement.
#
# @example
#   # bad
#   case expression
#   in pattern then
#   end
#
#   # good
#   case expression
#   in pattern
#   end
#
#   # good
#   case expression
#   in pattern then do_something
#   end
#
#   # good
#   case expression
#   in pattern then do_something(arg1,
#   arg2)
#   end
class RuboCop::Cop::Style::MultilineInPatternThen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_in_pattern(node); end

  private

  # Requires `then` for write `in` and its body on the same line.
  #
  # @return [Boolean]
  def require_then?(in_pattern_node); end
end

RuboCop::Cop::Style::MultilineInPatternThen::MSG = T.let(T.unsafe(nil), String)

# Checks expressions wrapping styles for multiline memoization.
#
# @example EnforcedStyle: keyword (default)
#   # bad
#   foo ||= (
#   bar
#   baz
#   )
#
#   # good
#   foo ||= begin
#   bar
#   baz
#   end
# @example EnforcedStyle: braces
#   # bad
#   foo ||= begin
#   bar
#   baz
#   end
#
#   # good
#   foo ||= (
#   bar
#   baz
#   )
class RuboCop::Cop::Style::MultilineMemoization < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def message(_node); end
  def on_or_asgn(node); end

  private

  # @return [Boolean]
  def bad_rhs?(rhs); end

  def keyword_autocorrect(node, corrector); end
  def keyword_begin_str(node, node_buf); end
  def keyword_end_str(node, node_buf); end
end

RuboCop::Cop::Style::MultilineMemoization::BRACES_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MultilineMemoization::KEYWORD_MSG = T.let(T.unsafe(nil), String)

# Checks for method signatures that span multiple lines.
#
# @example
#
#   # good
#
#   def foo(bar, baz)
#   end
#
#   # bad
#
#   def foo(bar,
#   baz)
#   end
class RuboCop::Cop::Style::MultilineMethodSignature < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  def arguments_range(node); end
  def autocorrect(corrector, node); end
  def closing_line(node); end

  # @return [Boolean]
  def correction_exceeds_max_line_length?(node); end

  def definition_width(node); end
  def indentation_width(node); end
  def last_line_source_of_arguments(arguments); end
  def max_line_length; end
  def opening_line(node); end
end

RuboCop::Cop::Style::MultilineMethodSignature::MSG = T.let(T.unsafe(nil), String)

# Checks for multi-line ternary op expressions.
#
# NOTE: `return if ... else ... end` is syntax error. If `return` is used before
# multiline ternary operator expression, it will be autocorrected to single-line
# ternary operator. The same is true for `break`, `next`, and method call.
#
# @example
#   # bad
#   a = cond ?
#   b : c
#   a = cond ? b :
#   c
#   a = cond ?
#   b :
#   c
#
#   return cond ?
#   b :
#   c
#
#   # good
#   a = cond ? b : c
#   a = if cond
#   b
#   else
#   c
#   end
#
#   return cond ? b : c
class RuboCop::Cop::Style::MultilineTernaryOperator < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def enforce_single_line_ternary_operator?(node); end

  # @return [Boolean]
  def offense?(node); end

  def replacement(node); end

  # @return [Boolean]
  def use_assignment_method?(node); end
end

RuboCop::Cop::Style::MultilineTernaryOperator::MSG_IF = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MultilineTernaryOperator::MSG_SINGLE_LINE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::MultilineTernaryOperator::SINGLE_LINE_TYPES = T.let(T.unsafe(nil), Array)

# Checks uses of the `then` keyword
# in multi-line when statements.
#
# @example
#   # bad
#   case foo
#   when bar then
#   end
#
#   # good
#   case foo
#   when bar
#   end
#
#   # good
#   case foo
#   when bar then do_something
#   end
#
#   # good
#   case foo
#   when bar then do_something(arg1,
#   arg2)
#   end
class RuboCop::Cop::Style::MultilineWhenThen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_when(node); end

  private

  # @return [Boolean]
  def accept_node_type?(node); end

  # Requires `then` for write `when` and its body on the same line.
  #
  # @return [Boolean]
  def require_then?(when_node); end
end

RuboCop::Cop::Style::MultilineWhenThen::MSG = T.let(T.unsafe(nil), String)

# Checks against comparing a variable with multiple items, where
# `Array#include?`, `Set#include?` or a `case` could be used instead
# to avoid code repetition.
# It accepts comparisons of multiple method calls to avoid unnecessary method calls
# by default. It can be configured by `AllowMethodComparison` option.
#
# @example
#   # bad
#   a = 'a'
#   foo if a == 'a' || a == 'b' || a == 'c'
#
#   # good
#   a = 'a'
#   foo if ['a', 'b', 'c'].include?(a)
#
#   VALUES = Set['a', 'b', 'c'].freeze
#   # elsewhere...
#   foo if VALUES.include?(a)
#
#   case foo
#   when 'a', 'b', 'c' then foo
#   # ...
#   end
#
#   # accepted (but consider `case` as above)
#   foo if a == b.lightweight || a == b.heavyweight
# @example AllowMethodComparison: true (default)
#   # good
#   foo if a == b.lightweight || a == b.heavyweight
# @example AllowMethodComparison: false
#   # bad
#   foo if a == b.lightweight || a == b.heavyweight
#
#   # good
#   foo if [b.lightweight, b.heavyweight].include?(a)
class RuboCop::Cop::Style::MultipleComparison < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
  def on_or(node); end
  def simple_comparison_lhs?(param0 = T.unsafe(nil)); end
  def simple_comparison_rhs?(param0 = T.unsafe(nil)); end
  def simple_double_comparison?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def allow_method_comparison?; end

  # @return [Boolean]
  def comparison?(node); end

  # @return [Boolean]
  def nested_comparison?(node); end

  # @return [Boolean]
  def nested_variable_comparison?(node); end

  def reset_comparison; end
  def root_of_or_node(or_node); end

  # @return [Boolean]
  def switch_comparison?(node); end

  def variable_name(node); end
  def variables_in_node(node); end
  def variables_in_simple_node(node); end
end

RuboCop::Cop::Style::MultipleComparison::MSG = T.let(T.unsafe(nil), String)

# Checks whether some constant value isn't a
# mutable literal (e.g. array or hash).
#
# Strict mode can be used to freeze all constants, rather than
# just literals.
# Strict mode is considered an experimental feature. It has not been
# updated with an exhaustive list of all methods that will produce
# frozen objects so there is a decent chance of getting some false
# positives. Luckily, there is no harm in freezing an already
# frozen object.
#
# From Ruby 3.0, this cop honours the magic comment
# 'shareable_constant_value'. When this magic comment is set to any
# acceptable value other than none, it will suppress the offenses
# raised by this cop. It enforces frozen state.
#
# NOTE: Regexp and Range literals are frozen objects since Ruby 3.0.
#
# NOTE: From Ruby 3.0, interpolated strings are not frozen when
# `# frozen-string-literal: true` is used, so this cop enforces explicit
# freezing for such strings.
#
# NOTE: From Ruby 3.0, this cop allows explicit freezing of constants when
# the `shareable_constant_value` directive is used.
#
# @example EnforcedStyle: literals (default)
#   # bad
#   CONST = [1, 2, 3]
#
#   # good
#   CONST = [1, 2, 3].freeze
#
#   # good
#   CONST = <<~TESTING.freeze
#   This is a heredoc
#   TESTING
#
#   # good
#   CONST = Something.new
# @example EnforcedStyle: strict
#   # bad
#   CONST = Something.new
#
#   # bad
#   CONST = Struct.new do
#   def foo
#   puts 1
#   end
#   end
#
#   # good
#   CONST = Something.new.freeze
#
#   # good
#   CONST = Struct.new do
#   def foo
#   puts 1
#   end
#   end.freeze
# @example
#   # Magic comment - shareable_constant_value: literal
#
#   # bad
#   CONST = [1, 2, 3]
#
#   # good
#   # shareable_constant_value: literal
#   CONST = [1, 2, 3]
class RuboCop::Cop::Style::MutableConstant < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Style::MutableConstant::ShareableConstantValue
  include ::RuboCop::Cop::FrozenStringLiteral
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_casgn(node); end

  # Some of these patterns may not actually return an immutable object,
  # but we want to consider them immutable for this cop.
  def operation_produces_immutable_object?(param0 = T.unsafe(nil)); end

  def range_enclosed_in_parentheses?(param0 = T.unsafe(nil)); end
  def splat_value(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def check(value); end
  def correct_splat_expansion(corrector, expr, splat_value); end

  # @return [Boolean]
  def frozen_regexp_or_range_literals?(node); end

  # @return [Boolean]
  def immutable_literal?(node); end

  # @return [Boolean]
  def mutable_literal?(value); end

  def on_assignment(value); end

  # @return [Boolean]
  def requires_parentheses?(node); end

  # @return [Boolean]
  def shareable_constant_value?(node); end

  def strict_check(value); end
end

RuboCop::Cop::Style::MutableConstant::MSG = T.let(T.unsafe(nil), String)

# Handles magic comment shareable_constant_value with O(n ^ 2) complexity
# n - number of lines in the source
# Iterates over all lines before a CONSTANT
# until it reaches shareable_constant_value
module RuboCop::Cop::Style::MutableConstant::ShareableConstantValue
  private

  # Identifies the most recent magic comment with valid shareable constant values
  # that's in scope for this node
  def magic_comment_in_scope(node); end

  def processed_source_till_node(node); end
  def recent_shareable_value?(node); end
  def shareable_constant_value_enabled?(value); end

  class << self
    # Identifies the most recent magic comment with valid shareable constant values
    # that's in scope for this node
    def magic_comment_in_scope(node); end

    # @return [Boolean]
    def recent_shareable_value?(node); end
  end
end

# Checks for uses of if with a negated condition. Only ifs
# without else are considered. There are three different styles:
#
# * both
# * prefix
# * postfix
#
# @example EnforcedStyle: both (default)
#   # enforces `unless` for `prefix` and `postfix` conditionals
#
#   # bad
#
#   if !foo
#   bar
#   end
#
#   # good
#
#   unless foo
#   bar
#   end
#
#   # bad
#
#   bar if !foo
#
#   # good
#
#   bar unless foo
# @example EnforcedStyle: prefix
#   # enforces `unless` for just `prefix` conditionals
#
#   # bad
#
#   if !foo
#   bar
#   end
#
#   # good
#
#   unless foo
#   bar
#   end
#
#   # good
#
#   bar if !foo
# @example EnforcedStyle: postfix
#   # enforces `unless` for just `postfix` conditionals
#
#   # bad
#
#   bar if !foo
#
#   # good
#
#   bar unless foo
#
#   # good
#
#   if !foo
#   bar
#   end
class RuboCop::Cop::Style::NegatedIf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::NegativeConditional
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def correct_style?(node); end

  def message(node); end
end

# Checks for uses of `if-else` and ternary operators with a negated condition
# which can be simplified by inverting condition and swapping branches.
#
# @example
#   # bad
#   if !x
#   do_something
#   else
#   do_something_else
#   end
#
#   # good
#   if x
#   do_something_else
#   else
#   do_something
#   end
#
#   # bad
#   !x ? do_something : do_something_else
#
#   # good
#   x ? do_something_else : do_something
class RuboCop::Cop::Style::NegatedIfElseCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def double_negation?(param0 = T.unsafe(nil)); end
  def on_if(node); end
  def on_new_investigation; end

  private

  def correct_negated_condition(corrector, node); end

  # @return [Boolean]
  def corrected_ancestor?(node); end

  # Collect the entire else branch, including whitespace and comments
  def else_range(node); end

  # @return [Boolean]
  def if_else?(node); end

  # Collect the entire if branch, including whitespace and comments
  def if_range(node); end

  # @return [Boolean]
  def negated_condition?(node); end

  def swap_branches(corrector, node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::NegatedIfElseCondition::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NegatedIfElseCondition::NEGATED_EQUALITY_METHODS = T.let(T.unsafe(nil), Array)

# Checks for uses of unless with a negated condition. Only unless
# without else are considered. There are three different styles:
#
# * both
# * prefix
# * postfix
#
# @example EnforcedStyle: both (default)
#   # enforces `if` for `prefix` and `postfix` conditionals
#
#   # bad
#   unless !foo
#   bar
#   end
#
#   # good
#   if foo
#   bar
#   end
#
#   # bad
#   bar unless !foo
#
#   # good
#   bar if foo
# @example EnforcedStyle: prefix
#   # enforces `if` for just `prefix` conditionals
#
#   # bad
#   unless !foo
#   bar
#   end
#
#   # good
#   if foo
#   bar
#   end
#
#   # good
#   bar unless !foo
# @example EnforcedStyle: postfix
#   # enforces `if` for just `postfix` conditionals
#
#   # bad
#   bar unless !foo
#
#   # good
#   bar if foo
#
#   # good
#   unless !foo
#   bar
#   end
class RuboCop::Cop::Style::NegatedUnless < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::NegativeConditional
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def correct_style?(node); end

  def message(node); end
end

# Checks for uses of while with a negated condition.
#
# @example
#   # bad
#   while !foo
#   bar
#   end
#
#   # good
#   until foo
#   bar
#   end
#
#   # bad
#   bar until !foo
#
#   # good
#   bar while foo
#   bar while !foo && baz
class RuboCop::Cop::Style::NegatedWhile < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::NegativeConditional
  extend ::RuboCop::Cop::AutoCorrector

  def on_until(node); end
  def on_while(node); end
end

# Checks for nested `File.dirname`.
# It replaces nested `File.dirname` with the level argument introduced in Ruby 3.1.
#
# @example
#
#   # bad
#   File.dirname(File.dirname(path))
#
#   # good
#   File.dirname(path, 2)
class RuboCop::Cop::Style::NestedFileDirname < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def file_dirname?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def offense_range(node); end
  def path_with_dir_level(node, level); end
end

RuboCop::Cop::Style::NestedFileDirname::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NestedFileDirname::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for nested use of if, unless, while and until in their
# modifier form.
#
# @example
#
#   # bad
#   something if a if b
#
#   # good
#   something if b && a
class RuboCop::Cop::Style::NestedModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
  def on_until(node); end
  def on_while(node); end

  private

  def add_parentheses_to_method_arguments(send_node); end
  def autocorrect(corrector, node); end
  def check(node); end
  def left_hand_operand(node, operator); end

  # @return [Boolean]
  def modifier?(node); end

  def new_expression(inner_node); end
  def replacement_operator(keyword); end

  # @return [Boolean]
  def requires_parens?(node); end

  def right_hand_operand(node, left_hand_keyword); end
end

RuboCop::Cop::Style::NestedModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for unparenthesized method calls in the argument list
# of a parenthesized method call.
# `be`, `be_a`, `be_an`, `be_between`, `be_falsey`, `be_kind_of`, `be_instance_of`,
# `be_truthy`, `be_within`, `eq`, `eql`, `end_with`, `include`, `match`, `raise_error`,
# `respond_to`, and `start_with` methods are allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example
#   # good
#   method1(method2(arg))
#
#   # bad
#   method1(method2 arg)
# @example AllowedMethods: [foo]
#   # good
#   method1(foo arg)
class RuboCop::Cop::Style::NestedParenthesizedCalls < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def allowed?(send_node); end

  # @return [Boolean]
  def allowed_omission?(send_node); end

  def autocorrect(corrector, nested); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::NestedParenthesizedCalls::MSG = T.let(T.unsafe(nil), String)

# Checks for nested ternary op expressions.
#
# @example
#   # bad
#   a ? (b ? b1 : b2) : a2
#
#   # good
#   if a
#   b ? b1 : b2
#   else
#   a2
#   end
class RuboCop::Cop::Style::NestedTernaryOperator < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  def autocorrect(corrector, if_node); end
  def if_node(node); end
  def remove_parentheses(source); end
  def replace_loc_and_whitespace(corrector, range, replacement); end
end

RuboCop::Cop::Style::NestedTernaryOperator::MSG = T.let(T.unsafe(nil), String)

# Use `next` to skip iteration instead of a condition at the end.
#
# @example EnforcedStyle: skip_modifier_ifs (default)
#   # bad
#   [1, 2].each do |a|
#   if a == 1
#   puts a
#   end
#   end
#
#   # good
#   [1, 2].each do |a|
#   next unless a == 1
#   puts a
#   end
#
#   # good
#   [1, 2].each do |a|
#   puts a if a == 1
#   end
# @example EnforcedStyle: always
#   # With `always` all conditions at the end of an iteration needs to be
#   # replaced by next - with `skip_modifier_ifs` the modifier if like
#   # this one are ignored: `[1, 2].each { |a| puts a if a == 1 }`
#
#   # bad
#   [1, 2].each do |a|
#   puts a if a == 1
#   end
#
#   # bad
#   [1, 2].each do |a|
#   if a == 1
#   puts a
#   end
#   end
#
#   # good
#   [1, 2].each do |a|
#   next unless a == 1
#   puts a
#   end
class RuboCop::Cop::Style::Next < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::MinBodyLength
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_for(node); end
  def on_new_investigation; end
  def on_numblock(node); end
  def on_until(node); end
  def on_while(node); end

  private

  def actual_indent(lines, buffer); end

  # @return [Boolean]
  def allowed_modifier_if?(node); end

  def autocorrect_block(corrector, node); end
  def autocorrect_modifier(corrector, node); end
  def check(node); end
  def cond_range(node, cond); end

  # @return [Boolean]
  def end_followed_by_whitespace_only?(source_buffer, end_pos); end

  def end_range(node); end

  # @return [Boolean]
  def ends_with_condition?(body); end

  # @return [Boolean]
  def exit_body_type?(node); end

  def heredoc_lines(node); end

  # @return [Boolean]
  def if_else_children?(node); end

  # @return [Boolean]
  def if_without_else?(node); end

  def offense_location(offense_node); end
  def offense_node(body); end

  # Adjust indentation of `lines` to match `node`
  def reindent(lines, node, corrector); end

  def reindent_line(corrector, lineno, delta, buffer); end
  def reindentable_lines(node); end

  # @return [Boolean]
  def simple_if_without_break?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::Next::EXIT_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::Next::MSG = T.let(T.unsafe(nil), String)

# Checks for comparison of something with nil using `==` and
# `nil?`.
#
# Supported styles are: predicate, comparison.
#
# @example EnforcedStyle: predicate (default)
#
#   # bad
#   if x == nil
#   end
#
#   # good
#   if x.nil?
#   end
# @example EnforcedStyle: comparison
#
#   # bad
#   if x.nil?
#   end
#
#   # good
#   if x == nil
#   end
class RuboCop::Cop::Style::NilComparison < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def nil_check?(param0 = T.unsafe(nil)); end
  def nil_comparison?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def message(_node); end

  # @return [Boolean]
  def prefer_comparison?; end

  # @return [Boolean]
  def style_check?(node, &block); end
end

RuboCop::Cop::Style::NilComparison::EXPLICIT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NilComparison::PREDICATE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NilComparison::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for lambdas and procs that always return nil,
# which can be replaced with an empty lambda or proc instead.
#
# @example
#   # bad
#   -> { nil }
#
#   lambda do
#   next nil
#   end
#
#   proc { nil }
#
#   Proc.new do
#   break nil
#   end
#
#   # good
#   -> {}
#
#   lambda do
#   end
#
#   -> (x) { nil if x }
#
#   proc {}
#
#   Proc.new { nil if x }
class RuboCop::Cop::Style::NilLambda < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def nil_return?(param0 = T.unsafe(nil)); end
  def on_block(node); end

  private

  def autocorrect(corrector, node); end
end

RuboCop::Cop::Style::NilLambda::MSG = T.let(T.unsafe(nil), String)

# Checks for non-nil checks, which are usually redundant.
#
# With `IncludeSemanticChanges` set to `false` by default, this cop
# does not report offenses for `!x.nil?` and does no changes that might
# change behavior.
# Also `IncludeSemanticChanges` set to `false` with `EnforcedStyle: comparison` of
# `Style/NilComparison` cop, this cop does not report offenses for `x != nil` and
# does no changes to `!x.nil?` style.
#
# With `IncludeSemanticChanges` set to `true`, this cop reports offenses
# for `!x.nil?` and autocorrects that and `x != nil` to solely `x`, which
# is *usually* OK, but might change behavior.
#
# @example
#   # bad
#   if x != nil
#   end
#
#   # good
#   if x
#   end
#
#   # Non-nil checks are allowed if they are the final nodes of predicate.
#   # good
#   def signed_in?
#   !current_user.nil?
#   end
# @example IncludeSemanticChanges: false (default)
#   # good
#   if !x.nil?
#   end
# @example IncludeSemanticChanges: true
#   # bad
#   if !x.nil?
#   end
class RuboCop::Cop::Style::NonNilCheck < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def nil_check?(param0 = T.unsafe(nil)); end
  def not_and_nil_check?(param0 = T.unsafe(nil)); end
  def not_equal_to_nil?(param0 = T.unsafe(nil)); end
  def on_def(node); end
  def on_defs(node); end
  def on_send(node); end
  def unless_check?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def autocorrect_comparison(corrector, node); end
  def autocorrect_non_nil(corrector, node, inner_node); end
  def autocorrect_unless_nil(corrector, node, receiver); end

  # @return [Boolean]
  def include_semantic_changes?; end

  def message(node); end
  def nil_comparison_style; end

  # @return [Boolean]
  def register_offense?(node); end

  # @return [Boolean]
  def unless_and_nil_check?(send_node); end
end

RuboCop::Cop::Style::NonNilCheck::MSG_FOR_REDUNDANCY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NonNilCheck::MSG_FOR_REPLACEMENT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NonNilCheck::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of the keyword `not` instead of `!`.
#
# @example
#
#   # bad - parentheses are required because of op precedence
#   x = (not something)
#
#   # good
#   x = !something
class RuboCop::Cop::Style::Not < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def correct_opposite_method(corrector, range, child); end
  def correct_with_parens(corrector, range, node); end
  def correct_without_parens(corrector, range); end

  # @return [Boolean]
  def opposite_method?(child); end

  # @return [Boolean]
  def requires_parens?(child); end
end

RuboCop::Cop::Style::Not::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Not::OPPOSITE_METHODS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::Not::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for numbered parameters.
#
# It can either restrict the use of numbered parameters to
# single-lined blocks, or disallow completely numbered parameters.
#
# @example EnforcedStyle: allow_single_line (default)
#   # bad
#   collection.each do
#   puts _1
#   end
#
#   # good
#   collection.each { puts _1 }
# @example EnforcedStyle: disallow
#   # bad
#   collection.each { puts _1 }
#
#   # good
#   collection.each { |item| puts item }
class RuboCop::Cop::Style::NumberedParameters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_numblock(node); end
end

RuboCop::Cop::Style::NumberedParameters::MSG_DISALLOW = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumberedParameters::MSG_MULTI_LINE = T.let(T.unsafe(nil), String)

# Detects use of an excessive amount of numbered parameters in a
# single block. Having too many numbered parameters can make code too
# cryptic and hard to read.
#
# The cop defaults to registering an offense if there is more than 1 numbered
# parameter but this maximum can be configured by setting `Max`.
#
# @example Max: 1 (default)
#   # bad
#   foo { _1.call(_2, _3, _4) }
#
#   # good
#   foo { do_something(_1) }
class RuboCop::Cop::Style::NumberedParametersLimit < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::TargetRubyVersion

  def max=(value); end
  def on_numblock(node); end

  private

  def max_count; end
end

RuboCop::Cop::Style::NumberedParametersLimit::DEFAULT_MAX_VALUE = T.let(T.unsafe(nil), Integer)
RuboCop::Cop::Style::NumberedParametersLimit::MSG = T.let(T.unsafe(nil), String)

# Checks for octal, hex, binary, and decimal literals using
# uppercase prefixes and corrects them to lowercase prefix
# or no prefix (in case of decimals).
#
# @example EnforcedOctalStyle: zero_with_o (default)
#   # bad - missing octal prefix
#   num = 01234
#
#   # bad - uppercase prefix
#   num = 0O1234
#   num = 0X12AB
#   num = 0B10101
#
#   # bad - redundant decimal prefix
#   num = 0D1234
#   num = 0d1234
#
#   # good
#   num = 0o1234
#   num = 0x12AB
#   num = 0b10101
#   num = 1234
# @example EnforcedOctalStyle: zero_only
#   # bad
#   num = 0o1234
#   num = 0O1234
#
#   # good
#   num = 01234
class RuboCop::Cop::Style::NumericLiteralPrefix < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::IntegerNode
  extend ::RuboCop::Cop::AutoCorrector

  def on_int(node); end

  private

  def format_binary(source); end
  def format_decimal(source); end
  def format_hex(source); end
  def format_octal(source); end
  def format_octal_zero_only(source); end
  def hex_bin_dec_literal_type(literal); end
  def literal_type(node); end
  def message(node); end
  def octal_literal_type(literal); end

  # @return [Boolean]
  def octal_zero_only?; end
end

RuboCop::Cop::Style::NumericLiteralPrefix::BINARY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericLiteralPrefix::BINARY_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::NumericLiteralPrefix::DECIMAL_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericLiteralPrefix::DECIMAL_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::NumericLiteralPrefix::HEX_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericLiteralPrefix::HEX_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::NumericLiteralPrefix::OCTAL_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericLiteralPrefix::OCTAL_REGEX = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::NumericLiteralPrefix::OCTAL_ZERO_ONLY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericLiteralPrefix::OCTAL_ZERO_ONLY_REGEX = T.let(T.unsafe(nil), Regexp)

# Checks for big numeric literals without `_` between groups
# of digits in them.
#
# Additional allowed patterns can be added by adding regexps to
# the `AllowedPatterns` configuration. All regexps are treated
# as anchored even if the patterns do not contain anchors (so
# `\d{4}_\d{4}` will allow `1234_5678` but not `1234_5678_9012`).
#
# NOTE: Even if `AllowedPatterns` are given, autocorrection will
# only correct to the standard pattern of an `_` every 3 digits.
#
# @example
#
#   # bad
#   1000000
#   1_00_000
#   1_0000
#
#   # good
#   1_000_000
#   1000
# @example Strict: false (default)
#
#   # good
#   10_000_00 # typical representation of $10,000 in cents
# @example Strict: true
#
#   # bad
#   10_000_00 # typical representation of $10,000 in cents
# @example AllowedNumbers: [3000]
#
#   # good
#   3000 # You can specify allowed numbers. (e.g. port number)
class RuboCop::Cop::Style::NumericLiterals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::IntegerNode
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def min_digits=(value); end
  def on_float(node); end
  def on_int(node); end

  private

  def allowed_numbers; end
  def allowed_patterns; end
  def check(node); end

  # @param int_part [String]
  def format_int_part(int_part); end

  def format_number(node); end
  def min_digits; end
  def register_offense(node, &_block); end
  def short_group_regex; end
end

RuboCop::Cop::Style::NumericLiterals::DELIMITER_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::NumericLiterals::MSG = T.let(T.unsafe(nil), String)

# Checks for usage of comparison operators (`==`,
# `>`, `<`) to test numbers as zero, positive, or negative.
# These can be replaced by their respective predicate methods.
# This cop can also be configured to do the reverse.
#
# This cop can be customized allowed methods with `AllowedMethods`.
# By default, there are no methods to allowed.
#
# This cop disregards `#nonzero?` as its value is truthy or falsey,
# but not `true` and `false`, and thus not always interchangeable with
# `!= 0`.
#
# This cop allows comparisons to global variables, since they are often
# populated with objects which can be compared with integers, but are
# not themselves `Integer` polymorphic.
#
# @example EnforcedStyle: predicate (default)
#   # bad
#   foo == 0
#   0 > foo
#   bar.baz > 0
#
#   # good
#   foo.zero?
#   foo.negative?
#   bar.baz.positive?
# @example EnforcedStyle: comparison
#   # bad
#   foo.zero?
#   foo.negative?
#   bar.baz.positive?
#
#   # good
#   foo == 0
#   0 > foo
#   bar.baz > 0
# @example AllowedMethods: [] (default) with EnforcedStyle: predicate
#   # bad
#   foo == 0
#   0 > foo
#   bar.baz > 0
# @example AllowedMethods: [==] with EnforcedStyle: predicate
#   # good
#   foo == 0
#
#   # bad
#   0 > foo
#   bar.baz > 0
# @example AllowedPatterns: [] (default) with EnforcedStyle: comparison
#   # bad
#   foo.zero?
#   foo.negative?
#   bar.baz.positive?
# @example AllowedPatterns: [/zero/] with EnforcedStyle: predicate
#   # good
#   # bad
#   foo.zero?
#
#   # bad
#   foo.negative?
#   bar.baz.positive?
class RuboCop::Cop::Style::NumericPredicate < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  def comparison(param0 = T.unsafe(nil)); end
  def inverted_comparison(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def predicate(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def allowed_method_name?(name); end

  def check(node); end
  def invert; end
  def parenthesized_source(node); end
  def replacement(numeric, operation); end

  # @return [Boolean]
  def replacement_supported?(operator); end

  # @return [Boolean]
  def require_parentheses?(node); end
end

RuboCop::Cop::Style::NumericPredicate::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::NumericPredicate::REPLACEMENTS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::NumericPredicate::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of consistent method names
# `Object#yield_self` or `Object#then`.
#
# @example EnforcedStyle: then (default)
#
#   # bad
#   obj.yield_self { |x| x.do_something }
#
#   # good
#   obj.then { |x| x.do_something }
# @example EnforcedStyle: yield_self
#
#   # bad
#   obj.then { |x| x.do_something }
#
#   # good
#   obj.yield_self { |x| x.do_something }
class RuboCop::Cop::Style::ObjectThen < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def on_send(node); end

  private

  def check_method_node(node); end
  def message(node); end
  def preferred_method(node); end
end

RuboCop::Cop::Style::ObjectThen::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of if/then/else/end constructs on a single line.
# AlwaysCorrectToMultiline config option can be set to true to auto-convert all offenses to
# multi-line constructs. When AlwaysCorrectToMultiline is false (default case) the
# autocorrect will first try converting them to ternary operators.
#
# @example
#   # bad
#   if foo then bar else baz end
#
#   # bad
#   unless foo then baz else bar end
#
#   # good
#   foo ? bar : baz
#
#   # good
#   bar if foo
#
#   # good
#   if foo then bar end
#
#   # good
#   if foo
#   bar
#   else
#   baz
#   end
class RuboCop::Cop::Style::OneLineConditional < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::OnNormalIfUnless
  extend ::RuboCop::Cop::AutoCorrector

  def on_normal_if_unless(node); end

  private

  # @return [Boolean]
  def always_multiline?; end

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def cannot_replace_to_ternary?(node); end

  def expr_replacement(node); end
  def indentation_width; end

  # @return [Boolean]
  def keyword_with_changed_precedence?(node); end

  def message(node); end

  # @return [Boolean]
  def method_call_with_changed_precedence?(node); end

  # @return [Boolean]
  def requires_parentheses?(node); end

  def ternary_correction(node); end
  def ternary_replacement(node); end
end

RuboCop::Cop::Style::OneLineConditional::MSG = T.let(T.unsafe(nil), String)

# Flags uses of OpenStruct, as it is now officially discouraged
# to be used for performance, version compatibility, and potential security issues.
#
# @example
#
#   # bad
#   point = OpenStruct.new(x: 0, y: 1)
#
#   # good
#   Point = Struct.new(:x, :y)
#   point = Point.new(0, 1)
#
#   # also good
#   point = { x: 0, y: 1 }
#
#   # bad
#   test_double = OpenStruct.new(a: 'b')
#
#   # good (assumes test using rspec-mocks)
#   test_double = double
#   allow(test_double).to receive(:a).and_return('b')
class RuboCop::Cop::Style::OpenStructUse < ::RuboCop::Cop::Base
  def on_const(node); end
  def uses_open_struct?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def custom_class_or_module_definition?(node); end
end

RuboCop::Cop::Style::OpenStructUse::MSG = T.let(T.unsafe(nil), String)

# Checks for options hashes and discourages them if the
# current Ruby version supports keyword arguments.
#
# @example
#
#   # bad
#   def fry(options = {})
#   temperature = options.fetch(:temperature, 300)
#   # ...
#   end
#
#   # good
#   def fry(temperature: 300)
#   # ...
#   end
class RuboCop::Cop::Style::OptionHash < ::RuboCop::Cop::Base
  def on_args(node); end
  def option_hash(param0 = T.unsafe(nil)); end

  private

  def allowlist; end

  # @return [Boolean]
  def super_used?(node); end

  # @return [Boolean]
  def suspicious_name?(arg_name); end
end

RuboCop::Cop::Style::OptionHash::MSG = T.let(T.unsafe(nil), String)

# Checks for optional arguments to methods
# that do not come at the end of the argument list.
#
# @example
#   # bad
#   def foo(a = 1, b, c)
#   end
#
#   # good
#   def baz(a, b, c = 1)
#   end
#
#   def foobar(a = 1, b = 2, c = 3)
#   end
class RuboCop::Cop::Style::OptionalArguments < ::RuboCop::Cop::Base
  def on_def(node); end

  private

  def argument_positions(arguments); end
  def each_misplaced_optional_arg(arguments); end
end

RuboCop::Cop::Style::OptionalArguments::MSG = T.let(T.unsafe(nil), String)

# Checks for places where keyword arguments can be used instead of
# boolean arguments when defining methods. `respond_to_missing?` method is allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example
#   # bad
#   def some_method(bar = false)
#   puts bar
#   end
#
#   # bad - common hack before keyword args were introduced
#   def some_method(options = {})
#   bar = options.fetch(:bar, false)
#   puts bar
#   end
#
#   # good
#   def some_method(bar: false)
#   puts bar
#   end
# @example AllowedMethods: ['some_method']
#   # good
#   def some_method(bar = false)
#   puts bar
#   end
class RuboCop::Cop::Style::OptionalBooleanParameter < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods

  def on_def(node); end
  def on_defs(node); end

  private

  def format_message(argument); end
end

RuboCop::Cop::Style::OptionalBooleanParameter::MSG = T.let(T.unsafe(nil), String)

# Checks for potential usage of the `||=` operator.
#
# @example
#   # bad
#   name = name ? name : 'Bozhidar'
#
#   # bad
#   name = if name
#   name
#   else
#   'Bozhidar'
#   end
#
#   # bad
#   unless name
#   name = 'Bozhidar'
#   end
#
#   # bad
#   name = 'Bozhidar' unless name
#
#   # good - set name to 'Bozhidar', only if it's nil or false
#   name ||= 'Bozhidar'
class RuboCop::Cop::Style::OrAssignment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_if(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def ternary_assignment?(param0 = T.unsafe(nil)); end
  def unless_assignment?(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def take_variable_and_default_from_ternary(node); end
  def take_variable_and_default_from_unless(node); end
end

RuboCop::Cop::Style::OrAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for simple usages of parallel assignment.
# This will only complain when the number of variables
# being assigned matched the number of assigning variables.
#
# @example
#   # bad
#   a, b, c = 1, 2, 3
#   a, b, c = [1, 2, 3]
#
#   # good
#   one, two = *foo
#   a, b = foo()
#   a, b = b, a
#
#   a = 1
#   b = 2
#   c = 3
class RuboCop::Cop::Style::ParallelAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode
  extend ::RuboCop::Cop::AutoCorrector

  def implicit_self_getter?(param0 = T.unsafe(nil)); end
  def on_masgn(node); end

  private

  # Converts (send nil :something) nodes to (send (:self) :something).
  # This makes the sorting algorithm work for expressions such as
  # `self.a, self.b = b, a`.
  def add_self_to_getters(right_elements); end

  # @return [Boolean]
  def allowed_lhs?(node); end

  # @return [Boolean]
  def allowed_masign?(lhs_elements, rhs_elements); end

  # @return [Boolean]
  def allowed_rhs?(node); end

  def assignment_corrector(node, order); end
  def autocorrect(corrector, node); end
  def find_valid_order(left_elements, right_elements); end

  # @return [Boolean]
  def modifier_statement?(node); end

  # @return [Boolean]
  def return_of_method_call?(node); end
end

# Helper class necessitated by silly design of TSort prior to Ruby 2.1
# Newer versions have a better API, but that doesn't help us
class RuboCop::Cop::Style::ParallelAssignment::AssignmentSorter
  include ::TSort
  extend ::RuboCop::AST::NodePattern::Macros

  # @return [AssignmentSorter] a new instance of AssignmentSorter
  def initialize(assignments); end

  # `lhs` is an assignment method call like `obj.attr=` or `ary[idx]=`.
  # Does `rhs` access the same value which is assigned by `lhs`?
  #
  # @return [Boolean]
  def accesses?(rhs, lhs); end

  # @return [Boolean]
  def dependency?(lhs, rhs); end

  def matching_calls(param0, param1, param2); end
  def tsort_each_child(assignment); end
  def tsort_each_node(&block); end
  def uses_var?(param0, param1); end
  def var_name(param0 = T.unsafe(nil)); end
end

# An internal class for correcting parallel assignment
class RuboCop::Cop::Style::ParallelAssignment::GenericCorrector
  include ::RuboCop::Cop::Alignment

  # @return [GenericCorrector] a new instance of GenericCorrector
  def initialize(node, config, new_elements); end

  # Returns the value of attribute config.
  def config; end

  def correction; end
  def correction_range; end

  # Returns the value of attribute node.
  def node; end

  protected

  def assignment; end

  private

  def cop_config; end
  def extract_sources(node); end
  def source(node); end
end

RuboCop::Cop::Style::ParallelAssignment::MSG = T.let(T.unsafe(nil), String)

# An internal class for correcting parallel assignment
# guarded by if, unless, while, or until
class RuboCop::Cop::Style::ParallelAssignment::ModifierCorrector < ::RuboCop::Cop::Style::ParallelAssignment::GenericCorrector
  def correction; end
  def correction_range; end

  private

  def modifier_range(node); end
end

# An internal class for correcting parallel assignment
# protected by rescue
class RuboCop::Cop::Style::ParallelAssignment::RescueCorrector < ::RuboCop::Cop::Style::ParallelAssignment::GenericCorrector
  def correction; end
  def correction_range; end

  private

  def begin_correction(rescue_result); end
  def def_correction(rescue_result); end
end

# Checks for the presence of superfluous parentheses around the
# condition of if/unless/while/until.
#
# `AllowSafeAssignment` option for safe assignment.
# By safe assignment we mean putting parentheses around
# an assignment to indicate "I know I'm using an assignment
# as a condition. It's not a mistake."
#
# @example
#   # bad
#   x += 1 while (x < 10)
#   foo unless (bar || baz)
#
#   if (x > 10)
#   elsif (x < 3)
#   end
#
#   # good
#   x += 1 while x < 10
#   foo unless bar || baz
#
#   if x > 10
#   elsif x < 3
#   end
# @example AllowSafeAssignment: true (default)
#   # good
#   foo unless (bar = baz)
# @example AllowSafeAssignment: false
#   # bad
#   foo unless (bar = baz)
# @example AllowInMultilineConditions: false (default)
#   # bad
#   if (x > 10 &&
#   y > 10)
#   end
#
#   # good
#   if x > 10 &&
#   y > 10
#   end
# @example AllowInMultilineConditions: true
#   # good
#   if (x > 10 &&
#   y > 10)
#   end
class RuboCop::Cop::Style::ParenthesesAroundCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SafeAssignment
  include ::RuboCop::Cop::Parentheses
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def control_op_condition(param0 = T.unsafe(nil)); end
  def on_if(node); end
  def on_until(node); end
  def on_while(node); end

  private

  # @return [Boolean]
  def allow_multiline_conditions?; end

  def message(node); end

  # @return [Boolean]
  def modifier_op?(node); end

  # @return [Boolean]
  def parens_allowed?(node); end

  def process_control_op(node); end

  # @return [Boolean]
  def semicolon_separated_expressions?(first_exp, rest_exps); end
end

# Enforces the consistent usage of `%`-literal delimiters.
#
# Specify the 'default' key to set all preferred delimiters at once. You
# can continue to specify individual preferred delimiters to override the
# default.
#
# @example
#   # Style/PercentLiteralDelimiters:
#   #   PreferredDelimiters:
#   #     default: '[]'
#   #     '%i':    '()'
#
#   # good
#   %w[alpha beta] + %i(gamma delta)
#
#   # bad
#   %W(alpha #{beta})
#
#   # bad
#   %I(alpha beta)
class RuboCop::Cop::Style::PercentLiteralDelimiters < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
  def on_dstr(node); end
  def on_regexp(node); end
  def on_str(node); end
  def on_sym(node); end
  def on_xstr(node); end

  private

  # @return [Boolean]
  def contains_delimiter?(node, delimiters); end

  # @return [Boolean]
  def contains_preferred_delimiter?(node, type); end

  # @return [Boolean]
  def include_same_character_as_used_for_delimiter?(node, type); end

  def matchpairs(begin_delimiter); end
  def message(type); end
  def on_percent_literal(node); end
  def preferred_delimiters_for(type); end
  def string_source(node); end

  # @return [Boolean]
  def uses_preferred_delimiter?(node, type); end
end

# Checks for usage of the %Q() syntax when %q() would do.
#
# @example EnforcedStyle: lower_case_q (default)
#   # The `lower_case_q` style prefers `%q` unless
#   # interpolation is needed.
#   # bad
#   %Q[Mix the foo into the baz.]
#   %Q(They all said: 'Hooray!')
#
#   # good
#   %q[Mix the foo into the baz]
#   %q(They all said: 'Hooray!')
# @example EnforcedStyle: upper_case_q
#   # The `upper_case_q` style requires the sole use of `%Q`.
#   # bad
#   %q/Mix the foo into the baz./
#   %q{They all said: 'Hooray!'}
#
#   # good
#   %Q/Mix the foo into the baz./
#   %Q{They all said: 'Hooray!'}
class RuboCop::Cop::Style::PercentQLiterals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_str(node); end

  private

  # @return [Boolean]
  def correct_literal_style?(node); end

  def corrected(src); end
  def message(_range); end
  def on_percent_literal(node); end
end

RuboCop::Cop::Style::PercentQLiterals::LOWER_CASE_Q_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::PercentQLiterals::UPPER_CASE_Q_MSG = T.let(T.unsafe(nil), String)

# Looks for uses of Perl-style regexp match
# backreferences and their English versions like
# $1, $2, $&, &+, $MATCH, $PREMATCH, etc.
#
# @example
#   # bad
#   puts $1
#
#   # good
#   puts Regexp.last_match(1)
class RuboCop::Cop::Style::PerlBackrefs < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_back_ref(node); end
  def on_gvar(node); end
  def on_nth_ref(node); end

  private

  # @param node [RuboCop::AST::Node]
  # @private
  # @return [Boolean]
  def derived_from_braceless_interpolation?(node); end

  # @param node [RuboCop::AST::Node]
  # @param preferred_expression [String]
  # @private
  # @return [String]
  def format_message(node:, preferred_expression:); end

  # @param node [RuboCop::AST::Node]
  # @private
  def on_back_ref_or_gvar_or_nth_ref(node); end

  # @param node [RuboCop::AST::Node]
  # @private
  # @return [String]
  def original_expression_of(node); end

  # @param node [RuboCop::AST::Node]
  # @private
  # @return [String, nil]
  def preferred_expression_to(node); end
end

RuboCop::Cop::Style::PerlBackrefs::MESSAGE_FORMAT = T.let(T.unsafe(nil), String)

# Checks for uses of methods `Hash#has_key?` and
# `Hash#has_value?`, and suggests using `Hash#key?` and `Hash#value?` instead.
#
# It is configurable to enforce the verbose method names, by using the
# `EnforcedStyle: verbose` configuration.
#
# @example EnforcedStyle: short (default)
#   # bad
#   Hash#has_key?
#   Hash#has_value?
#
#   # good
#   Hash#key?
#   Hash#value?
# @example EnforcedStyle: verbose
#   # bad
#   Hash#key?
#   Hash#value?
#
#   # good
#   Hash#has_key?
#   Hash#has_value?
class RuboCop::Cop::Style::PreferredHashMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  private

  def message(method_name); end

  # @return [Boolean]
  def offending_selector?(method_name); end

  def proper_method_name(method_name); end
end

RuboCop::Cop::Style::PreferredHashMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::PreferredHashMethods::OFFENDING_SELECTORS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::PreferredHashMethods::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of Proc.new where Kernel#proc
# would be more appropriate.
#
# @example
#   # bad
#   p = Proc.new { |n| puts n }
#
#   # good
#   p = proc { |n| puts n }
class RuboCop::Cop::Style::Proc < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def proc_new?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Style::Proc::MSG = T.let(T.unsafe(nil), String)

# Checks if the quotes used for quoted symbols match the configured defaults.
# By default uses the same configuration as `Style/StringLiterals`; if that
# cop is not enabled, the default `EnforcedStyle` is `single_quotes`.
#
# String interpolation is always kept in double quotes.
#
# Note: `Lint/SymbolConversion` can be used in parallel to ensure that symbols
# are not quoted that don't need to be. This cop is for configuring the quoting
# style to use for symbols that require quotes.
#
# @example EnforcedStyle: same_as_string_literals (default) / single_quotes
#   # bad
#   :"abc-def"
#
#   # good
#   :'abc-def'
#   :"#{str}"
#   :"a\'b"
# @example EnforcedStyle: double_quotes
#   # bad
#   :'abc-def'
#
#   # good
#   :"abc-def"
#   :"#{str}"
#   :"a\'b"
class RuboCop::Cop::Style::QuotedSymbols < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::SymbolHelp
  include ::RuboCop::Cop::StringLiteralsHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_sym(node); end

  private

  def alternative_style; end
  def autocorrect(corrector, node); end
  def correct_quotes(str); end

  # @return [Boolean]
  def hash_colon_key?(node); end

  # @return [Boolean]
  def invalid_double_quotes?(source); end

  # @return [Boolean]
  def quoted?(sym_node); end

  def style; end

  # @return [Boolean]
  def wrong_quotes?(node); end
end

RuboCop::Cop::Style::QuotedSymbols::MSG_DOUBLE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::QuotedSymbols::MSG_SINGLE = T.let(T.unsafe(nil), String)

# Checks the args passed to `fail` and `raise`. For exploded
# style (default), it recommends passing the exception class and message
# to `raise`, rather than construct an instance of the error. It will
# still allow passing just a message, or the construction of an error
# with more than one argument.
#
# The exploded style works identically, but with the addition that it
# will also suggest constructing error objects when the exception is
# passed multiple arguments.
#
# The exploded style has an `AllowedCompactTypes` configuration
# option that takes an Array of exception name Strings.
#
# @example EnforcedStyle: exploded (default)
#   # bad
#   raise StandardError.new('message')
#
#   # good
#   raise StandardError, 'message'
#   fail 'message'
#   raise MyCustomError
#   raise MyCustomError.new(arg1, arg2, arg3)
#   raise MyKwArgError.new(key1: val1, key2: val2)
#
#   # With `AllowedCompactTypes` set to ['MyWrappedError']
#   raise MyWrappedError.new(obj)
#   raise MyWrappedError.new(obj), 'message'
# @example EnforcedStyle: compact
#   # bad
#   raise StandardError, 'message'
#   raise RuntimeError, arg1, arg2, arg3
#
#   # good
#   raise StandardError.new('message')
#   raise MyCustomError
#   raise MyCustomError.new(arg1, arg2, arg3)
#   fail 'message'
class RuboCop::Cop::Style::RaiseArgs < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  # @return [Boolean]
  def acceptable_exploded_args?(args); end

  # @return [Boolean]
  def allowed_non_exploded_type?(arg); end

  def check_compact(node); end
  def check_exploded(node); end
  def correction_compact_to_exploded(node); end
  def correction_exploded_to_compact(node); end

  # @return [Boolean]
  def requires_parens?(parent); end

  # @return [Boolean]
  def use_new_method?(first_arg); end
end

RuboCop::Cop::Style::RaiseArgs::COMPACT_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RaiseArgs::EXPLODED_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RaiseArgs::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of randomly generated numbers,
# added/subtracted with integer literals, as well as those with
# Integer#succ and Integer#pred methods. Prefer using ranges instead,
# as it clearly states the intentions.
#
# @example
#   # bad
#   rand(6) + 1
#   1 + rand(6)
#   rand(6) - 1
#   1 - rand(6)
#   rand(6).succ
#   rand(6).pred
#   Random.rand(6) + 1
#   Kernel.rand(6) + 1
#   rand(0..5) + 1
#
#   # good
#   rand(1..6)
#   rand(1...7)
class RuboCop::Cop::Style::RandomWithOffset < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def integer_op_rand?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def rand_modified?(param0 = T.unsafe(nil)); end
  def rand_op_integer?(param0 = T.unsafe(nil)); end
  def random_call(param0 = T.unsafe(nil)); end
  def to_int(param0 = T.unsafe(nil)); end

  private

  def autocorrect(corrector, node); end
  def boundaries_from_random_node(random_node); end
  def corrected_integer_op_rand(node); end
  def corrected_rand_modified(node); end
  def corrected_rand_op_integer(node); end
  def prefix_from_prefix_node(node); end
end

RuboCop::Cop::Style::RandomWithOffset::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RandomWithOffset::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for a redundant argument passed to certain methods.
#
# NOTE: This cop is limited to methods with single parameter.
#
# Method names and their redundant arguments can be configured like this:
#
# [source,yaml]
# ----
# Methods:
#   join: ''
#   split: ' '
#   chomp: "\n"
#   chomp!: "\n"
#   foo: 2
# ----
#
# @example
#   # bad
#   array.join('')
#   [1, 2, 3].join("")
#   string.split(" ")
#   "first\nsecond".split(" ")
#   string.chomp("\n")
#   string.chomp!("\n")
#   A.foo(2)
#
#   # good
#   array.join
#   [1, 2, 3].join
#   string.split
#   "first second".split
#   string.chomp
#   string.chomp!
#   A.foo
class RuboCop::Cop::Style::RedundantArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def argument_range(node); end
  def redundant_arg_for_method(method_name); end

  # @return [Boolean]
  def redundant_argument?(node); end
end

RuboCop::Cop::Style::RedundantArgument::MSG = T.let(T.unsafe(nil), String)

# Checks for redundant assignment before returning.
#
# @example
#   # bad
#   def test
#   x = foo
#   x
#   end
#
#   # bad
#   def test
#   if x
#   z = foo
#   z
#   elsif y
#   z = bar
#   z
#   end
#   end
#
#   # good
#   def test
#   foo
#   end
#
#   # good
#   def test
#   if x
#   foo
#   elsif y
#   bar
#   end
#   end
class RuboCop::Cop::Style::RedundantAssignment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
  def redundant_assignment?(param0 = T.unsafe(nil)); end

  private

  def check_begin_node(node); end
  def check_branch(node); end
  def check_case_node(node); end
  def check_ensure_node(node); end
  def check_if_node(node); end
  def check_rescue_node(node); end
end

RuboCop::Cop::Style::RedundantAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for redundant `begin` blocks.
#
# Currently it checks for code like this:
#
# @example
#
#   # bad
#   def redundant
#   begin
#   ala
#   bala
#   rescue StandardError => e
#   something
#   end
#   end
#
#   # good
#   def preferred
#   ala
#   bala
#   rescue StandardError => e
#   something
#   end
#
#   # bad
#   begin
#   do_something
#   end
#
#   # good
#   do_something
#
#   # bad
#   # When using Ruby 2.5 or later.
#   do_something do
#   begin
#   something
#   rescue => ex
#   anything
#   end
#   end
#
#   # good
#   # In Ruby 2.5 or later, you can omit `begin` in `do-end` block.
#   do_something do
#   something
#   rescue => ex
#   anything
#   end
#
#   # good
#   # Stabby lambdas don't support implicit `begin` in `do-end` blocks.
#   -> do
#   begin
#   foo
#   rescue Bar
#   baz
#   end
#   end
class RuboCop::Cop::Style::RedundantBegin < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def offensive_kwbegins(param0); end
  def on_block(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_kwbegin(node); end
  def on_numblock(node); end

  private

  # @return [Boolean]
  def allowable_kwbegin?(node); end

  # @return [Boolean]
  def begin_block_has_multiline_statements?(node); end

  def condition_range(node); end

  # @return [Boolean]
  def contain_rescue_or_ensure?(node); end

  def correct_modifier_form_after_multiline_begin_block(corrector, node); end

  # @return [Boolean]
  def empty_begin?(node); end

  def register_offense(node); end
  def replace_begin_with_statement(corrector, offense_range, node); end

  # Restore comments that occur between "begin" and "first_child".
  # These comments will be moved to above the assignment line.
  def restore_removed_comments(corrector, offense_range, node, first_child); end

  # @return [Boolean]
  def use_modifier_form_after_multiline_begin_block?(node); end

  # @return [Boolean]
  def valid_begin_assignment?(node); end

  # @return [Boolean]
  def valid_context_using_only_begin?(node); end
end

RuboCop::Cop::Style::RedundantBegin::MSG = T.let(T.unsafe(nil), String)

# Checks for usage of the %W() syntax when %w() would do.
#
# @example
#   # bad
#   %W(cat dog pig)
#   %W[door wall floor]
#
#   # good
#   %w/swim run bike/
#   %w[shirt pants shoes]
#   %W(apple #{fruit} grape)
class RuboCop::Cop::Style::RedundantCapitalW < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end

  private

  def on_percent_literal(node); end

  # @return [Boolean]
  def requires_interpolation?(node); end
end

RuboCop::Cop::Style::RedundantCapitalW::MSG = T.let(T.unsafe(nil), String)

# Checks for unnecessary conditional expressions.
#
# @example
#   # bad
#   a = b ? b : c
#
#   # good
#   a = b || c
# @example
#   # bad
#   if b
#   b
#   else
#   c
#   end
#
#   # good
#   b || c
#
#   # good
#   if b
#   b
#   elsif cond
#   c
#   end
class RuboCop::Cop::Style::RedundantCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def asgn_type?(node); end

  # @return [Boolean]
  def branches_have_assignment?(node); end

  # @return [Boolean]
  def branches_have_method?(node); end

  def correct_ternary(corrector, node); end
  def else_source(else_branch, arithmetic_operation); end
  def else_source_if_has_assignment(else_branch); end
  def else_source_if_has_method(else_branch); end
  def if_source(if_branch, arithmetic_operation); end
  def make_ternary_form(node); end
  def message(node); end

  # @return [Boolean]
  def offense?(node); end

  def range_of_offense(node); end

  # @return [Boolean]
  def redundant_condition?(node); end

  # @return [Boolean]
  def require_braces?(node); end

  # @return [Boolean]
  def require_parentheses?(node); end

  # @return [Boolean]
  def same_method?(if_branch, else_branch); end

  # @return [Boolean]
  def synonymous_condition_and_branch?(node); end

  # @return [Boolean]
  def use_arithmetic_operation?(node); end

  # @return [Boolean]
  def use_hash_key_access?(node); end

  # @return [Boolean]
  def use_hash_key_assignment?(else_branch); end

  # @return [Boolean]
  def use_if_branch?(else_branch); end

  # @return [Boolean]
  def without_argument_parentheses_method?(node); end
end

RuboCop::Cop::Style::RedundantCondition::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantCondition::REDUNDANT_CONDITION = T.let(T.unsafe(nil), String)

# Checks for redundant returning of true/false in conditionals.
#
# @example
#   # bad
#   x == y ? true : false
#
#   # bad
#   if x == y
#   true
#   else
#   false
#   end
#
#   # good
#   x == y
#
#   # bad
#   x == y ? false : true
#
#   # good
#   x != y
class RuboCop::Cop::Style::RedundantConditional < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
  def redundant_condition?(param0 = T.unsafe(nil)); end
  def redundant_condition_inverted?(param0 = T.unsafe(nil)); end

  private

  def configured_indentation_width; end
  def indented_else_node(expression, node); end

  # @return [Boolean]
  def invert_expression?(node); end

  def message(node); end

  # @return [Boolean]
  def offense?(node); end

  def replacement_condition(node); end
end

RuboCop::Cop::Style::RedundantConditional::COMPARISON_OPERATOR_MATCHER = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantConditional::MSG = T.let(T.unsafe(nil), String)

# Checks for RuntimeError as the argument of raise/fail.
#
# It checks for code like this:
#
# @example
#   # Bad
#   raise RuntimeError, 'message'
#
#   # Bad
#   raise RuntimeError.new('message')
#
#   # Good
#   raise 'message'
class RuboCop::Cop::Style::RedundantException < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def compact?(param0 = T.unsafe(nil)); end
  def exploded?(param0 = T.unsafe(nil)); end
  def fix_compact(node); end
  def fix_exploded(node); end

  # Switch `raise RuntimeError, 'message'` to `raise 'message'`, and
  # `raise RuntimeError.new('message')` to `raise 'message'`.
  def on_send(node); end
end

RuboCop::Cop::Style::RedundantException::MSG_1 = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantException::MSG_2 = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `fetch(key) { value }`
# can be replaced by `fetch(key, value)`.
#
# In such cases `fetch(key, value)` method is faster
# than `fetch(key) { value }`.
#
# @example SafeForConstants: false (default)
#   # bad
#   hash.fetch(:key) { 5 }
#   hash.fetch(:key) { true }
#   hash.fetch(:key) { nil }
#   array.fetch(5) { :value }
#   ENV.fetch(:key) { 'value' }
#
#   # good
#   hash.fetch(:key, 5)
#   hash.fetch(:key, true)
#   hash.fetch(:key, nil)
#   array.fetch(5, :value)
#   ENV.fetch(:key, 'value')
# @example SafeForConstants: true
#   # bad
#   ENV.fetch(:key) { VALUE }
#
#   # good
#   ENV.fetch(:key, VALUE)
class RuboCop::Cop::Style::RedundantFetchBlock < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def rails_cache?(param0 = T.unsafe(nil)); end
  def redundant_fetch_block_candidate?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def basic_literal?(node); end

  def build_bad_method(send, body); end
  def build_good_method(send, body); end

  # @return [Boolean]
  def check_for_constant?; end

  # @return [Boolean]
  def check_for_string?; end

  # @return [Boolean]
  def const_type?(node); end

  def fetch_range(send, node); end

  # @return [Boolean]
  def should_not_check?(send, body); end
end

RuboCop::Cop::Style::RedundantFetchBlock::MSG = T.let(T.unsafe(nil), String)

# Checks for the presence of superfluous `.rb` extension in
# the filename provided to `require` and `require_relative`.
#
# Note: If the extension is omitted, Ruby tries adding '.rb', '.so',
#       and so on to the name until found. If the file named cannot be found,
#       a `LoadError` will be raised.
#       There is an edge case where `foo.so` file is loaded instead of a `LoadError`
#       if `foo.so` file exists when `require 'foo.rb'` will be changed to `require 'foo'`,
#       but that seems harmless.
#
# @example
#   # bad
#   require 'foo.rb'
#   require_relative '../foo.rb'
#
#   # good
#   require 'foo'
#   require 'foo.so'
#   require_relative '../foo'
#   require_relative '../foo.so'
class RuboCop::Cop::Style::RedundantFileExtensionInRequire < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def require_call?(param0 = T.unsafe(nil)); end

  private

  def extension_range(name_node); end
end

RuboCop::Cop::Style::RedundantFileExtensionInRequire::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantFileExtensionInRequire::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Check for uses of `Object#freeze` on immutable objects.
#
# NOTE: Regexp and Range literals are frozen objects since Ruby 3.0.
#
# NOTE: From Ruby 3.0, this cop allows explicit freezing of interpolated
# string literals when `# frozen-string-literal: true` is used.
#
# @example
#   # bad
#   CONST = 1.freeze
#
#   # good
#   CONST = 1
class RuboCop::Cop::Style::RedundantFreeze < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::FrozenStringLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def operation_produces_immutable_object?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def immutable_literal?(node); end

  def strip_parenthesis(node); end
end

RuboCop::Cop::Style::RedundantFreeze::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantFreeze::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for `initialize` methods that are redundant.
#
# An initializer is redundant if it does not do anything, or if it only
# calls `super` with the same arguments given to it. If the initializer takes
# an argument that accepts multiple values (`restarg`, `kwrestarg`, etc.) it
# will not register an offense, because it allows the initializer to take a different
# number of arguments as its superclass potentially does.
#
# NOTE: If an initializer argument has a default value, RuboCop assumes it
# to *not* be redundant.
#
# NOTE: Empty initializers are registered as offenses, but it is possible
# to purposely create an empty `initialize` method to override a superclass's
# initializer.
#
# @example
#   # bad
#   def initialize
#   end
#
#   # bad
#   def initialize
#   super
#   end
#
#   # bad
#   def initialize(a, b)
#   super
#   end
#
#   # bad
#   def initialize(a, b)
#   super(a, b)
#   end
#
#   # good
#   def initialize
#   do_something
#   end
#
#   # good
#   def initialize
#   do_something
#   super
#   end
#
#   # good (different number of parameters)
#   def initialize(a, b)
#   super(a)
#   end
#
#   # good (default value)
#   def initialize(a, b = 5)
#   super
#   end
#
#   # good (default value)
#   def initialize(a, b: 5)
#   super
#   end
#
#   # good (changes the parameter requirements)
#   def initialize(*)
#   end
#
#   # good (changes the parameter requirements)
#   def initialize(**)
#   end
#
#   # good (changes the parameter requirements)
#   def initialize(...)
#   end
# @example AllowComments: true (default)
#
#   # good
#   def initialize
#   # Overriding to negate superclass `initialize` method.
#   end
# @example AllowComments: false
#
#   # bad
#   def initialize
#   # Overriding to negate superclass `initialize` method.
#   end
class RuboCop::Cop::Style::RedundantInitialize < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def initialize_forwards?(param0 = T.unsafe(nil)); end
  def on_def(node); end

  private

  # @return [Boolean]
  def acceptable?(node); end

  # @return [Boolean]
  def allow_comments?(node); end

  # @return [Boolean]
  def forwards?(node); end

  def register_offense(node, message); end

  # @return [Boolean]
  def same_args?(super_node, args); end
end

RuboCop::Cop::Style::RedundantInitialize::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantInitialize::MSG_EMPTY = T.let(T.unsafe(nil), String)

# Checks for strings that are just an interpolated expression.
#
# @example
#
#   # bad
#   "#{@var}"
#
#   # good
#   @var.to_s
#
#   # good if @var is already a String
#   @var
class RuboCop::Cop::Style::RedundantInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::PercentLiteral
  extend ::RuboCop::Cop::AutoCorrector

  def on_dstr(node); end

  private

  def autocorrect_other(corrector, embedded_node, node); end
  def autocorrect_single_variable_interpolation(corrector, embedded_node, node); end
  def autocorrect_variable_interpolation(corrector, embedded_node, node); end

  # @return [Boolean]
  def embedded_in_percent_array?(node); end

  # @return [Boolean]
  def implicit_concatenation?(node); end

  # @return [Boolean]
  def interpolation?(node); end

  # @return [Boolean]
  def require_parentheses?(node); end

  # @return [Boolean]
  def single_interpolation?(node); end

  # @return [Boolean]
  def single_variable_interpolation?(node); end

  # @return [Boolean]
  def variable_interpolation?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::RedundantInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for redundant parentheses.
#
# @example
#
#   # bad
#   (x) if ((y.z).nil?)
#
#   # good
#   x if y.z.nil?
class RuboCop::Cop::Style::RedundantParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Parentheses
  extend ::RuboCop::Cop::AutoCorrector

  def arg_in_call_with_block?(param0 = T.unsafe(nil)); end
  def first_send_argument?(param0 = T.unsafe(nil)); end
  def first_super_argument?(param0 = T.unsafe(nil)); end
  def first_yield_argument?(param0 = T.unsafe(nil)); end
  def interpolation?(param0 = T.unsafe(nil)); end
  def method_node_and_args(param0 = T.unsafe(nil)); end
  def on_begin(node); end
  def range_end?(param0 = T.unsafe(nil)); end
  def rescue?(param0 = T.unsafe(nil)); end
  def square_brackets?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def allowed_ancestor?(node); end

  # @return [Boolean]
  def allowed_expression?(node); end

  # @return [Boolean]
  def allowed_method_call?(node); end

  # @return [Boolean]
  def allowed_multiple_expression?(node); end

  # @return [Boolean]
  def allowed_ternary?(node); end

  # @return [Boolean]
  def call_chain_starts_with_int?(begin_node, send_node); end

  def check(begin_node); end
  def check_send(begin_node, node); end
  def check_unary(begin_node, node); end

  # @return [Boolean]
  def disallowed_literal?(begin_node, node); end

  # @return [Boolean]
  def empty_parentheses?(node); end

  # @return [Boolean]
  def first_arg_begins_with_hash_literal?(node); end

  # @return [Boolean]
  def first_argument?(node); end

  # @return [Boolean]
  def ignore_syntax?(node); end

  # @return [Boolean]
  def keyword_ancestor?(node); end

  # @return [Boolean]
  def keyword_with_redundant_parentheses?(node); end

  # @return [Boolean]
  def like_method_argument_parentheses?(node); end

  # @return [Boolean]
  def method_call_with_redundant_parentheses?(node); end

  # @return [Boolean]
  def method_chain_begins_with_hash_literal?(node); end

  def offense(node, msg); end

  # @return [Boolean]
  def only_begin_arg?(args); end

  # @return [Boolean]
  def parens_allowed?(node); end

  # @return [Boolean]
  def raised_to_power_negative_numeric?(begin_node, node); end

  # @return [Boolean]
  def suspect_unary?(node); end

  # @return [Boolean]
  def ternary_parentheses_required?; end
end

# Checks for usage of the %q/%Q syntax when '' or "" would do.
#
# @example
#
#   # bad
#   name = %q(Bruce Wayne)
#   time = %q(8 o'clock)
#   question = %q("What did you say?")
#
#   # good
#   name = 'Bruce Wayne'
#   time = "8 o'clock"
#   question = '"What did you say?"'
class RuboCop::Cop::Style::RedundantPercentQ < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_dstr(node); end
  def on_str(node); end

  private

  # @return [Boolean]
  def acceptable_capital_q?(node); end

  # @return [Boolean]
  def acceptable_q?(node); end

  # @return [Boolean]
  def allowed_percent_q?(node); end

  def check(node); end

  # @return [Boolean]
  def interpolated_quotes?(node); end

  def message(node); end

  # @return [Boolean]
  def start_with_percent_q_variant?(string); end

  # @return [Boolean]
  def string_literal?(node); end
end

RuboCop::Cop::Style::RedundantPercentQ::DYNAMIC_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::EMPTY = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::ESCAPED_NON_BACKSLASH = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Style::RedundantPercentQ::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::PERCENT_CAPITAL_Q = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::PERCENT_Q = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::QUOTE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::SINGLE_QUOTE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantPercentQ::STRING_INTERPOLATION_REGEXP = T.let(T.unsafe(nil), Regexp)

# Checks for unnecessary single-element Regexp character classes.
#
# @example
#
#   # bad
#   r = /[x]/
#
#   # good
#   r = /x/
#
#   # bad
#   r = /[\s]/
#
#   # good
#   r = /\s/
#
#   # bad
#   r = %r{/[b]}
#
#   # good
#   r = %r{/b}
#
#   # good
#   r = /[ab]/
class RuboCop::Cop::Style::RedundantRegexpCharacterClass < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_regexp(node); end

  private

  # @return [Boolean]
  def backslash_b?(elem); end

  def each_redundant_character_class(node); end
  def each_single_element_character_class(node); end

  # @return [Boolean]
  def multiple_codepoins?(expression); end

  # @return [Boolean]
  def redundant_single_element_character_class?(node, char_class); end

  # @return [Boolean]
  def requires_escape_outside_char_class?(elem); end

  # @return [Boolean]
  def whitespace_in_free_space_mode?(node, elem); end

  def without_character_class(loc); end
end

RuboCop::Cop::Style::RedundantRegexpCharacterClass::MSG_REDUNDANT_CHARACTER_CLASS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantRegexpCharacterClass::REQUIRES_ESCAPE_OUTSIDE_CHAR_CLASS_CHARS = T.let(T.unsafe(nil), Array)

# Checks for redundant escapes inside Regexp literals.
#
# @example
#   # bad
#   %r{foo\/bar}
#
#   # good
#   %r{foo/bar}
#
#   # good
#   /foo\/bar/
#
#   # good
#   %r/foo\/bar/
#
#   # good
#   %r!foo\!bar!
#
#   # bad
#   /a\-b/
#
#   # good
#   /a-b/
#
#   # bad
#   /[\+\-]\d/
#
#   # good
#   /[+\-]\d/
class RuboCop::Cop::Style::RedundantRegexpEscape < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_regexp(node); end

  private

  # @return [Boolean]
  def allowed_escape?(node, char, within_character_class); end

  # @return [Boolean]
  def delimiter?(node, char); end

  # Please remove this `else` branch when support for regexp_parser 1.8 will be dropped.
  # It's for compatibility with regexp_arser 1.8 and will never be maintained.
  def each_escape(node); end

  def escape_range_at_index(node, index); end
end

RuboCop::Cop::Style::RedundantRegexpEscape::ALLOWED_ALWAYS_ESCAPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::RedundantRegexpEscape::ALLOWED_OUTSIDE_CHAR_CLASS_METACHAR_ESCAPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::RedundantRegexpEscape::ALLOWED_WITHIN_CHAR_CLASS_METACHAR_ESCAPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::RedundantRegexpEscape::MSG_REDUNDANT_ESCAPE = T.let(T.unsafe(nil), String)

# Checks for redundant `return` expressions.
#
# @example
#   # These bad cases should be extended to handle methods whose body is
#   # if/else or a case expression with a default branch.
#
#   # bad
#   def test
#   return something
#   end
#
#   # bad
#   def test
#   one
#   two
#   three
#   return something
#   end
#
#   # good
#   def test
#   return something if something_else
#   end
#
#   # good
#   def test
#   if x
#   elsif y
#   else
#   end
#   end
# @example AllowMultipleReturnValues: false (default)
#   # bad
#   def test
#   return x, y
#   end
# @example AllowMultipleReturnValues: true
#   # good
#   def test
#   return x, y
#   end
class RuboCop::Cop::Style::RedundantReturn < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  def add_braces(corrector, node); end
  def add_brackets(corrector, node); end

  # @return [Boolean]
  def allow_multiple_return_values?; end

  def check_begin_node(node); end
  def check_branch(node); end
  def check_case_node(node); end
  def check_ensure_node(node); end
  def check_if_node(node); end
  def check_resbody_node(node); end
  def check_rescue_node(node); end
  def check_return_node(node); end
  def correct_with_arguments(return_node, corrector); end
  def correct_without_arguments(return_node, corrector); end

  # @return [Boolean]
  def hash_without_braces?(node); end

  def message(node); end
end

RuboCop::Cop::Style::RedundantReturn::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantReturn::MULTI_RETURN_MSG = T.let(T.unsafe(nil), String)

# Checks for redundant uses of `self`.
#
# The usage of `self` is only needed when:
#
# * Sending a message to same object with zero arguments in
#   presence of a method name clash with an argument or a local
#   variable.
#
# * Calling an attribute writer to prevent a local variable assignment.
#
# Note, with using explicit self you can only send messages with public or
# protected scope, you cannot send private messages this way.
#
# Note we allow uses of `self` with operators because it would be awkward
# otherwise.
#
# @example
#
#   # bad
#   def foo(bar)
#   self.baz
#   end
#
#   # good
#   def foo(bar)
#   self.bar  # Resolves name clash with the argument.
#   end
#
#   def foo
#   bar = 1
#   self.bar  # Resolves name clash with the local variable.
#   end
#
#   def foo
#   %w[x y z].select do |bar|
#   self.bar == bar  # Resolves name clash with argument of the block.
#   end
#   end
class RuboCop::Cop::Style::RedundantSelf < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # @return [RedundantSelf] a new instance of RedundantSelf
  def initialize(config = T.unsafe(nil), options = T.unsafe(nil)); end

  # Assignment of self.x
  def on_and_asgn(node); end

  def on_args(node); end
  def on_block(node); end
  def on_blockarg(node); end

  # Using self.x to distinguish from local variable x
  def on_def(node); end

  # Using self.x to distinguish from local variable x
  def on_defs(node); end

  def on_if(node); end
  def on_in_pattern(node); end
  def on_lvasgn(node); end
  def on_masgn(node); end
  def on_numblock(node); end
  def on_op_asgn(node); end

  # Assignment of self.x
  def on_or_asgn(node); end

  def on_send(node); end
  def on_until(node); end
  def on_while(node); end

  private

  def add_lhs_to_local_variables_scopes(rhs, lhs); end
  def add_masgn_lhs_variables(rhs, lhs); end
  def add_match_var_scopes(in_pattern_node); end
  def add_scope(node, local_variables = T.unsafe(nil)); end
  def allow_self(node); end

  # @return [Boolean]
  def allowed_send_node?(node); end

  def on_argument(node); end

  # @return [Boolean]
  def regular_method_call?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::RedundantSelf::KERNEL_METHODS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::RedundantSelf::KEYWORDS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::RedundantSelf::MSG = T.let(T.unsafe(nil), String)

# Checks for places where redundant assignments are made for in place
# modification methods.
#
# @example
#   # bad
#   args = args.concat(ary)
#   hash = hash.merge!(other)
#
#   # good
#   args.concat(foo)
#   args += foo
#   hash.merge!(other)
#
#   # bad
#   self.foo = foo.concat(ary)
#
#   # good
#   foo.concat(ary)
#   self.foo += ary
class RuboCop::Cop::Style::RedundantSelfAssignment < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end
  def on_send(node); end
  def redundant_nonself_assignment?(param0 = T.unsafe(nil), param1, param2); end
  def redundant_self_assignment?(param0 = T.unsafe(nil), param1); end

  private

  def correction_range(node); end

  # @return [Boolean]
  def method_returning_self?(method_name); end

  # @return [Boolean]
  def redundant_assignment?(node); end
end

RuboCop::Cop::Style::RedundantSelfAssignment::ASSIGNMENT_TYPE_TO_RECEIVER_TYPE = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::RedundantSelfAssignment::METHODS_RETURNING_SELF = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Style::RedundantSelfAssignment::MSG = T.let(T.unsafe(nil), String)

# Checks for places where conditional branch makes redundant self-assignment.
#
# It only detects local variable because it may replace state of instance variable,
# class variable, and global variable that have state across methods with `nil`.
#
# @example
#
#   # bad
#   foo = condition ? bar : foo
#
#   # good
#   foo = bar if condition
#
#   # bad
#   foo = condition ? foo : bar
#
#   # good
#   foo = bar unless condition
class RuboCop::Cop::Style::RedundantSelfAssignmentBranch < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def bad_method?(param0 = T.unsafe(nil)); end
  def on_lvasgn(node); end

  private

  # @return [Boolean]
  def inconvertible_to_modifier?(if_branch, else_branch); end

  # @return [Boolean]
  def multiple_statements?(branch); end

  def register_offense(if_node, offense_branch, opposite_branch, keyword); end

  # @return [Boolean]
  def self_assign?(variable, branch); end

  # @return [Boolean]
  def use_if_and_else_branch?(expression); end
end

RuboCop::Cop::Style::RedundantSelfAssignmentBranch::MSG = T.let(T.unsafe(nil), String)

# Identifies instances of sorting and then
# taking only the first or last element. The same behavior can
# be accomplished without a relatively expensive sort by using
# `Enumerable#min` instead of sorting and taking the first
# element and `Enumerable#max` instead of sorting and taking the
# last element. Similarly, `Enumerable#min_by` and
# `Enumerable#max_by` can replace `Enumerable#sort_by` calls
# after which only the first or last element is used.
#
# @example
#   # bad
#   [2, 1, 3].sort.first
#   [2, 1, 3].sort[0]
#   [2, 1, 3].sort.at(0)
#   [2, 1, 3].sort.slice(0)
#
#   # good
#   [2, 1, 3].min
#
#   # bad
#   [2, 1, 3].sort.last
#   [2, 1, 3].sort[-1]
#   [2, 1, 3].sort.at(-1)
#   [2, 1, 3].sort.slice(-1)
#
#   # good
#   [2, 1, 3].max
#
#   # bad
#   arr.sort_by(&:foo).first
#   arr.sort_by(&:foo)[0]
#   arr.sort_by(&:foo).at(0)
#   arr.sort_by(&:foo).slice(0)
#
#   # good
#   arr.min_by(&:foo)
#
#   # bad
#   arr.sort_by(&:foo).last
#   arr.sort_by(&:foo)[-1]
#   arr.sort_by(&:foo).at(-1)
#   arr.sort_by(&:foo).slice(-1)
#
#   # good
#   arr.max_by(&:foo)
class RuboCop::Cop::Style::RedundantSort < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def redundant_sort?(param0 = T.unsafe(nil)); end

  private

  # This gets the start of the accessor whether it has a dot
  # (e.g. `.first`) or doesn't (e.g. `[0]`)
  def accessor_start(node); end

  def arg_node(node); end
  def arg_value(node); end
  def autocorrect(corrector, node, sort_node, sorter, accessor); end
  def base(accessor, arg); end
  def find_redundant_sort(*nodes); end
  def message(node, sorter, accessor); end
  def offense_range(sort_node, node); end
  def register_offense(node, sort_node, sorter, accessor); end
  def replace_with_logical_operator(corrector, node); end
  def suffix(sorter); end
  def suggestion(sorter, accessor, arg); end

  # @return [Boolean]
  def with_logical_operator?(node); end
end

RuboCop::Cop::Style::RedundantSort::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantSort::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Identifies places where `sort_by { ... }` can be replaced by
# `sort`.
#
# @example
#   # bad
#   array.sort_by { |x| x }
#   array.sort_by do |var|
#   var
#   end
#
#   # good
#   array.sort
class RuboCop::Cop::Style::RedundantSortBy < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end
  def on_numblock(node); end
  def redundant_sort_by_block(param0 = T.unsafe(nil)); end
  def redundant_sort_by_numblock(param0 = T.unsafe(nil)); end

  private

  def sort_by_range(send, node); end
end

RuboCop::Cop::Style::RedundantSortBy::MSG_BLOCK = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RedundantSortBy::MSG_NUMBLOCK = T.let(T.unsafe(nil), String)

# Enforces using // or %r around regular expressions.
#
# @example EnforcedStyle: slashes (default)
#   # bad
#   snake_case = %r{^[\dA-Z_]+$}
#
#   # bad
#   regex = %r{
#   foo
#   (bar)
#   (baz)
#   }x
#
#   # good
#   snake_case = /^[\dA-Z_]+$/
#
#   # good
#   regex = /
#   foo
#   (bar)
#   (baz)
#   /x
# @example EnforcedStyle: percent_r
#   # bad
#   snake_case = /^[\dA-Z_]+$/
#
#   # bad
#   regex = /
#   foo
#   (bar)
#   (baz)
#   /x
#
#   # good
#   snake_case = %r{^[\dA-Z_]+$}
#
#   # good
#   regex = %r{
#   foo
#   (bar)
#   (baz)
#   }x
# @example EnforcedStyle: mixed
#   # bad
#   snake_case = %r{^[\dA-Z_]+$}
#
#   # bad
#   regex = /
#   foo
#   (bar)
#   (baz)
#   /x
#
#   # good
#   snake_case = /^[\dA-Z_]+$/
#
#   # good
#   regex = %r{
#   foo
#   (bar)
#   (baz)
#   }x
# @example AllowInnerSlashes: false (default)
#   # If `false`, the cop will always recommend using `%r` if one or more
#   # slashes are found in the regexp string.
#
#   # bad
#   x =~ /home\//
#
#   # good
#   x =~ %r{home/}
# @example AllowInnerSlashes: true
#   # good
#   x =~ /home\//
class RuboCop::Cop::Style::RegexpLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_regexp(node); end

  private

  # @return [Boolean]
  def allow_inner_slashes?; end

  # @return [Boolean]
  def allowed_mixed_percent_r?(node); end

  # @return [Boolean]
  def allowed_mixed_slash?(node); end

  # @return [Boolean]
  def allowed_omit_parentheses_with_percent_r_literal?(node); end

  # @return [Boolean]
  def allowed_percent_r_literal?(node); end

  # @return [Boolean]
  def allowed_slash_literal?(node); end

  def calculate_replacement(node); end

  # @return [Boolean]
  def contains_disallowed_slash?(node); end

  # @return [Boolean]
  def contains_slash?(node); end

  def correct_delimiters(node, corrector); end
  def correct_inner_slashes(node, corrector); end
  def inner_slash_after_correction(node); end
  def inner_slash_before_correction(node); end
  def inner_slash_for(opening_delimiter); end
  def inner_slash_indices(node); end
  def node_body(node, include_begin_nodes: T.unsafe(nil)); end
  def preferred_delimiters; end

  # @return [Boolean]
  def slash_literal?(node); end
end

RuboCop::Cop::Style::RegexpLiteral::MSG_USE_PERCENT_R = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RegexpLiteral::MSG_USE_SLASHES = T.let(T.unsafe(nil), String)

# Checks for uses of rescue in its modifier form.
#
# The cop to check `rescue` in its modifier form is added for following
# reasons:
#
# * The syntax of modifier form `rescue` can be misleading because it
#   might led us to believe that `rescue` handles the given exception
#   but it actually rescue all exceptions to return the given rescue
#   block. In this case, value returned by handle_error or
#   SomeException.
#
# * Modifier form `rescue` would rescue all the exceptions. It would
#   silently skip all exception or errors and handle the error.
#   Example: If `NoMethodError` is raised, modifier form rescue would
#   handle the exception.
#
# @example
#   # bad
#   some_method rescue handle_error
#
#   # bad
#   some_method rescue SomeException
#
#   # good
#   begin
#   some_method
#   rescue
#   handle_error
#   end
#
#   # good
#   begin
#   some_method
#   rescue SomeException
#   handle_error
#   end
class RuboCop::Cop::Style::RescueModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::RescueNode
  extend ::RuboCop::Cop::AutoCorrector

  def on_resbody(node); end

  private

  def correct_rescue_block(corrector, node, parenthesized); end
  def indentation_and_offset(node, parenthesized); end

  # @return [Boolean]
  def parenthesized?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::RescueModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for rescuing `StandardError`. There are two supported
# styles `implicit` and `explicit`. This cop will not register an offense
# if any error other than `StandardError` is specified.
#
# @example EnforcedStyle: explicit (default)
#   # `explicit` will enforce using `rescue StandardError`
#   # instead of `rescue`.
#
#   # bad
#   begin
#   foo
#   rescue
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue StandardError
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue OtherError
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue StandardError, SecurityError
#   bar
#   end
# @example EnforcedStyle: implicit
#   # `implicit` will enforce using `rescue` instead of
#   # `rescue StandardError`.
#
#   # bad
#   begin
#   foo
#   rescue StandardError
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue OtherError
#   bar
#   end
#
#   # good
#   begin
#   foo
#   rescue StandardError, SecurityError
#   bar
#   end
class RuboCop::Cop::Style::RescueStandardError < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RescueNode
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_resbody(node); end
  def rescue_standard_error?(param0 = T.unsafe(nil)); end
  def rescue_without_error_class?(param0 = T.unsafe(nil)); end

  private

  def offense_for_explicit_enforced_style(node); end
  def offense_for_implicit_enforced_style(node, error); end
end

RuboCop::Cop::Style::RescueStandardError::MSG_EXPLICIT = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::RescueStandardError::MSG_IMPLICIT = T.let(T.unsafe(nil), String)

# Enforces consistency between 'return nil' and 'return'.
#
# Supported styles are: return, return_nil.
#
# @example EnforcedStyle: return (default)
#   # bad
#   def foo(arg)
#   return nil if arg
#   end
#
#   # good
#   def foo(arg)
#   return if arg
#   end
# @example EnforcedStyle: return_nil
#   # bad
#   def foo(arg)
#   return if arg
#   end
#
#   # good
#   def foo(arg)
#   return nil if arg
#   end
class RuboCop::Cop::Style::ReturnNil < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def chained_send?(param0 = T.unsafe(nil)); end
  def define_method?(param0 = T.unsafe(nil)); end
  def on_return(node); end
  def return_nil_node?(param0 = T.unsafe(nil)); end
  def return_node?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def correct_style?(node); end

  def message(_node); end

  # @return [Boolean]
  def scoped_node?(node); end
end

RuboCop::Cop::Style::ReturnNil::RETURN_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ReturnNil::RETURN_NIL_MSG = T.let(T.unsafe(nil), String)

# Transforms usages of a method call safeguarded by a non `nil`
# check for the variable whose method is being called to
# safe navigation (`&.`). If there is a method chain, all of the methods
# in the chain need to be checked for safety, and all of the methods will
# need to be changed to use safe navigation.
#
# The default for `ConvertCodeThatCanStartToReturnNil` is `false`.
# When configured to `true`, this will
# check for code in the format `!foo.nil? && foo.bar`. As it is written,
# the return of this code is limited to `false` and whatever the return
# of the method is. If this is converted to safe navigation,
# `foo&.bar` can start returning `nil` as well as what the method
# returns.
#
# The default for `MaxChainLength` is `2`
# We have limited the cop to not register an offense for method chains
# that exceed this option is set.
#
# @example
#   # bad
#   foo.bar if foo
#   foo.bar.baz if foo
#   foo.bar(param1, param2) if foo
#   foo.bar { |e| e.something } if foo
#   foo.bar(param) { |e| e.something } if foo
#
#   foo.bar if !foo.nil?
#   foo.bar unless !foo
#   foo.bar unless foo.nil?
#
#   foo && foo.bar
#   foo && foo.bar.baz
#   foo && foo.bar(param1, param2)
#   foo && foo.bar { |e| e.something }
#   foo && foo.bar(param) { |e| e.something }
#
#   # good
#   foo&.bar
#   foo&.bar&.baz
#   foo&.bar(param1, param2)
#   foo&.bar { |e| e.something }
#   foo&.bar(param) { |e| e.something }
#   foo && foo.bar.baz.qux # method chain with more than 2 methods
#   foo && foo.nil? # method that `nil` responds to
#
#   # Method calls that do not use `.`
#   foo && foo < bar
#   foo < bar if foo
#
#   # When checking `foo&.empty?` in a conditional, `foo` being `nil` will actually
#   # do the opposite of what the author intends.
#   foo && foo.empty?
#
#   # This could start returning `nil` as well as the return of the method
#   foo.nil? || foo.bar
#   !foo || foo.bar
#
#   # Methods that are used on assignment, arithmetic operation or
#   # comparison should not be converted to use safe navigation
#   foo.baz = bar if foo
#   foo.baz + bar if foo
#   foo.bar > 2 if foo
class RuboCop::Cop::Style::SafeNavigation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::NilMethods
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def check_node(node); end

  # if format: (if checked_variable body nil)
  # unless format: (if checked_variable nil body)
  def modifier_if_safe_navigation_candidate(param0 = T.unsafe(nil)); end

  def not_nil_check?(param0 = T.unsafe(nil)); end
  def on_and(node); end
  def on_if(node); end

  # @return [Boolean]
  def use_var_only_in_unless_modifier?(node, variable); end

  private

  def add_safe_nav_to_all_methods_in_chain(corrector, start_method, method_chain); end

  # @return [Boolean]
  def allowed_if_condition?(node); end

  def autocorrect(corrector, node); end
  def begin_range(node, method_call); end
  def chain_length(method_chain, method); end
  def comments(node); end
  def end_range(node, method_call); end
  def extract_common_parts(method_chain, checked_variable); end
  def extract_parts(node); end
  def extract_parts_from_and(node); end
  def extract_parts_from_if(node); end
  def find_matching_receiver_invocation(method_chain, checked_variable); end
  def handle_comments(corrector, node, method_call); end
  def max_chain_length; end
  def method_call(node); end

  # @return [Boolean]
  def method_called?(send_node); end

  # @return [Boolean]
  def negated?(send_node); end

  def relevant_comment_ranges(node); end

  # @return [Boolean]
  def unsafe_method?(send_node); end

  # @return [Boolean]
  def unsafe_method_used?(method_chain, method); end
end

RuboCop::Cop::Style::SafeNavigation::LOGIC_JUMP_KEYWORDS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::SafeNavigation::MSG = T.let(T.unsafe(nil), String)

# Identifies usages of `shuffle.first`,
# `shuffle.last`, and `shuffle[]` and change them to use
# `sample` instead.
#
# @example
#   # bad
#   [1, 2, 3].shuffle.first
#   [1, 2, 3].shuffle.first(2)
#   [1, 2, 3].shuffle.last
#   [2, 1, 3].shuffle.at(0)
#   [2, 1, 3].shuffle.slice(0)
#   [1, 2, 3].shuffle[2]
#   [1, 2, 3].shuffle[0, 2]    # sample(2) will do the same
#   [1, 2, 3].shuffle[0..2]    # sample(3) will do the same
#   [1, 2, 3].shuffle(random: Random.new).first
#
#   # good
#   [1, 2, 3].shuffle
#   [1, 2, 3].sample
#   [1, 2, 3].sample(3)
#   [1, 2, 3].shuffle[1, 3]    # sample(3) might return a longer Array
#   [1, 2, 3].shuffle[1..3]    # sample(3) might return a longer Array
#   [1, 2, 3].shuffle[foo, bar]
#   [1, 2, 3].shuffle(random: Random.new)
class RuboCop::Cop::Style::Sample < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def sample_candidate?(param0 = T.unsafe(nil)); end

  private

  def correction(shuffle_arg, method, method_args); end
  def extract_source(args); end
  def message(shuffle_arg, method, method_args, range); end

  # @return [Boolean]
  def offensive?(method, method_args); end

  def range_size(range_node); end
  def sample_arg(method, method_args); end
  def sample_size(method_args); end
  def sample_size_for_one_arg(arg); end
  def sample_size_for_two_args(first, second); end
  def source_range(shuffle_node, node); end
end

RuboCop::Cop::Style::Sample::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Sample::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Looks for places where an subset of an Enumerable (array,
# range, set, etc.; see note below) is calculated based on a `Regexp`
# match, and suggests `grep` or `grep_v` instead.
#
# NOTE: Hashes do not behave as you may expect with `grep`, which
# means that `hash.grep` is not equivalent to `hash.select`. Although
# RuboCop is limited by static analysis, this cop attempts to avoid
# registering an offense when the receiver is a hash (hash literal,
# `Hash.new`, `Hash#[]`, or `to_h`/`to_hash`).
#
# NOTE: `grep` and `grep_v` were optimized when used without a block
# in Ruby 3.0, but may be slower in previous versions.
# See https://bugs.ruby-lang.org/issues/17030
#
# @example
#   # bad (select or find_all)
#   array.select { |x| x.match? /regexp/ }
#   array.select { |x| /regexp/.match?(x) }
#   array.select { |x| x =~ /regexp/ }
#   array.select { |x| /regexp/ =~ x }
#
#   # bad (reject)
#   array.reject { |x| x.match? /regexp/ }
#   array.reject { |x| /regexp/.match?(x) }
#   array.reject { |x| x =~ /regexp/ }
#   array.reject { |x| /regexp/ =~ x }
#
#   # good
#   array.grep(regexp)
#   array.grep_v(regexp)
class RuboCop::Cop::Style::SelectByRegexp < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def calls_lvar?(param0 = T.unsafe(nil), param1); end

  # Returns true if a node appears to return a hash
  def creates_hash?(param0 = T.unsafe(nil)); end

  def env_const?(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def regexp_match?(param0 = T.unsafe(nil)); end

  private

  def extract_send_node(block_node); end
  def find_regexp(node, block); end

  # @return [Boolean]
  def match_predicate_without_receiver?(node); end

  # @return [Boolean]
  def receiver_allowed?(node); end

  def register_offense(node, block_node, regexp); end
end

RuboCop::Cop::Style::SelectByRegexp::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SelectByRegexp::REGEXP_METHODS = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Style::SelectByRegexp::REPLACEMENTS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::SelectByRegexp::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use the shorthand for self-assignment.
#
# @example
#
#   # bad
#   x = x + 1
#
#   # good
#   x += 1
class RuboCop::Cop::Style::SelfAssignment < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_cvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end

  private

  def apply_autocorrect(corrector, node, rhs, operator, new_rhs); end
  def autocorrect(corrector, node); end
  def autocorrect_boolean_node(corrector, node, rhs); end
  def autocorrect_send_node(corrector, node, rhs); end
  def check(node, var_type); end
  def check_boolean_node(node, rhs, var_name, var_type); end
  def check_send_node(node, rhs, var_name, var_type); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::SelfAssignment::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SelfAssignment::OPS = T.let(T.unsafe(nil), Array)

# Checks for multiple expressions placed on the same line.
# It also checks for lines terminated with a semicolon.
#
# This cop has `AllowAsExpressionSeparator` configuration option.
# It allows `;` to separate several expressions on the same line.
#
# @example
#   # bad
#   foo = 1; bar = 2;
#   baz = 3;
#
#   # good
#   foo = 1
#   bar = 2
#   baz = 3
# @example AllowAsExpressionSeparator: false (default)
#   # bad
#   foo = 1; bar = 2
# @example AllowAsExpressionSeparator: true
#   # good
#   foo = 1; bar = 2
class RuboCop::Cop::Style::Semicolon < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_begin(node); end
  def on_new_investigation; end

  private

  def check_for_line_terminator_or_opener; end
  def each_semicolon; end
  def expressions_per_line(exprs); end
  def find_range_node(token_before_semicolon); end
  def find_semicolon_positions(line); end
  def range_nodes; end
  def register_semicolon(line, column, after_expression, token_before_semicolon = T.unsafe(nil)); end
  def tokens_for_lines; end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::Semicolon::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of the send method.
#
# @example
#   # bad
#   Foo.send(:bar)
#   quuz.send(:fred)
#
#   # good
#   Foo.__send__(:bar)
#   quuz.public_send(:fred)
class RuboCop::Cop::Style::Send < ::RuboCop::Cop::Base
  def on_csend(node); end
  def on_send(node); end
end

RuboCop::Cop::Style::Send::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Send::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `fail` and `raise`.
#
# @example EnforcedStyle: only_raise (default)
#   # The `only_raise` style enforces the sole use of `raise`.
#   # bad
#   begin
#   fail
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   fail
#   rescue Exception
#   # handle it
#   end
#
#   Kernel.fail
#
#   # good
#   begin
#   raise
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   raise
#   rescue Exception
#   # handle it
#   end
#
#   Kernel.raise
# @example EnforcedStyle: only_fail
#   # The `only_fail` style enforces the sole use of `fail`.
#   # bad
#   begin
#   raise
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   raise
#   rescue Exception
#   # handle it
#   end
#
#   Kernel.raise
#
#   # good
#   begin
#   fail
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   fail
#   rescue Exception
#   # handle it
#   end
#
#   Kernel.fail
# @example EnforcedStyle: semantic
#   # The `semantic` style enforces the use of `fail` to signal an
#   # exception, then will use `raise` to trigger an offense after
#   # it has been rescued.
#   # bad
#   begin
#   raise
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   # Error thrown
#   rescue Exception
#   fail
#   end
#
#   Kernel.fail
#   Kernel.raise
#
#   # good
#   begin
#   fail
#   rescue Exception
#   # handle it
#   end
#
#   def watch_out
#   fail
#   rescue Exception
#   raise 'Preferably with descriptive message'
#   end
#
#   explicit_receiver.fail
#   explicit_receiver.raise
class RuboCop::Cop::Style::SignalException < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def custom_fail_methods(param0); end
  def kernel_call?(param0 = T.unsafe(nil), param1); end
  def on_new_investigation; end
  def on_rescue(node); end
  def on_send(node); end

  private

  def allow(method_name, node); end
  def autocorrect(corrector, node); end
  def check_scope(method_name, node); end
  def check_send(method_name, node); end

  # @return [Boolean]
  def command_or_kernel_call?(name, node); end

  def each_command_or_kernel_call(method_name, node); end
  def message(method_name); end
end

RuboCop::Cop::Style::SignalException::FAIL_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SignalException::RAISE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SignalException::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Sometimes using dig method ends up with just a single
# argument. In such cases, dig should be replaced with [].
#
# @example
#   # bad
#   { key: 'value' }.dig(:key)
#   [1, 2, 3].dig(0)
#
#   # good
#   { key: 'value' }[:key]
#   [1, 2, 3][0]
#
#   # good
#   { key1: { key2: 'value' } }.dig(:key1, :key2)
#   [1, [2, [3]]].dig(1, 1)
#
#   # good
#   keys = %i[key1 key2]
#   { key1: { key2: 'value' } }.dig(*keys)
class RuboCop::Cop::Style::SingleArgumentDig < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def single_argument_dig?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Style::SingleArgumentDig::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SingleArgumentDig::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks whether the block parameters of a single-line
# method accepting a block match the names specified via configuration.
#
# For instance one can configure `reduce`(`inject`) to use |a, e| as
# parameters.
#
# Configuration option: Methods
# Should be set to use this cop. Array of hashes, where each key is the
# method name and value - array of argument names.
#
# @example Methods: [{reduce: %w[a b]}]
#   # bad
#   foo.reduce { |c, d| c + d }
#   foo.reduce { |_, _d| 1 }
#
#   # good
#   foo.reduce { |a, b| a + b }
#   foo.reduce { |a, _b| a }
#   foo.reduce { |a, (id, _)| a + id }
#   foo.reduce { true }
#
#   # good
#   foo.reduce do |c, d|
#   c + d
#   end
class RuboCop::Cop::Style::SingleLineBlockParams < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end

  private

  # @return [Boolean]
  def args_match?(method_name, args); end

  def autocorrect(corrector, node, preferred_block_arguments, joined_block_arguments); end
  def build_preferred_arguments_map(node, preferred_arguments); end

  # @return [Boolean]
  def eligible_arguments?(node); end

  # @return [Boolean]
  def eligible_method?(node); end

  def method_name(method); end
  def method_names; end
  def methods; end
  def target_args(method_name); end
end

RuboCop::Cop::Style::SingleLineBlockParams::MSG = T.let(T.unsafe(nil), String)

# Checks for single-line method definitions that contain a body.
# It will accept single-line methods with no body.
#
# Endless methods added in Ruby 3.0 are also accepted by this cop.
#
# If `Style/EndlessMethod` is enabled with `EnforcedStyle: allow_single_line` or
# `allow_always`, single-line methods will be autocorrected to endless
# methods if there is only one statement in the body.
#
# @example
#   # bad
#   def some_method; body end
#   def link_to(url); {:name => url}; end
#   def @table.columns; super; end
#
#   # good
#   def self.resource_class=(klass); end
#   def @table.columns; end
#   def some_method() = body
# @example AllowIfMethodIsEmpty: true (default)
#   # good
#   def no_op; end
# @example AllowIfMethodIsEmpty: false
#   # bad
#   def no_op; end
class RuboCop::Cop::Style::SingleLineMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end

  private

  # @return [Boolean]
  def allow_empty?; end

  def autocorrect(corrector, node); end
  def break_line_before(corrector, node, range, indent_steps: T.unsafe(nil)); end
  def correct_to_endless(corrector, node); end

  # @return [Boolean]
  def correct_to_endless?(body_node); end

  def correct_to_multiline(corrector, node); end

  # @return [Boolean]
  def disallow_endless_method_style?; end

  def each_part(body); end
  def method_body_source(method_body); end
  def move_comment(node, corrector); end

  # @return [Boolean]
  def require_parentheses?(method_body); end
end

RuboCop::Cop::Style::SingleLineMethods::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SingleLineMethods::NOT_SUPPORTED_ENDLESS_METHOD_BODY_TYPES = T.let(T.unsafe(nil), Array)

# Checks that arrays are sliced with endless ranges instead of
# `ary[start..-1]` on Ruby 2.6+.
#
# @example
#   # bad
#   items[1..-1]
#
#   # good
#   items[1..]
class RuboCop::Cop::Style::SlicingWithRange < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_send(node); end
  def range_till_minus_one?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Style::SlicingWithRange::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SlicingWithRange::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# If the branch of a conditional consists solely of a conditional node,
# its conditions can be combined with the conditions of the outer branch.
# This helps to keep the nesting level from getting too deep.
#
# @example
#   # bad
#   if condition_a
#   if condition_b
#   do_something
#   end
#   end
#
#   # bad
#   if condition_b
#   do_something
#   end if condition_a
#
#   # good
#   if condition_a && condition_b
#   do_something
#   end
# @example AllowModifier: false (default)
#   # bad
#   if condition_a
#   do_something if condition_b
#   end
#
#   # bad
#   if condition_b
#   do_something
#   end if condition_a
# @example AllowModifier: true
#   # good
#   if condition_a
#   do_something if condition_b
#   end
#
#   # good
#   if condition_b
#   do_something
#   end if condition_a
class RuboCop::Cop::Style::SoleNestedConditional < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end

  private

  # @return [Boolean]
  def allow_modifier?; end

  def arguments_range(node); end
  def assigned_variables(condition); end
  def autocorrect(corrector, node, if_branch); end
  def autocorrect_outer_condition_basic(corrector, node, if_branch); end
  def autocorrect_outer_condition_modify_form(corrector, node, if_branch); end
  def correct_for_basic_condition_style(corrector, node, if_branch, and_operator); end
  def correct_for_comment(corrector, node, if_branch); end
  def correct_for_guard_condition_style(corrector, outer_condition, if_branch, and_operator); end
  def correct_for_outer_condition_modify_form_style(corrector, node, if_branch); end
  def correct_from_unless_to_if(corrector, node, is_modify_form: T.unsafe(nil)); end
  def correct_outer_condition(corrector, condition); end
  def insert_bang(corrector, node, is_modify_form); end
  def insert_bang_for_and(corrector, node); end

  # @return [Boolean]
  def offending_branch?(node, branch); end

  # @return [Boolean]
  def outer_condition_modify_form?(node, if_branch); end

  def replace_condition(condition); end

  # @return [Boolean]
  def require_parentheses?(condition); end

  # @return [Boolean]
  def use_variable_assignment_in_condition?(condition, if_branch); end

  def wrap_condition(corrector, condition); end

  # @return [Boolean]
  def wrap_condition?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::SoleNestedConditional::MSG = T.let(T.unsafe(nil), String)

# This cop looks for uses of Perl-style global variables.
# Correcting to global variables in the 'English' library
# will add a require statement to the top of the file if
# enabled by RequireEnglish config.
#
# Like `use_perl_names` but allows builtin global vars.
#
#   # good
#   puts $LOAD_PATH
#   puts $LOADED_FEATURES
#   puts $PROGRAM_NAME
#   puts ARGV
#   puts $:
#   puts $"
#   puts $0
#   puts $!
#   puts $@
#   puts $;
#   puts $,
#   puts $/
#   puts $\
#   puts $.
#   puts $_
#   puts $>
#   puts $<
#   puts $$
#   puts $?
#   puts $~
#   puts $=
#   puts $*
#
# @example EnforcedStyle: use_english_names (default)
#   # good
#   require 'English' # or this could be in another file.
#
#   puts $LOAD_PATH
#   puts $LOADED_FEATURES
#   puts $PROGRAM_NAME
#   puts $ERROR_INFO
#   puts $ERROR_POSITION
#   puts $FIELD_SEPARATOR # or $FS
#   puts $OUTPUT_FIELD_SEPARATOR # or $OFS
#   puts $INPUT_RECORD_SEPARATOR # or $RS
#   puts $OUTPUT_RECORD_SEPARATOR # or $ORS
#   puts $INPUT_LINE_NUMBER # or $NR
#   puts $LAST_READ_LINE
#   puts $DEFAULT_OUTPUT
#   puts $DEFAULT_INPUT
#   puts $PROCESS_ID # or $PID
#   puts $CHILD_STATUS
#   puts $LAST_MATCH_INFO
#   puts $IGNORECASE
#   puts $ARGV # or ARGV
# @example EnforcedStyle: use_perl_names
#   # good
#   puts $:
#   puts $"
#   puts $0
#   puts $!
#   puts $@
#   puts $;
#   puts $,
#   puts $/
#   puts $\
#   puts $.
#   puts $_
#   puts $>
#   puts $<
#   puts $$
#   puts $?
#   puts $~
#   puts $=
#   puts $*
# @example EnforcedStyle: use_builtin_english_names
class RuboCop::Cop::Style::SpecialGlobalVars < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::RequireLibrary
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, node, global_var); end
  def message(global_var); end
  def on_gvar(node); end
  def on_new_investigation; end

  private

  # @return [Boolean]
  def add_require_english?; end

  def english_name_replacement(preferred_name, node); end
  def format_english_message(global_var); end

  # For now, we assume that lists are 2 items or less. Easy grammar!
  def format_list(items); end

  def format_message(english, regular, global); end
  def matching_styles(global); end
  def preferred_names(global); end
  def replacement(node, global_var); end

  # @return [Boolean]
  def should_require_english?(global_var); end
end

RuboCop::Cop::Style::SpecialGlobalVars::BUILTIN_VARS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::SpecialGlobalVars::ENGLISH_VARS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::SpecialGlobalVars::LIBRARY_NAME = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SpecialGlobalVars::MSG_BOTH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SpecialGlobalVars::MSG_ENGLISH = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SpecialGlobalVars::MSG_REGULAR = T.let(T.unsafe(nil), String)

# Anything *not* in this set is provided by the English library.
RuboCop::Cop::Style::SpecialGlobalVars::NON_ENGLISH_VARS = T.let(T.unsafe(nil), Set)

RuboCop::Cop::Style::SpecialGlobalVars::PERL_VARS = T.let(T.unsafe(nil), Hash)
RuboCop::Cop::Style::SpecialGlobalVars::STYLE_VARS_MAP = T.let(T.unsafe(nil), Hash)

# Check for parentheses around stabby lambda arguments.
# There are two different styles. Defaults to `require_parentheses`.
#
# @example EnforcedStyle: require_parentheses (default)
#   # bad
#   ->a,b,c { a + b + c }
#
#   # good
#   ->(a,b,c) { a + b + c}
# @example EnforcedStyle: require_no_parentheses
#   # bad
#   ->(a,b,c) { a + b + c }
#
#   # good
#   ->a,b,c { a + b + c}
class RuboCop::Cop::Style::StabbyLambdaParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end

  private

  def message(_node); end

  # @return [Boolean]
  def missing_parentheses?(node); end

  def missing_parentheses_corrector(corrector, node); end

  # @return [Boolean]
  def parentheses?(node); end

  # @return [Boolean]
  def redundant_parentheses?(node); end

  # @return [Boolean]
  def stabby_lambda_with_args?(node); end

  def unwanted_parentheses_corrector(corrector, node); end
end

RuboCop::Cop::Style::StabbyLambdaParentheses::MSG_NO_REQUIRE = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::StabbyLambdaParentheses::MSG_REQUIRE = T.let(T.unsafe(nil), String)

# Checks for places where classes with only class methods can be
# replaced with a module. Classes should be used only when it makes sense to create
# instances out of them.
#
# @example
#   # bad
#   class SomeClass
#   def self.some_method
#   # body omitted
#   end
#
#   def self.some_other_method
#   # body omitted
#   end
#   end
#
#   # good
#   module SomeModule
#   module_function
#
#   def some_method
#   # body omitted
#   end
#
#   def some_other_method
#   # body omitted
#   end
#   end
#
#   # good - has instance method
#   class SomeClass
#   def instance_method; end
#   def self.class_method; end
#   end
class RuboCop::Cop::Style::StaticClass < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp

  def on_class(class_node); end

  private

  # @return [Boolean]
  def class_convertible_to_module?(class_node); end

  def class_elements(class_node); end

  # @return [Boolean]
  def extend_call?(node); end

  # @return [Boolean]
  def sclass_convertible_to_module?(node); end
end

RuboCop::Cop::Style::StaticClass::MSG = T.let(T.unsafe(nil), String)

# Identifies places where `$stderr.puts` can be replaced by
# `warn`. The latter has the advantage of easily being disabled by,
# the `-W0` interpreter flag or setting `$VERBOSE` to `nil`.
#
# @example
#   # bad
#   $stderr.puts('hello')
#
#   # good
#   warn('hello')
class RuboCop::Cop::Style::StderrPuts < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
  def stderr_puts?(param0 = T.unsafe(nil)); end

  private

  def message(node); end

  # @return [Boolean]
  def stderr_gvar?(sym); end

  def stderr_puts_range(send); end
end

RuboCop::Cop::Style::StderrPuts::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::StderrPuts::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for uses of `String#split` with empty string or regexp literal argument.
#
# @example
#   # bad
#   string.split(//)
#   string.split('')
#
#   # good
#   string.chars
class RuboCop::Cop::Style::StringChars < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_send(node); end
end

RuboCop::Cop::Style::StringChars::BAD_ARGUMENTS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::StringChars::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::StringChars::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for places where string concatenation
# can be replaced with string interpolation.
#
# The cop can autocorrect simple cases but will skip autocorrecting
# more complex cases where the resulting code would be harder to read.
# In those cases, it might be useful to extract statements to local
# variables or methods which you can then interpolate in a string.
#
# NOTE: When concatenation between two strings is broken over multiple
# lines, this cop does not register an offense; instead,
# `Style/LineEndConcatenation` will pick up the offense if enabled.
#
# Two modes are supported:
# 1. `aggressive` style checks and corrects all occurrences of `+` where
# either the left or right side of `+` is a string literal.
# 2. `conservative` style on the other hand, checks and corrects only if
# left side (receiver of `+` method call) is a string literal.
# This is useful when the receiver is some expression that returns string like `Pathname`
# instead of a string literal.
#
# @example Mode: aggressive (default)
#   # bad
#   email_with_name = user.name + ' <' + user.email + '>'
#   Pathname.new('/') + 'test'
#
#   # good
#   email_with_name = "#{user.name} <#{user.email}>"
#   email_with_name = format('%s <%s>', user.name, user.email)
#   "#{Pathname.new('/')}test"
#
#   # accepted, line-end concatenation
#   name = 'First' +
#   'Last'
# @example Mode: conservative
#   # bad
#   'Hello' + user.name
#
#   # good
#   "Hello #{user.name}"
#   user.name + '!!'
#   Pathname.new('/') + 'test'
class RuboCop::Cop::Style::StringConcatenation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_new_investigation; end
  def on_send(node); end
  def string_concatenation?(param0 = T.unsafe(nil)); end

  private

  def collect_parts(node, parts = T.unsafe(nil)); end

  # @return [Boolean]
  def corrected_ancestor?(node); end

  def find_topmost_plus_node(node); end
  def handle_quotes(parts); end

  # @return [Boolean]
  def heredoc?(node); end

  # @return [Boolean]
  def line_end_concatenation?(node); end

  def mode; end

  # @return [Boolean]
  def plus_node?(node); end

  def register_offense(topmost_plus_node, parts); end
  def replacement(parts); end

  # @return [Boolean]
  def single_quoted?(str_node); end

  # @return [Boolean]
  def uncorrectable?(part); end
end

RuboCop::Cop::Style::StringConcatenation::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::StringConcatenation::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for the use of strings as keys in hashes. The use of
# symbols is preferred instead.
#
# @example
#   # bad
#   { 'one' => 1, 'two' => 2, 'three' => 3 }
#
#   # good
#   { one: 1, two: 2, three: 3 }
class RuboCop::Cop::Style::StringHashKeys < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_pair(node); end
  def receive_environments_method?(param0 = T.unsafe(nil)); end
  def string_hash_key?(param0 = T.unsafe(nil)); end
end

RuboCop::Cop::Style::StringHashKeys::MSG = T.let(T.unsafe(nil), String)

# Checks if uses of quotes match the configured preference.
#
# @example EnforcedStyle: single_quotes (default)
#   # bad
#   "No special symbols"
#   "No string interpolation"
#   "Just text"
#
#   # good
#   'No special symbols'
#   'No string interpolation'
#   'Just text'
#   "Wait! What's #{this}!"
# @example EnforcedStyle: double_quotes
#   # bad
#   'Just some text'
#   'No special chars or interpolation'
#
#   # good
#   "Just some text"
#   "No special chars or interpolation"
#   "Every string in #{project} uses double_quotes"
class RuboCop::Cop::Style::StringLiterals < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::StringLiteralsHelp
  include ::RuboCop::Cop::StringHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_dstr(node); end

  private

  # @return [Boolean]
  def accept_child_double_quotes?(nodes); end

  # @return [Boolean]
  def all_string_literals?(nodes); end

  def autocorrect(corrector, node); end
  def check_multiline_quote_style(node, quote); end

  # @return [Boolean]
  def consistent_multiline?; end

  def detect_quote_styles(node); end
  def message(_node); end

  # @return [Boolean]
  def offense?(node); end

  def register_offense(node, message: T.unsafe(nil)); end

  # @return [Boolean]
  def unexpected_double_quotes?(quote); end

  # @return [Boolean]
  def unexpected_single_quotes?(quote); end
end

RuboCop::Cop::Style::StringLiterals::MSG_INCONSISTENT = T.let(T.unsafe(nil), String)

# Checks that quotes inside the string interpolation
# match the configured preference.
#
# @example EnforcedStyle: single_quotes (default)
#   # bad
#   result = "Tests #{success ? "PASS" : "FAIL"}"
#
#   # good
#   result = "Tests #{success ? 'PASS' : 'FAIL'}"
# @example EnforcedStyle: double_quotes
#   # bad
#   result = "Tests #{success ? 'PASS' : 'FAIL'}"
#
#   # good
#   result = "Tests #{success ? "PASS" : "FAIL"}"
class RuboCop::Cop::Style::StringLiteralsInInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::StringLiteralsHelp
  include ::RuboCop::Cop::StringHelp
  extend ::RuboCop::Cop::AutoCorrector

  def autocorrect(corrector, node); end

  private

  def message(_node); end

  # @return [Boolean]
  def offense?(node); end
end

# Enforces the use of consistent method names
# from the String class.
#
# @example
#   # bad
#   'name'.intern
#   'var'.unfavored_method
#
#   # good
#   'name'.to_sym
#   'var'.preferred_method
class RuboCop::Cop::Style::StringMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::MethodPreference
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end
end

RuboCop::Cop::Style::StringMethods::MSG = T.let(T.unsafe(nil), String)

# Identifies places where `lstrip.rstrip` can be replaced by
# `strip`.
#
# @example
#   # bad
#   'abc'.lstrip.rstrip
#   'abc'.rstrip.lstrip
#
#   # good
#   'abc'.strip
class RuboCop::Cop::Style::Strip < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def lstrip_rstrip(param0 = T.unsafe(nil)); end
  def on_send(node); end
end

RuboCop::Cop::Style::Strip::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::Strip::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for inheritance from Struct.new.
#
# @example
#   # bad
#   class Person < Struct.new(:first_name, :last_name)
#   def age
#   42
#   end
#   end
#
#   # good
#   Person = Struct.new(:first_name, :last_name) do
#   def age
#   42
#   end
#   end
class RuboCop::Cop::Style::StructInheritance < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
  def struct_constructor?(param0 = T.unsafe(nil)); end

  private

  def correct_parent(parent, corrector); end
  def range_for_empty_class_body(class_node, struct_new); end
end

RuboCop::Cop::Style::StructInheritance::MSG = T.let(T.unsafe(nil), String)

# Enforces the use of shorthand-style swapping of 2 variables.
#
# @example
#   # bad
#   tmp = x
#   x = y
#   y = tmp
#
#   # good
#   x, y = y, x
class RuboCop::Cop::Style::SwapValues < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_asgn(node); end
  def on_casgn(node); end
  def on_cvasgn(node); end
  def on_gvasgn(node); end
  def on_ivasgn(node); end
  def on_lvasgn(node); end

  private

  # @return [Boolean]
  def allowed_assignment?(node); end

  def correction_range(tmp_assign, y_assign); end
  def lhs(node); end
  def message(x_assign, y_assign); end
  def replacement(x_assign); end
  def rhs(node); end

  # @return [Boolean]
  def simple_assignment?(node); end

  # @return [Boolean]
  def swapping_values?(tmp_assign, x_assign, y_assign); end
end

RuboCop::Cop::Style::SwapValues::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SwapValues::SIMPLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Set)

# Checks for array literals made up of symbols that are not
# using the %i() syntax.
#
# Alternatively, it checks for symbol arrays using the %i() syntax on
# projects which do not want to use that syntax, perhaps because they
# support a version of Ruby lower than 2.0.
#
# Configuration option: MinSize
# If set, arrays with fewer elements than this value will not trigger the
# cop. For example, a `MinSize` of `3` will not enforce a style on an
# array of 2 or fewer elements.
#
# @example EnforcedStyle: percent (default)
#   # good
#   %i[foo bar baz]
#
#   # bad
#   [:foo, :bar, :baz]
# @example EnforcedStyle: brackets
#   # good
#   [:foo, :bar, :baz]
#
#   # bad
#   %i[foo bar baz]
class RuboCop::Cop::Style::SymbolArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ArrayMinSize
  include ::RuboCop::Cop::ArraySyntax
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::PercentArray
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_array(node); end

  private

  def build_bracketed_array(node); end

  # @return [Boolean]
  def symbol_without_quote?(string); end

  # @return [Boolean]
  def symbols_contain_spaces?(node); end

  def to_symbol_literal(string); end

  class << self
    # Returns the value of attribute largest_brackets.
    def largest_brackets; end

    # Sets the attribute largest_brackets
    #
    # @param value the value to set the attribute largest_brackets to.
    def largest_brackets=(_arg0); end
  end
end

RuboCop::Cop::Style::SymbolArray::ARRAY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SymbolArray::PERCENT_MSG = T.let(T.unsafe(nil), String)

# Checks symbol literal syntax.
#
# @example
#
#   # bad
#   :"symbol"
#
#   # good
#   :symbol
class RuboCop::Cop::Style::SymbolLiteral < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_sym(node); end
end

RuboCop::Cop::Style::SymbolLiteral::MSG = T.let(T.unsafe(nil), String)

# Use symbols as procs when possible.
#
# If you prefer a style that allows block for method with arguments,
# please set `true` to `AllowMethodsWithArguments`.
# respond_to , and `define_method?` methods are allowed by default.
# These are customizable with `AllowedMethods` option.
#
# @example AllowedPatterns: [/map/] (default)
#   # good
#   something.map { |s| s.upcase }
# @example AllowMethodsWithArguments: false (default)
#   # bad
#   something.do_something(foo) { |o| o.bar }
#
#   # good
#   something.do_something(foo, &:bar)
# @example AllowMethodsWithArguments: true
#   # good
#   something.do_something(foo) { |o| o.bar }
# @example AllowComments: false (default)
#   # bad
#   something.do_something do |s| # some comment
#   # some comment
#   s.upcase # some comment
#   # some comment
#   end
# @example AllowComments: true
#   # good  - if there are comment in either position
#   something.do_something do |s| # some comment
#   # some comment
#   s.upcase # some comment
#   # some comment
#   end
# @example AllowedMethods: [respond_to, define_method] (default)
#   # good
#   respond_to { |foo| foo.bar }
#   define_method(:foo) { |foo| foo.bar }
# @example AllowedPatterns: [] (default)
#   # bad
#   something.map { |s| s.upcase }
# @example
#   # bad
#   something.map { |s| s.upcase }
#   something.map { _1.upcase }
#
#   # good
#   something.map(&:upcase)
class RuboCop::Cop::Style::SymbolProc < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::CommentsHelp
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::AllowedMethods
  include ::RuboCop::Cop::AllowedPattern
  extend ::RuboCop::Cop::AutoCorrector

  # @return [Boolean]
  def destructuring_block_argument?(argument_node); end

  def on_block(node); end
  def on_numblock(node); end
  def proc_node?(param0 = T.unsafe(nil)); end
  def symbol_proc?(param0 = T.unsafe(nil)); end
  def symbol_proc_receiver?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def allow_comments?; end

  # @return [Boolean]
  def allow_if_method_has_argument?(send_node); end

  # @return [Boolean]
  def allowed_method_name?(name); end

  def autocorrect(corrector, node); end
  def autocorrect_with_args(corrector, node, args, method_name); end
  def autocorrect_without_args(corrector, node); end
  def begin_pos_for_replacement(node); end
  def block_range_with_space(node); end
  def register_offense(node, method_name, block_method_name); end

  # @return [Boolean]
  def unsafe_array_usage?(node); end

  # See: https://github.com/rubocop/rubocop/issues/10864
  #
  # @return [Boolean]
  def unsafe_hash_usage?(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

RuboCop::Cop::Style::SymbolProc::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::SymbolProc::SUPER_TYPES = T.let(T.unsafe(nil), Array)

# Corrector to correct conditional assignment in ternary conditions.
class RuboCop::Cop::Style::TernaryCorrector
  extend ::RuboCop::Cop::Style::ConditionalAssignmentHelper
  extend ::RuboCop::Cop::Style::ConditionalCorrectorHelper

  class << self
    def correct(corrector, node); end
    def move_assignment_inside_condition(corrector, node); end

    private

    def correction(node); end

    # @return [Boolean]
    def element_assignment?(node); end

    def extract_branches(node); end
    def move_branch_inside_condition(corrector, branch, assignment); end
    def remove_parentheses(corrector, node); end
    def ternary(node); end
  end
end

# Checks for the presence of parentheses around ternary
# conditions. It is configurable to enforce inclusion or omission of
# parentheses using `EnforcedStyle`. Omission is only enforced when
# removing the parentheses won't cause a different behavior.
#
# `AllowSafeAssignment` option for safe assignment.
# By safe assignment we mean putting parentheses around
# an assignment to indicate "I know I'm using an assignment
# as a condition. It's not a mistake."
#
# @example EnforcedStyle: require_no_parentheses (default)
#   # bad
#   foo = (bar?) ? a : b
#   foo = (bar.baz?) ? a : b
#   foo = (bar && baz) ? a : b
#
#   # good
#   foo = bar? ? a : b
#   foo = bar.baz? ? a : b
#   foo = bar && baz ? a : b
# @example EnforcedStyle: require_parentheses
#   # bad
#   foo = bar? ? a : b
#   foo = bar.baz? ? a : b
#   foo = bar && baz ? a : b
#
#   # good
#   foo = (bar?) ? a : b
#   foo = (bar.baz?) ? a : b
#   foo = (bar && baz) ? a : b
# @example EnforcedStyle: require_parentheses_when_complex
#   # bad
#   foo = (bar?) ? a : b
#   foo = (bar.baz?) ? a : b
#   foo = bar && baz ? a : b
#
#   # good
#   foo = bar? ? a : b
#   foo = bar.baz? ? a : b
#   foo = (bar && baz) ? a : b
# @example AllowSafeAssignment: true (default)
#   # good
#   foo = (bar = baz) ? a : b
# @example AllowSafeAssignment: false
#   # bad
#   foo = (bar = baz) ? a : b
class RuboCop::Cop::Style::TernaryParentheses < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::SafeAssignment
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  def method_name(param0 = T.unsafe(nil)); end
  def on_if(node); end

  private

  def autocorrect(corrector, node); end

  # @return [Boolean]
  def below_ternary_precedence?(child); end

  # If the condition is parenthesized we recurse and check for any
  # complex expressions within it.
  #
  # @return [Boolean]
  def complex_condition?(condition); end

  # @return [Boolean]
  def condition_as_parenthesized_one_line_pattern_matching?(condition); end

  def correct_parenthesized(corrector, condition); end
  def correct_unparenthesized(corrector, condition); end
  def message(node); end

  # Anything that is not a variable, constant, or method/.method call
  # will be counted as a complex expression.
  #
  # @return [Boolean]
  def non_complex_expression?(condition); end

  # @return [Boolean]
  def non_complex_send?(node); end

  # @return [Boolean]
  def offense?(node); end

  # @return [Boolean]
  def only_closing_parenthesis_is_last_line?(condition); end

  # @return [Boolean]
  def parenthesized?(node); end

  # @return [Boolean]
  def require_parentheses?; end

  # @return [Boolean]
  def require_parentheses_when_complex?; end

  # @return [Boolean]
  def unparenthesized_method_call?(child); end

  # @return [Boolean]
  def unsafe_autocorrect?(condition); end

  # @return [Boolean]
  def whitespace_after?(node); end
end

RuboCop::Cop::Style::TernaryParentheses::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::TernaryParentheses::MSG_COMPLEX = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::TernaryParentheses::NON_COMPLEX_TYPES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::TernaryParentheses::VARIABLE_TYPES = T.let(T.unsafe(nil), Set)

# Newcomers to ruby applications may write top-level methods,
# when ideally they should be organized in appropriate classes or modules.
# This cop looks for definitions of top-level methods and warns about them.
#
# However for ruby scripts it is perfectly fine to use top-level methods.
# Hence this cop is disabled by default.
#
# @example
#   # bad
#   def some_method
#   end
#
#   # bad
#   def self.some_method
#   end
#
#   # bad
#   define_method(:foo) { puts 1 }
#
#   # good
#   module Foo
#   def some_method
#   end
#   end
#
#   # good
#   class Foo
#   def self.some_method
#   end
#   end
#
#   # good
#   Struct.new do
#   def some_method
#   end
#   end
#
#   # good
#   class Foo
#   define_method(:foo) { puts 1 }
#   end
class RuboCop::Cop::Style::TopLevelMethodDefinition < ::RuboCop::Cop::Base
  def define_method_block?(param0 = T.unsafe(nil)); end
  def on_block(node); end
  def on_def(node); end
  def on_defs(node); end
  def on_numblock(node); end
  def on_send(node); end

  private

  # @return [Boolean]
  def top_level_method_definition?(node); end
end

RuboCop::Cop::Style::TopLevelMethodDefinition::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::TopLevelMethodDefinition::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for trailing code after the class definition.
#
# @example
#   # bad
#   class Foo; def foo; end
#   end
#
#   # good
#   class Foo
#   def foo; end
#   end
class RuboCop::Cop::Style::TrailingBodyOnClass < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::TrailingBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_class(node); end
end

RuboCop::Cop::Style::TrailingBodyOnClass::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing code after the method definition.
#
# NOTE: It always accepts endless method definitions that are basically on the same line.
#
# @example
#   # bad
#   def some_method; do_stuff
#   end
#
#   def f(x); b = foo
#   b[c: x]
#   end
#
#   # good
#   def some_method
#   do_stuff
#   end
#
#   def f(x)
#   b = foo
#   b[c: x]
#   end
#
#   def endless_method = do_stuff
class RuboCop::Cop::Style::TrailingBodyOnMethodDefinition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::TrailingBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end
  def on_defs(node); end
end

RuboCop::Cop::Style::TrailingBodyOnMethodDefinition::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing code after the module definition.
#
# @example
#   # bad
#   module Foo extend self
#   end
#
#   # good
#   module Foo
#   extend self
#   end
class RuboCop::Cop::Style::TrailingBodyOnModule < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Alignment
  include ::RuboCop::Cop::TrailingBody
  extend ::RuboCop::Cop::AutoCorrector

  def on_module(node); end
end

RuboCop::Cop::Style::TrailingBodyOnModule::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing comma in argument lists.
# The supported styles are:
#
# * `consistent_comma`: Requires a comma after the last argument,
# for all parenthesized method calls with arguments.
# * `comma`: Requires a comma after the last argument, but only for
# parenthesized method calls where each argument is on its own line.
# * `no_comma`: Requires that there is no comma after the last
# argument.
#
# @example EnforcedStyleForMultiline: consistent_comma
#   # bad
#   method(1, 2,)
#
#   # good
#   method(1, 2)
#
#   # good
#   method(
#   1, 2,
#   3,
#   )
#
#   # good
#   method(
#   1, 2, 3,
#   )
#
#   # good
#   method(
#   1,
#   2,
#   )
# @example EnforcedStyleForMultiline: comma
#   # bad
#   method(1, 2,)
#
#   # good
#   method(1, 2)
#
#   # bad
#   method(
#   1, 2,
#   3,
#   )
#
#   # good
#   method(
#   1, 2,
#   3
#   )
#
#   # bad
#   method(
#   1, 2, 3,
#   )
#
#   # good
#   method(
#   1, 2, 3
#   )
#
#   # good
#   method(
#   1,
#   2,
#   )
# @example EnforcedStyleForMultiline: no_comma (default)
#   # bad
#   method(1, 2,)
#
#   # good
#   method(1, 2)
#
#   # good
#   method(
#   1,
#   2
#   )
class RuboCop::Cop::Style::TrailingCommaInArguments < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::TrailingComma
  extend ::RuboCop::Cop::AutoCorrector

  def on_csend(node); end
  def on_send(node); end

  class << self
    def autocorrect_incompatible_with; end
  end
end

# Checks for trailing comma in array literals.
# The configuration options are:
#
# * `consistent_comma`: Requires a comma after the
# last item of all non-empty, multiline array literals.
# * `comma`: Requires a comma after last item in an array,
# but only when each item is on its own line.
# * `no_comma`: Does not require a comma after the
# last item in an array
#
# @example EnforcedStyleForMultiline: consistent_comma
#   # bad
#   a = [1, 2,]
#
#   # good
#   a = [1, 2]
#
#   # good
#   a = [
#   1, 2,
#   3,
#   ]
#
#   # good
#   a = [
#   1, 2, 3,
#   ]
#
#   # good
#   a = [
#   1,
#   2,
#   ]
# @example EnforcedStyleForMultiline: comma
#   # bad
#   a = [1, 2,]
#
#   # good
#   a = [1, 2]
#
#   # bad
#   a = [
#   1, 2,
#   3,
#   ]
#
#   # good
#   a = [
#   1, 2,
#   3
#   ]
#
#   # bad
#   a = [
#   1, 2, 3,
#   ]
#
#   # good
#   a = [
#   1, 2, 3
#   ]
#
#   # good
#   a = [
#   1,
#   2,
#   ]
# @example EnforcedStyleForMultiline: no_comma (default)
#   # bad
#   a = [1, 2,]
#
#   # good
#   a = [
#   1,
#   2
#   ]
class RuboCop::Cop::Style::TrailingCommaInArrayLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::TrailingComma
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end
end

# Checks whether trailing commas in block arguments are
# required. Blocks with only one argument and a trailing comma require
# that comma to be present. Blocks with more than one argument never
# require a trailing comma.
#
# @example
#   # bad
#   add { |foo, bar,| foo + bar }
#
#   # good
#   add { |foo, bar| foo + bar }
#
#   # good
#   add { |foo,| foo }
#
#   # good
#   add { foo }
#
#   # bad
#   add do |foo, bar,|
#   foo + bar
#   end
#
#   # good
#   add do |foo, bar|
#   foo + bar
#   end
#
#   # good
#   add do |foo,|
#   foo
#   end
#
#   # good
#   add do
#   foo + bar
#   end
class RuboCop::Cop::Style::TrailingCommaInBlockArgs < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_block(node); end

  private

  def arg_count(node); end
  def argument_tokens(node); end
  def last_comma(node); end

  # @return [Boolean]
  def trailing_comma?(node); end

  # @return [Boolean]
  def useless_trailing_comma?(node); end
end

RuboCop::Cop::Style::TrailingCommaInBlockArgs::MSG = T.let(T.unsafe(nil), String)

# Checks for trailing comma in hash literals.
# The configuration options are:
#
# * `consistent_comma`: Requires a comma after the
# last item of all non-empty, multiline hash literals.
# * `comma`: Requires a comma after the last item in a hash,
# but only when each item is on its own line.
# * `no_comma`: Does not require a comma after the
# last item in a hash
#
# @example EnforcedStyleForMultiline: consistent_comma
#
#   # bad
#   a = { foo: 1, bar: 2, }
#
#   # good
#   a = { foo: 1, bar: 2 }
#
#   # good
#   a = {
#   foo: 1, bar: 2,
#   qux: 3,
#   }
#
#   # good
#   a = {
#   foo: 1, bar: 2, qux: 3,
#   }
#
#   # good
#   a = {
#   foo: 1,
#   bar: 2,
#   }
# @example EnforcedStyleForMultiline: comma
#
#   # bad
#   a = { foo: 1, bar: 2, }
#
#   # good
#   a = { foo: 1, bar: 2 }
#
#   # bad
#   a = {
#   foo: 1, bar: 2,
#   qux: 3,
#   }
#
#   # good
#   a = {
#   foo: 1, bar: 2,
#   qux: 3
#   }
#
#   # bad
#   a = {
#   foo: 1, bar: 2, qux: 3,
#   }
#
#   # good
#   a = {
#   foo: 1, bar: 2, qux: 3
#   }
#
#   # good
#   a = {
#   foo: 1,
#   bar: 2,
#   }
# @example EnforcedStyleForMultiline: no_comma (default)
#
#   # bad
#   a = { foo: 1, bar: 2, }
#
#   # good
#   a = {
#   foo: 1,
#   bar: 2
#   }
class RuboCop::Cop::Style::TrailingCommaInHashLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::TrailingComma
  extend ::RuboCop::Cop::AutoCorrector

  def on_hash(node); end
end

# Checks for trailing code after the method definition.
#
# @example
#   # bad
#   def some_method
#   do_stuff; end
#
#   def do_this(x)
#   baz.map { |b| b.this(x) } end
#
#   def foo
#   block do
#   bar
#   end end
#
#   # good
#   def some_method
#   do_stuff
#   end
#
#   def do_this(x)
#   baz.map { |b| b.this(x) }
#   end
#
#   def foo
#   block do
#   bar
#   end
#   end
class RuboCop::Cop::Style::TrailingMethodEndStatement < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_def(node); end

  private

  # @return [Boolean]
  def body_and_end_on_same_line?(node); end

  # @return [Boolean]
  def trailing_end?(node); end
end

RuboCop::Cop::Style::TrailingMethodEndStatement::MSG = T.let(T.unsafe(nil), String)

# Checks for extra underscores in variable assignment.
#
# @example
#   # bad
#   a, b, _ = foo()
#   a, b, _, = foo()
#   a, _, _ = foo()
#   a, _, _, = foo()
#
#   # good
#   a, b, = foo()
#   a, = foo()
#   *a, b, _ = foo()
#   # => We need to know to not include 2 variables in a
#   a, *b, _ = foo()
#   # => The correction `a, *b, = foo()` is a syntax error
# @example AllowNamedUnderscoreVariables: true (default)
#   # good
#   a, b, _something = foo()
# @example AllowNamedUnderscoreVariables: false
#   # bad
#   a, b, _something = foo()
class RuboCop::Cop::Style::TrailingUnderscoreVariable < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::SurroundingSpace
  extend ::RuboCop::Cop::AutoCorrector

  def on_masgn(node); end

  private

  def allow_named_underscore_variables; end
  def children_offenses(variables); end
  def find_first_offense(variables); end
  def find_first_possible_offense(variables); end
  def main_node_offense(node); end
  def range_for_parentheses(offense, left); end
  def reverse_index(collection, item); end

  # @return [Boolean]
  def splat_variable_before?(first_offense, variables); end

  def unneeded_ranges(node); end
  def unused_range(node_type, mlhs_node, right); end

  # @return [Boolean]
  def unused_variables_only?(offense, variables); end
end

RuboCop::Cop::Style::TrailingUnderscoreVariable::DISALLOW = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::TrailingUnderscoreVariable::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::TrailingUnderscoreVariable::UNDERSCORE = T.let(T.unsafe(nil), String)

# Looks for trivial reader/writer methods, that could
# have been created with the attr_* family of functions automatically.
# `to_ary`, `to_a`, `to_c`, `to_enum`, `to_h`, `to_hash`, `to_i`, `to_int`, `to_io`,
# `to_open`, `to_path`, `to_proc`, `to_r`, `to_regexp`, `to_str`, `to_s`, and `to_sym` methods
# are allowed by default. These are customizable with `AllowedMethods` option.
#
# @example AllowedMethods: ['allowed_method']
#   # good
#   def allowed_method
#   @foo
#   end
# @example ExactNameMatch: true (default)
#   # good
#   def name
#   @other_name
#   end
# @example ExactNameMatch: false
#   # bad
#   def name
#   @other_name
#   end
# @example AllowPredicates: true (default)
#   # good
#   def foo?
#   @foo
#   end
# @example AllowPredicates: false
#   # bad
#   def foo?
#   @foo
#   end
#
#   # good
#   attr_reader :foo
# @example AllowDSLWriters: true (default)
#   # good
#   def on_exception(action)
#   @on_exception=action
#   end
# @example AllowDSLWriters: false
#   # bad
#   def on_exception(action)
#   @on_exception=action
#   end
#
#   # good
#   attr_writer :on_exception
# @example IgnoreClassMethods: false (default)
#   # bad
#   def self.foo
#   @foo
#   end
#
#   # good
#   class << self
#   attr_reader :foo
#   end
# @example IgnoreClassMethods: true
#   # good
#   def self.foo
#   @foo
#   end
# @example
#   # bad
#   def foo
#   @foo
#   end
#
#   def bar=(val)
#   @bar = val
#   end
#
#   def self.baz
#   @baz
#   end
#
#   # good
#   attr_reader :foo
#   attr_writer :bar
#
#   class << self
#   attr_reader :baz
#   end
class RuboCop::Cop::Style::TrivialAccessors < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::AllowedMethods
  extend ::RuboCop::Cop::AutoCorrector

  def looks_like_trivial_writer?(param0 = T.unsafe(nil)); end
  def on_def(node); end
  def on_defs(node); end

  private

  def accessor(kind, method_name); end

  # @return [Boolean]
  def allow_dsl_writers?; end

  # @return [Boolean]
  def allow_predicates?; end

  # @return [Boolean]
  def allowed_method_name?(node); end

  def allowed_method_names; end

  # @return [Boolean]
  def allowed_reader?(node); end

  # @return [Boolean]
  def allowed_writer?(node); end

  def autocorrect(corrector, node); end
  def autocorrect_class(corrector, node); end
  def autocorrect_instance(corrector, node); end

  # @return [Boolean]
  def dsl_writer?(node); end

  # @return [Boolean]
  def exact_name_match?; end

  # @return [Boolean]
  def ignore_class_methods?; end

  # @return [Boolean]
  def in_module_or_instance_eval?(node); end

  # @return [Boolean]
  def looks_like_trivial_reader?(node); end

  # @return [Boolean]
  def names_match?(node); end

  def on_method_def(node); end

  # @return [Boolean]
  def top_level_node?(node); end

  def trivial_accessor_kind(node); end

  # @return [Boolean]
  def trivial_reader?(node); end

  # @return [Boolean]
  def trivial_writer?(node); end
end

RuboCop::Cop::Style::TrivialAccessors::MSG = T.let(T.unsafe(nil), String)

# Looks for `unless` expressions with `else` clauses.
#
# @example
#   # bad
#   unless foo_bar.nil?
#   # do something...
#   else
#   # do a different thing...
#   end
#
#   # good
#   if foo_bar.present?
#   # do something...
#   else
#   # do a different thing...
#   end
class RuboCop::Cop::Style::UnlessElse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def on_if(node); end
  def range_between_condition_and_else(node, condition); end
  def range_between_else_and_end(node); end
end

RuboCop::Cop::Style::UnlessElse::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of logical operators in an `unless` condition.
# It discourages such code, as the condition becomes more difficult
# to read and understand.
#
# This cop supports two styles:
# - `forbid_mixed_logical_operators` (default)
# - `forbid_logical_operators`
#
# `forbid_mixed_logical_operators` style forbids the use of more than one type
# of logical operators. This makes the `unless` condition easier to read
# because either all conditions need to be met or any condition need to be met
# in order for the expression to be truthy or falsey.
#
# `forbid_logical_operators` style forbids any use of logical operator.
# This makes it even more easy to read the `unless` condition as
# there is only one condition in the expression.
#
# @example EnforcedStyle: forbid_mixed_logical_operators (default)
#   # bad
#   return unless a || b && c
#   return unless a && b || c
#   return unless a && b and c
#   return unless a || b or c
#   return unless a && b or c
#   return unless a || b and c
#
#   # good
#   return unless a && b && c
#   return unless a || b || c
#   return unless a and b and c
#   return unless a or b or c
#   return unless a?
# @example EnforcedStyle: forbid_logical_operators
#   # bad
#   return unless a || b
#   return unless a && b
#   return unless a or b
#   return unless a and b
#
#   # good
#   return unless a
#   return unless a?
class RuboCop::Cop::Style::UnlessLogicalOperators < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle

  def and_with_or?(param0 = T.unsafe(nil)); end
  def logical_operator?(param0 = T.unsafe(nil)); end
  def on_if(node); end
  def or_with_and?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  def mixed_logical_operator?(node); end

  # @return [Boolean]
  def mixed_precedence_and?(node); end

  # @return [Boolean]
  def mixed_precedence_or?(node); end
end

RuboCop::Cop::Style::UnlessLogicalOperators::FORBID_LOGICAL_OPERATORS = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::UnlessLogicalOperators::FORBID_MIXED_LOGICAL_OPERATORS = T.let(T.unsafe(nil), String)

# Checks for accessing the first element of `String#unpack`
# which can be replaced with the shorter method `unpack1`.
#
# @example
#
#   # bad
#   'foo'.unpack('h*').first
#   'foo'.unpack('h*')[0]
#   'foo'.unpack('h*').slice(0)
#   'foo'.unpack('h*').at(0)
#
#   # good
#   'foo'.unpack1('h*')
class RuboCop::Cop::Style::UnpackFirst < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector
  extend ::RuboCop::Cop::TargetRubyVersion

  def on_send(node); end
  def unpack_and_first_element?(param0 = T.unsafe(nil)); end

  private

  def first_element_range(node, unpack_call); end
end

RuboCop::Cop::Style::UnpackFirst::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::UnpackFirst::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for variable interpolation (like "#@ivar").
#
# @example
#   # bad
#   "His name is #$name"
#   /check #$pattern/
#   "Let's go to the #@store"
#
#   # good
#   "His name is #{$name}"
#   /check #{$pattern}/
#   "Let's go to the #{@store}"
class RuboCop::Cop::Style::VariableInterpolation < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::Interpolation
  extend ::RuboCop::Cop::AutoCorrector

  def on_node_with_interpolations(node); end

  private

  def message(range); end
  def var_nodes(nodes); end
end

RuboCop::Cop::Style::VariableInterpolation::MSG = T.let(T.unsafe(nil), String)

# Checks for `when;` uses in `case` expressions.
#
# @example
#   # bad
#   case foo
#   when 1; 'baz'
#   when 2; 'bar'
#   end
#
#   # good
#   case foo
#   when 1 then 'baz'
#   when 2 then 'bar'
#   end
class RuboCop::Cop::Style::WhenThen < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_when(node); end
end

RuboCop::Cop::Style::WhenThen::MSG = T.let(T.unsafe(nil), String)

# Checks for uses of `do` in multi-line `while/until` statements.
#
# @example
#
#   # bad
#   while x.any? do
#   do_something(x.pop)
#   end
#
#   # good
#   while x.any?
#   do_something(x.pop)
#   end
# @example
#
#   # bad
#   until x.empty? do
#   do_something(x.pop)
#   end
#
#   # good
#   until x.empty?
#   do_something(x.pop)
#   end
class RuboCop::Cop::Style::WhileUntilDo < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  def on_until(node); end
  def on_while(node); end
end

RuboCop::Cop::Style::WhileUntilDo::MSG = T.let(T.unsafe(nil), String)

# Checks for while and until statements that would fit on one line
# if written as a modifier while/until. The maximum line length is
# configured in the `Layout/LineLength` cop.
#
# @example
#   # bad
#   while x < 10
#   x += 1
#   end
#
#   # good
#   x += 1 while x < 10
# @example
#   # bad
#   until x > 10
#   x += 1
#   end
#
#   # good
#   x += 1 until x > 10
# @example
#   # bad
#   x += 100 while x < 500 # a long comment that makes code too long if it were a single line
#
#   # good
#   while x < 500 # a long comment that makes code too long if it were a single line
#   x += 100
#   end
class RuboCop::Cop::Style::WhileUntilModifier < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::LineLengthHelp
  include ::RuboCop::Cop::StatementModifier
  extend ::RuboCop::Cop::AutoCorrector

  def on_until(node); end
  def on_while(node); end
end

RuboCop::Cop::Style::WhileUntilModifier::MSG = T.let(T.unsafe(nil), String)

# Checks for array literals made up of word-like
# strings, that are not using the %w() syntax.
#
# Alternatively, it can check for uses of the %w() syntax, in projects
# which do not want to include that syntax.
#
# NOTE: When using the `percent` style, %w() arrays containing a space
# will be registered as offenses.
#
# Configuration option: MinSize
# If set, arrays with fewer elements than this value will not trigger the
# cop. For example, a `MinSize` of `3` will not enforce a style on an
# array of 2 or fewer elements.
#
# @example EnforcedStyle: percent (default)
#   # good
#   %w[foo bar baz]
#
#   # bad
#   ['foo', 'bar', 'baz']
#
#   # bad (contains spaces)
#   %w[foo\ bar baz\ quux]
# @example EnforcedStyle: brackets
#   # good
#   ['foo', 'bar', 'baz']
#
#   # bad
#   %w[foo bar baz]
#
#   # good (contains spaces)
#   ['foo bar', 'baz quux']
class RuboCop::Cop::Style::WordArray < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ArrayMinSize
  include ::RuboCop::Cop::ArraySyntax
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::PercentArray
  extend ::RuboCop::Cop::AutoCorrector

  def on_array(node); end

  private

  def build_bracketed_array(node); end

  # @return [Boolean]
  def complex_content?(strings, complex_regex: T.unsafe(nil)); end

  # @return [Boolean]
  def invalid_percent_array_contents?(node); end

  def word_regex; end

  class << self
    # Returns the value of attribute largest_brackets.
    def largest_brackets; end

    # Sets the attribute largest_brackets
    #
    # @param value the value to set the attribute largest_brackets to.
    def largest_brackets=(_arg0); end
  end
end

RuboCop::Cop::Style::WordArray::ARRAY_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::WordArray::PERCENT_MSG = T.let(T.unsafe(nil), String)

# Enforces or forbids Yoda conditions,
# i.e. comparison operations where the order of expression is reversed.
# eg. `5 == x`
#
# @example EnforcedStyle: forbid_for_all_comparison_operators (default)
#   # bad
#   99 == foo
#   "bar" != foo
#   42 >= foo
#   10 < bar
#
#   # good
#   foo == 99
#   foo == "bar"
#   foo <= 42
#   bar > 10
#   "#{interpolation}" == foo
#   /#{interpolation}/ == foo
# @example EnforcedStyle: forbid_for_equality_operators_only
#   # bad
#   99 == foo
#   "bar" != foo
#
#   # good
#   99 >= foo
#   3 < a && a < 5
# @example EnforcedStyle: require_for_all_comparison_operators
#   # bad
#   foo == 99
#   foo == "bar"
#   foo <= 42
#   bar > 10
#
#   # good
#   99 == foo
#   "bar" != foo
#   42 >= foo
#   10 < bar
# @example EnforcedStyle: require_for_equality_operators_only
#   # bad
#   99 >= foo
#   3 < a && a < 5
#
#   # good
#   99 == foo
#   "bar" != foo
class RuboCop::Cop::Style::YodaCondition < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  def file_constant_equal_program_name?(param0 = T.unsafe(nil)); end
  def on_send(node); end

  private

  def actual_code_range(node); end
  def corrected_code(node); end

  # @return [Boolean]
  def enforce_yoda?; end

  # @return [Boolean]
  def equality_only?; end

  # @return [Boolean]
  def interpolation?(node); end

  def message(node); end

  # @return [Boolean]
  def non_equality_operator?(node); end

  # @return [Boolean]
  def noncommutative_operator?(node); end

  # @return [Boolean]
  def program_name?(name); end

  def reverse_comparison(operator); end

  # @return [Boolean]
  def source_file_path_constant?(node); end

  # @return [Boolean]
  def valid_yoda?(node); end

  # @return [Boolean]
  def yoda_compatible_condition?(node); end
end

RuboCop::Cop::Style::YodaCondition::EQUALITY_OPERATORS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::YodaCondition::MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::YodaCondition::NONCOMMUTATIVE_OPERATORS = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::YodaCondition::PROGRAM_NAMES = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::YodaCondition::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Set)
RuboCop::Cop::Style::YodaCondition::REVERSE_COMPARISON = T.let(T.unsafe(nil), Hash)

# Checks for numeric comparisons that can be replaced
# by a predicate method, such as receiver.length == 0,
# receiver.length > 0, receiver.length != 0,
# receiver.length < 1 and receiver.size == 0 that can be
# replaced by receiver.empty? and !receiver.empty?.
#
# @example
#   # bad
#   [1, 2, 3].length == 0
#   0 == "foobar".length
#   array.length < 1
#   {a: 1, b: 2}.length != 0
#   string.length > 0
#   hash.size > 0
#
#   # good
#   [1, 2, 3].empty?
#   "foobar".empty?
#   array.empty?
#   !{a: 1, b: 2}.empty?
#   !string.empty?
#   !hash.empty?
class RuboCop::Cop::Style::ZeroLengthPredicate < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # Some collection like objects in the Ruby standard library
  # implement `#size`, but not `#empty`. We ignore those to
  # reduce false positives.
  def non_polymorphic_collection?(param0 = T.unsafe(nil)); end

  def nonzero_length_predicate(param0 = T.unsafe(nil)); end
  def on_send(node); end
  def other_receiver(param0 = T.unsafe(nil)); end
  def zero_length_predicate(param0 = T.unsafe(nil)); end
  def zero_length_receiver(param0 = T.unsafe(nil)); end

  private

  def check_nonzero_length_predicate(node); end
  def check_zero_length_predicate(node); end
  def replacement(node); end
end

RuboCop::Cop::Style::ZeroLengthPredicate::NONZERO_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::Style::ZeroLengthPredicate::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)
RuboCop::Cop::Style::ZeroLengthPredicate::ZERO_MSG = T.let(T.unsafe(nil), String)

# Common functionality for checking and correcting surrounding whitespace.
module RuboCop::Cop::SurroundingSpace
  include ::RuboCop::Cop::RangeHelp

  private

  # @return [Boolean]
  def empty_brackets?(left_bracket_token, right_bracket_token); end

  def empty_offense(node, range, message, command); end
  def empty_offenses(node, left, right, message); end

  # @return [Boolean]
  def extra_space?(token, side); end

  # @return [Boolean]
  def no_space_between?(left_bracket_token, right_bracket_token); end

  def no_space_offenses(node, left_token, right_token, message, start_ok: T.unsafe(nil), end_ok: T.unsafe(nil)); end

  # @return [Boolean]
  def offending_empty_no_space?(config, left_token, right_token); end

  # @return [Boolean]
  def offending_empty_space?(config, left_token, right_token); end

  def on_new_investigation; end
  def reposition(src, pos, step); end
  def side_space_range(range:, side:); end

  # @return [Boolean]
  def space_between?(left_bracket_token, right_bracket_token); end

  def space_offense(node, token, side, message, command); end
  def space_offenses(node, left_token, right_token, message, start_ok: T.unsafe(nil), end_ok: T.unsafe(nil)); end
end

RuboCop::Cop::SurroundingSpace::NO_SPACE_COMMAND = T.let(T.unsafe(nil), String)
RuboCop::Cop::SurroundingSpace::SINGLE_SPACE_REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::SurroundingSpace::SPACE_COMMAND = T.let(T.unsafe(nil), String)

# Classes that include this module just implement functions for working
# with symbol nodes.
module RuboCop::Cop::SymbolHelp
  # @return [Boolean]
  def hash_key?(node); end
end

# Common functionality for checking target ruby version.
module RuboCop::Cop::TargetRubyVersion
  def minimum_target_ruby_version(version); end
  def required_minimum_ruby_version; end

  # @return [Boolean]
  def support_target_ruby_version?(version); end
end

# A group of cops, ready to be called on duty to inspect files.
# Team is responsible for selecting only relevant cops to be sent on duty,
# as well as insuring that the needed forces are sent along with them.
#
# For performance reasons, Team will first dispatch cops & forces in two groups,
# first the ones needed for autocorrection (if any), then the rest
# (unless autocorrections happened).
class RuboCop::Cop::Team
  # @return [Team] a new instance of Team
  def initialize(cops, config = T.unsafe(nil), options = T.unsafe(nil)); end

  # @return [Boolean]
  def autocorrect?; end

  # Returns the value of attribute cops.
  def cops; end

  # @return [Boolean]
  def debug?; end

  # Returns the value of attribute errors.
  def errors; end

  def external_dependency_checksum; end

  # @deprecated
  def forces; end

  def inspect_file(processed_source); end

  # @return [Commissioner::InvestigationReport]
  def investigate(processed_source); end

  # Returns the value of attribute updated_source_file.
  def updated_source_file; end

  # Returns the value of attribute updated_source_file.
  def updated_source_file?; end

  # Returns the value of attribute warnings.
  def warnings; end

  private

  def autocorrect(processed_source, report); end
  def autocorrect_report(report); end
  def be_ready; end
  def collate_corrections(report); end
  def each_corrector(report); end
  def handle_error(error, location, cop); end
  def handle_warning(error, location); end

  # @return [Commissioner::InvestigationReport]
  def investigate_partial(cops, processed_source); end

  def process_errors(file, errors); end
  def reset; end

  # @return [Array<cop>]
  def roundup_relevant_cops(filename); end

  # @return [Boolean]
  def support_target_rails_version?(cop); end

  # @return [Boolean]
  def support_target_ruby_version?(cop); end

  def suppress_clobbering; end
  def validate_config; end

  class << self
    # @return [Array<Force>] needed for the given cops
    def forces_for(cops); end

    # @return [Team] with cops assembled from the given `cop_classes`
    def mobilize(cop_classes, config, options = T.unsafe(nil)); end

    # @return [Array<Cop::Cop>]
    def mobilize_cops(cop_classes, config, options = T.unsafe(nil)); end

    # @return [Team]
    def new(cop_or_classes, config, options = T.unsafe(nil)); end
  end
end

# Common methods shared by TrailingBody cops
module RuboCop::Cop::TrailingBody
  # @return [Boolean]
  def body_on_first_line?(node, body); end

  def first_part_of(body); end

  # @return [Boolean]
  def trailing_body?(node); end
end

# Common methods shared by Style/TrailingCommaInArguments and
# Style/TrailingCommaInLiteral
module RuboCop::Cop::TrailingComma
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  include ::RuboCop::Cop::RangeHelp

  private

  # A single argument with the closing bracket on the same line as the end
  # of the argument is not considered multiline, even if the argument
  # itself might span multiple lines.
  #
  # @return [Boolean]
  def allowed_multiline_argument?(node); end

  # @return [Boolean]
  def any_heredoc?(items); end

  def autocorrect_range(item); end
  def avoid_comma(kind, comma_begin_pos, extra_info); end

  # Returns true if the node has round/square/curly brackets.
  #
  # @return [Boolean]
  def brackets?(node); end

  def check(node, items, kind, begin_pos, end_pos); end
  def check_comma(node, kind, comma_pos); end
  def check_literal(node, kind); end
  def comma_offset(items, range); end
  def elements(node); end
  def extra_avoid_comma_info; end

  # @return [Boolean]
  def heredoc?(node); end

  # @return [Boolean]
  def heredoc_send?(node); end

  # @return [Boolean]
  def inside_comment?(range, comma_offset); end

  # @return [Boolean]
  def method_name_and_arguments_on_same_line?(node); end

  # Returns true if the round/square/curly brackets of the given node are
  # on different lines, each item within is on its own line, and the
  # closing bracket is on its own line.
  #
  # @return [Boolean]
  def multiline?(node); end

  # @return [Boolean]
  def no_elements_on_same_line?(node); end

  # @return [Boolean]
  def on_same_line?(range1, range2); end

  def put_comma(items, kind); end

  # @return [Boolean]
  def should_have_comma?(style, node); end

  def style_parameter_name; end
end

RuboCop::Cop::TrailingComma::MSG = T.let(T.unsafe(nil), String)

# Common functionality shared by Uncommunicative cops
module RuboCop::Cop::UncommunicativeName
  def check(node, args); end

  private

  def allow_nums; end
  def allowed_names; end
  def arg_range(arg, length); end
  def case_offense(node, range); end

  # @return [Boolean]
  def ends_with_num?(name); end

  def forbidden_names; end
  def forbidden_offense(node, range, name); end
  def issue_offenses(node, range, name); end
  def length_offense(node, range); end

  # @return [Boolean]
  def long_enough?(name); end

  def min_length; end
  def name_type(node); end
  def num_offense(node, range); end

  # @return [Boolean]
  def uppercase?(name); end
end

RuboCop::Cop::UncommunicativeName::CASE_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::UncommunicativeName::FORBIDDEN_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::UncommunicativeName::LENGTH_MSG = T.let(T.unsafe(nil), String)
RuboCop::Cop::UncommunicativeName::NUM_MSG = T.let(T.unsafe(nil), String)

# This autocorrects unused arguments.
class RuboCop::Cop::UnusedArgCorrector
  extend ::RuboCop::Cop::RangeHelp

  class << self
    def correct(corrector, processed_source, node); end
    def correct_for_blockarg_type(corrector, node); end

    # Returns the value of attribute processed_source.
    def processed_source; end
  end
end

# This module contains a collection of useful utility methods.
module RuboCop::Cop::Util
  include ::RuboCop::PathUtil

  private

  def add_parentheses(node, corrector); end
  def args_begin(node); end
  def args_end(node); end
  def begins_its_line?(range); end

  # This is a bad API
  def comment_line?(line_source); end

  # @deprecated Use `ProcessedSource#line_with_comment?`, `contains_comment?` or similar
  def comment_lines?(node); end

  def compatible_external_encoding_for?(src); end

  # If converting a string to Ruby string literal source code, must
  # double quotes be used?
  def double_quotes_required?(string); end

  def escape_string(string); end

  # Returns, for example, a bare `if` node if the given node is an `if`
  # with calls chained to the end of it.
  def first_part_of_call_chain(node); end

  def indent(node, offset: T.unsafe(nil)); end
  def interpret_string_escapes(string); end
  def line(node_or_range); end
  def line_range(node); end
  def needs_escaping?(string); end
  def on_node(syms, sexp, excludes = T.unsafe(nil), &block); end
  def parentheses?(node); end
  def same_line?(node1, node2); end
  def to_string_literal(string); end
  def to_supported_styles(enforced_style); end
  def trim_string_interpolation_escape_character(str); end

  class << self
    def add_parentheses(node, corrector); end
    def args_begin(node); end
    def args_end(node); end

    # @return [Boolean]
    def begins_its_line?(range); end

    # This is a bad API
    #
    # @return [Boolean]
    def comment_line?(line_source); end

    # @deprecated Use `ProcessedSource#line_with_comment?`, `contains_comment?` or similar
    # @return [Boolean]
    def comment_lines?(node); end

    # If converting a string to Ruby string literal source code, must
    # double quotes be used?
    #
    # @return [Boolean]
    def double_quotes_required?(string); end

    def escape_string(string); end

    # Returns, for example, a bare `if` node if the given node is an `if`
    # with calls chained to the end of it.
    def first_part_of_call_chain(node); end

    def indent(node, offset: T.unsafe(nil)); end
    def interpret_string_escapes(string); end
    def line(node_or_range); end
    def line_range(node); end

    # @return [Boolean]
    def needs_escaping?(string); end

    # @yield [sexp]
    def on_node(syms, sexp, excludes = T.unsafe(nil), &block); end

    # @return [Boolean]
    def parentheses?(node); end

    # @return [Boolean]
    def same_line?(node1, node2); end

    def to_string_literal(string); end
    def to_supported_styles(enforced_style); end
    def trim_string_interpolation_escape_character(str); end
  end
end

# Match literal regex characters, not including anchors, character
# classes, alternatives, groups, repetitions, references, etc
RuboCop::Cop::Util::LITERAL_REGEX = T.let(T.unsafe(nil), Regexp)

module RuboCop::Cop::Utils; end

# Parses {Kernel#sprintf} format strings.
class RuboCop::Cop::Utils::FormatString
  # @return [FormatString] a new instance of FormatString
  def initialize(string); end

  def format_sequences; end
  def max_digit_dollar_num; end

  # @return [Boolean]
  def named_interpolation?; end

  # @return [Boolean]
  def valid?; end

  private

  # @return [Boolean]
  def mixed_formats?; end

  def parse; end
end

RuboCop::Cop::Utils::FormatString::DIGIT_DOLLAR = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::FLAG = T.let(T.unsafe(nil), Regexp)

# The syntax of a format sequence is as follows.
#
# ```
# %[flags][width][.precision]type
# ```
#
# A format sequence consists of a percent sign, followed by optional
# flags, width, and precision indicators, then terminated with a field
# type character.
#
# For more complex formatting, Ruby supports a reference by name.
#
# @see https://ruby-doc.org/core-2.6.3/Kernel.html#method-i-format
class RuboCop::Cop::Utils::FormatString::FormatSequence
  # @return [FormatSequence] a new instance of FormatSequence
  def initialize(match); end

  # @return [Boolean]
  def annotated?; end

  # Number of arguments required for the format sequence
  def arity; end

  # Returns the value of attribute begin_pos.
  def begin_pos; end

  # Returns the value of attribute end_pos.
  def end_pos; end

  # Returns the value of attribute flags.
  def flags; end

  def max_digit_dollar_num; end

  # Returns the value of attribute name.
  def name; end

  # @return [Boolean]
  def percent?; end

  # Returns the value of attribute precision.
  def precision; end

  def style; end

  # @return [Boolean]
  def template?; end

  # Returns the value of attribute type.
  def type; end

  # Returns the value of attribute width.
  def width; end
end

RuboCop::Cop::Utils::FormatString::NAME = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::NUMBER = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::NUMBER_ARG = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::PRECISION = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::SEQUENCE = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::TEMPLATE_NAME = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::TYPE = T.let(T.unsafe(nil), Regexp)
RuboCop::Cop::Utils::FormatString::WIDTH = T.let(T.unsafe(nil), Regexp)

# This force provides a way to track local variables and scopes of Ruby.
# Cops interact with this force need to override some of the hook methods.
#
#     def before_entering_scope(scope, variable_table)
#     end
#
#     def after_entering_scope(scope, variable_table)
#     end
#
#     def before_leaving_scope(scope, variable_table)
#     end
#
#     def after_leaving_scope(scope, variable_table)
#     end
#
#     def before_declaring_variable(variable, variable_table)
#     end
#
#     def after_declaring_variable(variable, variable_table)
#     end
#
# @api private
class RuboCop::Cop::VariableForce < ::RuboCop::Cop::Force
  # Starting point.
  #
  # @api private
  def investigate(processed_source); end

  # @api private
  def process_node(node); end

  # @api private
  def variable_table; end

  private

  def after_declaring_variable(arg); end
  def after_entering_scope(arg); end
  def after_leaving_scope(arg); end
  def before_declaring_variable(arg); end
  def before_entering_scope(arg); end
  def before_leaving_scope(arg); end

  # @api private
  def descendant_reference(node); end

  # @api private
  def each_descendant_reference(loop_node); end

  # @api private
  def find_variables_in_loop(loop_node); end

  # This is called for each scope recursively.
  #
  # @api private
  def inspect_variables_in_scope(scope_node); end

  # Mark all assignments which are referenced in the same loop
  # as referenced by ignoring AST order since they would be referenced
  # in next iteration.
  #
  # @api private
  def mark_assignments_as_referenced_in_loop(node); end

  # @api private
  def node_handler_method_name(node); end

  # @api private
  def process_children(origin_node); end

  # @api private
  def process_loop(node); end

  # @api private
  def process_regexp_named_captures(node); end

  # @api private
  def process_rescue(node); end

  # @api private
  def process_scope(node); end

  # @api private
  def process_send(node); end

  # @api private
  def process_variable_assignment(node); end

  # @api private
  def process_variable_declaration(node); end

  # @api private
  def process_variable_multiple_assignment(node); end

  # @api private
  def process_variable_operator_assignment(node); end

  # @api private
  def process_variable_referencing(node); end

  # @api private
  def process_zero_arity_super(node); end

  # @api private
  def regexp_captured_names(node); end

  # Use Node#equal? for accurate check.
  #
  # @api private
  # @return [Boolean]
  def scanned_node?(node); end

  # @api private
  def scanned_nodes; end

  # @api private
  def skip_children!; end

  # @api private
  def twisted_nodes(node); end
end

# @api private
RuboCop::Cop::VariableForce::ARGUMENT_DECLARATION_TYPES = T.let(T.unsafe(nil), Array)

# This class represents each assignment of a variable.
class RuboCop::Cop::VariableForce::Assignment
  include ::RuboCop::Cop::VariableForce::Branchable

  # @return [Assignment] a new instance of Assignment
  def initialize(node, variable); end

  def meta_assignment_node; end

  # @return [Boolean]
  def multiple_assignment?; end

  def name; end

  # Returns the value of attribute node.
  def node; end

  def operator; end

  # @return [Boolean]
  def operator_assignment?; end

  def reference!(node); end

  # Returns the value of attribute referenced.
  def referenced; end

  # Returns the value of attribute referenced.
  def referenced?; end

  # Returns the value of attribute references.
  def references; end

  # @return [Boolean]
  def regexp_named_capture?; end

  def scope; end

  # @return [Boolean]
  def used?; end

  # Returns the value of attribute variable.
  def variable; end

  private

  def multiple_assignment_node; end
  def operator_assignment_node; end
end

RuboCop::Cop::VariableForce::Assignment::MULTIPLE_LEFT_HAND_SIDE_TYPE = T.let(T.unsafe(nil), Symbol)

# @api private
class RuboCop::Cop::VariableForce::AssignmentReference < ::Struct
  # @api private
  # @return [Boolean]
  def assignment?; end

  # Returns the value of attribute node
  #
  # @return [Object] the current value of node
  def node; end

  # Sets the attribute node
  #
  # @param value [Object] the value to set the attribute node to.
  # @return [Object] the newly set value
  def node=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Namespace for branch classes for each control structure.
module RuboCop::Cop::VariableForce::Branch
  class << self
    def of(target_node, scope: T.unsafe(nil)); end
  end
end

# left_body && right_body
class RuboCop::Cop::VariableForce::Branch::And < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::LogicalOperator

  def left_body?; end
  def right_body?; end
end

# Abstract base class for branch classes.
# A branch represents a conditional branch in a scope.
#
# @example
#   def some_scope
#   do_something     # no branch
#
#   if foo
#   do_something   # branch A
#   do_something   # branch A
#   else
#   do_something   # branch B
#   if bar
#   do_something # branch C (whose parent is branch B)
#   end
#   end
#
#   do_something     # no branch
#   end
class RuboCop::Cop::VariableForce::Branch::Base < ::Struct
  def ==(other); end

  # @raise [NotImplementedError]
  # @return [Boolean]
  def always_run?; end

  # @return [Boolean]
  def branched?; end

  # Returns the value of attribute child_node
  #
  # @return [Object] the current value of child_node
  def child_node; end

  # Sets the attribute child_node
  #
  # @param value [Object] the value to set the attribute child_node to.
  # @return [Object] the newly set value
  def child_node=(_); end

  def control_node; end

  # @yield [_self]
  # @yieldparam _self [RuboCop::Cop::VariableForce::Branch::Base] the object that the method was called on
  def each_ancestor(include_self: T.unsafe(nil), &block); end

  def eql?(other); end

  # @return [Boolean]
  def exclusive_with?(other); end

  def hash; end

  # @return [Boolean]
  def may_jump_to_other_branch?; end

  # @return [Boolean]
  def may_run_incompletely?; end

  def parent; end

  # Returns the value of attribute scope
  #
  # @return [Object] the current value of scope
  def scope; end

  # Sets the attribute scope
  #
  # @param value [Object] the value to set the attribute scope to.
  # @return [Object] the newly set value
  def scope=(_); end

  private

  def scan_ancestors; end

  class << self
    def [](*_arg0); end
    def classes; end
    def define_predicate(name, child_index: T.unsafe(nil)); end

    # @private
    def inherited(subclass); end

    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
    def type; end
  end
end

RuboCop::Cop::VariableForce::Branch::CLASSES_BY_TYPE = T.let(T.unsafe(nil), Hash)

# case target
# when /pattern/ # when_clause
# else
#   else_body
# end
class RuboCop::Cop::VariableForce::Branch::Case < ::RuboCop::Cop::VariableForce::Branch::Base
  # @return [Boolean]
  def always_run?; end

  def else_body?; end
  def target?; end
  def when_clause?; end
end

# case target
# in pattern # in_pattern
# else
#   else_body
# end
class RuboCop::Cop::VariableForce::Branch::CaseMatch < ::RuboCop::Cop::VariableForce::Branch::Base
  # @return [Boolean]
  def always_run?; end

  def else_body?; end
  def in_pattern?; end
  def target?; end
end

# begin
#     main_body
#   ensure
#     ensure_body
#   end
class RuboCop::Cop::VariableForce::Branch::Ensure < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::ExceptionHandler

  # @return [Boolean]
  def always_run?; end

  def ensure_body?; end
  def main_body?; end
end

# Mix-in module for exception handling control structures.
module RuboCop::Cop::VariableForce::Branch::ExceptionHandler
  # @return [Boolean]
  def may_jump_to_other_branch?; end

  # @return [Boolean]
  def may_run_incompletely?; end
end

# for element in collection
#   loop_body
# end
class RuboCop::Cop::VariableForce::Branch::For < ::RuboCop::Cop::VariableForce::Branch::Base
  # @return [Boolean]
  def always_run?; end

  def collection?; end
  def element?; end
  def loop_body?; end
end

# if conditional_clause
#   truthy_body
# else
#   falsey_body
# end
#
# unless conditional_clause
#   falsey_body
# else
#   truthy_body
# end
class RuboCop::Cop::VariableForce::Branch::If < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::SimpleConditional

  def conditional_clause?; end
  def falsey_body?; end
  def truthy_body?; end
end

# Mix-in module for logical operator control structures.
module RuboCop::Cop::VariableForce::Branch::LogicalOperator
  # @return [Boolean]
  def always_run?; end
end

# left_body || right_body
class RuboCop::Cop::VariableForce::Branch::Or < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::LogicalOperator

  def left_body?; end
  def right_body?; end
end

# begin
#     main_body
#   rescue StandardError => error # rescue_clause
#   else
#     else_body
#   end
class RuboCop::Cop::VariableForce::Branch::Rescue < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::ExceptionHandler

  # @return [Boolean]
  def always_run?; end

  def else_body?; end
  def main_body?; end
  def rescue_clause?; end
end

# Mix-in module for simple conditional control structures.
module RuboCop::Cop::VariableForce::Branch::SimpleConditional
  # @return [Boolean]
  def always_run?; end

  # @raise [NotImplementedError]
  # @return [Boolean]
  def conditional_clause?; end
end

# until conditional_clause
#   loop_body
# end
class RuboCop::Cop::VariableForce::Branch::Until < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::SimpleConditional

  def conditional_clause?; end
  def loop_body?; end
end

# begin
#   loop_body
# end until conditional_clause
class RuboCop::Cop::VariableForce::Branch::UntilPost < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::SimpleConditional

  def conditional_clause?; end
  def loop_body?; end
end

# while conditional_clause
#   loop_body
# end
class RuboCop::Cop::VariableForce::Branch::While < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::SimpleConditional

  def conditional_clause?; end
  def loop_body?; end
end

# begin
#   loop_body
# end while conditional_clause
class RuboCop::Cop::VariableForce::Branch::WhilePost < ::RuboCop::Cop::VariableForce::Branch::Base
  include ::RuboCop::Cop::VariableForce::Branch::SimpleConditional

  def conditional_clause?; end
  def loop_body?; end
end

# Mix-in module for classes which own a node and need branch information
# of the node. The user classes must implement #node and #scope.
module RuboCop::Cop::VariableForce::Branchable
  def branch; end

  # @return [Boolean]
  def run_exclusively_with?(other); end
end

# @api private
RuboCop::Cop::VariableForce::LOGICAL_OPERATOR_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::LOOP_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::MULTIPLE_ASSIGNMENT_TYPE = T.let(T.unsafe(nil), Symbol)

# @api private
RuboCop::Cop::VariableForce::OPERATOR_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::POST_CONDITION_LOOP_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::REGEXP_NAMED_CAPTURE_TYPE = T.let(T.unsafe(nil), Symbol)

# @api private
RuboCop::Cop::VariableForce::RESCUE_TYPE = T.let(T.unsafe(nil), Symbol)

# This class represents each reference of a variable.
class RuboCop::Cop::VariableForce::Reference
  include ::RuboCop::Cop::VariableForce::Branchable

  # @return [Reference] a new instance of Reference
  def initialize(node, scope); end

  # There's an implicit variable reference by the zero-arity `super`:
  #
  #     def some_method(foo)
  #       super
  #     end
  #
  # Another case is `binding`:
  #
  #     def some_method(foo)
  #       do_something(binding)
  #     end
  #
  # In these cases, the variable `foo` is not explicitly referenced,
  # but it can be considered used implicitly by the `super` or `binding`.
  #
  # @return [Boolean]
  def explicit?; end

  # Returns the value of attribute node.
  def node; end

  # Returns the value of attribute scope.
  def scope; end
end

RuboCop::Cop::VariableForce::Reference::VARIABLE_REFERENCE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::SCOPE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::SEND_TYPE = T.let(T.unsafe(nil), Symbol)

# A Scope represents a context of local variable visibility.
# This is a place where local variables belong to.
# A scope instance holds a scope node and variable entries.
class RuboCop::Cop::VariableForce::Scope
  # @return [Scope] a new instance of Scope
  def initialize(node); end

  def ==(other); end
  def body_node; end

  # @yield [node]
  def each_node(&block); end

  # @return [Boolean]
  def include?(target_node); end

  # Returns the value of attribute naked_top_level.
  def naked_top_level; end

  # Returns the value of attribute naked_top_level.
  def naked_top_level?; end

  def name; end

  # Returns the value of attribute node.
  def node; end

  # Returns the value of attribute variables.
  def variables; end

  private

  # @return [Boolean]
  def ancestor_node?(target_node); end

  # @return [Boolean]
  def belong_to_inner_scope?(target_node); end

  # @return [Boolean]
  def belong_to_outer_scope?(target_node); end

  def scan_node(node, &block); end
end

RuboCop::Cop::VariableForce::Scope::OUTER_SCOPE_CHILD_INDICES = T.let(T.unsafe(nil), Hash)

# @api private
RuboCop::Cop::VariableForce::TWISTED_SCOPE_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::VARIABLE_ASSIGNMENT_TYPE = T.let(T.unsafe(nil), Symbol)

# @api private
RuboCop::Cop::VariableForce::VARIABLE_ASSIGNMENT_TYPES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Cop::VariableForce::VARIABLE_REFERENCE_TYPE = T.let(T.unsafe(nil), Symbol)

# A Variable represents existence of a local variable.
# This holds a variable declaration node and some states of the variable.
class RuboCop::Cop::VariableForce::Variable
  # @return [Variable] a new instance of Variable
  def initialize(name, declaration_node, scope); end

  # @return [Boolean]
  def argument?; end

  def assign(node); end

  # Returns the value of attribute assignments.
  def assignments; end

  # @return [Boolean]
  def block_argument?; end

  def capture_with_block!; end

  # Returns the value of attribute captured_by_block.
  def captured_by_block; end

  # Returns the value of attribute captured_by_block.
  def captured_by_block?; end

  # Returns the value of attribute declaration_node.
  def declaration_node; end

  # @return [Boolean]
  def explicit_block_local_variable?; end

  # @return [Boolean]
  def in_modifier_if?(assignment); end

  # @return [Boolean]
  def keyword_argument?; end

  # @return [Boolean]
  def method_argument?; end

  # Returns the value of attribute name.
  def name; end

  def reference!(node); end

  # @return [Boolean]
  def referenced?; end

  # Returns the value of attribute references.
  def references; end

  # Returns the value of attribute scope.
  def scope; end

  # @return [Boolean]
  def should_be_unused?; end

  # This is a convenient way to check whether the variable is used
  # in its entire variable lifetime.
  # For more precise usage check, refer Assignment#used?.
  #
  # Once the variable is captured by a block, we have no idea
  # when, where, and how many times the block would be invoked.
  # This means we cannot track the usage of the variable.
  # So we consider it's used to suppress false positive offenses.
  #
  # @return [Boolean]
  def used?; end
end

RuboCop::Cop::VariableForce::Variable::VARIABLE_DECLARATION_TYPES = T.let(T.unsafe(nil), Array)

# @api private
class RuboCop::Cop::VariableForce::VariableReference < ::Struct
  # @api private
  # @return [Boolean]
  def assignment?; end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# A VariableTable manages the lifetime of all scopes and local variables
# in a program.
# This holds scopes as stack structure, provides a way to add local
# variables to current scope, and find local variables by considering
# variable visibility of the current scope.
class RuboCop::Cop::VariableForce::VariableTable
  # @return [VariableTable] a new instance of VariableTable
  def initialize(hook_receiver = T.unsafe(nil)); end

  def accessible_variables; end
  def assign_to_variable(name, node); end
  def current_scope; end
  def current_scope_level; end
  def declare_variable(name, node); end
  def find_variable(name); end
  def invoke_hook(hook_name, *args); end
  def pop_scope; end
  def push_scope(scope_node); end
  def reference_variable(name, node); end
  def scope_stack; end

  # @return [Boolean]
  def variable_exist?(name); end

  private

  def mark_variable_as_captured_by_block_if_so(variable); end
end

# @api private
RuboCop::Cop::VariableForce::ZERO_ARITY_SUPER_TYPE = T.let(T.unsafe(nil), Symbol)

# Help methods for determining node visibility.
module RuboCop::Cop::VisibilityHelp
  extend ::RuboCop::AST::NodePattern::Macros

  def visibility_block?(param0 = T.unsafe(nil)); end

  private

  # Navigate to find the last protected method
  def find_visibility_end(node); end

  def find_visibility_start(node); end
  def node_visibility(node); end
end

RuboCop::Cop::VisibilityHelp::VISIBILITY_SCOPES = T.let(T.unsafe(nil), Array)

# This class wraps the `Parser::Source::Comment` object that represents a
# cops it contains.
class RuboCop::DirectiveComment
  # @return [DirectiveComment] a new instance of DirectiveComment
  def initialize(comment, cop_registry = T.unsafe(nil)); end

  # Checks if all cops specified in this directive
  #
  # @return [Boolean]
  def all_cops?; end

  # Returns the value of attribute comment.
  def comment; end

  # Returns array of specified in this directive cop names
  def cop_names; end

  # Returns the value of attribute cop_registry.
  def cop_registry; end

  # Returns the value of attribute cops.
  def cops; end

  # Returns array of specified in this directive department names
  # when all department disabled
  def department_names; end

  def directive_count; end

  # Checks if this directive disables cops
  #
  # @return [Boolean]
  def disabled?; end

  # Checks if this directive disables all cops
  #
  # @return [Boolean]
  def disabled_all?; end

  # Checks if this directive enables cops
  #
  # @return [Boolean]
  def enabled?; end

  # Checks if this directive enables all cops
  #
  # @return [Boolean]
  def enabled_all?; end

  # Checks if directive departments include cop
  #
  # @return [Boolean]
  def in_directive_department?(cop); end

  # Returns line number for directive
  def line_number; end

  # Checks if this directive contains all the given cop names
  #
  # @return [Boolean]
  def match?(cop_names); end

  # Returns match captures to directive comment pattern
  def match_captures; end

  # Returns the value of attribute mode.
  def mode; end

  # Checks if cop department has already used in directive comment
  #
  # @return [Boolean]
  def overridden_by_department?(cop); end

  def range; end

  # Checks if this directive relates to single line
  #
  # @return [Boolean]
  def single_line?; end

  private

  def all_cop_names; end
  def cop_names_for_department(department); end

  # @return [Boolean]
  def department?(name); end

  def exclude_redundant_directive_cop(cops); end
  def parsed_cop_names; end
  def splitted_cops_string; end

  class << self
    def before_comment(line); end
  end
end

# @api private
RuboCop::DirectiveComment::COPS_PATTERN = T.let(T.unsafe(nil), String)

# @api private
RuboCop::DirectiveComment::COP_NAMES_PATTERN = T.let(T.unsafe(nil), String)

# @api private
RuboCop::DirectiveComment::COP_NAME_PATTERN = T.let(T.unsafe(nil), String)

# @api private
RuboCop::DirectiveComment::DIRECTIVE_COMMENT_REGEXP = T.let(T.unsafe(nil), Regexp)

# @api private
RuboCop::DirectiveComment::REDUNDANT_DIRECTIVE_COP = T.let(T.unsafe(nil), String)

# @api private
RuboCop::DirectiveComment::REDUNDANT_DIRECTIVE_COP_DEPARTMENT = T.let(T.unsafe(nil), String)

# An Error exception is different from an Offense with severity 'error'
# When this exception is raised, it means that RuboCop is unable to perform
# a requested action (probably due to misconfiguration) and must stop
# immediately, rather than carrying on
class RuboCop::Error < ::StandardError; end

# A wrapper to display errored location of analyzed file.
class RuboCop::ErrorWithAnalyzedFileLocation < ::RuboCop::Error
  # @return [ErrorWithAnalyzedFileLocation] a new instance of ErrorWithAnalyzedFileLocation
  def initialize(cause:, node:, cop:); end

  # Returns the value of attribute cause.
  def cause; end

  def column; end

  # Returns the value of attribute cop.
  def cop; end

  def line; end
  def message; end
end

# Allows specified configuration options to have an exclude limit
# ie. a maximum value tracked that it can be used by `--auto-gen-config`.
module RuboCop::ExcludeLimit
  # Sets up a configuration option to have an exclude limit tracked.
  # The parameter name given is transformed into a method name (eg. `Max`
  # becomes `self.max=` and `MinDigits` becomes `self.min_digits=`).
  def exclude_limit(parameter_name, method_name: T.unsafe(nil)); end

  private

  def transform(parameter_name); end
end

module RuboCop::Ext; end

# Extensions to AST::ProcessedSource for our cached comment_config
module RuboCop::Ext::ProcessedSource
  def comment_config; end
  def disabled_line_ranges; end
end

# Extensions to Parser::Source::Range
module RuboCop::Ext::Range
  # Adds `Range#single_line?` to parallel `Node#single_line?`
  #
  # @return [Boolean]
  def single_line?; end
end

# Extensions to AST::RegexpNode for our cached parsed regexp info
module RuboCop::Ext::RegexpNode
  # Please remove this `else` branch when support for regexp_parser 1.8 will be dropped.
  # It's for compatibility with regexp_arser 1.8 and will never be maintained.
  def assign_properties(*_arg0); end

  def each_capture(named: T.unsafe(nil)); end

  # Note: we extend Regexp nodes to provide `loc` and `expression`
  # see `ext/regexp_parser`.
  #
  # @return [Regexp::Expression::Root, nil]
  def parsed_tree; end

  private

  def with_interpolations_blanked; end
end

RuboCop::Ext::RegexpNode::ANY = T.let(T.unsafe(nil), Object)

# Extensions for `regexp_parser` gem
module RuboCop::Ext::RegexpParser; end

module RuboCop::Ext::RegexpParser::Expression; end

# Add `expression` and `loc` to all `regexp_parser` nodes
module RuboCop::Ext::RegexpParser::Expression::Base
  # Shortcut to `loc.expression`
  def expression; end

  # E.g.
  #     [a-z]{2,}
  #     ^^^^^^^^^ expression
  #          ^^^^ quantifier
  #     ^^^^^     body
  #     ^         begin
  #         ^     end
  #
  # Please open issue if you need other locations
  def loc; end

  # Returns the value of attribute origin.
  def origin; end

  # Sets the attribute origin
  #
  # @param value the value to set the attribute origin to.
  def origin=(_arg0); end

  private

  def build_location; end
end

# Provide `CharacterSet` with `begin` and `end` locations.
module RuboCop::Ext::RegexpParser::Expression::CharacterSet
  def build_location; end
end

# Source map for RegexpParser nodes
class RuboCop::Ext::RegexpParser::Map < ::Parser::Source::Map
  # @return [Map] a new instance of Map
  def initialize(expression, body:, quantifier: T.unsafe(nil), begin_l: T.unsafe(nil), end_l: T.unsafe(nil)); end

  # Returns the value of attribute begin.
  def begin; end

  # Returns the value of attribute body.
  def body; end

  # Returns the value of attribute end.
  def end; end

  # Returns the value of attribute quantifier.
  def quantifier; end
end

# This class handles loading files (a.k.a. features in Ruby) specified
# by `--require` command line option and `require` directive in the config.
#
# Normally, the given string is directly passed to `require`. If a string
# beginning with `.` is given, it is assumed to be relative to the given
# directory.
#
# If a string containing `-` is given, it will be used as is, but if we
# cannot find the file to load, we will replace `-` with `/` and try it
# again as when Bundler loads gems.
#
# @api private
class RuboCop::FeatureLoader
  # @api private
  # @param config_directory_path [String]
  # @param feature [String]
  # @return [FeatureLoader] a new instance of FeatureLoader
  def initialize(config_directory_path:, feature:); end

  # @api private
  def load; end

  private

  # @api private
  # @return [String]
  def namespaced_feature; end

  # @api private
  # @return [String]
  def namespaced_target; end

  # @api private
  # @param [String]
  # @return [String]
  def relative(feature); end

  # @api private
  # @return [Boolean]
  def relative?; end

  # @api private
  # @param error [LoadError]
  # @return [Boolean]
  def seems_cannot_load_such_file_error?(error); end

  # @api private
  # @return [String]
  def target; end

  class << self
    # @api private
    # @param config_directory_path [String]
    # @param feature [String]
    def load(config_directory_path:, feature:); end
  end
end

# Common methods for finding files.
#
# @api private
module RuboCop::FileFinder
  # @api private
  def find_file_upwards(filename, start_dir, stop_dir = T.unsafe(nil)); end

  # @api private
  def find_last_file_upwards(filename, start_dir, stop_dir = T.unsafe(nil)); end

  private

  # @api private
  def traverse_files_upwards(filename, start_dir, stop_dir); end

  class << self
    # @api private
    def root_level=(level); end

    # @api private
    # @return [Boolean]
    def root_level?(path, stop_dir); end
  end
end

module RuboCop::Formatter; end

# Does not show individual offenses in the console.
class RuboCop::Formatter::AutoGenConfigFormatter < ::RuboCop::Formatter::ProgressFormatter
  def finished(inspected_files); end
end

# Abstract base class for formatter, implements all public API methods.
#
# ## Creating Custom Formatter
#
# You can create a custom formatter by subclassing
# `RuboCop::Formatter::BaseFormatter` and overriding some methods
# or by implementing all the methods by duck typing.
#
# ## Using Custom Formatter in Command Line
#
# You can tell RuboCop to use your custom formatter with a combination of
# `--format` and `--require` option.
# For example, when you have defined `MyCustomFormatter` in
# `./path/to/my_custom_formatter.rb`, you would type this command:
#
#     rubocop --require ./path/to/my_custom_formatter --format MyCustomFormatter
#
# Note: The path passed to `--require` is directly passed to
# `Kernel.require`.
# If your custom formatter file is not in `$LOAD_PATH`,
# you need to specify the path as relative path prefixed with `./`
# explicitly or absolute path.
#
# ## Method Invocation Order
#
# For example, when RuboCop inspects 2 files,
# the invocation order should be like this:
#
# * `#initialize`
# * `#started`
# * `#file_started`
# * `#file_finished`
# * `#file_started`
# * `#file_finished`
# * `#finished`
class RuboCop::Formatter::BaseFormatter
  # @api public
  # @param output [IO] `$stdout` or opened file
  # @return [BaseFormatter] a new instance of BaseFormatter
  def initialize(output, options = T.unsafe(nil)); end

  # Invoked at the end of inspecting each files.
  #
  # @api public
  # @param file [String] the file path
  # @param offenses [Array(RuboCop::Cop::Offense)] all detected offenses for the file
  # @return [void]
  # @see RuboCop::Cop::Offense
  def file_finished(file, offenses); end

  # Invoked at the beginning of inspecting each files.
  #
  # @api public
  # @param file [String] the file path
  # @param options [Hash] file specific information, currently this is always empty.
  # @return [void]
  def file_started(file, options); end

  # Invoked after all files are inspected or interrupted by user.
  #
  # @api public
  # @param inspected_files [Array(String)] the inspected file paths.
  #   This would be same as `target_files` passed to `#started`
  #   unless RuboCop is interrupted by user.
  # @return [void]
  def finished(inspected_files); end

  # @api public
  # @return [Hash]
  def options; end

  # @api public
  # @return [IO] the IO object passed to `#initialize`
  # @see #initialize
  def output; end

  # Invoked once before any files are inspected.
  #
  # @api public
  # @param target_files [Array(String)] all target file paths to be inspected
  # @return [void]
  def started(target_files); end
end

# This formatter formats report data in clang style.
# The precise location of the problem is shown together with the
# relevant source code.
class RuboCop::Formatter::ClangStyleFormatter < ::RuboCop::Formatter::SimpleTextFormatter
  def report_file(file, offenses); end

  private

  def report_highlighted_area(highlighted_area); end
  def report_line(location); end
  def report_offense(file, offense); end

  # @return [Boolean]
  def valid_line?(offense); end
end

RuboCop::Formatter::ClangStyleFormatter::ELLIPSES = T.let(T.unsafe(nil), String)

# This mix-in module provides string coloring methods for terminals.
# It automatically disables coloring if coloring is disabled in the process
# globally or the formatter's output is not a terminal.
module RuboCop::Formatter::Colorizable
  def black(string); end
  def blue(string); end
  def colorize(string, *args); end
  def cyan(string); end
  def green(string); end
  def magenta(string); end
  def rainbow; end
  def red(string); end
  def white(string); end
  def yellow(string); end
end

# This formatter displays a YAML configuration file where all cops that
# detected any offenses are configured to not detect the offense.
class RuboCop::Formatter::DisabledConfigFormatter < ::RuboCop::Formatter::BaseFormatter
  include ::RuboCop::PathUtil

  # @return [DisabledConfigFormatter] a new instance of DisabledConfigFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def file_finished(file, offenses); end
  def file_started(_file, _file_info); end
  def finished(_inspected_files); end

  private

  def command; end
  def cop_config_params(default_cfg, cfg); end
  def default_config(cop_name); end
  def excludes(offending_files, cop_name, parent); end

  # @return [Boolean]
  def merge_mode_for_exclude?(cfg); end

  def output_cop(cop_name, offense_count); end
  def output_cop_comments(output_buffer, cfg, cop_name, offense_count); end
  def output_cop_config(output_buffer, cfg, cop_name); end
  def output_cop_param_comments(output_buffer, params, default_cfg); end
  def output_exclude_list(output_buffer, offending_files, cop_name); end
  def output_exclude_path(output_buffer, exclude_path, parent); end
  def output_offending_files(output_buffer, cfg, cop_name); end
  def output_offenses; end

  # @return [Boolean]
  def safe_autocorrect?(config); end

  def set_max(cfg, cop_name); end

  # @return [Boolean]
  def show_offense_counts?; end

  # @return [Boolean]
  def show_timestamp?; end

  # @return [Boolean]
  def supports_safe_autocorrect?(cop_class, default_cfg); end

  # @return [Boolean]
  def supports_unsafe_autocorrect?(cop_class, default_cfg); end

  def timestamp; end

  class << self
    # Returns the value of attribute config_to_allow_offenses.
    def config_to_allow_offenses; end

    # Sets the attribute config_to_allow_offenses
    #
    # @param value the value to set the attribute config_to_allow_offenses to.
    def config_to_allow_offenses=(_arg0); end

    # Returns the value of attribute detected_styles.
    def detected_styles; end

    # Sets the attribute detected_styles
    #
    # @param value the value to set the attribute detected_styles to.
    def detected_styles=(_arg0); end
  end
end

RuboCop::Formatter::DisabledConfigFormatter::HEADING = T.let(T.unsafe(nil), String)

# This formatter displays the report data in format that's
# easy to process in the Emacs text editor.
# The output is machine-parsable.
class RuboCop::Formatter::EmacsStyleFormatter < ::RuboCop::Formatter::BaseFormatter
  def file_finished(file, offenses); end

  private

  def message(offense); end
end

# This formatter displays just a list of the files with offenses in them,
# separated by newlines. The output is machine-parsable.
#
# Here's the format:
#
# /some/file
# /some/other/file
class RuboCop::Formatter::FileListFormatter < ::RuboCop::Formatter::BaseFormatter
  def file_finished(file, offenses); end
end

# This is a collection of formatters. A FormatterSet can hold multiple
# formatter instances and provides transparent formatter API methods
# which invoke same method of each formatters.
class RuboCop::Formatter::FormatterSet < ::Array
  # @return [FormatterSet] a new instance of FormatterSet
  def initialize(options = T.unsafe(nil)); end

  def add_formatter(formatter_type, output_path = T.unsafe(nil)); end
  def close_output_files; end
  def file_finished(file, offenses); end
  def file_started(file, options); end
  def finished(*args); end
  def started(*args); end

  private

  def builtin_formatter_class(specified_key); end
  def custom_formatter_class(specified_class_name); end
  def formatter_class(formatter_type); end
end

RuboCop::Formatter::FormatterSet::BUILTIN_FORMATTERS_FOR_KEYS = T.let(T.unsafe(nil), Hash)
RuboCop::Formatter::FormatterSet::FORMATTER_APIS = T.let(T.unsafe(nil), Array)

# This formatter displays a progress bar and shows details of offenses as
# soon as they are detected.
# This is inspired by the Fuubar formatter for RSpec by Jeff Kreeftmeijer.
# https://github.com/jeffkreeftmeijer/fuubar
class RuboCop::Formatter::FuubarStyleFormatter < ::RuboCop::Formatter::ClangStyleFormatter
  # @return [FuubarStyleFormatter] a new instance of FuubarStyleFormatter
  def initialize(*output); end

  def count_stats(offenses); end
  def file_finished(file, offenses); end
  def progressbar_color; end
  def started(target_files); end
  def with_color; end
end

RuboCop::Formatter::FuubarStyleFormatter::RESET_SEQUENCE = T.let(T.unsafe(nil), String)

# This formatter formats report data as GitHub Workflow commands resulting
# in GitHub check annotations when run within GitHub Actions.
class RuboCop::Formatter::GitHubActionsFormatter < ::RuboCop::Formatter::BaseFormatter
  def file_finished(file, offenses); end
  def finished(_inspected_files); end
  def started(_target_files); end

  private

  def github_escape(string); end
  def github_severity(offense); end
  def minimum_severity_to_fail; end
  def report_offense(file, offense); end
end

RuboCop::Formatter::GitHubActionsFormatter::ESCAPE_MAP = T.let(T.unsafe(nil), Hash)

# This formatter saves the output as an html file.
class RuboCop::Formatter::HTMLFormatter < ::RuboCop::Formatter::BaseFormatter
  # @return [HTMLFormatter] a new instance of HTMLFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def file_finished(file, offenses); end

  # Returns the value of attribute files.
  def files; end

  def finished(inspected_files); end
  def render_html; end
  def started(target_files); end

  # Returns the value of attribute summary.
  def summary; end
end

class RuboCop::Formatter::HTMLFormatter::Color < ::Struct
  # Returns the value of attribute alpha
  #
  # @return [Object] the current value of alpha
  def alpha; end

  # Sets the attribute alpha
  #
  # @param value [Object] the value to set the attribute alpha to.
  # @return [Object] the newly set value
  def alpha=(_); end

  # Returns the value of attribute blue
  #
  # @return [Object] the current value of blue
  def blue; end

  # Sets the attribute blue
  #
  # @param value [Object] the value to set the attribute blue to.
  # @return [Object] the newly set value
  def blue=(_); end

  def fade_out(amount); end

  # Returns the value of attribute green
  #
  # @return [Object] the current value of green
  def green; end

  # Sets the attribute green
  #
  # @param value [Object] the value to set the attribute green to.
  # @return [Object] the newly set value
  def green=(_); end

  # Returns the value of attribute red
  #
  # @return [Object] the current value of red
  def red; end

  # Sets the attribute red
  #
  # @param value [Object] the value to set the attribute red to.
  # @return [Object] the newly set value
  def red=(_); end

  def to_s; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RuboCop::Formatter::HTMLFormatter::ELLIPSES = T.let(T.unsafe(nil), String)

# This class provides helper methods used in the ERB template.
class RuboCop::Formatter::HTMLFormatter::ERBContext
  include ::RuboCop::PathUtil
  include ::RuboCop::Formatter::TextUtil

  # @return [ERBContext] a new instance of ERBContext
  def initialize(files, summary); end

  def base64_encoded_logo_image; end

  # Make Kernel#binding public.
  def binding; end

  def decorated_message(offense); end
  def escape(string); end

  # Returns the value of attribute files.
  def files; end

  def highlight_source_tag(offense); end
  def highlighted_source_line(offense); end
  def possible_ellipses(location); end
  def source_after_highlight(offense); end
  def source_before_highlight(offense); end

  # Returns the value of attribute summary.
  def summary; end
end

RuboCop::Formatter::HTMLFormatter::ERBContext::LOGO_IMAGE_PATH = T.let(T.unsafe(nil), String)
RuboCop::Formatter::HTMLFormatter::ERBContext::SEVERITY_COLORS = T.let(T.unsafe(nil), Hash)

class RuboCop::Formatter::HTMLFormatter::FileOffenses < ::Struct
  # Returns the value of attribute offenses
  #
  # @return [Object] the current value of offenses
  def offenses; end

  # Sets the attribute offenses
  #
  # @param value [Object] the value to set the attribute offenses to.
  # @return [Object] the newly set value
  def offenses=(_); end

  # Returns the value of attribute path
  #
  # @return [Object] the current value of path
  def path; end

  # Sets the attribute path
  #
  # @param value [Object] the value to set the attribute path to.
  # @return [Object] the newly set value
  def path=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

class RuboCop::Formatter::HTMLFormatter::Summary < ::Struct
  # Returns the value of attribute inspected_files
  #
  # @return [Object] the current value of inspected_files
  def inspected_files; end

  # Sets the attribute inspected_files
  #
  # @param value [Object] the value to set the attribute inspected_files to.
  # @return [Object] the newly set value
  def inspected_files=(_); end

  # Returns the value of attribute offense_count
  #
  # @return [Object] the current value of offense_count
  def offense_count; end

  # Sets the attribute offense_count
  #
  # @param value [Object] the value to set the attribute offense_count to.
  # @return [Object] the newly set value
  def offense_count=(_); end

  # Returns the value of attribute target_files
  #
  # @return [Object] the current value of target_files
  def target_files; end

  # Sets the attribute target_files
  #
  # @param value [Object] the value to set the attribute target_files to.
  # @return [Object] the newly set value
  def target_files=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RuboCop::Formatter::HTMLFormatter::TEMPLATE_PATH = T.let(T.unsafe(nil), String)

# This formatter formats the report data in JSON format.
class RuboCop::Formatter::JSONFormatter < ::RuboCop::Formatter::BaseFormatter
  include ::RuboCop::PathUtil

  # @return [JSONFormatter] a new instance of JSONFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def file_finished(file, offenses); end
  def finished(inspected_files); end
  def hash_for_file(file, offenses); end

  # TODO: Consider better solution for Offense#real_column.
  #       The minimum value of `start_column: real_column` is 1.
  #       So, the minimum value of `last_column` should be 1.
  #       And non-zero value of `last_column` should be used as is.
  def hash_for_location(offense); end

  def hash_for_offense(offense); end
  def metadata_hash; end

  # Returns the value of attribute output_hash.
  def output_hash; end

  def started(target_files); end
end

# This formatter formats the report data in JUnit format.
class RuboCop::Formatter::JUnitFormatter < ::RuboCop::Formatter::BaseFormatter
  # @return [JUnitFormatter] a new instance of JUnitFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def add_testcase_element_to_testsuite_element(file, target_offenses, cop); end
  def classname_attribute_value(file); end
  def file_finished(file, offenses); end
  def finished(_inspected_files); end
  def offenses_for_cop(all_offenses, cop); end

  # @return [Boolean]
  def relevant_for_output?(options, target_offenses); end

  private

  def add_failure_to(testcase, offenses, cop_name); end
  def reset_count; end
end

# This formatter displays the report data in markdown
class RuboCop::Formatter::MarkdownFormatter < ::RuboCop::Formatter::BaseFormatter
  include ::RuboCop::Formatter::TextUtil
  include ::RuboCop::PathUtil

  # @return [MarkdownFormatter] a new instance of MarkdownFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def file_finished(file, offenses); end

  # Returns the value of attribute files.
  def files; end

  def finished(inspected_files); end
  def started(target_files); end

  # Returns the value of attribute summary.
  def summary; end

  private

  def possible_ellipses(location); end
  def render_markdown; end
  def write_code(offense); end
  def write_context(offense); end
  def write_file_messages; end
  def write_heading(file); end
end

# This formatter displays the list of offended cops with a count of how
# many offenses of their kind were found. Ordered by desc offense count
#
# Here's the format:
#
# 26  LineLength
# 3   OneLineConditional
# --
# 29  Total
class RuboCop::Formatter::OffenseCountFormatter < ::RuboCop::Formatter::BaseFormatter
  def file_finished(_file, offenses); end
  def finished(_inspected_files); end

  # Returns the value of attribute offense_counts.
  def offense_counts; end

  def ordered_offense_counts(offense_counts); end
  def report_summary(offense_counts); end
  def started(target_files); end
  def total_offense_count(offense_counts); end
end

# This formatter prints a PACDOT per every file to be analyzed.
# Pacman will "eat" one PACDOT per file when no offense is detected.
# Otherwise it will print a Ghost.
# This is inspired by the Pacman formatter for RSpec by Carlos Rojas.
# https://github.com/go-labs/rspec_pacman_formatter
class RuboCop::Formatter::PacmanFormatter < ::RuboCop::Formatter::ClangStyleFormatter
  include ::RuboCop::Formatter::TextUtil

  # @return [PacmanFormatter] a new instance of PacmanFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def cols; end
  def file_finished(file, offenses); end
  def file_started(_file, _options); end
  def next_step(offenses); end
  def pacdots(number); end

  # Returns the value of attribute progress_line.
  def progress_line; end

  # Sets the attribute progress_line
  #
  # @param value the value to set the attribute progress_line to.
  def progress_line=(_arg0); end

  def started(target_files); end
  def step(character); end
  def update_progress_line; end
end

RuboCop::Formatter::PacmanFormatter::FALLBACK_TERMINAL_WIDTH = T.let(T.unsafe(nil), Integer)
RuboCop::Formatter::PacmanFormatter::GHOST = T.let(T.unsafe(nil), String)
RuboCop::Formatter::PacmanFormatter::PACDOT = T.let(T.unsafe(nil), Rainbow::Presenter)
RuboCop::Formatter::PacmanFormatter::PACMAN = T.let(T.unsafe(nil), Rainbow::Presenter)

# This formatter display dots for files with no offenses and
# letters for files with problems in the them. In the end it
# appends the regular report data in the clang style format.
class RuboCop::Formatter::ProgressFormatter < ::RuboCop::Formatter::ClangStyleFormatter
  include ::RuboCop::Formatter::TextUtil

  # @return [ProgressFormatter] a new instance of ProgressFormatter
  def initialize(output, options = T.unsafe(nil)); end

  def file_finished(file, offenses); end
  def finished(inspected_files); end
  def report_file_as_mark(offenses); end
  def started(target_files); end
end

RuboCop::Formatter::ProgressFormatter::DOT = T.let(T.unsafe(nil), String)

# If no offenses are found, no output is displayed.
# Otherwise, SimpleTextFormatter's output is displayed.
class RuboCop::Formatter::QuietFormatter < ::RuboCop::Formatter::SimpleTextFormatter
  def report_summary(file_count, offense_count, correction_count, correctable_count); end
end

# A basic formatter that displays only files with offenses.
# Offenses are displayed at compact form - just the
# location of the problem and the associated message.
class RuboCop::Formatter::SimpleTextFormatter < ::RuboCop::Formatter::BaseFormatter
  include ::RuboCop::Formatter::Colorizable
  include ::RuboCop::PathUtil

  def file_finished(file, offenses); end
  def finished(inspected_files); end
  def report_file(file, offenses); end
  def report_summary(file_count, offense_count, correction_count, correctable_count); end
  def started(_target_files); end

  private

  def annotate_message(msg); end
  def colored_severity_code(offense); end
  def count_stats(offenses); end
  def message(offense); end
end

RuboCop::Formatter::SimpleTextFormatter::COLOR_FOR_SEVERITY = T.let(T.unsafe(nil), Hash)

# A helper class for building the report summary text.
class RuboCop::Formatter::SimpleTextFormatter::Report
  include ::RuboCop::Formatter::Colorizable
  include ::RuboCop::Formatter::TextUtil

  # @return [Report] a new instance of Report
  def initialize(file_count, offense_count, correction_count, correctable_count, rainbow, safe_autocorrect: T.unsafe(nil)); end

  def summary; end

  private

  def correctable; end
  def corrections; end
  def files; end
  def offenses; end

  # Returns the value of attribute rainbow.
  def rainbow; end
end

# This formatter formats report data using the Test Anything Protocol.
# TAP allows for to communicate tests results in a language agnostics way.
class RuboCop::Formatter::TapFormatter < ::RuboCop::Formatter::ClangStyleFormatter
  def file_finished(file, offenses); end
  def started(target_files); end

  private

  def annotate_message(msg); end
  def message(offense); end
  def report_highlighted_area(highlighted_area); end
  def report_line(location); end
  def report_offense(file, offense); end
end

# Common logic for UI texts.
module RuboCop::Formatter::TextUtil
  private

  def pluralize(number, thing, options = T.unsafe(nil)); end

  class << self
    def pluralize(number, thing, options = T.unsafe(nil)); end
  end
end

# This formatter displays the list of offensive files, sorted by number of
# offenses with the worst offenders first.
#
# Here's the format:
#
# 26  this/file/is/really/bad.rb
# 3   just/ok.rb
# --
# 29  Total
class RuboCop::Formatter::WorstOffendersFormatter < ::RuboCop::Formatter::BaseFormatter
  def file_finished(file, offenses); end
  def finished(_inspected_files); end

  # Returns the value of attribute offense_counts.
  def offense_counts; end

  def ordered_offense_counts(offense_counts); end
  def report_summary(offense_counts); end
  def started(target_files); end
  def total_offense_count(offense_counts); end
end

class RuboCop::IncorrectCopNameError < ::StandardError; end

# Encapsulation of a lockfile for use when checking for gems.
# Does not actually resolve gems, just parses the lockfile.
#
# @api private
class RuboCop::Lockfile
  # Gems that the bundle depends on
  #
  # @api private
  def dependencies; end

  # All activated gems, including transitive dependencies
  #
  # @api private
  def gems; end

  # @api private
  # @return [Boolean]
  def includes_gem?(name); end

  private

  # @api private
  def parser; end
end

# Parse different formats of magic comments.
#
# @abstract parent of three different magic comment handlers
class RuboCop::MagicComment
  # @return [MagicComment] a new instance of MagicComment
  def initialize(comment); end

  # @return [Boolean]
  def any?; end

  # @return [Boolean]
  def encoding_specified?; end

  # Expose the `frozen_string_literal` value coerced to a boolean if possible.
  #
  # @return [Boolean] if value is `true` or `false`
  # @return [nil] if frozen_string_literal comment isn't found
  # @return [String] if comment is found but isn't true or false
  def frozen_string_literal; end

  # Does the magic comment enable the frozen string literal feature.
  #
  # Test whether the frozen string literal value is `true`. Cannot
  # just return `frozen_string_literal` since an invalid magic comment
  # `'yes'` does not actually enable the feature
  #
  # @return [Boolean]
  def frozen_string_literal?; end

  # Was a magic comment for the frozen string literal found?
  #
  # @return [Boolean]
  def frozen_string_literal_specified?; end

  # Expose the `shareable_constant_value` value coerced to a boolean if possible.
  #
  # @return [String] for shareable_constant_value config
  def shareable_constant_value; end

  # Was a shareable_constant_value specified?
  #
  # @return [Boolean]
  def shareable_constant_value_specified?; end

  def typed; end

  # Was the Sorbet `typed` sigil specified?
  #
  # @return [Boolean]
  def typed_specified?; end

  # @return [Boolean]
  def valid?; end

  # @return [Boolean]
  def valid_literal_value?; end

  # @return [Boolean]
  def valid_shareable_constant_value?; end

  private

  # Match the entire comment string with a pattern and take the first capture.
  #
  # @param pattern [Regexp]
  # @return [String] if pattern matched
  # @return [nil] otherwise
  def extract(pattern); end

  # @return [Boolean]
  def specified?(value); end

  class << self
    # Detect magic comment format and pass it to the appropriate wrapper.
    #
    # @param comment [String]
    # @return [RuboCop::MagicComment]
    def parse(comment); end
  end
end

# Parent to Vim and Emacs magic comment handling.
#
# @abstract
class RuboCop::MagicComment::EditorComment < ::RuboCop::MagicComment
  def encoding; end

  # Rewrite the comment without a given token type
  def without(type); end

  private

  # Find a token starting with the provided keyword and extract its value.
  #
  # @param keyword [String]
  # @return [String] extracted value if it is found
  # @return [nil] otherwise
  def match(keyword); end

  # Individual tokens composing an editor specific comment string.
  #
  # @return [Array<String>]
  def tokens; end
end

# Wrapper for Emacs style magic comments.
#
# @example Emacs style comment
#   comment = RuboCop::MagicComment.parse(
#   '# -*- encoding: ASCII-8BIT -*-'
#   )
#
#   comment.encoding # => 'ascii-8bit'
# @see https://www.gnu.org/software/emacs/manual/html_node/emacs/Specify-Coding.html
# @see https://github.com/ruby/ruby/blob/3f306dc/parse.y#L6873-L6892 Emacs handling in parse.y
class RuboCop::MagicComment::EmacsComment < ::RuboCop::MagicComment::EditorComment
  private

  def extract_frozen_string_literal; end
  def extract_shareable_constant_value; end

  # Emacs comments cannot specify Sorbet typechecking behavior.
  def extract_typed; end
end

RuboCop::MagicComment::EmacsComment::FORMAT = T.let(T.unsafe(nil), String)
RuboCop::MagicComment::EmacsComment::OPERATOR = T.let(T.unsafe(nil), String)
RuboCop::MagicComment::EmacsComment::REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::MagicComment::EmacsComment::SEPARATOR = T.let(T.unsafe(nil), String)
RuboCop::MagicComment::KEYWORDS = T.let(T.unsafe(nil), Hash)

# Wrapper for regular magic comments not bound to an editor.
#
# Simple comments can only specify one setting per comment.
#
# @example frozen string literal comments
#   comment1 = RuboCop::MagicComment.parse('# frozen_string_literal: true')
#   comment1.frozen_string_literal # => true
#   comment1.encoding              # => nil
# @example encoding comments
#   comment2 = RuboCop::MagicComment.parse('# encoding: utf-8')
#   comment2.frozen_string_literal # => nil
#   comment2.encoding              # => 'utf-8'
class RuboCop::MagicComment::SimpleComment < ::RuboCop::MagicComment
  # Match `encoding` or `coding`
  def encoding; end

  # Rewrite the comment without a given token type
  def without(type); end

  private

  # Extract `frozen_string_literal`.
  #
  # The `frozen_string_literal` magic comment only works if it
  # is the only text in the comment.
  #
  # Case-insensitive and dashes/underscores are acceptable.
  #
  # @see https://github.com/ruby/ruby/blob/78b95b4/parse.y#L7134-L7138
  def extract_frozen_string_literal; end

  def extract_shareable_constant_value; end
  def extract_typed; end
end

# IRB's pattern for matching magic comment tokens.
#
# @see https://github.com/ruby/ruby/blob/b4a55c1/lib/irb/magic-file.rb#L5
RuboCop::MagicComment::TOKEN = T.let(T.unsafe(nil), Regexp)

# Wrapper for Vim style magic comments.
#
# @example Vim style comment
#   comment = RuboCop::MagicComment.parse(
#   '# vim: filetype=ruby, fileencoding=ascii-8bit'
#   )
#
#   comment.encoding # => 'ascii-8bit'
class RuboCop::MagicComment::VimComment < ::RuboCop::MagicComment::EditorComment
  # For some reason the fileencoding keyword only works if there
  # is at least one other token included in the string. For example
  #
  #    # works
  #      # vim: foo=bar, fileencoding=ascii-8bit
  #
  #    # does nothing
  #      # vim: foo=bar, fileencoding=ascii-8bit
  def encoding; end

  # Vim comments cannot specify Sorbet typechecking behavior.
  def extract_typed; end

  # Vim comments cannot specify frozen string literal behavior.
  def frozen_string_literal; end

  # Vim comments cannot specify shareable constant values behavior.
  def shareable_constant_value; end
end

RuboCop::MagicComment::VimComment::FORMAT = T.let(T.unsafe(nil), String)
RuboCop::MagicComment::VimComment::KEYWORDS = T.let(T.unsafe(nil), Hash)
RuboCop::MagicComment::VimComment::OPERATOR = T.let(T.unsafe(nil), String)
RuboCop::MagicComment::VimComment::REGEXP = T.let(T.unsafe(nil), Regexp)
RuboCop::MagicComment::VimComment::SEPARATOR = T.let(T.unsafe(nil), String)

# Common functionality for finding names that are similar to a given name.
#
# @api private
module RuboCop::NameSimilarity
  private

  # @api private
  def find_similar_name(target_name, names); end

  # @api private
  def find_similar_names(target_name, names); end

  class << self
    # @api private
    def find_similar_name(target_name, names); end

    # @api private
    def find_similar_names(target_name, names); end
  end
end

RuboCop::NodePattern = RuboCop::AST::NodePattern
class RuboCop::OptionArgumentError < ::StandardError; end

# This class handles command line options.
#
# @api private
class RuboCop::Options
  # @api private
  # @return [Options] a new instance of Options
  def initialize; end

  # @api private
  def parse(command_line_args); end

  private

  # @api private
  def add_additional_modes(opts); end

  # the autocorrect command-line arguments map to the autocorrect @options values like so:
  #                            :fix_layout  :autocorrect  :safe_autocorrect  :autocorrect_all
  # -x, --fix-layout           true         true          -                  -
  # -a, --auto-correct         -            true          true               -
  #     --safe-auto-correct    -            true          true               -
  # -A, --auto-correct-all     -            true          -                  true
  #
  # @api private
  def add_autocorrection_options(opts); end

  # @api private
  def add_cache_options(opts); end

  # @api private
  def add_check_options(opts); end

  # @api private
  def add_config_generation_options(opts); end

  # @api private
  def add_cop_selection_csv_option(option, opts); end

  # @api private
  def add_general_options(opts); end

  # @api private
  def add_output_options(opts); end

  # @api private
  def add_server_options(opts); end

  # @api private
  def add_severity_option(opts); end

  # @api private
  def args_from_env; end

  # @api private
  def args_from_file; end

  # @api private
  def define_options; end

  # @api private
  def handle_deprecated_option(old_option, new_option); end

  # Finds the option in `args` starting with -- and converts it to a symbol,
  # e.g. [..., '--autocorrect', ...] to :autocorrect.
  #
  # @api private
  def long_opt_symbol(args); end

  # Sets a value in the @options hash, based on the given long option and its
  # value, in addition to calling the block if a block is given.
  #
  # @api private
  def option(opts, *args); end

  # @api private
  def rainbow; end

  # @api private
  def require_feature(file); end

  # Creates a section of options in order to separate them visually when
  # using `--help`.
  #
  # @api private
  def section(opts, heading, &_block); end
end

# @api private
RuboCop::Options::DEFAULT_MAXIMUM_EXCLUSION_ITEMS = T.let(T.unsafe(nil), Integer)

# @api private
RuboCop::Options::EXITING_OPTIONS = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::Options::E_STDIN_NO_PATH = T.let(T.unsafe(nil), String)

# This module contains help texts for command line options.
#
# @api private
module RuboCop::OptionsHelp; end

# @api private
RuboCop::OptionsHelp::FORMATTER_OPTION_LIST = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::OptionsHelp::MAX_EXCL = T.let(T.unsafe(nil), String)

# @api private
RuboCop::OptionsHelp::TEXT = T.let(T.unsafe(nil), Hash)

# Validates option arguments and the options' compatibility with each other.
#
# @api private
class RuboCop::OptionsValidator
  # @api private
  # @return [OptionsValidator] a new instance of OptionsValidator
  def initialize(options); end

  # @api private
  # @return [Boolean]
  def boolean_or_empty_cache?; end

  # @api private
  def disable_parallel_when_invalid_option_combo; end

  # @api private
  # @return [Boolean]
  def display_only_fail_level_offenses_with_autocorrect?; end

  # @api private
  # @return [Boolean]
  def except_syntax?; end

  # @api private
  def incompatible_options; end

  # @api private
  def invalid_arguments_for_parallel; end

  # @api private
  # @return [Boolean]
  def only_includes_redundant_disable?; end

  # @api private
  def validate_auto_gen_config; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_autocorrect; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_cache_enabled_for_cache_root; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_compatibility; end

  # @api private
  def validate_cop_options; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_display_only_correctable_and_autocorrect; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_display_only_failed; end

  # @api private
  # @raise [OptionArgumentError]
  def validate_display_only_failed_and_display_only_correctable; end

  # @api private
  # @raise [OptionParser::MissingArgument]
  def validate_exclude_limit_option; end

  class << self
    # Cop name validation must be done later than option parsing, so it's not
    # called from within Options.
    #
    # @api private
    def validate_cop_list(names); end

    private

    # @api private
    def format_message_from(name, cop_names); end
  end
end

# Common methods and behaviors for dealing with paths.
module RuboCop::PathUtil
  private

  # Returns true for an absolute Unix or Windows path.
  def absolute?(path); end

  def hidden_dir?(path); end
  def hidden_file?(path); end
  def hidden_file_in_not_hidden_dir?(pattern, path); end
  def match_path?(pattern, path); end

  # Loose check to reduce memory allocations
  def maybe_hidden_file?(path); end

  def relative_path(path, base_dir = T.unsafe(nil)); end
  def smart_path(path); end

  class << self
    # Returns true for an absolute Unix or Windows path.
    #
    # @return [Boolean]
    def absolute?(path); end

    # @return [Boolean]
    def hidden_dir?(path); end

    # @return [Boolean]
    def hidden_file?(path); end

    # @return [Boolean]
    def hidden_file_in_not_hidden_dir?(pattern, path); end

    # @return [Boolean]
    def match_path?(pattern, path); end

    # Loose check to reduce memory allocations
    #
    # @return [Boolean]
    def maybe_hidden_file?(path); end

    def relative_path(path, base_dir = T.unsafe(nil)); end
    def smart_path(path); end
  end
end

# This module provides information on the platform that RuboCop is being run
# on.
module RuboCop::Platform
  class << self
    # @return [Boolean]
    def windows?; end
  end
end

RuboCop::ProcessedSource = RuboCop::AST::ProcessedSource

# Common methods and behaviors for dealing with remote config files.
#
# @api private
class RuboCop::RemoteConfig
  # @api private
  # @return [RemoteConfig] a new instance of RemoteConfig
  def initialize(url, base_dir); end

  # @api private
  def file; end

  # @api private
  def inherit_from_remote(file, path); end

  # @api private
  def uri; end

  private

  # @api private
  def cache_name_from_uri; end

  # @api private
  def cache_path; end

  # @api private
  # @return [Boolean]
  def cache_path_exists?; end

  # @api private
  # @return [Boolean]
  def cache_path_expired?; end

  # @api private
  def cloned_url; end

  # @api private
  # @yield [request]
  def generate_request(uri); end

  # @api private
  def handle_response(response, limit, &block); end

  # @api private
  # @raise [ArgumentError]
  def request(uri = T.unsafe(nil), limit = T.unsafe(nil), &block); end
end

# @api private
RuboCop::RemoteConfig::CACHE_LIFETIME = T.let(T.unsafe(nil), Integer)

# Provides functionality for caching RuboCop runs.
#
# @api private
class RuboCop::ResultCache
  # @api private
  # @return [ResultCache] a new instance of ResultCache
  def initialize(file, team, options, config_store, cache_root = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  def debug?; end

  # @api private
  def load; end

  # @api private
  def path; end

  # @api private
  def save(offenses); end

  # @api private
  # @return [Boolean]
  def valid?; end

  private

  # @api private
  # @return [Boolean]
  def any_symlink?(path); end

  # We combine team and options into a single "context" checksum to avoid
  # making file names that are too long for some filesystems to handle.
  # This context is for anything that's not (1) the RuboCop executable
  # checksum or (2) the inspected file checksum.
  #
  # @api private
  def context_checksum(team, options); end

  # @api private
  def digest(path); end

  # @api private
  def file_checksum(file, config_store); end

  # Return a hash of the options given at invocation, minus the ones that have
  # no effect on which offenses and disabled line ranges are found, and thus
  # don't affect caching.
  #
  # @api private
  def relevant_options_digest(options); end

  # The checksum of the RuboCop program running the inspection.
  #
  # @api private
  def rubocop_checksum; end

  # @api private
  def rubocop_extra_features; end

  # @api private
  # @return [Boolean]
  def symlink_protection_triggered?(path); end

  # The external dependency checksums are cached per RuboCop team so that
  # the checksums don't need to be recomputed for each file.
  #
  # @api private
  def team_checksum(team); end

  class << self
    # @api private
    # @return [Boolean]
    def allow_symlinks_in_cache_location?(config_store); end

    # @api private
    def cache_root(config_store); end

    # Remove old files so that the cache doesn't grow too big. When the
    # threshold MaxFilesInCache has been exceeded, the oldest 50% of all the
    # files in the cache are removed. The reason for removing so much is that
    # cleaning should be done relatively seldom, since there is a slight risk
    # that some other RuboCop process was just about to read the file, when
    # there's parallel execution and the cache is shared.
    #
    # @api private
    def cleanup(config_store, verbose, cache_root = T.unsafe(nil)); end

    # @api private
    def inhibit_cleanup; end

    # @api private
    def inhibit_cleanup=(_arg0); end

    # @api private
    def rubocop_required_features; end

    # @api private
    def rubocop_required_features=(_arg0); end

    # @api private
    def source_checksum; end

    # @api private
    def source_checksum=(_arg0); end

    private

    # @api private
    def remove_files(files, dirs, remove_count); end

    # @api private
    def remove_oldest_files(files, dirs, cache_root, verbose); end

    # @api private
    # @return [Boolean]
    def requires_file_removal?(file_count, config_store); end
  end
end

# @api private
RuboCop::ResultCache::DL_EXTENSIONS = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::ResultCache::NON_CHANGING = T.let(T.unsafe(nil), Array)

# This class handles the processing of files, which includes dealing with
# formatters and letting cops inspect the files.
class RuboCop::Runner
  # @return [Runner] a new instance of Runner
  def initialize(options, config_store); end

  # Sets the attribute aborting
  #
  # @param value the value to set the attribute aborting to.
  def aborting=(_arg0); end

  # @return [Boolean]
  def aborting?; end

  # Returns the value of attribute errors.
  def errors; end

  def run(paths); end

  # Returns the value of attribute warnings.
  def warnings; end

  private

  def add_redundant_disables(file, offenses, source); end
  def cached_result(file, team); end

  # @return [Boolean]
  def cached_run?; end

  # Check whether a run created source identical to a previous run, which
  # means that we definitely have an infinite loop.
  def check_for_infinite_loop(processed_source, offenses_by_iteration); end

  # @return [Boolean]
  def check_for_redundant_disables?(source); end

  # @return [Boolean]
  def considered_failure?(offense); end

  def default_config(cop_name); end
  def do_inspection_loop(file); end
  def each_inspected_file(files); end
  def file_finished(file, offenses); end
  def file_offense_cache(file); end
  def file_offenses(file); end
  def file_started(file); end
  def filter_cop_classes(cop_classes, config); end

  # @return [Boolean]
  def filtered_run?; end

  def find_target_files(paths); end
  def formatter_set; end
  def get_processed_source(file); end
  def inspect_file(processed_source, team = T.unsafe(nil)); end
  def inspect_files(files); end
  def iterate_until_no_changes(source, offenses_by_iteration); end
  def list_files(paths); end

  # @return [Boolean]
  def mark_as_safe_by_config?(config); end

  def minimum_severity_to_fail; end
  def mobilize_team(processed_source); end
  def mobilized_cop_classes(config); end
  def offenses_to_report(offenses); end
  def process_file(file); end
  def qualify_option_cop_names; end

  # @yield [cop]
  def redundant_cop_disable_directive(file); end

  def save_in_cache(cache, offenses); end

  # A Cop::Team instance is stateful and may change when inspecting.
  # The "standby" team for a given config is an initialized but
  # otherwise dormant team that can be used for config- and option-
  # level caching in ResultCache.
  def standby_team(config); end

  # @return [Boolean]
  def style_guide_cops_only?(config); end

  # @return [Boolean]
  def supports_safe_autocorrect?(offense); end

  # @yield [team]
  def team_for_redundant_disables(file, offenses, source); end

  # Warms up the RuboCop cache by forking a suitable number of RuboCop
  # instances that each inspects its allotted group of files.
  def warm_cache(target_files); end
end

# An exception indicating that the inspection loop got stuck correcting
# offenses back and forth.
class RuboCop::Runner::InfiniteCorrectionLoop < ::StandardError
  # @return [InfiniteCorrectionLoop] a new instance of InfiniteCorrectionLoop
  def initialize(path, offenses_by_iteration, loop_start: T.unsafe(nil)); end

  # Returns the value of attribute offenses.
  def offenses; end
end

# @api private
RuboCop::Runner::MAX_ITERATIONS = T.let(T.unsafe(nil), Integer)

# Take a string with embedded escapes, and convert the escapes as the Ruby
# interpreter would when reading a double-quoted string literal.
# For example, "\\n" will be converted to "\n".
class RuboCop::StringInterpreter
  class << self
    def interpret(string); end

    private

    def interpret_hex(escape); end
    def interpret_octal(escape); end
    def interpret_string_escape(escape); end
    def interpret_unicode(escape); end
  end
end

RuboCop::StringInterpreter::STRING_ESCAPES = T.let(T.unsafe(nil), Hash)
RuboCop::StringInterpreter::STRING_ESCAPE_REGEX = T.let(T.unsafe(nil), Regexp)

# This class finds target files to inspect by scanning the directory tree
# and picking ruby files.
#
# @api private
class RuboCop::TargetFinder
  # @api private
  # @return [TargetFinder] a new instance of TargetFinder
  def initialize(config_store, options = T.unsafe(nil)); end

  # @api private
  def all_cops_include; end

  # @api private
  def combined_exclude_glob_patterns(base_dir); end

  # @api private
  # @return [Boolean]
  def configured_include?(file); end

  # @api private
  # @return [Boolean]
  def debug?; end

  # @api private
  # @return [Boolean]
  def fail_fast?; end

  # Generate a list of target files by expanding globbing patterns
  # (if any). If args is empty, recursively find all Ruby source
  # files under the current directory
  #
  # @api private
  # @return [Array] array of file paths
  def find(args, mode); end

  # Search for files recursively starting at the given base directory using
  # the given flags that determine how the match is made. Excluded files will
  # be removed later by the caller, but as an optimization find_files removes
  # the top level directories that are excluded in configuration in the
  # normal way (dir/**/*).
  #
  # @api private
  def find_files(base_dir, flags); end

  # @api private
  # @return [Boolean]
  def force_exclusion?; end

  # @api private
  # @return [Boolean]
  def included_file?(file); end

  # @api private
  def process_explicit_path(path, mode); end

  # @api private
  # @return [Boolean]
  def ruby_executable?(file); end

  # @api private
  # @return [Boolean]
  def ruby_extension?(file); end

  # @api private
  def ruby_extensions; end

  # @api private
  # @return [Boolean]
  def ruby_file?(file); end

  # @api private
  # @return [Boolean]
  def ruby_filename?(file); end

  # @api private
  def ruby_filenames; end

  # @api private
  def ruby_interpreters(file); end

  # @api private
  # @return [Boolean]
  def stdin?; end

  # @api private
  # @return [Boolean]
  def symlink_excluded_or_infinite_loop?(base_dir, current_dir, exclude_pattern, flags); end

  # Finds all Ruby source files under the current or other supplied
  # directory. A Ruby source file is defined as a file with the `.rb`
  # extension or a file with no extension that has a ruby shebang line
  # as its first line.
  # It is possible to specify includes and excludes using the config file,
  # so you can include other Ruby files like Rakefiles and gemspecs.
  #
  # @api private
  # @param base_dir Root directory under which to search for
  #   ruby source files
  # @return [Array] Array of filenames
  def target_files_in_dir(base_dir = T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  def to_inspect?(file, hidden_files, base_dir_config); end

  # @api private
  def wanted_dir_patterns(base_dir, exclude_pattern, flags); end

  private

  # @api private
  def order; end
end

# @api private
RuboCop::TargetFinder::HIDDEN_PATH_SUBSTRING = T.let(T.unsafe(nil), String)

# The kind of Ruby that code inspected by RuboCop is written in.
#
# @api private
class RuboCop::TargetRuby
  # @api private
  # @return [TargetRuby] a new instance of TargetRuby
  def initialize(config); end

  # @api private
  def rubocop_version_with_support; end

  # @api private
  def source; end

  # @api private
  # @return [Boolean]
  def supported?; end

  # @api private
  def version; end

  class << self
    # @api private
    def supported_versions; end
  end
end

# The lock file of Bundler may identify the target ruby version.
#
# @api private
class RuboCop::TargetRuby::BundlerLockFile < ::RuboCop::TargetRuby::Source
  # @api private
  def name; end

  private

  # @api private
  def bundler_lock_file_path; end

  # @api private
  def find_version; end
end

# @api private
RuboCop::TargetRuby::DEFAULT_VERSION = T.let(T.unsafe(nil), Float)

# If all else fails, a default version will be picked.
#
# @api private
class RuboCop::TargetRuby::Default < ::RuboCop::TargetRuby::Source
  # @api private
  def name; end

  private

  # @api private
  def find_version; end
end

# The target ruby version may be found in a .gemspec file.
#
# @api private
class RuboCop::TargetRuby::GemspecFile < ::RuboCop::TargetRuby::Source
  extend ::RuboCop::AST::NodePattern::Macros

  def gem_requirement?(param0 = T.unsafe(nil)); end

  # @api private
  def name; end

  def required_ruby_version(param0); end

  private

  # @api private
  def find_default_minimal_known_ruby(right_hand_side); end

  # @api private
  def find_version; end

  # @api private
  def gemspec_filename; end

  # @api private
  def gemspec_filepath; end

  # @api private
  def version_from_array(array); end

  # @api private
  def version_from_gemspec_file(file); end

  # @api private
  def version_from_right_hand_side(right_hand_side); end
end

# @api private
RuboCop::TargetRuby::GemspecFile::GEMSPEC_EXTENSION = T.let(T.unsafe(nil), String)

# @api private
RuboCop::TargetRuby::KNOWN_RUBIES = T.let(T.unsafe(nil), Array)

# @api private
RuboCop::TargetRuby::OBSOLETE_RUBIES = T.let(T.unsafe(nil), Hash)

# The target ruby version may be configured in RuboCop's config.
#
# @api private
class RuboCop::TargetRuby::RuboCopConfig < ::RuboCop::TargetRuby::Source
  # @api private
  def name; end

  private

  # @api private
  def find_version; end
end

# The target ruby version may be found in a .ruby-version file.
#
# @api private
class RuboCop::TargetRuby::RubyVersionFile < ::RuboCop::TargetRuby::Source
  # @api private
  def name; end

  private

  # @api private
  def filename; end

  # @api private
  def find_version; end

  # @api private
  def pattern; end

  # @api private
  def version_file; end
end

# @api private
RuboCop::TargetRuby::RubyVersionFile::RUBY_VERSION_FILENAME = T.let(T.unsafe(nil), String)

# @api private
RuboCop::TargetRuby::RubyVersionFile::RUBY_VERSION_PATTERN = T.let(T.unsafe(nil), Regexp)

# @api private
RuboCop::TargetRuby::SOURCES = T.let(T.unsafe(nil), Array)

# A place where information about a target ruby version is found.
#
# @api private
class RuboCop::TargetRuby::Source
  # @api private
  # @return [Source] a new instance of Source
  def initialize(config); end

  # @api private
  def name; end

  # @api private
  def to_s; end

  # @api private
  def version; end
end

# The target ruby version may be found in a .tool-versions file, in a line
# starting with `ruby`.
#
# @api private
class RuboCop::TargetRuby::ToolVersionsFile < ::RuboCop::TargetRuby::RubyVersionFile
  # @api private
  def name; end

  private

  # @api private
  def filename; end

  # @api private
  def pattern; end
end

# @api private
RuboCop::TargetRuby::ToolVersionsFile::TOOL_VERSIONS_FILENAME = T.let(T.unsafe(nil), String)

# @api private
RuboCop::TargetRuby::ToolVersionsFile::TOOL_VERSIONS_PATTERN = T.let(T.unsafe(nil), Regexp)

RuboCop::Token = RuboCop::AST::Token

# This module contains a collection of useful utility methods.
module RuboCop::Util
  class << self
    def silence_warnings; end
  end
end

class RuboCop::ValidationError < ::RuboCop::Error; end

# This module holds the RuboCop version information.
module RuboCop::Version
  class << self
    # @api private
    def document_version; end

    # @api private
    def extension_versions(env); end

    # Returns feature version in one of two ways:
    #
    # * Find by RuboCop core version style (e.g. rubocop-performance, rubocop-rspec)
    # * Find by `bundle gem` version style (e.g. rubocop-rake)
    #
    # @api private
    def feature_version(feature); end

    # @api private
    def version(debug: T.unsafe(nil), env: T.unsafe(nil)); end
  end
end

RuboCop::Version::CANONICAL_FEATURE_NAMES = T.let(T.unsafe(nil), Hash)
RuboCop::Version::EXTENSION_PATH_NAMES = T.let(T.unsafe(nil), Hash)
RuboCop::Version::MSG = T.let(T.unsafe(nil), String)
RuboCop::Version::STRING = T.let(T.unsafe(nil), String)

# A Warning exception is different from an Offense with severity 'warning'
# When a Warning is raised, this means that RuboCop was unable to perform a
# requested operation (such as inspecting or correcting a source file) due to
# user error
# For example, a configuration value in .rubocop.yml might be malformed
class RuboCop::Warning < ::StandardError; end

# Find duplicated keys from YAML.
#
# @api private
module RuboCop::YAMLDuplicationChecker
  class << self
    # @api private
    def check(yaml_string, filename, &on_duplicated); end

    private

    # @api private
    def traverse(tree, &on_duplicated); end
  end
end

# Extensions to the core String class
class String
  include ::Comparable
end

String::BLANK_RE = T.let(T.unsafe(nil), Regexp)
String::ENCODED_BLANKS = T.let(T.unsafe(nil), Concurrent::Map)
