# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rspec-mocks` gem.
# Please instead update this file by running `bin/tapioca gem rspec-mocks`.

# Share the top-level RSpec namespace, because we are a core supported
# extension.
module RSpec
  class << self
    # Used to ensure examples get reloaded between multiple runs in the same
    # process and ensures user configuration is persisted.
    #
    # Users must invoke this if they want to clear all examples but preserve
    # current configuration when they use the runner multiple times within the
    # same process.
    def clear_examples; end

    # Returns the global [Configuration](RSpec/Core/Configuration) object. While
    # you _can_ use this method to access the configuration, the more common
    # convention is to use [RSpec.configure](RSpec#configure-class_method).
    #
    # @example
    #   RSpec.configuration.drb_port = 1234
    # @see RSpec.configure
    # @see Core::Configuration
    def configuration; end

    # Setters for shared global objects
    #
    # @api private
    def configuration=(_arg0); end

    # Yields the global configuration to a block.
    #
    # @example
    #   RSpec.configure do |config|
    #   config.add_formatter 'documentation'
    #   end
    # @see Core::Configuration
    # @yield [Configuration] global configuration
    def configure; end

    # @private
    def const_missing(name); end

    def context(*args, &example_group_block); end

    # The example being executed.
    #
    # The primary audience for this method is library authors who need access
    # to the example currently being executed and also want to support all
    # versions of RSpec 2 and 3.
    #
    # @example
    #
    #   RSpec.configure do |c|
    #   # context.example is deprecated, but RSpec.current_example is not
    #   # available until RSpec 3.0.
    #   fetch_current_example = RSpec.respond_to?(:current_example) ?
    #   proc { RSpec.current_example } : proc { |context| context.example }
    #
    #   c.before(:example) do
    #   example = fetch_current_example.call(self)
    #
    #   # ...
    #   end
    #   end
    def current_example; end

    # Set the current example being executed.
    #
    # @api private
    def current_example=(example); end

    # Get the current RSpec execution scope
    #
    # Returns (in order of lifecycle):
    #   * `:suite` as an initial value, this is outside of the test lifecycle.
    #   * `:before_suite_hook` during `before(:suite)` hooks.
    #   * `:before_context_hook` during `before(:context)` hooks.
    #   * `:before_example_hook` during `before(:example)` hooks and `around(:example)` before `example.run`.
    #   * `:example` within the example run.
    #   * `:after_example_hook` during `after(:example)` hooks and `around(:example)` after `example.run`.
    #   * `:after_context_hook` during `after(:context)` hooks.
    #   * `:after_suite_hook` during `after(:suite)` hooks.
    #   * `:suite` as a final value, again this is outside of the test lifecycle.
    #
    # Reminder, `:context` hooks have `:all` alias and `:example` hooks have `:each` alias.
    #
    # @return [Symbol]
    def current_scope; end

    # Set the current scope rspec is executing in
    #
    # @api private
    def current_scope=(scope); end

    def describe(*args, &example_group_block); end
    def example_group(*args, &example_group_block); end
    def fcontext(*args, &example_group_block); end
    def fdescribe(*args, &example_group_block); end

    # Used to ensure examples get reloaded and user configuration gets reset to
    # defaults between multiple runs in the same process.
    #
    # Users must invoke this if they want to have the configuration reset when
    # they use the runner multiple times within the same process. Users must deal
    # themselves with re-configuration of RSpec before run.
    def reset; end

    def shared_context(name, *args, &block); end
    def shared_examples(name, *args, &block); end
    def shared_examples_for(name, *args, &block); end

    # Internal container for global non-configuration data.
    #
    # @private
    def world; end

    # Setters for shared global objects
    #
    # @api private
    def world=(_arg0); end

    def xcontext(*args, &example_group_block); end
    def xdescribe(*args, &example_group_block); end
  end
end

# @private
RSpec::MODULES_TO_AUTOLOAD = T.let(T.unsafe(nil), Hash)

# Contains top-level utility methods. While this contains a few
# public methods, these are not generally meant to be called from
# a test or example. They exist primarily for integration with
# test frameworks (such as rspec-core).
module RSpec::Mocks
  class << self
    # Adds an allowance (stub) on `subject`
    #
    # @example Defines the implementation of `foo` on `bar`, using the passed block
    #   x = 0
    #   RSpec::Mocks.allow_message(bar, :foo) { x += 1 }
    # @param subject the subject to which the message will be added
    # @param message a symbol, representing the message that will be
    #   added.
    # @param opts a hash of options, :expected_from is used to set the
    #   original call site
    # @yield an optional implementation for the allowance
    def allow_message(subject, message, opts = T.unsafe(nil), &block); end

    # Mocks specific configuration, as distinct from `RSpec.configuration`
    # which is core RSpec configuration.
    def configuration; end

    # @private
    def error_generator; end

    # Sets a message expectation on `subject`.
    #
    # @example Expect the message `foo` to receive `bar`, then call it
    #   RSpec::Mocks.expect_message(bar, :foo)
    #   bar.foo
    # @param subject the subject on which the message will be expected
    # @param message a symbol, representing the message that will be
    #   expected.
    # @param opts a hash of options, :expected_from is used to set the
    #   original call site
    # @yield an optional implementation for the expectation
    def expect_message(subject, message, opts = T.unsafe(nil), &block); end

    # Performs per-test/example setup. This should be called before
    # an test or example begins.
    def setup; end

    # @private
    def space; end

    # Cleans up all test double state (including any methods that were
    # redefined on partial doubles). This _must_ be called after
    # each example, even if an error was raised during the example.
    def teardown; end

    # Verifies any message expectations that were set during the
    # test or example. This should be called at the end of an example.
    def verify; end

    # Call the passed block and verify mocks after it has executed. This allows
    # mock usage in arbitrary places, such as a `before(:all)` hook.
    #
    # @return [Object] the return value from the block
    def with_temporary_scope; end
  end
end

# @private
class RSpec::Mocks::AllowanceTarget < ::RSpec::Mocks::TargetBase
  def expression; end
  def not_to(matcher, *_args); end
  def to(matcher, &block); end
  def to_not(matcher, *_args); end
end

# Handles the implementation of an `and_invoke` implementation.
#
# @private
class RSpec::Mocks::AndInvokeImplementation
  # @return [AndInvokeImplementation] a new instance of AndInvokeImplementation
  def initialize(procs_to_invoke); end

  def call(*args, &block); end
end

# Handles the implementation of an `and_return` implementation.
#
# @private
class RSpec::Mocks::AndReturnImplementation
  # @return [AndReturnImplementation] a new instance of AndReturnImplementation
  def initialize(values_to_return); end

  def call(*_args_to_ignore, &_block); end
end

# Represents an `and_call_original` implementation.
#
# @private
class RSpec::Mocks::AndWrapOriginalImplementation
  # @return [AndWrapOriginalImplementation] a new instance of AndWrapOriginalImplementation
  def initialize(method, block); end

  def call(*args, **_arg1, &block); end
  def initial_action=(_value); end
  def inner_action; end
  def inner_action=(_value); end

  # @return [Boolean]
  def present?; end

  def terminal_action=(_value); end

  private

  def cannot_modify_further_error; end
end

class RSpec::Mocks::AndWrapOriginalImplementation::CannotModifyFurtherError < ::StandardError; end

# Handles the implementation of an `and_yield` declaration.
#
# @private
class RSpec::Mocks::AndYieldImplementation
  # @return [AndYieldImplementation] a new instance of AndYieldImplementation
  def initialize(args_to_yield, eval_context, error_generator); end

  def call(*_args_to_ignore, &block); end
end

# @private
module RSpec::Mocks::AnyInstance
  class << self
    def error_generator; end
  end
end

# @private
class RSpec::Mocks::AnyInstance::Chain
  include ::RSpec::Mocks::AnyInstance::Chain::Customizations

  # @return [Chain] a new instance of Chain
  def initialize(recorder, *args, &block); end

  # @private
  # @return [Boolean]
  def constrained_to_any_of?(*constraints); end

  # @private
  def expectation_fulfilled!; end

  # @private
  # @return [Boolean]
  def matches_args?(*args); end

  def never; end

  # @private
  def playback!(instance); end

  def with(*args, &block); end

  private

  def last_message; end
  def messages; end

  # @return [Boolean]
  def negated?; end

  def record(rspec_method_name, *args, &block); end
end

# Provides convenience methods for recording customizations on message
# expectations.
#
# @private
module RSpec::Mocks::AnyInstance::Chain::Customizations
  # Records the `and_call_original` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_call_original
  def and_call_original(*args, &block); end

  # Records the `and_raise` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_raise
  def and_raise(*args, &block); end

  # Records the `and_return` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_return
  def and_return(*args, &block); end

  # Records the `and_throw` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_throw
  def and_throw(*args, &block); end

  # Records the `and_wrap_original` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_wrap_original
  def and_wrap_original(*args, &block); end

  # Records the `and_yield` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#and_yield
  def and_yield(*args, &block); end

  # Records the `at_least` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#at_least
  def at_least(*args, &block); end

  # Records the `at_most` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#at_most
  def at_most(*args, &block); end

  # Records the `exactly` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#exactly
  def exactly(*args, &block); end

  # Records the `never` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#never
  def never(*args, &block); end

  # Records the `once` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#once
  def once(*args, &block); end

  # Records the `thrice` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#thrice
  def thrice(*args, &block); end

  # Records the `time` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#time
  def time(*args, &block); end

  # Records the `times` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#times
  def times(*args, &block); end

  # Records the `twice` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#twice
  def twice(*args, &block); end

  # Records the `with` message for playback against an instance that
  # invokes a method stubbed or mocked using `any_instance`.
  #
  # @see RSpec::Mocks::MessageExpectation#with
  def with(*args, &block); end

  class << self
    def record(method_name); end
  end
end

# @private
class RSpec::Mocks::AnyInstance::ErrorGenerator < ::RSpec::Mocks::ErrorGenerator
  def raise_does_not_implement_error(klass, method_name); end
  def raise_message_already_received_by_other_instance_error(method_name, object_inspect, invoked_instance); end
  def raise_not_supported_with_prepend_error(method_name, problem_mod); end
  def raise_second_instance_received_message_error(unfulfilled_expectations); end
end

# @private
class RSpec::Mocks::AnyInstance::ExpectChainChain < ::RSpec::Mocks::AnyInstance::StubChain
  # @return [ExpectChainChain] a new instance of ExpectChainChain
  def initialize(*args); end

  # @return [Boolean]
  def expectation_fulfilled?; end

  def playback!(instance); end

  private

  def create_message_expectation_on(instance); end
  def invocation_order; end
end

# @private
class RSpec::Mocks::AnyInstance::ExpectationChain < ::RSpec::Mocks::AnyInstance::Chain
  # @return [ExpectationChain] a new instance of ExpectationChain
  def initialize(*args, &block); end

  # @return [Boolean]
  def expectation_fulfilled?; end

  private

  def verify_invocation_order(_rspec_method_name, *_args, &_block); end
end

# Delegates messages to each of the given targets in order to
# provide the fluent interface that is available off of message
# expectations when dealing with `any_instance`.
#
# `targets` will typically contain 1 of the `AnyInstance::Recorder`
# return values and N `MessageExpectation` instances (one per instance
# of the `any_instance` klass).
#
# @private
class RSpec::Mocks::AnyInstance::FluentInterfaceProxy
  # @return [FluentInterfaceProxy] a new instance of FluentInterfaceProxy
  def initialize(targets); end

  def method_missing(*args, &block); end

  private

  # @return [Boolean]
  def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end
end

# @private
class RSpec::Mocks::AnyInstance::MessageChains
  # @return [MessageChains] a new instance of MessageChains
  def initialize; end

  # @private
  def [](method_name); end

  # @private
  def add(method_name, chain); end

  # @private
  # @return [Boolean]
  def all_expectations_fulfilled?; end

  # @private
  def each_unfulfilled_expectation_matching(method_name, *args); end

  # @private
  # @return [Boolean]
  def has_expectation?(method_name); end

  # @private
  def playback!(instance, method_name); end

  # @private
  def received_expected_message!(method_name); end

  # @private
  def remove_stub_chains_for!(method_name); end

  # @private
  def unfulfilled_expectations; end

  private

  def raise_if_second_instance_to_receive_message(instance); end
end

# @private
class RSpec::Mocks::AnyInstance::PositiveExpectationChain < ::RSpec::Mocks::AnyInstance::ExpectationChain
  private

  def create_message_expectation_on(instance); end
  def invocation_order; end
end

RSpec::Mocks::AnyInstance::PositiveExpectationChain::ExpectationInvocationOrder = T.let(T.unsafe(nil), Hash)

# The `AnyInstance::Recorder` is responsible for redefining the klass's
# instance method in order to add any stubs/expectations the first time
# the method is called. It's not capable of updating a stub on an instance
# that's already been previously stubbed (either directly, or via
# `any_instance`).
#
# This proxy sits in front of the recorder and delegates both to it
# and to the `RSpec::Mocks::Proxy` for each already mocked or stubbed
# instance of the class, in order to propogates changes to the instances.
#
# Note that unlike `RSpec::Mocks::Proxy`, this proxy class is stateless
# and is not persisted in `RSpec::Mocks.space`.
#
# Proxying for the message expectation fluent interface (typically chained
# off of the return value of one of these methods) is provided by the
# `FluentInterfaceProxy` class below.
#
# @private
class RSpec::Mocks::AnyInstance::Proxy
  # @return [Proxy] a new instance of Proxy
  def initialize(recorder, target_proxies); end

  def expect_chain(*chain, &block); end
  def klass; end
  def should_not_receive(method_name, &block); end
  def should_receive(method_name, &block); end
  def stub(method_name_or_method_map, &block); end
  def stub_chain(*chain, &block); end
  def unstub(method_name); end

  private

  def perform_proxying(method_name, args, block, &target_proxy_block); end
end

# Given a class `TheClass`, `TheClass.any_instance` returns a `Recorder`,
# which records stubs and message expectations for later playback on
# instances of `TheClass`.
#
# Further constraints are stored in instances of [Chain](Chain).
#
# @see AnyInstance
# @see Chain
class RSpec::Mocks::AnyInstance::Recorder
  # @return [Recorder] a new instance of Recorder
  def initialize(klass); end

  # @private
  # @return [Boolean]
  def already_observing?(method_name); end

  # @private
  def build_alias_method_name(method_name); end

  # @private
  def expect_chain(*method_names_and_optional_return_values, &block); end

  # @private
  def instance_that_received(method_name); end

  # @private
  def klass; end

  # @private
  def message_chains; end

  # @private
  def notify_received_message(_object, message, args, _blk); end

  # @private
  def playback!(instance, method_name); end

  # The opposite of `should_receive`
  #
  # @see Methods#should_not_receive
  def should_not_receive(method_name, &block); end

  # Initializes the recording a message expectation to be played back
  # against any instance of this object that invokes the submitted
  # method.
  #
  # @see Methods#should_receive
  def should_receive(method_name, &block); end

  # @private
  def stop_all_observation!; end

  # Initializes the recording a stub to be played back against any
  # instance of this object that invokes the submitted method.
  #
  # @see Methods#stub
  def stub(method_name, &block); end

  # Initializes the recording a stub chain to be played back against any
  # instance of this object that invokes the method matching the first
  # argument.
  #
  # @see Methods#stub_chain
  def stub_chain(*method_names_and_optional_return_values, &block); end

  # @private
  def stubs; end

  # Removes any previously recorded stubs, stub_chains or message
  # expectations that use `method_name`.
  #
  # @see Methods#unstub
  def unstub(method_name); end

  # Used internally to verify that message expectations have been
  # fulfilled.
  #
  # @api private
  def verify; end

  protected

  def stop_observing!(method_name); end

  private

  def allow_no_prepended_module_definition_of(method_name); end

  # @return [Boolean]
  def ancestor_is_an_observer?(method_name); end

  def backup_method!(method_name); end
  def mark_invoked!(method_name); end

  # @yield [args.first, args]
  def normalize_chain(*args); end

  def observe!(method_name); end

  # @return [Boolean]
  def public_protected_or_private_method_defined?(method_name); end

  def received_expected_message!(method_name); end
  def remove_dummy_method!(method_name); end
  def restore_method!(method_name); end
  def restore_original_method!(method_name); end
  def super_class_observers_for(method_name); end

  # @return [Boolean]
  def super_class_observing?(method_name); end
end

# @private
class RSpec::Mocks::AnyInstance::StubChain < ::RSpec::Mocks::AnyInstance::Chain
  # @private
  # @return [Boolean]
  def expectation_fulfilled?; end

  private

  def create_message_expectation_on(instance); end
  def invocation_order; end

  # @raise [NoMethodError]
  def verify_invocation_order(rspec_method_name, *_args, &_block); end
end

RSpec::Mocks::AnyInstance::StubChain::EmptyInvocationOrder = T.let(T.unsafe(nil), Hash)
RSpec::Mocks::AnyInstance::StubChain::InvocationOrder = T.let(T.unsafe(nil), Hash)

# @private
class RSpec::Mocks::AnyInstance::StubChainChain < ::RSpec::Mocks::AnyInstance::StubChain
  # @return [StubChainChain] a new instance of StubChainChain
  def initialize(*args); end

  private

  def create_message_expectation_on(instance); end
  def invocation_order; end
end

# @private
class RSpec::Mocks::AnyInstanceAllowanceTarget < ::RSpec::Mocks::TargetBase
  def expression; end
  def not_to(matcher, *_args); end
  def to(matcher, &block); end
  def to_not(matcher, *_args); end
end

# @private
class RSpec::Mocks::AnyInstanceExpectationTarget < ::RSpec::Mocks::TargetBase
  def expression; end
  def not_to(matcher, &block); end
  def to(matcher, &block); end
  def to_not(matcher, &block); end
end

# Wrapper for matching arguments against a list of expected values. Used by
# the `with` method on a `MessageExpectation`:
#
#     expect(object).to receive(:message).with(:a, 'b', 3)
#     object.message(:a, 'b', 3)
#
# Values passed to `with` can be literal values or argument matchers that
# match against the real objects .e.g.
#
#     expect(object).to receive(:message).with(hash_including(:a => 'b'))
#
# Can also be used directly to match the contents of any `Array`. This
# enables 3rd party mocking libs to take advantage of rspec's argument
# matching without using the rest of rspec-mocks.
#
#     require 'rspec/mocks/argument_list_matcher'
#     include RSpec::Mocks::ArgumentMatchers
#
#     arg_list_matcher = RSpec::Mocks::ArgumentListMatcher.new(123, hash_including(:a => 'b'))
#     arg_list_matcher.args_match?(123, :a => 'b')
#
# This class is immutable.
#
# @see ArgumentMatchers
class RSpec::Mocks::ArgumentListMatcher
  # Initializes an `ArgumentListMatcher` with a collection of literal
  # values and/or argument matchers.
  #
  # @api public
  # @param expected_args [Array] a list of expected literals and/or argument matchers
  # @return [ArgumentListMatcher] a new instance of ArgumentListMatcher
  # @see ArgumentMatchers
  # @see #args_match?
  def initialize(*expected_args, **_arg1); end

  # Matches each element in the `expected_args` against the element in the same
  # position of the arguments passed to `new`.
  #
  # @api public
  # @param actual_args [Array]
  # @return [Boolean]
  # @see #initialize
  def args_match?(*actual_args, **_arg1); end

  # @private
  def expected_args; end

  # Resolves abstract arg placeholders like `no_args` and `any_args` into
  # a more concrete arg list based on the provided `actual_args`.
  #
  # @private
  def resolve_expected_args_based_on(actual_args); end

  private

  def ensure_expected_args_valid!; end
  def replace_any_args_with_splat_of_anything(before_count, actual_args_count); end
end

# Value that will match all argument lists.
#
# @private
RSpec::Mocks::ArgumentListMatcher::MATCH_ALL = T.let(T.unsafe(nil), RSpec::Mocks::ArgumentListMatcher)

# ArgumentMatchers are placeholders that you can include in message
# expectations to match arguments against a broader check than simple
# equality.
#
# With the exception of `any_args` and `no_args`, they all match against
# the arg in same position in the argument list.
#
# @see ArgumentListMatcher
module RSpec::Mocks::ArgumentMatchers
  # Matches if `arg.kind_of?(klass)`
  #
  # @example
  #   expect(object).to receive(:message).with(kind_of(Thing))
  def a_kind_of(klass); end

  # Matches if `arg.instance_of?(klass)`
  #
  # @example
  #   expect(object).to receive(:message).with(instance_of(Thing))
  def an_instance_of(klass); end

  # Acts like an arg splat, matching any number of args at any point in an arg list.
  #
  # @example
  #   expect(object).to receive(:message).with(1, 2, any_args)
  #
  #   # matches any of these:
  #   object.message(1, 2)
  #   object.message(1, 2, 3)
  #   object.message(1, 2, 3, 4)
  def any_args; end

  # Matches any argument at all.
  #
  # @example
  #   expect(object).to receive(:message).with(anything)
  def anything; end

  # Matches an array that includes the specified items at least once.
  # Ignores duplicates and additional values
  #
  # @example
  #   expect(object).to receive(:message).with(array_including(1,2,3))
  #   expect(object).to receive(:message).with(array_including([1,2,3]))
  def array_including(*args); end

  # Matches a boolean value.
  #
  # @example
  #   expect(object).to receive(:message).with(boolean())
  def boolean; end

  # Matches if the actual argument responds to the specified messages.
  #
  # @example
  #   expect(object).to receive(:message).with(duck_type(:hello))
  #   expect(object).to receive(:message).with(duck_type(:hello, :goodbye))
  def duck_type(*args); end

  # Matches a hash that doesn't include the specified key(s) or key/value.
  #
  # @example
  #   expect(object).to receive(:message).with(hash_excluding(:key => val))
  #   expect(object).to receive(:message).with(hash_excluding(:key))
  #   expect(object).to receive(:message).with(hash_excluding(:key, :key2 => :val2))
  def hash_excluding(*args); end

  # Matches a hash that includes the specified key(s) or key/value pairs.
  # Ignores any additional keys.
  #
  # @example
  #   expect(object).to receive(:message).with(hash_including(:key => val))
  #   expect(object).to receive(:message).with(hash_including(:key))
  #   expect(object).to receive(:message).with(hash_including(:key, :key2 => val2))
  def hash_including(*args); end

  # Matches a hash that doesn't include the specified key(s) or key/value.
  #
  # @example
  #   expect(object).to receive(:message).with(hash_excluding(:key => val))
  #   expect(object).to receive(:message).with(hash_excluding(:key))
  #   expect(object).to receive(:message).with(hash_excluding(:key, :key2 => :val2))
  def hash_not_including(*args); end

  # Matches if `arg.instance_of?(klass)`
  #
  # @example
  #   expect(object).to receive(:message).with(instance_of(Thing))
  def instance_of(klass); end

  # Matches if `arg.kind_of?(klass)`
  #
  # @example
  #   expect(object).to receive(:message).with(kind_of(Thing))
  def kind_of(klass); end

  # Matches no arguments.
  #
  # @example
  #   expect(object).to receive(:message).with(no_args)
  def no_args; end

  class << self
    # @private
    def anythingize_lonely_keys(*args); end
  end
end

# @private
class RSpec::Mocks::ArgumentMatchers::AnyArgMatcher < ::RSpec::Mocks::ArgumentMatchers::SingletonMatcher
  def ===(_other); end
  def description; end
end

RSpec::Mocks::ArgumentMatchers::AnyArgMatcher::INSTANCE = T.let(T.unsafe(nil), RSpec::Mocks::ArgumentMatchers::AnyArgMatcher)

# @private
class RSpec::Mocks::ArgumentMatchers::AnyArgsMatcher < ::RSpec::Mocks::ArgumentMatchers::SingletonMatcher
  def description; end
end

RSpec::Mocks::ArgumentMatchers::AnyArgsMatcher::INSTANCE = T.let(T.unsafe(nil), RSpec::Mocks::ArgumentMatchers::AnyArgsMatcher)

# @private
class RSpec::Mocks::ArgumentMatchers::ArrayIncludingMatcher
  # @return [ArrayIncludingMatcher] a new instance of ArrayIncludingMatcher
  def initialize(expected); end

  def ===(actual); end
  def description; end

  private

  def formatted_expected_values; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::BaseHashMatcher
  # @return [BaseHashMatcher] a new instance of BaseHashMatcher
  def initialize(expected); end

  def ===(predicate, actual); end
  def description(name); end

  private

  def formatted_expected_hash; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::BooleanMatcher < ::RSpec::Mocks::ArgumentMatchers::SingletonMatcher
  def ===(value); end
  def description; end
end

RSpec::Mocks::ArgumentMatchers::BooleanMatcher::INSTANCE = T.let(T.unsafe(nil), RSpec::Mocks::ArgumentMatchers::BooleanMatcher)

# @private
class RSpec::Mocks::ArgumentMatchers::DuckTypeMatcher
  # @return [DuckTypeMatcher] a new instance of DuckTypeMatcher
  def initialize(*methods_to_respond_to); end

  def ===(value); end
  def description; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::HashExcludingMatcher < ::RSpec::Mocks::ArgumentMatchers::BaseHashMatcher
  def ===(actual); end
  def description; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::HashIncludingMatcher < ::RSpec::Mocks::ArgumentMatchers::BaseHashMatcher
  def ===(actual); end
  def description; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::InstanceOf
  # @return [InstanceOf] a new instance of InstanceOf
  def initialize(klass); end

  def ===(actual); end
  def description; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::KindOf
  # @return [KindOf] a new instance of KindOf
  def initialize(klass); end

  def ===(actual); end
  def description; end
end

# @private
class RSpec::Mocks::ArgumentMatchers::NoArgsMatcher < ::RSpec::Mocks::ArgumentMatchers::SingletonMatcher
  def description; end
end

RSpec::Mocks::ArgumentMatchers::NoArgsMatcher::INSTANCE = T.let(T.unsafe(nil), RSpec::Mocks::ArgumentMatchers::NoArgsMatcher)

# Intended to be subclassed by stateless, immutable argument matchers.
# Provides a `<klass name>::INSTANCE` constant for accessing a global
# singleton instance of the matcher. There is no need to construct
# multiple instance since there is no state. It also facilities the
# special case logic we need for some of these matchers, by making it
# easy to do comparisons like: `[klass::INSTANCE] == args` rather than
# `args.count == 1 && klass === args.first`.
#
# @private
class RSpec::Mocks::ArgumentMatchers::SingletonMatcher
  class << self
    # @private
    def inherited(subklass); end
  end
end

# @private
class RSpec::Mocks::CallbackInvocationStrategy
  def call(doubled_module); end
end

# Raised for situations that RSpec cannot support due to mutations made
# externally on arguments that RSpec is holding onto to use for later
# comparisons.
#
# @deprecated We no longer raise this error but the constant remains until
#   RSpec 4 for SemVer reasons.
class RSpec::Mocks::CannotSupportArgMutationsError < ::StandardError; end

# When a class's `.new` method is stubbed, we want to use the method
# signature from `#initialize` because `.new`'s signature is a generic
# `def new(*args)` and it simply delegates to `#initialize` and forwards
# all args...so the method with the actually used signature is `#initialize`.
#
# This method reference implementation handles that specific case.
#
# @private
class RSpec::Mocks::ClassNewMethodReference < ::RSpec::Mocks::ObjectMethodReference
  def with_signature; end

  class << self
    # @return [Boolean]
    def applies_to?(method_name); end
  end
end

# Effectively the same as an ObjectVerifyingDouble (since a class is a type
# of object), except with Module in the inheritance chain so that
# transferring nested constants to work.
#
# @private
class RSpec::Mocks::ClassVerifyingDouble < ::Module
  include ::RSpec::Mocks::TestDouble
  include ::RSpec::Mocks::VerifyingDouble
  include ::RSpec::Mocks::ObjectVerifyingDoubleMethods
end

# Provides configuration options for rspec-mocks.
class RSpec::Mocks::Configuration
  # @return [Configuration] a new instance of Configuration
  def initialize; end

  # Adds `stub` and `should_receive` to the given
  # modules or classes. This is usually only necessary
  # if you application uses some proxy classes that
  # "strip themselves down" to a bare minimum set of
  # methods and remove `stub` and `should_receive` in
  # the process.
  #
  # @example
  #   RSpec.configure do |rspec|
  #   rspec.mock_with :rspec do |mocks|
  #   mocks.add_stub_and_should_receive_to Delegator
  #   end
  #   end
  def add_stub_and_should_receive_to(*modules); end

  # Sets whether RSpec will warn, ignore, or fail a test when
  # expectations are set on nil.
  # By default, when this flag is not set, warning messages are issued when
  # expectations are set on nil. This is to prevent false-positives and to
  # catch potential bugs early on.
  # When set to `true`, warning messages are suppressed.
  # When set to `false`, it will raise an error.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.mock_with :rspec do |mocks|
  #   mocks.allow_message_expectations_on_nil = false
  #   end
  #   end
  def allow_message_expectations_on_nil; end

  # Sets whether RSpec will warn, ignore, or fail a test when
  # expectations are set on nil.
  # By default, when this flag is not set, warning messages are issued when
  # expectations are set on nil. This is to prevent false-positives and to
  # catch potential bugs early on.
  # When set to `true`, warning messages are suppressed.
  # When set to `false`, it will raise an error.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.mock_with :rspec do |mocks|
  #   mocks.allow_message_expectations_on_nil = false
  #   end
  #   end
  def allow_message_expectations_on_nil=(_arg0); end

  # Provides a way to perform customisations when verifying doubles.
  #
  # @example
  #   RSpec::Mocks.configuration.before_verifying_doubles do |ref|
  #   ref.some_method!
  #   end
  def before_verifying_doubles(&block); end

  # Indicates whether or not diffs should be colored.
  # Delegates to rspec-core's color option if rspec-core
  # is loaded; otherwise you can set it here.
  #
  # @return [Boolean]
  def color?; end

  # Monkey-patch `Marshal.dump` to enable dumping of mocked or stubbed
  # objects. By default this will not work since RSpec mocks works by
  # adding singleton methods that cannot be serialized. This patch removes
  # these singleton methods before serialization. Setting to falsey removes
  # the patch.
  #
  # This method is idempotent.
  def patch_marshal_to_support_partial_doubles=(val); end

  # Resets the configured syntax to the default.
  #
  # @api private
  def reset_syntaxes_to_default; end

  # Returns an array with a list of syntaxes
  # that are enabled.
  #
  # @example
  #   unless RSpec::Mocks.configuration.syntax.include?(:expect)
  #   raise "this RSpec extension gem requires the rspec-mocks `:expect` syntax"
  #   end
  def syntax; end

  # Provides the ability to set either `expect`,
  # `should` or both syntaxes. RSpec uses `expect`
  # syntax by default. This is needed if you want to
  # explicitly enable `should` syntax and/or explicitly
  # disable `expect` syntax.
  #
  #  end
  #
  # @example
  #   RSpec.configure do |rspec|
  #   rspec.mock_with :rspec do |mocks|
  #   mocks.syntax = [:expect, :should]
  #   end
  def syntax=(*values); end

  # Used to track wether we are temporarily suppressing verifying partial
  # doubles with `without_partial_double_verification { ... }`
  #
  # @private
  def temporarily_suppress_partial_double_verification; end

  # Used to track wether we are temporarily suppressing verifying partial
  # doubles with `without_partial_double_verification { ... }`
  #
  # @private
  def temporarily_suppress_partial_double_verification=(_arg0); end

  # Sets the default for the `transfer_nested_constants` option when
  # stubbing constants.
  def transfer_nested_constants=(_arg0); end

  # @return [Boolean]
  def transfer_nested_constants?; end

  # When this is set to true, an error will be raised when
  # `instance_double` or `class_double` is given the name of an undefined
  # constant. You probably only want to set this when running your entire
  # test suite, with all production code loaded. Setting this for an
  # isolated unit test will prevent you from being able to isolate it!
  def verify_doubled_constant_names=(_arg0); end

  # @return [Boolean]
  def verify_doubled_constant_names?; end

  # When set to true, partial mocks will be verified the same as object
  # doubles. Any stubs will have their arguments checked against the original
  # method, and methods that do not exist cannot be stubbed.
  def verify_partial_doubles=(val); end

  # @return [Boolean]
  def verify_partial_doubles?; end

  # Returns an array of blocks to call when verifying doubles
  #
  # @api private
  def verifying_double_callbacks; end

  # Provides a way to perform customisations when verifying doubles.
  #
  # @example
  #   RSpec::Mocks.configuration.before_verifying_doubles do |ref|
  #   ref.some_method!
  #   end
  def when_declaring_verifying_double(&block); end

  # Sets whether or not RSpec will yield the receiving instance of a
  # message to blocks that are used for any_instance stub implementations.
  # When set, the first yielded argument will be the receiving instance.
  # Defaults to `true`.
  #
  # @example
  #   RSpec.configure do |rspec|
  #   rspec.mock_with :rspec do |mocks|
  #   mocks.yield_receiver_to_any_instance_implementation_blocks = false
  #   end
  #   end
  def yield_receiver_to_any_instance_implementation_blocks=(_arg0); end

  # @return [Boolean]
  def yield_receiver_to_any_instance_implementation_blocks?; end
end

# Provides information about constants that may (or may not)
# have been mutated by rspec-mocks.
class RSpec::Mocks::Constant
  extend ::RSpec::Support::RecursiveConstMethods

  # @api private
  # @return [Constant] a new instance of Constant
  # @yield [_self]
  # @yieldparam _self [RSpec::Mocks::Constant] the object that the method was called on
  def initialize(name); end

  # @private
  def hidden=(_arg0); end

  # @return [Boolean] Whether or not rspec-mocks has hidden
  #   this constant.
  def hidden?; end

  # The default `to_s` isn't very useful, so a custom version is provided.
  def inspect; end

  # @return [Boolean] Whether or not rspec-mocks has mutated
  #   (stubbed or hidden) this constant.
  def mutated?; end

  # @return [String] The fully qualified name of the constant.
  def name; end

  # @return [Object, nil] The original value (e.g. before it
  #   was mutated by rspec-mocks) of the constant, or
  #   nil if the constant was not previously defined.
  def original_value; end

  # @return [Object, nil] The original value (e.g. before it
  #   was mutated by rspec-mocks) of the constant, or
  #   nil if the constant was not previously defined.
  def original_value=(_arg0); end

  # @private
  def previously_defined=(_arg0); end

  # @return [Boolean] Whether or not the constant was defined
  #   before the current example.
  def previously_defined?; end

  # @private
  def stubbed=(_arg0); end

  # @return [Boolean] Whether or not rspec-mocks has stubbed
  #   this constant.
  def stubbed?; end

  # The default `to_s` isn't very useful, so a custom version is provided.
  def to_s; end

  # @private
  def valid_name=(_arg0); end

  # @return [Boolean] Whether or not the provided constant name
  #   is a valid Ruby constant name.
  def valid_name?; end

  class << self
    # Queries rspec-mocks to find out information about the named constant.
    #
    # @param name [String] the name of the constant
    # @return [Constant] an object contaning information about the named
    #   constant.
    def original(name); end

    # @private
    def unmutated(name); end
  end
end

# Provides a means to stub constants.
class RSpec::Mocks::ConstantMutator
  extend ::RSpec::Support::RecursiveConstMethods

  class << self
    # Hides a constant.
    #
    # @note It's recommended that you use `hide_const` in your
    #   examples. This is an alternate public API that is provided
    #   so you can hide constants in other contexts (e.g. helper
    #   classes).
    # @param constant_name [String] The fully qualified name of the constant.
    #   The current constant scoping at the point of call is not considered.
    # @see ExampleMethods#hide_const
    def hide(constant_name); end

    # Uses the mutator to mutate (stub or hide) a constant. Ensures that
    # the mutator is correctly registered so it can be backed out at the end
    # of the test.
    #
    # @private
    def mutate(mutator); end

    # Used internally by the constant stubbing to raise a helpful
    # error when a constant like "A::B::C" is stubbed and A::B is
    # not a module (and thus, it's impossible to define "A::B::C"
    # since only modules can have nested constants).
    #
    # @api private
    def raise_on_invalid_const; end

    # Stubs a constant.
    #
    # @note It's recommended that you use `stub_const` in your
    #   examples. This is an alternate public API that is provided
    #   so you can stub constants in other contexts (e.g. helper
    #   classes).
    # @option options
    # @param constant_name [String] The fully qualified name of the constant. The current
    #   constant scoping at the point of call is not considered.
    # @param value [Object] The value to make the constant refer to. When the
    #   example completes, the constant will be restored to its prior state.
    # @param options [Hash] Stubbing options.
    # @return [Object] the stubbed value of the constant
    # @see ExampleMethods#stub_const
    def stub(constant_name, value, options = T.unsafe(nil)); end
  end
end

# Contains common functionality used by all of the constant mutators.
#
# @private
class RSpec::Mocks::ConstantMutator::BaseMutator
  include ::RSpec::Support::RecursiveConstMethods

  # @return [BaseMutator] a new instance of BaseMutator
  def initialize(full_constant_name, mutated_value, transfer_nested_constants); end

  # Returns the value of attribute full_constant_name.
  def full_constant_name; end

  def idempotently_reset; end

  # Returns the value of attribute original_value.
  def original_value; end

  def to_constant; end
end

# Hides a defined constant for the duration of an example.
#
# @private
class RSpec::Mocks::ConstantMutator::ConstantHider < ::RSpec::Mocks::ConstantMutator::BaseMutator
  def mutate; end
  def reset; end
  def to_constant; end
end

# Replaces a defined constant for the duration of an example.
#
# @private
class RSpec::Mocks::ConstantMutator::DefinedConstantReplacer < ::RSpec::Mocks::ConstantMutator::BaseMutator
  # @return [DefinedConstantReplacer] a new instance of DefinedConstantReplacer
  def initialize(*args); end

  def mutate; end
  def reset; end

  # @return [Boolean]
  def should_transfer_nested_constants?; end

  def to_constant; end
  def transfer_nested_constants; end
  def verify_constants_to_transfer!; end
end

# Sets an undefined constant for the duration of an example.
#
# @private
class RSpec::Mocks::ConstantMutator::UndefinedConstantSetter < ::RSpec::Mocks::ConstantMutator::BaseMutator
  def mutate; end
  def reset; end
  def to_constant; end

  private

  def name_for(parent, name); end
end

# @private
RSpec::Mocks::DEFAULT_CALLBACK_INVOCATION_STRATEGY = T.let(T.unsafe(nil), RSpec::Mocks::CallbackInvocationStrategy)

# An implementation of rspec-mocks' reference interface.
# Used when an object is passed to {ExampleMethods#object_double}, or
# an anonymous class or module is passed to {ExampleMethods#instance_double}
# or {ExampleMethods#class_double}.
# Represents a reference to that object.
#
# @see NamedObjectReference
class RSpec::Mocks::DirectObjectReference
  # @param object [Object] the object to which this refers
  # @return [DirectObjectReference] a new instance of DirectObjectReference
  def initialize(object); end

  # Defined for interface parity with the other object reference
  # implementations. Raises an `ArgumentError` to indicate that `as_stubbed_const`
  # is invalid when passing an object argument to `object_double`.
  #
  # @raise [ArgumentError]
  def const_to_replace; end

  # Always returns true for an object as the class is defined.
  #
  # @return [true]
  def defined?; end

  # @return [String] the object's description (via `#inspect`).
  def description; end

  # The target of the verifying double (the object itself).
  #
  # @return [Object]
  def target; end

  # Yields if the reference target is loaded, providing a generic mechanism
  # to optionally run a bit of code only when a reference's target is
  # loaded.
  #
  # This specific implementation always yields because direct references
  # are always loaded.
  #
  # @yield [Object] the target of this reference.
  def when_loaded; end
end

# A generic test double object. `double`, `instance_double` and friends
# return an instance of this.
class RSpec::Mocks::Double
  include ::RSpec::Mocks::TestDouble
end

# @private
class RSpec::Mocks::ErrorGenerator
  # @return [ErrorGenerator] a new instance of ErrorGenerator
  def initialize(target = T.unsafe(nil)); end

  def default_error_message(expectation, expected_args, actual_args); end

  # @private
  def describe_expectation(verb, message, expected_received_count, _actual_received_count, args); end

  def expectation_on_nil_message(method_name); end

  # @private
  def intro(unwrapped = T.unsafe(nil)); end

  # @private
  def method_call_args_description(args, generic_prefix = T.unsafe(nil), matcher_prefix = T.unsafe(nil)); end

  # @private
  def opts; end

  # Sets the attribute opts
  #
  # @param value the value to set the attribute opts to.
  def opts=(_arg0); end

  # @private
  def raise_already_invoked_error(message, calling_customization); end

  # @private
  def raise_cant_constrain_count_for_negated_have_received_error(count_constraint); end

  # @private
  def raise_double_negation_error(wrapped_expression); end

  # @private
  def raise_expectation_error(message, expected_received_count, argument_list_matcher, actual_received_count, expectation_count_type, args, backtrace_line = T.unsafe(nil), source_id = T.unsafe(nil)); end

  # @private
  def raise_expectation_on_mocked_method(method); end

  def raise_expectation_on_nil_error(method_name); end

  # @private
  def raise_expectation_on_unstubbed_method(method); end

  # @private
  # @raise [ExpiredTestDoubleError]
  def raise_expired_test_double_error; end

  # @private
  def raise_have_received_disallowed(type, reason); end

  # @private
  def raise_invalid_arguments_error(verifier); end

  # @private
  def raise_method_not_stubbed_error(method_name); end

  # @private
  def raise_missing_block_error(args_to_yield); end

  # @private
  def raise_missing_default_stub_error(expectation, args_for_multiple_calls); end

  # @private
  # @raise [NoMethodError]
  def raise_non_public_error(method_name, visibility); end

  # @private
  def raise_only_valid_on_a_partial_double(method); end

  # @private
  def raise_out_of_order_error(message); end

  # @private
  def raise_similar_message_args_error(expectation, args_for_multiple_calls, backtrace_line = T.unsafe(nil)); end

  # @private
  def raise_unexpected_message_args_error(expectation, args_for_multiple_calls, source_id = T.unsafe(nil)); end

  # @private
  def raise_unexpected_message_error(message, args); end

  # @private
  def raise_unimplemented_error(doubled_module, method_name, object); end

  # @private
  def raise_verifying_double_not_defined_error(ref); end

  # @private
  def raise_wrong_arity_error(args_to_yield, signature); end

  private

  def __raise(message, backtrace_line = T.unsafe(nil), source_id = T.unsafe(nil)); end
  def arg_list(args); end
  def count_message(count, expectation_count_type = T.unsafe(nil)); end
  def diff_message(expected_args, actual_args); end
  def differ; end
  def error_message(expectation, args_for_multiple_calls); end
  def expected_part_of_expectation_error(expected_received_count, expectation_count_type, argument_list_matcher); end
  def format_args(args); end
  def format_received_args(args_for_multiple_calls); end
  def group_count(index, args); end
  def grouped_args(args); end

  # @return [Boolean]
  def list_of_exactly_one_string?(args); end

  def notify(*args); end
  def prepend_to_backtrace(exception, line); end
  def received_part_of_expectation_error(actual_received_count, args); end
  def times(count); end
  def unexpected_arguments_message(expected_args_string, actual_args_string); end
  def unpack_string_args(formatted_expected_args, actual_args); end
end

# Contains methods intended to be used from within code examples.
# Mix this in to your test context (such as a test framework base class)
# to use rspec-mocks with your test framework. If you're using rspec-core,
# it'll take care of doing this for you.
module RSpec::Mocks::ExampleMethods
  include ::RSpec::Mocks::ArgumentMatchers
  include ::RSpec::Mocks::ExampleMethods::ExpectHost

  # Used to wrap an object in preparation for stubbing a method
  # on it.
  #
  # @example
  #   allow(dbl).to receive(:foo).with(5).and_return(:return_value)
  # @note If you disable the `:expect` syntax this method will be undefined.
  def allow(target); end

  # Used to wrap a class in preparation for stubbing a method
  # on instances of it.
  #
  # @example
  #   allow_any_instance_of(MyClass).to receive(:foo)
  # @note This is only available when you have enabled the `expect` syntax.
  def allow_any_instance_of(klass); end

  # Disables warning messages about expectations being set on nil.
  #
  # By default warning messages are issued when expectations are set on
  # nil.  This is to prevent false-positives and to catch potential bugs
  # early on.
  #
  # @deprecated Use {RSpec::Mocks::Configuration#allow_message_expectations_on_nil} instead.
  def allow_message_expectations_on_nil; end

  # Constructs a test double against a specific class. If the given class
  # name has been loaded, only class methods defined on the class are
  # allowed to be stubbed. In all other ways it behaves like a
  # [double](double).
  #
  # @overload class_double
  # @overload class_double
  # @overload class_double
  # @overload class_double
  # @return ClassVerifyingDouble
  def class_double(doubled_class, *args); end

  # Constructs a test double that is optimized for use with `have_received`
  # against a specific class. If the given class name has been loaded,
  # only class methods defined on the class are allowed to be stubbed.
  # With a normal double one has to stub methods in order to be able to spy
  # them. An class_spy automatically spies on all class methods to which the
  # class responds.
  #
  # @overload class_spy
  # @overload class_spy
  # @overload class_spy
  # @overload class_spy
  # @return ClassVerifyingDouble
  def class_spy(*args); end

  # Constructs an instance of [RSpec::Mocks::Double](RSpec::Mocks::Double) configured
  # with an optional name, used for reporting in failure messages, and an optional
  # hash of message/return-value pairs.
  #
  # @example
  #   book = double("book", :title => "The RSpec Book")
  #   book.title #=> "The RSpec Book"
  #
  #   card = double("card", :suit => "Spades", :rank => "A")
  #   card.suit  #=> "Spades"
  #   card.rank  #=> "A"
  # @overload double
  # @overload double
  # @overload double
  # @overload double
  # @return [Double]
  def double(*args); end

  # Used to wrap a class in preparation for setting a mock expectation
  # on instances of it.
  #
  # @example
  #   expect_any_instance_of(MyClass).to receive(:foo)
  # @note If you disable the `:expect` syntax this method will be undefined.
  def expect_any_instance_of(klass); end

  # Verifies that the given object received the expected message during the
  # course of the test. On a spy objects or as null object doubles this
  # works for any method, on other objects the method must have
  # been stubbed beforehand in order for messages to be verified.
  #
  # Stubbing and verifying messages received in this way implements the
  # Test Spy pattern.
  #
  # @example
  #   invitation = double('invitation', accept: true)
  #   user.accept_invitation(invitation)
  #   expect(invitation).to have_received(:accept)
  #
  #   # You can also use most message expectations:
  #   expect(invitation).to have_received(:accept).with(mailer).once
  # @note `have_received(...).with(...)` is unable to work properly when
  #   passed arguments are mutated after the spy records the received message.
  # @param method_name [Symbol] name of the method expected to have been
  #   called.
  def have_received(method_name, &block); end

  # Hides the named constant with the given value. The constant will be
  # undefined for the duration of the test.
  #
  # Like method stubs, the constant will be restored to its original value
  # when the example completes.
  #
  # @example
  #   hide_const("MyClass") # => MyClass is now an undefined constant
  # @param constant_name [String] The fully qualified name of the constant.
  #   The current constant scoping at the point of call is not considered.
  def hide_const(constant_name); end

  # Constructs a test double against a specific class. If the given class
  # name has been loaded, only instance methods defined on the class are
  # allowed to be stubbed. In all other ways it behaves like a
  # [double](double).
  #
  # @overload instance_double
  # @overload instance_double
  # @overload instance_double
  # @overload instance_double
  # @return InstanceVerifyingDouble
  def instance_double(doubled_class, *args); end

  # Constructs a test double that is optimized for use with `have_received`
  # against a specific class. If the given class name has been loaded, only
  # instance methods defined on the class are allowed to be stubbed.  With
  # a normal double one has to stub methods in order to be able to spy
  # them. An instance_spy automatically spies on all instance methods to
  # which the class responds.
  #
  # @overload instance_spy
  # @overload instance_spy
  # @overload instance_spy
  # @overload instance_spy
  # @return InstanceVerifyingDouble
  def instance_spy(*args); end

  # Constructs a test double against a specific object. Only the methods
  # the object responds to are allowed to be stubbed. If a String argument
  # is provided, it is assumed to reference a constant object which is used
  # for verification. In all other ways it behaves like a [double](double).
  #
  # @overload object_double
  # @overload object_double
  # @overload object_double
  # @overload object_double
  # @return ObjectVerifyingDouble
  def object_double(object_or_name, *args); end

  # Constructs a test double that is optimized for use with `have_received`
  # against a specific object. Only instance methods defined on the object
  # are allowed to be stubbed.  With a normal double one has to stub
  # methods in order to be able to spy them. An object_spy automatically
  # spies on all methods to which the object responds.
  #
  # @overload object_spy
  # @overload object_spy
  # @overload object_spy
  # @overload object_spy
  # @return ObjectVerifyingDouble
  def object_spy(*args); end

  # Used to specify a message that you expect or allow an object
  # to receive. The object returned by `receive` supports the same
  # fluent interface that `should_receive` and `stub` have always
  # supported, allowing you to constrain the arguments or number of
  # times, and configure how the object should respond to the message.
  #
  # @example
  #   expect(obj).to receive(:hello).with("world").exactly(3).times
  # @note If you disable the `:expect` syntax this method will be undefined.
  def receive(method_name, &block); end

  # stubs/mocks a chain of messages on an object or test double.
  #
  # ## Warning:
  #
  # Chains can be arbitrarily long, which makes it quite painless to
  # violate the Law of Demeter in violent ways, so you should consider any
  # use of `receive_message_chain` a code smell. Even though not all code smells
  # indicate real problems (think fluent interfaces), `receive_message_chain` still
  # results in brittle examples.  For example, if you write
  # `allow(foo).to receive_message_chain(:bar, :baz => 37)` in a spec and then the
  # implementation calls `foo.baz.bar`, the stub will not work.
  #
  # @example
  #   allow(double).to receive_message_chain("foo.bar") { :baz }
  #   allow(double).to receive_message_chain(:foo, :bar => :baz)
  #   allow(double).to receive_message_chain(:foo, :bar) { :baz }
  #
  #   # Given any of ^^ these three forms ^^:
  #   double.foo.bar # => :baz
  #
  #   # Common use in Rails/ActiveRecord:
  #   allow(Article).to receive_message_chain("recent.published") { [Article.new] }
  # @note If you disable the `:expect` syntax this method will be undefined.
  # @overload receive_message_chain
  # @overload receive_message_chain
  # @overload receive_message_chain
  def receive_message_chain(*messages, &block); end

  # Shorthand syntax used to setup message(s), and their return value(s),
  # that you expect or allow an object to receive. The method takes a hash
  # of messages and their respective return values. Unlike with `receive`,
  # you cannot apply further customizations using a block or the fluent
  # interface.
  #
  # @example
  #   allow(obj).to receive_messages(:speak => "Hello World")
  #   allow(obj).to receive_messages(:speak => "Hello", :meow => "Meow")
  # @note If you disable the `:expect` syntax this method will be undefined.
  def receive_messages(message_return_value_hash); end

  # Constructs a test double that is optimized for use with
  # `have_received`. With a normal double one has to stub methods in order
  # to be able to spy them. A spy automatically spies on all methods.
  #
  # @overload spy
  # @overload spy
  # @overload spy
  # @overload spy
  # @return [Double]
  def spy(*args); end

  # Stubs the named constant with the given value.
  # Like method stubs, the constant will be restored
  # to its original value (or lack of one, if it was
  # undefined) when the example completes.
  #
  # @example
  #   stub_const("MyClass", Class.new) # => Replaces (or defines) MyClass with a new class object.
  #   stub_const("SomeModel::PER_PAGE", 5) # => Sets SomeModel::PER_PAGE to 5.
  #
  #   class CardDeck
  #   SUITS = [:Spades, :Diamonds, :Clubs, :Hearts]
  #   NUM_CARDS = 52
  #   end
  #
  #   stub_const("CardDeck", Class.new)
  #   CardDeck::SUITS # => uninitialized constant error
  #   CardDeck::NUM_CARDS # => uninitialized constant error
  #
  #   stub_const("CardDeck", Class.new, :transfer_nested_constants => true)
  #   CardDeck::SUITS # => our suits array
  #   CardDeck::NUM_CARDS # => 52
  #
  #   stub_const("CardDeck", Class.new, :transfer_nested_constants => [:SUITS])
  #   CardDeck::SUITS # => our suits array
  #   CardDeck::NUM_CARDS # => uninitialized constant error
  # @option options
  # @param constant_name [String] The fully qualified name of the constant. The current
  #   constant scoping at the point of call is not considered.
  # @param value [Object] The value to make the constant refer to. When the
  #   example completes, the constant will be restored to its prior state.
  # @param options [Hash] Stubbing options.
  # @return [Object] the stubbed value of the constant
  def stub_const(constant_name, value, options = T.unsafe(nil)); end

  # Turns off the verifying of partial doubles for the duration of the
  # block, this is useful in situations where methods are defined at run
  # time and you wish to define stubs for them but not turn off partial
  # doubles for the entire run suite. (e.g. view specs in rspec-rails).
  def without_partial_double_verification; end

  class << self
    # @private
    def declare_double(type, *args); end

    # @private
    def declare_verifying_double(type, ref, *args); end

    # @private
    # @private
    def extended(object); end

    # @private
    # @private
    def included(klass); end
  end
end

# This module exists to host the `expect` method for cases where
# rspec-mocks is used w/o rspec-expectations.
module RSpec::Mocks::ExampleMethods::ExpectHost
  def expect(target); end
end

# @private
class RSpec::Mocks::ExpectChain < ::RSpec::Mocks::MessageChain
  private

  def expectation(object, message, &return_block); end

  class << self
    # @api private
    def expect_chain_on(object, *chain, &blk); end
  end
end

# @private
class RSpec::Mocks::ExpectationTarget < ::RSpec::Mocks::TargetBase
  include ::RSpec::Mocks::ExpectationTargetMethods
end

# @private
module RSpec::Mocks::ExpectationTargetMethods
  include ::RSpec::Mocks::TargetDelegationInstanceMethods
  extend ::RSpec::Mocks::TargetDelegationClassMethods

  def expression; end
  def not_to(matcher, &block); end
  def to(matcher, &block); end
  def to_not(matcher, &block); end
end

# Raised when a test double is used after it has been torn
# down (typically at the end of an rspec-core example).
class RSpec::Mocks::ExpiredTestDoubleError < ::RSpec::Mocks::MockExpectationError; end

# @private
RSpec::Mocks::IGNORED_BACKTRACE_LINE = T.let(T.unsafe(nil), String)

# Represents a configured implementation. Takes into account
# any number of sub-implementations.
#
# @private
class RSpec::Mocks::Implementation
  def call(*args, **_arg1, &block); end

  # Returns the value of attribute initial_action.
  def initial_action; end

  # Sets the attribute initial_action
  #
  # @param value the value to set the attribute initial_action to.
  def initial_action=(_arg0); end

  # Returns the value of attribute inner_action.
  def inner_action; end

  # Sets the attribute inner_action
  #
  # @param value the value to set the attribute inner_action to.
  def inner_action=(_arg0); end

  # @return [Boolean]
  def present?; end

  # Returns the value of attribute terminal_action.
  def terminal_action; end

  # Sets the attribute terminal_action
  #
  # @param value the value to set the attribute terminal_action to.
  def terminal_action=(_arg0); end

  private

  def actions; end
end

# @private
class RSpec::Mocks::InstanceMethodReference < ::RSpec::Mocks::MethodReference
  private

  def find_method(mod); end

  # Ideally, we'd use `respond_to?` for `method_implemented?` but we need a
  # reference to an instance to do that and we don't have one.  Note that
  # we may get false negatives: if the method is implemented via
  # `method_missing`, we'll return `false` even though it meets our
  # definition of "implemented". However, it's the best we can do.
  #
  # @return [Boolean]
  def method_defined?(mod); end

  # @return [Boolean]
  def method_implemented?(mod); end

  def visibility_from(mod); end
end

# @private
class RSpec::Mocks::InstanceMethodStasher
  # @return [InstanceMethodStasher] a new instance of InstanceMethodStasher
  def initialize(object, method); end

  # ruby 2.0.0-p247 and 2.0.0-p195 both have a bug that we can't work around :(.
  # https://bugs.ruby-lang.org/issues/8686
  def handle_restoration_failures; end

  # @private
  # @return [Boolean]
  def method_is_stashed?; end

  # Returns the value of attribute original_method.
  def original_method; end

  # @private
  def restore; end

  # @private
  def stash; end

  private

  # @private
  # @return [Boolean]
  def method_defined_directly_on_klass?; end

  # @private
  # @return [Boolean]
  def method_defined_on_klass?(klass = T.unsafe(nil)); end

  # @return [Boolean]
  def method_owned_by_klass?; end
end

# A mock providing a custom proxy that can verify the validity of any
# method stubs or expectations against the public instance methods of the
# given class.
#
# @private
class RSpec::Mocks::InstanceVerifyingDouble
  include ::RSpec::Mocks::TestDouble
  include ::RSpec::Mocks::VerifyingDouble

  def __build_mock_proxy(order_group); end
end

# Support for `patch_marshal_to_support_partial_doubles` configuration.
#
# @private
class RSpec::Mocks::MarshalExtension
  class << self
    def patch!; end
    def unpatch!; end
  end
end

# Namespace for mock-related matchers.
module RSpec::Mocks::Matchers; end

# @private
class RSpec::Mocks::Matchers::ExpectationCustomization
  # @return [ExpectationCustomization] a new instance of ExpectationCustomization
  def initialize(method_name, args, block); end

  # Returns the value of attribute block.
  def block; end

  # Sets the attribute block
  #
  # @param value the value to set the attribute block to.
  def block=(_arg0); end

  def playback_onto(expectation); end
end

# @private
class RSpec::Mocks::Matchers::HaveReceived
  include ::RSpec::Mocks::Matchers::Matcher

  # @return [HaveReceived] a new instance of HaveReceived
  def initialize(method_name, &block); end

  def at_least(*args); end
  def at_most(*args); end
  def description; end

  # @return [Boolean]
  def does_not_match?(subject); end

  def exactly(*args); end
  def failure_message; end
  def failure_message_when_negated; end

  # @return [Boolean]
  def matches?(subject, &block); end

  def name; end
  def once(*args); end
  def ordered(*args); end
  def setup_allowance(_subject, &_block); end
  def setup_any_instance_allowance(_subject, &_block); end
  def setup_any_instance_expectation(_subject, &_block); end
  def setup_any_instance_negative_expectation(_subject, &_block); end
  def setup_expectation(subject, &block); end
  def setup_negative_expectation(subject, &block); end
  def thrice(*args); end
  def time(*args); end
  def times(*args); end
  def twice(*args); end
  def with(*args); end

  private

  def apply_constraints_to(expectation); end
  def capture_failure_message; end
  def count_constraint; end
  def disallow(type, reason = T.unsafe(nil)); end
  def ensure_count_unconstrained; end
  def expect; end

  # @return [Boolean]
  def expected_messages_received_in_order?; end

  def mock_proxy; end
  def notify_failure_message; end
end

RSpec::Mocks::Matchers::HaveReceived::ARGS_CONSTRAINTS = T.let(T.unsafe(nil), Array)
RSpec::Mocks::Matchers::HaveReceived::CONSTRAINTS = T.let(T.unsafe(nil), Array)
RSpec::Mocks::Matchers::HaveReceived::COUNT_CONSTRAINTS = T.let(T.unsafe(nil), Array)

# just a "tag" for rspec-mock matchers detection
#
# @private
module RSpec::Mocks::Matchers::Matcher; end

# @private
class RSpec::Mocks::Matchers::Receive
  include ::RSpec::Mocks::Matchers::Matcher

  # @return [Receive] a new instance of Receive
  def initialize(message, block); end

  def and_call_original(*args, **_arg1, &block); end
  def and_invoke(*args, **_arg1, &block); end
  def and_raise(*args, **_arg1, &block); end
  def and_return(*args, **_arg1, &block); end
  def and_throw(*args, **_arg1, &block); end
  def and_wrap_original(*args, **_arg1, &block); end
  def and_yield(*args, **_arg1, &block); end
  def at_least(*args, **_arg1, &block); end
  def at_most(*args, **_arg1, &block); end
  def description; end
  def does_not_match?(subject, &block); end
  def exactly(*args, **_arg1, &block); end
  def matches?(subject, &block); end
  def name; end
  def never(*args, **_arg1, &block); end
  def once(*args, **_arg1, &block); end
  def ordered(*args, **_arg1, &block); end
  def setup_allowance(subject, &block); end
  def setup_any_instance_allowance(subject, &block); end
  def setup_any_instance_expectation(subject, &block); end
  def setup_any_instance_negative_expectation(subject, &block); end
  def setup_expectation(subject, &block); end
  def setup_negative_expectation(subject, &block); end
  def thrice(*args, **_arg1, &block); end
  def time(*args, **_arg1, &block); end
  def times(*args, **_arg1, &block); end
  def twice(*args, **_arg1, &block); end
  def with(*args, **_arg1, &block); end

  private

  def describable; end
  def move_block_to_last_customization(block); end
  def setup_any_instance_method_substitute(subject, method, block); end
  def setup_method_substitute(host, method, block, *args); end
  def setup_mock_proxy_method_substitute(subject, method, block); end
  def warn_if_any_instance(expression, subject); end
end

# MessageExpectation objects are able to describe themselves in detail.
# We use this as a fall back when a MessageExpectation is not available.
#
# @private
class RSpec::Mocks::Matchers::Receive::DefaultDescribable
  # @return [DefaultDescribable] a new instance of DefaultDescribable
  def initialize(message); end

  # This is much simpler for the `any_instance` case than what the
  # user may want, but I'm not up for putting a bunch of effort
  # into full descriptions for `any_instance` expectations at this point :(.
  def description_for(verb); end
end

# @private
class RSpec::Mocks::Matchers::ReceiveMessageChain
  include ::RSpec::Mocks::Matchers::Matcher

  # @return [ReceiveMessageChain] a new instance of ReceiveMessageChain
  def initialize(chain, &block); end

  def and_call_original(*args, &block); end
  def and_invoke(*args, &block); end
  def and_raise(*args, &block); end
  def and_return(*args, &block); end
  def and_throw(*args, &block); end
  def and_yield(*args, &block); end
  def description; end

  # @raise [NegationUnsupportedError]
  def does_not_match?(*_args); end

  def matches?(subject, &block); end
  def name; end
  def setup_allowance(subject, &block); end
  def setup_any_instance_allowance(subject, &block); end
  def setup_any_instance_expectation(subject, &block); end
  def setup_expectation(subject, &block); end

  # @raise [NegationUnsupportedError]
  def setup_negative_expectation(*_args); end

  def with(*args, &block); end

  private

  def formatted_chain; end
  def replay_customizations(chain); end
end

# @private
class RSpec::Mocks::Matchers::ReceiveMessages
  include ::RSpec::Mocks::Matchers::Matcher

  # @return [ReceiveMessages] a new instance of ReceiveMessages
  def initialize(message_return_value_hash); end

  def description; end

  # @raise [NegationUnsupportedError]
  def does_not_match?(_subject); end

  def matches?(subject); end
  def name; end
  def setup_allowance(subject); end
  def setup_any_instance_allowance(subject); end
  def setup_any_instance_expectation(subject); end
  def setup_expectation(subject); end

  # @raise [NegationUnsupportedError]
  def setup_negative_expectation(_subject); end

  def warn_about_block; end

  private

  def any_instance_of(subject); end
  def each_message_on(host); end
  def proxy_on(subject); end
end

# @private
class RSpec::Mocks::MessageChain
  # @return [MessageChain] a new instance of MessageChain
  def initialize(object, *chain, &blk); end

  # Returns the value of attribute block.
  def block; end

  # Returns the value of attribute chain.
  def chain; end

  # Returns the value of attribute object.
  def object; end

  # @api private
  def setup_chain; end

  private

  def chain_on(object, *chain, &block); end
  def find_matching_expectation; end
  def find_matching_stub; end
  def format_chain(*chain, &blk); end
end

# Represents an individual method stub or message expectation. The methods
# defined here can be used to configure how it behaves. The methods return
# `self` so that they can be chained together to form a fluent interface.
class RSpec::Mocks::MessageExpectation
  include ::RSpec::Mocks::MessageExpectation::ImplementationDetails

  # Tells the object to delegate to the original unmodified method
  # when it receives the message.
  #
  # @example
  #   expect(counter).to receive(:increment).and_call_original
  #   original_count = counter.count
  #   counter.increment
  #   expect(counter.count).to eq(original_count + 1)
  # @note This is only available on partial doubles.
  # @return [nil] No further chaining is supported after this.
  def and_call_original; end

  # Tells the object to invoke a Proc when it receives the message. Given
  # more than one value, the result of the first Proc is returned the first
  # time the message is received, the result of the second Proc is returned
  # the next time, etc, etc.
  #
  # If the message is received more times than there are Procs, the result of
  # the last Proc is returned for every subsequent call.
  #
  # @example
  #   allow(api).to receive(:get_foo).and_invoke(-> { raise ApiTimeout })
  #   api.get_foo # => raises ApiTimeout
  #   api.get_foo # => raises ApiTimeout
  #
  #   allow(api).to receive(:get_foo).and_invoke(-> { raise ApiTimeout }, -> { raise ApiTimeout }, -> { :a_foo })
  #   api.get_foo # => raises ApiTimeout
  #   api.get_foo # => rasies ApiTimeout
  #   api.get_foo # => :a_foo
  #   api.get_foo # => :a_foo
  #   api.get_foo # => :a_foo
  #   # etc
  # @return [nil] No further chaining is supported after this.
  def and_invoke(first_proc, *procs); end

  # Tells the object to raise an exception when the message is received.
  #
  # @example
  #   allow(car).to receive(:go).and_raise
  #   allow(car).to receive(:go).and_raise(OutOfGas)
  #   allow(car).to receive(:go).and_raise(OutOfGas, "At least 2 oz of gas needed to drive")
  #   allow(car).to receive(:go).and_raise(OutOfGas.new(2, :oz))
  # @note When you pass an exception class, the MessageExpectation will raise
  #   an instance of it, creating it with `exception` and passing `message`
  #   if specified.  If the exception class initializer requires more than
  #   one parameters, you must pass in an instance and not the class,
  #   otherwise this method will raise an ArgumentError exception.
  # @overload and_raise
  # @overload and_raise
  # @overload and_raise
  # @overload and_raise
  # @return [nil] No further chaining is supported after this.
  def and_raise(*args); end

  # Tells the object to return a value when it receives the message.  Given
  # more than one value, the first value is returned the first time the
  # message is received, the second value is returned the next time, etc,
  # etc.
  #
  # If the message is received more times than there are values, the last
  # value is returned for every subsequent call.
  #
  # @example
  #   allow(counter).to receive(:count).and_return(1)
  #   counter.count # => 1
  #   counter.count # => 1
  #
  #   allow(counter).to receive(:count).and_return(1,2,3)
  #   counter.count # => 1
  #   counter.count # => 2
  #   counter.count # => 3
  #   counter.count # => 3
  #   counter.count # => 3
  #   # etc
  # @overload and_return
  # @overload and_return
  # @return [nil] No further chaining is supported after this.
  def and_return(first_value, *values); end

  # Tells the object to throw a symbol (with the object if that form is
  # used) when the message is received.
  #
  # @example
  #   allow(car).to receive(:go).and_throw(:out_of_gas)
  #   allow(car).to receive(:go).and_throw(:out_of_gas, :level => 0.1)
  # @overload and_throw
  # @overload and_throw
  # @return [nil] No further chaining is supported after this.
  def and_throw(*args); end

  # Decorates the stubbed method with the supplied block. The original
  # unmodified method is passed to the block along with any method call
  # arguments so you can delegate to it, whilst still being able to
  # change what args are passed to it and/or change the return value.
  #
  # @example
  #   expect(api).to receive(:large_list).and_wrap_original do |original_method, *args, &block|
  #   original_method.call(*args, &block).first(10)
  #   end
  # @note This is only available on partial doubles.
  # @return [nil] No further chaining is supported after this.
  def and_wrap_original(&block); end

  # Tells the object to yield one or more args to a block when the message
  # is received.
  #
  # @example
  #   stream.stub(:open).and_yield(StringIO.new)
  # @return [MessageExpectation] self, to support further chaining.
  # @yield [@eval_context = Object.new]
  def and_yield(*args, &block); end

  # Constrain a message expectation to be received at least a specific
  # number of times.
  #
  # @example
  #   expect(dealer).to receive(:deal_card).at_least(9).times
  # @return [MessageExpectation] self, to support further chaining.
  def at_least(n, &block); end

  # Constrain a message expectation to be received at most a specific
  # number of times.
  #
  # @example
  #   expect(dealer).to receive(:deal_card).at_most(10).times
  # @return [MessageExpectation] self, to support further chaining.
  def at_most(n, &block); end

  # Constrain a message expectation to be received a specific number of
  # times.
  #
  # @example
  #   expect(dealer).to receive(:deal_card).exactly(10).times
  # @return [MessageExpectation] self, to support further chaining.
  def exactly(n, &block); end

  # @return [String] a nice representation of the message expectation
  def inspect; end

  # Expect a message not to be received at all.
  #
  # @example
  #   expect(car).to receive(:stop).never
  # @return [MessageExpectation] self, to support further chaining.
  def never; end

  # Expect a message to be received exactly one time.
  #
  # @example
  #   expect(car).to receive(:go).once
  # @return [MessageExpectation] self, to support further chaining.
  def once(&block); end

  # Expect messages to be received in a specific order.
  #
  # @example
  #   expect(api).to receive(:prepare).ordered
  #   expect(api).to receive(:run).ordered
  #   expect(api).to receive(:finish).ordered
  # @return [MessageExpectation] self, to support further chaining.
  def ordered(&block); end

  # Expect a message to be received exactly three times.
  #
  # @example
  #   expect(car).to receive(:go).thrice
  # @return [MessageExpectation] self, to support further chaining.
  def thrice(&block); end

  # Syntactic sugar for `exactly`, `at_least` and `at_most`
  #
  # @example
  #   expect(dealer).to receive(:deal_card).exactly(10).times
  #   expect(dealer).to receive(:deal_card).at_least(10).times
  #   expect(dealer).to receive(:deal_card).at_most(10).times
  # @return [MessageExpectation] self, to support further chaining.
  def time(&block); end

  # Syntactic sugar for `exactly`, `at_least` and `at_most`
  #
  # @example
  #   expect(dealer).to receive(:deal_card).exactly(10).times
  #   expect(dealer).to receive(:deal_card).at_least(10).times
  #   expect(dealer).to receive(:deal_card).at_most(10).times
  # @return [MessageExpectation] self, to support further chaining.
  def times(&block); end

  # @return [String] a nice representation of the message expectation
  def to_s; end

  # Expect a message to be received exactly two times.
  #
  # @example
  #   expect(car).to receive(:go).twice
  # @return [MessageExpectation] self, to support further chaining.
  def twice(&block); end

  # Constrains a stub or message expectation to invocations with specific
  # arguments.
  #
  # With a stub, if the message might be received with other args as well,
  # you should stub a default value first, and then stub or mock the same
  # message using `with` to constrain to specific arguments.
  #
  # A message expectation will fail if the message is received with different
  # arguments.
  #
  # @example
  #   allow(cart).to receive(:add) { :failure }
  #   allow(cart).to receive(:add).with(Book.new(:isbn => 1934356379)) { :success }
  #   cart.add(Book.new(:isbn => 1234567890))
  #   # => :failure
  #   cart.add(Book.new(:isbn => 1934356379))
  #   # => :success
  #
  #   expect(cart).to receive(:add).with(Book.new(:isbn => 1934356379)) { :success }
  #   cart.add(Book.new(:isbn => 1234567890))
  #   # => failed expectation
  #   cart.add(Book.new(:isbn => 1934356379))
  #   # => passes
  # @return [MessageExpectation] self, to support further chaining.
  def with(*args, **_arg1, &block); end
end

# Contains the parts of `MessageExpectation` that aren't part of
# rspec-mocks' public API. The class is very big and could really use
# some collaborators it delegates to for this stuff but for now this was
# the simplest way to split the public from private stuff to make it
# easier to publish the docs for the APIs we want published.
#
# @private
module RSpec::Mocks::MessageExpectation::ImplementationDetails
  def initialize(error_generator, expectation_ordering, expected_from, method_double, type = T.unsafe(nil), opts = T.unsafe(nil), &implementation_block); end

  # @return [Boolean]
  def actual_received_count_matters?; end

  def additional_expected_calls; end
  def advise(*args); end
  def and_yield_receiver_to_implementation; end

  # Sets the attribute argument_list_matcher
  #
  # @param value the value to set the attribute argument_list_matcher to.
  def argument_list_matcher=(_arg0); end

  # @return [Boolean]
  def called_max_times?; end

  def description_for(verb); end
  def ensure_expected_ordering_received!; end

  # Returns the value of attribute error_generator.
  def error_generator; end

  def expectation_count_type; end
  def expected_args; end

  # @return [Boolean]
  def expected_messages_received?; end

  def generate_error; end

  # @return [Boolean]
  def ignoring_args?; end

  # Returns the value of attribute implementation.
  def implementation; end

  def increase_actual_received_count!; end
  def invoke(parent_stub, *args, **_arg2, &block); end
  def invoke_without_incrementing_received_count(parent_stub, *args, **_arg2, &block); end

  # @return [Boolean]
  def matches?(message, *args, **_arg2); end

  # @return [Boolean]
  def matches_at_least_count?; end

  # @return [Boolean]
  def matches_at_most_count?; end

  # @return [Boolean]
  def matches_exact_count?; end

  def matches_name_but_not_args(message, *args); end

  # Returns the value of attribute message.
  def message; end

  # @return [Boolean]
  def negative?; end

  # @return [Boolean]
  def negative_expectation_for?(message); end

  # @return [Boolean]
  def ordered?; end

  # Returns the value of attribute orig_object.
  def orig_object; end

  def raise_out_of_order_error; end
  def raise_unexpected_message_args_error(args_for_multiple_calls); end
  def safe_invoke(parent_stub, *args, **_arg2, &block); end
  def similar_messages; end

  # @private
  def type; end

  def unadvise(args); end
  def verify_messages_received; end

  # @return [Boolean]
  def yield_receiver_to_implementation_block?; end

  protected

  # Sets the attribute error_generator
  #
  # @param value the value to set the attribute error_generator to.
  def error_generator=(_arg0); end

  # Sets the attribute expected_from
  #
  # @param value the value to set the attribute expected_from to.
  def expected_from=(_arg0); end

  # Sets the attribute expected_received_count
  #
  # @param value the value to set the attribute expected_received_count to.
  def expected_received_count=(_arg0); end

  # Sets the attribute implementation
  #
  # @param value the value to set the attribute implementation to.
  def implementation=(_arg0); end

  private

  def exception_source_id; end

  # @return [Boolean]
  def has_been_invoked?; end

  def initial_implementation_action=(action); end
  def inner_implementation_action=(action); end
  def invoke_incrementing_actual_calls_by(increment, allowed_to_fail, parent_stub, *args, **_arg4, &block); end
  def raise_already_invoked_error_if_necessary(calling_customization); end
  def set_expected_received_count(relativity, n); end
  def terminal_implementation_action=(action); end
  def warn_about_stub_override; end
  def wrap_original(method_name, &block); end
end

# @private
class RSpec::Mocks::MethodDouble
  # @private
  # @return [MethodDouble] a new instance of MethodDouble
  def initialize(object, method_name, proxy); end

  # @private
  def add_default_stub(*args, &implementation); end

  # @private
  def add_expectation(error_generator, expectation_ordering, expected_from, opts, &implementation); end

  # @private
  def add_simple_expectation(method_name, response, error_generator, backtrace_line); end

  # A simple stub can only return a concrete value for a message, and
  # cannot match on arguments. It is used as an optimization over
  # `add_stub` / `add_expectation` where it is known in advance that this
  # is all that will be required of a stub, such as when passing attributes
  # to the `double` example method. They do not stash or restore existing method
  # definitions.
  #
  # @private
  def add_simple_stub(method_name, response); end

  # @private
  def add_stub(error_generator, expectation_ordering, expected_from, opts = T.unsafe(nil), &implementation); end

  # @private
  def build_expectation(error_generator, expectation_ordering); end

  # @private
  def clear; end

  # @private
  def configure_method; end

  # @private
  def define_proxy_method; end

  # @private
  def expectations; end

  # The type of message expectation to create has been extracted to its own
  # method so that subclasses can override it.
  #
  # @private
  def message_expectation_class; end

  # @private
  def method_name; end

  # @private
  def method_stasher; end

  # @private
  def object; end

  # @private
  def object_singleton_class; end

  def original_implementation_callable; end
  def original_method; end

  # The implementation of the proxied method. Subclasses may override this
  # method to perform additional operations.
  #
  # @private
  def proxy_method_invoked(_obj, *args, **_arg2, &block); end

  # @private
  def raise_method_not_stubbed_error; end

  # @private
  def remove_stub; end

  # @private
  def remove_stub_if_present; end

  # @private
  def reset; end

  # @private
  def restore_original_method; end

  # @private
  def restore_original_visibility; end

  def save_original_implementation_callable!; end

  # @private
  def setup_simple_method_double(method_name, response, collection, error_generator = T.unsafe(nil), backtrace_line = T.unsafe(nil)); end

  # @private
  def show_frozen_warning; end

  # @private
  def stubs; end

  # @private
  def verify; end

  # @private
  def visibility; end

  private

  def definition_target; end
  def new_rspec_prepended_module; end
  def remove_method_from_definition_target; end
  def usable_rspec_prepended_module; end
end

# We subclass `Module` in order to be able to easily detect our prepended module.
class RSpec::Mocks::MethodDouble::RSpecPrependedModule < ::Module; end

# Represents a method on an object that may or may not be defined.
# The method may be an instance method on a module or a method on
# any object.
#
# @private
class RSpec::Mocks::MethodReference
  # @return [MethodReference] a new instance of MethodReference
  def initialize(object_reference, method_name); end

  # A method is defined if we are able to get a `Method` object for it.
  # In that case, we can assert against metadata like the arity.
  #
  # @return [Boolean]
  def defined?; end

  # A method is implemented if sending the message does not result in
  # a `NoMethodError`. It might be dynamically implemented by
  # `method_missing`.
  #
  # @return [Boolean]
  def implemented?; end

  # Returns true if we definitively know that sending the method
  # will result in a `NoMethodError`.
  #
  # This is not simply the inverse of `implemented?`: there are
  # cases when we don't know if a method is implemented and
  # both `implemented?` and `unimplemented?` will return false.
  #
  # @return [Boolean]
  def unimplemented?; end

  def visibility; end

  # @yield [Support::MethodSignature.new(original)]
  def with_signature; end

  private

  def original_method; end

  class << self
    def for(object_reference, method_name); end
    def instance_method_visibility_for(klass, method_name); end
    def method_defined_at_any_visibility?(klass, method_name); end
    def method_visibility_for(object, method_name); end
  end
end

# Raised when an expectation customization method (e.g. `with`,
# `and_return`) is called on a message expectation which has already been
# invoked.
class RSpec::Mocks::MockExpectationAlreadyInvokedError < ::Exception; end

# Raised when a message expectation is not satisfied.
class RSpec::Mocks::MockExpectationError < ::Exception; end

# An implementation of rspec-mocks' reference interface.
# Used when a string is passed to {ExampleMethods#object_double},
# and when a string, named class or named module is passed to
# {ExampleMethods#instance_double}, or {ExampleMethods#class_double}.
# Represents a reference to the object named (via a constant lookup)
# by the string.
#
# @see DirectObjectReference
class RSpec::Mocks::NamedObjectReference
  # @param const_name [String] constant name
  # @return [NamedObjectReference] a new instance of NamedObjectReference
  def initialize(const_name); end

  # @return [String] the constant name to replace with a double.
  def const_to_replace; end

  # @return [Boolean] true if the named constant is defined, false otherwise.
  def defined?; end

  # @return [String] the constant name to replace with a double.
  def description; end

  # @return [Object, nil] the target of the verifying double (the named object), or
  #   nil if it is not defined.
  def target; end

  # Yields if the reference target is loaded, providing a generic mechanism
  # to optionally run a bit of code only when a reference's target is
  # loaded.
  #
  # @yield [Object] the target object
  def when_loaded; end

  private

  def object; end
end

# @private
class RSpec::Mocks::NegationUnsupportedError < ::StandardError; end

# @private
class RSpec::Mocks::NestedSpace < ::RSpec::Mocks::Space
  # @return [NestedSpace] a new instance of NestedSpace
  def initialize(parent); end

  def constant_mutator_for(name); end
  def proxies_of(klass); end

  # @return [Boolean]
  def registered?(object); end

  private

  def any_instance_recorder_not_found_for(id, klass); end
  def proxy_not_found_for(id, object); end
end

# @private
class RSpec::Mocks::NoCallbackInvocationStrategy
  def call(_doubled_module); end
end

# @private
class RSpec::Mocks::ObjectMethodReference < ::RSpec::Mocks::MethodReference
  private

  def find_method(object); end

  # @return [Boolean]
  def method_defined?(object); end

  # @return [Boolean]
  def method_implemented?(object); end

  def visibility_from(object); end

  class << self
    def for(object_reference, method_name); end
  end
end

# @private
class RSpec::Mocks::ObjectReference
  class << self
    # Returns an appropriate Object or Module reference based
    # on the given argument.
    def for(object_module_or_name, allow_direct_object_refs = T.unsafe(nil)); end

    private

    # 1.8.7
    #
    # @return [Boolean]
    def anonymous_module?(mod); end

    def name_of(mod); end
  end
end

# @private
RSpec::Mocks::ObjectReference::MODULE_NAME_METHOD = T.let(T.unsafe(nil), UnboundMethod)

# Similar to an InstanceVerifyingDouble, except that it verifies against
# public methods of the given object.
#
# @private
class RSpec::Mocks::ObjectVerifyingDouble
  include ::RSpec::Mocks::TestDouble
  include ::RSpec::Mocks::VerifyingDouble
  include ::RSpec::Mocks::ObjectVerifyingDoubleMethods
end

# An awkward module necessary because we cannot otherwise have
# ClassVerifyingDouble inherit from Module and still share these methods.
#
# @private
module RSpec::Mocks::ObjectVerifyingDoubleMethods
  include ::RSpec::Mocks::TestDouble
  include ::RSpec::Mocks::VerifyingDouble

  def as_stubbed_const(options = T.unsafe(nil)); end

  private

  def __build_mock_proxy(order_group); end
end

# @private
class RSpec::Mocks::OrderGroup
  # @return [OrderGroup] a new instance of OrderGroup
  def initialize; end

  def clear; end

  # @private
  def consume; end

  # @return [Boolean]
  def empty?; end

  # @private
  def handle_order_constraint(expectation); end

  def invoked(message); end

  # @private
  # @return [Boolean]
  def ready_for?(expectation); end

  # @private
  def register(expectation); end

  def verify_invocation_order(expectation); end

  private

  def expectation_for(message); end

  # @return [Boolean]
  def expectations_invoked_in_order?; end

  def expected_invocations; end
  def invoked_expectations; end
  def remaining_expectations; end
end

# Raised when doubles or partial doubles are used outside of the per-test lifecycle.
class RSpec::Mocks::OutsideOfExampleError < ::StandardError; end

# @private
class RSpec::Mocks::PartialClassDoubleProxy < ::RSpec::Mocks::PartialDoubleProxy
  include ::RSpec::Mocks::PartialClassDoubleProxyMethods
end

# When we mock or stub a method on a class, we have to treat it a bit different,
# because normally singleton method definitions only affect the object on which
# they are defined, but on classes they affect subclasses, too. As a result,
# we need some special handling to get the original method.
#
# @private
module RSpec::Mocks::PartialClassDoubleProxyMethods
  def initialize(source_space, *args); end

  # Consider this situation:
  #
  #   class A; end
  #   class B < A; end
  #
  #   allow(A).to receive(:new)
  #   expect(B).to receive(:new).and_call_original
  #
  # When getting the original definition for `B.new`, we cannot rely purely on
  # using `B.method(:new)` before our redefinition is defined on `B`, because
  # `B.method(:new)` will return a method that will execute the stubbed version
  # of the method on `A` since singleton methods on classes are in the lookup
  # hierarchy.
  #
  # To do it properly, we need to find the original definition of `new` from `A`
  # from _before_ `A` was stubbed, and we need to rebind it to `B` so that it will
  # run with the proper `self`.
  #
  # That's what this method (together with `original_unbound_method_handle_from_ancestor_for`)
  # does.
  def original_method_handle_for(message); end

  protected

  def method_double_from_ancestor_for(message); end
  def original_unbound_method_handle_from_ancestor_for(message); end
  def superclass_proxy; end
end

# @private
class RSpec::Mocks::PartialDoubleProxy < ::RSpec::Mocks::Proxy
  # @private
  def add_simple_expectation(method_name, response, location); end

  # @private
  def add_simple_stub(method_name, response); end

  def message_received(message, *args, **_arg2, &block); end
  def original_method_handle_for(message); end
  def reset; end

  # @private
  def visibility_for(method_name); end

  private

  # @return [Boolean]
  def any_instance_class_recorder_observing_method?(klass, method_name); end
end

# @private
class RSpec::Mocks::Proxy
  # @private
  # @return [Proxy] a new instance of Proxy
  def initialize(object, order_group, options = T.unsafe(nil)); end

  # @private
  def add_message_expectation(method_name, opts = T.unsafe(nil), &block); end

  # @private
  def add_simple_expectation(method_name, response, location); end

  # @private
  def add_simple_stub(method_name, response); end

  # @private
  def add_stub(method_name, opts = T.unsafe(nil), &implementation); end

  # Tells the object to ignore any messages that aren't explicitly set as
  # stubs or message expectations.
  #
  # @private
  def as_null_object; end

  # @private
  def build_expectation(method_name); end

  # @private
  def check_for_unexpected_arguments(expectation); end

  # @private
  # @raise [ArgumentError]
  def ensure_can_be_proxied!(object); end

  # @private
  def ensure_implemented(*_args); end

  # @private
  # @return [Boolean]
  def has_negative_expectation?(message); end

  # @private
  def message_received(message, *args, **_arg2, &block); end

  # @private
  def messages_arg_list; end

  # @private
  def method_double_if_exists_for_message(message); end

  # @private
  # @return [Boolean]
  def null_object?; end

  # @private
  def object; end

  # @private
  def original_method_handle_for(_message); end

  def prepended_modules_of_singleton_class; end

  # @private
  def raise_missing_default_stub_error(expectation, args_for_multiple_calls); end

  # @private
  def raise_unexpected_message_error(method_name, args); end

  # @private
  # @return [Boolean]
  def received_message?(method_name, *args, &block); end

  # @private
  def record_message_received(message, *args, &block); end

  # @private
  def remove_stub(method_name); end

  # @private
  def remove_stub_if_present(method_name); end

  # @private
  def replay_received_message_on(expectation, &block); end

  # @private
  def reset; end

  # @private
  def verify; end

  # @private
  def visibility_for(_method_name); end

  private

  def find_almost_matching_expectation(method_name, *args, **_arg2); end
  def find_almost_matching_stub(method_name, *args, **_arg2); end
  def find_best_matching_expectation_for(method_name); end
  def find_matching_expectation(method_name, *args, **_arg2); end
  def find_matching_method_stub(method_name, *args, **_arg2); end
  def method_double_for(message); end

  class << self
    def prepended_modules_of(klass); end
  end
end

RSpec::Mocks::Proxy::DEFAULT_MESSAGE_EXPECTATION_OPTS = T.let(T.unsafe(nil), Hash)

# @private
class RSpec::Mocks::Proxy::SpecificMessage < ::Struct
  def ==(expectation); end

  # Returns the value of attribute args
  #
  # @return [Object] the current value of args
  def args; end

  # Sets the attribute args
  #
  # @param value [Object] the value to set the attribute args to.
  # @return [Object] the newly set value
  def args=(_); end

  # Returns the value of attribute message
  #
  # @return [Object] the current value of message
  def message; end

  # Sets the attribute message
  #
  # @param value [Object] the value to set the attribute message to.
  # @return [Object] the newly set value
  def message=(_); end

  # Returns the value of attribute object
  #
  # @return [Object] the current value of object
  def object; end

  # Sets the attribute object
  #
  # @param value [Object] the value to set the attribute object to.
  # @return [Object] the newly set value
  def object=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @private
class RSpec::Mocks::ProxyForNil < ::RSpec::Mocks::PartialDoubleProxy
  # @return [ProxyForNil] a new instance of ProxyForNil
  def initialize(order_group); end

  def add_message_expectation(method_name, opts = T.unsafe(nil), &block); end
  def add_stub(method_name, opts = T.unsafe(nil), &implementation); end

  # Returns the value of attribute disallow_expectations.
  def disallow_expectations; end

  # Sets the attribute disallow_expectations
  #
  # @param value the value to set the attribute disallow_expectations to.
  def disallow_expectations=(_arg0); end

  # Returns the value of attribute warn_about_expectations.
  def warn_about_expectations; end

  # Sets the attribute warn_about_expectations
  #
  # @param value the value to set the attribute warn_about_expectations to.
  def warn_about_expectations=(_arg0); end

  private

  def raise_error(method_name); end
  def set_expectation_behavior; end
  def warn(method_name); end
  def warn_or_raise!(method_name); end
end

# Provides a default space implementation for outside
# the scope of an example. Called "root" because it serves
# as the root of the space stack.
#
# @private
class RSpec::Mocks::RootSpace
  def any_instance_proxy_for(*_args); end
  def any_instance_recorder_for(*_args); end
  def any_instance_recorders_from_ancestry_of(_object); end
  def new_scope; end
  def proxy_for(*_args); end
  def register_constant_mutator(_mutator); end

  # @return [Boolean]
  def registered?(_object); end

  def reset_all; end
  def superclass_proxy_for(*_args); end
  def verify_all; end

  private

  # @raise [OutsideOfExampleError]
  def raise_lifecycle_message; end
end

# A message expectation that only allows concrete return values to be set
# for a message. While this same effect can be achieved using a standard
# MessageExpectation, this version is much faster and so can be used as an
# optimization.
#
# @private
class RSpec::Mocks::SimpleMessageExpectation
  # @return [SimpleMessageExpectation] a new instance of SimpleMessageExpectation
  def initialize(message, response, error_generator, backtrace_line = T.unsafe(nil)); end

  # @return [Boolean]
  def called_max_times?; end

  def invoke(*_); end

  # @return [Boolean]
  def matches?(message, *_); end

  def unadvise(_); end
  def verify_messages_received; end
end

# @private
class RSpec::Mocks::Space
  # @return [Space] a new instance of Space
  def initialize; end

  # Returns the value of attribute any_instance_mutex.
  def any_instance_mutex; end

  def any_instance_proxy_for(klass); end
  def any_instance_recorder_for(klass, only_return_existing = T.unsafe(nil)); end

  # Returns the value of attribute any_instance_recorders.
  def any_instance_recorders; end

  def any_instance_recorders_from_ancestry_of(object); end
  def constant_mutator_for(name); end
  def ensure_registered(object); end
  def new_scope; end

  # Returns the value of attribute proxies.
  def proxies; end

  def proxies_of(klass); end
  def proxy_for(object); end

  # Returns the value of attribute proxy_mutex.
  def proxy_mutex; end

  def register_constant_mutator(mutator); end

  # @return [Boolean]
  def registered?(object); end

  def reset_all; end
  def superclass_proxy_for(klass); end
  def verify_all; end

  private

  def any_instance_recorder_not_found_for(id, klass); end
  def class_proxy_with_callback_verification_strategy(object, strategy); end
  def id_for(object); end
  def new_mutex; end
  def proxy_not_found_for(id, object); end
  def superclass_proxy_not_found_for(id, object); end
end

# @private
class RSpec::Mocks::StubChain < ::RSpec::Mocks::MessageChain
  private

  def expectation(object, message, &return_block); end

  class << self
    def stub_chain_on(object, *chain, &blk); end
  end
end

# Provides methods for enabling and disabling the available syntaxes
# provided by rspec-mocks.
#
# @api private
module RSpec::Mocks::Syntax
  class << self
    # Determines where the methods like `should_receive`, and `stub` are added.
    #
    # @api private
    def default_should_syntax_host; end

    # Disables the expect syntax (`expect(dbl).to receive`, `allow(dbl).to receive`, etc).
    #
    # @api private
    def disable_expect(syntax_host = T.unsafe(nil)); end

    # Disables the should syntax (`dbl.stub`, `dbl.should_receive`, etc).
    #
    # @api private
    def disable_should(syntax_host = T.unsafe(nil)); end

    # Enables the expect syntax (`expect(dbl).to receive`, `allow(dbl).to receive`, etc).
    #
    # @api private
    def enable_expect(syntax_host = T.unsafe(nil)); end

    # Enables the should syntax (`dbl.stub`, `dbl.should_receive`, etc).
    #
    # @api private
    def enable_should(syntax_host = T.unsafe(nil)); end

    # Indicates whether or not the expect syntax is enabled.
    #
    # @api private
    # @return [Boolean]
    def expect_enabled?(syntax_host = T.unsafe(nil)); end

    # Indicates whether or not the should syntax is enabled.
    #
    # @api private
    # @return [Boolean]
    def should_enabled?(syntax_host = T.unsafe(nil)); end

    # @api private
    # @private
    def warn_about_should!; end

    # @api private
    # @private
    def warn_unless_should_configured(method_name, replacement = T.unsafe(nil)); end
  end
end

# @private
class RSpec::Mocks::TargetBase
  include ::RSpec::Mocks::TargetDelegationInstanceMethods
  extend ::RSpec::Mocks::TargetDelegationClassMethods

  # @return [TargetBase] a new instance of TargetBase
  def initialize(target); end
end

# @private
module RSpec::Mocks::TargetDelegationClassMethods
  def delegate_not_to(matcher_method, options = T.unsafe(nil)); end
  def delegate_to(matcher_method); end
  def disallow_negation(method_name); end
end

# @private
module RSpec::Mocks::TargetDelegationInstanceMethods
  # Returns the value of attribute target.
  def target; end

  private

  def define_matcher(matcher, name, &block); end

  # @return [Boolean]
  def matcher_allowed?(matcher); end

  # @raise [NegationUnsupportedError]
  def raise_negation_unsupported(method_name, matcher); end

  # @raise [UnsupportedMatcherError]
  def raise_unsupported_matcher(method_name, matcher); end
end

# Implements the methods needed for a pure test double.  RSpec::Mocks::Double
# includes this module, and it is provided for cases where you want a
# pure test double without subclassing RSpec::Mocks::Double.
module RSpec::Mocks::TestDouble
  # Creates a new test double with a `name` (that will be used in error
  # messages only)
  def initialize(name = T.unsafe(nil), stubs = T.unsafe(nil)); end

  # This allows for comparing the mock to other objects that proxy such as
  # ActiveRecords belongs_to proxy objects. By making the other object run
  # the comparison, we're sure the call gets delegated to the proxy
  # target.
  def ==(other); end

  # @private
  def __build_mock_proxy_unless_expired(order_group); end

  # @private
  def __disallow_further_usage!; end

  # Tells the object to respond to all messages. If specific stub values
  # are declared, they'll work as expected. If not, the receiver is
  # returned.
  def as_null_object; end

  # Override for default freeze implementation to prevent freezing of test
  # doubles.
  def freeze; end

  # @private
  def inspect; end

  # Returns true if this object has received `as_null_object`
  #
  # @return [Boolean]
  def null_object?; end

  # @private
  # @return [Boolean]
  def respond_to?(message, incl_private = T.unsafe(nil)); end

  # @private
  def to_s; end

  private

  def __build_mock_proxy(order_group); end
  def __mock_proxy; end
  def __raise_expired_error; end
  def assign_stubs(stubs); end
  def initialize_copy(other); end

  # @raise [NoMethodError]
  def method_missing(message, *args, &block); end
end

# @private
module RSpec::Mocks::TestDoubleFormatter
  class << self
    def format(dbl, unwrap = T.unsafe(nil)); end

    private

    def name_desc(dbl); end
    def type_desc(dbl); end
    def verified_module_desc(dbl); end
  end
end

# @private
class RSpec::Mocks::TestDoubleProxy < ::RSpec::Mocks::Proxy
  def reset; end
end

# @private
class RSpec::Mocks::UnsupportedMatcherError < ::StandardError; end

# @private
module RSpec::Mocks::VerifyingDouble
  def initialize(doubled_module, *args); end

  def __send__(name, *args, &block); end
  def method_missing(message, *args, &block); end

  # @return [Boolean]
  def respond_to?(message, include_private = T.unsafe(nil)); end

  def send(name, *args, &block); end
end

# @private
class RSpec::Mocks::VerifyingDoubleNotDefinedError < ::StandardError; end

# Used in place of a `VerifyingExistingMethodDouble` for the specific case
# of mocking or stubbing a `new` method on a class. In this case, we substitute
# the method signature from `#initialize` since new's signature is just `*args`.
#
# @private
class RSpec::Mocks::VerifyingExistingClassNewMethodDouble < ::RSpec::Mocks::VerifyingExistingMethodDouble
  # @yield [Support::MethodSignature.new(object.instance_method(:initialize))]
  def with_signature; end
end

# A VerifyingMethodDouble fetches the method to verify against from the
# original object, using a MethodReference. This works for pure doubles,
# but when the original object is itself the one being modified we need to
# collapse the reference and the method double into a single object so that
# we can access the original pristine method definition.
#
# @private
class RSpec::Mocks::VerifyingExistingMethodDouble < ::RSpec::Mocks::VerifyingMethodDouble
  # @return [VerifyingExistingMethodDouble] a new instance of VerifyingExistingMethodDouble
  def initialize(object, method_name, proxy); end

  # @return [Boolean]
  def unimplemented?; end

  # @yield [Support::MethodSignature.new(original_implementation_callable)]
  def with_signature; end

  class << self
    def for(object, method_name, proxy); end
  end
end

# A message expectation that knows about the real implementation of the
# message being expected, so that it can verify that any expectations
# have the valid arguments.
#
# @api private
class RSpec::Mocks::VerifyingMessageExpectation < ::RSpec::Mocks::MessageExpectation
  # @api private
  # @return [VerifyingMessageExpectation] a new instance of VerifyingMessageExpectation
  def initialize(*args); end

  # A level of indirection is used here rather than just passing in the
  # method itself, since method look up is expensive and we only want to
  # do it if actually needed.
  #
  # Conceptually the method reference makes more sense as a constructor
  # argument since it should be immutable, but it is significantly more
  # straight forward to build the object in pieces so for now it stays as
  # an accessor.
  #
  # @api private
  def method_reference; end

  # A level of indirection is used here rather than just passing in the
  # method itself, since method look up is expensive and we only want to
  # do it if actually needed.
  #
  # Conceptually the method reference makes more sense as a constructor
  # argument since it should be immutable, but it is significantly more
  # straight forward to build the object in pieces so for now it stays as
  # an accessor.
  #
  # @api private
  def method_reference=(_arg0); end

  # @api private
  # @private
  def with(*args, &block); end

  private

  # @api private
  def validate_expected_arguments!; end
end

# @private
class RSpec::Mocks::VerifyingMethodDouble < ::RSpec::Mocks::MethodDouble
  # @return [VerifyingMethodDouble] a new instance of VerifyingMethodDouble
  def initialize(object, method_name, proxy, method_reference); end

  def add_expectation(*args, &block); end
  def add_stub(*args, &block); end
  def message_expectation_class; end
  def proxy_method_invoked(obj, *args, &block); end
  def validate_arguments!(actual_args); end
end

# @private
class RSpec::Mocks::VerifyingPartialClassDoubleProxy < ::RSpec::Mocks::VerifyingPartialDoubleProxy
  include ::RSpec::Mocks::PartialClassDoubleProxyMethods
end

# @private
class RSpec::Mocks::VerifyingPartialDoubleProxy < ::RSpec::Mocks::PartialDoubleProxy
  include ::RSpec::Mocks::VerifyingProxyMethods

  # @return [VerifyingPartialDoubleProxy] a new instance of VerifyingPartialDoubleProxy
  def initialize(object, expectation_ordering, optional_callback_invocation_strategy = T.unsafe(nil)); end

  def ensure_implemented(_method_name); end
  def method_reference; end
end

# A verifying proxy mostly acts like a normal proxy, except that it
# contains extra logic to try and determine the validity of any expectation
# set on it. This includes whether or not methods have been defined and the
# validatiy of arguments on method calls.
#
# In all other ways this behaves like a normal proxy. It only adds the
# verification behaviour to specific methods then delegates to the parent
# implementation.
#
# These checks are only activated if the doubled class has already been
# loaded, otherwise they are disabled. This allows for testing in
# isolation.
#
# @private
class RSpec::Mocks::VerifyingProxy < ::RSpec::Mocks::TestDoubleProxy
  include ::RSpec::Mocks::VerifyingProxyMethods

  # @return [VerifyingProxy] a new instance of VerifyingProxy
  def initialize(object, order_group, doubled_module, method_reference_class); end

  def method_reference; end
  def validate_arguments!(method_name, args); end
  def visibility_for(method_name); end
end

# @private
module RSpec::Mocks::VerifyingProxyMethods
  def add_message_expectation(method_name, opts = T.unsafe(nil), &block); end
  def add_simple_stub(method_name, *args); end
  def add_stub(method_name, opts = T.unsafe(nil), &implementation); end
  def ensure_implemented(method_name); end
  def ensure_publicly_implemented(method_name, _object); end
end

# Version information for RSpec mocks.
module RSpec::Mocks::Version; end

# Version of RSpec mocks currently in use in SemVer format.
RSpec::Mocks::Version::STRING = T.let(T.unsafe(nil), String)

# @private
RSpec::SharedContext = RSpec::Core::SharedContext
