# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rspec-core` gem.
# Please instead update this file by running `bin/tapioca gem rspec-core`.

# Namespace for all core RSpec code.
module RSpec
  extend ::RSpec::Core::Warnings

  class << self
    # Used to ensure examples get reloaded between multiple runs in the same
    # process and ensures user configuration is persisted.
    #
    # Users must invoke this if they want to clear all examples but preserve
    # current configuration when they use the runner multiple times within the
    # same process.
    def clear_examples; end

    # Returns the global [Configuration](RSpec/Core/Configuration) object. While
    # you _can_ use this method to access the configuration, the more common
    # convention is to use [RSpec.configure](RSpec#configure-class_method).
    #
    # @example
    #   RSpec.configuration.drb_port = 1234
    # @see RSpec.configure
    # @see Core::Configuration
    def configuration; end

    # Setters for shared global objects
    #
    # @api private
    def configuration=(_arg0); end

    # Yields the global configuration to a block.
    #
    # @example
    #   RSpec.configure do |config|
    #   config.add_formatter 'documentation'
    #   end
    # @see Core::Configuration
    # @yield [Configuration] global configuration
    def configure; end

    # @private
    def const_missing(name); end

    def context(*args, &example_group_block); end

    # The example being executed.
    #
    # The primary audience for this method is library authors who need access
    # to the example currently being executed and also want to support all
    # versions of RSpec 2 and 3.
    #
    # @example
    #
    #   RSpec.configure do |c|
    #   # context.example is deprecated, but RSpec.current_example is not
    #   # available until RSpec 3.0.
    #   fetch_current_example = RSpec.respond_to?(:current_example) ?
    #   proc { RSpec.current_example } : proc { |context| context.example }
    #
    #   c.before(:example) do
    #   example = fetch_current_example.call(self)
    #
    #   # ...
    #   end
    #   end
    def current_example; end

    # Set the current example being executed.
    #
    # @api private
    def current_example=(example); end

    # Get the current RSpec execution scope
    #
    # Returns (in order of lifecycle):
    #   * `:suite` as an initial value, this is outside of the test lifecycle.
    #   * `:before_suite_hook` during `before(:suite)` hooks.
    #   * `:before_context_hook` during `before(:context)` hooks.
    #   * `:before_example_hook` during `before(:example)` hooks and `around(:example)` before `example.run`.
    #   * `:example` within the example run.
    #   * `:after_example_hook` during `after(:example)` hooks and `around(:example)` after `example.run`.
    #   * `:after_context_hook` during `after(:context)` hooks.
    #   * `:after_suite_hook` during `after(:suite)` hooks.
    #   * `:suite` as a final value, again this is outside of the test lifecycle.
    #
    # Reminder, `:context` hooks have `:all` alias and `:example` hooks have `:each` alias.
    #
    # @return [Symbol]
    def current_scope; end

    # Set the current scope rspec is executing in
    #
    # @api private
    def current_scope=(scope); end

    def describe(*args, &example_group_block); end
    def example_group(*args, &example_group_block); end
    def fcontext(*args, &example_group_block); end
    def fdescribe(*args, &example_group_block); end

    # Used to ensure examples get reloaded and user configuration gets reset to
    # defaults between multiple runs in the same process.
    #
    # Users must invoke this if they want to have the configuration reset when
    # they use the runner multiple times within the same process. Users must deal
    # themselves with re-configuration of RSpec before run.
    def reset; end

    def shared_context(name, *args, &block); end
    def shared_examples(name, *args, &block); end
    def shared_examples_for(name, *args, &block); end

    # Internal container for global non-configuration data.
    #
    # @private
    def world; end

    # Setters for shared global objects
    #
    # @api private
    def world=(_arg0); end

    def xcontext(*args, &example_group_block); end
    def xdescribe(*args, &example_group_block); end
  end
end

# Namespace for the rspec-core code.
module RSpec::Core
  class << self
    # @private path to executable file.
    def path_to_executable; end
  end
end

# Unnamed example group used by `SuiteHookContext`.
#
# @private
class RSpec::Core::AnonymousExampleGroup < ::RSpec::Core::ExampleGroup
  class << self
    def metadata; end
  end
end

# @private
class RSpec::Core::BacktraceFormatter
  # @return [BacktraceFormatter] a new instance of BacktraceFormatter
  def initialize; end

  def backtrace_line(line); end

  # @return [Boolean]
  def exclude?(line); end

  # @private
  def exclusion_patterns; end

  # @private
  def exclusion_patterns=(_arg0); end

  def filter_gem(gem_name); end
  def format_backtrace(backtrace, options = T.unsafe(nil)); end

  # Sets the attribute full_backtrace
  #
  # @param value the value to set the attribute full_backtrace to.
  def full_backtrace=(_arg0); end

  # @return [Boolean]
  def full_backtrace?; end

  # @private
  def inclusion_patterns; end

  # @private
  def inclusion_patterns=(_arg0); end

  private

  # @return [Boolean]
  def matches?(patterns, line); end
end

# @private
module RSpec::Core::Bisect; end

# @private
class RSpec::Core::Bisect::BisectFailedError < ::StandardError
  class << self
    def for_failed_spec_run(spec_output); end
  end
end

# Wraps a pipe to support sending objects between a child and
# parent process. Where supported, encoding is explicitly
# set to ensure binary data is able to pass from child to
# parent.
#
# @private
class RSpec::Core::Bisect::Channel
  # @return [Channel] a new instance of Channel
  def initialize; end

  def close; end
  def receive; end
  def send(message); end
end

RSpec::Core::Bisect::Channel::MARSHAL_DUMP_ENCODING = T.let(T.unsafe(nil), Encoding)

# @private
class RSpec::Core::Bisect::ExampleSetDescriptor < ::Struct
  # Returns the value of attribute all_example_ids
  #
  # @return [Object] the current value of all_example_ids
  def all_example_ids; end

  # Sets the attribute all_example_ids
  #
  # @param value [Object] the value to set the attribute all_example_ids to.
  # @return [Object] the newly set value
  def all_example_ids=(_); end

  # Returns the value of attribute failed_example_ids
  #
  # @return [Object] the current value of failed_example_ids
  def failed_example_ids; end

  # Sets the attribute failed_example_ids
  #
  # @param value [Object] the value to set the attribute failed_example_ids to.
  # @return [Object] the newly set value
  def failed_example_ids=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Wraps a `formatter` providing a simple means to notify it in place
# of an `RSpec::Core::Reporter`, without involving configuration in
# any way.
#
# @private
class RSpec::Core::Bisect::Notifier
  # @return [Notifier] a new instance of Notifier
  def initialize(formatter); end

  def publish(event, *args); end
end

# Stores runtime configuration information.
#
# Configuration options are loaded from multiple files and joined together
# with command-line switches and the `SPEC_OPTS` environment variable.
#
# Precedence order (where later entries overwrite earlier entries on
# conflicts):
#
#   * Global (`$XDG_CONFIG_HOME/rspec/options`, or `~/.rspec` if it does
#     not exist)
#   * Project-specific (`./.rspec`)
#   * Local (`./.rspec-local`)
#   * Command-line options
#   * `SPEC_OPTS`
#
# For example, an option set in the local file will override an option set
# in your global file.
#
# The global, project-specific and local files can all be overridden with a
# separate custom file using the --options command-line parameter.
#
# @example Standard settings
#   RSpec.configure do |c|
#   c.drb          = true
#   c.drb_port     = 1234
#   c.default_path = 'behavior'
#   end
# @example Hooks
#   RSpec.configure do |c|
#   c.before(:suite)   { establish_connection }
#   c.before(:example) { log_in_as :authorized }
#   c.around(:example) { |ex| Database.transaction(&ex) }
#   end
# @see RSpec.configure
# @see Hooks
class RSpec::Core::Configuration
  include ::RSpec::Core::Hooks
  include ::RSpec::Core::Configuration::Readers

  # Build an object to store runtime configuration options and set defaults
  #
  # @return [Configuration] a new instance of Configuration
  def initialize; end

  # Adds a formatter to the set RSpec will use for this run.
  #
  # @overload add_formatter
  # @overload add_formatter
  # @param formatter [Class, String, Object] formatter to use. Can be any of the
  #   string values supported from the CLI (`p`/`progress`,
  #   `d`/`doc`/`documentation`, `h`/`html`, or `j`/`json`), any
  #   class that implements the formatter protocol and has registered
  #   itself with RSpec as a formatter, or a formatter instance.
  # @param output [String, IO] where the formatter will write its output.
  #   Can be an IO object or a string path to a file. If not provided,
  #   the configured `output_stream` (`$stdout`, by default) will be used.
  # @see RSpec::Core::Formatters::Protocol
  def add_formatter(formatter, output = T.unsafe(nil)); end

  # Adds a custom setting to the RSpec.configuration object.
  #
  #     RSpec.configuration.add_setting :foo
  #
  # Used internally and by extension frameworks like rspec-rails, so they
  # can add config settings that are domain specific. For example:
  #
  #     RSpec.configure do |c|
  #       c.add_setting :use_transactional_fixtures,
  #         :default => true,
  #         :alias_with => :use_transactional_examples
  #     end
  #
  # `add_setting` creates three methods on the configuration object, a
  # setter, a getter, and a predicate:
  #
  #     RSpec.configuration.foo=(value)
  #     RSpec.configuration.foo
  #     RSpec.configuration.foo? # Returns true if foo returns anything but nil or false.
  #
  # @option opts
  # @option opts
  # @overload add_setting
  # @overload add_setting
  # @param opts [Hash] a customizable set of options
  def add_setting(name, opts = T.unsafe(nil)); end

  # Defines a `after` hook. See {Hooks#after} for full docs.
  #
  # This method differs from {Hooks#after} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once after
  # the last example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #append_after
  # @see #before
  # @see #prepend_before
  def after(scope = T.unsafe(nil), *meta, &block); end

  # Creates a method that defines an example group with the provided
  # metadata. Can be used to define example group/metadata shortcuts.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.alias_example_group_to :describe_model, :type => :model
  #   end
  #
  #   shared_context_for "model tests", :type => :model do
  #   # define common model test helper methods, `let` declarations, etc
  #   end
  #
  #   # This lets you do this:
  #
  #   RSpec.describe_model User do
  #   end
  #
  #   # ... which is the equivalent of
  #
  #   RSpec.describe User, :type => :model do
  #   end
  # @note The defined aliased will also be added to the top level
  #   (e.g. `main` and from within modules) if
  #   `expose_dsl_globally` is set to true.
  # @see #alias_example_to
  # @see #expose_dsl_globally=
  def alias_example_group_to(new_name, *args); end

  # Creates a method that delegates to `example` including the submitted
  # `args`. Used internally to add variants of `example` like `pending`:
  #
  # @example
  #   RSpec.configure do |config|
  #   config.alias_example_to :pending, :pending => true
  #   end
  #
  #   # This lets you do this:
  #
  #   RSpec.describe Thing do
  #   pending "does something" do
  #   thing = Thing.new
  #   end
  #   end
  #
  #   # ... which is the equivalent of
  #
  #   RSpec.describe Thing do
  #   it "does something", :pending => true do
  #   thing = Thing.new
  #   end
  #   end
  # @note The specific example alias below (`pending`) is already
  #   defined for you.
  # @note Use with caution. This extends the language used in your
  #   specs, but does not add any additional documentation. We use this
  #   in RSpec to define methods like `focus` and `xit`, but we also add
  #   docs for those methods.
  # @param name [String] example name alias
  # @param args [Array<Symbol>, Hash] metadata for the generated example
  def alias_example_to(name, *args); end

  # Define an alias for it_should_behave_like that allows different
  # language (like "it_has_behavior" or "it_behaves_like") to be
  # employed when including shared examples.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.alias_it_behaves_like_to(:it_has_behavior, 'has behavior:')
  #   end
  #
  #   # allows the user to include a shared example group like:
  #
  #   RSpec.describe Entity do
  #   it_has_behavior 'sortability' do
  #   let(:sortable) { Entity.new }
  #   end
  #   end
  #
  #   # which is reported in the output as:
  #   # Entity
  #   #   has behavior: sortability
  #   #     ...sortability examples here
  # @note Use with caution. This extends the language used in your
  #   specs, but does not add any additional documentation. We use this
  #   in RSpec to define `it_should_behave_like` (for backward
  #   compatibility), but we also add docs for that method.
  def alias_it_behaves_like_to(new_name, report_label = T.unsafe(nil)); end

  # Define an alias for it_should_behave_like that allows different
  # language (like "it_has_behavior" or "it_behaves_like") to be
  # employed when including shared examples.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.alias_it_behaves_like_to(:it_has_behavior, 'has behavior:')
  #   end
  #
  #   # allows the user to include a shared example group like:
  #
  #   RSpec.describe Entity do
  #   it_has_behavior 'sortability' do
  #   let(:sortable) { Entity.new }
  #   end
  #   end
  #
  #   # which is reported in the output as:
  #   # Entity
  #   #   has behavior: sortability
  #   #     ...sortability examples here
  # @note Use with caution. This extends the language used in your
  #   specs, but does not add any additional documentation. We use this
  #   in RSpec to define `it_should_behave_like` (for backward
  #   compatibility), but we also add docs for that method.
  def alias_it_should_behave_like_to(new_name, report_label = T.unsafe(nil)); end

  # Adds `block` to the end of the list of `after` blocks in the same
  # scope (`:example`, `:context`, or `:suite`), in contrast to {#after},
  # which adds the hook to the start of the list.
  #
  # See {Hooks#after} for full `after` hook docs.
  #
  # This method differs from {Hooks#append_after} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once after
  # the last example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #append_after
  # @see #before
  # @see #prepend_before
  def append_after(scope = T.unsafe(nil), *meta, &block); end

  # Defines a `before` hook. See {Hooks#before} for full docs.
  #
  # This method differs from {Hooks#before} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once before
  # the first example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #prepend_before
  # @see #after
  # @see #append_after
  def append_before(scope = T.unsafe(nil), *meta, &block); end

  # @private
  # @raise [SystemStackError]
  def apply_derived_metadata_to(metadata); end

  # Registers `block` as an `around` hook.
  #
  # See {Hooks#around} for full `around` hook docs.
  def around(scope = T.unsafe(nil), *meta, &block); end

  # Regexps used to exclude lines from backtraces.
  #
  # Excludes lines from ruby (and jruby) source, installed gems, anything
  # in any "bin" directory, and any of the RSpec libs (outside gem
  # installs) by default.
  #
  # You can modify the list via the getter, or replace it with the setter.
  #
  # To override this behaviour and display a full backtrace, use
  # `--backtrace` on the command line, in a `.rspec` file, or in the
  # `rspec_options` attribute of RSpec's rake task.
  #
  # @return [Array<Regexp>]
  def backtrace_exclusion_patterns; end

  # Set regular expressions used to exclude lines in backtrace.
  #
  # @param patterns [Array<Regexp>] set backtrace_formatter exlusion_patterns
  def backtrace_exclusion_patterns=(patterns); end

  # @private
  def backtrace_formatter; end

  # Regexps used to include lines in backtraces.
  #
  # Defaults to [Regexp.new Dir.getwd].
  #
  # Lines that match an exclusion _and_ an inclusion pattern
  # will be included.
  #
  # You can modify the list via the getter, or replace it with the setter.
  #
  # @return [Array<Regexp>]
  def backtrace_inclusion_patterns; end

  # Set regular expressions used to include lines in backtrace.
  #
  # @attr patterns [Array<Regexp>] set backtrace_formatter inclusion_patterns
  def backtrace_inclusion_patterns=(patterns); end

  # Defines a `before` hook. See {Hooks#before} for full docs.
  #
  # This method differs from {Hooks#before} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once before
  # the first example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #prepend_before
  # @see #after
  # @see #append_after
  def before(scope = T.unsafe(nil), *meta, &block); end

  # Determines which bisect runner implementation gets used to run subsets
  # of the suite during a bisection. Your choices are:
  #
  #   - `:shell`: Performs a spec run by shelling out, booting RSpec and your
  #     application environment each time. This runner is the most widely
  #     compatible runner, but is not as fast. On platforms that do not
  #     support forking, this is the default.
  #   - `:fork`: Pre-boots RSpec and your application environment in a parent
  #     process, and then forks a child process for each spec run. This runner
  #     tends to be significantly faster than the `:shell` runner but cannot
  #     be used in some situations. On platforms that support forking, this
  #     is the default. If you use this runner, you should ensure that all
  #     of your one-time setup logic goes in a `before(:suite)` hook instead
  #     of getting run at the top-level of a file loaded by `--require`.
  #
  # @note This option will only be used by `--bisect` if you set it in a file
  #   loaded via `--require`.
  # @return [Symbol]
  def bisect_runner; end

  def bisect_runner=(value); end

  # @private
  def bisect_runner_class; end

  # Enables color output if the output is a TTY.  As of RSpec 3.6, this is
  # the default behavior and this option is retained only for backwards
  # compatibility.
  #
  # @deprecated No longer recommended because of complex behavior. Instead,
  #   rely on the fact that TTYs will display color by default, or set
  #   {#color_mode} to :on to display color on a non-TTY output.
  # @return [Boolean]
  # @see color_mode
  # @see color_enabled?
  def color; end

  # Toggle output color.
  #
  # @deprecated No longer recommended because of complex behavior. Instead,
  #   rely on the fact that TTYs will display color by default, or set
  #   {:color_mode} to :on to display color on a non-TTY output.
  def color=(_arg0); end

  # Check if color is enabled for a particular output.
  #
  # @param output [IO] an output stream to use, defaults to the current
  #   `output_stream`
  # @return [Boolean]
  def color_enabled?(output = T.unsafe(nil)); end

  # The mode for determining whether to display output in color. One of:
  #
  # - :automatic - the output will be in color if the output is a TTY (the
  #   default)
  # - :on - the output will be in color, whether or not the output is a TTY
  # - :off - the output will not be in color
  #
  # @return [Boolean]
  # @see color_enabled?
  def color_mode; end

  # Set the color mode.
  def color_mode=(_arg0); end

  # Used internally to extend the singleton class of a single example's
  # example group instance with modules using `include` and/or `extend`.
  #
  # @private
  def configure_example(example, example_hooks); end

  # @private
  def configure_expectation_framework; end

  # Used internally to extend a group with modules using `include`, `prepend` and/or
  # `extend`.
  #
  # @private
  def configure_group(group); end

  # @private
  def configure_mock_framework; end

  # The default output color. Defaults to `:white` but can be set to one of
  # the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def default_color; end

  # The default output color. Defaults to `:white` but can be set to one of
  # the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def default_color=(_arg0); end

  def default_color?; end

  # The formatter that will be used if no formatter has been set.
  # Defaults to 'progress'.
  def default_formatter; end

  # Sets a fallback formatter to use if none other has been set.
  #
  # @example
  #
  #   RSpec.configure do |rspec|
  #   rspec.default_formatter = 'doc'
  #   end
  def default_formatter=(value); end

  # Path to use if no path is provided to the `rspec` command (default:
  # `"spec"`). Allows you to just type `rspec` instead of `rspec spec` to
  # run all the examples in the `spec` directory.
  #
  # @note Other scripts invoking `rspec` indirectly will ignore this
  #   setting.
  # @return [String]
  def default_path; end

  # Path to use if no path is provided to the `rspec` command (default:
  # `"spec"`). Allows you to just type `rspec` instead of `rspec spec` to
  # run all the examples in the `spec` directory.
  #
  # @note Other scripts invoking `rspec` indirectly will ignore this
  #   setting.
  # @return [String]
  def default_path=(path); end

  def default_path?; end

  # Defines a callback that can assign derived metadata values.
  #
  # @example
  #   RSpec.configure do |config|
  #   # Tag all groups and examples in the spec/unit directory with
  #   # :type => :unit
  #   config.define_derived_metadata(:file_path => %r{/spec/unit/}) do |metadata|
  #   metadata[:type] = :unit
  #   end
  #   end
  # @param filters [Array<Symbol>, Hash] metadata filters that determine
  #   which example or group metadata hashes the callback will be triggered
  #   for. If none are given, the callback will be run against the metadata
  #   hashes of all groups and examples.
  # @yieldparam metadata [Hash] original metadata hash from an example or
  #   group. Mutate this in your block as needed.
  def define_derived_metadata(*filters, &block); end

  # Determines where deprecation warnings are printed.
  # Defaults to `$stderr`.
  #
  # @return [IO, String] IO or filename to write to
  def deprecation_stream; end

  # Determines where deprecation warnings are printed.
  #
  # @param value [IO, String] IO to write to or filename to write to
  def deprecation_stream=(value); end

  # Color used to print details.  Defaults to `:cyan` but can be set to one
  # of the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def detail_color; end

  # Color used to print details.  Defaults to `:cyan` but can be set to one
  # of the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def detail_color=(_arg0); end

  def detail_color?; end

  # @private
  def disable_monkey_patching; end

  # Enables zero monkey patching mode for RSpec. It removes monkey
  # patching of the top-level DSL methods (`describe`,
  # `shared_examples_for`, etc) onto `main` and `Module`, instead
  # requiring you to prefix these methods with `RSpec.`. It enables
  # expect-only syntax for rspec-mocks and rspec-expectations. It
  # simply disables monkey patching on whatever pieces of RSpec
  # the user is using.
  #
  # @example
  #
  #   # It disables all monkey patching.
  #   RSpec.configure do |config|
  #   config.disable_monkey_patching!
  #   end
  #
  #   # Is an equivalent to
  #   RSpec.configure do |config|
  #   config.expose_dsl_globally = false
  #
  #   config.mock_with :rspec do |mocks|
  #   mocks.syntax = :expect
  #   mocks.patch_marshal_to_support_partial_doubles = false
  #   end
  #
  #   config.expect_with :rspec do |expectations|
  #   expectations.syntax = :expect
  #   end
  #   end
  # @note It configures rspec-mocks and rspec-expectations only
  #   if the user is using those (either explicitly or implicitly
  #   by not setting `mock_with` or `expect_with` to anything else).
  # @note If the user uses this options with `mock_with :mocha`
  #   (or similiar) they will still have monkey patching active
  #   in their test environment from mocha.
  def disable_monkey_patching!; end

  # @private
  def disable_monkey_patching=(_arg0); end

  # Run examples over DRb (default: `false`). RSpec doesn't supply the DRb
  # server, but you can use tools like spork.
  #
  # @return [Boolean]
  def drb; end

  # Run examples over DRb (default: `false`). RSpec doesn't supply the DRb
  # server, but you can use tools like spork.
  #
  # @return [Boolean]
  def drb=(_arg0); end

  def drb?; end

  # The drb_port (default: nil).
  def drb_port; end

  # The drb_port (default: nil).
  def drb_port=(_arg0); end

  def drb_port?; end

  # Prints the formatter output of your suite without running any
  # examples or hooks.
  def dry_run; end

  # Prints the formatter output of your suite without running any
  # examples or hooks.
  def dry_run=(_arg0); end

  def dry_run?; end

  # The exit code to return if there are any errors outside examples (default: failure_exit_code)
  #
  # @return [Integer]
  def error_exit_code; end

  # The exit code to return if there are any errors outside examples (default: failure_exit_code)
  #
  # @return [Integer]
  def error_exit_code=(_arg0); end

  def error_exit_code?; end

  # Default: `$stderr`.
  def error_stream; end

  # Default: `$stderr`.
  def error_stream=(_arg0); end

  def error_stream?; end

  # The file path to use for persisting example statuses. Necessary for the
  # `--only-failures` and `--next-failure` CLI options.
  #
  # @overload example_status_persistence_file_path
  # @overload example_status_persistence_file_path=
  def example_status_persistence_file_path; end

  # Sets the file path to use for persisting example statuses. Necessary for the
  # `--only-failures` and `--next-failure` CLI options.
  def example_status_persistence_file_path=(value); end

  # Exclude files matching this pattern.
  #
  # @return [String]
  def exclude_pattern; end

  # Set pattern to match files to exclude.
  #
  # @attr value [String] the filename pattern to exclude spec files by
  def exclude_pattern=(value); end

  # Returns the `exclusion_filter`. If none has been set, returns an empty
  # hash.
  def exclusion_filter; end

  # Clears and reassigns the `exclusion_filter`. Set to `nil` if you don't
  # want any exclusion filter at all.
  #
  # ### Warning
  #
  # This overrides any exclusion filters/tags set on the command line or in
  # configuration files.
  def exclusion_filter=(filter); end

  # Sets the expectation framework module(s) to be included in each example
  # group.
  #
  # `frameworks` can be `:rspec`, `:test_unit`, `:minitest`, a custom
  # module, or any combination thereof:
  #
  #     config.expect_with :rspec
  #     config.expect_with :test_unit
  #     config.expect_with :minitest
  #     config.expect_with :rspec, :minitest
  #     config.expect_with OtherExpectationFramework
  #
  # RSpec will translate `:rspec`, `:minitest`, and `:test_unit` into the
  # appropriate modules.
  #
  # ## Configuration
  #
  # If the module responds to `configuration`, `expect_with` will
  # yield the `configuration` object if given a block:
  #
  #     config.expect_with OtherExpectationFramework do |custom_config|
  #       custom_config.custom_setting = true
  #     end
  def expect_with(*frameworks); end

  # Delegates to expect_with(framework).
  def expectation_framework=(framework); end

  # Returns the configured expectation framework adapter module(s)
  def expectation_frameworks; end

  # Exposes the current running example via the named
  # helper method. RSpec 2.x exposed this via `example`,
  # but in RSpec 3.0, the example is instead exposed via
  # an arg yielded to `it`, `before`, `let`, etc. However,
  # some extension gems (such as Capybara) depend on the
  # RSpec 2.x's `example` method, so this config option
  # can be used to maintain compatibility.
  #
  # @example
  #
  #   RSpec.configure do |rspec|
  #   rspec.expose_current_running_example_as :example
  #   end
  #
  #   RSpec.describe MyClass do
  #   before do
  #   # `example` can be used here because of the above config.
  #   do_something if example.metadata[:type] == "foo"
  #   end
  #   end
  # @param method_name [Symbol] the name of the helper method
  def expose_current_running_example_as(method_name); end

  # Use this to expose the core RSpec DSL via `Module` and the `main`
  # object. It will be set automatically but you can override it to
  # remove the DSL.
  # Default: true
  def expose_dsl_globally=(value); end

  # Indicates if the DSL has been exposed off of modules and `main`.
  # Default: true
  #
  # @return [Boolean]
  def expose_dsl_globally?; end

  # Tells RSpec to extend example groups with `mod`. Methods defined in
  # `mod` are exposed to example groups (not examples). Use `filters` to
  # constrain the groups to extend.
  #
  # Similar to `include`, but behavior is added to example groups, which
  # are classes, rather than the examples, which are instances of those
  # classes.
  #
  # @example
  #
  #   module UiHelpers
  #   def run_in_browser
  #   # ...
  #   end
  #   end
  #
  #   module PermissionHelpers
  #   def define_permissions
  #   # ...
  #   end
  #   end
  #
  #   RSpec.configure do |config|
  #   config.extend(UiHelpers, :type => :request)
  #   config.extend(PermissionHelpers, :with_permissions, :type => :request)
  #   end
  #
  #   describe "edit profile", :with_permissions, :type => :request do
  #   run_in_browser
  #   define_permissions
  #
  #   it "does stuff in the client" do
  #   # ...
  #   end
  #   end
  # @see #include
  # @see #prepend
  def extend(mod, *filters); end

  # If specified, indicates the number of failures required before cleaning
  # up and exit (default: `nil`). Can also be `true` to fail and exit on first
  # failure
  def fail_fast; end

  # @see fail_fast
  def fail_fast=(value); end

  # Whether or not to fail when there are no RSpec examples (default: false).
  #
  # @return [Boolean]
  def fail_if_no_examples; end

  # Whether or not to fail when there are no RSpec examples (default: false).
  #
  # @return [Boolean]
  def fail_if_no_examples=(_arg0); end

  def fail_if_no_examples?; end

  # Color to use to indicate failure.  Defaults to `:red` but can be set to
  # one of the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def failure_color; end

  # Color to use to indicate failure.  Defaults to `:red` but can be set to
  # one of the following: `[:black, :white, :red, :green, :yellow, :blue,
  # :magenta, :cyan]`
  #
  # @return [Symbol]
  def failure_color=(_arg0); end

  def failure_color?; end

  # The exit code to return if there are any failures (default: 1).
  #
  # @return [Integer]
  def failure_exit_code; end

  # The exit code to return if there are any failures (default: 1).
  #
  # @return [Integer]
  def failure_exit_code=(_arg0); end

  def failure_exit_code?; end

  # @private
  def files_or_directories_to_run=(*files); end

  # The spec files RSpec will run.
  #
  # @return [Array] specified files about to run
  def files_to_run; end

  # @private
  def files_to_run=(_arg0); end

  # Returns the `inclusion_filter`. If none has been set, returns an empty
  # hash.
  def filter; end

  # Clears and reassigns the `inclusion_filter`. Set to `nil` if you don't
  # want any inclusion filter at all.
  #
  # ### Warning
  #
  # This overrides any inclusion filters/tags set on the command line or in
  # configuration files.
  def filter=(filter); end

  # Adds {#backtrace_exclusion_patterns} that will filter lines from
  # the named gems from backtraces.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.filter_gems_from_backtrace "rack", "rake"
  #   end
  # @note The patterns this adds will match the named gems in their common
  #   locations (e.g. system gems, vendored with bundler, installed as a
  #   :git dependency with bundler, etc) but is not guaranteed to work for
  #   all possible gem locations. For example, if you have the gem source
  #   in a directory with a completely unrelated name, and use bundler's
  #   :path option, this will not filter it.
  # @param gem_names [Array<String>] Names of the gems to filter
  def filter_gems_from_backtrace(*gem_names); end

  # @private
  def filter_manager; end

  # @private
  def filter_manager=(_arg0); end

  # Adds key/value pairs to the `inclusion_filter`. If `args`
  # includes any symbols that are not part of the hash, each symbol
  # is treated as a key in the hash with the value `true`.
  #
  # ### Note
  #
  # Filters set using this method can be overridden from the command line
  # or config files (e.g. `.rspec`).
  #
  # @example
  #   # Given this declaration.
  #   describe "something", :foo => 'bar' do
  #   # ...
  #   end
  #
  #   # Any of the following will include that group.
  #   config.filter_run_including :foo => 'bar'
  #   config.filter_run_including :foo => /^ba/
  #   config.filter_run_including :foo => lambda {|v| v == 'bar'}
  #   config.filter_run_including :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   # Given a proc with an arity of 1, the lambda is passed the value
  #   # related to the key, e.g.
  #   config.filter_run_including :foo => lambda {|v| v == 'bar'}
  #
  #   # Given a proc with an arity of 2, the lambda is passed the value
  #   # related to the key, and the metadata itself e.g.
  #   config.filter_run_including :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   filter_run_including :foo # same as filter_run_including :foo => true
  def filter_run(*args); end

  # Adds key/value pairs to the `exclusion_filter`. If `args`
  # includes any symbols that are not part of the hash, each symbol
  # is treated as a key in the hash with the value `true`.
  #
  # ### Note
  #
  # Filters set using this method can be overridden from the command line
  # or config files (e.g. `.rspec`).
  #
  # @example
  #   # Given this declaration.
  #   describe "something", :foo => 'bar' do
  #   # ...
  #   end
  #
  #   # Any of the following will exclude that group.
  #   config.filter_run_excluding :foo => 'bar'
  #   config.filter_run_excluding :foo => /^ba/
  #   config.filter_run_excluding :foo => lambda {|v| v == 'bar'}
  #   config.filter_run_excluding :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   # Given a proc with an arity of 1, the lambda is passed the value
  #   # related to the key, e.g.
  #   config.filter_run_excluding :foo => lambda {|v| v == 'bar'}
  #
  #   # Given a proc with an arity of 2, the lambda is passed the value
  #   # related to the key, and the metadata itself e.g.
  #   config.filter_run_excluding :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   filter_run_excluding :foo # same as filter_run_excluding :foo => true
  def filter_run_excluding(*args); end

  # Adds key/value pairs to the `inclusion_filter`. If `args`
  # includes any symbols that are not part of the hash, each symbol
  # is treated as a key in the hash with the value `true`.
  #
  # ### Note
  #
  # Filters set using this method can be overridden from the command line
  # or config files (e.g. `.rspec`).
  #
  # @example
  #   # Given this declaration.
  #   describe "something", :foo => 'bar' do
  #   # ...
  #   end
  #
  #   # Any of the following will include that group.
  #   config.filter_run_including :foo => 'bar'
  #   config.filter_run_including :foo => /^ba/
  #   config.filter_run_including :foo => lambda {|v| v == 'bar'}
  #   config.filter_run_including :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   # Given a proc with an arity of 1, the lambda is passed the value
  #   # related to the key, e.g.
  #   config.filter_run_including :foo => lambda {|v| v == 'bar'}
  #
  #   # Given a proc with an arity of 2, the lambda is passed the value
  #   # related to the key, and the metadata itself e.g.
  #   config.filter_run_including :foo => lambda {|v,m| m[:foo] == 'bar'}
  #
  #   filter_run_including :foo # same as filter_run_including :foo => true
  def filter_run_including(*args); end

  # Applies the provided filter only if any of examples match, in constrast
  # to {#filter_run}, which always applies even if no examples match, in
  # which case no examples will be run. This allows you to leave configured
  # filters in place that are intended only for temporary use. The most common
  # example is focus filtering: `config.filter_run_when_matching :focus`.
  # With that configured, you can temporarily focus an example or group
  # by tagging it with `:focus` metadata, or prefixing it with an `f`
  # (as in `fdescribe`, `fcontext` and `fit`) since those are aliases for
  # `describe`/`context`/`it` with `:focus` metadata.
  def filter_run_when_matching(*args); end

  # Color used when a pending example is fixed. Defaults to `:blue` but can
  # be set to one of the following: `[:black, :white, :red, :green,
  # :yellow, :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def fixed_color; end

  # Color used when a pending example is fixed. Defaults to `:blue` but can
  # be set to one of the following: `[:black, :white, :red, :green,
  # :yellow, :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def fixed_color=(_arg0); end

  def fixed_color?; end

  # Used to set higher priority option values from the command line.
  #
  # @private
  def force(hash); end

  # Formats the docstring output using the block provided.
  #
  # @example
  #   # This will strip the descriptions of both examples and example
  #   # groups.
  #   RSpec.configure do |config|
  #   config.format_docstrings { |s| s.strip }
  #   end
  def format_docstrings(&block); end

  # @private
  def format_docstrings_block; end

  # Adds a formatter to the set RSpec will use for this run.
  #
  # @overload add_formatter
  # @overload add_formatter
  # @param formatter [Class, String, Object] formatter to use. Can be any of the
  #   string values supported from the CLI (`p`/`progress`,
  #   `d`/`doc`/`documentation`, `h`/`html`, or `j`/`json`), any
  #   class that implements the formatter protocol and has registered
  #   itself with RSpec as a formatter, or a formatter instance.
  # @param output [String, IO] where the formatter will write its output.
  #   Can be an IO object or a string path to a file. If not provided,
  #   the configured `output_stream` (`$stdout`, by default) will be used.
  # @see RSpec::Core::Formatters::Protocol
  def formatter=(formatter, output = T.unsafe(nil)); end

  # @private
  def formatter_loader; end

  # Returns a duplicate of the formatters currently loaded in
  # the `FormatterLoader` for introspection.
  #
  # Note as this is a duplicate, any mutations will be disregarded.
  #
  # @return [Array] the formatters currently loaded
  def formatters; end

  # Toggle full backtrace.
  #
  # @attr true_or_false [Boolean] toggle full backtrace display
  def full_backtrace=(true_or_false); end

  # Check if full backtrace is enabled.
  #
  # @return [Boolean] is full backtrace enabled
  def full_backtrace?; end

  # @return [Array] full description filter
  def full_description; end

  # Run examples matching on `description` in all files to run.
  #
  # @param description [String, Regexp] the pattern to filter on
  def full_description=(description); end

  # Holds the various registered hooks. Here we use a FilterableItemRepository
  # implementation that is specifically optimized for the read/write patterns
  # of the config object.
  #
  # @private
  def hooks; end

  # @private
  def in_project_source_dir_regex; end

  # Tells RSpec to include `mod` in example groups. Methods defined in
  # `mod` are exposed to examples (not example groups). Use `filters` to
  # constrain the groups or examples in which to include the module.
  #
  # @example
  #
  #   module AuthenticationHelpers
  #   def login_as(user)
  #   # ...
  #   end
  #   end
  #
  #   module PreferencesHelpers
  #   def preferences(user, preferences = {})
  #   # ...
  #   end
  #   end
  #
  #   module UserHelpers
  #   def users(username)
  #   # ...
  #   end
  #   end
  #
  #   RSpec.configure do |config|
  #   config.include(UserHelpers) # included in all groups
  #
  #   # included in examples with `:preferences` metadata
  #   config.include(PreferenceHelpers, :preferences)
  #
  #   # included in examples with `:type => :request` metadata
  #   config.include(AuthenticationHelpers, :type => :request)
  #   end
  #
  #   describe "edit profile", :preferences, :type => :request do
  #   it "can be viewed by owning user" do
  #   login_as preferences(users(:jdoe), :lang => 'es')
  #   get "/profiles/jdoe"
  #   assert_select ".username", :text => 'jdoe'
  #   end
  #   end
  # @note Filtered module inclusions can also be applied to
  #   individual examples that have matching metadata. Just like
  #   Ruby's object model is that every object has a singleton class
  #   which has only a single instance, RSpec's model is that every
  #   example has a singleton example group containing just the one
  #   example.
  # @see #include_context
  # @see #extend
  # @see #prepend
  def include(mod, *filters); end

  # Tells RSpec to include the named shared example group in example groups.
  # Use `filters` to constrain the groups or examples in which to include
  # the example group.
  #
  # @example
  #
  #   RSpec.shared_context "example admin user" do
  #   let(:admin_user) { create_user(:admin) }
  #   end
  #
  #   RSpec.shared_context "example guest user" do
  #   let(:guest_user) { create_user(:guest) }
  #   end
  #
  #   RSpec.configure do |config|
  #   config.include_context "example guest user", :type => :request
  #   config.include_context "example admin user", :admin, :type => :request
  #   end
  #
  #   RSpec.describe "The admin page", :type => :request do
  #   it "can be viewed by admins", :admin do
  #   login_with admin_user
  #   get "/admin"
  #   expect(response).to be_ok
  #   end
  #
  #   it "cannot be viewed by guests" do
  #   login_with guest_user
  #   get "/admin"
  #   expect(response).to be_forbidden
  #   end
  #   end
  # @note Filtered context inclusions can also be applied to
  #   individual examples that have matching metadata. Just like
  #   Ruby's object model is that every object has a singleton class
  #   which has only a single instance, RSpec's model is that every
  #   example has a singleton example group containing just the one
  #   example.
  # @see #include
  def include_context(shared_group_name, *filters); end

  # Returns the `inclusion_filter`. If none has been set, returns an empty
  # hash.
  def inclusion_filter; end

  # Clears and reassigns the `inclusion_filter`. Set to `nil` if you don't
  # want any inclusion filter at all.
  #
  # ### Warning
  #
  # This overrides any inclusion filters/tags set on the command line or in
  # configuration files.
  def inclusion_filter=(filter); end

  # @private
  def last_run_statuses; end

  # Returns dirs that have been prepended to the load path by the `-I`
  # command line option.
  #
  # @return [Array<String>]
  def libs; end

  # @private
  def libs=(libs); end

  # @private
  def load_spec_files; end

  # @private
  def loaded_spec_files; end

  # Maximum count of failed source lines to display in the failure reports.
  # (default `10`).
  # return [Integer]
  def max_displayed_failure_line_count; end

  # Maximum count of failed source lines to display in the failure reports.
  # (default `10`).
  # return [Integer]
  def max_displayed_failure_line_count=(_arg0); end

  def max_displayed_failure_line_count?; end

  # Returns the configured mock framework adapter module.
  #
  # @return [Symbol]
  def mock_framework; end

  # Delegates to mock_framework=(framework).
  def mock_framework=(framework); end

  # Sets the mock framework adapter module.
  #
  # `framework` can be a Symbol or a Module.
  #
  # Given any of `:rspec`, `:mocha`, `:flexmock`, or `:rr`, configures the
  # named framework.
  #
  # Given `:nothing`, configures no framework. Use this if you don't use
  # any mocking framework to save a little bit of overhead.
  #
  # Given a Module, includes that module in every example group. The module
  # should adhere to RSpec's mock framework adapter API:
  #
  #     setup_mocks_for_rspec
  #       - called before each example
  #
  #     verify_mocks_for_rspec
  #       - called after each example if the example hasn't yet failed.
  #         Framework should raise an exception when expectations fail
  #
  #     teardown_mocks_for_rspec
  #       - called after verify_mocks_for_rspec (even if there are errors)
  #
  # If the module responds to `configuration` and `mock_with` receives a
  # block, it will yield the configuration object to the block e.g.
  #
  #     config.mock_with OtherMockFrameworkAdapter do |mod_config|
  #       mod_config.custom_setting = true
  #     end
  def mock_with(framework); end

  # Invokes block before defining an example group
  def on_example_group_definition(&block); end

  # Returns an array of blocks to call before defining an example group
  #
  # @api private
  def on_example_group_definition_callbacks; end

  # Indicates if the `--only-failures` (or `--next-failure`) flag is being used.
  def only_failures; end

  # Indicates if the `--only-failures` (or `--next-failure`) flag is being used.
  def only_failures?; end

  # @private
  # @return [Boolean]
  def only_failures_but_not_configured?; end

  # Sets the default global ordering strategy. By default this can be one
  # of `:defined`, `:random`, but is customizable through the
  # `register_ordering` API. If order is set to `'rand:<seed>'`,
  # the seed will also be set.
  #
  # @see #register_ordering
  def order=(*args, &block); end

  # @private
  def ordering_manager; end

  def ordering_registry(*args, &block); end

  # Determines where RSpec will send its output.
  # Default: `$stdout`.
  #
  # @return [IO, String]
  def output_stream; end

  # Set the output stream for reporter.
  #
  # @attr value [IO, String] IO to write to or filename to write to, defaults to $stdout
  def output_stream=(value); end

  # Load files matching this pattern (default: `'**{,/*/**}/*_spec.rb'`).
  #
  # @return [String]
  def pattern; end

  # Set pattern to match files to load.
  #
  # @attr value [String] the filename pattern to filter spec files by
  def pattern=(value); end

  # Color to use to print pending examples.  Defaults to `:yellow` but can
  # be set to one of the following: `[:black, :white, :red, :green,
  # :yellow, :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def pending_color; end

  # Color to use to print pending examples.  Defaults to `:yellow` but can
  # be set to one of the following: `[:black, :white, :red, :green,
  # :yellow, :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def pending_color=(_arg0); end

  def pending_color?; end

  # Tells RSpec to prepend example groups with `mod`. Methods defined in
  # `mod` are exposed to examples (not example groups). Use `filters` to
  # constrain the groups in which to prepend the module.
  #
  # Similar to `include`, but module is included before the example group's class
  # in the ancestor chain.
  #
  # @example
  #
  #   module OverrideMod
  #   def override_me
  #   "overridden"
  #   end
  #   end
  #
  #   RSpec.configure do |config|
  #   config.prepend(OverrideMod, :method => :prepend)
  #   end
  #
  #   describe "overriding example's class", :method => :prepend do
  #   it "finds the user" do
  #   self.class.class_eval do
  #   def override_me
  #   end
  #   end
  #   override_me # => "overridden"
  #   # ...
  #   end
  #   end
  # @see #include
  # @see #extend
  def prepend(mod, *filters); end

  # Defines a `after` hook. See {Hooks#after} for full docs.
  #
  # This method differs from {Hooks#after} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once after
  # the last example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #append_after
  # @see #before
  # @see #prepend_before
  def prepend_after(scope = T.unsafe(nil), *meta, &block); end

  # Adds `block` to the start of the list of `before` blocks in the same
  # scope (`:example`, `:context`, or `:suite`), in contrast to {#before},
  # which adds the hook to the end of the list.
  #
  # See {Hooks#before} for full `before` hook docs.
  #
  # This method differs from {Hooks#prepend_before} in only one way: it supports
  # the `:suite` scope. Hooks with the `:suite` scope will be run once before
  # the first example of the entire suite is executed. Conditions passed along
  # with `:suite` are effectively ignored.
  #
  # @see #before
  # @see #after
  # @see #append_after
  def prepend_before(scope = T.unsafe(nil), *meta, &block); end

  # Defaults `profile_examples` to 10 examples when `@profile_examples` is
  # `true`.
  #
  # @api private
  def profile_examples; end

  # Report the times for the slowest examples (default: `false`).
  # Use this to specify the number of examples to include in the profile.
  #
  # @return [Boolean]
  def profile_examples=(_arg0); end

  def profile_examples?; end

  # Specifies which directories contain the source code for your project.
  # When a failure occurs, RSpec looks through the backtrace to find a
  # a line of source to print. It first looks for a line coming from
  # one of the project source directories so that, for example, it prints
  # the expectation or assertion call rather than the source code from
  # the expectation or assertion framework.
  #
  # @return [Array<String>]
  def project_source_dirs; end

  # Specifies which directories contain the source code for your project.
  # When a failure occurs, RSpec looks through the backtrace to find a
  # a line of source to print. It first looks for a line coming from
  # one of the project source directories so that, for example, it prints
  # the expectation or assertion call rather than the source code from
  # the expectation or assertion framework.
  #
  # @return [Array<String>]
  def project_source_dirs=(_arg0); end

  def project_source_dirs?; end

  # Turns deprecation warnings into errors, in order to surface
  # the full backtrace of the call site. This can be useful when
  # you need more context to address a deprecation than the
  # single-line call site normally provided.
  #
  # @example
  #
  #   RSpec.configure do |rspec|
  #   rspec.raise_errors_for_deprecations!
  #   end
  def raise_errors_for_deprecations!; end

  # Turns warnings into errors. This can be useful when
  # you want RSpec to run in a 'strict' no warning situation.
  #
  # @example
  #
  #   RSpec.configure do |rspec|
  #   rspec.raise_on_warning = true
  #   end
  def raise_on_warning=(value); end

  # Registers a named ordering strategy that can later be
  # used to order an example group's subgroups by adding
  # `:order => <name>` metadata to the example group.
  #
  # @example
  #   RSpec.configure do |rspec|
  #   rspec.register_ordering :reverse do |list|
  #   list.reverse
  #   end
  #   end
  #
  #   RSpec.describe 'MyClass', :order => :reverse do
  #   # ...
  #   end
  # @example
  #   RSpec.configure do |rspec|
  #   rspec.register_ordering :global do |examples|
  #   acceptance, other = examples.partition do |example|
  #   example.metadata[:type] == :acceptance
  #   end
  #   other + acceptance
  #   end
  #   end
  #
  #   RSpec.describe 'MyClass', :type => :acceptance do
  #   # will run last
  #   end
  #
  #   RSpec.describe 'MyClass' do
  #   # will run first
  #   end
  # @note Pass the symbol `:global` to set the ordering strategy that
  #   will be used to order the top-level example groups and any example
  #   groups that do not have declared `:order` metadata.
  # @param name [Symbol] The name of the ordering.
  # @yield Block that will order the given examples or example groups
  # @yieldparam list [Array<RSpec::Core::Example>, Array<RSpec::Core::ExampleGroup>] The examples or groups to order
  # @yieldreturn [Array<RSpec::Core::Example>, Array<RSpec::Core::ExampleGroup>] The re-ordered examples or groups
  def register_ordering(*args, &block); end

  # @return [RSpec::Core::Reporter] the currently configured reporter
  def reporter; end

  # Indicates files configured to be required.
  #
  # @return [Array<String>]
  def requires; end

  # @private
  def requires=(paths); end

  # @private
  def reset; end

  # @private
  def reset_filters; end

  # @private
  def reset_reporter; end

  # Run all examples if none match the configured filters
  # (default: `false`).
  #
  # @deprecated Use {#filter_run_when_matching} instead for the specific
  #   filters that you want to be ignored if none match.
  def run_all_when_everything_filtered; end

  # Run all examples if none match the configured filters
  # (default: `false`).
  #
  # @deprecated Use {#filter_run_when_matching} instead for the specific
  #   filters that you want to be ignored if none match.
  def run_all_when_everything_filtered=(_arg0); end

  def run_all_when_everything_filtered?; end

  # Seed for random ordering (default: generated randomly each run).
  #
  # When you run specs with `--order random`, RSpec generates a random seed
  # for the randomization and prints it to the `output_stream` (assuming
  # you're using RSpec's built-in formatters). If you discover an ordering
  # dependency (i.e. examples fail intermittently depending on order), set
  # this (on Configuration or on the command line with `--seed`) to run
  # using the same seed while you debug the issue.
  #
  # We recommend, actually, that you use the command line approach so you
  # don't accidentally leave the seed encoded.
  def seed(*args, &block); end

  # Sets the seed value and sets the default global ordering to random.
  def seed=(*args, &block); end

  def seed_used?(*args, &block); end

  # Configures how RSpec treats metadata passed as part of a shared example
  # group definition. For example, given this shared example group definition:
  #
  #     RSpec.shared_context "uses DB", :db => true do
  #       around(:example) do |ex|
  #         MyORM.transaction(:rollback => true, &ex)
  #       end
  #     end
  #
  # ...there are two ways RSpec can treat the `:db => true` metadata, each
  # of which has a corresponding config option:
  #
  # 1. `:trigger_inclusion`: this shared context will be implicitly included
  #    in any groups (or examples) that have `:db => true` metadata.
  # 2. `:apply_to_host_groups`: the metadata will be inherited by the metadata
  #    hash of all host groups and examples.
  #
  # `:trigger_inclusion` is the legacy behavior from before RSpec 3.5 but should
  # be considered deprecated. Instead, you can explicitly include a group with
  # `include_context`:
  #
  #     RSpec.describe "My model" do
  #       include_context "uses DB"
  #     end
  #
  # ...or you can configure RSpec to include the context based on matching metadata
  # using an API that mirrors configured module inclusion:
  #
  #     RSpec.configure do |rspec|
  #       rspec.include_context "uses DB", :db => true
  #     end
  #
  # `:apply_to_host_groups` is a new feature of RSpec 3.5 and will be the only
  # supported behavior in RSpec 4.
  #
  # @overload shared_context_metadata_behavior
  # @overload shared_context_metadata_behavior=
  def shared_context_metadata_behavior; end

  # @see shared_context_metadata_behavior
  def shared_context_metadata_behavior=(value); end

  # Don't print filter info i.e. "Run options: include {:focus=>true}"
  # (default `false`).
  # return [Boolean]
  def silence_filter_announcements; end

  # Don't print filter info i.e. "Run options: include {:focus=>true}"
  # (default `false`).
  # return [Boolean]
  def silence_filter_announcements=(_arg0); end

  def silence_filter_announcements?; end

  # @private
  def spec_files_with_failures; end

  def start_time; end
  def start_time=(_arg0); end
  def start_time?; end

  # @private
  def static_config_filter_manager; end

  # @private
  def static_config_filter_manager=(_arg0); end

  # Color to use to indicate success.  Defaults to `:green` but can be set
  # to one of the following: `[:black, :white, :red, :green, :yellow,
  # :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def success_color; end

  # Color to use to indicate success.  Defaults to `:green` but can be set
  # to one of the following: `[:black, :white, :red, :green, :yellow,
  # :blue, :magenta, :cyan]`
  #
  # @return [Symbol]
  def success_color=(_arg0); end

  def success_color?; end

  # Use threadsafe options where available.
  # Currently this will place a mutex around memoized values such as let blocks.
  # return [Boolean]
  def threadsafe; end

  # Use threadsafe options where available.
  # Currently this will place a mutex around memoized values such as let blocks.
  # return [Boolean]
  def threadsafe=(_arg0); end

  def threadsafe?; end

  # @deprecated This config option was added in RSpec 2 to pave the way
  #   for this being the default behavior in RSpec 3. Now this option is
  #   a no-op.
  def treat_symbols_as_metadata_keys_with_true_values=(_value); end

  def tty; end
  def tty=(_arg0); end
  def tty?; end

  # Set Ruby warnings on or off.
  def warnings=(value); end

  # @return [Boolean] Whether or not ruby warnings are enabled.
  def warnings?; end

  # Defines a callback that runs after the first example with matching
  # metadata is defined. If no examples are defined with matching metadata,
  # it will not get called at all.
  #
  # This can be used to ensure some setup is performed (such as bootstrapping
  # a DB or loading a specific file that adds significantly to the boot time)
  # if needed (as indicated by the presence of an example with matching metadata)
  # but avoided otherwise.
  #
  # @example
  #   RSpec.configure do |config|
  #   config.when_first_matching_example_defined(:db) do
  #   # Load a support file that does some heavyweight setup,
  #   # including bootstrapping the DB, but only if we have loaded
  #   # any examples tagged with `:db`.
  #   require 'support/db'
  #   end
  #   end
  def when_first_matching_example_defined(*filters); end

  # @private
  def with_suite_hooks; end

  # @private
  def world; end

  # @private
  def world=(_arg0); end

  private

  # :nocov:
  #
  # @return [Boolean]
  def absolute_pattern?(pattern); end

  def add_hook_to_existing_matching_groups(meta, scope, &block); end

  # @raise [MustBeConfiguredBeforeExampleGroupsError]
  def assert_no_example_groups_defined(config_option); end

  def clear_values_derived_from_example_status_persistence_file_path; end
  def command; end
  def conditionally_disable_expectations_monkey_patching; end
  def conditionally_disable_mocks_monkey_patching; end
  def configure_group_with(group, module_list, application_method); end
  def define_built_in_hooks; end
  def define_mixed_in_module(mod, filters, mod_list, config_method, &block); end
  def extract_location(path); end
  def file_glob_from(path, pattern); end
  def gather_directories(path); end
  def get_files_to_run(paths); end
  def get_matching_files(path, pattern); end
  def handle_suite_hook(scope, meta); end
  def load_file_handling_errors(method, file); end

  # @return [Boolean]
  def metadata_applies_to_group?(meta, group); end

  def on_existing_matching_groups(meta); end

  # @return [Boolean]
  def output_to_tty?(output = T.unsafe(nil)); end

  def output_wrapper; end
  def paths_to_check(paths); end

  # @return [Boolean]
  def pattern_might_load_specs_from_vendored_dirs?; end

  # @return [Boolean]
  def rspec_expectations_loaded?; end

  # @return [Boolean]
  def rspec_mocks_loaded?; end

  def run_suite_hooks(hook_description, hooks); end
  def safe_extend(mod, host); end

  # :nocov:
  def safe_include(mod, host); end

  def safe_prepend(mod, host); end
  def update_pattern_attr(name, value); end
  def value_for(key); end

  class << self
    # As `add_setting` but only add the reader.
    #
    # @private
    def add_read_only_setting(name, opts = T.unsafe(nil)); end

    # Invoked by the `add_setting` instance method. Use that method on a
    # `Configuration` instance rather than this class method.
    #
    # @private
    def add_setting(name, opts = T.unsafe(nil)); end

    # @private
    def define_alias(name, alias_name); end

    # @private
    def define_predicate(name); end

    # @private
    def define_reader(name); end

    # @private
    def delegate_to_ordering_manager(*methods); end
  end
end

# @private
RSpec::Core::Configuration::DEFAULT_FORMATTER = T.let(T.unsafe(nil), Proc)

# This buffer is used to capture all messages sent to the reporter during
# reporter initialization. It can then replay those messages after the
# formatter is correctly initialized. Otherwise, deprecation warnings
# during formatter initialization can cause an infinite loop.
#
# @private
class RSpec::Core::Configuration::DeprecationReporterBuffer
  # @return [DeprecationReporterBuffer] a new instance of DeprecationReporterBuffer
  def initialize; end

  def deprecation(*args); end
  def play_onto(reporter); end
end

# @private
module RSpec::Core::Configuration::ExposeCurrentExample; end

# @private
RSpec::Core::Configuration::FAILED_STATUS = T.let(T.unsafe(nil), String)

# @private
RSpec::Core::Configuration::MOCKING_ADAPTERS = T.let(T.unsafe(nil), Hash)

# @private
class RSpec::Core::Configuration::MustBeConfiguredBeforeExampleGroupsError < ::StandardError; end

# @private
RSpec::Core::Configuration::PASSED_STATUS = T.let(T.unsafe(nil), String)

# @private
RSpec::Core::Configuration::PENDING_STATUS = T.let(T.unsafe(nil), String)

# @private
RSpec::Core::Configuration::RAISE_ERROR_WARNING_NOTIFIER = T.let(T.unsafe(nil), Proc)

# Module that holds `attr_reader` declarations. It's in a separate
# module to allow us to override those methods and use `super`.
#
# @private
module RSpec::Core::Configuration::Readers
  def default_color; end
  def default_path; end
  def deprecation_stream; end
  def detail_color; end
  def drb; end
  def drb_port; end
  def dry_run; end
  def error_exit_code; end
  def error_stream; end
  def example_status_persistence_file_path; end
  def exclude_pattern; end
  def fail_fast; end
  def fail_if_no_examples; end
  def failure_color; end
  def failure_exit_code; end
  def fixed_color; end
  def libs; end
  def max_displayed_failure_line_count; end
  def only_failures; end
  def output_stream; end
  def pattern; end
  def pending_color; end
  def project_source_dirs; end
  def requires; end
  def run_all_when_everything_filtered; end
  def shared_context_metadata_behavior; end
  def silence_filter_announcements; end
  def start_time; end
  def success_color; end
  def threadsafe; end
  def tty; end
end

# @private
RSpec::Core::Configuration::UNKNOWN_STATUS = T.let(T.unsafe(nil), String)

# @private
RSpec::Core::Configuration::VALID_STATUSES = T.let(T.unsafe(nil), Array)

# Responsible for utilizing externally provided configuration options,
# whether via the command line, `.rspec`, `~/.rspec`,
# `$XDG_CONFIG_HOME/rspec/options`, `.rspec-local` or a custom options
# file.
class RSpec::Core::ConfigurationOptions
  # @param args [Array<String>] command line arguments
  # @return [ConfigurationOptions] a new instance of ConfigurationOptions
  def initialize(args); end

  # @return [Array<String>] the original command-line arguments
  def args; end

  # Updates the provided {Configuration} instance based on the provided
  # external configuration options.
  #
  # @param config [Configuration] the configuration instance to update
  def configure(config); end

  # Updates the provided {FilterManager} based on the filter options.
  #
  # @api private
  # @param filter_manager [FilterManager] instance to update
  def configure_filter_manager(filter_manager); end

  # @return [Hash] the final merged options, drawn from all external sources
  def options; end

  private

  def args_from_options_file(path); end
  def command_line_options; end
  def custom_options; end
  def custom_options_file; end
  def env_options; end
  def file_options; end

  # @return [Boolean]
  def force?(key); end

  def global_options; end
  def global_options_file; end
  def home_options_file_path; end
  def load_formatters_into(config); end
  def local_options; end
  def local_options_file; end
  def options_file_as_erb_string(path); end
  def options_from(path); end
  def order(keys); end
  def organize_options; end
  def parse_args_ignoring_files_or_dirs_to_run(args, source); end
  def process_options_into(config); end
  def project_options; end
  def project_options_file; end
  def resolve_xdg_config_home; end
  def xdg_options_file_if_exists; end
  def xdg_options_file_path; end
end

RSpec::Core::ConfigurationOptions::OPTIONS_ORDER = T.let(T.unsafe(nil), Array)
RSpec::Core::ConfigurationOptions::UNFORCED_OPTIONS = T.let(T.unsafe(nil), RSpec::Core::Set)
RSpec::Core::ConfigurationOptions::UNPROCESSABLE_OPTIONS = T.let(T.unsafe(nil), RSpec::Core::Set)

# DSL defines methods to group examples, most notably `describe`,
# and exposes them as class methods of {RSpec}. They can also be
# exposed globally (on `main` and instances of `Module`) through
# the {Configuration} option `expose_dsl_globally`.
#
# By default the methods `describe`, `context` and `example_group`
# are exposed. These methods define a named context for one or
# more examples. The given block is evaluated in the context of
# a generated subclass of {RSpec::Core::ExampleGroup}.
#
# ## Examples:
#
#     RSpec.describe "something" do
#       context "when something is a certain way" do
#         it "does something" do
#           # example code goes here
#         end
#       end
#     end
#
# @see ExampleGroup
# @see ExampleGroup.example_group
module RSpec::Core::DSL
  class << self
    # @private
    def change_global_dsl(&changes); end

    # @private
    def example_group_aliases; end

    # @private
    def expose_example_group_alias(name); end

    # @private
    def expose_example_group_alias_globally(method_name); end

    # Adds the describe method to Module and the top level binding.
    #
    # @api private
    def expose_globally!; end

    # @private
    # @return [Boolean]
    def exposed_globally?; end

    # Removes the describe method from Module and the top level binding.
    #
    # @api private
    def remove_globally!; end

    # @private
    def top_level; end

    # @private
    def top_level=(_arg0); end
  end
end

# Deprecation Error.
class RSpec::Core::DeprecationError < ::StandardError; end

# Wrapper around Ruby's `DidYouMean::SpellChecker` when available to provide file name suggestions.
#
# @private
class RSpec::Core::DidYouMean
  # @return [DidYouMean] a new instance of DidYouMean
  def initialize(relative_file_name); end

  # return a hint if API for ::DidYouMean::SpellChecker not supported
  def call; end

  # Returns the value of attribute relative_file_name.
  def relative_file_name; end

  private

  def formats(probables); end
  def red_font(mytext); end
  def top_and_tail(rspec_format); end
end

# Wrapper for an instance of a subclass of {ExampleGroup}. An instance of
# `RSpec::Core::Example` is returned by example definition methods
# such as {ExampleGroup.it it} and is yielded to the {ExampleGroup.it it},
# {Hooks#before before}, {Hooks#after after}, {Hooks#around around},
# {MemoizedHelpers::ClassMethods#let let} and
# {MemoizedHelpers::ClassMethods#subject subject} blocks.
#
# This allows us to provide rich metadata about each individual
# example without adding tons of methods directly to the ExampleGroup
# that users may inadvertently redefine.
#
# Useful for configuring logging and/or taking some action based
# on the state of an example's metadata.
#
# @example
#
#   RSpec.configure do |config|
#   config.before do |example|
#   log example.description
#   end
#
#   config.after do |example|
#   log example.description
#   end
#
#   config.around do |example|
#   log example.description
#   example.run
#   end
#   end
#
#   shared_examples "auditable" do
#   it "does something" do
#   log "#{example.full_description}: #{auditable.inspect}"
#   auditable.should do_something
#   end
#   end
# @note Example blocks are evaluated in the context of an instance
#   of an `ExampleGroup`, not in the context of an instance of `Example`.
# @see ExampleGroup
class RSpec::Core::Example
  # Creates a new instance of Example.
  #
  # @api private
  # @param example_group_class [Class] the subclass of ExampleGroup in which
  #   this Example is declared
  # @param description [String] the String passed to the `it` method (or
  #   alias)
  # @param user_metadata [Hash] additional args passed to `it` to be used as
  #   metadata
  # @param example_block [Proc] the block of code that represents the
  #   example
  # @return [Example] a new instance of Example
  def initialize(example_group_class, description, user_metadata, example_block = T.unsafe(nil)); end

  # @attr
  # @private
  def clock; end

  # @attr
  # @private
  def clock=(_arg0); end

  # Returns the string submitted to `example` or its aliases (e.g.
  # `specify`, `it`, etc). If no string is submitted (e.g.
  # `it { is_expected.to do_something }`) it returns the message generated
  # by the matcher if there is one, otherwise returns a message including
  # the location of the example.
  def description; end

  # The exception that will be displayed to the user -- either the failure of
  # the example or the `pending_exception` if the example is pending.
  #
  # @private
  def display_exception; end

  # Assigns the exception that will be displayed to the user -- either the failure of
  # the example or the `pending_exception` if the example is pending.
  #
  # @private
  def display_exception=(ex); end

  # Duplicates the example and overrides metadata with the provided
  # hash.
  #
  # @param metadata_overrides [Hash] the hash to override the example metadata
  # @return [Example] a duplicate of the example with modified metadata
  def duplicate_with(metadata_overrides = T.unsafe(nil)); end

  # Returns the example group class that provides the context for running
  # this example.
  def example_group; end

  # Returns the example_group_instance that provides the context for
  # running this example.
  #
  # @attr_reader
  # @private
  def example_group_instance; end

  # Returns the first exception raised in the context of running this
  # example (nil if no exception is raised).
  #
  # @attr_reader
  def exception; end

  # @return [ExecutionResult] represents the result of running this example.
  def execution_result; end

  # Used internally to set an exception and fail without actually executing
  # the example when an exception is raised in before(:context).
  #
  # @private
  def fail_with_exception(reporter, exception); end

  # @return [String] the relative path to the file where this example was
  #   defined.
  def file_path; end

  # @return [String] the full description (including the docstrings of
  #   all parent example groups).
  def full_description; end

  # @return [String] the unique id of this example. Pass
  #   this at the command line to re-run this exact example.
  def id; end

  # Provide a human-readable representation of this class
  def inspect; end

  # Returns a description of the example that always includes the location.
  def inspect_output; end

  # @private
  def instance_exec(*args, &block); end

  # @return [String] the exact source location of this example in a form
  #   like `./path/to/spec.rb:17`
  def location; end

  # Returns the location-based argument that can be passed to the `rspec` command to rerun this example.
  def location_rerun_argument; end

  # Returns the metadata object associated with this example.
  #
  # @attr_reader
  def metadata; end

  # @return [Boolean] flag that indicates that the example is not expected
  #   to pass. It will be run and will either have a pending result (if a
  #   failure occurs) or a failed result (if no failure occurs).
  def pending; end

  # @return [Boolean]
  def pending?; end

  # @return [RSpec::Core::Reporter] the current reporter for the example
  def reporter; end

  # Returns the location-based argument that can be passed to the `rspec` command to rerun this example.
  #
  # @deprecated Use {#location_rerun_argument} instead.
  # @note If there are multiple examples identified by this location, they will use {#id}
  #   to rerun instead, but this method will still return the location (that's why it is deprecated!).
  def rerun_argument; end

  # instance_execs the block passed to the constructor in the context of
  # the instance of {ExampleGroup}.
  #
  # @api private
  # @param example_group_instance the instance of an ExampleGroup subclass
  def run(example_group_instance, reporter); end

  # Used to set the exception when `aggregate_failures` fails.
  #
  # @private
  def set_aggregate_failures_exception(exception); end

  # Used internally to set an exception in an after hook, which
  # captures the exception but doesn't raise it.
  #
  # @private
  def set_exception(exception); end

  # @return [Boolean] flag that will cause the example to not run.
  #   The {ExecutionResult} status will be `:pending`.
  def skip; end

  # Used internally to skip without actually executing the example when
  # skip is used in before(:context).
  #
  # @private
  def skip_with_exception(reporter, exception); end

  # @return [Boolean]
  def skipped?; end

  # Provide a human-readable representation of this class
  def to_s; end

  # @private
  def update_inherited_metadata(updates); end

  private

  def assign_generated_description; end
  def finish(reporter); end
  def generate_description; end
  def hooks; end
  def location_description; end

  # @return [Boolean]
  def mocks_need_verification?; end

  def record_finished(status, reporter); end
  def run_after_example; end
  def run_before_example; end
  def start(reporter); end
  def verify_mocks; end
  def with_around_and_singleton_context_hooks; end
  def with_around_example_hooks; end

  class << self
    # Used to define methods that delegate to this example's metadata.
    #
    # @private
    def delegate_to_metadata(key); end

    # @private
    def parse_id(id); end
  end
end

# @private
RSpec::Core::Example::AllExceptionsExcludingDangerousOnesOnRubiesThatAllowIt = RSpec::Support::AllExceptionsExceptOnesWeMustNotRescue

# Represents the result of executing an example.
# Behaves like a hash for backwards compatibility.
class RSpec::Core::Example::ExecutionResult
  include ::RSpec::Core::HashImitatable
  extend ::RSpec::Core::HashImitatable::ClassMethods

  # Populates finished_at and run_time if it has not yet been set
  #
  # @api private
  def ensure_timing_set(clock); end

  # @return [Boolean] Indicates if the example was completely skipped
  #   (typically done via `:skip` metadata or the `skip` method). Skipped examples
  #   will have a `:pending` result. A `:pending` result can also come from examples
  #   that were marked as `:pending`, which causes them to be run, and produces a
  #   `:failed` result if the example passes.
  def example_skipped?; end

  # @return [Exception, nil] The failure, if there was one.
  def exception; end

  # @return [Exception, nil] The failure, if there was one.
  def exception=(_arg0); end

  # @return [Time] When the example finished.
  def finished_at; end

  # @return [Time] When the example finished.
  def finished_at=(_arg0); end

  # @return [Exception, nil] The exception triggered while
  #   executing the pending example. If no exception was triggered
  #   it would no longer get a status of `:pending` unless it was
  #   tagged with `:skip`.
  def pending_exception; end

  # @return [Exception, nil] The exception triggered while
  #   executing the pending example. If no exception was triggered
  #   it would no longer get a status of `:pending` unless it was
  #   tagged with `:skip`.
  def pending_exception=(_arg0); end

  # @return [Boolean] For examples tagged with `:pending`,
  #   this indicates whether or not it now passes.
  def pending_fixed; end

  # @return [Boolean] For examples tagged with `:pending`,
  #   this indicates whether or not it now passes.
  def pending_fixed=(_arg0); end

  # @return [Boolean]
  def pending_fixed?; end

  # @return [String, nil] The reason the example was pending,
  #   or nil if the example was not pending.
  def pending_message; end

  # @return [String, nil] The reason the example was pending,
  #   or nil if the example was not pending.
  def pending_message=(_arg0); end

  # Records the finished status of the example.
  #
  # @api private
  def record_finished(status, finished_at); end

  # @return [Float] How long the example took in seconds.
  def run_time; end

  # @return [Float] How long the example took in seconds.
  def run_time=(_arg0); end

  # @return [Time] When the example started.
  def started_at; end

  # @return [Time] When the example started.
  def started_at=(_arg0); end

  # @return [Symbol] `:passed`, `:failed` or `:pending`.
  def status; end

  # @return [Symbol] `:passed`, `:failed` or `:pending`.
  def status=(_arg0); end

  private

  def calculate_run_time(finished_at); end
  def get_value(name); end

  # For backwards compatibility we present `status` as a string
  # when presenting the legacy hash interface.
  def hash_for_delegation; end

  def issue_deprecation(_method_name, *_args); end
  def set_value(name, value); end
end

# Wraps both a `Proc` and an {Example} for use in {Hooks#around
# around} hooks. In around hooks we need to yield this special
# kind of object (rather than the raw {Example}) because when
# there are multiple `around` hooks we have to wrap them recursively.
#
# @example
#
#   RSpec.configure do |c|
#   c.around do |ex| # Procsy which wraps the example
#   if ex.metadata[:key] == :some_value && some_global_condition
#   raise "some message"
#   end
#   ex.run         # run delegates to ex.call.
#   end
#   end
# @note This class also exposes the instance methods of {Example},
#   proxying them through to the wrapped {Example} instance.
class RSpec::Core::Example::Procsy
  # @return [Procsy] a new instance of Procsy
  def initialize(example, &block); end

  def <<(*a, &b); end
  def ==(*a, &b); end
  def ===(*a, &b); end
  def >>(*a, &b); end
  def [](*a, &b); end
  def arity(*a, &b); end
  def binding(*a, &b); end

  # Calls the proc and notes that the example has been executed.
  def call(*args, &block); end

  def clock(*a, &b); end
  def clock=(*a, &b); end
  def clone(*a, &b); end
  def curry(*a, &b); end
  def description(*a, &b); end
  def dup(*a, &b); end
  def duplicate_with(*a, &b); end
  def eql?(*a, &b); end

  # The {Example} instance.
  def example; end

  def example_group(*a, &b); end
  def example_group_instance(*a, &b); end
  def exception(*a, &b); end

  # Indicates whether or not the around hook has executed the example.
  #
  # @return [Boolean]
  def executed?; end

  def execution_result(*a, &b); end
  def file_path(*a, &b); end
  def full_description(*a, &b); end
  def hash(*a, &b); end
  def id(*a, &b); end

  # @private
  def inspect; end

  def inspect_output(*a, &b); end
  def lambda?(*a, &b); end
  def location(*a, &b); end
  def location_rerun_argument(*a, &b); end
  def metadata(*a, &b); end
  def parameters(*a, &b); end
  def pending(*a, &b); end
  def pending?(*a, &b); end
  def reporter(*a, &b); end
  def rerun_argument(*a, &b); end
  def ruby2_keywords(*a, &b); end

  # Calls the proc and notes that the example has been executed.
  def run(*args, &block); end

  def skip(*a, &b); end
  def skipped?(*a, &b); end
  def source_location(*a, &b); end

  # Provides a wrapped proc that will update our `executed?` state when
  # executed.
  def to_proc; end

  def update_inherited_metadata(*a, &b); end

  # @private
  def wrap(&block); end

  def yield(*a, &b); end
end

# ExampleGroup and {Example} are the main structural elements of
# rspec-core. Consider this example:
#
#     RSpec.describe Thing do
#       it "does something" do
#       end
#     end
#
# The object returned by `describe Thing` is a subclass of ExampleGroup.
# The object returned by `it "does something"` is an instance of Example,
# which serves as a wrapper for an instance of the ExampleGroup in which it
# is declared.
#
# Example group bodies (e.g. `describe` or `context` blocks) are evaluated
# in the context of a new subclass of ExampleGroup. Individual examples are
# evaluated in the context of an instance of the specific ExampleGroup
# subclass to which they belong.
#
# Besides the class methods defined here, there are other interesting macros
# defined in {Hooks}, {MemoizedHelpers::ClassMethods} and
# {SharedExampleGroup}. There are additional instance methods available to
# your examples defined in {MemoizedHelpers} and {Pending}.
class RSpec::Core::ExampleGroup
  include ::RSpec::Core::MemoizedHelpers
  include ::RSpec::Core::Pending
  extend ::RSpec::Core::Hooks
  extend ::RSpec::Core::MemoizedHelpers::ClassMethods
  extend ::RSpec::Core::SharedExampleGroup

  def initialize(inspect_output = T.unsafe(nil)); end

  # Returns the class or module passed to the `describe` method (or alias).
  # Returns nil if the subject is not a class or module.
  #
  # @example
  #   RSpec.describe Thing do
  #   it "does something" do
  #   described_class == Thing
  #   end
  #   end
  def described_class; end

  def inspect; end

  private

  def method_missing(name, *args, **_arg2); end

  class << self
    # Adds an example to the example group
    def add_example(example); end

    # @private
    def before_context_ivars; end

    # @private
    def children; end

    def context(*args, &example_group_block); end

    # Returns true if a `before(:context)` or `after(:context)`
    # hook is currently executing.
    #
    # @return [Boolean]
    def currently_executing_a_context_hook?; end

    # @private
    def declaration_locations; end

    # @private
    # @see DSL#describe
    def define_example_group_method(name, metadata = T.unsafe(nil)); end

    # @example
    #     $1 "does something", :slow, :load_factor => 100 do
    #     end
    #
    # @private
    def define_example_method(name, extra_options = T.unsafe(nil)); end

    # @private
    def define_nested_shared_group_method(new_name, report_label = T.unsafe(nil)); end

    # @private
    def delegate_to_metadata(*names); end

    # @private
    def descendant_filtered_examples; end

    # @private
    def descendants; end

    def describe(*args, &example_group_block); end
    def described_class; end

    # @return [String] the current example group description
    def description; end

    # @private
    def each_instance_variable_for_example(group); end

    # @private
    def ensure_example_groups_are_configured; end

    # Defines an example within a group.
    #
    # @example
    #   example do
    #   end
    #
    #   example "does something" do
    #   end
    #
    #   example "does something", :slow, :uses_js do
    #   end
    #
    #   example "does something", :with => 'additional metadata' do
    #   end
    #
    #   example "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload example
    # @overload example
    # @overload example
    # @overload example
    # @yield [Example] the example object
    def example(*all_args, &block); end

    def example_group(*args, &example_group_block); end

    # @private
    def examples; end

    def fcontext(*args, &example_group_block); end
    def fdescribe(*args, &example_group_block); end

    # Shortcut to define an example with `:focus => true`.
    #
    # @example
    #   fexample do
    #   end
    #
    #   fexample "does something" do
    #   end
    #
    #   fexample "does something", :slow, :uses_js do
    #   end
    #
    #   fexample "does something", :with => 'additional metadata' do
    #   end
    #
    #   fexample "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload fexample
    # @overload fexample
    # @overload fexample
    # @overload fexample
    # @see example
    # @yield [Example] the example object
    def fexample(*all_args, &block); end

    def file_path; end

    # @private
    def filtered_examples; end

    # @private
    def find_and_eval_shared(label, name, inclusion_location, *args, &customization_block); end

    # Shortcut to define an example with `:focus => true`.
    #
    # @example
    #   fit do
    #   end
    #
    #   fit "does something" do
    #   end
    #
    #   fit "does something", :slow, :uses_js do
    #   end
    #
    #   fit "does something", :with => 'additional metadata' do
    #   end
    #
    #   fit "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload fit
    # @overload fit
    # @overload fit
    # @overload fit
    # @see example
    # @yield [Example] the example object
    def fit(*all_args, &block); end

    # Shortcut to define an example with `:focus => true`.
    #
    # @example
    #   focus do
    #   end
    #
    #   focus "does something" do
    #   end
    #
    #   focus "does something", :slow, :uses_js do
    #   end
    #
    #   focus "does something", :with => 'additional metadata' do
    #   end
    #
    #   focus "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload focus
    # @overload focus
    # @overload focus
    # @overload focus
    # @see example
    # @yield [Example] the example object
    def focus(*all_args, &block); end

    # @private
    def for_filtered_examples(reporter, &block); end

    # Shortcut to define an example with `:focus => true`.
    #
    # @example
    #   fspecify do
    #   end
    #
    #   fspecify "does something" do
    #   end
    #
    #   fspecify "does something", :slow, :uses_js do
    #   end
    #
    #   fspecify "does something", :with => 'additional metadata' do
    #   end
    #
    #   fspecify "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload fspecify
    # @overload fspecify
    # @overload fspecify
    # @overload fspecify
    # @see example
    # @yield [Example] the example object
    def fspecify(*all_args, &block); end

    # @return [String] the unique id of this example group. Pass
    #   this at the command line to re-run this exact example group.
    def id; end

    # Define a singleton method for the singleton class (remove the method if
    # it's already been defined).
    #
    # @private
    def idempotently_define_singleton_method(name, &definition); end

    # Includes shared content mapped to `name` directly in the group in which
    # it is declared, as opposed to `it_behaves_like`, which creates a nested
    # group. If given a block, that block is also eval'd in the current
    # context.
    #
    # @see SharedExampleGroup
    def include_context(name, *args, &block); end

    # Includes shared content mapped to `name` directly in the group in which
    # it is declared, as opposed to `it_behaves_like`, which creates a nested
    # group. If given a block, that block is also eval'd in the current
    # context.
    #
    # @see SharedExampleGroup
    def include_examples(name, *args, &block); end

    # Defines an example within a group.
    # This is the primary API to define a code example.
    #
    # @example
    #   it do
    #   end
    #
    #   it "does something" do
    #   end
    #
    #   it "does something", :slow, :uses_js do
    #   end
    #
    #   it "does something", :with => 'additional metadata' do
    #   end
    #
    #   it "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload it
    # @overload it
    # @overload it
    # @overload it
    # @yield [Example] the example object
    def it(*all_args, &block); end

    def it_behaves_like(name, *args, &customization_block); end
    def it_should_behave_like(name, *args, &customization_block); end
    def location; end

    # The [Metadata](Metadata) object associated with this group.
    #
    # @see Metadata
    def metadata; end

    # @private
    def next_runnable_index_for(file); end

    # @private
    def ordering_strategy; end

    # @private
    def parent_groups; end

    # Shortcut to define an example with `:pending => true`
    #
    # @example
    #   pending do
    #   end
    #
    #   pending "does something" do
    #   end
    #
    #   pending "does something", :slow, :uses_js do
    #   end
    #
    #   pending "does something", :with => 'additional metadata' do
    #   end
    #
    #   pending "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload pending
    # @overload pending
    # @overload pending
    # @overload pending
    # @see example
    # @yield [Example] the example object
    def pending(*all_args, &block); end

    # Removes an example from the example group
    def remove_example(example); end

    # Clear memoized values when adding/removing examples
    #
    # @private
    def reset_memoized; end

    # Runs all the examples in this group.
    def run(reporter = T.unsafe(nil)); end

    # @private
    def run_after_context_hooks(example_group_instance); end

    # @private
    def run_before_context_hooks(example_group_instance); end

    # @private
    def run_examples(reporter); end

    # @private
    def set_it_up(description, args, registration_collection, &example_group_block); end

    # @private
    def set_ivars(instance, ivars); end

    # Shortcut to define an example with `:skip => true`
    #
    # @example
    #   skip do
    #   end
    #
    #   skip "does something" do
    #   end
    #
    #   skip "does something", :slow, :uses_js do
    #   end
    #
    #   skip "does something", :with => 'additional metadata' do
    #   end
    #
    #   skip "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload skip
    # @overload skip
    # @overload skip
    # @overload skip
    # @see example
    # @yield [Example] the example object
    def skip(*all_args, &block); end

    # Defines an example within a group.
    # Useful for when your docstring does not read well off of `it`.
    #
    # @example
    #   RSpec.describe MyClass do
    #   specify "#do_something is deprecated" do
    #   # ...
    #   end
    #   end
    # @example
    #   specify do
    #   end
    #
    #   specify "does something" do
    #   end
    #
    #   specify "does something", :slow, :uses_js do
    #   end
    #
    #   specify "does something", :with => 'additional metadata' do
    #   end
    #
    #   specify "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload specify
    # @overload specify
    # @overload specify
    # @overload specify
    # @yield [Example] the example object
    def specify(*all_args, &block); end

    # @private
    def store_before_context_ivars(example_group_instance); end

    # @private
    def subclass(parent, description, args, registration_collection, &example_group_block); end

    # :nocov:
    #
    # @private
    def superclass_before_context_ivars; end

    # @private
    # @return [Metadata] belonging to the parent of a nested {ExampleGroup}
    def superclass_metadata; end

    # @private
    # @return [Boolean]
    def top_level?; end

    # @private
    def top_level_description; end

    # Traverses the tree of groups, starting with `self`, then the children, recursively.
    # Halts the traversal of a branch of the tree as soon as the passed block returns true.
    # Note that siblings groups and their sub-trees will continue to be explored.
    # This is intended to make it easy to find the top-most group that satisfies some
    # condition.
    #
    # @private
    def traverse_tree_until(&block); end

    # @private
    def update_inherited_metadata(updates); end

    # Temporarily replace the provided metadata.
    # Intended primarily to allow an example group's singleton class
    # to return the metadata of the example that it exists for. This
    # is necessary for shared example group inclusion to work properly
    # with singleton example groups.
    #
    # @private
    def with_replaced_metadata(meta); end

    def xcontext(*args, &example_group_block); end
    def xdescribe(*args, &example_group_block); end

    # Shortcut to define an example with `:skip => 'Temporarily skipped with xexample'`.
    #
    # @example
    #   xexample do
    #   end
    #
    #   xexample "does something" do
    #   end
    #
    #   xexample "does something", :slow, :uses_js do
    #   end
    #
    #   xexample "does something", :with => 'additional metadata' do
    #   end
    #
    #   xexample "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload xexample
    # @overload xexample
    # @overload xexample
    # @overload xexample
    # @see example
    # @yield [Example] the example object
    def xexample(*all_args, &block); end

    # Shortcut to define an example with `:skip => 'Temporarily skipped with xit'`.
    #
    # @example
    #   xit do
    #   end
    #
    #   xit "does something" do
    #   end
    #
    #   xit "does something", :slow, :uses_js do
    #   end
    #
    #   xit "does something", :with => 'additional metadata' do
    #   end
    #
    #   xit "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload xit
    # @overload xit
    # @overload xit
    # @overload xit
    # @see example
    # @yield [Example] the example object
    def xit(*all_args, &block); end

    # Shortcut to define an example with `:skip => 'Temporarily skipped with xspecify'`.
    #
    # @example
    #   xspecify do
    #   end
    #
    #   xspecify "does something" do
    #   end
    #
    #   xspecify "does something", :slow, :uses_js do
    #   end
    #
    #   xspecify "does something", :with => 'additional metadata' do
    #   end
    #
    #   xspecify "does something" do |ex|
    #   # ex is the Example object that contains metadata about the example
    #   end
    # @overload xspecify
    # @overload xspecify
    # @overload xspecify
    # @overload xspecify
    # @see example
    # @yield [Example] the example object
    def xspecify(*all_args, &block); end

    private

    def method_missing(name, *args); end
  end
end

# @private
RSpec::Core::ExampleGroup::INSTANCE_VARIABLE_TO_IGNORE = T.let(T.unsafe(nil), Symbol)

# Raised when an RSpec API is called in the wrong scope, such as `before`
# being called from within an example rather than from within an example
# group block.
class RSpec::Core::ExampleGroup::WrongScopeError < ::NoMethodError; end

# Dumps a list of hashes in a pretty, human readable format
# for later parsing. The hashes are expected to have symbol
# keys and string values, and each hash should have the same
# set of keys.
#
# @private
class RSpec::Core::ExampleStatusDumper
  # @return [ExampleStatusDumper] a new instance of ExampleStatusDumper
  def initialize(examples); end

  def dump; end

  private

  def column_widths; end
  def formatted_header_rows; end
  def formatted_row_from(row_values); end
  def formatted_value_rows; end
  def headers; end
  def rows; end

  class << self
    def dump(examples); end
  end
end

# Merges together a list of example statuses from this run
# and a list from previous runs (presumably loaded from disk).
# Each example status object is expected to be a hash with
# at least an `:example_id` and a `:status` key. Examples that
# were loaded but not executed (due to filtering, `--fail-fast`
# or whatever) should have a `:status` of `UNKNOWN_STATUS`.
#
# This willl produce a new list that:
#   - Will be missing examples from previous runs that we know for sure
#     no longer exist.
#   - Will have the latest known status for any examples that either
#     definitively do exist or may still exist.
#   - Is sorted by file name and example definition order, so that
#     the saved file is easily scannable if users want to inspect it.
#
# @private
class RSpec::Core::ExampleStatusMerger
  # @return [ExampleStatusMerger] a new instance of ExampleStatusMerger
  def initialize(this_run, from_previous_runs); end

  def merge; end

  private

  def delete_previous_examples_that_no_longer_exist; end

  # @return [Boolean]
  def example_must_no_longer_exist?(ex_id); end

  def hash_from(example_list); end
  def loaded_spec_files; end
  def sort_value_from(example); end
  def spec_file_from(ex_id); end

  class << self
    def merge(this_run, from_previous_runs); end
  end
end

# Parses a string that has been previously dumped by ExampleStatusDumper.
# Note that this parser is a bit naive in that it does a simple split on
# "\n" and " | ", with no concern for handling escaping. For now, that's
# OK because the values we plan to persist (example id, status, and perhaps
# example duration) are highly unlikely to contain "\n" or " | " -- after
# all, who puts those in file names?
#
# @private
class RSpec::Core::ExampleStatusParser
  # @return [ExampleStatusParser] a new instance of ExampleStatusParser
  def initialize(string); end

  def parse; end

  private

  def headers; end
  def parse_row(line); end
  def split_line(line); end

  class << self
    def parse(string); end
  end
end

# Persists example ids and their statuses so that we can filter
# to just the ones that failed the last time they ran.
#
# @private
class RSpec::Core::ExampleStatusPersister
  # @return [ExampleStatusPersister] a new instance of ExampleStatusPersister
  def initialize(examples, file_name); end

  def persist; end

  private

  def dump_statuses(unparsed_previous_runs); end
  def statuses_from_this_run; end

  class << self
    def load_from(file_name); end
    def persist(examples, file_name); end
  end
end

# @private
RSpec::Core::ExclusionRules = RSpec::Core::FilterRules

# @private
class RSpec::Core::FilterManager
  # @return [FilterManager] a new instance of FilterManager
  def initialize; end

  def add_ids(rerun_path, scoped_ids); end

  # @api private
  # @param file_path [String]
  # @param line_numbers [Array]
  def add_location(file_path, line_numbers); end

  # @return [Boolean]
  def empty?; end

  def exclude(*args); end
  def exclude_only(*args); end
  def exclude_with_low_priority(*args); end

  # Returns the value of attribute exclusions.
  def exclusions; end

  def include(*args); end
  def include_only(*args); end
  def include_with_low_priority(*args); end

  # Returns the value of attribute inclusions.
  def inclusions; end

  def prune(examples); end

  private

  def add_path_to_arrays_filter(filter_key, path, values); end

  # When a user specifies a particular spec location, that takes priority
  # over any exclusion filters (such as if the spec is tagged with `:slow`
  # and there is a `:slow => true` exclusion filter), but only for specs
  # defined in the same file as the location filters. Excluded specs in
  # other files should still be excluded.
  #
  # @return [Boolean]
  def file_scoped_include?(ex_metadata, ids, locations); end

  def prune_conditionally_filtered_examples(examples); end
end

# @private
class RSpec::Core::FilterRules
  # @return [FilterRules] a new instance of FilterRules
  def initialize(rules = T.unsafe(nil)); end

  def [](key); end
  def add(updated); end
  def add_with_low_priority(updated); end
  def clear; end
  def delete(key); end
  def description; end
  def each_pair(&block); end

  # @return [Boolean]
  def empty?; end

  def fetch(*args, &block); end

  # @return [Boolean]
  def include_example?(example); end

  # Returns the value of attribute opposite.
  def opposite; end

  # Sets the attribute opposite
  #
  # @param value the value to set the attribute opposite to.
  def opposite=(_arg0); end

  # Returns the value of attribute rules.
  def rules; end

  def use_only(updated); end

  class << self
    def build; end
  end
end

RSpec::Core::FilterRules::PROC_HEX_NUMBER = T.let(T.unsafe(nil), Regexp)
RSpec::Core::FilterRules::PROJECT_DIR = T.let(T.unsafe(nil), String)

# Tracks a collection of filterable items (e.g. modules, hooks, etc)
# and provides an optimized API to get the applicable items for the
# metadata of an example or example group.
#
# There are two implementations, optimized for different uses.
#
# @private
module RSpec::Core::FilterableItemRepository; end

# This implementation is much more complex, and is optimized for
# rare (or hopefully no) updates once the queries start. Updates
# incur a cost as it has to clear the memoization and keep track
# of applicable keys. Queries will be O(N) the first time an item
# is provided with a given set of applicable metadata; subsequent
# queries with items with the same set of applicable metadata will
# be O(1) due to internal memoization.
#
# This is ideal for use by config, where filterable items (e.g. hooks)
# are typically added at the start of the process (e.g. in `spec_helper`)
# and then repeatedly queried as example groups and examples are defined.
#
# @private
class RSpec::Core::FilterableItemRepository::QueryOptimized < ::RSpec::Core::FilterableItemRepository::UpdateOptimized
  # @return [QueryOptimized] a new instance of QueryOptimized
  def initialize(applies_predicate); end

  def append(item, metadata); end
  def delete(item, metadata); end
  def items_for(metadata); end
  def prepend(item, metadata); end

  private

  def applicable_metadata_from(metadata); end
  def find_items_for(request_meta); end
  def handle_mutation(metadata); end
  def proc_keys_from(metadata); end
  def reconstruct_caches; end
end

# This implementation is simple, and is optimized for frequent
# updates but rare queries. `append` and `prepend` do no extra
# processing, and no internal memoization is done, since this
# is not optimized for queries.
#
# This is ideal for use by a example or example group, which may
# be updated multiple times with globally configured hooks, etc,
# but will not be queried frequently by other examples or examle
# groups.
#
# @private
class RSpec::Core::FilterableItemRepository::UpdateOptimized
  # @return [UpdateOptimized] a new instance of UpdateOptimized
  def initialize(applies_predicate); end

  def append(item, metadata); end
  def delete(item, metadata); end

  # Returns the value of attribute items_and_filters.
  def items_and_filters; end

  def items_for(request_meta); end
  def prepend(item, metadata); end
end

# @private
module RSpec::Core::FlatMap
  private

  # :nocov:
  def flat_map(array, &block); end

  class << self
    # :nocov:
    def flat_map(array, &block); end
  end
end

# ## Built-in Formatters
#
# * progress (default) - Prints dots for passing examples, `F` for failures, `*`
#                        for pending.
# * documentation - Prints the docstrings passed to `describe` and `it` methods
#                   (and their aliases).
# * html
# * json - Useful for archiving data for subsequent analysis.
#
# The progress formatter is the default, but you can choose any one or more of
# the other formatters by passing with the `--format` (or `-f` for short)
# command-line option, e.g.
#
#     rspec --format documentation
#
# You can also send the output of multiple formatters to different streams, e.g.
#
#     rspec --format documentation --format html --out results.html
#
# This example sends the output of the documentation formatter to `$stdout`, and
# the output of the html formatter to results.html.
#
# ## Custom Formatters
#
# You can tell RSpec to use a custom formatter by passing its path and name to
# the `rspec` command. For example, if you define MyCustomFormatter in
# path/to/my_custom_formatter.rb, you would type this command:
#
#     rspec --require path/to/my_custom_formatter.rb --format MyCustomFormatter
#
# The reporter calls every formatter with this protocol:
#
# * To start
#   * `start(StartNotification)`
# * Once per example group
#   * `example_group_started(GroupNotification)`
# * Once per example
#   * `example_started(ExampleNotification)`
# * One of these per example, depending on outcome
#   * `example_passed(ExampleNotification)`
#   * `example_failed(FailedExampleNotification)`
#   * `example_pending(ExampleNotification)`
# * Optionally at any time
#   * `message(MessageNotification)`
# * At the end of the suite
#   * `stop(ExamplesNotification)`
#   * `start_dump(NullNotification)`
#   * `dump_pending(ExamplesNotification)`
#   * `dump_failures(ExamplesNotification)`
#   * `dump_summary(SummaryNotification)`
#   * `seed(SeedNotification)`
#   * `close(NullNotification)`
#
# Only the notifications to which you subscribe your formatter will be called
# on your formatter. To subscribe your formatter use:
# `RSpec::Core::Formatters#register` e.g.
#
# `RSpec::Core::Formatters.register FormatterClassName, :example_passed, :example_failed`
#
# We recommend you implement the methods yourself; for simplicity we provide the
# default formatter output via our notification objects but if you prefer you
# can subclass `RSpec::Core::Formatters::BaseTextFormatter` and override the
# methods you wish to enhance.
#
# @see RSpec::Core::Formatters::BaseTextFormatter
# @see RSpec::Core::Reporter
module RSpec::Core::Formatters
  class << self
    # Register the formatter class
    #
    # @param formatter_class [Class] formatter class to register
    # @param notifications [Array<Symbol>] one or more notifications to be
    #   registered to the specified formatter
    # @see RSpec::Core::Formatters::BaseFormatter
    def register(formatter_class, *notifications); end
  end
end

# Contains common logic for formatters used by `--bisect` to communicate results
# back to the bisect runner.
#
# Subclasses must define a `notify_results(all_example_ids, failed_example_ids)`
# method.
#
# @private
class RSpec::Core::Formatters::BaseBisectFormatter
  # @return [BaseBisectFormatter] a new instance of BaseBisectFormatter
  def initialize(expected_failures); end

  def example_failed(notification); end
  def example_finished(notification); end
  def start_dump(_notification); end

  class << self
    # @private
    def inherited(formatter); end
  end
end

# RSpec's built-in formatters are all subclasses of
# RSpec::Core::Formatters::BaseFormatter.
#
# @see RSpec::Core::Formatters::BaseTextFormatter
# @see RSpec::Core::Reporter
# @see RSpec::Core::Formatters::Protocol
class RSpec::Core::Formatters::BaseFormatter
  # @api public
  # @param output [IO] the formatter output
  # @return [BaseFormatter] a new instance of BaseFormatter
  # @see RSpec::Core::Formatters::Protocol#initialize
  def initialize(output); end

  # @api public
  # @param _notification [NullNotification] (Ignored)
  # @see RSpec::Core::Formatters::Protocol#close
  def close(_notification); end

  # Returns the value of attribute example_group.
  def example_group; end

  # Sets the attribute example_group
  #
  # @param value the value to set the attribute example_group to.
  def example_group=(_arg0); end

  # @api public
  # @param notification [GroupNotification] containing example_group
  #   subclass of `RSpec::Core::ExampleGroup`
  # @see RSpec::Core::Formatters::Protocol#example_group_started
  def example_group_started(notification); end

  # Returns the value of attribute output.
  def output; end

  # @api public
  # @param notification [StartNotification]
  # @see RSpec::Core::Formatters::Protocol#start
  def start(notification); end

  private

  def output_supports_sync; end
  def restore_sync_output; end
  def start_sync_output; end
end

# Base for all of RSpec's built-in formatters. See
# RSpec::Core::Formatters::BaseFormatter to learn more about all of the
# methods called by the reporter.
#
# @see RSpec::Core::Formatters::BaseFormatter
# @see RSpec::Core::Reporter
class RSpec::Core::Formatters::BaseTextFormatter < ::RSpec::Core::Formatters::BaseFormatter
  # Invoked at the end of a suite run. Allows the formatter to do any
  # tidying up, but be aware that formatter output streams may be used
  # elsewhere so don't actually close them.
  #
  # @api public
  # @param _notification [NullNotification] (Ignored)
  def close(_notification); end

  # Dumps detailed information about each example failure.
  #
  # @api public
  # @param notification [NullNotification]
  def dump_failures(notification); end

  # @private
  def dump_pending(notification); end

  # This method is invoked after the dumping of examples and failures.
  # Each parameter is assigned to a corresponding attribute.
  #
  # @api public
  # @param summary [SummaryNotification] containing duration,
  #   example_count, failure_count and pending_count
  def dump_summary(summary); end

  # Used by the reporter to send messages to the output stream.
  #
  # @api public
  # @param notification [MessageNotification] containing message
  def message(notification); end

  # @private
  def seed(notification); end
end

# Used by `--bisect`. When it shells out and runs a portion of the suite, it uses
# this formatter as a means to have the status reported back to it, via DRb.
#
# Note that since DRb calls carry considerable overhead compared to normal
# method calls, we try to minimize the number of DRb calls for perf reasons,
# opting to communicate only at the start and the end of the run, rather than
# after each example.
#
# @private
class RSpec::Core::Formatters::BisectDRbFormatter < ::RSpec::Core::Formatters::BaseBisectFormatter
  # @return [BisectDRbFormatter] a new instance of BisectDRbFormatter
  def initialize(_output); end

  def notify_results(results); end
end

# ConsoleCodes provides helpers for formatting console output
# with ANSI codes, e.g. color's and bold.
module RSpec::Core::Formatters::ConsoleCodes
  private

  # @private
  def config_colors_to_methods; end

  # Fetches the correct code for the supplied symbol, or checks
  # that a code is valid. Defaults to white (37).
  #
  # @param code_or_symbol [Symbol, Fixnum] Symbol or code to check
  # @return [Fixnum] a console code
  def console_code_for(code_or_symbol); end

  # Wraps a piece of text in ANSI codes with the supplied code. Will
  # only apply the control code if `RSpec.configuration.color_enabled?`
  # returns true.
  #
  # @param text [String] the text to wrap
  # @param code_or_symbol [Symbol, Fixnum] the desired control code
  # @return [String] the wrapped text
  def wrap(text, code_or_symbol); end

  class << self
    # @private
    def config_colors_to_methods; end

    # Fetches the correct code for the supplied symbol, or checks
    # that a code is valid. Defaults to white (37).
    #
    # @param code_or_symbol [Symbol, Fixnum] Symbol or code to check
    # @return [Fixnum] a console code
    def console_code_for(code_or_symbol); end

    # Wraps a piece of text in ANSI codes with the supplied code. Will
    # only apply the control code if `RSpec.configuration.color_enabled?`
    # returns true.
    #
    # @param text [String] the text to wrap
    # @param code_or_symbol [Symbol, Fixnum] the desired control code
    # @return [String] the wrapped text
    def wrap(text, code_or_symbol); end
  end
end

# @private
RSpec::Core::Formatters::ConsoleCodes::VT100_CODES = T.let(T.unsafe(nil), Hash)

# @private
RSpec::Core::Formatters::ConsoleCodes::VT100_CODE_VALUES = T.let(T.unsafe(nil), Hash)

# @private
class RSpec::Core::Formatters::DeprecationFormatter
  # @return [DeprecationFormatter] a new instance of DeprecationFormatter
  def initialize(deprecation_stream, summary_stream); end

  # Returns the value of attribute count.
  def count; end

  def deprecation(notification); end
  def deprecation_message_for(data); end

  # Returns the value of attribute deprecation_stream.
  def deprecation_stream; end

  def deprecation_summary(_notification); end

  # Returns the value of attribute deprecation_stream.
  def output; end

  def printer; end

  # Returns the value of attribute summary_stream.
  def summary_stream; end
end

RSpec::Core::Formatters::DeprecationFormatter::DEPRECATION_STREAM_NOTICE = T.let(T.unsafe(nil), String)

# @private
class RSpec::Core::Formatters::DeprecationFormatter::DelayedPrinter
  # @return [DelayedPrinter] a new instance of DelayedPrinter
  def initialize(deprecation_stream, summary_stream, deprecation_formatter); end

  # Returns the value of attribute deprecation_formatter.
  def deprecation_formatter; end

  # Returns the value of attribute deprecation_stream.
  def deprecation_stream; end

  def deprecation_summary; end
  def print_deferred_deprecation_warnings; end
  def print_deprecation_message(data); end
  def stash_deprecation_message(deprecation_message); end

  # Returns the value of attribute summary_stream.
  def summary_stream; end
end

RSpec::Core::Formatters::DeprecationFormatter::DelayedPrinter::TOO_MANY_USES_LIMIT = T.let(T.unsafe(nil), Integer)

# Wraps a File object and provides file-specific operations.
#
# @private
class RSpec::Core::Formatters::DeprecationFormatter::FileStream
  # @return [FileStream] a new instance of FileStream
  def initialize(file); end

  def puts(*args); end
  def summarize(summary_stream, deprecation_count); end
end

# @private
class RSpec::Core::Formatters::DeprecationFormatter::GeneratedDeprecationMessage < ::Struct
  # @return [GeneratedDeprecationMessage] a new instance of GeneratedDeprecationMessage
  def initialize(data); end

  def to_s; end
  def too_many_warnings_message; end

  # Returns the value of attribute type
  #
  # @return [Object] the current value of type
  def type; end

  # Sets the attribute type
  #
  # @param value [Object] the value to set the attribute type to.
  # @return [Object] the newly set value
  def type=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @private
class RSpec::Core::Formatters::DeprecationFormatter::ImmediatePrinter
  # @return [ImmediatePrinter] a new instance of ImmediatePrinter
  def initialize(deprecation_stream, summary_stream, deprecation_formatter); end

  # Returns the value of attribute deprecation_formatter.
  def deprecation_formatter; end

  # Returns the value of attribute deprecation_stream.
  def deprecation_stream; end

  def deprecation_summary; end
  def print_deprecation_message(data); end

  # Returns the value of attribute summary_stream.
  def summary_stream; end
end

RSpec::Core::Formatters::DeprecationFormatter::RAISE_ERROR_CONFIG_NOTICE = T.let(T.unsafe(nil), String)

# Not really a stream, but is usable in place of one.
#
# @private
class RSpec::Core::Formatters::DeprecationFormatter::RaiseErrorStream
  # @raise [DeprecationError]
  def puts(message); end

  def summarize(summary_stream, deprecation_count); end
end

# @private
class RSpec::Core::Formatters::DeprecationFormatter::SpecifiedDeprecationMessage < ::Struct
  # @return [SpecifiedDeprecationMessage] a new instance of SpecifiedDeprecationMessage
  def initialize(data); end

  def to_s; end
  def too_many_warnings_message; end

  # Returns the value of attribute type
  #
  # @return [Object] the current value of type
  def type; end

  # Sets the attribute type
  #
  # @param value [Object] the value to set the attribute type to.
  # @return [Object] the newly set value
  def type=(_); end

  private

  def deprecation_type_for(data); end
  def output_formatted(str); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

RSpec::Core::Formatters::DeprecationFormatter::TOO_MANY_WARNINGS_NOTICE = T.let(T.unsafe(nil), String)

# @private
class RSpec::Core::Formatters::DocumentationFormatter < ::RSpec::Core::Formatters::BaseTextFormatter
  # @return [DocumentationFormatter] a new instance of DocumentationFormatter
  def initialize(output); end

  def example_failed(failure); end
  def example_group_finished(_notification); end
  def example_group_started(notification); end
  def example_passed(passed); end
  def example_pending(pending); end
  def example_started(_notification); end
  def message(notification); end

  private

  def current_indentation(offset = T.unsafe(nil)); end
  def failure_output(example); end
  def flush_messages; end
  def next_failure_index; end
  def passed_output(example); end
  def pending_output(example, message); end
end

# @private
class RSpec::Core::Formatters::ExceptionPresenter
  # @return [ExceptionPresenter] a new instance of ExceptionPresenter
  def initialize(exception, example, options = T.unsafe(nil)); end

  def colorized_formatted_backtrace(colorizer = T.unsafe(nil)); end
  def colorized_message_lines(colorizer = T.unsafe(nil)); end

  # Returns the value of attribute description.
  def description; end

  # Returns the value of attribute example.
  def example; end

  # Returns the value of attribute exception.
  def exception; end

  def formatted_backtrace(exception = T.unsafe(nil)); end

  # :nocov:
  def formatted_cause(exception); end

  def fully_formatted(failure_number, colorizer = T.unsafe(nil)); end
  def fully_formatted_lines(failure_number, colorizer); end
  def message_lines; end

  private

  def add_shared_group_lines(lines, colorizer); end

  # Returns the value of attribute backtrace_formatter.
  def backtrace_formatter; end

  # Returns the value of attribute detail_formatter.
  def detail_formatter; end

  # for 1.8.7
  def encoded_description(description); end

  def encoded_string(string); end

  # :nocov:
  def encoding_of(string); end

  def exception_backtrace; end
  def exception_class_name(exception = T.unsafe(nil)); end
  def exception_lines; end
  def exception_message_string(exception); end

  # Returns the value of attribute extra_detail_formatter.
  def extra_detail_formatter; end

  def extra_failure_lines; end
  def failure_lines; end
  def failure_slash_error_lines; end
  def final_exception(exception, previous = T.unsafe(nil)); end
  def find_failed_line; end
  def formatted_message_and_backtrace(colorizer); end
  def indent_lines(lines, failure_number); end

  # Returns the value of attribute message_color.
  def message_color; end

  def read_failed_lines; end
end

# Configuring the `ExceptionPresenter` with the right set of options to handle
# pending vs failed vs skipped and aggregated (or not) failures is not simple.
# This class takes care of building an appropriate `ExceptionPresenter` for the
# provided example.
#
# @private
class RSpec::Core::Formatters::ExceptionPresenter::Factory
  # @return [Factory] a new instance of Factory
  def initialize(example); end

  def build; end

  private

  def multiple_exception_summarizer(exception, prior_detail_formatter, color); end

  # @return [Boolean]
  def multiple_exceptions_error?(exception); end

  def options; end
  def pending_options; end
  def sub_failure_list_formatter(exception, message_color); end
  def with_multiple_error_options_as_needed(exception, options); end
end

# @private
class RSpec::Core::Formatters::ExceptionPresenter::Factory::CommonBacktraceTruncater
  # @return [CommonBacktraceTruncater] a new instance of CommonBacktraceTruncater
  def initialize(parent); end

  def with_truncated_backtrace(child); end
end

# Used to prevent a confusing backtrace from showing up from the `aggregate_failures`
# block declared for `:aggregate_failures` metadata.
#
# @private
module RSpec::Core::Formatters::ExceptionPresenter::Factory::EmptyBacktraceFormatter
  class << self
    def format_backtrace(*_arg0); end
  end
end

# @private
RSpec::Core::Formatters::ExceptionPresenter::PENDING_DETAIL_FORMATTER = T.let(T.unsafe(nil), Proc)

# @private
class RSpec::Core::Formatters::FailureListFormatter < ::RSpec::Core::Formatters::BaseFormatter
  # Discard profile and messages
  #
  # These outputs are not really relevant in the context of this failure
  # list formatter.
  def dump_profile(_profile); end

  def example_failed(failure); end
  def message(_message); end
end

# Formatter for providing message output as a fallback when no other
# profiler implements #message
#
# @api private
class RSpec::Core::Formatters::FallbackMessageFormatter
  # @api private
  # @return [FallbackMessageFormatter] a new instance of FallbackMessageFormatter
  def initialize(output); end

  # Used by the reporter to send messages to the output stream.
  #
  # @api public
  # @param notification [MessageNotification] containing message
  def message(notification); end

  # @api private
  # @private
  def output; end
end

# Formatters helpers.
module RSpec::Core::Formatters::Helpers
  class << self
    # Formats seconds into a human-readable string.
    #
    # @api private
    # @example
    #   format_duration(1) #=>  "1 minute 1 second"
    #   format_duration(135.14) #=> "2 minutes 15.14 seconds"
    # @param duration [Float, Fixnum] in seconds
    # @return [String] human-readable time
    def format_duration(duration); end

    # Formats seconds to have 5 digits of precision with trailing zeros
    # removed if the number is less than 1 or with 2 digits of precision if
    # the number is greater than zero.
    #
    # The precision used is set in {Helpers::SUB_SECOND_PRECISION} and
    # {Helpers::DEFAULT_PRECISION}.
    #
    # @api private
    # @example
    #   format_seconds(0.000006) #=> "0.00001"
    #   format_seconds(0.020000) #=> "0.02"
    #   format_seconds(1.00000000001) #=> "1"
    # @param float [Float]
    # @return [String] formatted float
    # @see #strip_trailing_zeroes
    def format_seconds(float, precision = T.unsafe(nil)); end

    # Given a list of example ids, organizes them into a compact, ordered list.
    #
    # @api private
    def organize_ids(ids); end

    # Pluralize a word based on a count.
    #
    # @api private
    # @param count [Fixnum] number of objects
    # @param string [String] word to be pluralized
    # @return [String] pluralized word
    def pluralize(count, string); end

    private

    # Remove trailing zeros from a string.
    #
    # Only remove trailing zeros after a decimal place.
    # see: http://rubular.com/r/ojtTydOgpn
    #
    # @api private
    # @param string [String] string with trailing zeros
    # @return [String] string with trailing zeros removed
    def strip_trailing_zeroes(string); end
  end
end

# @private
RSpec::Core::Formatters::Helpers::DEFAULT_PRECISION = T.let(T.unsafe(nil), Integer)

# @private
RSpec::Core::Formatters::Helpers::SUB_SECOND_PRECISION = T.let(T.unsafe(nil), Integer)

# @private
class RSpec::Core::Formatters::HtmlFormatter < ::RSpec::Core::Formatters::BaseFormatter
  # @return [HtmlFormatter] a new instance of HtmlFormatter
  def initialize(output); end

  def dump_summary(summary); end
  def example_failed(failure); end
  def example_group_started(notification); end
  def example_passed(passed); end
  def example_pending(pending); end
  def example_started(_notification); end
  def start(notification); end
  def start_dump(_notification); end

  private

  # The number of the currently running example_group.
  def example_group_number; end

  # The number of the currently running example (a global counter).
  def example_number; end

  # Override this method if you wish to output extra HTML for a failed
  # spec. For example, you could output links to images or other files
  # produced during the specs.
  def extra_failure_content(failure); end

  def percent_done; end
end

# @private
class RSpec::Core::Formatters::HtmlPrinter
  include ::ERB::Util

  # @return [HtmlPrinter] a new instance of HtmlPrinter
  def initialize(output); end

  def flush; end
  def make_example_group_header_red(group_id); end
  def make_example_group_header_yellow(group_id); end
  def make_header_red; end
  def make_header_yellow; end
  def move_progress(percent_done); end
  def print_example_failed(pending_fixed, description, run_time, failure_id, exception, extra_content); end
  def print_example_group_end; end
  def print_example_group_start(group_id, description, number_of_parents); end
  def print_example_passed(description, run_time); end
  def print_example_pending(description, pending_message); end
  def print_html_start; end
  def print_summary(duration, example_count, failure_count, pending_count); end

  private

  def indentation_style(number_of_parents); end
end

RSpec::Core::Formatters::HtmlPrinter::GLOBAL_SCRIPTS = T.let(T.unsafe(nil), String)
RSpec::Core::Formatters::HtmlPrinter::GLOBAL_STYLES = T.let(T.unsafe(nil), String)
RSpec::Core::Formatters::HtmlPrinter::HTML_HEADER = T.let(T.unsafe(nil), String)
RSpec::Core::Formatters::HtmlPrinter::REPORT_HEADER = T.let(T.unsafe(nil), String)

# @private
class RSpec::Core::Formatters::JsonFormatter < ::RSpec::Core::Formatters::BaseFormatter
  # @return [JsonFormatter] a new instance of JsonFormatter
  def initialize(output); end

  def close(_notification); end
  def dump_profile(profile); end

  # @api private
  def dump_profile_slowest_example_groups(profile); end

  # @api private
  def dump_profile_slowest_examples(profile); end

  def dump_summary(summary); end
  def message(notification); end

  # Returns the value of attribute output_hash.
  def output_hash; end

  def seed(notification); end
  def stop(notification); end

  private

  def format_example(example); end
end

# `RSpec::Core::Formatters::Loader` is an internal class for
# managing formatters used by a particular configuration. It is
# not expected to be used directly, but only through the configuration
# interface.
#
# @api private
class RSpec::Core::Formatters::Loader
  # @api private
  # @return [Loader] a new instance of Loader
  def initialize(reporter); end

  # @api private
  # @private
  def add(formatter_to_use, *paths); end

  # @api private
  # @return [String] the default formatter to setup, defaults to `progress`
  def default_formatter; end

  # @api private
  # @return [String] the default formatter to setup, defaults to `progress`
  def default_formatter=(_arg0); end

  # @api private
  # @return [Array] the loaded formatters
  def formatters; end

  # @api private
  # @private
  def prepare_default(output_stream, deprecation_stream); end

  # @api private
  # @return [Reporter] the reporter
  def reporter; end

  # @api private
  # @private
  def setup_default(output_stream, deprecation_stream); end

  private

  # @api private
  def built_in_formatter(key); end

  # @api private
  def custom_formatter(formatter_ref); end

  # @api private
  # @return [Boolean]
  def duplicate_formatter_exists?(new_formatter); end

  # @api private
  # @return [Boolean]
  def existing_formatter_implements?(notification); end

  # @api private
  def find_formatter(formatter_to_use); end

  # @api private
  # @return [Boolean]
  def has_matching_output?(formatter, new_formatter); end

  # @api private
  def notifications_for(formatter_class); end

  # @api private
  def open_stream(path_or_wrapper); end

  # @api private
  def path_for(const_ref); end

  # @api private
  def register(formatter, notifications); end

  # @api private
  # @return [Boolean]
  def string_const?(str); end

  # activesupport/lib/active_support/inflector/methods.rb, line 48
  #
  # @api private
  def underscore(camel_cased_word); end

  # @api private
  def underscore_with_fix_for_non_standard_rspec_naming(string); end

  class << self
    # Internal formatters are stored here when loaded.
    #
    # @api private
    def formatters; end
  end
end

# Formatter for providing profile output.
#
# @api private
class RSpec::Core::Formatters::ProfileFormatter
  # @api private
  # @return [ProfileFormatter] a new instance of ProfileFormatter
  def initialize(output); end

  # This method is invoked after the dumping the summary if profiling is
  # enabled.
  #
  # @api public
  # @param profile [ProfileNotification] containing duration,
  #   slowest_examples and slowest_example_groups
  def dump_profile(profile); end

  # @api private
  # @private
  def output; end

  private

  # @api private
  def bold(text); end

  # @api private
  def dump_profile_slowest_example_groups(profile); end

  # @api private
  def dump_profile_slowest_examples(profile); end

  # @api private
  def format_caller(caller_info); end
end

# @private
class RSpec::Core::Formatters::ProgressFormatter < ::RSpec::Core::Formatters::BaseTextFormatter
  def example_failed(_notification); end
  def example_passed(_notification); end
  def example_pending(_notification); end
  def start_dump(_notification); end
end

# @private
class RSpec::Core::Formatters::SnippetExtractor
  # @return [SnippetExtractor] a new instance of SnippetExtractor
  def initialize(source, beginning_line_number, max_line_count = T.unsafe(nil)); end

  # Returns the value of attribute beginning_line_number.
  def beginning_line_number; end

  def expression_lines; end

  # Returns the value of attribute max_line_count.
  def max_line_count; end

  # Returns the value of attribute source.
  def source; end

  private

  # @raise [NoExpressionAtLineError]
  def expression_node; end

  # @return [Boolean]
  def expression_outmost_node?(node); end

  def line_range_of_expression; end
  def line_range_of_location_nodes_in_expression; end
  def location_nodes_at_beginning_line; end
  def unclosed_tokens_in_line_range(line_range); end

  class << self
    # :nocov:
    def extract_expression_lines_at(file_path, beginning_line_number, max_line_count = T.unsafe(nil)); end

    # @raise [NoSuchLineError]
    def extract_line_at(file_path, line_number); end

    def least_indentation_from(lines); end

    # @raise [NoSuchFileError]
    def source_from_file(path); end
  end
end

class RSpec::Core::Formatters::SnippetExtractor::NoExpressionAtLineError < ::StandardError; end
class RSpec::Core::Formatters::SnippetExtractor::NoSuchFileError < ::StandardError; end
class RSpec::Core::Formatters::SnippetExtractor::NoSuchLineError < ::StandardError; end

# Provides terminal syntax highlighting of code snippets
# when coderay is available.
#
# @private
class RSpec::Core::Formatters::SyntaxHighlighter
  # @return [SyntaxHighlighter] a new instance of SyntaxHighlighter
  def initialize(configuration); end

  def highlight(lines); end

  private

  def color_enabled_implementation; end

  # :nocov:
  def implementation; end

  class << self
    def attempt_to_add_rspec_terms_to_coderay_keywords; end
  end
end

# @private
module RSpec::Core::Formatters::SyntaxHighlighter::CodeRayImplementation
  class << self
    def highlight_syntax(lines); end
  end
end

RSpec::Core::Formatters::SyntaxHighlighter::CodeRayImplementation::RESET_CODE = T.let(T.unsafe(nil), String)

# @private
module RSpec::Core::Formatters::SyntaxHighlighter::NoSyntaxHighlightingImplementation
  class << self
    def highlight_syntax(lines); end
  end
end

# Not sure why, but our code above (and/or coderay itself) does not work
# on Windows, so we disable the feature on Windows.
#
# @private
RSpec::Core::Formatters::SyntaxHighlighter::WindowsImplementation = RSpec::Core::Formatters::SyntaxHighlighter::NoSyntaxHighlightingImplementation

# Mixin that makes the including class imitate a hash for backwards
# compatibility. The including class should use `attr_accessor` to
# declare attributes.
#
# @private
module RSpec::Core::HashImitatable
  mixes_in_class_methods ::RSpec::Core::HashImitatable::ClassMethods

  def <(*args, &block); end
  def <=(*args, &block); end
  def >(*args, &block); end
  def >=(*args, &block); end
  def [](key); end
  def []=(key, value); end
  def all?(*args, &block); end
  def any?(*args, &block); end
  def assoc(*args, &block); end
  def chain(*args, &block); end
  def chunk(*args, &block); end
  def chunk_while(*args, &block); end
  def clear(*args, &block); end
  def collect(*args, &block); end
  def collect_concat(*args, &block); end
  def compact(*args, &block); end
  def compact!(*args, &block); end
  def compare_by_identity(*args, &block); end
  def compare_by_identity?(*args, &block); end
  def count(*args, &block); end
  def cycle(*args, &block); end
  def deconstruct_keys(*args, &block); end
  def default(*args, &block); end
  def default=(*args, &block); end
  def default_proc(*args, &block); end
  def default_proc=(*args, &block); end
  def delete(*args, &block); end
  def delete_if(*args, &block); end
  def detect(*args, &block); end
  def dig(*args, &block); end
  def drop(*args, &block); end
  def drop_while(*args, &block); end
  def each(*args, &block); end
  def each_cons(*args, &block); end
  def each_entry(*args, &block); end
  def each_key(*args, &block); end
  def each_pair(*args, &block); end
  def each_slice(*args, &block); end
  def each_value(*args, &block); end
  def each_with_index(*args, &block); end
  def each_with_object(*args, &block); end
  def empty?(*args, &block); end
  def entries(*args, &block); end
  def except(*args, &block); end
  def fetch(*args, &block); end
  def fetch_values(*args, &block); end
  def filter(*args, &block); end
  def filter!(*args, &block); end
  def filter_map(*args, &block); end
  def find(*args, &block); end
  def find_all(*args, &block); end
  def find_index(*args, &block); end
  def first(*args, &block); end
  def flat_map(*args, &block); end
  def flatten(*args, &block); end
  def grep(*args, &block); end
  def grep_v(*args, &block); end
  def group_by(*args, &block); end
  def has_key?(*args, &block); end
  def has_value?(*args, &block); end
  def include?(*args, &block); end
  def inject(*args, &block); end
  def invert(*args, &block); end
  def keep_if(*args, &block); end
  def key(*args, &block); end
  def key?(*args, &block); end
  def keys(*args, &block); end
  def lazy(*args, &block); end
  def length(*args, &block); end
  def map(*args, &block); end
  def max(*args, &block); end
  def max_by(*args, &block); end
  def member?(*args, &block); end
  def merge(*args, &block); end
  def merge!(*args, &block); end
  def min(*args, &block); end
  def min_by(*args, &block); end
  def minmax(*args, &block); end
  def minmax_by(*args, &block); end
  def none?(*args, &block); end
  def one?(*args, &block); end
  def partition(*args, &block); end
  def rassoc(*args, &block); end
  def reduce(*args, &block); end
  def rehash(*args, &block); end
  def reject(*args, &block); end
  def reject!(*args, &block); end
  def replace(*args, &block); end
  def reverse_each(*args, &block); end
  def save_plist(*args, &block); end
  def select(*args, &block); end
  def select!(*args, &block); end
  def shift(*args, &block); end
  def size(*args, &block); end
  def slice(*args, &block); end
  def slice_after(*args, &block); end
  def slice_before(*args, &block); end
  def slice_when(*args, &block); end
  def sort(*args, &block); end
  def sort_by(*args, &block); end
  def store(*args, &block); end
  def sum(*args, &block); end
  def take(*args, &block); end
  def take_while(*args, &block); end
  def tally(*args, &block); end
  def to_a(*args, &block); end
  def to_h; end
  def to_hash(*args, &block); end
  def to_liquid(*args, &block); end
  def to_plist(*args, &block); end
  def to_proc(*args, &block); end
  def to_set(*args, &block); end
  def transform_keys(*args, &block); end
  def transform_keys!(*args, &block); end
  def transform_values(*args, &block); end
  def transform_values!(*args, &block); end
  def uniq(*args, &block); end
  def update(*args, &block); end
  def value?(*args, &block); end
  def values(*args, &block); end
  def values_at(*args, &block); end
  def zip(*args, &block); end

  private

  # @return [Boolean]
  def directly_supports_attribute?(name); end

  def extra_hash_attributes; end
  def get_value(name); end
  def hash_for_delegation; end
  def issue_deprecation(_method_name, *_args); end
  def set_value(name, value); end

  class << self
    # @private
    def included(klass); end
  end
end

# @private
module RSpec::Core::HashImitatable::ClassMethods
  def attr_accessor(*names); end
  def hash_attribute_names; end
end

# Provides `before`, `after` and `around` hooks as a means of
# supporting common setup and teardown. This module is extended
# onto {ExampleGroup}, making the methods available from any `describe`
# or `context` block and included in {Configuration}, making them
# available off of the configuration object to define global setup
# or teardown logic.
module RSpec::Core::Hooks
  # Declare a block of code to be run after each example (using `:example`)
  # or once after all examples n the context (using `:context`). See
  # {#before} for more information about ordering.
  #
  # ### Exceptions
  #
  # `after` hooks are guaranteed to run even when there are exceptions in
  # `before` hooks or examples. When an exception is raised in an after
  # block, the exception is captured for later reporting, and subsequent
  # `after` blocks are run.
  #
  # ### Order
  #
  # `after` hooks are stored in three scopes, which are run in order:
  # `:example`, `:context`, and `:suite`. They can also be declared in
  # several different places: `RSpec.configure`, a parent group, the current
  # group. They are run in the following order:
  #
  #     after(:example) # Declared in the current group.
  #     after(:example) # Declared in a parent group.
  #     after(:example) # Declared in RSpec.configure.
  #     after(:context) # Declared in the current group.
  #     after(:context) # Declared in a parent group.
  #     after(:context) # Declared in RSpec.configure.
  #     after(:suite)   # Declared in RSpec.configure.
  #
  # This is the reverse of the order in which `before` hooks are run.
  # Similarly, if more than one `after` is declared within any example
  # group, they are run in reverse order of that in which they are declared.
  # Also `around` hooks will run after any `after` example hooks are
  # invoked but before any `after` context hooks.
  #
  # @api public
  # @note The `:suite` scope is only supported for hooks registered on
  #   `RSpec.configuration` since they exist independently of any
  #   example or example group.
  # @note The `:example` and `:context` scopes are also available as
  #   `:each` and `:all`, respectively. Use whichever you prefer.
  # @overload after
  # @overload after
  # @overload after
  # @overload after
  # @see #before
  # @see #around
  # @see ExampleGroup
  # @see SharedContext
  # @see SharedExampleGroup
  # @see Configuration
  def after(*args, &block); end

  # Adds `block` to the back of the list of `after` blocks in the same
  # scope (`:example`, `:context`, or `:suite`).
  #
  # See {#after} for scoping semantics.
  def append_after(*args, &block); end

  # Declare a block of code to be run before each example (using `:example`)
  # or once before any example (using `:context`). These are usually
  # declared directly in the {ExampleGroup} to which they apply, but they
  # can also be shared across multiple groups.
  #
  # You can also use `before(:suite)` to run a block of code before any
  # example groups are run. This should be declared in {RSpec.configure}.
  #
  # Instance variables declared in `before(:example)` or `before(:context)`
  # are accessible within each example.
  #
  # ### Order
  #
  # `before` hooks are stored in three scopes, which are run in order:
  # `:suite`, `:context`, and `:example`. They can also be declared in
  # several different places: `RSpec.configure`, a parent group, the current
  # group. They are run in the following order:
  #
  #     before(:suite)    # Declared in RSpec.configure.
  #     before(:context)  # Declared in RSpec.configure.
  #     before(:context)  # Declared in a parent group.
  #     before(:context)  # Declared in the current group.
  #     before(:example)  # Declared in RSpec.configure.
  #     before(:example)  # Declared in a parent group.
  #     before(:example)  # Declared in the current group.
  #
  # If more than one `before` is declared within any one example group, they
  # are run in the order in which they are declared. Any `around` hooks will
  # execute after `before` context hooks but before any `before` example
  # hook regardless of where they are declared.
  #
  # ### Conditions
  #
  # When you add a conditions hash to `before(:example)` or
  # `before(:context)`, RSpec will only apply that hook to groups or
  # examples that match the conditions. e.g.
  #
  #     RSpec.configure do |config|
  #       config.before(:example, :authorized => true) do
  #         log_in_as :authorized_user
  #       end
  #     end
  #
  #     RSpec.describe Something, :authorized => true do
  #       # The before hook will run in before each example in this group.
  #     end
  #
  #     RSpec.describe SomethingElse do
  #       it "does something", :authorized => true do
  #         # The before hook will run before this example.
  #       end
  #
  #       it "does something else" do
  #         # The hook will not run before this example.
  #       end
  #     end
  #
  # Note that filtered config `:context` hooks can still be applied
  # to individual examples that have matching metadata. Just like
  # Ruby's object model is that every object has a singleton class
  # which has only a single instance, RSpec's model is that every
  # example has a singleton example group containing just the one
  # example.
  #
  # ### Warning: `before(:suite, :with => :conditions)`
  #
  # The conditions hash is used to match against specific examples. Since
  # `before(:suite)` is not run in relation to any specific example or
  # group, conditions passed along with `:suite` are effectively ignored.
  #
  # ### Exceptions
  #
  # When an exception is raised in a `before` block, RSpec skips any
  # subsequent `before` blocks and the example, but runs all of the
  # `after(:example)` and `after(:context)` hooks.
  #
  # ### Warning: implicit before blocks
  #
  # `before` hooks can also be declared in shared contexts which get
  # included implicitly either by you or by extension libraries. Since
  # RSpec runs these in the order in which they are declared within each
  # scope, load order matters, and can lead to confusing results when one
  # before block depends on state that is prepared in another before block
  # that gets run later.
  #
  # ### Warning: `before(:context)`
  #
  # It is very tempting to use `before(:context)` to speed things up, but we
  # recommend that you avoid this as there are a number of gotchas, as well
  # as things that simply don't work.
  #
  # #### Context
  #
  # `before(:context)` is run in an example that is generated to provide
  # group context for the block.
  #
  # #### Instance variables
  #
  # Instance variables declared in `before(:context)` are shared across all
  # the examples in the group. This means that each example can change the
  # state of a shared object, resulting in an ordering dependency that can
  # make it difficult to reason about failures.
  #
  # #### Unsupported RSpec constructs
  #
  # RSpec has several constructs that reset state between each example
  # automatically. These are not intended for use from within
  # `before(:context)`:
  #
  #   * `let` declarations
  #   * `subject` declarations
  #   * Any mocking, stubbing or test double declaration
  #
  # ### other frameworks
  #
  # Mock object frameworks and database transaction managers (like
  # ActiveRecord) are typically designed around the idea of setting up
  # before an example, running that one example, and then tearing down. This
  # means that mocks and stubs can (sometimes) be declared in
  # `before(:context)`, but get torn down before the first real example is
  # ever run.
  #
  # You _can_ create database-backed model objects in a `before(:context)`
  # in rspec-rails, but it will not be wrapped in a transaction for you, so
  # you are on your own to clean up in an `after(:context)` block.
  #
  # @api public
  # @example before(:example) declared in an {ExampleGroup}
  #   RSpec.describe Thing do
  #   before(:example) do
  #   @thing = Thing.new
  #   end
  #
  #   it "does something" do
  #   # Here you can access @thing.
  #   end
  #   end
  # @example before(:context) declared in an {ExampleGroup}
  #   RSpec.describe Parser do
  #   before(:context) do
  #   File.open(file_to_parse, 'w') do |f|
  #   f.write <<-CONTENT
  #   stuff in the file
  #   CONTENT
  #   end
  #   end
  #
  #   it "parses the file" do
  #   Parser.parse(file_to_parse)
  #   end
  #
  #   after(:context) do
  #   File.delete(file_to_parse)
  #   end
  #   end
  # @note The `:example` and `:context` scopes are also available as
  #   `:each` and `:all`, respectively. Use whichever you prefer.
  # @note The `:suite` scope is only supported for hooks registered on
  #   `RSpec.configuration` since they exist independently of any
  #   example or example group.
  # @overload before
  # @overload before
  # @overload before
  # @overload before
  # @see #after
  # @see #around
  # @see ExampleGroup
  # @see SharedContext
  # @see SharedExampleGroup
  # @see Configuration
  def append_before(*args, &block); end

  # Declare a block of code, parts of which will be run before and parts
  # after the example. It is your responsibility to run the example:
  #
  #     around(:example) do |ex|
  #       # Do some stuff before.
  #       ex.run
  #       # Do some stuff after.
  #     end
  #
  # The yielded example aliases `run` with `call`, which lets you treat it
  # like a `Proc`. This is especially handy when working with libraries
  # that manage their own setup and teardown using a block or proc syntax,
  # e.g.
  #
  #     around(:example) {|ex| Database.transaction(&ex)}
  #     around(:example) {|ex| FakeFS(&ex)}
  #
  # ### Order
  #
  # The `around` hooks execute surrounding an example and its hooks.
  #
  # This means after any `before` context hooks, but before any `before`
  # example hooks, and similarly after any `after` example hooks but before
  # any `after` context hooks.
  #
  # They are not a synonym for `before`/`after`.
  #
  # @api public
  # @note `:example`/`:each` is the only supported scope.
  # @note the syntax of `around` is similar to that of `before` and `after`
  #   but the semantics are quite different. `before` and `after` hooks are
  #   run in the context of the examples with which they are associated,
  #   whereas `around` hooks are actually responsible for running the
  #   examples. Consequently, `around` hooks do not have direct access to
  #   resources that are made available within the examples and their
  #   associated `before` and `after` hooks.
  # @overload around
  # @overload around
  # @overload around
  # @overload around
  # @yield [Example] the example to run
  def around(*args, &block); end

  # Declare a block of code to be run before each example (using `:example`)
  # or once before any example (using `:context`). These are usually
  # declared directly in the {ExampleGroup} to which they apply, but they
  # can also be shared across multiple groups.
  #
  # You can also use `before(:suite)` to run a block of code before any
  # example groups are run. This should be declared in {RSpec.configure}.
  #
  # Instance variables declared in `before(:example)` or `before(:context)`
  # are accessible within each example.
  #
  # ### Order
  #
  # `before` hooks are stored in three scopes, which are run in order:
  # `:suite`, `:context`, and `:example`. They can also be declared in
  # several different places: `RSpec.configure`, a parent group, the current
  # group. They are run in the following order:
  #
  #     before(:suite)    # Declared in RSpec.configure.
  #     before(:context)  # Declared in RSpec.configure.
  #     before(:context)  # Declared in a parent group.
  #     before(:context)  # Declared in the current group.
  #     before(:example)  # Declared in RSpec.configure.
  #     before(:example)  # Declared in a parent group.
  #     before(:example)  # Declared in the current group.
  #
  # If more than one `before` is declared within any one example group, they
  # are run in the order in which they are declared. Any `around` hooks will
  # execute after `before` context hooks but before any `before` example
  # hook regardless of where they are declared.
  #
  # ### Conditions
  #
  # When you add a conditions hash to `before(:example)` or
  # `before(:context)`, RSpec will only apply that hook to groups or
  # examples that match the conditions. e.g.
  #
  #     RSpec.configure do |config|
  #       config.before(:example, :authorized => true) do
  #         log_in_as :authorized_user
  #       end
  #     end
  #
  #     RSpec.describe Something, :authorized => true do
  #       # The before hook will run in before each example in this group.
  #     end
  #
  #     RSpec.describe SomethingElse do
  #       it "does something", :authorized => true do
  #         # The before hook will run before this example.
  #       end
  #
  #       it "does something else" do
  #         # The hook will not run before this example.
  #       end
  #     end
  #
  # Note that filtered config `:context` hooks can still be applied
  # to individual examples that have matching metadata. Just like
  # Ruby's object model is that every object has a singleton class
  # which has only a single instance, RSpec's model is that every
  # example has a singleton example group containing just the one
  # example.
  #
  # ### Warning: `before(:suite, :with => :conditions)`
  #
  # The conditions hash is used to match against specific examples. Since
  # `before(:suite)` is not run in relation to any specific example or
  # group, conditions passed along with `:suite` are effectively ignored.
  #
  # ### Exceptions
  #
  # When an exception is raised in a `before` block, RSpec skips any
  # subsequent `before` blocks and the example, but runs all of the
  # `after(:example)` and `after(:context)` hooks.
  #
  # ### Warning: implicit before blocks
  #
  # `before` hooks can also be declared in shared contexts which get
  # included implicitly either by you or by extension libraries. Since
  # RSpec runs these in the order in which they are declared within each
  # scope, load order matters, and can lead to confusing results when one
  # before block depends on state that is prepared in another before block
  # that gets run later.
  #
  # ### Warning: `before(:context)`
  #
  # It is very tempting to use `before(:context)` to speed things up, but we
  # recommend that you avoid this as there are a number of gotchas, as well
  # as things that simply don't work.
  #
  # #### Context
  #
  # `before(:context)` is run in an example that is generated to provide
  # group context for the block.
  #
  # #### Instance variables
  #
  # Instance variables declared in `before(:context)` are shared across all
  # the examples in the group. This means that each example can change the
  # state of a shared object, resulting in an ordering dependency that can
  # make it difficult to reason about failures.
  #
  # #### Unsupported RSpec constructs
  #
  # RSpec has several constructs that reset state between each example
  # automatically. These are not intended for use from within
  # `before(:context)`:
  #
  #   * `let` declarations
  #   * `subject` declarations
  #   * Any mocking, stubbing or test double declaration
  #
  # ### other frameworks
  #
  # Mock object frameworks and database transaction managers (like
  # ActiveRecord) are typically designed around the idea of setting up
  # before an example, running that one example, and then tearing down. This
  # means that mocks and stubs can (sometimes) be declared in
  # `before(:context)`, but get torn down before the first real example is
  # ever run.
  #
  # You _can_ create database-backed model objects in a `before(:context)`
  # in rspec-rails, but it will not be wrapped in a transaction for you, so
  # you are on your own to clean up in an `after(:context)` block.
  #
  # @api public
  # @example before(:example) declared in an {ExampleGroup}
  #
  #   RSpec.describe Thing do
  #   before(:example) do
  #   @thing = Thing.new
  #   end
  #
  #   it "does something" do
  #   # Here you can access @thing.
  #   end
  #   end
  # @example before(:context) declared in an {ExampleGroup}
  #
  #   RSpec.describe Parser do
  #   before(:context) do
  #   File.open(file_to_parse, 'w') do |f|
  #   f.write <<-CONTENT
  #   stuff in the file
  #   CONTENT
  #   end
  #   end
  #
  #   it "parses the file" do
  #   Parser.parse(file_to_parse)
  #   end
  #
  #   after(:context) do
  #   File.delete(file_to_parse)
  #   end
  #   end
  # @note The `:example` and `:context` scopes are also available as
  #   `:each` and `:all`, respectively. Use whichever you prefer.
  # @note The `:suite` scope is only supported for hooks registered on
  #   `RSpec.configuration` since they exist independently of any
  #   example or example group.
  # @overload before
  # @overload before
  # @overload before
  # @overload before
  # @see #after
  # @see #around
  # @see ExampleGroup
  # @see SharedContext
  # @see SharedExampleGroup
  # @see Configuration
  def before(*args, &block); end

  # Holds the various registered hooks.
  #
  # @private
  def hooks; end

  # Declare a block of code to be run after each example (using `:example`)
  # or once after all examples n the context (using `:context`). See
  # {#before} for more information about ordering.
  #
  # ### Exceptions
  #
  # `after` hooks are guaranteed to run even when there are exceptions in
  # `before` hooks or examples. When an exception is raised in an after
  # block, the exception is captured for later reporting, and subsequent
  # `after` blocks are run.
  #
  # ### Order
  #
  # `after` hooks are stored in three scopes, which are run in order:
  # `:example`, `:context`, and `:suite`. They can also be declared in
  # several different places: `RSpec.configure`, a parent group, the current
  # group. They are run in the following order:
  #
  #     after(:example) # Declared in the current group.
  #     after(:example) # Declared in a parent group.
  #     after(:example) # Declared in RSpec.configure.
  #     after(:context) # Declared in the current group.
  #     after(:context) # Declared in a parent group.
  #     after(:context) # Declared in RSpec.configure.
  #     after(:suite)   # Declared in RSpec.configure.
  #
  # This is the reverse of the order in which `before` hooks are run.
  # Similarly, if more than one `after` is declared within any example
  # group, they are run in reverse order of that in which they are declared.
  # Also `around` hooks will run after any `after` example hooks are
  # invoked but before any `after` context hooks.
  #
  # @api public
  # @note The `:suite` scope is only supported for hooks registered on
  #   `RSpec.configuration` since they exist independently of any
  #   example or example group.
  # @note The `:example` and `:context` scopes are also available as
  #   `:each` and `:all`, respectively. Use whichever you prefer.
  # @overload after
  # @overload after
  # @overload after
  # @overload after
  # @see #before
  # @see #around
  # @see ExampleGroup
  # @see SharedContext
  # @see SharedExampleGroup
  # @see Configuration
  def prepend_after(*args, &block); end

  # Adds `block` to the front of the list of `before` blocks in the same
  # scope (`:example`, `:context`, or `:suite`).
  #
  # See {#before} for scoping semantics.
  def prepend_before(*args, &block); end
end

# @private
class RSpec::Core::Hooks::AfterContextHook < ::RSpec::Core::Hooks::Hook
  def run(example); end
end

# @private
class RSpec::Core::Hooks::AfterHook < ::RSpec::Core::Hooks::Hook
  def run(example); end
end

# @private
class RSpec::Core::Hooks::AroundHook < ::RSpec::Core::Hooks::Hook
  def execute_with(example, procsy); end

  # :nocov:
  def hook_description; end
end

# @private
class RSpec::Core::Hooks::BeforeHook < ::RSpec::Core::Hooks::Hook
  def run(example); end
end

# @private
class RSpec::Core::Hooks::Hook < ::Struct
  # Returns the value of attribute block
  #
  # @return [Object] the current value of block
  def block; end

  # Sets the attribute block
  #
  # @param value [Object] the value to set the attribute block to.
  # @return [Object] the newly set value
  def block=(_); end

  # Returns the value of attribute options
  #
  # @return [Object] the current value of options
  def options; end

  # Sets the attribute options
  #
  # @param value [Object] the value to set the attribute options to.
  # @return [Object] the newly set value
  def options=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# This provides the primary API used by other parts of rspec-core. By hiding all
# implementation details behind this facade, it's allowed us to heavily optimize
# this, so that, for example, hook collection objects are only instantiated when
# a hook is added. This allows us to avoid many object allocations for the common
# case of a group having no hooks.
#
# This is only possible because this interface provides a "tell, don't ask"-style
# API, so that callers _tell_ this class what to do with the hooks, rather than
# asking this class for a list of hooks, and then doing something with them.
#
# @private
class RSpec::Core::Hooks::HookCollections
  # @return [HookCollections] a new instance of HookCollections
  def initialize(owner, filterable_item_repo_class); end

  def register(prepend_or_append, position, *args, &block); end
  def register_global_singleton_context_hooks(example, globals); end
  def register_globals(host, globals); end

  # Runs all of the blocks stored with the hook in the context of the
  # example. If no example is provided, just calls the hook directly.
  #
  # @private
  def run(position, scope, example_or_group); end

  protected

  def all_hooks_for(position, scope); end
  def matching_hooks_for(position, scope, example_or_group); end
  def processable_hooks_for(position, scope, host); end
  def run_owned_hooks_for(position, scope, example_or_group); end

  private

  def ensure_hooks_initialized_for(position, scope); end
  def extract_scope_from(args); end
  def hooks_for(position, scope); end

  # @return [Boolean]
  def known_scope?(scope); end

  def normalized_scope_for(scope); end

  # :nocov:
  def owner_parent_groups; end

  def process(host, parent_groups, globals, position, scope); end
  def run_around_example_hooks_for(example); end
  def run_example_hooks_for(example, position, each_method); end
  def scope_and_options_from(*args); end
end

RSpec::Core::Hooks::HookCollections::EMPTY_HOOK_ARRAY = T.let(T.unsafe(nil), Array)
RSpec::Core::Hooks::HookCollections::HOOK_TYPES = T.let(T.unsafe(nil), Hash)
RSpec::Core::Hooks::HookCollections::SCOPES = T.let(T.unsafe(nil), Array)
RSpec::Core::Hooks::HookCollections::SCOPE_ALIASES = T.let(T.unsafe(nil), Hash)

# @private
class RSpec::Core::InclusionRules < ::RSpec::Core::FilterRules
  def add(*args); end
  def add_with_low_priority(*args); end

  # @return [Boolean]
  def include_example?(example); end

  def split_file_scoped_rules; end

  # @return [Boolean]
  def standalone?; end

  private

  def apply_standalone_filter(updated); end

  # @return [Boolean]
  def is_standalone_filter?(rules); end

  def replace_filters(new_rules); end
end

# @private
module RSpec::Core::Invocations; end

# @private
class RSpec::Core::Invocations::Bisect
  def call(options, err, out); end

  private

  def bisect_formatter_klass_for(argument); end
end

# @private
class RSpec::Core::Invocations::DRbWithFallback
  def call(options, err, out); end
end

# @private
class RSpec::Core::Invocations::InitializeProject
  def call(*_args); end
end

# @private
class RSpec::Core::Invocations::PrintHelp < ::Struct
  def call(_options, _err, out); end

  # Returns the value of attribute hidden_options
  #
  # @return [Object] the current value of hidden_options
  def hidden_options; end

  # Sets the attribute hidden_options
  #
  # @param value [Object] the value to set the attribute hidden_options to.
  # @return [Object] the newly set value
  def hidden_options=(_); end

  # Returns the value of attribute parser
  #
  # @return [Object] the current value of parser
  def parser; end

  # Sets the attribute parser
  #
  # @param value [Object] the value to set the attribute parser to.
  # @return [Object] the newly set value
  def parser=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @private
class RSpec::Core::Invocations::PrintVersion
  def call(_options, _err, out); end
end

# Together with the example group metadata hash default block,
# provides backwards compatibility for the old `:example_group`
# key. In RSpec 2.x, the computed keys of a group's metadata
# were exposed from a nested subhash keyed by `[:example_group]`, and
# then the parent group's metadata was exposed by sub-subhash
# keyed by `[:example_group][:example_group]`.
#
# In RSpec 3, we reorganized this to that the computed keys are
# exposed directly of the group metadata hash (no nesting), and
# `:parent_example_group` returns the parent group's metadata.
#
# Maintaining backwards compatibility was difficult: we wanted
# `:example_group` to return an object that:
#
#   * Exposes the top-level metadata keys that used to be nested
#     under `:example_group`.
#   * Supports mutation (rspec-rails, for example, assigns
#     `metadata[:example_group][:described_class]` when you use
#     anonymous controller specs) such that changes are written
#     back to the top-level metadata hash.
#   * Exposes the parent group metadata as
#     `[:example_group][:example_group]`.
#
# @private
class RSpec::Core::LegacyExampleGroupHash
  include ::RSpec::Core::HashImitatable
  extend ::RSpec::Core::HashImitatable::ClassMethods

  # @return [LegacyExampleGroupHash] a new instance of LegacyExampleGroupHash
  def initialize(metadata); end

  def to_h; end

  private

  # @return [Boolean]
  def directly_supports_attribute?(name); end

  def get_value(name); end
  def set_value(name, value); end
end

# This module is included in {ExampleGroup}, making the methods
# available to be called from within example blocks.
#
# @see ClassMethods
module RSpec::Core::MemoizedHelpers
  # @private
  def initialize(*_arg0); end

  # Wraps the `subject` in `expect` to make it the target of an expectation.
  # Designed to read nicely for one-liners.
  #
  # @example
  #
  #   describe [1, 2, 3] do
  #   it { is_expected.to be_an Array }
  #   it { is_expected.not_to include 4 }
  #   end
  # @note This only works if you are using rspec-expectations.
  # @see #subject
  # @see #should
  # @see #should_not
  def is_expected; end

  # When `should` is called with no explicit receiver, the call is
  # delegated to the object returned by `subject`. Combined with an
  # implicit subject this supports very concise expressions.
  #
  # @example
  #
  #   RSpec.describe Person do
  #   it { should be_eligible_to_vote }
  #   end
  # @note This only works if you are using rspec-expectations.
  # @note If you are using RSpec's newer expect-based syntax you may
  #   want to use `is_expected.to` instead of `should`.
  # @see #subject
  # @see #is_expected
  def should(matcher = T.unsafe(nil), message = T.unsafe(nil)); end

  # Just like `should`, `should_not` delegates to the subject (implicit or
  # explicit) of the example group.
  #
  # @example
  #
  #   RSpec.describe Person do
  #   it { should_not be_eligible_to_vote }
  #   end
  # @note This only works if you are using rspec-expectations.
  # @note If you are using RSpec's newer expect-based syntax you may
  #   want to use `is_expected.to_not` instead of `should_not`.
  # @see #subject
  # @see #is_expected
  def should_not(matcher = T.unsafe(nil), message = T.unsafe(nil)); end

  # @example
  #
  #   # Explicit declaration of subject.
  #   RSpec.describe Person do
  #   subject { Person.new(:birthdate => 19.years.ago) }
  #   it "should be eligible to vote" do
  #   subject.should be_eligible_to_vote
  #   # ^ ^ explicit reference to subject not recommended
  #   end
  #   end
  #
  #   # Implicit subject => { Person.new }.
  #   RSpec.describe Person do
  #   it "should be eligible to vote" do
  #   subject.should be_eligible_to_vote
  #   # ^ ^ explicit reference to subject not recommended
  #   end
  #   end
  #
  #   # One-liner syntax - expectation is set on the subject.
  #   RSpec.describe Person do
  #   it { is_expected.to be_eligible_to_vote }
  #   # or
  #   it { should be_eligible_to_vote }
  #   end
  # @note `subject` was contributed by Joe Ferris to support the one-liner
  #   syntax embraced by shoulda matchers:
  #
  #   RSpec.describe Widget do
  #   it { is_expected.to validate_presence_of(:name) }
  #   # or
  #   it { should validate_presence_of(:name) }
  #   end
  #
  #   While the examples below demonstrate how to use `subject`
  #   explicitly in examples, we recommend that you define a method with
  #   an intention revealing name instead.
  # @note Because `subject` is designed to create state that is reset
  #   between each example, and `before(:context)` is designed to setup
  #   state that is shared across _all_ examples in an example group,
  #   `subject` is _not_ intended to be used in a `before(:context)` hook.
  # @see #should
  # @see #should_not
  # @see #is_expected
  def subject; end

  private

  # @private
  def __init_memoized; end

  # should just be placed in private section,
  # but Ruby issues warnings on private attributes.
  # and expanding it to the equivalent method upsets Rubocop,
  # b/c it should obviously be a reader
  #
  # @private
  def __memoized; end

  # @private
  def enforce_value_expectation(matcher, method_name); end

  # @return [Boolean]
  def matcher_supports_value_expectations?(matcher); end

  class << self
    # @private
    def define_helpers_on(example_group); end

    # Gets the named constant or yields.
    # On 1.9, const_defined? / const_get take into account the
    # the inheritance by default, and accept an argument to
    # disable this behavior. It's important that we don't
    # consider inheritance here; each example group level that
    # uses a `let` should get its own `LetDefinitions` module.
    #
    # @private
    def get_constant_or_yield(example_group, name); end

    # Gets the LetDefinitions module. The module is mixed into
    # the example group and is used to hold all let definitions.
    # This is done so that the block passed to `let` can be
    # forwarded directly on to `define_method`, so that all method
    # constructs (including `super` and `return`) can be used in
    # a `let` block.
    #
    # The memoization is provided by a method definition on the
    # example group that supers to the LetDefinitions definition
    # in order to get the value to memoize.
    #
    # @private
    def module_for(example_group); end
  end
end

# This module is extended onto {ExampleGroup}, making the methods
# available to be called from within example group blocks.
# You can think of them as being analagous to class macros.
module RSpec::Core::MemoizedHelpers::ClassMethods
  # Generates a method whose return value is memoized after the first
  # call. Useful for reducing duplication between examples that assign
  # values to the same local variable.
  #
  # @example
  #
  #   RSpec.describe Thing do
  #   let(:thing) { Thing.new }
  #
  #   it "does something" do
  #   # First invocation, executes block, memoizes and returns result.
  #   thing.do_something
  #
  #   # Second invocation, returns the memoized value.
  #   thing.should be_something
  #   end
  #   end
  # @note `let` _can_ enhance readability when used sparingly (1,2, or
  #   maybe 3 declarations) in any given example group, but that can
  #   quickly degrade with overuse. YMMV.
  # @note `let` can be configured to be threadsafe or not.
  #   If it is threadsafe, it will take longer to access the value.
  #   If it is not threadsafe, it may behave in surprising ways in examples
  #   that spawn separate threads. Specify this on `RSpec.configure`
  # @note Because `let` is designed to create state that is reset between
  #   each example, and `before(:context)` is designed to setup state that
  #   is shared across _all_ examples in an example group, `let` is _not_
  #   intended to be used in a `before(:context)` hook.
  def let(name, &block); end

  # Just like `let`, except the block is invoked by an implicit `before`
  # hook. This serves a dual purpose of setting up state and providing a
  # memoized reference to that state.
  #
  # @example
  #
  #   class Thing
  #   def self.count
  #   @count ||= 0
  #   end
  #
  #   def self.count=(val)
  #   @count += val
  #   end
  #
  #   def self.reset_count
  #   @count = 0
  #   end
  #
  #   def initialize
  #   self.class.count += 1
  #   end
  #   end
  #
  #   RSpec.describe Thing do
  #   after(:example) { Thing.reset_count }
  #
  #   context "using let" do
  #   let(:thing) { Thing.new }
  #
  #   it "is not invoked implicitly" do
  #   Thing.count.should eq(0)
  #   end
  #
  #   it "can be invoked explicitly" do
  #   thing
  #   Thing.count.should eq(1)
  #   end
  #   end
  #
  #   context "using let!" do
  #   let!(:thing) { Thing.new }
  #
  #   it "is invoked implicitly" do
  #   Thing.count.should eq(1)
  #   end
  #
  #   it "returns memoized version on first invocation" do
  #   thing
  #   Thing.count.should eq(1)
  #   end
  #   end
  #   end
  def let!(name, &block); end

  # Declares a `subject` for an example group which can then be wrapped
  # with `expect` using `is_expected` to make it the target of an
  # expectation in a concise, one-line example.
  #
  # Given a `name`, defines a method with that name which returns the
  # `subject`. This lets you declare the subject once and access it
  # implicitly in one-liners and explicitly using an intention revealing
  # name.
  #
  # When given a `name`, calling `super` in the block is not supported.
  #
  # @example
  #
  #   RSpec.describe CheckingAccount, "with $50" do
  #   subject { CheckingAccount.new(Money.new(50, :USD)) }
  #   it { is_expected.to have_a_balance_of(Money.new(50, :USD)) }
  #   it { is_expected.not_to be_overdrawn }
  #   end
  #
  #   RSpec.describe CheckingAccount, "with a non-zero starting balance" do
  #   subject(:account) { CheckingAccount.new(Money.new(50, :USD)) }
  #   it { is_expected.not_to be_overdrawn }
  #   it "has a balance equal to the starting balance" do
  #   account.balance.should eq(Money.new(50, :USD))
  #   end
  #   end
  # @note `subject` can be configured to be threadsafe or not.
  #   If it is threadsafe, it will take longer to access the value.
  #   If it is not threadsafe, it may behave in surprising ways in examples
  #   that spawn separate threads. Specify this on `RSpec.configure`
  # @param name [String, Symbol] used to define an accessor with an
  #   intention revealing name
  # @param block defines the value to be returned by `subject` in examples
  # @see MemoizedHelpers#should
  # @see MemoizedHelpers#should_not
  # @see MemoizedHelpers#is_expected
  def subject(name = T.unsafe(nil), &block); end

  # Just like `subject`, except the block is invoked by an implicit
  # `before` hook. This serves a dual purpose of setting up state and
  # providing a memoized reference to that state.
  #
  # @example
  #
  #   class Thing
  #   def self.count
  #   @count ||= 0
  #   end
  #
  #   def self.count=(val)
  #   @count += val
  #   end
  #
  #   def self.reset_count
  #   @count = 0
  #   end
  #
  #   def initialize
  #   self.class.count += 1
  #   end
  #   end
  #
  #   RSpec.describe Thing do
  #   after(:example) { Thing.reset_count }
  #
  #   context "using subject" do
  #   subject { Thing.new }
  #
  #   it "is not invoked implicitly" do
  #   Thing.count.should eq(0)
  #   end
  #
  #   it "can be invoked explicitly" do
  #   subject
  #   Thing.count.should eq(1)
  #   end
  #   end
  #
  #   context "using subject!" do
  #   subject!(:thing) { Thing.new }
  #
  #   it "is invoked implicitly" do
  #   Thing.count.should eq(1)
  #   end
  #
  #   it "returns memoized version on first invocation" do
  #   subject
  #   Thing.count.should eq(1)
  #   end
  #   end
  #   end
  def subject!(name = T.unsafe(nil), &block); end
end

# Used internally to customize the behavior of the
# memoized hash when used in a `before(:context)` hook.
#
# @private
class RSpec::Core::MemoizedHelpers::ContextHookMemoized
  class << self
    def fetch_or_store(key, &_block); end
    def isolate_for_context_hook(example_group_instance); end
  end
end

# @private
class RSpec::Core::MemoizedHelpers::ContextHookMemoized::After < ::RSpec::Core::MemoizedHelpers::ContextHookMemoized
  class << self
    def article; end
    def hook_expression; end
    def hook_intention; end
  end
end

# @private
class RSpec::Core::MemoizedHelpers::ContextHookMemoized::Before < ::RSpec::Core::MemoizedHelpers::ContextHookMemoized
  class << self
    def article; end
    def hook_expression; end
    def hook_intention; end
  end
end

# @private
class RSpec::Core::MemoizedHelpers::NonThreadSafeMemoized
  # @return [NonThreadSafeMemoized] a new instance of NonThreadSafeMemoized
  def initialize; end

  def fetch_or_store(key); end
end

# @private
class RSpec::Core::MemoizedHelpers::ThreadsafeMemoized
  # @return [ThreadsafeMemoized] a new instance of ThreadsafeMemoized
  def initialize; end

  def fetch_or_store(key); end
end

# Each ExampleGroup class and Example instance owns an instance of
# Metadata, which is Hash extended to support lazy evaluation of values
# associated with keys that may or may not be used by any example or group.
#
# In addition to metadata that is used internally, this also stores
# user-supplied metadata, e.g.
#
#     RSpec.describe Something, :type => :ui do
#       it "does something", :slow => true do
#         # ...
#       end
#     end
#
# `:type => :ui` is stored in the Metadata owned by the example group, and
# `:slow => true` is stored in the Metadata owned by the example. These can
# then be used to select which examples are run using the `--tag` option on
# the command line, or several methods on `Configuration` used to filter a
# run (e.g. `filter_run_including`, `filter_run_excluding`, etc).
#
# @see Example#metadata
# @see ExampleGroup.metadata
# @see FilterManager
# @see Configuration#filter_run_including
# @see Configuration#filter_run_excluding
module RSpec::Core::Metadata
  class << self
    # Returns an enumerator that iteratively walks up the given metadata through all
    # example group ancestors, yielding each metadata hash along the way.
    #
    # @private
    def ascend(metadata); end

    # Iteratively walks up from the given metadata through all
    # example group ancestors, yielding each metadata hash along the way.
    #
    # @private
    # @yield [metadata]
    def ascending(metadata); end

    # Used internally to build a hash from an args array.
    # Symbols are converted into hash keys with a value of `true`.
    # This is done to support simple tagging using a symbol, rather
    # than needing to do `:symbol => true`.
    #
    # @private
    def build_hash_from(args, warn_about_example_group_filtering = T.unsafe(nil)); end

    # @private
    def deep_hash_dup(object); end

    # @private
    def id_from(metadata); end

    # @private
    def location_tuple_from(metadata); end

    # @api private
    # @param line [String] current code line
    # @return [String] relative path to line
    def relative_path(line); end

    # Matches strings either at the beginning of the input or prefixed with a
    # whitespace, containing the current path, either postfixed with the
    # separator, or at the end of the string. Match groups are the character
    # before and the character after the string if any.
    #
    # http://rubular.com/r/fT0gmX6VJX
    # http://rubular.com/r/duOrD4i3wb
    # http://rubular.com/r/sbAMHFrOx1
    def relative_path_regex; end
  end
end

# @private
class RSpec::Core::Metadata::ExampleGroupHash < ::RSpec::Core::Metadata::HashPopulator
  private

  def described_class; end
  def full_description; end

  class << self
    def backwards_compatibility_default_proc(&example_group_selector); end
    def create(parent_group_metadata, user_metadata, example_group_index, *args, &block); end
    def hash_with_backwards_compatibility_default_proc; end
  end
end

# @private
class RSpec::Core::Metadata::ExampleHash < ::RSpec::Core::Metadata::HashPopulator
  private

  def described_class; end
  def full_description; end

  class << self
    def create(group_metadata, user_metadata, index_provider, description, block); end
  end
end

# Used internally to populate metadata hashes with computed keys
# managed by RSpec.
#
# @private
class RSpec::Core::Metadata::HashPopulator
  # @return [HashPopulator] a new instance of HashPopulator
  def initialize(metadata, user_metadata, index_provider, description_args, block); end

  # Returns the value of attribute block.
  def block; end

  # Returns the value of attribute description_args.
  def description_args; end

  # Returns the value of attribute metadata.
  def metadata; end

  def populate; end

  # Returns the value of attribute user_metadata.
  def user_metadata; end

  private

  def build_description_from(parent_description = T.unsafe(nil), my_description = T.unsafe(nil)); end
  def build_scoped_id_for(file_path); end
  def description_separator(parent_part, child_part); end
  def ensure_valid_user_keys; end
  def file_path_and_line_number_from(backtrace); end
  def populate_location_attributes; end
end

# @private
RSpec::Core::Metadata::RESERVED_KEYS = T.let(T.unsafe(nil), Array)

# Contains metadata filtering logic. This has been extracted from
# the metadata classes because it operates ON a metadata hash but
# does not manage any of the state in the hash. We're moving towards
# having metadata be a raw hash (not a custom subclass), so externalizing
# this filtering logic helps us move in that direction.
module RSpec::Core::MetadataFilter
  class << self
    # @private
    # @return [Boolean]
    def apply?(predicate, filters, metadata); end

    # @private
    # @return [Boolean]
    def filter_applies?(key, filter_value, metadata); end

    # @private
    def silence_metadata_example_group_deprecations; end

    private

    # @return [Boolean]
    def filter_applies_to_any_value?(key, value, metadata); end

    # @return [Boolean]
    def filters_apply?(key, value, metadata); end

    # @return [Boolean]
    def id_filter_applies?(rerun_paths_to_scoped_ids, metadata); end

    # @return [Boolean]
    def location_filter_applies?(locations, metadata); end

    # @return [Boolean]
    def proc_filter_applies?(key, proc, metadata); end
  end
end

# Provides a single exception instance that provides access to
# multiple sub-exceptions. This is used in situations where a single
# individual spec has multiple exceptions, such as one in the `it` block
# and one in an `after` block.
class RSpec::Core::MultipleExceptionError < ::StandardError
  include ::RSpec::Core::MultipleExceptionError::InterfaceTag

  # @param exceptions [Array<Exception>] The initial list of exceptions.
  # @return [MultipleExceptionError] a new instance of MultipleExceptionError
  def initialize(*exceptions); end

  # @return [nil] Provided only for interface compatibility with
  #   `RSpec::Expectations::MultipleExpectationsNotMetError`.
  def aggregation_block_label; end

  # @return [Hash] Metadata used by RSpec for formatting purposes.
  def aggregation_metadata; end

  # @return [Array<Exception>] The list of failures and other exceptions, combined.
  def all_exceptions; end

  # return [String] A description of the failure/error counts.
  def exception_count_description; end

  # @return [Array<Exception>] The list of failures.
  def failures; end

  # @note RSpec does not actually use this -- instead it formats each exception
  #   individually.
  # @return [String] Combines all the exception messages into a single string.
  def message; end

  # @return [Array<Exception>] The list of other errors.
  def other_errors; end

  # @return [String] A summary of the failure, including the block label and a count of failures.
  def summary; end
end

# Used so there is a common module in the ancestor chain of this class
# and `RSpec::Expectations::MultipleExpectationsNotMetError`, which allows
# code to detect exceptions that are instances of either, without first
# checking to see if rspec-expectations is loaded.
#
# @private
module RSpec::Core::MultipleExceptionError::InterfaceTag
  # Appends the provided exception to the list.
  #
  # @param exception [Exception] Exception to append to the list.
  # @private
  def add(exception); end

  class << self
    # Provides a way to force `ex` to be something that satisfies the multiple
    # exception error interface. If it already satisfies it, it will be returned;
    # otherwise it will wrap it in a `MultipleExceptionError`.
    #
    # @private
    def for(ex); end
  end
end

# Notifications are value objects passed to formatters to provide them
# with information about a particular event of interest.
module RSpec::Core::Notifications; end

# `CustomNotification` is used when sending custom events to formatters /
# other registered listeners, it creates attributes based on supplied hash
# of options.
class RSpec::Core::Notifications::CustomNotification < ::Struct
  class << self
    # Build a custom notification based on the supplied option key / values.
    #
    # @param options [Hash] A hash of method / value pairs to create on this notification
    # @return [CustomNotification]
    def for(options = T.unsafe(nil)); end
  end
end

# The `DeprecationNotification` is issued by the reporter when a deprecated
# part of RSpec is encountered. It represents information about the
# deprecated call site.
#
# @attr message [String] A custom message about the deprecation
# @attr deprecated [String] A custom message about the deprecation (alias of
#   message)
# @attr replacement [String] An optional replacement for the deprecation
# @attr call_site [String] An optional call site from which the deprecation
#   was issued
class RSpec::Core::Notifications::DeprecationNotification < ::Struct
  # An optional call site from which the deprecation
  # was issued
  #
  # @return [String] the current value of call_site
  def call_site; end

  # An optional call site from which the deprecation
  # was issued
  #
  # @param value [String] the value to set the attribute call_site to.
  # @return [String] the newly set value
  def call_site=(_); end

  # A custom message about the deprecation (alias of
  # message)
  #
  # @return [String] the current value of deprecated
  def deprecated; end

  # A custom message about the deprecation (alias of
  # message)
  #
  # @param value [String] the value to set the attribute deprecated to.
  # @return [String] the newly set value
  def deprecated=(_); end

  # A custom message about the deprecation
  #
  # @return [String] the current value of message
  def message; end

  # A custom message about the deprecation
  #
  # @param value [String] the value to set the attribute message to.
  # @return [String] the newly set value
  def message=(_); end

  # An optional replacement for the deprecation
  #
  # @return [String] the current value of replacement
  def replacement; end

  # An optional replacement for the deprecation
  #
  # @param value [String] the value to set the attribute replacement to.
  # @return [String] the newly set value
  def replacement=(_); end

  class << self
    def [](*_arg0); end

    # Convenience way to initialize the notification
    #
    # @api
    def from_hash(data); end

    def inspect; end
    def keyword_init?; end
    def members; end

    private

    def new(*_arg0); end
  end
end

# The `ExampleNotification` represents notifications sent by the reporter
# which contain information about the current (or soon to be) example.
# It is used by formatters to access information about that example.
#
# @attr example [RSpec::Core::Example] the current example
# @example
#   def example_started(notification)
#   puts "Hey I started #{notification.example.description}"
#   end
class RSpec::Core::Notifications::ExampleNotification < ::Struct
  # the current example
  #
  # @return [RSpec::Core::Example] the current value of example
  def example; end

  # the current example
  #
  # @param value [RSpec::Core::Example] the value to set the attribute example to.
  # @return [RSpec::Core::Example] the newly set value
  def example=(_); end

  class << self
    def [](*_arg0); end

    # @private
    def for(example); end

    def inspect; end
    def keyword_init?; end
    def members; end

    private

    def new(*_arg0); end
  end
end

# The `ExamplesNotification` represents notifications sent by the reporter
# which contain information about the suites examples.
#
# @example
#   def stop(notification)
#   puts "Hey I ran #{notification.examples.size}"
#   end
class RSpec::Core::Notifications::ExamplesNotification
  # @return [ExamplesNotification] a new instance of ExamplesNotification
  def initialize(reporter); end

  # @return [Array<RSpec::Core::Example>] list of examples
  def examples; end

  # @return [Array<RSpec::Core::Example>] list of failed examples
  def failed_examples; end

  # @return [Array<RSpec::Core::Notifications::FailedExampleNotification>] returns failed examples as notifications
  def failure_notifications; end

  # @return [String] The list of failed examples, fully formatted in the way
  #   that RSpec's built-in formatters emit.
  def fully_formatted_failed_examples(colorizer = T.unsafe(nil)); end

  # @return [String] The list of pending examples, fully formatted in the
  #   way that RSpec's built-in formatters emit.
  def fully_formatted_pending_examples(colorizer = T.unsafe(nil)); end

  # @return [Array<RSpec::Core::Notifications::ExampleNotification>] returns examples as notifications
  def notifications; end

  # @return [Array<RSpec::Core::Example>] list of pending examples
  def pending_examples; end

  # returns pending examples as notifications
  #
  # @return [Array<RSpec::Core::Notifications::SkippedExampleNotification,
  # RSpec::Core::Notifications::PendingExampleFailedAsExpectedNotification>]
  def pending_notifications; end

  private

  def format_examples(examples); end
end

# The `FailedExampleNotification` extends `ExampleNotification` with
# things useful for examples that have failure info -- typically a
# failed or pending spec.
#
# @attr example [RSpec::Core::Example] the current example
# @example
#   def example_failed(notification)
#   puts "Hey I failed :("
#   puts "Here's my stack trace"
#   puts notification.exception.backtrace.join("\n")
#   end
# @see ExampleNotification
class RSpec::Core::Notifications::FailedExampleNotification < ::RSpec::Core::Notifications::ExampleNotification
  # @return [FailedExampleNotification] a new instance of FailedExampleNotification
  def initialize(example, exception_presenter = T.unsafe(nil)); end

  # Returns the failures colorized formatted backtrace.
  #
  # @param colorizer [#wrap] An object to colorize the message_lines by
  # @return [Array<String>] the examples colorized backtrace lines
  def colorized_formatted_backtrace(colorizer = T.unsafe(nil)); end

  # Returns the message generated for this failure colorized line by line.
  #
  # @param colorizer [#wrap] An object to colorize the message_lines by
  # @return [Array<String>] The example failure message colorized
  def colorized_message_lines(colorizer = T.unsafe(nil)); end

  # @return [String] The example description
  def description; end

  # @return [Exception] The example failure
  def exception; end

  # Returns the failures formatted backtrace.
  #
  # @return [Array<String>] the examples backtrace lines
  def formatted_backtrace; end

  # @return [String] The failure information fully formatted in the way that
  #   RSpec's built-in formatters emit.
  def fully_formatted(failure_number, colorizer = T.unsafe(nil)); end

  # @return [Array<string>] The failure information fully formatted in the way that
  #   RSpec's built-in formatters emit, split by line.
  def fully_formatted_lines(failure_number, colorizer = T.unsafe(nil)); end

  # Returns the message generated for this failure line by line.
  #
  # @return [Array<String>] The example failure message
  def message_lines; end
end

# The `GroupNotification` represents notifications sent by the reporter
# which contain information about the currently running (or soon to be)
# example group. It is used by formatters to access information about that
# group.
#
# @attr group [RSpec::Core::ExampleGroup] the current group
# @example
#   def example_group_started(notification)
#   puts "Hey I started #{notification.group.description}"
#   end
class RSpec::Core::Notifications::GroupNotification < ::Struct
  # the current group
  #
  # @return [RSpec::Core::ExampleGroup] the current value of group
  def group; end

  # the current group
  #
  # @param value [RSpec::Core::ExampleGroup] the value to set the attribute group to.
  # @return [RSpec::Core::ExampleGroup] the newly set value
  def group=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# The `MessageNotification` encapsulates generic messages that the reporter
# sends to formatters.
#
# @attr message [String] the message
class RSpec::Core::Notifications::MessageNotification < ::Struct
  # the message
  #
  # @return [String] the current value of message
  def message; end

  # the message
  #
  # @param value [String] the value to set the attribute message to.
  # @return [String] the newly set value
  def message=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# @private
module RSpec::Core::Notifications::NullColorizer
  private

  def wrap(line, _code_or_symbol); end

  class << self
    def wrap(line, _code_or_symbol); end
  end
end

# `NullNotification` represents a placeholder value for notifications that
# currently require no information, but we may wish to extend in future.
class RSpec::Core::Notifications::NullNotification; end

# @deprecated Use {FailedExampleNotification} instead.
class RSpec::Core::Notifications::PendingExampleFailedAsExpectedNotification < ::RSpec::Core::Notifications::FailedExampleNotification; end

# @deprecated Use {FailedExampleNotification} instead.
class RSpec::Core::Notifications::PendingExampleFixedNotification < ::RSpec::Core::Notifications::FailedExampleNotification; end

# The `ProfileNotification` holds information about the results of running a
# test suite when profiling is enabled. It is used by formatters to provide
# information at the end of the test run for profiling information.
#
# @attr duration [Float] the time taken (in seconds) to run the suite
# @attr examples [Array<RSpec::Core::Example>] the examples run
# @attr number_of_examples [Fixnum] the number of examples to profile
# @attr example_groups [Array<RSpec::Core::Profiler>] example groups run
class RSpec::Core::Notifications::ProfileNotification
  # @return [ProfileNotification] a new instance of ProfileNotification
  def initialize(duration, examples, number_of_examples, example_groups); end

  # the time taken (in seconds) to run the suite
  #
  # @return [Float] the current value of duration
  def duration; end

  # the examples run
  #
  # @return [Array<RSpec::Core::Example>] the current value of examples
  def examples; end

  # the number of examples to profile
  #
  # @return [Fixnum] the current value of number_of_examples
  def number_of_examples; end

  # @return [String] the percentage of total time taken
  def percentage; end

  # @return [Float] the time taken (in seconds) to run the slowest examples
  def slow_duration; end

  # @return [Array<RSpec::Core::Example>] the slowest examples
  def slowest_examples; end

  # @return [Array<RSpec::Core::Example>] the slowest example groups
  def slowest_groups; end

  private

  def calculate_slowest_groups; end
end

# The `SeedNotification` holds the seed used to randomize examples and
# whether that seed has been used or not.
#
# @attr seed [Fixnum] the seed used to randomize ordering
# @attr used [Boolean] whether the seed has been used or not
class RSpec::Core::Notifications::SeedNotification < ::Struct
  # @return [String] The seed information fully formatted in the way that
  #   RSpec's built-in formatters emit.
  def fully_formatted; end

  # the seed used to randomize ordering
  #
  # @return [Fixnum] the current value of seed
  def seed; end

  # the seed used to randomize ordering
  #
  # @param value [Fixnum] the value to set the attribute seed to.
  # @return [Fixnum] the newly set value
  def seed=(_); end

  # @api
  # @return [Boolean] has the seed been used?
  def seed_used?; end

  # whether the seed has been used or not
  #
  # @param value [Boolean] the value to set the attribute used to.
  # @return [Boolean] the newly set value
  def used=(_); end

  private

  # whether the seed has been used or not
  #
  # @return [Boolean] the current value of used
  def used; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# The `SkippedExampleNotification` extends `ExampleNotification` with
# things useful for specs that are skipped.
#
# @attr example [RSpec::Core::Example] the current example
# @see ExampleNotification
class RSpec::Core::Notifications::SkippedExampleNotification < ::RSpec::Core::Notifications::ExampleNotification
  # @return [String] The pending detail fully formatted in the way that
  #   RSpec's built-in formatters emit.
  def fully_formatted(pending_number, colorizer = T.unsafe(nil)); end
end

# The `StartNotification` represents a notification sent by the reporter
# when the suite is started. It contains the expected amount of examples
# to be executed, and the load time of RSpec.
#
# @attr count [Fixnum] the number counted
# @attr load_time [Float] the number of seconds taken to boot RSpec
#   and load the spec files
class RSpec::Core::Notifications::StartNotification < ::Struct
  # the number counted
  #
  # @return [Fixnum] the current value of count
  def count; end

  # the number counted
  #
  # @param value [Fixnum] the value to set the attribute count to.
  # @return [Fixnum] the newly set value
  def count=(_); end

  # the number of seconds taken to boot RSpec
  # and load the spec files
  #
  # @return [Float] the current value of load_time
  def load_time; end

  # the number of seconds taken to boot RSpec
  # and load the spec files
  #
  # @param value [Float] the value to set the attribute load_time to.
  # @return [Float] the newly set value
  def load_time=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# The `SummaryNotification` holds information about the results of running
# a test suite. It is used by formatters to provide information at the end
# of the test run.
#
# @attr duration [Float] the time taken (in seconds) to run the suite
# @attr examples [Array<RSpec::Core::Example>] the examples run
# @attr failed_examples [Array<RSpec::Core::Example>] the failed examples
# @attr pending_examples [Array<RSpec::Core::Example>] the pending examples
# @attr load_time [Float] the number of seconds taken to boot RSpec
#   and load the spec files
# @attr errors_outside_of_examples_count [Integer] the number of errors that
#   have occurred processing
#   the spec suite
class RSpec::Core::Notifications::SummaryNotification < ::Struct
  include ::RSpec::Core::ShellEscape

  # Formats failures into a rerunable command format.
  #
  # @api public
  # @param colorizer [#wrap] An object which supports wrapping text with
  #   specific colors.
  # @return [String] A colorized summary line.
  def colorized_rerun_commands(colorizer = T.unsafe(nil)); end

  # Wraps the results line with colors based on the configured
  # colors for failure, pending, and success. Defaults to red,
  # yellow, green accordingly.
  #
  # @api public
  # @param colorizer [#wrap] An object which supports wrapping text with
  #   specific colors.
  # @return [String] A colorized results line.
  def colorized_totals_line(colorizer = T.unsafe(nil)); end

  # the time taken (in seconds) to run the suite
  #
  # @return [Float] the current value of duration
  def duration; end

  # the time taken (in seconds) to run the suite
  #
  # @param value [Float] the value to set the attribute duration to.
  # @return [Float] the newly set value
  def duration=(_); end

  # the number of errors that
  # have occurred processing
  # the spec suite
  #
  # @return [Integer] the current value of errors_outside_of_examples_count
  def errors_outside_of_examples_count; end

  # the number of errors that
  # have occurred processing
  # the spec suite
  #
  # @param value [Integer] the value to set the attribute errors_outside_of_examples_count to.
  # @return [Integer] the newly set value
  def errors_outside_of_examples_count=(_); end

  # @api
  # @return [Fixnum] the number of examples run
  def example_count; end

  # the examples run
  #
  # @return [Array<RSpec::Core::Example>] the current value of examples
  def examples; end

  # the examples run
  #
  # @param value [Array<RSpec::Core::Example>] the value to set the attribute examples to.
  # @return [Array<RSpec::Core::Example>] the newly set value
  def examples=(_); end

  # the failed examples
  #
  # @return [Array<RSpec::Core::Example>] the current value of failed_examples
  def failed_examples; end

  # the failed examples
  #
  # @param value [Array<RSpec::Core::Example>] the value to set the attribute failed_examples to.
  # @return [Array<RSpec::Core::Example>] the newly set value
  def failed_examples=(_); end

  # @api
  # @return [Fixnum] the number of failed examples
  def failure_count; end

  # @return [String] a formatted version of the time it took to run the
  #   suite
  def formatted_duration; end

  # @return [String] a formatted version of the time it took to boot RSpec
  #   and load the spec files
  def formatted_load_time; end

  # @return [String] The summary information fully formatted in the way that
  #   RSpec's built-in formatters emit.
  def fully_formatted(colorizer = T.unsafe(nil)); end

  # the number of seconds taken to boot RSpec
  # and load the spec files
  #
  # @return [Float] the current value of load_time
  def load_time; end

  # the number of seconds taken to boot RSpec
  # and load the spec files
  #
  # @param value [Float] the value to set the attribute load_time to.
  # @return [Float] the newly set value
  def load_time=(_); end

  # @api
  # @return [Fixnum] the number of pending examples
  def pending_count; end

  # the pending examples
  #
  # @return [Array<RSpec::Core::Example>] the current value of pending_examples
  def pending_examples; end

  # the pending examples
  #
  # @param value [Array<RSpec::Core::Example>] the value to set the attribute pending_examples to.
  # @return [Array<RSpec::Core::Example>] the newly set value
  def pending_examples=(_); end

  # @api
  # @return [String] A line summarising the result totals of the spec run.
  def totals_line; end

  private

  def duplicate_rerun_locations; end
  def rerun_argument_for(example); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# # Used in place of a {Reporter} for situations where we don't want reporting output.
#
# @private
class RSpec::Core::NullReporter
  class << self
    private

    def method_missing(*_arg0); end
  end
end

# @private
module RSpec::Core::Ordering; end

# Manages ordering configuration.
#
# @note This is not intended to be used externally. Use
#   the APIs provided by `RSpec::Core::Configuration` instead.
# @private
class RSpec::Core::Ordering::ConfigurationManager
  # @return [ConfigurationManager] a new instance of ConfigurationManager
  def initialize; end

  def force(hash); end
  def order=(type); end

  # Returns the value of attribute ordering_registry.
  def ordering_registry; end

  def register_ordering(name, strategy = T.unsafe(nil)); end

  # Returns the value of attribute seed.
  def seed; end

  def seed=(seed); end

  # @return [Boolean]
  def seed_used?; end
end

# Orders items based on a custom block.
#
# @private
class RSpec::Core::Ordering::Custom
  # @return [Custom] a new instance of Custom
  def initialize(callable); end

  def order(list); end
end

# The default global ordering (defined order).
#
# @private
class RSpec::Core::Ordering::Identity
  def order(items); end
end

# Orders items randomly.
#
# @private
class RSpec::Core::Ordering::Random
  # @return [Random] a new instance of Random
  def initialize(configuration); end

  def order(items); end

  # @return [Boolean]
  def used?; end

  private

  # http://en.wikipedia.org/wiki/Jenkins_hash_function
  # Jenkins provides a good distribution and is simpler than MD5.
  # It's a bit slower than MD5 (primarily because `Digest::MD5` is
  # implemented in C) but has the advantage of not requiring us
  # to load another part of stdlib, which we try to minimize.
  def jenkins_hash_digest(string); end
end

RSpec::Core::Ordering::Random::MAX_32_BIT = T.let(T.unsafe(nil), Integer)

# Orders items by modification time (most recent modified first).
#
# @private
class RSpec::Core::Ordering::RecentlyModified
  def order(list); end
end

# Stores the different ordering strategies.
#
# @private
class RSpec::Core::Ordering::Registry
  # @return [Registry] a new instance of Registry
  def initialize(configuration); end

  def fetch(name, &fallback); end
  def register(sym, strategy); end

  # @return [Boolean]
  def used_random_seed?; end
end

# @private
class RSpec::Core::OutputWrapper
  # @private
  # @return [OutputWrapper] a new instance of OutputWrapper
  def initialize(output); end

  def <<(*args, &block); end
  def advise(*args, &block); end
  def autoclose=(*args, &block); end
  def autoclose?(*args, &block); end
  def binmode(*args, &block); end
  def binmode?(*args, &block); end
  def close(*args, &block); end
  def close_on_exec=(*args, &block); end
  def close_on_exec?(*args, &block); end
  def close_read(*args, &block); end
  def close_write(*args, &block); end
  def closed?(*args, &block); end
  def each(*args, &block); end
  def each_byte(*args, &block); end
  def each_char(*args, &block); end
  def each_codepoint(*args, &block); end
  def each_line(*args, &block); end
  def eof(*args, &block); end
  def eof?(*args, &block); end
  def external_encoding(*args, &block); end
  def fcntl(*args, &block); end
  def fdatasync(*args, &block); end
  def fileno(*args, &block); end
  def flush(*args, &block); end
  def fsync(*args, &block); end
  def getbyte(*args, &block); end
  def getc(*args, &block); end
  def gets(*args, &block); end
  def inspect(*args, &block); end
  def internal_encoding(*args, &block); end
  def ioctl(*args, &block); end
  def isatty(*args, &block); end
  def lineno(*args, &block); end
  def lineno=(*args, &block); end
  def method_missing(name, *args, &block); end
  def nonblock(*args, &block); end
  def nonblock=(*args, &block); end
  def nonblock?(*args, &block); end
  def nread(*args, &block); end

  # @private
  def output; end

  # @private
  def output=(_arg0); end

  def pathconf(*args, &block); end
  def pid(*args, &block); end
  def pos(*args, &block); end
  def pos=(*args, &block); end
  def pread(*args, &block); end
  def print(*args, &block); end
  def printf(*args, &block); end
  def putc(*args, &block); end
  def puts(*args, &block); end
  def pwrite(*args, &block); end
  def read(*args, &block); end
  def read_nonblock(*args, &block); end
  def readbyte(*args, &block); end
  def readchar(*args, &block); end
  def readline(*args, &block); end
  def readlines(*args, &block); end
  def readpartial(*args, &block); end
  def ready?(*args, &block); end
  def reopen(*args, &block); end

  # @return [Boolean]
  def respond_to?(name, priv = T.unsafe(nil)); end

  def rewind(*args, &block); end
  def seek(*args, &block); end
  def set_encoding(*args, &block); end
  def set_encoding_by_bom(*args, &block); end
  def stat(*args, &block); end
  def sync(*args, &block); end
  def sync=(*args, &block); end
  def sysread(*args, &block); end
  def sysseek(*args, &block); end
  def syswrite(*args, &block); end
  def tell(*args, &block); end
  def to_i(*args, &block); end
  def to_io(*args, &block); end
  def tty?(*args, &block); end
  def ungetbyte(*args, &block); end
  def ungetc(*args, &block); end
  def wait(*args, &block); end
  def wait_priority(*args, &block); end
  def wait_readable(*args, &block); end
  def wait_writable(*args, &block); end
  def write(*args, &block); end
  def write_nonblock(*args, &block); end
end

# @private
class RSpec::Core::Parser
  # @return [Parser] a new instance of Parser
  def initialize(original_args); end

  # Returns the value of attribute original_args.
  def original_args; end

  def parse(source = T.unsafe(nil)); end

  private

  def add_tag_filter(options, filter_type, tag_name, value = T.unsafe(nil)); end
  def configure_only_failures(options); end
  def parser(options); end
  def set_fail_fast(options, value); end

  class << self
    def parse(args, source = T.unsafe(nil)); end
  end
end

# Provides methods to mark examples as pending. These methods are available
# to be called from within any example or hook.
module RSpec::Core::Pending
  # Marks an example as pending. The rest of the example will still be
  # executed, and if it passes the example will fail to indicate that the
  # pending can be removed.
  #
  # @example
  #   describe "some behaviour" do
  #   # reported as "Pending: no reason given"
  #   it "is pending with no message" do
  #   pending
  #   raise "broken"
  #   end
  #
  #   # reported as "Pending: something else getting finished"
  #   it "is pending with a custom message" do
  #   pending("something else getting finished")
  #   raise "broken"
  #   end
  #   end
  # @note When using `pending` inside an example body using this method
  #   hooks, such as `before(:example)`, have already be run. This means that
  #   a failure from the code in the `before` hook will prevent the example
  #   from being considered pending, as the example body would not be
  #   executed. If you need to consider hooks as pending as well you can use
  #   the pending metadata as an alternative, e.g.
  #   `it "does something", pending: "message"`.
  # @overload pending
  # @overload pending
  # @param message [String] optional message to add to the summary report.
  def pending(message = T.unsafe(nil)); end

  # Marks an example as pending and skips execution.
  #
  # @example
  #   describe "an example" do
  #   # reported as "Pending: no reason given"
  #   it "is skipped with no message" do
  #   skip
  #   end
  #
  #   # reported as "Pending: something else getting finished"
  #   it "is skipped with a custom message" do
  #   skip "something else getting finished"
  #   end
  #   end
  # @overload skip
  # @overload skip
  # @param message [String] optional message to add to the summary report.
  # @raise [SkipDeclaredInExample]
  def skip(message = T.unsafe(nil)); end

  class << self
    # Mark example as fixed.
    #
    # @param example [RSpec::Core::Example] the example to mark as fixed
    # @private
    def mark_fixed!(example); end

    # Mark example as pending.
    #
    # @param example [RSpec::Core::Example] the example to mark as pending
    # @param message_or_bool [Boolean, String] the message to use, or true
    # @private
    def mark_pending!(example, message_or_bool); end

    # Mark example as skipped.
    #
    # @param example [RSpec::Core::Example] the example to mark as skipped
    # @param message_or_bool [Boolean, String] the message to use, or true
    # @private
    def mark_skipped!(example, message_or_bool); end
  end
end

# @private
RSpec::Core::Pending::NOT_YET_IMPLEMENTED = T.let(T.unsafe(nil), String)

# @private
RSpec::Core::Pending::NO_REASON_GIVEN = T.let(T.unsafe(nil), String)

class RSpec::Core::Pending::PendingExampleFixedError < ::StandardError; end

# Raised in the middle of an example to indicate that it should be marked
# as skipped.
class RSpec::Core::Pending::SkipDeclaredInExample < ::StandardError
  # @return [SkipDeclaredInExample] a new instance of SkipDeclaredInExample
  def initialize(argument); end

  # Returns the value of attribute argument.
  def argument; end
end

# @private
class RSpec::Core::Profiler
  # @return [Profiler] a new instance of Profiler
  def initialize; end

  def example_group_finished(notification); end
  def example_group_started(notification); end

  # Returns the value of attribute example_groups.
  def example_groups; end

  def example_started(notification); end
end

RSpec::Core::Profiler::NOTIFICATIONS = T.let(T.unsafe(nil), Array)

# A reporter will send notifications to listeners, usually formatters for the
# spec suite run.
class RSpec::Core::Reporter
  # @return [Reporter] a new instance of Reporter
  def initialize(configuration); end

  # @private
  def abort_with(msg, exit_status); end

  # @private
  def close_after; end

  # @private
  def deprecation(hash); end

  # @private
  def example_failed(example); end

  # @private
  def example_finished(example); end

  # @private
  def example_group_finished(group); end

  # @private
  def example_group_started(group); end

  # @private
  def example_passed(example); end

  # @private
  def example_pending(example); end

  # @private
  def example_started(example); end

  # @private
  def examples; end

  # Reports a run that exited early without having run any examples.
  #
  # @param exit_code [Integer] the exit_code to be return by the reporter
  def exit_early(exit_code); end

  # @private
  # @return [Boolean]
  def fail_fast_limit_met?; end

  # @private
  def failed_examples; end

  # @private
  def finish; end

  # Send a custom message to supporting formatters.
  #
  # @param message [#to_s] A message object to send to formatters
  def message(message); end

  # @private
  def notify(event, notification); end

  # Provides a way to notify of an exception that is not tied to any
  # particular example (such as an exception encountered in a :suite hook).
  # Exceptions will be formatted the same way they normally are.
  #
  # @private
  def notify_non_example_exception(exception, context_description); end

  # @private
  def pending_examples; end

  # @private
  def prepare_default(loader, output_stream, deprecation_stream); end

  # Publish a custom event to supporting registered formatters.
  #
  # @param event [Symbol] Name of the custom event to trigger on formatters
  # @param options [Hash] Hash of arguments to provide via `CustomNotification`
  # @see RSpec::Core::Notifications::CustomNotification
  def publish(event, options = T.unsafe(nil)); end

  # Registers a listener to a list of notifications. The reporter will send
  # notification of events to all registered listeners.
  #
  # @param listener [Object] An obect that wishes to be notified of reporter
  #   events
  # @param notifications [Array] Array of symbols represents the events a
  #   listener wishes to subscribe too
  def register_listener(listener, *notifications); end

  # @private
  def registered_listeners(notification); end

  # Initializes the report run and yields itself for further reporting. The
  # block is required, so that the reporter can manage cleaning up after the
  # run.
  #
  # @example
  #
  #   reporter.report(group.examples.size) do |r|
  #   example_groups.map {|g| g.run(r) }
  #   end
  # @overload report
  # @overload report
  # @param expected_example_count [Integer] the number of examples being run
  # @yield [Block] block yields itself for further reporting.
  def report(expected_example_count); end

  # @private
  def start(expected_example_count, time = T.unsafe(nil)); end

  # @private
  def stop; end

  private

  def close; end
  def ensure_listeners_ready; end

  # @return [Boolean]
  def mute_profile_output?; end

  # @return [Boolean]
  def seed_used?; end
end

# @private
RSpec::Core::Reporter::RSPEC_NOTIFICATIONS = T.let(T.unsafe(nil), RSpec::Core::Set)

# @private
module RSpec::Core::RubyProject
  private

  def add_dir_to_load_path(dir); end
  def add_to_load_path(*dirs); end
  def ascend_until; end
  def determine_root; end
  def find_first_parent_containing(dir); end
  def root; end

  class << self
    def add_dir_to_load_path(dir); end
    def add_to_load_path(*dirs); end
    def ascend_until; end
    def determine_root; end
    def find_first_parent_containing(dir); end
    def root; end
  end
end

# Provides the main entry point to run a suite of RSpec examples.
class RSpec::Core::Runner
  # @return [Runner] a new instance of Runner
  def initialize(options, configuration = T.unsafe(nil), world = T.unsafe(nil)); end

  # @attr_reader
  # @private
  def configuration; end

  # @private
  def configure(err, out); end

  # @private
  def exit_code(examples_passed = T.unsafe(nil)); end

  # @attr_reader
  # @private
  def options; end

  # Configures and runs a spec suite.
  #
  # @param err [IO] error stream
  # @param out [IO] output stream
  def run(err, out); end

  # Runs the provided example groups.
  #
  # @param example_groups [Array<RSpec::Core::ExampleGroup>] groups to run
  # @return [Fixnum] exit status code. 0 if all specs passed,
  #   or the configured failure exit code (1 by default) if specs
  #   failed.
  def run_specs(example_groups); end

  # Wires together the various configuration objects and state holders.
  #
  # @param err [IO] error stream
  # @param out [IO] output stream
  def setup(err, out); end

  # @attr_reader
  # @private
  def world; end

  private

  def persist_example_statuses; end

  class << self
    # Register an `at_exit` hook that runs the suite when the process exits.
    #
    # @note This is not generally needed. The `rspec` command takes care
    #   of running examples for you without involving an `at_exit`
    #   hook. This is only needed if you are running specs using
    #   the `ruby` command, and even then, the normal way to invoke
    #   this is by requiring `rspec/autorun`.
    def autorun; end

    # @private
    # @return [Boolean]
    def autorun_disabled?; end

    # @private
    def disable_autorun!; end

    # @private
    def handle_interrupt; end

    # @private
    # @return [Boolean]
    def installed_at_exit?; end

    # Runs the suite of specs and exits the process with an appropriate exit
    # code.
    def invoke; end

    # @private
    def perform_at_exit; end

    # Run a suite of RSpec examples. Does not exit.
    #
    # This is used internally by RSpec to run a suite, but is available
    # for use by any other automation tool.
    #
    # If you want to run this multiple times in the same process, and you
    # want files like `spec_helper.rb` to be reloaded, be sure to load `load`
    # instead of `require`.
    #
    # @param args [Array] command-line-supported arguments
    # @param err [IO] error stream
    # @param out [IO] output stream
    # @return [Fixnum] exit status code. 0 if all specs passed,
    #   or the configured failure exit code (1 by default) if specs
    #   failed.
    def run(args, err = T.unsafe(nil), out = T.unsafe(nil)); end

    # @private
    # @return [Boolean]
    def running_in_drb?; end

    # @private
    def trap_interrupt; end
  end
end

# We use this to replace `::Set` so we can have the advantage of
# constant time key lookups for unique arrays but without the
# potential to pollute a developers environment with an extra
# piece of the stdlib. This helps to prevent false positive
# builds.
#
# @private
class RSpec::Core::Set
  include ::Enumerable

  # @return [Set] a new instance of Set
  def initialize(array = T.unsafe(nil)); end

  def <<(key); end
  def clear; end
  def delete(key); end
  def each(&block); end

  # @return [Boolean]
  def empty?; end

  # @return [Boolean]
  def include?(key); end

  def merge(values); end
end

# Exposes {ExampleGroup}-level methods to a module, so you can include that
# module in an {ExampleGroup}.
#
# @example
#
#   module LoggedInAsAdmin
#   extend RSpec::Core::SharedContext
#   before(:example) do
#   log_in_as :admin
#   end
#   end
#
#   describe "admin section" do
#   include LoggedInAsAdmin
#   # ...
#   end
module RSpec::Core::SharedContext
  # @private
  def __shared_context_recordings; end

  def after(*args, &block); end
  def append_after(*args, &block); end
  def append_before(*args, &block); end
  def around(*args, &block); end
  def before(*args, &block); end
  def context(*args, &block); end
  def describe(*args, &block); end
  def hooks(*args, &block); end

  # @private
  def included(group); end

  def let(*args, &block); end
  def let!(*args, &block); end
  def prepend_after(*args, &block); end
  def prepend_before(*args, &block); end
  def subject(*args, &block); end
  def subject!(*args, &block); end

  class << self
    # @private
    def record(methods); end
  end
end

# @private
class RSpec::Core::SharedContext::Recording < ::Struct
  # Returns the value of attribute args
  #
  # @return [Object] the current value of args
  def args; end

  # Sets the attribute args
  #
  # @param value [Object] the value to set the attribute args to.
  # @return [Object] the newly set value
  def args=(_); end

  # Returns the value of attribute block
  #
  # @return [Object] the current value of block
  def block; end

  # Sets the attribute block
  #
  # @param value [Object] the value to set the attribute block to.
  # @return [Object] the newly set value
  def block=(_); end

  # Returns the value of attribute method_name
  #
  # @return [Object] the current value of method_name
  def method_name; end

  # Sets the attribute method_name
  #
  # @param value [Object] the value to set the attribute method_name to.
  # @return [Object] the newly set value
  def method_name=(_); end

  def playback_onto(group); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Shared example groups let you define common context and/or common
# examples that you wish to use in multiple example groups.
#
# When defined, the shared group block is stored for later evaluation.
# It can later be included in an example group either explicitly
# (using `include_examples`, `include_context` or `it_behaves_like`)
# or implicitly (via matching metadata).
#
# Named shared example groups are scoped based on where they are
# defined. Shared groups defined in an example group are available
# for inclusion in that example group or any child example groups,
# but not in any parent or sibling example groups. Shared example
# groups defined at the top level can be included from any example group.
module RSpec::Core::SharedExampleGroup
  # Stores the block for later use. The block will be evaluated
  # in the context of an example group via `include_examples`,
  # `include_context`, or `it_behaves_like`.
  #
  # @example
  #   shared_examples "auditable" do
  #   it "stores an audit record on save!" do
  #   expect { auditable.save! }.to change(Audit, :count).by(1)
  #   end
  #   end
  #
  #   RSpec.describe Account do
  #   it_behaves_like "auditable" do
  #   let(:auditable) { Account.new }
  #   end
  #   end
  # @overload shared_examples
  # @overload shared_examples
  # @see ExampleGroup.it_behaves_like
  # @see ExampleGroup.include_examples
  # @see ExampleGroup.include_context
  def shared_context(name, *args, &block); end

  # Stores the block for later use. The block will be evaluated
  # in the context of an example group via `include_examples`,
  # `include_context`, or `it_behaves_like`.
  #
  # @example
  #   shared_examples "auditable" do
  #   it "stores an audit record on save!" do
  #   expect { auditable.save! }.to change(Audit, :count).by(1)
  #   end
  #   end
  #
  #   RSpec.describe Account do
  #   it_behaves_like "auditable" do
  #   let(:auditable) { Account.new }
  #   end
  #   end
  # @overload shared_examples
  # @overload shared_examples
  # @see ExampleGroup.it_behaves_like
  # @see ExampleGroup.include_examples
  # @see ExampleGroup.include_context
  def shared_examples(name, *args, &block); end

  # Stores the block for later use. The block will be evaluated
  # in the context of an example group via `include_examples`,
  # `include_context`, or `it_behaves_like`.
  #
  # @example
  #   shared_examples "auditable" do
  #   it "stores an audit record on save!" do
  #   expect { auditable.save! }.to change(Audit, :count).by(1)
  #   end
  #   end
  #
  #   RSpec.describe Account do
  #   it_behaves_like "auditable" do
  #   let(:auditable) { Account.new }
  #   end
  #   end
  # @overload shared_examples
  # @overload shared_examples
  # @see ExampleGroup.it_behaves_like
  # @see ExampleGroup.include_examples
  # @see ExampleGroup.include_context
  def shared_examples_for(name, *args, &block); end
end

# @private
class RSpec::Core::SharedExampleGroup::Registry
  def add(context, name, *metadata_args, &block); end
  def find(lookup_contexts, name); end

  private

  # :nocov:
  def ensure_block_has_source_location(_block); end

  # :nocov:
  def formatted_location(block); end

  # TODO: remove this in RSpec 4. This exists only to support
  # `config.shared_context_metadata_behavior == :trigger_inclusion`,
  # the legacy behavior of shared context metadata, which we do
  # not want to support in RSpec 4.
  def legacy_add(context, name, *metadata_args, &block); end

  def shared_example_groups; end

  # @return [Boolean]
  def valid_name?(candidate); end

  def warn_if_key_taken(context, key, new_block); end
end

# Shared examples top level DSL.
#
# @api private
module RSpec::Core::SharedExampleGroup::TopLevelDSL
  class << self
    # @api private
    # @private
    def definitions; end

    # Adds the top level DSL methods to Module and the top level binding.
    #
    # @api private
    def expose_globally!; end

    # @api private
    # @private
    # @return [Boolean]
    def exposed_globally?; end

    # Removes the top level DSL methods to Module and the top level binding.
    #
    # @api private
    def remove_globally!; end
  end
end

# Contains information about the inclusion site of a shared example group.
class RSpec::Core::SharedExampleGroupInclusionStackFrame
  # @private
  # @return [SharedExampleGroupInclusionStackFrame] a new instance of SharedExampleGroupInclusionStackFrame
  def initialize(shared_group_name, inclusion_location); end

  # @return [String] Description of this stack frame, in the form used by
  #   RSpec's built-in formatters.
  def description; end

  # @return [String] The {#inclusion_location}, formatted for display by a formatter.
  def formatted_inclusion_location; end

  # @return [String] the location where the shared example was included
  def inclusion_location; end

  # @return [String] the name of the shared example group
  def shared_group_name; end

  class << self
    # @private
    def current_backtrace; end

    # @private
    def shared_example_group_inclusions; end

    # @private
    def with_frame(name, location); end
  end
end

# Represents some functionality that is shared with multiple example groups.
# The functionality is defined by the provided block, which is lazily
# eval'd when the `SharedExampleGroupModule` instance is included in an example
# group.
class RSpec::Core::SharedExampleGroupModule < ::Module
  # @return [SharedExampleGroupModule] a new instance of SharedExampleGroupModule
  def initialize(description, definition, metadata); end

  # @private
  def definition; end

  # @private
  def include_in(klass, inclusion_line, args, customization_block); end

  # Ruby callback for when a module is included in another module is class.
  # Our definition evaluates the shared group block in the context of the
  # including example group.
  def included(klass); end

  # Provides a human-readable representation of this module.
  def inspect; end

  # Provides a human-readable representation of this module.
  def to_s; end
end

# Deals with the fact that `shellwords` only works on POSIX systems.
#
# @private
module RSpec::Core::ShellEscape
  private

  def conditionally_quote(id); end

  # :nocov:
  def escape(shell_command); end

  def quote(argument); end
  def shell_allows_unquoted_ids?; end

  class << self
    def conditionally_quote(id); end
    def escape(shell_command); end
    def quote(argument); end

    # @return [Boolean]
    def shell_allows_unquoted_ids?; end
  end
end

# Known shells that require quoting: zsh, csh, tcsh.
#
# Feel free to add other shells to this list that are known to
# allow `rspec ./some_spec.rb[1:1]` syntax without quoting the id.
#
# @private
RSpec::Core::ShellEscape::SHELLS_ALLOWING_UNQUOTED_IDS = T.let(T.unsafe(nil), Array)

# Provides an execution context for before/after :suite hooks.
#
# @private
class RSpec::Core::SuiteHookContext < ::RSpec::Core::Example
  # @return [SuiteHookContext] a new instance of SuiteHookContext
  def initialize(hook_description, reporter); end

  def set_exception(exception); end
end

# This avoids issues with reporting time caused by examples that
# change the value/meaning of Time.now without properly restoring
# it.
#
# @private
class RSpec::Core::Time
  class << self
    def now(in: T.unsafe(nil)); end
  end
end

# Version information for RSpec Core.
module RSpec::Core::Version; end

# Current version of RSpec Core, in semantic versioning format.
RSpec::Core::Version::STRING = T.let(T.unsafe(nil), String)

# @private
module RSpec::Core::Warnings
  # Used internally to print deprecation warnings.
  #
  # @private
  def deprecate(deprecated, data = T.unsafe(nil)); end

  # Used internally to print deprecation warnings.
  #
  # @private
  def warn_deprecation(message, opts = T.unsafe(nil)); end

  # @private
  def warn_with(message, options = T.unsafe(nil)); end
end

# Internal container for global non-configuration data.
#
# @api private
class RSpec::Core::World
  # @api private
  # @return [World] a new instance of World
  def initialize(configuration = T.unsafe(nil)); end

  # @api private
  # @private
  def all_example_groups; end

  # @api private
  # @private
  def all_examples; end

  # Add exclusion filters to announcement message.
  #
  # @api private
  def announce_exclusion_filter(announcements); end

  # Notify reporter of filters.
  #
  # @api private
  def announce_filters; end

  # Add inclusion filters to announcement message.
  #
  # @api private
  def announce_inclusion_filter(announcements); end

  # @api private
  # @private
  def everything_filtered_message; end

  # Get count of examples to be run.
  #
  # @api private
  def example_count(groups = T.unsafe(nil)); end

  # @api private
  # @private
  def example_group_counts_by_spec_file; end

  # @api private
  # @private
  def example_groups; end

  # @api private
  # @private
  def exclusion_filter; end

  # @api private
  # @private
  def filter_manager; end

  # @api private
  # @private
  def filtered_examples; end

  # @api private
  # @private
  def inclusion_filter; end

  # Used internally to signal that a failure outside of an example
  # has occurred, and that therefore the exit status should indicate
  # the run failed.
  #
  # @api private
  # @private
  def non_example_failure; end

  # Used internally to signal that a failure outside of an example
  # has occurred, and that therefore the exit status should indicate
  # the run failed.
  #
  # @api private
  # @private
  def non_example_failure=(_arg0); end

  # @api private
  # @private
  def num_example_groups_defined_in(file); end

  # Apply ordering strategy from configuration to example groups.
  #
  # @api private
  def ordered_example_groups; end

  # Find line number of previous declaration.
  #
  # @api private
  def preceding_declaration_line(absolute_file_name, filter_line); end

  # Prepares filters so that they apply to example groups when they run.
  #
  # This is a separate method so that filters can be modified/replaced and
  # examples refiltered during a process's lifetime, which can be useful for
  # a custom runner.
  #
  # @api public
  def prepare_example_filtering; end

  # Records an example group.
  #
  # @api private
  def record(example_group); end

  # @api private
  # @private
  def registered_example_group_files; end

  # @api private
  # @private
  def report_filter_message(message); end

  # @api private
  # @private
  def reporter; end

  # Reset world to 'scratch' before running suite.
  #
  # @api private
  def reset; end

  # Used internally to signify that a SystemExit occurred in
  # `Configuration#load_file_handling_errors`, and thus examples cannot
  # be counted accurately. Specifically, we cannot accurately report
  # "No examples found".
  #
  # @api private
  # @private
  def rspec_is_quitting; end

  # Used internally to signify that a SystemExit occurred in
  # `Configuration#load_file_handling_errors`, and thus examples cannot
  # be counted accurately. Specifically, we cannot accurately report
  # "No examples found".
  #
  # @api private
  # @private
  def rspec_is_quitting=(_arg0); end

  # @api private
  # @private
  def shared_example_group_registry; end

  # @api private
  # @private
  def source_from_file(path); end

  # @api private
  # @private
  def syntax_highlighter; end

  # Traverses the tree of each top level group.
  # For each it yields the group, then the children, recursively.
  # Halts the traversal of a branch of the tree as soon as the passed block returns true.
  # Note that siblings groups and their sub-trees will continue to be explored.
  # This is intended to make it easy to find the top-most group that satisfies some
  # condition.
  #
  # @api private
  # @private
  def traverse_example_group_trees_until(&block); end

  # Used internally to determine what to do when a SIGINT is received.
  #
  # @api private
  def wants_to_quit; end

  # Used internally to determine what to do when a SIGINT is received.
  #
  # @api private
  def wants_to_quit=(_arg0); end

  private

  # @api private
  def descending_declaration_line_numbers_by_file; end

  # @api private
  def fail_if_config_and_cli_options_invalid; end
end

# Provides a null implementation for initial use by configuration.
#
# @api private
# @private
module RSpec::Core::World::Null
  class << self
    # @api private
    def all_example_groups; end

    # :nocov:
    #
    # @api private
    def example_groups; end

    # @api private
    def non_example_failure; end

    # @api private
    def non_example_failure=(_); end

    # @api private
    def registered_example_group_files; end

    # @api private
    def traverse_example_group_trees_until; end
  end
end

# Namespace for the example group subclasses generated by top-level
# `describe`.
#
# @private
module RSpec::ExampleGroups
  extend ::RSpec::Support::RecursiveConstMethods

  class << self
    def assign_const(group); end
    def base_name_for(group); end
    def constant_scope_for(group); end
    def disambiguate(name, const_scope); end
    def remove_all_constants; end
  end
end

# @private
RSpec::MODULES_TO_AUTOLOAD = T.let(T.unsafe(nil), Hash)

# @private
RSpec::SharedContext = RSpec::Core::SharedContext
