# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rouge` gem.
# Please instead update this file by running `bin/tapioca gem rouge`.

# The containing module for Rouge
#
# source://rouge-3.30.0/lib/rouge.rb:8
module Rouge
  class << self
    # Highlight some text with a given lexer and formatter.
    #
    # @example
    #   Rouge.highlight('@foo = 1', 'ruby', 'html')
    #   Rouge.highlight('var foo = 1;', 'js', 'terminal256')
    #
    #   # streaming - chunks become available as they are lexed
    #   Rouge.highlight(large_string, 'ruby', 'html') do |chunk|
    #   $stdout.print chunk
    #   end
    #
    # source://rouge-3.30.0/lib/rouge.rb:29
    def highlight(text, lexer, formatter, &b); end

    # Load a file relative to the `lib/rouge` path.
    #
    # @api private
    #
    # source://rouge-3.30.0/lib/rouge.rb:42
    def load_file(path); end

    # Load the lexers in the `lib/rouge/lexers` directory.
    #
    # @api private
    #
    # source://rouge-3.30.0/lib/rouge.rb:49
    def load_lexers; end

    # source://rouge-3.30.0/lib/rouge.rb:14
    def reload!; end

    # source://rouge-3.30.0/lib/rouge/version.rb:5
    def version; end
  end
end

# source://rouge-3.30.0/lib/rouge/theme.rb:163
class Rouge::CSSTheme < ::Rouge::Theme
  # @return [CSSTheme] a new instance of CSSTheme
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:164
  def initialize(opts = T.unsafe(nil)); end

  # @yield ["#{@scope} table td { padding: 5px; }"]
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:168
  def render(&b); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:180
  def render_base(selector, &b); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:184
  def style_for(tok); end

  private

  # source://rouge-3.30.0/lib/rouge/theme.rb:189
  def css_selector(token); end

  # yield all of the tokens that should be styled the same
  # as the given token.  Essentially this recursively all of
  # the subtokens, except those which are more specifically
  # styled.
  #
  # @yield [tok]
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:207
  def inflate_token(tok, &b); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:197
  def single_css_selector(token); end
end

# A Formatter takes a token stream and formats it for human viewing.
#
# source://rouge-3.30.0/lib/rouge/formatter.rb:6
class Rouge::Formatter
  # @return [Formatter] a new instance of Formatter
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:49
  def initialize(opts = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:53
  def escape?(tok); end

  # source://rouge-3.30.0/lib/rouge/formatter.rb:57
  def filter_escapes(tokens); end

  # Format a token stream.
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:68
  def format(tokens, &b); end

  # @deprecated Use {#format} instead.
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:80
  def render(tokens); end

  # yield strings that, when concatenated, form the formatted output
  #
  # @abstract
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:87
  def stream(tokens, &b); end

  protected

  # @yield [out]
  #
  # source://rouge-3.30.0/lib/rouge/formatter.rb:92
  def token_lines(tokens, &b); end

  class << self
    # source://rouge-3.30.0/lib/rouge/formatter.rb:39
    def disable_escape!; end

    # source://rouge-3.30.0/lib/rouge/formatter.rb:35
    def enable_escape!; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/formatter.rb:31
    def escape_enabled?; end

    # Find a formatter class given a unique tag.
    #
    # source://rouge-3.30.0/lib/rouge/formatter.rb:20
    def find(tag); end

    # Format a token stream.  Delegates to {#format}.
    #
    # source://rouge-3.30.0/lib/rouge/formatter.rb:45
    def format(tokens, *args, **kwargs, &b); end

    # Specify or get the unique tag for this formatter.  This is used
    # for specifying a formatter in `rougify`.
    #
    # source://rouge-3.30.0/lib/rouge/formatter.rb:12
    def tag(tag = T.unsafe(nil)); end

    # source://rouge-3.30.0/lib/rouge/formatter.rb:24
    def with_escape; end
  end
end

# @private
#
# source://rouge-3.30.0/lib/rouge/formatter.rb:8
Rouge::Formatter::REGISTRY = T.let(T.unsafe(nil), Hash)

# source://rouge-3.30.0/lib/rouge/formatters/html.rb:5
module Rouge::Formatters; end

# Transforms a token stream into HTML output.
#
# source://rouge-3.30.0/lib/rouge/formatters/html.rb:7
class Rouge::Formatters::HTML < ::Rouge::Formatter
  # source://rouge-3.30.0/lib/rouge/formatters/html.rb:21
  def safe_span(tok, safe_val); end

  # source://rouge-3.30.0/lib/rouge/formatters/html.rb:15
  def span(tok, val); end

  # @yield the html output.
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html.rb:11
  def stream(tokens, &b); end

  private

  # A performance-oriented helper method to escape `&`, `<` and `>` for the rendered
  # HTML from this formatter.
  #
  # `String#gsub` will always return a new string instance irrespective of whether
  # a substitution occurs. This method however invokes `String#gsub` only if
  # a substitution is imminent.
  #
  # Returns either the given `value` argument string as is or a new string with the
  # special characters replaced with their escaped counterparts.
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html.rb:48
  def escape_special_html_chars(value); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html.rb:32
Rouge::Formatters::HTML::TABLE_FOR_ESCAPE_HTML = T.let(T.unsafe(nil), Hash)

# source://rouge-3.30.0/lib/rouge/formatters/html_inline.rb:6
class Rouge::Formatters::HTMLInline < ::Rouge::Formatters::HTML
  # @return [HTMLInline] a new instance of HTMLInline
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_inline.rb:9
  def initialize(theme); end

  # source://rouge-3.30.0/lib/rouge/formatters/html_inline.rb:21
  def safe_span(tok, safe_val); end
end

# Transforms a token stream into HTML output.
#
# source://rouge-3.30.0/lib/rouge/formatters/html_legacy.rb:10
class Rouge::Formatters::HTMLLegacy < ::Rouge::Formatter
  # Initialize with options.
  #
  # If `:inline_theme` is given, then instead of rendering the
  # tokens as <span> tags with CSS classes, the styles according to
  # the given theme will be inlined in "style" attributes.  This is
  # useful for formats in which stylesheets are not available.
  #
  # Content will be wrapped in a tag (`div` if tableized, `pre` if
  # not) with the given `:css_class` unless `:wrap` is set to `false`.
  #
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [HTMLLegacy] a new instance of HTMLLegacy
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_legacy.rb:27
  def initialize(opts = T.unsafe(nil)); end

  # @yield the html output.
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_legacy.rb:40
  def stream(tokens, &b); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html_line_highlighter.rb:6
class Rouge::Formatters::HTMLLineHighlighter < ::Rouge::Formatter
  # @return [HTMLLineHighlighter] a new instance of HTMLLineHighlighter
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_line_highlighter.rb:9
  def initialize(delegate, opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/formatters/html_line_highlighter.rb:15
  def stream(tokens); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html_line_table.rb:6
class Rouge::Formatters::HTMLLineTable < ::Rouge::Formatter
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @option opts
  # @param formatter [Rouge::Formatters::Formatter] An instance of a
  #   `Rouge::Formatters::HTML` or `Rouge::Formatters::HTMLInline`
  # @param opts [Hash] options for HTMLLineTable instance.
  # @return [HTMLLineTable] a new instance of HTMLLineTable
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_line_table.rb:24
  def initialize(formatter, opts = T.unsafe(nil)); end

  # @yield [buffer.join]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_line_table.rb:34
  def stream(tokens, &b); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html_linewise.rb:6
class Rouge::Formatters::HTMLLinewise < ::Rouge::Formatter
  # @return [HTMLLinewise] a new instance of HTMLLinewise
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_linewise.rb:7
  def initialize(formatter, opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/formatters/html_linewise.rb:13
  def stream(tokens, &b); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html_pygments.rb:5
class Rouge::Formatters::HTMLPygments < ::Rouge::Formatter
  # @return [HTMLPygments] a new instance of HTMLPygments
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_pygments.rb:6
  def initialize(inner, css_class = T.unsafe(nil)); end

  # @yield [%(<div class="highlight"><pre class="#{@css_class}"><code>)]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_pygments.rb:11
  def stream(tokens, &b); end
end

# source://rouge-3.30.0/lib/rouge/formatters/html_table.rb:6
class Rouge::Formatters::HTMLTable < ::Rouge::Formatter
  # @return [HTMLTable] a new instance of HTMLTable
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_table.rb:9
  def initialize(inner, opts = T.unsafe(nil)); end

  # @yield [buffer.join]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_table.rb:23
  def stream(tokens, &b); end

  # @yield [%(#{scope} .rouge-table { border-spacing: 0 })]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/html_table.rb:18
  def style(scope); end
end

# A formatter which renders nothing.
#
# source://rouge-3.30.0/lib/rouge/formatters/null.rb:7
class Rouge::Formatters::Null < ::Rouge::Formatter
  # @return [Null] a new instance of Null
  #
  # source://rouge-3.30.0/lib/rouge/formatters/null.rb:10
  def initialize(*_arg0); end

  # source://rouge-3.30.0/lib/rouge/formatters/null.rb:13
  def stream(tokens, &b); end
end

# A formatter for 256-color terminals
#
# source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:7
class Rouge::Formatters::Terminal256 < ::Rouge::Formatter
  # @param theme [Hash, Rouge::Theme] the theme to render with.
  # @return [Terminal256] a new instance of Terminal256
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:15
  def initialize(theme = T.unsafe(nil)); end

  # private
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:173
  def escape_sequence(token); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:184
  def get_style(token); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:180
  def make_escape_sequence(style); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:25
  def stream(tokens, &b); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:190
  def text_style; end

  # @private
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:11
  def theme; end
end

# source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:31
class Rouge::Formatters::Terminal256::EscapeSequence
  # @return [EscapeSequence] a new instance of EscapeSequence
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:33
  def initialize(style); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:80
  def bg; end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:75
  def fg; end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:105
  def reset_string; end

  # @yield [style_string]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:86
  def stream_value(val, &b); end

  # Returns the value of attribute style.
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:32
  def style; end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:93
  def style_string; end

  private

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:117
  def escape(attrs); end

  class << self
    # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:144
    def closest_color(r, g, b); end

    # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:122
    def color_index(color); end

    # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:127
    def get_rgb(color); end

    # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:37
    def xterm_colors; end
  end
end

# max distance between two colors, #000000 to #ffffff
#
# source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:142
Rouge::Formatters::Terminal256::EscapeSequence::MAX_DISTANCE = T.let(T.unsafe(nil), Integer)

# source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:165
class Rouge::Formatters::Terminal256::Unescape < ::Rouge::Formatters::Terminal256::EscapeSequence
  # @return [Unescape] a new instance of Unescape
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:166
  def initialize(*_arg0); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:168
  def reset_string(*_arg0); end

  # @yield [val]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:169
  def stream_value(val); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal256.rb:167
  def style_string(*_arg0); end
end

# source://rouge-3.30.0/lib/rouge/formatters/terminal_truecolor.rb:5
class Rouge::Formatters::TerminalTruecolor < ::Rouge::Formatters::Terminal256
  # source://rouge-3.30.0/lib/rouge/formatters/terminal_truecolor.rb:32
  def make_escape_sequence(style); end
end

# source://rouge-3.30.0/lib/rouge/formatters/terminal_truecolor.rb:8
class Rouge::Formatters::TerminalTruecolor::TruecolorEscapeSequence < ::Rouge::Formatters::Terminal256::EscapeSequence
  # source://rouge-3.30.0/lib/rouge/formatters/terminal_truecolor.rb:19
  def get_rgb(color); end

  # source://rouge-3.30.0/lib/rouge/formatters/terminal_truecolor.rb:9
  def style_string; end
end

# source://rouge-3.30.0/lib/rouge/formatters/tex.rb:6
class Rouge::Formatters::Tex < ::Rouge::Formatter
  # @return [Tex] a new instance of Tex
  #
  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:33
  def initialize(opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:37
  def escape_tex(str); end

  # Special handling for leading spaces, since they may be gobbled
  # by a previous command.  We replace all initial spaces with
  # \hphantom{xxxx}, which renders an empty space equal to the size
  # of the x's.
  #
  # @yield ["\\hphantom{#{'x' * leading}}"]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:74
  def hphantom_tag(tok, val); end

  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:64
  def render_line(line, &b); end

  # @yield ["\\begin{#{@prefix}*}%\n"]
  #
  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:41
  def stream(tokens, &b); end

  # source://rouge-3.30.0/lib/rouge/formatters/tex.rb:81
  def tag(tok, val); end
end

# A map of TeX escape characters.
# Newlines are handled specially by using #token_lines
# spaces are preserved as long as they aren't at the beginning
# of a line. see #tag_first for our initial-space strategy
#
# source://rouge-3.30.0/lib/rouge/formatters/tex.rb:13
Rouge::Formatters::Tex::ESCAPE = T.let(T.unsafe(nil), Hash)

# source://rouge-3.30.0/lib/rouge/formatters/tex.rb:31
Rouge::Formatters::Tex::ESCAPE_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/guesser.rb:4
class Rouge::Guesser
  # source://rouge-3.30.0/lib/rouge/guesser.rb:33
  def collect_best(lexers, opts = T.unsafe(nil), &scorer); end

  # source://rouge-3.30.0/lib/rouge/guesser.rb:53
  def filter(lexers); end

  class << self
    # source://rouge-3.30.0/lib/rouge/guesser.rb:14
    def guess(guessers, lexers); end
  end
end

# source://rouge-3.30.0/lib/rouge/guesser.rb:5
class Rouge::Guesser::Ambiguous < ::StandardError
  # @return [Ambiguous] a new instance of Ambiguous
  #
  # source://rouge-3.30.0/lib/rouge/guesser.rb:7
  def initialize(alternatives); end

  # Returns the value of attribute alternatives.
  #
  # source://rouge-3.30.0/lib/rouge/guesser.rb:6
  def alternatives; end

  # source://rouge-3.30.0/lib/rouge/guesser.rb:9
  def message; end
end

# source://rouge-3.30.0/lib/rouge/guessers/util.rb:4
module Rouge::Guessers; end

# source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:5
class Rouge::Guessers::Disambiguation < ::Rouge::Guesser
  include ::Rouge::Guessers::Util
  include ::Rouge::Lexers

  # @return [Disambiguation] a new instance of Disambiguation
  #
  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:9
  def initialize(filename, source); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:30
  def contains?(text); end

  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:14
  def filter(lexers); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:34
  def matches?(re); end

  class << self
    # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:39
    def disambiguate(*patterns, &decider); end

    # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:43
    def disambiguators; end
  end
end

# source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:47
class Rouge::Guessers::Disambiguation::Disambiguator
  include ::Rouge::Guessers::Util

  # @return [Disambiguator] a new instance of Disambiguator
  #
  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:50
  def initialize(patterns, &decider); end

  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:55
  def decide!(guesser); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/guessers/disambiguation.rb:64
  def match?(filename); end
end

# source://rouge-3.30.0/lib/rouge/guessers/filename.rb:5
class Rouge::Guessers::Filename < ::Rouge::Guesser
  # @return [Filename] a new instance of Filename
  #
  # source://rouge-3.30.0/lib/rouge/guessers/filename.rb:7
  def initialize(filename); end

  # returns a list of lexers that match the given filename with
  # equal specificity (i.e. number of wildcards in the pattern).
  # This helps disambiguate between, e.g. the Nginx lexer, which
  # matches `nginx.conf`, and the Conf lexer, which matches `*.conf`.
  # In this case, nginx will win because the pattern has no wildcards,
  # while `*.conf` has one.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/filename.rb:17
  def filter(lexers); end

  # Returns the value of attribute fname.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/filename.rb:6
  def fname; end
end

# This class allows for custom behavior
# with glob -> lexer name mappings
#
# source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:7
class Rouge::Guessers::GlobMapping < ::Rouge::Guesser
  include ::Rouge::Guessers::Util

  # @return [GlobMapping] a new instance of GlobMapping
  #
  # source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:26
  def initialize(glob_map, filename); end

  # Returns the value of attribute filename.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:25
  def filename; end

  # source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:31
  def filter(lexers); end

  # Returns the value of attribute glob_map.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:25
  def glob_map; end

  class << self
    # source://rouge-3.30.0/lib/rouge/guessers/glob_mapping.rb:10
    def by_pairs(mapping, filename); end
  end
end

# source://rouge-3.30.0/lib/rouge/guessers/mimetype.rb:5
class Rouge::Guessers::Mimetype < ::Rouge::Guesser
  # @return [Mimetype] a new instance of Mimetype
  #
  # source://rouge-3.30.0/lib/rouge/guessers/mimetype.rb:7
  def initialize(mimetype); end

  # source://rouge-3.30.0/lib/rouge/guessers/mimetype.rb:11
  def filter(lexers); end

  # Returns the value of attribute mimetype.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/mimetype.rb:6
  def mimetype; end
end

# source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:5
class Rouge::Guessers::Modeline < ::Rouge::Guesser
  include ::Rouge::Guessers::Util

  # @return [Modeline] a new instance of Modeline
  #
  # source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:23
  def initialize(source, opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:28
  def filter(lexers); end
end

# [jneen] regexen stolen from linguist
#
# source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:9
Rouge::Guessers::Modeline::EMACS_MODELINE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:21
Rouge::Guessers::Modeline::MODELINES = T.let(T.unsafe(nil), Array)

# First form vim modeline
# [text]{white}{vi:|vim:|ex:}[white]{options}
# ex: 'vim: syntax=ruby'
#
# source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:14
Rouge::Guessers::Modeline::VIM_MODELINE_1 = T.let(T.unsafe(nil), Regexp)

# Second form vim modeline (compatible with some versions of Vi)
# [text]{white}{vi:|vim:|Vim:|ex:}[white]se[t] {options}:[text]
# ex: 'vim set syntax=ruby:'
#
# source://rouge-3.30.0/lib/rouge/guessers/modeline.rb:19
Rouge::Guessers::Modeline::VIM_MODELINE_2 = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/guessers/source.rb:5
class Rouge::Guessers::Source < ::Rouge::Guesser
  include ::Rouge::Guessers::Util

  # @return [Source] a new instance of Source
  #
  # source://rouge-3.30.0/lib/rouge/guessers/source.rb:9
  def initialize(source); end

  # source://rouge-3.30.0/lib/rouge/guessers/source.rb:13
  def filter(lexers); end

  # Returns the value of attribute source.
  #
  # source://rouge-3.30.0/lib/rouge/guessers/source.rb:8
  def source; end
end

# source://rouge-3.30.0/lib/rouge/guessers/util.rb:5
module Rouge::Guessers::Util
  # @param source [String, IO]
  # @return [String]
  #
  # source://rouge-3.30.0/lib/rouge/guessers/util.rb:23
  def get_source(source); end

  # source://rouge-3.30.0/lib/rouge/guessers/util.rb:17
  def test_glob(pattern, path); end
end

# source://rouge-3.30.0/lib/rouge/guessers/util.rb:6
module Rouge::Guessers::Util::SourceNormalizer
  class << self
    # @param source [String, nil]
    # @return [String, nil]
    #
    # source://rouge-3.30.0/lib/rouge/guessers/util.rb:12
    def normalize(source); end
  end
end

# source://rouge-3.30.0/lib/rouge/guessers/util.rb:7
Rouge::Guessers::Util::SourceNormalizer::UTF8_BOM = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/guessers/util.rb:8
Rouge::Guessers::Util::SourceNormalizer::UTF8_BOM_RE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/theme.rb:136
module Rouge::HasModes
  # source://rouge-3.30.0/lib/rouge/theme.rb:144
  def get_mode(mode); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:137
  def mode(arg = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:156
  def mode!(arg); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:151
  def set_mode!(mode); end
end

# shared methods for some indentation-sensitive lexers
#
# source://rouge-3.30.0/lib/rouge/util.rb:68
module Rouge::Indentation
  # handle a single indented line
  #
  # source://rouge-3.30.0/lib/rouge/util.rb:83
  def indentation(indent_str); end

  # source://rouge-3.30.0/lib/rouge/util.rb:69
  def reset!; end

  # push a state for the next indented block
  #
  # source://rouge-3.30.0/lib/rouge/util.rb:75
  def starts_block(block_state); end
end

# source://rouge-3.30.0/lib/rouge/util.rb:5
class Rouge::InheritableHash < ::Hash
  # @return [InheritableHash] a new instance of InheritableHash
  #
  # source://rouge-3.30.0/lib/rouge/util.rb:6
  def initialize(parent = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/util.rb:10
  def [](k); end

  # source://rouge-3.30.0/lib/rouge/util.rb:25
  def each(&b); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/util.rb:21
  def include?(k); end

  # source://rouge-3.30.0/lib/rouge/util.rb:32
  def keys; end

  def own_keys; end

  # source://rouge-3.30.0/lib/rouge/util.rb:17
  def parent; end
end

# source://rouge-3.30.0/lib/rouge/util.rb:39
class Rouge::InheritableList
  include ::Enumerable

  # @return [InheritableList] a new instance of InheritableList
  #
  # source://rouge-3.30.0/lib/rouge/util.rb:42
  def initialize(parent = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/util.rb:61
  def <<(o); end

  # source://rouge-3.30.0/lib/rouge/util.rb:50
  def each(&b); end

  # source://rouge-3.30.0/lib/rouge/util.rb:57
  def own_entries; end

  # source://rouge-3.30.0/lib/rouge/util.rb:46
  def parent; end

  # source://rouge-3.30.0/lib/rouge/util.rb:61
  def push(o); end
end

# cache value in a constant since `__dir__` allocates a new string
# on every call.
#
# source://rouge-3.30.0/lib/rouge.rb:11
Rouge::LIB_DIR = T.let(T.unsafe(nil), String)

# A lexer transforms text into a stream of `[token, chunk]` pairs.
#
# @abstract
#
# source://rouge-3.30.0/lib/rouge/lexer.rb:12
class Rouge::Lexer
  include ::Rouge::Token::Tokens

  # Create a new lexer with the given options.  Individual lexers may
  # specify extra options.  The only current globally accepted option
  # is `:debug`.
  #
  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [Lexer] a new instance of Lexer
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:323
  def initialize(opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:338
  def as_bool(val); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:366
  def as_lexer(val); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:355
  def as_list(val); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:349
  def as_string(val); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:379
  def as_token(val); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:389
  def bool_option(name, &default); end

  # Continue the lex from the the current state without resetting
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:474
  def continue_lex(string, &b); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:415
  def hash_option(name, defaults, &val_cast); end

  # Given a string, yield [token, chunk] pairs.  If no block is given,
  # an enumerator is returned.
  #
  # @note The use of :continue => true has been deprecated. A warning is
  #   issued if run with `$VERBOSE` set to true.
  # @note The use of arbitrary `opts` has never been supported, but we
  #   previously ignored them with no error. We now warn unconditionally.
  # @option opts
  # @param opts [Hash] a customizable set of options
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:451
  def lex(string, opts = T.unsafe(nil), &b); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:403
  def lexer_option(name, &default); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:407
  def list_option(name, &default); end

  # -*- instance methods -*- #
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:313
  def options; end

  # Called after each lex is finished.  The default implementation
  # is a noop.
  #
  # @abstract
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:437
  def reset!; end

  # Yield `[token, chunk]` pairs, given a prepared input stream.  This
  # must be implemented.
  #
  # @abstract
  # @param stream [StringScanner] the stream
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:508
  def stream_tokens(stream, &b); end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:399
  def string_option(name, &default); end

  # delegated to {Lexer.tag}
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:497
  def tag; end

  # source://rouge-3.30.0/lib/rouge/lexer.rb:411
  def token_option(name, &default); end

  # Returns a new lexer with the given options set. Useful for e.g. setting
  # debug flags post hoc, or providing global overrides for certain options
  #
  # source://rouge-3.30.0/lib/rouge/lexer.rb:332
  def with(opts = T.unsafe(nil)); end

  class << self
    # Used to specify alternate names this lexer class may be found by.
    #
    # @example
    #   class Erb < Lexer
    #   tag 'erb'
    #   aliases 'eruby', 'rhtml'
    #   end
    #
    #   Lexer.find('eruby') # => Erb
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:261
    def aliases(*args); end

    # @return a list of all lexers.
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:141
    def all; end

    # @private
    # @raise [EncodingError]
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:295
    def assert_utf8!(str); end

    # In case #continue_lex is called statically, we simply
    # begin a new lex from the beginning, since there is no state.
    #
    # @see #continue_lex
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:30
    def continue_lex(*a, &b); end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:215
    def debug_enabled?; end

    # Specify or get a small demo string for this lexer
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:134
    def demo(arg = T.unsafe(nil)); end

    # Specify or get the path name containing a small demo for
    # this lexer (can be overriden by {demo}).
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:127
    def demo_file(arg = T.unsafe(nil)); end

    # Specify or get this lexer's description.
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:109
    def desc(arg = T.unsafe(nil)); end

    # Return true if there is an in-text indication (such as a shebang
    # or DOCTYPE declaration) that this lexer should be used.
    #
    # @abstract
    # @param text [TextAnalyzer] the text to be analyzed, with a couple of handy methods on it,
    #   like {TextAnalyzer#shebang?} and {TextAnalyzer#doctype?}
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:520
    def detect?(text); end

    # Determine if a lexer has a method named +:detect?+ defined in its
    # singleton class.
    #
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:221
    def detectable?; end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:211
    def disable_debug!; end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:207
    def enable_debug!; end

    # Specify a list of filename globs associated with this lexer.
    #
    # If a filename glob is associated with more than one lexer, this can
    # cause a Guesser::Ambiguous error to be raised in various guessing
    # methods. These errors can be avoided by disambiguation. Filename globs
    # are disambiguated in one of two ways. Either the lexer will define a
    # `self.detect?` method (intended for use with shebangs and doctypes) or a
    # manual rule will be specified in Guessers::Disambiguation.
    #
    # @example
    #   class Ruby < Lexer
    #   filenames '*.rb', '*.ruby', 'Gemfile', 'Rakefile'
    #   end
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:280
    def filenames(*fnames); end

    # Given a name in string, return the correct lexer class.
    #
    # @param name [String]
    # @return [Class<Rouge::Lexer>, nil]
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:37
    def find(name); end

    # Find a lexer, with fancy shiny features.
    #
    # * The string you pass can include CGI-style options
    #
    #     Lexer.find_fancy('erb?parent=tex')
    #
    # * You can pass the special name 'guess' so we guess for you,
    #   and you can pass a second argument of the code to guess by
    #
    #     Lexer.find_fancy('guess', "#!/bin/bash\necho Hello, world")
    #
    #   If the code matches more than one lexer then Guesser::Ambiguous
    #   is raised.
    #
    # This is used in the Redcarpet plugin as well as Rouge's own
    # markdown lexer for highlighting internal code blocks.
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:94
    def find_fancy(str, code = T.unsafe(nil), default_options = T.unsafe(nil)); end

    # Guess which lexer to use based on a hash of info.
    #
    # @option info
    # @option info
    # @option info
    # @param info [Hash] a customizable set of options
    # @param fallback [Proc] called if multiple lexers are detected.
    #   If omitted, Guesser::Ambiguous is raised.
    # @return [Class<Rouge::Lexer>]
    # @see Lexer.detect?
    # @see Lexer.guesses
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:182
    def guess(info = T.unsafe(nil), &fallback); end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:199
    def guess_by_filename(fname); end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:195
    def guess_by_mimetype(mt); end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:203
    def guess_by_source(source); end

    # Guess which lexer to use based on a hash of info.
    #
    # This accepts the same arguments as Lexer.guess, but will never throw
    # an error.  It will return a (possibly empty) list of potential lexers
    # to use.
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:150
    def guesses(info = T.unsafe(nil)); end

    # Lexes `stream` with the given options.  The lex is delegated to a
    # new instance.
    #
    # @see #lex
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:22
    def lex(stream, opts = T.unsafe(nil), &b); end

    # Same as ::find_fancy, except instead of returning an instantiated
    # lexer, returns a pair of [lexer_class, options], so that you can
    # modify or provide additional options to the lexer.
    #
    # Please note: the lexer class might be nil!
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:46
    def lookup_fancy(str, code = T.unsafe(nil), default_options = T.unsafe(nil)); end

    # Specify a list of mimetypes associated with this lexer.
    #
    # @example
    #   class Html < Lexer
    #   mimetypes 'text/html', 'application/xhtml+xml'
    #   end
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:290
    def mimetypes(*mts); end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:121
    def option(name, desc); end

    # source://rouge-3.30.0/lib/rouge/lexer.rb:117
    def option_docs; end

    # Used to specify or get the canonical name of this lexer class.
    #
    # @example
    #   class MyLexer < Lexer
    #   tag 'foo'
    #   end
    #
    #   MyLexer.tag # => 'foo'
    #
    #   Lexer.find('foo') # => MyLexer
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:245
    def tag(t = T.unsafe(nil)); end

    # Specify or get this lexer's title. Meant to be human-readable.
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:101
    def title(t = T.unsafe(nil)); end

    protected

    # @private
    #
    # source://rouge-3.30.0/lib/rouge/lexer.rb:228
    def register(name, lexer); end

    private

    # source://rouge-3.30.0/lib/rouge/lexer.rb:306
    def registry; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexer.rb:525
module Rouge::Lexers
  class << self
    # source://rouge-3.30.0/lib/rouge/lexer.rb:529
    def load_lexer(relpath); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/abap.rb:8
class Rouge::Lexers::ABAP < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/abap.rb:148
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/abap.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/abap.rb:178
    def new_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/abap.rb:171
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/apiblueprint.rb:7
class Rouge::Lexers::APIBlueprint < ::Rouge::Lexers::Markdown; end

# source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:6
class Rouge::Lexers::Actionscript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:100
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:96
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:84
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:76
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/actionscript.rb:88
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ada.rb:6
class Rouge::Lexers::Ada < ::Rouge::RegexLexer
  class << self
    # Return a hash mapping lower-case identifiers to token classes.
    #
    # source://rouge-3.30.0/lib/rouge/lexers/ada.rb:23
    def idents; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ada.rb:20
Rouge::Lexers::Ada::EXP = T.let(T.unsafe(nil), Regexp)

# Ada identifiers are Unicode with underscores only allowed as separators.
#
# source://rouge-3.30.0/lib/rouge/lexers/ada.rb:15
Rouge::Lexers::Ada::ID = T.let(T.unsafe(nil), Regexp)

# Numerals can also contain underscores.
#
# source://rouge-3.30.0/lib/rouge/lexers/ada.rb:18
Rouge::Lexers::Ada::NUM = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/ada.rb:19
Rouge::Lexers::Ada::XNUM = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/apache.rb:7
class Rouge::Lexers::Apache < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/apache.rb:30
  def name_for_token(token, tktype); end

  class << self
    # self-modifying method that loads the keywords file
    #
    # source://rouge-3.30.0/lib/rouge/lexers/apache.rb:15
    def directives; end

    # source://rouge-3.30.0/lib/rouge/lexers/apache.rb:20
    def sections; end

    # source://rouge-3.30.0/lib/rouge/lexers/apache.rb:25
    def values; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/apex.rb:6
class Rouge::Lexers::Apex < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/apex.rb:44
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/apex.rb:22
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/apex.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/apex.rb:30
    def soql; end

    # source://rouge-3.30.0/lib/rouge/lexers/apex.rb:38
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:6
class Rouge::Lexers::AppleScript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:30
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:23
    def classes; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:42
    def commands; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:87
    def controls; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:95
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:35
    def handler_params; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:17
    def literals; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:68
    def operators; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:60
    def references; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:99
    def reserved; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:103
    def studio_classes; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:169
    def studio_commands; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:122
    def studio_events; end

    # source://rouge-3.30.0/lib/rouge/lexers/apple_script.rb:183
    def studio_properties; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:6
class Rouge::Lexers::ArmAsm < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:44
    def builtin; end

    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:18
    def file_directive; end

    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:24
    def general_directive; end

    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:52
    def operator; end

    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:12
    def preproc_keyword; end

    # source://rouge-3.30.0/lib/rouge/lexers/armasm.rb:37
    def shift_or_condition; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/augeas.rb:6
class Rouge::Lexers::Augeas < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/augeas.rb:15
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/awk.rb:6
class Rouge::Lexers::Awk < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:42
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:35
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:27
    def declarations; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:14
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:20
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/awk.rb:31
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexer.rb:526
Rouge::Lexers::BASE_DIR = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:6
class Rouge::Lexers::BBCBASIC < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:45
    def constant; end

    # source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:18
    def function; end

    # source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:39
    def operator; end

    # source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:12
    def punctuation; end

    # source://rouge-3.30.0/lib/rouge/lexers/bbcbasic.rb:28
    def statement; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/biml.rb:7
class Rouge::Lexers::BIML < ::Rouge::Lexers::XML
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/biml.rb:13
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/bpf.rb:6
class Rouge::Lexers::BPF < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/bpf.rb:15
Rouge::Lexers::BPF::MISC_KEYWORDS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/bpf.rb:11
Rouge::Lexers::BPF::TYPE_KEYWORDS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:6
class Rouge::Lexers::Batchfile < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:73
    def attributes; end

    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:35
    def builtin_commands; end

    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:28
    def devices; end

    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:22
    def operator_words; end

    # source://rouge-3.30.0/lib/rouge/lexers/batchfile.rb:48
    def other_commands; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/bibtex.rb:9
class Rouge::Lexers::BibTeX < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/brainfuck.rb:6
class Rouge::Lexers::Brainfuck < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:6
class Rouge::Lexers::Brightscript < ::Rouge::RegexLexer
  class << self
    # Scene graph components configured as builtins. See BrightScript component documentation e.g.
    # https://developer.roku.com/en-ca/docs/references/brightscript/components/roappinfo.md
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:63
    def builtins; end

    # https://developer.roku.com/en-ca/docs/references/brightscript/language/reserved-words.md
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:29
    def keyword_reserved; end

    # These keywords are present in BrightScript, but not supported in standard .brs files
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:40
    def keyword_reserved_unsupported; end

    # https://developer.roku.com/en-ca/docs/references/brightscript/language/expressions-variables-types.md
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:47
    def keyword_type; end

    # https://developer.roku.com/en-ca/docs/references/brightscript/language/global-utility-functions.md
    # https://developer.roku.com/en-ca/docs/references/brightscript/language/global-string-functions.md
    # https://developer.roku.com/en-ca/docs/references/brightscript/language/global-math-functions.md
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:16
    def name_builtin; end

    # https://developer.roku.com/en-ca/docs/references/brightscript/language/expressions-variables-types.md#operators
    #
    # source://rouge-3.30.0/lib/rouge/lexers/brightscript.rb:55
    def operator_word; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/bsl.rb:6
class Rouge::Lexers::Bsl < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/bsl.rb:30
Rouge::Lexers::Bsl::BUILTINS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/bsl.rb:12
Rouge::Lexers::Bsl::KEYWORDS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/c.rb:6
class Rouge::Lexers::C < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/c.rb:59
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/c.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/c.rb:29
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/c.rb:50
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/cmhg.rb:6
class Rouge::Lexers::CMHG < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cmhg.rb:12
    def preproc_keyword; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/cmake.rb:6
class Rouge::Lexers::CMake < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/cmake.rb:14
Rouge::Lexers::CMake::BRACKET_OPEN = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/cmake.rb:24
Rouge::Lexers::CMake::BUILTIN_COMMANDS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/cmake.rb:13
Rouge::Lexers::CMake::SPACE = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/cmake.rb:16
Rouge::Lexers::CMake::STATES_MAP = T.let(T.unsafe(nil), Hash)

# source://rouge-3.30.0/lib/rouge/lexers/css.rb:6
class Rouge::Lexers::CSS < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/css.rb:19
    def attributes; end

    # source://rouge-3.30.0/lib/rouge/lexers/css.rb:120
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/css.rb:151
    def constants; end

    # source: http://www.w3.org/TR/CSS21/syndata.html#vendor-keyword-history
    #
    # source://rouge-3.30.0/lib/rouge/lexers/css.rb:181
    def vendor_prefixes; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/csvs.rb:6
class Rouge::Lexers::CSVS < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/csharp.rb:6
class Rouge::Lexers::CSharp < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/cuda.rb:7
class Rouge::Lexers::CUDA < ::Rouge::Lexers::Cpp
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cuda.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/cuda.rb:21
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ceylon.rb:6
class Rouge::Lexers::Ceylon < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/cfscript.rb:7
class Rouge::Lexers::Cfscript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cfscript.rb:20
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/cfscript.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/cfscript.rb:26
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/clean.rb:6
class Rouge::Lexers::Clean < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/clean.rb:13
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/clojure.rb:6
class Rouge::Lexers::Clojure < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/clojure.rb:70
  def name_token(name); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/clojure.rb:24
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/clojure.rb:17
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:6
class Rouge::Lexers::Coffeescript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:41
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:35
    def constants; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:15
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:19
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/coffeescript.rb:28
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:6
class Rouge::Lexers::CommonLisp < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:201
Rouge::Lexers::CommonLisp::BUILTIN_CLASSES = T.let(T.unsafe(nil), Set)

# 638 functions
#
# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:16
Rouge::Lexers::CommonLisp::BUILTIN_FUNCTIONS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:183
Rouge::Lexers::CommonLisp::BUILTIN_TYPES = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:178
Rouge::Lexers::CommonLisp::DECLARATIONS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:173
Rouge::Lexers::CommonLisp::LAMBDA_LIST_KEYWORDS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:152
Rouge::Lexers::CommonLisp::MACROS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/common_lisp.rb:145
Rouge::Lexers::CommonLisp::SPECIAL_FORMS = T.let(T.unsafe(nil), Set)

# source://rouge-3.30.0/lib/rouge/lexers/conf.rb:6
class Rouge::Lexers::Conf < ::Rouge::RegexLexer; end

# The {ConsoleLexer} class is intended to lex content that represents the
# text that would display in a console/terminal. As distinct from the
# {Shell} lexer, {ConsoleLexer} will try to parse out the prompt from each
# line before passing the remainder of the line to the language lexer for
# the shell (by default, the {Shell} lexer).
#
# The {ConsoleLexer} class accepts five options:
# 1. **lang**: the shell language to lex (default: `shell`);
# 2. **output**: the output language (default: `plaintext?token=Generic.Output`);
# 3. **prompt**: comma-separated list of strings that indicate the end of a
#    prompt (default: `$,#,>,;`);
# 4. **comments**: whether to enable comments.
# 5. **error**: comma-separated list of strings that indicate the start of an
#    error message
#
# The comments option, if enabled, will lex lines that begin with a `#` as a
# comment. Please note that this option will only work if the prompt is
# either not manually specified or, if manually specified, does not include
# the `#` character.
#
# Most Markdown lexers that recognise GitHub-Flavored Markdown syntax, will
# pass the language string to Rouge as written in the original document.
# This allows an end user to pass options to {ConsoleLexer} by passing them
# as CGI-style parameters as in the example below.
#
# <pre>Here's some regular text.
#
# ```console?comments=true
# # This is a comment
# $ cp foo bar
# ```
#
# Some more regular text.</pre>
#
# source://rouge-3.30.0/lib/rouge/lexers/console.rb:40
class Rouge::Lexers::ConsoleLexer < ::Rouge::Lexer
  # @return [ConsoleLexer] a new instance of ConsoleLexer
  #
  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:52
  def initialize(*_arg0); end

  # whether to allow comments. if manually specifying a prompt that isn't
  # simply "#", we flag this to on
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:63
  def allow_comments?; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:72
  def comment_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:76
  def end_chars; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:86
  def error_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:92
  def lang_lexer; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:105
  def line_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:109
  def output_lexer; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:122
  def process_line(input, &output); end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:167
  def prompt_prefix_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:175
  def prompt_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/console.rb:181
  def stream_tokens(input, &output); end
end

# source://rouge-3.30.0/lib/rouge/lexers/coq.rb:6
class Rouge::Lexers::Coq < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:69
    def classify(x); end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:19
    def coq; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:65
    def end_sentence; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:12
    def gallina; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:59
    def keyopts; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:32
    def ltac; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:46
    def tacticals; end

    # source://rouge-3.30.0/lib/rouge/lexers/coq.rb:52
    def terminators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/cpp.rb:8
class Rouge::Lexers::Cpp < ::Rouge::Lexers::C
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cpp.rb:23
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/cpp.rb:37
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/cpp.rb:43
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/crystal.rb:6
class Rouge::Lexers::Crystal < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/crystal.rb:15
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/cypher.rb:6
class Rouge::Lexers::Cypher < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cypher.rb:15
    def functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/cypher.rb:34
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/cypher.rb:28
    def predicates; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/cython.rb:8
class Rouge::Lexers::Cython < ::Rouge::Lexers::Python
  # @return [Cython] a new instance of Cython
  #
  # source://rouge-3.30.0/lib/rouge/lexers/cython.rb:16
  def initialize(opts = T.unsafe(nil)); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/cython.rb:27
    def c_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/cython.rb:21
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/d.rb:6
class Rouge::Lexers::D < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/dafny.rb:6
class Rouge::Lexers::Dafny < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/dart.rb:6
class Rouge::Lexers::Dart < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/datastudio.rb:6
class Rouge::Lexers::Datastudio < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/datastudio.rb:16
    def sql_keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/diff.rb:5
class Rouge::Lexers::Diff < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/diff.rb:14
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/digdag.rb:8
class Rouge::Lexers::Digdag < ::Rouge::Lexers::YAML; end

# http://docs.digdag.io/operators.html
# as of digdag v0.9.10
#
# source://rouge-3.30.0/lib/rouge/lexers/digdag.rb:18
Rouge::Lexers::Digdag::KEYWORD_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/docker.rb:6
class Rouge::Lexers::Docker < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/docker.rb:14
Rouge::Lexers::Docker::KEYWORDS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/dot.rb:6
class Rouge::Lexers::Dot < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:6
class Rouge::Lexers::ECL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:16
    def class_first; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:22
    def class_second; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:28
    def functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:51
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:71
    def template; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:81
    def type; end

    # source://rouge-3.30.0/lib/rouge/lexers/ecl.rb:89
    def typed; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/eex.rb:5
class Rouge::Lexers::EEX < ::Rouge::TemplateLexer
  # @return [EEX] a new instance of EEX
  #
  # source://rouge-3.30.0/lib/rouge/lexers/eex.rb:14
  def initialize(opts = T.unsafe(nil)); end
end

# source://rouge-3.30.0/lib/rouge/lexers/epp.rb:5
class Rouge::Lexers::EPP < ::Rouge::TemplateLexer
  # @return [EPP] a new instance of EPP
  #
  # source://rouge-3.30.0/lib/rouge/lexers/epp.rb:13
  def initialize(opts = T.unsafe(nil)); end
end

# source://rouge-3.30.0/lib/rouge/lexers/erb.rb:6
class Rouge::Lexers::ERB < ::Rouge::TemplateLexer
  # @return [ERB] a new instance of ERB
  #
  # source://rouge-3.30.0/lib/rouge/lexers/erb.rb:15
  def initialize(opts = T.unsafe(nil)); end
end

# source://rouge-3.30.0/lib/rouge/lexers/eiffel.rb:6
class Rouge::Lexers::Eiffel < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/eiffel.rb:23
Rouge::Lexers::Eiffel::BooleanConstants = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/eiffel.rb:14
Rouge::Lexers::Eiffel::LanguageKeywords = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/eiffel.rb:25
Rouge::Lexers::Eiffel::LanguageVariables = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/eiffel.rb:27
Rouge::Lexers::Eiffel::SimpleString = T.let(T.unsafe(nil), Regexp)

# Direct port of pygments Lexer.
# See: https://bitbucket.org/birkenfeld/pygments-main/src/7304e4759ae65343d89a51359ca538912519cc31/pygments/lexers/functional.py?at=default#cl-2362
#
# source://rouge-3.30.0/lib/rouge/lexers/elixir.rb:8
class Rouge::Lexers::Elixir < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/elm.rb:6
class Rouge::Lexers::Elm < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/email.rb:6
class Rouge::Lexers::Email < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/erlang.rb:6
class Rouge::Lexers::Erlang < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/escape.rb:6
class Rouge::Lexers::Escape < ::Rouge::Lexer
  # @return [Escape] a new instance of Escape
  #
  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:20
  def initialize(*_arg0); end

  # Returns the value of attribute end.
  #
  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:17
  def end; end

  # Returns the value of attribute lang.
  #
  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:18
  def lang; end

  # Returns the value of attribute start.
  #
  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:16
  def start; end

  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:35
  def stream_tokens(str, &b); end

  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:31
  def to_end_regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/escape.rb:27
  def to_start_regex; end
end

# source://rouge-3.30.0/lib/rouge/lexers/fsharp.rb:6
class Rouge::Lexers::FSharp < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/fsharp.rb:29
    def keyopts; end

    # source://rouge-3.30.0/lib/rouge/lexers/fsharp.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/fsharp.rb:40
    def primitives; end

    # source://rouge-3.30.0/lib/rouge/lexers/fsharp.rb:36
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/factor.rb:6
class Rouge::Lexers::Factor < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/factor.rb:17
    def builtins; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/factor.rb:13
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/fluent.rb:6
class Rouge::Lexers::Fluent < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/fortran.rb:10
class Rouge::Lexers::Fortran < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/fortran.rb:53
    def intrinsics; end

    # source://rouge-3.30.0/lib/rouge/lexers/fortran.rb:23
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/fortran.rb:45
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:8
class Rouge::Lexers::FreeFEM < ::Rouge::Lexers::Cpp
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:170
    def attributes; end

    # source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:56
    def builtins; end

    # Override C/C++ ones (for example, `do` does not exists)
    #
    # source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:18
    def keywords; end

    # Override C/C++ ones (for example, `double` does not exists)
    #
    # source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:25
    def keywords_type; end

    # Override C/C++ ones (totally different)
    #
    # source://rouge-3.30.0/lib/rouge/lexers/freefem.rb:34
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/gdscript.rb:6
class Rouge::Lexers::GDScript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/gdscript.rb:30
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/gdscript.rb:43
    def builtins_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/gdscript.rb:14
    def keywords; end

    # Reserved for future implementation
    #
    # source://rouge-3.30.0/lib/rouge/lexers/gdscript.rb:24
    def keywords_reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ghc_cmm.rb:15
class Rouge::Lexers::GHCCmm < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/ghc_core.rb:8
class Rouge::Lexers::GHCCore < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/gherkin.rb:6
class Rouge::Lexers::Gherkin < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/gherkin.rb:16
    def detect?(text); end

    # self-modifying method that loads the keywords file
    #
    # source://rouge-3.30.0/lib/rouge/lexers/gherkin.rb:21
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/gherkin.rb:26
    def step_regex; end
  end
end

# This file defines the GLSL language lexer to the Rouge
# syntax highlighter.
#
# Author: Sri Harsha Chilakapati
#
# source://rouge-3.30.0/lib/rouge/lexers/glsl.rb:12
class Rouge::Lexers::Glsl < ::Rouge::Lexers::C
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/glsl.rb:87
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/glsl.rb:20
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/glsl.rb:35
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/glsl.rb:61
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:6
class Rouge::Lexers::Go < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:96
Rouge::Lexers::Go::BIG_U_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:102
Rouge::Lexers::Go::BYTE_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:103
Rouge::Lexers::Go::CHAR_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:35
Rouge::Lexers::Go::COMMENT = T.let(T.unsafe(nil), Regexp)

# Floating-point literals
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:81
Rouge::Lexers::Go::DECIMALS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:27
Rouge::Lexers::Go::DECIMAL_DIGIT = T.let(T.unsafe(nil), Regexp)

# Integer literals
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:74
Rouge::Lexers::Go::DECIMAL_LIT = T.let(T.unsafe(nil), Regexp)

# Rune literals
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:94
Rouge::Lexers::Go::ESCAPED_CHAR = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:104
Rouge::Lexers::Go::ESCAPE_SEQUENCE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:82
Rouge::Lexers::Go::EXPONENT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:83
Rouge::Lexers::Go::FLOAT_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:34
Rouge::Lexers::Go::GENERAL_COMMENT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:101
Rouge::Lexers::Go::HEX_BYTE_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:29
Rouge::Lexers::Go::HEX_DIGIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:76
Rouge::Lexers::Go::HEX_LIT = T.let(T.unsafe(nil), Regexp)

# Identifiers
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:53
Rouge::Lexers::Go::IDENTIFIER = T.let(T.unsafe(nil), Regexp)

# Imaginary literals
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:90
Rouge::Lexers::Go::IMAGINARY_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:113
Rouge::Lexers::Go::INTERPRETED_STRING_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:77
Rouge::Lexers::Go::INT_LIT = T.let(T.unsafe(nil), Regexp)

# Keywords
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:39
Rouge::Lexers::Go::KEYWORD = T.let(T.unsafe(nil), Regexp)

# Letters and digits
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:26
Rouge::Lexers::Go::LETTER = T.let(T.unsafe(nil), Regexp)

# Comments
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:33
Rouge::Lexers::Go::LINE_COMMENT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:95
Rouge::Lexers::Go::LITTLE_U_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:19
Rouge::Lexers::Go::NEWLINE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:100
Rouge::Lexers::Go::OCTAL_BYTE_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:28
Rouge::Lexers::Go::OCTAL_DIGIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:75
Rouge::Lexers::Go::OCTAL_LIT = T.let(T.unsafe(nil), Regexp)

# Operators and delimiters
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:58
Rouge::Lexers::Go::OPERATOR = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:130
Rouge::Lexers::Go::PREDECLARED_CONSTANTS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:132
Rouge::Lexers::Go::PREDECLARED_FUNCTIONS = T.let(T.unsafe(nil), Regexp)

# Predeclared identifiers
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:120
Rouge::Lexers::Go::PREDECLARED_TYPES = T.let(T.unsafe(nil), Regexp)

# String literals
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:112
Rouge::Lexers::Go::RAW_STRING_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:68
Rouge::Lexers::Go::SEPARATOR = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:116
Rouge::Lexers::Go::STRING_LIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:20
Rouge::Lexers::Go::UNICODE_CHAR = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:22
Rouge::Lexers::Go::UNICODE_DIGIT = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:21
Rouge::Lexers::Go::UNICODE_LETTER = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/go.rb:97
Rouge::Lexers::Go::UNICODE_VALUE = T.let(T.unsafe(nil), Regexp)

# Characters
#
# source://rouge-3.30.0/lib/rouge/lexers/go.rb:17
Rouge::Lexers::Go::WHITE_SPACE = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/gradle.rb:8
class Rouge::Lexers::Gradle < ::Rouge::Lexers::Groovy
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/gradle.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/gradle.rb:23
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/graphql.rb:6
class Rouge::Lexers::GraphQL < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:6
class Rouge::Lexers::Groovy < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:38
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:24
    def declarations; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:13
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:17
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/groovy.rb:32
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/hlsl.rb:8
class Rouge::Lexers::HLSL < ::Rouge::Lexers::C
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/hlsl.rb:74
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/hlsl.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/hlsl.rb:28
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/hlsl.rb:65
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/hocon.rb:8
class Rouge::Lexers::HOCON < ::Rouge::Lexers::JSON; end

# source://rouge-3.30.0/lib/rouge/lexers/hql.rb:7
class Rouge::Lexers::HQL < ::Rouge::Lexers::SQL
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/hql.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/hql.rb:101
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/html.rb:6
class Rouge::Lexers::HTML < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/html.rb:13
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/http.rb:6
class Rouge::Lexers::HTTP < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/http.rb:17
  def content_lexer; end

  # source://rouge-3.30.0/lib/rouge/lexers/http.rb:21
  def guess_content_lexer; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/http.rb:13
    def http_methods; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/hack.rb:8
class Rouge::Lexers::Hack < ::Rouge::Lexers::PHP
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/hack.rb:15
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/hack.rb:24
    def keywords; end
  end
end

# A lexer for the Haml templating system for Ruby.
#
# @see http://haml.info
#
# source://rouge-3.30.0/lib/rouge/lexers/haml.rb:8
class Rouge::Lexers::Haml < ::Rouge::RegexLexer
  include ::Rouge::Indentation

  # @option opts
  # @param opts [Hash] a customizable set of options
  # @return [Haml] a new instance of Haml
  #
  # source://rouge-3.30.0/lib/rouge/lexers/haml.rb:26
  def initialize(opts = T.unsafe(nil)); end

  # Returns the value of attribute filters.
  #
  # source://rouge-3.30.0/lib/rouge/lexers/haml.rb:21
  def filters; end

  # source://rouge-3.30.0/lib/rouge/lexers/haml.rb:50
  def html; end

  # source://rouge-3.30.0/lib/rouge/lexers/haml.rb:46
  def ruby; end

  # source://rouge-3.30.0/lib/rouge/lexers/haml.rb:54
  def ruby!(state); end
end

# source://rouge-3.30.0/lib/rouge/lexers/handlebars.rb:6
class Rouge::Lexers::Handlebars < ::Rouge::TemplateLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/haskell.rb:6
class Rouge::Lexers::Haskell < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/haskell.rb:15
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:5
class Rouge::Lexers::Haxe < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:49
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:45
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:32
    def declarations; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:14
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:26
    def imports; end

    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/haxe.rb:39
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:6
class Rouge::Lexers::Hcl < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:55
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:51
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:43
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:39
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/hcl.rb:47
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/hylang.rb:6
class Rouge::Lexers::HyLang < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/hylang.rb:50
  def name_token(name); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/hylang.rb:25
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/hylang.rb:17
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:8
class Rouge::Lexers::IDLang < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:52
    def conditionals; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:39
    def decorators; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:19
    def exec_unit; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:25
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:46
    def operators; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:60
    def routines; end

    # source://rouge-3.30.0/lib/rouge/lexers/idlang.rb:32
    def standalone_statements; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ini.rb:6
class Rouge::Lexers::INI < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/io.rb:6
class Rouge::Lexers::IO < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/io.rb:21
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/io.rb:17
    def constants; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/io.rb:13
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/irb.rb:8
class Rouge::Lexers::IRBLexer < ::Rouge::Lexers::ConsoleLexer
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/irb.rb:29
  def allow_comments?; end

  # source://rouge-3.30.0/lib/rouge/lexers/irb.rb:21
  def lang_lexer; end

  # source://rouge-3.30.0/lib/rouge/lexers/irb.rb:17
  def output_lexer; end

  # source://rouge-3.30.0/lib/rouge/lexers/irb.rb:25
  def prompt_regex; end
end

# source://rouge-3.30.0/lib/rouge/lexers/irb.rb:35
class Rouge::Lexers::IRBOutputLexer < ::Rouge::Lexers::Ruby; end

# source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:6
class Rouge::Lexers::ISBL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:12
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:17
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:25
    def globals; end

    # source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:21
    def interfaces; end

    # source://rouge-3.30.0/lib/rouge/lexers/isbl.rb:29
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/idris.rb:6
class Rouge::Lexers::Idris < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/idris.rb:23
    def ascii; end

    # source://rouge-3.30.0/lib/rouge/lexers/idris.rb:30
    def prelude_functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/idris.rb:15
    def reserved_keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:6
class Rouge::Lexers::IgorPro < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:44
    def igorConstants; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:36
    def igorDeclarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:50
    def igorFunction; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:322
    def igorOperation; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:509
    def object_name; end

    # source://rouge-3.30.0/lib/rouge/lexers/igorpro.rb:28
    def preprocessor; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:7
class Rouge::Lexers::Isabelle < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:127
    def keyword_abandon_proof; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:29
    def keyword_diag; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:15
    def keyword_minor; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:150
    def keyword_proof_asm; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:154
    def keyword_proof_asm_goal; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:135
    def keyword_proof_block; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:139
    def keyword_proof_chain; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:143
    def keyword_proof_decl; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:131
    def keyword_proof_goal; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:158
    def keyword_proof_script; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:123
    def keyword_qed; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:57
    def keyword_section; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:61
    def keyword_subsection; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:65
    def keyword_theory_decl; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:109
    def keyword_theory_goal; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:105
    def keyword_theory_script; end

    # source://rouge-3.30.0/lib/rouge/lexers/isabelle.rb:53
    def keyword_thy; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/j.rb:6
class Rouge::Lexers::J < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:77
    def control_words; end

    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:84
    def control_words_id; end

    # https://code.jsoftware.com/wiki/NuVoc
    #
    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:30
    def inflection_list; end

    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:72
    def primitive(char, inflection); end

    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:34
    def primitive_table; end

    # https://code.jsoftware.com/wiki/Vocabulary/PartsOfSpeech
    #
    # source://rouge-3.30.0/lib/rouge/lexers/j.rb:17
    def token_map; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/jsl.rb:6
class Rouge::Lexers::JSL < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/json.rb:6
class Rouge::Lexers::JSON < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/json_doc.rb:8
class Rouge::Lexers::JSONDOC < ::Rouge::Lexers::JSON; end

# source://rouge-3.30.0/lib/rouge/lexers/jsp.rb:6
class Rouge::Lexers::JSP < ::Rouge::TemplateLexer
  # @return [JSP] a new instance of JSP
  #
  # source://rouge-3.30.0/lib/rouge/lexers/jsp.rb:12
  def initialize(*_arg0); end
end

# source://rouge-3.30.0/lib/rouge/lexers/jsx.rb:7
class Rouge::Lexers::JSX < ::Rouge::Lexers::Javascript; end

# source://rouge-3.30.0/lib/rouge/lexers/janet.rb:6
class Rouge::Lexers::Janet < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/janet.rb:107
  def name_token(name); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/janet.rb:23
    def bundled; end

    # source://rouge-3.30.0/lib/rouge/lexers/janet.rb:17
    def specials; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/java.rb:6
class Rouge::Lexers::Java < ::Rouge::RegexLexer; end

# IMPORTANT NOTICE:
#
# Please do not copy this lexer and open a pull request
# for a new language. It will not get merged, you will
# be unhappy, and kittens will cry.
#
# source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:12
class Rouge::Lexers::Javascript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:127
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:123
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:109
    def declarations; end

    # Pseudo-documentation: https://stackoverflow.com/questions/1661197/what-characters-are-valid-for-javascript-variable-names
    #
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:24
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:142
    def id_regex; end

    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:101
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/javascript.rb:116
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/jinja.rb:6
class Rouge::Lexers::Jinja < ::Rouge::TemplateLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/jinja.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/jinja.rb:30
    def pseudo_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/jinja.rb:24
    def tests; end

    # source://rouge-3.30.0/lib/rouge/lexers/jinja.rb:34
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/jsonnet.rb:6
class Rouge::Lexers::Jsonnet < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/jsonnet.rb:32
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/jsonnet.rb:26
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/jsonnet.rb:20
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/jsonnet.rb:13
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:6
class Rouge::Lexers::Julia < ::Rouge::RegexLexer
  class << self
    # Documentation: https://docs.julialang.org/en/v1/manual/variables/#Allowed-Variable-Names-1
    #
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/julia.rb:16
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:20
Rouge::Lexers::Julia::BUILTINS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:30
Rouge::Lexers::Julia::KEYWORDS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:170
Rouge::Lexers::Julia::OPERATORS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:184
Rouge::Lexers::Julia::PUNCTUATION = T.let(T.unsafe(nil), Regexp)

# NOTE: The list of types was generated automatically using the following script:
# using Pkg, InteractiveUtils
#
# allnames = [names(Core); names(Base, imported=true)]
#
# for stdlib in readdir(Pkg.Types.stdlib_dir())
#     mod = Symbol(basename(stdlib))
#     @eval begin
#         using $mod
#         append!(allnames, names($mod))
#     end
# end
#
# sort!(unique!(allnames))
#
# i = 1
# for sym in allnames
#     global i # needed at the top level, e.g. in the REPL
#     isdefined(Main, sym) || continue
#     getfield(which(Main, sym), sym) isa Type || continue
#     sym === :(=>) && continue # Actually an alias for Pair
#     print("| ", sym)
#     i % 3 == 0 ? println() : print(" ") # print 3 to a line
#     i += 1
# end
#
# source://rouge-3.30.0/lib/rouge/lexers/julia.rb:65
Rouge::Lexers::Julia::TYPES = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/kotlin.rb:7
class Rouge::Lexers::Kotlin < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/llvm.rb:6
class Rouge::Lexers::LLVM < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/llvm.rb:22
    def instructions; end

    # source://rouge-3.30.0/lib/rouge/lexers/llvm.rb:17
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/llvm.rb:27
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/lasso.rb:8
class Rouge::Lexers::Lasso < ::Rouge::TemplateLexer
  # @return [Lasso] a new instance of Lasso
  #
  # source://rouge-3.30.0/lib/rouge/lexers/lasso.rb:23
  def initialize(*_arg0); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/lasso.rb:29
  def start_inline?; end

  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/lasso.rb:18
    def detect?(text); end

    # self-modifying method that loads the keywords file
    #
    # source://rouge-3.30.0/lib/rouge/lexers/lasso.rb:38
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/lean.rb:7
class Rouge::Lexers::Lean < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/lean.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/lean.rb:103
    def operators; end

    # source://rouge-3.30.0/lib/rouge/lexers/lean.rb:95
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/liquid.rb:6
class Rouge::Lexers::Liquid < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/literate_coffeescript.rb:6
class Rouge::Lexers::LiterateCoffeescript < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/literate_coffeescript.rb:17
  def coffee; end

  # source://rouge-3.30.0/lib/rouge/lexers/literate_coffeescript.rb:13
  def markdown; end
end

# source://rouge-3.30.0/lib/rouge/lexers/literate_haskell.rb:6
class Rouge::Lexers::LiterateHaskell < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/literate_haskell.rb:14
  def haskell; end
end

# source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:6
class Rouge::Lexers::Livescript < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:36
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:32
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:19
    def declarations; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:15
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:23
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/livescript.rb:40
    def loop_control_keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/lua.rb:6
class Rouge::Lexers::Lua < ::Rouge::RegexLexer
  # @return [Lua] a new instance of Lua
  #
  # source://rouge-3.30.0/lib/rouge/lexers/lua.rb:17
  def initialize(opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/lexers/lua.rb:32
  def builtins; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/lua.rb:27
    def builtins; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/lua.rb:23
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/lustre.rb:6
class Rouge::Lexers::Lustre < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/lustre.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/lustre.rb:27
    def primitives; end

    # source://rouge-3.30.0/lib/rouge/lexers/lustre.rb:21
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/lutin.rb:9
class Rouge::Lexers::Lutin < ::Rouge::Lexers::Lustre
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/lutin.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/lutin.rb:28
    def primitives; end

    # source://rouge-3.30.0/lib/rouge/lexers/lutin.rb:23
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/m68k.rb:6
class Rouge::Lexers::M68k < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/m68k.rb:69
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/m68k.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/m68k.rb:47
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/m68k.rb:53
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/mxml.rb:6
class Rouge::Lexers::MXML < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/magik.rb:6
class Rouge::Lexers::Magik < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:63
    def character; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:56
    def decimal; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:47
    def digits; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:53
    def exponent; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:82
    def global_ref; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:73
    def identifier; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:85
    def label; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:59
    def number; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:76
    def package_identifier; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:70
    def piped_identifier; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:50
    def radix; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:67
    def simple_identifier; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:40
    def string_double; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:43
    def string_single; end

    # source://rouge-3.30.0/lib/rouge/lexers/magik.rb:79
    def symbol; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/make.rb:6
class Rouge::Lexers::Make < ::Rouge::RegexLexer
  # TODO: Add support for special keywords
  # bsd_special = %w(
  #   include undef error warning if else elif endif for endfor
  # )
  #
  # @return [Make] a new instance of Make
  #
  # source://rouge-3.30.0/lib/rouge/lexers/make.rb:28
  def initialize(opts = T.unsafe(nil)); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/make.rb:14
    def functions; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/markdown.rb:6
class Rouge::Lexers::Markdown < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/markdown.rb:15
  def html; end
end

# source://rouge-3.30.0/lib/rouge/lexers/mason.rb:6
class Rouge::Lexers::Mason < ::Rouge::TemplateLexer
  # @return [Mason] a new instance of Mason
  #
  # source://rouge-3.30.0/lib/rouge/lexers/mason.rb:13
  def initialize(*_arg0); end
end

# source://rouge-3.30.0/lib/rouge/lexers/mason.rb:21
Rouge::Lexers::Mason::COMPONENTS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/mason.rb:20
Rouge::Lexers::Mason::PERL_BLOCKS = T.let(T.unsafe(nil), Array)

# Note: If you add a tag in the lines below, you also need to modify "disambiguate '*.m'" in file disambiguation.rb
#
# source://rouge-3.30.0/lib/rouge/lexers/mason.rb:19
Rouge::Lexers::Mason::TEXT_BLOCKS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/mathematica.rb:6
class Rouge::Lexers::Mathematica < ::Rouge::RegexLexer
  class << self
    # The list of built-in symbols comes from a wolfram server and is created automatically by rake
    #
    # source://rouge-3.30.0/lib/rouge/lexers/mathematica.rb:58
    def builtins; end

    # Although Module, With and Block are normal built-in symbols, we give them a special treatment as they are
    # the most important expressions for defining local variables
    #
    # source://rouge-3.30.0/lib/rouge/lexers/mathematica.rb:51
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/matlab.rb:6
class Rouge::Lexers::Matlab < ::Rouge::RegexLexer
  class << self
    # self-modifying method that loads the builtins file
    #
    # source://rouge-3.30.0/lib/rouge/lexers/matlab.rb:23
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/matlab.rb:14
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/meson.rb:6
class Rouge::Lexers::Meson < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:43
  def current_string; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:26
    def builtin_functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:20
    def builtin_variables; end

    # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:13
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/meson.rb:138
class Rouge::Lexers::Meson::StringRegister < ::Array
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:139
  def delim?(delim); end

  # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:143
  def register(type: T.unsafe(nil), delim: T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:147
  def remove; end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/meson.rb:151
  def type?(type); end
end

# source://rouge-3.30.0/lib/rouge/lexers/minizinc.rb:9
class Rouge::Lexers::MiniZinc < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/minizinc.rb:16
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/minizinc.rb:28
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/minizinc.rb:36
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/minizinc.rb:42
    def operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/moonscript.rb:8
class Rouge::Lexers::Moonscript < ::Rouge::RegexLexer
  # @return [Moonscript] a new instance of Moonscript
  #
  # source://rouge-3.30.0/lib/rouge/lexers/moonscript.rb:19
  def initialize(*_arg0); end

  # source://rouge-3.30.0/lib/rouge/lexers/moonscript.rb:30
  def builtins; end

  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/moonscript.rb:26
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/mosel.rb:6
class Rouge::Lexers::Mosel < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/mosel.rb:16
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/msgtrans.rb:6
class Rouge::Lexers::MsgTrans < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/nasm.rb:8
class Rouge::Lexers::Nasm < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/nesasm.rb:6
class Rouge::Lexers::NesAsm < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/nesasm.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/nesasm.rb:28
    def keywords_reserved; end

    # source://rouge-3.30.0/lib/rouge/lexers/nesasm.rb:22
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/nginx.rb:6
class Rouge::Lexers::Nginx < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/nial.rb:6
class Rouge::Lexers::Nial < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:110
    def consts; end

    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:44
    def funcs; end

    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:12
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:21
    def operators; end

    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:26
    def punctuations; end

    # source://rouge-3.30.0/lib/rouge/lexers/nial.rb:30
    def transformers; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:7
class Rouge::Lexers::Nim < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/nim.rb:40
    def underscorize(words); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:15
Rouge::Lexers::Nim::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:36
Rouge::Lexers::Nim::NAMESPACE = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:23
Rouge::Lexers::Nim::OPWORDS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:27
Rouge::Lexers::Nim::PSEUDOKEYWORDS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/nim.rb:31
Rouge::Lexers::Nim::TYPES = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/nix.rb:6
class Rouge::Lexers::Nix < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:3
class Rouge::Lexers::OCL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:25
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:37
    def functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:11
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:18
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocl.rb:31
    def operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ocaml.rb:8
class Rouge::Lexers::OCaml < ::Rouge::Lexers::OCamlCommon
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/ocaml.rb:15
    def keywords; end
  end
end

# shared states with Reasonml and ReScript
#
# source://rouge-3.30.0/lib/rouge/lexers/ocaml/common.rb:7
class Rouge::Lexers::OCamlCommon < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/ocaml/common.rb:8
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocaml/common.rb:22
    def primitives; end

    # source://rouge-3.30.0/lib/rouge/lexers/ocaml/common.rb:18
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/objective_c.rb:9
class Rouge::Lexers::ObjectiveC < ::Rouge::Lexers::C
  extend ::Rouge::Lexers::ObjectiveCCommon
end

# source://rouge-3.30.0/lib/rouge/lexers/objective_c/common.rb:6
module Rouge::Lexers::ObjectiveCCommon
  # source://rouge-3.30.0/lib/rouge/lexers/objective_c/common.rb:17
  def at_builtins; end

  # source://rouge-3.30.0/lib/rouge/lexers/objective_c/common.rb:9
  def at_keywords; end

  # source://rouge-3.30.0/lib/rouge/lexers/objective_c/common.rb:21
  def builtins; end

  class << self
    # @private
    #
    # source://rouge-3.30.0/lib/rouge/lexers/objective_c/common.rb:25
    def extended(base); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/objective_cpp.rb:9
class Rouge::Lexers::ObjectiveCpp < ::Rouge::Lexers::Cpp
  extend ::Rouge::Lexers::ObjectiveCCommon
end

# source://rouge-3.30.0/lib/rouge/lexers/openedge.rb:6
class Rouge::Lexers::OpenEdge < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/openedge.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/openedge.rb:351
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/opentype_feature_file.rb:6
class Rouge::Lexers::OpenTypeFeatureFile < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/opentype_feature_file.rb:13
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/php.rb:6
class Rouge::Lexers::PHP < ::Rouge::TemplateLexer
  # @return [PHP] a new instance of PHP
  #
  # source://rouge-3.30.0/lib/rouge/lexers/php.rb:21
  def initialize(*_arg0); end

  # source://rouge-3.30.0/lib/rouge/lexers/php.rb:56
  def builtins; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/php.rb:51
    def builtins; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/php.rb:31
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/php.rb:37
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/plsql.rb:6
class Rouge::Lexers::PLSQL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/plsql.rb:33
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/plsql.rb:392
    def keywords_func; end

    # source://rouge-3.30.0/lib/rouge/lexers/plsql.rb:13
    def keywords_reserved; end

    # source://rouge-3.30.0/lib/rouge/lexers/plsql.rb:434
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/pascal.rb:6
class Rouge::Lexers::Pascal < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/perl.rb:6
class Rouge::Lexers::Perl < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/perl.rb:16
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/plain_text.rb:6
class Rouge::Lexers::PlainText < ::Rouge::Lexer
  # @return [PlainText] a new instance of PlainText
  #
  # source://rouge-3.30.0/lib/rouge/lexers/plain_text.rb:16
  def initialize(*_arg0); end

  # @yield [self.token, string]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/plain_text.rb:22
  def stream_tokens(string, &b); end

  # Returns the value of attribute token.
  #
  # source://rouge-3.30.0/lib/rouge/lexers/plain_text.rb:15
  def token; end
end

# source://rouge-3.30.0/lib/rouge/lexers/plist.rb:5
class Rouge::Lexers::Plist < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/pony.rb:6
class Rouge::Lexers::Pony < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/postscript.rb:7
class Rouge::Lexers::PostScript < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/postscript.rb:15
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:7
class Rouge::Lexers::Powershell < ::Rouge::RegexLexer; end

# https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_functions_cmdletbindingattribute?view=powershell-6
#
# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:16
Rouge::Lexers::Powershell::ATTRIBUTES = T.let(T.unsafe(nil), Array)

# https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_automatic_variables?view=powershell-6
#
# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:22
Rouge::Lexers::Powershell::AUTO_VARS = T.let(T.unsafe(nil), String)

# https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_reserved_words?view=powershell-6
#
# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:36
Rouge::Lexers::Powershell::KEYWORDS = T.let(T.unsafe(nil), String)

# https://devblogs.microsoft.com/scripting/powertip-find-a-list-of-powershell-type-accelerators/
# ([PSObject].Assembly.GetType("System.Management.Automation.TypeAccelerators")::Get).Keys -join ' '
#
# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:46
Rouge::Lexers::Powershell::KEYWORDS_TYPE = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:74
Rouge::Lexers::Powershell::MULTILINE_KEYWORDS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/powershell.rb:65
Rouge::Lexers::Powershell::OPERATORS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/praat.rb:6
class Rouge::Lexers::Praat < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/praat.rb:14
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/prolog.rb:6
class Rouge::Lexers::Prolog < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/prometheus.rb:5
class Rouge::Lexers::Prometheus < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/prometheus.rb:13
    def functions; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/properties.rb:6
class Rouge::Lexers::Properties < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/protobuf.rb:6
class Rouge::Lexers::Protobuf < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/puppet.rb:6
class Rouge::Lexers::Puppet < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/puppet.rb:25
    def constants; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/puppet.rb:13
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/puppet.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/puppet.rb:31
    def metaparameters; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/python.rb:6
class Rouge::Lexers::Python < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/python.rb:73
  def current_string; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/python.rb:28
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/python.rb:42
    def builtins_pseudo; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/python.rb:15
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/python.rb:46
    def exceptions; end

    # source://rouge-3.30.0/lib/rouge/lexers/python.rb:19
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/python.rb:230
class Rouge::Lexers::Python::StringRegister < ::Array
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/python.rb:231
  def delim?(delim); end

  # source://rouge-3.30.0/lib/rouge/lexers/python.rb:235
  def register(type: T.unsafe(nil), delim: T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/lexers/python.rb:239
  def remove; end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/python.rb:243
  def type?(type); end
end

# source://rouge-3.30.0/lib/rouge/lexers/q.rb:5
class Rouge::Lexers::Q < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/q.rb:27
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/q.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/q.rb:19
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/qml.rb:8
class Rouge::Lexers::Qml < ::Rouge::Lexers::Javascript; end

# source://rouge-3.30.0/lib/rouge/lexers/r.rb:6
class Rouge::Lexers::R < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/r.rb:47
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/r.rb:23
Rouge::Lexers::R::BUILTIN_CONSTANTS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/r.rb:16
Rouge::Lexers::R::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/r.rb:18
Rouge::Lexers::R::KEYWORD_CONSTANTS = T.let(T.unsafe(nil), Array)

# These are all the functions in `base` that are implemented as a
# `.Primitive`, minus those functions that are also keywords.
#
# source://rouge-3.30.0/lib/rouge/lexers/r.rb:27
Rouge::Lexers::R::PRIMITIVE_FUNCTIONS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/racket.rb:6
class Rouge::Lexers::Racket < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/racket.rb:65
    def builtins; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/racket.rb:14
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/racket.rb:21
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/rescript.rb:8
class Rouge::Lexers::ReScript < ::Rouge::Lexers::OCamlCommon
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/rescript.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/rescript.rb:23
    def types; end

    # source://rouge-3.30.0/lib/rouge/lexers/rescript.rb:30
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/reasonml.rb:8
class Rouge::Lexers::ReasonML < ::Rouge::Lexers::OCamlCommon
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/reasonml.rb:15
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/rego.rb:6
class Rouge::Lexers::Rego < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/rego.rb:12
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/rego.rb:18
    def operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/robot_framework.rb:6
class Rouge::Lexers::RobotFramework < ::Rouge::RegexLexer
  # @return [RobotFramework] a new instance of RobotFramework
  #
  # source://rouge-3.30.0/lib/rouge/lexers/robot_framework.rb:16
  def initialize(opts = T.unsafe(nil)); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/robot_framework.rb:31
    def settings_with_args; end

    # source://rouge-3.30.0/lib/rouge/lexers/robot_framework.rb:23
    def settings_with_keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ruby.rb:6
class Rouge::Lexers::Ruby < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/ruby.rb:18
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/rust.rb:6
class Rouge::Lexers::Rust < ::Rouge::RegexLexer
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/rust.rb:52
  def macro_closed?; end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/rust.rb:35
    def builtins; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/rust.rb:19
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/rust.rb:23
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sas.rb:5
class Rouge::Lexers::SAS < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:12
    def data_step_statements; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:140
    def proc_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:122
    def sas_auto_macro_vars; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:29
    def sas_functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:109
    def sas_macro_functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:94
    def sas_macro_statements; end

    # source://rouge-3.30.0/lib/rouge/lexers/sas.rb:330
    def sas_proc_names; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sml.rb:6
class Rouge::Lexers::SML < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/sml.rb:62
  def token_for_final_id(id); end

  # source://rouge-3.30.0/lib/rouge/lexers/sml.rb:70
  def token_for_id(id); end

  # source://rouge-3.30.0/lib/rouge/lexers/sml.rb:54
  def token_for_id_with_dot(id); end

  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sml.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/sml.rb:25
    def symbolic_reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sparql.rb:6
class Rouge::Lexers::SPARQL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sparql.rb:13
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/sparql.rb:25
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:6
class Rouge::Lexers::SQF < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:57
    def commands; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:32
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:25
    def controlflow; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:46
    def diag_commands; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:19
    def initializers; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:39
    def namespaces; end

    # source://rouge-3.30.0/lib/rouge/lexers/sqf.rb:13
    def wordoperators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sql.rb:6
class Rouge::Lexers::SQL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sql.rb:13
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/sql.rb:91
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/ssh.rb:6
class Rouge::Lexers::SSH < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/sass.rb:8
class Rouge::Lexers::Sass < ::Rouge::Lexers::SassCommon
  include ::Rouge::Indentation
end

# shared states with SCSS
#
# source://rouge-3.30.0/lib/rouge/lexers/sass/common.rb:7
class Rouge::Lexers::SassCommon < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/scala.rb:6
class Rouge::Lexers::Scala < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/scheme.rb:6
class Rouge::Lexers::Scheme < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/scheme.rb:22
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/scheme.rb:14
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/scss.rb:8
class Rouge::Lexers::Scss < ::Rouge::Lexers::SassCommon; end

# source://rouge-3.30.0/lib/rouge/lexers/sed.rb:6
class Rouge::Lexers::Sed < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/sed.rb:52
  def regex; end

  # source://rouge-3.30.0/lib/rouge/lexers/sed.rb:56
  def replacement; end

  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/sed.rb:14
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/sed.rb:18
class Rouge::Lexers::Sed::Regex < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/sed.rb:44
class Rouge::Lexers::Sed::Replacement < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/shell.rb:6
class Rouge::Lexers::Shell < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/shell.rb:19
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/shell.rb:28
Rouge::Lexers::Shell::BUILTINS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/shell.rb:23
Rouge::Lexers::Shell::KEYWORDS = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/sieve.rb:6
class Rouge::Lexers::Sieve < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/sieve.rb:20
    def actions; end

    # control commands (rfc5228 § 3)
    #
    # source://rouge-3.30.0/lib/rouge/lexers/sieve.rb:16
    def controls; end

    # source://rouge-3.30.0/lib/rouge/lexers/sieve.rb:39
    def tests; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/slice.rb:8
class Rouge::Lexers::Slice < ::Rouge::Lexers::C
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/slice.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/slice.rb:25
    def keywords_type; end
  end
end

# A lexer for the Slim tempalte language
#
# @see http://slim-lang.org
#
# source://rouge-3.30.0/lib/rouge/lexers/slim.rb:8
class Rouge::Lexers::Slim < ::Rouge::RegexLexer
  include ::Rouge::Indentation

  # source://rouge-3.30.0/lib/rouge/lexers/slim.rb:32
  def filters; end

  # source://rouge-3.30.0/lib/rouge/lexers/slim.rb:28
  def html; end

  # source://rouge-3.30.0/lib/rouge/lexers/slim.rb:24
  def ruby; end
end

# source://rouge-3.30.0/lib/rouge/lexers/smalltalk.rb:6
class Rouge::Lexers::Smalltalk < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/smarty.rb:6
class Rouge::Lexers::Smarty < ::Rouge::TemplateLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/smarty.rb:14
    def builtins; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:5
class Rouge::Lexers::Solidity < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:33
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:59
    def constants; end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:16
    def detect?(text); end

    # TODO: seperate by "type"
    #
    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:21
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:66
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/solidity.rb:72
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/stan.rb:6
class Rouge::Lexers::Stan < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:90
    def builtin_functions; end

    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:333
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:268
    def distributions; end

    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:48
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:62
    def reserved; end

    # source://rouge-3.30.0/lib/rouge/lexers/stan.rb:54
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/stan.rb:14
Rouge::Lexers::Stan::ID = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/stan.rb:16
Rouge::Lexers::Stan::OP = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/stan.rb:15
Rouge::Lexers::Stan::RT = T.let(T.unsafe(nil), Regexp)

# optional comment or whitespace
#
# source://rouge-3.30.0/lib/rouge/lexers/stan.rb:13
Rouge::Lexers::Stan::WS = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/stata.rb:6
class Rouge::Lexers::Stata < ::Rouge::RegexLexer
  class << self
    # Stata commands used with braces. Includes all valid abbreviations for 'forvalues'.
    #
    # source://rouge-3.30.0/lib/rouge/lexers/stata.rb:90
    def reserved_keywords; end

    # Note: types `str1-str2045` handled separately below
    #
    # source://rouge-3.30.0/lib/rouge/lexers/stata.rb:85
    def type_keywords; end
  end
end

# Partial list of common programming and estimation commands, as of Stata 16
# Note: not all abbreviations are included
#
# source://rouge-3.30.0/lib/rouge/lexers/stata.rb:19
Rouge::Lexers::Stata::KEYWORDS = T.let(T.unsafe(nil), Array)

# Complete list of functions by name, as of Stata 16
#
# source://rouge-3.30.0/lib/rouge/lexers/stata.rb:48
Rouge::Lexers::Stata::PRIMITIVE_FUNCTIONS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/supercollider.rb:6
class Rouge::Lexers::SuperCollider < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/supercollider.rb:28
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/supercollider.rb:13
    def keywords; end

    # these aren't technically keywords, but we treat
    # them as such because it makes things clearer 99%
    # of the time
    #
    # source://rouge-3.30.0/lib/rouge/lexers/supercollider.rb:22
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/swift.rb:6
class Rouge::Lexers::Swift < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/systemd.rb:6
class Rouge::Lexers::SystemD < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/syzlang.rb:6
class Rouge::Lexers::Syzlang < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/syzlang.rb:11
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/syzlang.rb:19
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/syzprog.rb:6
class Rouge::Lexers::Syzprog < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/syzprog.rb:11
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:6
class Rouge::Lexers::TCL < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:13
    def detect?(text); end

    # source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:58
    def gen_command_state(name = T.unsafe(nil)); end

    # source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:82
    def gen_delimiter_states(name, close, opts = T.unsafe(nil)); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:40
Rouge::Lexers::TCL::ALL = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:26
Rouge::Lexers::TCL::BUILTINS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:44
Rouge::Lexers::TCL::CHARS = T.let(T.unsafe(nil), Proc)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:39
Rouge::Lexers::TCL::CLOSE = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:41
Rouge::Lexers::TCL::END_LINE = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:42
Rouge::Lexers::TCL::END_WORD = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:19
Rouge::Lexers::TCL::KEYWORDS = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:45
Rouge::Lexers::TCL::NOT_CHARS = T.let(T.unsafe(nil), Proc)

# source://rouge-3.30.0/lib/rouge/lexers/tcl.rb:38
Rouge::Lexers::TCL::OPEN = T.let(T.unsafe(nil), Array)

# source://rouge-3.30.0/lib/rouge/lexers/toml.rb:6
class Rouge::Lexers::TOML < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/tsx.rb:9
class Rouge::Lexers::TSX < ::Rouge::Lexers::JSX
  extend ::Rouge::Lexers::TypescriptCommon
end

# source://rouge-3.30.0/lib/rouge/lexers/ttcn3.rb:6
class Rouge::Lexers::TTCN3 < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/ttcn3.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/ttcn3.rb:32
    def reserved; end

    # source://rouge-3.30.0/lib/rouge/lexers/ttcn3.rb:42
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/tap.rb:5
class Rouge::Lexers::Tap < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/tex.rb:6
class Rouge::Lexers::TeX < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/tex.rb:15
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:8
class Rouge::Lexers::Terraform < ::Rouge::Lexers::Hcl
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:36
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:32
    def constants; end

    # source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:22
    def declarations; end

    # source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:16
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/terraform.rb:28
    def reserved; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/tulip.rb:5
class Rouge::Lexers::Tulip < ::Rouge::RegexLexer
  class << self
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/tulip.rb:14
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/turtle.rb:6
class Rouge::Lexers::Turtle < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/twig.rb:8
class Rouge::Lexers::Twig < ::Rouge::Lexers::Jinja
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/twig.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/twig.rb:31
    def pseudo_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/twig.rb:26
    def tests; end

    # source://rouge-3.30.0/lib/rouge/lexers/twig.rb:35
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/typescript.rb:9
class Rouge::Lexers::Typescript < ::Rouge::Lexers::Javascript
  extend ::Rouge::Lexers::TypescriptCommon
end

# source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:6
module Rouge::Lexers::TypescriptCommon
  # source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:27
  def builtins; end

  # source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:14
  def declarations; end

  # source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:7
  def keywords; end

  # source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:20
  def reserved; end

  class << self
    # @private
    #
    # source://rouge-3.30.0/lib/rouge/lexers/typescript/common.rb:33
    def extended(base); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/vhdl.rb:6
class Rouge::Lexers::VHDL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/vhdl.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/vhdl.rb:27
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/vhdl.rb:35
    def operator_words; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/vala.rb:6
class Rouge::Lexers::Vala < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/varnish.rb:6
class Rouge::Lexers::Varnish < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/varnish.rb:28
    def functions; end

    # backend acl
    #
    # source://rouge-3.30.0/lib/rouge/lexers/varnish.rb:18
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/varnish.rb:39
    def variables; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/varnish.rb:15
Rouge::Lexers::Varnish::SPACE = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/lexers/velocity.rb:5
class Rouge::Lexers::Velocity < ::Rouge::TemplateLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/verilog.rb:6
class Rouge::Lexers::Verilog < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/verilog.rb:15
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/verilog.rb:52
    def keywords_system_task; end

    # source://rouge-3.30.0/lib/rouge/lexers/verilog.rb:37
    def keywords_type; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/viml.rb:6
class Rouge::Lexers::VimL < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/viml.rb:16
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/vb.rb:6
class Rouge::Lexers::VisualBasic < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/vb.rb:47
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/vb.rb:14
    def keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/vb.rb:33
    def keywords_type; end

    # source://rouge-3.30.0/lib/rouge/lexers/vb.rb:40
    def operator_words; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/vue.rb:7
class Rouge::Lexers::Vue < ::Rouge::Lexers::HTML
  # @return [Vue] a new instance of Vue
  #
  # source://rouge-3.30.0/lib/rouge/lexers/vue.rb:15
  def initialize(*_arg0); end

  # source://rouge-3.30.0/lib/rouge/lexers/vue.rb:20
  def lookup_lang(lang); end
end

# source://rouge-3.30.0/lib/rouge/lexers/wollok.rb:6
class Rouge::Lexers::Wollok < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/xml.rb:6
class Rouge::Lexers::XML < ::Rouge::RegexLexer
  class << self
    # Documentation: https://www.w3.org/TR/xml11/#charsets and https://www.w3.org/TR/xml11/#sec-suggested-names
    #
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/xml.rb:17
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:6
class Rouge::Lexers::XPath < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:67
    def axes; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:46
    def commentStart; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:92
    def constructorTypes; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:18
    def decimalLiteral; end

    # Terminal literals:
    # https://www.w3.org/TR/xpath-31/#terminal-symbols
    #
    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:14
    def digits; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:22
    def doubleLiteral; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:42
    def eqName; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:79
    def keywords; end

    # Terminal symbols:
    # https://www.w3.org/TR/xpath-30/#id-terminal-delimitation
    #
    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:56
    def kindTest; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:63
    def kindTestForPI; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:30
    def ncName; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:50
    def openParen; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:75
    def operators; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:34
    def qName; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:26
    def stringLiteral; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:38
    def uriQName; end

    # source://rouge-3.30.0/lib/rouge/lexers/xpath.rb:83
    def word_operators; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/xquery.rb:7
class Rouge::Lexers::XQuery < ::Rouge::Lexers::XPath
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/xquery.rb:14
    def keywords; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/xojo.rb:6
class Rouge::Lexers::Xojo < ::Rouge::RegexLexer; end

# source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:6
class Rouge::Lexers::YAML < ::Rouge::RegexLexer
  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:64
  def continue_indent(match); end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:39
  def dedent?(level); end

  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:34
  def indent; end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:43
  def indent?(level); end

  # reset the indentation levels
  #
  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:27
  def reset_indent; end

  # Save a possible indentation level
  #
  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:48
  def save_indent(match); end

  # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:69
  def set_indent(match, opts = T.unsafe(nil)); end

  class << self
    # Documentation: https://yaml.org/spec/1.2/spec.html
    #
    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:16
    def detect?(text); end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/yaml.rb:21
Rouge::Lexers::YAML::SPECIAL_VALUES = T.let(T.unsafe(nil), Regexp)

# source://rouge-3.30.0/lib/rouge/lexers/yang.rb:6
class Rouge::Lexers::YANG < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:40
    def body_stmts_keywords; end

    # RFC7950 other keywords
    #
    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:69
    def constants_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:47
    def data_def_stmts_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:34
    def linkage_stmts_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:62
    def list_stmts_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:28
    def meta_stmts_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:22
    def module_header_stmts_keywords; end

    # Keywords from RFC7950 ; oriented at BNF style
    #
    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:16
    def top_stmts_keywords; end

    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:54
    def type_stmts_keywords; end

    # RFC7950 Built-In Types
    #
    # source://rouge-3.30.0/lib/rouge/lexers/yang.rb:77
    def types; end
  end
end

# source://rouge-3.30.0/lib/rouge/lexers/zig.rb:6
class Rouge::Lexers::Zig < ::Rouge::RegexLexer
  class << self
    # source://rouge-3.30.0/lib/rouge/lexers/zig.rb:28
    def builtins; end

    # source://rouge-3.30.0/lib/rouge/lexers/zig.rb:15
    def keywords; end
  end
end

# A stateful lexer that uses sets of regular expressions to
# tokenize a string.  Most lexers are instances of RegexLexer.
#
# @abstract
#
# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:8
class Rouge::RegexLexer < ::Rouge::Lexer
  # Delegate the lex to another lexer. We use the `continue_lex` method
  # so that #reset! will not be called.  In this way, a single lexer
  # can be repeatedly delegated to while maintaining its own internal
  # state stack.
  #
  # @param lexer [#lex] The lexer or lexer class to delegate to
  # @param text [String] The text to delegate.  This defaults to the last matched string.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:420
  def delegate(lexer, text = T.unsafe(nil)); end

  # @private
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:268
  def get_state(state_name); end

  # replace the head of the stack with the given state
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:464
  def goto(state_name); end

  # Yield a token with the next matched group.  Subsequent calls
  # to this method will yield subsequent groups.
  #
  # @deprecated
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:399
  def group(tok); end

  # Yield tokens corresponding to the matched groups of the current
  # match.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:405
  def groups(*tokens); end

  # Check if `state_name` is in the state stack.
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:479
  def in_state?(state_name); end

  # Pop the state stack.  If a number is passed in, it will be popped
  # that number of times.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:453
  def pop!(times = T.unsafe(nil)); end

  # Push a state onto the stack.  If no state name is given and you've
  # passed a block, a state will be dynamically created using the
  # {StateDSL}.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:437
  def push(state_name = T.unsafe(nil), &b); end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:430
  def recurse(text = T.unsafe(nil)); end

  # reset this lexer to its initial state.  This runs all of the
  # start_procs.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:289
  def reset!; end

  # reset the stack back to `[:root]`.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:472
  def reset_stack; end

  # The state stack.  This is initially the single state `[:root]`.
  # It is an error for this stack to be empty.
  #
  # @see #state
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:275
  def stack; end

  # The current state - i.e. one on top of the state stack.
  #
  # NB: if the state stack is empty, this will throw an error rather
  # than returning nil.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:283
  def state; end

  # Check if `state_name` is the state on top of the state stack.
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:487
  def state?(state_name); end

  # Runs one step of the lex.  Rules in the current state are tried
  # until one matches, at which point its callback is called.
  #
  # @return true if a rule was tried successfully
  # @return false otherwise.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:345
  def step(state, stream); end

  # This implements the lexer protocol, by yielding [token, value] pairs.
  #
  # The process for lexing works as follows, until the stream is empty:
  #
  # 1. We look at the state on top of the stack (which by default is
  #    `[:root]`).
  # 2. Each rule in that state is tried until one is successful.  If one
  #    is found, that rule's callback is evaluated - which may yield
  #    tokens and manipulate the state stack.  Otherwise, one character
  #    is consumed with an `'Error'` token, and we continue at (1.)
  #
  # @see #step #step (where (2.) is implemented)
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:311
  def stream_tokens(str, &b); end

  # Yield a token.
  #
  # @param tok the token type
  # @param val (optional) the string value to yield.  If absent, this defaults
  #   to the entire last match.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:391
  def token(tok, val = T.unsafe(nil)); end

  private

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:492
  def yield_token(tok, val); end

  class << self
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:251
    def append(name, &b); end

    # @private
    #
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:258
    def get_state(name); end

    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:245
    def prepend(name, &b); end

    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:218
    def replace_state(name, new_defn); end

    # Specify an action to be run every fresh lex.
    #
    # @example
    #   start { puts "I'm lexing a new string!" }
    #
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:234
    def start(&b); end

    # The routines to run at the beginning of a fresh lex.
    #
    # @see start
    #
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:225
    def start_procs; end

    # Define a new state for this lexer with the given name.
    # The block will be evaluated in the context of a {StateDSL}.
    #
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:240
    def state(name, &b); end

    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:213
    def state_definitions; end

    # The states hash for this lexer.
    #
    # @see state
    #
    # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:209
    def states; end
  end
end

# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:19
class Rouge::RegexLexer::ClosedState < ::StandardError
  # @return [ClosedState] a new instance of ClosedState
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:21
  def initialize(state); end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:25
  def rule; end

  # Returns the value of attribute state.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:20
  def state; end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:29
  def to_s; end
end

# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:9
class Rouge::RegexLexer::InvalidRegex < ::StandardError
  # @return [InvalidRegex] a new instance of InvalidRegex
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:10
  def initialize(re); end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:14
  def to_s; end
end

# The number of successive scans permitted without consuming
# the input stream.  If this is exceeded, the match fails.
#
# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:338
Rouge::RegexLexer::MAX_NULL_SCANS = T.let(T.unsafe(nil), Integer)

# A rule is a tuple of a regular expression to test, and a callback
# to perform if the test succeeds.
#
# @see StateDSL#rule
#
# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:44
class Rouge::RegexLexer::Rule
  # @return [Rule] a new instance of Rule
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:48
  def initialize(re, callback); end

  # Returns the value of attribute beginning_of_line.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:47
  def beginning_of_line; end

  # Returns the value of attribute callback.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:45
  def callback; end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:54
  def inspect; end

  # Returns the value of attribute re.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:46
  def re; end
end

# a State is a named set of rules that can be tested for or
# mixed in.
#
# @see RegexLexer.state
#
# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:63
class Rouge::RegexLexer::State
  # @return [State] a new instance of State
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:65
  def initialize(name, rules); end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:70
  def inspect; end

  # Returns the value of attribute name.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:64
  def name; end

  # Returns the value of attribute rules.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:64
  def rules; end
end

# source://rouge-3.30.0/lib/rouge/regex_lexer.rb:75
class Rouge::RegexLexer::StateDSL
  # @return [StateDSL] a new instance of StateDSL
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:77
  def initialize(name, &defn); end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:101
  def appended(&defn); end

  # Returns the value of attribute name.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:76
  def name; end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:93
  def prepended(&defn); end

  # Returns the value of attribute rules.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:76
  def rules; end

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:85
  def to_state(lexer_class); end

  protected

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:188
  def close!; end

  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:178
  def context_sensitive?(re); end

  # Mix in the rules from another state into this state.  The rules
  # from the mixed-in state will be tried in order before moving on
  # to the rest of the rules in this state.
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:195
  def mixin(state); end

  # Define a new rule for this state.
  #
  # @overload rule
  # @overload rule
  # @param re [Regexp] a regular expression for this rule to test.
  # @param tok [String] the token type to yield if `re` matches.
  # @param next_state [#to_s] (optional) a state to push onto the stack if `re` matches.
  #   If `next_state` is `:pop!`, the state stack will be popped
  #   instead.
  # @param callback [Proc] a block that will be evaluated in the context of the lexer
  #   if `re` matches.  This block has access to a number of lexer
  #   methods, including {RegexLexer#push}, {RegexLexer#pop!},
  #   {RegexLexer#token}, and {RegexLexer#delegate}.  The first
  #   argument can be used to access the match groups.
  # @raise [ClosedState]
  #
  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:129
  def rule(re, tok = T.unsafe(nil), next_state = T.unsafe(nil), &callback); end

  private

  # source://rouge-3.30.0/lib/rouge/regex_lexer.rb:200
  def load!; end
end

# A TemplateLexer is one that accepts a :parent option, to specify
# which language is being templated.  The lexer class can specify its
# own default for the parent lexer, which is otherwise defaulted to
# HTML.
#
# @abstract
#
# source://rouge-3.30.0/lib/rouge/template_lexer.rb:11
class Rouge::TemplateLexer < ::Rouge::RegexLexer
  # the parent lexer - the one being templated.
  #
  # source://rouge-3.30.0/lib/rouge/template_lexer.rb:12
  def parent; end
end

# source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:5
class Rouge::TexThemeRenderer
  # @return [TexThemeRenderer] a new instance of TexThemeRenderer
  #
  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:6
  def initialize(theme, opts = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:97
  def camelize(name); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:86
  def gen_inline(name, &b); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:70
  def inline_name(color); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:101
  def palette_name(name); end

  # Our general strategy is this:
  #
  # * First, define the \RG{tokname}{content} command, which will
  #   expand into \RG@tok@tokname{content}. We use \csname...\endcsname
  #   to interpolate into a command.
  #
  # * Define the default RG* environment, which will enclose the whole
  #   thing. By default this will simply set \ttfamily (select monospace font)
  #   but it can be overridden with \renewcommand by the user to be
  #   any other formatting.
  #
  # * Define all the colors using xcolors \definecolor command. First we define
  #   every palette color with a name such as RG@palette@themneame@colorname.
  #   Then we find all foreground and background colors that have literal html
  #   colors embedded in them and define them with names such as
  #   RG@palette@themename@000000. While html allows three-letter colors such
  #   as #FFF, xcolor requires all six characters to be present, so we make sure
  #   to normalize that as well as the case convention in #inline_name.
  #
  # * Define the token commands RG@tok@xx. These will take the content as the
  #   argument and format it according to the theme, referring to the color
  #   in the palette.
  #
  # @yield [<<'END'.gsub('RG', @prefix)
  # \makeatletter
  # \def\RG#1#2{\csname RG@tok@#1\endcsname{#2}}%
  # \newenvironment{RG*}{\ttfamily}{\relax}%
  # END]
  #
  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:33
  def render(&b); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:111
  def render_blank(tok, &b); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:65
  def render_inline_pallete(style, &b); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:57
  def render_palette(palette, &b); end

  # @yield [out]
  #
  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:115
  def render_style(tok, style, &b); end

  # source://rouge-3.30.0/lib/rouge/tex_theme_renderer.rb:107
  def token_name(tok); end
end

# source://rouge-3.30.0/lib/rouge/text_analyzer.rb:6
class Rouge::TextAnalyzer < ::String
  # Return the contents of the doctype tag if present, nil otherwise.
  #
  # source://rouge-3.30.0/lib/rouge/text_analyzer.rb:25
  def doctype; end

  # Check if the doctype matches a given regexp or string
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/text_analyzer.rb:36
  def doctype?(type = T.unsafe(nil)); end

  # Return true if the result of lexing with the given lexer contains no
  # error tokens.
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/text_analyzer.rb:42
  def lexes_cleanly?(lexer); end

  # Find a shebang.  Returns nil if no shebang is present.
  #
  # source://rouge-3.30.0/lib/rouge/text_analyzer.rb:7
  def shebang; end

  # Check if the given shebang is present.
  #
  # This normalizes things so that `text.shebang?('bash')` will detect
  # `#!/bash`, '#!/bin/bash', '#!/usr/bin/env bash', and '#!/bin/bash -x'
  #
  # @return [Boolean]
  #
  # source://rouge-3.30.0/lib/rouge/text_analyzer.rb:18
  def shebang?(match); end
end

# source://rouge-3.30.0/lib/rouge/theme.rb:5
class Rouge::Theme
  include ::Rouge::Token::Tokens

  # source://rouge-3.30.0/lib/rouge/theme.rb:78
  def get_own_style(token); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:82
  def get_style(token); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:86
  def name; end

  # source://rouge-3.30.0/lib/rouge/theme.rb:67
  def palette(*a); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:46
  def styles; end

  class << self
    # source://rouge-3.30.0/lib/rouge/theme.rb:111
    def base_style; end

    # source://rouge-3.30.0/lib/rouge/theme.rb:126
    def find(n); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:99
    def get_own_style(token); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:107
    def get_style(token); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:115
    def name(n = T.unsafe(nil)); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:51
    def palette(arg = T.unsafe(nil)); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:122
    def register(name); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:130
    def registry; end

    # source://rouge-3.30.0/lib/rouge/theme.rb:74
    def render(opts = T.unsafe(nil), &b); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:91
    def style(*tokens); end

    # source://rouge-3.30.0/lib/rouge/theme.rb:70
    def styles; end
  end
end

# source://rouge-3.30.0/lib/rouge/theme.rb:8
class Rouge::Theme::Style < ::Hash
  # @return [Style] a new instance of Style
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:9
  def initialize(theme, hsh = T.unsafe(nil)); end

  # source://rouge-3.30.0/lib/rouge/theme.rb:16
  def bg; end

  # source://rouge-3.30.0/lib/rouge/theme.rb:16
  def fg; end

  # @yield ["#{selector} {"]
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:22
  def render(selector, &b); end

  # @yield ["color: #{fg}"]
  #
  # source://rouge-3.30.0/lib/rouge/theme.rb:34
  def rendered_rules(&b); end
end

# source://rouge-3.30.0/lib/rouge/themes/thankful_eyes.rb:5
module Rouge::Themes; end

# default base16 theme
# by Chris Kempson (http://chriskempson.com)
#
# source://rouge-3.30.0/lib/rouge/themes/base16.rb:8
class Rouge::Themes::Base16 < ::Rouge::CSSTheme
  extend ::Rouge::HasModes

  class << self
    # source://rouge-3.30.0/lib/rouge/themes/base16.rb:35
    def dark!; end

    # source://rouge-3.30.0/lib/rouge/themes/base16.rb:30
    def light!; end

    # source://rouge-3.30.0/lib/rouge/themes/base16.rb:40
    def make_dark!; end

    # source://rouge-3.30.0/lib/rouge/themes/base16.rb:44
    def make_light!; end
  end
end

# source://rouge-3.30.0/lib/rouge/themes/base16.rb:108
class Rouge::Themes::Base16::Monokai < ::Rouge::Themes::Base16; end

# source://rouge-3.30.0/lib/rouge/themes/base16.rb:85
class Rouge::Themes::Base16::Solarized < ::Rouge::Themes::Base16; end

# A port of the bw style from Pygments.
# See https://bitbucket.org/birkenfeld/pygments-main/src/default/pygments/styles/bw.py
#
# source://rouge-3.30.0/lib/rouge/themes/bw.rb:8
class Rouge::Themes::BlackWhiteTheme < ::Rouge::CSSTheme; end

# stolen from pygments
#
# source://rouge-3.30.0/lib/rouge/themes/colorful.rb:7
class Rouge::Themes::Colorful < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/github.rb:6
class Rouge::Themes::Github < ::Rouge::CSSTheme; end

# Based on https://github.com/morhetz/gruvbox, with help from
# https://github.com/daveyarwood/gruvbox-pygments
#
# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:10
class Rouge::Themes::Gruvbox < ::Rouge::CSSTheme
  extend ::Rouge::HasModes

  class << self
    # source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:67
    def dark!; end

    # source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:62
    def light!; end

    # source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:72
    def make_dark!; end

    # source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:99
    def make_light!; end
  end
end

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:40
Rouge::Themes::Gruvbox::C_bright_aqua = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:38
Rouge::Themes::Gruvbox::C_bright_blue = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:36
Rouge::Themes::Gruvbox::C_bright_green = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:41
Rouge::Themes::Gruvbox::C_bright_orange = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:39
Rouge::Themes::Gruvbox::C_bright_purple = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:35
Rouge::Themes::Gruvbox::C_bright_red = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:37
Rouge::Themes::Gruvbox::C_bright_yellow = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:15
Rouge::Themes::Gruvbox::C_dark0 = T.let(T.unsafe(nil), String)

# global Gruvbox colours {{{
#
# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:14
Rouge::Themes::Gruvbox::C_dark0_hard = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:16
Rouge::Themes::Gruvbox::C_dark0_soft = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:17
Rouge::Themes::Gruvbox::C_dark1 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:18
Rouge::Themes::Gruvbox::C_dark2 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:19
Rouge::Themes::Gruvbox::C_dark3 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:20
Rouge::Themes::Gruvbox::C_dark4 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:21
Rouge::Themes::Gruvbox::C_dark4_256 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:56
Rouge::Themes::Gruvbox::C_faded_aqua = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:54
Rouge::Themes::Gruvbox::C_faded_blue = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:52
Rouge::Themes::Gruvbox::C_faded_green = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:57
Rouge::Themes::Gruvbox::C_faded_orange = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:55
Rouge::Themes::Gruvbox::C_faded_purple = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:51
Rouge::Themes::Gruvbox::C_faded_red = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:53
Rouge::Themes::Gruvbox::C_faded_yellow = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:24
Rouge::Themes::Gruvbox::C_gray_244 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:23
Rouge::Themes::Gruvbox::C_gray_245 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:27
Rouge::Themes::Gruvbox::C_light0 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:26
Rouge::Themes::Gruvbox::C_light0_hard = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:28
Rouge::Themes::Gruvbox::C_light0_soft = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:29
Rouge::Themes::Gruvbox::C_light1 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:30
Rouge::Themes::Gruvbox::C_light2 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:31
Rouge::Themes::Gruvbox::C_light3 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:32
Rouge::Themes::Gruvbox::C_light4 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:33
Rouge::Themes::Gruvbox::C_light4_256 = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:48
Rouge::Themes::Gruvbox::C_neutral_aqua = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:46
Rouge::Themes::Gruvbox::C_neutral_blue = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:44
Rouge::Themes::Gruvbox::C_neutral_green = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:49
Rouge::Themes::Gruvbox::C_neutral_orange = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:47
Rouge::Themes::Gruvbox::C_neutral_purple = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:43
Rouge::Themes::Gruvbox::C_neutral_red = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/gruvbox.rb:45
Rouge::Themes::Gruvbox::C_neutral_yellow = T.let(T.unsafe(nil), String)

# source://rouge-3.30.0/lib/rouge/themes/igor_pro.rb:6
class Rouge::Themes::IgorPro < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/magritte.rb:6
class Rouge::Themes::Magritte < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/molokai.rb:6
class Rouge::Themes::Molokai < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/monokai.rb:6
class Rouge::Themes::Monokai < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/monokai_sublime.rb:6
class Rouge::Themes::MonokaiSublime < ::Rouge::CSSTheme; end

# A port of the pastie style from Pygments.
# See https://bitbucket.org/birkenfeld/pygments-main/src/default/pygments/styles/pastie.py
#
# source://rouge-3.30.0/lib/rouge/themes/pastie.rb:8
class Rouge::Themes::Pastie < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/thankful_eyes.rb:6
class Rouge::Themes::ThankfulEyes < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/themes/tulip.rb:6
class Rouge::Themes::Tulip < ::Rouge::CSSTheme; end

# source://rouge-3.30.0/lib/rouge/token.rb:5
class Rouge::Token
  class << self
    # source://rouge-3.30.0/lib/rouge/token.rb:19
    def [](qualname); end

    # source://rouge-3.30.0/lib/rouge/token.rb:11
    def cache; end

    # source://rouge-3.30.0/lib/rouge/token.rb:62
    def each_token(&b); end

    # source://rouge-3.30.0/lib/rouge/token.rb:25
    def inspect; end

    # source://rouge-3.30.0/lib/rouge/token.rb:46
    def make_token(name, shortname, &b); end

    # @return [Boolean]
    #
    # source://rouge-3.30.0/lib/rouge/token.rb:29
    def matches?(other); end

    # Returns the value of attribute name.
    #
    # source://rouge-3.30.0/lib/rouge/token.rb:7
    def name; end

    # Returns the value of attribute parent.
    #
    # source://rouge-3.30.0/lib/rouge/token.rb:8
    def parent; end

    # source://rouge-3.30.0/lib/rouge/token.rb:37
    def qualname; end

    # source://rouge-3.30.0/lib/rouge/token.rb:41
    def register!; end

    # Returns the value of attribute shortname.
    #
    # source://rouge-3.30.0/lib/rouge/token.rb:9
    def shortname; end

    # source://rouge-3.30.0/lib/rouge/token.rb:15
    def sub_tokens; end

    # source://rouge-3.30.0/lib/rouge/token.rb:57
    def token(name, shortname, &b); end

    # source://rouge-3.30.0/lib/rouge/token.rb:33
    def token_chain; end
  end
end

# source://rouge-3.30.0/lib/rouge/token.rb:69
module Rouge::Token::Tokens
  class << self
    # source://rouge-3.30.0/lib/rouge/token.rb:70
    def token(name, shortname, &b); end
  end
end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Doc < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Hashbang < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Multiline < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Preproc < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::PreprocFile < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Single < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Comment::Special < ::Rouge::Token::Tokens::Comment; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Error < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Escape < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Deleted < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Emph < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Error < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Heading < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Inserted < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Lineno < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Output < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Prompt < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Strong < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Subheading < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Generic::Traceback < ::Rouge::Token::Tokens::Generic; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Constant < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Declaration < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Namespace < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Pseudo < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Reserved < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Type < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Keyword::Variable < ::Rouge::Token::Tokens::Keyword; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Date < ::Rouge::Token::Tokens::Literal; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number < ::Rouge::Token::Tokens::Literal; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Bin < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Float < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Hex < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Integer < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Integer::Long < ::Rouge::Token::Tokens::Literal::Number::Integer; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Oct < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::Number::Other < ::Rouge::Token::Tokens::Literal::Number; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String < ::Rouge::Token::Tokens::Literal; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Affix < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Backtick < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Char < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Delimiter < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Doc < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Double < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Escape < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Heredoc < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Interpol < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Other < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Regex < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Single < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Literal::String::Symbol < ::Rouge::Token::Tokens::Literal::String; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Attribute < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Builtin < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Builtin::Pseudo < ::Rouge::Token::Tokens::Name::Builtin; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Class < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Constant < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Decorator < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Entity < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Exception < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Function < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Function::Magic < ::Rouge::Token::Tokens::Name::Function; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Label < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Namespace < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Other < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Property < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Tag < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Variable < ::Rouge::Token::Tokens::Name; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Variable::Class < ::Rouge::Token::Tokens::Name::Variable; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Variable::Global < ::Rouge::Token::Tokens::Name::Variable; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Variable::Instance < ::Rouge::Token::Tokens::Name::Variable; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Name::Variable::Magic < ::Rouge::Token::Tokens::Name::Variable; end

# convenience
#
# source://rouge-3.30.0/lib/rouge/token.rb:187
Rouge::Token::Tokens::Num = Rouge::Token::Tokens::Literal::Number

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Operator < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Operator::Word < ::Rouge::Token::Tokens::Operator; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Other < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Punctuation < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Punctuation::Indicator < ::Rouge::Token::Tokens::Punctuation; end

# source://rouge-3.30.0/lib/rouge/token.rb:188
Rouge::Token::Tokens::Str = Rouge::Token::Tokens::Literal::String

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Text < ::Rouge::Token; end

# source://rouge-3.30.0/lib/rouge/token.rb:48
class Rouge::Token::Tokens::Text::Whitespace < ::Rouge::Token::Tokens::Text; end
