# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `parslet` gem.
# Please instead update this file by running `bin/tapioca gem parslet`.

# A simple parser generator library. Typical usage would look like this:
#
#   require 'parslet'
#
#   class MyParser < Parslet::Parser
#     rule(:a) { str('a').repeat }
#     root(:a)
#   end
#
#   pp MyParser.new.parse('aaaa')   # => 'aaaa'@0
#   pp MyParser.new.parse('bbbb')   # => Parslet::Atoms::ParseFailed:
#                                   #    Don't know what to do with bbbb at line 1 char 1.
#
# The simple DSL allows you to define grammars in PEG-style. This kind of
# grammar construction does away with the ambiguities that usually comes with
# parsers; instead, it allows you to construct grammars that are easier to
# debug, since less magic is involved.
#
# Parslet is typically used in stages:
#
#
# * Parsing the input string; this yields an intermediary tree, see
#   Parslet.any, Parslet.match, Parslet.str, Parslet::ClassMethods#rule and
#   Parslet::ClassMethods#root.
# * Transformation of the tree into something useful to you, see
#   Parslet::Transform, Parslet.simple, Parslet.sequence and Parslet.subtree.
#
# The first stage is traditionally intermingled with the second stage; output
# from the second stage is usually called the 'Abstract Syntax Tree' or AST.
#
# The stages are completely decoupled; You can change your grammar around and
# use the second stage to isolate the rest of your code from the changes
# you've effected.
#
# == Further reading
#
# All parslet atoms are subclasses of {Parslet::Atoms::Base}. You might want to
# look at all of those: {Parslet::Atoms::Re}, {Parslet::Atoms::Str},
# {Parslet::Atoms::Repetition}, {Parslet::Atoms::Sequence},
# {Parslet::Atoms::Alternative}.
#
# == When things go wrong
#
# A parse that fails will raise {Parslet::ParseFailed}. This exception contains
# all the details of what went wrong, including a detailed error trace that
# can be printed out as an ascii tree. ({Parslet::Cause})
#
# source://parslet-2.0.0/lib/parslet.rb:48
module Parslet
  mixes_in_class_methods ::Parslet::ClassMethods

  private

  # Returns an atom matching any character. It acts like the '.' (dot)
  # character in regular expressions.
  #
  #   any.parse('a')    # => 'a'
  #
  # @return [Parslet::Atoms::Re] a parslet atom
  #
  # source://parslet-2.0.0/lib/parslet.rb:168
  def any; end

  # Designates a piece of the parser as being dynamic. Dynamic parsers can
  # either return a parser at runtime, which will be applied on the input, or
  # return a result from a parse.
  #
  # Dynamic parse pieces are never cached and can introduce performance
  # abnormalitites - use sparingly where other constructs fail.
  #
  # Example:
  #   # Parses either 'a' or 'b', depending on the weather
  #   dynamic { rand() < 0.5 ? str('a') : str('b') }
  #
  # source://parslet-2.0.0/lib/parslet.rb:199
  def dynamic(&block); end

  # A special kind of atom that allows embedding whole treetop expressions
  # into parslet construction.
  #
  #   # the same as str('a') >> str('b').maybe
  #   exp(%Q("a" "b"?))
  #
  # @param str [String] a treetop expression
  # @return [Parslet::Atoms::Base] the corresponding parslet parser
  #
  # source://parslet-2.0.0/lib/parslet.rb:253
  def exp(str); end

  # Returns a parslet atom that parses infix expressions. Operations are
  # specified as a list of <atom, precedence, associativity> tuples, where
  # atom is simply the parslet atom that matches an operator, precedence is
  # a number and associativity is either :left or :right.
  #
  # Higher precedence indicates that the operation should bind tighter than
  # other operations with lower precedence. In common algebra, '+' has
  # lower precedence than '*'. So you would have a precedence of 1 for '+' and
  # a precedence of 2 for '*'. Only the order relation between these two
  # counts, so any number would work.
  #
  # Associativity is what decides what interpretation to take for strings that
  # are ambiguous like '1 + 2 + 3'. If '+' is specified as left associative,
  # the expression would be interpreted as '(1 + 2) + 3'. If right
  # associativity is chosen, it would be interpreted as '1 + (2 + 3)'. Note
  # that the hash trees output reflect that choice as well.
  #
  # An optional block can be provided in order to manipulate the generated tree.
  # The block will be called on each operator and passed 3 arguments: the left
  # operand, the operator, and the right operand.
  #
  # Examples:
  #   infix_expression(integer, [add_op, 1, :left])
  #   # would parse things like '1 + 2'
  #
  #   infix_expression(integer, [add_op, 1, :left]) { |l,o,r| { :plus => [l, r] } }
  #   # would parse '1 + 2 + 3' as:
  #   # { :plus => [1, { :plus => [2, 3] }] }
  #
  # @param element [Parslet::Atoms::Base] elements that take the NUMBER position
  #   in the expression
  # @param operations [Array<(Parslet::Atoms::Base, Integer, {:left, :right})>]
  # @see Parslet::Atoms::Infix
  #
  # source://parslet-2.0.0/lib/parslet.rb:239
  def infix_expression(element, *operations, &reducer); end

  # Returns an atom matching a character class. All regular expressions can be
  # used, as long as they match only a single character at a time.
  #
  #   match('[ab]')     # will match either 'a' or 'b'
  #   match('[\n\s]')   # will match newlines and spaces
  #
  # There is also another (convenience) form of this method:
  #
  #   match['a-z']      # synonymous to match('[a-z]')
  #   match['\n']       # synonymous to match('[\n]')
  #
  # @overload match
  #
  # source://parslet-2.0.0/lib/parslet.rb:142
  def match(str = T.unsafe(nil)); end

  # Introduces a new capture scope. This means that all old captures stay
  # accessible, but new values stored will only be available during the block
  # given and the old values will be restored after the block.
  #
  # Example:
  #   # :a will be available until the end of the block. Afterwards,
  #   # :a from the outer scope will be available again, if such a thing
  #   # exists.
  #   scope { str('a').capture(:a) }
  #
  # source://parslet-2.0.0/lib/parslet.rb:183
  def scope(&block); end

  # Returns a placeholder for a tree transformation that will only match a
  # sequence of elements. The +symbol+ you specify will be the key for the
  # matched sequence in the returned dictionary.
  #
  #   # This would match a body element that contains several declarations.
  #   { :body => sequence(:declarations) }
  #
  # The above example would match <code>:body => ['a', 'b']</code>, but not
  # <code>:body => 'a'</code>.
  #
  # see {Parslet::Transform}
  #
  # source://parslet-2.0.0/lib/parslet.rb:270
  def sequence(symbol); end

  # Returns a placeholder for a tree transformation that will only match
  # simple elements. This matches everything that <code>#sequence</code>
  # doesn't match.
  #
  #   # Matches a single header.
  #   { :header => simple(:header) }
  #
  # see {Parslet::Transform}
  #
  # source://parslet-2.0.0/lib/parslet.rb:284
  def simple(symbol); end

  # Returns an atom matching the +str+ given:
  #
  #   str('class')      # will match 'class'
  #
  # @param str [String] string to match verbatim
  # @return [Parslet::Atoms::Str] a parslet atom
  #
  # source://parslet-2.0.0/lib/parslet.rb:156
  def str(str); end

  # Returns a placeholder for tree transformation patterns that will match
  # any kind of subtree.
  #
  #   { :expression => subtree(:exp) }
  #
  # source://parslet-2.0.0/lib/parslet.rb:294
  def subtree(symbol); end

  class << self
    # Returns an atom matching any character. It acts like the '.' (dot)
    # character in regular expressions.
    #
    #   any.parse('a')    # => 'a'
    #
    # @return [Parslet::Atoms::Re] a parslet atom
    #
    # source://parslet-2.0.0/lib/parslet.rb:168
    def any; end

    # Designates a piece of the parser as being dynamic. Dynamic parsers can
    # either return a parser at runtime, which will be applied on the input, or
    # return a result from a parse.
    #
    # Dynamic parse pieces are never cached and can introduce performance
    # abnormalitites - use sparingly where other constructs fail.
    #
    # Example:
    #   # Parses either 'a' or 'b', depending on the weather
    #   dynamic { rand() < 0.5 ? str('a') : str('b') }
    #
    # source://parslet-2.0.0/lib/parslet.rb:199
    def dynamic(&block); end

    # A special kind of atom that allows embedding whole treetop expressions
    # into parslet construction.
    #
    #   # the same as str('a') >> str('b').maybe
    #   exp(%Q("a" "b"?))
    #
    # @param str [String] a treetop expression
    # @return [Parslet::Atoms::Base] the corresponding parslet parser
    #
    # source://parslet-2.0.0/lib/parslet.rb:253
    def exp(str); end

    # Extends classes that include Parslet with the module
    # {Parslet::ClassMethods}.
    #
    # source://parslet-2.0.0/lib/parslet.rb:52
    def included(base); end

    # Returns a parslet atom that parses infix expressions. Operations are
    # specified as a list of <atom, precedence, associativity> tuples, where
    # atom is simply the parslet atom that matches an operator, precedence is
    # a number and associativity is either :left or :right.
    #
    # Higher precedence indicates that the operation should bind tighter than
    # other operations with lower precedence. In common algebra, '+' has
    # lower precedence than '*'. So you would have a precedence of 1 for '+' and
    # a precedence of 2 for '*'. Only the order relation between these two
    # counts, so any number would work.
    #
    # Associativity is what decides what interpretation to take for strings that
    # are ambiguous like '1 + 2 + 3'. If '+' is specified as left associative,
    # the expression would be interpreted as '(1 + 2) + 3'. If right
    # associativity is chosen, it would be interpreted as '1 + (2 + 3)'. Note
    # that the hash trees output reflect that choice as well.
    #
    # An optional block can be provided in order to manipulate the generated tree.
    # The block will be called on each operator and passed 3 arguments: the left
    # operand, the operator, and the right operand.
    #
    # Examples:
    #   infix_expression(integer, [add_op, 1, :left])
    #   # would parse things like '1 + 2'
    #
    #   infix_expression(integer, [add_op, 1, :left]) { |l,o,r| { :plus => [l, r] } }
    #   # would parse '1 + 2 + 3' as:
    #   # { :plus => [1, { :plus => [2, 3] }] }
    #
    # @param element [Parslet::Atoms::Base] elements that take the NUMBER position
    #   in the expression
    # @param operations [Array<(Parslet::Atoms::Base, Integer, {:left, :right})>]
    # @see Parslet::Atoms::Infix
    #
    # source://parslet-2.0.0/lib/parslet.rb:239
    def infix_expression(element, *operations, &reducer); end

    # Returns an atom matching a character class. All regular expressions can be
    # used, as long as they match only a single character at a time.
    #
    #   match('[ab]')     # will match either 'a' or 'b'
    #   match('[\n\s]')   # will match newlines and spaces
    #
    # There is also another (convenience) form of this method:
    #
    #   match['a-z']      # synonymous to match('[a-z]')
    #   match['\n']       # synonymous to match('[\n]')
    #
    # @overload match
    #
    # source://parslet-2.0.0/lib/parslet.rb:142
    def match(str = T.unsafe(nil)); end

    # Introduces a new capture scope. This means that all old captures stay
    # accessible, but new values stored will only be available during the block
    # given and the old values will be restored after the block.
    #
    # Example:
    #   # :a will be available until the end of the block. Afterwards,
    #   # :a from the outer scope will be available again, if such a thing
    #   # exists.
    #   scope { str('a').capture(:a) }
    #
    # source://parslet-2.0.0/lib/parslet.rb:183
    def scope(&block); end

    # Returns a placeholder for a tree transformation that will only match a
    # sequence of elements. The +symbol+ you specify will be the key for the
    # matched sequence in the returned dictionary.
    #
    #   # This would match a body element that contains several declarations.
    #   { :body => sequence(:declarations) }
    #
    # The above example would match <code>:body => ['a', 'b']</code>, but not
    # <code>:body => 'a'</code>.
    #
    # see {Parslet::Transform}
    #
    # source://parslet-2.0.0/lib/parslet.rb:270
    def sequence(symbol); end

    # Returns a placeholder for a tree transformation that will only match
    # simple elements. This matches everything that <code>#sequence</code>
    # doesn't match.
    #
    #   # Matches a single header.
    #   { :header => simple(:header) }
    #
    # see {Parslet::Transform}
    #
    # source://parslet-2.0.0/lib/parslet.rb:284
    def simple(symbol); end

    # Returns an atom matching the +str+ given:
    #
    #   str('class')      # will match 'class'
    #
    # @param str [String] string to match verbatim
    # @return [Parslet::Atoms::Str] a parslet atom
    #
    # source://parslet-2.0.0/lib/parslet.rb:156
    def str(str); end

    # Returns a placeholder for tree transformation patterns that will match
    # any kind of subtree.
    #
    #   { :expression => subtree(:exp) }
    #
    # source://parslet-2.0.0/lib/parslet.rb:294
    def subtree(symbol); end
  end
end

# This is where parslets name comes from: Small parser atoms.
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:4
module Parslet::Atoms; end

# Alternative during matching. Contains a list of parslets that is tried each
# one in turn. Only fails if all alternatives fail.
#
# Example:
#
#   str('a') | str('b')   # matches either 'a' or 'b'
#
# source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:9
class Parslet::Atoms::Alternative < ::Parslet::Atoms::Base
  # Constructs an Alternative instance using all given parslets in the order
  # given. This is what happens if you call '|' on existing parslets, like
  # this:
  #
  #   str('a') | str('b')
  #
  # @return [Alternative] a new instance of Alternative
  #
  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:18
  def initialize(*alternatives); end

  # Returns the value of attribute alternatives.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:10
  def alternatives; end

  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:32
  def error_msg; end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:136
  def precedence; end

  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:50
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:36
  def try(source, context, consume_all); end

  # ---
  # Don't construct a hanging tree of Alternative parslets, instead store them
  # all here. This reduces the number of objects created.
  # +++
  #
  # source://parslet-2.0.0/lib/parslet/atoms/alternative.rb:28
  def |(parslet); end
end

# Base class for all parslets, handles orchestration of calls and implements
# a lot of the operator and chaining methods.
#
# Also see Parslet::Atoms::DSL chaining parslet atoms together.
#
# source://parslet-2.0.0/lib/parslet/atoms/base.rb:6
class Parslet::Atoms::Base
  include ::Parslet::Atoms::Precedence
  include ::Parslet::Atoms::DSL
  include ::Parslet::Atoms::CanFlatten

  # Calls the #try method of this parslet. Success consumes input, error will
  # rewind the input.
  #
  #  @param context [Parslet::Atoms::Context] context to use for the parsing
  #
  # @param source [Parslet::Source] source to read input from
  # @param consume_all [Boolean] true if the current parse must consume
  #   all input by itself.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:83
  def apply(source, context, consume_all = T.unsafe(nil)); end

  # Returns true if this atom can be cached in the packrat cache. Most parslet
  # atoms are cached, so this always returns true, unless overridden.
  #
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:129
  def cached?; end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:147
  def inspect; end

  # Parslet label as provided in grammar
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:12
  def label; end

  # Parslet label as provided in grammar
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:12
  def label=(_arg0); end

  # Given a string or an IO object, this will attempt a parse of its contents
  # and return a result. If the parse fails, a Parslet::ParseFailed exception
  # will be thrown.
  #
  # @option options
  # @option options
  # @param io [String, Source] input for the parse process
  # @param options [Hash] a customizable set of options
  # @return [Hash, Array, Parslet::Slice] PORO (Plain old Ruby object) result
  #   tree
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:26
  def parse(io, options = T.unsafe(nil)); end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:136
  def precedence; end

  # Creates a context for parsing and applies the current atom to the input.
  # Returns the parse result.
  #
  # @return [<Boolean, Object>] Result of the parse. If the first member is
  #   true, the parse has succeeded.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:71
  def setup_and_apply(source, error_reporter, consume_all); end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:139
  def to_s(outer_prec = T.unsafe(nil)); end

  # Override this in your Atoms::Base subclasses to implement parsing
  # behaviour.
  #
  # @raise [NotImplementedError]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:121
  def try(source, context, consume_all); end

  private

  # Produces an instance of Success and returns it.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:154
  def succ(result); end

  class << self
    # Debug printing - in Treetop syntax.
    #
    # source://parslet-2.0.0/lib/parslet/atoms/base.rb:135
    def precedence(prec); end
  end
end

# A series of helper functions that have the common topic of flattening
# result values into the intermediary tree that consists of Ruby Hashes and
# Arrays.
#
# This module has one main function, #flatten, that takes an annotated
# structure as input and returns the reduced form that users expect from
# Atom#parse.
#
# NOTE: Since all of these functions are just that, functions without
# side effects, they are in a module and not in a class. Its hard to draw
# the line sometimes, but this is beyond.
#
# source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:15
module Parslet::Atoms::CanFlatten
  # Takes a mixed value coming out of a parslet and converts it to a return
  # value for the user by dropping things and merging hashes.
  #
  # Named is set to true if this result will be embedded in a Hash result from
  # naming something using <code>.as(...)</code>. It changes the folding
  # semantics of repetition.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:23
  def flatten(value, named = T.unsafe(nil)); end

  # Flatten results from a repetition of a single parslet. named indicates
  # whether the user has named the result or not. If the user has named
  # the results, we want to leave an empty list alone - otherwise it is
  # turned into an empty string.
  #
  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:104
  def flatten_repetition(list, named); end

  # Flatten results from a sequence of parslets.
  #
  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:58
  def flatten_sequence(list); end

  # Lisp style fold left where the first element builds the basis for
  # an inject.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:49
  def foldl(list, &block); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:64
  def merge_fold(l, r); end

  # That annoying warning 'Duplicate subtrees while merging result' comes
  # from here. You should add more '.as(...)' names to your intermediary tree.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/can_flatten.rb:129
  def warn_about_duplicate_keys(h1, h2); end
end

# Stores the result of matching an atom against input in the #captures in
# parse context. Doing so will allow you to pull parts of the ongoing parse
# out later and use them to match other pieces of input.
#
# Example:
#   # After this, context.captures[:an_a] returns 'a'
#   str('a').capture(:an_a)
#
#   # Capture and use of the capture: (matches either 'aa' or 'bb')
#   match['ab'].capture(:first) >>
#     dynamic { |src, ctx| str(ctx.captures[:first]) }
#
# source://parslet-2.0.0/lib/parslet/atoms/capture.rb:14
class Parslet::Atoms::Capture < ::Parslet::Atoms::Base
  # @return [Capture] a new instance of Capture
  #
  # source://parslet-2.0.0/lib/parslet/atoms/capture.rb:17
  def initialize(parslet, name); end

  # source://parslet-2.0.0/lib/parslet/atoms/capture.rb:23
  def apply(source, context, consume_all); end

  # Returns the value of attribute name.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/capture.rb:15
  def name; end

  # Returns the value of attribute parslet.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/capture.rb:15
  def parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/capture.rb:34
  def to_s_inner(prec); end
end

# Helper class that implements a transient cache that maps position and
# parslet object to results. This is used for memoization in the packrat
# style.
#
# Also, error reporter is stored here and error reporting happens through
# this class. This makes the reporting pluggable.
#
# source://parslet-2.0.0/lib/parslet/atoms/context.rb:9
class Parslet::Atoms::Context
  # @param reporter [#err, #err_at] Error reporter (leave empty for default
  #   reporter)
  # @return [Context] a new instance of Context
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:12
  def initialize(reporter = T.unsafe(nil)); end

  # Returns the current captures made on the input (see
  # Parslet::Atoms::Base#capture). Use as follows:
  #
  #   context.captures[:foobar] # => returns capture :foobar
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:79
  def captures; end

  # Report an error.
  #
  # @see ErrorReporter
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:61
  def err(*args); end

  # Report an error at a given position.
  #
  # @see ErrorReporter
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:53
  def err_at(*args); end

  # Starts a new scope. Use the #scope method of Parslet::Atoms::DSL
  # to call this.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:84
  def scope; end

  # Report a successful parse.
  #
  # @see ErrorReporter::Contextual
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:69
  def succ(*args); end

  # Caches a parse answer for obj at source.pos. Applying the same parslet
  # at one position of input always yields the same result, unless the input
  # has changed.
  #
  # We need the entire source here so we can ask for how many characters
  # were consumed by a successful parse. Imitation of such a parse must
  # advance the input pos by the same amount of bytes.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:26
  def try_with_cache(obj, source, consume_all); end

  private

  # NOTE These methods use #object_id directly, since that seems to bring the
  # most performance benefit. This is a hot spot; going through
  # Atoms::Base#hash doesn't yield as much.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:96
  def lookup(obj, pos); end

  # source://parslet-2.0.0/lib/parslet/atoms/context.rb:99
  def set(obj, pos, val); end
end

# A mixin module that defines operations that can be called on any subclass
# of Parslet::Atoms::Base. These operations make parslets atoms chainable and
# allow combination of parslet atoms to form bigger parsers.
#
# Example:
#
#   str('foo') >> str('bar')
#   str('f').repeat
#   any.absent?               # also called The Epsilon
#
# source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:12
module Parslet::Atoms::DSL
  # Chains two parslet atoms together as a sequence.
  #
  # Example:
  #   str('a') >> str('b')
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:54
  def >>(parslet); end

  # Tests for absence of a parslet atom in the input stream without consuming
  # it.
  #
  # Example:
  #   # Only proceed the parse if 'a' is absent.
  #   str('a').absent?
  #
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:77
  def absent?; end

  # Marks a parslet atom as important for the tree output. This must be used
  # to achieve meaningful output from the #parse method.
  #
  # Example:
  #   str('a').as(:b) # will produce {:b => 'a'}
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:98
  def as(name); end

  # Captures a part of the input and stores it under the name given. This
  # is very useful to create self-referential parses. A capture stores
  # the result of its parse (may be complex) on a successful parse action.
  #
  # Example:
  #   str('a').capture(:b)  # will store captures[:b] == 'a'
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:109
  def capture(name); end

  # Returns a new parslet atom that will not show up in the output. This
  # is synonymous to calling #repeat(0,1). Generated tree value will always be
  # nil.
  #
  # Example:
  #   str('foo').ignore
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:45
  def ignore; end

  # Returns a new parslet atom that is only maybe present in the input. This
  # is synonymous to calling #repeat(0,1). Generated tree value will be
  # either nil (if atom is not present in the input) or the matched subtree.
  #
  # Example:
  #   str('foo').maybe
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:34
  def maybe; end

  # Tests for presence of a parslet atom in the input stream without consuming
  # it.
  #
  # Example:
  #   # Only proceed the parse if 'a' is present.
  #   str('a').present?
  #
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:88
  def present?; end

  # Construct a new atom that repeats the current atom min times at least and
  # at most max times. max can be nil to indicate that no maximum is present.
  #
  # Example:
  #   # match any number of 'a's
  #   str('a').repeat
  #
  #   # match between 1 and 3 'a's
  #   str('a').repeat(1,3)
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:23
  def repeat(min = T.unsafe(nil), max = T.unsafe(nil)); end

  # Chains two parslet atoms together to express alternation. A match will
  # always be attempted with the parslet on the left side first. If it doesn't
  # match, the right side will be tried.
  #
  # Example:
  #   # matches either 'a' OR 'b'
  #   str('a') | str('b')
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dsl.rb:66
  def |(parslet); end
end

# Evaluates a block at parse time. The result from the block must be a parser
# (something which implements #apply). In the first case, the parser will then
# be applied to the input, creating the result.
#
# Dynamic parses are never cached.
#
# Example:
#   dynamic { rand < 0.5 ? str('a') : str('b') }
#
# source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:10
class Parslet::Atoms::Dynamic < ::Parslet::Atoms::Base
  # @return [Dynamic] a new instance of Dynamic
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:13
  def initialize(block); end

  # Returns the value of attribute block.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:11
  def block; end

  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:17
  def cached?; end

  # source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:28
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/dynamic.rb:21
  def try(source, context, consume_all); end
end

# This wraps pieces of parslet definition and gives them a name. The wrapped
# piece is lazily evaluated and cached. This has two purposes:
#
# * Avoid infinite recursion during evaluation of the definition
# * Be able to print things by their name, not by their sometimes
#   complicated content.
#
# You don't normally use this directly, instead you should generate it by
# using the structuring method Parslet.rule.
#
# source://parslet-2.0.0/lib/parslet/atoms/entity.rb:11
class Parslet::Atoms::Entity < ::Parslet::Atoms::Base
  # @return [Entity] a new instance of Entity
  #
  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:13
  def initialize(name, label = T.unsafe(nil), &block); end

  # Returns the value of attribute block.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:12
  def block; end

  # Returns the value of attribute name.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:12
  def name; end

  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:26
  def parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:34
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:22
  def try(source, context, consume_all); end

  private

  # source://parslet-2.0.0/lib/parslet/atoms/entity.rb:38
  def raise_not_implemented; end
end

# Ignores the result of a match.
#
# Example:
#
#   str('foo')            # will return 'foo',
#   str('foo').ignore     # will return nil
#
# source://parslet-2.0.0/lib/parslet/atoms/ignored.rb:8
class Parslet::Atoms::Ignored < ::Parslet::Atoms::Base
  # @return [Ignored] a new instance of Ignored
  #
  # source://parslet-2.0.0/lib/parslet/atoms/ignored.rb:10
  def initialize(parslet); end

  # source://parslet-2.0.0/lib/parslet/atoms/ignored.rb:16
  def apply(source, context, consume_all); end

  # Returns the value of attribute parslet.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/ignored.rb:9
  def parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/ignored.rb:23
  def to_s_inner(prec); end
end

# source://parslet-2.0.0/lib/parslet/atoms/infix.rb:1
class Parslet::Atoms::Infix < ::Parslet::Atoms::Base
  # @return [Infix] a new instance of Infix
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:4
  def initialize(element, operations, &reducer); end

  # Returns the value of attribute element.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:2
  def element; end

  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:98
  def match_operation(source, context, consume_all); end

  # Returns the value of attribute operations.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:2
  def operations; end

  # A precedence climbing algorithm married to parslet, as described here
  #   http://eli.thegreenplace.net/2012/08/02/parsing-expressions-by-precedence-climbing/
  #
  # @note Error handling in this routine is done by throwing :error and
  #   as a value the error to return to parslet. This avoids cluttering
  #   the recursion logic here with parslet error handling.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:51
  def precedence_climb(source, context, consume_all, current_prec = T.unsafe(nil), needs_element = T.unsafe(nil)); end

  # Turns an array of the form ['1', '+', ['2', '*', '3']] into a hash that
  # reflects the same structure.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:23
  def produce_tree(ary); end

  # Returns the value of attribute reducer.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:2
  def reducer; end

  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:111
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:12
  def try(source, context, consume_all); end

  # source://parslet-2.0.0/lib/parslet/atoms/infix.rb:94
  def unwrap(expr); end
end

# Either positive or negative lookahead, doesn't consume its input.
#
# Example:
#
#   str('foo').present? # matches when the input contains 'foo', but leaves it
#
# source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:7
class Parslet::Atoms::Lookahead < ::Parslet::Atoms::Base
  # @return [Lookahead] a new instance of Lookahead
  #
  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:11
  def initialize(bound_parslet, positive = T.unsafe(nil)); end

  # Returns the value of attribute bound_parslet.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:9
  def bound_parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:19
  def error_msgs; end

  # Returns the value of attribute positive.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:8
  def positive; end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:136
  def precedence; end

  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:47
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/lookahead.rb:26
  def try(source, context, consume_all); end
end

# Names a match to influence tree construction.
#
# Example:
#
#   str('foo')            # will return 'foo',
#   str('foo').as(:foo)   # will return :foo => 'foo'
#
# source://parslet-2.0.0/lib/parslet/atoms/named.rb:8
class Parslet::Atoms::Named < ::Parslet::Atoms::Base
  # @return [Named] a new instance of Named
  #
  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:10
  def initialize(parslet, name); end

  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:16
  def apply(source, context, consume_all); end

  # Returns the value of attribute name.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:9
  def name; end

  # Returns the value of attribute parslet.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:9
  def parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:25
  def to_s_inner(prec); end

  private

  # source://parslet-2.0.0/lib/parslet/atoms/named.rb:29
  def produce_return_value(val); end
end

# The precedence module controls parenthesis during the #inspect printing
# of parslets. It is not relevant to other aspects of the parsing.
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:8
module Parslet::Atoms::Precedence; end

# 'a' | 'b'
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:13
Parslet::Atoms::Precedence::ALTERNATE = T.let(T.unsafe(nil), Integer)

# everything else
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:9
Parslet::Atoms::Precedence::BASE = T.let(T.unsafe(nil), Integer)

# &SOMETHING
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:10
Parslet::Atoms::Precedence::LOOKAHEAD = T.let(T.unsafe(nil), Integer)

# printing is done here.
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:14
Parslet::Atoms::Precedence::OUTER = T.let(T.unsafe(nil), Integer)

# 'a'+, 'a'?
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:11
Parslet::Atoms::Precedence::REPETITION = T.let(T.unsafe(nil), Integer)

# 'a' 'b'
#
# source://parslet-2.0.0/lib/parslet/atoms.rb:12
Parslet::Atoms::Precedence::SEQUENCE = T.let(T.unsafe(nil), Integer)

# Matches a special kind of regular expression that only ever matches one
# character at a time. Useful members of this family are: <code>character
# ranges, \\w, \\d, \\r, \\n, ...</code>
#
# Example:
#
#   match('[a-z]')  # matches a-z
#   match('\s')     # like regexps: matches space characters
#
# source://parslet-2.0.0/lib/parslet/atoms/re.rb:10
class Parslet::Atoms::Re < ::Parslet::Atoms::Base
  # @return [Re] a new instance of Re
  #
  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:12
  def initialize(match); end

  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:19
  def error_msgs; end

  # Returns the value of attribute match.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:11
  def match; end

  # Returns the value of attribute re.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:11
  def re; end

  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:37
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/re.rb:26
  def try(source, context, consume_all); end
end

# Matches a parslet repeatedly.
#
# Example:
#
#   str('a').repeat(1,3)  # matches 'a' at least once, but at most three times
#   str('a').maybe        # matches 'a' if it is present in the input (repeat(0,1))
#
# source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:9
class Parslet::Atoms::Repetition < ::Parslet::Atoms::Base
  # @raise [ArgumentError]
  # @return [Repetition] a new instance of Repetition
  #
  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:11
  def initialize(parslet, min, max, tag = T.unsafe(nil)); end

  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:25
  def error_msgs; end

  # Returns the value of attribute max.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:10
  def max; end

  # Returns the value of attribute min.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:10
  def min; end

  # Returns the value of attribute parslet.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:10
  def parslet; end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:136
  def precedence; end

  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:80
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/repetition.rb:32
  def try(source, context, consume_all); end
end

# Starts a new scope in the parsing process. Please also see the #captures
# method.
#
# source://parslet-2.0.0/lib/parslet/atoms/scope.rb:4
class Parslet::Atoms::Scope < ::Parslet::Atoms::Base
  # @return [Scope] a new instance of Scope
  #
  # source://parslet-2.0.0/lib/parslet/atoms/scope.rb:6
  def initialize(block); end

  # source://parslet-2.0.0/lib/parslet/atoms/scope.rb:16
  def apply(source, context, consume_all); end

  # Returns the value of attribute block.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/scope.rb:5
  def block; end

  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/atoms/scope.rb:12
  def cached?; end

  # source://parslet-2.0.0/lib/parslet/atoms/scope.rb:23
  def to_s_inner(prec); end
end

# A sequence of parslets, matched from left to right. Denoted by '>>'
#
# Example:
#
#   str('a') >> str('b')  # matches 'a', then 'b'
#
# source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:7
class Parslet::Atoms::Sequence < ::Parslet::Atoms::Base
  # @return [Sequence] a new instance of Sequence
  #
  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:9
  def initialize(*parslets); end

  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:21
  def >>(parslet); end

  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:15
  def error_msgs; end

  # Returns the value of attribute parslets.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:8
  def parslets; end

  # source://parslet-2.0.0/lib/parslet/atoms/base.rb:136
  def precedence; end

  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:45
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/sequence.rb:25
  def try(source, context, consume_all); end
end

# Matches a string of characters.
#
# Example:
#
#   str('foo') # matches 'foo'
#
# source://parslet-2.0.0/lib/parslet/atoms/str.rb:7
class Parslet::Atoms::Str < ::Parslet::Atoms::Base
  # @return [Str] a new instance of Str
  #
  # source://parslet-2.0.0/lib/parslet/atoms/str.rb:9
  def initialize(str); end

  # source://parslet-2.0.0/lib/parslet/atoms/str.rb:17
  def error_msgs; end

  # Returns the value of attribute str.
  #
  # source://parslet-2.0.0/lib/parslet/atoms/str.rb:8
  def str; end

  # source://parslet-2.0.0/lib/parslet/atoms/str.rb:38
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/atoms/str.rb:24
  def try(source, context, consume_all); end
end

# Represents a cause why a parse did fail. A lot of these objects are
# constructed - not all of the causes turn out to be failures for the whole
# parse.
#
# source://parslet-2.0.0/lib/parslet/cause.rb:6
class Parslet::Cause
  # @return [Cause] a new instance of Cause
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:7
  def initialize(message, source, pos, children); end

  # Returns an ascii tree representation of the causes of this node and its
  # children.
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:76
  def ascii_tree; end

  # When this cause is part of a tree of error causes: child nodes for this
  # node. Very often carries the reasons for this cause.
  #
  # @return [Array<Parslet::Cause>] A list of reasons for this cause.
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:29
  def children; end

  # @return [String, Array] A string or an array of message pieces that
  #   provide failure information. Use #to_s to get a formatted string.
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:14
  def message; end

  # Location of the error.
  #
  # @return [Fixnum] Position where the error happened. (character offset)
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:23
  def pos; end

  # Signals to the outside that the parse has failed. Use this in
  # conjunction with .format for nice error messages.
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:68
  def raise(exception_klass = T.unsafe(nil)); end

  # Update error message to include context provided by label
  # Update all child causes too (the same context applies to all causes)
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:50
  def set_label(l); end

  # @return [Parslet::Source] Source that was parsed when this error
  #   happend. Mainly used for line number information.
  #
  # source://parslet-2.0.0/lib/parslet/cause.rb:18
  def source; end

  # source://parslet-2.0.0/lib/parslet/cause.rb:55
  def to_s; end

  private

  # source://parslet-2.0.0/lib/parslet/cause.rb:93
  def append_prefix(stream, curved); end

  # source://parslet-2.0.0/lib/parslet/cause.rb:83
  def recursive_ascii_tree(node, stream, curved); end

  class << self
    # Appends 'at line LINE char CHAR' to the string given. Use +pos+ to
    # override the position of the +source+. This method returns an object
    # that can be turned into a string using #to_s.
    #
    # @param source [Parslet::Source] source that was parsed when this error
    #   happened
    # @param pos [Fixnum] position of error
    # @param str [String, Array<String>] message parts
    # @param children [Array<Parslet::Cause>] child nodes for this error tree
    # @return [Parslet::Cause] a new instance of {Parslet::Cause}
    #
    # source://parslet-2.0.0/lib/parslet/cause.rb:44
    def format(source, pos, str, children = T.unsafe(nil)); end
  end
end

# source://parslet-2.0.0/lib/parslet.rb:86
module Parslet::ClassMethods
  # Define an entity for the parser. This generates a method of the same
  # name that can be used as part of other patterns. Those methods can be
  # freely mixed in your parser class with real ruby methods.
  #
  #   class MyParser
  #     include Parslet
  #
  #     rule(:bar) { str('bar') }
  #     rule(:twobar) do
  #       bar >> bar
  #     end
  #
  #     root :twobar
  #   end
  #
  # source://parslet-2.0.0/lib/parslet.rb:102
  def rule(name, opts = T.unsafe(nil), &definition); end
end

# Provides a context for tree transformations to run in. The context allows
# accessing each of the bindings in the bindings hash as local method.
#
# Example:
#
#   ctx = Context.new(:a => :b)
#   ctx.instance_eval do
#     a # => :b
#   end
#
# @api private
#
# source://parslet-2.0.0/lib/parslet/context.rb:12
class Parslet::Context
  include ::Parslet
  extend ::Parslet::ClassMethods

  # @api private
  # @return [Context] a new instance of Context
  #
  # source://parslet-2.0.0/lib/parslet/context.rb:15
  def initialize(bindings); end
end

# Allows for delayed construction of #match. See also Parslet.match.
#
# @api private
#
# source://parslet-2.0.0/lib/parslet.rb:121
class Parslet::DelayedMatchConstructor
  # @api private
  #
  # source://parslet-2.0.0/lib/parslet.rb:122
  def [](str); end
end

# A namespace for all error reporters.
#
# source://parslet-2.0.0/lib/parslet/error_reporter.rb:3
module Parslet::ErrorReporter; end

# A reporter that tries to improve on the deepest error reporter by
# using heuristics to find the most relevant error and provide more
# context.
# The heuristic chooses the deepest error when parsing a sequence for which
# no alternative parsed successfully.
#
# Given the following parser:
#
# root(:call)
#
# rule(:call, label: 'call') {
#   identifier >> str('.') >> method
# }
#
# rule(:method, label: 'method call') {
#   identifier >> str('(') >> arguments.maybe >> str(')')
# }
#
# rule(:identifier, label: 'identifier') {
#   match['[:alnum:]'].repeat(1)
# }
#
# rule(:arguments, label: 'method call arguments') {
#   argument >> str(',') >> arguments | argument
# }
#
# rule(:argument) {
#    call | identifier
# }
#
# and the following source:
#
#   foo.bar(a,goo.baz(),c,)
#
# The contextual reporter returns the following causes:
#
# 0: Failed to match sequence (identifier '.' method call) at line 1 char 5
#    when parsing method call arguments.
# 1: Failed to match sequence (identifier '(' method call arguments? ')') at
#    line 1 char 22 when parsing method call arguments.
# 2: Failed to match [[:alnum:]] at line 1 char 23 when parsing method call
#    arguments.
#
# (where 2 is a child cause of 1 and 1 a child cause of 0)
#
# The last piece used by the reporter is the (newly introduced) ability
# to attach a label to rules that describe a sequence in the grammar. The
# labels are used in two places:
#   - In the "to_s" of Atom::Base so that any error message uses labels to
#     refer to atoms
#   - In the cause error messages to give information about which expression
#     failed to parse
#
# source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:57
class Parslet::ErrorReporter::Contextual < ::Parslet::ErrorReporter::Deepest
  # @return [Contextual] a new instance of Contextual
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:59
  def initialize; end

  # Produces an error cause that combines the message at the current level
  # with the errors that happened at a level below (children).
  # Compute and set label used by Cause to produce error message.
  #
  # @param atom [Parslet::Atoms::Base] parslet that failed
  # @param source [Source] Source that we're using for this parse. (line
  #   number information...)
  # @param message [String, Array] Error message at this level.
  # @param children [Array] A list of errors from a deeper level (or nil).
  # @return [Cause] An error tree combining children with message.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:95
  def err(atom, source, message, children = T.unsafe(nil)); end

  # Reset deepest error and its position and sequence index
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:79
  def reset; end

  # A sequence expression successfully parsed, reset all errors reported
  # for previous expressions in the sequence (an alternative matched)
  # Only reset errors if the position of the source that matched is higher
  # than the position of the source that was last successful (so we keep
  # errors that are the "deepest" but for which no alternative succeeded)
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:70
  def succ(source); end

  # Update error message label if given label is more relevant.
  # A label is more relevant if the position of the matched source is
  # bigger.
  #
  # @param label [String] label to apply if more relevant
  # @param bytepos [Integer] position in source code of matched source
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/contextual.rb:111
  def update_label(label, bytepos); end
end

# Instead of reporting the latest error that happens like {Tree} does,
# this class reports the deepest error. Depth is defined here as how
# advanced into the input an error happens. The errors close to the
# greatest depth tend to be more relevant to the end user, since they
# specify what could be done to make them go away.
#
# More specifically, errors produced by this reporter won't be related to
# the structure of the grammar at all. The positions of the errors will
# be advanced and convey at every grammar level what the deepest rule
# was to fail.
#
# source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:14
class Parslet::ErrorReporter::Deepest
  # @return [Deepest] a new instance of Deepest
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:15
  def initialize; end

  # Checks to see if the lineage of the cause given includes a cause with
  # an error position deeper than the current deepest cause stored. If
  # yes, it passes the cause through to the caller. If no, it returns the
  # current deepest error that was saved as a reference.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:66
  def deepest(cause); end

  # Returns the value of attribute deepest_cause.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:59
  def deepest_cause; end

  # Produces an error cause that combines the message at the current level
  # with the errors that happened at a level below (children).
  #
  # @param atom [Parslet::Atoms::Base] parslet that failed
  # @param source [Source] Source that we're using for this parse. (line
  #   number information...)
  # @param message [String, Array] Error message at this level.
  # @param children [Array] A list of errors from a deeper level (or nil).
  # @return [Cause] An error tree combining children with message.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:29
  def err(atom, source, message, children = T.unsafe(nil)); end

  # Produces an error cause that combines the message at the current level
  # with the errors that happened at a level below (children).
  #
  # @param atom [Parslet::Atoms::Base] parslet that failed
  # @param source [Source] Source that we're using for this parse. (line
  #   number information...)
  # @param message [String, Array] Error message at this level.
  # @param pos [Fixnum] The real position of the error.
  # @param children [Array] A list of errors from a deeper level (or nil).
  # @return [Cause] An error tree combining children with message.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:46
  def err_at(atom, source, message, pos, children = T.unsafe(nil)); end

  # Notification that an expression successfully parsed
  # not used, see ErrorReporter::Contextual
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:56
  def succ(source); end

  private

  # Returns the leaf from a given error tree with the biggest rank.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/deepest.rb:81
  def deepest_child(cause, rank = T.unsafe(nil)); end
end

# An error reporter has two central methods, one for reporting errors at
# the current parse position (#err) and one for reporting errors at a
# given parse position (#err_at). The reporter can return an object (a
# 'cause') that will be returned to the caller along with the information
# that the parse failed.
#
# When reporting errors on the outer levels of your parser, these methods
# get passed a list of error objects ('causes') from the inner levels. In
# this default implementation, the inner levels are considered error
# subtrees and are appended to the generated tree node at each level,
# thereby constructing an error tree.
#
# This error tree will report in parallel with the grammar structure that
# failed. A one-to-one correspondence exists between each error in the
# tree and the parslet atom that produced that error.
#
# The implementor is really free to use these return values as he sees
# fit. One example would be to return an error state object from these
# methods that is then updated as errors cascade up the parse derivation
# tree.
#
# source://parslet-2.0.0/lib/parslet/error_reporter/tree.rb:24
class Parslet::ErrorReporter::Tree
  # Produces an error cause that combines the message at the current level
  # with the errors that happened at a level below (children).
  #
  # @param atom [Parslet::Atoms::Base] parslet that failed
  # @param source [Source] Source that we're using for this parse. (line
  #   number information...)
  # @param message [String, Array] Error message at this level.
  # @param children [Array] A list of errors from a deeper level (or nil).
  # @return [Cause] An error tree combining children with message.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/tree.rb:35
  def err(atom, source, message, children = T.unsafe(nil)); end

  # Produces an error cause that combines the message at the current level
  # with the errors that happened at a level below (children).
  #
  # @param atom [Parslet::Atoms::Base] parslet that failed
  # @param source [Source] Source that we're using for this parse. (line
  #   number information...)
  # @param message [String, Array] Error message at this level.
  # @param pos [Fixnum] The real position of the error.
  # @param children [Array] A list of errors from a deeper level (or nil).
  # @return [Cause] An error tree combining children with message.
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/tree.rb:51
  def err_at(atom, source, message, pos, children = T.unsafe(nil)); end

  # Notification that an expression successfully parsed
  # not used, see ErrorReporter::Contextual
  #
  # source://parslet-2.0.0/lib/parslet/error_reporter/tree.rb:58
  def succ(source); end
end

# Allows specifying rules as strings using the exact same grammar that treetop
# does, minus the actions. This is on one hand a good example of a fully
# fledged parser and on the other hand might even turn out really useful.
#
# This can be viewed as an extension to parslet and might even be hosted in
# its own gem one fine day.
#
# source://parslet-2.0.0/lib/parslet/expression.rb:9
class Parslet::Expression
  include ::Parslet
  extend ::Parslet::ClassMethods

  # Creates a parslet from a foreign language expression.
  #
  # Example:
  #
  #   Parslet::Expression.new("'a' 'b'")
  #
  # @return [Expression] a new instance of Expression
  #
  # source://parslet-2.0.0/lib/parslet/expression.rb:20
  def initialize(str, opts = T.unsafe(nil), context = T.unsafe(nil)); end

  # Parses the string and returns a parse tree.
  #
  # source://parslet-2.0.0/lib/parslet/expression.rb:41
  def parse(str); end

  # Turns this expression into a parslet.
  #
  # source://parslet-2.0.0/lib/parslet/expression.rb:48
  def to_parslet; end

  # Transforms the parse tree into a parslet expression.
  #
  # source://parslet-2.0.0/lib/parslet/expression.rb:29
  def transform(tree); end
end

# source://parslet-2.0.0/lib/parslet/expression/treetop.rb:1
class Parslet::Expression::Treetop; end

# source://parslet-2.0.0/lib/parslet/expression/treetop.rb:2
class Parslet::Expression::Treetop::Parser < ::Parslet::Parser
  # source://parslet-2.0.0/lib/parslet.rb:104
  def alternatives; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def atom; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def char_class; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def dot; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def expression; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def integer; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def occurrence; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def repetition_spec; end

  # source://parslet-2.0.0/lib/parslet/parser.rb:55
  def root; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def simple; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def space; end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def space?; end

  # source://parslet-2.0.0/lib/parslet/expression/treetop.rb:67
  def spaced(str); end

  # source://parslet-2.0.0/lib/parslet.rb:104
  def string; end
end

# source://parslet-2.0.0/lib/parslet/expression/treetop.rb:72
class Parslet::Expression::Treetop::Transform < ::Parslet::Transform; end

# Raised when the parse failed to match. It contains the message that should
# be presented to the user. More details can be extracted from the
# exceptions #parse_failure_cause member: It contains an instance of {Parslet::Cause} that
# stores all the details of your failed parse in a tree structure.
#
#   begin
#     parslet.parse(str)
#   rescue Parslet::ParseFailed => failure
#     puts failure.parse_failure_cause.ascii_tree
#   end
#
# Alternatively, you can just require 'parslet/convenience' and call the
# method #parse_with_debug instead of #parse. This method will never raise
# and print error trees to stdout.
#
#   require 'parslet/convenience'
#   parslet.parse_with_debug(str)
#
# source://parslet-2.0.0/lib/parslet.rb:74
class Parslet::ParseFailed < ::StandardError
  # @return [ParseFailed] a new instance of ParseFailed
  #
  # source://parslet-2.0.0/lib/parslet.rb:75
  def initialize(message, parse_failure_cause = T.unsafe(nil)); end

  # Why the parse failed.
  #
  # @return [Parslet::Cause]
  #
  # source://parslet-2.0.0/lib/parslet.rb:83
  def parse_failure_cause; end
end

# The base class for all your parsers. Use as follows:
#
#   require 'parslet'
#
#   class MyParser < Parslet::Parser
#     rule(:a) { str('a').repeat }
#     root(:a)
#   end
#
#   pp MyParser.new.parse('aaaa')   # => 'aaaa'
#   pp MyParser.new.parse('bbbb')   # => Parslet::Atoms::ParseFailed:
#                                   #    Don't know what to do with bbbb at line 1 char 1.
#
# Parslet::Parser is also a grammar atom. This means that you can mix full
# fledged parsers freely with small parts of a different parser.
#
# Example:
#   class ParserA < Parslet::Parser
#     root :aaa
#     rule(:aaa) { str('a').repeat(3,3) }
#   end
#   class ParserB < Parslet::Parser
#     root :expression
#     rule(:expression) { str('b') >> ParserA.new >> str('b') }
#   end
#
# In the above example, ParserB would parse something like 'baaab'.
#
# source://parslet-2.0.0/lib/parslet/parser.rb:30
class Parslet::Parser < ::Parslet::Atoms::Base
  include ::Parslet
  extend ::Parslet::ClassMethods

  # source://parslet-2.0.0/lib/parslet/parser.rb:65
  def to_s_inner(prec); end

  # source://parslet-2.0.0/lib/parslet/parser.rb:61
  def try(source, context, consume_all); end

  class << self
    # Define the parsers #root function. This is the place where you start
    # parsing; if you have a rule for 'file' that describes what should be
    # in a file, this would be your root declaration:
    #
    #   class Parser
    #     root :file
    #     rule(:file) { ... }
    #   end
    #
    # #root declares a 'parse' function that works just like the parse
    # function that you can call on a simple parslet, taking a string as input
    # and producing parse output.
    #
    # In a way, #root is a shorthand for:
    #
    #   def parse(str)
    #     your_parser_root.parse(str)
    #   end
    #
    # source://parslet-2.0.0/lib/parslet/parser.rb:53
    def root(name); end
  end
end

# Matches trees against expressions. Trees are formed by arrays and hashes
# for expressing membership and sequence. The leafs of the tree are other
# classes.
#
# A tree issued by the parslet library might look like this:
#
#   {
#     :function_call => {
#       :name => 'foobar',
#       :args => [1, 2, 3]
#     }
#   }
#
# A pattern that would match against this tree would be:
#
#   { :function_call => { :name => simple(:name), :args => sequence(:args) }}
#
# Note that Parslet::Pattern only matches at a given subtree; it wont try
# to match recursively. To do that, please use Parslet::Transform.
#
# source://parslet-2.0.0/lib/parslet/pattern.rb:21
class Parslet::Pattern
  # @return [Pattern] a new instance of Pattern
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:22
  def initialize(pattern); end

  # Returns true if the tree element given by +tree+ matches the expression
  # given by +exp+. This match must respect bindings already made in
  # +bindings+. Note that bindings is carried along and modified.
  #
  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:49
  def element_match(tree, exp, bindings); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:88
  def element_match_ary_single(sequence, exp, bindings); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:72
  def element_match_binding(tree, exp, bindings); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:97
  def element_match_hash(tree, exp, bindings); end

  # Decides if the given subtree matches this pattern. Returns the bindings
  # made on a successful match or nil if the match fails. If you specify
  # bindings to be a hash, the mappings in it will be treated like bindings
  # made during an attempted match.
  #
  #   Pattern.new('a').match('a', :foo => 'bar') # => { :foo => 'bar' }
  #
  # @param subtree [String, Hash, Array] poro subtree returned by a parse
  # @param bindings [Hash] variable bindings to be verified
  # @return [Hash, nil] On success: variable bindings that allow a match. On
  #   failure: nil
  #
  # source://parslet-2.0.0/lib/parslet/pattern.rb:38
  def match(subtree, bindings = T.unsafe(nil)); end
end

# Binds a symbol to a sequence of simple leafs ([element1, element2, ...])
#
# source://parslet-2.0.0/lib/parslet/pattern/binding.rb:44
class Parslet::Pattern::SequenceBind < ::Parslet::Pattern::SubtreeBind
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:45
  def can_bind?(subtree); end
end

# Binds a symbol to a simple subtree, one that is not either a sequence of
# elements or a collection of attributes.
#
# source://parslet-2.0.0/lib/parslet/pattern/binding.rb:36
class Parslet::Pattern::SimpleBind < ::Parslet::Pattern::SubtreeBind
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:37
  def can_bind?(subtree); end
end

# Used internally for representing a bind placeholder in a Parslet::Transform
# pattern. This is the superclass for all bindings.
#
# It defines the most permissive kind of bind, the one that matches any subtree
# whatever it looks like.
#
# source://parslet-2.0.0/lib/parslet/pattern/binding.rb:8
class Parslet::Pattern::SubtreeBind < ::Struct
  # @return [Boolean]
  #
  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:17
  def can_bind?(subtree); end

  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:13
  def inspect; end

  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:9
  def variable_name; end

  private

  # source://parslet-2.0.0/lib/parslet/pattern/binding.rb:22
  def bind_type_name; end
end

# Encapsules the concept of a position inside a string.
#
# source://parslet-2.0.0/lib/parslet/position.rb:4
class Parslet::Position
  include ::Comparable

  # @return [Position] a new instance of Position
  #
  # source://parslet-2.0.0/lib/parslet/position.rb:9
  def initialize(string, bytepos); end

  # source://parslet-2.0.0/lib/parslet/position.rb:18
  def <=>(b); end

  # Returns the value of attribute bytepos.
  #
  # source://parslet-2.0.0/lib/parslet/position.rb:5
  def bytepos; end

  # source://parslet-2.0.0/lib/parslet/position.rb:14
  def charpos; end
end

# source://parslet-2.0.0/lib/parslet/scope.rb:1
class Parslet::Scope
  # @return [Scope] a new instance of Scope
  #
  # source://parslet-2.0.0/lib/parslet/scope.rb:32
  def initialize; end

  # source://parslet-2.0.0/lib/parslet/scope.rb:25
  def [](k); end

  # source://parslet-2.0.0/lib/parslet/scope.rb:28
  def []=(k, v); end

  # source://parslet-2.0.0/lib/parslet/scope.rb:39
  def pop; end

  # source://parslet-2.0.0/lib/parslet/scope.rb:36
  def push; end
end

# source://parslet-2.0.0/lib/parslet/scope.rb:7
class Parslet::Scope::Binding
  # @return [Binding] a new instance of Binding
  #
  # source://parslet-2.0.0/lib/parslet/scope.rb:10
  def initialize(parent = T.unsafe(nil)); end

  # source://parslet-2.0.0/lib/parslet/scope.rb:15
  def [](k); end

  # source://parslet-2.0.0/lib/parslet/scope.rb:20
  def []=(k, v); end

  # Returns the value of attribute parent.
  #
  # source://parslet-2.0.0/lib/parslet/scope.rb:8
  def parent; end
end

# Raised when the accessed slot has never been assigned a value.
#
# source://parslet-2.0.0/lib/parslet/scope.rb:4
class Parslet::Scope::NotFound < ::StandardError; end

# A slice is a small part from the parse input. A slice mainly behaves like
# any other string, except that it remembers where it came from (offset in
# original input).
#
# == Extracting line and column
#
# Using the #line_and_column method, you can extract the line and column in
# the original input where this slice starts.
#
# Example:
#   slice.line_and_column # => [1, 13]
#   slice.offset          # => 12
#
# == Likeness to strings
#
# Parslet::Slice behaves in many ways like a Ruby String. This likeness
# however is not complete - many of the myriad of operations String supports
# are not yet in Slice. You can always extract the internal string instance by
# calling #to_s.
#
# These omissions are somewhat intentional. Rather than maintaining a full
# delegation, we opt for a partial emulation that gets the job done.
#
# source://parslet-2.0.0/lib/parslet/slice.rb:25
class Parslet::Slice
  # Construct a slice using a string, an offset and an optional line cache.
  # The line cache should be able to answer to the #line_and_column message.
  #
  # @return [Slice] a new instance of Slice
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:33
  def initialize(position, string, line_cache = T.unsafe(nil)); end

  # Concatenate two slices; it is assumed that the second slice begins
  # where the first one ends. The offset of the resulting slice is the same
  # as the one of this slice.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:67
  def +(other); end

  # Compares slices to other slices or strings.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:45
  def ==(other); end

  # Prints the slice as <code>"string"@offset</code>.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:103
  def inspect; end

  # Returns the slices size in characters.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:57
  def length; end

  # Returns a <line, column> tuple referring to the original input.
  #
  # @raise [ArgumentError]
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:73
  def line_and_column; end

  # Returns the value of attribute line_cache.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:28
  def line_cache; end

  # Match regular expressions.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:51
  def match(regexp); end

  # source://parslet-2.0.0/lib/parslet/slice.rb:39
  def offset; end

  # Returns the value of attribute position.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:27
  def position; end

  # Returns the slices size in characters.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:57
  def size; end

  # Returns the value of attribute str.
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:26
  def str; end

  # source://parslet-2.0.0/lib/parslet/slice.rb:96
  def to_f; end

  # source://parslet-2.0.0/lib/parslet/slice.rb:93
  def to_i; end

  # Conversion operators -----------------------------------------------------
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:82
  def to_s; end

  # source://parslet-2.0.0/lib/parslet/slice.rb:87
  def to_slice; end

  # Conversion operators -----------------------------------------------------
  #
  # source://parslet-2.0.0/lib/parslet/slice.rb:82
  def to_str; end

  # source://parslet-2.0.0/lib/parslet/slice.rb:90
  def to_sym; end
end

# Wraps the input string for parslet.
#
# source://parslet-2.0.0/lib/parslet/source/line_cache.rb:3
class Parslet::Source
  # @raise [ArgumentError]
  # @return [Source] a new instance of Source
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:12
  def initialize(str); end

  # source://parslet-2.0.0/lib/parslet/source.rb:77
  def bytepos; end

  # @note Please be aware of encodings at this point.
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:83
  def bytepos=(n); end

  # Returns how many chars remain in the input.
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:54
  def chars_left; end

  # Returns how many chars there are between current position and the
  # string given. If the string given doesn't occur in the source, then
  # the remaining chars (#chars_left) are returned.
  #
  # @return [Fixnum] count of chars until str or #chars_left
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:64
  def chars_until(str); end

  # Consumes n characters from the input, returning them as a slice of the
  # input.
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:41
  def consume(n); end

  # Returns a <line, column> tuple for the given position. If no position is
  # given, line/column information is returned for the current position
  # given by #pos.
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:92
  def line_and_column(position = T.unsafe(nil)); end

  # Checks if the given pattern matches at the current input position.
  #
  # @param pattern [Regexp] pattern to check for
  # @return [Boolean] true if the pattern matches at #pos
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:33
  def match(pattern); end

  # Checks if the given pattern matches at the current input position.
  #
  # @param pattern [Regexp] pattern to check for
  # @return [Boolean] true if the pattern matches at #pos
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:33
  def matches?(pattern); end

  # Position of the parse as a character offset into the original string.
  #
  # @note Please be aware of encodings at this point.
  #
  # source://parslet-2.0.0/lib/parslet/source.rb:74
  def pos; end
end

# A cache for line start positions.
#
# source://parslet-2.0.0/lib/parslet/source/line_cache.rb:6
class Parslet::Source::LineCache
  # @return [LineCache] a new instance of LineCache
  #
  # source://parslet-2.0.0/lib/parslet/source/line_cache.rb:7
  def initialize; end

  # Returns a <line, column> tuple for the given input position. Input
  # position must be given as byte offset into original string.
  #
  # source://parslet-2.0.0/lib/parslet/source/line_cache.rb:19
  def line_and_column(pos); end

  # source://parslet-2.0.0/lib/parslet/source/line_cache.rb:36
  def scan_for_line_endings(start_pos, buf); end
end

# Mixin for arrays that implicitly give a number of ranges, where one range
# begins where the other one ends.
#
#   Example:
#
#     [10, 20, 30]
#     # would describe [0, 10], (10, 20], (20, 30]
#
# source://parslet-2.0.0/lib/parslet/source/line_cache.rb:66
module Parslet::Source::RangeSearch
  # source://parslet-2.0.0/lib/parslet/source/line_cache.rb:67
  def find_mid(left, right); end

  # Scans the array for the first number that is > than bound. Returns the
  # index of that number.
  #
  # source://parslet-2.0.0/lib/parslet/source/line_cache.rb:76
  def lbound(bound); end
end

# Transforms an expression tree into something else. The transformation
# performs a depth-first, post-order traversal of the expression tree. During
# that traversal, each time a rule matches a node, the node is replaced by the
# result of the block associated to the rule. Otherwise the node is accepted
# as is into the result tree.
#
# This is almost what you would generally do with a tree visitor, except that
# you can match several levels of the tree at once.
#
# As a consequence of this, the resulting tree will contain pieces of the
# original tree and new pieces. Most likely, you will want to transform the
# original tree wholly, so this isn't a problem.
#
# You will not be able to create a loop, given that each node will be replaced
# only once and then left alone. This means that the results of a replacement
# will not be acted upon.
#
# Example:
#
#   class Example < Parslet::Transform
#     rule(:string => simple(:x)) {  # (1)
#       StringLiteral.new(x)
#     }
#   end
#
# A tree transform (Parslet::Transform) is defined by a set of rules. Each
# rule can be defined by calling #rule with the pattern as argument. The block
# given will be called every time the rule matches somewhere in the tree given
# to #apply. It is passed a Hash containing all the variable bindings of this
# pattern match.
#
# In the above example, (1) illustrates a simple matching rule.
#
# Let's say you want to parse matching parentheses and distill a maximum nest
# depth. You would probably write a parser like the one in example/parens.rb;
# here's the relevant part:
#
#   rule(:balanced) {
#     str('(').as(:l) >> balanced.maybe.as(:m) >> str(')').as(:r)
#   }
#
# If you now apply this to a string like '(())', you get a intermediate parse
# tree that looks like this:
#
#   {
#     l: '(',
#     m: {
#       l: '(',
#       m: nil,
#       r: ')'
#     },
#     r: ')'
#   }
#
# This parse tree is good for debugging, but what we would really like to have
# is just the nesting depth. This transformation rule will produce that:
#
#   rule(:l => '(', :m => simple(:x), :r => ')') {
#     # innermost :m will contain nil
#     x.nil? ? 1 : x+1
#   }
#
# = Usage patterns
#
# There are four ways of using this class. The first one is very much
# recommended, followed by the second one for generality. The other ones are
# omitted here.
#
# Recommended usage is as follows:
#
#   class MyTransformator < Parslet::Transform
#     rule(...) { ... }
#     rule(...) { ... }
#     # ...
#   end
#   MyTransformator.new.apply(tree)
#
# Alternatively, you can use the Transform class as follows:
#
#   transform = Parslet::Transform.new do
#     rule(...) { ... }
#   end
#   transform.apply(tree)
#
# = Execution context
#
# The execution context of action blocks differs depending on the arity of
# said blocks. This can be confusing. It is however somewhat intentional. You
# should not create fat Transform descendants containing a lot of helper methods,
# instead keep your AST class construction in global scope or make it available
# through a factory. The following piece of code illustrates usage of global
# scope:
#
#   transform = Parslet::Transform.new do
#     rule(...) { AstNode.new(a_variable) }
#     rule(...) { Ast.node(a_variable) } # modules are nice
#   end
#   transform.apply(tree)
#
# And here's how you would use a class builder (a factory):
#
#   transform = Parslet::Transform.new do
#     rule(...) { builder.add_node(a_variable) }
#     rule(...) { |d| d[:builder].add_node(d[:a_variable]) }
#   end
#   transform.apply(tree, :builder => Builder.new)
#
# As you can see, Transform allows you to inject local context for your rule
# action blocks to use.
#
# source://parslet-2.0.0/lib/parslet/transform.rb:114
class Parslet::Transform
  include ::Parslet
  extend ::Parslet::ClassMethods
  extend ::Parslet

  # @return [Transform] a new instance of Transform
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:143
  def initialize(raise_on_unmatch = T.unsafe(nil), &block); end

  # Applies the transformation to a tree that is generated by Parslet::Parser
  # or a simple parslet. Transformation will proceed down the tree, replacing
  # parts/all of it with new objects. The resulting object will be returned.
  #
  # Using the context parameter, you can inject bindings for the transformation.
  # This can be used to allow access to the outside world from transform blocks,
  # like so:
  #
  #   document = # some class that you act on
  #   transform.apply(tree, document: document)
  #
  # The above will make document available to all your action blocks:
  #
  #   # Variant A
  #   rule(...) { document.foo(bar) }
  #   # Variant B
  #   rule(...) { |d| d[:document].foo(d[:bar]) }
  #
  # @param obj PORO ast to transform
  # @param context start context to inject into the bindings.
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:184
  def apply(obj, context = T.unsafe(nil)); end

  # Executes the block on the bindings obtained by Pattern#match, if such a match
  # can be made. Depending on the arity of the given block, it is called in
  # one of two environments: the current one or a clean toplevel environment.
  #
  # If you would like the current environment preserved, please use the
  # arity 1 variant of the block. Alternatively, you can inject a context object
  # and call methods on it (think :ctx => self).
  #
  #   # the local variable a is simulated
  #   t.call_on_match(:a => :b) { a }
  #   # no change of environment here
  #   t.call_on_match(:a => :b) { |d| d[:a] }
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:211
  def call_on_match(bindings, block); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:260
  def recurse_array(ary, ctx); end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:252
  def recurse_hash(hsh, ctx); end

  # Defines a rule to be applied whenever apply is called on a tree. A rule
  # is composed of two parts:
  #
  # * an *expression pattern*
  # * a *transformation block*
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:158
  def rule(expression, &block); end

  # Allow easy access to all rules, the ones defined in the instance and the
  # ones predefined in a subclass definition.
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:225
  def rules; end

  # @api private
  #
  # source://parslet-2.0.0/lib/parslet/transform.rb:231
  def transform_elt(elt, context); end

  class << self
    # @private
    #
    # source://parslet-2.0.0/lib/parslet/transform.rb:137
    def inherited(subclass); end

    # Define a rule for the transform subclass.
    #
    # source://parslet-2.0.0/lib/parslet/transform.rb:125
    def rule(expression, &block); end

    # Allows accessing the class' rules
    #
    # source://parslet-2.0.0/lib/parslet/transform.rb:133
    def rules; end
  end
end
