# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `octokit` gem.
# Please instead update this file by running `bin/tapioca gem octokit`.

# Ruby toolkit for the GitHub API
module Octokit
  extend ::Octokit::Configurable

  class << self
    # API client based on configured options {Configurable}
    #
    # @return [Octokit::Client] API wrapper
    def client; end

    # EnterpriseAdminClient client based on configured options {Configurable}
    #
    # @return [Octokit::EnterpriseAdminClient] API wrapper
    def enterprise_admin_client; end

    # EnterpriseManagementConsoleClient client based on configured options {Configurable}
    #
    # @return [Octokit::EnterpriseManagementConsoleClient] API wrapper
    def enterprise_management_console_client; end

    private

    def method_missing(method_name, *args, &block); end

    # @return [Boolean]
    def respond_to_missing?(method_name, include_private = T.unsafe(nil)); end
  end
end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'abuse'
class Octokit::AbuseDetected < ::Octokit::Forbidden; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'account was suspended'
class Octokit::AccountSuspended < ::Octokit::Forbidden; end

# Raised when a method requires an application client_id
# and secret but none is provided
class Octokit::ApplicationCredentialsRequired < ::StandardError; end

# Extracts options from method arguments
#
# @private
class Octokit::Arguments < ::Array
  # @return [Arguments] a new instance of Arguments
  def initialize(args); end

  # Returns the value of attribute options.
  def options; end
end

# Authentication methods for {Octokit::Client}
module Octokit::Authentication
  # Indicates if the client has OAuth Application
  # client_id and secret credentials to make anonymous
  # requests at a higher rate limit
  #
  # @return [Boolean]
  # @see https://developer.github.com/v3/#unauthenticated-rate-limited-requests
  def application_authenticated?; end

  # Indicates if the client was supplied  Basic Auth
  # username and password
  #
  # @return [Boolean]
  # @see https://developer.github.com/v3/#authentication
  def basic_authenticated?; end

  # Indicates if the client was supplied a bearer token
  #
  # @return [Boolean]
  # @see https://developer.github.com/early-access/integrations/authentication/#as-an-integration
  def bearer_authenticated?; end

  # Indicates if the client was supplied an OAuth
  # access token
  #
  # @return [Boolean]
  # @see https://developer.github.com/v3/#authentication
  def token_authenticated?; end

  # Indicates if the client was supplied an OAuth
  # access token or Basic Auth username and password
  #
  # @return [Boolean]
  # @see https://developer.github.com/v3/#authentication
  def user_authenticated?; end

  private

  def login_from_netrc; end
end

# In Faraday 2.x, the authorization middleware uses new interface
Octokit::Authentication::FARADAY_BASIC_AUTH_KEYS = T.let(T.unsafe(nil), Array)

# Raised when GitHub returns a 502 HTTP status code
class Octokit::BadGateway < ::Octokit::ServerError; end

# Raised when GitHub returns a 400 HTTP status code
class Octokit::BadRequest < ::Octokit::ClientError; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'billing issue'
class Octokit::BillingIssue < ::Octokit::Forbidden; end

# Raised when GitHub returns a 404 HTTP status code
# and body matches 'Branch not protected'
class Octokit::BranchNotProtected < ::Octokit::ClientError; end

# Client for the GitHub API
#
# @see https://developer.github.com
class Octokit::Client
  include ::Octokit::Authentication
  include ::Octokit::Configurable
  include ::Octokit::Connection
  include ::Octokit::Preview
  include ::Octokit::Warnable
  include ::Octokit::Client::ActionsSecrets
  include ::Octokit::Client::Authorizations
  include ::Octokit::Client::Checks
  include ::Octokit::Client::Commits
  include ::Octokit::Client::CommitComments
  include ::Octokit::Client::CommitPulls
  include ::Octokit::Client::CommitBranches
  include ::Octokit::Client::CommunityProfile
  include ::Octokit::Client::Contents
  include ::Octokit::Client::Deployments
  include ::Octokit::Client::Downloads
  include ::Octokit::Client::Emojis
  include ::Octokit::Client::Events
  include ::Octokit::Client::Feeds
  include ::Octokit::Client::Gists
  include ::Octokit::Client::Gitignore
  include ::Octokit::Client::Hooks
  include ::Octokit::Client::ActionsWorkflows
  include ::Octokit::Client::ActionsWorkflowRuns
  include ::Octokit::Client::Apps
  include ::Octokit::Client::Issues
  include ::Octokit::Client::Labels
  include ::Octokit::Client::LegacySearch
  include ::Octokit::Client::Licenses
  include ::Octokit::Client::Meta
  include ::Octokit::Client::Markdown
  include ::Octokit::Client::Marketplace
  include ::Octokit::Client::Milestones
  include ::Octokit::Client::Notifications
  include ::Octokit::Client::OauthApplications
  include ::Octokit::Client::Objects
  include ::Octokit::Client::Organizations
  include ::Octokit::Client::Pages
  include ::Octokit::Client::Projects
  include ::Octokit::Client::PubSubHubbub
  include ::Octokit::Client::PullRequests
  include ::Octokit::Client::RateLimit
  include ::Octokit::Client::Reactions
  include ::Octokit::Client::Refs
  include ::Octokit::Client::Releases
  include ::Octokit::Client::Repositories
  include ::Octokit::Client::RepositoryInvitations
  include ::Octokit::Client::Reviews
  include ::Octokit::Client::Say
  include ::Octokit::Client::Search
  include ::Octokit::Client::ServiceStatus
  include ::Octokit::Client::SourceImport
  include ::Octokit::Client::Stats
  include ::Octokit::Client::Statuses
  include ::Octokit::Client::Traffic
  include ::Octokit::Client::Users

  # @return [Client] a new instance of Client
  def initialize(options = T.unsafe(nil)); end

  # Set OAuth access token for authentication
  #
  # @param value [String] 40 character GitHub OAuth access token
  def access_token=(value); end

  # Duplicate client using client_id and client_secret as
  # Basic Authentication credentials.
  #
  # @example
  #   Octokit.client_id = "foo"
  #   Octokit.client_secret = "bar"
  #
  #   # GET https://api.github.com/?client_id=foo&client_secret=bar
  #   Octokit.get "/"
  #
  #   Octokit.client.as_app do |client|
  #   # GET https://foo:bar@api.github.com/
  #   client.get "/"
  #   end
  # @yield [app_client]
  def as_app(key = T.unsafe(nil), secret = T.unsafe(nil)); end

  # Set Bearer Token for authentication
  #
  # @param value [String] JWT
  def bearer_token=(value); end

  # Set OAuth app client_id
  #
  # @param value [String] 20 character GitHub OAuth app client_id
  def client_id=(value); end

  # Set OAuth app client_secret
  #
  # @param value [String] 40 character GitHub OAuth app client_secret
  def client_secret=(value); end

  def client_without_redirects(options = T.unsafe(nil)); end

  # Text representation of the client, masking tokens and passwords
  #
  # @return [String]
  def inspect; end

  # Set username for authentication
  #
  # @param value [String] GitHub username
  def login=(value); end

  # Set password for authentication
  #
  # @param value [String] GitHub password
  def password=(value); end

  private

  # convenience method for constructing a user specific path, if the user is logged in
  def user_path(user, path); end
end

# Methods for the Actions Secrets API
#
# @see https://developer.github.com/v3/actions/secrets/
module Octokit::Client::ActionsSecrets
  # Create or update secrets
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param name [String] Name of secret
  # @param options [Hash] encrypted_value and key_id
  # @see https://developer.github.com/v3/actions/secrets/#create-or-update-a-secret-for-a-repository
  def create_or_update_secret(repo, name, options); end

  # Delete a secret
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param name [String] Name of secret
  # @see https://developer.github.com/v3/actions/secrets/#delete-a-secret-from-a-repository
  def delete_secret(repo, name); end

  # Get public key for secrets encryption
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Hash] key_id and key
  # @see https://developer.github.com/v3/actions/secrets/#get-your-public-key
  def get_public_key(repo); end

  # Get a secret
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param name [String] Name of secret
  # @return [Hash] name, created_at and updated_at
  # @see https://developer.github.com/v3/actions/secrets/#get-a-secret
  def get_secret(repo, name); end

  # List secrets
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Hash] total_count and list of secrets (each item is hash with name, created_at and updated_at)
  # @see https://developer.github.com/v3/actions/secrets/#list-secrets-for-a-repository
  def list_secrets(repo); end
end

module Octokit::Client::ActionsWorkflowRuns
  # Cancels a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [Boolean] Returns true if the cancellation was accepted
  # @see https://developer.github.com/v3/actions/workflow-runs/#cancel-a-workflow-run
  def cancel_workflow_run(repo, id, options = T.unsafe(nil)); end

  # Deletes a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [Boolean] Returns true if the run is deleted
  # @see https://docs.github.com/en/rest/reference/actions#delete-a-workflow-run
  def delete_workflow_run(repo, id, options = T.unsafe(nil)); end

  # Delets all log files of a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [Boolean] Returns true if the logs are deleted
  # @see https://developer.github.com/v3/actions/workflow-runs/#delete-workflow-run-logs
  def delete_workflow_run_logs(repo, id, options = T.unsafe(nil)); end

  # List all workflow runs for a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflow-runs/#list-repository-workflow-runs
  def list_repository_workflow_runs(repo, options = T.unsafe(nil)); end

  # List all runs for a repository workflow
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param workflow [Integer, String] Id or file name of the workflow
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs
  def list_workflow_runs(repo, workflow, options = T.unsafe(nil)); end

  # List all workflow runs for a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflow-runs/#list-repository-workflow-runs
  def repository_workflow_runs(repo, options = T.unsafe(nil)); end

  # Re-runs a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [Boolean] Returns true if the re-run request was accepted
  # @see https://developer.github.com/v3/actions/workflow-runs/#re-run-a-workflow
  def rerun_workflow_run(repo, id, options = T.unsafe(nil)); end

  # Get a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [Sawyer::Resource] Run information
  # @see https://developer.github.com/v3/actions/workflow-runs/#get-a-workflow-run
  def workflow_run(repo, id, options = T.unsafe(nil)); end

  # Get a download url for archived log files of a workflow run
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] Id of a workflow run
  # @return [String] URL to the archived log files of the run
  # @see https://developer.github.com/v3/actions/workflow-runs/#download-workflow-run-logs
  def workflow_run_logs(repo, id, options = T.unsafe(nil)); end

  # List all runs for a repository workflow
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param workflow [Integer, String] Id or file name of the workflow
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflow-runs/#list-workflow-runs
  def workflow_runs(repo, workflow, options = T.unsafe(nil)); end
end

# Methods for the Actions Workflows API
#
# @see https://developer.github.com/v3/actions/workflows
module Octokit::Client::ActionsWorkflows
  # Get the workflows in a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflows/#list-repository-workflows
  def list_workflows(repo, options = T.unsafe(nil)); end

  # Get single workflow in a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer, String] Id or file name of the workflow
  # @return [Sawyer::Resource] A single workflow
  # @see https://developer.github.com/v3/actions/workflows/#get-a-workflow
  def workflow(repo, id, options = T.unsafe(nil)); end

  # Create a workflow dispatch event
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer, String] Id or file name of the workflow
  # @param ref [String] A SHA, branch name, or tag name
  # @return [Boolean] True if event was dispatched, false otherwise
  # @see https://docs.github.com/en/rest/reference/actions#create-a-workflow-dispatch-event
  def workflow_dispatch(repo, id, ref, options = T.unsafe(nil)); end

  # Get the workflows in a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] the total count and an array of workflows
  # @see https://developer.github.com/v3/actions/workflows/#list-repository-workflows
  def workflows(repo, options = T.unsafe(nil)); end
end

# Methods for the Apps API
module Octokit::Client::Apps
  # Add a single repository to an installation
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param repo [Integer] The id of the GitHub repository
  # @param options [Hash] A customizable set of options
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/apps/installations/#add-repository-to-installation
  def add_repo_to_installation(installation, repo, options = T.unsafe(nil)); end

  # Add a single repository to an installation
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param repo [Integer] The id of the GitHub repository
  # @param options [Hash] A customizable set of options
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/apps/installations/#add-repository-to-installation
  def add_repository_to_app_installation(installation, repo, options = T.unsafe(nil)); end

  def add_repository_to_integration_installation(installation, repo, options = T.unsafe(nil)); end

  # Get the authenticated App
  #
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] App information
  # @see https://developer.github.com/v3/apps/#get-the-authenticated-app
  def app(options = T.unsafe(nil)); end

  # Create a new installation token
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param options [Hash] A customizable set of options
  # @return [<Sawyer::Resource>] An installation token
  # @see https://developer.github.com/v3/apps/#create-a-new-installation-token
  def create_app_installation_access_token(installation, options = T.unsafe(nil)); end

  # Create a new installation token
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param options [Hash] A customizable set of options
  # @return [<Sawyer::Resource>] An installation token
  # @see https://developer.github.com/v3/apps/#create-a-new-installation-token
  def create_installation_access_token(installation, options = T.unsafe(nil)); end

  def create_integration_installation_access_token(installation, options = T.unsafe(nil)); end

  # Delete an installation and uninstall a GitHub App
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param options [Hash] A customizable set of options
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/apps/#delete-an-installation
  def delete_installation(installation, options = T.unsafe(nil)); end

  # Find all installations that belong to an App
  #
  # @param options [Hash] A customizable set of options
  # @return [Array<Sawyer::Resource>] the total_count and an array of installations
  # @see https://developer.github.com/v3/apps/#list-installations
  def find_app_installations(options = T.unsafe(nil)); end

  # List repositories accessible to the user for an installation
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] the total_count and an array of repositories
  # @see https://developer.github.com/v3/apps/installations/#list-repositories-accessible-to-the-user-for-an-installation
  def find_installation_repositories_for_user(installation, options = T.unsafe(nil)); end

  # Find all installations that belong to an App
  #
  # @param options [Hash] A customizable set of options
  # @return [Array<Sawyer::Resource>] the total_count and an array of installations
  # @see https://developer.github.com/v3/apps/#list-installations
  def find_installations(options = T.unsafe(nil)); end

  def find_integration_installations(options = T.unsafe(nil)); end

  # Enables an app to find the organization's installation information.
  #
  # @param organization [String] Organization GitHub login
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] Installation information
  # @see https://developer.github.com/v3/apps/#get-an-organization-installation
  def find_organization_installation(organization, options = T.unsafe(nil)); end

  # Enables an app to find the repository's installation information.
  #
  # @param repo [String] A GitHub repository
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] Installation information
  # @see https://developer.github.com/v3/apps/#get-a-repository-installation
  def find_repository_installation(repo, options = T.unsafe(nil)); end

  # Enables an app to find the user's installation information.
  #
  # @param user [String] GitHub user login
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] Installation information
  # @see https://developer.github.com/v3/apps/#get-a-user-installation
  def find_user_installation(user, options = T.unsafe(nil)); end

  # Find all installations that are accessible to the authenticated user
  #
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] the total_count and an array of installations
  # @see https://developer.github.com/v3/apps/installations/#list-installations-for-a-user
  def find_user_installations(options = T.unsafe(nil)); end

  # Get a single installation
  #
  # @param id [Integer] Installation id
  # @return [Sawyer::Resource] Installation information
  # @see https://developer.github.com/v3/apps/#get-an-installation
  def installation(id, options = T.unsafe(nil)); end

  # List repositories that are accessible to the authenticated installation
  #
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] the total_count and an array of repositories
  # @see https://developer.github.com/v3/apps/installations/#list-repositories
  def list_app_installation_repositories(options = T.unsafe(nil)); end

  # List repositories that are accessible to the authenticated installation
  #
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] the total_count and an array of repositories
  # @see https://developer.github.com/v3/apps/installations/#list-repositories
  def list_installation_repos(options = T.unsafe(nil)); end

  def list_integration_installation_repositories(options = T.unsafe(nil)); end

  # Remove a single repository to an installation
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param repo [Integer] The id of the GitHub repository
  # @param options [Hash] A customizable set of options
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/apps/installations/#remove-repository-from-installation
  def remove_repo_from_installation(installation, repo, options = T.unsafe(nil)); end

  # Remove a single repository to an installation
  #
  # @param installation [Integer] The id of a GitHub App Installation
  # @param repo [Integer] The id of the GitHub repository
  # @param options [Hash] A customizable set of options
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/apps/installations/#remove-repository-from-installation
  def remove_repository_from_app_installation(installation, repo, options = T.unsafe(nil)); end

  def remove_repository_from_integration_installation(installation, repo, options = T.unsafe(nil)); end
end

# Methods for the Authorizations API
#
# @see https://developer.github.com/v3/oauth_authorizations/#oauth-authorizations-api
module Octokit::Client::Authorizations
  # Get a single authorization for the authenticated user.
  #
  # You can only access your own tokens, and only through
  # Basic Authentication.
  #
  # @example Show authorization for user ctshryock's Travis auth
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.authorization(999999)
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/oauth_authorizations/#get-a-single-authorization
  def authorization(number, options = T.unsafe(nil)); end

  # List the authenticated user's authorizations
  #
  # API for users to manage their own tokens.
  # You can only access your own tokens, and only through
  # Basic Authentication.
  #
  # @example List authorizations for user ctshryock
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.authorizations
  # @return [Array<Sawyer::Resource>] A list of authorizations for the authenticated user
  # @see https://developer.github.com/v3/oauth_authorizations/#list-your-authorizations
  def authorizations(options = T.unsafe(nil)); end

  # Get the URL to authorize a user for an application via the web flow
  #
  # @example
  #   @client.authorize_url('xxxx')
  # @option options
  # @option options
  # @option options
  # @param app_id [String] Client Id we received when our application was registered with GitHub.
  # @param options [Hash] a customizable set of options
  # @return [String] The url to redirect the user to authorize.
  # @see Octokit::Client
  # @see https://developer.github.com/v3/oauth/#web-application-flow
  def authorize_url(app_id = T.unsafe(nil), options = T.unsafe(nil)); end

  # Create an authorization for the authenticated user.
  #
  # You can create your own tokens, and only through
  # Basic Authentication.
  #
  # @example Create a new authorization for user ctshryock's project Zoidberg
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.create_authorization({:scopes => ["public_repo", "gist"], :note => "Why not Zoidberg?", :note_url=> "https://en.wikipedia.org/wiki/Zoidberg"})
  # @example Create a new OR return an existing authorization to be used by a specific client for user ctshryock's project Zoidberg
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.create_authorization({:idempotent => true, :client_id => 'xxxx', :client_secret => 'yyyy', :scopes => ["user"]})
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/oauth/#scopes Available scopes
  # @see https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization
  # @see https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app
  def create_authorization(options = T.unsafe(nil)); end

  # Delete an authorization for the authenticated user.
  #
  # You can delete your own tokens, and only through
  # Basic Authentication.
  #
  # @example Delete an authorization
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.delete_authorization(999999)
  # @param number [Number] An existing Authorization ID
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/oauth_authorizations/#delete-an-authorization
  def delete_authorization(number, options = T.unsafe(nil)); end

  # Revoke all tokens for an app
  #
  # Applications can revoke all of their tokens in a single request
  #
  # @deprecated As of January 25th, 2016: https://developer.github.com/changes/2014-04-08-reset-api-tokens/
  # @return [Boolean] false
  def revoke_all_application_authorizations(_options = T.unsafe(nil)); end

  # Check scopes for a token
  #
  # @param token [String] GitHub OAuth token
  # @param options [Hash] Header params for request
  # @raise [ArgumentError]
  # @return [Array<String>] OAuth scopes
  # @see https://developer.github.com/v3/oauth/#scopes
  def scopes(token = T.unsafe(nil), options = T.unsafe(nil)); end

  # Update an authorization for the authenticated user.
  #
  # You can update your own tokens, but only through
  # Basic Authentication.
  #
  # @example Update the authorization for user ctshryock's project Zoidberg
  #   client = Octokit::Client.new(:login => 'ctshryock', :password => 'secret')
  #   client.update_authorization(999999, {:add_scopes => ["gist", "repo"], :note => "Why not Zoidberg possibly?"})
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single (updated) authorization for the authenticated user
  # @see https://developer.github.com/v3/oauth_authorizations/#update-an-existing-authorization
  # @see https://developer.github.com/v3/oauth/#scopes for available scopes
  def update_authorization(number, options = T.unsafe(nil)); end
end

# Header keys that can be passed in options hash to {#get},{#head}
Octokit::Client::CONVENIENCE_HEADERS = T.let(T.unsafe(nil), Set)

# Methods for the Checks API
#
# @see https://developer.github.com/v3/checks/
module Octokit::Client::Checks
  # Get a single check run
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check run
  # @return [Sawyer::Resource] A hash representing the check run
  # @see https://developer.github.com/v3/checks/runs/#get-a-single-check-run
  def check_run(repo, id, options = T.unsafe(nil)); end

  # List annotations for a check run
  #
  # @example List annotations for a check run
  #   annotations = @client.check_run_annotations("octocat/Hello-World", 51295429)
  #   annotations.count # => 1
  #   annotations[0].path # => "README.md"
  #   annotations[0].message # => "Looks good!"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check run
  # @return [Array<Sawyer::Resource>] An array of hashes representing check run annotations
  # @see https://developer.github.com/v3/checks/runs/#list-annotations-for-a-check-run
  def check_run_annotations(repo, id, options = T.unsafe(nil)); end

  # List check runs in a check suite
  #
  # @example List check runs in a check suite
  #   result = @client.check_runs_for_check_suite("octocat/Hello-World", 50440400, status: "in_progress")
  #   result.total_count # => 1
  #   result.check_runs.count # => 1
  #   result.check_runs[0].check_suite.id # => 50440400
  #   result.check_runs[0].status # => "in_progress"
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check suite
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check runs
  # @see https://developer.github.com/v3/checks/runs/#list-check-runs-in-a-check-suite
  def check_runs_for_check_suite(repo, id, options = T.unsafe(nil)); end

  # List check runs for a specific ref
  #
  # @example List check runs for a specific ref
  #   result = @client.check_runs_for_ref("octocat/Hello-World", "7638417db6d59f3c431d3e1f261cc637155684cd", status: "in_progress")
  #   result.total_count # => 1
  #   result.check_runs.count # => 1
  #   result.check_runs[0].id # => 51295429
  #   result.check_runs[0].status # => "in_progress"
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param ref [String] A SHA, branch name, or tag name
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check runs
  # @see https://developer.github.com/v3/checks/runs/#list-check-runs-for-a-specific-ref
  def check_runs_for_ref(repo, ref, options = T.unsafe(nil)); end

  # Get a single check suite
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check suite
  # @return [Sawyer::Resource] A hash representing the check suite
  # @see https://developer.github.com/v3/checks/suites/#get-a-single-check-suite
  def check_suite(repo, id, options = T.unsafe(nil)); end

  # List check suites for a specific ref
  #
  # @example List check suites for a specific ref
  #   result = @client.check_suites_for_ref("octocat/Hello-World", "7638417db6d59f3c431d3e1f261cc637155684cd", app_id: 76765)
  #   result.total_count # => 1
  #   result.check_suites.count # => 1
  #   result.check_suites[0].id # => 50440400
  #   result.check_suites[0].app.id # => 76765
  # @option options
  # @option options
  # @param ref [String] A SHA, branch name, or tag name
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check suites
  # @see https://developer.github.com/v3/checks/suites/#list-check-suites-for-a-specific-ref
  def check_suites_for_ref(repo, ref, options = T.unsafe(nil)); end

  # Create a check run
  #
  # @example Create a check run
  #   check_run = @client.create_check_run("octocat/Hello-World", "my-check", "7638417db6d59f3c431d3e1f261cc637155684cd")
  #   check_run.name # => "my-check"
  #   check_run.head_sha # => "7638417db6d59f3c431d3e1f261cc637155684cd"
  #   check_run.status # => "queued"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param name [String] The name of the check
  # @param head_sha [String] The SHA of the commit to check
  # @return [Sawyer::Resource] A hash representing the new check run
  # @see https://developer.github.com/v3/checks/runs/#create-a-check-run
  def create_check_run(repo, name, head_sha, options = T.unsafe(nil)); end

  # Create a check suite
  #
  # @example Create a check suite
  #   check_suite = @client.create_check_suite("octocat/Hello-World", "7638417db6d59f3c431d3e1f261cc637155684cd")
  #   check_suite.head_sha # => "7638417db6d59f3c431d3e1f261cc637155684cd"
  #   check_suite.status # => "queued"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param head_sha [String] The SHA of the commit to check
  # @return [Sawyer::Resource] A hash representing the new check suite
  # @see https://developer.github.com/v3/checks/suites/#create-a-check-suite
  def create_check_suite(repo, head_sha, options = T.unsafe(nil)); end

  # List check runs in a check suite
  #
  # @example List check runs in a check suite
  #   result = @client.check_runs_for_check_suite("octocat/Hello-World", 50440400, status: "in_progress")
  #   result.total_count # => 1
  #   result.check_runs.count # => 1
  #   result.check_runs[0].check_suite.id # => 50440400
  #   result.check_runs[0].status # => "in_progress"
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check suite
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check runs
  # @see https://developer.github.com/v3/checks/runs/#list-check-runs-in-a-check-suite
  def list_check_runs_for_check_suite(repo, id, options = T.unsafe(nil)); end

  # List check runs for a specific ref
  #
  # @example List check runs for a specific ref
  #   result = @client.check_runs_for_ref("octocat/Hello-World", "7638417db6d59f3c431d3e1f261cc637155684cd", status: "in_progress")
  #   result.total_count # => 1
  #   result.check_runs.count # => 1
  #   result.check_runs[0].id # => 51295429
  #   result.check_runs[0].status # => "in_progress"
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param ref [String] A SHA, branch name, or tag name
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check runs
  # @see https://developer.github.com/v3/checks/runs/#list-check-runs-for-a-specific-ref
  def list_check_runs_for_ref(repo, ref, options = T.unsafe(nil)); end

  # List check suites for a specific ref
  #
  # @example List check suites for a specific ref
  #   result = @client.check_suites_for_ref("octocat/Hello-World", "7638417db6d59f3c431d3e1f261cc637155684cd", app_id: 76765)
  #   result.total_count # => 1
  #   result.check_suites.count # => 1
  #   result.check_suites[0].id # => 50440400
  #   result.check_suites[0].app.id # => 76765
  # @option options
  # @option options
  # @param ref [String] A SHA, branch name, or tag name
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] A set of optional filters
  # @return [Sawyer::Resource] A hash representing a collection of check suites
  # @see https://developer.github.com/v3/checks/suites/#list-check-suites-for-a-specific-ref
  def list_check_suites_for_ref(repo, ref, options = T.unsafe(nil)); end

  # Rerequest check suite
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check suite
  # @return [Boolean] True if successful, raises an error otherwise
  # @see https://developer.github.com/v3/checks/suites/#rerequest-check-suite
  def rerequest_check_suite(repo, id, options = T.unsafe(nil)); end

  # Set preferences for check suites on a repository
  #
  # @example Set preferences for check suites on a repository
  #   result = @client.set_check_suite_preferences("octocat/Hello-World", auto_trigger_checks: [{ app_id: 76765, setting: false }])
  #   result.preferences.auto_trigger_checks.count # => 1
  #   result.preferences.auto_trigger_checks[0].app_id # => 76765
  #   result.preferences.auto_trigger_checks[0].setting # => false
  #   result.repository.full_name # => "octocat/Hello-World"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] Preferences to set
  # @return [Sawyer::Resource] A hash representing the repository's check suite preferences
  # @see https://developer.github.com/v3/checks/suites/#set-preferences-for-check-suites-on-a-repository
  def set_check_suite_preferences(repo, options = T.unsafe(nil)); end

  # Update a check run
  #
  # @example Update a check run
  #   check_run = @client.update_check_run("octocat/Hello-World", 51295429, status: "in_progress")
  #   check_run.id # => 51295429
  #   check_run.status # => "in_progress"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The ID of the check run
  # @return [Sawyer::Resource] A hash representing the updated check run
  # @see https://developer.github.com/v3/checks/runs/#update-a-check-run
  def update_check_run(repo, id, options = T.unsafe(nil)); end
end

# Methods for the Branches for HEAD API
#
# @see https://developer.github.com/v3/repos/commits/
module Octokit::Client::CommitBranches
  # List branches for a single HEAD commit
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] The SHA of the commit whose branches will be fetched
  # @return [Array] List of branches
  # @see https://developer.github.com/v3/repos/commits/#list-branches-for-head-commit
  def commit_branches(repo, sha, options = T.unsafe(nil)); end
end

# Methods for the Commit Comments API
#
# @see https://developer.github.com/v3/repos/comments/
module Octokit::Client::CommitComments
  # Get a single commit comment
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [String] The ID of the comment to fetch
  # @return [Sawyer::Resource] Commit comment
  # @see https://developer.github.com/v3/repos/comments/#get-a-single-commit-comment
  def commit_comment(repo, id, options = T.unsafe(nil)); end

  # List comments for a single commit
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] The SHA of the commit whose comments will be fetched
  # @return [Array] List of commit comments
  # @see https://developer.github.com/v3/repos/comments/#list-comments-for-a-single-commit
  def commit_comments(repo, sha, options = T.unsafe(nil)); end

  # Create a commit comment
  #
  # @example Create a commit comment
  #   comment = Octokit.create_commit_comment("octocat/Hello-World", "827efc6d56897b048c772eb4087f854f46256132", "My comment message", "README.md", 10, 1)
  #   comment.commit_id # => "827efc6d56897b048c772eb4087f854f46256132"
  #   comment.id # => 54321
  #   comment.body # => "My comment message"
  #   comment.path # => "README.md"
  #   comment.line # => 10
  #   comment.position # => 1
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] Sha of the commit to comment on
  # @param body [String] Message
  # @param line [Integer] Line number in the file to comment on
  # @param position [Integer] Line index in the diff to comment on
  # @param path [String] Relative path of file to comment on
  # @return [Sawyer::Resource] Commit comment
  # @see https://developer.github.com/v3/repos/comments/#create-a-commit-comment
  def create_commit_comment(repo, sha, body, path = T.unsafe(nil), line = T.unsafe(nil), position = T.unsafe(nil), options = T.unsafe(nil)); end

  # Delete a commit comment
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [String] The ID of the comment to delete
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/repos/comments/#delete-a-commit-comment
  def delete_commit_comment(repo, id, options = T.unsafe(nil)); end

  # List all commit comments
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Array] List of commit comments
  # @see https://developer.github.com/v3/repos/comments/#list-commit-comments-for-a-repository
  def list_commit_comments(repo, options = T.unsafe(nil)); end

  # Update a commit comment
  #
  # @example Update a commit comment
  #   comment = Octokit.update_commit_comment("octocat/Hello-World", "860296", "Updated commit comment")
  #   comment.id # => 860296
  #   comment.body # => "Updated commit comment"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [String] The ID of the comment to update
  # @param body [String] Message
  # @return [Sawyer::Resource] Updated commit comment
  # @see https://developer.github.com/v3/repos/comments/#update-a-commit-comment
  def update_commit_comment(repo, id, body, options = T.unsafe(nil)); end
end

# Methods for the Commit Pulls API
#
# @see https://developer.github.com/v3/repos/comments/
module Octokit::Client::CommitPulls
  # List pulls for a single commit
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] The SHA of the commit whose pulls will be fetched
  # @return [Array] List of commit pulls
  # @see https://developer.github.com/v3/repos/commits/#list-pull-requests-associated-with-commit
  def commit_pulls(repo, sha, options = T.unsafe(nil)); end
end

# Methods for the Commits API
#
# @see https://developer.github.com/v3/repos/commits/
module Octokit::Client::Commits
  # Get a single commit
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] The SHA of the commit to fetch
  # @return [Sawyer::Resource] A hash representing the commit
  # @see https://developer.github.com/v3/repos/commits/#get-a-single-commit
  def commit(repo, sha, options = T.unsafe(nil)); end

  # List commits
  #
  # @overload commits
  # @overload commits
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def commits(*args); end

  # Get commits before a specified date
  #
  # @example
  #   Octokit.commits_before('octokit/octokit.rb', '2012-10-01')
  # @overload commits_before
  # @overload commits_before
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def commits_before(*args); end

  # Get commits made between two nominated dates
  #
  # @example
  #   Octokit.commits_between('octokit/octokit.rb', '2012-10-01', '2012-11-01')
  # @overload commits_between
  # @overload commits_between
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def commits_between(*args); end

  # Get commits on a specified date
  #
  # @example
  #   Octokit.commits_on('octokit/octokit.rb', '2012-10-01')
  # @overload commits_on
  # @overload commits_on
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def commits_on(*args); end

  # Get commits after a specified date
  #
  # @example
  #   Octokit.commits_since('octokit/octokit.rb', '2012-10-01')
  # @overload commits_since
  # @overload commits_since
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def commits_since(*args); end

  # Compare two commits
  #
  # When using auto_pagination, commits from all pages will be concatenated
  # into the <tt>commits</tt> attribute of the first page's response.
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param start [String] The sha of the starting commit
  # @param endd [String] The sha of the ending commit
  # @return [Sawyer::Resource] A hash representing the comparison
  # @see https://developer.github.com/v3/repos/commits/#compare-two-commits
  def compare(repo, start, endd, options = T.unsafe(nil)); end

  # Create a commit
  #
  # Optionally pass <tt>author</tt> and <tt>committer</tt> hashes in <tt>options</tt>
  # if you'd like manual control over those parameters. If absent, details will be
  # inferred from the authenticated user. See <a href="http://developer.github.com/v3/git/commits/">GitHub's documentation</a>
  # for details about how to format committer identities.
  #
  # @example Create a commit
  #   commit = Octokit.create_commit("octocat/Hello-World", "My commit message", "827efc6d56897b048c772eb4087f854f46256132", "7d1b31e74ee336d15cbd21741bc88a537ed063a0")
  #   commit.sha # => "7638417db6d59f3c431d3e1f261cc637155684cd"
  #   commit.tree.sha # => "827efc6d56897b048c772eb4087f854f46256132"
  #   commit.message # => "My commit message"
  #   commit.committer # => { "name" => "Wynn Netherland", "email" => "wynn@github.com", ... }
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param message [String] The commit message
  # @param tree [String] The SHA of the tree object the new commit will point to
  # @param parents [String, Array] One SHA (for a normal commit) or an array of SHAs (for a merge) of the new commit's parent commits. If ommitted or empty, a root commit will be created
  # @return [Sawyer::Resource] A hash representing the new commit
  # @see https://developer.github.com/v3/git/commits/#create-a-commit
  def create_commit(repo, message, tree, parents = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get a detailed git commit
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param sha [String] The SHA of the commit to fetch
  # @return [Sawyer::Resource] A hash representing the commit
  # @see https://developer.github.com/v3/git/commits/#get-a-commit
  def git_commit(repo, sha, options = T.unsafe(nil)); end

  # List commits
  #
  # @overload commits
  # @overload commits
  # @return [Array<Sawyer::Resource>] An array of hashes representing commits
  # @see https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository
  def list_commits(*args); end

  # Merge a branch or sha
  #
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param base [String] The name of the base branch to merge into
  # @param head [String] The branch or SHA1 to merge
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] A hash representing the comparison
  # @see https://developer.github.com/v3/repos/merging/#perform-a-merge
  def merge(repo, base, head, options = T.unsafe(nil)); end

  protected

  def iso8601(date); end

  # Parses the given string representation of a date, throwing a meaningful exception
  # (containing the date that failed to parse) in case of failure.
  #
  # @param date [String] String representation of a date
  # @return [DateTime]
  def parse_date(date); end
end

# Methods for the Community Profile API
#
# @see https://developer.github.com/v3/repos/community/
module Octokit::Client::CommunityProfile
  # Get community profile metrics for a repository
  #
  # @example Get community profile metrics for octokit/octokit.rb
  #   @client.community_profile('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Community profile metrics
  # @see https://developer.github.com/v3/repos/community/#retrieve-community-profile-metrics
  def community_profile(repo, options = T.unsafe(nil)); end
end

# Methods for the Repo Contents API
#
# @see https://developer.github.com/v3/repos/contents/
module Octokit::Client::Contents
  # Add content to a repository
  #
  # @example Add content at lib/octokit.rb
  #   Octokit.create_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Adding content",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload create_contents
  # @raise [ArgumentError]
  # @return [Sawyer::Resource] The contents and commit info for the addition
  # @see https://developer.github.com/v3/repos/contents/#create-a-file
  def add_content(*args); end

  # Add content to a repository
  #
  # @example Add content at lib/octokit.rb
  #   Octokit.create_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Adding content",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload create_contents
  # @raise [ArgumentError]
  # @return [Sawyer::Resource] The contents and commit info for the addition
  # @see https://developer.github.com/v3/repos/contents/#create-a-file
  def add_contents(*args); end

  # This method will provide a URL to download a tarball or zipball archive for a repository.
  #
  # @example Get archive link for octokit/octokit.rb
  #   Octokit.archive_link("octokit/octokit.rb")
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository.
  # @param options [Hash] a customizable set of options
  # @return [String] Location of the download
  # @see https://developer.github.com/v3/repos/contents/#get-archive-link
  def archive_link(repo, options = T.unsafe(nil)); end

  # Receive a listing of a repository folder or the contents of a file
  #
  # @example List the contents of lib/octokit.rb
  #   Octokit.contents("octokit/octokit.rb", :path => 'lib/octokit.rb')
  # @example Lists the contents of lib /octokit.rb on a particular branch
  #   Octokit.contents("octokit/octokit.rb", :path => 'lib/octokit.rb', :query => {:ref => 'some-other-branch'})
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The contents of a file or list of the files in the folder
  # @see https://developer.github.com/v3/repos/contents/#get-contents
  def content(repo, options = T.unsafe(nil)); end

  # Receive a listing of a repository folder or the contents of a file
  #
  # @example List the contents of lib/octokit.rb
  #   Octokit.contents("octokit/octokit.rb", :path => 'lib/octokit.rb')
  # @example Lists the contents of lib /octokit.rb on a particular branch
  #   Octokit.contents("octokit/octokit.rb", :path => 'lib/octokit.rb', :query => {:ref => 'some-other-branch'})
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The contents of a file or list of the files in the folder
  # @see https://developer.github.com/v3/repos/contents/#get-contents
  def contents(repo, options = T.unsafe(nil)); end

  # Add content to a repository
  #
  # @example Add content at lib/octokit.rb
  #   Octokit.create_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Adding content",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload create_contents
  # @raise [ArgumentError]
  # @return [Sawyer::Resource] The contents and commit info for the addition
  # @see https://developer.github.com/v3/repos/contents/#create-a-file
  def create_content(*args); end

  # Add content to a repository
  #
  # @example Add content at lib/octokit.rb
  #   Octokit.create_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Adding content",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload create_contents
  # @raise [ArgumentError]
  # @return [Sawyer::Resource] The contents and commit info for the addition
  # @see https://developer.github.com/v3/repos/contents/#create-a-file
  def create_contents(*args); end

  # Delete content in a repository
  #
  # @example Delete content at lib/octokit.rb
  #   Octokit.delete_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Deleting content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   :branch => "my-new-feature")
  # @option options
  # @param path [String] A path for the content to delete
  # @param sha [String] The _blob sha_ of the content to delete
  # @param options [Hash] a customizable set of options
  # @param message [String] A commit message for deleting the content
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] The commit info for the delete
  # @see https://developer.github.com/v3/repos/contents/#delete-a-file
  def delete_content(repo, path, message, sha, options = T.unsafe(nil)); end

  # Delete content in a repository
  #
  # @example Delete content at lib/octokit.rb
  #   Octokit.delete_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Deleting content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   :branch => "my-new-feature")
  # @option options
  # @param path [String] A path for the content to delete
  # @param sha [String] The _blob sha_ of the content to delete
  # @param options [Hash] a customizable set of options
  # @param message [String] A commit message for deleting the content
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] The commit info for the delete
  # @see https://developer.github.com/v3/repos/contents/#delete-a-file
  def delete_contents(repo, path, message, sha, options = T.unsafe(nil)); end

  # Receive the default Readme for a repository
  #
  # @example Get the readme file for a repo
  #   Octokit.readme("octokit/octokit.rb")
  # @example Get the readme file for a particular branch of the repo
  #   Octokit.readme("octokit/octokit.rb", :query => {:ref => 'some-other-branch'})
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The detail of the readme
  # @see https://developer.github.com/v3/repos/contents/#get-the-readme
  def readme(repo, options = T.unsafe(nil)); end

  # Delete content in a repository
  #
  # @example Delete content at lib/octokit.rb
  #   Octokit.delete_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Deleting content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   :branch => "my-new-feature")
  # @option options
  # @param path [String] A path for the content to delete
  # @param sha [String] The _blob sha_ of the content to delete
  # @param options [Hash] a customizable set of options
  # @param message [String] A commit message for deleting the content
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] The commit info for the delete
  # @see https://developer.github.com/v3/repos/contents/#delete-a-file
  def remove_content(repo, path, message, sha, options = T.unsafe(nil)); end

  # Delete content in a repository
  #
  # @example Delete content at lib/octokit.rb
  #   Octokit.delete_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Deleting content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   :branch => "my-new-feature")
  # @option options
  # @param path [String] A path for the content to delete
  # @param sha [String] The _blob sha_ of the content to delete
  # @param options [Hash] a customizable set of options
  # @param message [String] A commit message for deleting the content
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] The commit info for the delete
  # @see https://developer.github.com/v3/repos/contents/#delete-a-file
  def remove_contents(repo, path, message, sha, options = T.unsafe(nil)); end

  # Update content in a repository
  #
  # @example Update content at lib/octokit.rb
  #   Octokit.update_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Updating content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload update_contents
  # @return [Sawyer::Resource] The contents and commit info for the update
  # @see https://developer.github.com/v3/repos/contents/#update-a-file
  def update_content(*args); end

  # Update content in a repository
  #
  # @example Update content at lib/octokit.rb
  #   Octokit.update_contents("octokit/octokit.rb",
  #   "lib/octokit.rb",
  #   "Updating content",
  #   "7eb95f97e1a0636015df3837478d3f15184a5f49",
  #   "File content",
  #   :branch => "my-new-feature")
  # @overload update_contents
  # @return [Sawyer::Resource] The contents and commit info for the update
  # @see https://developer.github.com/v3/repos/contents/#update-a-file
  def update_contents(*args); end
end

# Methods for the Deployments API
#
# @see https://developer.github.com/v3/repos/commits/deployments/
module Octokit::Client::Deployments
  # Create a deployment for a ref
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref to deploy
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] A deployment
  # @see https://developer.github.com/v3/repos/deployments/#create-a-deployment
  def create_deployment(repo, ref, options = T.unsafe(nil)); end

  # Create a deployment status for a Deployment
  #
  # @option options
  # @option options
  # @param deployment_url [String] A URL for a deployment resource
  # @param state [String] The state: pending, success, failure, error
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] A deployment status
  # @see https://developer.github.com/v3/repos/deployments/#create-a-deployment-status
  def create_deployment_status(deployment_url, state, options = T.unsafe(nil)); end

  # Delete a Deployment
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param deployment_id [Integer, String, Repository, Hash] A GitHub repository
  # @return [No Content]
  # @see https://developer.github.com/v3/repos/deployments/#delete-a-deployment
  def delete_deployment(repo, deployment_id, options = T.unsafe(nil)); end

  # Fetch a single deployment for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param deployment_id [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] A single deployment
  # @see https://developer.github.com/v3/repos/deployments/#get-a-single-deployment
  def deployment(repo, deployment_id, options = T.unsafe(nil)); end

  # List all statuses for a Deployment
  #
  # @param deployment_url [String] A URL for a deployment resource
  # @return [Array<Sawyer::Resource>] A list of deployment statuses
  # @see https://developer.github.com/v3/repos/deployments/#list-deployment-statuses
  def deployment_statuses(deployment_url, options = T.unsafe(nil)); end

  # List all deployments for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of deployments
  # @see https://developer.github.com/v3/repos/deployments/#list-deployments
  def deployments(repo, options = T.unsafe(nil)); end

  # List all statuses for a Deployment
  #
  # @param deployment_url [String] A URL for a deployment resource
  # @return [Array<Sawyer::Resource>] A list of deployment statuses
  # @see https://developer.github.com/v3/repos/deployments/#list-deployment-statuses
  def list_deployment_statuses(deployment_url, options = T.unsafe(nil)); end

  # List all deployments for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of deployments
  # @see https://developer.github.com/v3/repos/deployments/#list-deployments
  def list_deployments(repo, options = T.unsafe(nil)); end
end

# Methods for the Repo Downloads API
#
# @see https://developer.github.com/v3/repos/downloads/
module Octokit::Client::Downloads
  # Delete a single download for a repository
  #
  # @deprecated As of December 11th, 2012: https://github.com/blog/1302-goodbye-uploads
  # @example Get the "Robawt" download from Github/Hubot
  #   Octokit.delete_download("github/hubot", 1234)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] ID of the download
  # @return [Boolean] Status
  # @see https://developer.github.com/v3/repos/downloads/#delete-a-download
  def delete_download(repo, id, options = T.unsafe(nil)); end

  # Get single download for a repository
  #
  # @deprecated As of December 11th, 2012: https://github.com/blog/1302-goodbye-uploads
  # @example Get the "Robawt" download from Github/Hubot
  #   Octokit.download("github/hubot")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer] ID of the download
  # @return [Sawyer::Resource] A single download from the repository
  # @see https://developer.github.com/v3/repos/downloads/#get-a-single-download
  def download(repo, id, options = T.unsafe(nil)); end

  # List available downloads for a repository
  #
  # @deprecated As of December 11th, 2012: https://github.com/blog/1302-goodbye-uploads
  # @example List all downloads for Github/Hubot
  #   Octokit.downloads("github/hubot")
  # @param repo [Integer, String, Repository, Hash] A Github Repository
  # @return [Array] A list of available downloads
  # @see https://developer.github.com/v3/repos/downloads/#list-downloads-for-a-repository
  def downloads(repo, options = T.unsafe(nil)); end

  # List available downloads for a repository
  #
  # @deprecated As of December 11th, 2012: https://github.com/blog/1302-goodbye-uploads
  # @example List all downloads for Github/Hubot
  #   Octokit.downloads("github/hubot")
  # @param repo [Integer, String, Repository, Hash] A Github Repository
  # @return [Array] A list of available downloads
  # @see https://developer.github.com/v3/repos/downloads/#list-downloads-for-a-repository
  def list_downloads(repo, options = T.unsafe(nil)); end
end

# Methods for the Emojis API
module Octokit::Client::Emojis
  # List all emojis used on GitHub
  #
  # @example List all emojis
  #   Octokit.emojis
  # @return [Sawyer::Resource] A list of all emojis on GitHub
  # @see https://developer.github.com/v3/emojis/#emojis
  def emojis(options = T.unsafe(nil)); end
end

# Method for the Events API
#
# @see https://developer.github.com/v3/activity/events/
# @see https://developer.github.com/v3/issues/events/
module Octokit::Client::Events
  # Get information on a single Issue Event
  #
  # @example Get Event information for ID 3094334 (a pull request was closed)
  #   Octokit.issue_event("octokit/octokit.rb", 3094334)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Event number
  # @return [Sawyer::Resource] A single Event for an Issue
  # @see https://developer.github.com/v3/issues/events/#get-a-single-event
  def issue_event(repo, number, options = T.unsafe(nil)); end

  # List events for an Issue
  #
  # @example List all issues events for issue #38 on octokit/octokit.rb
  #   Octokit.issue_events("octokit/octokit.rb", 38)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Issue number
  # @return [Array<Sawyer::Resource>] Array of events for that issue
  # @see https://developer.github.com/v3/issues/events/#list-events-for-an-issue
  def issue_events(repo, number, options = T.unsafe(nil)); end

  # List all events for an organization
  #
  # Requires authenticated client.
  #
  # @example List events for the lostisland organization
  #   @client.organization_events("lostisland")
  # @param org [String] Organization GitHub handle
  # @return [Array<Sawyer::Resource>] List of all events from a GitHub organization
  # @see https://developer.github.com/v3/activity/events/#list-events-for-an-organization
  def organization_events(org, options = T.unsafe(nil)); end

  # List an organization's public events
  #
  # @example List public events for GitHub
  #   Octokit.organization_public_events("GitHub")
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] List of public events from a GitHub organization
  # @see https://developer.github.com/v3/activity/events/#list-public-events-for-an-organization
  def organization_public_events(org, options = T.unsafe(nil)); end

  # List all public events for GitHub
  #
  # @example List all pubilc events
  #   Octokit.public_events
  # @return [Array<Sawyer::Resource>] A list of all public events from GitHub
  # @see https://developer.github.com/v3/activity/events/#list-public-events
  def public_events(options = T.unsafe(nil)); end

  # List events that a user has received
  #
  # @example List all user received events
  #   Octokit.received_events("sferik")
  # @param user [Integer, String] GitHub user login or id
  # @return [Array<Sawyer::Resource>] A list of all user received events
  # @see https://developer.github.com/v3/activity/events/#list-events-that-a-user-has-received
  def received_events(user, options = T.unsafe(nil)); end

  # List public events a user has received
  #
  # @example List public user received events
  #   Octokit.received_public_events("sferik")
  # @param user [Integer, String] GitHub user login or id
  # @return [Array<Sawyer::Resource>] A list of public user received events
  # @see https://developer.github.com/v3/activity/events/#list-public-events-that-a-user-has-received
  def received_public_events(user, options = T.unsafe(nil)); end

  # Get all Issue Events for a given Repository
  #
  # @example Get all Issue Events for Octokit
  #   Octokit.repository_issue_events("octokit/octokit.rb")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] Array of all Issue Events for this Repository
  # @see https://developer.github.com/v3/issues/events/#list-events-for-a-repository
  # @see https://developer.github.com/v3/activity/events/#list-issue-events-for-a-repository
  def repo_issue_events(repo, options = T.unsafe(nil)); end

  # List events for a repository
  #
  # @example List events for a repository
  #   Octokit.repository_events("sferik/rails_admin")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of events for a repository
  # @see https://developer.github.com/v3/activity/events/#list-repository-events
  def repository_events(repo, options = T.unsafe(nil)); end

  # Get all Issue Events for a given Repository
  #
  # @example Get all Issue Events for Octokit
  #   Octokit.repository_issue_events("octokit/octokit.rb")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] Array of all Issue Events for this Repository
  # @see https://developer.github.com/v3/issues/events/#list-events-for-a-repository
  # @see https://developer.github.com/v3/activity/events/#list-issue-events-for-a-repository
  def repository_issue_events(repo, options = T.unsafe(nil)); end

  # List public events for a repository's network
  #
  # @example List events for a repository's network
  #   Octokit.repository_network_events("sferik/rails_admin")
  # @param repo [String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of events for a repository's network
  # @see https://developer.github.com/v3/activity/events/#list-public-events-for-a-network-of-repositories
  def repository_network_events(repo, options = T.unsafe(nil)); end

  # List all user events
  #
  # @example List all user events
  #   Octokit.user_events("sferik")
  # @param user [Integer, String] GitHub user login or id.
  # @return [Array<Sawyer::Resource>] A list of all user events
  # @see https://developer.github.com/v3/activity/events/#list-events-performed-by-a-user
  def user_events(user, options = T.unsafe(nil)); end

  # List public user events
  #
  # @example List public user events
  #   Octokit.user_events("sferik")
  # @param user [Integer, String] GitHub user login or id
  # @return [Array<Sawyer::Resource>] A list of public user events
  # @see https://developer.github.com/v3/activity/events/#list-public-events-performed-by-a-user
  def user_public_events(user, options = T.unsafe(nil)); end
end

# Methods for the Feeds API
#
# @see https://developer.github.com/v3/activity/feeds/
module Octokit::Client::Feeds
  # Get a Feed by name
  #
  # @param name [Symbol, String] Name of feed to retrieve.
  # @return [Feed] Parsed feed in the format returned by the configured
  #   parser.
  def feed(name, options = T.unsafe(nil)); end

  # List Feeds
  #
  # The feeds returned depend on authentication, see the GitHub API docs
  # for more information.
  #
  # @return [Array<Sawyer::Resource>] list of feeds
  # @see https://developer.github.com/v3/activity/feeds/#list-feeds
  def feeds; end
end

# Methods for the Gists API
#
# @see https://developer.github.com/v3/gists/
module Octokit::Client::Gists
  # Create a gist
  #
  # @option options
  # @option options
  # @option options
  # @param options [Hash] Gist information.
  # @return [Sawyer::Resource] Newly created gist info
  # @see https://developer.github.com/v3/gists/#create-a-gist
  def create_gist(options = T.unsafe(nil)); end

  # Create gist comment
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.create_gist_comment('3528645', 'This is very helpful.')
  # @param gist_id [String] Id of the gist.
  # @param comment [String] Comment contents.
  # @return [Sawyer::Resource] Hash representing the new comment.
  # @see https://developer.github.com/v3/gists/comments/#create-a-comment
  def create_gist_comment(gist_id, comment, options = T.unsafe(nil)); end

  # Delete a gist
  #
  # @param gist [String] Gist ID
  # @return [Boolean] Indicating success of deletion
  # @see https://developer.github.com/v3/gists/#delete-a-gist
  def delete_gist(gist, options = T.unsafe(nil)); end

  # Delete gist comment
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.delete_gist_comment('208sdaz3', '586399')
  # @param gist_id [String] Id of the gist.
  # @param gist_comment_id [Integer] Id of the gist comment to delete.
  # @return [Boolean] True if comment deleted, false otherwise.
  # @see https://developer.github.com/v3/gists/comments/#delete-a-comment
  def delete_gist_comment(gist_id, gist_comment_id, options = T.unsafe(nil)); end

  # Edit a gist
  #
  # @example Update a gist
  #   @client.edit_gist('some_id', {
  #   :files => {"boo.md" => {"content" => "updated stuff"}}
  #   })
  # @option options
  # @option options
  # @param options [Hash] Gist information.
  # @return [Sawyer::Resource] Newly created gist info
  # @see https://developer.github.com/v3/gists/#edit-a-gist
  def edit_gist(gist, options = T.unsafe(nil)); end

  # Fork a gist
  #
  # @param gist [String] Gist ID
  # @return [Sawyer::Resource] Data for the new gist
  # @see https://developer.github.com/v3/gists/#fork-a-gist
  def fork_gist(gist, options = T.unsafe(nil)); end

  # Get a single gist
  #
  # @option options
  # @param gist [String] ID of gist to fetch
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Gist information
  # @see https://developer.github.com/v3/gists/#get-a-single-gist
  # @see https://developer.github.com/v3/gists/#get-a-specific-revision-of-a-gist
  def gist(gist, options = T.unsafe(nil)); end

  # Get gist comment
  #
  # @example
  #   Octokit.gist_comment('208sdaz3', 1451398)
  # @param gist_id [String] Id of the gist.
  # @param gist_comment_id [Integer] Id of the gist comment.
  # @return [Sawyer::Resource] Hash representing gist comment.
  # @see https://developer.github.com/v3/gists/comments/#get-a-single-comment
  def gist_comment(gist_id, gist_comment_id, options = T.unsafe(nil)); end

  # List gist comments
  #
  # @example
  #   Octokit.gist_comments('3528ae645')
  # @param gist_id [String] Gist Id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing comments.
  # @see https://developer.github.com/v3/gists/comments/#list-comments-on-a-gist
  def gist_comments(gist_id, options = T.unsafe(nil)); end

  # List gist commits
  #
  # @example List commits for a gist
  #   @client.gist_commits('some_id')
  # @param gist [String] Gist ID
  # @return [Array] List of commits to the gist
  # @see https://developer.github.com/v3/gists/#list-gist-commits
  def gist_commits(gist, options = T.unsafe(nil)); end

  # List gist forks
  #
  # @example List gist forks
  #   @client.gist_forks('some-id')
  # @param gist [String] Gist ID
  # @return [Array] List of gist forks
  # @see https://developer.github.com/v3/gists/#list-gist-forks
  def gist_forks(gist, options = T.unsafe(nil)); end

  # Check if a gist is starred
  #
  # @param gist [String] Gist ID
  # @return [Boolean] Indicates if gist is starred
  # @see https://developer.github.com/v3/gists/#check-if-a-gist-is-starred
  def gist_starred?(gist, options = T.unsafe(nil)); end

  # List gists for a user or all public gists
  #
  # @example Fetch all gists for defunkt
  #   Octokit.gists('defunkt')
  # @example Fetch all public gists
  #   Octokit.gists
  # @param user [String] An optional user to filter listing
  # @return [Array<Sawyer::Resource>] A list of gists
  # @see https://developer.github.com/v3/gists/#list-gists
  def gists(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List gists for a user or all public gists
  #
  # @example Fetch all gists for defunkt
  #   Octokit.gists('defunkt')
  # @example Fetch all public gists
  #   Octokit.gists
  # @param user [String] An optional user to filter listing
  # @return [Array<Sawyer::Resource>] A list of gists
  # @see https://developer.github.com/v3/gists/#list-gists
  def list_gists(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List public gists
  #
  # @example Fetch all public gists
  #   Octokit.public_gists
  # @return [Array<Sawyer::Resource>] A list of gists
  # @see https://developer.github.com/v3/gists/#list-gists
  def public_gists(options = T.unsafe(nil)); end

  # Star a gist
  #
  # @param gist [String] Gist ID
  # @return [Boolean] Indicates if gist is starred successfully
  # @see https://developer.github.com/v3/gists/#star-a-gist
  def star_gist(gist, options = T.unsafe(nil)); end

  # List the authenticated user’s starred gists
  #
  # @return [Array<Sawyer::Resource>] A list of gists
  # @see https://developer.github.com/v3/gists/#list-gists
  def starred_gists(options = T.unsafe(nil)); end

  # Unstar a gist
  #
  # @param gist [String] Gist ID
  # @return [Boolean] Indicates if gist is unstarred successfully
  # @see https://developer.github.com/v3/gists/#unstar-a-gist
  def unstar_gist(gist, options = T.unsafe(nil)); end

  # Update gist comment
  #
  # Requires authenticated client
  #
  # @example
  #   @client.update_gist_comment('208sdaz3', '3528645', ':heart:')
  # @param gist_id [String] Id of the gist.
  # @param gist_comment_id [Integer] Id of the gist comment to update.
  # @param comment [String] Updated comment contents.
  # @return [Sawyer::Resource] Hash representing the updated comment.
  # @see https://developer.github.com/v3/gists/comments/#edit-a-comment
  def update_gist_comment(gist_id, gist_comment_id, comment, options = T.unsafe(nil)); end
end

# Methods for the Gitignore API
#
# @see https://developer.github.com/v3/gitignore/
module Octokit::Client::Gitignore
  # Get a gitignore template.
  #
  # Use the raw {http://developer.github.com/v3/media/ media type} to get
  # the raw contents.
  #
  # @example Get the Ruby gitignore template
  #   @client.gitignore_template('Ruby')
  # @param template_name [String] Name of the template. Template names are
  #   case sensitive, make sure to use a valid name from the
  #   .gitignore_templates list.
  # @return [Sawyer::Resource] Gitignore template
  # @see https://developer.github.com/v3/gitignore/#get-a-single-template
  def gitignore_template(template_name, options = T.unsafe(nil)); end

  # Listing available gitignore templates.
  #
  # These templates can be passed option when creating a repository.
  #
  # @example Git all the gitignore templates
  #   @client.gitignore_templates
  # @return [Array<String>] List of templates.
  # @see https://developer.github.com/v3/gitignore/#listing-available-templates
  def gitignore_templates(options = T.unsafe(nil)); end
end

# Methods for the Hooks API
module Octokit::Client::Hooks
  # List all Service Hooks supported by GitHub
  #
  # @example List all hooks
  #   Octokit.available_hooks
  # @return [Sawyer::Resource] A list of all hooks on GitHub
  # @see https://developer.github.com/v3/repos/hooks/#services
  def available_hooks(options = T.unsafe(nil)); end

  # Create a hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.create_hook(
  #   'octokit/octokit.rb',
  #   'web',
  #   {
  #   :url => 'http://something.com/webhook',
  #   :content_type => 'json'
  #   },
  #   {
  #   :events => ['push', 'pull_request'],
  #   :active => true
  #   }
  #   )
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param config [Hash] A Hash containing key/value pairs to provide
  #   settings for this hook. These settings vary between the services and
  #   are defined in the {https://github.com/github/github-services github-services} repo.
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param name [String] The name of the service that is being called. See
  #   {https://api.github.com/hooks Hooks} for the possible names.
  # @return [Sawyer::Resource] Hook info for the new hook
  # @see https://api.github.com/hooks
  # @see https://github.com/github/github-services
  # @see https://developer.github.com/v3/repos/hooks/#create-a-hook
  def create_hook(repo, name, config, options = T.unsafe(nil)); end

  # Create an org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.create_org_hook(
  #   'octokit',
  #   {
  #   :url => 'http://something.com/webhook',
  #   :content_type => 'json'
  #   },
  #   {
  #   :events => ['push', 'pull_request'],
  #   :active => true
  #   }
  #   )
  # @option options
  # @option options
  # @param config [Hash] A Hash containing key/value pairs to provide
  #   settings for this hook.
  # @param org [String, Integer] Organization GitHub login or id.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hook info for the new hook
  # @see https://api.github.com/hooks
  # @see https://developer.github.com/v3/orgs/hooks/#create-a-hook
  def create_org_hook(org, config, options = T.unsafe(nil)); end

  # Edit a hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.edit_hook(
  #   'octokit/octokit.rb',
  #   100000,
  #   'web',
  #   {
  #   :url => 'http://something.com/webhook',
  #   :content_type => 'json'
  #   },
  #   {
  #   :add_events => ['status'],
  #   :remove_events => ['pull_request'],
  #   :active => true
  #   }
  #   )
  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [String] The name of the service that is being called. See
  #   {https://api.github.com/hooks Hooks} for the possible names.
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the hook being updated.
  # @param config [Hash] A Hash containing key/value pairs to provide
  #   settings for this hook. These settings vary between the services and
  #   are defined in the {https://github.com/github/github-services github-services} repo.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hook info for the updated hook
  # @see https://api.github.com/hooks
  # @see https://github.com/github/github-services
  # @see https://developer.github.com/v3/repos/hooks/#edit-a-hook
  def edit_hook(repo, id, name, config, options = T.unsafe(nil)); end

  # Update an org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.edit_org_hook(
  #   'octokit',
  #   123,
  #   {
  #   :url => 'http://something.com/webhook',
  #   :content_type => 'json'
  #   },
  #   {
  #   :events => ['push', 'pull_request'],
  #   :active => true
  #   }
  #   )
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param config [Hash] A Hash containing key/value pairs to provide
  #   settings for this hook.
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] Id of the hook to update.
  # @return [Sawyer::Resource] Hook info for the new hook
  # @see https://api.github.com/hooks
  # @see https://developer.github.com/v3/orgs/hooks/#edit-a-hook
  def edit_org_hook(org, id, config, options = T.unsafe(nil)); end

  # Get single hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.hook('octokit/octokit.rb', 100000)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the hook to get.
  # @return [Sawyer::Resource] Hash representing hook.
  # @see https://developer.github.com/v3/repos/hooks/#get-single-hook
  def hook(repo, id, options = T.unsafe(nil)); end

  # List repo hooks
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.hooks('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing hooks.
  # @see https://developer.github.com/v3/repos/hooks/#list-hooks
  def hooks(repo, options = T.unsafe(nil)); end

  # List org hooks
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.org_hooks('octokit')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing hooks.
  # @see https://developer.github.com/v3/orgs/hooks/#list-hooks
  def list_org_hooks(org, options = T.unsafe(nil)); end

  # Get an org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.org_hook('octokit', 123)
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] Id of the hook to get.
  # @return [Sawyer::Resource] Hash representing hook.
  # @see https://developer.github.com/v3/orgs/hooks/#get-single-hook
  def org_hook(org, id, options = T.unsafe(nil)); end

  # List org hooks
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.org_hooks('octokit')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing hooks.
  # @see https://developer.github.com/v3/orgs/hooks/#list-hooks
  def org_hooks(org, options = T.unsafe(nil)); end

  # Parse payload string
  #
  # @param payload_string [String] The payload
  # @return [Sawyer::Resource] The payload object
  # @see https://developer.github.com/v3/activity/events/types/
  def parse_payload(payload_string); end

  # Ping hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.ping_hook('octokit/octokit.rb', 1000000)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the hook to send a ping.
  # @return [Boolean] Ping requested?
  # @see https://developer.github.com/v3/repos/hooks/#ping-a-hook
  def ping_hook(repo, id, options = T.unsafe(nil)); end

  # Ping org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.ping_org_hook('octokit', 1000000)
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] Id of the hook to update.
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/orgs/hooks/#ping-a-hook
  def ping_org_hook(org, id, options = T.unsafe(nil)); end

  # Delete hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_hook('octokit/octokit.rb', 1000000)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the hook to remove.
  # @return [Boolean] True if hook removed, false otherwise.
  # @see https://developer.github.com/v3/repos/hooks/#delete-a-hook
  def remove_hook(repo, id, options = T.unsafe(nil)); end

  # Remove org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.remove_org_hook('octokit', 1000000)
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] Id of the hook to update.
  # @return [Boolean] True if hook removed, false otherwise.
  # @see https://developer.github.com/v3/orgs/hooks/#delete-a-hook
  def remove_org_hook(org, id, options = T.unsafe(nil)); end

  # Test hook
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.test_hook('octokit/octokit.rb', 1000000)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the hook to test.
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/repos/hooks/#test-a-push-hook
  def test_hook(repo, id, options = T.unsafe(nil)); end

  # Update an org hook
  #
  # Requires client authenticated as admin for the org.
  #
  # @example
  #   @client.edit_org_hook(
  #   'octokit',
  #   123,
  #   {
  #   :url => 'http://something.com/webhook',
  #   :content_type => 'json'
  #   },
  #   {
  #   :events => ['push', 'pull_request'],
  #   :active => true
  #   }
  #   )
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param config [Hash] A Hash containing key/value pairs to provide
  #   settings for this hook.
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] Id of the hook to update.
  # @return [Sawyer::Resource] Hook info for the new hook
  # @see https://api.github.com/hooks
  # @see https://developer.github.com/v3/orgs/hooks/#edit-a-hook
  def update_org_hook(org, id, config, options = T.unsafe(nil)); end
end

# Methods for the Issues API
#
# @see https://developer.github.com/v3/issues/
module Octokit::Client::Issues
  # Add assignees to an issue
  #
  # @example Add assignees "pengwynn" and "joeyw" to Issue #23 on octokit/octokit.rb
  #   Octokit.add_assignees("octokit/octokit.rb", 23, ["pengwynn", "joeyw"])
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Issue number
  # @param assignees [Array<String>] Assignees to be added
  # @return [Sawyer::Resource] Issue
  # @see https://developer.github.com/v3/issues/assignees/#add-assignees-to-an-issue
  def add_assignees(repo, number, assignees, options = T.unsafe(nil)); end

  # Add a comment to an issue
  #
  # @example Add the comment "Almost to v1" to Issue #23 on octokit/octokit.rb
  #   Octokit.add_comment("octokit/octokit.rb", 23, "Almost to v1")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Issue number
  # @param comment [String] Comment to be added
  # @return [Sawyer::Resource] Comment
  # @see https://developer.github.com/v3/issues/comments/#create-a-comment
  def add_comment(repo, number, comment, options = T.unsafe(nil)); end

  # Close an issue
  #
  # @example Close Issue #25 from octokit/octokit.rb
  #   Octokit.close_issue("octokit/octokit.rb", "25")
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] The updated Issue
  # @see https://developer.github.com/v3/issues/#edit-an-issue
  def close_issue(repo, number, options = T.unsafe(nil)); end

  # Create an issue for a repository
  #
  # @example Create a new Issues for a repository
  #   Octokit.create_issue("sferik/rails_admin", 'Updated Docs', 'Added some extra links')
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param title [String] A descriptive title
  # @param body [String] An optional concise description
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] Your newly created issue
  # @see https://developer.github.com/v3/issues/#create-an-issue
  def create_issue(repo, title, body = T.unsafe(nil), options = T.unsafe(nil)); end

  # Delete a single comment
  #
  # @example Delete the comment #1194549 on an issue on octokit/octokit.rb
  #   Octokit.delete_comment("octokit/octokit.rb", 1194549)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Comment number
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/issues/comments/#delete-a-comment
  def delete_comment(repo, number, options = T.unsafe(nil)); end

  # Get a single issue from a repository
  #
  # @example Get issue #25 from octokit/octokit.rb
  #   Octokit.issue("octokit/octokit.rb", "25")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Sawyer::Resource] The issue you requested, if it exists
  # @see https://developer.github.com/v3/issues/#get-a-single-issue
  def issue(repo, number, options = T.unsafe(nil)); end

  # Get a single comment attached to an issue
  #
  # @example Get comment #1194549 from an issue on octokit/octokit.rb
  #   Octokit.issue_comment("octokit/octokit.rb", 1194549)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the comment
  # @return [Sawyer::Resource] The specific comment in question
  # @see https://developer.github.com/v3/issues/comments/#get-a-single-comment
  def issue_comment(repo, number, options = T.unsafe(nil)); end

  # Get all comments attached to an issue
  #
  # @example Get comments for issue #25 from octokit/octokit.rb
  #   Octokit.issue_comments("octokit/octokit.rb", "25")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Array<Sawyer::Resource>] Array of comments that belong to an issue
  # @see https://developer.github.com/v3/issues/comments/#list-comments-on-an-issue
  def issue_comments(repo, number, options = T.unsafe(nil)); end

  # Get the timeline for an issue
  #
  # @example Get timeline for issue #1435 on octokit/octokit.rb
  #   Octokit.issue_timeline("octokit/octokit.rb", 1435)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the comment
  # @return [Sawyer::Resource] The timeline for this issue
  # @see https://developer.github.com/v3/issues/timeline/
  def issue_timeline(repo, number, options = T.unsafe(nil)); end

  # List issues for the authenticated user or repository
  #
  # @example List issues for the authenticated user across repositories
  #   @client = Octokit::Client.new(:login => 'foo', :password => 'bar')
  #   @client.list_issues
  # @example List issues for a repository
  #   Octokit.list_issues("sferik/rails_admin")
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository.
  # @param options [Sawyer::Resource] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of issues for a repository.
  # @see https://developer.github.com/v3/issues/#list-issues-for-a-repository
  # @see https://developer.github.com/v3/issues/#list-issues
  def issues(repository = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get all comments attached to issues for the repository
  #
  # By default, Issue Comments are ordered by ascending ID.
  #
  # @example Get issues comments, sort by updated descending since a time
  #   @client.issues_comments("octokit/octokit.rb", {
  #   :sort => 'desc',
  #   :direction => 'asc',
  #   :since => '2010-05-04T23:45:02Z'
  #   })
  # @example Get the comments for issues in the octokit repository
  #   @client.issues_comments("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array<Sawyer::Resource>] List of issues comments.
  # @see https://developer.github.com/v3/issues/comments/#list-comments-in-a-repository
  def issues_comments(repo, options = T.unsafe(nil)); end

  # Lists the available assignees for issues in a repository.
  #
  # @example Get available assignees on repository octokit/octokit.rb
  #   Octokit.list_assignees("octokit/octokit.rb")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] List of GitHub users.
  # @see https://developer.github.com/v3/issues/assignees/#list-assignees
  def list_assignees(repo, options = T.unsafe(nil)); end

  # List issues for the authenticated user or repository
  #
  # @example List issues for the authenticated user across repositories
  #   @client = Octokit::Client.new(:login => 'foo', :password => 'bar')
  #   @client.list_issues
  # @example List issues for a repository
  #   Octokit.list_issues("sferik/rails_admin")
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository.
  # @param options [Sawyer::Resource] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of issues for a repository.
  # @see https://developer.github.com/v3/issues/#list-issues-for-a-repository
  # @see https://developer.github.com/v3/issues/#list-issues
  def list_issues(repository = T.unsafe(nil), options = T.unsafe(nil)); end

  # Lock an issue's conversation, limiting it to collaborators
  #
  # @example Lock Issue #25 from octokit/octokit.rb
  #   Octokit.lock_issue("octokit/octokit.rb", "25")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/issues/#lock-an-issue
  def lock_issue(repo, number, options = T.unsafe(nil)); end

  # Create an issue for a repository
  #
  # @example Create a new Issues for a repository
  #   Octokit.create_issue("sferik/rails_admin", 'Updated Docs', 'Added some extra links')
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param title [String] A descriptive title
  # @param body [String] An optional concise description
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] Your newly created issue
  # @see https://developer.github.com/v3/issues/#create-an-issue
  def open_issue(repo, title, body = T.unsafe(nil), options = T.unsafe(nil)); end

  # List all issues for a given organization for the authenticated user
  #
  # @example List all issues for a given organization for the authenticated user
  #   @client = Octokit::Client.new(:login => 'foo', :password => 'bar')
  #   @client.org_issues("octokit")
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param org [String, Integer] Organization GitHub login or id.
  # @param options [Sawyer::Resource] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of issues.
  # @see https://developer.github.com/v3/issues/#list-issues
  def org_issues(org, options = T.unsafe(nil)); end

  # Remove assignees from an issue
  #
  # @example Remove assignees "pengwynn" and "joeyw" from Issue #23 on octokit/octokit.rb
  #   Octokit.remove_assignees("octokit/octokit.rb", 23, ["pengwynn", "joeyw"])
  # @example Remove assignees "pengwynn" from Issue #23 on octokit/octokit.rb
  #   Octokit.remove_assignees("octokit/octokit.rb", 23, ["pengwynn"],
  #   :accept => "application/vnd.github.v3+json")
  # @param number [Integer] Issue number
  # @param options [Hash] Header params for request
  # @param assignees [Array<String>] Assignees to be removed
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] Issue
  # @see https://developer.github.com/v3/issues/assignees/#remove-assignees-from-an-issue
  def remove_assignees(repo, number, assignees, options = T.unsafe(nil)); end

  # Reopen an issue
  #
  # @example Reopen Issue #25 from octokit/octokit.rb
  #   Octokit.reopen_issue("octokit/octokit.rb", "25")
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] The updated Issue
  # @see https://developer.github.com/v3/issues/#edit-an-issue
  def reopen_issue(repo, number, options = T.unsafe(nil)); end

  # Unlock an issue's conversation, opening it to all viewers
  #
  # @example Unlock Issue #25 from octokit/octokit.rb
  #   Octokit.close_issue("octokit/octokit.rb", "25")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/issues/#unlock-an-issue
  def unlock_issue(repo, number, options = T.unsafe(nil)); end

  # Update a single comment on an issue
  #
  # @example Update the comment #1194549 with body "I've started this on my 25-issue-comments-v3 fork" on an issue on octokit/octokit.rb
  #   Octokit.update_comment("octokit/octokit.rb", 1194549, "Almost to v1, added this on my fork")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Comment number
  # @param comment [String] Body of the comment which will replace the existing body.
  # @return [Sawyer::Resource] Comment
  # @see https://developer.github.com/v3/issues/comments/#edit-a-comment
  def update_comment(repo, number, comment, options = T.unsafe(nil)); end

  # Update an issue
  #
  # @example Change only the assignee of Issue #25
  #   Octokit.update_issue("octokit/octokit.rb", "25", :assignee => "pengwynn")
  # @example Change the title of Issue #25
  #   Octokit.update_issue("octokit/octokit.rb", "25", "A new title", "the same body")
  # @option options
  # @overload update_issue
  # @overload update_issue
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The updated Issue
  # @see https://developer.github.com/v3/issues/#edit-an-issue
  def update_issue(repo, number, *args); end

  # List all issues across owned and member repositories for the authenticated user
  #
  # @example List issues for the authenticated user across owned and member repositories
  #   @client = Octokit::Client.new(:login => 'foo', :password => 'bar')
  #   @client.user_issues
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Sawyer::Resource] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of issues for a repository.
  # @see https://developer.github.com/v3/issues/#list-issues
  def user_issues(options = T.unsafe(nil)); end
end

# Methods for the Issue Labels API
#
# @see https://developer.github.com/v3/issues/labels/
module Octokit::Client::Labels
  # Add a label to a repository
  #
  # @example Add a new label "Version 1.0" with color "#cccccc"
  #   Octokit.add_label("octokit/octokit.rb", "Version 1.0", "cccccc")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param label [String] A new label
  # @param color [String] A color, in hex, without the leading #
  # @return [Sawyer::Resource] The new label
  # @see https://developer.github.com/v3/issues/labels/#create-a-label
  def add_label(repo, label, color = T.unsafe(nil), options = T.unsafe(nil)); end

  # Add label(s) to an Issue
  #
  # @example Add two labels for octokit/octokit.rb
  #   Octokit.add_labels_to_an_issue("octokit/octokit.rb", 10, ['V3 Transition', 'Improvement'])
  # @param repo [Integer, String, Repository, Hash] A Github repository
  # @param number [Integer] Number ID of the issue
  # @param labels [Array] An array of labels to apply to this Issue
  # @return [Array<Sawyer::Resource>] A list of the labels currently on the issue
  # @see https://developer.github.com/v3/issues/labels/#add-labels-to-an-issue
  def add_labels_to_an_issue(repo, number, labels); end

  # Delete a label from a repository.
  #
  # This deletes the label from the repository, and removes it from all issues.
  #
  # @example Delete the label "Version 1.0" from the repository.
  #   Octokit.delete_label!("octokit/octokit.rb", "Version 1.0")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param label [String] String name of the label
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/issues/labels/#delete-a-label
  def delete_label!(repo, label, options = T.unsafe(nil)); end

  # Get single label for a repository
  #
  # @example Get the "V3 Addition" label from octokit/octokit.rb
  #   Octokit.label("octokit/octokit.rb", "V3 Addition")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param name [String] Name of the label
  # @return [Sawyer::Resource] A single label from the repository
  # @see https://developer.github.com/v3/issues/labels/#get-a-single-label
  def label(repo, name, options = T.unsafe(nil)); end

  # List available labels for a repository
  #
  # @example List labels for octokit/octokit.rb
  #   Octokit.labels("octokit/octokit.rb")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of the labels across the repository
  # @see https://developer.github.com/v3/issues/labels/#list-all-labels-for-this-repository
  def labels(repo, options = T.unsafe(nil)); end

  # List labels for a given issue
  #
  # @example List labels for octokit/octokit.rb, issue # 1
  #   Octokit.labels_for_issue("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Array<Sawyer::Resource>] A list of the labels currently on the issue
  # @see https://developer.github.com/v3/issues/labels/#list-labels-on-an-issue
  def labels_for_issue(repo, number, options = T.unsafe(nil)); end

  # Get labels for every issue in a milestone
  #
  # @example List all labels for milestone #2 on octokit/octokit.rb
  #   Octokit.labels_for_milestone("octokit/octokit.rb", 2)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the milestone
  # @return [Array<Sawyer::Resource>] A list of the labels across the milestone
  # @see http://developer.github.com/v3/issues/labels/#get-labels-for-every-issue-in-a-milestone
  def labels_for_milestone(repo, number, options = T.unsafe(nil)); end

  # Remove all label from an Issue
  #
  # This removes the label from the Issue
  #
  # @example Remove all labels from Issue #23
  #   Octokit.remove_all_labels("octokit/octokit.rb", 23)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @return [Boolean] Success of operation
  # @see https://developer.github.com/v3/issues/labels/#remove-all-labels-from-an-issue
  def remove_all_labels(repo, number, options = T.unsafe(nil)); end

  # Remove a label from an Issue
  #
  # This removes the label from the Issue
  #
  # @example Remove the label "Version 1.0" from the repository.
  #   Octokit.remove_label("octokit/octokit.rb", 23, "Version 1.0")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param number [Integer] Number ID of the issue
  # @param label [String] String name of the label
  # @return [Array<Sawyer::Resource>] A list of the labels currently on the issue
  # @see https://developer.github.com/v3/issues/labels/#remove-a-label-from-an-issue
  def remove_label(repo, number, label, options = T.unsafe(nil)); end

  # Replace all labels on an Issue
  #
  # @example Replace labels for octokit/octokit.rb Issue #10
  #   Octokit.replace_all_labels("octokit/octokit.rb", 10, ['V3 Transition', 'Improvement'])
  # @param repo [Integer, String, Repository, Hash] A Github repository
  # @param number [Integer] Number ID of the issue
  # @param labels [Array] An array of labels to use as replacement
  # @return [Array<Sawyer::Resource>] A list of the labels currently on the issue
  # @see https://developer.github.com/v3/issues/labels/#replace-all-labels-for-an-issue
  def replace_all_labels(repo, number, labels, _options = T.unsafe(nil)); end

  # Update a label
  #
  # @example Update the label "Version 1.0" with new color "#cceeaa"
  #   Octokit.update_label("octokit/octokit.rb", "Version 1.0", {:color => "cceeaa"})
  # @option options
  # @option options
  # @param label [String] The name of the label which will be updated
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] The updated label
  # @see https://developer.github.com/v3/issues/labels/#update-a-label
  def update_label(repo, label, options = T.unsafe(nil)); end
end

# Methods for the Legacy Search API
#
# @see https://developer.github.com/v3/search/
module Octokit::Client::LegacySearch
  # Legacy search issues within a repository
  #
  # @example Search for 'test' in the open issues for sferik/rails_admin
  #   Octokit.search_issues("sferik/rails_admin", 'test', 'open')
  # @param repo [String, Repository, Hash] A GitHub repository
  # @param search_term [String] The term to search for
  # @param state [String] :state (open) <tt>open</tt> or <tt>closed</tt>.
  # @return [Array<Sawyer::Resource>] A list of issues matching the search term and state
  def legacy_search_issues(repo, search_term, state = T.unsafe(nil), options = T.unsafe(nil)); end

  # Legacy repository search
  #
  # @param q [String] Search keyword
  # @return [Array<Sawyer::Resource>] List of repositories found
  # @see https://developer.github.com/v3/search/#search-repositories
  def legacy_search_repositories(q, options = T.unsafe(nil)); end

  # Search for user.
  #
  # @example
  #   Octokit.search_users('pengwynn')
  # @param search [String] User to search for.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/search/#search-users
  def legacy_search_users(search, options = T.unsafe(nil)); end
end

module Octokit::Client::Licenses
  def license(license_name, options = T.unsafe(nil)); end
  def licenses(options = T.unsafe(nil)); end
  def repository_license_contents(repo, options = T.unsafe(nil)); end
end

# Methods for the Markdown API
#
# @see https://developer.github.com/v3/markdown/
module Octokit::Client::Markdown
  # Render an arbitrary Markdown document
  #
  # @example Render some GFM
  #   Octokit.markdown('Fixed in #111', :mode => "gfm", :context => "octokit/octokit.rb")
  # @option options
  # @option options
  # @param text [String] Markdown source
  # @param options [Hash] a customizable set of options
  # @return [String] HTML renderization
  # @see https://developer.github.com/v3/markdown/#render-an-arbitrary-markdown-document
  def markdown(text, options = T.unsafe(nil)); end
end

# Methods for the Marketplace Listing API
#
# @see https://developer.github.com/v3/apps/marketplace/
module Octokit::Client::Marketplace
  # List all GitHub accounts on a specific plan
  #
  # @param plan_id [Integer] The id of the GitHub plan
  # @param options [Hash] A customizable set of options
  # @return [Array<Sawyer::Resource>] A list of accounts
  # @see https://developer.github.com/v3/apps/marketplace/#list-all-github-accounts-user-or-organization-on-a-specific-plan
  def list_accounts_for_plan(plan_id, options = T.unsafe(nil)); end

  # List all plans for an app's marketplace listing
  #
  # @param options [Hash] A customizable set of options
  # @return [Array<Sawyer::Resource>] A list of plans
  # @see https://developer.github.com/v3/apps/marketplace/#list-all-plans-for-your-marketplace-listing
  def list_plans(options = T.unsafe(nil)); end

  # Get user's Marketplace purchases
  #
  # @param options [Hash] A customizable set of options
  # @return [Array<Sawyer::Resource>] A list of Marketplace purchases
  # @see https://developer.github.com/v3/apps/marketplace/#get-a-users-marketplace-purchases
  def marketplace_purchases(options = T.unsafe(nil)); end

  # Get the plan associated with a given GitHub account
  #
  # @param account_id [Integer] The id of the GitHub account
  # @param options [Hash] A customizable set of options
  # @return [Sawyer::Resource] Account with plan details, or nil
  # @see https://developer.github.com/v3/apps/marketplace/#check-if-a-github-account-is-associated-with-any-marketplace-listing
  def plan_for_account(account_id, options = T.unsafe(nil)); end
end

# Methods for the Meta API
#
# @see https://developer.github.com/v3/meta/
module Octokit::Client::Meta
  # Get meta information about GitHub.com, the service.
  #
  # @example Get GitHub meta information
  #   @client.github_meta
  # @return [Sawyer::Resource] Hash with meta information.
  # @see https://developer.github.com/v3/meta/#meta
  def github_meta(options = T.unsafe(nil)); end

  # Get meta information about GitHub.com, the service.
  #
  # @example Get GitHub meta information
  #   @client.github_meta
  # @return [Sawyer::Resource] Hash with meta information.
  # @see https://developer.github.com/v3/meta/#meta
  def meta(options = T.unsafe(nil)); end
end

# Methods for the Issues Milestones API
#
# @see https://developer.github.com/v3/issues/milestones/
module Octokit::Client::Milestones
  # Create a milestone for a repository
  #
  # @example Create a milestone for a repository
  #   Octokit.create_milestone("octokit/octokit.rb", "0.7.0", {:description => 'Add support for v3 of Github API'})
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param title [String] A unique title.
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single milestone object
  # @see https://developer.github.com/v3/issues/milestones/#create-a-milestone
  def create_milestone(repository, title, options = T.unsafe(nil)); end

  # Delete a single milestone for a repository
  #
  # @example Delete a single milestone from a repository
  #   Octokit.delete_milestone("octokit/octokit.rb", 1)
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] A customizable set of options.
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/issues/milestones/#delete-a-milestone
  def delete_milestone(repository, number, options = T.unsafe(nil)); end

  # Update a milestone for a repository
  #
  # @example Update a milestone for a repository
  #   Octokit.update_milestone("octokit/octokit.rb", 1, {:description => 'Add support for v3 of Github API'})
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param number [String, Integer] ID of the milestone
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single milestone object
  # @see https://developer.github.com/v3/issues/milestones/#update-a-milestone
  def edit_milestone(repository, number, options = T.unsafe(nil)); end

  # List milestones for a repository
  #
  # @example List milestones for a repository
  #   Octokit.list_milestones("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of milestones for a repository.
  # @see https://developer.github.com/v3/issues/milestones/#list-milestones-for-a-repository
  def list_milestones(repository, options = T.unsafe(nil)); end

  # Get a single milestone for a repository
  #
  # @example Get a single milestone for a repository
  #   Octokit.milestone("octokit/octokit.rb", 1)
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single milestone from a repository.
  # @see https://developer.github.com/v3/issues/milestones/#get-a-single-milestone
  def milestone(repository, number, options = T.unsafe(nil)); end

  # List milestones for a repository
  #
  # @example List milestones for a repository
  #   Octokit.list_milestones("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] A customizable set of options.
  # @return [Array<Sawyer::Resource>] A list of milestones for a repository.
  # @see https://developer.github.com/v3/issues/milestones/#list-milestones-for-a-repository
  def milestones(repository, options = T.unsafe(nil)); end

  # Update a milestone for a repository
  #
  # @example Update a milestone for a repository
  #   Octokit.update_milestone("octokit/octokit.rb", 1, {:description => 'Add support for v3 of Github API'})
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repository [Integer, String, Repository, Hash] A GitHub repository
  # @param number [String, Integer] ID of the milestone
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource] A single milestone object
  # @see https://developer.github.com/v3/issues/milestones/#update-a-milestone
  def update_milestone(repository, number, options = T.unsafe(nil)); end
end

# Methods for the Notifications API
#
# @see https://developer.github.com/v3/activity/notifications/
module Octokit::Client::Notifications
  # Delete a thread subscription
  #
  # @example
  #   @client.delete_thread_subscription(1)
  # @param thread_id [Integer] Id of the thread.
  # @return [Boolean] True if delete successful, false otherwise.
  # @see https://developer.github.com/v3/activity/notifications/#delete-a-thread-subscription
  def delete_thread_subscription(thread_id, options = T.unsafe(nil)); end

  # Mark notifications as read
  #
  # @example
  #   @client.mark_notifications_as_read
  # @option options
  # @option options
  # @option options
  # @param options [Hash] Optional parameters
  # @return [Boolean] True if marked as read, false otherwise
  # @see https://developer.github.com/v3/activity/notifications/#mark-as-read
  def mark_notifications_as_read(options = T.unsafe(nil)); end

  # Mark notifications from a specific repository as read
  #
  # @example
  #   @client.mark_notifications_as_read("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Boolean] True if marked as read, false otherwise
  # @see https://developer.github.com/v3/activity/notifications/#mark-notifications-as-read-in-a-repository
  def mark_repo_notifications_as_read(repo, options = T.unsafe(nil)); end

  # Mark notifications from a specific repository as read
  #
  # @example
  #   @client.mark_notifications_as_read("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Boolean] True if marked as read, false otherwise
  # @see https://developer.github.com/v3/activity/notifications/#mark-notifications-as-read-in-a-repository
  def mark_repository_notifications_as_read(repo, options = T.unsafe(nil)); end

  # Mark thread as read
  #
  # @example
  #   @client.mark_thread_as_read(1, :read => false)
  # @param thread_id [Integer] Id of the thread to update.
  # @return [Boolean] True if updated, false otherwise.
  # @see https://developer.github.com/v3/activity/notifications/#mark-a-thread-as-read
  def mark_thread_as_read(thread_id, options = T.unsafe(nil)); end

  # List your notifications
  #
  # @example Get all notifications since a certain time.
  #   @client.notifications({all: true, since: '2012-10-09T23:39:01Z'})
  # @example Get users notifications
  #   @client.notifications
  # @option options
  # @option options
  # @option options
  # @param options [Hash] Optional parameters
  # @return [Array<Sawyer::Resource>] Array of notifications.
  # @see https://developer.github.com/v3/activity/notifications/#list-your-notifications
  def notifications(options = T.unsafe(nil)); end

  # List your notifications in a repository
  #
  # @example Get your notifications for octokit/octokit.rb since a time.
  #   @client.repository_notifications({since: '2012-10-09T23:39:01Z'})
  # @example Get your notifications for octokit/octokit.rb
  #   @client.repository_notifications('octokit/octokit.rb')
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array<Sawyer::Resource>] Array of notifications.
  # @see https://developer.github.com/v3/activity/notifications/#list-your-notifications-in-a-repository
  def repo_notifications(repo, options = T.unsafe(nil)); end

  # List your notifications in a repository
  #
  # @example Get your notifications for octokit/octokit.rb since a time.
  #   @client.repository_notifications({since: '2012-10-09T23:39:01Z'})
  # @example Get your notifications for octokit/octokit.rb
  #   @client.repository_notifications('octokit/octokit.rb')
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array<Sawyer::Resource>] Array of notifications.
  # @see https://developer.github.com/v3/activity/notifications/#list-your-notifications-in-a-repository
  def repository_notifications(repo, options = T.unsafe(nil)); end

  # List notifications for a specific thread
  #
  # @example
  #   @client.notification_thread(1000)
  # @param thread_id [Integer] Id of the thread.
  # @return [Array<Sawyer::Resource>] Array of notifications.
  # @see https://developer.github.com/v3/activity/notifications/#view-a-single-thread
  def thread_notifications(thread_id, options = T.unsafe(nil)); end

  # Get thread subscription
  #
  # @example
  #   @client.thread_subscription(1)
  # @param thread_id [Integer] Id of the thread.
  # @return [Sawyer::Resource] Subscription.
  # @see https://developer.github.com/v3/activity/notifications/#get-a-thread-subscription
  def thread_subscription(thread_id, options = T.unsafe(nil)); end

  # Update thread subscription
  #
  # This lets you subscribe to a thread, or ignore it. Subscribing to a
  # thread is unnecessary if the user is already subscribed to the
  # repository. Ignoring a thread will mute all future notifications (until
  # you comment or get @mentioned).
  #
  # @example Subscribe to notifications
  #   @client.update_thread_subscription(1, :subscribed => true)
  # @example Ignore notifications from a repo
  #   @client.update_thread_subscription(1, :ignored => true)
  # @option options
  # @option options
  # @param thread_id [Integer] Id of the thread.
  # @param options
  # @return [Sawyer::Resource] Updated subscription.
  # @see https://developer.github.com/v3/activity/notifications/#set-a-thread-subscription
  def update_thread_subscription(thread_id, options = T.unsafe(nil)); end
end

# Methods for the OauthApplications API
#
# @see https://developer.github.com/v3/apps/oauth_applications
module Octokit::Client::OauthApplications
  # Check if a token is valid.
  #
  # Applications can check if a token is valid without rate limits.
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.check_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/apps/oauth_applications/#check-a-token
  def check_application_authorization(access_token, options = T.unsafe(nil)); end

  # Check if a token is valid.
  #
  # Applications can check if a token is valid without rate limits.
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.check_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/apps/oauth_applications/#check-a-token
  def check_token(access_token, options = T.unsafe(nil)); end

  # Delete an app authorization
  #
  # OAuth application owners can revoke a grant for their OAuth application and a specific user.
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.delete_app_authorization('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Boolean] Result
  # @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
  def delete_app_authorization(access_token, options = T.unsafe(nil)); end

  # Delete an app token
  #
  # Applications can revoke (delete) a token
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.delete_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Boolean] Result
  # @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
  def delete_app_token(access_token, options = T.unsafe(nil)); end

  # Delete an app token
  #
  # Applications can revoke (delete) a token
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.delete_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Boolean] Result
  # @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
  def delete_application_authorization(access_token, options = T.unsafe(nil)); end

  # Reset a token
  #
  # Applications can reset a token without requiring a user to re-authorize.
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.reset_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/apps/oauth_applications/#reset-a-token
  def reset_application_authorization(access_token, options = T.unsafe(nil)); end

  # Reset a token
  #
  # Applications can reset a token without requiring a user to re-authorize.
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.reset_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Sawyer::Resource] A single authorization for the authenticated user
  # @see https://developer.github.com/v3/apps/oauth_applications/#reset-a-token
  def reset_token(access_token, options = T.unsafe(nil)); end

  # Delete an app token
  #
  # Applications can revoke (delete) a token
  #
  # @example
  #   client = Octokit::Client.new(:client_id => 'abcdefg12345', :client_secret => 'secret')
  #   client.delete_token('deadbeef1234567890deadbeef987654321')
  # @param access_token [String] 40 character GitHub OAuth access token
  # @return [Boolean] Result
  # @see https://developer.github.com/v3/apps/oauth_applications/#delete-an-app-token
  def revoke_application_authorization(access_token, options = T.unsafe(nil)); end
end

# Methods for the Git Data API
#
# @see https://developer.github.com/v3/git/
module Octokit::Client::Objects
  # Get a single blob, fetching its content and encoding
  #
  # @example Fetch a blob and inspect its contents
  #   blob = Octokit.blob("octocat/Hello-World", "827efc6d56897b048c772eb4087f854f46256132")
  #   blob.encoding # => "utf-8"
  #   blob.content # => "Foo bar baz"
  # @example Fetch a base64-encoded blob and inspect its contents
  #   require "base64"
  #   blob = Octokit.blob("octocat/Hello-World", "827efc6d56897b048c772eb4087f854f46256132")
  #   blob.encoding # => "base64"
  #   blob.content # => "Rm9vIGJhciBiYXo="
  #   Base64.decode64(blob.content) # => "Foo bar baz"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param blob_sha [String] The SHA of the blob to fetch
  # @return [Sawyer::Resource] A hash representing the fetched blob
  # @see https://developer.github.com/v3/git/blobs/#get-a-blob
  def blob(repo, blob_sha, options = T.unsafe(nil)); end

  # Create a blob
  #
  # @example Create a blob containing <tt>foo bar baz</tt>
  #   Octokit.create_blob("octocat/Hello-World", "foo bar baz")
  # @example Create a blob containing <tt>foo bar baz</tt>, encoded using base64
  #   require "base64"
  #   Octokit.create_blob("octocat/Hello-World", Base64.encode64("foo bar baz"), "base64")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param content [String] Content of the blob
  # @param encoding [String] The content's encoding. <tt>utf-8</tt> and <tt>base64</tt> are accepted. If your data cannot be losslessly sent as a UTF-8 string, you can base64 encode it
  # @return [String] The new blob's SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @see https://developer.github.com/v3/git/blobs/#create-a-blob
  def create_blob(repo, content, encoding = T.unsafe(nil), options = T.unsafe(nil)); end

  # Create a tag
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.create_tag(
  #   "octokit/octokit.rb",
  #   "v9000.0.0",
  #   "Version 9000\n",
  #   "f4cdf6eb734f32343ce3f27670c17b35f54fd82e",
  #   "commit",
  #   "Wynn Netherland",
  #   "wynn.netherland@gmail.com",
  #   "2012-06-03T17:03:11-07:00"
  #   )
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param tag [String] Tag string.
  # @param message [String] Tag message.
  # @param object_sha [String] SHA of the git object this is tagging.
  # @param tagger_name [String] Name of the author of the tag.
  # @param tagger_email [String] Email of the author of the tag.
  # @param tagger_date [string] Timestamp of when this object was tagged.
  # @param type [String] Type of the object we're tagging. Normally this is
  #   a `commit` but it can also be a `tree` or a `blob`.
  # @return [Sawyer::Resource] Hash representing new tag.
  # @see https://developer.github.com/v3/git/tags/#create-a-tag-object
  def create_tag(repo, tag, message, object_sha, type, tagger_name, tagger_email, tagger_date, options = T.unsafe(nil)); end

  # Create a tree
  #
  # Pass <tt>:base_tree => "827efc6..."</tt> in <tt>options</tt> to update an existing tree with new data.
  #
  # @example Create a tree containing one file
  #   tree = Octokit.create_tree("octocat/Hello-World", [ { :path => "file.rb", :mode => "100644", :type => "blob", :sha => "44b4fc6d56897b048c772eb4087f854f46256132" } ])
  #   tree.sha # => "cd8274d15fa3ae2ab983129fb037999f264ba9a7"
  #   tree.tree.first.path # => "file.rb"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param tree [Array] An array of hashes representing a tree structure
  # @return [Sawyer::Resource] A hash representing the new tree
  # @see https://developer.github.com/v3/git/trees/#create-a-tree
  def create_tree(repo, tree, options = T.unsafe(nil)); end

  # Get a tag
  #
  # @example Fetch a tag
  #   Octokit.tag('octokit/octokit.rb', '23aad20633f4d2981b1c7209a800db3014774e96')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param tag_sha [String] The SHA of the tag to fetch.
  # @return [Sawyer::Resource] Hash representing the tag.
  # @see https://developer.github.com/v3/git/tags/#get-a-tag
  def tag(repo, tag_sha, options = T.unsafe(nil)); end

  # Get a single tree, fetching information about its root-level objects
  #
  # Pass <tt>:recursive => true</tt> in <tt>options</tt> to fetch information about all of the tree's objects, including those in subdirectories.
  #
  # @example Fetch a tree and inspect the path of one of its files
  #   tree = Octokit.tree("octocat/Hello-World", "9fb037999f264ba9a7fc6274d15fa3ae2ab98312")
  #   tree.tree.first.path # => "file.rb"
  # @example Fetch a tree recursively
  #   tree = Octokit.tree("octocat/Hello-World", "fc6274d15fa3ae2ab983129fb037999f264ba9a7", :recursive => true)
  #   tree.tree.first.path # => "subdir/file.txt"
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param tree_sha [String] The SHA of the tree to fetch
  # @return [Sawyer::Resource] A hash representing the fetched tree
  # @see https://developer.github.com/v3/git/trees/#get-a-tree
  # @see https://developer.github.com/v3/git/trees/#get-a-tree-recursively
  def tree(repo, tree_sha, options = T.unsafe(nil)); end
end

# Methods for the Organizations API
#
# @see https://developer.github.com/v3/orgs/
module Octokit::Client::Organizations
  # Add team member
  #
  # Requires authenticated organization owner or member with team
  # `admin` permission.
  #
  # @example
  #   @client.add_team_member(100000, 'pengwynn')
  # @example
  #   # Opt-in to future behavior for this endpoint. Adds the member to the
  #   # team if they're already an org member. If not, the method will return
  #   # 422 and indicate the user should call the new Team Membership endpoint.
  #   @client.add_team_member \
  #   100000,
  #   'pengwynn',
  #   :accept => "application/vnd.github.the-wasp-preview+json"
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of new team member.
  # @return [Boolean] True on successful addition, false otherwise.
  # @see https://developer.github.com/v3/orgs/teams/#add-team-member
  # @see https://developer.github.com/changes/2014-08-05-team-memberships-api/
  def add_team_member(team_id, user, options = T.unsafe(nil)); end

  # Add or invite a user to a team
  #
  # @example Check if a user has a membership for a team
  #   @client.add_team_membership(1234, 'pengwynn')
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of the user to invite.
  # @return [Sawyer::Resource] Hash of team membership info
  # @see https://developer.github.com/v3/orgs/teams/#add-or-update-team-membership
  def add_team_membership(team_id, user, options = T.unsafe(nil)); end

  # Add team repository
  #
  # This can also be used to update the permission of an existing team
  #
  # Requires authenticated user to be an owner of the organization that the
  # team is associated with. Also, the repo must be owned by the
  # organization, or a direct form of a repo owned by the organization.
  #
  # @example
  #   @client.add_team_repo(100000, 'github/developer.github.com')
  # @example
  #   @client.add_team_repository(100000, 'github/developer.github.com')
  # @example Add a team with admin permissions
  #   @client.add_team_repository(100000, 'github/developer.github.com', permission: 'admin')
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @param team_id [Integer] Team id.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] True if successful, false otherwise.
  # @see Octokit::Repository
  # @see https://developer.github.com/v3/orgs/teams/#add-or-update-team-repository
  def add_team_repo(team_id, repo, options = T.unsafe(nil)); end

  # Add team repository
  #
  # This can also be used to update the permission of an existing team
  #
  # Requires authenticated user to be an owner of the organization that the
  # team is associated with. Also, the repo must be owned by the
  # organization, or a direct form of a repo owned by the organization.
  #
  # @example
  #   @client.add_team_repo(100000, 'github/developer.github.com')
  # @example
  #   @client.add_team_repository(100000, 'github/developer.github.com')
  # @example Add a team with admin permissions
  #   @client.add_team_repository(100000, 'github/developer.github.com', permission: 'admin')
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @param team_id [Integer] Team id.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] True if successful, false otherwise.
  # @see Octokit::Repository
  # @see https://developer.github.com/v3/orgs/teams/#add-or-update-team-repository
  def add_team_repository(team_id, repo, options = T.unsafe(nil)); end

  # List all GitHub organizations
  #
  # This provides a list of every organization, in the order that they
  # were created.
  #
  # Organization that you’ve seen.
  #
  # @option options
  # @param options [Hash] Optional options.
  # @return [Array<Sawyer::Resource>] List of GitHub organizations.
  # @see https://developer.github.com/v3/orgs/#list-all-organizations
  def all_organizations(options = T.unsafe(nil)); end

  # List all GitHub organizations
  #
  # This provides a list of every organization, in the order that they
  # were created.
  #
  # Organization that you’ve seen.
  #
  # @option options
  # @param options [Hash] Optional options.
  # @return [Array<Sawyer::Resource>] List of GitHub organizations.
  # @see https://developer.github.com/v3/orgs/#list-all-organizations
  def all_orgs(options = T.unsafe(nil)); end

  # Get GitHub Actions billing for an organization
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.billing_actions('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Sawyer::Resource] Hash representing GitHub Actions billing for an organization.
  # @see https://docs.github.com/en/rest/reference/billing#get-github-actions-billing-for-an-organization
  def billing_actions(org); end

  # List child teams
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.child_teams(100000, :accept => "application/vnd.github.hellcat-preview+json")
  # @param team_id [Integer] Team id.
  # @return [Sawyer::Resource] Hash representing team.
  # @see https://developer.github.com/v3/orgs/teams/#list-child-teams
  def child_teams(team_id, options = T.unsafe(nil)); end

  # Conceal a user's membership of an organization.
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.unpublicize_membership('github', 'pengwynn')
  # @example
  #   @client.conceal_membership('github', 'pengwynn')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of user to unpublicize.
  # @return [Boolean] True of unpublicization successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/members/#conceal-a-users-membership
  def conceal_membership(org, user, options = T.unsafe(nil)); end

  # Converts an organization member to an outside collaborator
  #
  # Requires authenticated organization members.
  #
  # @example
  #   @client.convert_to_outside_collaborator('github', 'lizzhale')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username to be removed as outside collaborator
  # @return [Boolean] Return true if outside collaborator removed from organization, false otherwise.
  # @see https://developer.github.com/v3/orgs/outside-collaborators/#convert-member-to-outside-collaborator
  def convert_to_outside_collaborator(org, user, options = T.unsafe(nil)); end

  # Create team
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.create_team('github', {
  #   :name => 'Designers',
  #   :repo_names => ['github/dotfiles']
  #   })
  # @option options
  # @option options
  # @option options
  # @option options
  # @param org [String, Integer] Organization GitHub login or id.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing new team.
  # @see https://developer.github.com/v3/orgs/teams/#create-team
  def create_team(org, options = T.unsafe(nil)); end

  # Deletes a previous migration archive.
  #
  # Requires authenticated organization owner.
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#delete-an-organization-migration-archive
  def delete_migration_archive(org, id, options = T.unsafe(nil)); end

  # Delete team
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.delete_team(100000)
  # @param team_id [Integer] Team id.
  # @return [Boolean] True if deletion successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/teams/#delete-team
  def delete_team(team_id, options = T.unsafe(nil)); end

  # Get organizations for a user.
  #
  # Nonauthenticated calls to this method will return organizations that
  # the user is a public member.
  #
  # Use an authenicated client to get both public and private organizations
  # for a user.
  #
  # Calling this method on a `@client` will return that users organizations.
  # Private organizations are included only if the `@client` is authenticated.
  #
  # @example
  #   Octokit.organizations('pengwynn')
  # @example
  #   @client.organizations('pengwynn')
  # @example
  #   Octokit.orgs('pengwynn')
  # @example
  #   Octokit.list_organizations('pengwynn')
  # @example
  #   Octokit.list_orgs('pengwynn')
  # @example
  #   @client.organizations
  # @param user [Integer, String] GitHub user login or id of the user to get
  #   list of organizations.
  # @return [Array<Sawyer::Resource>] Array of hashes representing organizations.
  # @see https://developer.github.com/v3/orgs/#list-your-organizations
  # @see https://developer.github.com/v3/orgs/#list-user-organizations
  def list_organizations(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get organizations for a user.
  #
  # Nonauthenticated calls to this method will return organizations that
  # the user is a public member.
  #
  # Use an authenicated client to get both public and private organizations
  # for a user.
  #
  # Calling this method on a `@client` will return that users organizations.
  # Private organizations are included only if the `@client` is authenticated.
  #
  # @example
  #   Octokit.organizations('pengwynn')
  # @example
  #   @client.organizations('pengwynn')
  # @example
  #   Octokit.orgs('pengwynn')
  # @example
  #   Octokit.list_organizations('pengwynn')
  # @example
  #   Octokit.list_orgs('pengwynn')
  # @example
  #   @client.organizations
  # @param user [Integer, String] GitHub user login or id of the user to get
  #   list of organizations.
  # @return [Array<Sawyer::Resource>] Array of hashes representing organizations.
  # @see https://developer.github.com/v3/orgs/#list-your-organizations
  # @see https://developer.github.com/v3/orgs/#list-user-organizations
  def list_orgs(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Fetches the URL to a migration archive.
  #
  # Requires authenticated organization owner.
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#download-an-organization-migration-archive
  def migration_archive_url(org, id, options = T.unsafe(nil)); end

  # Fetches the status of a migration.
  #
  # Requires authenticated organization owner.
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#get-an-organization-migration-status
  def migration_status(org, id, options = T.unsafe(nil)); end

  # Lists the most recent migrations.
  #
  # Requires authenticated organization owner.
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of migration resources.
  # @see https://docs.github.com/en/rest/reference/migrations#list-organization-migrations
  def migrations(org, options = T.unsafe(nil)); end

  # Get an organization
  #
  # @example
  #   Octokit.organization('github')
  # @example
  #   Octokit.org('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Sawyer::Resource] Hash representing GitHub organization.
  # @see https://developer.github.com/v3/orgs/#get-an-organization
  def org(org, options = T.unsafe(nil)); end

  # List pending organization invitations
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.organization_invitations('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing invitations.
  # @see https://developer.github.com/v3/orgs/members/#list-pending-organization-invitations
  def org_invitations(org, options = T.unsafe(nil)); end

  # Check if a user is a member of an organization.
  #
  # Use this to check if another user is a member of an organization that
  # you are a member. If you are not in the organization you are checking,
  # use .organization_public_member? instead.
  #
  # @example Check if a user is in your organization
  #   @client.organization_member?('your_organization', 'pengwynn')
  #   => false
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of the user to check.
  # @return [Boolean] Is a member?
  # @see https://developer.github.com/v3/orgs/members/#check-membership
  def org_member?(org, user, options = T.unsafe(nil)); end

  # Get organization members
  #
  # Public members of the organization are returned by default. An
  # authenticated client that is a member of the GitHub organization
  # is required to get private members.
  #
  # @example
  #   Octokit.organization_members('github')
  # @example
  #   Octokit.org_members('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/members/#members-list
  def org_members(org, options = T.unsafe(nil)); end

  # Get an organization membership
  #
  # @option options
  # @param org [Integer, String] The GitHub Organization.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing the organization membership.
  # @see https://developer.github.com/v3/orgs/members/#get-your-organization-membership
  # @see https://developer.github.com/v3/orgs/members/#get-organization-membership
  def org_membership(org, options = T.unsafe(nil)); end

  # List all organizations memberships for the authenticated user
  #
  # @return [Array<Sawyer::Resource>] Array of organizations memberships.
  # @see https://developer.github.com/v3/orgs/members/#list-your-organization-memberships
  def org_memberships(options = T.unsafe(nil)); end

  # Check if a user is a public member of an organization.
  #
  # If you are checking for membership of a user of an organization that
  # you are in, use .organization_member? instead.
  #
  # @example Check if a user is a hubbernaut
  #   @client.organization_public_member?('github', 'pengwynn')
  #   => true
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of the user to check.
  # @return [Boolean] Is a public member?
  # @see https://developer.github.com/v3/orgs/members/#check-public-membership
  def org_public_member?(org, user, options = T.unsafe(nil)); end

  # Get organization public members
  #
  # Lists the public members of an organization
  #
  # @example
  #   Octokit.organization_public_members('github')
  # @example
  #   Octokit.org_public_members('github')
  # @param org [String] Organization GitHub username.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/members/#public-members-list
  def org_public_members(org, options = T.unsafe(nil)); end

  # List organization repositories
  #
  # Public repositories are available without authentication. Private repos
  # require authenticated organization member.
  #
  # @example
  #   Octokit.organization_repositories('github')
  # @example
  #   Octokit.org_repositories('github')
  # @example
  #   Octokit.org_repos('github')
  # @example
  #   @client.org_repos('github', {:type => 'private'})
  # @option options
  # @param org [String, Integer] Organization GitHub login or id for which
  #   to list repos.
  # @param options [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-organization-repositories
  def org_repos(org, options = T.unsafe(nil)); end

  # List organization repositories
  #
  # Public repositories are available without authentication. Private repos
  # require authenticated organization member.
  #
  # @example
  #   Octokit.organization_repositories('github')
  # @example
  #   Octokit.org_repositories('github')
  # @example
  #   Octokit.org_repos('github')
  # @example
  #   @client.org_repos('github', {:type => 'private'})
  # @option options
  # @param org [String, Integer] Organization GitHub login or id for which
  #   to list repos.
  # @param options [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-organization-repositories
  def org_repositories(org, options = T.unsafe(nil)); end

  # List teams
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.organization_teams('github')
  # @example
  #   @client.org_teams('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing teams.
  # @see https://developer.github.com/v3/orgs/teams/#list-teams
  def org_teams(org, options = T.unsafe(nil)); end

  # Get an organization
  #
  # @example
  #   Octokit.organization('github')
  # @example
  #   Octokit.org('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Sawyer::Resource] Hash representing GitHub organization.
  # @see https://developer.github.com/v3/orgs/#get-an-organization
  def organization(org, options = T.unsafe(nil)); end

  # List pending organization invitations
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.organization_invitations('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing invitations.
  # @see https://developer.github.com/v3/orgs/members/#list-pending-organization-invitations
  def organization_invitations(org, options = T.unsafe(nil)); end

  # Check if a user is a member of an organization.
  #
  # Use this to check if another user is a member of an organization that
  # you are a member. If you are not in the organization you are checking,
  # use .organization_public_member? instead.
  #
  # @example Check if a user is in your organization
  #   @client.organization_member?('your_organization', 'pengwynn')
  #   => false
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of the user to check.
  # @return [Boolean] Is a member?
  # @see https://developer.github.com/v3/orgs/members/#check-membership
  def organization_member?(org, user, options = T.unsafe(nil)); end

  # Get organization members
  #
  # Public members of the organization are returned by default. An
  # authenticated client that is a member of the GitHub organization
  # is required to get private members.
  #
  # @example
  #   Octokit.organization_members('github')
  # @example
  #   Octokit.org_members('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/members/#members-list
  def organization_members(org, options = T.unsafe(nil)); end

  # Get an organization membership
  #
  # @option options
  # @param org [Integer, String] The GitHub Organization.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing the organization membership.
  # @see https://developer.github.com/v3/orgs/members/#get-your-organization-membership
  # @see https://developer.github.com/v3/orgs/members/#get-organization-membership
  def organization_membership(org, options = T.unsafe(nil)); end

  # List all organizations memberships for the authenticated user
  #
  # @return [Array<Sawyer::Resource>] Array of organizations memberships.
  # @see https://developer.github.com/v3/orgs/members/#list-your-organization-memberships
  def organization_memberships(options = T.unsafe(nil)); end

  # Check if a user is a public member of an organization.
  #
  # If you are checking for membership of a user of an organization that
  # you are in, use .organization_member? instead.
  #
  # @example Check if a user is a hubbernaut
  #   @client.organization_public_member?('github', 'pengwynn')
  #   => true
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of the user to check.
  # @return [Boolean] Is a public member?
  # @see https://developer.github.com/v3/orgs/members/#check-public-membership
  def organization_public_member?(org, user, options = T.unsafe(nil)); end

  # Get organization public members
  #
  # Lists the public members of an organization
  #
  # @example
  #   Octokit.organization_public_members('github')
  # @example
  #   Octokit.org_public_members('github')
  # @param org [String] Organization GitHub username.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/members/#public-members-list
  def organization_public_members(org, options = T.unsafe(nil)); end

  # List organization repositories
  #
  # Public repositories are available without authentication. Private repos
  # require authenticated organization member.
  #
  # @example
  #   Octokit.organization_repositories('github')
  # @example
  #   Octokit.org_repositories('github')
  # @example
  #   Octokit.org_repos('github')
  # @example
  #   @client.org_repos('github', {:type => 'private'})
  # @option options
  # @param org [String, Integer] Organization GitHub login or id for which
  #   to list repos.
  # @param options [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-organization-repositories
  def organization_repositories(org, options = T.unsafe(nil)); end

  # List teams
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.organization_teams('github')
  # @example
  #   @client.org_teams('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing teams.
  # @see https://developer.github.com/v3/orgs/teams/#list-teams
  def organization_teams(org, options = T.unsafe(nil)); end

  # Get organizations for a user.
  #
  # Nonauthenticated calls to this method will return organizations that
  # the user is a public member.
  #
  # Use an authenicated client to get both public and private organizations
  # for a user.
  #
  # Calling this method on a `@client` will return that users organizations.
  # Private organizations are included only if the `@client` is authenticated.
  #
  # @example
  #   Octokit.organizations('pengwynn')
  # @example
  #   @client.organizations('pengwynn')
  # @example
  #   Octokit.orgs('pengwynn')
  # @example
  #   Octokit.list_organizations('pengwynn')
  # @example
  #   Octokit.list_orgs('pengwynn')
  # @example
  #   @client.organizations
  # @param user [Integer, String] GitHub user login or id of the user to get
  #   list of organizations.
  # @return [Array<Sawyer::Resource>] Array of hashes representing organizations.
  # @see https://developer.github.com/v3/orgs/#list-your-organizations
  # @see https://developer.github.com/v3/orgs/#list-user-organizations
  def organizations(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get organizations for a user.
  #
  # Nonauthenticated calls to this method will return organizations that
  # the user is a public member.
  #
  # Use an authenicated client to get both public and private organizations
  # for a user.
  #
  # Calling this method on a `@client` will return that users organizations.
  # Private organizations are included only if the `@client` is authenticated.
  #
  # @example
  #   Octokit.organizations('pengwynn')
  # @example
  #   @client.organizations('pengwynn')
  # @example
  #   Octokit.orgs('pengwynn')
  # @example
  #   Octokit.list_organizations('pengwynn')
  # @example
  #   Octokit.list_orgs('pengwynn')
  # @example
  #   @client.organizations
  # @param user [Integer, String] GitHub user login or id of the user to get
  #   list of organizations.
  # @return [Array<Sawyer::Resource>] Array of hashes representing organizations.
  # @see https://developer.github.com/v3/orgs/#list-your-organizations
  # @see https://developer.github.com/v3/orgs/#list-user-organizations
  def orgs(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List outside collaborators for an organization
  #
  # Requires authenticated organization members.
  #
  # @example
  #   @client.outside_collaborators('github')
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/outside_collaborators/#list-outside-collaborators
  def outside_collaborators(org, options = T.unsafe(nil)); end

  # Publicize a user's membership of an organization
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.publicize_membership('github', 'pengwynn')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of user to publicize.
  # @return [Boolean] True if publicization successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/members/#publicize-a-users-membership
  def publicize_membership(org, user, options = T.unsafe(nil)); end

  # Remove organization member
  #
  # Requires authenticated organization owner or member with team `admin` access.
  #
  # @example
  #   @client.remove_organization_member('github', 'pengwynn')
  # @example
  #   @client.remove_org_member('github', 'pengwynn')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of user to remove.
  # @return [Boolean] True if removal is successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/members/#remove-a-member
  def remove_org_member(org, user, options = T.unsafe(nil)); end

  # Remove an organization membership
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/orgs/members/#remove-organization-membership
  def remove_org_membership(org, options = T.unsafe(nil)); end

  # Remove organization member
  #
  # Requires authenticated organization owner or member with team `admin` access.
  #
  # @example
  #   @client.remove_organization_member('github', 'pengwynn')
  # @example
  #   @client.remove_org_member('github', 'pengwynn')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of user to remove.
  # @return [Boolean] True if removal is successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/members/#remove-a-member
  def remove_organization_member(org, user, options = T.unsafe(nil)); end

  # Remove an organization membership
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/orgs/members/#remove-organization-membership
  def remove_organization_membership(org, options = T.unsafe(nil)); end

  # Remove outside collaborator from an organization
  #
  # Requires authenticated organization members.
  #
  # @example
  #   @client.remove_outside_collaborator('github', 'lizzhale')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username to be removed as outside collaborator
  # @return [Boolean] Return true if outside collaborator removed from organization, false otherwise.
  # @see https://developer.github.com/v3/orgs/outside-collaborators/#remove-outside-collaborator
  def remove_outside_collaborator(org, user, options = T.unsafe(nil)); end

  # Remove team member
  #
  # Requires authenticated organization owner or member with team
  # `admin` permission.
  #
  # @example
  #   @client.remove_team_member(100000, 'pengwynn')
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of the user to boot.
  # @return [Boolean] True if user removed, false otherwise.
  # @see https://developer.github.com/v3/orgs/teams/#remove-team-member
  def remove_team_member(team_id, user, options = T.unsafe(nil)); end

  # Remove team membership
  #
  # @example
  #   @client.remove_team_membership(100000, 'pengwynn')
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of the user to boot.
  # @return [Boolean] True if user removed, false otherwise.
  # @see https://developer.github.com/v3/orgs/teams/#remove-team-membership
  def remove_team_membership(team_id, user, options = T.unsafe(nil)); end

  # Remove team repository
  #
  # Removes repository from team. Does not delete the repository.
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.remove_team_repository(100000, 'github/developer.github.com')
  # @example
  #   @client.remove_team_repo(100000, 'github/developer.github.com')
  # @param team_id [Integer] Team id.
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @return [Boolean] Return true if repo removed from team, false otherwise.
  # @see Octokit::Repository
  # @see https://developer.github.com/v3/orgs/teams/#remove-team-repository
  def remove_team_repo(team_id, repo, _options = T.unsafe(nil)); end

  # Remove team repository
  #
  # Removes repository from team. Does not delete the repository.
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.remove_team_repository(100000, 'github/developer.github.com')
  # @example
  #   @client.remove_team_repo(100000, 'github/developer.github.com')
  # @param team_id [Integer] Team id.
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @return [Boolean] Return true if repo removed from team, false otherwise.
  # @see Octokit::Repository
  # @see https://developer.github.com/v3/orgs/teams/#remove-team-repository
  def remove_team_repository(team_id, repo, _options = T.unsafe(nil)); end

  # Initiates the generation of a migration archive.
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.start_migration('github', ['github/dotfiles'])
  # @option options
  # @param org [String, Integer] Organization GitHub login or id.
  # @param repositories [Array<String>] :repositories Repositories for the organization.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing the new migration.
  # @see https://docs.github.com/en/rest/reference/migrations#start-an-organization-migration
  def start_migration(org, repositories, options = T.unsafe(nil)); end

  # Get team
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team(100000)
  # @param team_id [Integer] Team id.
  # @return [Sawyer::Resource] Hash representing team.
  # @see https://developer.github.com/v3/orgs/teams/#get-team
  def team(team_id, options = T.unsafe(nil)); end

  # Get team by name and org
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team_by_name("github", "justice-league")
  # @param org [String, Integer] Organization GitHub login or id.
  # @param team_slug [String] Team slug.
  # @return [Sawyer::Resource] Hash representing team.
  # @see https://developer.github.com/v3/teams/#get-team-by-name
  def team_by_name(org, team_slug, options = T.unsafe(nil)); end

  # List pending team invitations
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team_invitations('github')
  # @param team_id [Integer] Team id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing invitations.
  # @see https://developer.github.com/v3/orgs/teams/#list-pending-team-invitations
  def team_invitations(team_id, options = T.unsafe(nil)); end

  # Check if a user is a member of a team.
  #
  # Use this to check if another user is a member of a team that
  # you are a member.
  #
  # @example Check if a user is in your team
  #   @client.team_member?(100000, 'pengwynn')
  #   => false
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of the user to check.
  # @return [Boolean] Is a member?
  # @see https://developer.github.com/v3/orgs/teams/#get-team-member
  def team_member?(team_id, user, options = T.unsafe(nil)); end

  # List team members
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team_members(100000)
  # @param team_id [Integer] Team id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/orgs/teams/#list-team-members
  def team_members(team_id, options = T.unsafe(nil)); end

  # Check if a user has a team membership.
  #
  # @example Check if a user has a membership for a team
  #   @client.team_membership(1234, 'pengwynn')
  # @param team_id [Integer] Team id.
  # @param user [String] GitHub username of the user to check.
  # @return [Sawyer::Resource] Hash of team membership info
  # @see https://developer.github.com/v3/orgs/teams/#get-team-membership
  def team_membership(team_id, user, options = T.unsafe(nil)); end

  # Check if a repo is managed by a specific team
  #
  # @example
  #   @client.team_repository?(8675309, 'octokit/octokit.rb')
  # @example
  #   @client.team_repo?(8675309, 'octokit/octokit.rb')
  # @param team_id [Integer] Team ID.
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @return [Boolean] True if managed by a team. False if not managed by
  #   the team OR the requesting user does not have authorization to access
  #   the team information.
  # @see https://developer.github.com/v3/orgs/teams/#check-if-a-team-manages-a-repository
  def team_repo?(team_id, repo, _options = T.unsafe(nil)); end

  # List team repositories
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team_repositories(100000)
  # @example
  #   @client.team_repos(100000)
  # @param team_id [Integer] Team id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing repositories.
  # @see https://developer.github.com/v3/orgs/teams/#list-team-repos
  def team_repos(team_id, options = T.unsafe(nil)); end

  # List team repositories
  #
  # Requires authenticated organization member.
  #
  # @example
  #   @client.team_repositories(100000)
  # @example
  #   @client.team_repos(100000)
  # @param team_id [Integer] Team id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing repositories.
  # @see https://developer.github.com/v3/orgs/teams/#list-team-repos
  def team_repositories(team_id, options = T.unsafe(nil)); end

  # Check if a repo is managed by a specific team
  #
  # @example
  #   @client.team_repository?(8675309, 'octokit/octokit.rb')
  # @example
  #   @client.team_repo?(8675309, 'octokit/octokit.rb')
  # @param team_id [Integer] Team ID.
  # @param repo [String, Hash, Repository] A GitHub repository.
  # @return [Boolean] True if managed by a team. False if not managed by
  #   the team OR the requesting user does not have authorization to access
  #   the team information.
  # @see https://developer.github.com/v3/orgs/teams/#check-if-a-team-manages-a-repository
  def team_repository?(team_id, repo, _options = T.unsafe(nil)); end

  # Unlock a previous migration archive.
  #
  # Requires authenticated organization owner.
  #
  # @param org [String, Integer] Organization GitHub login or id.
  # @param id [Integer] ID number of the migration.
  # @param repo [String] Name of the repository.
  # @see https://docs.github.com/en/rest/reference/migrations#unlock-an-organization-repository
  def unlock_repository(org, id, repo, options = T.unsafe(nil)); end

  # Conceal a user's membership of an organization.
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.unpublicize_membership('github', 'pengwynn')
  # @example
  #   @client.conceal_membership('github', 'pengwynn')
  # @param org [String, Integer] Organization GitHub login or id.
  # @param user [String] GitHub username of user to unpublicize.
  # @return [Boolean] True of unpublicization successful, false otherwise.
  # @see https://developer.github.com/v3/orgs/members/#conceal-a-users-membership
  def unpublicize_membership(org, user, options = T.unsafe(nil)); end

  # Update an organization.
  #
  # Requires authenticated client with proper organization permissions.
  #
  # @example
  #   @client.update_org('github', {:company => 'Unicorns, Inc.'})
  # @example
  #   @client.update_organization('github', {
  #   :billing_email => 'support@github.com',
  #   :company => 'GitHub',
  #   :email => 'support@github.com',
  #   :location => 'San Francisco',
  #   :name => 'github'
  #   })
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @param org [String, Integer] Organization GitHub login or id.
  # @param values [Hash] The updated organization attributes.
  # @return [Sawyer::Resource] Hash representing GitHub organization.
  # @see https://developer.github.com/v3/orgs/#edit-an-organization
  def update_org(org, values, options = T.unsafe(nil)); end

  # Edit an organization membership
  #
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Sawyer::Resource] Hash representing the updated organization membership.
  # @see https://developer.github.com/v3/orgs/members/#edit-your-organization-membership
  # @see https://developer.github.com/v3/orgs/members/#add-or-update-organization-membership
  def update_org_membership(org, options = T.unsafe(nil)); end

  # Update an organization.
  #
  # Requires authenticated client with proper organization permissions.
  #
  # @example
  #   @client.update_org('github', {:company => 'Unicorns, Inc.'})
  # @example
  #   @client.update_organization('github', {
  #   :billing_email => 'support@github.com',
  #   :company => 'GitHub',
  #   :email => 'support@github.com',
  #   :location => 'San Francisco',
  #   :name => 'github'
  #   })
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @option values
  # @param org [String, Integer] Organization GitHub login or id.
  # @param values [Hash] The updated organization attributes.
  # @return [Sawyer::Resource] Hash representing GitHub organization.
  # @see https://developer.github.com/v3/orgs/#edit-an-organization
  def update_organization(org, values, options = T.unsafe(nil)); end

  # Edit an organization membership
  #
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param org [String, Integer] Organization GitHub login or id.
  # @return [Sawyer::Resource] Hash representing the updated organization membership.
  # @see https://developer.github.com/v3/orgs/members/#edit-your-organization-membership
  # @see https://developer.github.com/v3/orgs/members/#add-or-update-organization-membership
  def update_organization_membership(org, options = T.unsafe(nil)); end

  # Update team
  #
  # Requires authenticated organization owner.
  #
  # @example
  #   @client.update_team(100000, {
  #   :name => 'Front-end Designers',
  #   :permission => 'push'
  #   })
  # @option options
  # @option options
  # @option options
  # @param team_id [Integer] Team id.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing updated team.
  # @see https://developer.github.com/v3/orgs/teams/#edit-team
  def update_team(team_id, options = T.unsafe(nil)); end

  # List all teams for the authenticated user across all their orgs
  #
  # @return [Array<Sawyer::Resource>] Array of team resources.
  # @see https://developer.github.com/v3/orgs/teams/#list-user-teams
  def user_teams(options = T.unsafe(nil)); end
end

# Methods for the Pages API
#
# @see https://developer.github.com/v3/repos/pages/
module Octokit::Client::Pages
  # List the latest Pages build information for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return Sawyer::Resource A GitHub Pages resource about a build
  # @see https://developer.github.com/v3/repos/pages/#list-latest-pages-build
  def latest_pages_build(repo, options = T.unsafe(nil)); end

  # List Pages builds for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of build history for a repository.
  # @see https://developer.github.com/v3/repos/pages/#list-pages-builds
  def list_pages_builds(repo, options = T.unsafe(nil)); end

  # List Pages information for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return Sawyer::Resource A GitHub Pages resource
  # @see https://developer.github.com/v3/repos/pages/#get-information-about-a-pages-site
  def pages(repo, options = T.unsafe(nil)); end

  # Get a specific Pages build by ID
  #
  # @example
  #   Octokit.pages_build("github/developer.github.com", 5472601)
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param id [Integer, String] Build ID
  # @return [Sawyer::Resource] Pages build information
  # @see https://developer.github.com/v3/repos/pages/#list-a-specific-pages-build
  def pages_build(repo, id, options = T.unsafe(nil)); end

  # List Pages builds for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of build history for a repository.
  # @see https://developer.github.com/v3/repos/pages/#list-pages-builds
  def pages_builds(repo, options = T.unsafe(nil)); end

  # Request a page build for the latest revision of the default branch
  #
  # You can only request builds for your repositories
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] Request result
  # @see https://developer.github.com/v3/repos/pages/#request-a-page-build
  def request_page_build(repo, options = T.unsafe(nil)); end
end

# Methods for Projects API
#
# @see https://developer.github.com/v3/repos/projects
module Octokit::Client::Projects
  # List columns cards
  #
  # Requires authenticated client
  #
  # @example
  #   @client.column_cards(30294)
  # @param id [Integer] Project column id
  # @return [Array<Sawyer::Resource>] Cards in the column
  # @see https://developer.github.com/v3/projects/cards/#list-project-cards
  def column_cards(id, options = T.unsafe(nil)); end

  # Create organization project
  #
  # Requires authenticated client
  #
  # @example Create a project with name and body
  #   @client.create_org_project("octokit", "octocan", body: 'Improve clients')
  # @example Create with only a name
  #   @client.create_org_project("octocat", "make more octocats")
  # @option options
  # @param name [String] Project name
  # @param org [String] A GitHub organization
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Organization project
  # @see https://developer.github.com/v3/projects/#create-an-organization-project
  def create_org_project(org, name, options = T.unsafe(nil)); end

  # Create organization project
  #
  # Requires authenticated client
  #
  # @example Create a project with name and body
  #   @client.create_org_project("octokit", "octocan", body: 'Improve clients')
  # @example Create with only a name
  #   @client.create_org_project("octocat", "make more octocats")
  # @option options
  # @param name [String] Project name
  # @param org [String] A GitHub organization
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Organization project
  # @see https://developer.github.com/v3/projects/#create-an-organization-project
  def create_organization_project(org, name, options = T.unsafe(nil)); end

  # Create a project
  #
  # Requires authenticated client
  #
  # @example Create project with name and body
  #   @client.create_project('octokit/octokit.rb', 'bugs be gone', body: 'Fix all the bugs @joeyw creates')
  # @example Create project with only a name
  #   @client.create_project('octokit/octokit.rb', 'implement new APIs')
  # @option options
  # @param name [String] Project name
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Fresh new project
  # @see https://developer.github.com/v3/projects/#create-a-repository-project
  def create_project(repo, name, options = T.unsafe(nil)); end

  # Create project card
  #
  # Requires authenticated client
  #
  # @example Create a project card for an repository issue
  #   @client.create_project_card(123495, content_id: 1, content_type: 'Issue')
  # @example Create a project card with a note
  #   @client.create_project_card(123495, note: 'New note card')
  # @note If :note is supplied, :content_id and :content_type must be
  #   excluded. Similarly, if :content_id is supplied, :content_type must
  #   be set and :note must not be included.
  # @option options
  # @option options
  # @option options
  # @param id [Integer] Project column id
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Newly created card
  # @see https://developer.github.com/v3/projects/cards/#create-a-project-card
  def create_project_card(id, options = T.unsafe(nil)); end

  # Create a project column
  #
  # Requires authenticated client
  #
  # @example
  #   @client.create_project_column(123942, "To Dones")
  # @param id [Integer] Project column id
  # @param name [String] New column name
  # @return [Sawyer::Resource] Newly created column
  # @see https://developer.github.com/v3/projects/columns/#create-a-project-column
  def create_project_column(id, name, options = T.unsafe(nil)); end

  # Delete a project
  #
  # Requires authenticated client
  #
  # @example
  #   @client.delete_project(123942)
  # @param id [Integer] Project id
  # @return [Boolean] Result of deletion
  # @see https://developer.github.com/v3/projects/#delete-a-project
  def delete_project(id, options = T.unsafe(nil)); end

  # Delete a project card
  #
  # Requires authenticated client
  #
  # @example
  #   @client.delete_project_card(123495)
  # @param id [Integer] Project card id
  # @return [Boolean] True of deleted, false otherwise
  # @see https://developer.github.com/v3/projects/cards/#delete-a-project-card
  def delete_project_card(id, options = T.unsafe(nil)); end

  # Delete a project column
  #
  # Requires authenticated client
  #
  # @example
  #   @client.delete_project_column(30294)
  # @param id [Integer] Project column id
  # @return [Boolean] Result of deletion request, true when deleted
  # @see https://developer.github.com/v3/projects/columns/#delete-a-project-column
  def delete_project_column(id, options = T.unsafe(nil)); end

  # Move a project card
  #
  # Requires authenticated client
  #
  # @example Move a card to the top of another column
  #   @client.move_project_card(123495, 'top', column_id: 59402)
  # @example Move a card to the bottom of the same column
  #   @client.move_project_card(123495, 'bottom')
  # @option options
  # @param position [String] Can be one of <tt>top</tt>, <tt>bottom</tt>,
  #   or <tt>after:<card-id></tt>, where <card-id> is the id value of a
  #   card in the same column, or in the new column specified by column_id.
  # @param id [Integer] Project card id
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Empty sawyer resource
  # @see https://developer.github.com/v3/projects/cards/#move-a-project-card
  def move_project_card(id, position, options = T.unsafe(nil)); end

  # Move a project column
  #
  # Requires authenticated client
  #
  # @example
  #   @client.move_project_column(30294, "last")
  # @param id [Integer] Project column id
  # @param position [String] New position for the column. Can be one of
  #   <tt>first</tt>, <tt>last</tt>, or <tt>after:<column-id></tt>, where
  #   <tt><column-id></tt> is the id value of a column in the same project.
  # @return [Sawyer::Resource] Result
  # @see https://developer.github.com/v3/projects/columns/#move-a-project-column
  def move_project_column(id, position, options = T.unsafe(nil)); end

  # List organization projects
  #
  # Requires authenticated client
  #
  # @example
  #   @client.org_projects("octokit")
  # @param org [String] A GitHub organization
  # @return [Array<Sawyer::Resource>] Organization projects
  # @see https://developer.github.com/v3/projects/#list-organization-projects
  def org_projects(org, options = T.unsafe(nil)); end

  # List organization projects
  #
  # Requires authenticated client
  #
  # @example
  #   @client.org_projects("octokit")
  # @param org [String] A GitHub organization
  # @return [Array<Sawyer::Resource>] Organization projects
  # @see https://developer.github.com/v3/projects/#list-organization-projects
  def organization_projects(org, options = T.unsafe(nil)); end

  # Get a project by id
  #
  # @example
  #   Octokit.project(123942)
  # @param id [Integer] Project id
  # @return [Sawyer::Resource] Project
  # @see https://developer.github.com/v3/projects/#get-a-project
  def project(id, options = T.unsafe(nil)); end

  # Get a project card
  #
  # Requires authenticated client
  #
  # @example
  #   @client.project_card(123495)
  # @param id [Integer] Project card id
  # @return [Sawyer::Resource] Project card
  # @see https://developer.github.com/v3/projects/cards/#get-a-project-card
  def project_card(id, options = T.unsafe(nil)); end

  # Get a project column by ID
  #
  # @example
  #   Octokit.project_column(30294)
  # @param id [Integer] Project column id
  # @return [Sawyer::Resource] Project column
  # @see https://developer.github.com/v3/projects/columns/#get-a-project-column
  def project_column(id, options = T.unsafe(nil)); end

  # List project columns
  #
  # @example
  #   @client.project_columns(123942)
  # @param id [Integer] Project id
  # @return [Array<Sawyer::Resource>] List of project columns
  # @see https://developer.github.com/v3/projects/columns/#list-project-columns
  def project_columns(id, options = T.unsafe(nil)); end

  # List projects for a repository
  #
  # Requires authenticated client
  #
  # @example
  #   @client.projects('octokit/octokit.rb')
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] Repository projects
  # @see https://developer.github.com/v3/projects/#list-repository-projects
  def projects(repo, options = T.unsafe(nil)); end

  # Update a project
  #
  # Requires authenticated client
  #
  # @example Update project name
  #   @client.update_project(123942, name: 'New name')
  # @option options
  # @option options
  # @param id [Integer] Project id
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Project
  # @see https://developer.github.com/v3/projects/#update-a-project
  def update_project(id, options = T.unsafe(nil)); end

  # Update a project card
  #
  # Requires authenticated client
  #
  # @example
  #   @client.update_project_card(12345, note: 'new note')
  # @option options
  # @param id [Integer] Project card id
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Updated project card
  # @see https://developer.github.com/v3/projects/cards/#update-a-project-card
  def update_project_card(id, options = T.unsafe(nil)); end

  # Update a project column
  #
  # Requires authenticated client
  #
  # @example
  #   @client.update_project_column(30294, "new column name")
  # @param id [Integer] Project column id
  # @param name [String] New column name
  # @return [Sawyer::Resource] Updated column
  # @see https://developer.github.com/v3/projects/columns/#update-a-project-column
  def update_project_column(id, name, options = T.unsafe(nil)); end
end

# Methods for the PubSubHubbub API
#
# @see https://developer.github.com/v3/repos/hooks/#pubsubhubbub
module Octokit::Client::PubSubHubbub
  # Subscribe to a pubsub topic
  #
  # @example Subscribe to push events from one of your repositories, having an email sent when fired
  #   client = Octokit::Client.new(:oauth_token = "token")
  #   client.subscribe("https://github.com/joshk/devise_imapable/events/push", "github://Email?address=josh.kalderimis@gmail.com")
  # @param topic [String] A recoginized and supported pubsub topic
  # @param callback [String] A callback url to be posted to when the topic event is fired
  # @param secret [String] An optional shared secret used to generate a SHA1 HMAC of the outgoing body content
  # @return [Boolean] true if the subscribe was successful, otherwise an error is raised
  # @see https://developer.github.com/v3/repos/hooks/#subscribing
  def subscribe(topic, callback, secret = T.unsafe(nil)); end

  # Subscribe to a repository through pubsub
  #
  # @example Subscribe to push events to one of your repositories to Travis-CI
  #   client = Octokit::Client.new(:oauth_token = "token")
  #   client.subscribe_service_hook('joshk/device_imapable', 'Travis', { :token => "test", :domain => "domain", :user => "user" })
  # @param repo [String, Repository, Hash] A GitHub repository
  # @param service_name [String] service name owner
  # @param service_arguments [Hash] params that will be passed by subscribed hook.
  #   List of services is available @ https://github.com/github/github-services/tree/master/docs.
  #   Please refer Data node for complete list of arguments.
  # @param secret [String] An optional shared secret used to generate a SHA1 HMAC of the outgoing body content
  # @return [Boolean] True if subscription successful, false otherwise
  # @see https://developer.github.com/v3/repos/hooks/#subscribing
  def subscribe_service_hook(repo, service_name, service_arguments = T.unsafe(nil), secret = T.unsafe(nil)); end

  # Unsubscribe from a pubsub topic
  #
  # @example Unsubscribe to push events from one of your repositories, no longer having an email sent when fired
  #   client = Octokit::Client.new(:oauth_token = "token")
  #   client.unsubscribe("https://github.com/joshk/devise_imapable/events/push", "github://Email?address=josh.kalderimis@gmail.com")
  # @param topic [String] A recoginized pubsub topic
  # @param callback [String] A callback url to be unsubscribed from
  # @return [Boolean] true if the unsubscribe was successful, otherwise an error is raised
  # @see https://developer.github.com/v3/repos/hooks/#subscribing
  def unsubscribe(topic, callback); end

  # Unsubscribe repository through pubsub
  #
  # @example Subscribe to push events to one of your repositories to Travis-CI
  #   client = Octokit::Client.new(:oauth_token = "token")
  #   client.unsubscribe_service_hook('joshk/device_imapable', 'Travis')
  # @param repo [String, Repository, Hash] A GitHub repository
  # @param service_name [String] service name owner
  #   List of services is available @ https://github.com/github/github-services/tree/master/docs.
  # @see https://developer.github.com/v3/repos/hooks/#subscribing
  def unsubscribe_service_hook(repo, service_name); end

  private

  def pub_sub_hubbub_request(options = T.unsafe(nil)); end
end

# Methods for the Pull Requests API
#
# @see https://developer.github.com/v3/pulls/
module Octokit::Client::PullRequests
  # Close a pull request
  #
  # @example
  #   @client.close_pull_request('octokit/octokit.rb', 67)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param number [Integer] Number of pull request to update.
  # @return [Sawyer::Resource] Hash representing updated pull request.
  # @see https://developer.github.com/v3/pulls/#update-a-pull-request
  def close_pull_request(repo, number, options = T.unsafe(nil)); end

  # Create a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment("octokit/octokit.rb", 163, ":shipit:",
  #   "2d3201e4440903d8b04a5487842053ca4883e5f0", "lib/octokit/request.rb", 47)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment content
  # @param path [String] Relative path of the file to comment on.
  # @param position [Integer] Line index in the diff to comment on.
  # @param commit_id [String] Sha of the commit to comment on.
  # @return [Sawyer::Resource] Hash representing the new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_pull_comment(repo, pull_id, body, commit_id, path, position, options = T.unsafe(nil)); end

  # Create reply to a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment_reply("octokit/octokit.rb", 163, "done.", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment contents
  # @param comment_id [Integer] Comment id to reply to
  # @return [Sawyer::Resource] Hash representing new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_pull_reply(repo, pull_id, body, comment_id, options = T.unsafe(nil)); end

  # Create a pull request
  #
  # @example
  #   @client.create_pull_request("octokit/octokit.rb", "master", "feature-branch",
  #   "Pull Request title", "Pull Request body")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param base [String] The branch (or git ref) you want your changes
  #   pulled into. This should be an existing branch on the current
  #   repository. You cannot submit a pull request to one repo that requests
  #   a merge to a base of another repo.
  # @param head [String] The branch (or git ref) where your changes are implemented.
  # @param body [String] The body for the pull request (optional). Supports GFM.
  # @param title [String] Title for the pull request
  # @return [Sawyer::Resource] The newly created pull request
  # @see https://developer.github.com/v3/pulls/#create-a-pull-request
  def create_pull_request(repo, base, head, title, body = T.unsafe(nil), options = T.unsafe(nil)); end

  # Create a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment("octokit/octokit.rb", 163, ":shipit:",
  #   "2d3201e4440903d8b04a5487842053ca4883e5f0", "lib/octokit/request.rb", 47)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment content
  # @param path [String] Relative path of the file to comment on.
  # @param position [Integer] Line index in the diff to comment on.
  # @param commit_id [String] Sha of the commit to comment on.
  # @return [Sawyer::Resource] Hash representing the new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_pull_request_comment(repo, pull_id, body, commit_id, path, position, options = T.unsafe(nil)); end

  # Create reply to a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment_reply("octokit/octokit.rb", 163, "done.", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment contents
  # @param comment_id [Integer] Comment id to reply to
  # @return [Sawyer::Resource] Hash representing new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_pull_request_comment_reply(repo, pull_id, body, comment_id, options = T.unsafe(nil)); end

  # Create a pull request from existing issue
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param base [String] The branch (or git ref) you want your changes
  #   pulled into. This should be an existing branch on the current
  #   repository. You cannot submit a pull request to one repo that requests
  #   a merge to a base of another repo.
  # @param head [String] The branch (or git ref) where your changes are implemented.
  # @param issue [Integer] Number of Issue on which to base this pull request
  # @return [Sawyer::Resource] The newly created pull request
  # @see https://developer.github.com/v3/pulls/#alternative-input
  def create_pull_request_for_issue(repo, base, head, issue, options = T.unsafe(nil)); end

  # Create reply to a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment_reply("octokit/octokit.rb", 163, "done.", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment contents
  # @param comment_id [Integer] Comment id to reply to
  # @return [Sawyer::Resource] Hash representing new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_review_reply(repo, pull_id, body, comment_id, options = T.unsafe(nil)); end

  # Create a pull request comment
  #
  # @example
  #   @client.create_pull_request_comment("octokit/octokit.rb", 163, ":shipit:",
  #   "2d3201e4440903d8b04a5487842053ca4883e5f0", "lib/octokit/request.rb", 47)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param pull_id [Integer] Pull request id
  # @param body [String] Comment content
  # @param path [String] Relative path of the file to comment on.
  # @param position [Integer] Line index in the diff to comment on.
  # @param commit_id [String] Sha of the commit to comment on.
  # @return [Sawyer::Resource] Hash representing the new comment
  # @see https://developer.github.com/v3/pulls/comments/#create-a-comment
  def create_view_comment(repo, pull_id, body, commit_id, path, position, options = T.unsafe(nil)); end

  # Delete pull request comment
  #
  # @example
  #   @client.delete_pull_request_comment("octokit/octokit.rb", 1902707)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to delete
  # @return [Boolean] True if deleted, false otherwise
  # @see https://developer.github.com/v3/pulls/comments/#delete-a-comment
  def delete_pull_comment(repo, comment_id, options = T.unsafe(nil)); end

  # Delete pull request comment
  #
  # @example
  #   @client.delete_pull_request_comment("octokit/octokit.rb", 1902707)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to delete
  # @return [Boolean] True if deleted, false otherwise
  # @see https://developer.github.com/v3/pulls/comments/#delete-a-comment
  def delete_pull_request_comment(repo, comment_id, options = T.unsafe(nil)); end

  # Delete pull request comment
  #
  # @example
  #   @client.delete_pull_request_comment("octokit/octokit.rb", 1902707)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to delete
  # @return [Boolean] True if deleted, false otherwise
  # @see https://developer.github.com/v3/pulls/comments/#delete-a-comment
  def delete_review_comment(repo, comment_id, options = T.unsafe(nil)); end

  # Merge a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @param commit_message [String] Optional commit message for the merge commit
  # @return [Array<Sawyer::Resource>] Merge commit info if successful
  # @see https://developer.github.com/v3/pulls/#merge-a-pull-request-merge-button
  def merge_pull_request(repo, number, commit_message = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get a pull request
  #
  # @example
  #   Octokit.pull_request('rails/rails', 42, :state => 'closed')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of the pull request to fetch
  # @return [Sawyer::Resource] Pull request info
  # @see https://developer.github.com/v3/pulls/#get-a-single-pull-request
  def pull(repo, number, options = T.unsafe(nil)); end

  # Get a pull request comment
  #
  # @example
  #   @client.pull_request_comment("pengwynn/octkit", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of comment to get
  # @return [Sawyer::Resource] Hash representing the comment
  # @see https://developer.github.com/v3/pulls/comments/#get-a-single-comment
  def pull_comment(repo, comment_id, options = T.unsafe(nil)); end

  # List comments on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of comments
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-on-a-pull-request
  def pull_comments(repo, number, options = T.unsafe(nil)); end

  # List commits on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of commits
  # @see https://developer.github.com/v3/pulls/#list-commits-on-a-pull-request
  def pull_commits(repo, number, options = T.unsafe(nil)); end

  # List files on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of files
  # @see https://developer.github.com/v3/pulls/#list-pull-requests-files
  def pull_files(repo, number, options = T.unsafe(nil)); end

  # Check pull request merge status
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Boolean] True if the pull request has been merged
  # @see https://developer.github.com/v3/pulls/#get-if-a-pull-request-has-been-merged
  def pull_merged?(repo, number, options = T.unsafe(nil)); end

  # Get a pull request
  #
  # @example
  #   Octokit.pull_request('rails/rails', 42, :state => 'closed')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of the pull request to fetch
  # @return [Sawyer::Resource] Pull request info
  # @see https://developer.github.com/v3/pulls/#get-a-single-pull-request
  def pull_request(repo, number, options = T.unsafe(nil)); end

  # Get a pull request comment
  #
  # @example
  #   @client.pull_request_comment("pengwynn/octkit", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of comment to get
  # @return [Sawyer::Resource] Hash representing the comment
  # @see https://developer.github.com/v3/pulls/comments/#get-a-single-comment
  def pull_request_comment(repo, comment_id, options = T.unsafe(nil)); end

  # List comments on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of comments
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-on-a-pull-request
  def pull_request_comments(repo, number, options = T.unsafe(nil)); end

  # List commits on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of commits
  # @see https://developer.github.com/v3/pulls/#list-commits-on-a-pull-request
  def pull_request_commits(repo, number, options = T.unsafe(nil)); end

  # List files on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of files
  # @see https://developer.github.com/v3/pulls/#list-pull-requests-files
  def pull_request_files(repo, number, options = T.unsafe(nil)); end

  # Check pull request merge status
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Boolean] True if the pull request has been merged
  # @see https://developer.github.com/v3/pulls/#get-if-a-pull-request-has-been-merged
  def pull_request_merged?(repo, number, options = T.unsafe(nil)); end

  # List pull requests for a repository
  #
  # @example
  #   Octokit.pull_requests('rails/rails', :state => 'closed')
  # @overload pull_requests
  # @return [Array<Sawyer::Resource>] Array of pulls
  # @see https://developer.github.com/v3/pulls/#list-pull-requests
  def pull_requests(repo, options = T.unsafe(nil)); end

  # List pull request comments for a repository
  #
  # By default, Review Comments are ordered by ascending ID.
  #
  # @example Get review comments, sort by updated asc since a time
  #   @client.pull_requests_comments("octokit/octokit.rb", {
  #   :sort => 'updated',
  #   :direction => 'asc',
  #   :since => '2010-05-04T23:45:02Z'
  #   })
  # @example Get the pull request review comments in the octokit repository
  #   @client.issues_comments("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array] List of pull request review comments.
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-in-a-repository
  def pull_requests_comments(repo, options = T.unsafe(nil)); end

  # List pull requests for a repository
  #
  # @example
  #   Octokit.pull_requests('rails/rails', :state => 'closed')
  # @overload pull_requests
  # @return [Array<Sawyer::Resource>] Array of pulls
  # @see https://developer.github.com/v3/pulls/#list-pull-requests
  def pulls(repo, options = T.unsafe(nil)); end

  # List pull request comments for a repository
  #
  # By default, Review Comments are ordered by ascending ID.
  #
  # @example Get review comments, sort by updated asc since a time
  #   @client.pull_requests_comments("octokit/octokit.rb", {
  #   :sort => 'updated',
  #   :direction => 'asc',
  #   :since => '2010-05-04T23:45:02Z'
  #   })
  # @example Get the pull request review comments in the octokit repository
  #   @client.issues_comments("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array] List of pull request review comments.
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-in-a-repository
  def pulls_comments(repo, options = T.unsafe(nil)); end

  # Get a pull request comment
  #
  # @example
  #   @client.pull_request_comment("pengwynn/octkit", 1903950)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of comment to get
  # @return [Sawyer::Resource] Hash representing the comment
  # @see https://developer.github.com/v3/pulls/comments/#get-a-single-comment
  def review_comment(repo, comment_id, options = T.unsafe(nil)); end

  # List comments on a pull request
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number of pull request
  # @return [Array<Sawyer::Resource>] List of comments
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-on-a-pull-request
  def review_comments(repo, number, options = T.unsafe(nil)); end

  # List pull request comments for a repository
  #
  # By default, Review Comments are ordered by ascending ID.
  #
  # @example Get review comments, sort by updated asc since a time
  #   @client.pull_requests_comments("octokit/octokit.rb", {
  #   :sort => 'updated',
  #   :direction => 'asc',
  #   :since => '2010-05-04T23:45:02Z'
  #   })
  # @example Get the pull request review comments in the octokit repository
  #   @client.issues_comments("octokit/octokit.rb")
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param options [Hash] Optional parameters
  # @return [Array] List of pull request review comments.
  # @see https://developer.github.com/v3/pulls/comments/#list-comments-in-a-repository
  def reviews_comments(repo, options = T.unsafe(nil)); end

  # Update pull request comment
  #
  # @example
  #   @client.update_pull_request_comment("octokit/octokit.rb", 1903950, ":shipit:")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to update
  # @param body [String] Updated comment content
  # @return [Sawyer::Resource] Hash representing the updated comment
  # @see https://developer.github.com/v3/pulls/comments/#edit-a-comment
  def update_pull_comment(repo, comment_id, body, options = T.unsafe(nil)); end

  # Update a pull request
  #
  # @example
  #   @client.update_pull_request('octokit/octokit.rb', 67, 'new title', 'updated body', 'closed')
  # @example Passing nil for optional attributes to update specific attributes.
  #   @client.update_pull_request('octokit/octokit.rb', 67, nil, nil, 'open')
  # @example Empty body by passing empty string
  #   @client.update_pull_request('octokit/octokit.rb', 67, nil, '')
  # @overload update_pull_request
  # @overload update_pull_request
  # @return [Sawyer::Resource] Hash representing updated pull request.
  # @see https://developer.github.com/v3/pulls/#update-a-pull-request
  def update_pull_request(*args); end

  # Update pull request comment
  #
  # @example
  #   @client.update_pull_request_comment("octokit/octokit.rb", 1903950, ":shipit:")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to update
  # @param body [String] Updated comment content
  # @return [Sawyer::Resource] Hash representing the updated comment
  # @see https://developer.github.com/v3/pulls/comments/#edit-a-comment
  def update_pull_request_comment(repo, comment_id, body, options = T.unsafe(nil)); end

  # Update pull request comment
  #
  # @example
  #   @client.update_pull_request_comment("octokit/octokit.rb", 1903950, ":shipit:")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param comment_id [Integer] Id of the comment to update
  # @param body [String] Updated comment content
  # @return [Sawyer::Resource] Hash representing the updated comment
  # @see https://developer.github.com/v3/pulls/comments/#edit-a-comment
  def update_review_comment(repo, comment_id, body, options = T.unsafe(nil)); end
end

# Methods for API rate limiting info
#
# @see https://developer.github.com/v3/#rate-limiting
module Octokit::Client::RateLimit
  # Get rate limit info from last response if available
  # or make a new request to fetch rate limit
  #
  # @return [Octokit::RateLimit] Rate limit info
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def rate_limit(_options = T.unsafe(nil)); end

  # Refresh rate limit info by making a new request
  #
  # @return [Octokit::RateLimit] Rate limit info
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def rate_limit!(_options = T.unsafe(nil)); end

  # Get number of rate limted requests remaining
  #
  # @return [Integer] Number of requests remaining in this period
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def rate_limit_remaining(_options = T.unsafe(nil)); end

  # Refresh rate limit info and get number of rate limted requests remaining
  #
  # @return [Integer] Number of requests remaining in this period
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def rate_limit_remaining!(_options = T.unsafe(nil)); end

  # Get rate limit info from last response if available
  # or make a new request to fetch rate limit
  #
  # @return [Octokit::RateLimit] Rate limit info
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def ratelimit(_options = T.unsafe(nil)); end

  # Refresh rate limit info by making a new request
  #
  # @return [Octokit::RateLimit] Rate limit info
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def ratelimit!(_options = T.unsafe(nil)); end

  # Get number of rate limted requests remaining
  #
  # @return [Integer] Number of requests remaining in this period
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def ratelimit_remaining(_options = T.unsafe(nil)); end

  # Refresh rate limit info and get number of rate limted requests remaining
  #
  # @return [Integer] Number of requests remaining in this period
  # @see https://developer.github.com/v3/rate_limit/#rate-limit
  def ratelimit_remaining!(_options = T.unsafe(nil)); end
end

# Methods for the Reacions API
#
# @see https://developer.github.com/v3/reactions/
module Octokit::Client::Reactions
  # List reactions for a commit comment
  #
  # @example
  #   @client.commit_comment_reactions("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The id of the commit comment
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the reactions.
  # @see https://developer.github.com/v3/reactions/#list-reactions-for-a-commit-comment
  def commit_comment_reactions(repo, id, options = T.unsafe(nil)); end

  # Create a reaction for a commit comment
  #
  # @example
  #   @client.create_commit_comment_reactions("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The id of the commit comment
  # @param reaction [String] The Reaction
  # @return [<Sawyer::Resource>] Hash representing the reaction
  # @see https://developer.github.com/v3/reactions/#create-reaction-for-a-commit-comment
  # @see https://developer.github.com/v3/reactions/#reaction-types
  def create_commit_comment_reaction(repo, id, reaction, options = T.unsafe(nil)); end

  # Create reaction for an issue comment
  #
  # @example
  #   @client.create_issue_comment_reaction("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The Issue comment id
  # @param reaction [String] The Reaction
  # @return [<Sawyer::Resource>] Hashes representing the reaction.
  # @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue-comment
  # @see https://developer.github.com/v3/reactions/#reaction-types
  def create_issue_comment_reaction(repo, id, reaction, options = T.unsafe(nil)); end

  # Create reaction for an issue
  #
  # @example
  #   @client.create_issue_reaction("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] The Issue number
  # @param reaction [String] The Reaction
  # @return [<Sawyer::Resource>] Hash representing the reaction.
  # @see https://developer.github.com/v3/reactions/#create-reaction-for-an-issue
  # @see https://developer.github.com/v3/reactions/#reaction-types
  def create_issue_reaction(repo, number, reaction, options = T.unsafe(nil)); end

  # Create reaction for a pull request review comment
  #
  # @example
  #   @client.create_pull_request_reiew_comment_reaction("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The Issue comment id
  # @param reaction [String] The Reaction
  # @return [<Sawyer::Resource>] Hash representing the reaction.
  # @see https://developer.github.com/v3/reactions/#create-reaction-for-a-pull-request-review-comment
  # @see https://developer.github.com/v3/reactions/#reaction-types
  def create_pull_request_review_comment_reaction(repo, id, reaction, options = T.unsafe(nil)); end

  # Delete a reaction
  #
  # @example
  #   @client.delete_reaction(1)
  # @param id [Integer] Reaction id
  # @return [Boolean] Return true if reaction was deleted, false otherwise.
  # @see https://developer.github.com/v3/reactions/#delete-a-reaction
  def delete_reaction(id, options = T.unsafe(nil)); end

  # List reactions for an issue comment
  #
  # @example
  #   @client.issue_comment_reactions("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The Issue comment id
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the reactions.
  # @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue-comment
  def issue_comment_reactions(repo, id, options = T.unsafe(nil)); end

  # List reactions for an issue
  #
  # @example
  #   @client.issue_reactions("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] The Issue number
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the reactions.
  # @see https://developer.github.com/v3/reactions/#list-reactions-for-an-issue
  def issue_reactions(repo, number, options = T.unsafe(nil)); end

  # List reactions for a pull request review comment
  #
  # @example
  #   @client.pull_request_review_comment_reactions("octokit/octokit.rb", 1)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The Issue comment id
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the reactions.
  # @see https://developer.github.com/v3/reactions/#list-reactions-for-a-pull-request-review-comment
  def pull_request_review_comment_reactions(repo, id, options = T.unsafe(nil)); end
end

# Methods for References for Git Data API
#
# @see https://developer.github.com/v3/git/refs/
module Octokit::Client::Refs
  # Create a reference
  #
  # @example Create refs/heads/master for octocat/Hello-World with sha 827efc6d56897b048c772eb4087f854f46256132
  #   Octokit.create_ref("octocat/Hello-World", "heads/master", "827efc6d56897b048c772eb4087f854f46256132")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @param sha [String] A SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @return [Array<Sawyer::Resource>] The list of references, already containing the new one
  # @see https://developer.github.com/v3/git/refs/#create-a-reference
  def create_ref(repo, ref, sha, options = T.unsafe(nil)); end

  # Create a reference
  #
  # @example Create refs/heads/master for octocat/Hello-World with sha 827efc6d56897b048c772eb4087f854f46256132
  #   Octokit.create_ref("octocat/Hello-World", "heads/master", "827efc6d56897b048c772eb4087f854f46256132")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @param sha [String] A SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @return [Array<Sawyer::Resource>] The list of references, already containing the new one
  # @see https://developer.github.com/v3/git/refs/#create-a-reference
  def create_reference(repo, ref, sha, options = T.unsafe(nil)); end

  # Delete a single branch
  #
  # @example Delete uritemplate for sigmavirus24/github3.py
  #   Octokit.delete_branch("sigmavirus24/github3.py", "uritemplate")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param branch [String] The branch, e.g. <tt>fix-refs</tt>
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/git/refs/#delete-a-reference
  def delete_branch(repo, branch, options = T.unsafe(nil)); end

  # Delete a single reference
  #
  # @example Delete tags/v0.0.3 for sferik/rails_admin
  #   Octokit.delete_ref("sferik/rails_admin","tags/v0.0.3")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/git/refs/#delete-a-reference
  def delete_ref(repo, ref, options = T.unsafe(nil)); end

  # Delete a single reference
  #
  # @example Delete tags/v0.0.3 for sferik/rails_admin
  #   Octokit.delete_ref("sferik/rails_admin","tags/v0.0.3")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @return [Boolean] Success
  # @see https://developer.github.com/v3/git/refs/#delete-a-reference
  def delete_reference(repo, ref, options = T.unsafe(nil)); end

  # List all refs for a given user and repo
  #
  # @example Fetch all refs for sferik/rails_admin
  #   Octokit.refs("sferik/rails_admin")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param namespace [String] The ref namespace, e.g. <tt>tag</tt> or <tt>heads</tt>
  # @return [Array<Sawyer::Resource>] A list of references matching the repo and the namespace
  # @see https://developer.github.com/v3/git/refs/#get-all-references
  def list_references(repo, namespace = T.unsafe(nil), options = T.unsafe(nil)); end

  # List all refs for a given user and repo
  #
  # @example Fetch all refs for sferik/rails_admin
  #   Octokit.refs("sferik/rails_admin")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param namespace [String] The ref namespace, e.g. <tt>tag</tt> or <tt>heads</tt>
  # @return [Array<Sawyer::Resource>] A list of references matching the repo and the namespace
  # @see https://developer.github.com/v3/git/refs/#get-all-references
  def list_refs(repo, namespace = T.unsafe(nil), options = T.unsafe(nil)); end

  # Fetch matching refs
  #
  # @example Fetch refs matching tags/v2 for sferik/rails_admin
  #   Octokit.ref("sferik/rails_admin","tags/v2")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt> or <tt>heads/rails-3</tt>
  # @return [Array<Sawyer::Resource>] The reference matching the given repo and the ref id
  # @see https://developer.github.com/v3/git/refs/#list-matching-references
  def matching_refs(repo, ref, options = T.unsafe(nil)); end

  # Fetch a given reference
  #
  # @example Fetch tags/v0.0.3 for sferik/rails_admin
  #   Octokit.ref("sferik/rails_admin","tags/v0.0.3")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @return [Sawyer::Resource] The reference matching the given repo and the ref id
  # @see https://developer.github.com/v3/git/refs/#get-a-reference
  def ref(repo, ref, options = T.unsafe(nil)); end

  # Fetch a given reference
  #
  # @example Fetch tags/v0.0.3 for sferik/rails_admin
  #   Octokit.ref("sferik/rails_admin","tags/v0.0.3")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @return [Sawyer::Resource] The reference matching the given repo and the ref id
  # @see https://developer.github.com/v3/git/refs/#get-a-reference
  def reference(repo, ref, options = T.unsafe(nil)); end

  # List all refs for a given user and repo
  #
  # @example Fetch all refs for sferik/rails_admin
  #   Octokit.refs("sferik/rails_admin")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param namespace [String] The ref namespace, e.g. <tt>tag</tt> or <tt>heads</tt>
  # @return [Array<Sawyer::Resource>] A list of references matching the repo and the namespace
  # @see https://developer.github.com/v3/git/refs/#get-all-references
  def references(repo, namespace = T.unsafe(nil), options = T.unsafe(nil)); end

  # List all refs for a given user and repo
  #
  # @example Fetch all refs for sferik/rails_admin
  #   Octokit.refs("sferik/rails_admin")
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param namespace [String] The ref namespace, e.g. <tt>tag</tt> or <tt>heads</tt>
  # @return [Array<Sawyer::Resource>] A list of references matching the repo and the namespace
  # @see https://developer.github.com/v3/git/refs/#get-all-references
  def refs(repo, namespace = T.unsafe(nil), options = T.unsafe(nil)); end

  # Update a branch
  #
  # @example Force update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_branch("octocat/Hello-World", "sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd")
  # @example Fast-forward update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_branch("octocat/Hello-World", "sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd", false)
  # @param branch [String] The ref, e.g. <tt>feature/new-shiny</tt>
  # @param force [Boolean] A flag indicating whether to force the update or to make sure the update is a fast-forward update.
  # @param sha [String] A SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] The list of references updated
  # @see https://developer.github.com/v3/git/refs/#update-a-reference
  def update_branch(repo, branch, sha, force = T.unsafe(nil), options = T.unsafe(nil)); end

  # Update a reference
  #
  # @example Force update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_ref("octocat/Hello-World", "heads/sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd")
  # @example Fast-forward update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_ref("octocat/Hello-World", "heads/sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd", false)
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @param force [Boolean] A flag indicating whether to force the update or to make sure the update is a fast-forward update.
  # @param sha [String] A SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] The list of references updated
  # @see https://developer.github.com/v3/git/refs/#update-a-reference
  def update_ref(repo, ref, sha, force = T.unsafe(nil), options = T.unsafe(nil)); end

  # Update a reference
  #
  # @example Force update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_ref("octocat/Hello-World", "heads/sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd")
  # @example Fast-forward update heads/sc/featureA for octocat/Hello-World with sha aa218f56b14c9653891f9e74264a383fa43fefbd
  #   Octokit.update_ref("octocat/Hello-World", "heads/sc/featureA", "aa218f56b14c9653891f9e74264a383fa43fefbd", false)
  # @param ref [String] The ref, e.g. <tt>tags/v0.0.3</tt>
  # @param force [Boolean] A flag indicating whether to force the update or to make sure the update is a fast-forward update.
  # @param sha [String] A SHA, e.g. <tt>827efc6d56897b048c772eb4087f854f46256132</tt>
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] The list of references updated
  # @see https://developer.github.com/v3/git/refs/#update-a-reference
  def update_reference(repo, ref, sha, force = T.unsafe(nil), options = T.unsafe(nil)); end
end

# Methods for the Releases API
#
# @see https://developer.github.com/v3/repos/releases/
module Octokit::Client::Releases
  # Create a release
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param tag_name [String] Git tag from which to create release
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#create-a-release
  def create_release(repo, tag_name, options = T.unsafe(nil)); end

  # Delete a release
  #
  # @param url [String] URL for the release as returned from .releases
  # @return [Boolean] Success or failure
  # @see https://developer.github.com/v3/repos/releases/#delete-a-release
  def delete_release(url, options = T.unsafe(nil)); end

  # Delete a release asset
  #
  # @param asset_url [String] URL for the asset as returned from .release_assets
  # @return [Boolean] Success or failure
  # @see https://developer.github.com/v3/repos/releases/#delete-a-release-asset
  def delete_release_asset(asset_url, options = T.unsafe(nil)); end

  # Update a release
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param url [String] URL for the release as returned from .releases
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#edit-a-release
  def edit_release(url, options = T.unsafe(nil)); end

  # Update a release asset
  #
  # @option options
  # @option options
  # @param asset_url [String] URL for the asset as returned from .release_assets
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release asset
  # @see https://developer.github.com/v3/repos/releases/#edit-a-release-asset
  def edit_release_asset(asset_url, options = T.unsafe(nil)); end

  # Get the latest release
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#get-the-latest-release
  def latest_release(repo, options = T.unsafe(nil)); end

  # List releases for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of releases
  # @see https://developer.github.com/v3/repos/releases/#list-releases-for-a-repository
  def list_releases(repo, options = T.unsafe(nil)); end

  # Get a release
  #
  # @param url [String] URL for the release as returned from .releases
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#get-a-single-release
  def release(url, options = T.unsafe(nil)); end

  # Get a single release asset
  #
  # @param asset_url [String] URL for the asset as returned from .release_assets
  # @return [Sawyer::Resource] The release asset
  # @see https://developer.github.com/v3/repos/releases/#get-a-single-release-asset
  def release_asset(asset_url, options = T.unsafe(nil)); end

  # List release assets
  #
  # @param release_url [String] URL for the release as returned from .releases
  # @return [Array<Sawyer::Resource>] A list of release assets
  # @see https://developer.github.com/v3/repos/releases/#list-assets-for-a-release
  def release_assets(release_url, options = T.unsafe(nil)); end

  # Get the release for a given tag
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param tag_name [String] the name for a tag
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#get-a-release-by-tag-name
  def release_for_tag(repo, tag_name, options = T.unsafe(nil)); end

  # List releases for a repository
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of releases
  # @see https://developer.github.com/v3/repos/releases/#list-releases-for-a-repository
  def releases(repo, options = T.unsafe(nil)); end

  # Update a release
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param url [String] URL for the release as returned from .releases
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release
  # @see https://developer.github.com/v3/repos/releases/#edit-a-release
  def update_release(url, options = T.unsafe(nil)); end

  # Update a release asset
  #
  # @option options
  # @option options
  # @param asset_url [String] URL for the asset as returned from .release_assets
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release asset
  # @see https://developer.github.com/v3/repos/releases/#edit-a-release-asset
  def update_release_asset(asset_url, options = T.unsafe(nil)); end

  # Upload a release asset
  #
  # @option options
  # @option options
  # @param release_url [String] URL for the release as returned from .releases
  # @param path_or_file [String] Path to file to upload
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The release asset
  # @see https://developer.github.com/v3/repos/releases/#upload-a-release-asset
  def upload_asset(release_url, path_or_file, options = T.unsafe(nil)); end

  private

  def content_type_from_file(file); end
end

# Methods for the Repositories API
#
# @see https://developer.github.com/v3/repos/
module Octokit::Client::Repositories
  # Add collaborator to repo
  #
  # This can also be used to update the permission of an existing collaborator
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.add_collaborator('octokit/octokit.rb', 'holman')
  # @example
  #   @client.add_collab('octokit/octokit.rb', 'holman')
  # @example Add a collaborator with admin permissions
  #   @client.add_collaborator('octokit/octokit.rb', 'holman', permission: 'admin')
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param collaborator [String] Collaborator GitHub username to add.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] True if collaborator added, false otherwise.
  # @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
  def add_collab(repo, collaborator, options = T.unsafe(nil)); end

  # Add collaborator to repo
  #
  # This can also be used to update the permission of an existing collaborator
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.add_collaborator('octokit/octokit.rb', 'holman')
  # @example
  #   @client.add_collab('octokit/octokit.rb', 'holman')
  # @example Add a collaborator with admin permissions
  #   @client.add_collaborator('octokit/octokit.rb', 'holman', permission: 'admin')
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param collaborator [String] Collaborator GitHub username to add.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] True if collaborator added, false otherwise.
  # @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
  def add_collaborator(repo, collaborator, options = T.unsafe(nil)); end

  # Add deploy key to a repo
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.add_deploy_key('octokit/octokit.rb', 'Staging server', 'ssh-rsa AAA...')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param title [String] Title reference for the deploy key.
  # @param key [String] Public key.
  # @return [Sawyer::Resource] Hash representing newly added key.
  # @see https://developer.github.com/v3/repos/keys/#add-a-new-deploy-key
  def add_deploy_key(repo, title, key, options = T.unsafe(nil)); end

  # List all repositories
  #
  # This provides a dump of every repository, in the order that they were
  # created.
  #
  # @option options
  # @param options [Hash] Optional options
  # @return [Array<Sawyer::Resource>] List of repositories.
  # @see https://developer.github.com/v3/repos/#list-all-public-repositories
  def all_repositories(options = T.unsafe(nil)); end

  # Get a single branch from a repository
  #
  # @example Get branch 'master` from octokit/octokit.rb
  #   Octokit.branch("octokit/octokit.rb", "master")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param branch [String] Branch name
  # @return [Sawyer::Resource] The branch requested, if it exists
  # @see https://developer.github.com/v3/repos/#get-branch
  def branch(repo, branch, options = T.unsafe(nil)); end

  # Get branch protection summary
  #
  # @example
  #   @client.branch_protection('octokit/octokit.rb', 'master')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param branch [String] Branch name
  # @return [Sawyer::Resource, nil] Branch protection summary or nil if the branch
  #   is not protected
  # @see https://developer.github.com/v3/repos/branches/#get-branch-protection
  def branch_protection(repo, branch, options = T.unsafe(nil)); end

  # List branches
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.branches('octokit/octokit.rb')
  # @example
  #   @client.branches('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing branches.
  # @see https://developer.github.com/v3/repos/#list-branches
  def branches(repo, options = T.unsafe(nil)); end

  # Check to see if a particular user is an assignee for a repository.
  #
  # @example
  #   Octokit.check_assignee('octokit/octokit.rb', 'andrew')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param assignee [String] User login to check
  # @return [Boolean] True if assignable on project, false otherwise.
  # @see https://developer.github.com/v3/issues/assignees/#check-assignee
  def check_assignee(repo, assignee, options = T.unsafe(nil)); end

  # Checks if a user is a collaborator for a repo.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.collaborator?('octokit/octokit.rb', 'holman')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param collaborator [String] Collaborator GitHub username to check.
  # @return [Boolean] True if user is a collaborator, false otherwise.
  # @see https://developer.github.com/v3/repos/collaborators/#check-if-a-user-is-a-collaborator
  def collaborator?(repo, collaborator, options = T.unsafe(nil)); end

  # List collaborators
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.collaborators('octokit/octokit.rb')
  # @example
  #   Octokit.collabs('octokit/octokit.rb')
  # @example
  #   @client.collabs('octokit/octokit.rb')
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] Array of hashes representing collaborating users.
  # @see https://developer.github.com/v3/repos/collaborators/#list-collaborators
  def collaborators(repo, options = T.unsafe(nil)); end

  # List collaborators
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.collaborators('octokit/octokit.rb')
  # @example
  #   Octokit.collabs('octokit/octokit.rb')
  # @example
  #   @client.collabs('octokit/octokit.rb')
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] Array of hashes representing collaborating users.
  # @see https://developer.github.com/v3/repos/collaborators/#list-collaborators
  def collabs(repo, options = T.unsafe(nil)); end

  # List contributors to a repo
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.contributors('octokit/octokit.rb', true)
  # @example
  #   Octokit.contribs('octokit/octokit.rb')
  # @example
  #   @client.contribs('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param anon [Boolean] Set true to include anonymous contributors.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/repos/#list-contributors
  def contribs(repo, anon = T.unsafe(nil), options = T.unsafe(nil)); end

  # List contributors to a repo
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.contributors('octokit/octokit.rb', true)
  # @example
  #   Octokit.contribs('octokit/octokit.rb')
  # @example
  #   @client.contribs('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param anon [Boolean] Set true to include anonymous contributors.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/repos/#list-contributors
  def contributors(repo, anon = T.unsafe(nil), options = T.unsafe(nil)); end

  # Create a repository for a user or organization
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [String] Name of the new repo
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Repository info for the new repository
  # @see https://developer.github.com/v3/repos/#create
  def create(name, options = T.unsafe(nil)); end

  # Create a repository for a user or organization
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [String] Name of the new repo
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Repository info for the new repository
  # @see https://developer.github.com/v3/repos/#create
  def create_repo(name, options = T.unsafe(nil)); end

  # Create a repository for a user or organization generated from a template repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub template repository
  # @param name [String] Name of the new repo
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Repository info for the new repository
  def create_repo_from_template(repo, name, options = T.unsafe(nil)); end

  # Create a repository for a user or organization
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param name [String] Name of the new repo
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Repository info for the new repository
  # @see https://developer.github.com/v3/repos/#create
  def create_repository(name, options = T.unsafe(nil)); end

  # Create a repository for a user or organization generated from a template repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub template repository
  # @param name [String] Name of the new repo
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Repository info for the new repository
  def create_repository_from_template(repo, name, options = T.unsafe(nil)); end

  # Delete repository
  #
  # Note: If OAuth is used, 'delete_repo' scope is required
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if repository was deleted
  # @see https://developer.github.com/v3/repos/#delete-a-repository
  def delete_repo(repo, options = T.unsafe(nil)); end

  # Delete repository
  #
  # Note: If OAuth is used, 'delete_repo' scope is required
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if repository was deleted
  # @see https://developer.github.com/v3/repos/#delete-a-repository
  def delete_repository(repo, options = T.unsafe(nil)); end

  # Delete a repository subscription
  #
  # @example
  #   @client.delete_subscription("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Boolean] True if subscription deleted, false otherwise.
  # @see https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription
  def delete_subscription(repo, options = T.unsafe(nil)); end

  # Get a single deploy key for a repo
  #
  # @example
  #   @client.deploy_key('octokit/octokit.rb', 8675309)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Deploy key ID.
  # @return [Sawyer::Resource] Deploy key.
  # @see https://developer.github.com/v3/repos/keys/#get-a-deploy-key
  def deploy_key(repo, id, options = T.unsafe(nil)); end

  # Get deploy keys on a repo
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.deploy_keys('octokit/octokit.rb')
  # @example
  #   @client.list_deploy_keys('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Array<Sawyer::Resource>] Array of hashes representing deploy keys.
  # @see https://developer.github.com/v3/repos/keys/#list-deploy-keys
  def deploy_keys(repo, options = T.unsafe(nil)); end

  # Disable vulnerability alerts for a repository
  #
  # @example Disable vulnerability alerts for a repository
  #   @client.disable_vulnerability_alerts("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash]
  # @return [Boolean] True if vulnerability alerts disabled, false otherwise.
  # @see https://docs.github.com/en/rest/reference/repos#disable-vulnerability-alerts
  def disable_vulnerability_alerts(repo, options = T.unsafe(nil)); end

  # Create a repository dispatch event
  #
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param event_type [String] A custom webhook event name.
  # @param options [Hash] a customizable set of options
  # @return [Boolean] True if event was dispatched, false otherwise.
  # @see https://developer.github.com/v3/repos/#create-a-repository-dispatch-event
  def dispatch_event(repo, event_type, options = T.unsafe(nil)); end

  # Edit a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository
  # @param options [Hash] Repository information to update
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#update-a-repository
  def edit(repo, options = T.unsafe(nil)); end

  # Edit a deploy key
  #
  # @deprecated This method is no longer supported in the API
  # @example Update the key for a deploy key.
  #   @client.edit_deploy_key('octokit/octokit.rb', 8675309, :key => 'ssh-rsa BBB...')
  # @example
  #   @client.update_deploy_key('octokit/octokit.rb', 8675309, :title => 'Uber', :key => 'ssh-rsa BBB...'))
  # @option title
  # @option key
  # @param id [Integer] Deploy key ID.
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] Attributes to edit.
  # @param title [Hash] a customizable set of options
  # @param key [Hash] a customizable set of options
  # @return [Sawyer::Resource] Updated deploy key.
  # @see https://developer.github.com/changes/2014-02-24-finer-grained-scopes-for-ssh-keys/
  # @see https://developer.github.com/v3/repos/keys/#edit-a-deploy-key
  def edit_deploy_key(repo, id, options); end

  # Edit a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository
  # @param options [Hash] Repository information to update
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#update-a-repository
  def edit_repository(repo, options = T.unsafe(nil)); end

  # Enable vulnerability alerts for a repository
  #
  # @example Enable vulnerability alerts for a repository
  #   @client.enable_vulnerability_alerts("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash]
  # @return [Boolean] True if vulnerability alerts enabled, false otherwise.
  # @see https://docs.github.com/en/rest/reference/repos#enable-vulnerability-alerts
  def enable_vulnerability_alerts(repo, options = T.unsafe(nil)); end

  # Fork a repository
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Repository info for the new fork
  # @see https://developer.github.com/v3/repos/forks/#create-a-fork
  def fork(repo, options = T.unsafe(nil)); end

  # List forks
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.forks('octokit/octokit.rb')
  # @example
  #   Octokit.network('octokit/octokit.rb')
  # @example
  #   @client.forks('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing repos.
  # @see https://developer.github.com/v3/repos/forks/#list-forks
  def forks(repo, options = T.unsafe(nil)); end

  # Get a single branch from a repository
  #
  # @example Get branch 'master` from octokit/octokit.rb
  #   Octokit.branch("octokit/octokit.rb", "master")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param branch [String] Branch name
  # @return [Sawyer::Resource] The branch requested, if it exists
  # @see https://developer.github.com/v3/repos/#get-branch
  def get_branch(repo, branch, options = T.unsafe(nil)); end

  # List languages of code in the repo.
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.languages('octokit/octokit.rb')
  # @example
  #   @client.languages('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of Hashes representing languages.
  # @see https://developer.github.com/v3/repos/#list-languages
  def languages(repo, options = T.unsafe(nil)); end

  # Get deploy keys on a repo
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.deploy_keys('octokit/octokit.rb')
  # @example
  #   @client.list_deploy_keys('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Array<Sawyer::Resource>] Array of hashes representing deploy keys.
  # @see https://developer.github.com/v3/repos/keys/#list-deploy-keys
  def list_deploy_keys(repo, options = T.unsafe(nil)); end

  # List user repositories
  #
  # If user is not supplied, repositories for the current
  #   authenticated user are returned.
  #
  # @note If the user provided is a GitHub organization, only the
  #   organization's public repositories will be listed. For retrieving
  #   organization repositories the {Organizations#organization_repositories}
  #   method should be used instead.
  # @param user [Integer, String] Optional GitHub user login or id for which
  #   to list repos.
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-your-repositories
  # @see https://developer.github.com/v3/repos/#list-user-repositories
  def list_repos(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List user repositories
  #
  # If user is not supplied, repositories for the current
  #   authenticated user are returned.
  #
  # @note If the user provided is a GitHub organization, only the
  #   organization's public repositories will be listed. For retrieving
  #   organization repositories the {Organizations#organization_repositories}
  #   method should be used instead.
  # @param user [Integer, String] Optional GitHub user login or id for which
  #   to list repos.
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-your-repositories
  # @see https://developer.github.com/v3/repos/#list-user-repositories
  def list_repositories(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List forks
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.forks('octokit/octokit.rb')
  # @example
  #   Octokit.network('octokit/octokit.rb')
  # @example
  #   @client.forks('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing repos.
  # @see https://developer.github.com/v3/repos/forks/#list-forks
  def network(repo, options = T.unsafe(nil)); end

  # Get a user's permission level for a repo.
  #
  # Requires authenticated client
  #
  # @example
  #   @client.permission_level('octokit/octokit.rb', 'lizzhale')
  # @return [Sawyer::Resource] Hash representing the user's permission level for the given repository
  # @see https://developer.github.com/v3/repos/collaborators/#review-a-users-permission-level
  def permission_level(repo, collaborator, options = T.unsafe(nil)); end

  # Lock a single branch from a repository
  #
  # Requires authenticated client
  #
  # @example
  #   @client.protect_branch('octokit/octokit.rb', 'master', foo)
  # @option options
  # @option options
  # @param branch [String] Branch name
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] The protected branch
  # @see https://developer.github.com/v3/repos/#enabling-and-disabling-branch-protection
  def protect_branch(repo, branch, options = T.unsafe(nil)); end

  # Remove collaborator from repo.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_collaborator('octokit/octokit.rb', 'holman')
  # @example
  #   @client.remove_collab('octokit/octokit.rb', 'holman')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param collaborator [String] Collaborator GitHub username to remove.
  # @return [Boolean] True if collaborator removed, false otherwise.
  # @see https://developer.github.com/v3/repos/collaborators/#remove-user-as-a-collaborator
  def remove_collab(repo, collaborator, options = T.unsafe(nil)); end

  # Remove collaborator from repo.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_collaborator('octokit/octokit.rb', 'holman')
  # @example
  #   @client.remove_collab('octokit/octokit.rb', 'holman')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param collaborator [String] Collaborator GitHub username to remove.
  # @return [Boolean] True if collaborator removed, false otherwise.
  # @see https://developer.github.com/v3/repos/collaborators/#remove-user-as-a-collaborator
  def remove_collaborator(repo, collaborator, options = T.unsafe(nil)); end

  # Remove deploy key from a repo
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_deploy_key('octokit/octokit.rb', 100000)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param id [Integer] Id of the deploy key to remove.
  # @return [Boolean] True if key removed, false otherwise.
  # @see https://developer.github.com/v3/repos/keys/#remove-a-deploy-key
  def remove_deploy_key(repo, id, options = T.unsafe(nil)); end

  # Rename a single branch from a repository
  #
  # Requires authenticated client
  #
  # @example
  #   @client.rename_branch('octokit/octokit.rb', 'master', 'main')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param branch [String] Current branch name
  # @param new_name [String] New branch name
  # @return [Sawyer::Resource] The renamed branch
  # @see https://developer.github.com/v3/repos/#rename-a-branch
  def rename_branch(repo, branch, new_name, options = T.unsafe(nil)); end

  # Replace all topics for a repository
  #
  # Requires authenticated client.
  #
  # @example Replace topics for octokit/octokit.rb
  #   client.replace_all_topics('octokit/octokit.rb', ['octocat', 'atom', 'electron', 'API'])
  # @example Clear all topics for octokit/octokit.rb
  #   client.replace_all_topics('octokit/octokit.rb', [])
  # @param repo [Integer, String, Repository, Hash] A Github repository
  # @param names [Array] An array of topics to add to the repository.
  # @return [Sawyer::Resource] representing the replaced topics for given repo
  # @see https://developer.github.com/v3/repos/#replace-all-topics-for-a-repository
  def replace_all_topics(repo, names, options = T.unsafe(nil)); end

  # Get a single repository
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#get
  # @see https://developer.github.com/v3/licenses/#get-a-repositorys-license
  def repo(repo, options = T.unsafe(nil)); end

  # List users available for assigning to issues.
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.repository_assignees('octokit/octokit.rb')
  # @example
  #   Octokit.repo_assignees('octokit/octokit.rb')
  # @example
  #   @client.repository_assignees('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/issues/assignees/#list-assignees
  def repo_assignees(repo, options = T.unsafe(nil)); end

  # List teams for a repo
  #
  # Requires authenticated client that is an owner or collaborator of the repo.
  #
  # @example
  #   @client.repository_teams('octokit/pengwynn')
  # @example
  #   @client.repo_teams('octokit/pengwynn')
  # @example
  #   @client.teams('octokit/pengwynn')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing teams.
  # @see https://developer.github.com/v3/repos/#list-teams
  def repo_teams(repo, options = T.unsafe(nil)); end

  # List user repositories
  #
  # If user is not supplied, repositories for the current
  #   authenticated user are returned.
  #
  # @note If the user provided is a GitHub organization, only the
  #   organization's public repositories will be listed. For retrieving
  #   organization repositories the {Organizations#organization_repositories}
  #   method should be used instead.
  # @param user [Integer, String] Optional GitHub user login or id for which
  #   to list repos.
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-your-repositories
  # @see https://developer.github.com/v3/repos/#list-user-repositories
  def repos(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # List user repositories
  #
  # If user is not supplied, repositories for the current
  #   authenticated user are returned.
  #
  # @note If the user provided is a GitHub organization, only the
  #   organization's public repositories will be listed. For retrieving
  #   organization repositories the {Organizations#organization_repositories}
  #   method should be used instead.
  # @param user [Integer, String] Optional GitHub user login or id for which
  #   to list repos.
  # @return [Array<Sawyer::Resource>] List of repositories
  # @see https://developer.github.com/v3/repos/#list-your-repositories
  # @see https://developer.github.com/v3/repos/#list-user-repositories
  def repositories(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get a single repository
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#get
  # @see https://developer.github.com/v3/licenses/#get-a-repositorys-license
  def repository(repo, options = T.unsafe(nil)); end

  # Check if a repository exists
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Boolean]
  # @see https://developer.github.com/v3/repos/#get
  def repository?(repo, options = T.unsafe(nil)); end

  # List users available for assigning to issues.
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.repository_assignees('octokit/octokit.rb')
  # @example
  #   Octokit.repo_assignees('octokit/octokit.rb')
  # @example
  #   @client.repository_assignees('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/issues/assignees/#list-assignees
  def repository_assignees(repo, options = T.unsafe(nil)); end

  # List teams for a repo
  #
  # Requires authenticated client that is an owner or collaborator of the repo.
  #
  # @example
  #   @client.repository_teams('octokit/pengwynn')
  # @example
  #   @client.repo_teams('octokit/pengwynn')
  # @example
  #   @client.teams('octokit/pengwynn')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing teams.
  # @see https://developer.github.com/v3/repos/#list-teams
  def repository_teams(repo, options = T.unsafe(nil)); end

  # Hide a public repository
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Updated repository info
  def set_private(repo, options = T.unsafe(nil)); end

  # Unhide a private repository
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Updated repository info
  def set_public(repo, options = T.unsafe(nil)); end

  # Star a repository
  #
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if successfully starred
  # @see https://developer.github.com/v3/activity/starring/#star-a-repository
  def star(repo, options = T.unsafe(nil)); end

  # List stargazers of a repo
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.stargazers('octokit/octokit.rb')
  # @example
  #   @client.stargazers('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/activity/starring/#list-stargazers
  def stargazers(repo, options = T.unsafe(nil)); end

  # List watchers subscribing to notifications for a repo
  #
  # @example
  #   @client.subscribers("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of users watching.
  # @see https://developer.github.com/v3/activity/watching/#list-watchers
  def subscribers(repo, options = T.unsafe(nil)); end

  # Get a repository subscription
  #
  # @example
  #   @client.subscription("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Sawyer::Resource] Repository subscription.
  # @see https://developer.github.com/v3/activity/watching/#get-a-repository-subscription
  def subscription(repo, options = T.unsafe(nil)); end

  # List tags
  #
  # Requires authenticated client for private repos.
  #
  # @example
  #   Octokit.tags('octokit/octokit.rb')
  # @example
  #   @client.tags('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing tags.
  # @see https://developer.github.com/v3/repos/#list-tags
  def tags(repo, options = T.unsafe(nil)); end

  # List teams for a repo
  #
  # Requires authenticated client that is an owner or collaborator of the repo.
  #
  # @example
  #   @client.repository_teams('octokit/pengwynn')
  # @example
  #   @client.repo_teams('octokit/pengwynn')
  # @example
  #   @client.teams('octokit/pengwynn')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing teams.
  # @see https://developer.github.com/v3/repos/#list-teams
  def teams(repo, options = T.unsafe(nil)); end

  # List all topics for a repository
  #
  # Requires authenticated client for private repos.
  #
  # @example List topics for octokit/octokit.rb
  #   Octokit.topics('octokit/octokit.rb')
  # @example List topics for octokit/octokit.rb
  #   client.topics('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Sawyer::Resource] representing the topics for given repo
  # @see https://developer.github.com/v3/repos/#list-all-topics-for-a-repository
  def topics(repo, options = T.unsafe(nil)); end

  # Transfer repository
  #
  # Transfer a repository owned by your organization
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param new_owner [String] The username or organization name the repository will be transferred to.
  # @param options [Array<Integer>] :team_ids ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
  # @return [Sawyer::Resource] Repository info for the transferred repository
  # @see https://developer.github.com/v3/repos/#transfer-a-repository
  def transfer_repo(repo, new_owner, options = T.unsafe(nil)); end

  # Transfer repository
  #
  # Transfer a repository owned by your organization
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param new_owner [String] The username or organization name the repository will be transferred to.
  # @param options [Array<Integer>] :team_ids ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
  # @return [Sawyer::Resource] Repository info for the transferred repository
  # @see https://developer.github.com/v3/repos/#transfer-a-repository
  def transfer_repository(repo, new_owner, options = T.unsafe(nil)); end

  # Unlock a single branch from a repository
  #
  # Requires authenticated client
  #
  # @example
  #   @client.unprotect_branch('octokit/octokit.rb', 'master')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param branch [String] Branch name
  # @return [Sawyer::Resource] The unprotected branch
  # @see https://developer.github.com/v3/repos/#enabling-and-disabling-branch-protection
  def unprotect_branch(repo, branch, options = T.unsafe(nil)); end

  # Unstar a repository
  #
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if successfully unstarred
  # @see https://developer.github.com/v3/activity/starring/#unstar-a-repository
  def unstar(repo, options = T.unsafe(nil)); end

  # Unwatch a repository
  #
  # @deprecated Use #unstar instead
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if successfully unwatched
  # @see https://developer.github.com/v3/activity/watching/#stop-watching-a-repository-legacy
  def unwatch(repo, options = T.unsafe(nil)); end

  # Edit a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository
  # @param options [Hash] Repository information to update
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#update-a-repository
  def update(repo, options = T.unsafe(nil)); end

  # Edit a deploy key
  #
  # @deprecated This method is no longer supported in the API
  # @example Update the key for a deploy key.
  #   @client.edit_deploy_key('octokit/octokit.rb', 8675309, :key => 'ssh-rsa BBB...')
  # @example
  #   @client.update_deploy_key('octokit/octokit.rb', 8675309, :title => 'Uber', :key => 'ssh-rsa BBB...'))
  # @option title
  # @option key
  # @param id [Integer] Deploy key ID.
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] Attributes to edit.
  # @param title [Hash] a customizable set of options
  # @param key [Hash] a customizable set of options
  # @return [Sawyer::Resource] Updated deploy key.
  # @see https://developer.github.com/changes/2014-02-24-finer-grained-scopes-for-ssh-keys/
  # @see https://developer.github.com/v3/repos/keys/#edit-a-deploy-key
  def update_deploy_key(repo, id, options); end

  # Edit a repository
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param repo [String, Hash, Repository] A GitHub repository
  # @param options [Hash] Repository information to update
  # @return [Sawyer::Resource] Repository information
  # @see https://developer.github.com/v3/repos/#update-a-repository
  def update_repository(repo, options = T.unsafe(nil)); end

  # Update repository subscription
  #
  # @example Subscribe to notifications for a repository
  #   @client.update_subscription("octokit/octokit.rb", {subscribed: true})
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash]
  # @return [Sawyer::Resource] Updated repository subscription.
  # @see https://developer.github.com/v3/activity/watching/#set-a-repository-subscription
  def update_subscription(repo, options = T.unsafe(nil)); end

  # Check to see if vulnerability alerts are enabled for a repository
  #
  # The authenticated user must have admin access to the repository.
  #
  # @example
  #   @client.vulnerability_alerts_enabled?("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Boolean] True if vulnerability alerts are enabled, false otherwise.
  # @see https://docs.github.com/en/rest/reference/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository
  def vulnerability_alerts_enabled?(repo, options = T.unsafe(nil)); end

  # Watch a repository
  #
  # @deprecated Use #star instead
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Boolean] `true` if successfully watched
  # @see https://developer.github.com/v3/activity/watching/#watch-a-repository-legacy
  def watch(repo, options = T.unsafe(nil)); end

  # List watchers of repo.
  #
  # Requires authenticated client for private repos.
  #
  # @deprecated Use {#stargazers} instead
  # @example
  #   Octokit.watchers('octokit/octokit.rb')
  # @example
  #   @client.watchers('octokit/octokit.rb')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users.
  # @see https://developer.github.com/v3/repos/watching/#list-watchers
  def watchers(repo, options = T.unsafe(nil)); end
end

# Methods for the Repository Invitations API
#
# @see https://developer.github.com/v3/repos/invitations/
module Octokit::Client::RepositoryInvitations
  # Accept a repository invitation
  #
  # Requires authenticated client
  #
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the acceptance of the invitation was successful
  # @see https://developer.github.com/v3/repos/invitations/#accept-a-repository-invitation
  def accept_repo_invitation(invitation_id, options = T.unsafe(nil)); end

  # Accept a repository invitation
  #
  # Requires authenticated client
  #
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the acceptance of the invitation was successful
  # @see https://developer.github.com/v3/repos/invitations/#accept-a-repository-invitation
  def accept_repository_invitation(invitation_id, options = T.unsafe(nil)); end

  # Decline a repository invitation
  #
  # Requires authenticated client
  #
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the acceptance of the invitation was successful
  # @see https://developer.github.com/v3/repos/invitations/#decline-a-repository-invitation
  def decline_invitation(invitation_id, options = T.unsafe(nil)); end

  # Decline a repository invitation
  #
  # Requires authenticated client
  #
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the acceptance of the invitation was successful
  # @see https://developer.github.com/v3/repos/invitations/#decline-a-repository-invitation
  def decline_repository_invitation(invitation_id, options = T.unsafe(nil)); end

  # Delete an invitation for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the invitation was successfully deleted
  # @see https://developer.github.com/v3/repos/invitations/#delete-a-repository-invitation
  def delete_repo_invitation(repo, invitation_id, options = T.unsafe(nil)); end

  # Delete an invitation for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param invitation_id [Integer] The id of the invitation
  # @return [Boolean] True if the invitation was successfully deleted
  # @see https://developer.github.com/v3/repos/invitations/#delete-a-repository-invitation
  def delete_repository_invitation(repo, invitation_id, options = T.unsafe(nil)); end

  # Invite a user to a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param user [String] User GitHub username to add
  # @return [Sawyer::Resource] The repository invitation
  # @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
  def invite_user_to_repo(repo, user, options = T.unsafe(nil)); end

  # Invite a user to a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param user [String] User GitHub username to add
  # @return [Sawyer::Resource] The repository invitation
  # @see https://developer.github.com/v3/repos/collaborators/#add-user-as-a-collaborator
  def invite_user_to_repository(repo, user, options = T.unsafe(nil)); end

  # List all invitations for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of invitations
  # @see https://developer.github.com/v3/repos/invitations/#list-invitations-for-a-repository
  def repo_invitations(repo, options = T.unsafe(nil)); end

  # List all invitations for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] A list of invitations
  # @see https://developer.github.com/v3/repos/invitations/#list-invitations-for-a-repository
  def repository_invitations(repo, options = T.unsafe(nil)); end

  # Update an invitation for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param invitation_id [Integer] The id of the invitation
  # @return [Sawyer::Resource] The updated repository invitation
  # @see https://developer.github.com/v3/repos/invitations/#update-a-repository-invitation
  def update_repo_invitation(repo, invitation_id, options = T.unsafe(nil)); end

  # Update an invitation for a repository
  #
  # Requires authenticated client
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param invitation_id [Integer] The id of the invitation
  # @return [Sawyer::Resource] The updated repository invitation
  # @see https://developer.github.com/v3/repos/invitations/#update-a-repository-invitation
  def update_repository_invitation(repo, invitation_id, options = T.unsafe(nil)); end

  # List all repository invitations for the user
  #
  # Requires authenticated client
  #
  # @return [Array<Sawyer::Resource>] The users repository invitations
  # @see https://developer.github.com/v3/repos/invitations/#list-a-users-repository-invitations
  def user_repo_invitations(options = T.unsafe(nil)); end

  # List all repository invitations for the user
  #
  # Requires authenticated client
  #
  # @return [Array<Sawyer::Resource>] The users repository invitations
  # @see https://developer.github.com/v3/repos/invitations/#list-a-users-repository-invitations
  def user_repository_invitations(options = T.unsafe(nil)); end
end

# Methods for the Reviews API
#
# @see https://developer.github.com/v3/pulls/reviews/
module Octokit::Client::Reviews
  # Create a pull request review
  #
  # @example
  #   comments = [
  #   { path: '.travis.yml', position: 10, body: 'ruby-head is under development that is not stable.' },
  #   { path: '.travis.yml', position: 32, body: 'ruby-head is also required in thervm section.' },
  #   ]
  #   options = { event: 'REQUEST_CHANGES', comments: comments }
  #   @client.create_pull_request_review('octokit/octokit.rb', 844, options)
  # @option options
  # @option options
  # @option options
  # @option comments
  # @option comments
  # @option comments
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param options [Hash] Method options
  # @param comments [Hash] a customizable set of options
  # @return [Sawyer::Resource] ] Hash respresenting the review
  # @see https://developer.github.com/v3/pulls/reviews/#create-a-pull-request-review
  def create_pull_request_review(repo, number, options = T.unsafe(nil)); end

  # Delete a pending review
  #
  # @example
  #   @client.delete_pull_request_review('octokit/octokit.rb', 825, 6505518)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param review [Integer] The id of the review
  # @return [Sawyer::Resource] Hash representing the deleted review
  # @see https://developer.github.com/v3/pulls/reviews/#delete-a-pending-review
  def delete_pull_request_review(repo, number, review, options = T.unsafe(nil)); end

  # Delete a review request
  #
  # @example
  #   options = {
  #   "reviewers" => [ "octocat", "hubot", "other_user" ],
  #   "team_reviewers" => [ "justice-league" ]
  #   }
  #   @client.delete_pull_request_review_request('octokit/octokit.rb', 2, options)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param id [Integer] The id of the pull request
  # @param reviewers [Hash] :reviewers [Array] An array of user logins
  # @param options [Hash] :team_reviewers [Array] An array of team slugs
  # @return [Sawyer::Resource] ] Hash representing the pull request
  # @see https://developer.github.com/v3/pulls/review_requests/#delete-a-review-request
  def delete_pull_request_review_request(repo, id, reviewers = T.unsafe(nil), options = T.unsafe(nil)); end

  # Dismiss a pull request review
  #
  # @example
  #   @client.dismiss_pull_request_review('octokit/octokit.rb', 825, 6505518, 'The message.')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param review [Integer] The id of the review
  # @param message [String] The message for the pull request review dismissal
  # @return [Sawyer::Resource] Hash representing the dismissed review
  # @see https://developer.github.com/v3/pulls/reviews/#dismiss-a-pull-request-review
  def dismiss_pull_request_review(repo, number, review, message, options = T.unsafe(nil)); end

  # Get a single review
  #
  # @example
  #   @client.pull_request_review('octokit/octokit.rb', 825, 6505518)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param review [Integer] The id of the review
  # @return [Sawyer::Resource] Hash representing the review
  # @see https://developer.github.com/v3/pulls/reviews/#get-a-single-review
  def pull_request_review(repo, number, review, options = T.unsafe(nil)); end

  # Get comments for a single review
  #
  # @example
  #   @client.pull_request_review_comments('octokit/octokit.rb', 825, 6505518)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param review [Integer] The id of the review
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the review comments
  # @see https://developer.github.com/v3/pulls/reviews/#get-comments-for-a-single-review
  def pull_request_review_comments(repo, number, review, options = T.unsafe(nil)); end

  # List review requests
  #
  # @example
  #   @client.pull_request_review_requests('octokit/octokit.rb', 2)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the review requests
  # @see https://developer.github.com/v3/pulls/review_requests/#list-review-requests
  def pull_request_review_requests(repo, number, options = T.unsafe(nil)); end

  # List reviews on a pull request
  #
  # @example
  #   @client.pull_request_reviews('octokit/octokit.rb', 2)
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @return [Array<Sawyer::Resource>] Array of Hashes representing the reviews
  # @see https://developer.github.com/v3/pulls/reviews/#list-reviews-on-a-pull-request
  def pull_request_reviews(repo, number, options = T.unsafe(nil)); end

  # Create a review request
  #
  # @example
  #   @client.request_pull_request_review('octokit/octokit.rb', 2, reviewers: ['soudy'])
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param reviewers [Hash] :reviewers [Array<String>] An array of user logins
  # @param options [Hash] :team_reviewers [Array<String>] An array of team slugs
  # @return [Sawyer::Resource] ] Hash respresenting the pull request
  # @see https://developer.github.com/v3/pulls/review_requests/#create-a-review-request
  def request_pull_request_review(repo, number, reviewers = T.unsafe(nil), options = T.unsafe(nil)); end

  # Submit a pull request review
  #
  # @example
  #   @client.submit_pull_request_review('octokit/octokit.rb', 825, 6505518,
  #   'APPROVE', body: 'LGTM!')
  # @option options
  # @param number [Integer] Number ID of the pull request
  # @param event [String] The review action (event) to perform; can be one of
  #   APPROVE, REQUEST_CHANGES, or COMMENT.
  # @param options [Hash] Method options
  # @param review [Integer] The id of the review
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @return [Sawyer::Resource] Hash respresenting the review
  # @see https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review
  def submit_pull_request_review(repo, number, review, event, options = T.unsafe(nil)); end

  # Update a review request comment
  #
  # @example
  #   @client.update_pull_request_review('octokit/octokit.rb', 825, 6505518, 'This is close to perfect! Please address the suggested inline change. And add more about this.')
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param number [Integer] Number ID of the pull request
  # @param review [Integer] The id of the review
  # @param options [Hash] Method options
  # @param body [String] body text of the pull request review.
  # @return [Sawyer::Resource] Hash representing the review comment
  # @see https://developer.github.com/v3/pulls/reviews/#update-a-pull-request-review
  def update_pull_request_review(repo, number, review, body, options = T.unsafe(nil)); end
end

# Methods for the unpublished Octocat API
module Octokit::Client::Say
  # Return a nifty ASCII Octocat with GitHub wisdom
  # or your own
  #
  # @return [String]
  def octocat(text = T.unsafe(nil), options = T.unsafe(nil)); end

  # Return a nifty ASCII Octocat with GitHub wisdom
  # or your own
  #
  # @return [String]
  def say(text = T.unsafe(nil), options = T.unsafe(nil)); end
end

# Methods for the Search API
#
# @see https://developer.github.com/v3/search/
module Octokit::Client::Search
  # Search code
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search term and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-code
  def search_code(query, options = T.unsafe(nil)); end

  # Search commits
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search terms and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-commits
  def search_commits(query, options = T.unsafe(nil)); end

  # Search issues
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search term and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-issues-and-pull-requests
  def search_issues(query, options = T.unsafe(nil)); end

  # Search repositories
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search term and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-repositories
  def search_repos(query, options = T.unsafe(nil)); end

  # Search repositories
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search term and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-repositories
  def search_repositories(query, options = T.unsafe(nil)); end

  # Search users
  #
  # @option options
  # @option options
  # @option options
  # @option options
  # @param query [String] Search term and qualifiers
  # @param options [Hash] Sort and pagination options
  # @return [Sawyer::Resource] Search results object
  # @see https://developer.github.com/v3/search/#search-users
  def search_users(query, options = T.unsafe(nil)); end

  private

  def search(path, query, options = T.unsafe(nil)); end
end

# Methods for the GitHub Status API
#
# @see https://status.github.com/api
module Octokit::Client::ServiceStatus
  # Returns the current system status
  #
  # @return [Sawyer::Resource] GitHub status
  # @see https://www.githubstatus.com/api#status
  def github_status; end

  # Returns the last human communication, status, and timestamp.
  #
  # @return [Sawyer::Resource] GitHub status last message
  # @see https://www.githubstatus.com/api/#components
  def github_status_last_message; end

  # Returns the most recent human communications with status and timestamp.
  #
  # @return [Array<Sawyer::Resource>] GitHub status messages
  # @see https://www.githubstatus.com/api#components
  def github_status_messages; end

  # Returns a summary with the current status and the last status messages.
  #
  # @return [<Sawyer::Resource>] GitHub status summary
  # @see https://www.githubstatus.com/api#summory
  def github_status_summary; end
end

Octokit::Client::ServiceStatus::COMPONENTS_ROOT = T.let(T.unsafe(nil), String)
Octokit::Client::ServiceStatus::STATUS_ROOT = T.let(T.unsafe(nil), String)

# Root for status API
#
# @private
Octokit::Client::ServiceStatus::SUMMARY_ROOT = T.let(T.unsafe(nil), String)

# Methods for the Source Import API
#
# @see https://developer.github.com/v3/migration/source_imports
module Octokit::Client::SourceImport
  # Stop an import for a repository.
  #
  # @example
  #   @client.cancel_source_import("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Boolean] True if the import has been cancelled, false otherwise.
  # @see https://developer.github.com/v3/migration/source_imports/#cancel-an-import
  def cancel_source_import(repo, options = T.unsafe(nil)); end

  # Update an author's identity for the import.
  #
  # @example
  #   author_url = "https://api.github.com/repos/octokit/octokit.rb/import/authors/1"
  #   @client.map_source_import_commit_author(author_url, {
  #   :email => "hubot@github.com",
  #   :name => "Hubot the Robot"
  #   })
  # @option values
  # @option values
  # @param author_url [String] The source import API url for the commit author
  # @param values [Hash] The updated author attributes
  # @return [Sawyer::Resource] Hash representing the updated commit author
  # @see https://developer.github.com/v3/migration/source_imports/#map-a-commit-author
  def map_source_import_commit_author(author_url, values, options = T.unsafe(nil)); end

  # Set preference for using Git LFS to import files over 100MB
  #
  # @example
  #   @client.opt_in_source_import_lfs("octokit/octokit.rb", "opt_in")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param use_lfs [String] Preference for using Git LFS to import large files. Can be one of "opt_in" or "opt_out"
  # @return [Sawyer::Resource] Hash representing the repository import
  # @see https://developer.github.com/v3/migration/source_imports/#set-git-lfs-preference
  def set_source_import_lfs_preference(repo, use_lfs, options = T.unsafe(nil)); end

  # List source import commit authors
  #
  # @example
  #   @client.source_import_commit_authors("octokit/octokit.rb")
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash]
  # @return [Array<Sawyer::Resource>] Array of hashes representing commit_authors.
  # @see https://developer.github.com/v3/migration/source_imports/#get-commit-authors
  def source_import_commit_authors(repo, options = T.unsafe(nil)); end

  # List source import large files
  #
  # @example
  #   @client.source_import_large_files("octokit/octokit.rb")
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash]
  # @return [Array<Sawyer::Resource>] Array of hashes representing files over 100MB.
  # @see https://developer.github.com/v3/migration/source_imports/#get-large-files
  def source_import_large_files(repo, options = T.unsafe(nil)); end

  # View the progress of an import.
  #
  # @example
  #   @client.source_import_progress("octokit/octokit.rb")
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @return [Sawyer::Resource] Hash representing the progress of the import
  # @see https://developer.github.com/v3/migration/source_imports/#get-import-progress
  def source_import_progress(repo, options = T.unsafe(nil)); end

  # Start a source import to a GitHub repository using GitHub Importer.
  #
  # @example
  #   @client.start_source_import("octokit/octokit.rb", "http://svn.mycompany.com/svn/myproject", {
  #   :vcs           => "subversion",
  #   :vcs_username" => "octocat",
  #   :vcs_password  => "secret"
  #   })
  # @overload start_source_import
  # @overload start_source_import
  # @return [Sawyer::Resource] Hash representing the repository import
  # @see https://developer.github.com/v3/migration/source_imports/#start-an-import
  def start_source_import(*args); end

  # Update source import with authentication or project choice
  # Restart source import if no options are passed
  #
  # https://developer.github.com/v3/migration/source_imports/#update-existing-import
  #
  # @example
  #   @client.update_source_import("octokit/octokit.rb", {
  #   :vcs_username" => "octocat",
  #   :vcs_password  => "secret"
  #   })
  # @option options
  # @option options
  # @option options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing the repository import
  # @see https://developer.github.com/v3/migration/source_imports/#update-existing-import
  def update_source_import(repo, options = T.unsafe(nil)); end
end

# Methods for the Repository Statistics API
#
# @see https://developer.github.com/v3/repos/statistics/
module Octokit::Client::Stats
  # Get the number of additions and deletions per week
  #
  # @example Get code frequency stats for octokit
  #   @client.code_frequency_stats('octokit/octokit.rb')
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] Weekly aggregate of the number of additions
  #   and deletions pushed to a repository.
  # @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-additions-and-deletions-per-week
  def code_frequency_stats(repo, options = T.unsafe(nil)); end

  # Get the last year of commit activity data
  #
  # @example Get commit activity for octokit
  #   @client.commit_activity_stats('octokit/octokit.rb')
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] The last year of commit activity grouped by
  #   week. The days array is a group of commits per day, starting on Sunday.
  # @see https://developer.github.com/v3/repos/statistics/#get-the-last-year-of-commit-activity-data
  def commit_activity_stats(repo, options = T.unsafe(nil)); end

  # Get contributors list with additions, deletions, and commit counts
  #
  # @example Get contributor stats for octokit
  #   @client.contributors_stats('octokit/octokit.rb')
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] Array of contributor stats
  # @see https://developer.github.com/v3/repos/statistics/#get-contributors-list-with-additions-deletions-and-commit-counts
  def contributor_stats(repo, options = T.unsafe(nil)); end

  # Get contributors list with additions, deletions, and commit counts
  #
  # @example Get contributor stats for octokit
  #   @client.contributors_stats('octokit/octokit.rb')
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Sawyer::Resource>] Array of contributor stats
  # @see https://developer.github.com/v3/repos/statistics/#get-contributors-list-with-additions-deletions-and-commit-counts
  def contributors_stats(repo, options = T.unsafe(nil)); end

  # Get the weekly commit count for the repo owner and everyone else
  #
  # @example Get weekly commit counts for octokit
  #   @client.participation_stats("octokit/octokit.rb")
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Sawyer::Resource] Total commit counts for the owner and total commit
  #   counts in all. all is everyone combined, including the owner in the last
  #   52 weeks. If you’d like to get the commit counts for non-owners, you can
  #   subtract all from owner.
  # @see https://developer.github.com/v3/repos/statistics/#get-the-weekly-commit-count-for-the-repository-owner-and-everyone-else
  def participation_stats(repo, options = T.unsafe(nil)); end

  # Get the number of commits per hour in each day
  #
  # @example Get octokit punch card
  #   @octokit.punch_card_stats
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Array>] Arrays containing the day number, hour number, and
  #   number of commits
  # @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-commits-per-hour-in-each-day
  def punch_card(repo, options = T.unsafe(nil)); end

  # Get the number of commits per hour in each day
  #
  # @example Get octokit punch card
  #   @octokit.punch_card_stats
  # @option retry_timeout
  # @option retry_wait
  # @param retry_timeout [Hash] a customizable set of options
  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param retry_wait [Hash] a customizable set of options
  # @return [Array<Array>] Arrays containing the day number, hour number, and
  #   number of commits
  # @see https://developer.github.com/v3/repos/statistics/#get-the-number-of-commits-per-hour-in-each-day
  def punch_card_stats(repo, options = T.unsafe(nil)); end

  private

  # @param repo [Integer, String, Hash, Repository] A GitHub repository
  # @param metric [String] The metrics you are looking for
  # @private Get stats for a repository
  # @return [Array<Sawyer::Resource> or nil] Stats in metric-specific format, or nil if not yet calculated.
  # @see https://developer.github.com/v3/repos/statistics/
  def get_stats(repo, metric, options = T.unsafe(nil)); end
end

# Methods for the Commit Statuses API
#
# @see https://developer.github.com/v3/repos/statuses/
module Octokit::Client::Statuses
  # Get the combined status for a ref
  #
  # @param repo [Integer, String, Repository, Hash] a GitHub repository
  # @param ref [String] A Sha or Ref to fetch the status of
  # @return [Sawyer::Resource] The combined status for the commit
  # @see https://developer.github.com/v3/repos/statuses/#get-the-combined-status-for-a-specific-ref
  def combined_status(repo, ref, options = T.unsafe(nil)); end

  # Create status for a commit
  #
  # @option options
  # @option options
  # @option options
  # @param options [Hash] a customizable set of options
  # @param sha [String] The SHA1 for the commit
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param state [String] The state: pending, success, failure, error
  # @return [Sawyer::Resource] A status
  # @see https://developer.github.com/v3/repos/statuses/#create-a-status
  def create_status(repo, sha, state, options = T.unsafe(nil)); end

  # List all statuses for a given commit
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param sha [String] The SHA1 for the commit
  # @return [Array<Sawyer::Resource>] A list of statuses
  # @see https://developer.github.com/v3/repos/statuses/#list-statuses-for-a-specific-ref
  def list_statuses(repo, sha, options = T.unsafe(nil)); end

  # Get the combined status for a ref
  #
  # @param repo [Integer, String, Repository, Hash] a GitHub repository
  # @param ref [String] A Sha or Ref to fetch the status of
  # @return [Sawyer::Resource] The combined status for the commit
  # @see https://developer.github.com/v3/repos/statuses/#get-the-combined-status-for-a-specific-ref
  def status(repo, ref, options = T.unsafe(nil)); end

  # List all statuses for a given commit
  #
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @param sha [String] The SHA1 for the commit
  # @return [Array<Sawyer::Resource>] A list of statuses
  # @see https://developer.github.com/v3/repos/statuses/#list-statuses-for-a-specific-ref
  def statuses(repo, sha, options = T.unsafe(nil)); end
end

# Methods for the Traffic API
#
# @see https://developer.github.com/v3/repos/traffic/
module Octokit::Client::Traffic
  # Get the total number of clones and breakdown per day or week for the
  # last 14 days
  #
  # @example Clones per day
  #   @client.clones('octokit/octokit.rb')
  # @example Clones per week
  #   @client.clones('octokit/octokit.rb', per: 'week')
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub Repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Breakdown of clone stats
  # @see https://developer.github.com/v3/repos/traffic/#clones
  def clones(repo, options = T.unsafe(nil)); end

  # Get the top 10 popular contents over the last 14 days
  #
  # @example
  #   @client.top_paths('octokit/octokit.rb')
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] List of popular contents
  # @see https://developer.github.com/v3/repos/traffic/#list-paths
  def top_paths(repo, options = T.unsafe(nil)); end

  # Get the top 10 referrers over the last 14 days
  #
  # @example
  #   @client.top_referrers('octokit/octokit.rb')
  # @param repo [Integer, String, Repository, Hash] A GitHub repository
  # @return [Array<Sawyer::Resource>] List of referrers and stats
  # @see https://developer.github.com/v3/repos/traffic/#list-referrers
  def top_referrers(repo, options = T.unsafe(nil)); end

  # Get the total number of views and breakdown per day or week for the
  # last 14 days
  #
  # @example Views per day
  #   @client.views('octokit/octokit.rb')
  # @example Views per week
  #   @client.views('octokit/octokit.rb', per: 'week')
  # @option options
  # @param repo [Integer, String, Repository, Hash] A GitHub Repository
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Breakdown of view stats
  # @see https://developer.github.com/v3/repos/traffic/#views
  def views(repo, options = T.unsafe(nil)); end
end

# Methods for the Users API
#
# @see https://developer.github.com/v3/users/
module Octokit::Client::Users
  # Add email address to user.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.add_email('new_email@user.com')
  # @param email [String] Email address to add to the user.
  # @return [Array<String>] Array of all email addresses of the user.
  # @see https://developer.github.com/v3/users/emails/#add-email-addresses
  def add_email(email, _options = T.unsafe(nil)); end

  # Add public key to user account.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.add_key('Personal projects key', 'ssh-rsa AAA...')
  # @param title [String] Title to give reference to the public key.
  # @param key [String] Public key.
  # @return [Sawyer::Resource] Hash representing the newly added public key.
  # @see https://developer.github.com/v3/users/keys/#create-a-public-key
  def add_key(title, key, options = T.unsafe(nil)); end

  # List all GitHub users
  #
  # This provides a list of every user, in the order that they signed up
  # for GitHub.
  #
  # @option options
  # @param options [Hash] Optional options.
  # @return [Array<Sawyer::Resource>] List of GitHub users.
  # @see https://developer.github.com/v3/users/#get-all-users
  def all_users(options = T.unsafe(nil)); end

  # Deletes a previous migration archive.
  #
  # Requires authenticated user.
  #
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#delete-a-user-migration-archive
  def delete_user_migration_archive(id, options = T.unsafe(nil)); end

  # List email addresses for a user.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.emails
  # @return [Array<String>] Array of email addresses.
  # @see https://developer.github.com/v3/users/emails/#list-email-addresses-for-a-user
  def emails(options = T.unsafe(nil)); end

  # Retrieve the access_token.
  #
  # @example
  #   Octokit.exchange_code_for_token('aaaa', 'xxxx', 'yyyy', {:accept => 'application/json'})
  # @param code [String] Authorization code generated by GitHub.
  # @param app_id [String] Client Id we received when our application was registered with GitHub. Defaults to client_id.
  # @param app_secret [String] Client Secret we received when our application was registered with GitHub. Defaults to client_secret.
  # @return [Sawyer::Resource] Hash holding the access token.
  # @see https://developer.github.com/v3/oauth/#web-application-flow
  def exchange_code_for_token(code, app_id = T.unsafe(nil), app_secret = T.unsafe(nil), options = T.unsafe(nil)); end

  # Follow a user.
  #
  # Requires authenticatied client.
  #
  # @example
  #   @client.follow('holman')
  # @param user [String] Username of the user to follow.
  # @return [Boolean] True if follow was successful, false otherwise.
  # @see https://developer.github.com/v3/users/followers/#follow-a-user
  def follow(user, options = T.unsafe(nil)); end

  # Get a user's followers.
  #
  # @example
  #   Octokit.followers('pengwynn')
  # @param user [Integer, String] GitHub user login or id of the user whose
  #   list of followers you are getting.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users
  #   followers.
  # @see https://developer.github.com/v3/users/followers/#list-followers-of-a-user
  def followers(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get list of users a user is following.
  #
  # @example
  #   Octokit.following('pengwynn')
  # @param user [Intger, String] GitHub user login or id of the user who you
  #   are getting the list of the people they follow.
  # @return [Array<Sawyer::Resource>] Array of hashes representing users a
  #   user is following.
  # @see https://developer.github.com/v3/users/followers/#list-users-followed-by-another-user
  def following(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Check if you are following a user. Alternatively, check if a given user
  # is following a target user.
  #
  # Requries an authenticated client.
  #
  # @example
  #   @client.follows?('pengwynn')
  # @example
  #   @client.follows?('catsby', 'pengwynn')
  # @overload follows?
  # @overload follows?
  # @return [Boolean] True following target user, false otherwise.
  # @see https://developer.github.com/v3/users/followers/#check-if-you-are-following-a-user
  # @see https://developer.github.com/v3/users/followers/#check-if-one-user-follows-another
  def follows?(*args); end

  # Get a public key.
  #
  # Note, when using dot notation to retrieve the values, ruby will return
  # the hash key for the public keys value instead of the actual value, use
  # symbol or key string to retrieve the value. See example.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.key(1)
  # @example Retrieve public key contents
  #   public_key = @client.key(1)
  #   public_key.key
  #   # => Error
  #
  #   public_key[:key]
  #   # => "ssh-rsa AAA..."
  #
  #   public_key['key']
  #   # => "ssh-rsa AAA..."
  # @param key_id [Integer] Key to retreive.
  # @return [Sawyer::Resource] Hash representing the key.
  # @see https://developer.github.com/v3/users/keys/#get-a-single-public-key
  def key(key_id, options = T.unsafe(nil)); end

  # Get list of public keys for user.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.keys
  # @return [Array<Sawyer::Resource>] Array of hashes representing public keys.
  # @see https://developer.github.com/v3/users/keys/#list-your-public-keys
  def keys(options = T.unsafe(nil)); end

  # Remove email from user.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_email('old_email@user.com')
  # @param email [String] Email address to remove.
  # @return [Array<String>] Array of all email addresses of the user.
  # @see https://developer.github.com/v3/users/emails/#delete-email-addresses
  def remove_email(email); end

  # Remove a public key from user account.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.remove_key(1)
  # @param id [String] Id of the public key to remove.
  # @return [Boolean] True if removal was successful, false otherwise.
  # @see https://developer.github.com/v3/users/keys/#delete-a-public-key
  def remove_key(id, options = T.unsafe(nil)); end

  # Get list of repos starred by a user.
  #
  # @example
  #   Octokit.starred('pengwynn')
  # @option options
  # @option options
  # @param user [Integer, String] GitHub user login of the user to get the
  #   list of their starred repositories.
  # @param options [Hash] Optional options
  # @return [Array<Sawyer::Resource>] Array of hashes representing repositories starred by user.
  # @see https://developer.github.com/v3/activity/starring/#list-repositories-being-starred
  def starred(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Check if you are starring a repo.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.starred?('pengwynn/octokit')
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Boolean] True if you are following the repo, false otherwise.
  # @see https://developer.github.com/v3/activity/starring/#check-if-you-are-starring-a-repository
  def starred?(repo, options = T.unsafe(nil)); end

  # Initiates the generation of a migration archive.
  #
  # Requires authenticated user.
  #
  # @example
  #   @client.start_migration(['octocat/hello-world'])
  # @option options
  # @option options
  # @param repositories [Array<String>] :repositories Repositories for the organization.
  # @param options [Hash] a customizable set of options
  # @return [Sawyer::Resource] Hash representing the new migration.
  # @see https://docs.github.com/en/rest/reference/migrations#start-a-user-migration
  def start_user_migration(repositories, options = T.unsafe(nil)); end

  # List repositories being watched by a user.
  #
  # @example
  #   @client.subscriptions("pengwynn")
  # @param user [Integer, String] GitHub user login or id.
  # @return [Array<Sawyer::Resource>] Array of repositories.
  # @see https://developer.github.com/v3/activity/watching/#list-repositories-being-watched
  def subscriptions(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Unfollow a user.
  #
  # Requires authenticated client.
  #
  # @example
  #   @client.unfollow('holman')
  # @param user [String] Username of the user to unfollow.
  # @return [Boolean] True if unfollow was successful, false otherwise.
  # @see https://developer.github.com/v3/users/followers/#unfollow-a-user
  def unfollow(user, options = T.unsafe(nil)); end

  # Unlock a user repository which has been locked by a migration.
  #
  # Requires authenticated user.
  #
  # @param id [Integer] ID number of the migration.
  # @param repo [String] Name of the repository.
  # @see https://docs.github.com/en/rest/reference/migrations#unlock-a-user-repository
  def unlock_user_repository(id, repo, options = T.unsafe(nil)); end

  # Update a public key
  #
  # Requires authenticated client
  #
  # @deprecated This method is no longer supported in the API
  # @example
  #   @client.update_key(1, :title => 'new title', :key => "ssh-rsa BBB")
  # @option options
  # @option options
  # @param key_id [Integer] Id of key to update.
  # @param options [Hash] Hash containing attributes to update.
  # @return [Sawyer::Resource] Hash representing the updated public key.
  # @see https://developer.github.com/v3/users/keys/#update-a-public-key
  # @see https://developer.github.com/changes/2014-02-24-finer-grained-scopes-for-ssh-keys/
  def update_key(key_id, options = T.unsafe(nil)); end

  # Update the authenticated user
  #
  # @example
  #   Octokit.update_user(:name => "Erik Michaels-Ober", :email => "sferik@gmail.com", :company => "Code for America", :location => "San Francisco", :hireable => false)
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @option options
  # @param options [Hash] A customizable set of options.
  # @return [Sawyer::Resource]
  # @see https://developer.github.com/v3/users/#update-the-authenticated-user
  def update_user(options); end

  # Get a single user
  #
  # @example
  #   Octokit.user("sferik")
  # @param user [Integer, String] GitHub user login or id.
  # @return [Sawyer::Resource]
  # @see https://developer.github.com/v3/users/#get-a-single-user
  # @see https://developer.github.com/v3/users/#get-the-authenticated-user
  def user(user = T.unsafe(nil), options = T.unsafe(nil)); end

  # Get list of public keys for user.
  #
  # @example
  #   @client.user_keys('pengwynn')
  # @param user [Integer, String] GitHub user login or id.
  # @return [Array<Sawyer::Resource>] Array of hashes representing public keys.
  # @see https://developer.github.com/v3/users/keys/#list-public-keys-for-a-user
  def user_keys(user, options = T.unsafe(nil)); end

  # Fetches the URL to a migration archive.
  #
  # Requires authenticated user.
  #
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#download-a-user-migration-archive
  def user_migration_archive_url(id, options = T.unsafe(nil)); end

  # List repositories for a user migration.
  #
  # Requires authenticated user.
  #
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#list-repositories-for-a-user-migration
  def user_migration_repositories(id, options = T.unsafe(nil)); end

  # Fetches the status of a migration.
  #
  # Requires authenticated user.
  #
  # @param id [Integer] ID number of the migration.
  # @see https://docs.github.com/en/rest/reference/migrations#get-a-user-migration-status
  def user_migration_status(id, options = T.unsafe(nil)); end

  # Lists the most recent migrations.
  #
  # Requires authenticated user.
  #
  # @return [Array<Sawyer::Resource>] Array of migration resources.
  # @see https://docs.github.com/en/rest/reference/migrations#list-user-migrations
  def user_migrations(options = T.unsafe(nil)); end

  # Validate user username and password
  #
  # @option options
  # @option options
  # @param options [Hash] User credentials
  # @return [Boolean] True if credentials are valid
  def validate_credentials(options = T.unsafe(nil)); end

  # List repositories being watched by a user.
  #
  # @example
  #   @client.subscriptions("pengwynn")
  # @param user [Integer, String] GitHub user login or id.
  # @return [Array<Sawyer::Resource>] Array of repositories.
  # @see https://developer.github.com/v3/activity/watching/#list-repositories-being-watched
  def watched(user = T.unsafe(nil), options = T.unsafe(nil)); end
end

# Raised on errors in the 400-499 range
class Octokit::ClientError < ::Octokit::Error; end

# Raised when GitHub returns a 422 HTTP status code
# and body matches 'PullRequestReviewComment' and 'commit_id (or end_commit_oid) is not part of the pull request'
class Octokit::CommitIsNotPartOfPullRequest < ::Octokit::UnprocessableEntity; end

# Configuration options for {Client}, defaulting to values
# in {Default}
module Octokit::Configurable
  # Returns the value of attribute access_token.
  def access_token; end

  # @return [String] OAuth2 access token for authentication
  # @see https://developer.github.com/v3/oauth/
  def access_token=(_arg0); end

  # @return [String] Base URL for API requests. default: https://api.github.com/
  def api_endpoint; end

  # @return [String] Base URL for API requests. default: https://api.github.com/
  def api_endpoint=(_arg0); end

  # @return [Boolean] Auto fetch next page of results until rate limit reached
  def auto_paginate; end

  # @return [Boolean] Auto fetch next page of results until rate limit reached
  def auto_paginate=(_arg0); end

  # Returns the value of attribute bearer_token.
  def bearer_token; end

  # @return [String] JWT bearer token for authentication
  # @see https://developer.github.com/early-access/integrations/authentication/#as-an-integration
  def bearer_token=(_arg0); end

  # @return [String] Configure OAuth app key
  # @see https://developer.github.com/v3/oauth/
  def client_id; end

  # @return [String] Configure OAuth app key
  # @see https://developer.github.com/v3/oauth/
  def client_id=(_arg0); end

  # Returns the value of attribute client_secret.
  def client_secret; end

  # @return [String] Configure OAuth app secret
  # @see https://developer.github.com/v3/oauth/
  def client_secret=(_arg0); end

  # Set configuration options using a block
  #
  # @yield [_self]
  # @yieldparam _self [Octokit::Configurable] the object that the method was called on
  def configure; end

  # @return [Hash] Configure connection options for Faraday
  # @see https://github.com/lostisland/faraday
  def connection_options; end

  # @return [Hash] Configure connection options for Faraday
  # @see https://github.com/lostisland/faraday
  def connection_options=(_arg0); end

  # @return [String] Configure preferred media type (for API versioning, for example)
  # @see https://developer.github.com/v3/media/
  def default_media_type; end

  # @return [String] Configure preferred media type (for API versioning, for example)
  # @see https://developer.github.com/v3/media/
  def default_media_type=(_arg0); end

  # @return [String] GitHub username for Basic Authentication
  def login; end

  # @return [String] GitHub username for Basic Authentication
  def login=(_arg0); end

  # @return [String] Base URL for API requests to the GitHub Enterprise management console
  def management_console_endpoint; end

  # @return [String] Base URL for API requests to the GitHub Enterprise management console
  def management_console_endpoint=(_arg0); end

  # @return [String] An admin password set up for your GitHub Enterprise management console
  def management_console_password=(_arg0); end

  # @return [Faraday::Builder or Faraday::RackBuilder] Configure middleware for Faraday
  # @see https://github.com/lostisland/faraday
  def middleware; end

  # @return [Faraday::Builder or Faraday::RackBuilder] Configure middleware for Faraday
  # @see https://github.com/lostisland/faraday
  def middleware=(_arg0); end

  # @return [Boolean] Instruct Octokit to get credentials from .netrc file
  def netrc; end

  # @return [Boolean] Instruct Octokit to get credentials from .netrc file
  def netrc=(_arg0); end

  # @return [Boolean]
  def netrc?; end

  # @return [String] Path to .netrc file. default: ~/.netrc
  def netrc_file; end

  # @return [String] Path to .netrc file. default: ~/.netrc
  def netrc_file=(_arg0); end

  # @return [String] GitHub password for Basic Authentication
  def password=(_arg0); end

  # @return [String] Configure page size for paginated results. API default: 30
  def per_page; end

  # @return [String] Configure page size for paginated results. API default: 30
  def per_page=(_arg0); end

  # @return [String] URI for proxy server
  # @see https://github.com/lostisland/faraday
  def proxy; end

  # @return [String] URI for proxy server
  # @see https://github.com/lostisland/faraday
  def proxy=(_arg0); end

  # Reset configuration options to default values
  def reset!; end

  # Compares client options to a Hash of requested options
  #
  # @param opts [Hash] Options to compare with current client options
  # @return [Boolean]
  def same_options?(opts); end

  # Reset configuration options to default values
  def setup; end

  # @return [String] SSL verify mode for ssl connections
  # @see https://github.com/lostisland/faraday
  def ssl_verify_mode; end

  # @return [String] SSL verify mode for ssl connections
  # @see https://github.com/lostisland/faraday
  def ssl_verify_mode=(_arg0); end

  # @return [String] Configure User-Agent header for requests.
  def user_agent; end

  # Sets the attribute user_agent
  #
  # @param value the value to set the attribute user_agent to.
  def user_agent=(_arg0); end

  # Base URL for generated web URLs
  #
  # @return [String] Default: https://github.com/
  def web_endpoint; end

  # @return [String] Base URL for web URLs. default: https://github.com/
  def web_endpoint=(_arg0); end

  private

  def fetch_client_id_and_secret(overrides = T.unsafe(nil)); end
  def options; end

  class << self
    # List of configurable keys for {Octokit::Client}
    #
    # @return [Array] of option keys
    def keys; end
  end
end

# Raised when GitHub returns a 409 HTTP status code
class Octokit::Conflict < ::Octokit::ClientError; end

# Network layer for API clients.
module Octokit::Connection
  include ::Octokit::Authentication

  # Hypermedia agent for the GitHub API
  #
  # @return [Sawyer::Agent]
  def agent; end

  # Make a HTTP DELETE request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Query and header params for request
  # @return [Sawyer::Resource]
  def delete(url, options = T.unsafe(nil)); end

  # Make a HTTP GET request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Query and header params for request
  # @return [Sawyer::Resource]
  def get(url, options = T.unsafe(nil)); end

  # Make a HTTP HEAD request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Query and header params for request
  # @return [Sawyer::Resource]
  def head(url, options = T.unsafe(nil)); end

  # Response for last HTTP request
  #
  # @return [Sawyer::Response]
  def last_response; end

  # Make one or more HTTP GET requests, optionally fetching
  # the next page of results from URL in Link response header based
  # on value in {#auto_paginate}.
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Query and header params for request
  # @param block [Block] Block to perform the data concatination of the
  #   multiple requests. The block is called with two parameters, the first
  #   contains the contents of the requests so far and the second parameter
  #   contains the latest response.
  # @return [Sawyer::Resource]
  def paginate(url, options = T.unsafe(nil)); end

  # Make a HTTP PATCH request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Body and header params for request
  # @return [Sawyer::Resource]
  def patch(url, options = T.unsafe(nil)); end

  # Make a HTTP POST request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Body and header params for request
  # @return [Sawyer::Resource]
  def post(url, options = T.unsafe(nil)); end

  # Make a HTTP PUT request
  #
  # @param url [String] The path, relative to {#api_endpoint}
  # @param options [Hash] Body and header params for request
  # @return [Sawyer::Resource]
  def put(url, options = T.unsafe(nil)); end

  # Fetch the root resource for the API
  #
  # @return [Sawyer::Resource]
  def root; end

  protected

  def endpoint; end

  private

  # Executes the request, checking if it was successful
  #
  # @return [Boolean] True on success, false otherwise
  def boolean_from_response(method, path, options = T.unsafe(nil)); end

  def parse_query_and_convenience_headers(options); end
  def request(method, path, data, options = T.unsafe(nil)); end
  def reset_agent; end
  def sawyer_options; end
end

# Header keys that can be passed in options hash to {#get},{#head}
Octokit::Connection::CONVENIENCE_HEADERS = T.let(T.unsafe(nil), Set)

# Default configuration options for {Client}
module Octokit::Default
  class << self
    # Default access token from ENV
    #
    # @return [String]
    def access_token; end

    # Default API endpoint from ENV or {API_ENDPOINT}
    #
    # @return [String]
    def api_endpoint; end

    # Default pagination preference from ENV
    #
    # @return [String]
    def auto_paginate; end

    # Default bearer token from ENV
    #
    # @return [String]
    def bearer_token; end

    # Default OAuth app key from ENV
    #
    # @return [String]
    def client_id; end

    # Default OAuth app secret from ENV
    #
    # @return [String]
    def client_secret; end

    # Default options for Faraday::Connection
    #
    # @return [Hash]
    def connection_options; end

    # Default media type from ENV or {MEDIA_TYPE}
    #
    # @return [String]
    def default_media_type; end

    # Default GitHub username for Basic Auth from ENV
    #
    # @return [String]
    def login; end

    # Default management console endpoint from ENV
    #
    # @return [String]
    def management_console_endpoint; end

    # Default management console password from ENV
    #
    # @return [String]
    def management_console_password; end

    # Default middleware stack for Faraday::Connection
    # from {MIDDLEWARE}
    #
    # @return [Faraday::RackBuilder or Faraday::Builder]
    def middleware; end

    # Default behavior for reading .netrc file
    #
    # @return [Boolean]
    def netrc; end

    # Default path for .netrc file
    #
    # @return [String]
    def netrc_file; end

    # Configuration options
    #
    # @return [Hash]
    def options; end

    # Default GitHub password for Basic Auth from ENV
    #
    # @return [String]
    def password; end

    # Default pagination page size from ENV
    #
    # @return [Integer] Page size
    def per_page; end

    # Default proxy server URI for Faraday connection from ENV
    #
    # @return [String]
    def proxy; end

    # Default SSL verify mode from ENV
    #
    # @return [Integer]
    def ssl_verify_mode; end

    # Default User-Agent header string from ENV or {USER_AGENT}
    #
    # @return [String]
    def user_agent; end

    # Default web endpoint from ENV or {WEB_ENDPOINT}
    #
    # @return [String]
    def web_endpoint; end
  end
end

# Default API endpoint
Octokit::Default::API_ENDPOINT = T.let(T.unsafe(nil), String)

# Default media type
Octokit::Default::MEDIA_TYPE = T.let(T.unsafe(nil), String)

# Default Faraday middleware stack
Octokit::Default::MIDDLEWARE = T.let(T.unsafe(nil), Faraday::RackBuilder)

# Default User Agent header string
Octokit::Default::USER_AGENT = T.let(T.unsafe(nil), String)

# Default WEB endpoint
Octokit::Default::WEB_ENDPOINT = T.let(T.unsafe(nil), String)

# EnterpriseAdminClient is only meant to be used by GitHub Enterprise Admins
# and provides access the Admin only API endpoints including Admin Stats,
# Management Console, and the Search Indexing API.
#
# @see Octokit::Client Use Octokit::Client for regular API use for GitHub
#   and GitHub Enterprise.
# @see https://developer.github.com/v3/enterprise/
class Octokit::EnterpriseAdminClient
  include ::Octokit::Configurable
  include ::Octokit::Authentication
  include ::Octokit::Connection
  include ::Octokit::Warnable
  include ::Octokit::EnterpriseAdminClient::AdminStats
  include ::Octokit::EnterpriseAdminClient::License
  include ::Octokit::EnterpriseAdminClient::Orgs
  include ::Octokit::EnterpriseAdminClient::SearchIndexing
  include ::Octokit::EnterpriseAdminClient::Users

  # @return [EnterpriseAdminClient] a new instance of EnterpriseAdminClient
  def initialize(options = T.unsafe(nil)); end
end

# Methods for the Enterprise Admin Stats API
#
# @see https://developer.github.com/v3/enterprise-admin/admin_stats/
module Octokit::EnterpriseAdminClient::AdminStats
  # Get only comment-related stats
  #
  # @example Get only comment-related stats
  #   @client.admin_comments_stats
  # @return [Sawyer::Resource] Only comment-related stats
  def admin_comments_stats; end

  # Get only gist-related stats
  #
  # @example Get only gist-related stats
  #   @client.admin_gits_stats
  # @return [Sawyer::Resource] Only only gist-related stats
  def admin_gists_stats; end

  # Get only hooks-related stats
  #
  # @example Get only hooks-related stats
  #   @client.admin_hooks_stats
  # @return [Sawyer::Resource] Only hooks-related stats
  def admin_hooks_stats; end

  # Get only issue-related stats
  #
  # @example Get only issue-related stats
  #   @client.admin_issues_stats
  # @return [Sawyer::Resource] Only issue-related stats
  def admin_issues_stats; end

  # Get only milestone-related stats
  #
  # @example Get only milestone-related stats
  #   @client.admin_milestones_stats
  # @return [Sawyer::Resource] Only milestone-related stats
  def admin_milestones_stats; end

  # Get only organization-related stats
  #
  # @example Get only organization-related stats
  #   @client.admin_organization_stats
  # @return [Sawyer::Resource] Only organization-related stats
  def admin_organization_stats; end

  # Get only pages-related stats
  #
  # @example Get only pages-related stats
  #   @client.admin_pages_stats
  # @return [Sawyer::Resource] Only pages-related stats
  def admin_pages_stats; end

  # Get only pull request-related stats
  #
  # @example Get only pull request-related stats
  #   @client.admin_pull_requests_stats
  # @return [Sawyer::Resource] Only pull request-related stats
  def admin_pull_requests_stats; end

  # Get only repository-related stats
  #
  # @example Get only repository-related stats
  #   @client.admin_repository_stats
  # @return [Sawyer::Resource] Only repository-related stats
  def admin_repository_stats; end

  # Get all available stats
  #
  # @example Get all available stats
  #   @client.admin_stats
  # @return [Sawyer::Resource] All available stats
  def admin_stats; end

  # Get only user-related stats
  #
  # @example Get only user-related stats
  #   @client.admin_users_stats
  # @return [Sawyer::Resource] Only user-related stats
  def admin_users_stats; end

  private

  # @param metric [String] The metrics you are looking for
  # @private Get enterprise stats
  # @return [Sawyer::Resource] Magical unicorn stats
  def get_admin_stats(metric); end
end

module Octokit::EnterpriseAdminClient::License
  def license_info; end
end

# Methods for the Enterprise Orgs API
#
# @see https://developer.github.com/v3/enterprise-admin/orgs/
module Octokit::EnterpriseAdminClient::Orgs
  # Create a new organization on the instance.
  #
  # @example
  #   @admin_client.create_organization('SuchAGreatOrg', 'gjtorikian')
  # @option options
  # @param login [String] The organization's username.
  # @param admin [String] The login of the user who will manage this organization.
  # @param options [Hash] A set of options.
  # @return [nil]
  # @see https://developer.github.com/v3/enterprise-admin/orgs/#create-an-organization
  def create_organization(login, admin, options = T.unsafe(nil)); end
end

# Methods for the Enterprise Search Indexing API
#
# @see https://developer.github.com/v3/enterprise-admin/search_indexing/
module Octokit::EnterpriseAdminClient::SearchIndexing
  # Queue a User or Organization to be indexed
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_organization(user); end

  # Queue a user's or organization's repositories to be indexed
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_organizations_repositories(user); end

  # Queue an index of all the code contained in all of a user's or
  # organization's repositories
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_organizations_repositories_code(user); end

  # Queue an index of all the issues across all of a user's or
  # organization's repositories
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_organizations_repositories_issues(user); end

  # Queue a Repository to be indexed
  #
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_repository(repo); end

  # Queue a repository's code to be indexed
  #
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_repository_code(repo); end

  # Queue a repository's Issues to be indexed
  #
  # @param repo [String, Hash, Repository] A GitHub repository
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_repository_issues(repo); end

  # Queue a User or Organization to be indexed
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_user(user); end

  # Queue a user's or organization's repositories to be indexed
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_users_repositories(user); end

  # Queue an index of all the code contained in all of a user's or
  # organization's repositories
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_users_repositories_code(user); end

  # Queue an index of all the issues across all of a user's or
  # organization's repositories
  #
  # @param user [String] A GitHub Enterprise user or organization
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def index_users_repositories_issues(user); end

  private

  # @param target [String] Target to index
  # @private Queue a target for indexing
  # @return [Sawyer:Resource] Result of the queuing containing `:message`
  def queue_index(target); end
end

# Methods for the Enterprise User Administration API
#
# @see https://developer.github.com/enterprise/v3/enterprise-admin/users/
module Octokit::EnterpriseAdminClient::Users
  # Creates an impersonation OAuth token.
  #
  # @example
  #   @admin_client.create_impersonation_token('foobar', {:scopes => ['repo:write']})
  # @param login [String] The user to create a token for.
  # @param options [Array<String>] :scopes The scopes to apply.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#create-an-impersonation-oauth-token
  def create_impersonation_token(login, options = T.unsafe(nil)); end

  # Create a new user.
  #
  # @example
  #   @admin_client.create_user('foobar', 'notreal@foo.bar')
  # @param login [String] The user's username.
  # @param email [String] The user's email address.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users#create-a-new-user
  def create_user(login, email, options = T.unsafe(nil)); end

  # Deletes an impersonation OAuth token.
  #
  # @example
  #   @admin_client.delete_impersonation_token('foobar')
  # @param login [String] The user whose token should be deleted.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#delete-an-impersonation-oauth-token
  def delete_impersonation_token(login, options = T.unsafe(nil)); end

  # Deletes a public SSH keys.
  #
  # @example
  #   @admin_client.delete_key(1)
  # @param id [Number] The ID of the key to delete.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#delete-a-public-key
  def delete_key(id, options = T.unsafe(nil)); end

  # Deletes a user.
  #
  # @example
  #   @admin_client.delete_key(1)
  # @param username [String] The username to delete.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#delete-a-user
  def delete_user(username, options = T.unsafe(nil)); end

  # Demote a site administrator to an ordinary user
  #
  # @example
  #   @admin_client.demote('holman')
  # @param user [String] Username of the user to demote.
  # @return [Boolean] True if demote was successful, false otherwise.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#demote-a-site-administrator-to-an-ordinary-user
  def demote(user, options = T.unsafe(nil)); end

  # Lists all the public SSH keys.
  #
  # @example
  #   @admin_client.list_all_keys
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#list-all-public-keys
  def list_all_keys(options = T.unsafe(nil)); end

  # Promote an ordinary user to a site administrator
  #
  # @example
  #   @admin_client.promote('holman')
  # @param user [String] Username of the user to promote.
  # @return [Boolean] True if promote was successful, false otherwise.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#promote-an-ordinary-user-to-a-site-administrator
  def promote(user, options = T.unsafe(nil)); end

  # Rename a user.
  #
  # @example
  #   @admin_client.rename_user('foobar', 'foofoobar')
  # @param old_login [String] The user's old username.
  # @param new_login [String] The user's new username.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#rename-an-existing-user
  def rename_user(old_login, new_login, options = T.unsafe(nil)); end

  # Suspend a user.
  #
  # @example
  #   @admin_client.suspend('holman')
  # @param user [String] Username of the user to suspend.
  # @return [Boolean] True if suspend was successful, false otherwise.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#suspend-a-user
  def suspend(user, options = T.unsafe(nil)); end

  # Unsuspend a user.
  #
  # @example
  #   @admin_client.unsuspend('holman')
  # @param user [String] Username of the user to unsuspend.
  # @return [Boolean] True if unsuspend was successful, false otherwise.
  # @see https://developer.github.com/enterprise/v3/enterprise-admin/users/#unsuspend-a-user
  def unsuspend(user, options = T.unsafe(nil)); end
end

# EnterpriseManagementConsoleClient is only meant to be used by GitHub Enterprise Admins
# and provides access to the management console API endpoints.
#
# @see Octokit::Client Use Octokit::Client for regular API use for GitHub
#   and GitHub Enterprise.
# @see https://developer.github.com/v3/enterprise-admin/management_console/
class Octokit::EnterpriseManagementConsoleClient
  include ::Octokit::Configurable
  include ::Octokit::Authentication
  include ::Octokit::Connection
  include ::Octokit::Warnable
  include ::Octokit::EnterpriseManagementConsoleClient::ManagementConsole

  # @return [EnterpriseManagementConsoleClient] a new instance of EnterpriseManagementConsoleClient
  def initialize(options = T.unsafe(nil)); end

  protected

  def endpoint; end

  # Set Enterprise Management Console endpoint
  #
  # @param value [String] Management console endpoint
  def management_console_endpoint=(value); end

  # Set Enterprise Management Console password
  #
  # @param value [String] Management console admin password
  def management_console_password=(value); end

  private

  def faraday_configuration; end
  def password_hash; end
end

# Methods for the Enterprise Management Console API
#
# @see https://developer.github.com/v3/enterprise-admin/management_console/
module Octokit::EnterpriseManagementConsoleClient::ManagementConsole
  # Add an authorized SSH keys on the Enterprise install
  #
  # @param key Either the file path to a key, a File handler to the key, or the contents of the key itself
  # @return [Sawyer::Resource] An array of authorized SSH keys
  def add_authorized_key(key); end

  # Fetch the authorized SSH keys on the Enterprise install
  #
  # @return [Sawyer::Resource] An array of authorized SSH keys
  def authorized_keys; end

  # Get information about the Enterprise installation
  #
  # @return [Sawyer::Resource] The installation information
  def config_check; end

  # Get information about the Enterprise installation
  #
  # @return [Sawyer::Resource] The installation information
  def config_status; end

  # Removes an authorized SSH keys from the Enterprise install
  #
  # @param key Either the file path to a key, a File handler to the key, or the contents of the key itself
  # @return [Sawyer::Resource] An array of authorized SSH keys
  def delete_authorized_key(key); end

  # Start (or turn off) the Enterprise maintenance mode
  #
  # @param maintenance [Hash] A hash configuration of the maintenance settings
  # @return [nil]
  def edit_maintenance_status(maintenance); end

  # Modify the Enterprise settings
  #
  # @param settings [Hash] A hash configuration of the new settings
  # @return [nil]
  def edit_settings(settings); end

  # Fetch the authorized SSH keys on the Enterprise install
  #
  # @return [Sawyer::Resource] An array of authorized SSH keys
  def get_authorized_keys; end

  # Get information about the Enterprise maintenance status
  #
  # @return [Sawyer::Resource] The maintenance status
  def get_maintenance_status; end

  # Get information about the Enterprise installation
  #
  # @return [Sawyer::Resource] The settings
  def get_settings; end

  # Get information about the Enterprise maintenance status
  #
  # @return [Sawyer::Resource] The maintenance status
  def maintenance_status; end

  # Removes an authorized SSH keys from the Enterprise install
  #
  # @param key Either the file path to a key, a File handler to the key, or the contents of the key itself
  # @return [Sawyer::Resource] An array of authorized SSH keys
  def remove_authorized_key(key); end

  # Start (or turn off) the Enterprise maintenance mode
  #
  # @param maintenance [Hash] A hash configuration of the maintenance settings
  # @return [nil]
  def set_maintenance_status(maintenance); end

  # Get information about the Enterprise installation
  #
  # @return [Sawyer::Resource] The settings
  def settings; end

  # Start a configuration process.
  #
  # @return nil
  def start_configuration; end

  # Upgrade an Enterprise installation
  #
  # @param license [String] The path to your .ghl license file.
  # @return nil
  def upgrade(license); end

  def upload_license(license, settings = T.unsafe(nil)); end
end

# Custom error class for rescuing from all GitHub errors
class Octokit::Error < ::StandardError
  # @return [Error] a new instance of Error
  def initialize(response = T.unsafe(nil)); end

  def build_error_context; end

  # Returns the value of attribute context.
  def context; end

  # Documentation URL returned by the API for some errors
  #
  # @return [String]
  def documentation_url; end

  # Array of validation errors
  #
  # @return [Array<Hash>] Error info
  def errors; end

  # Body returned by the GitHub server.
  #
  # @return [String]
  def response_body; end

  # Headers returned by the GitHub server.
  #
  # @return [Hash]
  def response_headers; end

  # Status code returned by the GitHub server.
  #
  # @return [Integer]
  def response_status; end

  private

  def build_error_message; end
  def data; end
  def redact_url(url_string); end
  def response_error; end
  def response_error_summary; end
  def response_message; end

  class << self
    # Returns most appropriate error for 401 HTTP status code
    #
    # @private
    def error_for_401(headers); end

    # Returns most appropriate error for 403 HTTP status code
    #
    # @private
    def error_for_403(body); end

    # Return most appropriate error for 404 HTTP status code
    #
    # @private
    def error_for_404(body); end

    # Return most appropriate error for 422 HTTP status code
    #
    # @private
    def error_for_422(body); end

    # Returns the appropriate Octokit::Error subclass based
    # on status and response message
    #
    # @param response [Hash] HTTP response
    # @return [Octokit::Error]
    def from_response(response); end
  end
end

# Raised when GitHub returns a 403 HTTP status code
class Octokit::Forbidden < ::Octokit::ClientError; end

# Class to parse and create Gist URLs
class Octokit::Gist
  # @return [Gist] a new instance of Gist
  def initialize(gist); end

  # !@attribute id
  #   @return [String] Gist ID
  def id; end

  # !@attribute id
  #   @return [String] Gist ID
  def id=(_arg0); end

  # Gist ID
  #
  # @return [String]
  def to_s; end

  # Gist URL
  #
  # @return [String]
  def url; end

  class << self
    # Instantiate {Gist} object from Gist URL
    # @ return [Gist]
    def from_url(url); end
  end
end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'suspended your access'
class Octokit::InstallationSuspended < ::Octokit::Forbidden; end

# Raised when GitHub returns a 500 HTTP status code
class Octokit::InternalServerError < ::Octokit::ServerError; end

# Raised when a repository is created with an invalid format
class Octokit::InvalidRepository < ::ArgumentError; end

# Current major release.
#
# @return [Integer]
Octokit::MAJOR = T.let(T.unsafe(nil), Integer)

# Current minor release.
#
# @return [Integer]
Octokit::MINOR = T.let(T.unsafe(nil), Integer)

# Raised when GitHub returns a 405 HTTP status code
class Octokit::MethodNotAllowed < ::Octokit::ClientError; end

module Octokit::Middleware; end

# Public: Follow HTTP 301, 302, 303, and 307 redirects.
#
# For HTTP 303, the original GET, POST, PUT, DELETE, or PATCH request gets
# converted into a GET. For HTTP 301, 302, and 307, the HTTP method remains
# unchanged.
#
# This middleware currently only works with synchronous requests; i.e. it
# doesn't support parallelism.
class Octokit::Middleware::FollowRedirects < ::Faraday::Middleware
  # Public: Initialize the middleware.
  #
  # options - An options Hash (default: {}):
  #           :limit               - A Integer redirect limit (default: 3).
  #
  # @return [FollowRedirects] a new instance of FollowRedirects
  def initialize(app, options = T.unsafe(nil)); end

  def call(env); end

  private

  # @return [Boolean]
  def convert_to_get?(response); end

  def follow_limit; end

  # @return [Boolean]
  def follow_redirect?(env, response); end

  def perform_with_redirection(env, follows); end

  # Internal: Escapes unsafe characters from a URL which might be a path
  # component only or a fully-qualified URI so that it can be joined onto a
  # URI:HTTP using the `+` operator. Doesn't escape "%" characters so to not
  # risk double-escaping.
  def safe_escape(uri); end

  # @return [Boolean]
  def same_host?(original_url, redirect_url); end

  def update_env(env, request_body, response); end
end

# HTTP methods for which 30x redirects can be followed
Octokit::Middleware::FollowRedirects::ALLOWED_METHODS = T.let(T.unsafe(nil), Set)

# Keys in env hash which will get cleared between requests
Octokit::Middleware::FollowRedirects::ENV_TO_CLEAR = T.let(T.unsafe(nil), Set)

# Default value for max redirects followed
Octokit::Middleware::FollowRedirects::FOLLOW_LIMIT = T.let(T.unsafe(nil), Integer)

# HTTP redirect status codes that this middleware implements
Octokit::Middleware::FollowRedirects::REDIRECT_CODES = T.let(T.unsafe(nil), Set)

# Regex that matches characters that need to be escaped in URLs, sans
# the "%" character which we assume already represents an escaped
# sequence.
Octokit::Middleware::FollowRedirects::URI_UNSAFE = T.let(T.unsafe(nil), Regexp)

# Public: Exception thrown when the maximum amount of requests is exceeded.
class Octokit::Middleware::RedirectLimitReached < ::Faraday::ClientError
  # @return [RedirectLimitReached] a new instance of RedirectLimitReached
  def initialize(response); end

  # Returns the value of attribute response.
  def response; end
end

# Raised when client fails to provide valid Content-Type
class Octokit::MissingContentType < ::ArgumentError; end

# Raised when GitHub returns a 406 HTTP status code
class Octokit::NotAcceptable < ::Octokit::ClientError; end

# Raised when GitHub returns a 404 HTTP status code
class Octokit::NotFound < ::Octokit::ClientError; end

# Raised when GitHub returns a 501 HTTP status code
class Octokit::NotImplemented < ::Octokit::ServerError; end

# Raised when GitHub returns a 401 HTTP status code
# and headers include "X-GitHub-OTP"
class Octokit::OneTimePasswordRequired < ::Octokit::ClientError
  # Delivery method for the user's OTP
  #
  # @return [String]
  def password_delivery; end

  private

  def delivery_method_from_header; end

  class << self
    # @private
    def required_header(headers); end
  end
end

# @private
Octokit::OneTimePasswordRequired::OTP_DELIVERY_PATTERN = T.let(T.unsafe(nil), Regexp)

# GitHub organization class to generate API path urls
class Octokit::Organization
  class << self
    # Get the api path for an organization
    #
    # @param org [String, Integer] GitHub organization login or id
    # @return [String] Organization Api path
    def path(org); end
  end
end

# Current patch level.
#
# @return [Integer]
Octokit::PATCH = T.let(T.unsafe(nil), Integer)

# Raised when GitHub returns a 422 HTTP status code and body matches 'Path diff too large'.
# It could occur when attempting to post review comments on a "too large" file.
class Octokit::PathDiffTooLarge < ::Octokit::UnprocessableEntity; end

# Default setup options for preview features
module Octokit::Preview
  def ensure_api_media_type(type, options); end
  def warn_preview(type); end
end

Octokit::Preview::PREVIEW_TYPES = T.let(T.unsafe(nil), Hash)
Octokit::RATE_LIMITED_ERRORS = T.let(T.unsafe(nil), Array)

# Class for API Rate Limit info
#
# @see https://developer.github.com/v3/#rate-limiting
class Octokit::RateLimit < ::Struct
  class << self
    # Get rate limit info from HTTP response
    #
    # @param response [#headers] HTTP response
    # @return [RateLimit]
    def from_response(response); end
  end
end

# Class to extract options from Ruby arguments for
# Repository-related methods
class Octokit::RepoArguments < ::Octokit::Arguments
  # @return [RepoArguments] a new instance of RepoArguments
  def initialize(args); end

  # !@attribute [r] repo
  #   @return [Repository]
  def repo; end
end

# Class to parse GitHub repository owner and name from
# URLs and to generate URLs
class Octokit::Repository
  # @raise [Octokit::InvalidRepository] if the repository
  #   has an invalid format
  # @return [Repository] a new instance of Repository
  def initialize(repo); end

  # Returns the value of attribute id.
  def id; end

  # Sets the attribute id
  #
  # @param value the value to set the attribute id to.
  def id=(_arg0); end

  # @return [String] Api path for id identified repos
  def id_api_path; end

  # Returns the value of attribute name.
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  def name=(_arg0); end

  # @return [String] Api path for owner/name identified repos
  def named_api_path; end

  # Returns the value of attribute owner.
  def owner; end

  # Sets the attribute owner
  #
  # @param value the value to set the attribute owner to.
  def owner=(_arg0); end

  # @return [String] Repository API path
  def path; end

  # Returns the value of attribute name.
  def repo; end

  # Repository owner/name
  #
  # @return [String]
  def slug; end

  # Repository owner/name
  #
  # @return [String]
  def to_s; end

  # Repository URL based on {Octokit::Client#web_endpoint}
  #
  # @return [String]
  def url; end

  # Returns the value of attribute owner.
  def user; end

  # Returns the value of attribute owner.
  def username; end

  private

  # @raise [Octokit::InvalidRepository]
  def raise_invalid_repository!(repo); end

  def validate_owner_and_name!(repo); end

  class << self
    # Instantiate from a GitHub repository URL
    #
    # @return [Repository]
    def from_url(url); end

    # Get the api path for a repo
    #
    # @param repo [Integer, String, Hash, Repository] A GitHub repository.
    # @return [String] Api path.
    def path(repo); end
  end
end

Octokit::Repository::NAME_WITH_OWNER_PATTERN = T.let(T.unsafe(nil), Regexp)

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'repository access blocked'
class Octokit::RepositoryUnavailable < ::Octokit::Forbidden; end

# Faraday response middleware
module Octokit::Response; end

# In Faraday 2.x, Faraday::Response::Middleware was removed
Octokit::Response::BaseMiddleware = Faraday::Middleware

# Parses RSS and Atom feed responses.
class Octokit::Response::FeedParser < ::Faraday::Middleware
  def on_complete(env); end
end

# This class raises an Octokit-flavored exception based
# HTTP status codes returned by the API
class Octokit::Response::RaiseError < ::Faraday::Middleware
  def on_complete(response); end
end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'Resource protected by organization SAML enforcement'
class Octokit::SAMLProtected < ::Octokit::Forbidden; end

# Raised on errors in the 500-599 range
class Octokit::ServerError < ::Octokit::Error; end

# Raised when GitHub returns a 503 HTTP status code
class Octokit::ServiceUnavailable < ::Octokit::ServerError; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'returns blobs up to [0-9]+ MB'
class Octokit::TooLargeContent < ::Octokit::Forbidden; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'login attempts exceeded'
class Octokit::TooManyLoginAttempts < ::Octokit::Forbidden; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'rate limit exceeded'
class Octokit::TooManyRequests < ::Octokit::Forbidden; end

# Raised when GitHub returns a 401 HTTP status code
class Octokit::Unauthorized < ::Octokit::ClientError; end

# Raised when GitHub returns a 451 HTTP status code
class Octokit::UnavailableForLegalReasons < ::Octokit::ClientError; end

# Raised when GitHub returns a 422 HTTP status code
class Octokit::UnprocessableEntity < ::Octokit::ClientError; end

# Raised when GitHub returns a 414 HTTP status code
class Octokit::UnsupportedMediaType < ::Octokit::ClientError; end

# Raised when GitHub returns a 403 HTTP status code
# and body matches 'email address must be verified'
class Octokit::UnverifiedEmail < ::Octokit::Forbidden; end

# GitHub user class to generate API path urls
class Octokit::User
  class << self
    # Get the api path for a user
    #
    # @param user [String, Integer] GitHub user login or id
    # @return [String] User Api path
    def path(user); end
  end
end

# Full release version.
#
# @return [String]
Octokit::VERSION = T.let(T.unsafe(nil), String)

# Allows warnings to be suppressed via environment variable.
module Octokit::Warnable
  private

  # Wrapper around Kernel#warn to print warnings unless
  # OCTOKIT_SILENT is set to true.
  #
  # @return [nil]
  def octokit_warn(*message); end

  class << self
    # Wrapper around Kernel#warn to print warnings unless
    # OCTOKIT_SILENT is set to true.
    #
    # @return [nil]
    def octokit_warn(*message); end
  end
end
