# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `mediawiki_api` gem.
# Please instead update this file by running `bin/tapioca gem mediawiki_api`.

# MediaWiki Ruby API
module MediawikiApi; end

# generic MediaWiki api errors
class MediawikiApi::ApiError < ::StandardError
  # @return [ApiError] a new instance of ApiError
  def initialize(response = T.unsafe(nil)); end

  def code; end
  def info; end

  # Returns the value of attribute response.
  def response; end

  def to_s; end

  private

  def response_data; end
end

# high level client for MediaWiki
class MediawikiApi::Client
  # @return [Client] a new instance of Client
  def initialize(url, log = T.unsafe(nil)); end

  def action(name, params = T.unsafe(nil)); end

  # Returns the value of attribute cookies.
  def cookies; end

  def create_account(username, password); end
  def create_account_new(username, password); end
  def create_account_old(username, password, token = T.unsafe(nil)); end
  def create_page(title, content); end
  def delete_page(title, reason); end

  # @raise [EditError]
  def edit(params = T.unsafe(nil)); end

  def get_wikitext(title); end
  def list(type, params = T.unsafe(nil)); end
  def log_in(username, password, token = T.unsafe(nil)); end

  # Returns the value of attribute logged_in.
  def logged_in; end

  # Sets the attribute logged_in
  #
  # @param value the value to set the attribute logged_in to.
  def logged_in=(_arg0); end

  # Returns the value of attribute logged_in.
  def logged_in?; end

  def meta(type, params = T.unsafe(nil)); end
  def prop(type, params = T.unsafe(nil)); end
  def protect_page(title, reason, protections = T.unsafe(nil)); end
  def query(params = T.unsafe(nil)); end
  def unwatch_page(title); end
  def upload_image(filename, path, comment, ignorewarnings, text = T.unsafe(nil)); end
  def watch_page(title); end

  protected

  def compile_parameters(parameters); end
  def get_token(type); end
  def raw_action(name, params = T.unsafe(nil)); end

  # @raise [HttpError]
  def send_request(method, params, envelope); end

  def subquery(type, subtype, params = T.unsafe(nil)); end
end

MediawikiApi::Client::FORMAT = T.let(T.unsafe(nil), String)
class MediawikiApi::CreateAccountError < ::StandardError; end

# for edit failures
class MediawikiApi::EditError < ::MediawikiApi::ApiError
  def to_s; end
end

# for errors from HTTP requests
class MediawikiApi::HttpError < ::StandardError
  # @return [HttpError] a new instance of HttpError
  def initialize(status); end

  # Returns the value of attribute status.
  def status; end

  def to_s; end
end

class MediawikiApi::LoginError < ::StandardError; end

# Provides access to a parsed MediaWiki API responses.
#
# Some types of responses, depending on the action, contain a level or two
# of addition structure (an envelope) above the actual payload. The {#data}
# method provides a way of easily getting at it.
#
# @example
#   # http.body => '{"query": {"userinfo": {"some": "data"}}}'
#   response = Response.new(http, ["query", "userinfo"])
#   response.data # => { "some" => "data" }
class MediawikiApi::Response
  extend ::Forwardable

  # Constructs a new response.
  #
  # @param response [Faraday::Response]
  # @param envelope [Array] Property names for expected payload nesting.
  # @return [Response] a new instance of Response
  def initialize(response, envelope = T.unsafe(nil)); end

  # Accessor for root response object values.
  #
  # @param key [String]
  # @return [Object]
  def [](key); end

  # The main payload from the parsed response, removed from its envelope.
  #
  # @return [Object]
  def data; end

  # Set of error messages from the response.
  #
  # @return [Array]
  def errors; end

  def status(*args, **_arg1, &block); end
  def success?(*args, **_arg1, &block); end

  # Set of warning messages from the response.
  #
  # @return [Array]
  def warnings; end

  # Whether the response contains warnings.
  #
  # @return [true, false]
  def warnings?; end

  private

  def flatten_resp(str); end
  def open_envelope(obj, env = T.unsafe(nil)); end
  def response_object; end
end

class MediawikiApi::TokenError < ::StandardError; end
